/* Cmap.c generated by valac 0.56.17, the Vala compiler
 * generated from Cmap.vala, do not modify */

/*
Copyright (C) 2012, 2013, 2014 Johan Mattsson

This library is free software; you can redistribute it and/or modify 
it under the terms of the GNU Lesser General Public License as 
published by the Free Software Foundation; either version 3 of the 
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
Lesser General Public License for more details.
*/

#include "birdfont.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <stdio.h>
#include <gee.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	BIRD_FONT_CMAP_TABLE_0_PROPERTY,
	BIRD_FONT_CMAP_TABLE_NUM_PROPERTIES
};
static GParamSpec* bird_font_cmap_table_properties[BIRD_FONT_CMAP_TABLE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _BirdFontCmapTablePrivate {
	BirdFontGlyfTable* glyf_table;
	BirdFontCmapSubtableFormat4* cmap_format4;
};

static gint BirdFontCmapTable_private_offset;
static gpointer bird_font_cmap_table_parent_class = NULL;

static BirdFontCmapSubtableFormat4* bird_font_cmap_table_get_prefered_table (BirdFontCmapTable* self);
static gchar* bird_font_cmap_table_real_get_id (BirdFontOtfTable* base);
static void bird_font_cmap_table_real_parse (BirdFontOtfTable* base,
                                      BirdFontFontData* dis,
                                      GError** error);
static void bird_font_cmap_table_finalize (GObject * obj);
static GType bird_font_cmap_table_get_type_once (void);
VALA_EXTERN guint16 bird_font_largest_pow2 (guint16 max);
VALA_EXTERN guint16 bird_font_largest_pow2_exponent (guint16 max);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
bird_font_cmap_table_get_instance_private (BirdFontCmapTable* self)
{
	return G_STRUCT_MEMBER_P (self, BirdFontCmapTable_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

BirdFontCmapTable*
bird_font_cmap_table_construct (GType object_type,
                                BirdFontGlyfTable* gt)
{
	BirdFontCmapTable * self = NULL;
	BirdFontGlyfTable* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (gt != NULL, NULL);
	self = (BirdFontCmapTable*) bird_font_otf_table_construct (object_type);
	_tmp0_ = _g_object_ref0 (gt);
	_g_object_unref0 (self->priv->glyf_table);
	self->priv->glyf_table = _tmp0_;
	_tmp1_ = g_strdup ("cmap");
	_g_free0 (((BirdFontOtfTable*) self)->id);
	((BirdFontOtfTable*) self)->id = _tmp1_;
	return self;
}

BirdFontCmapTable*
bird_font_cmap_table_new (BirdFontGlyfTable* gt)
{
	return bird_font_cmap_table_construct (BIRD_FONT_TYPE_CMAP_TABLE, gt);
}

gunichar
bird_font_cmap_table_get_char (BirdFontCmapTable* self,
                               guint32 i)
{
	BirdFontCmapSubtableFormat4* _tmp0_;
	BirdFontCmapSubtableFormat4* _tmp1_;
	gunichar _tmp2_;
	gunichar result;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = bird_font_cmap_table_get_prefered_table (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = bird_font_cmap_subtable_format4_get_char (_tmp1_, i);
	_g_object_unref0 (_tmp1_);
	result = _tmp2_;
	return result;
}

static BirdFontCmapSubtableFormat4*
bird_font_cmap_table_get_prefered_table (BirdFontCmapTable* self)
{
	BirdFontCmapSubtableFormat4* _tmp0_;
	BirdFontCmapSubtableFormat4* _tmp1_;
	BirdFontCmapSubtableFormat4* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->cmap_format4;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static gchar*
bird_font_cmap_table_real_get_id (BirdFontOtfTable* base)
{
	BirdFontCmapTable * self;
	gchar* _tmp0_;
	gchar* result;
	self = (BirdFontCmapTable*) base;
	_tmp0_ = g_strdup ("cmap");
	result = _tmp0_;
	return result;
}

static void
bird_font_cmap_table_real_parse (BirdFontOtfTable* base,
                                 BirdFontFontData* dis,
                                 GError** error)
{
	BirdFontCmapTable * self;
	guint16 version = 0U;
	guint16 nsubtables = 0U;
	guint16 platform = 0U;
	guint16 encoding = 0U;
	guint32 sub_offset = 0U;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	BirdFontCmapSubtableFormat4* _tmp33_;
	GError* _inner_error0_ = NULL;
	self = (BirdFontCmapTable*) base;
	g_return_if_fail (dis != NULL);
	if (((BirdFontOtfTable*) self)->offset > ((guint32) 0)) {
		_tmp0_ = ((BirdFontOtfTable*) self)->length > ((guint32) 0);
	} else {
		_tmp0_ = FALSE;
	}
	g_return_if_fail (_tmp0_);
	bird_font_font_data_seek (dis, (guint) ((BirdFontOtfTable*) self)->offset);
	version = bird_font_font_data_read_ushort (dis);
	nsubtables = bird_font_font_data_read_ushort (dis);
	_tmp1_ = g_strdup_printf ("%hu", version);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat ("cmap version: ", _tmp2_, "\n", NULL);
	_tmp4_ = _tmp3_;
	bird_font_printd (_tmp4_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	_tmp5_ = g_strdup_printf ("%hu", nsubtables);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_strconcat ("cmap subtables: ", _tmp6_, "\n", NULL);
	_tmp8_ = _tmp7_;
	bird_font_printd (_tmp8_);
	_g_free0 (_tmp8_);
	_g_free0 (_tmp6_);
	if (((gint) version) != 0) {
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		_tmp9_ = g_strdup_printf ("%hu", version);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_strdup_printf ("%hu", nsubtables);
		_tmp12_ = _tmp11_;
		_tmp13_ = g_strconcat ("Bad version for cmap table: ", _tmp10_, " expecting 0. Number of subtables: ", _tmp12_, NULL);
		_tmp14_ = _tmp13_;
		g_warning ("Cmap.vala:59: %s", _tmp14_);
		_g_free0 (_tmp14_);
		_g_free0 (_tmp12_);
		_g_free0 (_tmp10_);
		return;
	}
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp15_ = FALSE;
			_tmp15_ = TRUE;
			while (TRUE) {
				gboolean _tmp17_ = FALSE;
				if (!_tmp15_) {
					guint _tmp16_;
					_tmp16_ = i;
					i = _tmp16_ + 1;
				}
				_tmp15_ = FALSE;
				if (!(i < ((guint) nsubtables))) {
					break;
				}
				platform = bird_font_font_data_read_ushort (dis);
				encoding = bird_font_font_data_read_ushort (dis);
				sub_offset = bird_font_font_data_read_ulong (dis);
				if (((gint) platform) == 3) {
					_tmp17_ = ((gint) encoding) == 1;
				} else {
					_tmp17_ = FALSE;
				}
				if (_tmp17_) {
					gchar* _tmp18_;
					gchar* _tmp19_;
					gchar* _tmp20_;
					gchar* _tmp21_;
					gchar* _tmp22_;
					gchar* _tmp23_;
					BirdFontCmapSubtableFormat4* _tmp24_;
					_tmp18_ = g_strdup_printf ("%hu", platform);
					_tmp19_ = _tmp18_;
					_tmp20_ = g_strdup_printf ("%hu", encoding);
					_tmp21_ = _tmp20_;
					_tmp22_ = g_strconcat ("Parsing Unicode BMP (UCS-2) Platform: ", _tmp19_, " Encoding: ", _tmp21_, "\n", NULL);
					_tmp23_ = _tmp22_;
					bird_font_printd (_tmp23_);
					_g_free0 (_tmp23_);
					_g_free0 (_tmp21_);
					_g_free0 (_tmp19_);
					_tmp24_ = self->priv->cmap_format4;
					_tmp24_->offset = ((BirdFontOtfTable*) self)->offset + sub_offset;
				} else {
					FILE* _tmp25_;
					gchar* _tmp26_;
					gchar* _tmp27_;
					gchar* _tmp28_;
					gchar* _tmp29_;
					gchar* _tmp30_;
					gchar* _tmp31_;
					_tmp25_ = stderr;
					_tmp26_ = g_strdup_printf ("%hu", platform);
					_tmp27_ = _tmp26_;
					_tmp28_ = g_strdup_printf ("%hu", encoding);
					_tmp29_ = _tmp28_;
					_tmp30_ = g_strconcat ("Unknown cmap format. Platform: ", _tmp27_, " Encoding: ", _tmp29_, ".\n", NULL);
					_tmp31_ = _tmp30_;
					fprintf (_tmp25_, "%s", _tmp31_);
					_g_free0 (_tmp31_);
					_g_free0 (_tmp29_);
					_g_free0 (_tmp27_);
				}
				if (((gint) encoding) == 3) {
					FILE* _tmp32_;
					_tmp32_ = stderr;
					fprintf (_tmp32_, "Font contains a cmap table with the obsolete encoding 3.\n");
				}
			}
		}
	}
	_tmp33_ = self->priv->cmap_format4;
	if (_tmp33_->offset > ((guint32) 0)) {
		BirdFontCmapSubtableFormat4* _tmp34_;
		_tmp34_ = self->priv->cmap_format4;
		bird_font_cmap_subtable_format4_parse (_tmp34_, dis, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			return;
		}
	} else {
		g_warning ("Cmap.vala:83: No cmap subtable4 found.");
	}
}

/** Character to glyph mapping */
void
bird_font_cmap_table_process (BirdFontCmapTable* self,
                              BirdFontGlyfTable* glyf_table,
                              GError** error)
{
	BirdFontFontData* fd = NULL;
	BirdFontFontData* _tmp0_;
	BirdFontCmapSubtableFormat0* cmap0 = NULL;
	BirdFontCmapSubtableFormat0* _tmp1_;
	BirdFontCmapSubtableFormat4* cmap4 = NULL;
	BirdFontCmapSubtableFormat4* _tmp2_;
	BirdFontCmapSubtableFormat12* cmap12 = NULL;
	BirdFontCmapSubtableFormat12* _tmp3_;
	guint16 n_encoding_tables = 0U;
	GeeArrayList* cmap_tables = NULL;
	GeeArrayList* _tmp4_;
	BirdFontCmapSubtableFormat0* _tmp5_;
	BirdFontCmapSubtableFormat4* _tmp6_;
	BirdFontCmapSubtableFormat12* _tmp7_;
	GeeArrayList* _tmp8_;
	BirdFontCmapSubtableFormat0* _tmp9_;
	GeeArrayList* _tmp10_;
	BirdFontCmapSubtableFormat4* _tmp11_;
	GeeArrayList* _tmp12_;
	BirdFontCmapSubtableFormat12* _tmp13_;
	GeeArrayList* _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	BirdFontFontData* _tmp17_;
	BirdFontFontData* _tmp18_;
	guint subtable_offset = 0U;
	GeeArrayList* _tmp19_;
	gint _tmp20_;
	gint _tmp21_;
	BirdFontFontData* _tmp50_;
	BirdFontFontData* _tmp51_;
	BirdFontFontData* _tmp52_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (glyf_table != NULL);
	_tmp0_ = bird_font_font_data_new ((guint32) 1024);
	fd = _tmp0_;
	_tmp1_ = bird_font_cmap_subtable_format0_new ();
	cmap0 = _tmp1_;
	_tmp2_ = bird_font_cmap_subtable_format4_new ();
	cmap4 = _tmp2_;
	_tmp3_ = bird_font_cmap_subtable_format12_new ();
	cmap12 = _tmp3_;
	_tmp4_ = gee_array_list_new (BIRD_FONT_TYPE_CMAP_SUBTABLE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	cmap_tables = _tmp4_;
	_tmp5_ = cmap0;
	bird_font_cmap_subtable_generate_cmap_data ((BirdFontCmapSubtable*) _tmp5_, glyf_table, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (cmap_tables);
		_g_object_unref0 (cmap12);
		_g_object_unref0 (cmap4);
		_g_object_unref0 (cmap0);
		_g_object_unref0 (fd);
		return;
	}
	_tmp6_ = cmap4;
	bird_font_cmap_subtable_generate_cmap_data ((BirdFontCmapSubtable*) _tmp6_, glyf_table, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (cmap_tables);
		_g_object_unref0 (cmap12);
		_g_object_unref0 (cmap4);
		_g_object_unref0 (cmap0);
		_g_object_unref0 (fd);
		return;
	}
	_tmp7_ = cmap12;
	bird_font_cmap_subtable_generate_cmap_data ((BirdFontCmapSubtable*) _tmp7_, glyf_table, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (cmap_tables);
		_g_object_unref0 (cmap12);
		_g_object_unref0 (cmap4);
		_g_object_unref0 (cmap0);
		_g_object_unref0 (fd);
		return;
	}
	_tmp8_ = cmap_tables;
	_tmp9_ = cmap0;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp8_, (BirdFontCmapSubtable*) _tmp9_);
	_tmp10_ = cmap_tables;
	_tmp11_ = cmap4;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp10_, (BirdFontCmapSubtable*) _tmp11_);
	_tmp12_ = cmap_tables;
	_tmp13_ = cmap12;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp12_, (BirdFontCmapSubtable*) _tmp13_);
	_tmp14_ = cmap_tables;
	_tmp15_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp14_);
	_tmp16_ = _tmp15_;
	n_encoding_tables = (guint16) _tmp16_;
	_tmp17_ = fd;
	bird_font_font_data_add_u16 (_tmp17_, (guint16) 0);
	_tmp18_ = fd;
	bird_font_font_data_add_u16 (_tmp18_, n_encoding_tables);
	_tmp19_ = cmap_tables;
	_tmp20_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp19_);
	_tmp21_ = _tmp20_;
	subtable_offset = (guint) (4 + (8 * _tmp21_));
	{
		GeeArrayList* _subtable_list = NULL;
		GeeArrayList* _tmp22_;
		gint _subtable_size = 0;
		GeeArrayList* _tmp23_;
		gint _tmp24_;
		gint _tmp25_;
		gint _subtable_index = 0;
		_tmp22_ = cmap_tables;
		_subtable_list = _tmp22_;
		_tmp23_ = _subtable_list;
		_tmp24_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp23_);
		_tmp25_ = _tmp24_;
		_subtable_size = _tmp25_;
		_subtable_index = -1;
		while (TRUE) {
			gint _tmp26_;
			gint _tmp27_;
			BirdFontCmapSubtable* subtable = NULL;
			GeeArrayList* _tmp28_;
			gpointer _tmp29_;
			BirdFontFontData* _tmp30_;
			BirdFontCmapSubtable* _tmp31_;
			BirdFontFontData* _tmp32_;
			BirdFontCmapSubtable* _tmp33_;
			BirdFontFontData* _tmp34_;
			BirdFontCmapSubtable* _tmp35_;
			BirdFontFontData* _tmp36_;
			BirdFontFontData* _tmp37_;
			_subtable_index = _subtable_index + 1;
			_tmp26_ = _subtable_index;
			_tmp27_ = _subtable_size;
			if (!(_tmp26_ < _tmp27_)) {
				break;
			}
			_tmp28_ = _subtable_list;
			_tmp29_ = gee_abstract_list_get ((GeeAbstractList*) _tmp28_, _subtable_index);
			subtable = (BirdFontCmapSubtable*) _tmp29_;
			_tmp30_ = fd;
			_tmp31_ = subtable;
			bird_font_font_data_add_u16 (_tmp30_, (guint16) bird_font_cmap_subtable_get_platform (_tmp31_));
			_tmp32_ = fd;
			_tmp33_ = subtable;
			bird_font_font_data_add_u16 (_tmp32_, (guint16) bird_font_cmap_subtable_get_encoding (_tmp33_));
			_tmp34_ = fd;
			bird_font_font_data_add_ulong (_tmp34_, (guint32) subtable_offset, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (subtable);
				_g_object_unref0 (cmap_tables);
				_g_object_unref0 (cmap12);
				_g_object_unref0 (cmap4);
				_g_object_unref0 (cmap0);
				_g_object_unref0 (fd);
				return;
			}
			_tmp35_ = subtable;
			_tmp36_ = bird_font_cmap_subtable_get_cmap_data (_tmp35_);
			_tmp37_ = _tmp36_;
			subtable_offset += bird_font_font_data_length (_tmp37_);
			_g_object_unref0 (_tmp37_);
			_g_object_unref0 (subtable);
		}
	}
	{
		GeeArrayList* _subtable_list = NULL;
		GeeArrayList* _tmp38_;
		gint _subtable_size = 0;
		GeeArrayList* _tmp39_;
		gint _tmp40_;
		gint _tmp41_;
		gint _subtable_index = 0;
		_tmp38_ = cmap_tables;
		_subtable_list = _tmp38_;
		_tmp39_ = _subtable_list;
		_tmp40_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp39_);
		_tmp41_ = _tmp40_;
		_subtable_size = _tmp41_;
		_subtable_index = -1;
		while (TRUE) {
			gint _tmp42_;
			gint _tmp43_;
			BirdFontCmapSubtable* subtable = NULL;
			GeeArrayList* _tmp44_;
			gpointer _tmp45_;
			BirdFontFontData* _tmp46_;
			BirdFontCmapSubtable* _tmp47_;
			BirdFontFontData* _tmp48_;
			BirdFontFontData* _tmp49_;
			_subtable_index = _subtable_index + 1;
			_tmp42_ = _subtable_index;
			_tmp43_ = _subtable_size;
			if (!(_tmp42_ < _tmp43_)) {
				break;
			}
			_tmp44_ = _subtable_list;
			_tmp45_ = gee_abstract_list_get ((GeeAbstractList*) _tmp44_, _subtable_index);
			subtable = (BirdFontCmapSubtable*) _tmp45_;
			_tmp46_ = fd;
			_tmp47_ = subtable;
			_tmp48_ = bird_font_cmap_subtable_get_cmap_data (_tmp47_);
			_tmp49_ = _tmp48_;
			bird_font_font_data_append (_tmp46_, _tmp49_);
			_g_object_unref0 (_tmp49_);
			_g_object_unref0 (subtable);
		}
	}
	_tmp50_ = fd;
	bird_font_font_data_pad (_tmp50_);
	_tmp51_ = fd;
	_tmp52_ = _g_object_ref0 (_tmp51_);
	_g_object_unref0 (((BirdFontOtfTable*) self)->font_data);
	((BirdFontOtfTable*) self)->font_data = _tmp52_;
	_g_object_unref0 (cmap_tables);
	_g_object_unref0 (cmap12);
	_g_object_unref0 (cmap4);
	_g_object_unref0 (cmap0);
	_g_object_unref0 (fd);
}

static void
bird_font_cmap_table_class_init (BirdFontCmapTableClass * klass,
                                 gpointer klass_data)
{
	bird_font_cmap_table_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BirdFontCmapTable_private_offset);
	((BirdFontOtfTableClass *) klass)->get_id = (gchar* (*) (BirdFontOtfTable*)) bird_font_cmap_table_real_get_id;
	((BirdFontOtfTableClass *) klass)->parse = (void (*) (BirdFontOtfTable*, BirdFontFontData*, GError**)) bird_font_cmap_table_real_parse;
	G_OBJECT_CLASS (klass)->finalize = bird_font_cmap_table_finalize;
}

static void
bird_font_cmap_table_instance_init (BirdFontCmapTable * self,
                                    gpointer klass)
{
	BirdFontCmapSubtableFormat4* _tmp0_;
	self->priv = bird_font_cmap_table_get_instance_private (self);
	_tmp0_ = bird_font_cmap_subtable_format4_new ();
	self->priv->cmap_format4 = _tmp0_;
}

static void
bird_font_cmap_table_finalize (GObject * obj)
{
	BirdFontCmapTable * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BIRD_FONT_TYPE_CMAP_TABLE, BirdFontCmapTable);
	_g_object_unref0 (self->priv->glyf_table);
	_g_object_unref0 (self->priv->cmap_format4);
	G_OBJECT_CLASS (bird_font_cmap_table_parent_class)->finalize (obj);
}

static GType
bird_font_cmap_table_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BirdFontCmapTableClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bird_font_cmap_table_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BirdFontCmapTable), 0, (GInstanceInitFunc) bird_font_cmap_table_instance_init, NULL };
	GType bird_font_cmap_table_type_id;
	bird_font_cmap_table_type_id = g_type_register_static (BIRD_FONT_TYPE_OTF_TABLE, "BirdFontCmapTable", &g_define_type_info, 0);
	BirdFontCmapTable_private_offset = g_type_add_instance_private (bird_font_cmap_table_type_id, sizeof (BirdFontCmapTablePrivate));
	return bird_font_cmap_table_type_id;
}

GType
bird_font_cmap_table_get_type (void)
{
	static volatile gsize bird_font_cmap_table_type_id__once = 0;
	if (g_once_init_enter (&bird_font_cmap_table_type_id__once)) {
		GType bird_font_cmap_table_type_id;
		bird_font_cmap_table_type_id = bird_font_cmap_table_get_type_once ();
		g_once_init_leave (&bird_font_cmap_table_type_id__once, bird_font_cmap_table_type_id);
	}
	return bird_font_cmap_table_type_id__once;
}

/** Largest power of two less than max. */
guint16
bird_font_largest_pow2 (guint16 max)
{
	guint16 x = 0U;
	guint16 l = 0U;
	guint16 result;
	x = (guint16) 1;
	l = (guint16) 0;
	while (TRUE) {
		if (!(x <= max)) {
			break;
		}
		l = x;
		x = (guint16) (x << 1);
	}
	result = l;
	return result;
}

/** Largest exponent for a power of two less than max. */
guint16
bird_font_largest_pow2_exponent (guint16 max)
{
	guint16 exp = 0U;
	guint16 l = 0U;
	guint16 x = 0U;
	guint16 result;
	exp = (guint16) 0;
	l = (guint16) 0;
	x = (guint16) 0;
	while (TRUE) {
		guint16 _tmp0_;
		if (!(x <= max)) {
			break;
		}
		l = exp;
		_tmp0_ = exp;
		exp = _tmp0_ + 1;
		x = (guint16) (1 << exp);
	}
	result = l;
	return result;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

