/* CharDatabaseParser.c generated by valac 0.56.17, the Vala compiler
 * generated from CharDatabaseParser.vala, do not modify */

/*
Copyright (C) 2013 2015 2018 Johan Mattsson

This library is free software; you can redistribute it and/or modify 
it under the terms of the GNU Lesser General Public License as 
published by the Free Software Foundation; either version 3 of the 
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
Lesser General Public License for more details.
*/

#include "birdfont.h"
#include <sqlite3.h>
#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	BIRD_FONT_CHAR_DATABASE_PARSER_0_PROPERTY,
	BIRD_FONT_CHAR_DATABASE_PARSER_NUM_PROPERTIES
};
static GParamSpec* bird_font_char_database_parser_properties[BIRD_FONT_CHAR_DATABASE_PARSER_NUM_PROPERTIES];
#define _bird_font_glyph_range_unref0(var) ((var == NULL) ? NULL : (var = (bird_font_glyph_range_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _sqlite3_close0(var) ((var == NULL) ? NULL : (var = (sqlite3_close (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

struct _BirdFontCharDatabaseParserPrivate {
	BirdFontGlyphRange* utf8;
};

static gint BirdFontCharDatabaseParser_private_offset;
static gpointer bird_font_char_database_parser_parent_class = NULL;
static sqlite3* bird_font_char_database_parser_db;
static sqlite3* bird_font_char_database_parser_db = NULL;
static sqlite3* bird_font_char_database_parser_database;
static sqlite3* bird_font_char_database_parser_database = NULL;

VALA_EXTERN gchar* bird_font_bird_font_get_argument (const gchar* param);
static void bird_font_char_database_parser_parse_all_entries (BirdFontCharDatabaseParser* self);
static void bird_font_char_database_parser_add_entry (BirdFontCharDatabaseParser* self,
                                               const gchar* data);
static GFile* bird_font_char_database_parser_get_unicode_database (BirdFontCharDatabaseParser* self);
static void bird_font_char_database_parser_finalize (GObject * obj);
static GType bird_font_char_database_parser_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
bird_font_char_database_parser_get_instance_private (BirdFontCharDatabaseParser* self)
{
	return G_STRUCT_MEMBER_P (self, BirdFontCharDatabaseParser_private_offset);
}

BirdFontCharDatabaseParser*
bird_font_char_database_parser_construct (GType object_type)
{
	BirdFontCharDatabaseParser * self = NULL;
	self = (BirdFontCharDatabaseParser*) g_object_new (object_type, NULL);
	return self;
}

BirdFontCharDatabaseParser*
bird_font_char_database_parser_new (void)
{
	return bird_font_char_database_parser_construct (BIRD_FONT_TYPE_CHAR_DATABASE_PARSER);
}

GFile*
bird_font_char_database_parser_get_database_file (BirdFontCharDatabaseParser* self)
{
	gchar* fn = NULL;
	gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_;
	GFile* _tmp6_;
	GFile* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = bird_font_bird_font_get_argument ("--parse-ucd");
	fn = _tmp0_;
	_tmp2_ = fn;
	if (_tmp2_ != NULL) {
		const gchar* _tmp3_;
		_tmp3_ = fn;
		_tmp1_ = g_strcmp0 ((const gchar*) _tmp3_, "") != 0;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		const gchar* _tmp4_;
		GFile* _tmp5_;
		_tmp4_ = fn;
		_tmp5_ = g_file_new_for_path ((const gchar*) _tmp4_);
		result = _tmp5_;
		_g_free0 (fn);
		return result;
	}
	_tmp6_ = g_file_new_for_path ("ucd.sqlite");
	result = _tmp6_;
	_g_free0 (fn);
	return result;
}

void
bird_font_char_database_parser_regenerate_database (BirdFontCharDatabaseParser* self)
{
	GFile* f = NULL;
	GFile* _tmp0_;
	FILE* _tmp1_;
	FILE* _tmp2_;
	GFile* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = bird_font_char_database_parser_get_database_file (self);
	f = _tmp0_;
	_tmp1_ = stdout;
	fprintf (_tmp1_, "Please use the other script.\n");
	_tmp2_ = stdout;
	_tmp3_ = f;
	_tmp4_ = g_file_get_path (_tmp3_);
	_tmp5_ = (gchar*) _tmp4_;
	fprintf (_tmp2_, "Generating sqlite database in: %s\n", _tmp5_);
	_g_free0 (_tmp5_);
	{
		GFile* _tmp6_;
		gboolean open = FALSE;
		_tmp6_ = f;
		if (g_file_query_exists (_tmp6_, NULL)) {
			GFile* _tmp7_;
			_tmp7_ = f;
			g_file_delete (_tmp7_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		open = bird_font_char_database_parser_open_database (self, SQLITE_OPEN_READWRITE | SQLITE_OPEN_CREATE);
		if (open) {
			bird_font_char_database_parser_create_tables (self);
			bird_font_char_database_parser_parse_all_entries (self);
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp8_;
		const gchar* _tmp9_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp8_ = e;
		_tmp9_ = _tmp8_->message;
		g_warning ("CharDatabaseParser.vala:57: %s", _tmp9_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (f);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (f);
}

gboolean
bird_font_char_database_parser_open_database (BirdFontCharDatabaseParser* self,
                                              gint access_mode)
{
	GFile* f = NULL;
	GFile* _tmp0_;
	gint rc = 0;
	GFile* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	sqlite3* _tmp4_ = NULL;
	gint _tmp5_;
	gint _tmp6_;
	sqlite3* _tmp7_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = bird_font_char_database_parser_get_database_file (self);
	f = _tmp0_;
	_tmp1_ = f;
	_tmp2_ = g_file_get_path (_tmp1_);
	_tmp3_ = (gchar*) _tmp2_;
	_tmp5_ = sqlite3_open_v2 (_tmp3_, &_tmp4_, access_mode, NULL);
	_sqlite3_close0 (bird_font_char_database_parser_database);
	bird_font_char_database_parser_database = _tmp4_;
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp3_);
	rc = _tmp6_;
	_tmp7_ = bird_font_char_database_parser_database;
	bird_font_char_database_parser_db = (sqlite3*) _tmp7_;
	if (rc != SQLITE_OK) {
		FILE* _tmp8_;
		GFile* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		FILE* _tmp12_;
		sqlite3* _tmp13_;
		const gchar* _tmp14_;
		_tmp8_ = stderr;
		_tmp9_ = f;
		_tmp10_ = g_file_get_path (_tmp9_);
		_tmp11_ = (gchar*) _tmp10_;
		fprintf (_tmp8_, "File: %s\n", _tmp11_);
		_g_free0 (_tmp11_);
		_tmp12_ = stderr;
		_tmp13_ = bird_font_char_database_parser_db;
		_tmp14_ = sqlite3_errmsg (_tmp13_);
		fprintf (_tmp12_, "Can't open database: %d, %s\n", rc, _tmp14_);
		result = FALSE;
		_g_object_unref0 (f);
		return result;
	}
	result = TRUE;
	_g_object_unref0 (f);
	return result;
}

static gint
_sqlite3_exec (sqlite3* self,
               const gchar* sql,
               sqlite3_callback callback,
               gpointer callback_target,
               gchar** errmsg)
{
	gchar* _vala_errmsg = NULL;
	const gchar* sqlite_errmsg = NULL;
	gint ec = 0;
	const gchar* _tmp0_ = NULL;
	gint _tmp1_;
	const gchar* _tmp4_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (sql != NULL, 0);
	_tmp1_ = sqlite3_exec (self, sql, callback, callback_target, (char**) (&_tmp0_));
	sqlite_errmsg = _tmp0_;
	ec = _tmp1_;
	if ((&_vala_errmsg) != NULL) {
		const gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = sqlite_errmsg;
		_tmp3_ = g_strdup (_tmp2_);
		_g_free0 (_vala_errmsg);
		_vala_errmsg = _tmp3_;
	} else {
		_g_free0 (_vala_errmsg);
		_vala_errmsg = NULL;
	}
	_tmp4_ = sqlite_errmsg;
	sqlite3_free ((void*) _tmp4_);
	result = ec;
	if (errmsg) {
		*errmsg = _vala_errmsg;
	} else {
		_g_free0 (_vala_errmsg);
	}
	return result;
}

void
bird_font_char_database_parser_create_tables (BirdFontCharDatabaseParser* self)
{
	gint ec = 0;
	gchar* errmsg = NULL;
	gchar* description_table = NULL;
	gchar* _tmp0_;
	sqlite3* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	gint _tmp4_;
	gchar* index_table = NULL;
	gchar* _tmp6_;
	sqlite3* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_ = NULL;
	gint _tmp10_;
	gchar* create_index = NULL;
	gchar* _tmp12_;
	sqlite3* _tmp13_;
	const gchar* _tmp14_;
	gchar* _tmp15_ = NULL;
	gint _tmp16_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("\n" \
"\t\t\tCREATE TABLE Description (\n" \
"\t\t\t\tunicode         INTEGER     PRIMARY KEY    NOT NULL,\n" \
"\t\t\t\tdescription     TEXT                       NOT NULL\n" \
"\t\t\t);\n" \
"\t\t");
	description_table = _tmp0_;
	_tmp1_ = bird_font_char_database_parser_db;
	_tmp2_ = description_table;
	_tmp4_ = _sqlite3_exec (_tmp1_, _tmp2_, NULL, NULL, &_tmp3_);
	_g_free0 (errmsg);
	errmsg = _tmp3_;
	ec = _tmp4_;
	if (ec != SQLITE_OK) {
		const gchar* _tmp5_;
		_tmp5_ = errmsg;
		g_warning ("CharDatabaseParser.vala:88: Error: %s\n", (const gchar*) _tmp5_);
	}
	_tmp6_ = g_strdup ("\n" \
"\t\t\tCREATE TABLE Words (\n" \
"\t\t\t\tunicode        INTEGER     NOT NULL,\n" \
"\t\t\t\tword           TEXT        NOT NULL\n" \
"\t\t\t);\n" \
"\t\t");
	index_table = _tmp6_;
	_tmp7_ = bird_font_char_database_parser_db;
	_tmp8_ = index_table;
	_tmp10_ = _sqlite3_exec (_tmp7_, _tmp8_, NULL, NULL, &_tmp9_);
	_g_free0 (errmsg);
	errmsg = _tmp9_;
	ec = _tmp10_;
	if (ec != SQLITE_OK) {
		const gchar* _tmp11_;
		_tmp11_ = errmsg;
		g_warning ("CharDatabaseParser.vala:100: Error: %s\n", (const gchar*) _tmp11_);
	}
	_tmp12_ = g_strdup ("CREATE INDEX word_index ON Words (word);");
	create_index = _tmp12_;
	_tmp13_ = bird_font_char_database_parser_db;
	_tmp14_ = create_index;
	_tmp16_ = _sqlite3_exec (_tmp13_, _tmp14_, NULL, NULL, &_tmp15_);
	_g_free0 (errmsg);
	errmsg = _tmp15_;
	ec = _tmp16_;
	if (ec != SQLITE_OK) {
		const gchar* _tmp17_;
		_tmp17_ = errmsg;
		g_warning ("CharDatabaseParser.vala:107: Error: %s\n", (const gchar*) _tmp17_);
	}
	_g_free0 (create_index);
	_g_free0 (index_table);
	_g_free0 (description_table);
	_g_free0 (errmsg);
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

void
bird_font_char_database_parser_insert_lookup (BirdFontCharDatabaseParser* self,
                                              gint64 character,
                                              const gchar* word)
{
	gchar* errmsg = NULL;
	gchar* w = NULL;
	gchar* _tmp0_;
	gchar* query = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gint ec = 0;
	sqlite3* _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_ = NULL;
	gint _tmp17_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (word != NULL);
	_tmp0_ = g_utf8_strdown (word, (gssize) -1);
	w = _tmp0_;
	_tmp1_ = g_strdup_printf ("%" G_GINT64_FORMAT, (gint64) character);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat ("\n\t\t\tINSERT INTO Words (unicode, word)\n\t\t\tVALUES (", _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strconcat (_tmp4_, ", '", NULL);
	_tmp6_ = _tmp5_;
	_tmp7_ = w;
	_tmp8_ = string_replace (_tmp7_, "'", "''");
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strconcat (_tmp6_, _tmp9_, NULL);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_strconcat (_tmp11_, "');", NULL);
	_tmp13_ = _tmp12_;
	_g_free0 (_tmp11_);
	_g_free0 (_tmp9_);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	query = _tmp13_;
	_tmp14_ = bird_font_char_database_parser_db;
	_tmp15_ = query;
	_tmp17_ = _sqlite3_exec (_tmp14_, _tmp15_, NULL, NULL, &_tmp16_);
	_g_free0 (errmsg);
	errmsg = _tmp16_;
	ec = _tmp17_;
	if (ec != SQLITE_OK) {
		FILE* _tmp18_;
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		_tmp18_ = stderr;
		_tmp19_ = query;
		fprintf (_tmp18_, "%s", _tmp19_);
		_tmp20_ = errmsg;
		g_warning ("CharDatabaseParser.vala:121: Error: %s\n", (const gchar*) _tmp20_);
	}
	_g_free0 (query);
	_g_free0 (w);
	_g_free0 (errmsg);
}

/** medial, isolated etc. */
gchar*
bird_font_char_database_parser_get_context_substitution (BirdFontCharDatabaseParser* self,
                                                         const gchar* description)
{
	gchar** lines = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gint lines_length1;
	gint _lines_size_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gchar* first_line = NULL;
	gchar** _tmp3_;
	gint _tmp3__length1;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* type = NULL;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (description != NULL, NULL);
	_tmp1_ = _tmp0_ = g_strsplit (description, "\n", 0);
	lines = _tmp1_;
	lines_length1 = _vala_array_length (_tmp0_);
	_lines_size_ = lines_length1;
	_tmp2_ = lines;
	_tmp2__length1 = lines_length1;
	g_return_val_if_fail (_tmp2__length1 > 0, "NONE");
	_tmp3_ = lines;
	_tmp3__length1 = lines_length1;
	_tmp4_ = _tmp3_[0];
	_tmp5_ = g_strdup (_tmp4_);
	first_line = _tmp5_;
	_tmp6_ = g_strdup ("NONE");
	type = _tmp6_;
	_tmp7_ = first_line;
	if (g_str_has_suffix (_tmp7_, "INITIAL FORM")) {
		gchar* _tmp8_;
		_tmp8_ = g_strdup ("INITIAL");
		_g_free0 (type);
		type = _tmp8_;
	} else {
		const gchar* _tmp9_;
		_tmp9_ = first_line;
		if (g_str_has_suffix (_tmp9_, "MEDIAL FORM")) {
			gchar* _tmp10_;
			_tmp10_ = g_strdup ("MEDIAL");
			_g_free0 (type);
			type = _tmp10_;
		} else {
			const gchar* _tmp11_;
			_tmp11_ = first_line;
			if (g_str_has_suffix (_tmp11_, "FINAL FORM")) {
				gchar* _tmp12_;
				_tmp12_ = g_strdup ("FINAL");
				_g_free0 (type);
				type = _tmp12_;
			} else {
				const gchar* _tmp13_;
				_tmp13_ = first_line;
				if (g_str_has_suffix (_tmp13_, "ISOLATED FORM")) {
					gchar* _tmp14_;
					_tmp14_ = g_strdup ("ISOLATED");
					_g_free0 (type);
					type = _tmp14_;
				}
			}
		}
	}
	result = type;
	_g_free0 (first_line);
	lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

static gint
string_index_of (const gchar* self,
                 const gchar* needle,
                 gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

gchar*
bird_font_char_database_parser_get_name (BirdFontCharDatabaseParser* self,
                                         const gchar* description)
{
	gchar** lines = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gint lines_length1;
	gint _lines_size_;
	gchar* first_line = NULL;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gint separator = 0;
	gchar* name = NULL;
	gint _tmp4_;
	gint _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (description != NULL, NULL);
	_tmp1_ = _tmp0_ = g_strsplit (description, "\n", 0);
	lines = _tmp1_;
	lines_length1 = _vala_array_length (_tmp0_);
	_lines_size_ = lines_length1;
	g_return_val_if_fail (lines_length1 > 0, "NONE");
	_tmp2_ = lines[0];
	_tmp3_ = g_strdup (_tmp2_);
	first_line = _tmp3_;
	separator = string_index_of (first_line, "\t", 0);
	_tmp4_ = strlen ("\t");
	_tmp5_ = _tmp4_;
	_tmp6_ = string_substring (first_line, (glong) (separator + _tmp5_), (glong) -1);
	name = _tmp6_;
	_tmp7_ = string_strip (name);
	result = _tmp7_;
	_g_free0 (name);
	_g_free0 (first_line);
	lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

void
bird_font_char_database_parser_insert_entry (BirdFontCharDatabaseParser* self,
                                             gint64 character,
                                             const gchar* description)
{
	gchar* errmsg = NULL;
	gchar* query = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gint ec = 0;
	sqlite3* _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_ = NULL;
	gint _tmp17_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (description != NULL);
	_tmp0_ = g_strdup_printf ("%" G_GINT64_FORMAT, (gint64) character);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat ("\n" \
"\t\t\tINSERT INTO Description (unicode, description)\n" \
"\t\t\tVALUES (", _tmp1_, NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat (_tmp3_, ", ", NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strconcat (_tmp5_, "'", NULL);
	_tmp7_ = _tmp6_;
	_tmp8_ = string_replace (description, "'", "''");
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strconcat (_tmp7_, _tmp9_, NULL);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_strconcat (_tmp11_, "');", NULL);
	_tmp13_ = _tmp12_;
	_g_free0 (_tmp11_);
	_g_free0 (_tmp9_);
	_g_free0 (_tmp7_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	query = _tmp13_;
	_tmp14_ = bird_font_char_database_parser_db;
	_tmp15_ = query;
	_tmp17_ = _sqlite3_exec (_tmp14_, _tmp15_, NULL, NULL, &_tmp16_);
	_g_free0 (errmsg);
	errmsg = _tmp16_;
	ec = _tmp17_;
	if (ec != SQLITE_OK) {
		FILE* _tmp18_;
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		_tmp18_ = stderr;
		_tmp19_ = query;
		fprintf (_tmp18_, "%s", _tmp19_);
		_tmp20_ = errmsg;
		g_warning ("CharDatabaseParser.vala:169: Error: %s\n", (const gchar*) _tmp20_);
		_tmp21_ = g_strdup_printf ("%" G_GINT64_FORMAT, character);
		_tmp22_ = _tmp21_;
		_tmp23_ = g_strconcat ("Can't insert description to: ", _tmp22_, NULL);
		_tmp24_ = _tmp23_;
		g_warning ("CharDatabaseParser.vala:170: %s", _tmp24_);
		_g_free0 (_tmp24_);
		_g_free0 (_tmp22_);
	}
	_g_free0 (query);
	_g_free0 (errmsg);
}

static void
bird_font_char_database_parser_add_entry (BirdFontCharDatabaseParser* self,
                                          const gchar* data)
{
	gchar** e = NULL;
	gint e_length1 = 0;
	gint _e_size_ = 0;
	gchar** r = NULL;
	gint r_length1 = 0;
	gint _r_size_ = 0;
	gchar** d = NULL;
	gint d_length1 = 0;
	gint _d_size_ = 0;
	gchar* index_values = NULL;
	gunichar ch = 0U;
	gchar* unicode_hex = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	const gchar* _tmp19_;
	gchar* _tmp20_;
	const gchar* _tmp21_;
	gchar* _tmp22_;
	const gchar* _tmp23_;
	gchar* _tmp24_;
	const gchar* _tmp25_;
	gchar** _tmp26_;
	gchar** _tmp27_;
	gchar** _tmp28_;
	gint _tmp28__length1;
	gchar** _tmp29_;
	gint _tmp29__length1;
	const gchar* _tmp30_;
	gchar* _tmp31_;
	const gchar* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	BirdFontGlyphRange* _tmp37_;
	gchar** _tmp38_;
	gint _tmp38__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (data != NULL);
	if (g_str_has_prefix (data, "@")) {
		_g_free0 (unicode_hex);
		_g_free0 (index_values);
		d = (_vala_array_free (d, d_length1, (GDestroyNotify) g_free), NULL);
		r = (_vala_array_free (r, r_length1, (GDestroyNotify) g_free), NULL);
		e = (_vala_array_free (e, e_length1, (GDestroyNotify) g_free), NULL);
		return;
	}
	if (g_str_has_prefix (data, ";")) {
		_g_free0 (unicode_hex);
		_g_free0 (index_values);
		d = (_vala_array_free (d, d_length1, (GDestroyNotify) g_free), NULL);
		r = (_vala_array_free (r, r_length1, (GDestroyNotify) g_free), NULL);
		e = (_vala_array_free (e, e_length1, (GDestroyNotify) g_free), NULL);
		return;
	}
	_tmp0_ = g_utf8_strdown (data, (gssize) -1);
	_g_free0 (index_values);
	index_values = _tmp0_;
	_tmp1_ = index_values;
	_tmp2_ = string_replace (_tmp1_, "\n\tx", "");
	_g_free0 (index_values);
	index_values = _tmp2_;
	_tmp3_ = index_values;
	_tmp4_ = string_replace (_tmp3_, "\n\t*", "");
	_g_free0 (index_values);
	index_values = _tmp4_;
	_tmp5_ = index_values;
	_tmp6_ = string_replace (_tmp5_, "\n\t=", "");
	_g_free0 (index_values);
	index_values = _tmp6_;
	_tmp7_ = index_values;
	_tmp8_ = string_replace (_tmp7_, "\n\t#", "");
	_g_free0 (index_values);
	index_values = _tmp8_;
	_tmp9_ = index_values;
	_tmp10_ = string_replace (_tmp9_, ",", " ");
	_g_free0 (index_values);
	index_values = _tmp10_;
	_tmp11_ = index_values;
	_tmp12_ = string_replace (_tmp11_, " - ", " ");
	_g_free0 (index_values);
	index_values = _tmp12_;
	_tmp13_ = index_values;
	_tmp14_ = string_replace (_tmp13_, "(", "");
	_g_free0 (index_values);
	index_values = _tmp14_;
	_tmp15_ = index_values;
	_tmp16_ = string_replace (_tmp15_, ")", "");
	_g_free0 (index_values);
	index_values = _tmp16_;
	_tmp17_ = index_values;
	_tmp18_ = string_replace (_tmp17_, "<font>", "");
	_g_free0 (index_values);
	index_values = _tmp18_;
	_tmp19_ = index_values;
	_tmp20_ = string_replace (_tmp19_, " a ", " ");
	_g_free0 (index_values);
	index_values = _tmp20_;
	_tmp21_ = index_values;
	_tmp22_ = string_replace (_tmp21_, " is ", " ");
	_g_free0 (index_values);
	index_values = _tmp22_;
	_tmp23_ = index_values;
	_tmp24_ = string_replace (_tmp23_, " the ", " ");
	_g_free0 (index_values);
	index_values = _tmp24_;
	_tmp25_ = index_values;
	_tmp27_ = _tmp26_ = g_strsplit (_tmp25_, "\t", 0);
	e = (_vala_array_free (e, e_length1, (GDestroyNotify) g_free), NULL);
	e = _tmp27_;
	e_length1 = _vala_array_length (_tmp26_);
	_e_size_ = e_length1;
	_tmp28_ = e;
	_tmp28__length1 = e_length1;
	g_return_if_fail (_tmp28__length1 > 0);
	_tmp29_ = e;
	_tmp29__length1 = e_length1;
	_tmp30_ = _tmp29_[0];
	_tmp31_ = g_utf8_strup (_tmp30_, (gssize) -1);
	_g_free0 (unicode_hex);
	unicode_hex = _tmp31_;
	_tmp32_ = unicode_hex;
	_tmp33_ = g_utf8_strdown (_tmp32_, (gssize) -1);
	_tmp34_ = _tmp33_;
	_tmp35_ = g_strconcat ("U+", _tmp34_, NULL);
	_tmp36_ = _tmp35_;
	ch = bird_font_font_to_unichar (_tmp36_);
	_g_free0 (_tmp36_);
	_g_free0 (_tmp34_);
	bird_font_char_database_parser_insert_entry (self, (gint64) ch, data);
	_tmp37_ = self->priv->utf8;
	bird_font_glyph_range_add_single (_tmp37_, ch);
	_tmp38_ = e;
	_tmp38__length1 = e_length1;
	{
		gchar** s_collection = NULL;
		gint s_collection_length1 = 0;
		gint _s_collection_size_ = 0;
		gint s_it = 0;
		s_collection = _tmp38_;
		s_collection_length1 = _tmp38__length1;
		for (s_it = 0; s_it < s_collection_length1; s_it = s_it + 1) {
			gchar* _tmp39_;
			gchar* s = NULL;
			_tmp39_ = g_strdup (s_collection[s_it]);
			s = _tmp39_;
			{
				const gchar* _tmp40_;
				gchar** _tmp41_;
				gchar** _tmp42_;
				gchar** _tmp43_;
				gint _tmp43__length1;
				_tmp40_ = s;
				_tmp42_ = _tmp41_ = g_strsplit (_tmp40_, "\n", 0);
				r = (_vala_array_free (r, r_length1, (GDestroyNotify) g_free), NULL);
				r = _tmp42_;
				r_length1 = _vala_array_length (_tmp41_);
				_r_size_ = r_length1;
				_tmp43_ = r;
				_tmp43__length1 = r_length1;
				{
					gchar** t_collection = NULL;
					gint t_collection_length1 = 0;
					gint _t_collection_size_ = 0;
					gint t_it = 0;
					t_collection = _tmp43_;
					t_collection_length1 = _tmp43__length1;
					for (t_it = 0; t_it < t_collection_length1; t_it = t_it + 1) {
						gchar* _tmp44_;
						gchar* t = NULL;
						_tmp44_ = g_strdup (t_collection[t_it]);
						t = _tmp44_;
						{
							const gchar* _tmp45_;
							_tmp45_ = t;
							if (!g_str_has_prefix (_tmp45_, "\t~")) {
								const gchar* _tmp46_;
								gchar** _tmp47_;
								gchar** _tmp48_;
								gchar** _tmp49_;
								gint _tmp49__length1;
								_tmp46_ = t;
								_tmp48_ = _tmp47_ = g_strsplit (_tmp46_, " ", 0);
								d = (_vala_array_free (d, d_length1, (GDestroyNotify) g_free), NULL);
								d = _tmp48_;
								d_length1 = _vala_array_length (_tmp47_);
								_d_size_ = d_length1;
								_tmp49_ = d;
								_tmp49__length1 = d_length1;
								{
									gchar** token_collection = NULL;
									gint token_collection_length1 = 0;
									gint _token_collection_size_ = 0;
									gint token_it = 0;
									token_collection = _tmp49_;
									token_collection_length1 = _tmp49__length1;
									for (token_it = 0; token_it < token_collection_length1; token_it = token_it + 1) {
										gchar* _tmp50_;
										gchar* token = NULL;
										_tmp50_ = g_strdup (token_collection[token_it]);
										token = _tmp50_;
										{
											const gchar* _tmp51_;
											_tmp51_ = token;
											if (g_strcmp0 (_tmp51_, "") != 0) {
												const gchar* _tmp52_;
												_tmp52_ = token;
												bird_font_char_database_parser_insert_lookup (self, (gint64) ch, _tmp52_);
											}
											_g_free0 (token);
										}
									}
								}
							}
							_g_free0 (t);
						}
					}
				}
				_g_free0 (s);
			}
		}
	}
	_g_free0 (unicode_hex);
	_g_free0 (index_values);
	d = (_vala_array_free (d, d_length1, (GDestroyNotify) g_free), NULL);
	r = (_vala_array_free (r, r_length1, (GDestroyNotify) g_free), NULL);
	e = (_vala_array_free (e, e_length1, (GDestroyNotify) g_free), NULL);
}

static void
bird_font_char_database_parser_parse_all_entries (BirdFontCharDatabaseParser* self)
{
	GFileInputStream* fin = NULL;
	GDataInputStream* din = NULL;
	gchar* line = NULL;
	gchar* data = NULL;
	gchar* description = NULL;
	gchar* _tmp0_;
	GFile* file = NULL;
	gint ec = 0;
	gchar* errmsg = NULL;
	guint64 transaction_number = 0ULL;
	GFile* _tmp1_;
	sqlite3* _tmp2_;
	gchar* _tmp3_ = NULL;
	gint _tmp4_;
	sqlite3* _tmp54_;
	gchar* _tmp55_ = NULL;
	gint _tmp56_;
	FILE* _tmp58_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("");
	description = _tmp0_;
	transaction_number = (guint64) 0;
	_tmp1_ = bird_font_char_database_parser_get_unicode_database (self);
	_g_object_unref0 (file);
	file = _tmp1_;
	_tmp2_ = bird_font_char_database_parser_db;
	_tmp4_ = _sqlite3_exec (_tmp2_, "BEGIN TRANSACTION", NULL, NULL, &_tmp3_);
	_g_free0 (errmsg);
	errmsg = _tmp3_;
	ec = _tmp4_;
	if (ec != SQLITE_OK) {
		const gchar* _tmp5_;
		_tmp5_ = errmsg;
		g_warning ("CharDatabaseParser.vala:245: Error: %s\n", (const gchar*) _tmp5_);
	}
	{
		GFileInputStream* _tmp6_ = NULL;
		GFile* _tmp7_;
		GFileInputStream* _tmp8_;
		GFileInputStream* _tmp9_;
		GFileInputStream* _tmp10_;
		GDataInputStream* _tmp11_;
		gchar* _tmp12_ = NULL;
		GDataInputStream* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		const gchar* _tmp45_;
		GFileInputStream* _tmp46_;
		GDataInputStream* _tmp47_;
		_tmp7_ = file;
		_tmp8_ = g_file_read (_tmp7_, NULL, &_inner_error0_);
		_tmp6_ = _tmp8_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp9_ = _tmp6_;
		_tmp6_ = NULL;
		_g_object_unref0 (fin);
		fin = _tmp9_;
		_tmp10_ = fin;
		_tmp11_ = g_data_input_stream_new ((GInputStream*) _tmp10_);
		_g_object_unref0 (din);
		din = _tmp11_;
		_tmp13_ = din;
		_tmp14_ = g_data_input_stream_read_line (_tmp13_, NULL, NULL, &_inner_error0_);
		_tmp12_ = _tmp14_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp6_);
			goto __catch0_g_error;
		}
		_tmp15_ = _tmp12_;
		_tmp12_ = NULL;
		_g_free0 (line);
		line = _tmp15_;
		while (TRUE) {
			const gchar* _tmp16_;
			gchar* _tmp17_;
			const gchar* _tmp18_;
			gchar* _tmp19_;
			const gchar* _tmp44_;
			_tmp16_ = line;
			_tmp17_ = g_strdup ((const gchar*) _tmp16_);
			_g_free0 (data);
			data = _tmp17_;
			_tmp18_ = data;
			_tmp19_ = g_strdup (_tmp18_);
			_g_free0 (description);
			description = _tmp19_;
			while (TRUE) {
				gchar* _tmp20_ = NULL;
				GDataInputStream* _tmp21_;
				gchar* _tmp22_;
				gchar* _tmp23_;
				const gchar* _tmp24_;
				const gchar* _tmp25_;
				gchar* _tmp26_;
				const gchar* _tmp27_;
				_tmp21_ = din;
				_tmp22_ = g_data_input_stream_read_line (_tmp21_, NULL, NULL, &_inner_error0_);
				_tmp20_ = _tmp22_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_free0 (_tmp12_);
					_g_object_unref0 (_tmp6_);
					goto __catch0_g_error;
				}
				_tmp23_ = _tmp20_;
				_tmp20_ = NULL;
				_g_free0 (line);
				line = _tmp23_;
				_tmp24_ = line;
				if (!(_tmp24_ != NULL)) {
					_g_free0 (_tmp20_);
					break;
				}
				_tmp25_ = line;
				_tmp26_ = g_strdup ((const gchar*) _tmp25_);
				_g_free0 (data);
				data = _tmp26_;
				_tmp27_ = data;
				if (g_str_has_prefix (_tmp27_, "\t")) {
					const gchar* _tmp28_;
					gchar* _tmp29_;
					const gchar* _tmp30_;
					const gchar* _tmp31_;
					gchar* _tmp32_;
					_tmp28_ = description;
					_tmp29_ = g_strconcat (_tmp28_, "\n", NULL);
					_g_free0 (description);
					description = _tmp29_;
					_tmp30_ = description;
					_tmp31_ = data;
					_tmp32_ = g_strconcat (_tmp30_, _tmp31_, NULL);
					_g_free0 (description);
					description = _tmp32_;
				} else {
					const gchar* _tmp33_;
					_tmp33_ = description;
					if (string_index_of (_tmp33_, "<not a character>", 0) == -1) {
						const gchar* _tmp34_;
						guint64 _tmp35_;
						_tmp34_ = description;
						bird_font_char_database_parser_add_entry (self, _tmp34_);
						_tmp35_ = transaction_number;
						transaction_number = _tmp35_ + 1;
						if (transaction_number >= ((guint64) 1000)) {
							sqlite3* _tmp36_;
							gchar* _tmp37_ = NULL;
							gint _tmp38_;
							sqlite3* _tmp40_;
							gchar* _tmp41_ = NULL;
							gint _tmp42_;
							_tmp36_ = bird_font_char_database_parser_db;
							_tmp38_ = _sqlite3_exec (_tmp36_, "END TRANSACTION", NULL, NULL, &_tmp37_);
							_g_free0 (errmsg);
							errmsg = _tmp37_;
							ec = _tmp38_;
							if (ec != SQLITE_OK) {
								const gchar* _tmp39_;
								_tmp39_ = errmsg;
								g_warning ("CharDatabaseParser.vala:270: Error: %s\n", (const gchar*) _tmp39_);
							}
							_tmp40_ = bird_font_char_database_parser_db;
							_tmp42_ = _sqlite3_exec (_tmp40_, "BEGIN TRANSACTION", NULL, NULL, &_tmp41_);
							_g_free0 (errmsg);
							errmsg = _tmp41_;
							ec = _tmp42_;
							if (ec != SQLITE_OK) {
								const gchar* _tmp43_;
								_tmp43_ = errmsg;
								g_warning ("CharDatabaseParser.vala:275: Error: %s\n", (const gchar*) _tmp43_);
							}
							transaction_number = (guint64) 0;
						}
					}
					_g_free0 (_tmp20_);
					break;
				}
				_g_free0 (_tmp20_);
			}
			_tmp44_ = line;
			if (_tmp44_ == NULL) {
				break;
			}
		}
		_tmp45_ = description;
		if (g_strcmp0 (_tmp45_, "") == 0) {
			g_warning ("CharDatabaseParser.vala:291: no description found");
		}
		_tmp46_ = fin;
		g_input_stream_close ((GInputStream*) _tmp46_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (_tmp12_);
			_g_object_unref0 (_tmp6_);
			goto __catch0_g_error;
		}
		_tmp47_ = din;
		g_input_stream_close ((GInputStream*) _tmp47_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (_tmp12_);
			_g_object_unref0 (_tmp6_);
			goto __catch0_g_error;
		}
		_g_free0 (_tmp12_);
		_g_object_unref0 (_tmp6_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp48_;
		const gchar* _tmp49_;
		GFile* _tmp50_;
		GFile* _tmp51_;
		gchar* _tmp52_;
		gchar* _tmp53_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp48_ = e;
		_tmp49_ = _tmp48_->message;
		g_warning ("CharDatabaseParser.vala:297: %s", _tmp49_);
		_tmp50_ = bird_font_char_database_parser_get_unicode_database (self);
		_tmp51_ = _tmp50_;
		_tmp52_ = g_file_get_path (_tmp51_);
		_tmp53_ = (gchar*) _tmp52_;
		g_warning ("CharDatabaseParser.vala:298: In %s", _tmp53_);
		_g_free0 (_tmp53_);
		_g_object_unref0 (_tmp51_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (errmsg);
		_g_object_unref0 (file);
		_g_free0 (description);
		_g_free0 (data);
		_g_free0 (line);
		_g_object_unref0 (din);
		_g_object_unref0 (fin);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp54_ = bird_font_char_database_parser_db;
	_tmp56_ = _sqlite3_exec (_tmp54_, "END TRANSACTION", NULL, NULL, &_tmp55_);
	_g_free0 (errmsg);
	errmsg = _tmp55_;
	ec = _tmp56_;
	if (ec != SQLITE_OK) {
		const gchar* _tmp57_;
		_tmp57_ = errmsg;
		g_warning ("CharDatabaseParser.vala:303: Error: %s\n", (const gchar*) _tmp57_);
	}
	_tmp58_ = stdout;
	fprintf (_tmp58_, "Done");
	_g_free0 (errmsg);
	_g_object_unref0 (file);
	_g_free0 (description);
	_g_free0 (data);
	_g_free0 (line);
	_g_object_unref0 (din);
	_g_object_unref0 (fin);
}

static GFile*
bird_font_char_database_parser_get_unicode_database (BirdFontCharDatabaseParser* self)
{
	GFile* _tmp0_;
	GFile* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = bird_font_search_paths_get_char_database ();
	result = _tmp0_;
	return result;
}

static void
bird_font_char_database_parser_class_init (BirdFontCharDatabaseParserClass * klass,
                                           gpointer klass_data)
{
	bird_font_char_database_parser_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BirdFontCharDatabaseParser_private_offset);
	G_OBJECT_CLASS (klass)->finalize = bird_font_char_database_parser_finalize;
}

static void
bird_font_char_database_parser_instance_init (BirdFontCharDatabaseParser * self,
                                              gpointer klass)
{
	BirdFontGlyphRange* _tmp0_;
	self->priv = bird_font_char_database_parser_get_instance_private (self);
	_tmp0_ = bird_font_glyph_range_new ();
	self->priv->utf8 = _tmp0_;
}

static void
bird_font_char_database_parser_finalize (GObject * obj)
{
	BirdFontCharDatabaseParser * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BIRD_FONT_TYPE_CHAR_DATABASE_PARSER, BirdFontCharDatabaseParser);
	_bird_font_glyph_range_unref0 (self->priv->utf8);
	G_OBJECT_CLASS (bird_font_char_database_parser_parent_class)->finalize (obj);
}

static GType
bird_font_char_database_parser_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BirdFontCharDatabaseParserClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bird_font_char_database_parser_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BirdFontCharDatabaseParser), 0, (GInstanceInitFunc) bird_font_char_database_parser_instance_init, NULL };
	GType bird_font_char_database_parser_type_id;
	bird_font_char_database_parser_type_id = g_type_register_static (G_TYPE_OBJECT, "BirdFontCharDatabaseParser", &g_define_type_info, 0);
	BirdFontCharDatabaseParser_private_offset = g_type_add_instance_private (bird_font_char_database_parser_type_id, sizeof (BirdFontCharDatabaseParserPrivate));
	return bird_font_char_database_parser_type_id;
}

GType
bird_font_char_database_parser_get_type (void)
{
	static volatile gsize bird_font_char_database_parser_type_id__once = 0;
	if (g_once_init_enter (&bird_font_char_database_parser_type_id__once)) {
		GType bird_font_char_database_parser_type_id;
		bird_font_char_database_parser_type_id = bird_font_char_database_parser_get_type_once ();
		g_once_init_leave (&bird_font_char_database_parser_type_id__once, bird_font_char_database_parser_type_id);
	}
	return bird_font_char_database_parser_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

