/* BirdFontFile.c generated by valac 0.56.17, the Vala compiler
 * generated from BirdFontFile.vala, do not modify */

/*
Copyright (C) 2013 2014 2015 2016 2017 2022 Johan Mattsson

This library is free software; you can redistribute it and/or modify 
it under the terms of the GNU Lesser General Public License as 
published by the Free Software Foundation; either version 3 of the 
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
Lesser General Public License for more details.
*/

#include <glib-object.h>
#include "birdfont.h"
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <xmlbird.h>
#include <glib/gstdio.h>
#include <gio/gio.h>
#include <float.h>
#include <math.h>
#include <errno.h>

#define BIRD_FONT_BIRD_FONT_FILE_FORMAT_MAJOR 2
#define BIRD_FONT_BIRD_FONT_FILE_FORMAT_MINOR 5
#define BIRD_FONT_BIRD_FONT_FILE_MIN_FORMAT_MAJOR 0
#define BIRD_FONT_BIRD_FONT_FILE_MIN_FORMAT_MINOR 0
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define BIRD_FONT_TYPE_BIRD_FONT_FILE (bird_font_bird_font_file_get_type ())
#define BIRD_FONT_BIRD_FONT_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BIRD_FONT_TYPE_BIRD_FONT_FILE, BirdFontBirdFontFile))
#define BIRD_FONT_BIRD_FONT_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BIRD_FONT_TYPE_BIRD_FONT_FILE, BirdFontBirdFontFileClass))
#define BIRD_FONT_IS_BIRD_FONT_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BIRD_FONT_TYPE_BIRD_FONT_FILE))
#define BIRD_FONT_IS_BIRD_FONT_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BIRD_FONT_TYPE_BIRD_FONT_FILE))
#define BIRD_FONT_BIRD_FONT_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BIRD_FONT_TYPE_BIRD_FONT_FILE, BirdFontBirdFontFileClass))

typedef struct _BirdFontBirdFontFile BirdFontBirdFontFile;
typedef struct _BirdFontBirdFontFileClass BirdFontBirdFontFileClass;
typedef struct _BirdFontBirdFontFilePrivate BirdFontBirdFontFilePrivate;
enum  {
	BIRD_FONT_BIRD_FONT_FILE_0_PROPERTY,
	BIRD_FONT_BIRD_FONT_FILE_NUM_PROPERTIES
};
static GParamSpec* bird_font_bird_font_file_properties[BIRD_FONT_BIRD_FONT_FILE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block5Data Block5Data;
typedef struct _Block6Data Block6Data;
typedef struct _Block7Data Block7Data;
#define _bird_font_glyph_range_unref0(var) ((var == NULL) ? NULL : (var = (bird_font_glyph_range_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
typedef struct _Block8Data Block8Data;

struct _BirdFontBirdFontFile {
	GObject parent_instance;
	BirdFontBirdFontFilePrivate * priv;
};

struct _BirdFontBirdFontFileClass {
	GObjectClass parent_class;
};

struct _BirdFontBirdFontFilePrivate {
	BirdFontFont* font;
	GeeArrayList* written_images;
};

struct _Block5Data {
	int _ref_count_;
	BirdFontBirdFontFile* self;
	gchar* path;
};

struct _Block6Data {
	int _ref_count_;
	Block5Data * _data5_;
	GDataOutputStream* os;
};

struct _Block7Data {
	int _ref_count_;
	BirdFontBirdFontFile* self;
	GDataOutputStream* os;
};

struct _Block8Data {
	int _ref_count_;
	BirdFontBirdFontFile* self;
	GDataOutputStream* os;
};

static gint BirdFontBirdFontFile_private_offset;
static gpointer bird_font_bird_font_file_parent_class = NULL;

VALA_EXTERN GType bird_font_bird_font_file_get_type (void) G_GNUC_CONST ;
VALA_EXTERN BirdFontBirdFontFile* bird_font_bird_font_file_new (BirdFontFont* f);
VALA_EXTERN BirdFontBirdFontFile* bird_font_bird_font_file_construct (GType object_type,
                                                          BirdFontFont* f);
VALA_EXTERN gboolean bird_font_bird_font_file_load (BirdFontBirdFontFile* self,
                                        const gchar* path);
static gboolean bird_font_bird_font_file_load_xml (BirdFontBirdFontFile* self,
                                            BXmlParser* parser);
VALA_EXTERN gboolean bird_font_bird_font_file_load_part (BirdFontBirdFontFile* self,
                                             const gchar* bfp_file);
VALA_EXTERN gboolean bird_font_bird_font_file_load_data (BirdFontBirdFontFile* self,
                                             const gchar* xml_data);
static void bird_font_bird_font_file_create_background_files (BirdFontBirdFontFile* self,
                                                       BTag* root);
static gboolean bird_font_bird_font_file_parse_file (BirdFontBirdFontFile* self,
                                              BTag* tag);
VALA_EXTERN gboolean bird_font_bird_font_file_write_font_file (BirdFontBirdFontFile* self,
                                                   const gchar* path,
                                                   gboolean backup);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
VALA_EXTERN void bird_font_bird_font_file_write_root_tag (BirdFontBirdFontFile* self,
                                              GDataOutputStream* os,
                                              GError** error);
VALA_EXTERN void bird_font_bird_font_file_write_description (BirdFontBirdFontFile* self,
                                                 GDataOutputStream* os,
                                                 GError** error);
VALA_EXTERN void bird_font_bird_font_file_write_lines (BirdFontBirdFontFile* self,
                                           GDataOutputStream* os,
                                           GError** error);
VALA_EXTERN void bird_font_bird_font_file_write_settings (BirdFontBirdFontFile* self,
                                              GDataOutputStream* os,
                                              GError** error);
static void ___lambda505_ (Block6Data* _data6_,
                    BirdFontGlyphCollection* gc);
VALA_EXTERN void bird_font_bird_font_file_write_glyph_collection (BirdFontBirdFontFile* self,
                                                      BirdFontGlyphCollection* gc,
                                                      GDataOutputStream* os,
                                                      GError** error);
static void ____lambda505__gfunc (gconstpointer data,
                           gpointer self);
VALA_EXTERN void bird_font_bird_font_file_write_images (BirdFontBirdFontFile* self,
                                            GDataOutputStream* os,
                                            GError** error);
VALA_EXTERN void bird_font_bird_font_file_write_ligatures (BirdFontBirdFontFile* self,
                                               GDataOutputStream* os);
static void ___lambda506_ (Block6Data* _data6_,
                    BirdFontGlyphCollection* gc);
VALA_EXTERN void bird_font_bird_font_file_write_image (BirdFontBirdFontFile* self,
                                           GDataOutputStream* os,
                                           const gchar* sha1,
                                           const gchar* data,
                                           GError** error);
static void ____lambda506__gfunc (gconstpointer data,
                           gpointer self);
VALA_EXTERN void bird_font_bird_font_file_write_spacing_classes (BirdFontBirdFontFile* self,
                                                     GDataOutputStream* os,
                                                     GError** error);
VALA_EXTERN void bird_font_bird_font_file_write_alternates (BirdFontBirdFontFile* self,
                                                GDataOutputStream* os,
                                                GError** error);
VALA_EXTERN void bird_font_bird_font_file_write_kerning (BirdFontBirdFontFile* self,
                                             GDataOutputStream* os,
                                             GError** error);
VALA_EXTERN void bird_font_bird_font_file_write_closing_root_tag (BirdFontBirdFontFile* self,
                                                      GDataOutputStream* os,
                                                      GError** error);
VALA_EXTERN gchar* bird_font_bird_font_file_encode (const gchar* s);
VALA_EXTERN gchar* bird_font_bird_font_file_round (gdouble p,
                                       gint decimals);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (void * _userdata_);
static void __lambda339_ (Block7Data* _data7_,
                   const gchar* l,
                   const gchar* r,
                   gdouble k);
static void ___lambda339__bird_font_kerning_classes_kerning_class_iterator (const gchar* left,
                                                                     const gchar* right,
                                                                     gdouble kerning,
                                                                     gpointer self);
VALA_EXTERN void bird_font_bird_font_file_write_glyph_collection_start (BirdFontBirdFontFile* self,
                                                            BirdFontGlyphCollection* gc,
                                                            BirdFontGlyphMaster* master,
                                                            GDataOutputStream* os,
                                                            GError** error);
VALA_EXTERN void bird_font_bird_font_file_write_glyph_collection_end (BirdFontBirdFontFile* self,
                                                          GDataOutputStream* os,
                                                          GError** error);
VALA_EXTERN void bird_font_bird_font_file_write_selected (BirdFontBirdFontFile* self,
                                              BirdFontGlyphMaster* master,
                                              GDataOutputStream* os,
                                              GError** error);
VALA_EXTERN void bird_font_bird_font_file_write_glyph_master (BirdFontBirdFontFile* self,
                                                  BirdFontGlyphMaster* master,
                                                  GDataOutputStream* os,
                                                  GError** error);
VALA_EXTERN void bird_font_bird_font_file_write_glyph (BirdFontBirdFontFile* self,
                                           BirdFontGlyph* g,
                                           GDataOutputStream* os,
                                           GError** error);
VALA_EXTERN gchar* bird_font_bird_font_file_double_to_string (gdouble n);
static void bird_font_bird_font_file_write_layer (BirdFontBirdFontFile* self,
                                           BirdFontLayer* layer,
                                           GDataOutputStream* os,
                                           GError** error);
static void bird_font_bird_font_file_write_glyph_background (BirdFontBirdFontFile* self,
                                                      BirdFontGlyph* g,
                                                      GDataOutputStream* os,
                                                      GError** error);
VALA_EXTERN gchar* bird_font_bird_font_file_get_point_data (BirdFontPath* pl);
static void bird_font_bird_font_file_add_start_point (BirdFontEditPoint* e,
                                               GString* data);
static void bird_font_bird_font_file_add_next_point (BirdFontEditPoint* start,
                                              BirdFontEditPoint* end,
                                              GString* data);
static void bird_font_bird_font_file_add_cubic_start (BirdFontEditPoint* p,
                                               GString* data);
static void bird_font_bird_font_file_add_double_start (BirdFontEditPoint* p,
                                                GString* data);
static void bird_font_bird_font_file_add_quadratic_start (BirdFontEditPoint* p,
                                                   GString* data);
static void bird_font_bird_font_file_add_quadratic_line_to (BirdFontEditPoint* p,
                                                     GString* data);
static void bird_font_bird_font_file_add_line_to (BirdFontEditPoint* p,
                                           GString* data);
static void bird_font_bird_font_file_add_cubic_line_to (BirdFontEditPoint* p,
                                                 GString* data);
static void bird_font_bird_font_file_quadratic_line (BirdFontPath* path,
                                              const gchar* px,
                                              const gchar* py);
static gdouble bird_font_bird_font_file_parse_double (const gchar* p);
static void bird_font_bird_font_file_add_quadratic (BirdFontEditPoint* start,
                                             BirdFontEditPoint* end,
                                             GString* data);
static void bird_font_bird_font_file_add_double (BirdFontEditPoint* start,
                                          BirdFontEditPoint* end,
                                          GString* data);
static void bird_font_bird_font_file_add_cubic (BirdFontEditPoint* start,
                                         BirdFontEditPoint* end,
                                         GString* data);
VALA_EXTERN void bird_font_bird_font_file_parse_format (BirdFontBirdFontFile* self,
                                            BTag* tag);
static void bird_font_bird_font_file_parse_glyph_collection (BirdFontBirdFontFile* self,
                                                      BTag* tag);
static void bird_font_bird_font_file_parse_horizontal_lines (BirdFontBirdFontFile* self,
                                                      BTag* tag);
static void bird_font_bird_font_file_parse_grid (BirdFontBirdFontFile* self,
                                          BTag* tag);
static void bird_font_bird_font_file_parse_background (BirdFontBirdFontFile* self,
                                                BTag* tag);
VALA_EXTERN gchar* bird_font_bird_font_file_decode (const gchar* s);
static void bird_font_bird_font_file_parse_kerning (BirdFontBirdFontFile* self,
                                             BTag* tag);
static void bird_font_bird_font_file_parse_spacing_class (BirdFontBirdFontFile* self,
                                                   BTag* tag);
VALA_EXTERN void bird_font_bird_font_file_parse_ligature (BirdFontBirdFontFile* self,
                                              BTag* t);
VALA_EXTERN void bird_font_bird_font_file_parse_contectual_ligature (BirdFontBirdFontFile* self,
                                                         BTag* t);
VALA_EXTERN void bird_font_bird_font_file_parse_images (BirdFontBirdFontFile* self,
                                            BTag* tag);
VALA_EXTERN void bird_font_bird_font_file_parse_alternate (BirdFontBirdFontFile* self,
                                               BTag* tag);
VALA_EXTERN gchar* bird_font_bird_font_file_unserialize (const gchar* s);
static void bird_font_bird_font_file_parse_image_selections (BirdFontBirdFontFile* self,
                                                      BirdFontBackgroundImage* image,
                                                      BTag* tag);
static void bird_font_bird_font_file_parse_background_image (BirdFontBirdFontFile* self,
                                                      BTag* tag);
VALA_EXTERN gchar* bird_font_bird_font_file_serialize_attribute (const gchar* s);
VALA_EXTERN gchar* bird_font_bird_font_file_serialize_unichar (gunichar c);
static gboolean bird_font_bird_font_file_has_grid (BirdFontBirdFontFile* self,
                                            const gchar* v);
static gdouble bird_font_bird_font_file_parse_double_from_node (BirdFontBirdFontFile* self,
                                                         BTag* tag);
static gint bird_font_bird_font_file_parse_selected (BirdFontBirdFontFile* self,
                                              BTag* tag);
VALA_EXTERN void bird_font_bird_font_file_parse_glyph (BirdFontBirdFontFile* self,
                                           BTag* tag,
                                           BirdFontGlyphCollection* gc,
                                           BirdFontGlyphMaster* master,
                                           const gchar* name,
                                           gunichar unicode,
                                           gint selected_id,
                                           gboolean unassigned);
static BirdFontLayer* bird_font_bird_font_file_parse_layer (BirdFontBirdFontFile* self,
                                                     BTag* tag);
static BirdFontPath* bird_font_bird_font_file_parse_path (BirdFontBirdFontFile* self,
                                                   BTag* tag);
static void bird_font_bird_font_file_parse_background_scale (BirdFontBirdFontFile* self,
                                                      BirdFontGlyph* g,
                                                      BTag* tag);
static void bird_font_bird_font_file_line (BirdFontPath* path,
                                    const gchar* px,
                                    const gchar* py);
static void bird_font_bird_font_file_cubic_line (BirdFontPath* path,
                                          const gchar* px,
                                          const gchar* py);
static void bird_font_bird_font_file_quadratic (BirdFontPath* path,
                                         const gchar* px0,
                                         const gchar* py0,
                                         const gchar* px1,
                                         const gchar* py1);
static void bird_font_bird_font_file_cubic (BirdFontPath* path,
                                     const gchar* px0,
                                     const gchar* py0,
                                     const gchar* px1,
                                     const gchar* py1,
                                     const gchar* px2,
                                     const gchar* py2);
static void bird_font_bird_font_file_double_curve (BirdFontPath* path,
                                            const gchar* px0,
                                            const gchar* py0,
                                            const gchar* px1,
                                            const gchar* py1,
                                            const gchar* px2,
                                            const gchar* py2);
VALA_EXTERN void bird_font_bird_font_file_close (BirdFontPath* path);
VALA_EXTERN void bird_font_bird_font_file_parse_path_data (const gchar* data,
                                               BirdFontPath* path);
static Block8Data* block8_data_ref (Block8Data* _data8_);
static void block8_data_unref (void * _userdata_);
static void __lambda337_ (Block8Data* _data8_,
                   const gchar* subst,
                   const gchar* liga);
static void ___lambda337__bird_font_ligatures_ligature_iterator (const gchar* substitution,
                                                          const gchar* ligature,
                                                          gpointer self);
VALA_EXTERN gchar* bird_font_bird_font_file_remove_last_zeros (const gchar* value);
static void bird_font_bird_font_file_finalize (GObject * obj);
static GType bird_font_bird_font_file_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
bird_font_bird_font_file_get_instance_private (BirdFontBirdFontFile* self)
{
	return G_STRUCT_MEMBER_P (self, BirdFontBirdFontFile_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

BirdFontBirdFontFile*
bird_font_bird_font_file_construct (GType object_type,
                                    BirdFontFont* f)
{
	BirdFontBirdFontFile * self = NULL;
	BirdFontFont* _tmp0_;
	g_return_val_if_fail (f != NULL, NULL);
	self = (BirdFontBirdFontFile*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (f);
	_g_object_unref0 (self->priv->font);
	self->priv->font = _tmp0_;
	return self;
}

BirdFontBirdFontFile*
bird_font_bird_font_file_new (BirdFontFont* f)
{
	return bird_font_bird_font_file_construct (BIRD_FONT_TYPE_BIRD_FONT_FILE, f);
}

/** Load a new .bf file.
 * @param path path to a valid .bf file
 */
gboolean
bird_font_bird_font_file_load (BirdFontBirdFontFile* self,
                               const gchar* path)
{
	gchar* xml_data = NULL;
	BXmlParser* parser = NULL;
	gboolean ok = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (path != NULL, FALSE);
	ok = FALSE;
	{
		gchar* _tmp0_ = NULL;
		BirdFontFont* _tmp2_;
		GeeArrayList* _tmp3_;
		BirdFontFont* _tmp4_;
		gchar* _tmp5_;
		BXmlParser* _tmp6_;
		BXmlParser* _tmp7_;
		g_file_get_contents (path, &_tmp0_, NULL, &_inner_error0_);
		_g_free0 (xml_data);
		xml_data = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp1_ = FALSE;
			if (_inner_error0_->domain == G_FILE_ERROR) {
				goto __catch0_g_file_error;
			}
			_g_object_unref0 (parser);
			_g_free0 (xml_data);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp1_;
		}
		_tmp2_ = self->priv->font;
		_tmp3_ = _tmp2_->background_images;
		gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp3_);
		_tmp4_ = self->priv->font;
		_tmp5_ = g_strdup (path);
		_g_free0 (_tmp4_->font_file);
		_tmp4_->font_file = _tmp5_;
		_tmp6_ = b_xml_parser_new (xml_data);
		_g_object_unref0 (parser);
		parser = _tmp6_;
		_tmp7_ = parser;
		ok = bird_font_bird_font_file_load_xml (self, _tmp7_);
	}
	goto __finally0;
	__catch0_g_file_error:
	{
		GError* e = NULL;
		GError* _tmp8_;
		const gchar* _tmp9_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp8_ = e;
		_tmp9_ = _tmp8_->message;
		g_warning ("BirdFontFile.vala:57: %s", _tmp9_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp10_ = FALSE;
		_g_object_unref0 (parser);
		_g_free0 (xml_data);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp10_;
	}
	result = ok;
	_g_object_unref0 (parser);
	_g_free0 (xml_data);
	return result;
}

gboolean
bird_font_bird_font_file_load_part (BirdFontBirdFontFile* self,
                                    const gchar* bfp_file)
{
	gchar* xml_data = NULL;
	BXmlParser* parser = NULL;
	gboolean ok = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (bfp_file != NULL, FALSE);
	ok = FALSE;
	{
		gchar* _tmp0_ = NULL;
		BXmlParser* _tmp2_;
		BXmlParser* _tmp3_;
		g_file_get_contents (bfp_file, &_tmp0_, NULL, &_inner_error0_);
		_g_free0 (xml_data);
		xml_data = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp1_ = FALSE;
			if (_inner_error0_->domain == G_FILE_ERROR) {
				goto __catch0_g_file_error;
			}
			_g_object_unref0 (parser);
			_g_free0 (xml_data);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp1_;
		}
		_tmp2_ = b_xml_parser_new (xml_data);
		_g_object_unref0 (parser);
		parser = _tmp2_;
		_tmp3_ = parser;
		ok = bird_font_bird_font_file_load_xml (self, _tmp3_);
	}
	goto __finally0;
	__catch0_g_file_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_warning ("BirdFontFile.vala:73: %s", _tmp5_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp6_ = FALSE;
		_g_object_unref0 (parser);
		_g_free0 (xml_data);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp6_;
	}
	result = ok;
	_g_object_unref0 (parser);
	_g_free0 (xml_data);
	return result;
}

/** Load a new .bf file.
 * @param xml_data data for a valid .bf file
 */
gboolean
bird_font_bird_font_file_load_data (BirdFontBirdFontFile* self,
                                    const gchar* xml_data)
{
	gboolean ok = FALSE;
	BXmlParser* parser = NULL;
	BirdFontFont* _tmp0_;
	gchar* _tmp1_;
	BXmlParser* _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (xml_data != NULL, FALSE);
	_tmp0_ = self->priv->font;
	_tmp1_ = g_strdup ("typeface.birdfont");
	_g_free0 (_tmp0_->font_file);
	_tmp0_->font_file = _tmp1_;
	_tmp2_ = b_xml_parser_new (xml_data);
	_g_object_unref0 (parser);
	parser = _tmp2_;
	ok = bird_font_bird_font_file_load_xml (self, parser);
	result = ok;
	_g_object_unref0 (parser);
	return result;
}

static gboolean
bird_font_bird_font_file_load_xml (BirdFontBirdFontFile* self,
                                   BXmlParser* parser)
{
	gboolean ok = FALSE;
	BTag* _tmp0_;
	BTag* _tmp1_;
	BTag* _tmp2_;
	BTag* _tmp3_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (parser != NULL, FALSE);
	ok = TRUE;
	_tmp0_ = b_xml_parser_get_root_tag (parser);
	_tmp1_ = _tmp0_;
	bird_font_bird_font_file_create_background_files (self, _tmp1_);
	_g_object_unref0 (_tmp1_);
	_tmp2_ = b_xml_parser_get_root_tag (parser);
	_tmp3_ = _tmp2_;
	ok = bird_font_bird_font_file_parse_file (self, _tmp3_);
	_g_object_unref0 (_tmp3_);
	result = ok;
	return result;
}

static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}

static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		BirdFontBirdFontFile* self;
		self = _data5_->self;
		_g_free0 (_data5_->path);
		_g_object_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}

static Block6Data*
block6_data_ref (Block6Data* _data6_)
{
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}

static void
block6_data_unref (void * _userdata_)
{
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		BirdFontBirdFontFile* self;
		self = _data6_->_data5_->self;
		_g_object_unref0 (_data6_->os);
		block5_data_unref (_data6_->_data5_);
		_data6_->_data5_ = NULL;
		g_slice_free (Block6Data, _data6_);
	}
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static void
___lambda505_ (Block6Data* _data6_,
               BirdFontGlyphCollection* gc)
{
	Block5Data* _data5_;
	BirdFontBirdFontFile* self;
	GError* _inner_error0_ = NULL;
	_data5_ = _data6_->_data5_;
	self = _data5_->self;
	g_return_if_fail (gc != NULL);
	{
		GDataOutputStream* _tmp0_;
		_tmp0_ = _data6_->os;
		bird_font_bird_font_file_write_glyph_collection (self, gc, _tmp0_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_warning ("BirdFontFile.vala:143: %s", _tmp2_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
____lambda505__gfunc (gconstpointer data,
                      gpointer self)
{
	___lambda505_ (self, (BirdFontGlyphCollection*) data);
}

static void
___lambda506_ (Block6Data* _data6_,
               BirdFontGlyphCollection* gc)
{
	Block5Data* _data5_;
	BirdFontBirdFontFile* self;
	BirdFontBackgroundImage* bg = NULL;
	GError* _inner_error0_ = NULL;
	_data5_ = _data6_->_data5_;
	self = _data5_->self;
	g_return_if_fail (gc != NULL);
	{
		gchar* data = NULL;
		{
			GeeArrayList* _g_list = NULL;
			GeeArrayList* _tmp0_;
			gint _g_size = 0;
			GeeArrayList* _tmp1_;
			gint _tmp2_;
			gint _tmp3_;
			gint _g_index = 0;
			_tmp0_ = bird_font_glyph_collection_get_all_glyph_masters (gc);
			_g_list = _tmp0_;
			_tmp1_ = _g_list;
			_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
			_tmp3_ = _tmp2_;
			_g_size = _tmp3_;
			_g_index = -1;
			while (TRUE) {
				gint _tmp4_;
				gint _tmp5_;
				BirdFontGlyph* g = NULL;
				GeeArrayList* _tmp6_;
				gpointer _tmp7_;
				BirdFontGlyph* _tmp8_;
				BirdFontBackgroundImage* _tmp9_;
				BirdFontBackgroundImage* _tmp10_;
				gboolean _tmp11_;
				_g_index = _g_index + 1;
				_tmp4_ = _g_index;
				_tmp5_ = _g_size;
				if (!(_tmp4_ < _tmp5_)) {
					break;
				}
				_tmp6_ = _g_list;
				_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _g_index);
				g = (BirdFontGlyph*) _tmp7_;
				_tmp8_ = g;
				_tmp9_ = bird_font_glyph_get_background_image (_tmp8_);
				_tmp10_ = _tmp9_;
				_tmp11_ = _tmp10_ != NULL;
				_g_object_unref0 (_tmp10_);
				if (_tmp11_) {
					BirdFontGlyph* _tmp12_;
					BirdFontBackgroundImage* _tmp13_;
					BirdFontBackgroundImage* _tmp14_;
					gchar* _tmp15_;
					BirdFontBackgroundImage* _tmp16_;
					GDataOutputStream* _tmp17_;
					BirdFontBackgroundImage* _tmp18_;
					gchar* _tmp19_;
					gchar* _tmp20_;
					const gchar* _tmp21_;
					_tmp12_ = g;
					_tmp13_ = bird_font_glyph_get_background_image (_tmp12_);
					_g_object_unref0 (bg);
					bg = G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, BIRD_FONT_TYPE_BACKGROUND_IMAGE, BirdFontBackgroundImage);
					_tmp14_ = bg;
					_tmp15_ = bird_font_background_image_get_png_base64 (_tmp14_);
					_g_free0 (data);
					data = _tmp15_;
					_tmp16_ = bg;
					if (!bird_font_background_image_is_valid (_tmp16_)) {
						_g_object_unref0 (g);
						continue;
					}
					_tmp17_ = _data6_->os;
					_tmp18_ = bg;
					_tmp19_ = bird_font_background_image_get_sha1 (_tmp18_);
					_tmp20_ = _tmp19_;
					_tmp21_ = data;
					bird_font_bird_font_file_write_image (self, _tmp17_, _tmp20_, _tmp21_, &_inner_error0_);
					_g_free0 (_tmp20_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_object_unref0 (g);
						_g_object_unref0 (_g_list);
						_g_free0 (data);
						goto __catch0_g_error;
					}
				}
				_g_object_unref0 (g);
			}
			_g_object_unref0 (_g_list);
		}
		{
			GeeArrayList* _b_list = NULL;
			BirdFontFont* _tmp22_;
			GeeArrayList* _tmp23_;
			gint _b_size = 0;
			GeeArrayList* _tmp24_;
			gint _tmp25_;
			gint _tmp26_;
			gint _b_index = 0;
			_tmp22_ = self->priv->font;
			_tmp23_ = _tmp22_->background_images;
			_b_list = _tmp23_;
			_tmp24_ = _b_list;
			_tmp25_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp24_);
			_tmp26_ = _tmp25_;
			_b_size = _tmp26_;
			_b_index = -1;
			while (TRUE) {
				gint _tmp27_;
				gint _tmp28_;
				BirdFontBackgroundImage* b = NULL;
				GeeArrayList* _tmp29_;
				gpointer _tmp30_;
				GDataOutputStream* _tmp31_;
				BirdFontBackgroundImage* _tmp32_;
				gchar* _tmp33_;
				gchar* _tmp34_;
				BirdFontBackgroundImage* _tmp35_;
				gchar* _tmp36_;
				gchar* _tmp37_;
				_b_index = _b_index + 1;
				_tmp27_ = _b_index;
				_tmp28_ = _b_size;
				if (!(_tmp27_ < _tmp28_)) {
					break;
				}
				_tmp29_ = _b_list;
				_tmp30_ = gee_abstract_list_get ((GeeAbstractList*) _tmp29_, _b_index);
				b = (BirdFontBackgroundImage*) _tmp30_;
				_tmp31_ = _data6_->os;
				_tmp32_ = b;
				_tmp33_ = bird_font_background_image_get_sha1 (_tmp32_);
				_tmp34_ = _tmp33_;
				_tmp35_ = b;
				_tmp36_ = bird_font_background_image_get_png_base64 (_tmp35_);
				_tmp37_ = _tmp36_;
				bird_font_bird_font_file_write_image (self, _tmp31_, _tmp34_, _tmp37_, &_inner_error0_);
				_g_free0 (_tmp37_);
				_g_free0 (_tmp34_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_object_unref0 (b);
					_g_free0 (data);
					goto __catch0_g_error;
				}
				_g_object_unref0 (b);
			}
		}
		_g_free0 (data);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* ef = NULL;
		const gchar* _tmp38_;
		gchar* _tmp39_;
		gchar* _tmp40_;
		GError* _tmp41_;
		const gchar* _tmp42_;
		const gchar* _tmp43_;
		gchar* _tmp44_;
		gchar* _tmp45_;
		ef = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp38_ = string_to_string (_data5_->path);
		_tmp39_ = g_strconcat ("Failed to save ", _tmp38_, " \n", NULL);
		_tmp40_ = _tmp39_;
		g_warning ("BirdFontFile.vala:176: %s", _tmp40_);
		_g_free0 (_tmp40_);
		_tmp41_ = ef;
		_tmp42_ = _tmp41_->message;
		_tmp43_ = string_to_string (_tmp42_);
		_tmp44_ = g_strconcat (_tmp43_, " \n", NULL);
		_tmp45_ = _tmp44_;
		g_warning ("BirdFontFile.vala:177: %s", _tmp45_);
		_g_free0 (_tmp45_);
		_g_error_free0 (ef);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (bg);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (bg);
}

static void
____lambda506__gfunc (gconstpointer data,
                      gpointer self)
{
	___lambda506_ (self, (BirdFontGlyphCollection*) data);
}

gboolean
bird_font_bird_font_file_write_font_file (BirdFontBirdFontFile* self,
                                          const gchar* path,
                                          gboolean backup)
{
	Block5Data* _data5_;
	gchar* _tmp0_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (path != NULL, FALSE);
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_data5_->self = g_object_ref (self);
	_tmp0_ = g_strdup (path);
	_g_free0 (_data5_->path);
	_data5_->path = _tmp0_;
	{
		Block6Data* _data6_;
		GFile* file = NULL;
		GFile* _tmp1_;
		GFile* _tmp2_;
		GFile* _tmp6_;
		GFileOutputStream* _tmp8_ = NULL;
		GFile* _tmp9_;
		GFileOutputStream* _tmp10_;
		GDataOutputStream* _tmp11_;
		GDataOutputStream* _tmp12_;
		GDataOutputStream* _tmp22_;
		GDataOutputStream* _tmp23_;
		GDataOutputStream* _tmp24_;
		GDataOutputStream* _tmp25_;
		GDataOutputStream* _tmp26_;
		GDataOutputStream* _tmp27_;
		GDataOutputStream* _tmp28_;
		BirdFontFont* _tmp29_;
		BirdFontGlyphTable* _tmp30_;
		GDataOutputStream* _tmp31_;
		GDataOutputStream* _tmp32_;
		GDataOutputStream* _tmp33_;
		GDataOutputStream* _tmp34_;
		BirdFontFont* _tmp35_;
		BirdFontGlyphTable* _tmp36_;
		GDataOutputStream* _tmp37_;
		GDataOutputStream* _tmp38_;
		GDataOutputStream* _tmp39_;
		GDataOutputStream* _tmp40_;
		GDataOutputStream* _tmp41_;
		GDataOutputStream* _tmp42_;
		_data6_ = g_slice_new0 (Block6Data);
		_data6_->_ref_count_ = 1;
		_data6_->_data5_ = block5_data_ref (_data5_);
		_tmp1_ = g_file_new_for_path (_data5_->path);
		_g_object_unref0 (file);
		file = _tmp1_;
		_tmp2_ = file;
		if (g_file_query_file_type (_tmp2_, 0, NULL) == G_FILE_TYPE_DIRECTORY) {
			const gchar* _tmp3_;
			gchar* _tmp4_;
			gchar* _tmp5_;
			_tmp3_ = string_to_string (_data5_->path);
			_tmp4_ = g_strconcat ("Can't save font. ", _tmp3_, " is a directory.", NULL);
			_tmp5_ = _tmp4_;
			g_warning ("BirdFontFile.vala:110: %s", _tmp5_);
			_g_free0 (_tmp5_);
			result = FALSE;
			_g_object_unref0 (file);
			block6_data_unref (_data6_);
			_data6_ = NULL;
			block5_data_unref (_data5_);
			_data5_ = NULL;
			return result;
		}
		_tmp6_ = file;
		if (g_file_query_exists (_tmp6_, NULL)) {
			GFile* _tmp7_;
			_tmp7_ = file;
			g_file_delete (_tmp7_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (file);
				block6_data_unref (_data6_);
				_data6_ = NULL;
				goto __catch0_g_error;
			}
		}
		_tmp9_ = file;
		_tmp10_ = g_file_create (_tmp9_, G_FILE_CREATE_REPLACE_DESTINATION, NULL, &_inner_error0_);
		_tmp8_ = _tmp10_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (file);
			block6_data_unref (_data6_);
			_data6_ = NULL;
			goto __catch0_g_error;
		}
		_tmp11_ = g_data_output_stream_new ((GOutputStream*) _tmp8_);
		_g_object_unref0 (_data6_->os);
		_data6_->os = _tmp11_;
		_tmp12_ = _data6_->os;
		bird_font_bird_font_file_write_root_tag (self, _tmp12_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp8_);
			_g_object_unref0 (file);
			block6_data_unref (_data6_);
			_data6_ = NULL;
			goto __catch0_g_error;
		}
		if (backup) {
			GDataOutputStream* _tmp13_;
			GDataOutputStream* _tmp14_;
			GDataOutputStream* _tmp15_;
			BirdFontFont* _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
			const gchar* _tmp19_;
			gchar* _tmp20_;
			gchar* _tmp21_;
			_tmp13_ = _data6_->os;
			g_data_output_stream_put_string (_tmp13_, "\n", NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (_tmp8_);
				_g_object_unref0 (file);
				block6_data_unref (_data6_);
				_data6_ = NULL;
				goto __catch0_g_error;
			}
			_tmp14_ = _data6_->os;
			g_data_output_stream_put_string (_tmp14_, "<!-- This is a backup of the following font: -->\n", NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (_tmp8_);
				_g_object_unref0 (file);
				block6_data_unref (_data6_);
				_data6_ = NULL;
				goto __catch0_g_error;
			}
			_tmp15_ = _data6_->os;
			_tmp16_ = self->priv->font;
			_tmp17_ = bird_font_font_get_path (_tmp16_);
			_tmp18_ = (gchar*) _tmp17_;
			_tmp19_ = string_to_string (_tmp18_);
			_tmp20_ = g_strconcat ("<backup>", _tmp19_, "</backup>\n", NULL);
			_tmp21_ = _tmp20_;
			g_data_output_stream_put_string (_tmp15_, _tmp21_, NULL, &_inner_error0_);
			_g_free0 (_tmp21_);
			_g_free0 (_tmp18_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (_tmp8_);
				_g_object_unref0 (file);
				block6_data_unref (_data6_);
				_data6_ = NULL;
				goto __catch0_g_error;
			}
		}
		_tmp22_ = _data6_->os;
		g_data_output_stream_put_string (_tmp22_, "\n", NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp8_);
			_g_object_unref0 (file);
			block6_data_unref (_data6_);
			_data6_ = NULL;
			goto __catch0_g_error;
		}
		_tmp23_ = _data6_->os;
		bird_font_bird_font_file_write_description (self, _tmp23_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp8_);
			_g_object_unref0 (file);
			block6_data_unref (_data6_);
			_data6_ = NULL;
			goto __catch0_g_error;
		}
		_tmp24_ = _data6_->os;
		g_data_output_stream_put_string (_tmp24_, "\n", NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp8_);
			_g_object_unref0 (file);
			block6_data_unref (_data6_);
			_data6_ = NULL;
			goto __catch0_g_error;
		}
		_tmp25_ = _data6_->os;
		bird_font_bird_font_file_write_lines (self, _tmp25_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp8_);
			_g_object_unref0 (file);
			block6_data_unref (_data6_);
			_data6_ = NULL;
			goto __catch0_g_error;
		}
		_tmp26_ = _data6_->os;
		g_data_output_stream_put_string (_tmp26_, "\n", NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp8_);
			_g_object_unref0 (file);
			block6_data_unref (_data6_);
			_data6_ = NULL;
			goto __catch0_g_error;
		}
		_tmp27_ = _data6_->os;
		bird_font_bird_font_file_write_settings (self, _tmp27_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp8_);
			_g_object_unref0 (file);
			block6_data_unref (_data6_);
			_data6_ = NULL;
			goto __catch0_g_error;
		}
		_tmp28_ = _data6_->os;
		g_data_output_stream_put_string (_tmp28_, "\n", NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp8_);
			_g_object_unref0 (file);
			block6_data_unref (_data6_);
			_data6_ = NULL;
			goto __catch0_g_error;
		}
		_tmp29_ = self->priv->font;
		_tmp30_ = _tmp29_->glyph_cache;
		bird_font_glyph_table_for_each (_tmp30_, ____lambda505__gfunc, _data6_);
		_tmp31_ = _data6_->os;
		g_data_output_stream_put_string (_tmp31_, "\n", NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp8_);
			_g_object_unref0 (file);
			block6_data_unref (_data6_);
			_data6_ = NULL;
			goto __catch0_g_error;
		}
		_tmp32_ = _data6_->os;
		bird_font_bird_font_file_write_images (self, _tmp32_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp8_);
			_g_object_unref0 (file);
			block6_data_unref (_data6_);
			_data6_ = NULL;
			goto __catch0_g_error;
		}
		_tmp33_ = _data6_->os;
		g_data_output_stream_put_string (_tmp33_, "\n", NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp8_);
			_g_object_unref0 (file);
			block6_data_unref (_data6_);
			_data6_ = NULL;
			goto __catch0_g_error;
		}
		_tmp34_ = _data6_->os;
		bird_font_bird_font_file_write_ligatures (self, _tmp34_);
		_tmp35_ = self->priv->font;
		_tmp36_ = _tmp35_->glyph_cache;
		bird_font_glyph_table_for_each (_tmp36_, ____lambda506__gfunc, _data6_);
		_tmp37_ = _data6_->os;
		g_data_output_stream_put_string (_tmp37_, "\n", NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp8_);
			_g_object_unref0 (file);
			block6_data_unref (_data6_);
			_data6_ = NULL;
			goto __catch0_g_error;
		}
		_tmp38_ = _data6_->os;
		bird_font_bird_font_file_write_spacing_classes (self, _tmp38_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp8_);
			_g_object_unref0 (file);
			block6_data_unref (_data6_);
			_data6_ = NULL;
			goto __catch0_g_error;
		}
		_tmp39_ = _data6_->os;
		bird_font_bird_font_file_write_alternates (self, _tmp39_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp8_);
			_g_object_unref0 (file);
			block6_data_unref (_data6_);
			_data6_ = NULL;
			goto __catch0_g_error;
		}
		_tmp40_ = _data6_->os;
		bird_font_bird_font_file_write_kerning (self, _tmp40_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp8_);
			_g_object_unref0 (file);
			block6_data_unref (_data6_);
			_data6_ = NULL;
			goto __catch0_g_error;
		}
		_tmp41_ = _data6_->os;
		bird_font_bird_font_file_write_closing_root_tag (self, _tmp41_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp8_);
			_g_object_unref0 (file);
			block6_data_unref (_data6_);
			_data6_ = NULL;
			goto __catch0_g_error;
		}
		_tmp42_ = _data6_->os;
		g_output_stream_close ((GOutputStream*) _tmp42_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp8_);
			_g_object_unref0 (file);
			block6_data_unref (_data6_);
			_data6_ = NULL;
			goto __catch0_g_error;
		}
		_g_object_unref0 (_tmp8_);
		_g_object_unref0 (file);
		block6_data_unref (_data6_);
		_data6_ = NULL;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp43_;
		gchar* _tmp44_;
		gchar* _tmp45_;
		GError* _tmp46_;
		const gchar* _tmp47_;
		const gchar* _tmp48_;
		gchar* _tmp49_;
		gchar* _tmp50_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp43_ = string_to_string (_data5_->path);
		_tmp44_ = g_strconcat ("Failed to save ", _tmp43_, " \n", NULL);
		_tmp45_ = _tmp44_;
		g_warning ("BirdFontFile.vala:189: %s", _tmp45_);
		_g_free0 (_tmp45_);
		_tmp46_ = e;
		_tmp47_ = _tmp46_->message;
		_tmp48_ = string_to_string (_tmp47_);
		_tmp49_ = g_strconcat (_tmp48_, " \n", NULL);
		_tmp50_ = _tmp49_;
		g_warning ("BirdFontFile.vala:190: %s", _tmp50_);
		_g_free0 (_tmp50_);
		result = FALSE;
		_g_error_free0 (e);
		block5_data_unref (_data5_);
		_data5_ = NULL;
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp51_ = FALSE;
		block5_data_unref (_data5_);
		_data5_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp51_;
	}
	result = TRUE;
	block5_data_unref (_data5_);
	_data5_ = NULL;
	return result;
}

void
bird_font_bird_font_file_write_alternates (BirdFontBirdFontFile* self,
                                           GDataOutputStream* os,
                                           GError** error)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (os != NULL);
	{
		GeeArrayList* _alternate_list = NULL;
		BirdFontFont* _tmp0_;
		BirdFontAlternateSets* _tmp1_;
		GeeArrayList* _tmp2_;
		gint _alternate_size = 0;
		GeeArrayList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _alternate_index = 0;
		_tmp0_ = self->priv->font;
		_tmp1_ = _tmp0_->alternates;
		_tmp2_ = _tmp1_->alternates;
		_alternate_list = _tmp2_;
		_tmp3_ = _alternate_list;
		_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_alternate_size = _tmp5_;
		_alternate_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			BirdFontAlternate* alternate = NULL;
			GeeArrayList* _tmp8_;
			gpointer _tmp9_;
			gchar* glyph_name = NULL;
			BirdFontAlternate* _tmp10_;
			const gchar* _tmp11_;
			gchar* _tmp12_;
			gchar* tag = NULL;
			BirdFontAlternate* _tmp13_;
			const gchar* _tmp14_;
			gchar* _tmp15_;
			_alternate_index = _alternate_index + 1;
			_tmp6_ = _alternate_index;
			_tmp7_ = _alternate_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _alternate_list;
			_tmp9_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _alternate_index);
			alternate = (BirdFontAlternate*) _tmp9_;
			_tmp10_ = alternate;
			_tmp11_ = _tmp10_->glyph_name;
			_tmp12_ = g_strdup (_tmp11_);
			glyph_name = _tmp12_;
			_tmp13_ = alternate;
			_tmp14_ = _tmp13_->tag;
			_tmp15_ = g_strdup (_tmp14_);
			tag = _tmp15_;
			{
				GeeArrayList* _alt_list = NULL;
				BirdFontAlternate* _tmp16_;
				GeeArrayList* _tmp17_;
				gint _alt_size = 0;
				GeeArrayList* _tmp18_;
				gint _tmp19_;
				gint _tmp20_;
				gint _alt_index = 0;
				_tmp16_ = alternate;
				_tmp17_ = _tmp16_->alternates;
				_alt_list = _tmp17_;
				_tmp18_ = _alt_list;
				_tmp19_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp18_);
				_tmp20_ = _tmp19_;
				_alt_size = _tmp20_;
				_alt_index = -1;
				while (TRUE) {
					gint _tmp21_;
					gint _tmp22_;
					gchar* alt = NULL;
					GeeArrayList* _tmp23_;
					gpointer _tmp24_;
					const gchar* _tmp25_;
					gchar* _tmp26_;
					gchar* _tmp27_;
					const gchar* _tmp28_;
					gchar* _tmp29_;
					gchar* _tmp30_;
					const gchar* _tmp31_;
					gchar* _tmp32_;
					gchar* _tmp33_;
					const gchar* _tmp34_;
					gchar* _tmp35_;
					gchar* _tmp36_;
					const gchar* _tmp37_;
					const gchar* _tmp38_;
					gchar* _tmp39_;
					gchar* _tmp40_;
					_alt_index = _alt_index + 1;
					_tmp21_ = _alt_index;
					_tmp22_ = _alt_size;
					if (!(_tmp21_ < _tmp22_)) {
						break;
					}
					_tmp23_ = _alt_list;
					_tmp24_ = gee_abstract_list_get ((GeeAbstractList*) _tmp23_, _alt_index);
					alt = (gchar*) _tmp24_;
					g_data_output_stream_put_string (os, "<alternate ", NULL, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						g_propagate_error (error, _inner_error0_);
						_g_free0 (alt);
						_g_free0 (tag);
						_g_free0 (glyph_name);
						_g_object_unref0 (alternate);
						return;
					}
					_tmp25_ = glyph_name;
					_tmp26_ = bird_font_bird_font_file_encode (_tmp25_);
					_tmp27_ = _tmp26_;
					_tmp28_ = string_to_string (_tmp27_);
					_tmp29_ = g_strconcat ("glyph=\"", _tmp28_, "\" ", NULL);
					_tmp30_ = _tmp29_;
					g_data_output_stream_put_string (os, _tmp30_, NULL, &_inner_error0_);
					_g_free0 (_tmp30_);
					_g_free0 (_tmp27_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						g_propagate_error (error, _inner_error0_);
						_g_free0 (alt);
						_g_free0 (tag);
						_g_free0 (glyph_name);
						_g_object_unref0 (alternate);
						return;
					}
					_tmp31_ = alt;
					_tmp32_ = bird_font_bird_font_file_encode (_tmp31_);
					_tmp33_ = _tmp32_;
					_tmp34_ = string_to_string (_tmp33_);
					_tmp35_ = g_strconcat ("replacement=\"", _tmp34_, "\" ", NULL);
					_tmp36_ = _tmp35_;
					g_data_output_stream_put_string (os, _tmp36_, NULL, &_inner_error0_);
					_g_free0 (_tmp36_);
					_g_free0 (_tmp33_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						g_propagate_error (error, _inner_error0_);
						_g_free0 (alt);
						_g_free0 (tag);
						_g_free0 (glyph_name);
						_g_object_unref0 (alternate);
						return;
					}
					_tmp37_ = tag;
					_tmp38_ = string_to_string (_tmp37_);
					_tmp39_ = g_strconcat ("tag=\"", _tmp38_, "\" />\n", NULL);
					_tmp40_ = _tmp39_;
					g_data_output_stream_put_string (os, _tmp40_, NULL, &_inner_error0_);
					_g_free0 (_tmp40_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						g_propagate_error (error, _inner_error0_);
						_g_free0 (alt);
						_g_free0 (tag);
						_g_free0 (glyph_name);
						_g_object_unref0 (alternate);
						return;
					}
					_g_free0 (alt);
				}
			}
			_g_free0 (tag);
			_g_free0 (glyph_name);
			_g_object_unref0 (alternate);
		}
	}
}

static gchar*
double_to_string (gdouble self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint _tmp1__length1;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* result;
	_tmp0_ = g_new0 (gchar, G_ASCII_DTOSTR_BUF_SIZE);
	_tmp1_ = _tmp0_;
	_tmp1__length1 = G_ASCII_DTOSTR_BUF_SIZE;
	_tmp2_ = g_ascii_dtostr (_tmp1_, (gint) G_ASCII_DTOSTR_BUF_SIZE, self);
	_tmp3_ = g_strdup (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp1_ = (g_free (_tmp1_), NULL);
	result = _tmp4_;
	return result;
}

void
bird_font_bird_font_file_write_images (BirdFontBirdFontFile* self,
                                       GDataOutputStream* os,
                                       GError** error)
{
	gchar* glyph_name = NULL;
	BirdFontFont* _tmp0_;
	GeeArrayList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (os != NULL);
	_tmp0_ = self->priv->font;
	_tmp1_ = _tmp0_->background_images;
	_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ > 0) {
		g_data_output_stream_put_string (os, "<images>\n", NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (glyph_name);
			return;
		}
		{
			GeeArrayList* _b_list = NULL;
			BirdFontFont* _tmp4_;
			GeeArrayList* _tmp5_;
			gint _b_size = 0;
			GeeArrayList* _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			gint _b_index = 0;
			_tmp4_ = self->priv->font;
			_tmp5_ = _tmp4_->background_images;
			_b_list = _tmp5_;
			_tmp6_ = _b_list;
			_tmp7_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp6_);
			_tmp8_ = _tmp7_;
			_b_size = _tmp8_;
			_b_index = -1;
			while (TRUE) {
				gint _tmp9_;
				gint _tmp10_;
				BirdFontBackgroundImage* b = NULL;
				GeeArrayList* _tmp11_;
				gpointer _tmp12_;
				BirdFontBackgroundImage* _tmp13_;
				const gchar* _tmp14_;
				BirdFontBackgroundImage* _tmp15_;
				const gchar* _tmp16_;
				const gchar* _tmp17_;
				gchar* _tmp18_;
				gchar* _tmp19_;
				BirdFontBackgroundImage* _tmp20_;
				gchar* _tmp21_;
				gchar* _tmp22_;
				const gchar* _tmp23_;
				gchar* _tmp24_;
				gchar* _tmp25_;
				BirdFontBackgroundImage* _tmp26_;
				gchar* _tmp27_;
				gchar* _tmp28_;
				gchar* _tmp29_;
				gchar* _tmp30_;
				BirdFontBackgroundImage* _tmp31_;
				gchar* _tmp32_;
				gchar* _tmp33_;
				gchar* _tmp34_;
				gchar* _tmp35_;
				BirdFontBackgroundImage* _tmp36_;
				gdouble _tmp37_;
				gdouble _tmp38_;
				gchar* _tmp39_;
				gchar* _tmp40_;
				const gchar* _tmp41_;
				gchar* _tmp42_;
				gchar* _tmp43_;
				BirdFontBackgroundImage* _tmp44_;
				gdouble _tmp45_;
				gdouble _tmp46_;
				gchar* _tmp47_;
				gchar* _tmp48_;
				const gchar* _tmp49_;
				gchar* _tmp50_;
				gchar* _tmp51_;
				BirdFontBackgroundImage* _tmp52_;
				gchar* _tmp53_;
				gchar* _tmp54_;
				const gchar* _tmp55_;
				gchar* _tmp56_;
				gchar* _tmp57_;
				_b_index = _b_index + 1;
				_tmp9_ = _b_index;
				_tmp10_ = _b_size;
				if (!(_tmp9_ < _tmp10_)) {
					break;
				}
				_tmp11_ = _b_list;
				_tmp12_ = gee_abstract_list_get ((GeeAbstractList*) _tmp11_, _b_index);
				b = (BirdFontBackgroundImage*) _tmp12_;
				_tmp13_ = b;
				_tmp14_ = _tmp13_->name;
				if (g_strcmp0 (_tmp14_, "") == 0) {
					g_warning ("BirdFontFile.vala:220: No name.");
				}
				g_data_output_stream_put_string (os, "\t<image ", NULL, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_propagate_error (error, _inner_error0_);
					_g_object_unref0 (b);
					_g_free0 (glyph_name);
					return;
				}
				_tmp15_ = b;
				_tmp16_ = _tmp15_->name;
				_tmp17_ = string_to_string (_tmp16_);
				_tmp18_ = g_strconcat ("name=\"", _tmp17_, "\" ", NULL);
				_tmp19_ = _tmp18_;
				g_data_output_stream_put_string (os, _tmp19_, NULL, &_inner_error0_);
				_g_free0 (_tmp19_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_propagate_error (error, _inner_error0_);
					_g_object_unref0 (b);
					_g_free0 (glyph_name);
					return;
				}
				_tmp20_ = b;
				_tmp21_ = bird_font_background_image_get_sha1 (_tmp20_);
				_tmp22_ = _tmp21_;
				_tmp23_ = string_to_string (_tmp22_);
				_tmp24_ = g_strconcat ("sha1=\"", _tmp23_, "\" ", NULL);
				_tmp25_ = _tmp24_;
				g_data_output_stream_put_string (os, _tmp25_, NULL, &_inner_error0_);
				_g_free0 (_tmp25_);
				_g_free0 (_tmp22_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_propagate_error (error, _inner_error0_);
					_g_object_unref0 (b);
					_g_free0 (glyph_name);
					return;
				}
				_tmp26_ = b;
				_tmp27_ = double_to_string (_tmp26_->img_x);
				_tmp28_ = _tmp27_;
				_tmp29_ = g_strconcat ("x=\"", _tmp28_, "\" ", NULL);
				_tmp30_ = _tmp29_;
				g_data_output_stream_put_string (os, _tmp30_, NULL, &_inner_error0_);
				_g_free0 (_tmp30_);
				_g_free0 (_tmp28_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_propagate_error (error, _inner_error0_);
					_g_object_unref0 (b);
					_g_free0 (glyph_name);
					return;
				}
				_tmp31_ = b;
				_tmp32_ = double_to_string (_tmp31_->img_y);
				_tmp33_ = _tmp32_;
				_tmp34_ = g_strconcat ("y=\"", _tmp33_, "\" ", NULL);
				_tmp35_ = _tmp34_;
				g_data_output_stream_put_string (os, _tmp35_, NULL, &_inner_error0_);
				_g_free0 (_tmp35_);
				_g_free0 (_tmp33_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_propagate_error (error, _inner_error0_);
					_g_object_unref0 (b);
					_g_free0 (glyph_name);
					return;
				}
				_tmp36_ = b;
				_tmp37_ = bird_font_background_image_get_img_scale_x (_tmp36_);
				_tmp38_ = _tmp37_;
				_tmp39_ = bird_font_bird_font_file_round (_tmp38_, 5);
				_tmp40_ = _tmp39_;
				_tmp41_ = string_to_string (_tmp40_);
				_tmp42_ = g_strconcat ("scale_x=\"", _tmp41_, "\" ", NULL);
				_tmp43_ = _tmp42_;
				g_data_output_stream_put_string (os, _tmp43_, NULL, &_inner_error0_);
				_g_free0 (_tmp43_);
				_g_free0 (_tmp40_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_propagate_error (error, _inner_error0_);
					_g_object_unref0 (b);
					_g_free0 (glyph_name);
					return;
				}
				_tmp44_ = b;
				_tmp45_ = bird_font_background_image_get_img_scale_y (_tmp44_);
				_tmp46_ = _tmp45_;
				_tmp47_ = bird_font_bird_font_file_round (_tmp46_, 5);
				_tmp48_ = _tmp47_;
				_tmp49_ = string_to_string (_tmp48_);
				_tmp50_ = g_strconcat ("scale_y=\"", _tmp49_, "\" ", NULL);
				_tmp51_ = _tmp50_;
				g_data_output_stream_put_string (os, _tmp51_, NULL, &_inner_error0_);
				_g_free0 (_tmp51_);
				_g_free0 (_tmp48_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_propagate_error (error, _inner_error0_);
					_g_object_unref0 (b);
					_g_free0 (glyph_name);
					return;
				}
				_tmp52_ = b;
				_tmp53_ = bird_font_bird_font_file_round (_tmp52_->img_rotation, 5);
				_tmp54_ = _tmp53_;
				_tmp55_ = string_to_string (_tmp54_);
				_tmp56_ = g_strconcat ("rotation=\"", _tmp55_, "\" ", NULL);
				_tmp57_ = _tmp56_;
				g_data_output_stream_put_string (os, _tmp57_, NULL, &_inner_error0_);
				_g_free0 (_tmp57_);
				_g_free0 (_tmp54_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_propagate_error (error, _inner_error0_);
					_g_object_unref0 (b);
					_g_free0 (glyph_name);
					return;
				}
				g_data_output_stream_put_string (os, ">\n", NULL, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_propagate_error (error, _inner_error0_);
					_g_object_unref0 (b);
					_g_free0 (glyph_name);
					return;
				}
				{
					GeeArrayList* _selection_list = NULL;
					BirdFontBackgroundImage* _tmp58_;
					GeeArrayList* _tmp59_;
					gint _selection_size = 0;
					GeeArrayList* _tmp60_;
					gint _tmp61_;
					gint _tmp62_;
					gint _selection_index = 0;
					_tmp58_ = b;
					_tmp59_ = _tmp58_->selections;
					_selection_list = _tmp59_;
					_tmp60_ = _selection_list;
					_tmp61_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp60_);
					_tmp62_ = _tmp61_;
					_selection_size = _tmp62_;
					_selection_index = -1;
					while (TRUE) {
						gint _tmp63_;
						gint _tmp64_;
						BirdFontBackgroundSelection* selection = NULL;
						GeeArrayList* _tmp65_;
						gpointer _tmp66_;
						BirdFontBackgroundSelection* _tmp67_;
						gchar* _tmp68_;
						gchar* _tmp69_;
						gchar* _tmp70_;
						gchar* _tmp71_;
						BirdFontBackgroundSelection* _tmp72_;
						gchar* _tmp73_;
						gchar* _tmp74_;
						gchar* _tmp75_;
						gchar* _tmp76_;
						BirdFontBackgroundSelection* _tmp77_;
						gchar* _tmp78_;
						gchar* _tmp79_;
						gchar* _tmp80_;
						gchar* _tmp81_;
						BirdFontBackgroundSelection* _tmp82_;
						gchar* _tmp83_;
						gchar* _tmp84_;
						gchar* _tmp85_;
						gchar* _tmp86_;
						BirdFontBackgroundSelection* _tmp87_;
						const gchar* _tmp88_;
						_selection_index = _selection_index + 1;
						_tmp63_ = _selection_index;
						_tmp64_ = _selection_size;
						if (!(_tmp63_ < _tmp64_)) {
							break;
						}
						_tmp65_ = _selection_list;
						_tmp66_ = gee_abstract_list_get ((GeeAbstractList*) _tmp65_, _selection_index);
						selection = (BirdFontBackgroundSelection*) _tmp66_;
						g_data_output_stream_put_string (os, "\t\t<selection ", NULL, &_inner_error0_);
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							g_propagate_error (error, _inner_error0_);
							_g_object_unref0 (selection);
							_g_object_unref0 (b);
							_g_free0 (glyph_name);
							return;
						}
						_tmp67_ = selection;
						_tmp68_ = double_to_string (_tmp67_->x_img);
						_tmp69_ = _tmp68_;
						_tmp70_ = g_strconcat ("x=\"", _tmp69_, "\" ", NULL);
						_tmp71_ = _tmp70_;
						g_data_output_stream_put_string (os, _tmp71_, NULL, &_inner_error0_);
						_g_free0 (_tmp71_);
						_g_free0 (_tmp69_);
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							g_propagate_error (error, _inner_error0_);
							_g_object_unref0 (selection);
							_g_object_unref0 (b);
							_g_free0 (glyph_name);
							return;
						}
						_tmp72_ = selection;
						_tmp73_ = double_to_string (_tmp72_->y_img);
						_tmp74_ = _tmp73_;
						_tmp75_ = g_strconcat ("y=\"", _tmp74_, "\" ", NULL);
						_tmp76_ = _tmp75_;
						g_data_output_stream_put_string (os, _tmp76_, NULL, &_inner_error0_);
						_g_free0 (_tmp76_);
						_g_free0 (_tmp74_);
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							g_propagate_error (error, _inner_error0_);
							_g_object_unref0 (selection);
							_g_object_unref0 (b);
							_g_free0 (glyph_name);
							return;
						}
						_tmp77_ = selection;
						_tmp78_ = double_to_string (_tmp77_->width);
						_tmp79_ = _tmp78_;
						_tmp80_ = g_strconcat ("width=\"", _tmp79_, "\" ", NULL);
						_tmp81_ = _tmp80_;
						g_data_output_stream_put_string (os, _tmp81_, NULL, &_inner_error0_);
						_g_free0 (_tmp81_);
						_g_free0 (_tmp79_);
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							g_propagate_error (error, _inner_error0_);
							_g_object_unref0 (selection);
							_g_object_unref0 (b);
							_g_free0 (glyph_name);
							return;
						}
						_tmp82_ = selection;
						_tmp83_ = double_to_string (_tmp82_->height);
						_tmp84_ = _tmp83_;
						_tmp85_ = g_strconcat ("height=\"", _tmp84_, "\" ", NULL);
						_tmp86_ = _tmp85_;
						g_data_output_stream_put_string (os, _tmp86_, NULL, &_inner_error0_);
						_g_free0 (_tmp86_);
						_g_free0 (_tmp84_);
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							g_propagate_error (error, _inner_error0_);
							_g_object_unref0 (selection);
							_g_object_unref0 (b);
							_g_free0 (glyph_name);
							return;
						}
						_tmp87_ = selection;
						_tmp88_ = _tmp87_->assigned_glyph;
						if (_tmp88_ != NULL) {
							BirdFontBackgroundSelection* _tmp89_;
							const gchar* _tmp90_;
							gchar* _tmp91_;
							const gchar* _tmp92_;
							const gchar* _tmp93_;
							gchar* _tmp94_;
							gchar* _tmp95_;
							_tmp89_ = selection;
							_tmp90_ = _tmp89_->assigned_glyph;
							_tmp91_ = g_strdup ((const gchar*) _tmp90_);
							_g_free0 (glyph_name);
							glyph_name = _tmp91_;
							_tmp92_ = glyph_name;
							_tmp93_ = string_to_string (_tmp92_);
							_tmp94_ = g_strconcat ("glyph=\"", _tmp93_, "\" ", NULL);
							_tmp95_ = _tmp94_;
							g_data_output_stream_put_string (os, _tmp95_, NULL, &_inner_error0_);
							_g_free0 (_tmp95_);
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
								g_propagate_error (error, _inner_error0_);
								_g_object_unref0 (selection);
								_g_object_unref0 (b);
								_g_free0 (glyph_name);
								return;
							}
						}
						g_data_output_stream_put_string (os, "/>\n", NULL, &_inner_error0_);
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							g_propagate_error (error, _inner_error0_);
							_g_object_unref0 (selection);
							_g_object_unref0 (b);
							_g_free0 (glyph_name);
							return;
						}
						_g_object_unref0 (selection);
					}
				}
				g_data_output_stream_put_string (os, "\t</image>\n", NULL, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_propagate_error (error, _inner_error0_);
					_g_object_unref0 (b);
					_g_free0 (glyph_name);
					return;
				}
				_g_object_unref0 (b);
			}
		}
		g_data_output_stream_put_string (os, "</images>\n", NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (glyph_name);
			return;
		}
		g_data_output_stream_put_string (os, "\n", NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (glyph_name);
			return;
		}
	}
	_g_free0 (glyph_name);
}

void
bird_font_bird_font_file_write_image (BirdFontBirdFontFile* self,
                                      GDataOutputStream* os,
                                      const gchar* sha1,
                                      const gchar* data,
                                      GError** error)
{
	GeeArrayList* _tmp0_;
	gboolean _tmp3_ = FALSE;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (os != NULL);
	g_return_if_fail (sha1 != NULL);
	g_return_if_fail (data != NULL);
	_tmp0_ = self->priv->written_images;
	if (gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp0_, sha1)) {
		gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = g_strconcat ("Font file already contains ", sha1, NULL);
		_tmp2_ = _tmp1_;
		g_warning ("BirdFontFile.vala:258: %s", _tmp2_);
		_g_free0 (_tmp2_);
		return;
	}
	if (g_strcmp0 (sha1, "") == 0) {
		_tmp3_ = TRUE;
	} else {
		_tmp3_ = g_strcmp0 (data, "") == 0;
	}
	if (_tmp3_) {
		g_warning ("BirdFontFile.vala:263: No data in background image.");
		return;
	}
	g_data_output_stream_put_string (os, "<background-image sha1=\"", NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	g_data_output_stream_put_string (os, sha1, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	g_data_output_stream_put_string (os, "\" ", NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	g_data_output_stream_put_string (os, " data=\"", NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	g_data_output_stream_put_string (os, data, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	g_data_output_stream_put_string (os, "\" />\n", NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

void
bird_font_bird_font_file_write_root_tag (BirdFontBirdFontFile* self,
                                         GDataOutputStream* os,
                                         GError** error)
{
	gchar* program_version = NULL;
	gchar* _tmp0_;
	gchar* operating_system = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (os != NULL);
	_tmp0_ = bird_font_get_version ();
	program_version = _tmp0_;
	_tmp1_ = bird_font_get_os ();
	operating_system = _tmp1_;
	g_data_output_stream_put_string (os, "<?xml version=\"1.0\" encoding=\"utf-8\" standalone=\"yes\"?>", NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (operating_system);
		_g_free0 (program_version);
		return;
	}
	g_data_output_stream_put_string (os, "\n", NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (operating_system);
		_g_free0 (program_version);
		return;
	}
	g_data_output_stream_put_string (os, "<font>\n", NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (operating_system);
		_g_free0 (program_version);
		return;
	}
	_tmp2_ = g_strdup_printf ("%i", BIRD_FONT_BIRD_FONT_FILE_FORMAT_MAJOR);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup_printf ("%i", BIRD_FONT_BIRD_FONT_FILE_FORMAT_MINOR);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strconcat ("<format>", _tmp3_, ".", _tmp5_, "</format>\n", NULL);
	_tmp7_ = _tmp6_;
	g_data_output_stream_put_string (os, _tmp7_, NULL, &_inner_error0_);
	_g_free0 (_tmp7_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (operating_system);
		_g_free0 (program_version);
		return;
	}
	_tmp8_ = program_version;
	_tmp9_ = string_to_string (_tmp8_);
	_tmp10_ = operating_system;
	_tmp11_ = string_to_string (_tmp10_);
	_tmp12_ = g_strconcat ("<program version=\"", _tmp9_, "\" os=\"", _tmp11_, "\" />\n", NULL);
	_tmp13_ = _tmp12_;
	g_data_output_stream_put_string (os, _tmp13_, NULL, &_inner_error0_);
	_g_free0 (_tmp13_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (operating_system);
		_g_free0 (program_version);
		return;
	}
	_g_free0 (operating_system);
	_g_free0 (program_version);
}

void
bird_font_bird_font_file_write_closing_root_tag (BirdFontBirdFontFile* self,
                                                 GDataOutputStream* os,
                                                 GError** error)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (os != NULL);
	g_data_output_stream_put_string (os, "</font>\n", NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

static gunichar
string_get_char (const gchar* self,
                 glong index)
{
	gunichar result;
	g_return_val_if_fail (self != NULL, 0U);
	result = g_utf8_get_char (((gchar*) self) + index);
	return result;
}

void
bird_font_bird_font_file_write_spacing_classes (BirdFontBirdFontFile* self,
                                                GDataOutputStream* os,
                                                GError** error)
{
	BirdFontSpacingData* s = NULL;
	BirdFontFont* _tmp0_;
	BirdFontSpacingData* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (os != NULL);
	_tmp0_ = self->priv->font;
	_tmp1_ = bird_font_font_get_spacing (_tmp0_);
	s = _tmp1_;
	{
		GeeArrayList* _sc_list = NULL;
		BirdFontSpacingData* _tmp2_;
		GeeArrayList* _tmp3_;
		gint _sc_size = 0;
		GeeArrayList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _sc_index = 0;
		_tmp2_ = s;
		_tmp3_ = _tmp2_->classes;
		_sc_list = _tmp3_;
		_tmp4_ = _sc_list;
		_tmp5_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_sc_size = _tmp6_;
		_sc_index = -1;
		while (TRUE) {
			gint _tmp7_;
			gint _tmp8_;
			BirdFontSpacingClass* sc = NULL;
			GeeArrayList* _tmp9_;
			gpointer _tmp10_;
			BirdFontSpacingClass* _tmp11_;
			const gchar* _tmp12_;
			BirdFontSpacingClass* _tmp21_;
			const gchar* _tmp22_;
			_sc_index = _sc_index + 1;
			_tmp7_ = _sc_index;
			_tmp8_ = _sc_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _sc_list;
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp9_, _sc_index);
			sc = (BirdFontSpacingClass*) _tmp10_;
			g_data_output_stream_put_string (os, "<spacing ", NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (sc);
				_g_object_unref0 (s);
				return;
			}
			g_data_output_stream_put_string (os, "first=\"", NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (sc);
				_g_object_unref0 (s);
				return;
			}
			_tmp11_ = sc;
			_tmp12_ = _tmp11_->first;
			if (g_utf8_strlen (_tmp12_, (gssize) -1) == 1) {
				BirdFontSpacingClass* _tmp13_;
				const gchar* _tmp14_;
				gchar* _tmp15_;
				gchar* _tmp16_;
				_tmp13_ = sc;
				_tmp14_ = _tmp13_->first;
				_tmp15_ = bird_font_font_to_hex (string_get_char (_tmp14_, (glong) 0));
				_tmp16_ = _tmp15_;
				g_data_output_stream_put_string (os, _tmp16_, NULL, &_inner_error0_);
				_g_free0 (_tmp16_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_propagate_error (error, _inner_error0_);
					_g_object_unref0 (sc);
					_g_object_unref0 (s);
					return;
				}
			} else {
				BirdFontSpacingClass* _tmp17_;
				const gchar* _tmp18_;
				gchar* _tmp19_;
				gchar* _tmp20_;
				g_data_output_stream_put_string (os, "name:", NULL, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_propagate_error (error, _inner_error0_);
					_g_object_unref0 (sc);
					_g_object_unref0 (s);
					return;
				}
				_tmp17_ = sc;
				_tmp18_ = _tmp17_->first;
				_tmp19_ = bird_font_bird_font_file_encode (_tmp18_);
				_tmp20_ = _tmp19_;
				g_data_output_stream_put_string (os, _tmp20_, NULL, &_inner_error0_);
				_g_free0 (_tmp20_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_propagate_error (error, _inner_error0_);
					_g_object_unref0 (sc);
					_g_object_unref0 (s);
					return;
				}
			}
			g_data_output_stream_put_string (os, "\" ", NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (sc);
				_g_object_unref0 (s);
				return;
			}
			g_data_output_stream_put_string (os, "next=\"", NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (sc);
				_g_object_unref0 (s);
				return;
			}
			_tmp21_ = sc;
			_tmp22_ = _tmp21_->next;
			if (g_utf8_strlen (_tmp22_, (gssize) -1) == 1) {
				BirdFontSpacingClass* _tmp23_;
				const gchar* _tmp24_;
				gchar* _tmp25_;
				gchar* _tmp26_;
				_tmp23_ = sc;
				_tmp24_ = _tmp23_->next;
				_tmp25_ = bird_font_font_to_hex (string_get_char (_tmp24_, (glong) 0));
				_tmp26_ = _tmp25_;
				g_data_output_stream_put_string (os, _tmp26_, NULL, &_inner_error0_);
				_g_free0 (_tmp26_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_propagate_error (error, _inner_error0_);
					_g_object_unref0 (sc);
					_g_object_unref0 (s);
					return;
				}
			} else {
				BirdFontSpacingClass* _tmp27_;
				const gchar* _tmp28_;
				gchar* _tmp29_;
				gchar* _tmp30_;
				g_data_output_stream_put_string (os, "name:", NULL, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_propagate_error (error, _inner_error0_);
					_g_object_unref0 (sc);
					_g_object_unref0 (s);
					return;
				}
				_tmp27_ = sc;
				_tmp28_ = _tmp27_->next;
				_tmp29_ = bird_font_bird_font_file_encode (_tmp28_);
				_tmp30_ = _tmp29_;
				g_data_output_stream_put_string (os, _tmp30_, NULL, &_inner_error0_);
				_g_free0 (_tmp30_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_propagate_error (error, _inner_error0_);
					_g_object_unref0 (sc);
					_g_object_unref0 (s);
					return;
				}
			}
			g_data_output_stream_put_string (os, "\" ", NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (sc);
				_g_object_unref0 (s);
				return;
			}
			g_data_output_stream_put_string (os, "/>\n", NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (sc);
				_g_object_unref0 (s);
				return;
			}
			_g_object_unref0 (sc);
		}
	}
	_g_object_unref0 (s);
}

static Block7Data*
block7_data_ref (Block7Data* _data7_)
{
	g_atomic_int_inc (&_data7_->_ref_count_);
	return _data7_;
}

static void
block7_data_unref (void * _userdata_)
{
	Block7Data* _data7_;
	_data7_ = (Block7Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
		BirdFontBirdFontFile* self;
		self = _data7_->self;
		_g_object_unref0 (_data7_->os);
		_g_object_unref0 (self);
		g_slice_free (Block7Data, _data7_);
	}
}

static void
__lambda339_ (Block7Data* _data7_,
              const gchar* l,
              const gchar* r,
              gdouble k)
{
	BirdFontBirdFontFile* self;
	GError* _inner_error0_ = NULL;
	self = _data7_->self;
	g_return_if_fail (l != NULL);
	g_return_if_fail (r != NULL);
	{
		gchar* _tmp0_;
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		g_data_output_stream_put_string (_data7_->os, "<kerning ", NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		g_data_output_stream_put_string (_data7_->os, "left=\"", NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp0_ = bird_font_bird_font_file_encode (l);
		_tmp1_ = _tmp0_;
		g_data_output_stream_put_string (_data7_->os, _tmp1_, NULL, &_inner_error0_);
		_g_free0 (_tmp1_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		g_data_output_stream_put_string (_data7_->os, "\" ", NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		g_data_output_stream_put_string (_data7_->os, "right=\"", NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = bird_font_bird_font_file_encode (r);
		_tmp3_ = _tmp2_;
		g_data_output_stream_put_string (_data7_->os, _tmp3_, NULL, &_inner_error0_);
		_g_free0 (_tmp3_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		g_data_output_stream_put_string (_data7_->os, "\" ", NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		g_data_output_stream_put_string (_data7_->os, "hadjustment=\"", NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp4_ = bird_font_bird_font_file_round (k, 5);
		_tmp5_ = _tmp4_;
		g_data_output_stream_put_string (_data7_->os, _tmp5_, NULL, &_inner_error0_);
		_g_free0 (_tmp5_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		g_data_output_stream_put_string (_data7_->os, "\" />\n", NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		_tmp8_ = string_to_string (_tmp7_);
		_tmp9_ = g_strconcat (_tmp8_, " \n", NULL);
		_tmp10_ = _tmp9_;
		g_warning ("BirdFontFile.vala:362: %s", _tmp10_);
		_g_free0 (_tmp10_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda339__bird_font_kerning_classes_kerning_class_iterator (const gchar* left,
                                                                const gchar* right,
                                                                gdouble kerning,
                                                                gpointer self)
{
	__lambda339_ (self, left, right, kerning);
}

void
bird_font_bird_font_file_write_kerning (BirdFontBirdFontFile* self,
                                        GDataOutputStream* os,
                                        GError** error)
{
	Block7Data* _data7_;
	GDataOutputStream* _tmp0_;
	guint num_kerning_pairs = 0U;
	gchar* range = NULL;
	BirdFontKerningClasses* classes = NULL;
	BirdFontFont* _tmp1_;
	BirdFontKerningClasses* _tmp2_;
	BirdFontKerningClasses* _tmp3_;
	GeeArrayList* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	BirdFontKerningClasses* _tmp31_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (os != NULL);
	_data7_ = g_slice_new0 (Block7Data);
	_data7_->_ref_count_ = 1;
	_data7_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (os);
	_g_object_unref0 (_data7_->os);
	_data7_->os = _tmp0_;
	_tmp1_ = self->priv->font;
	_tmp2_ = bird_font_font_get_kerning_classes (_tmp1_);
	classes = _tmp2_;
	_tmp3_ = classes;
	_tmp4_ = _tmp3_->classes_first;
	_tmp5_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp4_);
	_tmp6_ = _tmp5_;
	num_kerning_pairs = (guint) _tmp6_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp7_ = FALSE;
			_tmp7_ = TRUE;
			while (TRUE) {
				BirdFontKerningClasses* _tmp9_;
				GeeArrayList* _tmp10_;
				gpointer _tmp11_;
				BirdFontGlyphRange* _tmp12_;
				gchar* _tmp13_;
				const gchar* _tmp14_;
				gchar* _tmp15_;
				gchar* _tmp16_;
				BirdFontKerningClasses* _tmp17_;
				GeeArrayList* _tmp18_;
				gpointer _tmp19_;
				BirdFontGlyphRange* _tmp20_;
				gchar* _tmp21_;
				const gchar* _tmp22_;
				gchar* _tmp23_;
				gchar* _tmp24_;
				BirdFontKerningClasses* _tmp25_;
				GeeArrayList* _tmp26_;
				gpointer _tmp27_;
				BirdFontKerning* _tmp28_;
				gchar* _tmp29_;
				gchar* _tmp30_;
				if (!_tmp7_) {
					gint _tmp8_;
					_tmp8_ = i;
					i = _tmp8_ + 1;
				}
				_tmp7_ = FALSE;
				if (!(((guint) i) < num_kerning_pairs)) {
					break;
				}
				_tmp9_ = classes;
				_tmp10_ = _tmp9_->classes_first;
				_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _tmp10_, i);
				_tmp12_ = (BirdFontGlyphRange*) _tmp11_;
				_tmp13_ = bird_font_glyph_range_get_all_ranges (_tmp12_);
				_g_free0 (range);
				range = _tmp13_;
				_bird_font_glyph_range_unref0 (_tmp12_);
				g_data_output_stream_put_string (_data7_->os, "<kerning ", NULL, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_propagate_error (error, _inner_error0_);
					_g_object_unref0 (classes);
					_g_free0 (range);
					block7_data_unref (_data7_);
					_data7_ = NULL;
					return;
				}
				g_data_output_stream_put_string (_data7_->os, "left=\"", NULL, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_propagate_error (error, _inner_error0_);
					_g_object_unref0 (classes);
					_g_free0 (range);
					block7_data_unref (_data7_);
					_data7_ = NULL;
					return;
				}
				_tmp14_ = range;
				_tmp15_ = bird_font_bird_font_file_encode (_tmp14_);
				_tmp16_ = _tmp15_;
				g_data_output_stream_put_string (_data7_->os, _tmp16_, NULL, &_inner_error0_);
				_g_free0 (_tmp16_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_propagate_error (error, _inner_error0_);
					_g_object_unref0 (classes);
					_g_free0 (range);
					block7_data_unref (_data7_);
					_data7_ = NULL;
					return;
				}
				g_data_output_stream_put_string (_data7_->os, "\" ", NULL, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_propagate_error (error, _inner_error0_);
					_g_object_unref0 (classes);
					_g_free0 (range);
					block7_data_unref (_data7_);
					_data7_ = NULL;
					return;
				}
				_tmp17_ = classes;
				_tmp18_ = _tmp17_->classes_last;
				_tmp19_ = gee_abstract_list_get ((GeeAbstractList*) _tmp18_, i);
				_tmp20_ = (BirdFontGlyphRange*) _tmp19_;
				_tmp21_ = bird_font_glyph_range_get_all_ranges (_tmp20_);
				_g_free0 (range);
				range = _tmp21_;
				_bird_font_glyph_range_unref0 (_tmp20_);
				g_data_output_stream_put_string (_data7_->os, "right=\"", NULL, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_propagate_error (error, _inner_error0_);
					_g_object_unref0 (classes);
					_g_free0 (range);
					block7_data_unref (_data7_);
					_data7_ = NULL;
					return;
				}
				_tmp22_ = range;
				_tmp23_ = bird_font_bird_font_file_encode (_tmp22_);
				_tmp24_ = _tmp23_;
				g_data_output_stream_put_string (_data7_->os, _tmp24_, NULL, &_inner_error0_);
				_g_free0 (_tmp24_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_propagate_error (error, _inner_error0_);
					_g_object_unref0 (classes);
					_g_free0 (range);
					block7_data_unref (_data7_);
					_data7_ = NULL;
					return;
				}
				g_data_output_stream_put_string (_data7_->os, "\" ", NULL, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_propagate_error (error, _inner_error0_);
					_g_object_unref0 (classes);
					_g_free0 (range);
					block7_data_unref (_data7_);
					_data7_ = NULL;
					return;
				}
				g_data_output_stream_put_string (_data7_->os, "hadjustment=\"", NULL, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_propagate_error (error, _inner_error0_);
					_g_object_unref0 (classes);
					_g_free0 (range);
					block7_data_unref (_data7_);
					_data7_ = NULL;
					return;
				}
				_tmp25_ = classes;
				_tmp26_ = _tmp25_->classes_kerning;
				_tmp27_ = gee_abstract_list_get ((GeeAbstractList*) _tmp26_, i);
				_tmp28_ = (BirdFontKerning*) _tmp27_;
				_tmp29_ = bird_font_bird_font_file_round (_tmp28_->val, 5);
				_tmp30_ = _tmp29_;
				g_data_output_stream_put_string (_data7_->os, _tmp30_, NULL, &_inner_error0_);
				_g_free0 (_tmp30_);
				_g_object_unref0 (_tmp28_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_propagate_error (error, _inner_error0_);
					_g_object_unref0 (classes);
					_g_free0 (range);
					block7_data_unref (_data7_);
					_data7_ = NULL;
					return;
				}
				g_data_output_stream_put_string (_data7_->os, "\" />\n", NULL, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_propagate_error (error, _inner_error0_);
					_g_object_unref0 (classes);
					_g_free0 (range);
					block7_data_unref (_data7_);
					_data7_ = NULL;
					return;
				}
			}
		}
	}
	_tmp31_ = classes;
	bird_font_kerning_classes_get_single_position_pairs (_tmp31_, ___lambda339__bird_font_kerning_classes_kerning_class_iterator, _data7_);
	_g_object_unref0 (classes);
	_g_free0 (range);
	block7_data_unref (_data7_);
	_data7_ = NULL;
}

void
bird_font_bird_font_file_write_settings (BirdFontBirdFontFile* self,
                                         GDataOutputStream* os,
                                         GError** error)
{
	GeeArrayList* _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	BirdFontFont* _tmp16_;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (os != NULL);
	{
		GeeArrayList* _gv_list = NULL;
		BirdFontFont* _tmp0_;
		GeeArrayList* _tmp1_;
		gint _gv_size = 0;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _gv_index = 0;
		_tmp0_ = self->priv->font;
		_tmp1_ = _tmp0_->grid_width;
		_gv_list = _tmp1_;
		_tmp2_ = _gv_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_gv_size = _tmp4_;
		_gv_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gchar* gv = NULL;
			GeeArrayList* _tmp7_;
			gpointer _tmp8_;
			const gchar* _tmp9_;
			const gchar* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			_gv_index = _gv_index + 1;
			_tmp5_ = _gv_index;
			_tmp6_ = _gv_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _gv_list;
			_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _gv_index);
			gv = (gchar*) _tmp8_;
			_tmp9_ = gv;
			_tmp10_ = string_to_string (_tmp9_);
			_tmp11_ = g_strconcat ("<grid width=\"", _tmp10_, "\"/>\n", NULL);
			_tmp12_ = _tmp11_;
			g_data_output_stream_put_string (os, _tmp12_, NULL, &_inner_error0_);
			_g_free0 (_tmp12_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_free0 (gv);
				return;
			}
			_g_free0 (gv);
		}
	}
	_tmp13_ = bird_font_grid_tool_sizes;
	_tmp14_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp13_);
	_tmp15_ = _tmp14_;
	if (_tmp15_ > 0) {
		g_data_output_stream_put_string (os, "\n", NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			return;
		}
	}
	_tmp16_ = self->priv->font;
	_tmp17_ = _tmp16_->background_scale;
	_tmp18_ = string_to_string (_tmp17_);
	_tmp19_ = g_strconcat ("<background scale=\"", _tmp18_, "\" />\n", NULL);
	_tmp20_ = _tmp19_;
	g_data_output_stream_put_string (os, _tmp20_, NULL, &_inner_error0_);
	_g_free0 (_tmp20_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

static gchar*
bool_to_string (gboolean self)
{
	gchar* result;
	if (self) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("true");
		result = _tmp0_;
		return result;
	} else {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("false");
		result = _tmp1_;
		return result;
	}
}

void
bird_font_bird_font_file_write_description (BirdFontBirdFontFile* self,
                                            GDataOutputStream* os,
                                            GError** error)
{
	BirdFontFont* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	BirdFontFont* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	BirdFontFont* _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	const gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	BirdFontFont* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	BirdFontFont* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	BirdFontFont* _tmp31_;
	const gchar* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	const gchar* _tmp35_;
	gchar* _tmp36_;
	gchar* _tmp37_;
	BirdFontFont* _tmp38_;
	const gchar* _tmp39_;
	gchar* _tmp40_;
	gchar* _tmp41_;
	const gchar* _tmp42_;
	gchar* _tmp43_;
	gchar* _tmp44_;
	BirdFontFont* _tmp45_;
	const gchar* _tmp46_;
	gchar* _tmp47_;
	gchar* _tmp48_;
	const gchar* _tmp49_;
	gchar* _tmp50_;
	gchar* _tmp51_;
	BirdFontFont* _tmp52_;
	const gchar* _tmp53_;
	gchar* _tmp54_;
	gchar* _tmp55_;
	const gchar* _tmp56_;
	gchar* _tmp57_;
	gchar* _tmp58_;
	BirdFontFont* _tmp59_;
	const gchar* _tmp60_;
	gchar* _tmp61_;
	gchar* _tmp62_;
	const gchar* _tmp63_;
	gchar* _tmp64_;
	gchar* _tmp65_;
	BirdFontFont* _tmp66_;
	const gchar* _tmp67_;
	gchar* _tmp68_;
	gchar* _tmp69_;
	const gchar* _tmp70_;
	gchar* _tmp71_;
	gchar* _tmp72_;
	BirdFontFont* _tmp73_;
	const gchar* _tmp74_;
	gchar* _tmp75_;
	gchar* _tmp76_;
	const gchar* _tmp77_;
	gchar* _tmp78_;
	gchar* _tmp79_;
	BirdFontFont* _tmp80_;
	gchar* _tmp81_;
	gchar* _tmp82_;
	gchar* _tmp83_;
	gchar* _tmp84_;
	BirdFontFont* _tmp85_;
	gchar* _tmp86_;
	gchar* _tmp87_;
	const gchar* _tmp88_;
	gchar* _tmp89_;
	gchar* _tmp90_;
	BirdFontFont* _tmp91_;
	gchar* _tmp92_;
	gchar* _tmp93_;
	gchar* _tmp94_;
	gchar* _tmp95_;
	BirdFontFont* _tmp96_;
	const gchar* _tmp97_;
	gchar* _tmp98_;
	gchar* _tmp99_;
	const gchar* _tmp100_;
	gchar* _tmp101_;
	gchar* _tmp102_;
	BirdFontFont* _tmp103_;
	const gchar* _tmp104_;
	gchar* _tmp105_;
	gchar* _tmp106_;
	const gchar* _tmp107_;
	gchar* _tmp108_;
	gchar* _tmp109_;
	BirdFontFont* _tmp110_;
	const gchar* _tmp111_;
	gchar* _tmp112_;
	gchar* _tmp113_;
	const gchar* _tmp114_;
	gchar* _tmp115_;
	gchar* _tmp116_;
	BirdFontFont* _tmp117_;
	const gchar* _tmp118_;
	gchar* _tmp119_;
	gchar* _tmp120_;
	const gchar* _tmp121_;
	gchar* _tmp122_;
	gchar* _tmp123_;
	BirdFontFont* _tmp124_;
	const gchar* _tmp125_;
	gchar* _tmp126_;
	gchar* _tmp127_;
	const gchar* _tmp128_;
	gchar* _tmp129_;
	gchar* _tmp130_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (os != NULL);
	_tmp0_ = self->priv->font;
	_tmp1_ = _tmp0_->postscript_name;
	_tmp2_ = g_markup_escape_text (_tmp1_, (gssize) -1);
	_tmp3_ = _tmp2_;
	_tmp4_ = string_to_string (_tmp3_);
	_tmp5_ = g_strconcat ("<postscript_name>", _tmp4_, "</postscript_name>\n", NULL);
	_tmp6_ = _tmp5_;
	g_data_output_stream_put_string (os, _tmp6_, NULL, &_inner_error0_);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp3_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp7_ = self->priv->font;
	_tmp8_ = _tmp7_->name;
	_tmp9_ = g_markup_escape_text (_tmp8_, (gssize) -1);
	_tmp10_ = _tmp9_;
	_tmp11_ = string_to_string (_tmp10_);
	_tmp12_ = g_strconcat ("<name>", _tmp11_, "</name>\n", NULL);
	_tmp13_ = _tmp12_;
	g_data_output_stream_put_string (os, _tmp13_, NULL, &_inner_error0_);
	_g_free0 (_tmp13_);
	_g_free0 (_tmp10_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp14_ = self->priv->font;
	_tmp15_ = _tmp14_->subfamily;
	_tmp16_ = g_markup_escape_text (_tmp15_, (gssize) -1);
	_tmp17_ = _tmp16_;
	_tmp18_ = string_to_string (_tmp17_);
	_tmp19_ = g_strconcat ("<subfamily>", _tmp18_, "</subfamily>\n", NULL);
	_tmp20_ = _tmp19_;
	g_data_output_stream_put_string (os, _tmp20_, NULL, &_inner_error0_);
	_g_free0 (_tmp20_);
	_g_free0 (_tmp17_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp21_ = self->priv->font;
	_tmp22_ = bool_to_string (_tmp21_->bold);
	_tmp23_ = _tmp22_;
	_tmp24_ = g_strconcat ("<bold>", _tmp23_, "</bold>\n", NULL);
	_tmp25_ = _tmp24_;
	g_data_output_stream_put_string (os, _tmp25_, NULL, &_inner_error0_);
	_g_free0 (_tmp25_);
	_g_free0 (_tmp23_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp26_ = self->priv->font;
	_tmp27_ = bool_to_string (_tmp26_->italic);
	_tmp28_ = _tmp27_;
	_tmp29_ = g_strconcat ("<italic>", _tmp28_, "</italic>\n", NULL);
	_tmp30_ = _tmp29_;
	g_data_output_stream_put_string (os, _tmp30_, NULL, &_inner_error0_);
	_g_free0 (_tmp30_);
	_g_free0 (_tmp28_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp31_ = self->priv->font;
	_tmp32_ = _tmp31_->full_name;
	_tmp33_ = g_markup_escape_text (_tmp32_, (gssize) -1);
	_tmp34_ = _tmp33_;
	_tmp35_ = string_to_string (_tmp34_);
	_tmp36_ = g_strconcat ("<full_name>", _tmp35_, "</full_name>\n", NULL);
	_tmp37_ = _tmp36_;
	g_data_output_stream_put_string (os, _tmp37_, NULL, &_inner_error0_);
	_g_free0 (_tmp37_);
	_g_free0 (_tmp34_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp38_ = self->priv->font;
	_tmp39_ = _tmp38_->unique_identifier;
	_tmp40_ = g_markup_escape_text (_tmp39_, (gssize) -1);
	_tmp41_ = _tmp40_;
	_tmp42_ = string_to_string (_tmp41_);
	_tmp43_ = g_strconcat ("<unique_identifier>", _tmp42_, "</unique_identifier>\n", NULL);
	_tmp44_ = _tmp43_;
	g_data_output_stream_put_string (os, _tmp44_, NULL, &_inner_error0_);
	_g_free0 (_tmp44_);
	_g_free0 (_tmp41_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp45_ = self->priv->font;
	_tmp46_ = _tmp45_->version;
	_tmp47_ = g_markup_escape_text (_tmp46_, (gssize) -1);
	_tmp48_ = _tmp47_;
	_tmp49_ = string_to_string (_tmp48_);
	_tmp50_ = g_strconcat ("<version>", _tmp49_, "</version>\n", NULL);
	_tmp51_ = _tmp50_;
	g_data_output_stream_put_string (os, _tmp51_, NULL, &_inner_error0_);
	_g_free0 (_tmp51_);
	_g_free0 (_tmp48_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp52_ = self->priv->font;
	_tmp53_ = _tmp52_->description;
	_tmp54_ = g_markup_escape_text (_tmp53_, (gssize) -1);
	_tmp55_ = _tmp54_;
	_tmp56_ = string_to_string (_tmp55_);
	_tmp57_ = g_strconcat ("<description>", _tmp56_, "</description>\n", NULL);
	_tmp58_ = _tmp57_;
	g_data_output_stream_put_string (os, _tmp58_, NULL, &_inner_error0_);
	_g_free0 (_tmp58_);
	_g_free0 (_tmp55_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp59_ = self->priv->font;
	_tmp60_ = _tmp59_->copyright;
	_tmp61_ = g_markup_escape_text (_tmp60_, (gssize) -1);
	_tmp62_ = _tmp61_;
	_tmp63_ = string_to_string (_tmp62_);
	_tmp64_ = g_strconcat ("<copyright>", _tmp63_, "</copyright>\n", NULL);
	_tmp65_ = _tmp64_;
	g_data_output_stream_put_string (os, _tmp65_, NULL, &_inner_error0_);
	_g_free0 (_tmp65_);
	_g_free0 (_tmp62_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp66_ = self->priv->font;
	_tmp67_ = _tmp66_->license;
	_tmp68_ = g_markup_escape_text (_tmp67_, (gssize) -1);
	_tmp69_ = _tmp68_;
	_tmp70_ = string_to_string (_tmp69_);
	_tmp71_ = g_strconcat ("<license>", _tmp70_, "</license>\n", NULL);
	_tmp72_ = _tmp71_;
	g_data_output_stream_put_string (os, _tmp72_, NULL, &_inner_error0_);
	_g_free0 (_tmp72_);
	_g_free0 (_tmp69_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp73_ = self->priv->font;
	_tmp74_ = _tmp73_->license_url;
	_tmp75_ = g_markup_escape_text (_tmp74_, (gssize) -1);
	_tmp76_ = _tmp75_;
	_tmp77_ = string_to_string (_tmp76_);
	_tmp78_ = g_strconcat ("<license_url>", _tmp77_, "</license_url>\n", NULL);
	_tmp79_ = _tmp78_;
	g_data_output_stream_put_string (os, _tmp79_, NULL, &_inner_error0_);
	_g_free0 (_tmp79_);
	_g_free0 (_tmp76_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp80_ = self->priv->font;
	_tmp81_ = g_strdup_printf ("%i", _tmp80_->weight);
	_tmp82_ = _tmp81_;
	_tmp83_ = g_strconcat ("<weight>", _tmp82_, "</weight>\n", NULL);
	_tmp84_ = _tmp83_;
	g_data_output_stream_put_string (os, _tmp84_, NULL, &_inner_error0_);
	_g_free0 (_tmp84_);
	_g_free0 (_tmp82_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp85_ = self->priv->font;
	_tmp86_ = bird_font_bird_font_file_round (_tmp85_->italic_angle, 5);
	_tmp87_ = _tmp86_;
	_tmp88_ = string_to_string (_tmp87_);
	_tmp89_ = g_strconcat ("<italic_angle>", _tmp88_, "</italic_angle>\n", NULL);
	_tmp90_ = _tmp89_;
	g_data_output_stream_put_string (os, _tmp90_, NULL, &_inner_error0_);
	_g_free0 (_tmp90_);
	_g_free0 (_tmp87_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp91_ = self->priv->font;
	_tmp92_ = g_strdup_printf ("%i", _tmp91_->units_per_em);
	_tmp93_ = _tmp92_;
	_tmp94_ = g_strconcat ("<units_per_em>", _tmp93_, "</units_per_em>\n", NULL);
	_tmp95_ = _tmp94_;
	g_data_output_stream_put_string (os, _tmp95_, NULL, &_inner_error0_);
	_g_free0 (_tmp95_);
	_g_free0 (_tmp93_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp96_ = self->priv->font;
	_tmp97_ = _tmp96_->trademark;
	_tmp98_ = g_markup_escape_text (_tmp97_, (gssize) -1);
	_tmp99_ = _tmp98_;
	_tmp100_ = string_to_string (_tmp99_);
	_tmp101_ = g_strconcat ("<trademark>", _tmp100_, "</trademark>\n", NULL);
	_tmp102_ = _tmp101_;
	g_data_output_stream_put_string (os, _tmp102_, NULL, &_inner_error0_);
	_g_free0 (_tmp102_);
	_g_free0 (_tmp99_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp103_ = self->priv->font;
	_tmp104_ = _tmp103_->manufacturer;
	_tmp105_ = g_markup_escape_text (_tmp104_, (gssize) -1);
	_tmp106_ = _tmp105_;
	_tmp107_ = string_to_string (_tmp106_);
	_tmp108_ = g_strconcat ("<manufacturer>", _tmp107_, "</manufacturer>\n", NULL);
	_tmp109_ = _tmp108_;
	g_data_output_stream_put_string (os, _tmp109_, NULL, &_inner_error0_);
	_g_free0 (_tmp109_);
	_g_free0 (_tmp106_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp110_ = self->priv->font;
	_tmp111_ = _tmp110_->designer;
	_tmp112_ = g_markup_escape_text (_tmp111_, (gssize) -1);
	_tmp113_ = _tmp112_;
	_tmp114_ = string_to_string (_tmp113_);
	_tmp115_ = g_strconcat ("<designer>", _tmp114_, "</designer>\n", NULL);
	_tmp116_ = _tmp115_;
	g_data_output_stream_put_string (os, _tmp116_, NULL, &_inner_error0_);
	_g_free0 (_tmp116_);
	_g_free0 (_tmp113_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp117_ = self->priv->font;
	_tmp118_ = _tmp117_->vendor_url;
	_tmp119_ = g_markup_escape_text (_tmp118_, (gssize) -1);
	_tmp120_ = _tmp119_;
	_tmp121_ = string_to_string (_tmp120_);
	_tmp122_ = g_strconcat ("<vendor_url>", _tmp121_, "</vendor_url>\n", NULL);
	_tmp123_ = _tmp122_;
	g_data_output_stream_put_string (os, _tmp123_, NULL, &_inner_error0_);
	_g_free0 (_tmp123_);
	_g_free0 (_tmp120_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp124_ = self->priv->font;
	_tmp125_ = _tmp124_->designer_url;
	_tmp126_ = g_markup_escape_text (_tmp125_, (gssize) -1);
	_tmp127_ = _tmp126_;
	_tmp128_ = string_to_string (_tmp127_);
	_tmp129_ = g_strconcat ("<designer_url>", _tmp128_, "</designer_url>\n", NULL);
	_tmp130_ = _tmp129_;
	g_data_output_stream_put_string (os, _tmp130_, NULL, &_inner_error0_);
	_g_free0 (_tmp130_);
	_g_free0 (_tmp127_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

void
bird_font_bird_font_file_write_lines (BirdFontBirdFontFile* self,
                                      GDataOutputStream* os,
                                      GError** error)
{
	BirdFontFont* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	BirdFontFont* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	BirdFontFont* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	BirdFontFont* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	const gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	BirdFontFont* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	const gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	BirdFontFont* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	const gchar* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (os != NULL);
	g_data_output_stream_put_string (os, "<horizontal>\n", NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp0_ = self->priv->font;
	_tmp1_ = bird_font_bird_font_file_round (_tmp0_->top_limit, 5);
	_tmp2_ = _tmp1_;
	_tmp3_ = string_to_string (_tmp2_);
	_tmp4_ = g_strconcat ("\t<top_limit>", _tmp3_, "</top_limit>\n", NULL);
	_tmp5_ = _tmp4_;
	g_data_output_stream_put_string (os, _tmp5_, NULL, &_inner_error0_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp2_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp6_ = self->priv->font;
	_tmp7_ = bird_font_bird_font_file_round (_tmp6_->top_position, 5);
	_tmp8_ = _tmp7_;
	_tmp9_ = string_to_string (_tmp8_);
	_tmp10_ = g_strconcat ("\t<top_position>", _tmp9_, "</top_position>\n", NULL);
	_tmp11_ = _tmp10_;
	g_data_output_stream_put_string (os, _tmp11_, NULL, &_inner_error0_);
	_g_free0 (_tmp11_);
	_g_free0 (_tmp8_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp12_ = self->priv->font;
	_tmp13_ = bird_font_bird_font_file_round (_tmp12_->xheight_position, 5);
	_tmp14_ = _tmp13_;
	_tmp15_ = string_to_string (_tmp14_);
	_tmp16_ = g_strconcat ("\t<x-height>", _tmp15_, "</x-height>\n", NULL);
	_tmp17_ = _tmp16_;
	g_data_output_stream_put_string (os, _tmp17_, NULL, &_inner_error0_);
	_g_free0 (_tmp17_);
	_g_free0 (_tmp14_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp18_ = self->priv->font;
	_tmp19_ = bird_font_bird_font_file_round (_tmp18_->base_line, 5);
	_tmp20_ = _tmp19_;
	_tmp21_ = string_to_string (_tmp20_);
	_tmp22_ = g_strconcat ("\t<base_line>", _tmp21_, "</base_line>\n", NULL);
	_tmp23_ = _tmp22_;
	g_data_output_stream_put_string (os, _tmp23_, NULL, &_inner_error0_);
	_g_free0 (_tmp23_);
	_g_free0 (_tmp20_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp24_ = self->priv->font;
	_tmp25_ = bird_font_bird_font_file_round (_tmp24_->bottom_position, 5);
	_tmp26_ = _tmp25_;
	_tmp27_ = string_to_string (_tmp26_);
	_tmp28_ = g_strconcat ("\t<bottom_position>", _tmp27_, "</bottom_position>\n", NULL);
	_tmp29_ = _tmp28_;
	g_data_output_stream_put_string (os, _tmp29_, NULL, &_inner_error0_);
	_g_free0 (_tmp29_);
	_g_free0 (_tmp26_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp30_ = self->priv->font;
	_tmp31_ = bird_font_bird_font_file_round (_tmp30_->bottom_limit, 5);
	_tmp32_ = _tmp31_;
	_tmp33_ = string_to_string (_tmp32_);
	_tmp34_ = g_strconcat ("\t<bottom_limit>", _tmp33_, "</bottom_limit>\n", NULL);
	_tmp35_ = _tmp34_;
	g_data_output_stream_put_string (os, _tmp35_, NULL, &_inner_error0_);
	_g_free0 (_tmp35_);
	_g_free0 (_tmp32_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	{
		GeeArrayList* _guide_list = NULL;
		BirdFontFont* _tmp36_;
		GeeArrayList* _tmp37_;
		gint _guide_size = 0;
		GeeArrayList* _tmp38_;
		gint _tmp39_;
		gint _tmp40_;
		gint _guide_index = 0;
		_tmp36_ = self->priv->font;
		_tmp37_ = _tmp36_->custom_guides;
		_guide_list = _tmp37_;
		_tmp38_ = _guide_list;
		_tmp39_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp38_);
		_tmp40_ = _tmp39_;
		_guide_size = _tmp40_;
		_guide_index = -1;
		while (TRUE) {
			gint _tmp41_;
			gint _tmp42_;
			BirdFontLine* guide = NULL;
			GeeArrayList* _tmp43_;
			gpointer _tmp44_;
			BirdFontLine* _tmp45_;
			const gchar* _tmp46_;
			gchar* _tmp47_;
			gchar* _tmp48_;
			const gchar* _tmp49_;
			BirdFontLine* _tmp50_;
			gchar* _tmp51_;
			gchar* _tmp52_;
			const gchar* _tmp53_;
			gchar* _tmp54_;
			gchar* _tmp55_;
			_guide_index = _guide_index + 1;
			_tmp41_ = _guide_index;
			_tmp42_ = _guide_size;
			if (!(_tmp41_ < _tmp42_)) {
				break;
			}
			_tmp43_ = _guide_list;
			_tmp44_ = gee_abstract_list_get ((GeeAbstractList*) _tmp43_, _guide_index);
			guide = (BirdFontLine*) _tmp44_;
			_tmp45_ = guide;
			_tmp46_ = _tmp45_->label;
			_tmp47_ = bird_font_bird_font_file_encode (_tmp46_);
			_tmp48_ = _tmp47_;
			_tmp49_ = string_to_string (_tmp48_);
			_tmp50_ = guide;
			_tmp51_ = bird_font_bird_font_file_round (_tmp50_->pos, 5);
			_tmp52_ = _tmp51_;
			_tmp53_ = string_to_string (_tmp52_);
			_tmp54_ = g_strconcat ("\t<custom_guide label=\"", _tmp49_, "\">", _tmp53_, "</custom_guide>\n", NULL);
			_tmp55_ = _tmp54_;
			g_data_output_stream_put_string (os, _tmp55_, NULL, &_inner_error0_);
			_g_free0 (_tmp55_);
			_g_free0 (_tmp52_);
			_g_free0 (_tmp48_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (guide);
				return;
			}
			_g_object_unref0 (guide);
		}
	}
	g_data_output_stream_put_string (os, "</horizontal>\n", NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

void
bird_font_bird_font_file_write_glyph_collection_start (BirdFontBirdFontFile* self,
                                                       BirdFontGlyphCollection* gc,
                                                       BirdFontGlyphMaster* master,
                                                       GDataOutputStream* os,
                                                       GError** error)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (gc != NULL);
	g_return_if_fail (master != NULL);
	g_return_if_fail (os != NULL);
	g_data_output_stream_put_string (os, "<collection ", NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	if (bird_font_glyph_collection_is_unassigned (gc)) {
		gchar* _tmp0_;
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp0_ = bird_font_glyph_collection_get_name (gc);
		_tmp1_ = _tmp0_;
		_tmp2_ = bird_font_bird_font_file_encode (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = string_to_string (_tmp3_);
		_tmp5_ = g_strconcat ("name=\"", _tmp4_, "\"", NULL);
		_tmp6_ = _tmp5_;
		g_data_output_stream_put_string (os, _tmp6_, NULL, &_inner_error0_);
		_g_free0 (_tmp6_);
		_g_free0 (_tmp3_);
		_g_free0 (_tmp1_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			return;
		}
	} else {
		gchar* _tmp7_;
		gchar* _tmp8_;
		const gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp7_ = bird_font_font_to_hex (bird_font_glyph_collection_get_unicode_character (gc));
		_tmp8_ = _tmp7_;
		_tmp9_ = string_to_string (_tmp8_);
		_tmp10_ = g_strconcat ("unicode=\"", _tmp9_, "\"", NULL);
		_tmp11_ = _tmp10_;
		g_data_output_stream_put_string (os, _tmp11_, NULL, &_inner_error0_);
		_g_free0 (_tmp11_);
		_g_free0 (_tmp8_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			return;
		}
	}
	if (bird_font_glyph_collection_is_multimaster (gc)) {
		gchar* _tmp12_;
		gchar* _tmp13_;
		const gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		g_data_output_stream_put_string (os, " ", NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			return;
		}
		_tmp12_ = bird_font_glyph_master_get_id (master);
		_tmp13_ = _tmp12_;
		_tmp14_ = string_to_string (_tmp13_);
		_tmp15_ = g_strconcat ("master=\"", _tmp14_, "\"", NULL);
		_tmp16_ = _tmp15_;
		g_data_output_stream_put_string (os, _tmp16_, NULL, &_inner_error0_);
		_g_free0 (_tmp16_);
		_g_free0 (_tmp13_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			return;
		}
	}
	g_data_output_stream_put_string (os, ">\n", NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

void
bird_font_bird_font_file_write_glyph_collection_end (BirdFontBirdFontFile* self,
                                                     GDataOutputStream* os,
                                                     GError** error)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (os != NULL);
	g_data_output_stream_put_string (os, "</collection>\n\n", NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

void
bird_font_bird_font_file_write_selected (BirdFontBirdFontFile* self,
                                         BirdFontGlyphMaster* master,
                                         GDataOutputStream* os,
                                         GError** error)
{
	BirdFontGlyph* g = NULL;
	BirdFontGlyph* _tmp0_;
	BirdFontGlyph* glyph = NULL;
	BirdFontGlyph* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (master != NULL);
	g_return_if_fail (os != NULL);
	_tmp0_ = bird_font_glyph_master_get_current (master);
	g = _tmp0_;
	_tmp1_ = g;
	if (_tmp1_ != NULL) {
		BirdFontGlyph* _tmp2_;
		BirdFontGlyph* _tmp3_;
		BirdFontGlyph* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp2_ = g;
		_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, BIRD_FONT_TYPE_GLYPH, BirdFontGlyph));
		_g_object_unref0 (glyph);
		glyph = _tmp3_;
		_tmp4_ = glyph;
		_tmp5_ = g_strdup_printf ("%i", _tmp4_->version_id);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_strconcat ("\t<selected id=\"", _tmp6_, "\"/>\n", NULL);
		_tmp8_ = _tmp7_;
		g_data_output_stream_put_string (os, _tmp8_, NULL, &_inner_error0_);
		_g_free0 (_tmp8_);
		_g_free0 (_tmp6_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (glyph);
			_g_object_unref0 (g);
			return;
		}
	}
	_g_object_unref0 (glyph);
	_g_object_unref0 (g);
}

void
bird_font_bird_font_file_write_glyph_collection (BirdFontBirdFontFile* self,
                                                 BirdFontGlyphCollection* gc,
                                                 GDataOutputStream* os,
                                                 GError** error)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (gc != NULL);
	g_return_if_fail (os != NULL);
	{
		GeeArrayList* _master_list = NULL;
		GeeArrayList* _tmp0_;
		gint _master_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _master_index = 0;
		_tmp0_ = gc->glyph_masters;
		_master_list = _tmp0_;
		_tmp1_ = _master_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_master_size = _tmp3_;
		_master_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			BirdFontGlyphMaster* master = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			BirdFontGlyphMaster* _tmp8_;
			BirdFontGlyphMaster* _tmp9_;
			BirdFontGlyphMaster* _tmp10_;
			_master_index = _master_index + 1;
			_tmp4_ = _master_index;
			_tmp5_ = _master_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _master_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _master_index);
			master = (BirdFontGlyphMaster*) _tmp7_;
			_tmp8_ = master;
			bird_font_bird_font_file_write_glyph_collection_start (self, gc, _tmp8_, os, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (master);
				return;
			}
			_tmp9_ = master;
			bird_font_bird_font_file_write_selected (self, _tmp9_, os, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (master);
				return;
			}
			_tmp10_ = master;
			bird_font_bird_font_file_write_glyph_master (self, _tmp10_, os, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (master);
				return;
			}
			bird_font_bird_font_file_write_glyph_collection_end (self, os, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (master);
				return;
			}
			_g_object_unref0 (master);
		}
	}
}

void
bird_font_bird_font_file_write_glyph_master (BirdFontBirdFontFile* self,
                                             BirdFontGlyphMaster* master,
                                             GDataOutputStream* os,
                                             GError** error)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (master != NULL);
	g_return_if_fail (os != NULL);
	{
		GeeArrayList* _g_list = NULL;
		GeeArrayList* _tmp0_;
		gint _g_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _g_index = 0;
		_tmp0_ = master->glyphs;
		_g_list = _tmp0_;
		_tmp1_ = _g_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_g_size = _tmp3_;
		_g_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			BirdFontGlyph* g = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			BirdFontGlyph* _tmp8_;
			_g_index = _g_index + 1;
			_tmp4_ = _g_index;
			_tmp5_ = _g_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _g_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _g_index);
			g = (BirdFontGlyph*) _tmp7_;
			_tmp8_ = g;
			bird_font_bird_font_file_write_glyph (self, _tmp8_, os, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (g);
				return;
			}
			_g_object_unref0 (g);
		}
	}
}

void
bird_font_bird_font_file_write_glyph (BirdFontBirdFontFile* self,
                                      BirdFontGlyph* g,
                                      GDataOutputStream* os,
                                      GError** error)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gdouble _tmp2_;
	gdouble _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	gdouble _tmp7_;
	gdouble _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (g != NULL);
	g_return_if_fail (os != NULL);
	_tmp0_ = g_strdup_printf ("%i", g->version_id);
	_tmp1_ = _tmp0_;
	_tmp2_ = bird_font_glyph_get_left_limit (g);
	_tmp3_ = _tmp2_;
	_tmp4_ = bird_font_bird_font_file_double_to_string (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = string_to_string (_tmp5_);
	_tmp7_ = bird_font_glyph_get_right_limit (g);
	_tmp8_ = _tmp7_;
	_tmp9_ = bird_font_bird_font_file_double_to_string (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = string_to_string (_tmp10_);
	_tmp12_ = g_strconcat ("\t<glyph id=\"", _tmp1_, "\" left=\"", _tmp6_, "\" right=\"", _tmp11_, "\">\n", NULL);
	_tmp13_ = _tmp12_;
	g_data_output_stream_put_string (os, _tmp13_, NULL, &_inner_error0_);
	_g_free0 (_tmp13_);
	_g_free0 (_tmp10_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp1_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	{
		GeeArrayList* _layer_list = NULL;
		BirdFontLayer* _tmp14_;
		GeeArrayList* _tmp15_;
		gint _layer_size = 0;
		GeeArrayList* _tmp16_;
		gint _tmp17_;
		gint _tmp18_;
		gint _layer_index = 0;
		_tmp14_ = g->layers;
		_tmp15_ = _tmp14_->subgroups;
		_layer_list = _tmp15_;
		_tmp16_ = _layer_list;
		_tmp17_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp16_);
		_tmp18_ = _tmp17_;
		_layer_size = _tmp18_;
		_layer_index = -1;
		while (TRUE) {
			gint _tmp19_;
			gint _tmp20_;
			BirdFontLayer* layer = NULL;
			GeeArrayList* _tmp21_;
			gpointer _tmp22_;
			BirdFontLayer* _tmp23_;
			_layer_index = _layer_index + 1;
			_tmp19_ = _layer_index;
			_tmp20_ = _layer_size;
			if (!(_tmp19_ < _tmp20_)) {
				break;
			}
			_tmp21_ = _layer_list;
			_tmp22_ = gee_abstract_list_get ((GeeAbstractList*) _tmp21_, _layer_index);
			layer = (BirdFontLayer*) _tmp22_;
			_tmp23_ = layer;
			bird_font_bird_font_file_write_layer (self, _tmp23_, os, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (layer);
				return;
			}
			_g_object_unref0 (layer);
		}
	}
	bird_font_bird_font_file_write_glyph_background (self, g, os, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	g_data_output_stream_put_string (os, "\t</glyph>\n", NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

static void
bird_font_bird_font_file_write_layer (BirdFontBirdFontFile* self,
                                      BirdFontLayer* layer,
                                      GDataOutputStream* os,
                                      GError** error)
{
	gchar* data = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	BirdFontPathList* all_paths = NULL;
	BirdFontPathList* _tmp6_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (layer != NULL);
	g_return_if_fail (os != NULL);
	_tmp0_ = layer->name;
	_tmp1_ = string_to_string (_tmp0_);
	_tmp2_ = bool_to_string (layer->visible);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat ("\t\t<layer name= \"", _tmp1_, "\" visible=\"", _tmp3_, "\">\n", NULL);
	_tmp5_ = _tmp4_;
	g_data_output_stream_put_string (os, _tmp5_, NULL, &_inner_error0_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (data);
		return;
	}
	_tmp6_ = bird_font_layer_get_all_paths (layer);
	all_paths = _tmp6_;
	{
		GeeArrayList* _p_list = NULL;
		BirdFontPathList* _tmp7_;
		GeeArrayList* _tmp8_;
		gint _p_size = 0;
		GeeArrayList* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		gint _p_index = 0;
		_tmp7_ = all_paths;
		_tmp8_ = _tmp7_->paths;
		_p_list = _tmp8_;
		_tmp9_ = _p_list;
		_tmp10_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp9_);
		_tmp11_ = _tmp10_;
		_p_size = _tmp11_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp12_;
			gint _tmp13_;
			BirdFontPath* p = NULL;
			GeeArrayList* _tmp14_;
			gpointer _tmp15_;
			BirdFontPath* _tmp16_;
			gchar* _tmp17_;
			const gchar* _tmp18_;
			_p_index = _p_index + 1;
			_tmp12_ = _p_index;
			_tmp13_ = _p_size;
			if (!(_tmp12_ < _tmp13_)) {
				break;
			}
			_tmp14_ = _p_list;
			_tmp15_ = gee_abstract_list_get ((GeeAbstractList*) _tmp14_, _p_index);
			p = (BirdFontPath*) _tmp15_;
			_tmp16_ = p;
			_tmp17_ = bird_font_bird_font_file_get_point_data (_tmp16_);
			_g_free0 (data);
			data = _tmp17_;
			_tmp18_ = data;
			if (g_strcmp0 (_tmp18_, "") != 0) {
				BirdFontPath* _tmp19_;
				gdouble _tmp20_;
				gdouble _tmp21_;
				BirdFontPath* _tmp30_;
				BirdFontPath* _tmp33_;
				const gchar* _tmp40_;
				const gchar* _tmp41_;
				gchar* _tmp42_;
				gchar* _tmp43_;
				g_data_output_stream_put_string (os, "\t\t\t<path ", NULL, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_propagate_error (error, _inner_error0_);
					_g_object_unref0 (p);
					_g_object_unref0 (all_paths);
					_g_free0 (data);
					return;
				}
				_tmp19_ = p;
				_tmp20_ = bird_font_path_get_stroke (_tmp19_);
				_tmp21_ = _tmp20_;
				if (_tmp21_ != ((gdouble) 0)) {
					BirdFontPath* _tmp22_;
					gdouble _tmp23_;
					gdouble _tmp24_;
					gchar* _tmp25_;
					gchar* _tmp26_;
					const gchar* _tmp27_;
					gchar* _tmp28_;
					gchar* _tmp29_;
					_tmp22_ = p;
					_tmp23_ = bird_font_path_get_stroke (_tmp22_);
					_tmp24_ = _tmp23_;
					_tmp25_ = bird_font_bird_font_file_double_to_string (_tmp24_);
					_tmp26_ = _tmp25_;
					_tmp27_ = string_to_string (_tmp26_);
					_tmp28_ = g_strconcat ("stroke=\"", _tmp27_, "\" ", NULL);
					_tmp29_ = _tmp28_;
					g_data_output_stream_put_string (os, _tmp29_, NULL, &_inner_error0_);
					_g_free0 (_tmp29_);
					_g_free0 (_tmp26_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						g_propagate_error (error, _inner_error0_);
						_g_object_unref0 (p);
						_g_object_unref0 (all_paths);
						_g_free0 (data);
						return;
					}
				}
				_tmp30_ = p;
				if (_tmp30_->line_cap != BIRD_FONT_LINE_CAP_BUTT) {
					BirdFontPath* _tmp31_;
					_tmp31_ = p;
					if (_tmp31_->line_cap == BIRD_FONT_LINE_CAP_ROUND) {
						g_data_output_stream_put_string (os, "cap=\"round\" ", NULL, &_inner_error0_);
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							g_propagate_error (error, _inner_error0_);
							_g_object_unref0 (p);
							_g_object_unref0 (all_paths);
							_g_free0 (data);
							return;
						}
					} else {
						BirdFontPath* _tmp32_;
						_tmp32_ = p;
						if (_tmp32_->line_cap == BIRD_FONT_LINE_CAP_SQUARE) {
							g_data_output_stream_put_string (os, "cap=\"square\" ", NULL, &_inner_error0_);
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
								g_propagate_error (error, _inner_error0_);
								_g_object_unref0 (p);
								_g_object_unref0 (all_paths);
								_g_free0 (data);
								return;
							}
						}
					}
				}
				_tmp33_ = p;
				if (_tmp33_->skew != ((gdouble) 0)) {
					BirdFontPath* _tmp34_;
					gchar* _tmp35_;
					gchar* _tmp36_;
					const gchar* _tmp37_;
					gchar* _tmp38_;
					gchar* _tmp39_;
					_tmp34_ = p;
					_tmp35_ = bird_font_bird_font_file_double_to_string (_tmp34_->skew);
					_tmp36_ = _tmp35_;
					_tmp37_ = string_to_string (_tmp36_);
					_tmp38_ = g_strconcat ("skew=\"", _tmp37_, "\" ", NULL);
					_tmp39_ = _tmp38_;
					g_data_output_stream_put_string (os, _tmp39_, NULL, &_inner_error0_);
					_g_free0 (_tmp39_);
					_g_free0 (_tmp36_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						g_propagate_error (error, _inner_error0_);
						_g_object_unref0 (p);
						_g_object_unref0 (all_paths);
						_g_free0 (data);
						return;
					}
				}
				_tmp40_ = data;
				_tmp41_ = string_to_string (_tmp40_);
				_tmp42_ = g_strconcat ("data=\"", _tmp41_, "\" />\n", NULL);
				_tmp43_ = _tmp42_;
				g_data_output_stream_put_string (os, _tmp43_, NULL, &_inner_error0_);
				_g_free0 (_tmp43_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_propagate_error (error, _inner_error0_);
					_g_object_unref0 (p);
					_g_object_unref0 (all_paths);
					_g_free0 (data);
					return;
				}
			}
			_g_object_unref0 (p);
		}
	}
	g_data_output_stream_put_string (os, "\t\t</layer>\n", NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (all_paths);
		_g_free0 (data);
		return;
	}
	_g_object_unref0 (all_paths);
	_g_free0 (data);
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

gchar*
bird_font_bird_font_file_double_to_string (gdouble n)
{
	gchar* d = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	_tmp0_ = double_to_string (n);
	d = _tmp0_;
	_tmp1_ = string_replace (d, ",", ".");
	result = _tmp1_;
	_g_free0 (d);
	return result;
}

/** Get control points in BirdFont format. This function is uses a
 * cartesian coordinate system with origo in the middle.
 * 
 * Instructions:
 * R - Start point for a quadratic path
 * S - Start point for a double quadratic path
 * B - Start point for a cubic path
 * K - Line with quadratic control points
 * L - Line with double quadratic control points
 * M - Line with cubic control points
 * Q - Quadratic Bézier path
 * D - Two quadratic off curve points
 * C - Cubic Bézier path
 * 
 * T - Tie handles for previous curve
 * 
 * O - Keep open (do not close path)
 */
gchar*
bird_font_bird_font_file_get_point_data (BirdFontPath* pl)
{
	GString* data = NULL;
	GString* _tmp0_;
	BirdFontEditPoint* n = NULL;
	BirdFontEditPoint* m = NULL;
	gint i = 0;
	GeeArrayList* _tmp1_;
	GeeArrayList* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	GeeArrayList* _tmp8_;
	GeeArrayList* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	GeeArrayList* _tmp31_;
	GeeArrayList* _tmp32_;
	gint _tmp33_;
	gint _tmp34_;
	GString* _tmp95_;
	GeeArrayList* _tmp96_;
	GeeArrayList* _tmp97_;
	gpointer _tmp98_;
	BirdFontEditPoint* _tmp99_;
	BirdFontEditPoint* _tmp100_;
	GString* _tmp101_;
	GString* _tmp103_;
	const gchar* _tmp104_;
	gchar* _tmp105_;
	gchar* result;
	g_return_val_if_fail (pl != NULL, NULL);
	_tmp0_ = g_string_new ("");
	data = _tmp0_;
	n = NULL;
	i = 0;
	_tmp1_ = bird_font_path_get_points (pl);
	_tmp2_ = _tmp1_;
	_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == 0) {
		GString* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp5_ = data;
		_tmp6_ = _tmp5_->str;
		_tmp7_ = g_strdup (_tmp6_);
		result = _tmp7_;
		_g_object_unref0 (m);
		_g_object_unref0 (n);
		_g_string_free0 (data);
		return result;
	}
	_tmp8_ = bird_font_path_get_points (pl);
	_tmp9_ = _tmp8_;
	_tmp10_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp9_);
	_tmp11_ = _tmp10_;
	if (_tmp11_ == 1) {
		GeeArrayList* _tmp12_;
		GeeArrayList* _tmp13_;
		gpointer _tmp14_;
		BirdFontEditPoint* _tmp15_;
		GString* _tmp16_;
		GString* _tmp17_;
		GeeArrayList* _tmp18_;
		GeeArrayList* _tmp19_;
		gpointer _tmp20_;
		BirdFontEditPoint* _tmp21_;
		GeeArrayList* _tmp22_;
		GeeArrayList* _tmp23_;
		gpointer _tmp24_;
		BirdFontEditPoint* _tmp25_;
		GString* _tmp26_;
		GString* _tmp28_;
		const gchar* _tmp29_;
		gchar* _tmp30_;
		_tmp12_ = bird_font_path_get_points (pl);
		_tmp13_ = _tmp12_;
		_tmp14_ = gee_abstract_list_get ((GeeAbstractList*) _tmp13_, 0);
		_tmp15_ = (BirdFontEditPoint*) _tmp14_;
		_tmp16_ = data;
		bird_font_bird_font_file_add_start_point (_tmp15_, _tmp16_);
		_g_object_unref0 (_tmp15_);
		_tmp17_ = data;
		g_string_append (_tmp17_, " ");
		_tmp18_ = bird_font_path_get_points (pl);
		_tmp19_ = _tmp18_;
		_tmp20_ = gee_abstract_list_get ((GeeAbstractList*) _tmp19_, 0);
		_tmp21_ = (BirdFontEditPoint*) _tmp20_;
		_tmp22_ = bird_font_path_get_points (pl);
		_tmp23_ = _tmp22_;
		_tmp24_ = gee_abstract_list_get ((GeeAbstractList*) _tmp23_, 0);
		_tmp25_ = (BirdFontEditPoint*) _tmp24_;
		_tmp26_ = data;
		bird_font_bird_font_file_add_next_point (_tmp21_, _tmp25_, _tmp26_);
		_g_object_unref0 (_tmp25_);
		_g_object_unref0 (_tmp21_);
		if (bird_font_path_is_open (pl)) {
			GString* _tmp27_;
			_tmp27_ = data;
			g_string_append (_tmp27_, " O");
		}
		_tmp28_ = data;
		_tmp29_ = _tmp28_->str;
		_tmp30_ = g_strdup (_tmp29_);
		result = _tmp30_;
		_g_object_unref0 (m);
		_g_object_unref0 (n);
		_g_string_free0 (data);
		return result;
	}
	_tmp31_ = bird_font_path_get_points (pl);
	_tmp32_ = _tmp31_;
	_tmp33_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp32_);
	_tmp34_ = _tmp33_;
	if (_tmp34_ == 2) {
		GeeArrayList* _tmp35_;
		GeeArrayList* _tmp36_;
		gpointer _tmp37_;
		BirdFontEditPoint* _tmp38_;
		GString* _tmp39_;
		GString* _tmp40_;
		GeeArrayList* _tmp41_;
		GeeArrayList* _tmp42_;
		gpointer _tmp43_;
		BirdFontEditPoint* _tmp44_;
		GeeArrayList* _tmp45_;
		GeeArrayList* _tmp46_;
		GeeArrayList* _tmp47_;
		GeeArrayList* _tmp48_;
		gint _tmp49_;
		gint _tmp50_;
		gpointer _tmp51_;
		BirdFontEditPoint* _tmp52_;
		GString* _tmp53_;
		GString* _tmp54_;
		GeeArrayList* _tmp55_;
		GeeArrayList* _tmp56_;
		GeeArrayList* _tmp57_;
		GeeArrayList* _tmp58_;
		gint _tmp59_;
		gint _tmp60_;
		gpointer _tmp61_;
		BirdFontEditPoint* _tmp62_;
		GeeArrayList* _tmp63_;
		GeeArrayList* _tmp64_;
		gpointer _tmp65_;
		BirdFontEditPoint* _tmp66_;
		GString* _tmp67_;
		GString* _tmp69_;
		const gchar* _tmp70_;
		gchar* _tmp71_;
		_tmp35_ = bird_font_path_get_points (pl);
		_tmp36_ = _tmp35_;
		_tmp37_ = gee_abstract_list_get ((GeeAbstractList*) _tmp36_, 0);
		_tmp38_ = (BirdFontEditPoint*) _tmp37_;
		_tmp39_ = data;
		bird_font_bird_font_file_add_start_point (_tmp38_, _tmp39_);
		_g_object_unref0 (_tmp38_);
		_tmp40_ = data;
		g_string_append (_tmp40_, " ");
		_tmp41_ = bird_font_path_get_points (pl);
		_tmp42_ = _tmp41_;
		_tmp43_ = gee_abstract_list_get ((GeeAbstractList*) _tmp42_, 0);
		_tmp44_ = (BirdFontEditPoint*) _tmp43_;
		_tmp45_ = bird_font_path_get_points (pl);
		_tmp46_ = _tmp45_;
		_tmp47_ = bird_font_path_get_points (pl);
		_tmp48_ = _tmp47_;
		_tmp49_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp48_);
		_tmp50_ = _tmp49_;
		_tmp51_ = gee_abstract_list_get ((GeeAbstractList*) _tmp46_, _tmp50_ - 1);
		_tmp52_ = (BirdFontEditPoint*) _tmp51_;
		_tmp53_ = data;
		bird_font_bird_font_file_add_next_point (_tmp44_, _tmp52_, _tmp53_);
		_g_object_unref0 (_tmp52_);
		_g_object_unref0 (_tmp44_);
		_tmp54_ = data;
		g_string_append (_tmp54_, " ");
		_tmp55_ = bird_font_path_get_points (pl);
		_tmp56_ = _tmp55_;
		_tmp57_ = bird_font_path_get_points (pl);
		_tmp58_ = _tmp57_;
		_tmp59_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp58_);
		_tmp60_ = _tmp59_;
		_tmp61_ = gee_abstract_list_get ((GeeAbstractList*) _tmp56_, _tmp60_ - 1);
		_tmp62_ = (BirdFontEditPoint*) _tmp61_;
		_tmp63_ = bird_font_path_get_points (pl);
		_tmp64_ = _tmp63_;
		_tmp65_ = gee_abstract_list_get ((GeeAbstractList*) _tmp64_, 0);
		_tmp66_ = (BirdFontEditPoint*) _tmp65_;
		_tmp67_ = data;
		bird_font_bird_font_file_add_next_point (_tmp62_, _tmp66_, _tmp67_);
		_g_object_unref0 (_tmp66_);
		_g_object_unref0 (_tmp62_);
		if (bird_font_path_is_open (pl)) {
			GString* _tmp68_;
			_tmp68_ = data;
			g_string_append (_tmp68_, " O");
		}
		_tmp69_ = data;
		_tmp70_ = _tmp69_->str;
		_tmp71_ = g_strdup (_tmp70_);
		result = _tmp71_;
		_g_object_unref0 (m);
		_g_object_unref0 (n);
		_g_string_free0 (data);
		return result;
	}
	bird_font_path_create_list (pl);
	{
		GeeArrayList* _e_list = NULL;
		GeeArrayList* _tmp72_;
		GeeArrayList* _tmp73_;
		gint _e_size = 0;
		GeeArrayList* _tmp74_;
		gint _tmp75_;
		gint _tmp76_;
		gint _e_index = 0;
		_tmp72_ = bird_font_path_get_points (pl);
		_tmp73_ = _tmp72_;
		_e_list = _tmp73_;
		_tmp74_ = _e_list;
		_tmp75_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp74_);
		_tmp76_ = _tmp75_;
		_e_size = _tmp76_;
		_e_index = -1;
		while (TRUE) {
			gint _tmp77_;
			gint _tmp78_;
			BirdFontEditPoint* e = NULL;
			GeeArrayList* _tmp79_;
			gpointer _tmp80_;
			BirdFontEditPoint* _tmp86_;
			BirdFontEditPoint* _tmp87_;
			GString* _tmp88_;
			BirdFontEditPoint* _tmp89_;
			BirdFontEditPoint* _tmp90_;
			GString* _tmp91_;
			BirdFontEditPoint* _tmp92_;
			BirdFontEditPoint* _tmp93_;
			gint _tmp94_;
			_e_index = _e_index + 1;
			_tmp77_ = _e_index;
			_tmp78_ = _e_size;
			if (!(_tmp77_ < _tmp78_)) {
				break;
			}
			_tmp79_ = _e_list;
			_tmp80_ = gee_abstract_list_get ((GeeAbstractList*) _tmp79_, _e_index);
			e = (BirdFontEditPoint*) _tmp80_;
			if (i == 0) {
				BirdFontEditPoint* _tmp81_;
				GString* _tmp82_;
				gint _tmp83_;
				BirdFontEditPoint* _tmp84_;
				BirdFontEditPoint* _tmp85_;
				_tmp81_ = e;
				_tmp82_ = data;
				bird_font_bird_font_file_add_start_point (_tmp81_, _tmp82_);
				_tmp83_ = i;
				i = _tmp83_ + 1;
				_tmp84_ = e;
				_tmp85_ = _g_object_ref0 (_tmp84_);
				_g_object_unref0 (n);
				n = _tmp85_;
				_g_object_unref0 (e);
				continue;
			}
			_tmp86_ = n;
			_tmp87_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp86_, BIRD_FONT_TYPE_EDIT_POINT, BirdFontEditPoint));
			_g_object_unref0 (m);
			m = _tmp87_;
			_tmp88_ = data;
			g_string_append (_tmp88_, " ");
			_tmp89_ = m;
			_tmp90_ = e;
			_tmp91_ = data;
			bird_font_bird_font_file_add_next_point (_tmp89_, _tmp90_, _tmp91_);
			_tmp92_ = e;
			_tmp93_ = _g_object_ref0 (_tmp92_);
			_g_object_unref0 (n);
			n = _tmp93_;
			_tmp94_ = i;
			i = _tmp94_ + 1;
			_g_object_unref0 (e);
		}
	}
	_tmp95_ = data;
	g_string_append (_tmp95_, " ");
	_tmp96_ = bird_font_path_get_points (pl);
	_tmp97_ = _tmp96_;
	_tmp98_ = gee_abstract_list_get ((GeeAbstractList*) _tmp97_, 0);
	_g_object_unref0 (m);
	m = (BirdFontEditPoint*) _tmp98_;
	_tmp99_ = n;
	_tmp100_ = m;
	_tmp101_ = data;
	bird_font_bird_font_file_add_next_point (G_TYPE_CHECK_INSTANCE_CAST (_tmp99_, BIRD_FONT_TYPE_EDIT_POINT, BirdFontEditPoint), _tmp100_, _tmp101_);
	if (bird_font_path_is_open (pl)) {
		GString* _tmp102_;
		_tmp102_ = data;
		g_string_append (_tmp102_, " O");
	}
	_tmp103_ = data;
	_tmp104_ = _tmp103_->str;
	_tmp105_ = g_strdup (_tmp104_);
	result = _tmp105_;
	_g_object_unref0 (m);
	_g_object_unref0 (n);
	_g_string_free0 (data);
	return result;
}

static void
bird_font_bird_font_file_add_start_point (BirdFontEditPoint* e,
                                          GString* data)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (e != NULL);
	g_return_if_fail (data != NULL);
	if (e->type == BIRD_FONT_POINT_TYPE_CUBIC) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = e->type == BIRD_FONT_POINT_TYPE_LINE_CUBIC;
	}
	if (_tmp0_) {
		bird_font_bird_font_file_add_cubic_start (e, data);
	} else {
		gboolean _tmp1_ = FALSE;
		if (e->type == BIRD_FONT_POINT_TYPE_DOUBLE_CURVE) {
			_tmp1_ = TRUE;
		} else {
			_tmp1_ = e->type == BIRD_FONT_POINT_TYPE_LINE_DOUBLE_CURVE;
		}
		if (_tmp1_) {
			bird_font_bird_font_file_add_double_start (e, data);
		} else {
			gboolean _tmp2_ = FALSE;
			if (e->type == BIRD_FONT_POINT_TYPE_QUADRATIC) {
				_tmp2_ = TRUE;
			} else {
				_tmp2_ = e->type == BIRD_FONT_POINT_TYPE_LINE_QUADRATIC;
			}
			if (_tmp2_) {
				bird_font_bird_font_file_add_quadratic_start (e, data);
			} else {
				GEnumValue* _tmp3_;
				gchar* _tmp4_;
				gchar* _tmp5_;
				_tmp3_ = g_enum_get_value (g_type_class_ref (BIRD_FONT_TYPE_POINT_TYPE), e->type);
				_tmp4_ = g_strconcat ("Unexpected start point type: ", (_tmp3_ != NULL) ? _tmp3_->value_name : NULL, NULL);
				_tmp5_ = _tmp4_;
				g_warning ("BirdFontFile.vala:608: %s", _tmp5_);
				_g_free0 (_tmp5_);
			}
		}
	}
}

static void
bird_font_bird_font_file_add_quadratic_start (BirdFontEditPoint* p,
                                              GString* data)
{
	gchar* x = NULL;
	gchar* y = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	g_return_if_fail (p != NULL);
	g_return_if_fail (data != NULL);
	_tmp0_ = bird_font_bird_font_file_round (p->x, 5);
	_g_free0 (x);
	x = _tmp0_;
	_tmp1_ = bird_font_bird_font_file_round (p->y, 5);
	_g_free0 (y);
	y = _tmp1_;
	_tmp2_ = string_to_string (x);
	_tmp3_ = string_to_string (y);
	_tmp4_ = g_strconcat ("R ", _tmp2_, ",", _tmp3_, NULL);
	_tmp5_ = _tmp4_;
	g_string_append (data, _tmp5_);
	_g_free0 (_tmp5_);
	_g_free0 (y);
	_g_free0 (x);
}

static void
bird_font_bird_font_file_add_double_start (BirdFontEditPoint* p,
                                           GString* data)
{
	gdouble x = 0.0;
	gdouble y = 0.0;
	gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	g_return_if_fail (p != NULL);
	g_return_if_fail (data != NULL);
	x = p->x;
	y = p->y;
	_tmp0_ = bird_font_bird_font_file_round (x, 5);
	_tmp1_ = _tmp0_;
	_tmp2_ = string_to_string (_tmp1_);
	_tmp3_ = bird_font_bird_font_file_round (y, 5);
	_tmp4_ = _tmp3_;
	_tmp5_ = string_to_string (_tmp4_);
	_tmp6_ = g_strconcat ("S ", _tmp2_, ",", _tmp5_, NULL);
	_tmp7_ = _tmp6_;
	g_string_append (data, _tmp7_);
	_g_free0 (_tmp7_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp1_);
}

static void
bird_font_bird_font_file_add_cubic_start (BirdFontEditPoint* p,
                                          GString* data)
{
	gdouble x = 0.0;
	gdouble y = 0.0;
	gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	g_return_if_fail (p != NULL);
	g_return_if_fail (data != NULL);
	x = p->x;
	y = p->y;
	_tmp0_ = bird_font_bird_font_file_round (x, 5);
	_tmp1_ = _tmp0_;
	_tmp2_ = string_to_string (_tmp1_);
	_tmp3_ = bird_font_bird_font_file_round (y, 5);
	_tmp4_ = _tmp3_;
	_tmp5_ = string_to_string (_tmp4_);
	_tmp6_ = g_strconcat ("B ", _tmp2_, ",", _tmp5_, NULL);
	_tmp7_ = _tmp6_;
	g_string_append (data, _tmp7_);
	_g_free0 (_tmp7_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp1_);
}

static void
bird_font_bird_font_file_add_quadratic_line_to (BirdFontEditPoint* p,
                                                GString* data)
{
	gchar* x = NULL;
	gchar* y = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	g_return_if_fail (p != NULL);
	g_return_if_fail (data != NULL);
	_tmp0_ = bird_font_bird_font_file_round (p->x, 5);
	_g_free0 (x);
	x = _tmp0_;
	_tmp1_ = bird_font_bird_font_file_round (p->y, 5);
	_g_free0 (y);
	y = _tmp1_;
	_tmp2_ = string_to_string (x);
	_tmp3_ = string_to_string (y);
	_tmp4_ = g_strconcat ("K ", _tmp2_, ",", _tmp3_, NULL);
	_tmp5_ = _tmp4_;
	g_string_append (data, _tmp5_);
	_g_free0 (_tmp5_);
	_g_free0 (y);
	_g_free0 (x);
}

static void
bird_font_bird_font_file_add_line_to (BirdFontEditPoint* p,
                                      GString* data)
{
	gdouble x = 0.0;
	gdouble y = 0.0;
	gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	g_return_if_fail (p != NULL);
	g_return_if_fail (data != NULL);
	x = p->x;
	y = p->y;
	_tmp0_ = bird_font_bird_font_file_round (x, 5);
	_tmp1_ = _tmp0_;
	_tmp2_ = string_to_string (_tmp1_);
	_tmp3_ = bird_font_bird_font_file_round (y, 5);
	_tmp4_ = _tmp3_;
	_tmp5_ = string_to_string (_tmp4_);
	_tmp6_ = g_strconcat ("L ", _tmp2_, ",", _tmp5_, NULL);
	_tmp7_ = _tmp6_;
	g_string_append (data, _tmp7_);
	_g_free0 (_tmp7_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp1_);
}

static void
bird_font_bird_font_file_add_cubic_line_to (BirdFontEditPoint* p,
                                            GString* data)
{
	gdouble x = 0.0;
	gdouble y = 0.0;
	gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	g_return_if_fail (p != NULL);
	g_return_if_fail (data != NULL);
	x = p->x;
	y = p->y;
	_tmp0_ = bird_font_bird_font_file_round (x, 5);
	_tmp1_ = _tmp0_;
	_tmp2_ = string_to_string (_tmp1_);
	_tmp3_ = bird_font_bird_font_file_round (y, 5);
	_tmp4_ = _tmp3_;
	_tmp5_ = string_to_string (_tmp4_);
	_tmp6_ = g_strconcat ("M ", _tmp2_, ",", _tmp5_, NULL);
	_tmp7_ = _tmp6_;
	g_string_append (data, _tmp7_);
	_g_free0 (_tmp7_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp1_);
}

static void
bird_font_bird_font_file_quadratic_line (BirdFontPath* path,
                                         const gchar* px,
                                         const gchar* py)
{
	BirdFontEditPoint* ep = NULL;
	BirdFontEditPoint* _tmp0_;
	BirdFontEditPoint* _tmp1_;
	BirdFontEditPoint* _tmp2_;
	BirdFontEditPointHandle* _tmp3_;
	BirdFontEditPointHandle* _tmp4_;
	g_return_if_fail (path != NULL);
	g_return_if_fail (px != NULL);
	g_return_if_fail (py != NULL);
	_tmp0_ = bird_font_path_add (path, bird_font_bird_font_file_parse_double (px), bird_font_bird_font_file_parse_double (py));
	_tmp1_ = _tmp0_;
	_g_object_unref0 (_tmp1_);
	_tmp2_ = bird_font_path_get_last_point (path);
	_g_object_unref0 (ep);
	ep = _tmp2_;
	_tmp3_ = bird_font_edit_point_get_right_handle (ep);
	_tmp3_->type = BIRD_FONT_POINT_TYPE_LINE_QUADRATIC;
	_tmp4_ = bird_font_edit_point_get_left_handle (ep);
	_tmp4_->type = BIRD_FONT_POINT_TYPE_LINE_QUADRATIC;
	ep->type = BIRD_FONT_POINT_TYPE_LINE_QUADRATIC;
	bird_font_path_recalculate_linear_handles_for_point (path, ep);
	_g_object_unref0 (ep);
}

static void
bird_font_bird_font_file_add_quadratic (BirdFontEditPoint* start,
                                        BirdFontEditPoint* end,
                                        GString* data)
{
	BirdFontEditPointHandle* h = NULL;
	BirdFontEditPointHandle* _tmp0_;
	BirdFontEditPointHandle* _tmp1_;
	gdouble x0 = 0.0;
	gdouble y0 = 0.0;
	gdouble x1 = 0.0;
	gdouble y1 = 0.0;
	gdouble _tmp2_;
	gdouble _tmp3_;
	gdouble _tmp4_;
	gdouble _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	g_return_if_fail (start != NULL);
	g_return_if_fail (end != NULL);
	g_return_if_fail (data != NULL);
	_tmp0_ = bird_font_edit_point_get_right_handle (start);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	h = _tmp1_;
	_tmp2_ = bird_font_edit_point_handle_get_x (h);
	_tmp3_ = _tmp2_;
	x0 = _tmp3_;
	_tmp4_ = bird_font_edit_point_handle_get_y (h);
	_tmp5_ = _tmp4_;
	y0 = _tmp5_;
	x1 = end->x;
	y1 = end->y;
	_tmp6_ = bird_font_bird_font_file_round (x0, 5);
	_tmp7_ = _tmp6_;
	_tmp8_ = string_to_string (_tmp7_);
	_tmp9_ = bird_font_bird_font_file_round (y0, 5);
	_tmp10_ = _tmp9_;
	_tmp11_ = string_to_string (_tmp10_);
	_tmp12_ = bird_font_bird_font_file_round (x1, 5);
	_tmp13_ = _tmp12_;
	_tmp14_ = string_to_string (_tmp13_);
	_tmp15_ = bird_font_bird_font_file_round (y1, 5);
	_tmp16_ = _tmp15_;
	_tmp17_ = string_to_string (_tmp16_);
	_tmp18_ = g_strconcat ("Q ", _tmp8_, ",", _tmp11_, " ", _tmp14_, ",", _tmp17_, NULL);
	_tmp19_ = _tmp18_;
	g_string_append (data, _tmp19_);
	_g_free0 (_tmp19_);
	_g_free0 (_tmp16_);
	_g_free0 (_tmp13_);
	_g_free0 (_tmp10_);
	_g_free0 (_tmp7_);
	_g_object_unref0 (h);
}

static void
bird_font_bird_font_file_add_double (BirdFontEditPoint* start,
                                     BirdFontEditPoint* end,
                                     GString* data)
{
	BirdFontEditPointHandle* h1 = NULL;
	BirdFontEditPointHandle* _tmp0_;
	BirdFontEditPointHandle* _tmp1_;
	BirdFontEditPointHandle* h2 = NULL;
	BirdFontEditPointHandle* _tmp2_;
	BirdFontEditPointHandle* _tmp3_;
	gdouble x0 = 0.0;
	gdouble y0 = 0.0;
	gdouble x1 = 0.0;
	gdouble y1 = 0.0;
	gdouble x2 = 0.0;
	gdouble y2 = 0.0;
	gdouble _tmp4_;
	gdouble _tmp5_;
	gdouble _tmp6_;
	gdouble _tmp7_;
	gdouble _tmp8_;
	gdouble _tmp9_;
	gdouble _tmp10_;
	gdouble _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	const gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	const gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	const gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	const gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	g_return_if_fail (start != NULL);
	g_return_if_fail (end != NULL);
	g_return_if_fail (data != NULL);
	_tmp0_ = bird_font_edit_point_get_right_handle (start);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	h1 = _tmp1_;
	_tmp2_ = bird_font_edit_point_get_left_handle (end);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	h2 = _tmp3_;
	_tmp4_ = bird_font_edit_point_handle_get_x (h1);
	_tmp5_ = _tmp4_;
	x0 = _tmp5_;
	_tmp6_ = bird_font_edit_point_handle_get_y (h1);
	_tmp7_ = _tmp6_;
	y0 = _tmp7_;
	_tmp8_ = bird_font_edit_point_handle_get_x (h2);
	_tmp9_ = _tmp8_;
	x1 = _tmp9_;
	_tmp10_ = bird_font_edit_point_handle_get_y (h2);
	_tmp11_ = _tmp10_;
	y1 = _tmp11_;
	x2 = end->x;
	y2 = end->y;
	_tmp12_ = bird_font_bird_font_file_round (x0, 5);
	_tmp13_ = _tmp12_;
	_tmp14_ = string_to_string (_tmp13_);
	_tmp15_ = bird_font_bird_font_file_round (y0, 5);
	_tmp16_ = _tmp15_;
	_tmp17_ = string_to_string (_tmp16_);
	_tmp18_ = bird_font_bird_font_file_round (x1, 5);
	_tmp19_ = _tmp18_;
	_tmp20_ = string_to_string (_tmp19_);
	_tmp21_ = bird_font_bird_font_file_round (y1, 5);
	_tmp22_ = _tmp21_;
	_tmp23_ = string_to_string (_tmp22_);
	_tmp24_ = bird_font_bird_font_file_round (x2, 5);
	_tmp25_ = _tmp24_;
	_tmp26_ = string_to_string (_tmp25_);
	_tmp27_ = bird_font_bird_font_file_round (y2, 5);
	_tmp28_ = _tmp27_;
	_tmp29_ = string_to_string (_tmp28_);
	_tmp30_ = g_strconcat ("D ", _tmp14_, ",", _tmp17_, " ", _tmp20_, ",", _tmp23_, " ", _tmp26_, ",", _tmp29_, NULL);
	_tmp31_ = _tmp30_;
	g_string_append (data, _tmp31_);
	_g_free0 (_tmp31_);
	_g_free0 (_tmp28_);
	_g_free0 (_tmp25_);
	_g_free0 (_tmp22_);
	_g_free0 (_tmp19_);
	_g_free0 (_tmp16_);
	_g_free0 (_tmp13_);
	_g_object_unref0 (h2);
	_g_object_unref0 (h1);
}

static void
bird_font_bird_font_file_add_cubic (BirdFontEditPoint* start,
                                    BirdFontEditPoint* end,
                                    GString* data)
{
	BirdFontEditPointHandle* h1 = NULL;
	BirdFontEditPointHandle* _tmp0_;
	BirdFontEditPointHandle* _tmp1_;
	BirdFontEditPointHandle* h2 = NULL;
	BirdFontEditPointHandle* _tmp2_;
	BirdFontEditPointHandle* _tmp3_;
	gdouble x0 = 0.0;
	gdouble y0 = 0.0;
	gdouble x1 = 0.0;
	gdouble y1 = 0.0;
	gdouble x2 = 0.0;
	gdouble y2 = 0.0;
	gdouble _tmp4_;
	gdouble _tmp5_;
	gdouble _tmp6_;
	gdouble _tmp7_;
	gdouble _tmp8_;
	gdouble _tmp9_;
	gdouble _tmp10_;
	gdouble _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	const gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	const gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	const gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	const gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	g_return_if_fail (start != NULL);
	g_return_if_fail (end != NULL);
	g_return_if_fail (data != NULL);
	_tmp0_ = bird_font_edit_point_get_right_handle (start);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	h1 = _tmp1_;
	_tmp2_ = bird_font_edit_point_get_left_handle (end);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	h2 = _tmp3_;
	_tmp4_ = bird_font_edit_point_handle_get_x (h1);
	_tmp5_ = _tmp4_;
	x0 = _tmp5_;
	_tmp6_ = bird_font_edit_point_handle_get_y (h1);
	_tmp7_ = _tmp6_;
	y0 = _tmp7_;
	_tmp8_ = bird_font_edit_point_handle_get_x (h2);
	_tmp9_ = _tmp8_;
	x1 = _tmp9_;
	_tmp10_ = bird_font_edit_point_handle_get_y (h2);
	_tmp11_ = _tmp10_;
	y1 = _tmp11_;
	x2 = end->x;
	y2 = end->y;
	_tmp12_ = bird_font_bird_font_file_round (x0, 5);
	_tmp13_ = _tmp12_;
	_tmp14_ = string_to_string (_tmp13_);
	_tmp15_ = bird_font_bird_font_file_round (y0, 5);
	_tmp16_ = _tmp15_;
	_tmp17_ = string_to_string (_tmp16_);
	_tmp18_ = bird_font_bird_font_file_round (x1, 5);
	_tmp19_ = _tmp18_;
	_tmp20_ = string_to_string (_tmp19_);
	_tmp21_ = bird_font_bird_font_file_round (y1, 5);
	_tmp22_ = _tmp21_;
	_tmp23_ = string_to_string (_tmp22_);
	_tmp24_ = bird_font_bird_font_file_round (x2, 5);
	_tmp25_ = _tmp24_;
	_tmp26_ = string_to_string (_tmp25_);
	_tmp27_ = bird_font_bird_font_file_round (y2, 5);
	_tmp28_ = _tmp27_;
	_tmp29_ = string_to_string (_tmp28_);
	_tmp30_ = g_strconcat ("C ", _tmp14_, ",", _tmp17_, " ", _tmp20_, ",", _tmp23_, " ", _tmp26_, ",", _tmp29_, NULL);
	_tmp31_ = _tmp30_;
	g_string_append (data, _tmp31_);
	_g_free0 (_tmp31_);
	_g_free0 (_tmp28_);
	_g_free0 (_tmp25_);
	_g_free0 (_tmp22_);
	_g_free0 (_tmp19_);
	_g_free0 (_tmp16_);
	_g_free0 (_tmp13_);
	_g_object_unref0 (h2);
	_g_object_unref0 (h1);
}

static void
bird_font_bird_font_file_add_next_point (BirdFontEditPoint* start,
                                         BirdFontEditPoint* end,
                                         GString* data)
{
	gboolean _tmp0_ = FALSE;
	BirdFontEditPointHandle* _tmp1_;
	gboolean _tmp30_;
	gboolean _tmp31_;
	g_return_if_fail (start != NULL);
	g_return_if_fail (end != NULL);
	g_return_if_fail (data != NULL);
	_tmp1_ = start->right_handle;
	if (_tmp1_->type == BIRD_FONT_POINT_TYPE_LINE_QUADRATIC) {
		BirdFontEditPointHandle* _tmp2_;
		_tmp2_ = end->left_handle;
		_tmp0_ = _tmp2_->type == BIRD_FONT_POINT_TYPE_LINE_QUADRATIC;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		bird_font_bird_font_file_add_quadratic_line_to (end, data);
	} else {
		gboolean _tmp3_ = FALSE;
		BirdFontEditPointHandle* _tmp4_;
		_tmp4_ = start->right_handle;
		if (_tmp4_->type == BIRD_FONT_POINT_TYPE_LINE_DOUBLE_CURVE) {
			BirdFontEditPointHandle* _tmp5_;
			_tmp5_ = end->left_handle;
			_tmp3_ = _tmp5_->type == BIRD_FONT_POINT_TYPE_LINE_DOUBLE_CURVE;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			bird_font_bird_font_file_add_line_to (end, data);
		} else {
			gboolean _tmp6_ = FALSE;
			BirdFontEditPointHandle* _tmp7_;
			_tmp7_ = start->right_handle;
			if (_tmp7_->type == BIRD_FONT_POINT_TYPE_LINE_CUBIC) {
				BirdFontEditPointHandle* _tmp8_;
				_tmp8_ = end->left_handle;
				_tmp6_ = _tmp8_->type == BIRD_FONT_POINT_TYPE_LINE_CUBIC;
			} else {
				_tmp6_ = FALSE;
			}
			if (_tmp6_) {
				bird_font_bird_font_file_add_cubic_line_to (end, data);
			} else {
				gboolean _tmp9_ = FALSE;
				BirdFontEditPointHandle* _tmp10_;
				_tmp10_ = end->left_handle;
				if (_tmp10_->type == BIRD_FONT_POINT_TYPE_DOUBLE_CURVE) {
					_tmp9_ = TRUE;
				} else {
					BirdFontEditPointHandle* _tmp11_;
					_tmp11_ = start->right_handle;
					_tmp9_ = _tmp11_->type == BIRD_FONT_POINT_TYPE_DOUBLE_CURVE;
				}
				if (_tmp9_) {
					bird_font_bird_font_file_add_double (start, end, data);
				} else {
					gboolean _tmp12_ = FALSE;
					BirdFontEditPointHandle* _tmp13_;
					_tmp13_ = end->left_handle;
					if (_tmp13_->type == BIRD_FONT_POINT_TYPE_QUADRATIC) {
						_tmp12_ = TRUE;
					} else {
						BirdFontEditPointHandle* _tmp14_;
						_tmp14_ = start->right_handle;
						_tmp12_ = _tmp14_->type == BIRD_FONT_POINT_TYPE_QUADRATIC;
					}
					if (_tmp12_) {
						bird_font_bird_font_file_add_quadratic (start, end, data);
					} else {
						gboolean _tmp15_ = FALSE;
						BirdFontEditPointHandle* _tmp16_;
						_tmp16_ = end->left_handle;
						if (_tmp16_->type == BIRD_FONT_POINT_TYPE_CUBIC) {
							_tmp15_ = TRUE;
						} else {
							BirdFontEditPointHandle* _tmp17_;
							_tmp17_ = start->right_handle;
							_tmp15_ = _tmp17_->type == BIRD_FONT_POINT_TYPE_CUBIC;
						}
						if (_tmp15_) {
							bird_font_bird_font_file_add_cubic (start, end, data);
						} else {
							gboolean _tmp18_ = FALSE;
							BirdFontEditPointHandle* _tmp19_;
							_tmp19_ = start->right_handle;
							if (_tmp19_->type == BIRD_FONT_POINT_TYPE_LINE_CUBIC) {
								BirdFontEditPointHandle* _tmp20_;
								_tmp20_ = end->left_handle;
								_tmp18_ = _tmp20_->type == BIRD_FONT_POINT_TYPE_LINE_DOUBLE_CURVE;
							} else {
								_tmp18_ = FALSE;
							}
							if (_tmp18_) {
								bird_font_bird_font_file_add_line_to (end, data);
							} else {
								gboolean _tmp21_ = FALSE;
								BirdFontEditPointHandle* _tmp22_;
								_tmp22_ = start->right_handle;
								if (_tmp22_->type == BIRD_FONT_POINT_TYPE_LINE_DOUBLE_CURVE) {
									BirdFontEditPointHandle* _tmp23_;
									_tmp23_ = end->left_handle;
									_tmp21_ = _tmp23_->type == BIRD_FONT_POINT_TYPE_LINE_CUBIC;
								} else {
									_tmp21_ = FALSE;
								}
								if (_tmp21_) {
									bird_font_bird_font_file_add_line_to (end, data);
								} else {
									BirdFontEditPointHandle* _tmp24_;
									GEnumValue* _tmp25_;
									BirdFontEditPointHandle* _tmp26_;
									GEnumValue* _tmp27_;
									gchar* _tmp28_;
									gchar* _tmp29_;
									_tmp24_ = start->right_handle;
									_tmp25_ = g_enum_get_value (g_type_class_ref (BIRD_FONT_TYPE_POINT_TYPE), _tmp24_->type);
									_tmp26_ = end->left_handle;
									_tmp27_ = g_enum_get_value (g_type_class_ref (BIRD_FONT_TYPE_POINT_TYPE), _tmp26_->type);
									_tmp28_ = g_strconcat ("Unknown point type. \nStart handle: ", (_tmp25_ != NULL) ? _tmp25_->value_name : NULL, " \nStop handle: ", (_tmp27_ != NULL) ? _tmp27_->value_name : NULL, NULL);
									_tmp29_ = _tmp28_;
									g_warning ("BirdFontFile.vala:737: %s", _tmp29_);
									_g_free0 (_tmp29_);
									bird_font_bird_font_file_add_cubic (start, end, data);
								}
							}
						}
					}
				}
			}
		}
	}
	_tmp30_ = bird_font_edit_point_get_tie_handles (end);
	_tmp31_ = _tmp30_;
	if (_tmp31_) {
		g_string_append (data, " ");
		g_string_append (data, "T");
	}
}

static void
bird_font_bird_font_file_write_glyph_background (BirdFontBirdFontFile* self,
                                                 BirdFontGlyph* g,
                                                 GDataOutputStream* os,
                                                 GError** error)
{
	BirdFontBackgroundImage* bg = NULL;
	BirdFontBackgroundImage* background_image = NULL;
	gdouble pos_x = 0.0;
	gdouble pos_y = 0.0;
	gdouble scale_x = 0.0;
	gdouble scale_y = 0.0;
	gdouble rotation = 0.0;
	BirdFontBackgroundImage* _tmp0_;
	BirdFontBackgroundImage* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (g != NULL);
	g_return_if_fail (os != NULL);
	_tmp0_ = bird_font_glyph_get_background_image (g);
	_g_object_unref0 (bg);
	bg = _tmp0_;
	_tmp1_ = bg;
	if (_tmp1_ != NULL) {
		BirdFontBackgroundImage* _tmp2_;
		BirdFontBackgroundImage* _tmp3_;
		BirdFontBackgroundImage* _tmp4_;
		BirdFontBackgroundImage* _tmp5_;
		BirdFontBackgroundImage* _tmp6_;
		gdouble _tmp7_;
		gdouble _tmp8_;
		BirdFontBackgroundImage* _tmp9_;
		gdouble _tmp10_;
		gdouble _tmp11_;
		BirdFontBackgroundImage* _tmp12_;
		BirdFontBackgroundImage* _tmp13_;
		_tmp2_ = bg;
		_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, BIRD_FONT_TYPE_BACKGROUND_IMAGE, BirdFontBackgroundImage));
		_g_object_unref0 (background_image);
		background_image = _tmp3_;
		_tmp4_ = background_image;
		pos_x = _tmp4_->img_x;
		_tmp5_ = background_image;
		pos_y = _tmp5_->img_y;
		_tmp6_ = background_image;
		_tmp7_ = bird_font_background_image_get_img_scale_x (_tmp6_);
		_tmp8_ = _tmp7_;
		scale_x = _tmp8_;
		_tmp9_ = background_image;
		_tmp10_ = bird_font_background_image_get_img_scale_y (_tmp9_);
		_tmp11_ = _tmp10_;
		scale_y = _tmp11_;
		_tmp12_ = background_image;
		rotation = _tmp12_->img_rotation;
		_tmp13_ = background_image;
		if (bird_font_background_image_is_valid (_tmp13_)) {
			BirdFontBackgroundImage* _tmp14_;
			gchar* _tmp15_;
			gchar* _tmp16_;
			const gchar* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			gchar* _tmp20_;
			gchar* _tmp21_;
			gchar* _tmp22_;
			gchar* _tmp23_;
			gchar* _tmp24_;
			gchar* _tmp25_;
			gchar* _tmp26_;
			gchar* _tmp27_;
			gchar* _tmp28_;
			gchar* _tmp29_;
			_tmp14_ = background_image;
			_tmp15_ = bird_font_background_image_get_sha1 (_tmp14_);
			_tmp16_ = _tmp15_;
			_tmp17_ = string_to_string (_tmp16_);
			_tmp18_ = double_to_string (pos_x);
			_tmp19_ = _tmp18_;
			_tmp20_ = double_to_string (pos_y);
			_tmp21_ = _tmp20_;
			_tmp22_ = double_to_string (scale_x);
			_tmp23_ = _tmp22_;
			_tmp24_ = double_to_string (scale_y);
			_tmp25_ = _tmp24_;
			_tmp26_ = double_to_string (rotation);
			_tmp27_ = _tmp26_;
			_tmp28_ = g_strconcat ("\t\t<background sha1=\"", _tmp17_, "\" x=\"", _tmp19_, "\" y=\"", _tmp21_, "\" scale_x=\"", _tmp23_, "\" scale_y=\"", _tmp25_, "\" rotation=\"", _tmp27_, "\"/>\n", NULL);
			_tmp29_ = _tmp28_;
			g_data_output_stream_put_string (os, _tmp29_, NULL, &_inner_error0_);
			_g_free0 (_tmp29_);
			_g_free0 (_tmp27_);
			_g_free0 (_tmp25_);
			_g_free0 (_tmp23_);
			_g_free0 (_tmp21_);
			_g_free0 (_tmp19_);
			_g_free0 (_tmp16_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (background_image);
				_g_object_unref0 (bg);
				return;
			}
		}
	}
	_g_object_unref0 (background_image);
	_g_object_unref0 (bg);
}

static gboolean
bool_parse (const gchar* str)
{
	gboolean result;
	g_return_val_if_fail (str != NULL, FALSE);
	if (g_strcmp0 (str, "true") == 0) {
		result = TRUE;
		return result;
	} else {
		result = FALSE;
		return result;
	}
}

static gdouble
double_parse (const gchar* str)
{
	gdouble result;
	g_return_val_if_fail (str != NULL, 0.0);
	result = g_ascii_strtod (str, NULL);
	return result;
}

static gboolean
bird_font_bird_font_file_parse_file (BirdFontBirdFontFile* self,
                                     BTag* tag)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (tag != NULL, FALSE);
	{
		BTagIterator* _t_it = NULL;
		BTagIterator* _tmp0_;
		_tmp0_ = b_tag_iterator (tag);
		_t_it = _tmp0_;
		while (TRUE) {
			BTagIterator* _tmp1_;
			BTag* t = NULL;
			BTagIterator* _tmp2_;
			BTag* _tmp3_;
			BTag* _tmp4_;
			gchar* _tmp5_;
			gchar* _tmp6_;
			gboolean _tmp7_;
			BTag* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			gboolean _tmp14_;
			BTag* _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
			gboolean _tmp19_;
			BTag* _tmp21_;
			gchar* _tmp22_;
			gchar* _tmp23_;
			gboolean _tmp24_;
			BTag* _tmp26_;
			gchar* _tmp27_;
			gchar* _tmp28_;
			gboolean _tmp29_;
			BTag* _tmp31_;
			gchar* _tmp32_;
			gchar* _tmp33_;
			gboolean _tmp34_;
			BTag* _tmp36_;
			gchar* _tmp37_;
			gchar* _tmp38_;
			gboolean _tmp39_;
			BTag* _tmp45_;
			gchar* _tmp46_;
			gchar* _tmp47_;
			gboolean _tmp48_;
			BTag* _tmp54_;
			gchar* _tmp55_;
			gchar* _tmp56_;
			gboolean _tmp57_;
			BTag* _tmp63_;
			gchar* _tmp64_;
			gchar* _tmp65_;
			gboolean _tmp66_;
			BTag* _tmp71_;
			gchar* _tmp72_;
			gchar* _tmp73_;
			gboolean _tmp74_;
			BTag* _tmp79_;
			gchar* _tmp80_;
			gchar* _tmp81_;
			gboolean _tmp82_;
			BTag* _tmp88_;
			gchar* _tmp89_;
			gchar* _tmp90_;
			gboolean _tmp91_;
			BTag* _tmp97_;
			gchar* _tmp98_;
			gchar* _tmp99_;
			gboolean _tmp100_;
			BTag* _tmp106_;
			gchar* _tmp107_;
			gchar* _tmp108_;
			gboolean _tmp109_;
			BTag* _tmp115_;
			gchar* _tmp116_;
			gchar* _tmp117_;
			gboolean _tmp118_;
			BTag* _tmp124_;
			gchar* _tmp125_;
			gchar* _tmp126_;
			gboolean _tmp127_;
			BTag* _tmp133_;
			gchar* _tmp134_;
			gchar* _tmp135_;
			gboolean _tmp136_;
			BTag* _tmp142_;
			gchar* _tmp143_;
			gchar* _tmp144_;
			gboolean _tmp145_;
			BTag* _tmp151_;
			gchar* _tmp152_;
			gchar* _tmp153_;
			gboolean _tmp154_;
			BTag* _tmp160_;
			gchar* _tmp161_;
			gchar* _tmp162_;
			gboolean _tmp163_;
			BTag* _tmp169_;
			gchar* _tmp170_;
			gchar* _tmp171_;
			gboolean _tmp172_;
			BTag* _tmp178_;
			gchar* _tmp179_;
			gchar* _tmp180_;
			gboolean _tmp181_;
			BTag* _tmp187_;
			gchar* _tmp188_;
			gchar* _tmp189_;
			gboolean _tmp190_;
			BTag* _tmp192_;
			gchar* _tmp193_;
			gchar* _tmp194_;
			gboolean _tmp195_;
			BTag* _tmp197_;
			gchar* _tmp198_;
			gchar* _tmp199_;
			gboolean _tmp200_;
			BTag* _tmp202_;
			gchar* _tmp203_;
			gchar* _tmp204_;
			gboolean _tmp205_;
			BTag* _tmp207_;
			gchar* _tmp208_;
			gchar* _tmp209_;
			gboolean _tmp210_;
			BTag* _tmp215_;
			gchar* _tmp216_;
			gchar* _tmp217_;
			gboolean _tmp218_;
			BTag* _tmp223_;
			gchar* _tmp224_;
			gchar* _tmp225_;
			gboolean _tmp226_;
			BTag* _tmp231_;
			gchar* _tmp232_;
			gchar* _tmp233_;
			gboolean _tmp234_;
			BTag* _tmp236_;
			gchar* _tmp237_;
			gchar* _tmp238_;
			gboolean _tmp239_;
			_tmp1_ = _t_it;
			if (!b_tag_iterator_next (_tmp1_)) {
				break;
			}
			_tmp2_ = _t_it;
			_tmp3_ = b_tag_iterator_get (_tmp2_);
			t = _tmp3_;
			_tmp4_ = t;
			_tmp5_ = b_tag_get_name (_tmp4_);
			_tmp6_ = _tmp5_;
			_tmp7_ = g_strcmp0 (_tmp6_, "backup") == 0;
			_g_free0 (_tmp6_);
			if (_tmp7_) {
				BirdFontFont* _tmp8_;
				BTag* _tmp9_;
				gchar* _tmp10_;
				_tmp8_ = self->priv->font;
				_tmp9_ = t;
				_tmp10_ = b_tag_get_content (_tmp9_);
				_g_free0 (_tmp8_->font_file);
				_tmp8_->font_file = _tmp10_;
			}
			_tmp11_ = t;
			_tmp12_ = b_tag_get_name (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = g_strcmp0 (_tmp13_, "format") == 0;
			_g_free0 (_tmp13_);
			if (_tmp14_) {
				BTag* _tmp15_;
				_tmp15_ = t;
				bird_font_bird_font_file_parse_format (self, _tmp15_);
			}
			_tmp16_ = t;
			_tmp17_ = b_tag_get_name (_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = g_strcmp0 (_tmp18_, "collection") == 0;
			_g_free0 (_tmp18_);
			if (_tmp19_) {
				BTag* _tmp20_;
				_tmp20_ = t;
				bird_font_bird_font_file_parse_glyph_collection (self, _tmp20_);
			}
			_tmp21_ = t;
			_tmp22_ = b_tag_get_name (_tmp21_);
			_tmp23_ = _tmp22_;
			_tmp24_ = g_strcmp0 (_tmp23_, "horizontal") == 0;
			_g_free0 (_tmp23_);
			if (_tmp24_) {
				BTag* _tmp25_;
				_tmp25_ = t;
				bird_font_bird_font_file_parse_horizontal_lines (self, _tmp25_);
			}
			_tmp26_ = t;
			_tmp27_ = b_tag_get_name (_tmp26_);
			_tmp28_ = _tmp27_;
			_tmp29_ = g_strcmp0 (_tmp28_, "grid") == 0;
			_g_free0 (_tmp28_);
			if (_tmp29_) {
				BTag* _tmp30_;
				_tmp30_ = t;
				bird_font_bird_font_file_parse_grid (self, _tmp30_);
			}
			_tmp31_ = t;
			_tmp32_ = b_tag_get_name (_tmp31_);
			_tmp33_ = _tmp32_;
			_tmp34_ = g_strcmp0 (_tmp33_, "background") == 0;
			_g_free0 (_tmp33_);
			if (_tmp34_) {
				BTag* _tmp35_;
				_tmp35_ = t;
				bird_font_bird_font_file_parse_background (self, _tmp35_);
			}
			_tmp36_ = t;
			_tmp37_ = b_tag_get_name (_tmp36_);
			_tmp38_ = _tmp37_;
			_tmp39_ = g_strcmp0 (_tmp38_, "postscript_name") == 0;
			_g_free0 (_tmp38_);
			if (_tmp39_) {
				BirdFontFont* _tmp40_;
				BTag* _tmp41_;
				gchar* _tmp42_;
				gchar* _tmp43_;
				gchar* _tmp44_;
				_tmp40_ = self->priv->font;
				_tmp41_ = t;
				_tmp42_ = b_tag_get_content (_tmp41_);
				_tmp43_ = _tmp42_;
				_tmp44_ = bird_font_bird_font_file_decode (_tmp43_);
				_g_free0 (_tmp40_->postscript_name);
				_tmp40_->postscript_name = _tmp44_;
				_g_free0 (_tmp43_);
			}
			_tmp45_ = t;
			_tmp46_ = b_tag_get_name (_tmp45_);
			_tmp47_ = _tmp46_;
			_tmp48_ = g_strcmp0 (_tmp47_, "name") == 0;
			_g_free0 (_tmp47_);
			if (_tmp48_) {
				BirdFontFont* _tmp49_;
				BTag* _tmp50_;
				gchar* _tmp51_;
				gchar* _tmp52_;
				gchar* _tmp53_;
				_tmp49_ = self->priv->font;
				_tmp50_ = t;
				_tmp51_ = b_tag_get_content (_tmp50_);
				_tmp52_ = _tmp51_;
				_tmp53_ = bird_font_bird_font_file_decode (_tmp52_);
				_g_free0 (_tmp49_->name);
				_tmp49_->name = _tmp53_;
				_g_free0 (_tmp52_);
			}
			_tmp54_ = t;
			_tmp55_ = b_tag_get_name (_tmp54_);
			_tmp56_ = _tmp55_;
			_tmp57_ = g_strcmp0 (_tmp56_, "subfamily") == 0;
			_g_free0 (_tmp56_);
			if (_tmp57_) {
				BirdFontFont* _tmp58_;
				BTag* _tmp59_;
				gchar* _tmp60_;
				gchar* _tmp61_;
				gchar* _tmp62_;
				_tmp58_ = self->priv->font;
				_tmp59_ = t;
				_tmp60_ = b_tag_get_content (_tmp59_);
				_tmp61_ = _tmp60_;
				_tmp62_ = bird_font_bird_font_file_decode (_tmp61_);
				_g_free0 (_tmp58_->subfamily);
				_tmp58_->subfamily = _tmp62_;
				_g_free0 (_tmp61_);
			}
			_tmp63_ = t;
			_tmp64_ = b_tag_get_name (_tmp63_);
			_tmp65_ = _tmp64_;
			_tmp66_ = g_strcmp0 (_tmp65_, "bold") == 0;
			_g_free0 (_tmp65_);
			if (_tmp66_) {
				BirdFontFont* _tmp67_;
				BTag* _tmp68_;
				gchar* _tmp69_;
				gchar* _tmp70_;
				_tmp67_ = self->priv->font;
				_tmp68_ = t;
				_tmp69_ = b_tag_get_content (_tmp68_);
				_tmp70_ = _tmp69_;
				_tmp67_->bold = bool_parse (_tmp70_);
				_g_free0 (_tmp70_);
			}
			_tmp71_ = t;
			_tmp72_ = b_tag_get_name (_tmp71_);
			_tmp73_ = _tmp72_;
			_tmp74_ = g_strcmp0 (_tmp73_, "italic") == 0;
			_g_free0 (_tmp73_);
			if (_tmp74_) {
				BirdFontFont* _tmp75_;
				BTag* _tmp76_;
				gchar* _tmp77_;
				gchar* _tmp78_;
				_tmp75_ = self->priv->font;
				_tmp76_ = t;
				_tmp77_ = b_tag_get_content (_tmp76_);
				_tmp78_ = _tmp77_;
				_tmp75_->italic = bool_parse (_tmp78_);
				_g_free0 (_tmp78_);
			}
			_tmp79_ = t;
			_tmp80_ = b_tag_get_name (_tmp79_);
			_tmp81_ = _tmp80_;
			_tmp82_ = g_strcmp0 (_tmp81_, "full_name") == 0;
			_g_free0 (_tmp81_);
			if (_tmp82_) {
				BirdFontFont* _tmp83_;
				BTag* _tmp84_;
				gchar* _tmp85_;
				gchar* _tmp86_;
				gchar* _tmp87_;
				_tmp83_ = self->priv->font;
				_tmp84_ = t;
				_tmp85_ = b_tag_get_content (_tmp84_);
				_tmp86_ = _tmp85_;
				_tmp87_ = bird_font_bird_font_file_decode (_tmp86_);
				_g_free0 (_tmp83_->full_name);
				_tmp83_->full_name = _tmp87_;
				_g_free0 (_tmp86_);
			}
			_tmp88_ = t;
			_tmp89_ = b_tag_get_name (_tmp88_);
			_tmp90_ = _tmp89_;
			_tmp91_ = g_strcmp0 (_tmp90_, "unique_identifier") == 0;
			_g_free0 (_tmp90_);
			if (_tmp91_) {
				BirdFontFont* _tmp92_;
				BTag* _tmp93_;
				gchar* _tmp94_;
				gchar* _tmp95_;
				gchar* _tmp96_;
				_tmp92_ = self->priv->font;
				_tmp93_ = t;
				_tmp94_ = b_tag_get_content (_tmp93_);
				_tmp95_ = _tmp94_;
				_tmp96_ = bird_font_bird_font_file_decode (_tmp95_);
				_g_free0 (_tmp92_->unique_identifier);
				_tmp92_->unique_identifier = _tmp96_;
				_g_free0 (_tmp95_);
			}
			_tmp97_ = t;
			_tmp98_ = b_tag_get_name (_tmp97_);
			_tmp99_ = _tmp98_;
			_tmp100_ = g_strcmp0 (_tmp99_, "version") == 0;
			_g_free0 (_tmp99_);
			if (_tmp100_) {
				BirdFontFont* _tmp101_;
				BTag* _tmp102_;
				gchar* _tmp103_;
				gchar* _tmp104_;
				gchar* _tmp105_;
				_tmp101_ = self->priv->font;
				_tmp102_ = t;
				_tmp103_ = b_tag_get_content (_tmp102_);
				_tmp104_ = _tmp103_;
				_tmp105_ = bird_font_bird_font_file_decode (_tmp104_);
				_g_free0 (_tmp101_->version);
				_tmp101_->version = _tmp105_;
				_g_free0 (_tmp104_);
			}
			_tmp106_ = t;
			_tmp107_ = b_tag_get_name (_tmp106_);
			_tmp108_ = _tmp107_;
			_tmp109_ = g_strcmp0 (_tmp108_, "description") == 0;
			_g_free0 (_tmp108_);
			if (_tmp109_) {
				BirdFontFont* _tmp110_;
				BTag* _tmp111_;
				gchar* _tmp112_;
				gchar* _tmp113_;
				gchar* _tmp114_;
				_tmp110_ = self->priv->font;
				_tmp111_ = t;
				_tmp112_ = b_tag_get_content (_tmp111_);
				_tmp113_ = _tmp112_;
				_tmp114_ = bird_font_bird_font_file_decode (_tmp113_);
				_g_free0 (_tmp110_->description);
				_tmp110_->description = _tmp114_;
				_g_free0 (_tmp113_);
			}
			_tmp115_ = t;
			_tmp116_ = b_tag_get_name (_tmp115_);
			_tmp117_ = _tmp116_;
			_tmp118_ = g_strcmp0 (_tmp117_, "copyright") == 0;
			_g_free0 (_tmp117_);
			if (_tmp118_) {
				BirdFontFont* _tmp119_;
				BTag* _tmp120_;
				gchar* _tmp121_;
				gchar* _tmp122_;
				gchar* _tmp123_;
				_tmp119_ = self->priv->font;
				_tmp120_ = t;
				_tmp121_ = b_tag_get_content (_tmp120_);
				_tmp122_ = _tmp121_;
				_tmp123_ = bird_font_bird_font_file_decode (_tmp122_);
				_g_free0 (_tmp119_->copyright);
				_tmp119_->copyright = _tmp123_;
				_g_free0 (_tmp122_);
			}
			_tmp124_ = t;
			_tmp125_ = b_tag_get_name (_tmp124_);
			_tmp126_ = _tmp125_;
			_tmp127_ = g_strcmp0 (_tmp126_, "license") == 0;
			_g_free0 (_tmp126_);
			if (_tmp127_) {
				BirdFontFont* _tmp128_;
				BTag* _tmp129_;
				gchar* _tmp130_;
				gchar* _tmp131_;
				gchar* _tmp132_;
				_tmp128_ = self->priv->font;
				_tmp129_ = t;
				_tmp130_ = b_tag_get_content (_tmp129_);
				_tmp131_ = _tmp130_;
				_tmp132_ = bird_font_bird_font_file_decode (_tmp131_);
				_g_free0 (_tmp128_->license);
				_tmp128_->license = _tmp132_;
				_g_free0 (_tmp131_);
			}
			_tmp133_ = t;
			_tmp134_ = b_tag_get_name (_tmp133_);
			_tmp135_ = _tmp134_;
			_tmp136_ = g_strcmp0 (_tmp135_, "license_url") == 0;
			_g_free0 (_tmp135_);
			if (_tmp136_) {
				BirdFontFont* _tmp137_;
				BTag* _tmp138_;
				gchar* _tmp139_;
				gchar* _tmp140_;
				gchar* _tmp141_;
				_tmp137_ = self->priv->font;
				_tmp138_ = t;
				_tmp139_ = b_tag_get_content (_tmp138_);
				_tmp140_ = _tmp139_;
				_tmp141_ = bird_font_bird_font_file_decode (_tmp140_);
				_g_free0 (_tmp137_->license_url);
				_tmp137_->license_url = _tmp141_;
				_g_free0 (_tmp140_);
			}
			_tmp142_ = t;
			_tmp143_ = b_tag_get_name (_tmp142_);
			_tmp144_ = _tmp143_;
			_tmp145_ = g_strcmp0 (_tmp144_, "trademark") == 0;
			_g_free0 (_tmp144_);
			if (_tmp145_) {
				BirdFontFont* _tmp146_;
				BTag* _tmp147_;
				gchar* _tmp148_;
				gchar* _tmp149_;
				gchar* _tmp150_;
				_tmp146_ = self->priv->font;
				_tmp147_ = t;
				_tmp148_ = b_tag_get_content (_tmp147_);
				_tmp149_ = _tmp148_;
				_tmp150_ = bird_font_bird_font_file_decode (_tmp149_);
				_g_free0 (_tmp146_->trademark);
				_tmp146_->trademark = _tmp150_;
				_g_free0 (_tmp149_);
			}
			_tmp151_ = t;
			_tmp152_ = b_tag_get_name (_tmp151_);
			_tmp153_ = _tmp152_;
			_tmp154_ = g_strcmp0 (_tmp153_, "manufacturer") == 0;
			_g_free0 (_tmp153_);
			if (_tmp154_) {
				BirdFontFont* _tmp155_;
				BTag* _tmp156_;
				gchar* _tmp157_;
				gchar* _tmp158_;
				gchar* _tmp159_;
				_tmp155_ = self->priv->font;
				_tmp156_ = t;
				_tmp157_ = b_tag_get_content (_tmp156_);
				_tmp158_ = _tmp157_;
				_tmp159_ = bird_font_bird_font_file_decode (_tmp158_);
				_g_free0 (_tmp155_->manufacturer);
				_tmp155_->manufacturer = _tmp159_;
				_g_free0 (_tmp158_);
			}
			_tmp160_ = t;
			_tmp161_ = b_tag_get_name (_tmp160_);
			_tmp162_ = _tmp161_;
			_tmp163_ = g_strcmp0 (_tmp162_, "designer") == 0;
			_g_free0 (_tmp162_);
			if (_tmp163_) {
				BirdFontFont* _tmp164_;
				BTag* _tmp165_;
				gchar* _tmp166_;
				gchar* _tmp167_;
				gchar* _tmp168_;
				_tmp164_ = self->priv->font;
				_tmp165_ = t;
				_tmp166_ = b_tag_get_content (_tmp165_);
				_tmp167_ = _tmp166_;
				_tmp168_ = bird_font_bird_font_file_decode (_tmp167_);
				_g_free0 (_tmp164_->designer);
				_tmp164_->designer = _tmp168_;
				_g_free0 (_tmp167_);
			}
			_tmp169_ = t;
			_tmp170_ = b_tag_get_name (_tmp169_);
			_tmp171_ = _tmp170_;
			_tmp172_ = g_strcmp0 (_tmp171_, "vendor_url") == 0;
			_g_free0 (_tmp171_);
			if (_tmp172_) {
				BirdFontFont* _tmp173_;
				BTag* _tmp174_;
				gchar* _tmp175_;
				gchar* _tmp176_;
				gchar* _tmp177_;
				_tmp173_ = self->priv->font;
				_tmp174_ = t;
				_tmp175_ = b_tag_get_content (_tmp174_);
				_tmp176_ = _tmp175_;
				_tmp177_ = bird_font_bird_font_file_decode (_tmp176_);
				_g_free0 (_tmp173_->vendor_url);
				_tmp173_->vendor_url = _tmp177_;
				_g_free0 (_tmp176_);
			}
			_tmp178_ = t;
			_tmp179_ = b_tag_get_name (_tmp178_);
			_tmp180_ = _tmp179_;
			_tmp181_ = g_strcmp0 (_tmp180_, "designer_url") == 0;
			_g_free0 (_tmp180_);
			if (_tmp181_) {
				BirdFontFont* _tmp182_;
				BTag* _tmp183_;
				gchar* _tmp184_;
				gchar* _tmp185_;
				gchar* _tmp186_;
				_tmp182_ = self->priv->font;
				_tmp183_ = t;
				_tmp184_ = b_tag_get_content (_tmp183_);
				_tmp185_ = _tmp184_;
				_tmp186_ = bird_font_bird_font_file_decode (_tmp185_);
				_g_free0 (_tmp182_->designer_url);
				_tmp182_->designer_url = _tmp186_;
				_g_free0 (_tmp185_);
			}
			_tmp187_ = t;
			_tmp188_ = b_tag_get_name (_tmp187_);
			_tmp189_ = _tmp188_;
			_tmp190_ = g_strcmp0 (_tmp189_, "kerning") == 0;
			_g_free0 (_tmp189_);
			if (_tmp190_) {
				BTag* _tmp191_;
				_tmp191_ = t;
				bird_font_bird_font_file_parse_kerning (self, _tmp191_);
			}
			_tmp192_ = t;
			_tmp193_ = b_tag_get_name (_tmp192_);
			_tmp194_ = _tmp193_;
			_tmp195_ = g_strcmp0 (_tmp194_, "spacing") == 0;
			_g_free0 (_tmp194_);
			if (_tmp195_) {
				BTag* _tmp196_;
				_tmp196_ = t;
				bird_font_bird_font_file_parse_spacing_class (self, _tmp196_);
			}
			_tmp197_ = t;
			_tmp198_ = b_tag_get_name (_tmp197_);
			_tmp199_ = _tmp198_;
			_tmp200_ = g_strcmp0 (_tmp199_, "ligature") == 0;
			_g_free0 (_tmp199_);
			if (_tmp200_) {
				BTag* _tmp201_;
				_tmp201_ = t;
				bird_font_bird_font_file_parse_ligature (self, _tmp201_);
			}
			_tmp202_ = t;
			_tmp203_ = b_tag_get_name (_tmp202_);
			_tmp204_ = _tmp203_;
			_tmp205_ = g_strcmp0 (_tmp204_, "contextual") == 0;
			_g_free0 (_tmp204_);
			if (_tmp205_) {
				BTag* _tmp206_;
				_tmp206_ = t;
				bird_font_bird_font_file_parse_contectual_ligature (self, _tmp206_);
			}
			_tmp207_ = t;
			_tmp208_ = b_tag_get_name (_tmp207_);
			_tmp209_ = _tmp208_;
			_tmp210_ = g_strcmp0 (_tmp209_, "weight") == 0;
			_g_free0 (_tmp209_);
			if (_tmp210_) {
				BirdFontFont* _tmp211_;
				BTag* _tmp212_;
				gchar* _tmp213_;
				gchar* _tmp214_;
				_tmp211_ = self->priv->font;
				_tmp212_ = t;
				_tmp213_ = b_tag_get_content (_tmp212_);
				_tmp214_ = _tmp213_;
				_tmp211_->weight = atoi (_tmp214_);
				_g_free0 (_tmp214_);
			}
			_tmp215_ = t;
			_tmp216_ = b_tag_get_name (_tmp215_);
			_tmp217_ = _tmp216_;
			_tmp218_ = g_strcmp0 (_tmp217_, "italic_angle") == 0;
			_g_free0 (_tmp217_);
			if (_tmp218_) {
				BirdFontFont* _tmp219_;
				BTag* _tmp220_;
				gchar* _tmp221_;
				gchar* _tmp222_;
				_tmp219_ = self->priv->font;
				_tmp220_ = t;
				_tmp221_ = b_tag_get_content (_tmp220_);
				_tmp222_ = _tmp221_;
				_tmp219_->italic_angle = double_parse (_tmp222_);
				_g_free0 (_tmp222_);
			}
			_tmp223_ = t;
			_tmp224_ = b_tag_get_name (_tmp223_);
			_tmp225_ = _tmp224_;
			_tmp226_ = g_strcmp0 (_tmp225_, "units_per_em") == 0;
			_g_free0 (_tmp225_);
			if (_tmp226_) {
				BirdFontFont* _tmp227_;
				BTag* _tmp228_;
				gchar* _tmp229_;
				gchar* _tmp230_;
				_tmp227_ = self->priv->font;
				_tmp228_ = t;
				_tmp229_ = b_tag_get_content (_tmp228_);
				_tmp230_ = _tmp229_;
				_tmp227_->units_per_em = atoi (_tmp230_);
				_g_free0 (_tmp230_);
			}
			_tmp231_ = t;
			_tmp232_ = b_tag_get_name (_tmp231_);
			_tmp233_ = _tmp232_;
			_tmp234_ = g_strcmp0 (_tmp233_, "images") == 0;
			_g_free0 (_tmp233_);
			if (_tmp234_) {
				BTag* _tmp235_;
				_tmp235_ = t;
				bird_font_bird_font_file_parse_images (self, _tmp235_);
			}
			_tmp236_ = t;
			_tmp237_ = b_tag_get_name (_tmp236_);
			_tmp238_ = _tmp237_;
			_tmp239_ = g_strcmp0 (_tmp238_, "alternate") == 0;
			_g_free0 (_tmp238_);
			if (_tmp239_) {
				BTag* _tmp240_;
				_tmp240_ = t;
				bird_font_bird_font_file_parse_alternate (self, _tmp240_);
			}
			_g_object_unref0 (t);
		}
		_g_object_unref0 (_t_it);
	}
	result = TRUE;
	return result;
}

void
bird_font_bird_font_file_parse_alternate (BirdFontBirdFontFile* self,
                                          BTag* tag)
{
	gchar* glyph_name = NULL;
	gchar* _tmp0_;
	gchar* alt = NULL;
	gchar* _tmp1_;
	gchar* alt_tag = NULL;
	gchar* _tmp2_;
	const gchar* _tmp36_;
	const gchar* _tmp37_;
	const gchar* _tmp38_;
	BirdFontFont* _tmp39_;
	const gchar* _tmp40_;
	const gchar* _tmp41_;
	const gchar* _tmp42_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tag != NULL);
	_tmp0_ = g_strdup ("");
	glyph_name = _tmp0_;
	_tmp1_ = g_strdup ("");
	alt = _tmp1_;
	_tmp2_ = g_strdup ("");
	alt_tag = _tmp2_;
	{
		BAttributesIterator* _attribute_it = NULL;
		BAttributes* _tmp3_;
		BAttributes* _tmp4_;
		BAttributesIterator* _tmp5_;
		BAttributesIterator* _tmp6_;
		_tmp3_ = b_tag_get_attributes (tag);
		_tmp4_ = _tmp3_;
		_tmp5_ = b_attributes_iterator (_tmp4_);
		_tmp6_ = _tmp5_;
		_g_object_unref0 (_tmp4_);
		_attribute_it = _tmp6_;
		while (TRUE) {
			BAttributesIterator* _tmp7_;
			BAttribute* attribute = NULL;
			BAttributesIterator* _tmp8_;
			BAttribute* _tmp9_;
			BAttribute* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			gboolean _tmp13_;
			BAttribute* _tmp20_;
			gchar* _tmp21_;
			gchar* _tmp22_;
			gboolean _tmp23_;
			BAttribute* _tmp30_;
			gchar* _tmp31_;
			gchar* _tmp32_;
			gboolean _tmp33_;
			_tmp7_ = _attribute_it;
			if (!b_attributes_iterator_next (_tmp7_)) {
				break;
			}
			_tmp8_ = _attribute_it;
			_tmp9_ = b_attributes_iterator_get (_tmp8_);
			attribute = _tmp9_;
			_tmp10_ = attribute;
			_tmp11_ = b_attribute_get_name (_tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = g_strcmp0 (_tmp12_, "glyph") == 0;
			_g_free0 (_tmp12_);
			if (_tmp13_) {
				BAttribute* _tmp14_;
				gchar* _tmp15_;
				gchar* _tmp16_;
				gchar* _tmp17_;
				gchar* _tmp18_;
				gchar* _tmp19_;
				_tmp14_ = attribute;
				_tmp15_ = b_attribute_get_content (_tmp14_);
				_tmp16_ = _tmp15_;
				_tmp17_ = bird_font_bird_font_file_decode (_tmp16_);
				_tmp18_ = _tmp17_;
				_tmp19_ = bird_font_bird_font_file_unserialize (_tmp18_);
				_g_free0 (glyph_name);
				glyph_name = _tmp19_;
				_g_free0 (_tmp18_);
				_g_free0 (_tmp16_);
			}
			_tmp20_ = attribute;
			_tmp21_ = b_attribute_get_name (_tmp20_);
			_tmp22_ = _tmp21_;
			_tmp23_ = g_strcmp0 (_tmp22_, "replacement") == 0;
			_g_free0 (_tmp22_);
			if (_tmp23_) {
				BAttribute* _tmp24_;
				gchar* _tmp25_;
				gchar* _tmp26_;
				gchar* _tmp27_;
				gchar* _tmp28_;
				gchar* _tmp29_;
				_tmp24_ = attribute;
				_tmp25_ = b_attribute_get_content (_tmp24_);
				_tmp26_ = _tmp25_;
				_tmp27_ = bird_font_bird_font_file_decode (_tmp26_);
				_tmp28_ = _tmp27_;
				_tmp29_ = bird_font_bird_font_file_unserialize (_tmp28_);
				_g_free0 (alt);
				alt = _tmp29_;
				_g_free0 (_tmp28_);
				_g_free0 (_tmp26_);
			}
			_tmp30_ = attribute;
			_tmp31_ = b_attribute_get_name (_tmp30_);
			_tmp32_ = _tmp31_;
			_tmp33_ = g_strcmp0 (_tmp32_, "tag") == 0;
			_g_free0 (_tmp32_);
			if (_tmp33_) {
				BAttribute* _tmp34_;
				gchar* _tmp35_;
				_tmp34_ = attribute;
				_tmp35_ = b_attribute_get_content (_tmp34_);
				_g_free0 (alt_tag);
				alt_tag = _tmp35_;
			}
			_g_object_unref0 (attribute);
		}
		_g_object_unref0 (_attribute_it);
	}
	_tmp36_ = glyph_name;
	if (g_strcmp0 (_tmp36_, "") == 0) {
		g_warning ("BirdFontFile.vala:931: No name for source glyph in alternate.");
		_g_free0 (alt_tag);
		_g_free0 (alt);
		_g_free0 (glyph_name);
		return;
	}
	_tmp37_ = alt;
	if (g_strcmp0 (_tmp37_, "") == 0) {
		g_warning ("BirdFontFile.vala:936: No name for alternate.");
		_g_free0 (alt_tag);
		_g_free0 (alt);
		_g_free0 (glyph_name);
		return;
	}
	_tmp38_ = alt_tag;
	if (g_strcmp0 (_tmp38_, "") == 0) {
		g_warning ("BirdFontFile.vala:941: No tag for alternate.");
		_g_free0 (alt_tag);
		_g_free0 (alt);
		_g_free0 (glyph_name);
		return;
	}
	_tmp39_ = self->priv->font;
	_tmp40_ = glyph_name;
	_tmp41_ = alt;
	_tmp42_ = alt_tag;
	bird_font_font_add_alternate (_tmp39_, _tmp40_, _tmp41_, _tmp42_);
	_g_free0 (alt_tag);
	_g_free0 (alt);
	_g_free0 (glyph_name);
}

void
bird_font_bird_font_file_parse_format (BirdFontBirdFontFile* self,
                                       BTag* tag)
{
	gchar** v = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	gint v_length1;
	gint _v_size_;
	gchar** _tmp5_;
	gint _tmp5__length1;
	BirdFontFont* _tmp6_;
	gchar** _tmp7_;
	gint _tmp7__length1;
	const gchar* _tmp8_;
	BirdFontFont* _tmp9_;
	gchar** _tmp10_;
	gint _tmp10__length1;
	const gchar* _tmp11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tag != NULL);
	_tmp0_ = b_tag_get_content (tag);
	_tmp1_ = _tmp0_;
	_tmp3_ = _tmp2_ = g_strsplit (_tmp1_, ".", 0);
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _vala_array_length (_tmp2_);
	_g_free0 (_tmp1_);
	v = _tmp4_;
	v_length1 = _tmp4__length1;
	_v_size_ = v_length1;
	_tmp5_ = v;
	_tmp5__length1 = v_length1;
	if (_tmp5__length1 != 2) {
		g_warning ("BirdFontFile.vala:952: Bad format string.");
		v = (_vala_array_free (v, v_length1, (GDestroyNotify) g_free), NULL);
		return;
	}
	_tmp6_ = self->priv->font;
	_tmp7_ = v;
	_tmp7__length1 = v_length1;
	_tmp8_ = _tmp7_[0];
	_tmp6_->format_major = atoi (_tmp8_);
	_tmp9_ = self->priv->font;
	_tmp10_ = v;
	_tmp10__length1 = v_length1;
	_tmp11_ = _tmp10_[1];
	_tmp9_->format_minor = atoi (_tmp11_);
	v = (_vala_array_free (v, v_length1, (GDestroyNotify) g_free), NULL);
}

void
bird_font_bird_font_file_parse_images (BirdFontBirdFontFile* self,
                                       BTag* tag)
{
	BirdFontBackgroundImage* new_img = NULL;
	BirdFontBackgroundImage* img = NULL;
	gchar* name = NULL;
	GFile* img_file = NULL;
	gdouble x = 0.0;
	gdouble y = 0.0;
	gdouble scale_x = 0.0;
	gdouble scale_y = 0.0;
	gdouble rotation = 0.0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tag != NULL);
	{
		BTagIterator* _t_it = NULL;
		BTagIterator* _tmp0_;
		_tmp0_ = b_tag_iterator (tag);
		_t_it = _tmp0_;
		while (TRUE) {
			BTagIterator* _tmp1_;
			BTag* t = NULL;
			BTagIterator* _tmp2_;
			BTag* _tmp3_;
			BTag* _tmp4_;
			gchar* _tmp5_;
			gchar* _tmp6_;
			gboolean _tmp7_;
			_tmp1_ = _t_it;
			if (!b_tag_iterator_next (_tmp1_)) {
				break;
			}
			_tmp2_ = _t_it;
			_tmp3_ = b_tag_iterator_get (_tmp2_);
			t = _tmp3_;
			_tmp4_ = t;
			_tmp5_ = b_tag_get_name (_tmp4_);
			_tmp6_ = _tmp5_;
			_tmp7_ = g_strcmp0 (_tmp6_, "image") == 0;
			_g_free0 (_tmp6_);
			if (_tmp7_) {
				gchar* _tmp8_;
				BirdFontFont* _tmp9_;
				GFile* _tmp10_;
				GFile* _tmp11_;
				GFile* _tmp12_;
				gboolean _tmp84_ = FALSE;
				BirdFontBackgroundImage* _tmp85_;
				_tmp8_ = g_strdup ("");
				_g_free0 (name);
				name = _tmp8_;
				_g_object_unref0 (new_img);
				new_img = NULL;
				_tmp9_ = self->priv->font;
				_tmp10_ = bird_font_font_get_backgrounds_folder (_tmp9_);
				_tmp11_ = _tmp10_;
				_tmp12_ = bird_font_get_child (_tmp11_, "parts");
				_g_object_unref0 (img_file);
				img_file = _tmp12_;
				_g_object_unref0 (_tmp11_);
				x = (gdouble) 0;
				y = (gdouble) 0;
				scale_x = (gdouble) 0;
				scale_y = (gdouble) 0;
				rotation = (gdouble) 0;
				{
					BAttributesIterator* _attr_it = NULL;
					BTag* _tmp13_;
					BAttributes* _tmp14_;
					BAttributes* _tmp15_;
					BAttributesIterator* _tmp16_;
					BAttributesIterator* _tmp17_;
					_tmp13_ = t;
					_tmp14_ = b_tag_get_attributes (_tmp13_);
					_tmp15_ = _tmp14_;
					_tmp16_ = b_attributes_iterator (_tmp15_);
					_tmp17_ = _tmp16_;
					_g_object_unref0 (_tmp15_);
					_attr_it = _tmp17_;
					while (TRUE) {
						BAttributesIterator* _tmp18_;
						BAttribute* attr = NULL;
						BAttributesIterator* _tmp19_;
						BAttribute* _tmp20_;
						BAttribute* _tmp21_;
						gchar* _tmp22_;
						gchar* _tmp23_;
						gboolean _tmp24_;
						BAttribute* _tmp43_;
						gchar* _tmp44_;
						gchar* _tmp45_;
						gboolean _tmp46_;
						BAttribute* _tmp49_;
						gchar* _tmp50_;
						gchar* _tmp51_;
						gboolean _tmp52_;
						BAttribute* _tmp56_;
						gchar* _tmp57_;
						gchar* _tmp58_;
						gboolean _tmp59_;
						BAttribute* _tmp63_;
						gchar* _tmp64_;
						gchar* _tmp65_;
						gboolean _tmp66_;
						BAttribute* _tmp70_;
						gchar* _tmp71_;
						gchar* _tmp72_;
						gboolean _tmp73_;
						BAttribute* _tmp77_;
						gchar* _tmp78_;
						gchar* _tmp79_;
						gboolean _tmp80_;
						_tmp18_ = _attr_it;
						if (!b_attributes_iterator_next (_tmp18_)) {
							break;
						}
						_tmp19_ = _attr_it;
						_tmp20_ = b_attributes_iterator_get (_tmp19_);
						attr = _tmp20_;
						_tmp21_ = attr;
						_tmp22_ = b_attribute_get_name (_tmp21_);
						_tmp23_ = _tmp22_;
						_tmp24_ = g_strcmp0 (_tmp23_, "sha1") == 0;
						_g_free0 (_tmp23_);
						if (_tmp24_) {
							GFile* _tmp25_;
							BAttribute* _tmp26_;
							gchar* _tmp27_;
							gchar* _tmp28_;
							gchar* _tmp29_;
							gchar* _tmp30_;
							GFile* _tmp31_;
							GFile* _tmp32_;
							GFile* _tmp39_;
							gchar* _tmp40_;
							gchar* _tmp41_;
							BirdFontBackgroundImage* _tmp42_;
							_tmp25_ = img_file;
							_tmp26_ = attr;
							_tmp27_ = b_attribute_get_content (_tmp26_);
							_tmp28_ = _tmp27_;
							_tmp29_ = g_strconcat (_tmp28_, ".png", NULL);
							_tmp30_ = _tmp29_;
							_tmp31_ = bird_font_get_child (_tmp25_, _tmp30_);
							_g_object_unref0 (img_file);
							img_file = _tmp31_;
							_g_free0 (_tmp30_);
							_g_free0 (_tmp28_);
							_tmp32_ = img_file;
							if (!g_file_query_exists (_tmp32_, NULL)) {
								GFile* _tmp33_;
								gchar* _tmp34_;
								gchar* _tmp35_;
								const gchar* _tmp36_;
								gchar* _tmp37_;
								gchar* _tmp38_;
								_tmp33_ = img_file;
								_tmp34_ = g_file_get_path (_tmp33_);
								_tmp35_ = (gchar*) _tmp34_;
								_tmp36_ = string_to_string (_tmp35_);
								_tmp37_ = g_strconcat ("Background file has not been created yet. ", _tmp36_, NULL);
								_tmp38_ = _tmp37_;
								g_warning ("BirdFontFile.vala:984: %s", _tmp38_);
								_g_free0 (_tmp38_);
								_g_free0 (_tmp35_);
							}
							_tmp39_ = img_file;
							_tmp40_ = g_file_get_path (_tmp39_);
							_tmp41_ = (gchar*) _tmp40_;
							_tmp42_ = bird_font_background_image_new (_tmp41_);
							_g_object_unref0 (new_img);
							new_img = _tmp42_;
							_g_free0 (_tmp41_);
						}
						_tmp43_ = attr;
						_tmp44_ = b_attribute_get_name (_tmp43_);
						_tmp45_ = _tmp44_;
						_tmp46_ = g_strcmp0 (_tmp45_, "name") == 0;
						_g_free0 (_tmp45_);
						if (_tmp46_) {
							BAttribute* _tmp47_;
							gchar* _tmp48_;
							_tmp47_ = attr;
							_tmp48_ = b_attribute_get_content (_tmp47_);
							_g_free0 (name);
							name = _tmp48_;
						}
						_tmp49_ = attr;
						_tmp50_ = b_attribute_get_name (_tmp49_);
						_tmp51_ = _tmp50_;
						_tmp52_ = g_strcmp0 (_tmp51_, "x") == 0;
						_g_free0 (_tmp51_);
						if (_tmp52_) {
							BAttribute* _tmp53_;
							gchar* _tmp54_;
							gchar* _tmp55_;
							_tmp53_ = attr;
							_tmp54_ = b_attribute_get_content (_tmp53_);
							_tmp55_ = _tmp54_;
							x = bird_font_bird_font_file_parse_double (_tmp55_);
							_g_free0 (_tmp55_);
						}
						_tmp56_ = attr;
						_tmp57_ = b_attribute_get_name (_tmp56_);
						_tmp58_ = _tmp57_;
						_tmp59_ = g_strcmp0 (_tmp58_, "y") == 0;
						_g_free0 (_tmp58_);
						if (_tmp59_) {
							BAttribute* _tmp60_;
							gchar* _tmp61_;
							gchar* _tmp62_;
							_tmp60_ = attr;
							_tmp61_ = b_attribute_get_content (_tmp60_);
							_tmp62_ = _tmp61_;
							y = bird_font_bird_font_file_parse_double (_tmp62_);
							_g_free0 (_tmp62_);
						}
						_tmp63_ = attr;
						_tmp64_ = b_attribute_get_name (_tmp63_);
						_tmp65_ = _tmp64_;
						_tmp66_ = g_strcmp0 (_tmp65_, "scale_x") == 0;
						_g_free0 (_tmp65_);
						if (_tmp66_) {
							BAttribute* _tmp67_;
							gchar* _tmp68_;
							gchar* _tmp69_;
							_tmp67_ = attr;
							_tmp68_ = b_attribute_get_content (_tmp67_);
							_tmp69_ = _tmp68_;
							scale_x = bird_font_bird_font_file_parse_double (_tmp69_);
							_g_free0 (_tmp69_);
						}
						_tmp70_ = attr;
						_tmp71_ = b_attribute_get_name (_tmp70_);
						_tmp72_ = _tmp71_;
						_tmp73_ = g_strcmp0 (_tmp72_, "scale_y") == 0;
						_g_free0 (_tmp72_);
						if (_tmp73_) {
							BAttribute* _tmp74_;
							gchar* _tmp75_;
							gchar* _tmp76_;
							_tmp74_ = attr;
							_tmp75_ = b_attribute_get_content (_tmp74_);
							_tmp76_ = _tmp75_;
							scale_y = bird_font_bird_font_file_parse_double (_tmp76_);
							_g_free0 (_tmp76_);
						}
						_tmp77_ = attr;
						_tmp78_ = b_attribute_get_name (_tmp77_);
						_tmp79_ = _tmp78_;
						_tmp80_ = g_strcmp0 (_tmp79_, "rotation") == 0;
						_g_free0 (_tmp79_);
						if (_tmp80_) {
							BAttribute* _tmp81_;
							gchar* _tmp82_;
							gchar* _tmp83_;
							_tmp81_ = attr;
							_tmp82_ = b_attribute_get_content (_tmp81_);
							_tmp83_ = _tmp82_;
							rotation = bird_font_bird_font_file_parse_double (_tmp83_);
							_g_free0 (_tmp83_);
						}
						_g_object_unref0 (attr);
					}
					_g_object_unref0 (_attr_it);
				}
				_tmp85_ = new_img;
				if (_tmp85_ != NULL) {
					const gchar* _tmp86_;
					_tmp86_ = name;
					_tmp84_ = g_strcmp0 (_tmp86_, "") != 0;
				} else {
					_tmp84_ = FALSE;
				}
				if (_tmp84_) {
					BirdFontBackgroundImage* _tmp87_;
					BirdFontBackgroundImage* _tmp88_;
					BirdFontBackgroundImage* _tmp89_;
					const gchar* _tmp90_;
					gchar* _tmp91_;
					BirdFontBackgroundTools* _tmp92_;
					BirdFontBackgroundImage* _tmp93_;
					BirdFontBackgroundImage* _tmp94_;
					BTag* _tmp95_;
					BirdFontBackgroundImage* _tmp96_;
					BirdFontBackgroundImage* _tmp97_;
					BirdFontBackgroundImage* _tmp98_;
					BirdFontBackgroundImage* _tmp99_;
					BirdFontBackgroundImage* _tmp100_;
					_tmp87_ = new_img;
					_tmp88_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp87_, BIRD_FONT_TYPE_BACKGROUND_IMAGE, BirdFontBackgroundImage));
					_g_object_unref0 (img);
					img = _tmp88_;
					_tmp89_ = img;
					_tmp90_ = name;
					_tmp91_ = g_strdup (_tmp90_);
					_g_free0 (_tmp89_->name);
					_tmp89_->name = _tmp91_;
					_tmp92_ = bird_font_toolbox_background_tools;
					_tmp93_ = img;
					bird_font_background_tools_add_image (_tmp92_, _tmp93_);
					_tmp94_ = img;
					_tmp95_ = t;
					bird_font_bird_font_file_parse_image_selections (self, _tmp94_, _tmp95_);
					_tmp96_ = img;
					_tmp96_->img_x = x;
					_tmp97_ = img;
					_tmp97_->img_y = y;
					_tmp98_ = img;
					bird_font_background_image_set_img_scale_x (_tmp98_, scale_x);
					_tmp99_ = img;
					bird_font_background_image_set_img_scale_y (_tmp99_, scale_y);
					_tmp100_ = img;
					_tmp100_->img_rotation = rotation;
				} else {
					const gchar* _tmp101_;
					const gchar* _tmp102_;
					gchar* _tmp103_;
					gchar* _tmp104_;
					_tmp101_ = name;
					_tmp102_ = string_to_string (_tmp101_);
					_tmp103_ = g_strconcat ("No image found, name: ", _tmp102_, NULL);
					_tmp104_ = _tmp103_;
					g_warning ("BirdFontFile.vala:1028: %s", _tmp104_);
					_g_free0 (_tmp104_);
				}
			}
			_g_object_unref0 (t);
		}
		_g_object_unref0 (_t_it);
	}
	_g_object_unref0 (img_file);
	_g_free0 (name);
	_g_object_unref0 (img);
	_g_object_unref0 (new_img);
}

static void
bird_font_bird_font_file_parse_image_selections (BirdFontBirdFontFile* self,
                                                 BirdFontBackgroundImage* image,
                                                 BTag* tag)
{
	gdouble x = 0.0;
	gdouble y = 0.0;
	gdouble w = 0.0;
	gdouble h = 0.0;
	gchar* assigned_glyph = NULL;
	BirdFontBackgroundSelection* s = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (image != NULL);
	g_return_if_fail (tag != NULL);
	{
		BTagIterator* _t_it = NULL;
		BTagIterator* _tmp0_;
		_tmp0_ = b_tag_iterator (tag);
		_t_it = _tmp0_;
		while (TRUE) {
			BTagIterator* _tmp1_;
			BTag* t = NULL;
			BTagIterator* _tmp2_;
			BTag* _tmp3_;
			BTag* _tmp4_;
			gchar* _tmp5_;
			gchar* _tmp6_;
			gboolean _tmp7_;
			_tmp1_ = _t_it;
			if (!b_tag_iterator_next (_tmp1_)) {
				break;
			}
			_tmp2_ = _t_it;
			_tmp3_ = b_tag_iterator_get (_tmp2_);
			t = _tmp3_;
			_tmp4_ = t;
			_tmp5_ = b_tag_get_name (_tmp4_);
			_tmp6_ = _tmp5_;
			_tmp7_ = g_strcmp0 (_tmp6_, "selection") == 0;
			_g_free0 (_tmp6_);
			if (_tmp7_) {
				BirdFontBackgroundSelection* _tmp50_;
				BirdFontBackgroundSelection* _tmp51_;
				const gchar* _tmp52_;
				gchar* _tmp53_;
				GeeArrayList* _tmp54_;
				BirdFontBackgroundSelection* _tmp55_;
				x = (gdouble) 0;
				y = (gdouble) 0;
				w = (gdouble) 0;
				h = (gdouble) 0;
				_g_free0 (assigned_glyph);
				assigned_glyph = NULL;
				{
					BAttributesIterator* _attr_it = NULL;
					BTag* _tmp8_;
					BAttributes* _tmp9_;
					BAttributes* _tmp10_;
					BAttributesIterator* _tmp11_;
					BAttributesIterator* _tmp12_;
					_tmp8_ = t;
					_tmp9_ = b_tag_get_attributes (_tmp8_);
					_tmp10_ = _tmp9_;
					_tmp11_ = b_attributes_iterator (_tmp10_);
					_tmp12_ = _tmp11_;
					_g_object_unref0 (_tmp10_);
					_attr_it = _tmp12_;
					while (TRUE) {
						BAttributesIterator* _tmp13_;
						BAttribute* attr = NULL;
						BAttributesIterator* _tmp14_;
						BAttribute* _tmp15_;
						BAttribute* _tmp16_;
						gchar* _tmp17_;
						gchar* _tmp18_;
						gboolean _tmp19_;
						BAttribute* _tmp23_;
						gchar* _tmp24_;
						gchar* _tmp25_;
						gboolean _tmp26_;
						BAttribute* _tmp30_;
						gchar* _tmp31_;
						gchar* _tmp32_;
						gboolean _tmp33_;
						BAttribute* _tmp37_;
						gchar* _tmp38_;
						gchar* _tmp39_;
						gboolean _tmp40_;
						BAttribute* _tmp44_;
						gchar* _tmp45_;
						gchar* _tmp46_;
						gboolean _tmp47_;
						_tmp13_ = _attr_it;
						if (!b_attributes_iterator_next (_tmp13_)) {
							break;
						}
						_tmp14_ = _attr_it;
						_tmp15_ = b_attributes_iterator_get (_tmp14_);
						attr = _tmp15_;
						_tmp16_ = attr;
						_tmp17_ = b_attribute_get_name (_tmp16_);
						_tmp18_ = _tmp17_;
						_tmp19_ = g_strcmp0 (_tmp18_, "x") == 0;
						_g_free0 (_tmp18_);
						if (_tmp19_) {
							BAttribute* _tmp20_;
							gchar* _tmp21_;
							gchar* _tmp22_;
							_tmp20_ = attr;
							_tmp21_ = b_attribute_get_content (_tmp20_);
							_tmp22_ = _tmp21_;
							x = bird_font_bird_font_file_parse_double (_tmp22_);
							_g_free0 (_tmp22_);
						}
						_tmp23_ = attr;
						_tmp24_ = b_attribute_get_name (_tmp23_);
						_tmp25_ = _tmp24_;
						_tmp26_ = g_strcmp0 (_tmp25_, "y") == 0;
						_g_free0 (_tmp25_);
						if (_tmp26_) {
							BAttribute* _tmp27_;
							gchar* _tmp28_;
							gchar* _tmp29_;
							_tmp27_ = attr;
							_tmp28_ = b_attribute_get_content (_tmp27_);
							_tmp29_ = _tmp28_;
							y = bird_font_bird_font_file_parse_double (_tmp29_);
							_g_free0 (_tmp29_);
						}
						_tmp30_ = attr;
						_tmp31_ = b_attribute_get_name (_tmp30_);
						_tmp32_ = _tmp31_;
						_tmp33_ = g_strcmp0 (_tmp32_, "width") == 0;
						_g_free0 (_tmp32_);
						if (_tmp33_) {
							BAttribute* _tmp34_;
							gchar* _tmp35_;
							gchar* _tmp36_;
							_tmp34_ = attr;
							_tmp35_ = b_attribute_get_content (_tmp34_);
							_tmp36_ = _tmp35_;
							w = bird_font_bird_font_file_parse_double (_tmp36_);
							_g_free0 (_tmp36_);
						}
						_tmp37_ = attr;
						_tmp38_ = b_attribute_get_name (_tmp37_);
						_tmp39_ = _tmp38_;
						_tmp40_ = g_strcmp0 (_tmp39_, "height") == 0;
						_g_free0 (_tmp39_);
						if (_tmp40_) {
							BAttribute* _tmp41_;
							gchar* _tmp42_;
							gchar* _tmp43_;
							_tmp41_ = attr;
							_tmp42_ = b_attribute_get_content (_tmp41_);
							_tmp43_ = _tmp42_;
							h = bird_font_bird_font_file_parse_double (_tmp43_);
							_g_free0 (_tmp43_);
						}
						_tmp44_ = attr;
						_tmp45_ = b_attribute_get_name (_tmp44_);
						_tmp46_ = _tmp45_;
						_tmp47_ = g_strcmp0 (_tmp46_, "glyph") == 0;
						_g_free0 (_tmp46_);
						if (_tmp47_) {
							BAttribute* _tmp48_;
							gchar* _tmp49_;
							_tmp48_ = attr;
							_tmp49_ = b_attribute_get_content (_tmp48_);
							_g_free0 (assigned_glyph);
							assigned_glyph = _tmp49_;
						}
						_g_object_unref0 (attr);
					}
					_g_object_unref0 (_attr_it);
				}
				_tmp50_ = bird_font_background_selection_new_absolute (NULL, image, x, y, w, h);
				_g_object_unref0 (s);
				s = _tmp50_;
				_tmp51_ = s;
				_tmp52_ = assigned_glyph;
				_tmp53_ = g_strdup (_tmp52_);
				_g_free0 (_tmp51_->assigned_glyph);
				_tmp51_->assigned_glyph = _tmp53_;
				_tmp54_ = image->selections;
				_tmp55_ = s;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp54_, _tmp55_);
			}
			_g_object_unref0 (t);
		}
		_g_object_unref0 (_t_it);
	}
	_g_object_unref0 (s);
	_g_free0 (assigned_glyph);
}

static void
bird_font_bird_font_file_create_background_files (BirdFontBirdFontFile* self,
                                                  BTag* root)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (root != NULL);
	{
		BTagIterator* _child_it = NULL;
		BTagIterator* _tmp0_;
		_tmp0_ = b_tag_iterator (root);
		_child_it = _tmp0_;
		while (TRUE) {
			BTagIterator* _tmp1_;
			BTag* child = NULL;
			BTagIterator* _tmp2_;
			BTag* _tmp3_;
			BTag* _tmp4_;
			gchar* _tmp5_;
			gchar* _tmp6_;
			gboolean _tmp7_;
			BTag* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			gboolean _tmp15_;
			_tmp1_ = _child_it;
			if (!b_tag_iterator_next (_tmp1_)) {
				break;
			}
			_tmp2_ = _child_it;
			_tmp3_ = b_tag_iterator_get (_tmp2_);
			child = _tmp3_;
			_tmp4_ = child;
			_tmp5_ = b_tag_get_name (_tmp4_);
			_tmp6_ = _tmp5_;
			_tmp7_ = g_strcmp0 (_tmp6_, "name") == 0;
			_g_free0 (_tmp6_);
			if (_tmp7_) {
				BirdFontFont* _tmp8_;
				BTag* _tmp9_;
				gchar* _tmp10_;
				gchar* _tmp11_;
				_tmp8_ = self->priv->font;
				_tmp9_ = child;
				_tmp10_ = b_tag_get_content (_tmp9_);
				_tmp11_ = _tmp10_;
				bird_font_font_set_name (_tmp8_, _tmp11_);
				_g_free0 (_tmp11_);
			}
			_tmp12_ = child;
			_tmp13_ = b_tag_get_name (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = g_strcmp0 (_tmp14_, "background-image") == 0;
			_g_free0 (_tmp14_);
			if (_tmp15_) {
				BTag* _tmp16_;
				_tmp16_ = child;
				bird_font_bird_font_file_parse_background_image (self, _tmp16_);
			}
			_g_object_unref0 (child);
		}
		_g_object_unref0 (_child_it);
	}
}

gchar*
bird_font_bird_font_file_serialize_attribute (const gchar* s)
{
	gchar* n = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* result;
	g_return_val_if_fail (s != NULL, NULL);
	_tmp0_ = string_replace (s, "\"", "quote");
	n = _tmp0_;
	_tmp1_ = n;
	_tmp2_ = string_replace (_tmp1_, "&", "ampersand");
	_g_free0 (n);
	n = _tmp2_;
	result = n;
	return result;
}

gchar*
bird_font_bird_font_file_unserialize (const gchar* s)
{
	GString* b = NULL;
	gchar* r = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* result;
	g_return_val_if_fail (s != NULL, NULL);
	_tmp0_ = string_replace (s, "quote", "\"");
	_g_free0 (r);
	r = _tmp0_;
	_tmp1_ = r;
	_tmp2_ = string_replace (_tmp1_, "ampersand", "&");
	_g_free0 (r);
	r = _tmp2_;
	if (g_str_has_prefix (s, "U+")) {
		GString* _tmp3_;
		GString* _tmp4_;
		GString* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp3_ = g_string_new ("");
		_g_string_free0 (b);
		b = _tmp3_;
		_tmp4_ = b;
		g_string_append_unichar (_tmp4_, bird_font_font_to_unichar (s));
		_tmp5_ = b;
		_tmp6_ = _tmp5_->str;
		_tmp7_ = string_to_string (_tmp6_);
		_tmp8_ = g_strdup (_tmp7_);
		_g_free0 (r);
		r = _tmp8_;
	}
	result = r;
	_g_string_free0 (b);
	return result;
}

gchar*
bird_font_bird_font_file_serialize_unichar (gunichar c)
{
	gchar* _tmp0_;
	gchar* result;
	_tmp0_ = bird_font_glyph_range_get_serialized_char (c);
	result = _tmp0_;
	return result;
}

static gchar*
g_unichar_to_string (gunichar self)
{
	gchar* str = NULL;
	gchar* _tmp0_;
	gchar* result;
	_tmp0_ = g_new0 (gchar, 7);
	str = (gchar*) _tmp0_;
	g_unichar_to_utf8 (self, str);
	result = str;
	return result;
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static void
bird_font_bird_font_file_parse_spacing_class (BirdFontBirdFontFile* self,
                                              BTag* tag)
{
	gchar* first = NULL;
	gchar* next = NULL;
	gchar* name = NULL;
	BirdFontSpacingData* spacing = NULL;
	BirdFontFont* _tmp0_;
	BirdFontSpacingData* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	BirdFontSpacingData* _tmp59_;
	const gchar* _tmp60_;
	const gchar* _tmp61_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tag != NULL);
	_tmp0_ = self->priv->font;
	_tmp1_ = bird_font_font_get_spacing (_tmp0_);
	spacing = _tmp1_;
	_tmp2_ = g_strdup ("");
	_g_free0 (first);
	first = _tmp2_;
	_tmp3_ = g_strdup ("");
	_g_free0 (next);
	next = _tmp3_;
	{
		BAttributesIterator* _attr_it = NULL;
		BAttributes* _tmp4_;
		BAttributes* _tmp5_;
		BAttributesIterator* _tmp6_;
		BAttributesIterator* _tmp7_;
		_tmp4_ = b_tag_get_attributes (tag);
		_tmp5_ = _tmp4_;
		_tmp6_ = b_attributes_iterator (_tmp5_);
		_tmp7_ = _tmp6_;
		_g_object_unref0 (_tmp5_);
		_attr_it = _tmp7_;
		while (TRUE) {
			BAttributesIterator* _tmp8_;
			BAttribute* attr = NULL;
			BAttributesIterator* _tmp9_;
			BAttribute* _tmp10_;
			BAttribute* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			gboolean _tmp14_;
			BAttribute* _tmp35_;
			gchar* _tmp36_;
			gchar* _tmp37_;
			gboolean _tmp38_;
			_tmp8_ = _attr_it;
			if (!b_attributes_iterator_next (_tmp8_)) {
				break;
			}
			_tmp9_ = _attr_it;
			_tmp10_ = b_attributes_iterator_get (_tmp9_);
			attr = _tmp10_;
			_tmp11_ = attr;
			_tmp12_ = b_attribute_get_name (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = g_strcmp0 (_tmp13_, "first") == 0;
			_g_free0 (_tmp13_);
			if (_tmp14_) {
				BAttribute* _tmp15_;
				gchar* _tmp16_;
				gchar* _tmp17_;
				gboolean _tmp18_;
				_tmp15_ = attr;
				_tmp16_ = b_attribute_get_content (_tmp15_);
				_tmp17_ = _tmp16_;
				_tmp18_ = g_str_has_prefix (_tmp17_, "U+");
				_g_free0 (_tmp17_);
				if (_tmp18_) {
					BAttribute* _tmp19_;
					gchar* _tmp20_;
					gchar* _tmp21_;
					gchar* _tmp22_;
					_tmp19_ = attr;
					_tmp20_ = b_attribute_get_content (_tmp19_);
					_tmp21_ = _tmp20_;
					_tmp22_ = g_unichar_to_string (bird_font_font_to_unichar (_tmp21_));
					_g_free0 (first);
					first = (gchar*) _tmp22_;
					_g_free0 (_tmp21_);
				} else {
					BAttribute* _tmp23_;
					gchar* _tmp24_;
					gchar* _tmp25_;
					gboolean _tmp26_;
					_tmp23_ = attr;
					_tmp24_ = b_attribute_get_content (_tmp23_);
					_tmp25_ = _tmp24_;
					_tmp26_ = g_str_has_prefix (_tmp25_, "name:");
					_g_free0 (_tmp25_);
					if (_tmp26_) {
						BAttribute* _tmp27_;
						gchar* _tmp28_;
						gchar* _tmp29_;
						gint _tmp30_;
						gint _tmp31_;
						gchar* _tmp32_;
						const gchar* _tmp33_;
						gchar* _tmp34_;
						_tmp27_ = attr;
						_tmp28_ = b_attribute_get_content (_tmp27_);
						_tmp29_ = _tmp28_;
						_tmp30_ = strlen ("name:");
						_tmp31_ = _tmp30_;
						_tmp32_ = string_substring (_tmp29_, (glong) _tmp31_, (glong) -1);
						_g_free0 (name);
						name = _tmp32_;
						_g_free0 (_tmp29_);
						_tmp33_ = name;
						_tmp34_ = bird_font_bird_font_file_decode (_tmp33_);
						_g_free0 (first);
						first = _tmp34_;
					}
				}
			}
			_tmp35_ = attr;
			_tmp36_ = b_attribute_get_name (_tmp35_);
			_tmp37_ = _tmp36_;
			_tmp38_ = g_strcmp0 (_tmp37_, "next") == 0;
			_g_free0 (_tmp37_);
			if (_tmp38_) {
				BAttribute* _tmp39_;
				gchar* _tmp40_;
				gchar* _tmp41_;
				gboolean _tmp42_;
				_tmp39_ = attr;
				_tmp40_ = b_attribute_get_content (_tmp39_);
				_tmp41_ = _tmp40_;
				_tmp42_ = g_str_has_prefix (_tmp41_, "U+");
				_g_free0 (_tmp41_);
				if (_tmp42_) {
					BAttribute* _tmp43_;
					gchar* _tmp44_;
					gchar* _tmp45_;
					gchar* _tmp46_;
					_tmp43_ = attr;
					_tmp44_ = b_attribute_get_content (_tmp43_);
					_tmp45_ = _tmp44_;
					_tmp46_ = g_unichar_to_string (bird_font_font_to_unichar (_tmp45_));
					_g_free0 (next);
					next = (gchar*) _tmp46_;
					_g_free0 (_tmp45_);
				} else {
					BAttribute* _tmp47_;
					gchar* _tmp48_;
					gchar* _tmp49_;
					gboolean _tmp50_;
					_tmp47_ = attr;
					_tmp48_ = b_attribute_get_content (_tmp47_);
					_tmp49_ = _tmp48_;
					_tmp50_ = g_str_has_prefix (_tmp49_, "name:");
					_g_free0 (_tmp49_);
					if (_tmp50_) {
						BAttribute* _tmp51_;
						gchar* _tmp52_;
						gchar* _tmp53_;
						gint _tmp54_;
						gint _tmp55_;
						gchar* _tmp56_;
						const gchar* _tmp57_;
						gchar* _tmp58_;
						_tmp51_ = attr;
						_tmp52_ = b_attribute_get_content (_tmp51_);
						_tmp53_ = _tmp52_;
						_tmp54_ = strlen ("name:");
						_tmp55_ = _tmp54_;
						_tmp56_ = string_substring (_tmp53_, (glong) _tmp55_, (glong) -1);
						_g_free0 (name);
						name = _tmp56_;
						_g_free0 (_tmp53_);
						_tmp57_ = name;
						_tmp58_ = bird_font_bird_font_file_decode (_tmp57_);
						_g_free0 (next);
						next = _tmp58_;
					}
				}
			}
			_g_object_unref0 (attr);
		}
		_g_object_unref0 (_attr_it);
	}
	_tmp59_ = spacing;
	_tmp60_ = first;
	_tmp61_ = next;
	bird_font_spacing_data_add_class (_tmp59_, _tmp60_, _tmp61_);
	_g_object_unref0 (spacing);
	_g_free0 (name);
	_g_free0 (next);
	_g_free0 (first);
}

static void
bird_font_bird_font_file_parse_kerning (BirdFontBirdFontFile* self,
                                        BTag* tag)
{
	BirdFontGlyphRange* range_left = NULL;
	BirdFontGlyphRange* range_right = NULL;
	gdouble hadjustment = 0.0;
	BirdFontKerningRange* kerning_range = NULL;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tag != NULL);
	hadjustment = (gdouble) 0;
	{
		BirdFontGlyphRange* _tmp0_;
		BirdFontGlyphRange* _tmp1_;
		BirdFontGlyphRange* _tmp40_;
		BirdFontGlyphRange* _tmp48_;
		BirdFontFont* _tmp56_;
		BirdFontKerningClasses* _tmp57_;
		BirdFontKerningClasses* _tmp58_;
		BirdFontGlyphRange* _tmp59_;
		BirdFontGlyphRange* _tmp60_;
		_tmp0_ = bird_font_glyph_range_new ();
		_bird_font_glyph_range_unref0 (range_left);
		range_left = _tmp0_;
		_tmp1_ = bird_font_glyph_range_new ();
		_bird_font_glyph_range_unref0 (range_right);
		range_right = _tmp1_;
		{
			BAttributesIterator* _attr_it = NULL;
			BAttributes* _tmp2_;
			BAttributes* _tmp3_;
			BAttributesIterator* _tmp4_;
			BAttributesIterator* _tmp5_;
			_tmp2_ = b_tag_get_attributes (tag);
			_tmp3_ = _tmp2_;
			_tmp4_ = b_attributes_iterator (_tmp3_);
			_tmp5_ = _tmp4_;
			_g_object_unref0 (_tmp3_);
			_attr_it = _tmp5_;
			while (TRUE) {
				BAttributesIterator* _tmp6_;
				BAttribute* attr = NULL;
				BAttributesIterator* _tmp7_;
				BAttribute* _tmp8_;
				BAttribute* _tmp9_;
				gchar* _tmp10_;
				gchar* _tmp11_;
				gboolean _tmp12_;
				BAttribute* _tmp21_;
				gchar* _tmp22_;
				gchar* _tmp23_;
				gboolean _tmp24_;
				BAttribute* _tmp33_;
				gchar* _tmp34_;
				gchar* _tmp35_;
				gboolean _tmp36_;
				_tmp6_ = _attr_it;
				if (!b_attributes_iterator_next (_tmp6_)) {
					break;
				}
				_tmp7_ = _attr_it;
				_tmp8_ = b_attributes_iterator_get (_tmp7_);
				attr = _tmp8_;
				_tmp9_ = attr;
				_tmp10_ = b_attribute_get_name (_tmp9_);
				_tmp11_ = _tmp10_;
				_tmp12_ = g_strcmp0 (_tmp11_, "left") == 0;
				_g_free0 (_tmp11_);
				if (_tmp12_) {
					BirdFontGlyphRange* _tmp13_;
					BAttribute* _tmp14_;
					gchar* _tmp15_;
					gchar* _tmp16_;
					gchar* _tmp17_;
					gchar* _tmp18_;
					gchar* _tmp19_;
					gchar* _tmp20_;
					_tmp13_ = range_left;
					_tmp14_ = attr;
					_tmp15_ = b_attribute_get_content (_tmp14_);
					_tmp16_ = _tmp15_;
					_tmp17_ = bird_font_bird_font_file_decode (_tmp16_);
					_tmp18_ = _tmp17_;
					_tmp19_ = bird_font_bird_font_file_unserialize (_tmp18_);
					_tmp20_ = _tmp19_;
					bird_font_glyph_range_parse_ranges (_tmp13_, _tmp20_, &_inner_error0_);
					_g_free0 (_tmp20_);
					_g_free0 (_tmp18_);
					_g_free0 (_tmp16_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_object_unref0 (attr);
						_g_object_unref0 (_attr_it);
						if (_inner_error0_->domain == G_MARKUP_ERROR) {
							goto __catch0_g_markup_error;
						}
						_g_object_unref0 (kerning_range);
						_bird_font_glyph_range_unref0 (range_right);
						_bird_font_glyph_range_unref0 (range_left);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
				}
				_tmp21_ = attr;
				_tmp22_ = b_attribute_get_name (_tmp21_);
				_tmp23_ = _tmp22_;
				_tmp24_ = g_strcmp0 (_tmp23_, "right") == 0;
				_g_free0 (_tmp23_);
				if (_tmp24_) {
					BirdFontGlyphRange* _tmp25_;
					BAttribute* _tmp26_;
					gchar* _tmp27_;
					gchar* _tmp28_;
					gchar* _tmp29_;
					gchar* _tmp30_;
					gchar* _tmp31_;
					gchar* _tmp32_;
					_tmp25_ = range_right;
					_tmp26_ = attr;
					_tmp27_ = b_attribute_get_content (_tmp26_);
					_tmp28_ = _tmp27_;
					_tmp29_ = bird_font_bird_font_file_decode (_tmp28_);
					_tmp30_ = _tmp29_;
					_tmp31_ = bird_font_bird_font_file_unserialize (_tmp30_);
					_tmp32_ = _tmp31_;
					bird_font_glyph_range_parse_ranges (_tmp25_, _tmp32_, &_inner_error0_);
					_g_free0 (_tmp32_);
					_g_free0 (_tmp30_);
					_g_free0 (_tmp28_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_object_unref0 (attr);
						_g_object_unref0 (_attr_it);
						if (_inner_error0_->domain == G_MARKUP_ERROR) {
							goto __catch0_g_markup_error;
						}
						_g_object_unref0 (kerning_range);
						_bird_font_glyph_range_unref0 (range_right);
						_bird_font_glyph_range_unref0 (range_left);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
				}
				_tmp33_ = attr;
				_tmp34_ = b_attribute_get_name (_tmp33_);
				_tmp35_ = _tmp34_;
				_tmp36_ = g_strcmp0 (_tmp35_, "hadjustment") == 0;
				_g_free0 (_tmp35_);
				if (_tmp36_) {
					BAttribute* _tmp37_;
					gchar* _tmp38_;
					gchar* _tmp39_;
					_tmp37_ = attr;
					_tmp38_ = b_attribute_get_content (_tmp37_);
					_tmp39_ = _tmp38_;
					hadjustment = double_parse (_tmp39_);
					_g_free0 (_tmp39_);
				}
				_g_object_unref0 (attr);
			}
			_g_object_unref0 (_attr_it);
		}
		_tmp40_ = range_left;
		if (bird_font_glyph_range_get_length (_tmp40_) > ((guint32) 1)) {
			BirdFontFont* _tmp41_;
			BirdFontKerningRange* _tmp42_;
			BirdFontKerningRange* _tmp43_;
			BirdFontGlyphRange* _tmp44_;
			gchar* _tmp45_;
			gchar* _tmp46_;
			BirdFontKerningRange* _tmp47_;
			_tmp41_ = self->priv->font;
			_tmp42_ = bird_font_kerning_range_new (_tmp41_, NULL, "");
			_g_object_unref0 (kerning_range);
			kerning_range = _tmp42_;
			_tmp43_ = kerning_range;
			_tmp44_ = range_left;
			_tmp45_ = bird_font_glyph_range_get_all_ranges (_tmp44_);
			_tmp46_ = _tmp45_;
			bird_font_kerning_range_set_ranges (_tmp43_, _tmp46_);
			_g_free0 (_tmp46_);
			_tmp47_ = kerning_range;
			bird_font_kerning_tools_add_unique_class (_tmp47_);
		}
		_tmp48_ = range_right;
		if (bird_font_glyph_range_get_length (_tmp48_) > ((guint32) 1)) {
			BirdFontFont* _tmp49_;
			BirdFontKerningRange* _tmp50_;
			BirdFontKerningRange* _tmp51_;
			BirdFontGlyphRange* _tmp52_;
			gchar* _tmp53_;
			gchar* _tmp54_;
			BirdFontKerningRange* _tmp55_;
			_tmp49_ = self->priv->font;
			_tmp50_ = bird_font_kerning_range_new (_tmp49_, NULL, "");
			_g_object_unref0 (kerning_range);
			kerning_range = _tmp50_;
			_tmp51_ = kerning_range;
			_tmp52_ = range_right;
			_tmp53_ = bird_font_glyph_range_get_all_ranges (_tmp52_);
			_tmp54_ = _tmp53_;
			bird_font_kerning_range_set_ranges (_tmp51_, _tmp54_);
			_g_free0 (_tmp54_);
			_tmp55_ = kerning_range;
			bird_font_kerning_tools_add_unique_class (_tmp55_);
		}
		_tmp56_ = self->priv->font;
		_tmp57_ = bird_font_font_get_kerning_classes (_tmp56_);
		_tmp58_ = _tmp57_;
		_tmp59_ = range_left;
		_tmp60_ = range_right;
		bird_font_kerning_classes_set_kerning (_tmp58_, _tmp59_, _tmp60_, hadjustment, -1);
		_g_object_unref0 (_tmp58_);
	}
	goto __finally0;
	__catch0_g_markup_error:
	{
		GError* e = NULL;
		GError* _tmp61_;
		const gchar* _tmp62_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp61_ = e;
		_tmp62_ = _tmp61_->message;
		g_warning ("BirdFontFile.vala:1185: %s", _tmp62_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (kerning_range);
		_bird_font_glyph_range_unref0 (range_right);
		_bird_font_glyph_range_unref0 (range_left);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (kerning_range);
	_bird_font_glyph_range_unref0 (range_right);
	_bird_font_glyph_range_unref0 (range_left);
}

static void
bird_font_bird_font_file_parse_background_image (BirdFontBirdFontFile* self,
                                                 BTag* tag)
{
	gchar* file = NULL;
	gchar* _tmp0_;
	gchar* data = NULL;
	gchar* _tmp1_;
	GFile* img_dir = NULL;
	GFile* img_file = NULL;
	GFileOutputStream* file_stream = NULL;
	GDataOutputStream* png_stream = NULL;
	BirdFontFont* _tmp21_;
	GFile* _tmp22_;
	GFile* _tmp23_;
	gboolean _tmp24_;
	BirdFontFont* _tmp30_;
	GFile* _tmp31_;
	GFile* _tmp32_;
	GFile* _tmp33_;
	GFile* _tmp34_;
	GFile* _tmp38_;
	const gchar* _tmp39_;
	const gchar* _tmp40_;
	gchar* _tmp41_;
	gchar* _tmp42_;
	GFile* _tmp43_;
	GFile* _tmp44_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tag != NULL);
	_tmp0_ = g_strdup ("");
	file = _tmp0_;
	_tmp1_ = g_strdup ("");
	data = _tmp1_;
	b_tag_reparse (tag);
	{
		BAttributesIterator* _attr_it = NULL;
		BAttributes* _tmp2_;
		BAttributes* _tmp3_;
		BAttributesIterator* _tmp4_;
		BAttributesIterator* _tmp5_;
		_tmp2_ = b_tag_get_attributes (tag);
		_tmp3_ = _tmp2_;
		_tmp4_ = b_attributes_iterator (_tmp3_);
		_tmp5_ = _tmp4_;
		_g_object_unref0 (_tmp3_);
		_attr_it = _tmp5_;
		while (TRUE) {
			BAttributesIterator* _tmp6_;
			BAttribute* attr = NULL;
			BAttributesIterator* _tmp7_;
			BAttribute* _tmp8_;
			BAttribute* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			gboolean _tmp12_;
			BAttribute* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			gboolean _tmp18_;
			_tmp6_ = _attr_it;
			if (!b_attributes_iterator_next (_tmp6_)) {
				break;
			}
			_tmp7_ = _attr_it;
			_tmp8_ = b_attributes_iterator_get (_tmp7_);
			attr = _tmp8_;
			_tmp9_ = attr;
			_tmp10_ = b_attribute_get_name (_tmp9_);
			_tmp11_ = _tmp10_;
			_tmp12_ = g_strcmp0 (_tmp11_, "sha1") == 0;
			_g_free0 (_tmp11_);
			if (_tmp12_) {
				BAttribute* _tmp13_;
				gchar* _tmp14_;
				_tmp13_ = attr;
				_tmp14_ = b_attribute_get_content (_tmp13_);
				_g_free0 (file);
				file = _tmp14_;
			}
			_tmp15_ = attr;
			_tmp16_ = b_attribute_get_name (_tmp15_);
			_tmp17_ = _tmp16_;
			_tmp18_ = g_strcmp0 (_tmp17_, "data") == 0;
			_g_free0 (_tmp17_);
			if (_tmp18_) {
				BAttribute* _tmp19_;
				gchar* _tmp20_;
				_tmp19_ = attr;
				_tmp20_ = b_attribute_get_content (_tmp19_);
				_g_free0 (data);
				data = _tmp20_;
			}
			_g_object_unref0 (attr);
		}
		_g_object_unref0 (_attr_it);
	}
	_tmp21_ = self->priv->font;
	_tmp22_ = bird_font_font_get_backgrounds_folder (_tmp21_);
	_tmp23_ = _tmp22_;
	_tmp24_ = !g_file_query_exists (_tmp23_, NULL);
	_g_object_unref0 (_tmp23_);
	if (_tmp24_) {
		BirdFontFont* _tmp25_;
		GFile* _tmp26_;
		GFile* _tmp27_;
		gchar* _tmp28_;
		gchar* _tmp29_;
		_tmp25_ = self->priv->font;
		_tmp26_ = bird_font_font_get_backgrounds_folder (_tmp25_);
		_tmp27_ = _tmp26_;
		_tmp28_ = g_file_get_path (_tmp27_);
		_tmp29_ = (gchar*) _tmp28_;
		g_mkdir (_tmp29_, 0755);
		_g_free0 (_tmp29_);
		_g_object_unref0 (_tmp27_);
	}
	_tmp30_ = self->priv->font;
	_tmp31_ = bird_font_font_get_backgrounds_folder (_tmp30_);
	_tmp32_ = _tmp31_;
	_tmp33_ = bird_font_get_child (_tmp32_, "parts");
	_g_object_unref0 (img_dir);
	img_dir = _tmp33_;
	_g_object_unref0 (_tmp32_);
	_tmp34_ = img_dir;
	if (!g_file_query_exists (_tmp34_, NULL)) {
		GFile* _tmp35_;
		gchar* _tmp36_;
		gchar* _tmp37_;
		_tmp35_ = img_dir;
		_tmp36_ = g_file_get_path (_tmp35_);
		_tmp37_ = (gchar*) _tmp36_;
		g_mkdir (_tmp37_, 0755);
		_g_free0 (_tmp37_);
	}
	_tmp38_ = img_dir;
	_tmp39_ = file;
	_tmp40_ = string_to_string (_tmp39_);
	_tmp41_ = g_strconcat (_tmp40_, ".png", NULL);
	_tmp42_ = _tmp41_;
	_tmp43_ = bird_font_get_child (_tmp38_, _tmp42_);
	_g_object_unref0 (img_file);
	img_file = _tmp43_;
	_g_free0 (_tmp42_);
	_tmp44_ = img_file;
	if (g_file_query_exists (_tmp44_, NULL)) {
		_g_object_unref0 (png_stream);
		_g_object_unref0 (file_stream);
		_g_object_unref0 (img_file);
		_g_object_unref0 (img_dir);
		_g_free0 (data);
		_g_free0 (file);
		return;
	}
	{
		GFileOutputStream* _tmp45_ = NULL;
		GFile* _tmp46_;
		GFileOutputStream* _tmp47_;
		GFileOutputStream* _tmp48_;
		GFileOutputStream* _tmp49_;
		GDataOutputStream* _tmp50_;
		GDataOutputStream* _tmp51_;
		const gchar* _tmp52_;
		gsize _tmp53_ = 0;
		guchar* _tmp54_;
		guchar* _tmp55_;
		gint _tmp55__length1;
		GDataOutputStream* _tmp56_;
		_tmp46_ = img_file;
		_tmp47_ = g_file_create (_tmp46_, G_FILE_CREATE_REPLACE_DESTINATION, NULL, &_inner_error0_);
		_tmp45_ = _tmp47_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp48_ = _tmp45_;
		_tmp45_ = NULL;
		_g_object_unref0 (file_stream);
		file_stream = _tmp48_;
		_tmp49_ = file_stream;
		_tmp50_ = g_data_output_stream_new ((GOutputStream*) _tmp49_);
		_g_object_unref0 (png_stream);
		png_stream = _tmp50_;
		_tmp51_ = png_stream;
		_tmp52_ = data;
		_tmp54_ = g_base64_decode (_tmp52_, &_tmp53_);
		_tmp55_ = _tmp54_;
		_tmp55__length1 = _tmp53_;
		g_output_stream_write ((GOutputStream*) _tmp51_, _tmp55_, (gsize) _tmp53_, NULL, &_inner_error0_);
		_tmp55_ = (g_free (_tmp55_), NULL);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp45_);
			goto __catch0_g_error;
		}
		_tmp56_ = png_stream;
		g_output_stream_close ((GOutputStream*) _tmp56_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp45_);
			goto __catch0_g_error;
		}
		_g_object_unref0 (_tmp45_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp57_;
		const gchar* _tmp58_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp57_ = e;
		_tmp58_ = _tmp57_->message;
		g_warning ("BirdFontFile.vala:1232: %s", _tmp58_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (png_stream);
		_g_object_unref0 (file_stream);
		_g_object_unref0 (img_file);
		_g_object_unref0 (img_dir);
		_g_free0 (data);
		_g_free0 (file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (png_stream);
	_g_object_unref0 (file_stream);
	_g_object_unref0 (img_file);
	_g_object_unref0 (img_dir);
	_g_free0 (data);
	_g_free0 (file);
}

static void
bird_font_bird_font_file_parse_background (BirdFontBirdFontFile* self,
                                           BTag* tag)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (tag != NULL);
	{
		BAttributesIterator* _attr_it = NULL;
		BAttributes* _tmp0_;
		BAttributes* _tmp1_;
		BAttributesIterator* _tmp2_;
		BAttributesIterator* _tmp3_;
		_tmp0_ = b_tag_get_attributes (tag);
		_tmp1_ = _tmp0_;
		_tmp2_ = b_attributes_iterator (_tmp1_);
		_tmp3_ = _tmp2_;
		_g_object_unref0 (_tmp1_);
		_attr_it = _tmp3_;
		while (TRUE) {
			BAttributesIterator* _tmp4_;
			BAttribute* attr = NULL;
			BAttributesIterator* _tmp5_;
			BAttribute* _tmp6_;
			BAttribute* _tmp7_;
			gchar* _tmp8_;
			gchar* _tmp9_;
			gboolean _tmp10_;
			_tmp4_ = _attr_it;
			if (!b_attributes_iterator_next (_tmp4_)) {
				break;
			}
			_tmp5_ = _attr_it;
			_tmp6_ = b_attributes_iterator_get (_tmp5_);
			attr = _tmp6_;
			_tmp7_ = attr;
			_tmp8_ = b_attribute_get_name (_tmp7_);
			_tmp9_ = _tmp8_;
			_tmp10_ = g_strcmp0 (_tmp9_, "scale") == 0;
			_g_free0 (_tmp9_);
			if (_tmp10_) {
				BirdFontFont* _tmp11_;
				BAttribute* _tmp12_;
				gchar* _tmp13_;
				_tmp11_ = self->priv->font;
				_tmp12_ = attr;
				_tmp13_ = b_attribute_get_content (_tmp12_);
				_g_free0 (_tmp11_->background_scale);
				_tmp11_->background_scale = _tmp13_;
			}
			_g_object_unref0 (attr);
		}
		_g_object_unref0 (_attr_it);
	}
}

static gboolean
bird_font_bird_font_file_has_grid (BirdFontBirdFontFile* self,
                                   const gchar* v)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (v != NULL, FALSE);
	{
		GeeArrayList* _g_list = NULL;
		BirdFontFont* _tmp0_;
		GeeArrayList* _tmp1_;
		gint _g_size = 0;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _g_index = 0;
		_tmp0_ = self->priv->font;
		_tmp1_ = _tmp0_->grid_width;
		_g_list = _tmp1_;
		_tmp2_ = _g_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_g_size = _tmp4_;
		_g_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gchar* g = NULL;
			GeeArrayList* _tmp7_;
			gpointer _tmp8_;
			const gchar* _tmp9_;
			_g_index = _g_index + 1;
			_tmp5_ = _g_index;
			_tmp6_ = _g_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _g_list;
			_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _g_index);
			g = (gchar*) _tmp8_;
			_tmp9_ = g;
			if (g_strcmp0 (_tmp9_, v) == 0) {
				result = TRUE;
				_g_free0 (g);
				return result;
			}
			_g_free0 (g);
		}
	}
	result = FALSE;
	return result;
}

static void
bird_font_bird_font_file_parse_grid (BirdFontBirdFontFile* self,
                                     BTag* tag)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (tag != NULL);
	{
		BAttributesIterator* _attr_it = NULL;
		BAttributes* _tmp0_;
		BAttributes* _tmp1_;
		BAttributesIterator* _tmp2_;
		BAttributesIterator* _tmp3_;
		_tmp0_ = b_tag_get_attributes (tag);
		_tmp1_ = _tmp0_;
		_tmp2_ = b_attributes_iterator (_tmp1_);
		_tmp3_ = _tmp2_;
		_g_object_unref0 (_tmp1_);
		_attr_it = _tmp3_;
		while (TRUE) {
			BAttributesIterator* _tmp4_;
			BAttribute* attr = NULL;
			BAttributesIterator* _tmp5_;
			BAttribute* _tmp6_;
			gchar* v = NULL;
			BAttribute* _tmp7_;
			gchar* _tmp8_;
			gboolean _tmp9_ = FALSE;
			BAttribute* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			gboolean _tmp13_;
			_tmp4_ = _attr_it;
			if (!b_attributes_iterator_next (_tmp4_)) {
				break;
			}
			_tmp5_ = _attr_it;
			_tmp6_ = b_attributes_iterator_get (_tmp5_);
			attr = _tmp6_;
			_tmp7_ = attr;
			_tmp8_ = b_attribute_get_content (_tmp7_);
			v = _tmp8_;
			_tmp10_ = attr;
			_tmp11_ = b_attribute_get_name (_tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = g_strcmp0 (_tmp12_, "width") == 0;
			_g_free0 (_tmp12_);
			if (_tmp13_) {
				const gchar* _tmp14_;
				_tmp14_ = v;
				_tmp9_ = !bird_font_bird_font_file_has_grid (self, _tmp14_);
			} else {
				_tmp9_ = FALSE;
			}
			if (_tmp9_) {
				BirdFontFont* _tmp15_;
				GeeArrayList* _tmp16_;
				const gchar* _tmp17_;
				_tmp15_ = self->priv->font;
				_tmp16_ = _tmp15_->grid_width;
				_tmp17_ = v;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp16_, _tmp17_);
			}
			_g_free0 (v);
			_g_object_unref0 (attr);
		}
		_g_object_unref0 (_attr_it);
	}
}

static void
bird_font_bird_font_file_parse_horizontal_lines (BirdFontBirdFontFile* self,
                                                 BTag* tag)
{
	BirdFontLine* line = NULL;
	gchar* label = NULL;
	gdouble position = 0.0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tag != NULL);
	{
		BTagIterator* _t_it = NULL;
		BTagIterator* _tmp0_;
		_tmp0_ = b_tag_iterator (tag);
		_t_it = _tmp0_;
		while (TRUE) {
			BTagIterator* _tmp1_;
			BTag* t = NULL;
			BTagIterator* _tmp2_;
			BTag* _tmp3_;
			gboolean _tmp4_ = FALSE;
			BTag* _tmp5_;
			gchar* _tmp6_;
			gchar* _tmp7_;
			gboolean _tmp8_;
			gboolean _tmp14_ = FALSE;
			BTag* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			gboolean _tmp18_;
			gboolean _tmp24_ = FALSE;
			BTag* _tmp25_;
			gchar* _tmp26_;
			gchar* _tmp27_;
			gboolean _tmp28_;
			gboolean _tmp34_ = FALSE;
			BTag* _tmp35_;
			gchar* _tmp36_;
			gchar* _tmp37_;
			gboolean _tmp38_;
			gboolean _tmp44_ = FALSE;
			BTag* _tmp45_;
			gchar* _tmp46_;
			gchar* _tmp47_;
			gboolean _tmp48_;
			gboolean _tmp54_ = FALSE;
			BTag* _tmp55_;
			gchar* _tmp56_;
			gchar* _tmp57_;
			gboolean _tmp58_;
			gboolean _tmp64_ = FALSE;
			BTag* _tmp65_;
			gchar* _tmp66_;
			gchar* _tmp67_;
			gboolean _tmp68_;
			_tmp1_ = _t_it;
			if (!b_tag_iterator_next (_tmp1_)) {
				break;
			}
			_tmp2_ = _t_it;
			_tmp3_ = b_tag_iterator_get (_tmp2_);
			t = _tmp3_;
			_tmp5_ = t;
			_tmp6_ = b_tag_get_name (_tmp5_);
			_tmp7_ = _tmp6_;
			_tmp8_ = g_strcmp0 (_tmp7_, "top_limit") == 0;
			_g_free0 (_tmp7_);
			if (_tmp8_) {
				BTag* _tmp9_;
				gchar* _tmp10_;
				gchar* _tmp11_;
				_tmp9_ = t;
				_tmp10_ = b_tag_get_content (_tmp9_);
				_tmp11_ = _tmp10_;
				_tmp4_ = g_strcmp0 (_tmp11_, "") != 0;
				_g_free0 (_tmp11_);
			} else {
				_tmp4_ = FALSE;
			}
			if (_tmp4_) {
				BirdFontFont* _tmp12_;
				BTag* _tmp13_;
				_tmp12_ = self->priv->font;
				_tmp13_ = t;
				_tmp12_->top_limit = bird_font_bird_font_file_parse_double_from_node (self, _tmp13_);
			}
			_tmp15_ = t;
			_tmp16_ = b_tag_get_name (_tmp15_);
			_tmp17_ = _tmp16_;
			_tmp18_ = g_strcmp0 (_tmp17_, "top_position") == 0;
			_g_free0 (_tmp17_);
			if (_tmp18_) {
				BTag* _tmp19_;
				gchar* _tmp20_;
				gchar* _tmp21_;
				_tmp19_ = t;
				_tmp20_ = b_tag_get_content (_tmp19_);
				_tmp21_ = _tmp20_;
				_tmp14_ = g_strcmp0 (_tmp21_, "") != 0;
				_g_free0 (_tmp21_);
			} else {
				_tmp14_ = FALSE;
			}
			if (_tmp14_) {
				BirdFontFont* _tmp22_;
				BTag* _tmp23_;
				_tmp22_ = self->priv->font;
				_tmp23_ = t;
				_tmp22_->top_position = bird_font_bird_font_file_parse_double_from_node (self, _tmp23_);
			}
			_tmp25_ = t;
			_tmp26_ = b_tag_get_name (_tmp25_);
			_tmp27_ = _tmp26_;
			_tmp28_ = g_strcmp0 (_tmp27_, "x-height") == 0;
			_g_free0 (_tmp27_);
			if (_tmp28_) {
				BTag* _tmp29_;
				gchar* _tmp30_;
				gchar* _tmp31_;
				_tmp29_ = t;
				_tmp30_ = b_tag_get_content (_tmp29_);
				_tmp31_ = _tmp30_;
				_tmp24_ = g_strcmp0 (_tmp31_, "") != 0;
				_g_free0 (_tmp31_);
			} else {
				_tmp24_ = FALSE;
			}
			if (_tmp24_) {
				BirdFontFont* _tmp32_;
				BTag* _tmp33_;
				_tmp32_ = self->priv->font;
				_tmp33_ = t;
				_tmp32_->xheight_position = bird_font_bird_font_file_parse_double_from_node (self, _tmp33_);
			}
			_tmp35_ = t;
			_tmp36_ = b_tag_get_name (_tmp35_);
			_tmp37_ = _tmp36_;
			_tmp38_ = g_strcmp0 (_tmp37_, "base_line") == 0;
			_g_free0 (_tmp37_);
			if (_tmp38_) {
				BTag* _tmp39_;
				gchar* _tmp40_;
				gchar* _tmp41_;
				_tmp39_ = t;
				_tmp40_ = b_tag_get_content (_tmp39_);
				_tmp41_ = _tmp40_;
				_tmp34_ = g_strcmp0 (_tmp41_, "") != 0;
				_g_free0 (_tmp41_);
			} else {
				_tmp34_ = FALSE;
			}
			if (_tmp34_) {
				BirdFontFont* _tmp42_;
				BTag* _tmp43_;
				_tmp42_ = self->priv->font;
				_tmp43_ = t;
				_tmp42_->base_line = bird_font_bird_font_file_parse_double_from_node (self, _tmp43_);
			}
			_tmp45_ = t;
			_tmp46_ = b_tag_get_name (_tmp45_);
			_tmp47_ = _tmp46_;
			_tmp48_ = g_strcmp0 (_tmp47_, "bottom_position") == 0;
			_g_free0 (_tmp47_);
			if (_tmp48_) {
				BTag* _tmp49_;
				gchar* _tmp50_;
				gchar* _tmp51_;
				_tmp49_ = t;
				_tmp50_ = b_tag_get_content (_tmp49_);
				_tmp51_ = _tmp50_;
				_tmp44_ = g_strcmp0 (_tmp51_, "") != 0;
				_g_free0 (_tmp51_);
			} else {
				_tmp44_ = FALSE;
			}
			if (_tmp44_) {
				BirdFontFont* _tmp52_;
				BTag* _tmp53_;
				_tmp52_ = self->priv->font;
				_tmp53_ = t;
				_tmp52_->bottom_position = bird_font_bird_font_file_parse_double_from_node (self, _tmp53_);
			}
			_tmp55_ = t;
			_tmp56_ = b_tag_get_name (_tmp55_);
			_tmp57_ = _tmp56_;
			_tmp58_ = g_strcmp0 (_tmp57_, "bottom_limit") == 0;
			_g_free0 (_tmp57_);
			if (_tmp58_) {
				BTag* _tmp59_;
				gchar* _tmp60_;
				gchar* _tmp61_;
				_tmp59_ = t;
				_tmp60_ = b_tag_get_content (_tmp59_);
				_tmp61_ = _tmp60_;
				_tmp54_ = g_strcmp0 (_tmp61_, "") != 0;
				_g_free0 (_tmp61_);
			} else {
				_tmp54_ = FALSE;
			}
			if (_tmp54_) {
				BirdFontFont* _tmp62_;
				BTag* _tmp63_;
				_tmp62_ = self->priv->font;
				_tmp63_ = t;
				_tmp62_->bottom_limit = bird_font_bird_font_file_parse_double_from_node (self, _tmp63_);
			}
			_tmp65_ = t;
			_tmp66_ = b_tag_get_name (_tmp65_);
			_tmp67_ = _tmp66_;
			_tmp68_ = g_strcmp0 (_tmp67_, "custom_guide") == 0;
			_g_free0 (_tmp67_);
			if (_tmp68_) {
				BTag* _tmp69_;
				gchar* _tmp70_;
				gchar* _tmp71_;
				_tmp69_ = t;
				_tmp70_ = b_tag_get_content (_tmp69_);
				_tmp71_ = _tmp70_;
				_tmp64_ = g_strcmp0 (_tmp71_, "") != 0;
				_g_free0 (_tmp71_);
			} else {
				_tmp64_ = FALSE;
			}
			if (_tmp64_) {
				BTag* _tmp72_;
				gchar* _tmp73_;
				const gchar* _tmp90_;
				const gchar* _tmp91_;
				BirdFontLine* _tmp92_;
				BirdFontFont* _tmp93_;
				GeeArrayList* _tmp94_;
				BirdFontLine* _tmp95_;
				_tmp72_ = t;
				position = bird_font_bird_font_file_parse_double_from_node (self, _tmp72_);
				_tmp73_ = g_strdup ("");
				_g_free0 (label);
				label = _tmp73_;
				{
					BAttributesIterator* _attr_it = NULL;
					BTag* _tmp74_;
					BAttributes* _tmp75_;
					BAttributes* _tmp76_;
					BAttributesIterator* _tmp77_;
					BAttributesIterator* _tmp78_;
					_tmp74_ = t;
					_tmp75_ = b_tag_get_attributes (_tmp74_);
					_tmp76_ = _tmp75_;
					_tmp77_ = b_attributes_iterator (_tmp76_);
					_tmp78_ = _tmp77_;
					_g_object_unref0 (_tmp76_);
					_attr_it = _tmp78_;
					while (TRUE) {
						BAttributesIterator* _tmp79_;
						BAttribute* attr = NULL;
						BAttributesIterator* _tmp80_;
						BAttribute* _tmp81_;
						BAttribute* _tmp82_;
						gchar* _tmp83_;
						gchar* _tmp84_;
						gboolean _tmp85_;
						_tmp79_ = _attr_it;
						if (!b_attributes_iterator_next (_tmp79_)) {
							break;
						}
						_tmp80_ = _attr_it;
						_tmp81_ = b_attributes_iterator_get (_tmp80_);
						attr = _tmp81_;
						_tmp82_ = attr;
						_tmp83_ = b_attribute_get_name (_tmp82_);
						_tmp84_ = _tmp83_;
						_tmp85_ = g_strcmp0 (_tmp84_, "label") == 0;
						_g_free0 (_tmp84_);
						if (_tmp85_) {
							BAttribute* _tmp86_;
							gchar* _tmp87_;
							gchar* _tmp88_;
							gchar* _tmp89_;
							_tmp86_ = attr;
							_tmp87_ = b_attribute_get_content (_tmp86_);
							_tmp88_ = _tmp87_;
							_tmp89_ = bird_font_bird_font_file_decode (_tmp88_);
							_g_free0 (label);
							label = _tmp89_;
							_g_free0 (_tmp88_);
						}
						_g_object_unref0 (attr);
					}
					_g_object_unref0 (_attr_it);
				}
				_tmp90_ = label;
				_tmp91_ = label;
				_tmp92_ = bird_font_line_new (_tmp90_, _tmp91_, position, FALSE);
				_g_object_unref0 (line);
				line = _tmp92_;
				_tmp93_ = self->priv->font;
				_tmp94_ = _tmp93_->custom_guides;
				_tmp95_ = line;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp94_, _tmp95_);
			}
			_g_object_unref0 (t);
		}
		_g_object_unref0 (_t_it);
	}
	_g_free0 (label);
	_g_object_unref0 (line);
}

static gboolean
double_try_parse (const gchar* str,
                  gdouble* _result_,
                  const gchar** unparsed)
{
	gdouble _vala__result_ = 0.0;
	const gchar* _vala_unparsed = NULL;
	gchar* endptr = NULL;
	gchar* _tmp0_ = NULL;
	gdouble _tmp1_;
	gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gboolean result;
	g_return_val_if_fail (str != NULL, FALSE);
	errno = 0;
	_tmp1_ = g_ascii_strtod (str, &_tmp0_);
	endptr = _tmp0_;
	_vala__result_ = _tmp1_;
	_tmp2_ = endptr;
	_tmp3_ = strlen (str);
	_tmp4_ = _tmp3_;
	if (_tmp2_ == (((gchar*) str) + _tmp4_)) {
		_vala_unparsed = "";
		result = errno != ERANGE;
		if (_result_) {
			*_result_ = _vala__result_;
		}
		if (unparsed) {
			*unparsed = _vala_unparsed;
		}
		return result;
	} else {
		gchar* _tmp5_;
		_tmp5_ = endptr;
		_vala_unparsed = (const gchar*) _tmp5_;
		result = FALSE;
		if (_result_) {
			*_result_ = _vala__result_;
		}
		if (unparsed) {
			*unparsed = _vala_unparsed;
		}
		return result;
	}
}

static gdouble
bird_font_bird_font_file_parse_double_from_node (BirdFontBirdFontFile* self,
                                                 BTag* tag)
{
	gdouble d = 0.0;
	gboolean r = FALSE;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gdouble _tmp2_ = 0.0;
	gboolean _tmp3_;
	gboolean _tmp4_;
	gchar* s = NULL;
	gdouble _tmp12_ = 0.0;
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	g_return_val_if_fail (tag != NULL, 0.0);
	_tmp0_ = b_tag_get_content (tag);
	_tmp1_ = _tmp0_;
	_tmp3_ = double_try_parse (_tmp1_, &_tmp2_, NULL);
	d = _tmp2_;
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp1_);
	r = _tmp4_;
	if (G_UNLIKELY (!r)) {
		gchar* _tmp5_;
		const gchar* _tmp6_;
		_tmp5_ = b_tag_get_content (tag);
		_g_free0 (s);
		s = _tmp5_;
		_tmp6_ = s;
		if (g_strcmp0 (_tmp6_, "") == 0) {
			g_warning ("BirdFontFile.vala:1319: %s", "No content for node\n");
		} else {
			gchar* _tmp7_;
			gchar* _tmp8_;
			const gchar* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			_tmp7_ = b_tag_get_content (tag);
			_tmp8_ = _tmp7_;
			_tmp9_ = string_to_string (_tmp8_);
			_tmp10_ = g_strconcat ("Failed to parse double for \"", _tmp9_, "\"\n", NULL);
			_tmp11_ = _tmp10_;
			g_warning ("BirdFontFile.vala:1321: %s", _tmp11_);
			_g_free0 (_tmp11_);
			_g_free0 (_tmp8_);
		}
	}
	if (r) {
		_tmp12_ = d;
	} else {
		_tmp12_ = 0.0;
	}
	result = _tmp12_;
	_g_free0 (s);
	return result;
}

/** Parse the new glyph format */
static void
bird_font_bird_font_file_parse_glyph_collection (BirdFontBirdFontFile* self,
                                                 BTag* tag)
{
	gunichar unicode = 0U;
	BirdFontGlyphCollection* gc = NULL;
	BirdFontGlyphCollection* current_gc = NULL;
	gboolean new_glyph_collection = FALSE;
	GString* b = NULL;
	gchar* name = NULL;
	gchar* _tmp0_;
	gint selected_id = 0;
	gboolean unassigned = FALSE;
	gchar* master_id = NULL;
	gchar* _tmp1_;
	BirdFontGlyphMaster* master = NULL;
	BirdFontFont* _tmp37_;
	const gchar* _tmp38_;
	BirdFontGlyphCollection* _tmp39_;
	BirdFontGlyphCollection* _tmp40_;
	BirdFontGlyphCollection* _tmp45_;
	const gchar* _tmp46_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tag != NULL);
	unicode = (gunichar) 0;
	_tmp0_ = g_strdup ("");
	name = _tmp0_;
	selected_id = -1;
	unassigned = FALSE;
	_tmp1_ = g_strdup ("");
	master_id = _tmp1_;
	{
		BAttributesIterator* _attribute_it = NULL;
		BAttributes* _tmp2_;
		BAttributes* _tmp3_;
		BAttributesIterator* _tmp4_;
		BAttributesIterator* _tmp5_;
		_tmp2_ = b_tag_get_attributes (tag);
		_tmp3_ = _tmp2_;
		_tmp4_ = b_attributes_iterator (_tmp3_);
		_tmp5_ = _tmp4_;
		_g_object_unref0 (_tmp3_);
		_attribute_it = _tmp5_;
		while (TRUE) {
			BAttributesIterator* _tmp6_;
			BAttribute* attribute = NULL;
			BAttributesIterator* _tmp7_;
			BAttribute* _tmp8_;
			BAttribute* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			gboolean _tmp12_;
			BAttribute* _tmp23_;
			gchar* _tmp24_;
			gchar* _tmp25_;
			gboolean _tmp26_;
			BAttribute* _tmp31_;
			gchar* _tmp32_;
			gchar* _tmp33_;
			gboolean _tmp34_;
			_tmp6_ = _attribute_it;
			if (!b_attributes_iterator_next (_tmp6_)) {
				break;
			}
			_tmp7_ = _attribute_it;
			_tmp8_ = b_attributes_iterator_get (_tmp7_);
			attribute = _tmp8_;
			_tmp9_ = attribute;
			_tmp10_ = b_attribute_get_name (_tmp9_);
			_tmp11_ = _tmp10_;
			_tmp12_ = g_strcmp0 (_tmp11_, "unicode") == 0;
			_g_free0 (_tmp11_);
			if (_tmp12_) {
				BAttribute* _tmp13_;
				gchar* _tmp14_;
				gchar* _tmp15_;
				GString* _tmp16_;
				GString* _tmp17_;
				GString* _tmp18_;
				const gchar* _tmp19_;
				gchar* _tmp20_;
				const gchar* _tmp21_;
				_tmp13_ = attribute;
				_tmp14_ = b_attribute_get_content (_tmp13_);
				_tmp15_ = _tmp14_;
				unicode = bird_font_font_to_unichar (_tmp15_);
				_g_free0 (_tmp15_);
				_tmp16_ = g_string_new ("");
				_g_string_free0 (b);
				b = _tmp16_;
				_tmp17_ = b;
				g_string_append_unichar (_tmp17_, unicode);
				_tmp18_ = b;
				_tmp19_ = _tmp18_->str;
				_tmp20_ = g_strdup (_tmp19_);
				_g_free0 (name);
				name = _tmp20_;
				_tmp21_ = name;
				if (g_strcmp0 (_tmp21_, "") == 0) {
					gchar* _tmp22_;
					_tmp22_ = g_strdup (".null");
					_g_free0 (name);
					name = _tmp22_;
				}
				unassigned = FALSE;
			}
			_tmp23_ = attribute;
			_tmp24_ = b_attribute_get_name (_tmp23_);
			_tmp25_ = _tmp24_;
			_tmp26_ = g_strcmp0 (_tmp25_, "name") == 0;
			_g_free0 (_tmp25_);
			if (_tmp26_) {
				BAttribute* _tmp27_;
				gchar* _tmp28_;
				gchar* _tmp29_;
				gchar* _tmp30_;
				unicode = (gunichar) '\0';
				_tmp27_ = attribute;
				_tmp28_ = b_attribute_get_content (_tmp27_);
				_tmp29_ = _tmp28_;
				_tmp30_ = bird_font_bird_font_file_decode (_tmp29_);
				_g_free0 (name);
				name = _tmp30_;
				_g_free0 (_tmp29_);
				unassigned = TRUE;
			}
			_tmp31_ = attribute;
			_tmp32_ = b_attribute_get_name (_tmp31_);
			_tmp33_ = _tmp32_;
			_tmp34_ = g_strcmp0 (_tmp33_, "master") == 0;
			_g_free0 (_tmp33_);
			if (_tmp34_) {
				BAttribute* _tmp35_;
				gchar* _tmp36_;
				_tmp35_ = attribute;
				_tmp36_ = b_attribute_get_content (_tmp35_);
				_g_free0 (master_id);
				master_id = _tmp36_;
			}
			_g_object_unref0 (attribute);
		}
		_g_object_unref0 (_attribute_it);
	}
	_tmp37_ = self->priv->font;
	_tmp38_ = name;
	_tmp39_ = bird_font_font_get_glyph_collection_by_name (_tmp37_, _tmp38_);
	_g_object_unref0 (current_gc);
	current_gc = _tmp39_;
	_tmp40_ = current_gc;
	new_glyph_collection = _tmp40_ == NULL;
	if (!new_glyph_collection) {
		BirdFontGlyphCollection* _tmp41_;
		BirdFontGlyphCollection* _tmp42_;
		_tmp41_ = current_gc;
		_tmp42_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp41_, BIRD_FONT_TYPE_GLYPH_COLLECTION, BirdFontGlyphCollection));
		_g_object_unref0 (gc);
		gc = _tmp42_;
	} else {
		const gchar* _tmp43_;
		BirdFontGlyphCollection* _tmp44_;
		_tmp43_ = name;
		_tmp44_ = bird_font_glyph_collection_new (unicode, _tmp43_);
		_g_object_unref0 (gc);
		gc = _tmp44_;
	}
	_tmp45_ = gc;
	_tmp46_ = master_id;
	if (bird_font_glyph_collection_has_master (_tmp45_, _tmp46_)) {
		BirdFontGlyphCollection* _tmp47_;
		const gchar* _tmp48_;
		BirdFontGlyphMaster* _tmp49_;
		_tmp47_ = gc;
		_tmp48_ = master_id;
		_tmp49_ = bird_font_glyph_collection_get_master (_tmp47_, _tmp48_);
		_g_object_unref0 (master);
		master = _tmp49_;
	} else {
		const gchar* _tmp50_;
		BirdFontGlyphMaster* _tmp51_;
		BirdFontGlyphCollection* _tmp52_;
		BirdFontGlyphMaster* _tmp53_;
		_tmp50_ = master_id;
		_tmp51_ = bird_font_glyph_master_new_for_id (_tmp50_);
		_g_object_unref0 (master);
		master = _tmp51_;
		_tmp52_ = gc;
		_tmp53_ = master;
		bird_font_glyph_collection_add_master (_tmp52_, _tmp53_);
	}
	{
		BTagIterator* _t_it = NULL;
		BTagIterator* _tmp54_;
		_tmp54_ = b_tag_iterator (tag);
		_t_it = _tmp54_;
		while (TRUE) {
			BTagIterator* _tmp55_;
			BTag* t = NULL;
			BTagIterator* _tmp56_;
			BTag* _tmp57_;
			BTag* _tmp58_;
			gchar* _tmp59_;
			gchar* _tmp60_;
			gboolean _tmp61_;
			_tmp55_ = _t_it;
			if (!b_tag_iterator_next (_tmp55_)) {
				break;
			}
			_tmp56_ = _t_it;
			_tmp57_ = b_tag_iterator_get (_tmp56_);
			t = _tmp57_;
			_tmp58_ = t;
			_tmp59_ = b_tag_get_name (_tmp58_);
			_tmp60_ = _tmp59_;
			_tmp61_ = g_strcmp0 (_tmp60_, "selected") == 0;
			_g_free0 (_tmp60_);
			if (_tmp61_) {
				BTag* _tmp62_;
				BirdFontGlyphMaster* _tmp63_;
				_tmp62_ = t;
				selected_id = bird_font_bird_font_file_parse_selected (self, _tmp62_);
				_tmp63_ = master;
				bird_font_glyph_master_set_selected_version (_tmp63_, selected_id);
			}
			_g_object_unref0 (t);
		}
		_g_object_unref0 (_t_it);
	}
	{
		BTagIterator* _t_it = NULL;
		BTagIterator* _tmp64_;
		_tmp64_ = b_tag_iterator (tag);
		_t_it = _tmp64_;
		while (TRUE) {
			BTagIterator* _tmp65_;
			BTag* t = NULL;
			BTagIterator* _tmp66_;
			BTag* _tmp67_;
			BTag* _tmp68_;
			gchar* _tmp69_;
			gchar* _tmp70_;
			gboolean _tmp71_;
			_tmp65_ = _t_it;
			if (!b_tag_iterator_next (_tmp65_)) {
				break;
			}
			_tmp66_ = _t_it;
			_tmp67_ = b_tag_iterator_get (_tmp66_);
			t = _tmp67_;
			_tmp68_ = t;
			_tmp69_ = b_tag_get_name (_tmp68_);
			_tmp70_ = _tmp69_;
			_tmp71_ = g_strcmp0 (_tmp70_, "glyph") == 0;
			_g_free0 (_tmp70_);
			if (_tmp71_) {
				BTag* _tmp72_;
				BirdFontGlyphCollection* _tmp73_;
				BirdFontGlyphMaster* _tmp74_;
				const gchar* _tmp75_;
				_tmp72_ = t;
				_tmp73_ = gc;
				_tmp74_ = master;
				_tmp75_ = name;
				bird_font_bird_font_file_parse_glyph (self, _tmp72_, _tmp73_, _tmp74_, _tmp75_, unicode, selected_id, unassigned);
			}
			_g_object_unref0 (t);
		}
		_g_object_unref0 (_t_it);
	}
	if (new_glyph_collection) {
		BirdFontFont* _tmp76_;
		BirdFontGlyphCollection* _tmp77_;
		_tmp76_ = self->priv->font;
		_tmp77_ = gc;
		bird_font_font_add_glyph_collection (_tmp76_, _tmp77_);
	}
	_g_object_unref0 (master);
	_g_free0 (master_id);
	_g_free0 (name);
	_g_string_free0 (b);
	_g_object_unref0 (current_gc);
	_g_object_unref0 (gc);
}

static gint
bird_font_bird_font_file_parse_selected (BirdFontBirdFontFile* self,
                                         BTag* tag)
{
	gint id = 0;
	gboolean has_selected_tag = FALSE;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (tag != NULL, 0);
	id = 1;
	has_selected_tag = FALSE;
	{
		BAttributesIterator* _attribute_it = NULL;
		BAttributes* _tmp0_;
		BAttributes* _tmp1_;
		BAttributesIterator* _tmp2_;
		BAttributesIterator* _tmp3_;
		_tmp0_ = b_tag_get_attributes (tag);
		_tmp1_ = _tmp0_;
		_tmp2_ = b_attributes_iterator (_tmp1_);
		_tmp3_ = _tmp2_;
		_g_object_unref0 (_tmp1_);
		_attribute_it = _tmp3_;
		while (TRUE) {
			BAttributesIterator* _tmp4_;
			BAttribute* attribute = NULL;
			BAttributesIterator* _tmp5_;
			BAttribute* _tmp6_;
			BAttribute* _tmp7_;
			gchar* _tmp8_;
			gchar* _tmp9_;
			gboolean _tmp10_;
			_tmp4_ = _attribute_it;
			if (!b_attributes_iterator_next (_tmp4_)) {
				break;
			}
			_tmp5_ = _attribute_it;
			_tmp6_ = b_attributes_iterator_get (_tmp5_);
			attribute = _tmp6_;
			_tmp7_ = attribute;
			_tmp8_ = b_attribute_get_name (_tmp7_);
			_tmp9_ = _tmp8_;
			_tmp10_ = g_strcmp0 (_tmp9_, "id") == 0;
			_g_free0 (_tmp9_);
			if (_tmp10_) {
				BAttribute* _tmp11_;
				gchar* _tmp12_;
				gchar* _tmp13_;
				_tmp11_ = attribute;
				_tmp12_ = b_attribute_get_content (_tmp11_);
				_tmp13_ = _tmp12_;
				id = atoi (_tmp13_);
				_g_free0 (_tmp13_);
				has_selected_tag = TRUE;
				_g_object_unref0 (attribute);
				break;
			}
			_g_object_unref0 (attribute);
		}
		_g_object_unref0 (_attribute_it);
	}
	if (G_UNLIKELY (!has_selected_tag)) {
		g_warning ("BirdFontFile.vala:1414: No selected tag.");
	}
	result = id;
	return result;
}

void
bird_font_bird_font_file_parse_glyph (BirdFontBirdFontFile* self,
                                      BTag* tag,
                                      BirdFontGlyphCollection* gc,
                                      BirdFontGlyphMaster* master,
                                      const gchar* name,
                                      gunichar unicode,
                                      gint selected_id,
                                      gboolean unassigned)
{
	BirdFontGlyph* glyph = NULL;
	BirdFontGlyph* _tmp0_;
	BirdFontPath* path = NULL;
	gboolean selected = FALSE;
	gboolean has_id = FALSE;
	gint id = 0;
	BirdFontLayer* layer = NULL;
	gint _tmp83_ = 0;
	BirdFontGlyph* _tmp84_;
	gboolean _tmp85_ = FALSE;
	BirdFontGlyph* _tmp86_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tag != NULL);
	g_return_if_fail (gc != NULL);
	g_return_if_fail (master != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = bird_font_glyph_new (name, unicode);
	glyph = _tmp0_;
	selected = FALSE;
	has_id = FALSE;
	id = 1;
	{
		BAttributesIterator* _attr_it = NULL;
		BAttributes* _tmp1_;
		BAttributes* _tmp2_;
		BAttributesIterator* _tmp3_;
		BAttributesIterator* _tmp4_;
		_tmp1_ = b_tag_get_attributes (tag);
		_tmp2_ = _tmp1_;
		_tmp3_ = b_attributes_iterator (_tmp2_);
		_tmp4_ = _tmp3_;
		_g_object_unref0 (_tmp2_);
		_attr_it = _tmp4_;
		while (TRUE) {
			BAttributesIterator* _tmp5_;
			BAttribute* attr = NULL;
			BAttributesIterator* _tmp6_;
			BAttribute* _tmp7_;
			BAttribute* _tmp8_;
			gchar* _tmp9_;
			gchar* _tmp10_;
			gboolean _tmp11_;
			BAttribute* _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
			gboolean _tmp19_;
			BAttribute* _tmp24_;
			gchar* _tmp25_;
			gchar* _tmp26_;
			gboolean _tmp27_;
			BAttribute* _tmp31_;
			gchar* _tmp32_;
			gchar* _tmp33_;
			gboolean _tmp34_;
			_tmp5_ = _attr_it;
			if (!b_attributes_iterator_next (_tmp5_)) {
				break;
			}
			_tmp6_ = _attr_it;
			_tmp7_ = b_attributes_iterator_get (_tmp6_);
			attr = _tmp7_;
			_tmp8_ = attr;
			_tmp9_ = b_attribute_get_name (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = g_strcmp0 (_tmp10_, "left") == 0;
			_g_free0 (_tmp10_);
			if (_tmp11_) {
				BirdFontGlyph* _tmp12_;
				BAttribute* _tmp13_;
				gchar* _tmp14_;
				gchar* _tmp15_;
				_tmp12_ = glyph;
				_tmp13_ = attr;
				_tmp14_ = b_attribute_get_content (_tmp13_);
				_tmp15_ = _tmp14_;
				bird_font_glyph_set_left_limit (_tmp12_, double_parse (_tmp15_));
				_g_free0 (_tmp15_);
			}
			_tmp16_ = attr;
			_tmp17_ = b_attribute_get_name (_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = g_strcmp0 (_tmp18_, "right") == 0;
			_g_free0 (_tmp18_);
			if (_tmp19_) {
				BirdFontGlyph* _tmp20_;
				BAttribute* _tmp21_;
				gchar* _tmp22_;
				gchar* _tmp23_;
				_tmp20_ = glyph;
				_tmp21_ = attr;
				_tmp22_ = b_attribute_get_content (_tmp21_);
				_tmp23_ = _tmp22_;
				bird_font_glyph_set_right_limit (_tmp20_, double_parse (_tmp23_));
				_g_free0 (_tmp23_);
			}
			_tmp24_ = attr;
			_tmp25_ = b_attribute_get_name (_tmp24_);
			_tmp26_ = _tmp25_;
			_tmp27_ = g_strcmp0 (_tmp26_, "id") == 0;
			_g_free0 (_tmp26_);
			if (_tmp27_) {
				BAttribute* _tmp28_;
				gchar* _tmp29_;
				gchar* _tmp30_;
				_tmp28_ = attr;
				_tmp29_ = b_attribute_get_content (_tmp28_);
				_tmp30_ = _tmp29_;
				id = atoi (_tmp30_);
				_g_free0 (_tmp30_);
				has_id = TRUE;
			}
			_tmp31_ = attr;
			_tmp32_ = b_attribute_get_name (_tmp31_);
			_tmp33_ = _tmp32_;
			_tmp34_ = g_strcmp0 (_tmp33_, "selected") == 0;
			_g_free0 (_tmp33_);
			if (_tmp34_) {
				BAttribute* _tmp35_;
				gchar* _tmp36_;
				gchar* _tmp37_;
				_tmp35_ = attr;
				_tmp36_ = b_attribute_get_content (_tmp35_);
				_tmp37_ = _tmp36_;
				selected = bool_parse (_tmp37_);
				_g_free0 (_tmp37_);
			}
			_g_object_unref0 (attr);
		}
		_g_object_unref0 (_attr_it);
	}
	{
		BTagIterator* _t_it = NULL;
		BTagIterator* _tmp38_;
		_tmp38_ = b_tag_iterator (tag);
		_t_it = _tmp38_;
		while (TRUE) {
			BTagIterator* _tmp39_;
			BTag* t = NULL;
			BTagIterator* _tmp40_;
			BTag* _tmp41_;
			BTag* _tmp42_;
			gchar* _tmp43_;
			gchar* _tmp44_;
			gboolean _tmp45_;
			_tmp39_ = _t_it;
			if (!b_tag_iterator_next (_tmp39_)) {
				break;
			}
			_tmp40_ = _t_it;
			_tmp41_ = b_tag_iterator_get (_tmp40_);
			t = _tmp41_;
			_tmp42_ = t;
			_tmp43_ = b_tag_get_name (_tmp42_);
			_tmp44_ = _tmp43_;
			_tmp45_ = g_strcmp0 (_tmp44_, "layer") == 0;
			_g_free0 (_tmp44_);
			if (_tmp45_) {
				BTag* _tmp46_;
				BirdFontLayer* _tmp47_;
				BirdFontGlyph* _tmp48_;
				BirdFontLayer* _tmp49_;
				BirdFontLayer* _tmp50_;
				_tmp46_ = t;
				_tmp47_ = bird_font_bird_font_file_parse_layer (self, _tmp46_);
				_g_object_unref0 (layer);
				layer = _tmp47_;
				_tmp48_ = glyph;
				_tmp49_ = _tmp48_->layers;
				_tmp50_ = layer;
				bird_font_layer_add_layer (_tmp49_, _tmp50_);
			}
			_g_object_unref0 (t);
		}
		_g_object_unref0 (_t_it);
	}
	{
		BTagIterator* _t_it = NULL;
		BTagIterator* _tmp51_;
		_tmp51_ = b_tag_iterator (tag);
		_t_it = _tmp51_;
		while (TRUE) {
			BTagIterator* _tmp52_;
			BTag* t = NULL;
			BTagIterator* _tmp53_;
			BTag* _tmp54_;
			BTag* _tmp55_;
			gchar* _tmp56_;
			gchar* _tmp57_;
			gboolean _tmp58_;
			_tmp52_ = _t_it;
			if (!b_tag_iterator_next (_tmp52_)) {
				break;
			}
			_tmp53_ = _t_it;
			_tmp54_ = b_tag_iterator_get (_tmp53_);
			t = _tmp54_;
			_tmp55_ = t;
			_tmp56_ = b_tag_get_name (_tmp55_);
			_tmp57_ = _tmp56_;
			_tmp58_ = g_strcmp0 (_tmp57_, "path") == 0;
			_g_free0 (_tmp57_);
			if (_tmp58_) {
				BTag* _tmp59_;
				BirdFontPath* _tmp60_;
				BirdFontGlyph* _tmp61_;
				BirdFontPath* _tmp62_;
				_tmp59_ = t;
				_tmp60_ = bird_font_bird_font_file_parse_path (self, _tmp59_);
				_g_object_unref0 (path);
				path = _tmp60_;
				_tmp61_ = glyph;
				_tmp62_ = path;
				bird_font_glyph_add_path (_tmp61_, _tmp62_);
			}
			_g_object_unref0 (t);
		}
		_g_object_unref0 (_t_it);
	}
	{
		BTagIterator* _t_it = NULL;
		BTagIterator* _tmp63_;
		_tmp63_ = b_tag_iterator (tag);
		_t_it = _tmp63_;
		while (TRUE) {
			BTagIterator* _tmp64_;
			BTag* t = NULL;
			BTagIterator* _tmp65_;
			BTag* _tmp66_;
			BTag* _tmp67_;
			gchar* _tmp68_;
			gchar* _tmp69_;
			gboolean _tmp70_;
			_tmp64_ = _t_it;
			if (!b_tag_iterator_next (_tmp64_)) {
				break;
			}
			_tmp65_ = _t_it;
			_tmp66_ = b_tag_iterator_get (_tmp65_);
			t = _tmp66_;
			_tmp67_ = t;
			_tmp68_ = b_tag_get_name (_tmp67_);
			_tmp69_ = _tmp68_;
			_tmp70_ = g_strcmp0 (_tmp69_, "background") == 0;
			_g_free0 (_tmp69_);
			if (_tmp70_) {
				BirdFontGlyph* _tmp71_;
				BTag* _tmp72_;
				_tmp71_ = glyph;
				_tmp72_ = t;
				bird_font_bird_font_file_parse_background_scale (self, _tmp71_, _tmp72_);
			}
			_g_object_unref0 (t);
		}
		_g_object_unref0 (_t_it);
	}
	{
		GeeArrayList* _p_list = NULL;
		BirdFontGlyph* _tmp73_;
		GeeArrayList* _tmp74_;
		gint _p_size = 0;
		GeeArrayList* _tmp75_;
		gint _tmp76_;
		gint _tmp77_;
		gint _p_index = 0;
		_tmp73_ = glyph;
		_tmp74_ = bird_font_glyph_get_all_paths (_tmp73_);
		_p_list = _tmp74_;
		_tmp75_ = _p_list;
		_tmp76_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp75_);
		_tmp77_ = _tmp76_;
		_p_size = _tmp77_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp78_;
			gint _tmp79_;
			BirdFontPath* p = NULL;
			GeeArrayList* _tmp80_;
			gpointer _tmp81_;
			BirdFontPath* _tmp82_;
			_p_index = _p_index + 1;
			_tmp78_ = _p_index;
			_tmp79_ = _p_size;
			if (!(_tmp78_ < _tmp79_)) {
				break;
			}
			_tmp80_ = _p_list;
			_tmp81_ = gee_abstract_list_get ((GeeAbstractList*) _tmp80_, _p_index);
			p = (BirdFontPath*) _tmp81_;
			_tmp82_ = p;
			bird_font_path_reset_stroke (_tmp82_);
			_g_object_unref0 (p);
		}
		_g_object_unref0 (_p_list);
	}
	if (has_id) {
		_tmp83_ = id;
	} else {
		_tmp83_ = ((gint) bird_font_glyph_collection_length (gc)) + 1;
	}
	_tmp84_ = glyph;
	_tmp84_->version_id = _tmp83_;
	bird_font_glyph_collection_set_unassigned (gc, unassigned);
	if (selected) {
		_tmp85_ = TRUE;
	} else {
		_tmp85_ = selected_id == id;
	}
	_tmp86_ = glyph;
	bird_font_glyph_master_insert_glyph (master, _tmp86_, _tmp85_);
	_g_object_unref0 (layer);
	_g_object_unref0 (path);
	_g_object_unref0 (glyph);
}

static BirdFontLayer*
bird_font_bird_font_file_parse_layer (BirdFontBirdFontFile* self,
                                      BTag* tag)
{
	BirdFontLayer* layer = NULL;
	BirdFontLayer* _tmp0_;
	BirdFontPath* path = NULL;
	BirdFontLayer* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (tag != NULL, NULL);
	_tmp0_ = bird_font_layer_new ();
	layer = _tmp0_;
	{
		BAttributesIterator* _a_it = NULL;
		BAttributes* _tmp1_;
		BAttributes* _tmp2_;
		BAttributesIterator* _tmp3_;
		BAttributesIterator* _tmp4_;
		_tmp1_ = b_tag_get_attributes (tag);
		_tmp2_ = _tmp1_;
		_tmp3_ = b_attributes_iterator (_tmp2_);
		_tmp4_ = _tmp3_;
		_g_object_unref0 (_tmp2_);
		_a_it = _tmp4_;
		while (TRUE) {
			BAttributesIterator* _tmp5_;
			BAttribute* a = NULL;
			BAttributesIterator* _tmp6_;
			BAttribute* _tmp7_;
			BAttribute* _tmp8_;
			gchar* _tmp9_;
			gchar* _tmp10_;
			gboolean _tmp11_;
			BAttribute* _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
			gboolean _tmp19_;
			_tmp5_ = _a_it;
			if (!b_attributes_iterator_next (_tmp5_)) {
				break;
			}
			_tmp6_ = _a_it;
			_tmp7_ = b_attributes_iterator_get (_tmp6_);
			a = _tmp7_;
			_tmp8_ = a;
			_tmp9_ = b_attribute_get_name (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = g_strcmp0 (_tmp10_, "visible") == 0;
			_g_free0 (_tmp10_);
			if (_tmp11_) {
				BirdFontLayer* _tmp12_;
				BAttribute* _tmp13_;
				gchar* _tmp14_;
				gchar* _tmp15_;
				_tmp12_ = layer;
				_tmp13_ = a;
				_tmp14_ = b_attribute_get_content (_tmp13_);
				_tmp15_ = _tmp14_;
				_tmp12_->visible = bool_parse (_tmp15_);
				_g_free0 (_tmp15_);
			}
			_tmp16_ = a;
			_tmp17_ = b_attribute_get_name (_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = g_strcmp0 (_tmp18_, "name") == 0;
			_g_free0 (_tmp18_);
			if (_tmp19_) {
				BirdFontLayer* _tmp20_;
				BAttribute* _tmp21_;
				gchar* _tmp22_;
				_tmp20_ = layer;
				_tmp21_ = a;
				_tmp22_ = b_attribute_get_content (_tmp21_);
				_g_free0 (_tmp20_->name);
				_tmp20_->name = _tmp22_;
			}
			_g_object_unref0 (a);
		}
		_g_object_unref0 (_a_it);
	}
	{
		BTagIterator* _t_it = NULL;
		BTagIterator* _tmp23_;
		_tmp23_ = b_tag_iterator (tag);
		_t_it = _tmp23_;
		while (TRUE) {
			BTagIterator* _tmp24_;
			BTag* t = NULL;
			BTagIterator* _tmp25_;
			BTag* _tmp26_;
			BTag* _tmp27_;
			gchar* _tmp28_;
			gchar* _tmp29_;
			gboolean _tmp30_;
			BTag* _tmp35_;
			gchar* _tmp36_;
			gchar* _tmp37_;
			gboolean _tmp38_;
			_tmp24_ = _t_it;
			if (!b_tag_iterator_next (_tmp24_)) {
				break;
			}
			_tmp25_ = _t_it;
			_tmp26_ = b_tag_iterator_get (_tmp25_);
			t = _tmp26_;
			_tmp27_ = t;
			_tmp28_ = b_tag_get_name (_tmp27_);
			_tmp29_ = _tmp28_;
			_tmp30_ = g_strcmp0 (_tmp29_, "path") == 0;
			_g_free0 (_tmp29_);
			if (_tmp30_) {
				BTag* _tmp31_;
				BirdFontPath* _tmp32_;
				BirdFontLayer* _tmp33_;
				BirdFontPath* _tmp34_;
				_tmp31_ = t;
				_tmp32_ = bird_font_bird_font_file_parse_path (self, _tmp31_);
				_g_object_unref0 (path);
				path = _tmp32_;
				_tmp33_ = layer;
				_tmp34_ = path;
				bird_font_layer_add_path (_tmp33_, _tmp34_);
			}
			_tmp35_ = t;
			_tmp36_ = b_tag_get_name (_tmp35_);
			_tmp37_ = _tmp36_;
			_tmp38_ = g_strcmp0 (_tmp37_, "embedded") == 0;
			_g_free0 (_tmp37_);
			if (_tmp38_) {
				BirdFontFont* _tmp39_;
				_tmp39_ = self->priv->font;
				_tmp39_->has_svg = TRUE;
			}
			_g_object_unref0 (t);
		}
		_g_object_unref0 (_t_it);
	}
	result = layer;
	_g_object_unref0 (path);
	return result;
}

static BirdFontPath*
bird_font_bird_font_file_parse_path (BirdFontBirdFontFile* self,
                                     BTag* tag)
{
	BirdFontPath* path = NULL;
	BirdFontPath* _tmp0_;
	BirdFontPath* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (tag != NULL, NULL);
	_tmp0_ = bird_font_path_new ();
	path = _tmp0_;
	{
		BAttributesIterator* _attr_it = NULL;
		BAttributes* _tmp1_;
		BAttributes* _tmp2_;
		BAttributesIterator* _tmp3_;
		BAttributesIterator* _tmp4_;
		_tmp1_ = b_tag_get_attributes (tag);
		_tmp2_ = _tmp1_;
		_tmp3_ = b_attributes_iterator (_tmp2_);
		_tmp4_ = _tmp3_;
		_g_object_unref0 (_tmp2_);
		_attr_it = _tmp4_;
		while (TRUE) {
			BAttributesIterator* _tmp5_;
			BAttribute* attr = NULL;
			BAttributesIterator* _tmp6_;
			BAttribute* _tmp7_;
			BAttribute* _tmp8_;
			gchar* _tmp9_;
			gchar* _tmp10_;
			gboolean _tmp11_;
			_tmp5_ = _attr_it;
			if (!b_attributes_iterator_next (_tmp5_)) {
				break;
			}
			_tmp6_ = _attr_it;
			_tmp7_ = b_attributes_iterator_get (_tmp6_);
			attr = _tmp7_;
			_tmp8_ = attr;
			_tmp9_ = b_attribute_get_name (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = g_strcmp0 (_tmp10_, "data") == 0;
			_g_free0 (_tmp10_);
			if (_tmp11_) {
				BirdFontPath* _tmp12_;
				BAttribute* _tmp13_;
				gchar* _tmp14_;
				BirdFontPath* _tmp15_;
				_tmp12_ = path;
				_tmp13_ = attr;
				_tmp14_ = b_attribute_get_content (_tmp13_);
				_g_free0 (_tmp12_->point_data);
				_tmp12_->point_data = _tmp14_;
				_tmp15_ = path;
				_g_object_unref0 (_tmp15_->control_points);
				_tmp15_->control_points = NULL;
			}
			_g_object_unref0 (attr);
		}
		_g_object_unref0 (_attr_it);
	}
	{
		BAttributesIterator* _attr_it = NULL;
		BAttributes* _tmp16_;
		BAttributes* _tmp17_;
		BAttributesIterator* _tmp18_;
		BAttributesIterator* _tmp19_;
		_tmp16_ = b_tag_get_attributes (tag);
		_tmp17_ = _tmp16_;
		_tmp18_ = b_attributes_iterator (_tmp17_);
		_tmp19_ = _tmp18_;
		_g_object_unref0 (_tmp17_);
		_attr_it = _tmp19_;
		while (TRUE) {
			BAttributesIterator* _tmp20_;
			BAttribute* attr = NULL;
			BAttributesIterator* _tmp21_;
			BAttribute* _tmp22_;
			BAttribute* _tmp23_;
			gchar* _tmp24_;
			gchar* _tmp25_;
			gboolean _tmp26_;
			BAttribute* _tmp31_;
			gchar* _tmp32_;
			gchar* _tmp33_;
			gboolean _tmp34_;
			BAttribute* _tmp39_;
			gchar* _tmp40_;
			gchar* _tmp41_;
			gboolean _tmp42_;
			_tmp20_ = _attr_it;
			if (!b_attributes_iterator_next (_tmp20_)) {
				break;
			}
			_tmp21_ = _attr_it;
			_tmp22_ = b_attributes_iterator_get (_tmp21_);
			attr = _tmp22_;
			_tmp23_ = attr;
			_tmp24_ = b_attribute_get_name (_tmp23_);
			_tmp25_ = _tmp24_;
			_tmp26_ = g_strcmp0 (_tmp25_, "stroke") == 0;
			_g_free0 (_tmp25_);
			if (_tmp26_) {
				BirdFontPath* _tmp27_;
				BAttribute* _tmp28_;
				gchar* _tmp29_;
				gchar* _tmp30_;
				_tmp27_ = path;
				_tmp28_ = attr;
				_tmp29_ = b_attribute_get_content (_tmp28_);
				_tmp30_ = _tmp29_;
				bird_font_path_set_stroke (_tmp27_, double_parse (_tmp30_));
				_g_free0 (_tmp30_);
			}
			_tmp31_ = attr;
			_tmp32_ = b_attribute_get_name (_tmp31_);
			_tmp33_ = _tmp32_;
			_tmp34_ = g_strcmp0 (_tmp33_, "skew") == 0;
			_g_free0 (_tmp33_);
			if (_tmp34_) {
				BirdFontPath* _tmp35_;
				BAttribute* _tmp36_;
				gchar* _tmp37_;
				gchar* _tmp38_;
				_tmp35_ = path;
				_tmp36_ = attr;
				_tmp37_ = b_attribute_get_content (_tmp36_);
				_tmp38_ = _tmp37_;
				_tmp35_->skew = double_parse (_tmp38_);
				_g_free0 (_tmp38_);
			}
			_tmp39_ = attr;
			_tmp40_ = b_attribute_get_name (_tmp39_);
			_tmp41_ = _tmp40_;
			_tmp42_ = g_strcmp0 (_tmp41_, "cap") == 0;
			_g_free0 (_tmp41_);
			if (_tmp42_) {
				BAttribute* _tmp43_;
				gchar* _tmp44_;
				gchar* _tmp45_;
				gboolean _tmp46_;
				_tmp43_ = attr;
				_tmp44_ = b_attribute_get_content (_tmp43_);
				_tmp45_ = _tmp44_;
				_tmp46_ = g_strcmp0 (_tmp45_, "round") == 0;
				_g_free0 (_tmp45_);
				if (_tmp46_) {
					BirdFontPath* _tmp47_;
					_tmp47_ = path;
					_tmp47_->line_cap = BIRD_FONT_LINE_CAP_ROUND;
				} else {
					BAttribute* _tmp48_;
					gchar* _tmp49_;
					gchar* _tmp50_;
					gboolean _tmp51_;
					_tmp48_ = attr;
					_tmp49_ = b_attribute_get_content (_tmp48_);
					_tmp50_ = _tmp49_;
					_tmp51_ = g_strcmp0 (_tmp50_, "square") == 0;
					_g_free0 (_tmp50_);
					if (_tmp51_) {
						BirdFontPath* _tmp52_;
						_tmp52_ = path;
						_tmp52_->line_cap = BIRD_FONT_LINE_CAP_SQUARE;
					}
				}
			}
			_g_object_unref0 (attr);
		}
		_g_object_unref0 (_attr_it);
	}
	result = path;
	return result;
}

static void
bird_font_bird_font_file_line (BirdFontPath* path,
                               const gchar* px,
                               const gchar* py)
{
	BirdFontEditPoint* ep = NULL;
	BirdFontEditPoint* _tmp0_;
	BirdFontEditPoint* _tmp1_;
	BirdFontEditPoint* _tmp2_;
	BirdFontEditPointHandle* _tmp3_;
	BirdFontEditPointHandle* _tmp4_;
	g_return_if_fail (path != NULL);
	g_return_if_fail (px != NULL);
	g_return_if_fail (py != NULL);
	_tmp0_ = bird_font_path_add (path, bird_font_bird_font_file_parse_double (px), bird_font_bird_font_file_parse_double (py));
	_tmp1_ = _tmp0_;
	_g_object_unref0 (_tmp1_);
	_tmp2_ = bird_font_path_get_last_point (path);
	_g_object_unref0 (ep);
	ep = _tmp2_;
	_tmp3_ = bird_font_edit_point_get_right_handle (ep);
	_tmp3_->type = BIRD_FONT_POINT_TYPE_LINE_DOUBLE_CURVE;
	_tmp4_ = bird_font_edit_point_get_left_handle (ep);
	_tmp4_->type = BIRD_FONT_POINT_TYPE_LINE_DOUBLE_CURVE;
	ep->type = BIRD_FONT_POINT_TYPE_LINE_DOUBLE_CURVE;
	bird_font_path_recalculate_linear_handles_for_point (path, ep);
	_g_object_unref0 (ep);
}

static void
bird_font_bird_font_file_cubic_line (BirdFontPath* path,
                                     const gchar* px,
                                     const gchar* py)
{
	BirdFontEditPoint* ep = NULL;
	BirdFontEditPoint* _tmp0_;
	BirdFontEditPoint* _tmp1_;
	GeeArrayList* _tmp2_;
	GeeArrayList* _tmp3_;
	GeeArrayList* _tmp4_;
	GeeArrayList* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	gpointer _tmp8_;
	BirdFontEditPointHandle* _tmp9_;
	g_return_if_fail (path != NULL);
	g_return_if_fail (px != NULL);
	g_return_if_fail (py != NULL);
	_tmp0_ = bird_font_path_add (path, bird_font_bird_font_file_parse_double (px), bird_font_bird_font_file_parse_double (py));
	_tmp1_ = _tmp0_;
	_g_object_unref0 (_tmp1_);
	_tmp2_ = bird_font_path_get_points (path);
	_tmp3_ = _tmp2_;
	_tmp4_ = bird_font_path_get_points (path);
	_tmp5_ = _tmp4_;
	_tmp6_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp3_, _tmp7_ - 1);
	_g_object_unref0 (ep);
	ep = (BirdFontEditPoint*) _tmp8_;
	_tmp9_ = bird_font_edit_point_get_right_handle (ep);
	_tmp9_->type = BIRD_FONT_POINT_TYPE_LINE_CUBIC;
	ep->type = BIRD_FONT_POINT_TYPE_LINE_CUBIC;
	bird_font_path_recalculate_linear_handles_for_point (path, ep);
	_g_object_unref0 (ep);
}

static void
bird_font_bird_font_file_quadratic (BirdFontPath* path,
                                    const gchar* px0,
                                    const gchar* py0,
                                    const gchar* px1,
                                    const gchar* py1)
{
	BirdFontEditPoint* ep1 = NULL;
	BirdFontEditPoint* ep2 = NULL;
	gdouble x0 = 0.0;
	gdouble y0 = 0.0;
	gdouble x1 = 0.0;
	gdouble y1 = 0.0;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	GeeArrayList* _tmp4_;
	GeeArrayList* _tmp5_;
	GeeArrayList* _tmp6_;
	GeeArrayList* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	gpointer _tmp10_;
	BirdFontEditPoint* _tmp11_;
	BirdFontEditPoint* _tmp12_;
	BirdFontEditPointHandle* _tmp13_;
	BirdFontEditPoint* _tmp14_;
	BirdFontEditPointHandle* _tmp15_;
	BirdFontEditPoint* _tmp16_;
	BirdFontEditPoint* _tmp17_;
	BirdFontEditPoint* _tmp18_;
	GeeArrayList* _tmp19_;
	GeeArrayList* _tmp20_;
	GeeArrayList* _tmp21_;
	GeeArrayList* _tmp22_;
	gint _tmp23_;
	gint _tmp24_;
	gpointer _tmp25_;
	BirdFontEditPoint* _tmp26_;
	BirdFontEditPoint* _tmp27_;
	BirdFontEditPointHandle* _tmp28_;
	BirdFontEditPoint* _tmp29_;
	BirdFontEditPointHandle* _tmp30_;
	BirdFontEditPoint* _tmp31_;
	g_return_if_fail (path != NULL);
	g_return_if_fail (px0 != NULL);
	g_return_if_fail (py0 != NULL);
	g_return_if_fail (px1 != NULL);
	g_return_if_fail (py1 != NULL);
	x0 = bird_font_bird_font_file_parse_double (px0);
	y0 = bird_font_bird_font_file_parse_double (py0);
	x1 = bird_font_bird_font_file_parse_double (px1);
	y1 = bird_font_bird_font_file_parse_double (py1);
	_tmp0_ = bird_font_path_get_points (path);
	_tmp1_ = _tmp0_;
	_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == 0) {
		g_warning ("BirdFontFile.vala:1570: No point.");
		_g_object_unref0 (ep2);
		_g_object_unref0 (ep1);
		return;
	}
	_tmp4_ = bird_font_path_get_points (path);
	_tmp5_ = _tmp4_;
	_tmp6_ = bird_font_path_get_points (path);
	_tmp7_ = _tmp6_;
	_tmp8_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp5_, _tmp9_ - 1);
	_g_object_unref0 (ep1);
	ep1 = (BirdFontEditPoint*) _tmp10_;
	_tmp11_ = ep1;
	bird_font_path_recalculate_linear_handles_for_point (path, _tmp11_);
	_tmp12_ = ep1;
	_tmp13_ = bird_font_edit_point_get_right_handle (_tmp12_);
	_tmp13_->type = BIRD_FONT_POINT_TYPE_QUADRATIC;
	_tmp14_ = ep1;
	_tmp15_ = bird_font_edit_point_get_right_handle (_tmp14_);
	bird_font_edit_point_handle_move_to_coordinate (_tmp15_, x0, y0);
	_tmp16_ = ep1;
	_tmp16_->type = BIRD_FONT_POINT_TYPE_QUADRATIC;
	_tmp17_ = bird_font_path_add (path, x1, y1);
	_tmp18_ = _tmp17_;
	_g_object_unref0 (_tmp18_);
	_tmp19_ = bird_font_path_get_points (path);
	_tmp20_ = _tmp19_;
	_tmp21_ = bird_font_path_get_points (path);
	_tmp22_ = _tmp21_;
	_tmp23_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp22_);
	_tmp24_ = _tmp23_;
	_tmp25_ = gee_abstract_list_get ((GeeAbstractList*) _tmp20_, _tmp24_ - 1);
	_g_object_unref0 (ep2);
	ep2 = (BirdFontEditPoint*) _tmp25_;
	_tmp26_ = ep2;
	bird_font_path_recalculate_linear_handles_for_point (path, _tmp26_);
	_tmp27_ = ep2;
	_tmp28_ = bird_font_edit_point_get_left_handle (_tmp27_);
	_tmp28_->type = BIRD_FONT_POINT_TYPE_QUADRATIC;
	_tmp29_ = ep2;
	_tmp30_ = bird_font_edit_point_get_left_handle (_tmp29_);
	bird_font_edit_point_handle_move_to_coordinate (_tmp30_, x0, y0);
	_tmp31_ = ep2;
	_tmp31_->type = BIRD_FONT_POINT_TYPE_QUADRATIC;
	_g_object_unref0 (ep2);
	_g_object_unref0 (ep1);
}

static void
bird_font_bird_font_file_cubic (BirdFontPath* path,
                                const gchar* px0,
                                const gchar* py0,
                                const gchar* px1,
                                const gchar* py1,
                                const gchar* px2,
                                const gchar* py2)
{
	BirdFontEditPoint* ep1 = NULL;
	BirdFontEditPoint* ep2 = NULL;
	gdouble x0 = 0.0;
	gdouble y0 = 0.0;
	gdouble x1 = 0.0;
	gdouble y1 = 0.0;
	gdouble x2 = 0.0;
	gdouble y2 = 0.0;
	gdouble lx = 0.0;
	gdouble ly = 0.0;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	GeeArrayList* _tmp4_;
	GeeArrayList* _tmp5_;
	GeeArrayList* _tmp6_;
	GeeArrayList* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	gpointer _tmp10_;
	BirdFontEditPoint* _tmp11_;
	BirdFontEditPointHandle* _tmp12_;
	BirdFontEditPoint* _tmp13_;
	BirdFontEditPoint* _tmp14_;
	BirdFontEditPoint* _tmp15_;
	BirdFontEditPoint* _tmp16_;
	BirdFontEditPoint* _tmp17_;
	BirdFontEditPointHandle* _tmp18_;
	BirdFontEditPoint* _tmp19_;
	GeeArrayList* _tmp20_;
	GeeArrayList* _tmp21_;
	GeeArrayList* _tmp22_;
	GeeArrayList* _tmp23_;
	gint _tmp24_;
	gint _tmp25_;
	gpointer _tmp26_;
	BirdFontEditPoint* _tmp27_;
	BirdFontEditPoint* _tmp28_;
	BirdFontEditPointHandle* _tmp29_;
	BirdFontEditPoint* _tmp30_;
	BirdFontEditPointHandle* _tmp31_;
	BirdFontEditPoint* _tmp32_;
	BirdFontEditPoint* _tmp33_;
	BirdFontEditPoint* _tmp34_;
	GeeArrayList* _tmp35_;
	GeeArrayList* _tmp36_;
	GeeArrayList* _tmp37_;
	GeeArrayList* _tmp38_;
	gint _tmp39_;
	gint _tmp40_;
	gpointer _tmp41_;
	BirdFontEditPoint* _tmp42_;
	BirdFontEditPoint* _tmp43_;
	BirdFontEditPointHandle* _tmp44_;
	BirdFontEditPoint* _tmp45_;
	BirdFontEditPointHandle* _tmp46_;
	BirdFontEditPoint* _tmp47_;
	BirdFontEditPoint* _tmp48_;
	g_return_if_fail (path != NULL);
	g_return_if_fail (px0 != NULL);
	g_return_if_fail (py0 != NULL);
	g_return_if_fail (px1 != NULL);
	g_return_if_fail (py1 != NULL);
	g_return_if_fail (px2 != NULL);
	g_return_if_fail (py2 != NULL);
	x0 = bird_font_bird_font_file_parse_double (px0);
	y0 = bird_font_bird_font_file_parse_double (py0);
	x1 = bird_font_bird_font_file_parse_double (px1);
	y1 = bird_font_bird_font_file_parse_double (py1);
	x2 = bird_font_bird_font_file_parse_double (px2);
	y2 = bird_font_bird_font_file_parse_double (py2);
	_tmp0_ = bird_font_path_get_points (path);
	_tmp1_ = _tmp0_;
	_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == 0) {
		g_warning ("BirdFontFile.vala:1602: No point");
		_g_object_unref0 (ep2);
		_g_object_unref0 (ep1);
		return;
	}
	_tmp4_ = bird_font_path_get_points (path);
	_tmp5_ = _tmp4_;
	_tmp6_ = bird_font_path_get_points (path);
	_tmp7_ = _tmp6_;
	_tmp8_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp5_, _tmp9_ - 1);
	_g_object_unref0 (ep1);
	ep1 = (BirdFontEditPoint*) _tmp10_;
	_tmp11_ = ep1;
	_tmp12_ = bird_font_edit_point_get_right_handle (_tmp11_);
	_tmp12_->type = BIRD_FONT_POINT_TYPE_LINE_CUBIC;
	_tmp13_ = ep1;
	_tmp14_ = ep1;
	lx = _tmp13_->x + ((x2 - _tmp14_->x) / 3);
	_tmp15_ = ep1;
	_tmp16_ = ep1;
	ly = _tmp15_->y + ((y2 - _tmp16_->y) / 3);
	_tmp17_ = ep1;
	_tmp18_ = bird_font_edit_point_get_right_handle (_tmp17_);
	bird_font_edit_point_handle_move_to_coordinate (_tmp18_, lx, ly);
	_tmp19_ = ep1;
	bird_font_path_recalculate_linear_handles_for_point (path, _tmp19_);
	_tmp20_ = bird_font_path_get_points (path);
	_tmp21_ = _tmp20_;
	_tmp22_ = bird_font_path_get_points (path);
	_tmp23_ = _tmp22_;
	_tmp24_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp23_);
	_tmp25_ = _tmp24_;
	_tmp26_ = gee_abstract_list_get ((GeeAbstractList*) _tmp21_, _tmp25_ - 1);
	_g_object_unref0 (ep1);
	ep1 = (BirdFontEditPoint*) _tmp26_;
	_tmp27_ = ep1;
	bird_font_path_recalculate_linear_handles_for_point (path, _tmp27_);
	_tmp28_ = ep1;
	_tmp29_ = bird_font_edit_point_get_right_handle (_tmp28_);
	_tmp29_->type = BIRD_FONT_POINT_TYPE_CUBIC;
	_tmp30_ = ep1;
	_tmp31_ = bird_font_edit_point_get_right_handle (_tmp30_);
	bird_font_edit_point_handle_move_to_coordinate (_tmp31_, x0, y0);
	_tmp32_ = ep1;
	_tmp32_->type = BIRD_FONT_POINT_TYPE_CUBIC;
	_tmp33_ = bird_font_path_add (path, x2, y2);
	_tmp34_ = _tmp33_;
	_g_object_unref0 (_tmp34_);
	_tmp35_ = bird_font_path_get_points (path);
	_tmp36_ = _tmp35_;
	_tmp37_ = bird_font_path_get_points (path);
	_tmp38_ = _tmp37_;
	_tmp39_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp38_);
	_tmp40_ = _tmp39_;
	_tmp41_ = gee_abstract_list_get ((GeeAbstractList*) _tmp36_, _tmp40_ - 1);
	_g_object_unref0 (ep2);
	ep2 = (BirdFontEditPoint*) _tmp41_;
	_tmp42_ = ep2;
	bird_font_path_recalculate_linear_handles_for_point (path, _tmp42_);
	_tmp43_ = ep2;
	_tmp44_ = bird_font_edit_point_get_left_handle (_tmp43_);
	_tmp44_->type = BIRD_FONT_POINT_TYPE_CUBIC;
	_tmp45_ = ep2;
	_tmp46_ = bird_font_edit_point_get_left_handle (_tmp45_);
	bird_font_edit_point_handle_move_to_coordinate (_tmp46_, x1, y1);
	_tmp47_ = ep2;
	_tmp47_->type = BIRD_FONT_POINT_TYPE_CUBIC;
	_tmp48_ = ep2;
	bird_font_path_recalculate_linear_handles_for_point (path, _tmp48_);
	_g_object_unref0 (ep2);
	_g_object_unref0 (ep1);
}

/** Two quadratic off curve points. */
static void
bird_font_bird_font_file_double_curve (BirdFontPath* path,
                                       const gchar* px0,
                                       const gchar* py0,
                                       const gchar* px1,
                                       const gchar* py1,
                                       const gchar* px2,
                                       const gchar* py2)
{
	BirdFontEditPoint* ep1 = NULL;
	BirdFontEditPoint* ep2 = NULL;
	gdouble x0 = 0.0;
	gdouble y0 = 0.0;
	gdouble x1 = 0.0;
	gdouble y1 = 0.0;
	gdouble x2 = 0.0;
	gdouble y2 = 0.0;
	gdouble lx = 0.0;
	gdouble ly = 0.0;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	GeeArrayList* _tmp4_;
	GeeArrayList* _tmp5_;
	GeeArrayList* _tmp6_;
	GeeArrayList* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	gpointer _tmp10_;
	BirdFontEditPoint* _tmp11_;
	BirdFontEditPointHandle* _tmp12_;
	BirdFontEditPoint* _tmp13_;
	BirdFontEditPoint* _tmp14_;
	BirdFontEditPoint* _tmp15_;
	BirdFontEditPoint* _tmp16_;
	BirdFontEditPoint* _tmp17_;
	BirdFontEditPointHandle* _tmp18_;
	BirdFontEditPoint* _tmp19_;
	GeeArrayList* _tmp20_;
	GeeArrayList* _tmp21_;
	GeeArrayList* _tmp22_;
	GeeArrayList* _tmp23_;
	gint _tmp24_;
	gint _tmp25_;
	gpointer _tmp26_;
	BirdFontEditPoint* _tmp27_;
	BirdFontEditPoint* _tmp28_;
	BirdFontEditPointHandle* _tmp29_;
	BirdFontEditPoint* _tmp30_;
	BirdFontEditPointHandle* _tmp31_;
	BirdFontEditPoint* _tmp32_;
	BirdFontEditPoint* _tmp33_;
	BirdFontEditPoint* _tmp34_;
	BirdFontEditPoint* _tmp35_;
	BirdFontEditPointHandle* _tmp36_;
	BirdFontEditPoint* _tmp37_;
	BirdFontEditPointHandle* _tmp38_;
	BirdFontEditPoint* _tmp39_;
	BirdFontEditPoint* _tmp40_;
	g_return_if_fail (path != NULL);
	g_return_if_fail (px0 != NULL);
	g_return_if_fail (py0 != NULL);
	g_return_if_fail (px1 != NULL);
	g_return_if_fail (py1 != NULL);
	g_return_if_fail (px2 != NULL);
	g_return_if_fail (py2 != NULL);
	x0 = bird_font_bird_font_file_parse_double (px0);
	y0 = bird_font_bird_font_file_parse_double (py0);
	x1 = bird_font_bird_font_file_parse_double (px1);
	y1 = bird_font_bird_font_file_parse_double (py1);
	x2 = bird_font_bird_font_file_parse_double (px2);
	y2 = bird_font_bird_font_file_parse_double (py2);
	_tmp0_ = bird_font_path_get_points (path);
	_tmp1_ = _tmp0_;
	_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == 0) {
		g_warning ("BirdFontFile.vala:1648: No point");
		_g_object_unref0 (ep2);
		_g_object_unref0 (ep1);
		return;
	}
	_tmp4_ = bird_font_path_get_points (path);
	_tmp5_ = _tmp4_;
	_tmp6_ = bird_font_path_get_points (path);
	_tmp7_ = _tmp6_;
	_tmp8_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp5_, _tmp9_ - 1);
	_g_object_unref0 (ep1);
	ep1 = (BirdFontEditPoint*) _tmp10_;
	_tmp11_ = ep1;
	_tmp12_ = bird_font_edit_point_get_right_handle (_tmp11_);
	_tmp12_->type = BIRD_FONT_POINT_TYPE_LINE_DOUBLE_CURVE;
	_tmp13_ = ep1;
	_tmp14_ = ep1;
	lx = _tmp13_->x + ((x2 - _tmp14_->x) / 4);
	_tmp15_ = ep1;
	_tmp16_ = ep1;
	ly = _tmp15_->y + ((y2 - _tmp16_->y) / 4);
	_tmp17_ = ep1;
	_tmp18_ = bird_font_edit_point_get_right_handle (_tmp17_);
	bird_font_edit_point_handle_move_to_coordinate (_tmp18_, lx, ly);
	_tmp19_ = ep1;
	bird_font_path_recalculate_linear_handles_for_point (path, _tmp19_);
	_tmp20_ = bird_font_path_get_points (path);
	_tmp21_ = _tmp20_;
	_tmp22_ = bird_font_path_get_points (path);
	_tmp23_ = _tmp22_;
	_tmp24_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp23_);
	_tmp25_ = _tmp24_;
	_tmp26_ = gee_abstract_list_get ((GeeAbstractList*) _tmp21_, _tmp25_ - 1);
	_g_object_unref0 (ep1);
	ep1 = (BirdFontEditPoint*) _tmp26_;
	_tmp27_ = ep1;
	bird_font_path_recalculate_linear_handles_for_point (path, _tmp27_);
	_tmp28_ = ep1;
	_tmp29_ = bird_font_edit_point_get_right_handle (_tmp28_);
	_tmp29_->type = BIRD_FONT_POINT_TYPE_DOUBLE_CURVE;
	_tmp30_ = ep1;
	_tmp31_ = bird_font_edit_point_get_right_handle (_tmp30_);
	bird_font_edit_point_handle_move_to_coordinate (_tmp31_, x0, y0);
	_tmp32_ = ep1;
	_tmp32_->type = BIRD_FONT_POINT_TYPE_DOUBLE_CURVE;
	_tmp33_ = bird_font_path_add (path, x2, y2);
	_g_object_unref0 (ep2);
	ep2 = _tmp33_;
	_tmp34_ = ep2;
	bird_font_path_recalculate_linear_handles_for_point (path, _tmp34_);
	_tmp35_ = ep2;
	_tmp36_ = bird_font_edit_point_get_left_handle (_tmp35_);
	_tmp36_->type = BIRD_FONT_POINT_TYPE_DOUBLE_CURVE;
	_tmp37_ = ep2;
	_tmp38_ = bird_font_edit_point_get_left_handle (_tmp37_);
	bird_font_edit_point_handle_move_to_coordinate (_tmp38_, x1, y1);
	_tmp39_ = ep2;
	_tmp39_->type = BIRD_FONT_POINT_TYPE_DOUBLE_CURVE;
	_tmp40_ = ep1;
	bird_font_path_recalculate_linear_handles_for_point (path, _tmp40_);
	_g_object_unref0 (ep2);
	_g_object_unref0 (ep1);
}

void
bird_font_bird_font_file_close (BirdFontPath* path)
{
	BirdFontEditPoint* ep1 = NULL;
	BirdFontEditPoint* ep2 = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	GeeArrayList* _tmp4_;
	GeeArrayList* _tmp5_;
	GeeArrayList* _tmp6_;
	GeeArrayList* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	gpointer _tmp10_;
	GeeArrayList* _tmp11_;
	GeeArrayList* _tmp12_;
	gpointer _tmp13_;
	GeeArrayList* _tmp14_;
	GeeArrayList* _tmp15_;
	GeeArrayList* _tmp16_;
	GeeArrayList* _tmp17_;
	gint _tmp18_;
	gint _tmp19_;
	gpointer _tmp20_;
	BirdFontEditPoint* _tmp21_;
	gboolean _tmp22_ = FALSE;
	BirdFontEditPoint* _tmp23_;
	g_return_if_fail (path != NULL);
	_tmp0_ = bird_font_path_get_points (path);
	_tmp1_ = _tmp0_;
	_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ < 2) {
		g_warning ("BirdFontFile.vala:1682: Less  than two points in path.");
		_g_object_unref0 (ep2);
		_g_object_unref0 (ep1);
		return;
	}
	_tmp4_ = bird_font_path_get_points (path);
	_tmp5_ = _tmp4_;
	_tmp6_ = bird_font_path_get_points (path);
	_tmp7_ = _tmp6_;
	_tmp8_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp5_, _tmp9_ - 1);
	_g_object_unref0 (ep1);
	ep1 = (BirdFontEditPoint*) _tmp10_;
	_tmp11_ = bird_font_path_get_points (path);
	_tmp12_ = _tmp11_;
	_tmp13_ = gee_abstract_list_get ((GeeAbstractList*) _tmp12_, 0);
	_g_object_unref0 (ep2);
	ep2 = (BirdFontEditPoint*) _tmp13_;
	_tmp14_ = bird_font_path_get_points (path);
	_tmp15_ = _tmp14_;
	_tmp16_ = bird_font_path_get_points (path);
	_tmp17_ = _tmp16_;
	_tmp18_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp17_);
	_tmp19_ = _tmp18_;
	_tmp20_ = gee_abstract_list_remove_at ((GeeAbstractList*) _tmp15_, _tmp19_ - 1);
	_tmp21_ = (BirdFontEditPoint*) _tmp20_;
	_g_object_unref0 (_tmp21_);
	_tmp23_ = ep1;
	if (_tmp23_->type != BIRD_FONT_POINT_TYPE_QUADRATIC) {
		_tmp22_ = TRUE;
	} else {
		BirdFontEditPoint* _tmp24_;
		_tmp24_ = ep2;
		_tmp22_ = _tmp24_->type != BIRD_FONT_POINT_TYPE_QUADRATIC;
	}
	if (_tmp22_) {
		BirdFontEditPoint* _tmp25_;
		BirdFontEditPoint* _tmp26_;
		gboolean _tmp27_;
		gboolean _tmp28_;
		BirdFontEditPoint* _tmp29_;
		BirdFontEditPointHandle* _tmp30_;
		BirdFontEditPoint* _tmp31_;
		BirdFontEditPointHandle* _tmp32_;
		BirdFontEditPoint* _tmp33_;
		BirdFontEditPointHandle* _tmp34_;
		BirdFontEditPoint* _tmp35_;
		BirdFontEditPointHandle* _tmp36_;
		BirdFontEditPoint* _tmp37_;
		BirdFontEditPointHandle* _tmp38_;
		BirdFontEditPoint* _tmp39_;
		BirdFontEditPointHandle* _tmp40_;
		_tmp25_ = ep2;
		_tmp26_ = ep1;
		_tmp27_ = bird_font_edit_point_get_tie_handles (_tmp26_);
		_tmp28_ = _tmp27_;
		bird_font_edit_point_set_tie_handles (_tmp25_, _tmp28_);
		_tmp29_ = ep2;
		_tmp30_ = _tmp29_->left_handle;
		_tmp31_ = ep1;
		_tmp32_ = _tmp31_->left_handle;
		_tmp30_->angle = _tmp32_->angle;
		_tmp33_ = ep2;
		_tmp34_ = _tmp33_->left_handle;
		_tmp35_ = ep1;
		_tmp36_ = _tmp35_->left_handle;
		_tmp34_->length = _tmp36_->length;
		_tmp37_ = ep2;
		_tmp38_ = _tmp37_->left_handle;
		_tmp39_ = ep1;
		_tmp40_ = _tmp39_->left_handle;
		_tmp38_->type = _tmp40_->type;
	}
	bird_font_path_close (path);
	_g_object_unref0 (ep2);
	_g_object_unref0 (ep1);
}

void
bird_font_bird_font_file_parse_path_data (const gchar* data,
                                          BirdFontPath* path)
{
	gchar** d = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gint d_length1;
	gint _d_size_;
	gchar** p = NULL;
	gint p_length1 = 0;
	gint _p_size_ = 0;
	gchar** p1 = NULL;
	gint p1_length1 = 0;
	gint _p1_size_ = 0;
	gchar** p2 = NULL;
	gint p2_length1 = 0;
	gint _p2_size_ = 0;
	gint i = 0;
	gchar* instruction = NULL;
	gchar* _tmp2_;
	gboolean open = FALSE;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gchar** _tmp6_;
	gint _tmp6__length1;
	const gchar* _tmp7_;
	gchar** _tmp12_;
	gint _tmp12__length1;
	gint _tmp13_;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	const gchar* _tmp16_;
	const gchar* _tmp27_;
	const gchar* _tmp38_;
	g_return_if_fail (data != NULL);
	g_return_if_fail (path != NULL);
	_tmp1_ = _tmp0_ = g_strsplit (data, " ", 0);
	d = _tmp1_;
	d_length1 = _vala_array_length (_tmp0_);
	_d_size_ = d_length1;
	i = 0;
	_tmp2_ = g_strdup ("");
	instruction = _tmp2_;
	open = FALSE;
	if (g_strcmp0 (data, "") == 0) {
		_g_free0 (instruction);
		p2 = (_vala_array_free (p2, p2_length1, (GDestroyNotify) g_free), NULL);
		p1 = (_vala_array_free (p1, p1_length1, (GDestroyNotify) g_free), NULL);
		p = (_vala_array_free (p, p_length1, (GDestroyNotify) g_free), NULL);
		d = (_vala_array_free (d, d_length1, (GDestroyNotify) g_free), NULL);
		return;
	}
	_tmp3_ = d;
	_tmp3__length1 = d_length1;
	g_return_if_fail (_tmp3__length1 > 1);
	_tmp6_ = d;
	_tmp6__length1 = d_length1;
	_tmp7_ = _tmp6_[0];
	if (g_strcmp0 (_tmp7_, "R") == 0) {
		_tmp5_ = TRUE;
	} else {
		gchar** _tmp8_;
		gint _tmp8__length1;
		const gchar* _tmp9_;
		_tmp8_ = d;
		_tmp8__length1 = d_length1;
		_tmp9_ = _tmp8_[0];
		_tmp5_ = g_strcmp0 (_tmp9_, "S") == 0;
	}
	if (_tmp5_) {
		_tmp4_ = TRUE;
	} else {
		gchar** _tmp10_;
		gint _tmp10__length1;
		const gchar* _tmp11_;
		_tmp10_ = d;
		_tmp10__length1 = d_length1;
		_tmp11_ = _tmp10_[0];
		_tmp4_ = g_strcmp0 (_tmp11_, "B") == 0;
	}
	if (!_tmp4_) {
		g_warning ("BirdFontFile.vala:1716: No start point.");
		_g_free0 (instruction);
		p2 = (_vala_array_free (p2, p2_length1, (GDestroyNotify) g_free), NULL);
		p1 = (_vala_array_free (p1, p1_length1, (GDestroyNotify) g_free), NULL);
		p = (_vala_array_free (p, p_length1, (GDestroyNotify) g_free), NULL);
		d = (_vala_array_free (d, d_length1, (GDestroyNotify) g_free), NULL);
		return;
	}
	_tmp12_ = d;
	_tmp12__length1 = d_length1;
	_tmp13_ = i;
	i = _tmp13_ + 1;
	_tmp14_ = _tmp12_[_tmp13_];
	_tmp15_ = g_strdup (_tmp14_);
	_g_free0 (instruction);
	instruction = _tmp15_;
	_tmp16_ = instruction;
	if (g_strcmp0 (_tmp16_, "R") == 0) {
		gchar** _tmp17_;
		gint _tmp17__length1;
		gint _tmp18_;
		const gchar* _tmp19_;
		gchar** _tmp20_;
		gchar** _tmp21_;
		gchar** _tmp22_;
		gint _tmp22__length1;
		gchar** _tmp23_;
		gint _tmp23__length1;
		const gchar* _tmp24_;
		gchar** _tmp25_;
		gint _tmp25__length1;
		const gchar* _tmp26_;
		_tmp17_ = d;
		_tmp17__length1 = d_length1;
		_tmp18_ = i;
		i = _tmp18_ + 1;
		_tmp19_ = _tmp17_[_tmp18_];
		_tmp21_ = _tmp20_ = g_strsplit (_tmp19_, ",", 0);
		p = (_vala_array_free (p, p_length1, (GDestroyNotify) g_free), NULL);
		p = _tmp21_;
		p_length1 = _vala_array_length (_tmp20_);
		_p_size_ = p_length1;
		_tmp22_ = p;
		_tmp22__length1 = p_length1;
		g_return_if_fail (_tmp22__length1 == 2);
		_tmp23_ = p;
		_tmp23__length1 = p_length1;
		_tmp24_ = _tmp23_[0];
		_tmp25_ = p;
		_tmp25__length1 = p_length1;
		_tmp26_ = _tmp25_[1];
		bird_font_bird_font_file_quadratic_line (path, _tmp24_, _tmp26_);
	}
	_tmp27_ = instruction;
	if (g_strcmp0 (_tmp27_, "S") == 0) {
		gchar** _tmp28_;
		gint _tmp28__length1;
		gint _tmp29_;
		const gchar* _tmp30_;
		gchar** _tmp31_;
		gchar** _tmp32_;
		gchar** _tmp33_;
		gint _tmp33__length1;
		gchar** _tmp34_;
		gint _tmp34__length1;
		const gchar* _tmp35_;
		gchar** _tmp36_;
		gint _tmp36__length1;
		const gchar* _tmp37_;
		_tmp28_ = d;
		_tmp28__length1 = d_length1;
		_tmp29_ = i;
		i = _tmp29_ + 1;
		_tmp30_ = _tmp28_[_tmp29_];
		_tmp32_ = _tmp31_ = g_strsplit (_tmp30_, ",", 0);
		p = (_vala_array_free (p, p_length1, (GDestroyNotify) g_free), NULL);
		p = _tmp32_;
		p_length1 = _vala_array_length (_tmp31_);
		_p_size_ = p_length1;
		_tmp33_ = p;
		_tmp33__length1 = p_length1;
		g_return_if_fail (_tmp33__length1 == 2);
		_tmp34_ = p;
		_tmp34__length1 = p_length1;
		_tmp35_ = _tmp34_[0];
		_tmp36_ = p;
		_tmp36__length1 = p_length1;
		_tmp37_ = _tmp36_[1];
		bird_font_bird_font_file_line (path, _tmp35_, _tmp37_);
	}
	_tmp38_ = instruction;
	if (g_strcmp0 (_tmp38_, "B") == 0) {
		gchar** _tmp39_;
		gint _tmp39__length1;
		gint _tmp40_;
		const gchar* _tmp41_;
		gchar** _tmp42_;
		gchar** _tmp43_;
		gchar** _tmp44_;
		gint _tmp44__length1;
		gchar** _tmp45_;
		gint _tmp45__length1;
		const gchar* _tmp46_;
		gchar** _tmp47_;
		gint _tmp47__length1;
		const gchar* _tmp48_;
		_tmp39_ = d;
		_tmp39__length1 = d_length1;
		_tmp40_ = i;
		i = _tmp40_ + 1;
		_tmp41_ = _tmp39_[_tmp40_];
		_tmp43_ = _tmp42_ = g_strsplit (_tmp41_, ",", 0);
		p = (_vala_array_free (p, p_length1, (GDestroyNotify) g_free), NULL);
		p = _tmp43_;
		p_length1 = _vala_array_length (_tmp42_);
		_p_size_ = p_length1;
		_tmp44_ = p;
		_tmp44__length1 = p_length1;
		g_return_if_fail (_tmp44__length1 == 2);
		_tmp45_ = p;
		_tmp45__length1 = p_length1;
		_tmp46_ = _tmp45_[0];
		_tmp47_ = p;
		_tmp47__length1 = p_length1;
		_tmp48_ = _tmp47_[1];
		bird_font_bird_font_file_cubic_line (path, _tmp46_, _tmp48_);
	}
	while (TRUE) {
		gchar** _tmp49_;
		gint _tmp49__length1;
		gchar** _tmp50_;
		gint _tmp50__length1;
		gint _tmp51_;
		const gchar* _tmp52_;
		gchar* _tmp53_;
		const gchar* _tmp54_;
		const gchar* _tmp59_;
		_tmp49_ = d;
		_tmp49__length1 = d_length1;
		if (!(i < _tmp49__length1)) {
			break;
		}
		_tmp50_ = d;
		_tmp50__length1 = d_length1;
		_tmp51_ = i;
		i = _tmp51_ + 1;
		_tmp52_ = _tmp50_[_tmp51_];
		_tmp53_ = g_strdup (_tmp52_);
		_g_free0 (instruction);
		instruction = _tmp53_;
		_tmp54_ = instruction;
		if (g_strcmp0 (_tmp54_, "") == 0) {
			gchar* _tmp55_;
			gchar* _tmp56_;
			gchar* _tmp57_;
			gchar* _tmp58_;
			_tmp55_ = g_strdup_printf ("%i", i);
			_tmp56_ = _tmp55_;
			_tmp57_ = g_strconcat ("No instruction at index ", _tmp56_, ".", NULL);
			_tmp58_ = _tmp57_;
			g_warning ("BirdFontFile.vala:1744: %s", _tmp58_);
			_g_free0 (_tmp58_);
			_g_free0 (_tmp56_);
			_g_free0 (instruction);
			p2 = (_vala_array_free (p2, p2_length1, (GDestroyNotify) g_free), NULL);
			p1 = (_vala_array_free (p1, p1_length1, (GDestroyNotify) g_free), NULL);
			p = (_vala_array_free (p, p_length1, (GDestroyNotify) g_free), NULL);
			d = (_vala_array_free (d, d_length1, (GDestroyNotify) g_free), NULL);
			return;
		}
		_tmp59_ = instruction;
		if (g_strcmp0 (_tmp59_, "K") == 0) {
			gchar** _tmp60_;
			gint _tmp60__length1;
			gchar** _tmp61_;
			gint _tmp61__length1;
			gint _tmp62_;
			const gchar* _tmp63_;
			gchar** _tmp64_;
			gchar** _tmp65_;
			gchar** _tmp66_;
			gint _tmp66__length1;
			gchar** _tmp67_;
			gint _tmp67__length1;
			const gchar* _tmp68_;
			gchar** _tmp69_;
			gint _tmp69__length1;
			const gchar* _tmp70_;
			_tmp60_ = d;
			_tmp60__length1 = d_length1;
			g_return_if_fail (i < _tmp60__length1);
			_tmp61_ = d;
			_tmp61__length1 = d_length1;
			_tmp62_ = i;
			i = _tmp62_ + 1;
			_tmp63_ = _tmp61_[_tmp62_];
			_tmp65_ = _tmp64_ = g_strsplit (_tmp63_, ",", 0);
			p = (_vala_array_free (p, p_length1, (GDestroyNotify) g_free), NULL);
			p = _tmp65_;
			p_length1 = _vala_array_length (_tmp64_);
			_p_size_ = p_length1;
			_tmp66_ = p;
			_tmp66__length1 = p_length1;
			g_return_if_fail (_tmp66__length1 == 2);
			_tmp67_ = p;
			_tmp67__length1 = p_length1;
			_tmp68_ = _tmp67_[0];
			_tmp69_ = p;
			_tmp69__length1 = p_length1;
			_tmp70_ = _tmp69_[1];
			bird_font_bird_font_file_quadratic_line (path, _tmp68_, _tmp70_);
		} else {
			const gchar* _tmp71_;
			_tmp71_ = instruction;
			if (g_strcmp0 (_tmp71_, "L") == 0) {
				gchar** _tmp72_;
				gint _tmp72__length1;
				gchar** _tmp73_;
				gint _tmp73__length1;
				gint _tmp74_;
				const gchar* _tmp75_;
				gchar** _tmp76_;
				gchar** _tmp77_;
				gchar** _tmp78_;
				gint _tmp78__length1;
				gchar** _tmp79_;
				gint _tmp79__length1;
				const gchar* _tmp80_;
				gchar** _tmp81_;
				gint _tmp81__length1;
				const gchar* _tmp82_;
				_tmp72_ = d;
				_tmp72__length1 = d_length1;
				g_return_if_fail (i < _tmp72__length1);
				_tmp73_ = d;
				_tmp73__length1 = d_length1;
				_tmp74_ = i;
				i = _tmp74_ + 1;
				_tmp75_ = _tmp73_[_tmp74_];
				_tmp77_ = _tmp76_ = g_strsplit (_tmp75_, ",", 0);
				p = (_vala_array_free (p, p_length1, (GDestroyNotify) g_free), NULL);
				p = _tmp77_;
				p_length1 = _vala_array_length (_tmp76_);
				_p_size_ = p_length1;
				_tmp78_ = p;
				_tmp78__length1 = p_length1;
				g_return_if_fail (_tmp78__length1 == 2);
				_tmp79_ = p;
				_tmp79__length1 = p_length1;
				_tmp80_ = _tmp79_[0];
				_tmp81_ = p;
				_tmp81__length1 = p_length1;
				_tmp82_ = _tmp81_[1];
				bird_font_bird_font_file_line (path, _tmp80_, _tmp82_);
			} else {
				const gchar* _tmp83_;
				_tmp83_ = instruction;
				if (g_strcmp0 (_tmp83_, "M") == 0) {
					gchar** _tmp84_;
					gint _tmp84__length1;
					gchar** _tmp85_;
					gint _tmp85__length1;
					gint _tmp86_;
					const gchar* _tmp87_;
					gchar** _tmp88_;
					gchar** _tmp89_;
					gchar** _tmp90_;
					gint _tmp90__length1;
					gchar** _tmp91_;
					gint _tmp91__length1;
					const gchar* _tmp92_;
					gchar** _tmp93_;
					gint _tmp93__length1;
					const gchar* _tmp94_;
					_tmp84_ = d;
					_tmp84__length1 = d_length1;
					g_return_if_fail (i < _tmp84__length1);
					_tmp85_ = d;
					_tmp85__length1 = d_length1;
					_tmp86_ = i;
					i = _tmp86_ + 1;
					_tmp87_ = _tmp85_[_tmp86_];
					_tmp89_ = _tmp88_ = g_strsplit (_tmp87_, ",", 0);
					p = (_vala_array_free (p, p_length1, (GDestroyNotify) g_free), NULL);
					p = _tmp89_;
					p_length1 = _vala_array_length (_tmp88_);
					_p_size_ = p_length1;
					_tmp90_ = p;
					_tmp90__length1 = p_length1;
					g_return_if_fail (_tmp90__length1 == 2);
					_tmp91_ = p;
					_tmp91__length1 = p_length1;
					_tmp92_ = _tmp91_[0];
					_tmp93_ = p;
					_tmp93__length1 = p_length1;
					_tmp94_ = _tmp93_[1];
					bird_font_bird_font_file_cubic_line (path, _tmp92_, _tmp94_);
				} else {
					const gchar* _tmp95_;
					_tmp95_ = instruction;
					if (g_strcmp0 (_tmp95_, "Q") == 0) {
						gchar** _tmp96_;
						gint _tmp96__length1;
						gchar** _tmp97_;
						gint _tmp97__length1;
						gint _tmp98_;
						const gchar* _tmp99_;
						gchar** _tmp100_;
						gchar** _tmp101_;
						gchar** _tmp102_;
						gint _tmp102__length1;
						gint _tmp103_;
						const gchar* _tmp104_;
						gchar** _tmp105_;
						gchar** _tmp106_;
						gchar** _tmp107_;
						gint _tmp107__length1;
						gchar** _tmp108_;
						gint _tmp108__length1;
						gchar** _tmp109_;
						gint _tmp109__length1;
						const gchar* _tmp110_;
						gchar** _tmp111_;
						gint _tmp111__length1;
						const gchar* _tmp112_;
						gchar** _tmp113_;
						gint _tmp113__length1;
						const gchar* _tmp114_;
						gchar** _tmp115_;
						gint _tmp115__length1;
						const gchar* _tmp116_;
						_tmp96_ = d;
						_tmp96__length1 = d_length1;
						g_return_if_fail ((i + 1) < _tmp96__length1);
						_tmp97_ = d;
						_tmp97__length1 = d_length1;
						_tmp98_ = i;
						i = _tmp98_ + 1;
						_tmp99_ = _tmp97_[_tmp98_];
						_tmp101_ = _tmp100_ = g_strsplit (_tmp99_, ",", 0);
						p = (_vala_array_free (p, p_length1, (GDestroyNotify) g_free), NULL);
						p = _tmp101_;
						p_length1 = _vala_array_length (_tmp100_);
						_p_size_ = p_length1;
						_tmp102_ = d;
						_tmp102__length1 = d_length1;
						_tmp103_ = i;
						i = _tmp103_ + 1;
						_tmp104_ = _tmp102_[_tmp103_];
						_tmp106_ = _tmp105_ = g_strsplit (_tmp104_, ",", 0);
						p1 = (_vala_array_free (p1, p1_length1, (GDestroyNotify) g_free), NULL);
						p1 = _tmp106_;
						p1_length1 = _vala_array_length (_tmp105_);
						_p1_size_ = p1_length1;
						_tmp107_ = p;
						_tmp107__length1 = p_length1;
						g_return_if_fail (_tmp107__length1 == 2);
						_tmp108_ = p1;
						_tmp108__length1 = p1_length1;
						g_return_if_fail (_tmp108__length1 == 2);
						_tmp109_ = p;
						_tmp109__length1 = p_length1;
						_tmp110_ = _tmp109_[0];
						_tmp111_ = p;
						_tmp111__length1 = p_length1;
						_tmp112_ = _tmp111_[1];
						_tmp113_ = p1;
						_tmp113__length1 = p1_length1;
						_tmp114_ = _tmp113_[0];
						_tmp115_ = p1;
						_tmp115__length1 = p1_length1;
						_tmp116_ = _tmp115_[1];
						bird_font_bird_font_file_quadratic (path, _tmp110_, _tmp112_, _tmp114_, _tmp116_);
					} else {
						const gchar* _tmp117_;
						_tmp117_ = instruction;
						if (g_strcmp0 (_tmp117_, "D") == 0) {
							gchar** _tmp118_;
							gint _tmp118__length1;
							gchar** _tmp119_;
							gint _tmp119__length1;
							gint _tmp120_;
							const gchar* _tmp121_;
							gchar** _tmp122_;
							gchar** _tmp123_;
							gchar** _tmp124_;
							gint _tmp124__length1;
							gint _tmp125_;
							const gchar* _tmp126_;
							gchar** _tmp127_;
							gchar** _tmp128_;
							gchar** _tmp129_;
							gint _tmp129__length1;
							gint _tmp130_;
							const gchar* _tmp131_;
							gchar** _tmp132_;
							gchar** _tmp133_;
							gchar** _tmp134_;
							gint _tmp134__length1;
							gchar** _tmp135_;
							gint _tmp135__length1;
							gchar** _tmp136_;
							gint _tmp136__length1;
							gchar** _tmp137_;
							gint _tmp137__length1;
							const gchar* _tmp138_;
							gchar** _tmp139_;
							gint _tmp139__length1;
							const gchar* _tmp140_;
							gchar** _tmp141_;
							gint _tmp141__length1;
							const gchar* _tmp142_;
							gchar** _tmp143_;
							gint _tmp143__length1;
							const gchar* _tmp144_;
							gchar** _tmp145_;
							gint _tmp145__length1;
							const gchar* _tmp146_;
							gchar** _tmp147_;
							gint _tmp147__length1;
							const gchar* _tmp148_;
							_tmp118_ = d;
							_tmp118__length1 = d_length1;
							g_return_if_fail ((i + 2) < _tmp118__length1);
							_tmp119_ = d;
							_tmp119__length1 = d_length1;
							_tmp120_ = i;
							i = _tmp120_ + 1;
							_tmp121_ = _tmp119_[_tmp120_];
							_tmp123_ = _tmp122_ = g_strsplit (_tmp121_, ",", 0);
							p = (_vala_array_free (p, p_length1, (GDestroyNotify) g_free), NULL);
							p = _tmp123_;
							p_length1 = _vala_array_length (_tmp122_);
							_p_size_ = p_length1;
							_tmp124_ = d;
							_tmp124__length1 = d_length1;
							_tmp125_ = i;
							i = _tmp125_ + 1;
							_tmp126_ = _tmp124_[_tmp125_];
							_tmp128_ = _tmp127_ = g_strsplit (_tmp126_, ",", 0);
							p1 = (_vala_array_free (p1, p1_length1, (GDestroyNotify) g_free), NULL);
							p1 = _tmp128_;
							p1_length1 = _vala_array_length (_tmp127_);
							_p1_size_ = p1_length1;
							_tmp129_ = d;
							_tmp129__length1 = d_length1;
							_tmp130_ = i;
							i = _tmp130_ + 1;
							_tmp131_ = _tmp129_[_tmp130_];
							_tmp133_ = _tmp132_ = g_strsplit (_tmp131_, ",", 0);
							p2 = (_vala_array_free (p2, p2_length1, (GDestroyNotify) g_free), NULL);
							p2 = _tmp133_;
							p2_length1 = _vala_array_length (_tmp132_);
							_p2_size_ = p2_length1;
							_tmp134_ = p;
							_tmp134__length1 = p_length1;
							g_return_if_fail (_tmp134__length1 == 2);
							_tmp135_ = p1;
							_tmp135__length1 = p1_length1;
							g_return_if_fail (_tmp135__length1 == 2);
							_tmp136_ = p2;
							_tmp136__length1 = p2_length1;
							g_return_if_fail (_tmp136__length1 == 2);
							_tmp137_ = p;
							_tmp137__length1 = p_length1;
							_tmp138_ = _tmp137_[0];
							_tmp139_ = p;
							_tmp139__length1 = p_length1;
							_tmp140_ = _tmp139_[1];
							_tmp141_ = p1;
							_tmp141__length1 = p1_length1;
							_tmp142_ = _tmp141_[0];
							_tmp143_ = p1;
							_tmp143__length1 = p1_length1;
							_tmp144_ = _tmp143_[1];
							_tmp145_ = p2;
							_tmp145__length1 = p2_length1;
							_tmp146_ = _tmp145_[0];
							_tmp147_ = p2;
							_tmp147__length1 = p2_length1;
							_tmp148_ = _tmp147_[1];
							bird_font_bird_font_file_double_curve (path, _tmp138_, _tmp140_, _tmp142_, _tmp144_, _tmp146_, _tmp148_);
						} else {
							const gchar* _tmp149_;
							_tmp149_ = instruction;
							if (g_strcmp0 (_tmp149_, "C") == 0) {
								gchar** _tmp150_;
								gint _tmp150__length1;
								gchar** _tmp151_;
								gint _tmp151__length1;
								gint _tmp152_;
								const gchar* _tmp153_;
								gchar** _tmp154_;
								gchar** _tmp155_;
								gchar** _tmp156_;
								gint _tmp156__length1;
								gint _tmp157_;
								const gchar* _tmp158_;
								gchar** _tmp159_;
								gchar** _tmp160_;
								gchar** _tmp161_;
								gint _tmp161__length1;
								gint _tmp162_;
								const gchar* _tmp163_;
								gchar** _tmp164_;
								gchar** _tmp165_;
								gchar** _tmp166_;
								gint _tmp166__length1;
								gchar** _tmp167_;
								gint _tmp167__length1;
								gchar** _tmp168_;
								gint _tmp168__length1;
								gchar** _tmp169_;
								gint _tmp169__length1;
								const gchar* _tmp170_;
								gchar** _tmp171_;
								gint _tmp171__length1;
								const gchar* _tmp172_;
								gchar** _tmp173_;
								gint _tmp173__length1;
								const gchar* _tmp174_;
								gchar** _tmp175_;
								gint _tmp175__length1;
								const gchar* _tmp176_;
								gchar** _tmp177_;
								gint _tmp177__length1;
								const gchar* _tmp178_;
								gchar** _tmp179_;
								gint _tmp179__length1;
								const gchar* _tmp180_;
								_tmp150_ = d;
								_tmp150__length1 = d_length1;
								g_return_if_fail ((i + 2) < _tmp150__length1);
								_tmp151_ = d;
								_tmp151__length1 = d_length1;
								_tmp152_ = i;
								i = _tmp152_ + 1;
								_tmp153_ = _tmp151_[_tmp152_];
								_tmp155_ = _tmp154_ = g_strsplit (_tmp153_, ",", 0);
								p = (_vala_array_free (p, p_length1, (GDestroyNotify) g_free), NULL);
								p = _tmp155_;
								p_length1 = _vala_array_length (_tmp154_);
								_p_size_ = p_length1;
								_tmp156_ = d;
								_tmp156__length1 = d_length1;
								_tmp157_ = i;
								i = _tmp157_ + 1;
								_tmp158_ = _tmp156_[_tmp157_];
								_tmp160_ = _tmp159_ = g_strsplit (_tmp158_, ",", 0);
								p1 = (_vala_array_free (p1, p1_length1, (GDestroyNotify) g_free), NULL);
								p1 = _tmp160_;
								p1_length1 = _vala_array_length (_tmp159_);
								_p1_size_ = p1_length1;
								_tmp161_ = d;
								_tmp161__length1 = d_length1;
								_tmp162_ = i;
								i = _tmp162_ + 1;
								_tmp163_ = _tmp161_[_tmp162_];
								_tmp165_ = _tmp164_ = g_strsplit (_tmp163_, ",", 0);
								p2 = (_vala_array_free (p2, p2_length1, (GDestroyNotify) g_free), NULL);
								p2 = _tmp165_;
								p2_length1 = _vala_array_length (_tmp164_);
								_p2_size_ = p2_length1;
								_tmp166_ = p;
								_tmp166__length1 = p_length1;
								g_return_if_fail (_tmp166__length1 == 2);
								_tmp167_ = p1;
								_tmp167__length1 = p1_length1;
								g_return_if_fail (_tmp167__length1 == 2);
								_tmp168_ = p2;
								_tmp168__length1 = p2_length1;
								g_return_if_fail (_tmp168__length1 == 2);
								_tmp169_ = p;
								_tmp169__length1 = p_length1;
								_tmp170_ = _tmp169_[0];
								_tmp171_ = p;
								_tmp171__length1 = p_length1;
								_tmp172_ = _tmp171_[1];
								_tmp173_ = p1;
								_tmp173__length1 = p1_length1;
								_tmp174_ = _tmp173_[0];
								_tmp175_ = p1;
								_tmp175__length1 = p1_length1;
								_tmp176_ = _tmp175_[1];
								_tmp177_ = p2;
								_tmp177__length1 = p2_length1;
								_tmp178_ = _tmp177_[0];
								_tmp179_ = p2;
								_tmp179__length1 = p2_length1;
								_tmp180_ = _tmp179_[1];
								bird_font_bird_font_file_cubic (path, _tmp170_, _tmp172_, _tmp174_, _tmp176_, _tmp178_, _tmp180_);
							} else {
								const gchar* _tmp181_;
								_tmp181_ = instruction;
								if (g_strcmp0 (_tmp181_, "T") == 0) {
									GeeArrayList* _tmp182_;
									GeeArrayList* _tmp183_;
									GeeArrayList* _tmp184_;
									GeeArrayList* _tmp185_;
									gint _tmp186_;
									gint _tmp187_;
									gpointer _tmp188_;
									BirdFontEditPoint* _tmp189_;
									_tmp182_ = bird_font_path_get_points (path);
									_tmp183_ = _tmp182_;
									_tmp184_ = bird_font_path_get_points (path);
									_tmp185_ = _tmp184_;
									_tmp186_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp185_);
									_tmp187_ = _tmp186_;
									_tmp188_ = gee_abstract_list_get ((GeeAbstractList*) _tmp183_, _tmp187_ - 1);
									_tmp189_ = (BirdFontEditPoint*) _tmp188_;
									bird_font_edit_point_set_tie_handles (_tmp189_, TRUE);
									_g_object_unref0 (_tmp189_);
								} else {
									const gchar* _tmp190_;
									_tmp190_ = instruction;
									if (g_strcmp0 (_tmp190_, "O") == 0) {
										open = TRUE;
									} else {
										const gchar* _tmp191_;
										const gchar* _tmp192_;
										gchar* _tmp193_;
										gchar* _tmp194_;
										_tmp191_ = instruction;
										_tmp192_ = string_to_string (_tmp191_);
										_tmp193_ = g_strconcat ("invalid instruction ", _tmp192_, NULL);
										_tmp194_ = _tmp193_;
										g_warning ("BirdFontFile.vala:1802: %s", _tmp194_);
										_g_free0 (_tmp194_);
										_g_free0 (instruction);
										p2 = (_vala_array_free (p2, p2_length1, (GDestroyNotify) g_free), NULL);
										p1 = (_vala_array_free (p1, p1_length1, (GDestroyNotify) g_free), NULL);
										p = (_vala_array_free (p, p_length1, (GDestroyNotify) g_free), NULL);
										d = (_vala_array_free (d, d_length1, (GDestroyNotify) g_free), NULL);
										return;
									}
								}
							}
						}
					}
				}
			}
		}
	}
	if (!open) {
		bird_font_bird_font_file_close (path);
	} else {
		GeeArrayList* _tmp195_;
		GeeArrayList* _tmp196_;
		GeeArrayList* _tmp197_;
		GeeArrayList* _tmp198_;
		gint _tmp199_;
		gint _tmp200_;
		gpointer _tmp201_;
		BirdFontEditPoint* _tmp202_;
		_tmp195_ = bird_font_path_get_points (path);
		_tmp196_ = _tmp195_;
		_tmp197_ = bird_font_path_get_points (path);
		_tmp198_ = _tmp197_;
		_tmp199_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp198_);
		_tmp200_ = _tmp199_;
		_tmp201_ = gee_abstract_list_remove_at ((GeeAbstractList*) _tmp196_, _tmp200_ - 1);
		_tmp202_ = (BirdFontEditPoint*) _tmp201_;
		_g_object_unref0 (_tmp202_);
		if (!bird_font_path_is_open (path)) {
			g_warning ("BirdFontFile.vala:1813: Closed path.");
		}
	}
	bird_font_path_update_region_boundaries (path);
	_g_free0 (instruction);
	p2 = (_vala_array_free (p2, p2_length1, (GDestroyNotify) g_free), NULL);
	p1 = (_vala_array_free (p1, p1_length1, (GDestroyNotify) g_free), NULL);
	p = (_vala_array_free (p, p_length1, (GDestroyNotify) g_free), NULL);
	d = (_vala_array_free (d, d_length1, (GDestroyNotify) g_free), NULL);
}

static gdouble
bird_font_bird_font_file_parse_double (const gchar* p)
{
	gdouble d = 0.0;
	gdouble _tmp0_ = 0.0;
	gboolean _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gdouble result;
	g_return_val_if_fail (p != NULL, 0.0);
	_tmp1_ = double_try_parse (p, &_tmp0_, NULL);
	d = _tmp0_;
	if (_tmp1_) {
		result = d;
		return result;
	}
	_tmp2_ = string_to_string (p);
	_tmp3_ = g_strconcat ("failed to parse ", _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	g_warning ("BirdFontFile.vala:1826: %s", _tmp4_);
	_g_free0 (_tmp4_);
	result = (gdouble) 0;
	return result;
}

static void
bird_font_bird_font_file_parse_background_scale (BirdFontBirdFontFile* self,
                                                 BirdFontGlyph* g,
                                                 BTag* tag)
{
	BirdFontBackgroundImage* img = NULL;
	BirdFontBackgroundImage* new_img = NULL;
	GFile* img_file = NULL;
	BirdFontFont* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	BirdFontBackgroundImage* _tmp35_;
	BirdFontBackgroundImage* _tmp36_;
	BirdFontBackgroundImage* _tmp37_;
	BirdFontBackgroundImage* _tmp85_;
	BirdFontBackgroundImage* _tmp86_;
	BirdFontBackgroundImage* _tmp87_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (g != NULL);
	g_return_if_fail (tag != NULL);
	new_img = NULL;
	_tmp0_ = self->priv->font;
	_tmp1_ = bird_font_font_get_backgrounds_folder (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = bird_font_get_child (_tmp2_, "parts");
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp2_);
	img_file = _tmp4_;
	{
		BAttributesIterator* _attr_it = NULL;
		BAttributes* _tmp5_;
		BAttributes* _tmp6_;
		BAttributesIterator* _tmp7_;
		BAttributesIterator* _tmp8_;
		_tmp5_ = b_tag_get_attributes (tag);
		_tmp6_ = _tmp5_;
		_tmp7_ = b_attributes_iterator (_tmp6_);
		_tmp8_ = _tmp7_;
		_g_object_unref0 (_tmp6_);
		_attr_it = _tmp8_;
		while (TRUE) {
			BAttributesIterator* _tmp9_;
			BAttribute* attr = NULL;
			BAttributesIterator* _tmp10_;
			BAttribute* _tmp11_;
			BAttribute* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			gboolean _tmp15_;
			_tmp9_ = _attr_it;
			if (!b_attributes_iterator_next (_tmp9_)) {
				break;
			}
			_tmp10_ = _attr_it;
			_tmp11_ = b_attributes_iterator_get (_tmp10_);
			attr = _tmp11_;
			_tmp12_ = attr;
			_tmp13_ = b_attribute_get_name (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = g_strcmp0 (_tmp14_, "sha1") == 0;
			_g_free0 (_tmp14_);
			if (_tmp15_) {
				GFile* _tmp16_;
				BAttribute* _tmp17_;
				gchar* _tmp18_;
				gchar* _tmp19_;
				gchar* _tmp20_;
				gchar* _tmp21_;
				GFile* _tmp22_;
				GFile* _tmp23_;
				GFile* _tmp30_;
				gchar* _tmp31_;
				gchar* _tmp32_;
				BirdFontBackgroundImage* _tmp33_;
				BirdFontBackgroundImage* _tmp34_;
				_tmp16_ = img_file;
				_tmp17_ = attr;
				_tmp18_ = b_attribute_get_content (_tmp17_);
				_tmp19_ = _tmp18_;
				_tmp20_ = g_strconcat (_tmp19_, ".png", NULL);
				_tmp21_ = _tmp20_;
				_tmp22_ = bird_font_get_child (_tmp16_, _tmp21_);
				_g_object_unref0 (img_file);
				img_file = _tmp22_;
				_g_free0 (_tmp21_);
				_g_free0 (_tmp19_);
				_tmp23_ = img_file;
				if (!g_file_query_exists (_tmp23_, NULL)) {
					GFile* _tmp24_;
					gchar* _tmp25_;
					gchar* _tmp26_;
					const gchar* _tmp27_;
					gchar* _tmp28_;
					gchar* _tmp29_;
					_tmp24_ = img_file;
					_tmp25_ = g_file_get_path (_tmp24_);
					_tmp26_ = (gchar*) _tmp25_;
					_tmp27_ = string_to_string (_tmp26_);
					_tmp28_ = g_strconcat ("Background file has not been created yet. ", _tmp27_, NULL);
					_tmp29_ = _tmp28_;
					g_warning ("BirdFontFile.vala:1841: %s", _tmp29_);
					_g_free0 (_tmp29_);
					_g_free0 (_tmp26_);
				}
				_tmp30_ = img_file;
				_tmp31_ = g_file_get_path (_tmp30_);
				_tmp32_ = (gchar*) _tmp31_;
				_tmp33_ = bird_font_background_image_new (_tmp32_);
				_g_object_unref0 (new_img);
				new_img = _tmp33_;
				_g_free0 (_tmp32_);
				_tmp34_ = new_img;
				bird_font_glyph_set_background_image (g, G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, BIRD_FONT_TYPE_BACKGROUND_IMAGE, BirdFontBackgroundImage));
			}
			_g_object_unref0 (attr);
		}
		_g_object_unref0 (_attr_it);
	}
	_tmp35_ = new_img;
	if (G_UNLIKELY (_tmp35_ == NULL)) {
		g_warning ("BirdFontFile.vala:1850: No source for image found.");
		_g_object_unref0 (img_file);
		_g_object_unref0 (new_img);
		_g_object_unref0 (img);
		return;
	}
	_tmp36_ = new_img;
	_tmp37_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp36_, BIRD_FONT_TYPE_BACKGROUND_IMAGE, BirdFontBackgroundImage));
	_g_object_unref0 (img);
	img = _tmp37_;
	{
		BAttributesIterator* _attr_it = NULL;
		BAttributes* _tmp38_;
		BAttributes* _tmp39_;
		BAttributesIterator* _tmp40_;
		BAttributesIterator* _tmp41_;
		_tmp38_ = b_tag_get_attributes (tag);
		_tmp39_ = _tmp38_;
		_tmp40_ = b_attributes_iterator (_tmp39_);
		_tmp41_ = _tmp40_;
		_g_object_unref0 (_tmp39_);
		_attr_it = _tmp41_;
		while (TRUE) {
			BAttributesIterator* _tmp42_;
			BAttribute* attr = NULL;
			BAttributesIterator* _tmp43_;
			BAttribute* _tmp44_;
			BAttribute* _tmp45_;
			gchar* _tmp46_;
			gchar* _tmp47_;
			gboolean _tmp48_;
			BAttribute* _tmp53_;
			gchar* _tmp54_;
			gchar* _tmp55_;
			gboolean _tmp56_;
			BAttribute* _tmp61_;
			gchar* _tmp62_;
			gchar* _tmp63_;
			gboolean _tmp64_;
			BAttribute* _tmp69_;
			gchar* _tmp70_;
			gchar* _tmp71_;
			gboolean _tmp72_;
			BAttribute* _tmp77_;
			gchar* _tmp78_;
			gchar* _tmp79_;
			gboolean _tmp80_;
			_tmp42_ = _attr_it;
			if (!b_attributes_iterator_next (_tmp42_)) {
				break;
			}
			_tmp43_ = _attr_it;
			_tmp44_ = b_attributes_iterator_get (_tmp43_);
			attr = _tmp44_;
			_tmp45_ = attr;
			_tmp46_ = b_attribute_get_name (_tmp45_);
			_tmp47_ = _tmp46_;
			_tmp48_ = g_strcmp0 (_tmp47_, "x") == 0;
			_g_free0 (_tmp47_);
			if (_tmp48_) {
				BirdFontBackgroundImage* _tmp49_;
				BAttribute* _tmp50_;
				gchar* _tmp51_;
				gchar* _tmp52_;
				_tmp49_ = img;
				_tmp50_ = attr;
				_tmp51_ = b_attribute_get_content (_tmp50_);
				_tmp52_ = _tmp51_;
				_tmp49_->img_x = double_parse (_tmp52_);
				_g_free0 (_tmp52_);
			}
			_tmp53_ = attr;
			_tmp54_ = b_attribute_get_name (_tmp53_);
			_tmp55_ = _tmp54_;
			_tmp56_ = g_strcmp0 (_tmp55_, "y") == 0;
			_g_free0 (_tmp55_);
			if (_tmp56_) {
				BirdFontBackgroundImage* _tmp57_;
				BAttribute* _tmp58_;
				gchar* _tmp59_;
				gchar* _tmp60_;
				_tmp57_ = img;
				_tmp58_ = attr;
				_tmp59_ = b_attribute_get_content (_tmp58_);
				_tmp60_ = _tmp59_;
				_tmp57_->img_y = double_parse (_tmp60_);
				_g_free0 (_tmp60_);
			}
			_tmp61_ = attr;
			_tmp62_ = b_attribute_get_name (_tmp61_);
			_tmp63_ = _tmp62_;
			_tmp64_ = g_strcmp0 (_tmp63_, "scale_x") == 0;
			_g_free0 (_tmp63_);
			if (_tmp64_) {
				BirdFontBackgroundImage* _tmp65_;
				BAttribute* _tmp66_;
				gchar* _tmp67_;
				gchar* _tmp68_;
				_tmp65_ = img;
				_tmp66_ = attr;
				_tmp67_ = b_attribute_get_content (_tmp66_);
				_tmp68_ = _tmp67_;
				bird_font_background_image_set_img_scale_x (_tmp65_, double_parse (_tmp68_));
				_g_free0 (_tmp68_);
			}
			_tmp69_ = attr;
			_tmp70_ = b_attribute_get_name (_tmp69_);
			_tmp71_ = _tmp70_;
			_tmp72_ = g_strcmp0 (_tmp71_, "scale_y") == 0;
			_g_free0 (_tmp71_);
			if (_tmp72_) {
				BirdFontBackgroundImage* _tmp73_;
				BAttribute* _tmp74_;
				gchar* _tmp75_;
				gchar* _tmp76_;
				_tmp73_ = img;
				_tmp74_ = attr;
				_tmp75_ = b_attribute_get_content (_tmp74_);
				_tmp76_ = _tmp75_;
				bird_font_background_image_set_img_scale_y (_tmp73_, double_parse (_tmp76_));
				_g_free0 (_tmp76_);
			}
			_tmp77_ = attr;
			_tmp78_ = b_attribute_get_name (_tmp77_);
			_tmp79_ = _tmp78_;
			_tmp80_ = g_strcmp0 (_tmp79_, "rotation") == 0;
			_g_free0 (_tmp79_);
			if (_tmp80_) {
				BirdFontBackgroundImage* _tmp81_;
				BAttribute* _tmp82_;
				gchar* _tmp83_;
				gchar* _tmp84_;
				_tmp81_ = img;
				_tmp82_ = attr;
				_tmp83_ = b_attribute_get_content (_tmp82_);
				_tmp84_ = _tmp83_;
				_tmp81_->img_rotation = double_parse (_tmp84_);
				_g_free0 (_tmp84_);
			}
			_g_object_unref0 (attr);
		}
		_g_object_unref0 (_attr_it);
	}
	_tmp85_ = img;
	_tmp86_ = img;
	_tmp87_ = img;
	bird_font_background_image_set_position (_tmp85_, _tmp86_->img_x, _tmp87_->img_y);
	_g_object_unref0 (img_file);
	_g_object_unref0 (new_img);
	_g_object_unref0 (img);
}

static Block8Data*
block8_data_ref (Block8Data* _data8_)
{
	g_atomic_int_inc (&_data8_->_ref_count_);
	return _data8_;
}

static void
block8_data_unref (void * _userdata_)
{
	Block8Data* _data8_;
	_data8_ = (Block8Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data8_->_ref_count_)) {
		BirdFontBirdFontFile* self;
		self = _data8_->self;
		_g_object_unref0 (_data8_->os);
		_g_object_unref0 (self);
		g_slice_free (Block8Data, _data8_);
	}
}

static void
__lambda337_ (Block8Data* _data8_,
              const gchar* subst,
              const gchar* liga)
{
	BirdFontBirdFontFile* self;
	GError* _inner_error0_ = NULL;
	self = _data8_->self;
	g_return_if_fail (subst != NULL);
	g_return_if_fail (liga != NULL);
	{
		gchar* lig = NULL;
		gchar* _tmp0_;
		gchar* sequence = NULL;
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		const gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		_tmp0_ = bird_font_bird_font_file_serialize_attribute (liga);
		lig = _tmp0_;
		_tmp1_ = bird_font_bird_font_file_encode (subst);
		_tmp2_ = _tmp1_;
		_tmp3_ = bird_font_bird_font_file_serialize_attribute (_tmp2_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		sequence = _tmp4_;
		_tmp5_ = bird_font_bird_font_file_encode (sequence);
		_tmp6_ = _tmp5_;
		_tmp7_ = string_to_string (_tmp6_);
		_tmp8_ = bird_font_bird_font_file_encode (lig);
		_tmp9_ = _tmp8_;
		_tmp10_ = string_to_string (_tmp9_);
		_tmp11_ = g_strconcat ("<ligature sequence=\"", _tmp7_, "\" replacement=\"", _tmp10_, "\"/>\n", NULL);
		_tmp12_ = _tmp11_;
		g_data_output_stream_put_string (_data8_->os, _tmp12_, NULL, &_inner_error0_);
		_g_free0 (_tmp12_);
		_g_free0 (_tmp9_);
		_g_free0 (_tmp6_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (sequence);
			_g_free0 (lig);
			if (_inner_error0_->domain == G_IO_ERROR) {
				goto __catch0_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_g_free0 (sequence);
		_g_free0 (lig);
	}
	goto __finally0;
	__catch0_g_io_error:
	{
		GError* e = NULL;
		GError* _tmp13_;
		const gchar* _tmp14_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp13_ = e;
		_tmp14_ = _tmp13_->message;
		g_warning ("BirdFontFile.vala:1890: %s", _tmp14_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda337__bird_font_ligatures_ligature_iterator (const gchar* substitution,
                                                     const gchar* ligature,
                                                     gpointer self)
{
	__lambda337_ (self, substitution, ligature);
}

void
bird_font_bird_font_file_write_ligatures (BirdFontBirdFontFile* self,
                                          GDataOutputStream* os)
{
	Block8Data* _data8_;
	GDataOutputStream* _tmp0_;
	BirdFontLigatures* ligatures = NULL;
	BirdFontFont* _tmp1_;
	BirdFontLigatures* _tmp2_;
	BirdFontLigatures* _tmp3_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (os != NULL);
	_data8_ = g_slice_new0 (Block8Data);
	_data8_->_ref_count_ = 1;
	_data8_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (os);
	_g_object_unref0 (_data8_->os);
	_data8_->os = _tmp0_;
	_tmp1_ = self->priv->font;
	_tmp2_ = bird_font_font_get_ligatures (_tmp1_);
	ligatures = _tmp2_;
	_tmp3_ = ligatures;
	bird_font_ligatures_get_ligatures (_tmp3_, ___lambda337__bird_font_ligatures_ligature_iterator, _data8_);
	{
		{
			GeeArrayList* _c_list = NULL;
			BirdFontLigatures* _tmp4_;
			GeeArrayList* _tmp5_;
			gint _c_size = 0;
			GeeArrayList* _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			gint _c_index = 0;
			_tmp4_ = ligatures;
			_tmp5_ = _tmp4_->contextual_ligatures;
			_c_list = _tmp5_;
			_tmp6_ = _c_list;
			_tmp7_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp6_);
			_tmp8_ = _tmp7_;
			_c_size = _tmp8_;
			_c_index = -1;
			while (TRUE) {
				gint _tmp9_;
				gint _tmp10_;
				BirdFontContextualLigature* c = NULL;
				GeeArrayList* _tmp11_;
				gpointer _tmp12_;
				BirdFontContextualLigature* _tmp13_;
				const gchar* _tmp14_;
				const gchar* _tmp15_;
				gchar* _tmp16_;
				gchar* _tmp17_;
				gchar* _tmp18_;
				gchar* _tmp19_;
				BirdFontContextualLigature* _tmp20_;
				const gchar* _tmp21_;
				const gchar* _tmp22_;
				gchar* _tmp23_;
				gchar* _tmp24_;
				gchar* _tmp25_;
				gchar* _tmp26_;
				BirdFontContextualLigature* _tmp27_;
				const gchar* _tmp28_;
				const gchar* _tmp29_;
				gchar* _tmp30_;
				gchar* _tmp31_;
				gchar* _tmp32_;
				gchar* _tmp33_;
				BirdFontContextualLigature* _tmp34_;
				const gchar* _tmp35_;
				const gchar* _tmp36_;
				gchar* _tmp37_;
				gchar* _tmp38_;
				gchar* _tmp39_;
				gchar* _tmp40_;
				_c_index = _c_index + 1;
				_tmp9_ = _c_index;
				_tmp10_ = _c_size;
				if (!(_tmp9_ < _tmp10_)) {
					break;
				}
				_tmp11_ = _c_list;
				_tmp12_ = gee_abstract_list_get ((GeeAbstractList*) _tmp11_, _c_index);
				c = (BirdFontContextualLigature*) _tmp12_;
				_tmp13_ = c;
				_tmp14_ = _tmp13_->ligatures;
				_tmp15_ = string_to_string (_tmp14_);
				_tmp16_ = g_strconcat ("ligature=\"", _tmp15_, "\" ", NULL);
				_tmp17_ = _tmp16_;
				_tmp18_ = g_strconcat ("<contextual ", _tmp17_, NULL);
				_tmp19_ = _tmp18_;
				_tmp20_ = c;
				_tmp21_ = _tmp20_->backtrack;
				_tmp22_ = string_to_string (_tmp21_);
				_tmp23_ = g_strconcat ("backtrack=\"", _tmp22_, "\" ", NULL);
				_tmp24_ = _tmp23_;
				_tmp25_ = g_strconcat (_tmp19_, _tmp24_, NULL);
				_tmp26_ = _tmp25_;
				_tmp27_ = c;
				_tmp28_ = _tmp27_->input;
				_tmp29_ = string_to_string (_tmp28_);
				_tmp30_ = g_strconcat ("input=\"", _tmp29_, "\" ", NULL);
				_tmp31_ = _tmp30_;
				_tmp32_ = g_strconcat (_tmp26_, _tmp31_, NULL);
				_tmp33_ = _tmp32_;
				_tmp34_ = c;
				_tmp35_ = _tmp34_->lookahead;
				_tmp36_ = string_to_string (_tmp35_);
				_tmp37_ = g_strconcat ("lookahead=\"", _tmp36_, "\" />\n", NULL);
				_tmp38_ = _tmp37_;
				_tmp39_ = g_strconcat (_tmp33_, _tmp38_, NULL);
				_tmp40_ = _tmp39_;
				g_data_output_stream_put_string (_data8_->os, _tmp40_, NULL, &_inner_error0_);
				_g_free0 (_tmp40_);
				_g_free0 (_tmp38_);
				_g_free0 (_tmp33_);
				_g_free0 (_tmp31_);
				_g_free0 (_tmp26_);
				_g_free0 (_tmp24_);
				_g_free0 (_tmp19_);
				_g_free0 (_tmp17_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_object_unref0 (c);
					goto __catch0_g_error;
				}
				_g_object_unref0 (c);
			}
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp41_;
		const gchar* _tmp42_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp41_ = e;
		_tmp42_ = _tmp41_->message;
		g_warning ("BirdFontFile.vala:1903: %s", _tmp42_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (ligatures);
		block8_data_unref (_data8_);
		_data8_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (ligatures);
	block8_data_unref (_data8_);
	_data8_ = NULL;
}

void
bird_font_bird_font_file_parse_contectual_ligature (BirdFontBirdFontFile* self,
                                                    BTag* t)
{
	gchar* ligature = NULL;
	gchar* _tmp0_;
	gchar* backtrack = NULL;
	gchar* _tmp1_;
	gchar* input = NULL;
	gchar* _tmp2_;
	gchar* lookahead = NULL;
	gchar* _tmp3_;
	BirdFontLigatures* ligatures = NULL;
	BirdFontFont* _tmp43_;
	BirdFontLigatures* _tmp44_;
	const gchar* _tmp45_;
	const gchar* _tmp46_;
	const gchar* _tmp47_;
	const gchar* _tmp48_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (t != NULL);
	_tmp0_ = g_strdup ("");
	ligature = _tmp0_;
	_tmp1_ = g_strdup ("");
	backtrack = _tmp1_;
	_tmp2_ = g_strdup ("");
	input = _tmp2_;
	_tmp3_ = g_strdup ("");
	lookahead = _tmp3_;
	{
		BAttributesIterator* _a_it = NULL;
		BAttributes* _tmp4_;
		BAttributes* _tmp5_;
		BAttributesIterator* _tmp6_;
		BAttributesIterator* _tmp7_;
		_tmp4_ = b_tag_get_attributes (t);
		_tmp5_ = _tmp4_;
		_tmp6_ = b_attributes_iterator (_tmp5_);
		_tmp7_ = _tmp6_;
		_g_object_unref0 (_tmp5_);
		_a_it = _tmp7_;
		while (TRUE) {
			BAttributesIterator* _tmp8_;
			BAttribute* a = NULL;
			BAttributesIterator* _tmp9_;
			BAttribute* _tmp10_;
			BAttribute* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			gboolean _tmp14_;
			BAttribute* _tmp19_;
			gchar* _tmp20_;
			gchar* _tmp21_;
			gboolean _tmp22_;
			BAttribute* _tmp27_;
			gchar* _tmp28_;
			gchar* _tmp29_;
			gboolean _tmp30_;
			BAttribute* _tmp35_;
			gchar* _tmp36_;
			gchar* _tmp37_;
			gboolean _tmp38_;
			_tmp8_ = _a_it;
			if (!b_attributes_iterator_next (_tmp8_)) {
				break;
			}
			_tmp9_ = _a_it;
			_tmp10_ = b_attributes_iterator_get (_tmp9_);
			a = _tmp10_;
			_tmp11_ = a;
			_tmp12_ = b_attribute_get_name (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = g_strcmp0 (_tmp13_, "ligature") == 0;
			_g_free0 (_tmp13_);
			if (_tmp14_) {
				BAttribute* _tmp15_;
				gchar* _tmp16_;
				gchar* _tmp17_;
				gchar* _tmp18_;
				_tmp15_ = a;
				_tmp16_ = b_attribute_get_content (_tmp15_);
				_tmp17_ = _tmp16_;
				_tmp18_ = bird_font_bird_font_file_decode (_tmp17_);
				_g_free0 (ligature);
				ligature = _tmp18_;
				_g_free0 (_tmp17_);
			}
			_tmp19_ = a;
			_tmp20_ = b_attribute_get_name (_tmp19_);
			_tmp21_ = _tmp20_;
			_tmp22_ = g_strcmp0 (_tmp21_, "backtrack") == 0;
			_g_free0 (_tmp21_);
			if (_tmp22_) {
				BAttribute* _tmp23_;
				gchar* _tmp24_;
				gchar* _tmp25_;
				gchar* _tmp26_;
				_tmp23_ = a;
				_tmp24_ = b_attribute_get_content (_tmp23_);
				_tmp25_ = _tmp24_;
				_tmp26_ = bird_font_bird_font_file_decode (_tmp25_);
				_g_free0 (backtrack);
				backtrack = _tmp26_;
				_g_free0 (_tmp25_);
			}
			_tmp27_ = a;
			_tmp28_ = b_attribute_get_name (_tmp27_);
			_tmp29_ = _tmp28_;
			_tmp30_ = g_strcmp0 (_tmp29_, "input") == 0;
			_g_free0 (_tmp29_);
			if (_tmp30_) {
				BAttribute* _tmp31_;
				gchar* _tmp32_;
				gchar* _tmp33_;
				gchar* _tmp34_;
				_tmp31_ = a;
				_tmp32_ = b_attribute_get_content (_tmp31_);
				_tmp33_ = _tmp32_;
				_tmp34_ = bird_font_bird_font_file_decode (_tmp33_);
				_g_free0 (input);
				input = _tmp34_;
				_g_free0 (_tmp33_);
			}
			_tmp35_ = a;
			_tmp36_ = b_attribute_get_name (_tmp35_);
			_tmp37_ = _tmp36_;
			_tmp38_ = g_strcmp0 (_tmp37_, "lookahead") == 0;
			_g_free0 (_tmp37_);
			if (_tmp38_) {
				BAttribute* _tmp39_;
				gchar* _tmp40_;
				gchar* _tmp41_;
				gchar* _tmp42_;
				_tmp39_ = a;
				_tmp40_ = b_attribute_get_content (_tmp39_);
				_tmp41_ = _tmp40_;
				_tmp42_ = bird_font_bird_font_file_decode (_tmp41_);
				_g_free0 (lookahead);
				lookahead = _tmp42_;
				_g_free0 (_tmp41_);
			}
			_g_object_unref0 (a);
		}
		_g_object_unref0 (_a_it);
	}
	_tmp43_ = self->priv->font;
	_tmp44_ = bird_font_font_get_ligatures (_tmp43_);
	_g_object_unref0 (ligatures);
	ligatures = _tmp44_;
	_tmp45_ = ligature;
	_tmp46_ = backtrack;
	_tmp47_ = input;
	_tmp48_ = lookahead;
	bird_font_ligatures_add_contextual_ligature (ligatures, _tmp45_, _tmp46_, _tmp47_, _tmp48_);
	_g_object_unref0 (ligatures);
	_g_free0 (lookahead);
	_g_free0 (input);
	_g_free0 (backtrack);
	_g_free0 (ligature);
}

void
bird_font_bird_font_file_parse_ligature (BirdFontBirdFontFile* self,
                                         BTag* t)
{
	gchar* sequence = NULL;
	gchar* _tmp0_;
	gchar* ligature = NULL;
	gchar* _tmp1_;
	BirdFontLigatures* ligatures = NULL;
	BirdFontFont* _tmp25_;
	BirdFontLigatures* _tmp26_;
	const gchar* _tmp27_;
	const gchar* _tmp28_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (t != NULL);
	_tmp0_ = g_strdup ("");
	sequence = _tmp0_;
	_tmp1_ = g_strdup ("");
	ligature = _tmp1_;
	{
		BAttributesIterator* _a_it = NULL;
		BAttributes* _tmp2_;
		BAttributes* _tmp3_;
		BAttributesIterator* _tmp4_;
		BAttributesIterator* _tmp5_;
		_tmp2_ = b_tag_get_attributes (t);
		_tmp3_ = _tmp2_;
		_tmp4_ = b_attributes_iterator (_tmp3_);
		_tmp5_ = _tmp4_;
		_g_object_unref0 (_tmp3_);
		_a_it = _tmp5_;
		while (TRUE) {
			BAttributesIterator* _tmp6_;
			BAttribute* a = NULL;
			BAttributesIterator* _tmp7_;
			BAttribute* _tmp8_;
			BAttribute* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			gboolean _tmp12_;
			BAttribute* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			gboolean _tmp20_;
			_tmp6_ = _a_it;
			if (!b_attributes_iterator_next (_tmp6_)) {
				break;
			}
			_tmp7_ = _a_it;
			_tmp8_ = b_attributes_iterator_get (_tmp7_);
			a = _tmp8_;
			_tmp9_ = a;
			_tmp10_ = b_attribute_get_name (_tmp9_);
			_tmp11_ = _tmp10_;
			_tmp12_ = g_strcmp0 (_tmp11_, "sequence") == 0;
			_g_free0 (_tmp11_);
			if (_tmp12_) {
				BAttribute* _tmp13_;
				gchar* _tmp14_;
				gchar* _tmp15_;
				gchar* _tmp16_;
				_tmp13_ = a;
				_tmp14_ = b_attribute_get_content (_tmp13_);
				_tmp15_ = _tmp14_;
				_tmp16_ = bird_font_bird_font_file_decode (_tmp15_);
				_g_free0 (sequence);
				sequence = _tmp16_;
				_g_free0 (_tmp15_);
			}
			_tmp17_ = a;
			_tmp18_ = b_attribute_get_name (_tmp17_);
			_tmp19_ = _tmp18_;
			_tmp20_ = g_strcmp0 (_tmp19_, "replacement") == 0;
			_g_free0 (_tmp19_);
			if (_tmp20_) {
				BAttribute* _tmp21_;
				gchar* _tmp22_;
				gchar* _tmp23_;
				gchar* _tmp24_;
				_tmp21_ = a;
				_tmp22_ = b_attribute_get_content (_tmp21_);
				_tmp23_ = _tmp22_;
				_tmp24_ = bird_font_bird_font_file_decode (_tmp23_);
				_g_free0 (ligature);
				ligature = _tmp24_;
				_g_free0 (_tmp23_);
			}
			_g_object_unref0 (a);
		}
		_g_object_unref0 (_a_it);
	}
	_tmp25_ = self->priv->font;
	_tmp26_ = bird_font_font_get_ligatures (_tmp25_);
	_g_object_unref0 (ligatures);
	ligatures = _tmp26_;
	_tmp27_ = sequence;
	_tmp28_ = ligature;
	bird_font_ligatures_add_ligature (ligatures, _tmp27_, _tmp28_);
	_g_object_unref0 (ligatures);
	_g_free0 (ligature);
	_g_free0 (sequence);
}

static gint
string_index_of (const gchar* self,
                 const gchar* needle,
                 gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

gchar*
bird_font_bird_font_file_round (gdouble p,
                                gint decimals)
{
	gchar* v = NULL;
	gchar* _tmp0_;
	gchar* c = NULL;
	gchar* _tmp1_;
	gint c_length1;
	gint _c_size_;
	gchar* _tmp2_;
	gint _tmp2__length1;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	const gchar* _tmp11_;
	gboolean _tmp13_ = FALSE;
	const gchar* _tmp14_;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* result;
	_tmp0_ = g_strdup ("");
	v = _tmp0_;
	_tmp1_ = g_new0 (gchar, 501);
	c = _tmp1_;
	c_length1 = 501;
	_c_size_ = c_length1;
	_tmp2_ = c;
	_tmp2__length1 = c_length1;
	_tmp3_ = g_strdup_printf ("%i", decimals);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strconcat ("%.", _tmp4_, "f", NULL);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_ascii_formatd (_tmp2_, (gint) _tmp2__length1, _tmp6_, p);
	_tmp8_ = g_strdup (_tmp7_);
	_g_free0 (v);
	v = _tmp8_;
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	_tmp9_ = v;
	_tmp10_ = string_replace (_tmp9_, ",", ".");
	_g_free0 (v);
	v = _tmp10_;
	_tmp11_ = v;
	if (string_index_of (_tmp11_, "e", 0) != -1) {
		gchar* _tmp12_;
		_tmp12_ = g_strdup ("0.0");
		_g_free0 (v);
		v = _tmp12_;
	}
	_tmp14_ = v;
	if (string_index_of (_tmp14_, "-", 0) == 0) {
		const gchar* _tmp15_;
		_tmp15_ = v;
		_tmp13_ = double_parse (_tmp15_) == ((gdouble) -0);
	} else {
		_tmp13_ = FALSE;
	}
	if (_tmp13_) {
		gchar* _tmp16_;
		_tmp16_ = g_strdup ("0");
		_g_free0 (v);
		v = _tmp16_;
	}
	_tmp17_ = v;
	_tmp18_ = bird_font_bird_font_file_remove_last_zeros (_tmp17_);
	result = _tmp18_;
	c = (g_free (c), NULL);
	_g_free0 (v);
	return result;
}

gchar*
bird_font_bird_font_file_remove_last_zeros (const gchar* value)
{
	gchar* v = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (value != NULL, NULL);
	_tmp0_ = g_strdup (value);
	v = _tmp0_;
	_tmp1_ = v;
	if (string_index_of (_tmp1_, ".", 0) != -1) {
		const gchar* _tmp10_;
		while (TRUE) {
			const gchar* _tmp2_;
			const gchar* _tmp3_;
			const gchar* _tmp4_;
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			gchar* _tmp9_;
			_tmp2_ = v;
			if (!g_str_has_suffix (_tmp2_, "0")) {
				break;
			}
			_tmp3_ = v;
			_tmp4_ = v;
			_tmp5_ = strlen (_tmp4_);
			_tmp6_ = _tmp5_;
			_tmp7_ = strlen ("0");
			_tmp8_ = _tmp7_;
			_tmp9_ = string_substring (_tmp3_, (glong) 0, (glong) (_tmp6_ - _tmp8_));
			_g_free0 (v);
			v = _tmp9_;
		}
		_tmp10_ = v;
		if (g_str_has_suffix (_tmp10_, ".")) {
			const gchar* _tmp11_;
			const gchar* _tmp12_;
			gint _tmp13_;
			gint _tmp14_;
			gint _tmp15_;
			gint _tmp16_;
			gchar* _tmp17_;
			_tmp11_ = v;
			_tmp12_ = v;
			_tmp13_ = strlen (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = strlen (".");
			_tmp16_ = _tmp15_;
			_tmp17_ = string_substring (_tmp11_, (glong) 0, (glong) (_tmp14_ - _tmp16_));
			_g_free0 (v);
			v = _tmp17_;
		}
	}
	result = v;
	return result;
}

gchar*
bird_font_bird_font_file_decode (const gchar* s)
{
	gchar* t = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* result;
	g_return_val_if_fail (s != NULL, NULL);
	_tmp0_ = string_replace (s, "&quot;", "\"");
	_g_free0 (t);
	t = _tmp0_;
	_tmp1_ = t;
	_tmp2_ = string_replace (_tmp1_, "&apos;", "'");
	_g_free0 (t);
	t = _tmp2_;
	_tmp3_ = t;
	_tmp4_ = string_replace (_tmp3_, "&lt;", "<");
	_g_free0 (t);
	t = _tmp4_;
	_tmp5_ = t;
	_tmp6_ = string_replace (_tmp5_, "&gt;", ">");
	_g_free0 (t);
	t = _tmp6_;
	_tmp7_ = t;
	_tmp8_ = string_replace (_tmp7_, "&amp;", "&");
	_g_free0 (t);
	t = _tmp8_;
	result = t;
	return result;
}

/**
 * Replace ", ' < > and & with encoded characters.
 */
gchar*
bird_font_bird_font_file_encode (const gchar* s)
{
	gchar* t = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* result;
	g_return_val_if_fail (s != NULL, NULL);
	_tmp0_ = string_replace (s, "&", "&amp;");
	_g_free0 (t);
	t = _tmp0_;
	_tmp1_ = t;
	_tmp2_ = string_replace (_tmp1_, "\"", "&quot;");
	_g_free0 (t);
	t = _tmp2_;
	_tmp3_ = t;
	_tmp4_ = string_replace (_tmp3_, "'", "&apos;");
	_g_free0 (t);
	t = _tmp4_;
	_tmp5_ = t;
	_tmp6_ = string_replace (_tmp5_, "<", "&lt;");
	_g_free0 (t);
	t = _tmp6_;
	_tmp7_ = t;
	_tmp8_ = string_replace (_tmp7_, ">", "&gt;");
	_g_free0 (t);
	t = _tmp8_;
	result = t;
	return result;
}

static void
bird_font_bird_font_file_class_init (BirdFontBirdFontFileClass * klass,
                                     gpointer klass_data)
{
	bird_font_bird_font_file_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BirdFontBirdFontFile_private_offset);
	G_OBJECT_CLASS (klass)->finalize = bird_font_bird_font_file_finalize;
}

static void
bird_font_bird_font_file_instance_init (BirdFontBirdFontFile * self,
                                        gpointer klass)
{
	GeeArrayList* _tmp0_;
	self->priv = bird_font_bird_font_file_get_instance_private (self);
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	self->priv->written_images = _tmp0_;
}

static void
bird_font_bird_font_file_finalize (GObject * obj)
{
	BirdFontBirdFontFile * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BIRD_FONT_TYPE_BIRD_FONT_FILE, BirdFontBirdFontFile);
	_g_object_unref0 (self->priv->font);
	_g_object_unref0 (self->priv->written_images);
	G_OBJECT_CLASS (bird_font_bird_font_file_parent_class)->finalize (obj);
}

/** 
 * BirdFont file format. This class can parse both the old ffi format 
 * and the new bf format.
 */
static GType
bird_font_bird_font_file_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BirdFontBirdFontFileClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bird_font_bird_font_file_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BirdFontBirdFontFile), 0, (GInstanceInitFunc) bird_font_bird_font_file_instance_init, NULL };
	GType bird_font_bird_font_file_type_id;
	bird_font_bird_font_file_type_id = g_type_register_static (G_TYPE_OBJECT, "BirdFontBirdFontFile", &g_define_type_info, 0);
	BirdFontBirdFontFile_private_offset = g_type_add_instance_private (bird_font_bird_font_file_type_id, sizeof (BirdFontBirdFontFilePrivate));
	return bird_font_bird_font_file_type_id;
}

GType
bird_font_bird_font_file_get_type (void)
{
	static volatile gsize bird_font_bird_font_file_type_id__once = 0;
	if (g_once_init_enter (&bird_font_bird_font_file_type_id__once)) {
		GType bird_font_bird_font_file_type_id;
		bird_font_bird_font_file_type_id = bird_font_bird_font_file_get_type_once ();
		g_once_init_leave (&bird_font_bird_font_file_type_id__once, bird_font_bird_font_file_type_id);
	}
	return bird_font_bird_font_file_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

