#include <gio/gio.h>

#if defined (__ELF__) && ( __GNUC__ > 2 || (__GNUC__ == 2 && __GNUC_MINOR__ >= 6))
# define SECTION __attribute__ ((section (".gresource.balsa_ab"), aligned (sizeof(void *) > 8 ? sizeof(void *) : 8)))
#else
# define SECTION
#endif

static const SECTION union { const guint8 data[701]; const double alignment; void * const ptr;}  balsa_ab_resource_data = {
  "\107\126\141\162\151\141\156\164\000\000\000\000\000\000\000\000"
  "\030\000\000\000\254\000\000\000\000\000\000\050\005\000\000\000"
  "\000\000\000\000\002\000\000\000\002\000\000\000\005\000\000\000"
  "\005\000\000\000\113\120\220\013\001\000\000\000\254\000\000\000"
  "\004\000\114\000\260\000\000\000\264\000\000\000\324\265\002\000"
  "\377\377\377\377\264\000\000\000\001\000\114\000\270\000\000\000"
  "\274\000\000\000\012\067\312\360\004\000\000\000\274\000\000\000"
  "\012\000\166\000\310\000\000\000\244\002\000\000\124\214\331\133"
  "\000\000\000\000\244\002\000\000\010\000\114\000\254\002\000\000"
  "\260\002\000\000\151\377\210\203\003\000\000\000\260\002\000\000"
  "\010\000\114\000\270\002\000\000\274\002\000\000\157\162\147\057"
  "\003\000\000\000\057\000\000\000\000\000\000\000\141\142\055\155"
  "\141\151\156\056\165\151\000\000\134\015\000\000\001\000\000\000"
  "\170\332\325\227\115\157\302\060\014\206\357\373\025\121\117\354"
  "\300\270\117\245\022\033\214\115\232\046\046\115\273\042\227\032"
  "\026\055\115\112\222\016\370\367\113\001\061\076\222\006\130\213"
  "\104\117\305\161\354\327\117\235\326\204\224\153\224\143\030\141"
  "\164\103\314\025\246\310\163\102\223\166\120\334\304\040\203\225"
  "\175\271\246\362\170\263\074\246\014\233\305\257\055\207\245\023"
  "\150\055\151\234\153\044\034\122\154\007\014\142\144\001\321\022"
  "\270\142\240\041\146\306\270\100\025\104\303\047\023\043\154\155"
  "\066\354\005\122\070\322\124\360\135\353\266\216\303\225\022\001"
  "\126\337\342\072\024\346\164\035\011\003\153\256\333\001\044\211"
  "\104\245\110\054\304\167\231\173\152\144\152\325\016\076\326\071"
  "\204\124\367\044\005\312\311\212\243\306\224\064\311\033\316\310"
  "\116\304\150\150\114\116\060\233\102\213\355\221\063\373\251\034"
  "\354\054\242\341\347\043\310\204\164\326\372\036\214\076\322\350"
  "\163\221\142\141\277\365\252\264\112\201\345\223\015\242\031\345"
  "\167\313\106\342\070\153\376\214\114\100\177\325\055\167\331\027"
  "\042\322\233\233\043\303\201\221\151\216\162\101\032\100\062\051"
  "\046\022\322\052\151\340\072\311\065\000\171\355\276\074\355\164"
  "\110\205\034\130\102\307\327\301\240\063\250\217\001\144\327\300"
  "\240\077\350\325\205\140\222\341\331\004\302\226\363\203\121\002"
  "\346\377\337\221\150\070\220\042\103\251\051\052\277\170\057\206"
  "\354\270\140\116\012\365\226\332\105\206\032\053\050\063\361\007"
  "\262\225\150\036\262\155\136\050\231\042\352\345\361\236\123\135"
  "\001\215\251\057\314\221\054\054\147\300\076\106\235\062\277\365"
  "\270\226\013\367\000\347\350\303\023\340\332\222\026\323\122\171"
  "\142\057\131\054\266\027\257\025\267\166\033\325\172\352\131\035"
  "\234\152\112\362\234\235\375\252\152\151\212\147\144\331\245\173"
  "\242\023\213\134\237\017\357\313\110\156\102\151\014\017\272\260"
  "\265\272\067\156\177\377\247\176\001\364\310\203\026\000\050\165"
  "\165\141\171\051\144\145\163\153\164\157\160\057\004\000\000\000"
  "\102\141\154\163\141\101\142\057\002\000\000\000" };

static GStaticResource static_resource = { balsa_ab_resource_data.data, sizeof (balsa_ab_resource_data.data) - 1 /* nul terminator */, NULL, NULL, NULL };

G_GNUC_INTERNAL
GResource *balsa_ab_get_resource (void);
GResource *balsa_ab_get_resource (void)
{
  return g_static_resource_get_resource (&static_resource);
}
/* GLIB - Library of useful routines for C programming
 * Copyright (C) 1995-1997  Peter Mattis, Spencer Kimball and Josh MacDonald
 *
 * SPDX-License-Identifier: LGPL-2.1-or-later
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, see <http://www.gnu.org/licenses/>.
 */

/*
 * Modified by the GLib Team and others 1997-2000.  See the AUTHORS
 * file for a list of people on the GLib Team.  See the ChangeLog
 * files for a list of changes.  These files are distributed with
 * GLib at ftp://ftp.gtk.org/pub/gtk/.
 */

#ifndef __G_CONSTRUCTOR_H__
#define __G_CONSTRUCTOR_H__

/*
  If G_HAS_CONSTRUCTORS is true then the compiler support *both* constructors and
  destructors, in a usable way, including e.g. on library unload. If not you're on
  your own.

  Some compilers need #pragma to handle this, which does not work with macros,
  so the way you need to use this is (for constructors):

  #ifdef G_DEFINE_CONSTRUCTOR_NEEDS_PRAGMA
  #pragma G_DEFINE_CONSTRUCTOR_PRAGMA_ARGS(my_constructor)
  #endif
  G_DEFINE_CONSTRUCTOR(my_constructor)
  static void my_constructor(void) {
   ...
  }

*/

#ifndef __GTK_DOC_IGNORE__

#if  __GNUC__ > 2 || (__GNUC__ == 2 && __GNUC_MINOR__ >= 7)

#define G_HAS_CONSTRUCTORS 1

#define G_DEFINE_CONSTRUCTOR(_func) static void __attribute__((constructor)) _func (void);
#define G_DEFINE_DESTRUCTOR(_func) static void __attribute__((destructor)) _func (void);

#elif defined (_MSC_VER)

/*
 * Only try to include gslist.h if not already included via glib.h,
 * so that items using gconstructor.h outside of GLib (such as
 * GResources) continue to build properly.
 */
#ifndef __G_LIB_H__
#include "gslist.h"
#endif

#include <stdlib.h>

#define G_HAS_CONSTRUCTORS 1

/* We do some weird things to avoid the constructors being optimized
 * away on VS2015 if WholeProgramOptimization is enabled. First we
 * make a reference to the array from the wrapper to make sure its
 * references. Then we use a pragma to make sure the wrapper function
 * symbol is always included at the link stage. Also, the symbols
 * need to be extern (but not dllexport), even though they are not
 * really used from another object file.
 */

/* We need to account for differences between the mangling of symbols
 * for x86 and x64/ARM/ARM64 programs, as symbols on x86 are prefixed
 * with an underscore but symbols on x64/ARM/ARM64 are not.
 */
#ifdef _M_IX86
#define G_MSVC_SYMBOL_PREFIX "_"
#else
#define G_MSVC_SYMBOL_PREFIX ""
#endif

#define G_DEFINE_CONSTRUCTOR(_func) G_MSVC_CTOR (_func, G_MSVC_SYMBOL_PREFIX)
#define G_DEFINE_DESTRUCTOR(_func) G_MSVC_DTOR (_func, G_MSVC_SYMBOL_PREFIX)

#define G_MSVC_CTOR(_func,_sym_prefix) \
  static void _func(void); \
  extern int (* _array ## _func)(void);              \
  int _func ## _wrapper(void);              \
  int _func ## _wrapper(void) { _func(); g_slist_find (NULL,  _array ## _func); return 0; } \
  __pragma(comment(linker,"/include:" _sym_prefix # _func "_wrapper")) \
  __pragma(section(".CRT$XCU",read)) \
  __declspec(allocate(".CRT$XCU")) int (* _array ## _func)(void) = _func ## _wrapper;

#define G_MSVC_DTOR(_func,_sym_prefix) \
  static void _func(void); \
  extern int (* _array ## _func)(void);              \
  int _func ## _constructor(void);              \
  int _func ## _constructor(void) { atexit (_func); g_slist_find (NULL,  _array ## _func); return 0; } \
   __pragma(comment(linker,"/include:" _sym_prefix # _func "_constructor")) \
  __pragma(section(".CRT$XCU",read)) \
  __declspec(allocate(".CRT$XCU")) int (* _array ## _func)(void) = _func ## _constructor;

#elif defined(__SUNPRO_C)

/* This is not tested, but i believe it should work, based on:
 * http://opensource.apple.com/source/OpenSSL098/OpenSSL098-35/src/fips/fips_premain.c
 */

#define G_HAS_CONSTRUCTORS 1

#define G_DEFINE_CONSTRUCTOR_NEEDS_PRAGMA 1
#define G_DEFINE_DESTRUCTOR_NEEDS_PRAGMA 1

#define G_DEFINE_CONSTRUCTOR_PRAGMA_ARGS(_func) \
  init(_func)
#define G_DEFINE_CONSTRUCTOR(_func) \
  static void _func(void);

#define G_DEFINE_DESTRUCTOR_PRAGMA_ARGS(_func) \
  fini(_func)
#define G_DEFINE_DESTRUCTOR(_func) \
  static void _func(void);

#else

/* constructors not supported for this compiler */

#endif

#endif /* __GTK_DOC_IGNORE__ */
#endif /* __G_CONSTRUCTOR_H__ */

#ifdef G_HAS_CONSTRUCTORS

#ifdef G_DEFINE_CONSTRUCTOR_NEEDS_PRAGMA
#pragma G_DEFINE_CONSTRUCTOR_PRAGMA_ARGS(balsa_abresource_constructor)
#endif
G_DEFINE_CONSTRUCTOR(balsa_abresource_constructor)
#ifdef G_DEFINE_DESTRUCTOR_NEEDS_PRAGMA
#pragma G_DEFINE_DESTRUCTOR_PRAGMA_ARGS(balsa_abresource_destructor)
#endif
G_DEFINE_DESTRUCTOR(balsa_abresource_destructor)

#else
#warning "Constructor not supported on this compiler, linking in resources will not work"
#endif

static void balsa_abresource_constructor (void)
{
  g_static_resource_init (&static_resource);
}

static void balsa_abresource_destructor (void)
{
  g_static_resource_fini (&static_resource);
}
