
#include "glproc.hpp"
#include "os.hpp"


static EGLBoolean EGLAPIENTRY _fail_eglChooseConfig(EGLDisplay dpy, const EGLint * attrib_list, EGLConfig * configs, EGLint config_size, EGLint * num_config) {
    const char *_name = "eglChooseConfig";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static EGLBoolean EGLAPIENTRY _get_eglChooseConfig(EGLDisplay dpy, const EGLint * attrib_list, EGLConfig * configs, EGLint config_size, EGLint * num_config) {
    PFN_EGLCHOOSECONFIG _ptr;
    _ptr = (PFN_EGLCHOOSECONFIG)_getPublicProcAddress("eglChooseConfig");
    if (!_ptr) {
        _ptr = &_fail_eglChooseConfig;
    }
    _eglChooseConfig = _ptr;
    return _eglChooseConfig(dpy, attrib_list, configs, config_size, num_config);
}

PFN_EGLCHOOSECONFIG _eglChooseConfig = &_get_eglChooseConfig;

static EGLBoolean EGLAPIENTRY _fail_eglCopyBuffers(EGLDisplay dpy, EGLSurface surface, EGLNativePixmapType target) {
    const char *_name = "eglCopyBuffers";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static EGLBoolean EGLAPIENTRY _get_eglCopyBuffers(EGLDisplay dpy, EGLSurface surface, EGLNativePixmapType target) {
    PFN_EGLCOPYBUFFERS _ptr;
    _ptr = (PFN_EGLCOPYBUFFERS)_getPublicProcAddress("eglCopyBuffers");
    if (!_ptr) {
        _ptr = &_fail_eglCopyBuffers;
    }
    _eglCopyBuffers = _ptr;
    return _eglCopyBuffers(dpy, surface, target);
}

PFN_EGLCOPYBUFFERS _eglCopyBuffers = &_get_eglCopyBuffers;

static EGLContext EGLAPIENTRY _fail_eglCreateContext(EGLDisplay dpy, EGLConfig config, EGLContext share_context, const EGLint * attrib_list) {
    const char *_name = "eglCreateContext";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static EGLContext EGLAPIENTRY _get_eglCreateContext(EGLDisplay dpy, EGLConfig config, EGLContext share_context, const EGLint * attrib_list) {
    PFN_EGLCREATECONTEXT _ptr;
    _ptr = (PFN_EGLCREATECONTEXT)_getPublicProcAddress("eglCreateContext");
    if (!_ptr) {
        _ptr = &_fail_eglCreateContext;
    }
    _eglCreateContext = _ptr;
    return _eglCreateContext(dpy, config, share_context, attrib_list);
}

PFN_EGLCREATECONTEXT _eglCreateContext = &_get_eglCreateContext;

static EGLSurface EGLAPIENTRY _fail_eglCreatePbufferSurface(EGLDisplay dpy, EGLConfig config, const EGLint * attrib_list) {
    const char *_name = "eglCreatePbufferSurface";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static EGLSurface EGLAPIENTRY _get_eglCreatePbufferSurface(EGLDisplay dpy, EGLConfig config, const EGLint * attrib_list) {
    PFN_EGLCREATEPBUFFERSURFACE _ptr;
    _ptr = (PFN_EGLCREATEPBUFFERSURFACE)_getPublicProcAddress("eglCreatePbufferSurface");
    if (!_ptr) {
        _ptr = &_fail_eglCreatePbufferSurface;
    }
    _eglCreatePbufferSurface = _ptr;
    return _eglCreatePbufferSurface(dpy, config, attrib_list);
}

PFN_EGLCREATEPBUFFERSURFACE _eglCreatePbufferSurface = &_get_eglCreatePbufferSurface;

static EGLSurface EGLAPIENTRY _fail_eglCreatePixmapSurface(EGLDisplay dpy, EGLConfig config, EGLNativePixmapType pixmap, const EGLint * attrib_list) {
    const char *_name = "eglCreatePixmapSurface";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static EGLSurface EGLAPIENTRY _get_eglCreatePixmapSurface(EGLDisplay dpy, EGLConfig config, EGLNativePixmapType pixmap, const EGLint * attrib_list) {
    PFN_EGLCREATEPIXMAPSURFACE _ptr;
    _ptr = (PFN_EGLCREATEPIXMAPSURFACE)_getPublicProcAddress("eglCreatePixmapSurface");
    if (!_ptr) {
        _ptr = &_fail_eglCreatePixmapSurface;
    }
    _eglCreatePixmapSurface = _ptr;
    return _eglCreatePixmapSurface(dpy, config, pixmap, attrib_list);
}

PFN_EGLCREATEPIXMAPSURFACE _eglCreatePixmapSurface = &_get_eglCreatePixmapSurface;

static EGLSurface EGLAPIENTRY _fail_eglCreateWindowSurface(EGLDisplay dpy, EGLConfig config, EGLNativeWindowType win, const EGLint * attrib_list) {
    const char *_name = "eglCreateWindowSurface";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static EGLSurface EGLAPIENTRY _get_eglCreateWindowSurface(EGLDisplay dpy, EGLConfig config, EGLNativeWindowType win, const EGLint * attrib_list) {
    PFN_EGLCREATEWINDOWSURFACE _ptr;
    _ptr = (PFN_EGLCREATEWINDOWSURFACE)_getPublicProcAddress("eglCreateWindowSurface");
    if (!_ptr) {
        _ptr = &_fail_eglCreateWindowSurface;
    }
    _eglCreateWindowSurface = _ptr;
    return _eglCreateWindowSurface(dpy, config, win, attrib_list);
}

PFN_EGLCREATEWINDOWSURFACE _eglCreateWindowSurface = &_get_eglCreateWindowSurface;

static EGLBoolean EGLAPIENTRY _fail_eglDestroyContext(EGLDisplay dpy, EGLContext ctx) {
    const char *_name = "eglDestroyContext";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static EGLBoolean EGLAPIENTRY _get_eglDestroyContext(EGLDisplay dpy, EGLContext ctx) {
    PFN_EGLDESTROYCONTEXT _ptr;
    _ptr = (PFN_EGLDESTROYCONTEXT)_getPublicProcAddress("eglDestroyContext");
    if (!_ptr) {
        _ptr = &_fail_eglDestroyContext;
    }
    _eglDestroyContext = _ptr;
    return _eglDestroyContext(dpy, ctx);
}

PFN_EGLDESTROYCONTEXT _eglDestroyContext = &_get_eglDestroyContext;

static EGLBoolean EGLAPIENTRY _fail_eglDestroySurface(EGLDisplay dpy, EGLSurface surface) {
    const char *_name = "eglDestroySurface";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static EGLBoolean EGLAPIENTRY _get_eglDestroySurface(EGLDisplay dpy, EGLSurface surface) {
    PFN_EGLDESTROYSURFACE _ptr;
    _ptr = (PFN_EGLDESTROYSURFACE)_getPublicProcAddress("eglDestroySurface");
    if (!_ptr) {
        _ptr = &_fail_eglDestroySurface;
    }
    _eglDestroySurface = _ptr;
    return _eglDestroySurface(dpy, surface);
}

PFN_EGLDESTROYSURFACE _eglDestroySurface = &_get_eglDestroySurface;

static EGLBoolean EGLAPIENTRY _fail_eglGetConfigAttrib(EGLDisplay dpy, EGLConfig config, EGLint attribute, EGLint * value) {
    const char *_name = "eglGetConfigAttrib";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static EGLBoolean EGLAPIENTRY _get_eglGetConfigAttrib(EGLDisplay dpy, EGLConfig config, EGLint attribute, EGLint * value) {
    PFN_EGLGETCONFIGATTRIB _ptr;
    _ptr = (PFN_EGLGETCONFIGATTRIB)_getPublicProcAddress("eglGetConfigAttrib");
    if (!_ptr) {
        _ptr = &_fail_eglGetConfigAttrib;
    }
    _eglGetConfigAttrib = _ptr;
    return _eglGetConfigAttrib(dpy, config, attribute, value);
}

PFN_EGLGETCONFIGATTRIB _eglGetConfigAttrib = &_get_eglGetConfigAttrib;

static EGLBoolean EGLAPIENTRY _fail_eglGetConfigs(EGLDisplay dpy, EGLConfig * configs, EGLint config_size, EGLint * num_config) {
    const char *_name = "eglGetConfigs";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static EGLBoolean EGLAPIENTRY _get_eglGetConfigs(EGLDisplay dpy, EGLConfig * configs, EGLint config_size, EGLint * num_config) {
    PFN_EGLGETCONFIGS _ptr;
    _ptr = (PFN_EGLGETCONFIGS)_getPublicProcAddress("eglGetConfigs");
    if (!_ptr) {
        _ptr = &_fail_eglGetConfigs;
    }
    _eglGetConfigs = _ptr;
    return _eglGetConfigs(dpy, configs, config_size, num_config);
}

PFN_EGLGETCONFIGS _eglGetConfigs = &_get_eglGetConfigs;

static EGLDisplay EGLAPIENTRY _fail_eglGetCurrentDisplay(void) {
    const char *_name = "eglGetCurrentDisplay";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static EGLDisplay EGLAPIENTRY _get_eglGetCurrentDisplay(void) {
    PFN_EGLGETCURRENTDISPLAY _ptr;
    _ptr = (PFN_EGLGETCURRENTDISPLAY)_getPublicProcAddress("eglGetCurrentDisplay");
    if (!_ptr) {
        _ptr = &_fail_eglGetCurrentDisplay;
    }
    _eglGetCurrentDisplay = _ptr;
    return _eglGetCurrentDisplay();
}

PFN_EGLGETCURRENTDISPLAY _eglGetCurrentDisplay = &_get_eglGetCurrentDisplay;

static EGLSurface EGLAPIENTRY _fail_eglGetCurrentSurface(EGLint readdraw) {
    const char *_name = "eglGetCurrentSurface";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static EGLSurface EGLAPIENTRY _get_eglGetCurrentSurface(EGLint readdraw) {
    PFN_EGLGETCURRENTSURFACE _ptr;
    _ptr = (PFN_EGLGETCURRENTSURFACE)_getPublicProcAddress("eglGetCurrentSurface");
    if (!_ptr) {
        _ptr = &_fail_eglGetCurrentSurface;
    }
    _eglGetCurrentSurface = _ptr;
    return _eglGetCurrentSurface(readdraw);
}

PFN_EGLGETCURRENTSURFACE _eglGetCurrentSurface = &_get_eglGetCurrentSurface;

static EGLDisplay EGLAPIENTRY _fail_eglGetDisplay(EGLNativeDisplayType display_id) {
    const char *_name = "eglGetDisplay";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static EGLDisplay EGLAPIENTRY _get_eglGetDisplay(EGLNativeDisplayType display_id) {
    PFN_EGLGETDISPLAY _ptr;
    _ptr = (PFN_EGLGETDISPLAY)_getPublicProcAddress("eglGetDisplay");
    if (!_ptr) {
        _ptr = &_fail_eglGetDisplay;
    }
    _eglGetDisplay = _ptr;
    return _eglGetDisplay(display_id);
}

PFN_EGLGETDISPLAY _eglGetDisplay = &_get_eglGetDisplay;

static EGLint EGLAPIENTRY _fail_eglGetError(void) {
    const char *_name = "eglGetError";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static EGLint EGLAPIENTRY _get_eglGetError(void) {
    PFN_EGLGETERROR _ptr;
    _ptr = (PFN_EGLGETERROR)_getPublicProcAddress("eglGetError");
    if (!_ptr) {
        _ptr = &_fail_eglGetError;
    }
    _eglGetError = _ptr;
    return _eglGetError();
}

PFN_EGLGETERROR _eglGetError = &_get_eglGetError;

static __eglMustCastToProperFunctionPointerType EGLAPIENTRY _fail_eglGetProcAddress(const char * procname) {
    const char *_name = "eglGetProcAddress";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static __eglMustCastToProperFunctionPointerType EGLAPIENTRY _get_eglGetProcAddress(const char * procname) {
    PFN_EGLGETPROCADDRESS _ptr;
    _ptr = (PFN_EGLGETPROCADDRESS)_getPublicProcAddress("eglGetProcAddress");
    if (!_ptr) {
        _ptr = &_fail_eglGetProcAddress;
    }
    _eglGetProcAddress = _ptr;
    return _eglGetProcAddress(procname);
}

PFN_EGLGETPROCADDRESS _eglGetProcAddress = &_get_eglGetProcAddress;

static EGLBoolean EGLAPIENTRY _fail_eglInitialize(EGLDisplay dpy, EGLint * major, EGLint * minor) {
    const char *_name = "eglInitialize";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static EGLBoolean EGLAPIENTRY _get_eglInitialize(EGLDisplay dpy, EGLint * major, EGLint * minor) {
    PFN_EGLINITIALIZE _ptr;
    _ptr = (PFN_EGLINITIALIZE)_getPublicProcAddress("eglInitialize");
    if (!_ptr) {
        _ptr = &_fail_eglInitialize;
    }
    _eglInitialize = _ptr;
    return _eglInitialize(dpy, major, minor);
}

PFN_EGLINITIALIZE _eglInitialize = &_get_eglInitialize;

static EGLBoolean EGLAPIENTRY _fail_eglMakeCurrent(EGLDisplay dpy, EGLSurface draw, EGLSurface read, EGLContext ctx) {
    const char *_name = "eglMakeCurrent";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static EGLBoolean EGLAPIENTRY _get_eglMakeCurrent(EGLDisplay dpy, EGLSurface draw, EGLSurface read, EGLContext ctx) {
    PFN_EGLMAKECURRENT _ptr;
    _ptr = (PFN_EGLMAKECURRENT)_getPublicProcAddress("eglMakeCurrent");
    if (!_ptr) {
        _ptr = &_fail_eglMakeCurrent;
    }
    _eglMakeCurrent = _ptr;
    return _eglMakeCurrent(dpy, draw, read, ctx);
}

PFN_EGLMAKECURRENT _eglMakeCurrent = &_get_eglMakeCurrent;

static EGLBoolean EGLAPIENTRY _fail_eglQueryContext(EGLDisplay dpy, EGLContext ctx, EGLint attribute, EGLint * value) {
    const char *_name = "eglQueryContext";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static EGLBoolean EGLAPIENTRY _get_eglQueryContext(EGLDisplay dpy, EGLContext ctx, EGLint attribute, EGLint * value) {
    PFN_EGLQUERYCONTEXT _ptr;
    _ptr = (PFN_EGLQUERYCONTEXT)_getPublicProcAddress("eglQueryContext");
    if (!_ptr) {
        _ptr = &_fail_eglQueryContext;
    }
    _eglQueryContext = _ptr;
    return _eglQueryContext(dpy, ctx, attribute, value);
}

PFN_EGLQUERYCONTEXT _eglQueryContext = &_get_eglQueryContext;

static const char * EGLAPIENTRY _fail_eglQueryString(EGLDisplay dpy, EGLint name) {
    const char *_name = "eglQueryString";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static const char * EGLAPIENTRY _get_eglQueryString(EGLDisplay dpy, EGLint name) {
    PFN_EGLQUERYSTRING _ptr;
    _ptr = (PFN_EGLQUERYSTRING)_getPublicProcAddress("eglQueryString");
    if (!_ptr) {
        _ptr = &_fail_eglQueryString;
    }
    _eglQueryString = _ptr;
    return _eglQueryString(dpy, name);
}

PFN_EGLQUERYSTRING _eglQueryString = &_get_eglQueryString;

static EGLBoolean EGLAPIENTRY _fail_eglQuerySurface(EGLDisplay dpy, EGLSurface surface, EGLint attribute, EGLint * value) {
    const char *_name = "eglQuerySurface";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static EGLBoolean EGLAPIENTRY _get_eglQuerySurface(EGLDisplay dpy, EGLSurface surface, EGLint attribute, EGLint * value) {
    PFN_EGLQUERYSURFACE _ptr;
    _ptr = (PFN_EGLQUERYSURFACE)_getPublicProcAddress("eglQuerySurface");
    if (!_ptr) {
        _ptr = &_fail_eglQuerySurface;
    }
    _eglQuerySurface = _ptr;
    return _eglQuerySurface(dpy, surface, attribute, value);
}

PFN_EGLQUERYSURFACE _eglQuerySurface = &_get_eglQuerySurface;

static EGLBoolean EGLAPIENTRY _fail_eglSwapBuffers(EGLDisplay dpy, EGLSurface surface) {
    const char *_name = "eglSwapBuffers";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static EGLBoolean EGLAPIENTRY _get_eglSwapBuffers(EGLDisplay dpy, EGLSurface surface) {
    PFN_EGLSWAPBUFFERS _ptr;
    _ptr = (PFN_EGLSWAPBUFFERS)_getPublicProcAddress("eglSwapBuffers");
    if (!_ptr) {
        _ptr = &_fail_eglSwapBuffers;
    }
    _eglSwapBuffers = _ptr;
    return _eglSwapBuffers(dpy, surface);
}

PFN_EGLSWAPBUFFERS _eglSwapBuffers = &_get_eglSwapBuffers;

static EGLBoolean EGLAPIENTRY _fail_eglTerminate(EGLDisplay dpy) {
    const char *_name = "eglTerminate";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static EGLBoolean EGLAPIENTRY _get_eglTerminate(EGLDisplay dpy) {
    PFN_EGLTERMINATE _ptr;
    _ptr = (PFN_EGLTERMINATE)_getPublicProcAddress("eglTerminate");
    if (!_ptr) {
        _ptr = &_fail_eglTerminate;
    }
    _eglTerminate = _ptr;
    return _eglTerminate(dpy);
}

PFN_EGLTERMINATE _eglTerminate = &_get_eglTerminate;

static EGLBoolean EGLAPIENTRY _fail_eglWaitGL(void) {
    const char *_name = "eglWaitGL";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static EGLBoolean EGLAPIENTRY _get_eglWaitGL(void) {
    PFN_EGLWAITGL _ptr;
    _ptr = (PFN_EGLWAITGL)_getPublicProcAddress("eglWaitGL");
    if (!_ptr) {
        _ptr = &_fail_eglWaitGL;
    }
    _eglWaitGL = _ptr;
    return _eglWaitGL();
}

PFN_EGLWAITGL _eglWaitGL = &_get_eglWaitGL;

static EGLBoolean EGLAPIENTRY _fail_eglWaitNative(EGLint engine) {
    const char *_name = "eglWaitNative";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static EGLBoolean EGLAPIENTRY _get_eglWaitNative(EGLint engine) {
    PFN_EGLWAITNATIVE _ptr;
    _ptr = (PFN_EGLWAITNATIVE)_getPublicProcAddress("eglWaitNative");
    if (!_ptr) {
        _ptr = &_fail_eglWaitNative;
    }
    _eglWaitNative = _ptr;
    return _eglWaitNative(engine);
}

PFN_EGLWAITNATIVE _eglWaitNative = &_get_eglWaitNative;

static EGLBoolean EGLAPIENTRY _fail_eglBindTexImage(EGLDisplay dpy, EGLSurface surface, EGLint buffer) {
    const char *_name = "eglBindTexImage";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static EGLBoolean EGLAPIENTRY _get_eglBindTexImage(EGLDisplay dpy, EGLSurface surface, EGLint buffer) {
    PFN_EGLBINDTEXIMAGE _ptr;
    _ptr = (PFN_EGLBINDTEXIMAGE)_getPublicProcAddress("eglBindTexImage");
    if (!_ptr) {
        _ptr = &_fail_eglBindTexImage;
    }
    _eglBindTexImage = _ptr;
    return _eglBindTexImage(dpy, surface, buffer);
}

PFN_EGLBINDTEXIMAGE _eglBindTexImage = &_get_eglBindTexImage;

static EGLBoolean EGLAPIENTRY _fail_eglReleaseTexImage(EGLDisplay dpy, EGLSurface surface, EGLint buffer) {
    const char *_name = "eglReleaseTexImage";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static EGLBoolean EGLAPIENTRY _get_eglReleaseTexImage(EGLDisplay dpy, EGLSurface surface, EGLint buffer) {
    PFN_EGLRELEASETEXIMAGE _ptr;
    _ptr = (PFN_EGLRELEASETEXIMAGE)_getPublicProcAddress("eglReleaseTexImage");
    if (!_ptr) {
        _ptr = &_fail_eglReleaseTexImage;
    }
    _eglReleaseTexImage = _ptr;
    return _eglReleaseTexImage(dpy, surface, buffer);
}

PFN_EGLRELEASETEXIMAGE _eglReleaseTexImage = &_get_eglReleaseTexImage;

static EGLBoolean EGLAPIENTRY _fail_eglSurfaceAttrib(EGLDisplay dpy, EGLSurface surface, EGLint attribute, EGLint value) {
    const char *_name = "eglSurfaceAttrib";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static EGLBoolean EGLAPIENTRY _get_eglSurfaceAttrib(EGLDisplay dpy, EGLSurface surface, EGLint attribute, EGLint value) {
    PFN_EGLSURFACEATTRIB _ptr;
    _ptr = (PFN_EGLSURFACEATTRIB)_getPublicProcAddress("eglSurfaceAttrib");
    if (!_ptr) {
        _ptr = &_fail_eglSurfaceAttrib;
    }
    _eglSurfaceAttrib = _ptr;
    return _eglSurfaceAttrib(dpy, surface, attribute, value);
}

PFN_EGLSURFACEATTRIB _eglSurfaceAttrib = &_get_eglSurfaceAttrib;

static EGLBoolean EGLAPIENTRY _fail_eglSwapInterval(EGLDisplay dpy, EGLint interval) {
    const char *_name = "eglSwapInterval";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static EGLBoolean EGLAPIENTRY _get_eglSwapInterval(EGLDisplay dpy, EGLint interval) {
    PFN_EGLSWAPINTERVAL _ptr;
    _ptr = (PFN_EGLSWAPINTERVAL)_getPublicProcAddress("eglSwapInterval");
    if (!_ptr) {
        _ptr = &_fail_eglSwapInterval;
    }
    _eglSwapInterval = _ptr;
    return _eglSwapInterval(dpy, interval);
}

PFN_EGLSWAPINTERVAL _eglSwapInterval = &_get_eglSwapInterval;

static EGLBoolean EGLAPIENTRY _fail_eglBindAPI(EGLenum api) {
    const char *_name = "eglBindAPI";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static EGLBoolean EGLAPIENTRY _get_eglBindAPI(EGLenum api) {
    PFN_EGLBINDAPI _ptr;
    _ptr = (PFN_EGLBINDAPI)_getPublicProcAddress("eglBindAPI");
    if (!_ptr) {
        _ptr = &_fail_eglBindAPI;
    }
    _eglBindAPI = _ptr;
    return _eglBindAPI(api);
}

PFN_EGLBINDAPI _eglBindAPI = &_get_eglBindAPI;

static EGLenum EGLAPIENTRY _fail_eglQueryAPI(void) {
    const char *_name = "eglQueryAPI";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static EGLenum EGLAPIENTRY _get_eglQueryAPI(void) {
    PFN_EGLQUERYAPI _ptr;
    _ptr = (PFN_EGLQUERYAPI)_getPublicProcAddress("eglQueryAPI");
    if (!_ptr) {
        _ptr = &_fail_eglQueryAPI;
    }
    _eglQueryAPI = _ptr;
    return _eglQueryAPI();
}

PFN_EGLQUERYAPI _eglQueryAPI = &_get_eglQueryAPI;

static EGLSurface EGLAPIENTRY _fail_eglCreatePbufferFromClientBuffer(EGLDisplay dpy, EGLenum buftype, EGLClientBuffer buffer, EGLConfig config, const EGLint * attrib_list) {
    const char *_name = "eglCreatePbufferFromClientBuffer";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static EGLSurface EGLAPIENTRY _get_eglCreatePbufferFromClientBuffer(EGLDisplay dpy, EGLenum buftype, EGLClientBuffer buffer, EGLConfig config, const EGLint * attrib_list) {
    PFN_EGLCREATEPBUFFERFROMCLIENTBUFFER _ptr;
    _ptr = (PFN_EGLCREATEPBUFFERFROMCLIENTBUFFER)_getPublicProcAddress("eglCreatePbufferFromClientBuffer");
    if (!_ptr) {
        _ptr = &_fail_eglCreatePbufferFromClientBuffer;
    }
    _eglCreatePbufferFromClientBuffer = _ptr;
    return _eglCreatePbufferFromClientBuffer(dpy, buftype, buffer, config, attrib_list);
}

PFN_EGLCREATEPBUFFERFROMCLIENTBUFFER _eglCreatePbufferFromClientBuffer = &_get_eglCreatePbufferFromClientBuffer;

static EGLBoolean EGLAPIENTRY _fail_eglReleaseThread(void) {
    const char *_name = "eglReleaseThread";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static EGLBoolean EGLAPIENTRY _get_eglReleaseThread(void) {
    PFN_EGLRELEASETHREAD _ptr;
    _ptr = (PFN_EGLRELEASETHREAD)_getPublicProcAddress("eglReleaseThread");
    if (!_ptr) {
        _ptr = &_fail_eglReleaseThread;
    }
    _eglReleaseThread = _ptr;
    return _eglReleaseThread();
}

PFN_EGLRELEASETHREAD _eglReleaseThread = &_get_eglReleaseThread;

static EGLBoolean EGLAPIENTRY _fail_eglWaitClient(void) {
    const char *_name = "eglWaitClient";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static EGLBoolean EGLAPIENTRY _get_eglWaitClient(void) {
    PFN_EGLWAITCLIENT _ptr;
    _ptr = (PFN_EGLWAITCLIENT)_getPublicProcAddress("eglWaitClient");
    if (!_ptr) {
        _ptr = &_fail_eglWaitClient;
    }
    _eglWaitClient = _ptr;
    return _eglWaitClient();
}

PFN_EGLWAITCLIENT _eglWaitClient = &_get_eglWaitClient;

static EGLContext EGLAPIENTRY _fail_eglGetCurrentContext(void) {
    const char *_name = "eglGetCurrentContext";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static EGLContext EGLAPIENTRY _get_eglGetCurrentContext(void) {
    PFN_EGLGETCURRENTCONTEXT _ptr;
    _ptr = (PFN_EGLGETCURRENTCONTEXT)_getPublicProcAddress("eglGetCurrentContext");
    if (!_ptr) {
        _ptr = &_fail_eglGetCurrentContext;
    }
    _eglGetCurrentContext = _ptr;
    return _eglGetCurrentContext();
}

PFN_EGLGETCURRENTCONTEXT _eglGetCurrentContext = &_get_eglGetCurrentContext;

static EGLSync EGLAPIENTRY _fail_eglCreateSync(EGLDisplay dpy, EGLenum type, const EGLAttrib * attrib_list) {
    const char *_name = "eglCreateSync";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static EGLSync EGLAPIENTRY _get_eglCreateSync(EGLDisplay dpy, EGLenum type, const EGLAttrib * attrib_list) {
    PFN_EGLCREATESYNC _ptr;
    _ptr = (PFN_EGLCREATESYNC)_getPrivateProcAddress("eglCreateSync");
    if (!_ptr) {
        _ptr = &_fail_eglCreateSync;
    }
    _eglCreateSync = _ptr;
    return _eglCreateSync(dpy, type, attrib_list);
}

PFN_EGLCREATESYNC _eglCreateSync = &_get_eglCreateSync;

static EGLBoolean EGLAPIENTRY _fail_eglDestroySync(EGLDisplay dpy, EGLSync sync) {
    const char *_name = "eglDestroySync";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static EGLBoolean EGLAPIENTRY _get_eglDestroySync(EGLDisplay dpy, EGLSync sync) {
    PFN_EGLDESTROYSYNC _ptr;
    _ptr = (PFN_EGLDESTROYSYNC)_getPrivateProcAddress("eglDestroySync");
    if (!_ptr) {
        _ptr = &_fail_eglDestroySync;
    }
    _eglDestroySync = _ptr;
    return _eglDestroySync(dpy, sync);
}

PFN_EGLDESTROYSYNC _eglDestroySync = &_get_eglDestroySync;

static EGLint EGLAPIENTRY _fail_eglClientWaitSync(EGLDisplay dpy, EGLSync sync, EGLint flags, EGLTime timeout) {
    const char *_name = "eglClientWaitSync";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static EGLint EGLAPIENTRY _get_eglClientWaitSync(EGLDisplay dpy, EGLSync sync, EGLint flags, EGLTime timeout) {
    PFN_EGLCLIENTWAITSYNC _ptr;
    _ptr = (PFN_EGLCLIENTWAITSYNC)_getPrivateProcAddress("eglClientWaitSync");
    if (!_ptr) {
        _ptr = &_fail_eglClientWaitSync;
    }
    _eglClientWaitSync = _ptr;
    return _eglClientWaitSync(dpy, sync, flags, timeout);
}

PFN_EGLCLIENTWAITSYNC _eglClientWaitSync = &_get_eglClientWaitSync;

static EGLBoolean EGLAPIENTRY _fail_eglGetSyncAttrib(EGLDisplay dpy, EGLSync sync, EGLint attribute, EGLAttrib * value) {
    const char *_name = "eglGetSyncAttrib";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static EGLBoolean EGLAPIENTRY _get_eglGetSyncAttrib(EGLDisplay dpy, EGLSync sync, EGLint attribute, EGLAttrib * value) {
    PFN_EGLGETSYNCATTRIB _ptr;
    _ptr = (PFN_EGLGETSYNCATTRIB)_getPrivateProcAddress("eglGetSyncAttrib");
    if (!_ptr) {
        _ptr = &_fail_eglGetSyncAttrib;
    }
    _eglGetSyncAttrib = _ptr;
    return _eglGetSyncAttrib(dpy, sync, attribute, value);
}

PFN_EGLGETSYNCATTRIB _eglGetSyncAttrib = &_get_eglGetSyncAttrib;

static EGLImage EGLAPIENTRY _fail_eglCreateImage(EGLDisplay dpy, EGLContext ctx, EGLenum target, EGLClientBuffer buffer, const EGLAttrib * attrib_list) {
    const char *_name = "eglCreateImage";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static EGLImage EGLAPIENTRY _get_eglCreateImage(EGLDisplay dpy, EGLContext ctx, EGLenum target, EGLClientBuffer buffer, const EGLAttrib * attrib_list) {
    PFN_EGLCREATEIMAGE _ptr;
    _ptr = (PFN_EGLCREATEIMAGE)_getPrivateProcAddress("eglCreateImage");
    if (!_ptr) {
        _ptr = &_fail_eglCreateImage;
    }
    _eglCreateImage = _ptr;
    return _eglCreateImage(dpy, ctx, target, buffer, attrib_list);
}

PFN_EGLCREATEIMAGE _eglCreateImage = &_get_eglCreateImage;

static EGLBoolean EGLAPIENTRY _fail_eglDestroyImage(EGLDisplay dpy, EGLImage image) {
    const char *_name = "eglDestroyImage";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static EGLBoolean EGLAPIENTRY _get_eglDestroyImage(EGLDisplay dpy, EGLImage image) {
    PFN_EGLDESTROYIMAGE _ptr;
    _ptr = (PFN_EGLDESTROYIMAGE)_getPrivateProcAddress("eglDestroyImage");
    if (!_ptr) {
        _ptr = &_fail_eglDestroyImage;
    }
    _eglDestroyImage = _ptr;
    return _eglDestroyImage(dpy, image);
}

PFN_EGLDESTROYIMAGE _eglDestroyImage = &_get_eglDestroyImage;

static EGLDisplay EGLAPIENTRY _fail_eglGetPlatformDisplay(EGLenum platform, void * native_display, const EGLAttrib * attrib_list) {
    const char *_name = "eglGetPlatformDisplay";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static EGLDisplay EGLAPIENTRY _get_eglGetPlatformDisplay(EGLenum platform, void * native_display, const EGLAttrib * attrib_list) {
    PFN_EGLGETPLATFORMDISPLAY _ptr;
    _ptr = (PFN_EGLGETPLATFORMDISPLAY)_getPrivateProcAddress("eglGetPlatformDisplay");
    if (!_ptr) {
        _ptr = &_fail_eglGetPlatformDisplay;
    }
    _eglGetPlatformDisplay = _ptr;
    return _eglGetPlatformDisplay(platform, native_display, attrib_list);
}

PFN_EGLGETPLATFORMDISPLAY _eglGetPlatformDisplay = &_get_eglGetPlatformDisplay;

static EGLSurface EGLAPIENTRY _fail_eglCreatePlatformWindowSurface(EGLDisplay dpy, EGLConfig config, void * native_window, const EGLAttrib * attrib_list) {
    const char *_name = "eglCreatePlatformWindowSurface";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static EGLSurface EGLAPIENTRY _get_eglCreatePlatformWindowSurface(EGLDisplay dpy, EGLConfig config, void * native_window, const EGLAttrib * attrib_list) {
    PFN_EGLCREATEPLATFORMWINDOWSURFACE _ptr;
    _ptr = (PFN_EGLCREATEPLATFORMWINDOWSURFACE)_getPrivateProcAddress("eglCreatePlatformWindowSurface");
    if (!_ptr) {
        _ptr = &_fail_eglCreatePlatformWindowSurface;
    }
    _eglCreatePlatformWindowSurface = _ptr;
    return _eglCreatePlatformWindowSurface(dpy, config, native_window, attrib_list);
}

PFN_EGLCREATEPLATFORMWINDOWSURFACE _eglCreatePlatformWindowSurface = &_get_eglCreatePlatformWindowSurface;

static EGLSurface EGLAPIENTRY _fail_eglCreatePlatformPixmapSurface(EGLDisplay dpy, EGLConfig config, void * native_pixmap, const EGLAttrib * attrib_list) {
    const char *_name = "eglCreatePlatformPixmapSurface";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static EGLSurface EGLAPIENTRY _get_eglCreatePlatformPixmapSurface(EGLDisplay dpy, EGLConfig config, void * native_pixmap, const EGLAttrib * attrib_list) {
    PFN_EGLCREATEPLATFORMPIXMAPSURFACE _ptr;
    _ptr = (PFN_EGLCREATEPLATFORMPIXMAPSURFACE)_getPrivateProcAddress("eglCreatePlatformPixmapSurface");
    if (!_ptr) {
        _ptr = &_fail_eglCreatePlatformPixmapSurface;
    }
    _eglCreatePlatformPixmapSurface = _ptr;
    return _eglCreatePlatformPixmapSurface(dpy, config, native_pixmap, attrib_list);
}

PFN_EGLCREATEPLATFORMPIXMAPSURFACE _eglCreatePlatformPixmapSurface = &_get_eglCreatePlatformPixmapSurface;

static EGLBoolean EGLAPIENTRY _fail_eglWaitSync(EGLDisplay dpy, EGLSync sync, EGLint flags) {
    const char *_name = "eglWaitSync";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static EGLBoolean EGLAPIENTRY _get_eglWaitSync(EGLDisplay dpy, EGLSync sync, EGLint flags) {
    PFN_EGLWAITSYNC _ptr;
    _ptr = (PFN_EGLWAITSYNC)_getPrivateProcAddress("eglWaitSync");
    if (!_ptr) {
        _ptr = &_fail_eglWaitSync;
    }
    _eglWaitSync = _ptr;
    return _eglWaitSync(dpy, sync, flags);
}

PFN_EGLWAITSYNC _eglWaitSync = &_get_eglWaitSync;

static EGLint EGLAPIENTRY _fail_eglDupNativeFenceFDANDROID(EGLDisplay dpy, EGLSyncKHR sync) {
    const char *_name = "eglDupNativeFenceFDANDROID";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static EGLint EGLAPIENTRY _get_eglDupNativeFenceFDANDROID(EGLDisplay dpy, EGLSyncKHR sync) {
    PFN_EGLDUPNATIVEFENCEFDANDROID _ptr;
    _ptr = (PFN_EGLDUPNATIVEFENCEFDANDROID)_getPrivateProcAddress("eglDupNativeFenceFDANDROID");
    if (!_ptr) {
        _ptr = &_fail_eglDupNativeFenceFDANDROID;
    }
    _eglDupNativeFenceFDANDROID = _ptr;
    return _eglDupNativeFenceFDANDROID(dpy, sync);
}

PFN_EGLDUPNATIVEFENCEFDANDROID _eglDupNativeFenceFDANDROID = &_get_eglDupNativeFenceFDANDROID;

static EGLBoolean EGLAPIENTRY _fail_eglQuerySurfacePointerANGLE(EGLDisplay dpy, EGLSurface surface, EGLint attribute, void * * value) {
    const char *_name = "eglQuerySurfacePointerANGLE";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static EGLBoolean EGLAPIENTRY _get_eglQuerySurfacePointerANGLE(EGLDisplay dpy, EGLSurface surface, EGLint attribute, void * * value) {
    PFN_EGLQUERYSURFACEPOINTERANGLE _ptr;
    _ptr = (PFN_EGLQUERYSURFACEPOINTERANGLE)_getPrivateProcAddress("eglQuerySurfacePointerANGLE");
    if (!_ptr) {
        _ptr = &_fail_eglQuerySurfacePointerANGLE;
    }
    _eglQuerySurfacePointerANGLE = _ptr;
    return _eglQuerySurfacePointerANGLE(dpy, surface, attribute, value);
}

PFN_EGLQUERYSURFACEPOINTERANGLE _eglQuerySurfacePointerANGLE = &_get_eglQuerySurfacePointerANGLE;

static bool EGLAPIENTRY _fail_eglGetSyncValuesCHROMIUM(EGLDisplay dpy, EGLSurface surface, int64_t * ust, int64_t * msc, int64_t * sbc) {
    const char *_name = "eglGetSyncValuesCHROMIUM";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static bool EGLAPIENTRY _get_eglGetSyncValuesCHROMIUM(EGLDisplay dpy, EGLSurface surface, int64_t * ust, int64_t * msc, int64_t * sbc) {
    PFN_EGLGETSYNCVALUESCHROMIUM _ptr;
    _ptr = (PFN_EGLGETSYNCVALUESCHROMIUM)_getPrivateProcAddress("eglGetSyncValuesCHROMIUM");
    if (!_ptr) {
        _ptr = &_fail_eglGetSyncValuesCHROMIUM;
    }
    _eglGetSyncValuesCHROMIUM = _ptr;
    return _eglGetSyncValuesCHROMIUM(dpy, surface, ust, msc, sbc);
}

PFN_EGLGETSYNCVALUESCHROMIUM _eglGetSyncValuesCHROMIUM = &_get_eglGetSyncValuesCHROMIUM;

static EGLBoolean EGLAPIENTRY _fail_eglQueryDevicesEXT(EGLint max_devices, EGLDeviceEXT * devices, EGLint * num_devices) {
    const char *_name = "eglQueryDevicesEXT";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static EGLBoolean EGLAPIENTRY _get_eglQueryDevicesEXT(EGLint max_devices, EGLDeviceEXT * devices, EGLint * num_devices) {
    PFN_EGLQUERYDEVICESEXT _ptr;
    _ptr = (PFN_EGLQUERYDEVICESEXT)_getPrivateProcAddress("eglQueryDevicesEXT");
    if (!_ptr) {
        _ptr = &_fail_eglQueryDevicesEXT;
    }
    _eglQueryDevicesEXT = _ptr;
    return _eglQueryDevicesEXT(max_devices, devices, num_devices);
}

PFN_EGLQUERYDEVICESEXT _eglQueryDevicesEXT = &_get_eglQueryDevicesEXT;

static EGLBoolean EGLAPIENTRY _fail_eglQueryDeviceAttribEXT(EGLDeviceEXT device, EGLint attribute, EGLAttrib * value) {
    const char *_name = "eglQueryDeviceAttribEXT";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static EGLBoolean EGLAPIENTRY _get_eglQueryDeviceAttribEXT(EGLDeviceEXT device, EGLint attribute, EGLAttrib * value) {
    PFN_EGLQUERYDEVICEATTRIBEXT _ptr;
    _ptr = (PFN_EGLQUERYDEVICEATTRIBEXT)_getPrivateProcAddress("eglQueryDeviceAttribEXT");
    if (!_ptr) {
        _ptr = &_fail_eglQueryDeviceAttribEXT;
    }
    _eglQueryDeviceAttribEXT = _ptr;
    return _eglQueryDeviceAttribEXT(device, attribute, value);
}

PFN_EGLQUERYDEVICEATTRIBEXT _eglQueryDeviceAttribEXT = &_get_eglQueryDeviceAttribEXT;

static const char * EGLAPIENTRY _fail_eglQueryDeviceStringEXT(EGLDeviceEXT device, EGLint name) {
    const char *_name = "eglQueryDeviceStringEXT";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static const char * EGLAPIENTRY _get_eglQueryDeviceStringEXT(EGLDeviceEXT device, EGLint name) {
    PFN_EGLQUERYDEVICESTRINGEXT _ptr;
    _ptr = (PFN_EGLQUERYDEVICESTRINGEXT)_getPrivateProcAddress("eglQueryDeviceStringEXT");
    if (!_ptr) {
        _ptr = &_fail_eglQueryDeviceStringEXT;
    }
    _eglQueryDeviceStringEXT = _ptr;
    return _eglQueryDeviceStringEXT(device, name);
}

PFN_EGLQUERYDEVICESTRINGEXT _eglQueryDeviceStringEXT = &_get_eglQueryDeviceStringEXT;

static EGLBoolean EGLAPIENTRY _fail_eglQueryDisplayAttribEXT(EGLDisplay dpy, EGLint attribute, EGLAttrib * value) {
    const char *_name = "eglQueryDisplayAttribEXT";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static EGLBoolean EGLAPIENTRY _get_eglQueryDisplayAttribEXT(EGLDisplay dpy, EGLint attribute, EGLAttrib * value) {
    PFN_EGLQUERYDISPLAYATTRIBEXT _ptr;
    _ptr = (PFN_EGLQUERYDISPLAYATTRIBEXT)_getPrivateProcAddress("eglQueryDisplayAttribEXT");
    if (!_ptr) {
        _ptr = &_fail_eglQueryDisplayAttribEXT;
    }
    _eglQueryDisplayAttribEXT = _ptr;
    return _eglQueryDisplayAttribEXT(dpy, attribute, value);
}

PFN_EGLQUERYDISPLAYATTRIBEXT _eglQueryDisplayAttribEXT = &_get_eglQueryDisplayAttribEXT;

static EGLBoolean EGLAPIENTRY _fail_eglQueryDmaBufFormatsEXT(EGLDisplay dpy, EGLint max_formats, EGLint * formats, EGLint * num_formats) {
    const char *_name = "eglQueryDmaBufFormatsEXT";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static EGLBoolean EGLAPIENTRY _get_eglQueryDmaBufFormatsEXT(EGLDisplay dpy, EGLint max_formats, EGLint * formats, EGLint * num_formats) {
    PFN_EGLQUERYDMABUFFORMATSEXT _ptr;
    _ptr = (PFN_EGLQUERYDMABUFFORMATSEXT)_getPrivateProcAddress("eglQueryDmaBufFormatsEXT");
    if (!_ptr) {
        _ptr = &_fail_eglQueryDmaBufFormatsEXT;
    }
    _eglQueryDmaBufFormatsEXT = _ptr;
    return _eglQueryDmaBufFormatsEXT(dpy, max_formats, formats, num_formats);
}

PFN_EGLQUERYDMABUFFORMATSEXT _eglQueryDmaBufFormatsEXT = &_get_eglQueryDmaBufFormatsEXT;

static EGLBoolean EGLAPIENTRY _fail_eglQueryDmaBufModifiersEXT(EGLDisplay dpy, EGLint format, EGLint max_modifiers, EGLuint64KHR * modifiers, EGLBoolean * external_only, EGLint * num_modifiers) {
    const char *_name = "eglQueryDmaBufModifiersEXT";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static EGLBoolean EGLAPIENTRY _get_eglQueryDmaBufModifiersEXT(EGLDisplay dpy, EGLint format, EGLint max_modifiers, EGLuint64KHR * modifiers, EGLBoolean * external_only, EGLint * num_modifiers) {
    PFN_EGLQUERYDMABUFMODIFIERSEXT _ptr;
    _ptr = (PFN_EGLQUERYDMABUFMODIFIERSEXT)_getPrivateProcAddress("eglQueryDmaBufModifiersEXT");
    if (!_ptr) {
        _ptr = &_fail_eglQueryDmaBufModifiersEXT;
    }
    _eglQueryDmaBufModifiersEXT = _ptr;
    return _eglQueryDmaBufModifiersEXT(dpy, format, max_modifiers, modifiers, external_only, num_modifiers);
}

PFN_EGLQUERYDMABUFMODIFIERSEXT _eglQueryDmaBufModifiersEXT = &_get_eglQueryDmaBufModifiersEXT;

static EGLDisplay EGLAPIENTRY _fail_eglGetPlatformDisplayEXT(EGLenum platform, void * native_display, const EGLint * attrib_list) {
    const char *_name = "eglGetPlatformDisplayEXT";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static EGLDisplay EGLAPIENTRY _get_eglGetPlatformDisplayEXT(EGLenum platform, void * native_display, const EGLint * attrib_list) {
    PFN_EGLGETPLATFORMDISPLAYEXT _ptr;
    _ptr = (PFN_EGLGETPLATFORMDISPLAYEXT)_getPrivateProcAddress("eglGetPlatformDisplayEXT");
    if (!_ptr) {
        _ptr = &_fail_eglGetPlatformDisplayEXT;
    }
    _eglGetPlatformDisplayEXT = _ptr;
    return _eglGetPlatformDisplayEXT(platform, native_display, attrib_list);
}

PFN_EGLGETPLATFORMDISPLAYEXT _eglGetPlatformDisplayEXT = &_get_eglGetPlatformDisplayEXT;

static EGLSurface EGLAPIENTRY _fail_eglCreatePlatformWindowSurfaceEXT(EGLDisplay dpy, EGLConfig config, void * native_window, const EGLint * attrib_list) {
    const char *_name = "eglCreatePlatformWindowSurfaceEXT";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static EGLSurface EGLAPIENTRY _get_eglCreatePlatformWindowSurfaceEXT(EGLDisplay dpy, EGLConfig config, void * native_window, const EGLint * attrib_list) {
    PFN_EGLCREATEPLATFORMWINDOWSURFACEEXT _ptr;
    _ptr = (PFN_EGLCREATEPLATFORMWINDOWSURFACEEXT)_getPrivateProcAddress("eglCreatePlatformWindowSurfaceEXT");
    if (!_ptr) {
        _ptr = &_fail_eglCreatePlatformWindowSurfaceEXT;
    }
    _eglCreatePlatformWindowSurfaceEXT = _ptr;
    return _eglCreatePlatformWindowSurfaceEXT(dpy, config, native_window, attrib_list);
}

PFN_EGLCREATEPLATFORMWINDOWSURFACEEXT _eglCreatePlatformWindowSurfaceEXT = &_get_eglCreatePlatformWindowSurfaceEXT;

static EGLSurface EGLAPIENTRY _fail_eglCreatePlatformPixmapSurfaceEXT(EGLDisplay dpy, EGLConfig config, void * native_pixmap, const EGLint * attrib_list) {
    const char *_name = "eglCreatePlatformPixmapSurfaceEXT";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static EGLSurface EGLAPIENTRY _get_eglCreatePlatformPixmapSurfaceEXT(EGLDisplay dpy, EGLConfig config, void * native_pixmap, const EGLint * attrib_list) {
    PFN_EGLCREATEPLATFORMPIXMAPSURFACEEXT _ptr;
    _ptr = (PFN_EGLCREATEPLATFORMPIXMAPSURFACEEXT)_getPrivateProcAddress("eglCreatePlatformPixmapSurfaceEXT");
    if (!_ptr) {
        _ptr = &_fail_eglCreatePlatformPixmapSurfaceEXT;
    }
    _eglCreatePlatformPixmapSurfaceEXT = _ptr;
    return _eglCreatePlatformPixmapSurfaceEXT(dpy, config, native_pixmap, attrib_list);
}

PFN_EGLCREATEPLATFORMPIXMAPSURFACEEXT _eglCreatePlatformPixmapSurfaceEXT = &_get_eglCreatePlatformPixmapSurfaceEXT;

static EGLBoolean EGLAPIENTRY _fail_eglSetDamageRegionKHR(EGLDisplay dpy, EGLSurface surface, EGLint * rects, EGLint n_rects) {
    const char *_name = "eglSetDamageRegionKHR";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static EGLBoolean EGLAPIENTRY _get_eglSetDamageRegionKHR(EGLDisplay dpy, EGLSurface surface, EGLint * rects, EGLint n_rects) {
    PFN_EGLSETDAMAGEREGIONKHR _ptr;
    _ptr = (PFN_EGLSETDAMAGEREGIONKHR)_getPrivateProcAddress("eglSetDamageRegionKHR");
    if (!_ptr) {
        _ptr = &_fail_eglSetDamageRegionKHR;
    }
    _eglSetDamageRegionKHR = _ptr;
    return _eglSetDamageRegionKHR(dpy, surface, rects, n_rects);
}

PFN_EGLSETDAMAGEREGIONKHR _eglSetDamageRegionKHR = &_get_eglSetDamageRegionKHR;

static EGLBoolean EGLAPIENTRY _fail_eglSwapBuffersWithDamageEXT(EGLDisplay dpy, EGLSurface surface, const EGLint * rects, EGLint n_rects) {
    const char *_name = "eglSwapBuffersWithDamageEXT";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static EGLBoolean EGLAPIENTRY _get_eglSwapBuffersWithDamageEXT(EGLDisplay dpy, EGLSurface surface, const EGLint * rects, EGLint n_rects) {
    PFN_EGLSWAPBUFFERSWITHDAMAGEEXT _ptr;
    _ptr = (PFN_EGLSWAPBUFFERSWITHDAMAGEEXT)_getPrivateProcAddress("eglSwapBuffersWithDamageEXT");
    if (!_ptr) {
        _ptr = &_fail_eglSwapBuffersWithDamageEXT;
    }
    _eglSwapBuffersWithDamageEXT = _ptr;
    return _eglSwapBuffersWithDamageEXT(dpy, surface, rects, n_rects);
}

PFN_EGLSWAPBUFFERSWITHDAMAGEEXT _eglSwapBuffersWithDamageEXT = &_get_eglSwapBuffersWithDamageEXT;

static EGLSurface EGLAPIENTRY _fail_eglCreatePixmapSurfaceHI(EGLDisplay dpy, EGLConfig config, struct EGLClientPixmapHI * pixmap) {
    const char *_name = "eglCreatePixmapSurfaceHI";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static EGLSurface EGLAPIENTRY _get_eglCreatePixmapSurfaceHI(EGLDisplay dpy, EGLConfig config, struct EGLClientPixmapHI * pixmap) {
    PFN_EGLCREATEPIXMAPSURFACEHI _ptr;
    _ptr = (PFN_EGLCREATEPIXMAPSURFACEHI)_getPrivateProcAddress("eglCreatePixmapSurfaceHI");
    if (!_ptr) {
        _ptr = &_fail_eglCreatePixmapSurfaceHI;
    }
    _eglCreatePixmapSurfaceHI = _ptr;
    return _eglCreatePixmapSurfaceHI(dpy, config, pixmap);
}

PFN_EGLCREATEPIXMAPSURFACEHI _eglCreatePixmapSurfaceHI = &_get_eglCreatePixmapSurfaceHI;

static EGLSyncKHR EGLAPIENTRY _fail_eglCreateSyncKHR(EGLDisplay dpy, EGLenum type, const EGLint * attrib_list) {
    const char *_name = "eglCreateSyncKHR";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static EGLSyncKHR EGLAPIENTRY _get_eglCreateSyncKHR(EGLDisplay dpy, EGLenum type, const EGLint * attrib_list) {
    PFN_EGLCREATESYNCKHR _ptr;
    _ptr = (PFN_EGLCREATESYNCKHR)_getPrivateProcAddress("eglCreateSyncKHR");
    if (!_ptr) {
        _ptr = &_fail_eglCreateSyncKHR;
    }
    _eglCreateSyncKHR = _ptr;
    return _eglCreateSyncKHR(dpy, type, attrib_list);
}

PFN_EGLCREATESYNCKHR _eglCreateSyncKHR = &_get_eglCreateSyncKHR;

static EGLBoolean EGLAPIENTRY _fail_eglDestroySyncKHR(EGLDisplay dpy, EGLSyncKHR sync) {
    const char *_name = "eglDestroySyncKHR";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static EGLBoolean EGLAPIENTRY _get_eglDestroySyncKHR(EGLDisplay dpy, EGLSyncKHR sync) {
    PFN_EGLDESTROYSYNCKHR _ptr;
    _ptr = (PFN_EGLDESTROYSYNCKHR)_getPrivateProcAddress("eglDestroySyncKHR");
    if (!_ptr) {
        _ptr = &_fail_eglDestroySyncKHR;
    }
    _eglDestroySyncKHR = _ptr;
    return _eglDestroySyncKHR(dpy, sync);
}

PFN_EGLDESTROYSYNCKHR _eglDestroySyncKHR = &_get_eglDestroySyncKHR;

static EGLint EGLAPIENTRY _fail_eglClientWaitSyncKHR(EGLDisplay dpy, EGLSyncKHR sync, EGLint flags, EGLTimeKHR timeout) {
    const char *_name = "eglClientWaitSyncKHR";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static EGLint EGLAPIENTRY _get_eglClientWaitSyncKHR(EGLDisplay dpy, EGLSyncKHR sync, EGLint flags, EGLTimeKHR timeout) {
    PFN_EGLCLIENTWAITSYNCKHR _ptr;
    _ptr = (PFN_EGLCLIENTWAITSYNCKHR)_getPrivateProcAddress("eglClientWaitSyncKHR");
    if (!_ptr) {
        _ptr = &_fail_eglClientWaitSyncKHR;
    }
    _eglClientWaitSyncKHR = _ptr;
    return _eglClientWaitSyncKHR(dpy, sync, flags, timeout);
}

PFN_EGLCLIENTWAITSYNCKHR _eglClientWaitSyncKHR = &_get_eglClientWaitSyncKHR;

static EGLBoolean EGLAPIENTRY _fail_eglGetSyncAttribKHR(EGLDisplay dpy, EGLSyncKHR sync, EGLint attribute, EGLint * value) {
    const char *_name = "eglGetSyncAttribKHR";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static EGLBoolean EGLAPIENTRY _get_eglGetSyncAttribKHR(EGLDisplay dpy, EGLSyncKHR sync, EGLint attribute, EGLint * value) {
    PFN_EGLGETSYNCATTRIBKHR _ptr;
    _ptr = (PFN_EGLGETSYNCATTRIBKHR)_getPrivateProcAddress("eglGetSyncAttribKHR");
    if (!_ptr) {
        _ptr = &_fail_eglGetSyncAttribKHR;
    }
    _eglGetSyncAttribKHR = _ptr;
    return _eglGetSyncAttribKHR(dpy, sync, attribute, value);
}

PFN_EGLGETSYNCATTRIBKHR _eglGetSyncAttribKHR = &_get_eglGetSyncAttribKHR;

static EGLImageKHR EGLAPIENTRY _fail_eglCreateImageKHR(EGLDisplay dpy, EGLContext ctx, EGLenum target, EGLClientBuffer buffer, const EGLint * attrib_list) {
    const char *_name = "eglCreateImageKHR";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static EGLImageKHR EGLAPIENTRY _get_eglCreateImageKHR(EGLDisplay dpy, EGLContext ctx, EGLenum target, EGLClientBuffer buffer, const EGLint * attrib_list) {
    PFN_EGLCREATEIMAGEKHR _ptr;
    _ptr = (PFN_EGLCREATEIMAGEKHR)_getPrivateProcAddress("eglCreateImageKHR");
    if (!_ptr) {
        _ptr = &_fail_eglCreateImageKHR;
    }
    _eglCreateImageKHR = _ptr;
    return _eglCreateImageKHR(dpy, ctx, target, buffer, attrib_list);
}

PFN_EGLCREATEIMAGEKHR _eglCreateImageKHR = &_get_eglCreateImageKHR;

static EGLBoolean EGLAPIENTRY _fail_eglDestroyImageKHR(EGLDisplay dpy, EGLImageKHR image) {
    const char *_name = "eglDestroyImageKHR";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static EGLBoolean EGLAPIENTRY _get_eglDestroyImageKHR(EGLDisplay dpy, EGLImageKHR image) {
    PFN_EGLDESTROYIMAGEKHR _ptr;
    _ptr = (PFN_EGLDESTROYIMAGEKHR)_getPrivateProcAddress("eglDestroyImageKHR");
    if (!_ptr) {
        _ptr = &_fail_eglDestroyImageKHR;
    }
    _eglDestroyImageKHR = _ptr;
    return _eglDestroyImageKHR(dpy, image);
}

PFN_EGLDESTROYIMAGEKHR _eglDestroyImageKHR = &_get_eglDestroyImageKHR;

static EGLBoolean EGLAPIENTRY _fail_eglLockSurfaceKHR(EGLDisplay dpy, EGLSurface surface, const EGLint * attrib_list) {
    const char *_name = "eglLockSurfaceKHR";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static EGLBoolean EGLAPIENTRY _get_eglLockSurfaceKHR(EGLDisplay dpy, EGLSurface surface, const EGLint * attrib_list) {
    PFN_EGLLOCKSURFACEKHR _ptr;
    _ptr = (PFN_EGLLOCKSURFACEKHR)_getPrivateProcAddress("eglLockSurfaceKHR");
    if (!_ptr) {
        _ptr = &_fail_eglLockSurfaceKHR;
    }
    _eglLockSurfaceKHR = _ptr;
    return _eglLockSurfaceKHR(dpy, surface, attrib_list);
}

PFN_EGLLOCKSURFACEKHR _eglLockSurfaceKHR = &_get_eglLockSurfaceKHR;

static EGLBoolean EGLAPIENTRY _fail_eglUnlockSurfaceKHR(EGLDisplay dpy, EGLSurface surface) {
    const char *_name = "eglUnlockSurfaceKHR";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static EGLBoolean EGLAPIENTRY _get_eglUnlockSurfaceKHR(EGLDisplay dpy, EGLSurface surface) {
    PFN_EGLUNLOCKSURFACEKHR _ptr;
    _ptr = (PFN_EGLUNLOCKSURFACEKHR)_getPrivateProcAddress("eglUnlockSurfaceKHR");
    if (!_ptr) {
        _ptr = &_fail_eglUnlockSurfaceKHR;
    }
    _eglUnlockSurfaceKHR = _ptr;
    return _eglUnlockSurfaceKHR(dpy, surface);
}

PFN_EGLUNLOCKSURFACEKHR _eglUnlockSurfaceKHR = &_get_eglUnlockSurfaceKHR;

static EGLBoolean EGLAPIENTRY _fail_eglSignalSyncKHR(EGLDisplay dpy, EGLSyncKHR sync, EGLenum mode) {
    const char *_name = "eglSignalSyncKHR";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static EGLBoolean EGLAPIENTRY _get_eglSignalSyncKHR(EGLDisplay dpy, EGLSyncKHR sync, EGLenum mode) {
    PFN_EGLSIGNALSYNCKHR _ptr;
    _ptr = (PFN_EGLSIGNALSYNCKHR)_getPrivateProcAddress("eglSignalSyncKHR");
    if (!_ptr) {
        _ptr = &_fail_eglSignalSyncKHR;
    }
    _eglSignalSyncKHR = _ptr;
    return _eglSignalSyncKHR(dpy, sync, mode);
}

PFN_EGLSIGNALSYNCKHR _eglSignalSyncKHR = &_get_eglSignalSyncKHR;

static EGLBoolean EGLAPIENTRY _fail_eglSwapBuffersWithDamageKHR(EGLDisplay dpy, EGLSurface surface, const EGLint * rects, EGLint n_rects) {
    const char *_name = "eglSwapBuffersWithDamageKHR";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static EGLBoolean EGLAPIENTRY _get_eglSwapBuffersWithDamageKHR(EGLDisplay dpy, EGLSurface surface, const EGLint * rects, EGLint n_rects) {
    PFN_EGLSWAPBUFFERSWITHDAMAGEKHR _ptr;
    _ptr = (PFN_EGLSWAPBUFFERSWITHDAMAGEKHR)_getPrivateProcAddress("eglSwapBuffersWithDamageKHR");
    if (!_ptr) {
        _ptr = &_fail_eglSwapBuffersWithDamageKHR;
    }
    _eglSwapBuffersWithDamageKHR = _ptr;
    return _eglSwapBuffersWithDamageKHR(dpy, surface, rects, n_rects);
}

PFN_EGLSWAPBUFFERSWITHDAMAGEKHR _eglSwapBuffersWithDamageKHR = &_get_eglSwapBuffersWithDamageKHR;

static EGLint EGLAPIENTRY _fail_eglWaitSyncKHR(EGLDisplay dpy, EGLSyncKHR sync, EGLint flags) {
    const char *_name = "eglWaitSyncKHR";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static EGLint EGLAPIENTRY _get_eglWaitSyncKHR(EGLDisplay dpy, EGLSyncKHR sync, EGLint flags) {
    PFN_EGLWAITSYNCKHR _ptr;
    _ptr = (PFN_EGLWAITSYNCKHR)_getPrivateProcAddress("eglWaitSyncKHR");
    if (!_ptr) {
        _ptr = &_fail_eglWaitSyncKHR;
    }
    _eglWaitSyncKHR = _ptr;
    return _eglWaitSyncKHR(dpy, sync, flags);
}

PFN_EGLWAITSYNCKHR _eglWaitSyncKHR = &_get_eglWaitSyncKHR;

static EGLSyncNV EGLAPIENTRY _fail_eglCreateFenceSyncNV(EGLDisplay dpy, EGLenum condition, const EGLint * attrib_list) {
    const char *_name = "eglCreateFenceSyncNV";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static EGLSyncNV EGLAPIENTRY _get_eglCreateFenceSyncNV(EGLDisplay dpy, EGLenum condition, const EGLint * attrib_list) {
    PFN_EGLCREATEFENCESYNCNV _ptr;
    _ptr = (PFN_EGLCREATEFENCESYNCNV)_getPrivateProcAddress("eglCreateFenceSyncNV");
    if (!_ptr) {
        _ptr = &_fail_eglCreateFenceSyncNV;
    }
    _eglCreateFenceSyncNV = _ptr;
    return _eglCreateFenceSyncNV(dpy, condition, attrib_list);
}

PFN_EGLCREATEFENCESYNCNV _eglCreateFenceSyncNV = &_get_eglCreateFenceSyncNV;

static EGLBoolean EGLAPIENTRY _fail_eglDestroySyncNV(EGLSyncNV sync) {
    const char *_name = "eglDestroySyncNV";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static EGLBoolean EGLAPIENTRY _get_eglDestroySyncNV(EGLSyncNV sync) {
    PFN_EGLDESTROYSYNCNV _ptr;
    _ptr = (PFN_EGLDESTROYSYNCNV)_getPrivateProcAddress("eglDestroySyncNV");
    if (!_ptr) {
        _ptr = &_fail_eglDestroySyncNV;
    }
    _eglDestroySyncNV = _ptr;
    return _eglDestroySyncNV(sync);
}

PFN_EGLDESTROYSYNCNV _eglDestroySyncNV = &_get_eglDestroySyncNV;

static EGLBoolean EGLAPIENTRY _fail_eglFenceNV(EGLSyncNV sync) {
    const char *_name = "eglFenceNV";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static EGLBoolean EGLAPIENTRY _get_eglFenceNV(EGLSyncNV sync) {
    PFN_EGLFENCENV _ptr;
    _ptr = (PFN_EGLFENCENV)_getPrivateProcAddress("eglFenceNV");
    if (!_ptr) {
        _ptr = &_fail_eglFenceNV;
    }
    _eglFenceNV = _ptr;
    return _eglFenceNV(sync);
}

PFN_EGLFENCENV _eglFenceNV = &_get_eglFenceNV;

static EGLint EGLAPIENTRY _fail_eglClientWaitSyncNV(EGLSyncNV sync, EGLint flags, EGLTimeNV timeout) {
    const char *_name = "eglClientWaitSyncNV";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static EGLint EGLAPIENTRY _get_eglClientWaitSyncNV(EGLSyncNV sync, EGLint flags, EGLTimeNV timeout) {
    PFN_EGLCLIENTWAITSYNCNV _ptr;
    _ptr = (PFN_EGLCLIENTWAITSYNCNV)_getPrivateProcAddress("eglClientWaitSyncNV");
    if (!_ptr) {
        _ptr = &_fail_eglClientWaitSyncNV;
    }
    _eglClientWaitSyncNV = _ptr;
    return _eglClientWaitSyncNV(sync, flags, timeout);
}

PFN_EGLCLIENTWAITSYNCNV _eglClientWaitSyncNV = &_get_eglClientWaitSyncNV;

static EGLBoolean EGLAPIENTRY _fail_eglSignalSyncNV(EGLSyncNV sync, EGLenum mode) {
    const char *_name = "eglSignalSyncNV";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static EGLBoolean EGLAPIENTRY _get_eglSignalSyncNV(EGLSyncNV sync, EGLenum mode) {
    PFN_EGLSIGNALSYNCNV _ptr;
    _ptr = (PFN_EGLSIGNALSYNCNV)_getPrivateProcAddress("eglSignalSyncNV");
    if (!_ptr) {
        _ptr = &_fail_eglSignalSyncNV;
    }
    _eglSignalSyncNV = _ptr;
    return _eglSignalSyncNV(sync, mode);
}

PFN_EGLSIGNALSYNCNV _eglSignalSyncNV = &_get_eglSignalSyncNV;

static EGLBoolean EGLAPIENTRY _fail_eglGetSyncAttribNV(EGLSyncNV sync, EGLint attribute, EGLint * value) {
    const char *_name = "eglGetSyncAttribNV";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static EGLBoolean EGLAPIENTRY _get_eglGetSyncAttribNV(EGLSyncNV sync, EGLint attribute, EGLint * value) {
    PFN_EGLGETSYNCATTRIBNV _ptr;
    _ptr = (PFN_EGLGETSYNCATTRIBNV)_getPrivateProcAddress("eglGetSyncAttribNV");
    if (!_ptr) {
        _ptr = &_fail_eglGetSyncAttribNV;
    }
    _eglGetSyncAttribNV = _ptr;
    return _eglGetSyncAttribNV(sync, attribute, value);
}

PFN_EGLGETSYNCATTRIBNV _eglGetSyncAttribNV = &_get_eglGetSyncAttribNV;

static EGLImageKHR EGLAPIENTRY _fail_eglCreateDRMImageMESA(EGLDisplay dpy, const EGLint * attrib_list) {
    const char *_name = "eglCreateDRMImageMESA";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static EGLImageKHR EGLAPIENTRY _get_eglCreateDRMImageMESA(EGLDisplay dpy, const EGLint * attrib_list) {
    PFN_EGLCREATEDRMIMAGEMESA _ptr;
    _ptr = (PFN_EGLCREATEDRMIMAGEMESA)_getPrivateProcAddress("eglCreateDRMImageMESA");
    if (!_ptr) {
        _ptr = &_fail_eglCreateDRMImageMESA;
    }
    _eglCreateDRMImageMESA = _ptr;
    return _eglCreateDRMImageMESA(dpy, attrib_list);
}

PFN_EGLCREATEDRMIMAGEMESA _eglCreateDRMImageMESA = &_get_eglCreateDRMImageMESA;

static EGLBoolean EGLAPIENTRY _fail_eglExportDRMImageMESA(EGLDisplay dpy, EGLImageKHR image, EGLint * name, EGLint * handle, EGLint * stride) {
    const char *_name = "eglExportDRMImageMESA";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static EGLBoolean EGLAPIENTRY _get_eglExportDRMImageMESA(EGLDisplay dpy, EGLImageKHR image, EGLint * name, EGLint * handle, EGLint * stride) {
    PFN_EGLEXPORTDRMIMAGEMESA _ptr;
    _ptr = (PFN_EGLEXPORTDRMIMAGEMESA)_getPrivateProcAddress("eglExportDRMImageMESA");
    if (!_ptr) {
        _ptr = &_fail_eglExportDRMImageMESA;
    }
    _eglExportDRMImageMESA = _ptr;
    return _eglExportDRMImageMESA(dpy, image, name, handle, stride);
}

PFN_EGLEXPORTDRMIMAGEMESA _eglExportDRMImageMESA = &_get_eglExportDRMImageMESA;

static EGLBoolean EGLAPIENTRY _fail_eglExportDMABUFImageQueryMESA(EGLDisplay dpy, EGLImageKHR image, EGLint * fourcc, EGLint * num_planes, EGLuint64KHR * modifiers) {
    const char *_name = "eglExportDMABUFImageQueryMESA";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static EGLBoolean EGLAPIENTRY _get_eglExportDMABUFImageQueryMESA(EGLDisplay dpy, EGLImageKHR image, EGLint * fourcc, EGLint * num_planes, EGLuint64KHR * modifiers) {
    PFN_EGLEXPORTDMABUFIMAGEQUERYMESA _ptr;
    _ptr = (PFN_EGLEXPORTDMABUFIMAGEQUERYMESA)_getPrivateProcAddress("eglExportDMABUFImageQueryMESA");
    if (!_ptr) {
        _ptr = &_fail_eglExportDMABUFImageQueryMESA;
    }
    _eglExportDMABUFImageQueryMESA = _ptr;
    return _eglExportDMABUFImageQueryMESA(dpy, image, fourcc, num_planes, modifiers);
}

PFN_EGLEXPORTDMABUFIMAGEQUERYMESA _eglExportDMABUFImageQueryMESA = &_get_eglExportDMABUFImageQueryMESA;

static EGLBoolean EGLAPIENTRY _fail_eglExportDMABUFImageMESA(EGLDisplay dpy, EGLImageKHR image, EGLint * fds, EGLint * strides, EGLint * offsets) {
    const char *_name = "eglExportDMABUFImageMESA";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static EGLBoolean EGLAPIENTRY _get_eglExportDMABUFImageMESA(EGLDisplay dpy, EGLImageKHR image, EGLint * fds, EGLint * strides, EGLint * offsets) {
    PFN_EGLEXPORTDMABUFIMAGEMESA _ptr;
    _ptr = (PFN_EGLEXPORTDMABUFIMAGEMESA)_getPrivateProcAddress("eglExportDMABUFImageMESA");
    if (!_ptr) {
        _ptr = &_fail_eglExportDMABUFImageMESA;
    }
    _eglExportDMABUFImageMESA = _ptr;
    return _eglExportDMABUFImageMESA(dpy, image, fds, strides, offsets);
}

PFN_EGLEXPORTDMABUFIMAGEMESA _eglExportDMABUFImageMESA = &_get_eglExportDMABUFImageMESA;

static EGLBoolean EGLAPIENTRY _fail_eglPostSubBufferNV(EGLDisplay dpy, EGLSurface surface, EGLint x, EGLint y, EGLint width, EGLint height) {
    const char *_name = "eglPostSubBufferNV";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static EGLBoolean EGLAPIENTRY _get_eglPostSubBufferNV(EGLDisplay dpy, EGLSurface surface, EGLint x, EGLint y, EGLint width, EGLint height) {
    PFN_EGLPOSTSUBBUFFERNV _ptr;
    _ptr = (PFN_EGLPOSTSUBBUFFERNV)_getPrivateProcAddress("eglPostSubBufferNV");
    if (!_ptr) {
        _ptr = &_fail_eglPostSubBufferNV;
    }
    _eglPostSubBufferNV = _ptr;
    return _eglPostSubBufferNV(dpy, surface, x, y, width, height);
}

PFN_EGLPOSTSUBBUFFERNV _eglPostSubBufferNV = &_get_eglPostSubBufferNV;

static EGLuint64NV EGLAPIENTRY _fail_eglGetSystemTimeFrequencyNV(void) {
    const char *_name = "eglGetSystemTimeFrequencyNV";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static EGLuint64NV EGLAPIENTRY _get_eglGetSystemTimeFrequencyNV(void) {
    PFN_EGLGETSYSTEMTIMEFREQUENCYNV _ptr;
    _ptr = (PFN_EGLGETSYSTEMTIMEFREQUENCYNV)_getPrivateProcAddress("eglGetSystemTimeFrequencyNV");
    if (!_ptr) {
        _ptr = &_fail_eglGetSystemTimeFrequencyNV;
    }
    _eglGetSystemTimeFrequencyNV = _ptr;
    return _eglGetSystemTimeFrequencyNV();
}

PFN_EGLGETSYSTEMTIMEFREQUENCYNV _eglGetSystemTimeFrequencyNV = &_get_eglGetSystemTimeFrequencyNV;

static EGLuint64NV EGLAPIENTRY _fail_eglGetSystemTimeNV(void) {
    const char *_name = "eglGetSystemTimeNV";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static EGLuint64NV EGLAPIENTRY _get_eglGetSystemTimeNV(void) {
    PFN_EGLGETSYSTEMTIMENV _ptr;
    _ptr = (PFN_EGLGETSYSTEMTIMENV)_getPrivateProcAddress("eglGetSystemTimeNV");
    if (!_ptr) {
        _ptr = &_fail_eglGetSystemTimeNV;
    }
    _eglGetSystemTimeNV = _ptr;
    return _eglGetSystemTimeNV();
}

PFN_EGLGETSYSTEMTIMENV _eglGetSystemTimeNV = &_get_eglGetSystemTimeNV;

static void EGLAPIENTRY _fail_glEGLImageTargetTexture2DOES(GLenum target, EGLImageKHR image) {
    const char *_name = "glEGLImageTargetTexture2DOES";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void EGLAPIENTRY _get_glEGLImageTargetTexture2DOES(GLenum target, EGLImageKHR image) {
    PFN_GLEGLIMAGETARGETTEXTURE2DOES _ptr;
    _ptr = (PFN_GLEGLIMAGETARGETTEXTURE2DOES)_getPrivateProcAddress("glEGLImageTargetTexture2DOES");
    if (!_ptr) {
        _ptr = &_fail_glEGLImageTargetTexture2DOES;
    }
    _glEGLImageTargetTexture2DOES = _ptr;
    _glEGLImageTargetTexture2DOES(target, image);
}

PFN_GLEGLIMAGETARGETTEXTURE2DOES _glEGLImageTargetTexture2DOES = &_get_glEGLImageTargetTexture2DOES;

static void EGLAPIENTRY _fail_glEGLImageTargetRenderbufferStorageOES(GLenum target, EGLImageKHR image) {
    const char *_name = "glEGLImageTargetRenderbufferStorageOES";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void EGLAPIENTRY _get_glEGLImageTargetRenderbufferStorageOES(GLenum target, EGLImageKHR image) {
    PFN_GLEGLIMAGETARGETRENDERBUFFERSTORAGEOES _ptr;
    _ptr = (PFN_GLEGLIMAGETARGETRENDERBUFFERSTORAGEOES)_getPrivateProcAddress("glEGLImageTargetRenderbufferStorageOES");
    if (!_ptr) {
        _ptr = &_fail_glEGLImageTargetRenderbufferStorageOES;
    }
    _glEGLImageTargetRenderbufferStorageOES = _ptr;
    _glEGLImageTargetRenderbufferStorageOES(target, image);
}

PFN_GLEGLIMAGETARGETRENDERBUFFERSTORAGEOES _glEGLImageTargetRenderbufferStorageOES = &_get_glEGLImageTargetRenderbufferStorageOES;

static EGLBoolean EGLAPIENTRY _fail_eglQuerySupportedCompressionRatesEXT(EGLDisplay dpy, EGLConfig config, const EGLAttrib * attrib_list, EGLint * rates, EGLint rate_size, EGLint * num_rates) {
    const char *_name = "eglQuerySupportedCompressionRatesEXT";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static EGLBoolean EGLAPIENTRY _get_eglQuerySupportedCompressionRatesEXT(EGLDisplay dpy, EGLConfig config, const EGLAttrib * attrib_list, EGLint * rates, EGLint rate_size, EGLint * num_rates) {
    PFN_EGLQUERYSUPPORTEDCOMPRESSIONRATESEXT _ptr;
    _ptr = (PFN_EGLQUERYSUPPORTEDCOMPRESSIONRATESEXT)_getPrivateProcAddress("eglQuerySupportedCompressionRatesEXT");
    if (!_ptr) {
        _ptr = &_fail_eglQuerySupportedCompressionRatesEXT;
    }
    _eglQuerySupportedCompressionRatesEXT = _ptr;
    return _eglQuerySupportedCompressionRatesEXT(dpy, config, attrib_list, rates, rate_size, num_rates);
}

PFN_EGLQUERYSUPPORTEDCOMPRESSIONRATESEXT _eglQuerySupportedCompressionRatesEXT = &_get_eglQuerySupportedCompressionRatesEXT;

static EGLBoolean EGLAPIENTRY _fail_eglBindWaylandDisplayWL(EGLDisplay dpy, struct wl_display* display) {
    const char *_name = "eglBindWaylandDisplayWL";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static EGLBoolean EGLAPIENTRY _get_eglBindWaylandDisplayWL(EGLDisplay dpy, struct wl_display* display) {
    PFN_EGLBINDWAYLANDDISPLAYWL _ptr;
    _ptr = (PFN_EGLBINDWAYLANDDISPLAYWL)_getPrivateProcAddress("eglBindWaylandDisplayWL");
    if (!_ptr) {
        _ptr = &_fail_eglBindWaylandDisplayWL;
    }
    _eglBindWaylandDisplayWL = _ptr;
    return _eglBindWaylandDisplayWL(dpy, display);
}

PFN_EGLBINDWAYLANDDISPLAYWL _eglBindWaylandDisplayWL = &_get_eglBindWaylandDisplayWL;

static EGLBoolean EGLAPIENTRY _fail_eglUnbindWaylandDisplayWL(EGLDisplay dpy, struct wl_display* display) {
    const char *_name = "eglUnbindWaylandDisplayWL";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static EGLBoolean EGLAPIENTRY _get_eglUnbindWaylandDisplayWL(EGLDisplay dpy, struct wl_display* display) {
    PFN_EGLUNBINDWAYLANDDISPLAYWL _ptr;
    _ptr = (PFN_EGLUNBINDWAYLANDDISPLAYWL)_getPrivateProcAddress("eglUnbindWaylandDisplayWL");
    if (!_ptr) {
        _ptr = &_fail_eglUnbindWaylandDisplayWL;
    }
    _eglUnbindWaylandDisplayWL = _ptr;
    return _eglUnbindWaylandDisplayWL(dpy, display);
}

PFN_EGLUNBINDWAYLANDDISPLAYWL _eglUnbindWaylandDisplayWL = &_get_eglUnbindWaylandDisplayWL;

static EGLBoolean EGLAPIENTRY _fail_eglQueryWaylandBufferWL(EGLDisplay dpy, struct wl_resource* buffer, EGLint attribute, EGLint * value) {
    const char *_name = "eglQueryWaylandBufferWL";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static EGLBoolean EGLAPIENTRY _get_eglQueryWaylandBufferWL(EGLDisplay dpy, struct wl_resource* buffer, EGLint attribute, EGLint * value) {
    PFN_EGLQUERYWAYLANDBUFFERWL _ptr;
    _ptr = (PFN_EGLQUERYWAYLANDBUFFERWL)_getPrivateProcAddress("eglQueryWaylandBufferWL");
    if (!_ptr) {
        _ptr = &_fail_eglQueryWaylandBufferWL;
    }
    _eglQueryWaylandBufferWL = _ptr;
    return _eglQueryWaylandBufferWL(dpy, buffer, attribute, value);
}

PFN_EGLQUERYWAYLANDBUFFERWL _eglQueryWaylandBufferWL = &_get_eglQueryWaylandBufferWL;

static EGLint EGLAPIENTRY _fail_eglDebugMessageControlKHR(EGLDEBUGPROCKHR callback, const EGLAttrib * attrib_list) {
    return EGL_SUCCESS;
}

static EGLint EGLAPIENTRY _get_eglDebugMessageControlKHR(EGLDEBUGPROCKHR callback, const EGLAttrib * attrib_list) {
    PFN_EGLDEBUGMESSAGECONTROLKHR _ptr;
    _ptr = (PFN_EGLDEBUGMESSAGECONTROLKHR)_getPrivateProcAddress("eglDebugMessageControlKHR");
    if (!_ptr) {
        _ptr = &_fail_eglDebugMessageControlKHR;
    }
    _eglDebugMessageControlKHR = _ptr;
    return _eglDebugMessageControlKHR(callback, attrib_list);
}

PFN_EGLDEBUGMESSAGECONTROLKHR _eglDebugMessageControlKHR = &_get_eglDebugMessageControlKHR;

static EGLBoolean EGLAPIENTRY _fail_eglQueryDebugKHR(EGLint attribute, EGLAttrib * value) {
    if (value != 0) *value = 0;
    return EGL_FALSE;
}

static EGLBoolean EGLAPIENTRY _get_eglQueryDebugKHR(EGLint attribute, EGLAttrib * value) {
    PFN_EGLQUERYDEBUGKHR _ptr;
    _ptr = (PFN_EGLQUERYDEBUGKHR)_getPrivateProcAddress("eglQueryDebugKHR");
    if (!_ptr) {
        _ptr = &_fail_eglQueryDebugKHR;
    }
    _eglQueryDebugKHR = _ptr;
    return _eglQueryDebugKHR(attribute, value);
}

PFN_EGLQUERYDEBUGKHR _eglQueryDebugKHR = &_get_eglQueryDebugKHR;

static EGLint EGLAPIENTRY _fail_eglLabelObjectKHR(EGLDisplay display, EGLenum objectType, EGLObjectKHR object, EGLLabelKHR label) {
    return EGL_SUCCESS;
}

static EGLint EGLAPIENTRY _get_eglLabelObjectKHR(EGLDisplay display, EGLenum objectType, EGLObjectKHR object, EGLLabelKHR label) {
    PFN_EGLLABELOBJECTKHR _ptr;
    _ptr = (PFN_EGLLABELOBJECTKHR)_getPrivateProcAddress("eglLabelObjectKHR");
    if (!_ptr) {
        _ptr = &_fail_eglLabelObjectKHR;
    }
    _eglLabelObjectKHR = _ptr;
    return _eglLabelObjectKHR(display, objectType, object, label);
}

PFN_EGLLABELOBJECTKHR _eglLabelObjectKHR = &_get_eglLabelObjectKHR;


#if defined(_WIN32)

static HGLRC __stdcall _fail_wglCreateContext(HDC hdc) {
    const char *_name = "wglCreateContext";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static HGLRC __stdcall _get_wglCreateContext(HDC hdc) {
    PFN_WGLCREATECONTEXT _ptr;
    _ptr = (PFN_WGLCREATECONTEXT)_getPublicProcAddress("wglCreateContext");
    if (!_ptr) {
        _ptr = &_fail_wglCreateContext;
    }
    _wglCreateContext = _ptr;
    return _wglCreateContext(hdc);
}

PFN_WGLCREATECONTEXT _wglCreateContext = &_get_wglCreateContext;

static BOOL __stdcall _fail_wglDeleteContext(HGLRC hglrc) {
    const char *_name = "wglDeleteContext";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static BOOL __stdcall _get_wglDeleteContext(HGLRC hglrc) {
    PFN_WGLDELETECONTEXT _ptr;
    _ptr = (PFN_WGLDELETECONTEXT)_getPublicProcAddress("wglDeleteContext");
    if (!_ptr) {
        _ptr = &_fail_wglDeleteContext;
    }
    _wglDeleteContext = _ptr;
    return _wglDeleteContext(hglrc);
}

PFN_WGLDELETECONTEXT _wglDeleteContext = &_get_wglDeleteContext;

static HGLRC __stdcall _fail_wglGetCurrentContext(void) {
    const char *_name = "wglGetCurrentContext";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static HGLRC __stdcall _get_wglGetCurrentContext(void) {
    PFN_WGLGETCURRENTCONTEXT _ptr;
    _ptr = (PFN_WGLGETCURRENTCONTEXT)_getPublicProcAddress("wglGetCurrentContext");
    if (!_ptr) {
        _ptr = &_fail_wglGetCurrentContext;
    }
    _wglGetCurrentContext = _ptr;
    return _wglGetCurrentContext();
}

PFN_WGLGETCURRENTCONTEXT _wglGetCurrentContext = &_get_wglGetCurrentContext;

static BOOL __stdcall _fail_wglMakeCurrent(HDC hdc, HGLRC hglrc) {
    const char *_name = "wglMakeCurrent";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static BOOL __stdcall _get_wglMakeCurrent(HDC hdc, HGLRC hglrc) {
    PFN_WGLMAKECURRENT _ptr;
    _ptr = (PFN_WGLMAKECURRENT)_getPublicProcAddress("wglMakeCurrent");
    if (!_ptr) {
        _ptr = &_fail_wglMakeCurrent;
    }
    _wglMakeCurrent = _ptr;
    return _wglMakeCurrent(hdc, hglrc);
}

PFN_WGLMAKECURRENT _wglMakeCurrent = &_get_wglMakeCurrent;

static BOOL __stdcall _fail_wglCopyContext(HGLRC hglrcSrc, HGLRC hglrcDst, UINT mask) {
    const char *_name = "wglCopyContext";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static BOOL __stdcall _get_wglCopyContext(HGLRC hglrcSrc, HGLRC hglrcDst, UINT mask) {
    PFN_WGLCOPYCONTEXT _ptr;
    _ptr = (PFN_WGLCOPYCONTEXT)_getPublicProcAddress("wglCopyContext");
    if (!_ptr) {
        _ptr = &_fail_wglCopyContext;
    }
    _wglCopyContext = _ptr;
    return _wglCopyContext(hglrcSrc, hglrcDst, mask);
}

PFN_WGLCOPYCONTEXT _wglCopyContext = &_get_wglCopyContext;

static int __stdcall _fail_wglChoosePixelFormat(HDC hdc, const PIXELFORMATDESCRIPTOR * ppfd) {
    const char *_name = "wglChoosePixelFormat";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static int __stdcall _get_wglChoosePixelFormat(HDC hdc, const PIXELFORMATDESCRIPTOR * ppfd) {
    PFN_WGLCHOOSEPIXELFORMAT _ptr;
    _ptr = (PFN_WGLCHOOSEPIXELFORMAT)_getPublicProcAddress("wglChoosePixelFormat");
    if (!_ptr) {
        _ptr = &_fail_wglChoosePixelFormat;
    }
    _wglChoosePixelFormat = _ptr;
    return _wglChoosePixelFormat(hdc, ppfd);
}

PFN_WGLCHOOSEPIXELFORMAT _wglChoosePixelFormat = &_get_wglChoosePixelFormat;

static int __stdcall _fail_wglDescribePixelFormat(HDC hdc, int iPixelFormat, UINT nBytes, PIXELFORMATDESCRIPTOR * ppfd) {
    const char *_name = "wglDescribePixelFormat";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static int __stdcall _get_wglDescribePixelFormat(HDC hdc, int iPixelFormat, UINT nBytes, PIXELFORMATDESCRIPTOR * ppfd) {
    PFN_WGLDESCRIBEPIXELFORMAT _ptr;
    _ptr = (PFN_WGLDESCRIBEPIXELFORMAT)_getPublicProcAddress("wglDescribePixelFormat");
    if (!_ptr) {
        _ptr = &_fail_wglDescribePixelFormat;
    }
    _wglDescribePixelFormat = _ptr;
    return _wglDescribePixelFormat(hdc, iPixelFormat, nBytes, ppfd);
}

PFN_WGLDESCRIBEPIXELFORMAT _wglDescribePixelFormat = &_get_wglDescribePixelFormat;

static HDC __stdcall _fail_wglGetCurrentDC(void) {
    const char *_name = "wglGetCurrentDC";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static HDC __stdcall _get_wglGetCurrentDC(void) {
    PFN_WGLGETCURRENTDC _ptr;
    _ptr = (PFN_WGLGETCURRENTDC)_getPublicProcAddress("wglGetCurrentDC");
    if (!_ptr) {
        _ptr = &_fail_wglGetCurrentDC;
    }
    _wglGetCurrentDC = _ptr;
    return _wglGetCurrentDC();
}

PFN_WGLGETCURRENTDC _wglGetCurrentDC = &_get_wglGetCurrentDC;

static PROC __stdcall _fail_wglGetDefaultProcAddress(const char * lpszProc) {
    const char *_name = "wglGetDefaultProcAddress";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static PROC __stdcall _get_wglGetDefaultProcAddress(const char * lpszProc) {
    PFN_WGLGETDEFAULTPROCADDRESS _ptr;
    _ptr = (PFN_WGLGETDEFAULTPROCADDRESS)_getPublicProcAddress("wglGetDefaultProcAddress");
    if (!_ptr) {
        _ptr = &_fail_wglGetDefaultProcAddress;
    }
    _wglGetDefaultProcAddress = _ptr;
    return _wglGetDefaultProcAddress(lpszProc);
}

PFN_WGLGETDEFAULTPROCADDRESS _wglGetDefaultProcAddress = &_get_wglGetDefaultProcAddress;

static int __stdcall _fail_wglGetPixelFormat(HDC hdc) {
    const char *_name = "wglGetPixelFormat";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static int __stdcall _get_wglGetPixelFormat(HDC hdc) {
    PFN_WGLGETPIXELFORMAT _ptr;
    _ptr = (PFN_WGLGETPIXELFORMAT)_getPublicProcAddress("wglGetPixelFormat");
    if (!_ptr) {
        _ptr = &_fail_wglGetPixelFormat;
    }
    _wglGetPixelFormat = _ptr;
    return _wglGetPixelFormat(hdc);
}

PFN_WGLGETPIXELFORMAT _wglGetPixelFormat = &_get_wglGetPixelFormat;

static BOOL __stdcall _fail_wglSetPixelFormat(HDC hdc, int iPixelFormat, const PIXELFORMATDESCRIPTOR * ppfd) {
    const char *_name = "wglSetPixelFormat";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static BOOL __stdcall _get_wglSetPixelFormat(HDC hdc, int iPixelFormat, const PIXELFORMATDESCRIPTOR * ppfd) {
    PFN_WGLSETPIXELFORMAT _ptr;
    _ptr = (PFN_WGLSETPIXELFORMAT)_getPublicProcAddress("wglSetPixelFormat");
    if (!_ptr) {
        _ptr = &_fail_wglSetPixelFormat;
    }
    _wglSetPixelFormat = _ptr;
    return _wglSetPixelFormat(hdc, iPixelFormat, ppfd);
}

PFN_WGLSETPIXELFORMAT _wglSetPixelFormat = &_get_wglSetPixelFormat;

static BOOL __stdcall _fail_wglSwapBuffers(HDC hdc) {
    const char *_name = "wglSwapBuffers";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static BOOL __stdcall _get_wglSwapBuffers(HDC hdc) {
    PFN_WGLSWAPBUFFERS _ptr;
    _ptr = (PFN_WGLSWAPBUFFERS)_getPublicProcAddress("wglSwapBuffers");
    if (!_ptr) {
        _ptr = &_fail_wglSwapBuffers;
    }
    _wglSwapBuffers = _ptr;
    return _wglSwapBuffers(hdc);
}

PFN_WGLSWAPBUFFERS _wglSwapBuffers = &_get_wglSwapBuffers;

static BOOL __stdcall _fail_wglShareLists(HGLRC hglrc1, HGLRC hglrc2) {
    const char *_name = "wglShareLists";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static BOOL __stdcall _get_wglShareLists(HGLRC hglrc1, HGLRC hglrc2) {
    PFN_WGLSHARELISTS _ptr;
    _ptr = (PFN_WGLSHARELISTS)_getPublicProcAddress("wglShareLists");
    if (!_ptr) {
        _ptr = &_fail_wglShareLists;
    }
    _wglShareLists = _ptr;
    return _wglShareLists(hglrc1, hglrc2);
}

PFN_WGLSHARELISTS _wglShareLists = &_get_wglShareLists;

static HGLRC __stdcall _fail_wglCreateLayerContext(HDC hdc, int iLayerPlane) {
    const char *_name = "wglCreateLayerContext";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static HGLRC __stdcall _get_wglCreateLayerContext(HDC hdc, int iLayerPlane) {
    PFN_WGLCREATELAYERCONTEXT _ptr;
    _ptr = (PFN_WGLCREATELAYERCONTEXT)_getPublicProcAddress("wglCreateLayerContext");
    if (!_ptr) {
        _ptr = &_fail_wglCreateLayerContext;
    }
    _wglCreateLayerContext = _ptr;
    return _wglCreateLayerContext(hdc, iLayerPlane);
}

PFN_WGLCREATELAYERCONTEXT _wglCreateLayerContext = &_get_wglCreateLayerContext;

static BOOL __stdcall _fail_wglDescribeLayerPlane(HDC hdc, int iPixelFormat, int iLayerPlane, UINT nBytes, LAYERPLANEDESCRIPTOR * plpd) {
    const char *_name = "wglDescribeLayerPlane";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static BOOL __stdcall _get_wglDescribeLayerPlane(HDC hdc, int iPixelFormat, int iLayerPlane, UINT nBytes, LAYERPLANEDESCRIPTOR * plpd) {
    PFN_WGLDESCRIBELAYERPLANE _ptr;
    _ptr = (PFN_WGLDESCRIBELAYERPLANE)_getPublicProcAddress("wglDescribeLayerPlane");
    if (!_ptr) {
        _ptr = &_fail_wglDescribeLayerPlane;
    }
    _wglDescribeLayerPlane = _ptr;
    return _wglDescribeLayerPlane(hdc, iPixelFormat, iLayerPlane, nBytes, plpd);
}

PFN_WGLDESCRIBELAYERPLANE _wglDescribeLayerPlane = &_get_wglDescribeLayerPlane;

static int __stdcall _fail_wglSetLayerPaletteEntries(HDC hdc, int iLayerPlane, int iStart, int cEntries, const COLORREF * pcr) {
    const char *_name = "wglSetLayerPaletteEntries";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static int __stdcall _get_wglSetLayerPaletteEntries(HDC hdc, int iLayerPlane, int iStart, int cEntries, const COLORREF * pcr) {
    PFN_WGLSETLAYERPALETTEENTRIES _ptr;
    _ptr = (PFN_WGLSETLAYERPALETTEENTRIES)_getPublicProcAddress("wglSetLayerPaletteEntries");
    if (!_ptr) {
        _ptr = &_fail_wglSetLayerPaletteEntries;
    }
    _wglSetLayerPaletteEntries = _ptr;
    return _wglSetLayerPaletteEntries(hdc, iLayerPlane, iStart, cEntries, pcr);
}

PFN_WGLSETLAYERPALETTEENTRIES _wglSetLayerPaletteEntries = &_get_wglSetLayerPaletteEntries;

static int __stdcall _fail_wglGetLayerPaletteEntries(HDC hdc, int iLayerPlane, int iStart, int cEntries, COLORREF * pcr) {
    const char *_name = "wglGetLayerPaletteEntries";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static int __stdcall _get_wglGetLayerPaletteEntries(HDC hdc, int iLayerPlane, int iStart, int cEntries, COLORREF * pcr) {
    PFN_WGLGETLAYERPALETTEENTRIES _ptr;
    _ptr = (PFN_WGLGETLAYERPALETTEENTRIES)_getPublicProcAddress("wglGetLayerPaletteEntries");
    if (!_ptr) {
        _ptr = &_fail_wglGetLayerPaletteEntries;
    }
    _wglGetLayerPaletteEntries = _ptr;
    return _wglGetLayerPaletteEntries(hdc, iLayerPlane, iStart, cEntries, pcr);
}

PFN_WGLGETLAYERPALETTEENTRIES _wglGetLayerPaletteEntries = &_get_wglGetLayerPaletteEntries;

static BOOL __stdcall _fail_wglRealizeLayerPalette(HDC hdc, int iLayerPlane, BOOL bRealize) {
    const char *_name = "wglRealizeLayerPalette";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static BOOL __stdcall _get_wglRealizeLayerPalette(HDC hdc, int iLayerPlane, BOOL bRealize) {
    PFN_WGLREALIZELAYERPALETTE _ptr;
    _ptr = (PFN_WGLREALIZELAYERPALETTE)_getPublicProcAddress("wglRealizeLayerPalette");
    if (!_ptr) {
        _ptr = &_fail_wglRealizeLayerPalette;
    }
    _wglRealizeLayerPalette = _ptr;
    return _wglRealizeLayerPalette(hdc, iLayerPlane, bRealize);
}

PFN_WGLREALIZELAYERPALETTE _wglRealizeLayerPalette = &_get_wglRealizeLayerPalette;

static BOOL __stdcall _fail_wglSwapLayerBuffers(HDC hdc, UINT fuPlanes) {
    const char *_name = "wglSwapLayerBuffers";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static BOOL __stdcall _get_wglSwapLayerBuffers(HDC hdc, UINT fuPlanes) {
    PFN_WGLSWAPLAYERBUFFERS _ptr;
    _ptr = (PFN_WGLSWAPLAYERBUFFERS)_getPublicProcAddress("wglSwapLayerBuffers");
    if (!_ptr) {
        _ptr = &_fail_wglSwapLayerBuffers;
    }
    _wglSwapLayerBuffers = _ptr;
    return _wglSwapLayerBuffers(hdc, fuPlanes);
}

PFN_WGLSWAPLAYERBUFFERS _wglSwapLayerBuffers = &_get_wglSwapLayerBuffers;

static BOOL __stdcall _fail_wglUseFontBitmapsA(HDC hdc, DWORD first, DWORD count, DWORD listBase) {
    const char *_name = "wglUseFontBitmapsA";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static BOOL __stdcall _get_wglUseFontBitmapsA(HDC hdc, DWORD first, DWORD count, DWORD listBase) {
    PFN_WGLUSEFONTBITMAPSA _ptr;
    _ptr = (PFN_WGLUSEFONTBITMAPSA)_getPublicProcAddress("wglUseFontBitmapsA");
    if (!_ptr) {
        _ptr = &_fail_wglUseFontBitmapsA;
    }
    _wglUseFontBitmapsA = _ptr;
    return _wglUseFontBitmapsA(hdc, first, count, listBase);
}

PFN_WGLUSEFONTBITMAPSA _wglUseFontBitmapsA = &_get_wglUseFontBitmapsA;

static BOOL __stdcall _fail_wglUseFontBitmapsW(HDC hdc, DWORD first, DWORD count, DWORD listBase) {
    const char *_name = "wglUseFontBitmapsW";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static BOOL __stdcall _get_wglUseFontBitmapsW(HDC hdc, DWORD first, DWORD count, DWORD listBase) {
    PFN_WGLUSEFONTBITMAPSW _ptr;
    _ptr = (PFN_WGLUSEFONTBITMAPSW)_getPublicProcAddress("wglUseFontBitmapsW");
    if (!_ptr) {
        _ptr = &_fail_wglUseFontBitmapsW;
    }
    _wglUseFontBitmapsW = _ptr;
    return _wglUseFontBitmapsW(hdc, first, count, listBase);
}

PFN_WGLUSEFONTBITMAPSW _wglUseFontBitmapsW = &_get_wglUseFontBitmapsW;

static DWORD __stdcall _fail_wglSwapMultipleBuffers(UINT n, const WGLSWAP * ps) {
    const char *_name = "wglSwapMultipleBuffers";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static DWORD __stdcall _get_wglSwapMultipleBuffers(UINT n, const WGLSWAP * ps) {
    PFN_WGLSWAPMULTIPLEBUFFERS _ptr;
    _ptr = (PFN_WGLSWAPMULTIPLEBUFFERS)_getPublicProcAddress("wglSwapMultipleBuffers");
    if (!_ptr) {
        _ptr = &_fail_wglSwapMultipleBuffers;
    }
    _wglSwapMultipleBuffers = _ptr;
    return _wglSwapMultipleBuffers(n, ps);
}

PFN_WGLSWAPMULTIPLEBUFFERS _wglSwapMultipleBuffers = &_get_wglSwapMultipleBuffers;

static BOOL __stdcall _fail_wglUseFontOutlinesA(HDC hdc, DWORD first, DWORD count, DWORD listBase, FLOAT deviation, FLOAT extrusion, int format, GLYPHMETRICSFLOAT * lpgmf) {
    const char *_name = "wglUseFontOutlinesA";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static BOOL __stdcall _get_wglUseFontOutlinesA(HDC hdc, DWORD first, DWORD count, DWORD listBase, FLOAT deviation, FLOAT extrusion, int format, GLYPHMETRICSFLOAT * lpgmf) {
    PFN_WGLUSEFONTOUTLINESA _ptr;
    _ptr = (PFN_WGLUSEFONTOUTLINESA)_getPublicProcAddress("wglUseFontOutlinesA");
    if (!_ptr) {
        _ptr = &_fail_wglUseFontOutlinesA;
    }
    _wglUseFontOutlinesA = _ptr;
    return _wglUseFontOutlinesA(hdc, first, count, listBase, deviation, extrusion, format, lpgmf);
}

PFN_WGLUSEFONTOUTLINESA _wglUseFontOutlinesA = &_get_wglUseFontOutlinesA;

static BOOL __stdcall _fail_wglUseFontOutlinesW(HDC hdc, DWORD first, DWORD count, DWORD listBase, FLOAT deviation, FLOAT extrusion, int format, GLYPHMETRICSFLOAT * lpgmf) {
    const char *_name = "wglUseFontOutlinesW";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static BOOL __stdcall _get_wglUseFontOutlinesW(HDC hdc, DWORD first, DWORD count, DWORD listBase, FLOAT deviation, FLOAT extrusion, int format, GLYPHMETRICSFLOAT * lpgmf) {
    PFN_WGLUSEFONTOUTLINESW _ptr;
    _ptr = (PFN_WGLUSEFONTOUTLINESW)_getPublicProcAddress("wglUseFontOutlinesW");
    if (!_ptr) {
        _ptr = &_fail_wglUseFontOutlinesW;
    }
    _wglUseFontOutlinesW = _ptr;
    return _wglUseFontOutlinesW(hdc, first, count, listBase, deviation, extrusion, format, lpgmf);
}

PFN_WGLUSEFONTOUTLINESW _wglUseFontOutlinesW = &_get_wglUseFontOutlinesW;

static HANDLE __stdcall _fail_wglCreateBufferRegionARB(HDC hDC, int iLayerPlane, UINT uType) {
    const char *_name = "wglCreateBufferRegionARB";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static HANDLE __stdcall _get_wglCreateBufferRegionARB(HDC hDC, int iLayerPlane, UINT uType) {
    PFN_WGLCREATEBUFFERREGIONARB _ptr;
    _ptr = (PFN_WGLCREATEBUFFERREGIONARB)_getPrivateProcAddress("wglCreateBufferRegionARB");
    if (!_ptr) {
        _ptr = &_fail_wglCreateBufferRegionARB;
    }
    _wglCreateBufferRegionARB = _ptr;
    return _wglCreateBufferRegionARB(hDC, iLayerPlane, uType);
}

PFN_WGLCREATEBUFFERREGIONARB _wglCreateBufferRegionARB = &_get_wglCreateBufferRegionARB;

static void __stdcall _fail_wglDeleteBufferRegionARB(HANDLE hRegion) {
    const char *_name = "wglDeleteBufferRegionARB";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void __stdcall _get_wglDeleteBufferRegionARB(HANDLE hRegion) {
    PFN_WGLDELETEBUFFERREGIONARB _ptr;
    _ptr = (PFN_WGLDELETEBUFFERREGIONARB)_getPrivateProcAddress("wglDeleteBufferRegionARB");
    if (!_ptr) {
        _ptr = &_fail_wglDeleteBufferRegionARB;
    }
    _wglDeleteBufferRegionARB = _ptr;
    _wglDeleteBufferRegionARB(hRegion);
}

PFN_WGLDELETEBUFFERREGIONARB _wglDeleteBufferRegionARB = &_get_wglDeleteBufferRegionARB;

static BOOL __stdcall _fail_wglSaveBufferRegionARB(HANDLE hRegion, int x, int y, int width, int height) {
    const char *_name = "wglSaveBufferRegionARB";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static BOOL __stdcall _get_wglSaveBufferRegionARB(HANDLE hRegion, int x, int y, int width, int height) {
    PFN_WGLSAVEBUFFERREGIONARB _ptr;
    _ptr = (PFN_WGLSAVEBUFFERREGIONARB)_getPrivateProcAddress("wglSaveBufferRegionARB");
    if (!_ptr) {
        _ptr = &_fail_wglSaveBufferRegionARB;
    }
    _wglSaveBufferRegionARB = _ptr;
    return _wglSaveBufferRegionARB(hRegion, x, y, width, height);
}

PFN_WGLSAVEBUFFERREGIONARB _wglSaveBufferRegionARB = &_get_wglSaveBufferRegionARB;

static BOOL __stdcall _fail_wglRestoreBufferRegionARB(HANDLE hRegion, int x, int y, int width, int height, int xSrc, int ySrc) {
    const char *_name = "wglRestoreBufferRegionARB";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static BOOL __stdcall _get_wglRestoreBufferRegionARB(HANDLE hRegion, int x, int y, int width, int height, int xSrc, int ySrc) {
    PFN_WGLRESTOREBUFFERREGIONARB _ptr;
    _ptr = (PFN_WGLRESTOREBUFFERREGIONARB)_getPrivateProcAddress("wglRestoreBufferRegionARB");
    if (!_ptr) {
        _ptr = &_fail_wglRestoreBufferRegionARB;
    }
    _wglRestoreBufferRegionARB = _ptr;
    return _wglRestoreBufferRegionARB(hRegion, x, y, width, height, xSrc, ySrc);
}

PFN_WGLRESTOREBUFFERREGIONARB _wglRestoreBufferRegionARB = &_get_wglRestoreBufferRegionARB;

static const char * __stdcall _fail_wglGetExtensionsStringARB(HDC hdc) {
    const char *_name = "wglGetExtensionsStringARB";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static const char * __stdcall _get_wglGetExtensionsStringARB(HDC hdc) {
    PFN_WGLGETEXTENSIONSSTRINGARB _ptr;
    _ptr = (PFN_WGLGETEXTENSIONSSTRINGARB)_getPrivateProcAddress("wglGetExtensionsStringARB");
    if (!_ptr) {
        _ptr = &_fail_wglGetExtensionsStringARB;
    }
    _wglGetExtensionsStringARB = _ptr;
    return _wglGetExtensionsStringARB(hdc);
}

PFN_WGLGETEXTENSIONSSTRINGARB _wglGetExtensionsStringARB = &_get_wglGetExtensionsStringARB;

static BOOL __stdcall _fail_wglGetPixelFormatAttribivARB(HDC hdc, int iPixelFormat, int iLayerPlane, UINT nAttributes, int * piAttributes, int * piValues) {
    const char *_name = "wglGetPixelFormatAttribivARB";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static BOOL __stdcall _get_wglGetPixelFormatAttribivARB(HDC hdc, int iPixelFormat, int iLayerPlane, UINT nAttributes, int * piAttributes, int * piValues) {
    PFN_WGLGETPIXELFORMATATTRIBIVARB _ptr;
    _ptr = (PFN_WGLGETPIXELFORMATATTRIBIVARB)_getPrivateProcAddress("wglGetPixelFormatAttribivARB");
    if (!_ptr) {
        _ptr = &_fail_wglGetPixelFormatAttribivARB;
    }
    _wglGetPixelFormatAttribivARB = _ptr;
    return _wglGetPixelFormatAttribivARB(hdc, iPixelFormat, iLayerPlane, nAttributes, piAttributes, piValues);
}

PFN_WGLGETPIXELFORMATATTRIBIVARB _wglGetPixelFormatAttribivARB = &_get_wglGetPixelFormatAttribivARB;

static BOOL __stdcall _fail_wglGetPixelFormatAttribfvARB(HDC hdc, int iPixelFormat, int iLayerPlane, UINT nAttributes, int * piAttributes, FLOAT * pfValues) {
    const char *_name = "wglGetPixelFormatAttribfvARB";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static BOOL __stdcall _get_wglGetPixelFormatAttribfvARB(HDC hdc, int iPixelFormat, int iLayerPlane, UINT nAttributes, int * piAttributes, FLOAT * pfValues) {
    PFN_WGLGETPIXELFORMATATTRIBFVARB _ptr;
    _ptr = (PFN_WGLGETPIXELFORMATATTRIBFVARB)_getPrivateProcAddress("wglGetPixelFormatAttribfvARB");
    if (!_ptr) {
        _ptr = &_fail_wglGetPixelFormatAttribfvARB;
    }
    _wglGetPixelFormatAttribfvARB = _ptr;
    return _wglGetPixelFormatAttribfvARB(hdc, iPixelFormat, iLayerPlane, nAttributes, piAttributes, pfValues);
}

PFN_WGLGETPIXELFORMATATTRIBFVARB _wglGetPixelFormatAttribfvARB = &_get_wglGetPixelFormatAttribfvARB;

static BOOL __stdcall _fail_wglChoosePixelFormatARB(HDC hdc, const int * piAttribIList, const FLOAT * pfAttribFList, UINT nMaxFormats, int * piFormats, UINT * nNumFormats) {
    const char *_name = "wglChoosePixelFormatARB";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static BOOL __stdcall _get_wglChoosePixelFormatARB(HDC hdc, const int * piAttribIList, const FLOAT * pfAttribFList, UINT nMaxFormats, int * piFormats, UINT * nNumFormats) {
    PFN_WGLCHOOSEPIXELFORMATARB _ptr;
    _ptr = (PFN_WGLCHOOSEPIXELFORMATARB)_getPrivateProcAddress("wglChoosePixelFormatARB");
    if (!_ptr) {
        _ptr = &_fail_wglChoosePixelFormatARB;
    }
    _wglChoosePixelFormatARB = _ptr;
    return _wglChoosePixelFormatARB(hdc, piAttribIList, pfAttribFList, nMaxFormats, piFormats, nNumFormats);
}

PFN_WGLCHOOSEPIXELFORMATARB _wglChoosePixelFormatARB = &_get_wglChoosePixelFormatARB;

static BOOL __stdcall _fail_wglMakeContextCurrentARB(HDC hDrawDC, HDC hReadDC, HGLRC hglrc) {
    const char *_name = "wglMakeContextCurrentARB";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static BOOL __stdcall _get_wglMakeContextCurrentARB(HDC hDrawDC, HDC hReadDC, HGLRC hglrc) {
    PFN_WGLMAKECONTEXTCURRENTARB _ptr;
    _ptr = (PFN_WGLMAKECONTEXTCURRENTARB)_getPrivateProcAddress("wglMakeContextCurrentARB");
    if (!_ptr) {
        _ptr = &_fail_wglMakeContextCurrentARB;
    }
    _wglMakeContextCurrentARB = _ptr;
    return _wglMakeContextCurrentARB(hDrawDC, hReadDC, hglrc);
}

PFN_WGLMAKECONTEXTCURRENTARB _wglMakeContextCurrentARB = &_get_wglMakeContextCurrentARB;

static HDC __stdcall _fail_wglGetCurrentReadDCARB(void) {
    const char *_name = "wglGetCurrentReadDCARB";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static HDC __stdcall _get_wglGetCurrentReadDCARB(void) {
    PFN_WGLGETCURRENTREADDCARB _ptr;
    _ptr = (PFN_WGLGETCURRENTREADDCARB)_getPrivateProcAddress("wglGetCurrentReadDCARB");
    if (!_ptr) {
        _ptr = &_fail_wglGetCurrentReadDCARB;
    }
    _wglGetCurrentReadDCARB = _ptr;
    return _wglGetCurrentReadDCARB();
}

PFN_WGLGETCURRENTREADDCARB _wglGetCurrentReadDCARB = &_get_wglGetCurrentReadDCARB;

static HPBUFFERARB __stdcall _fail_wglCreatePbufferARB(HDC hDC, int iPixelFormat, int iWidth, int iHeight, const int * piAttribList) {
    const char *_name = "wglCreatePbufferARB";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static HPBUFFERARB __stdcall _get_wglCreatePbufferARB(HDC hDC, int iPixelFormat, int iWidth, int iHeight, const int * piAttribList) {
    PFN_WGLCREATEPBUFFERARB _ptr;
    _ptr = (PFN_WGLCREATEPBUFFERARB)_getPrivateProcAddress("wglCreatePbufferARB");
    if (!_ptr) {
        _ptr = &_fail_wglCreatePbufferARB;
    }
    _wglCreatePbufferARB = _ptr;
    return _wglCreatePbufferARB(hDC, iPixelFormat, iWidth, iHeight, piAttribList);
}

PFN_WGLCREATEPBUFFERARB _wglCreatePbufferARB = &_get_wglCreatePbufferARB;

static HDC __stdcall _fail_wglGetPbufferDCARB(HPBUFFERARB hPbuffer) {
    const char *_name = "wglGetPbufferDCARB";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static HDC __stdcall _get_wglGetPbufferDCARB(HPBUFFERARB hPbuffer) {
    PFN_WGLGETPBUFFERDCARB _ptr;
    _ptr = (PFN_WGLGETPBUFFERDCARB)_getPrivateProcAddress("wglGetPbufferDCARB");
    if (!_ptr) {
        _ptr = &_fail_wglGetPbufferDCARB;
    }
    _wglGetPbufferDCARB = _ptr;
    return _wglGetPbufferDCARB(hPbuffer);
}

PFN_WGLGETPBUFFERDCARB _wglGetPbufferDCARB = &_get_wglGetPbufferDCARB;

static int __stdcall _fail_wglReleasePbufferDCARB(HPBUFFERARB hPbuffer, HDC hDC) {
    const char *_name = "wglReleasePbufferDCARB";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static int __stdcall _get_wglReleasePbufferDCARB(HPBUFFERARB hPbuffer, HDC hDC) {
    PFN_WGLRELEASEPBUFFERDCARB _ptr;
    _ptr = (PFN_WGLRELEASEPBUFFERDCARB)_getPrivateProcAddress("wglReleasePbufferDCARB");
    if (!_ptr) {
        _ptr = &_fail_wglReleasePbufferDCARB;
    }
    _wglReleasePbufferDCARB = _ptr;
    return _wglReleasePbufferDCARB(hPbuffer, hDC);
}

PFN_WGLRELEASEPBUFFERDCARB _wglReleasePbufferDCARB = &_get_wglReleasePbufferDCARB;

static BOOL __stdcall _fail_wglDestroyPbufferARB(HPBUFFERARB hPbuffer) {
    const char *_name = "wglDestroyPbufferARB";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static BOOL __stdcall _get_wglDestroyPbufferARB(HPBUFFERARB hPbuffer) {
    PFN_WGLDESTROYPBUFFERARB _ptr;
    _ptr = (PFN_WGLDESTROYPBUFFERARB)_getPrivateProcAddress("wglDestroyPbufferARB");
    if (!_ptr) {
        _ptr = &_fail_wglDestroyPbufferARB;
    }
    _wglDestroyPbufferARB = _ptr;
    return _wglDestroyPbufferARB(hPbuffer);
}

PFN_WGLDESTROYPBUFFERARB _wglDestroyPbufferARB = &_get_wglDestroyPbufferARB;

static BOOL __stdcall _fail_wglQueryPbufferARB(HPBUFFERARB hPbuffer, int iAttribute, int * piValue) {
    const char *_name = "wglQueryPbufferARB";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static BOOL __stdcall _get_wglQueryPbufferARB(HPBUFFERARB hPbuffer, int iAttribute, int * piValue) {
    PFN_WGLQUERYPBUFFERARB _ptr;
    _ptr = (PFN_WGLQUERYPBUFFERARB)_getPrivateProcAddress("wglQueryPbufferARB");
    if (!_ptr) {
        _ptr = &_fail_wglQueryPbufferARB;
    }
    _wglQueryPbufferARB = _ptr;
    return _wglQueryPbufferARB(hPbuffer, iAttribute, piValue);
}

PFN_WGLQUERYPBUFFERARB _wglQueryPbufferARB = &_get_wglQueryPbufferARB;

static BOOL __stdcall _fail_wglBindTexImageARB(HPBUFFERARB hPbuffer, int iBuffer) {
    const char *_name = "wglBindTexImageARB";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static BOOL __stdcall _get_wglBindTexImageARB(HPBUFFERARB hPbuffer, int iBuffer) {
    PFN_WGLBINDTEXIMAGEARB _ptr;
    _ptr = (PFN_WGLBINDTEXIMAGEARB)_getPrivateProcAddress("wglBindTexImageARB");
    if (!_ptr) {
        _ptr = &_fail_wglBindTexImageARB;
    }
    _wglBindTexImageARB = _ptr;
    return _wglBindTexImageARB(hPbuffer, iBuffer);
}

PFN_WGLBINDTEXIMAGEARB _wglBindTexImageARB = &_get_wglBindTexImageARB;

static BOOL __stdcall _fail_wglReleaseTexImageARB(HPBUFFERARB hPbuffer, int iBuffer) {
    const char *_name = "wglReleaseTexImageARB";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static BOOL __stdcall _get_wglReleaseTexImageARB(HPBUFFERARB hPbuffer, int iBuffer) {
    PFN_WGLRELEASETEXIMAGEARB _ptr;
    _ptr = (PFN_WGLRELEASETEXIMAGEARB)_getPrivateProcAddress("wglReleaseTexImageARB");
    if (!_ptr) {
        _ptr = &_fail_wglReleaseTexImageARB;
    }
    _wglReleaseTexImageARB = _ptr;
    return _wglReleaseTexImageARB(hPbuffer, iBuffer);
}

PFN_WGLRELEASETEXIMAGEARB _wglReleaseTexImageARB = &_get_wglReleaseTexImageARB;

static BOOL __stdcall _fail_wglSetPbufferAttribARB(HPBUFFERARB hPbuffer, const int * piAttribList) {
    const char *_name = "wglSetPbufferAttribARB";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static BOOL __stdcall _get_wglSetPbufferAttribARB(HPBUFFERARB hPbuffer, const int * piAttribList) {
    PFN_WGLSETPBUFFERATTRIBARB _ptr;
    _ptr = (PFN_WGLSETPBUFFERATTRIBARB)_getPrivateProcAddress("wglSetPbufferAttribARB");
    if (!_ptr) {
        _ptr = &_fail_wglSetPbufferAttribARB;
    }
    _wglSetPbufferAttribARB = _ptr;
    return _wglSetPbufferAttribARB(hPbuffer, piAttribList);
}

PFN_WGLSETPBUFFERATTRIBARB _wglSetPbufferAttribARB = &_get_wglSetPbufferAttribARB;

static HGLRC __stdcall _fail_wglCreateContextAttribsARB(HDC hDC, HGLRC hShareContext, const int * attribList) {
    const char *_name = "wglCreateContextAttribsARB";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static HGLRC __stdcall _get_wglCreateContextAttribsARB(HDC hDC, HGLRC hShareContext, const int * attribList) {
    PFN_WGLCREATECONTEXTATTRIBSARB _ptr;
    _ptr = (PFN_WGLCREATECONTEXTATTRIBSARB)_getPrivateProcAddress("wglCreateContextAttribsARB");
    if (!_ptr) {
        _ptr = &_fail_wglCreateContextAttribsARB;
    }
    _wglCreateContextAttribsARB = _ptr;
    return _wglCreateContextAttribsARB(hDC, hShareContext, attribList);
}

PFN_WGLCREATECONTEXTATTRIBSARB _wglCreateContextAttribsARB = &_get_wglCreateContextAttribsARB;

static GLboolean __stdcall _fail_wglCreateDisplayColorTableEXT(GLushort id) {
    const char *_name = "wglCreateDisplayColorTableEXT";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static GLboolean __stdcall _get_wglCreateDisplayColorTableEXT(GLushort id) {
    PFN_WGLCREATEDISPLAYCOLORTABLEEXT _ptr;
    _ptr = (PFN_WGLCREATEDISPLAYCOLORTABLEEXT)_getPrivateProcAddress("wglCreateDisplayColorTableEXT");
    if (!_ptr) {
        _ptr = &_fail_wglCreateDisplayColorTableEXT;
    }
    _wglCreateDisplayColorTableEXT = _ptr;
    return _wglCreateDisplayColorTableEXT(id);
}

PFN_WGLCREATEDISPLAYCOLORTABLEEXT _wglCreateDisplayColorTableEXT = &_get_wglCreateDisplayColorTableEXT;

static GLboolean __stdcall _fail_wglLoadDisplayColorTableEXT(const GLushort * table, GLuint length) {
    const char *_name = "wglLoadDisplayColorTableEXT";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static GLboolean __stdcall _get_wglLoadDisplayColorTableEXT(const GLushort * table, GLuint length) {
    PFN_WGLLOADDISPLAYCOLORTABLEEXT _ptr;
    _ptr = (PFN_WGLLOADDISPLAYCOLORTABLEEXT)_getPrivateProcAddress("wglLoadDisplayColorTableEXT");
    if (!_ptr) {
        _ptr = &_fail_wglLoadDisplayColorTableEXT;
    }
    _wglLoadDisplayColorTableEXT = _ptr;
    return _wglLoadDisplayColorTableEXT(table, length);
}

PFN_WGLLOADDISPLAYCOLORTABLEEXT _wglLoadDisplayColorTableEXT = &_get_wglLoadDisplayColorTableEXT;

static GLboolean __stdcall _fail_wglBindDisplayColorTableEXT(GLushort id) {
    const char *_name = "wglBindDisplayColorTableEXT";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static GLboolean __stdcall _get_wglBindDisplayColorTableEXT(GLushort id) {
    PFN_WGLBINDDISPLAYCOLORTABLEEXT _ptr;
    _ptr = (PFN_WGLBINDDISPLAYCOLORTABLEEXT)_getPrivateProcAddress("wglBindDisplayColorTableEXT");
    if (!_ptr) {
        _ptr = &_fail_wglBindDisplayColorTableEXT;
    }
    _wglBindDisplayColorTableEXT = _ptr;
    return _wglBindDisplayColorTableEXT(id);
}

PFN_WGLBINDDISPLAYCOLORTABLEEXT _wglBindDisplayColorTableEXT = &_get_wglBindDisplayColorTableEXT;

static void __stdcall _fail_wglDestroyDisplayColorTableEXT(GLushort id) {
    const char *_name = "wglDestroyDisplayColorTableEXT";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void __stdcall _get_wglDestroyDisplayColorTableEXT(GLushort id) {
    PFN_WGLDESTROYDISPLAYCOLORTABLEEXT _ptr;
    _ptr = (PFN_WGLDESTROYDISPLAYCOLORTABLEEXT)_getPrivateProcAddress("wglDestroyDisplayColorTableEXT");
    if (!_ptr) {
        _ptr = &_fail_wglDestroyDisplayColorTableEXT;
    }
    _wglDestroyDisplayColorTableEXT = _ptr;
    _wglDestroyDisplayColorTableEXT(id);
}

PFN_WGLDESTROYDISPLAYCOLORTABLEEXT _wglDestroyDisplayColorTableEXT = &_get_wglDestroyDisplayColorTableEXT;

static const char * __stdcall _fail_wglGetExtensionsStringEXT(void) {
    const char *_name = "wglGetExtensionsStringEXT";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static const char * __stdcall _get_wglGetExtensionsStringEXT(void) {
    PFN_WGLGETEXTENSIONSSTRINGEXT _ptr;
    _ptr = (PFN_WGLGETEXTENSIONSSTRINGEXT)_getPrivateProcAddress("wglGetExtensionsStringEXT");
    if (!_ptr) {
        _ptr = &_fail_wglGetExtensionsStringEXT;
    }
    _wglGetExtensionsStringEXT = _ptr;
    return _wglGetExtensionsStringEXT();
}

PFN_WGLGETEXTENSIONSSTRINGEXT _wglGetExtensionsStringEXT = &_get_wglGetExtensionsStringEXT;

static BOOL __stdcall _fail_wglMakeContextCurrentEXT(HDC hDrawDC, HDC hReadDC, HGLRC hglrc) {
    const char *_name = "wglMakeContextCurrentEXT";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static BOOL __stdcall _get_wglMakeContextCurrentEXT(HDC hDrawDC, HDC hReadDC, HGLRC hglrc) {
    PFN_WGLMAKECONTEXTCURRENTEXT _ptr;
    _ptr = (PFN_WGLMAKECONTEXTCURRENTEXT)_getPrivateProcAddress("wglMakeContextCurrentEXT");
    if (!_ptr) {
        _ptr = &_fail_wglMakeContextCurrentEXT;
    }
    _wglMakeContextCurrentEXT = _ptr;
    return _wglMakeContextCurrentEXT(hDrawDC, hReadDC, hglrc);
}

PFN_WGLMAKECONTEXTCURRENTEXT _wglMakeContextCurrentEXT = &_get_wglMakeContextCurrentEXT;

static HDC __stdcall _fail_wglGetCurrentReadDCEXT(void) {
    const char *_name = "wglGetCurrentReadDCEXT";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static HDC __stdcall _get_wglGetCurrentReadDCEXT(void) {
    PFN_WGLGETCURRENTREADDCEXT _ptr;
    _ptr = (PFN_WGLGETCURRENTREADDCEXT)_getPrivateProcAddress("wglGetCurrentReadDCEXT");
    if (!_ptr) {
        _ptr = &_fail_wglGetCurrentReadDCEXT;
    }
    _wglGetCurrentReadDCEXT = _ptr;
    return _wglGetCurrentReadDCEXT();
}

PFN_WGLGETCURRENTREADDCEXT _wglGetCurrentReadDCEXT = &_get_wglGetCurrentReadDCEXT;

static HPBUFFEREXT __stdcall _fail_wglCreatePbufferEXT(HDC hDC, int iPixelFormat, int iWidth, int iHeight, const int * piAttribList) {
    const char *_name = "wglCreatePbufferEXT";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static HPBUFFEREXT __stdcall _get_wglCreatePbufferEXT(HDC hDC, int iPixelFormat, int iWidth, int iHeight, const int * piAttribList) {
    PFN_WGLCREATEPBUFFEREXT _ptr;
    _ptr = (PFN_WGLCREATEPBUFFEREXT)_getPrivateProcAddress("wglCreatePbufferEXT");
    if (!_ptr) {
        _ptr = &_fail_wglCreatePbufferEXT;
    }
    _wglCreatePbufferEXT = _ptr;
    return _wglCreatePbufferEXT(hDC, iPixelFormat, iWidth, iHeight, piAttribList);
}

PFN_WGLCREATEPBUFFEREXT _wglCreatePbufferEXT = &_get_wglCreatePbufferEXT;

static HDC __stdcall _fail_wglGetPbufferDCEXT(HPBUFFEREXT hPbuffer) {
    const char *_name = "wglGetPbufferDCEXT";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static HDC __stdcall _get_wglGetPbufferDCEXT(HPBUFFEREXT hPbuffer) {
    PFN_WGLGETPBUFFERDCEXT _ptr;
    _ptr = (PFN_WGLGETPBUFFERDCEXT)_getPrivateProcAddress("wglGetPbufferDCEXT");
    if (!_ptr) {
        _ptr = &_fail_wglGetPbufferDCEXT;
    }
    _wglGetPbufferDCEXT = _ptr;
    return _wglGetPbufferDCEXT(hPbuffer);
}

PFN_WGLGETPBUFFERDCEXT _wglGetPbufferDCEXT = &_get_wglGetPbufferDCEXT;

static int __stdcall _fail_wglReleasePbufferDCEXT(HPBUFFEREXT hPbuffer, HDC hDC) {
    const char *_name = "wglReleasePbufferDCEXT";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static int __stdcall _get_wglReleasePbufferDCEXT(HPBUFFEREXT hPbuffer, HDC hDC) {
    PFN_WGLRELEASEPBUFFERDCEXT _ptr;
    _ptr = (PFN_WGLRELEASEPBUFFERDCEXT)_getPrivateProcAddress("wglReleasePbufferDCEXT");
    if (!_ptr) {
        _ptr = &_fail_wglReleasePbufferDCEXT;
    }
    _wglReleasePbufferDCEXT = _ptr;
    return _wglReleasePbufferDCEXT(hPbuffer, hDC);
}

PFN_WGLRELEASEPBUFFERDCEXT _wglReleasePbufferDCEXT = &_get_wglReleasePbufferDCEXT;

static BOOL __stdcall _fail_wglDestroyPbufferEXT(HPBUFFEREXT hPbuffer) {
    const char *_name = "wglDestroyPbufferEXT";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static BOOL __stdcall _get_wglDestroyPbufferEXT(HPBUFFEREXT hPbuffer) {
    PFN_WGLDESTROYPBUFFEREXT _ptr;
    _ptr = (PFN_WGLDESTROYPBUFFEREXT)_getPrivateProcAddress("wglDestroyPbufferEXT");
    if (!_ptr) {
        _ptr = &_fail_wglDestroyPbufferEXT;
    }
    _wglDestroyPbufferEXT = _ptr;
    return _wglDestroyPbufferEXT(hPbuffer);
}

PFN_WGLDESTROYPBUFFEREXT _wglDestroyPbufferEXT = &_get_wglDestroyPbufferEXT;

static BOOL __stdcall _fail_wglQueryPbufferEXT(HPBUFFEREXT hPbuffer, int iAttribute, int * piValue) {
    const char *_name = "wglQueryPbufferEXT";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static BOOL __stdcall _get_wglQueryPbufferEXT(HPBUFFEREXT hPbuffer, int iAttribute, int * piValue) {
    PFN_WGLQUERYPBUFFEREXT _ptr;
    _ptr = (PFN_WGLQUERYPBUFFEREXT)_getPrivateProcAddress("wglQueryPbufferEXT");
    if (!_ptr) {
        _ptr = &_fail_wglQueryPbufferEXT;
    }
    _wglQueryPbufferEXT = _ptr;
    return _wglQueryPbufferEXT(hPbuffer, iAttribute, piValue);
}

PFN_WGLQUERYPBUFFEREXT _wglQueryPbufferEXT = &_get_wglQueryPbufferEXT;

static BOOL __stdcall _fail_wglGetPixelFormatAttribivEXT(HDC hdc, int iPixelFormat, int iLayerPlane, UINT nAttributes, int * piAttributes, int * piValues) {
    const char *_name = "wglGetPixelFormatAttribivEXT";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static BOOL __stdcall _get_wglGetPixelFormatAttribivEXT(HDC hdc, int iPixelFormat, int iLayerPlane, UINT nAttributes, int * piAttributes, int * piValues) {
    PFN_WGLGETPIXELFORMATATTRIBIVEXT _ptr;
    _ptr = (PFN_WGLGETPIXELFORMATATTRIBIVEXT)_getPrivateProcAddress("wglGetPixelFormatAttribivEXT");
    if (!_ptr) {
        _ptr = &_fail_wglGetPixelFormatAttribivEXT;
    }
    _wglGetPixelFormatAttribivEXT = _ptr;
    return _wglGetPixelFormatAttribivEXT(hdc, iPixelFormat, iLayerPlane, nAttributes, piAttributes, piValues);
}

PFN_WGLGETPIXELFORMATATTRIBIVEXT _wglGetPixelFormatAttribivEXT = &_get_wglGetPixelFormatAttribivEXT;

static BOOL __stdcall _fail_wglGetPixelFormatAttribfvEXT(HDC hdc, int iPixelFormat, int iLayerPlane, UINT nAttributes, int * piAttributes, FLOAT * pfValues) {
    const char *_name = "wglGetPixelFormatAttribfvEXT";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static BOOL __stdcall _get_wglGetPixelFormatAttribfvEXT(HDC hdc, int iPixelFormat, int iLayerPlane, UINT nAttributes, int * piAttributes, FLOAT * pfValues) {
    PFN_WGLGETPIXELFORMATATTRIBFVEXT _ptr;
    _ptr = (PFN_WGLGETPIXELFORMATATTRIBFVEXT)_getPrivateProcAddress("wglGetPixelFormatAttribfvEXT");
    if (!_ptr) {
        _ptr = &_fail_wglGetPixelFormatAttribfvEXT;
    }
    _wglGetPixelFormatAttribfvEXT = _ptr;
    return _wglGetPixelFormatAttribfvEXT(hdc, iPixelFormat, iLayerPlane, nAttributes, piAttributes, pfValues);
}

PFN_WGLGETPIXELFORMATATTRIBFVEXT _wglGetPixelFormatAttribfvEXT = &_get_wglGetPixelFormatAttribfvEXT;

static BOOL __stdcall _fail_wglChoosePixelFormatEXT(HDC hdc, const int * piAttribIList, const FLOAT * pfAttribFList, UINT nMaxFormats, int * piFormats, UINT * nNumFormats) {
    const char *_name = "wglChoosePixelFormatEXT";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static BOOL __stdcall _get_wglChoosePixelFormatEXT(HDC hdc, const int * piAttribIList, const FLOAT * pfAttribFList, UINT nMaxFormats, int * piFormats, UINT * nNumFormats) {
    PFN_WGLCHOOSEPIXELFORMATEXT _ptr;
    _ptr = (PFN_WGLCHOOSEPIXELFORMATEXT)_getPrivateProcAddress("wglChoosePixelFormatEXT");
    if (!_ptr) {
        _ptr = &_fail_wglChoosePixelFormatEXT;
    }
    _wglChoosePixelFormatEXT = _ptr;
    return _wglChoosePixelFormatEXT(hdc, piAttribIList, pfAttribFList, nMaxFormats, piFormats, nNumFormats);
}

PFN_WGLCHOOSEPIXELFORMATEXT _wglChoosePixelFormatEXT = &_get_wglChoosePixelFormatEXT;

static BOOL __stdcall _fail_wglSwapIntervalEXT(int interval) {
    const char *_name = "wglSwapIntervalEXT";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static BOOL __stdcall _get_wglSwapIntervalEXT(int interval) {
    PFN_WGLSWAPINTERVALEXT _ptr;
    _ptr = (PFN_WGLSWAPINTERVALEXT)_getPrivateProcAddress("wglSwapIntervalEXT");
    if (!_ptr) {
        _ptr = &_fail_wglSwapIntervalEXT;
    }
    _wglSwapIntervalEXT = _ptr;
    return _wglSwapIntervalEXT(interval);
}

PFN_WGLSWAPINTERVALEXT _wglSwapIntervalEXT = &_get_wglSwapIntervalEXT;

static int __stdcall _fail_wglGetSwapIntervalEXT(void) {
    const char *_name = "wglGetSwapIntervalEXT";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static int __stdcall _get_wglGetSwapIntervalEXT(void) {
    PFN_WGLGETSWAPINTERVALEXT _ptr;
    _ptr = (PFN_WGLGETSWAPINTERVALEXT)_getPrivateProcAddress("wglGetSwapIntervalEXT");
    if (!_ptr) {
        _ptr = &_fail_wglGetSwapIntervalEXT;
    }
    _wglGetSwapIntervalEXT = _ptr;
    return _wglGetSwapIntervalEXT();
}

PFN_WGLGETSWAPINTERVALEXT _wglGetSwapIntervalEXT = &_get_wglGetSwapIntervalEXT;

static void * __stdcall _fail_wglAllocateMemoryNV(GLsizei size, GLfloat readfreq, GLfloat writefreq, GLfloat priority) {
    const char *_name = "wglAllocateMemoryNV";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static void * __stdcall _get_wglAllocateMemoryNV(GLsizei size, GLfloat readfreq, GLfloat writefreq, GLfloat priority) {
    PFN_WGLALLOCATEMEMORYNV _ptr;
    _ptr = (PFN_WGLALLOCATEMEMORYNV)_getPrivateProcAddress("wglAllocateMemoryNV");
    if (!_ptr) {
        _ptr = &_fail_wglAllocateMemoryNV;
    }
    _wglAllocateMemoryNV = _ptr;
    return _wglAllocateMemoryNV(size, readfreq, writefreq, priority);
}

PFN_WGLALLOCATEMEMORYNV _wglAllocateMemoryNV = &_get_wglAllocateMemoryNV;

static void __stdcall _fail_wglFreeMemoryNV(void * pointer) {
    const char *_name = "wglFreeMemoryNV";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void __stdcall _get_wglFreeMemoryNV(void * pointer) {
    PFN_WGLFREEMEMORYNV _ptr;
    _ptr = (PFN_WGLFREEMEMORYNV)_getPrivateProcAddress("wglFreeMemoryNV");
    if (!_ptr) {
        _ptr = &_fail_wglFreeMemoryNV;
    }
    _wglFreeMemoryNV = _ptr;
    _wglFreeMemoryNV(pointer);
}

PFN_WGLFREEMEMORYNV _wglFreeMemoryNV = &_get_wglFreeMemoryNV;

static BOOL __stdcall _fail_wglGetSyncValuesOML(HDC hdc, INT64 * ust, INT64 * msc, INT64 * sbc) {
    const char *_name = "wglGetSyncValuesOML";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static BOOL __stdcall _get_wglGetSyncValuesOML(HDC hdc, INT64 * ust, INT64 * msc, INT64 * sbc) {
    PFN_WGLGETSYNCVALUESOML _ptr;
    _ptr = (PFN_WGLGETSYNCVALUESOML)_getPrivateProcAddress("wglGetSyncValuesOML");
    if (!_ptr) {
        _ptr = &_fail_wglGetSyncValuesOML;
    }
    _wglGetSyncValuesOML = _ptr;
    return _wglGetSyncValuesOML(hdc, ust, msc, sbc);
}

PFN_WGLGETSYNCVALUESOML _wglGetSyncValuesOML = &_get_wglGetSyncValuesOML;

static BOOL __stdcall _fail_wglGetMscRateOML(HDC hdc, INT32 * numerator, INT32 * denominator) {
    const char *_name = "wglGetMscRateOML";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static BOOL __stdcall _get_wglGetMscRateOML(HDC hdc, INT32 * numerator, INT32 * denominator) {
    PFN_WGLGETMSCRATEOML _ptr;
    _ptr = (PFN_WGLGETMSCRATEOML)_getPrivateProcAddress("wglGetMscRateOML");
    if (!_ptr) {
        _ptr = &_fail_wglGetMscRateOML;
    }
    _wglGetMscRateOML = _ptr;
    return _wglGetMscRateOML(hdc, numerator, denominator);
}

PFN_WGLGETMSCRATEOML _wglGetMscRateOML = &_get_wglGetMscRateOML;

static INT64 __stdcall _fail_wglSwapBuffersMscOML(HDC hdc, INT64 target_msc, INT64 divisor, INT64 remainder) {
    const char *_name = "wglSwapBuffersMscOML";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static INT64 __stdcall _get_wglSwapBuffersMscOML(HDC hdc, INT64 target_msc, INT64 divisor, INT64 remainder) {
    PFN_WGLSWAPBUFFERSMSCOML _ptr;
    _ptr = (PFN_WGLSWAPBUFFERSMSCOML)_getPrivateProcAddress("wglSwapBuffersMscOML");
    if (!_ptr) {
        _ptr = &_fail_wglSwapBuffersMscOML;
    }
    _wglSwapBuffersMscOML = _ptr;
    return _wglSwapBuffersMscOML(hdc, target_msc, divisor, remainder);
}

PFN_WGLSWAPBUFFERSMSCOML _wglSwapBuffersMscOML = &_get_wglSwapBuffersMscOML;

static INT64 __stdcall _fail_wglSwapLayerBuffersMscOML(HDC hdc, int fuPlanes, INT64 target_msc, INT64 divisor, INT64 remainder) {
    const char *_name = "wglSwapLayerBuffersMscOML";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static INT64 __stdcall _get_wglSwapLayerBuffersMscOML(HDC hdc, int fuPlanes, INT64 target_msc, INT64 divisor, INT64 remainder) {
    PFN_WGLSWAPLAYERBUFFERSMSCOML _ptr;
    _ptr = (PFN_WGLSWAPLAYERBUFFERSMSCOML)_getPrivateProcAddress("wglSwapLayerBuffersMscOML");
    if (!_ptr) {
        _ptr = &_fail_wglSwapLayerBuffersMscOML;
    }
    _wglSwapLayerBuffersMscOML = _ptr;
    return _wglSwapLayerBuffersMscOML(hdc, fuPlanes, target_msc, divisor, remainder);
}

PFN_WGLSWAPLAYERBUFFERSMSCOML _wglSwapLayerBuffersMscOML = &_get_wglSwapLayerBuffersMscOML;

static BOOL __stdcall _fail_wglWaitForMscOML(HDC hdc, INT64 target_msc, INT64 divisor, INT64 remainder, INT64 * ust, INT64 * msc, INT64 * sbc) {
    const char *_name = "wglWaitForMscOML";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static BOOL __stdcall _get_wglWaitForMscOML(HDC hdc, INT64 target_msc, INT64 divisor, INT64 remainder, INT64 * ust, INT64 * msc, INT64 * sbc) {
    PFN_WGLWAITFORMSCOML _ptr;
    _ptr = (PFN_WGLWAITFORMSCOML)_getPrivateProcAddress("wglWaitForMscOML");
    if (!_ptr) {
        _ptr = &_fail_wglWaitForMscOML;
    }
    _wglWaitForMscOML = _ptr;
    return _wglWaitForMscOML(hdc, target_msc, divisor, remainder, ust, msc, sbc);
}

PFN_WGLWAITFORMSCOML _wglWaitForMscOML = &_get_wglWaitForMscOML;

static BOOL __stdcall _fail_wglWaitForSbcOML(HDC hdc, INT64 target_sbc, INT64 * ust, INT64 * msc, INT64 * sbc) {
    const char *_name = "wglWaitForSbcOML";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static BOOL __stdcall _get_wglWaitForSbcOML(HDC hdc, INT64 target_sbc, INT64 * ust, INT64 * msc, INT64 * sbc) {
    PFN_WGLWAITFORSBCOML _ptr;
    _ptr = (PFN_WGLWAITFORSBCOML)_getPrivateProcAddress("wglWaitForSbcOML");
    if (!_ptr) {
        _ptr = &_fail_wglWaitForSbcOML;
    }
    _wglWaitForSbcOML = _ptr;
    return _wglWaitForSbcOML(hdc, target_sbc, ust, msc, sbc);
}

PFN_WGLWAITFORSBCOML _wglWaitForSbcOML = &_get_wglWaitForSbcOML;

static BOOL __stdcall _fail_wglGetDigitalVideoParametersI3D(HDC hDC, int iAttribute, int * piValue) {
    const char *_name = "wglGetDigitalVideoParametersI3D";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static BOOL __stdcall _get_wglGetDigitalVideoParametersI3D(HDC hDC, int iAttribute, int * piValue) {
    PFN_WGLGETDIGITALVIDEOPARAMETERSI3D _ptr;
    _ptr = (PFN_WGLGETDIGITALVIDEOPARAMETERSI3D)_getPrivateProcAddress("wglGetDigitalVideoParametersI3D");
    if (!_ptr) {
        _ptr = &_fail_wglGetDigitalVideoParametersI3D;
    }
    _wglGetDigitalVideoParametersI3D = _ptr;
    return _wglGetDigitalVideoParametersI3D(hDC, iAttribute, piValue);
}

PFN_WGLGETDIGITALVIDEOPARAMETERSI3D _wglGetDigitalVideoParametersI3D = &_get_wglGetDigitalVideoParametersI3D;

static BOOL __stdcall _fail_wglSetDigitalVideoParametersI3D(HDC hDC, int iAttribute, const int * piValue) {
    const char *_name = "wglSetDigitalVideoParametersI3D";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static BOOL __stdcall _get_wglSetDigitalVideoParametersI3D(HDC hDC, int iAttribute, const int * piValue) {
    PFN_WGLSETDIGITALVIDEOPARAMETERSI3D _ptr;
    _ptr = (PFN_WGLSETDIGITALVIDEOPARAMETERSI3D)_getPrivateProcAddress("wglSetDigitalVideoParametersI3D");
    if (!_ptr) {
        _ptr = &_fail_wglSetDigitalVideoParametersI3D;
    }
    _wglSetDigitalVideoParametersI3D = _ptr;
    return _wglSetDigitalVideoParametersI3D(hDC, iAttribute, piValue);
}

PFN_WGLSETDIGITALVIDEOPARAMETERSI3D _wglSetDigitalVideoParametersI3D = &_get_wglSetDigitalVideoParametersI3D;

static BOOL __stdcall _fail_wglGetGammaTableParametersI3D(HDC hDC, int iAttribute, int * piValue) {
    const char *_name = "wglGetGammaTableParametersI3D";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static BOOL __stdcall _get_wglGetGammaTableParametersI3D(HDC hDC, int iAttribute, int * piValue) {
    PFN_WGLGETGAMMATABLEPARAMETERSI3D _ptr;
    _ptr = (PFN_WGLGETGAMMATABLEPARAMETERSI3D)_getPrivateProcAddress("wglGetGammaTableParametersI3D");
    if (!_ptr) {
        _ptr = &_fail_wglGetGammaTableParametersI3D;
    }
    _wglGetGammaTableParametersI3D = _ptr;
    return _wglGetGammaTableParametersI3D(hDC, iAttribute, piValue);
}

PFN_WGLGETGAMMATABLEPARAMETERSI3D _wglGetGammaTableParametersI3D = &_get_wglGetGammaTableParametersI3D;

static BOOL __stdcall _fail_wglSetGammaTableParametersI3D(HDC hDC, int iAttribute, const int * piValue) {
    const char *_name = "wglSetGammaTableParametersI3D";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static BOOL __stdcall _get_wglSetGammaTableParametersI3D(HDC hDC, int iAttribute, const int * piValue) {
    PFN_WGLSETGAMMATABLEPARAMETERSI3D _ptr;
    _ptr = (PFN_WGLSETGAMMATABLEPARAMETERSI3D)_getPrivateProcAddress("wglSetGammaTableParametersI3D");
    if (!_ptr) {
        _ptr = &_fail_wglSetGammaTableParametersI3D;
    }
    _wglSetGammaTableParametersI3D = _ptr;
    return _wglSetGammaTableParametersI3D(hDC, iAttribute, piValue);
}

PFN_WGLSETGAMMATABLEPARAMETERSI3D _wglSetGammaTableParametersI3D = &_get_wglSetGammaTableParametersI3D;

static BOOL __stdcall _fail_wglGetGammaTableI3D(HDC hDC, int iEntries, USHORT * puRed, USHORT * puGreen, USHORT * puBlue) {
    const char *_name = "wglGetGammaTableI3D";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static BOOL __stdcall _get_wglGetGammaTableI3D(HDC hDC, int iEntries, USHORT * puRed, USHORT * puGreen, USHORT * puBlue) {
    PFN_WGLGETGAMMATABLEI3D _ptr;
    _ptr = (PFN_WGLGETGAMMATABLEI3D)_getPrivateProcAddress("wglGetGammaTableI3D");
    if (!_ptr) {
        _ptr = &_fail_wglGetGammaTableI3D;
    }
    _wglGetGammaTableI3D = _ptr;
    return _wglGetGammaTableI3D(hDC, iEntries, puRed, puGreen, puBlue);
}

PFN_WGLGETGAMMATABLEI3D _wglGetGammaTableI3D = &_get_wglGetGammaTableI3D;

static BOOL __stdcall _fail_wglSetGammaTableI3D(HDC hDC, int iEntries, const USHORT * puRed, const USHORT * puGreen, const USHORT * puBlue) {
    const char *_name = "wglSetGammaTableI3D";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static BOOL __stdcall _get_wglSetGammaTableI3D(HDC hDC, int iEntries, const USHORT * puRed, const USHORT * puGreen, const USHORT * puBlue) {
    PFN_WGLSETGAMMATABLEI3D _ptr;
    _ptr = (PFN_WGLSETGAMMATABLEI3D)_getPrivateProcAddress("wglSetGammaTableI3D");
    if (!_ptr) {
        _ptr = &_fail_wglSetGammaTableI3D;
    }
    _wglSetGammaTableI3D = _ptr;
    return _wglSetGammaTableI3D(hDC, iEntries, puRed, puGreen, puBlue);
}

PFN_WGLSETGAMMATABLEI3D _wglSetGammaTableI3D = &_get_wglSetGammaTableI3D;

static BOOL __stdcall _fail_wglEnableGenlockI3D(HDC hDC) {
    const char *_name = "wglEnableGenlockI3D";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static BOOL __stdcall _get_wglEnableGenlockI3D(HDC hDC) {
    PFN_WGLENABLEGENLOCKI3D _ptr;
    _ptr = (PFN_WGLENABLEGENLOCKI3D)_getPrivateProcAddress("wglEnableGenlockI3D");
    if (!_ptr) {
        _ptr = &_fail_wglEnableGenlockI3D;
    }
    _wglEnableGenlockI3D = _ptr;
    return _wglEnableGenlockI3D(hDC);
}

PFN_WGLENABLEGENLOCKI3D _wglEnableGenlockI3D = &_get_wglEnableGenlockI3D;

static BOOL __stdcall _fail_wglDisableGenlockI3D(HDC hDC) {
    const char *_name = "wglDisableGenlockI3D";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static BOOL __stdcall _get_wglDisableGenlockI3D(HDC hDC) {
    PFN_WGLDISABLEGENLOCKI3D _ptr;
    _ptr = (PFN_WGLDISABLEGENLOCKI3D)_getPrivateProcAddress("wglDisableGenlockI3D");
    if (!_ptr) {
        _ptr = &_fail_wglDisableGenlockI3D;
    }
    _wglDisableGenlockI3D = _ptr;
    return _wglDisableGenlockI3D(hDC);
}

PFN_WGLDISABLEGENLOCKI3D _wglDisableGenlockI3D = &_get_wglDisableGenlockI3D;

static BOOL __stdcall _fail_wglIsEnabledGenlockI3D(HDC hDC, BOOL * pFlag) {
    const char *_name = "wglIsEnabledGenlockI3D";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static BOOL __stdcall _get_wglIsEnabledGenlockI3D(HDC hDC, BOOL * pFlag) {
    PFN_WGLISENABLEDGENLOCKI3D _ptr;
    _ptr = (PFN_WGLISENABLEDGENLOCKI3D)_getPrivateProcAddress("wglIsEnabledGenlockI3D");
    if (!_ptr) {
        _ptr = &_fail_wglIsEnabledGenlockI3D;
    }
    _wglIsEnabledGenlockI3D = _ptr;
    return _wglIsEnabledGenlockI3D(hDC, pFlag);
}

PFN_WGLISENABLEDGENLOCKI3D _wglIsEnabledGenlockI3D = &_get_wglIsEnabledGenlockI3D;

static BOOL __stdcall _fail_wglGenlockSourceI3D(HDC hDC, UINT uSource) {
    const char *_name = "wglGenlockSourceI3D";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static BOOL __stdcall _get_wglGenlockSourceI3D(HDC hDC, UINT uSource) {
    PFN_WGLGENLOCKSOURCEI3D _ptr;
    _ptr = (PFN_WGLGENLOCKSOURCEI3D)_getPrivateProcAddress("wglGenlockSourceI3D");
    if (!_ptr) {
        _ptr = &_fail_wglGenlockSourceI3D;
    }
    _wglGenlockSourceI3D = _ptr;
    return _wglGenlockSourceI3D(hDC, uSource);
}

PFN_WGLGENLOCKSOURCEI3D _wglGenlockSourceI3D = &_get_wglGenlockSourceI3D;

static BOOL __stdcall _fail_wglGetGenlockSourceI3D(HDC hDC, UINT * uSource) {
    const char *_name = "wglGetGenlockSourceI3D";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static BOOL __stdcall _get_wglGetGenlockSourceI3D(HDC hDC, UINT * uSource) {
    PFN_WGLGETGENLOCKSOURCEI3D _ptr;
    _ptr = (PFN_WGLGETGENLOCKSOURCEI3D)_getPrivateProcAddress("wglGetGenlockSourceI3D");
    if (!_ptr) {
        _ptr = &_fail_wglGetGenlockSourceI3D;
    }
    _wglGetGenlockSourceI3D = _ptr;
    return _wglGetGenlockSourceI3D(hDC, uSource);
}

PFN_WGLGETGENLOCKSOURCEI3D _wglGetGenlockSourceI3D = &_get_wglGetGenlockSourceI3D;

static BOOL __stdcall _fail_wglGenlockSourceEdgeI3D(HDC hDC, UINT uEdge) {
    const char *_name = "wglGenlockSourceEdgeI3D";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static BOOL __stdcall _get_wglGenlockSourceEdgeI3D(HDC hDC, UINT uEdge) {
    PFN_WGLGENLOCKSOURCEEDGEI3D _ptr;
    _ptr = (PFN_WGLGENLOCKSOURCEEDGEI3D)_getPrivateProcAddress("wglGenlockSourceEdgeI3D");
    if (!_ptr) {
        _ptr = &_fail_wglGenlockSourceEdgeI3D;
    }
    _wglGenlockSourceEdgeI3D = _ptr;
    return _wglGenlockSourceEdgeI3D(hDC, uEdge);
}

PFN_WGLGENLOCKSOURCEEDGEI3D _wglGenlockSourceEdgeI3D = &_get_wglGenlockSourceEdgeI3D;

static BOOL __stdcall _fail_wglGetGenlockSourceEdgeI3D(HDC hDC, UINT * uEdge) {
    const char *_name = "wglGetGenlockSourceEdgeI3D";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static BOOL __stdcall _get_wglGetGenlockSourceEdgeI3D(HDC hDC, UINT * uEdge) {
    PFN_WGLGETGENLOCKSOURCEEDGEI3D _ptr;
    _ptr = (PFN_WGLGETGENLOCKSOURCEEDGEI3D)_getPrivateProcAddress("wglGetGenlockSourceEdgeI3D");
    if (!_ptr) {
        _ptr = &_fail_wglGetGenlockSourceEdgeI3D;
    }
    _wglGetGenlockSourceEdgeI3D = _ptr;
    return _wglGetGenlockSourceEdgeI3D(hDC, uEdge);
}

PFN_WGLGETGENLOCKSOURCEEDGEI3D _wglGetGenlockSourceEdgeI3D = &_get_wglGetGenlockSourceEdgeI3D;

static BOOL __stdcall _fail_wglGenlockSampleRateI3D(HDC hDC, UINT uRate) {
    const char *_name = "wglGenlockSampleRateI3D";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static BOOL __stdcall _get_wglGenlockSampleRateI3D(HDC hDC, UINT uRate) {
    PFN_WGLGENLOCKSAMPLERATEI3D _ptr;
    _ptr = (PFN_WGLGENLOCKSAMPLERATEI3D)_getPrivateProcAddress("wglGenlockSampleRateI3D");
    if (!_ptr) {
        _ptr = &_fail_wglGenlockSampleRateI3D;
    }
    _wglGenlockSampleRateI3D = _ptr;
    return _wglGenlockSampleRateI3D(hDC, uRate);
}

PFN_WGLGENLOCKSAMPLERATEI3D _wglGenlockSampleRateI3D = &_get_wglGenlockSampleRateI3D;

static BOOL __stdcall _fail_wglGetGenlockSampleRateI3D(HDC hDC, UINT * uRate) {
    const char *_name = "wglGetGenlockSampleRateI3D";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static BOOL __stdcall _get_wglGetGenlockSampleRateI3D(HDC hDC, UINT * uRate) {
    PFN_WGLGETGENLOCKSAMPLERATEI3D _ptr;
    _ptr = (PFN_WGLGETGENLOCKSAMPLERATEI3D)_getPrivateProcAddress("wglGetGenlockSampleRateI3D");
    if (!_ptr) {
        _ptr = &_fail_wglGetGenlockSampleRateI3D;
    }
    _wglGetGenlockSampleRateI3D = _ptr;
    return _wglGetGenlockSampleRateI3D(hDC, uRate);
}

PFN_WGLGETGENLOCKSAMPLERATEI3D _wglGetGenlockSampleRateI3D = &_get_wglGetGenlockSampleRateI3D;

static BOOL __stdcall _fail_wglGenlockSourceDelayI3D(HDC hDC, UINT uDelay) {
    const char *_name = "wglGenlockSourceDelayI3D";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static BOOL __stdcall _get_wglGenlockSourceDelayI3D(HDC hDC, UINT uDelay) {
    PFN_WGLGENLOCKSOURCEDELAYI3D _ptr;
    _ptr = (PFN_WGLGENLOCKSOURCEDELAYI3D)_getPrivateProcAddress("wglGenlockSourceDelayI3D");
    if (!_ptr) {
        _ptr = &_fail_wglGenlockSourceDelayI3D;
    }
    _wglGenlockSourceDelayI3D = _ptr;
    return _wglGenlockSourceDelayI3D(hDC, uDelay);
}

PFN_WGLGENLOCKSOURCEDELAYI3D _wglGenlockSourceDelayI3D = &_get_wglGenlockSourceDelayI3D;

static BOOL __stdcall _fail_wglGetGenlockSourceDelayI3D(HDC hDC, UINT * uDelay) {
    const char *_name = "wglGetGenlockSourceDelayI3D";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static BOOL __stdcall _get_wglGetGenlockSourceDelayI3D(HDC hDC, UINT * uDelay) {
    PFN_WGLGETGENLOCKSOURCEDELAYI3D _ptr;
    _ptr = (PFN_WGLGETGENLOCKSOURCEDELAYI3D)_getPrivateProcAddress("wglGetGenlockSourceDelayI3D");
    if (!_ptr) {
        _ptr = &_fail_wglGetGenlockSourceDelayI3D;
    }
    _wglGetGenlockSourceDelayI3D = _ptr;
    return _wglGetGenlockSourceDelayI3D(hDC, uDelay);
}

PFN_WGLGETGENLOCKSOURCEDELAYI3D _wglGetGenlockSourceDelayI3D = &_get_wglGetGenlockSourceDelayI3D;

static BOOL __stdcall _fail_wglQueryGenlockMaxSourceDelayI3D(HDC hDC, UINT * uMaxLineDelay, UINT * uMaxPixelDelay) {
    const char *_name = "wglQueryGenlockMaxSourceDelayI3D";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static BOOL __stdcall _get_wglQueryGenlockMaxSourceDelayI3D(HDC hDC, UINT * uMaxLineDelay, UINT * uMaxPixelDelay) {
    PFN_WGLQUERYGENLOCKMAXSOURCEDELAYI3D _ptr;
    _ptr = (PFN_WGLQUERYGENLOCKMAXSOURCEDELAYI3D)_getPrivateProcAddress("wglQueryGenlockMaxSourceDelayI3D");
    if (!_ptr) {
        _ptr = &_fail_wglQueryGenlockMaxSourceDelayI3D;
    }
    _wglQueryGenlockMaxSourceDelayI3D = _ptr;
    return _wglQueryGenlockMaxSourceDelayI3D(hDC, uMaxLineDelay, uMaxPixelDelay);
}

PFN_WGLQUERYGENLOCKMAXSOURCEDELAYI3D _wglQueryGenlockMaxSourceDelayI3D = &_get_wglQueryGenlockMaxSourceDelayI3D;

static void * __stdcall _fail_wglCreateImageBufferI3D(HDC hDC, DWORD dwSize, UINT uFlags) {
    const char *_name = "wglCreateImageBufferI3D";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static void * __stdcall _get_wglCreateImageBufferI3D(HDC hDC, DWORD dwSize, UINT uFlags) {
    PFN_WGLCREATEIMAGEBUFFERI3D _ptr;
    _ptr = (PFN_WGLCREATEIMAGEBUFFERI3D)_getPrivateProcAddress("wglCreateImageBufferI3D");
    if (!_ptr) {
        _ptr = &_fail_wglCreateImageBufferI3D;
    }
    _wglCreateImageBufferI3D = _ptr;
    return _wglCreateImageBufferI3D(hDC, dwSize, uFlags);
}

PFN_WGLCREATEIMAGEBUFFERI3D _wglCreateImageBufferI3D = &_get_wglCreateImageBufferI3D;

static BOOL __stdcall _fail_wglDestroyImageBufferI3D(HDC hDC, void * pAddress) {
    const char *_name = "wglDestroyImageBufferI3D";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static BOOL __stdcall _get_wglDestroyImageBufferI3D(HDC hDC, void * pAddress) {
    PFN_WGLDESTROYIMAGEBUFFERI3D _ptr;
    _ptr = (PFN_WGLDESTROYIMAGEBUFFERI3D)_getPrivateProcAddress("wglDestroyImageBufferI3D");
    if (!_ptr) {
        _ptr = &_fail_wglDestroyImageBufferI3D;
    }
    _wglDestroyImageBufferI3D = _ptr;
    return _wglDestroyImageBufferI3D(hDC, pAddress);
}

PFN_WGLDESTROYIMAGEBUFFERI3D _wglDestroyImageBufferI3D = &_get_wglDestroyImageBufferI3D;

static BOOL __stdcall _fail_wglAssociateImageBufferEventsI3D(HDC hDC, const HANDLE * pEvent, void * const * pAddress, const DWORD * pSize, UINT count) {
    const char *_name = "wglAssociateImageBufferEventsI3D";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static BOOL __stdcall _get_wglAssociateImageBufferEventsI3D(HDC hDC, const HANDLE * pEvent, void * const * pAddress, const DWORD * pSize, UINT count) {
    PFN_WGLASSOCIATEIMAGEBUFFEREVENTSI3D _ptr;
    _ptr = (PFN_WGLASSOCIATEIMAGEBUFFEREVENTSI3D)_getPrivateProcAddress("wglAssociateImageBufferEventsI3D");
    if (!_ptr) {
        _ptr = &_fail_wglAssociateImageBufferEventsI3D;
    }
    _wglAssociateImageBufferEventsI3D = _ptr;
    return _wglAssociateImageBufferEventsI3D(hDC, pEvent, pAddress, pSize, count);
}

PFN_WGLASSOCIATEIMAGEBUFFEREVENTSI3D _wglAssociateImageBufferEventsI3D = &_get_wglAssociateImageBufferEventsI3D;

static BOOL __stdcall _fail_wglReleaseImageBufferEventsI3D(HDC hDC, void * const * pAddress, UINT count) {
    const char *_name = "wglReleaseImageBufferEventsI3D";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static BOOL __stdcall _get_wglReleaseImageBufferEventsI3D(HDC hDC, void * const * pAddress, UINT count) {
    PFN_WGLRELEASEIMAGEBUFFEREVENTSI3D _ptr;
    _ptr = (PFN_WGLRELEASEIMAGEBUFFEREVENTSI3D)_getPrivateProcAddress("wglReleaseImageBufferEventsI3D");
    if (!_ptr) {
        _ptr = &_fail_wglReleaseImageBufferEventsI3D;
    }
    _wglReleaseImageBufferEventsI3D = _ptr;
    return _wglReleaseImageBufferEventsI3D(hDC, pAddress, count);
}

PFN_WGLRELEASEIMAGEBUFFEREVENTSI3D _wglReleaseImageBufferEventsI3D = &_get_wglReleaseImageBufferEventsI3D;

static BOOL __stdcall _fail_wglEnableFrameLockI3D(void) {
    const char *_name = "wglEnableFrameLockI3D";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static BOOL __stdcall _get_wglEnableFrameLockI3D(void) {
    PFN_WGLENABLEFRAMELOCKI3D _ptr;
    _ptr = (PFN_WGLENABLEFRAMELOCKI3D)_getPrivateProcAddress("wglEnableFrameLockI3D");
    if (!_ptr) {
        _ptr = &_fail_wglEnableFrameLockI3D;
    }
    _wglEnableFrameLockI3D = _ptr;
    return _wglEnableFrameLockI3D();
}

PFN_WGLENABLEFRAMELOCKI3D _wglEnableFrameLockI3D = &_get_wglEnableFrameLockI3D;

static BOOL __stdcall _fail_wglDisableFrameLockI3D(void) {
    const char *_name = "wglDisableFrameLockI3D";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static BOOL __stdcall _get_wglDisableFrameLockI3D(void) {
    PFN_WGLDISABLEFRAMELOCKI3D _ptr;
    _ptr = (PFN_WGLDISABLEFRAMELOCKI3D)_getPrivateProcAddress("wglDisableFrameLockI3D");
    if (!_ptr) {
        _ptr = &_fail_wglDisableFrameLockI3D;
    }
    _wglDisableFrameLockI3D = _ptr;
    return _wglDisableFrameLockI3D();
}

PFN_WGLDISABLEFRAMELOCKI3D _wglDisableFrameLockI3D = &_get_wglDisableFrameLockI3D;

static BOOL __stdcall _fail_wglIsEnabledFrameLockI3D(BOOL * pFlag) {
    const char *_name = "wglIsEnabledFrameLockI3D";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static BOOL __stdcall _get_wglIsEnabledFrameLockI3D(BOOL * pFlag) {
    PFN_WGLISENABLEDFRAMELOCKI3D _ptr;
    _ptr = (PFN_WGLISENABLEDFRAMELOCKI3D)_getPrivateProcAddress("wglIsEnabledFrameLockI3D");
    if (!_ptr) {
        _ptr = &_fail_wglIsEnabledFrameLockI3D;
    }
    _wglIsEnabledFrameLockI3D = _ptr;
    return _wglIsEnabledFrameLockI3D(pFlag);
}

PFN_WGLISENABLEDFRAMELOCKI3D _wglIsEnabledFrameLockI3D = &_get_wglIsEnabledFrameLockI3D;

static BOOL __stdcall _fail_wglQueryFrameLockMasterI3D(BOOL * pFlag) {
    const char *_name = "wglQueryFrameLockMasterI3D";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static BOOL __stdcall _get_wglQueryFrameLockMasterI3D(BOOL * pFlag) {
    PFN_WGLQUERYFRAMELOCKMASTERI3D _ptr;
    _ptr = (PFN_WGLQUERYFRAMELOCKMASTERI3D)_getPrivateProcAddress("wglQueryFrameLockMasterI3D");
    if (!_ptr) {
        _ptr = &_fail_wglQueryFrameLockMasterI3D;
    }
    _wglQueryFrameLockMasterI3D = _ptr;
    return _wglQueryFrameLockMasterI3D(pFlag);
}

PFN_WGLQUERYFRAMELOCKMASTERI3D _wglQueryFrameLockMasterI3D = &_get_wglQueryFrameLockMasterI3D;

static BOOL __stdcall _fail_wglGetFrameUsageI3D(float * pUsage) {
    const char *_name = "wglGetFrameUsageI3D";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static BOOL __stdcall _get_wglGetFrameUsageI3D(float * pUsage) {
    PFN_WGLGETFRAMEUSAGEI3D _ptr;
    _ptr = (PFN_WGLGETFRAMEUSAGEI3D)_getPrivateProcAddress("wglGetFrameUsageI3D");
    if (!_ptr) {
        _ptr = &_fail_wglGetFrameUsageI3D;
    }
    _wglGetFrameUsageI3D = _ptr;
    return _wglGetFrameUsageI3D(pUsage);
}

PFN_WGLGETFRAMEUSAGEI3D _wglGetFrameUsageI3D = &_get_wglGetFrameUsageI3D;

static BOOL __stdcall _fail_wglBeginFrameTrackingI3D(void) {
    const char *_name = "wglBeginFrameTrackingI3D";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static BOOL __stdcall _get_wglBeginFrameTrackingI3D(void) {
    PFN_WGLBEGINFRAMETRACKINGI3D _ptr;
    _ptr = (PFN_WGLBEGINFRAMETRACKINGI3D)_getPrivateProcAddress("wglBeginFrameTrackingI3D");
    if (!_ptr) {
        _ptr = &_fail_wglBeginFrameTrackingI3D;
    }
    _wglBeginFrameTrackingI3D = _ptr;
    return _wglBeginFrameTrackingI3D();
}

PFN_WGLBEGINFRAMETRACKINGI3D _wglBeginFrameTrackingI3D = &_get_wglBeginFrameTrackingI3D;

static BOOL __stdcall _fail_wglEndFrameTrackingI3D(void) {
    const char *_name = "wglEndFrameTrackingI3D";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static BOOL __stdcall _get_wglEndFrameTrackingI3D(void) {
    PFN_WGLENDFRAMETRACKINGI3D _ptr;
    _ptr = (PFN_WGLENDFRAMETRACKINGI3D)_getPrivateProcAddress("wglEndFrameTrackingI3D");
    if (!_ptr) {
        _ptr = &_fail_wglEndFrameTrackingI3D;
    }
    _wglEndFrameTrackingI3D = _ptr;
    return _wglEndFrameTrackingI3D();
}

PFN_WGLENDFRAMETRACKINGI3D _wglEndFrameTrackingI3D = &_get_wglEndFrameTrackingI3D;

static BOOL __stdcall _fail_wglQueryFrameTrackingI3D(DWORD * pFrameCount, DWORD * pMissedFrames, float * pLastMissedUsage) {
    const char *_name = "wglQueryFrameTrackingI3D";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static BOOL __stdcall _get_wglQueryFrameTrackingI3D(DWORD * pFrameCount, DWORD * pMissedFrames, float * pLastMissedUsage) {
    PFN_WGLQUERYFRAMETRACKINGI3D _ptr;
    _ptr = (PFN_WGLQUERYFRAMETRACKINGI3D)_getPrivateProcAddress("wglQueryFrameTrackingI3D");
    if (!_ptr) {
        _ptr = &_fail_wglQueryFrameTrackingI3D;
    }
    _wglQueryFrameTrackingI3D = _ptr;
    return _wglQueryFrameTrackingI3D(pFrameCount, pMissedFrames, pLastMissedUsage);
}

PFN_WGLQUERYFRAMETRACKINGI3D _wglQueryFrameTrackingI3D = &_get_wglQueryFrameTrackingI3D;

static BOOL __stdcall _fail_wglSetStereoEmitterState3DL(HDC hDC, UINT uState) {
    const char *_name = "wglSetStereoEmitterState3DL";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static BOOL __stdcall _get_wglSetStereoEmitterState3DL(HDC hDC, UINT uState) {
    PFN_WGLSETSTEREOEMITTERSTATE3DL _ptr;
    _ptr = (PFN_WGLSETSTEREOEMITTERSTATE3DL)_getPrivateProcAddress("wglSetStereoEmitterState3DL");
    if (!_ptr) {
        _ptr = &_fail_wglSetStereoEmitterState3DL;
    }
    _wglSetStereoEmitterState3DL = _ptr;
    return _wglSetStereoEmitterState3DL(hDC, uState);
}

PFN_WGLSETSTEREOEMITTERSTATE3DL _wglSetStereoEmitterState3DL = &_get_wglSetStereoEmitterState3DL;

static int __stdcall _fail_wglEnumerateVideoDevicesNV(HDC hDC, HVIDEOOUTPUTDEVICENV * phDeviceList) {
    const char *_name = "wglEnumerateVideoDevicesNV";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static int __stdcall _get_wglEnumerateVideoDevicesNV(HDC hDC, HVIDEOOUTPUTDEVICENV * phDeviceList) {
    PFN_WGLENUMERATEVIDEODEVICESNV _ptr;
    _ptr = (PFN_WGLENUMERATEVIDEODEVICESNV)_getPrivateProcAddress("wglEnumerateVideoDevicesNV");
    if (!_ptr) {
        _ptr = &_fail_wglEnumerateVideoDevicesNV;
    }
    _wglEnumerateVideoDevicesNV = _ptr;
    return _wglEnumerateVideoDevicesNV(hDC, phDeviceList);
}

PFN_WGLENUMERATEVIDEODEVICESNV _wglEnumerateVideoDevicesNV = &_get_wglEnumerateVideoDevicesNV;

static BOOL __stdcall _fail_wglBindVideoDeviceNV(HDC hDC, unsigned int uVideoSlot, HVIDEOOUTPUTDEVICENV hVideoDevice, const int * piAttribList) {
    const char *_name = "wglBindVideoDeviceNV";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static BOOL __stdcall _get_wglBindVideoDeviceNV(HDC hDC, unsigned int uVideoSlot, HVIDEOOUTPUTDEVICENV hVideoDevice, const int * piAttribList) {
    PFN_WGLBINDVIDEODEVICENV _ptr;
    _ptr = (PFN_WGLBINDVIDEODEVICENV)_getPrivateProcAddress("wglBindVideoDeviceNV");
    if (!_ptr) {
        _ptr = &_fail_wglBindVideoDeviceNV;
    }
    _wglBindVideoDeviceNV = _ptr;
    return _wglBindVideoDeviceNV(hDC, uVideoSlot, hVideoDevice, piAttribList);
}

PFN_WGLBINDVIDEODEVICENV _wglBindVideoDeviceNV = &_get_wglBindVideoDeviceNV;

static BOOL __stdcall _fail_wglQueryCurrentContextNV(int iAttribute, int * piValue) {
    const char *_name = "wglQueryCurrentContextNV";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static BOOL __stdcall _get_wglQueryCurrentContextNV(int iAttribute, int * piValue) {
    PFN_WGLQUERYCURRENTCONTEXTNV _ptr;
    _ptr = (PFN_WGLQUERYCURRENTCONTEXTNV)_getPrivateProcAddress("wglQueryCurrentContextNV");
    if (!_ptr) {
        _ptr = &_fail_wglQueryCurrentContextNV;
    }
    _wglQueryCurrentContextNV = _ptr;
    return _wglQueryCurrentContextNV(iAttribute, piValue);
}

PFN_WGLQUERYCURRENTCONTEXTNV _wglQueryCurrentContextNV = &_get_wglQueryCurrentContextNV;

static BOOL __stdcall _fail_wglGetVideoDeviceNV(HDC hDC, int numDevices, HPVIDEODEV * hVideoDevice) {
    const char *_name = "wglGetVideoDeviceNV";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static BOOL __stdcall _get_wglGetVideoDeviceNV(HDC hDC, int numDevices, HPVIDEODEV * hVideoDevice) {
    PFN_WGLGETVIDEODEVICENV _ptr;
    _ptr = (PFN_WGLGETVIDEODEVICENV)_getPrivateProcAddress("wglGetVideoDeviceNV");
    if (!_ptr) {
        _ptr = &_fail_wglGetVideoDeviceNV;
    }
    _wglGetVideoDeviceNV = _ptr;
    return _wglGetVideoDeviceNV(hDC, numDevices, hVideoDevice);
}

PFN_WGLGETVIDEODEVICENV _wglGetVideoDeviceNV = &_get_wglGetVideoDeviceNV;

static BOOL __stdcall _fail_wglReleaseVideoDeviceNV(HPVIDEODEV hVideoDevice) {
    const char *_name = "wglReleaseVideoDeviceNV";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static BOOL __stdcall _get_wglReleaseVideoDeviceNV(HPVIDEODEV hVideoDevice) {
    PFN_WGLRELEASEVIDEODEVICENV _ptr;
    _ptr = (PFN_WGLRELEASEVIDEODEVICENV)_getPrivateProcAddress("wglReleaseVideoDeviceNV");
    if (!_ptr) {
        _ptr = &_fail_wglReleaseVideoDeviceNV;
    }
    _wglReleaseVideoDeviceNV = _ptr;
    return _wglReleaseVideoDeviceNV(hVideoDevice);
}

PFN_WGLRELEASEVIDEODEVICENV _wglReleaseVideoDeviceNV = &_get_wglReleaseVideoDeviceNV;

static BOOL __stdcall _fail_wglBindVideoImageNV(HPVIDEODEV hVideoDevice, HPBUFFERARB hPbuffer, int iVideoBuffer) {
    const char *_name = "wglBindVideoImageNV";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static BOOL __stdcall _get_wglBindVideoImageNV(HPVIDEODEV hVideoDevice, HPBUFFERARB hPbuffer, int iVideoBuffer) {
    PFN_WGLBINDVIDEOIMAGENV _ptr;
    _ptr = (PFN_WGLBINDVIDEOIMAGENV)_getPrivateProcAddress("wglBindVideoImageNV");
    if (!_ptr) {
        _ptr = &_fail_wglBindVideoImageNV;
    }
    _wglBindVideoImageNV = _ptr;
    return _wglBindVideoImageNV(hVideoDevice, hPbuffer, iVideoBuffer);
}

PFN_WGLBINDVIDEOIMAGENV _wglBindVideoImageNV = &_get_wglBindVideoImageNV;

static BOOL __stdcall _fail_wglReleaseVideoImageNV(HPBUFFERARB hPbuffer, int iVideoBuffer) {
    const char *_name = "wglReleaseVideoImageNV";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static BOOL __stdcall _get_wglReleaseVideoImageNV(HPBUFFERARB hPbuffer, int iVideoBuffer) {
    PFN_WGLRELEASEVIDEOIMAGENV _ptr;
    _ptr = (PFN_WGLRELEASEVIDEOIMAGENV)_getPrivateProcAddress("wglReleaseVideoImageNV");
    if (!_ptr) {
        _ptr = &_fail_wglReleaseVideoImageNV;
    }
    _wglReleaseVideoImageNV = _ptr;
    return _wglReleaseVideoImageNV(hPbuffer, iVideoBuffer);
}

PFN_WGLRELEASEVIDEOIMAGENV _wglReleaseVideoImageNV = &_get_wglReleaseVideoImageNV;

static BOOL __stdcall _fail_wglSendPbufferToVideoNV(HPBUFFERARB hPbuffer, int iBufferType, unsigned long * pulCounterPbuffer, BOOL bBlock) {
    const char *_name = "wglSendPbufferToVideoNV";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static BOOL __stdcall _get_wglSendPbufferToVideoNV(HPBUFFERARB hPbuffer, int iBufferType, unsigned long * pulCounterPbuffer, BOOL bBlock) {
    PFN_WGLSENDPBUFFERTOVIDEONV _ptr;
    _ptr = (PFN_WGLSENDPBUFFERTOVIDEONV)_getPrivateProcAddress("wglSendPbufferToVideoNV");
    if (!_ptr) {
        _ptr = &_fail_wglSendPbufferToVideoNV;
    }
    _wglSendPbufferToVideoNV = _ptr;
    return _wglSendPbufferToVideoNV(hPbuffer, iBufferType, pulCounterPbuffer, bBlock);
}

PFN_WGLSENDPBUFFERTOVIDEONV _wglSendPbufferToVideoNV = &_get_wglSendPbufferToVideoNV;

static BOOL __stdcall _fail_wglGetVideoInfoNV(HPVIDEODEV hpVideoDevice, unsigned long * pulCounterOutputPbuffer, unsigned long * pulCounterOutputVideo) {
    const char *_name = "wglGetVideoInfoNV";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static BOOL __stdcall _get_wglGetVideoInfoNV(HPVIDEODEV hpVideoDevice, unsigned long * pulCounterOutputPbuffer, unsigned long * pulCounterOutputVideo) {
    PFN_WGLGETVIDEOINFONV _ptr;
    _ptr = (PFN_WGLGETVIDEOINFONV)_getPrivateProcAddress("wglGetVideoInfoNV");
    if (!_ptr) {
        _ptr = &_fail_wglGetVideoInfoNV;
    }
    _wglGetVideoInfoNV = _ptr;
    return _wglGetVideoInfoNV(hpVideoDevice, pulCounterOutputPbuffer, pulCounterOutputVideo);
}

PFN_WGLGETVIDEOINFONV _wglGetVideoInfoNV = &_get_wglGetVideoInfoNV;

static BOOL __stdcall _fail_wglJoinSwapGroupNV(HDC hDC, GLuint group) {
    const char *_name = "wglJoinSwapGroupNV";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static BOOL __stdcall _get_wglJoinSwapGroupNV(HDC hDC, GLuint group) {
    PFN_WGLJOINSWAPGROUPNV _ptr;
    _ptr = (PFN_WGLJOINSWAPGROUPNV)_getPrivateProcAddress("wglJoinSwapGroupNV");
    if (!_ptr) {
        _ptr = &_fail_wglJoinSwapGroupNV;
    }
    _wglJoinSwapGroupNV = _ptr;
    return _wglJoinSwapGroupNV(hDC, group);
}

PFN_WGLJOINSWAPGROUPNV _wglJoinSwapGroupNV = &_get_wglJoinSwapGroupNV;

static BOOL __stdcall _fail_wglBindSwapBarrierNV(GLuint group, GLuint barrier) {
    const char *_name = "wglBindSwapBarrierNV";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static BOOL __stdcall _get_wglBindSwapBarrierNV(GLuint group, GLuint barrier) {
    PFN_WGLBINDSWAPBARRIERNV _ptr;
    _ptr = (PFN_WGLBINDSWAPBARRIERNV)_getPrivateProcAddress("wglBindSwapBarrierNV");
    if (!_ptr) {
        _ptr = &_fail_wglBindSwapBarrierNV;
    }
    _wglBindSwapBarrierNV = _ptr;
    return _wglBindSwapBarrierNV(group, barrier);
}

PFN_WGLBINDSWAPBARRIERNV _wglBindSwapBarrierNV = &_get_wglBindSwapBarrierNV;

static BOOL __stdcall _fail_wglQuerySwapGroupNV(HDC hDC, GLuint * group, GLuint * barrier) {
    const char *_name = "wglQuerySwapGroupNV";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static BOOL __stdcall _get_wglQuerySwapGroupNV(HDC hDC, GLuint * group, GLuint * barrier) {
    PFN_WGLQUERYSWAPGROUPNV _ptr;
    _ptr = (PFN_WGLQUERYSWAPGROUPNV)_getPrivateProcAddress("wglQuerySwapGroupNV");
    if (!_ptr) {
        _ptr = &_fail_wglQuerySwapGroupNV;
    }
    _wglQuerySwapGroupNV = _ptr;
    return _wglQuerySwapGroupNV(hDC, group, barrier);
}

PFN_WGLQUERYSWAPGROUPNV _wglQuerySwapGroupNV = &_get_wglQuerySwapGroupNV;

static BOOL __stdcall _fail_wglQueryMaxSwapGroupsNV(HDC hDC, GLuint * maxGroups, GLuint * maxBarriers) {
    const char *_name = "wglQueryMaxSwapGroupsNV";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static BOOL __stdcall _get_wglQueryMaxSwapGroupsNV(HDC hDC, GLuint * maxGroups, GLuint * maxBarriers) {
    PFN_WGLQUERYMAXSWAPGROUPSNV _ptr;
    _ptr = (PFN_WGLQUERYMAXSWAPGROUPSNV)_getPrivateProcAddress("wglQueryMaxSwapGroupsNV");
    if (!_ptr) {
        _ptr = &_fail_wglQueryMaxSwapGroupsNV;
    }
    _wglQueryMaxSwapGroupsNV = _ptr;
    return _wglQueryMaxSwapGroupsNV(hDC, maxGroups, maxBarriers);
}

PFN_WGLQUERYMAXSWAPGROUPSNV _wglQueryMaxSwapGroupsNV = &_get_wglQueryMaxSwapGroupsNV;

static BOOL __stdcall _fail_wglQueryFrameCountNV(HDC hDC, GLuint * count) {
    const char *_name = "wglQueryFrameCountNV";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static BOOL __stdcall _get_wglQueryFrameCountNV(HDC hDC, GLuint * count) {
    PFN_WGLQUERYFRAMECOUNTNV _ptr;
    _ptr = (PFN_WGLQUERYFRAMECOUNTNV)_getPrivateProcAddress("wglQueryFrameCountNV");
    if (!_ptr) {
        _ptr = &_fail_wglQueryFrameCountNV;
    }
    _wglQueryFrameCountNV = _ptr;
    return _wglQueryFrameCountNV(hDC, count);
}

PFN_WGLQUERYFRAMECOUNTNV _wglQueryFrameCountNV = &_get_wglQueryFrameCountNV;

static BOOL __stdcall _fail_wglResetFrameCountNV(HDC hDC) {
    const char *_name = "wglResetFrameCountNV";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static BOOL __stdcall _get_wglResetFrameCountNV(HDC hDC) {
    PFN_WGLRESETFRAMECOUNTNV _ptr;
    _ptr = (PFN_WGLRESETFRAMECOUNTNV)_getPrivateProcAddress("wglResetFrameCountNV");
    if (!_ptr) {
        _ptr = &_fail_wglResetFrameCountNV;
    }
    _wglResetFrameCountNV = _ptr;
    return _wglResetFrameCountNV(hDC);
}

PFN_WGLRESETFRAMECOUNTNV _wglResetFrameCountNV = &_get_wglResetFrameCountNV;

static BOOL __stdcall _fail_wglEnumGpusNV(UINT iGpuIndex, HGPUNV * phGpu) {
    const char *_name = "wglEnumGpusNV";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static BOOL __stdcall _get_wglEnumGpusNV(UINT iGpuIndex, HGPUNV * phGpu) {
    PFN_WGLENUMGPUSNV _ptr;
    _ptr = (PFN_WGLENUMGPUSNV)_getPrivateProcAddress("wglEnumGpusNV");
    if (!_ptr) {
        _ptr = &_fail_wglEnumGpusNV;
    }
    _wglEnumGpusNV = _ptr;
    return _wglEnumGpusNV(iGpuIndex, phGpu);
}

PFN_WGLENUMGPUSNV _wglEnumGpusNV = &_get_wglEnumGpusNV;

static BOOL __stdcall _fail_wglEnumGpuDevicesNV(HGPUNV hGpu, UINT iDeviceIndex, _GPU_DEVICE * lpGpuDevice) {
    const char *_name = "wglEnumGpuDevicesNV";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static BOOL __stdcall _get_wglEnumGpuDevicesNV(HGPUNV hGpu, UINT iDeviceIndex, _GPU_DEVICE * lpGpuDevice) {
    PFN_WGLENUMGPUDEVICESNV _ptr;
    _ptr = (PFN_WGLENUMGPUDEVICESNV)_getPrivateProcAddress("wglEnumGpuDevicesNV");
    if (!_ptr) {
        _ptr = &_fail_wglEnumGpuDevicesNV;
    }
    _wglEnumGpuDevicesNV = _ptr;
    return _wglEnumGpuDevicesNV(hGpu, iDeviceIndex, lpGpuDevice);
}

PFN_WGLENUMGPUDEVICESNV _wglEnumGpuDevicesNV = &_get_wglEnumGpuDevicesNV;

static HDC __stdcall _fail_wglCreateAffinityDCNV(const HGPUNV * phGpuList) {
    const char *_name = "wglCreateAffinityDCNV";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static HDC __stdcall _get_wglCreateAffinityDCNV(const HGPUNV * phGpuList) {
    PFN_WGLCREATEAFFINITYDCNV _ptr;
    _ptr = (PFN_WGLCREATEAFFINITYDCNV)_getPrivateProcAddress("wglCreateAffinityDCNV");
    if (!_ptr) {
        _ptr = &_fail_wglCreateAffinityDCNV;
    }
    _wglCreateAffinityDCNV = _ptr;
    return _wglCreateAffinityDCNV(phGpuList);
}

PFN_WGLCREATEAFFINITYDCNV _wglCreateAffinityDCNV = &_get_wglCreateAffinityDCNV;

static BOOL __stdcall _fail_wglEnumGpusFromAffinityDCNV(HDC hAffinityDC, UINT iGpuIndex, HGPUNV * hGpu) {
    const char *_name = "wglEnumGpusFromAffinityDCNV";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static BOOL __stdcall _get_wglEnumGpusFromAffinityDCNV(HDC hAffinityDC, UINT iGpuIndex, HGPUNV * hGpu) {
    PFN_WGLENUMGPUSFROMAFFINITYDCNV _ptr;
    _ptr = (PFN_WGLENUMGPUSFROMAFFINITYDCNV)_getPrivateProcAddress("wglEnumGpusFromAffinityDCNV");
    if (!_ptr) {
        _ptr = &_fail_wglEnumGpusFromAffinityDCNV;
    }
    _wglEnumGpusFromAffinityDCNV = _ptr;
    return _wglEnumGpusFromAffinityDCNV(hAffinityDC, iGpuIndex, hGpu);
}

PFN_WGLENUMGPUSFROMAFFINITYDCNV _wglEnumGpusFromAffinityDCNV = &_get_wglEnumGpusFromAffinityDCNV;

static BOOL __stdcall _fail_wglDeleteDCNV(HDC hdc) {
    const char *_name = "wglDeleteDCNV";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static BOOL __stdcall _get_wglDeleteDCNV(HDC hdc) {
    PFN_WGLDELETEDCNV _ptr;
    _ptr = (PFN_WGLDELETEDCNV)_getPrivateProcAddress("wglDeleteDCNV");
    if (!_ptr) {
        _ptr = &_fail_wglDeleteDCNV;
    }
    _wglDeleteDCNV = _ptr;
    return _wglDeleteDCNV(hdc);
}

PFN_WGLDELETEDCNV _wglDeleteDCNV = &_get_wglDeleteDCNV;

static UINT __stdcall _fail_wglGetGPUIDsAMD(UINT maxCount, UINT * ids) {
    const char *_name = "wglGetGPUIDsAMD";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static UINT __stdcall _get_wglGetGPUIDsAMD(UINT maxCount, UINT * ids) {
    PFN_WGLGETGPUIDSAMD _ptr;
    _ptr = (PFN_WGLGETGPUIDSAMD)_getPrivateProcAddress("wglGetGPUIDsAMD");
    if (!_ptr) {
        _ptr = &_fail_wglGetGPUIDsAMD;
    }
    _wglGetGPUIDsAMD = _ptr;
    return _wglGetGPUIDsAMD(maxCount, ids);
}

PFN_WGLGETGPUIDSAMD _wglGetGPUIDsAMD = &_get_wglGetGPUIDsAMD;

static INT __stdcall _fail_wglGetGPUInfoAMD(UINT id, int property, GLenum dataType, UINT size, void * data) {
    const char *_name = "wglGetGPUInfoAMD";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static INT __stdcall _get_wglGetGPUInfoAMD(UINT id, int property, GLenum dataType, UINT size, void * data) {
    PFN_WGLGETGPUINFOAMD _ptr;
    _ptr = (PFN_WGLGETGPUINFOAMD)_getPrivateProcAddress("wglGetGPUInfoAMD");
    if (!_ptr) {
        _ptr = &_fail_wglGetGPUInfoAMD;
    }
    _wglGetGPUInfoAMD = _ptr;
    return _wglGetGPUInfoAMD(id, property, dataType, size, data);
}

PFN_WGLGETGPUINFOAMD _wglGetGPUInfoAMD = &_get_wglGetGPUInfoAMD;

static UINT __stdcall _fail_wglGetContextGPUIDAMD(HGLRC hglrc) {
    const char *_name = "wglGetContextGPUIDAMD";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static UINT __stdcall _get_wglGetContextGPUIDAMD(HGLRC hglrc) {
    PFN_WGLGETCONTEXTGPUIDAMD _ptr;
    _ptr = (PFN_WGLGETCONTEXTGPUIDAMD)_getPrivateProcAddress("wglGetContextGPUIDAMD");
    if (!_ptr) {
        _ptr = &_fail_wglGetContextGPUIDAMD;
    }
    _wglGetContextGPUIDAMD = _ptr;
    return _wglGetContextGPUIDAMD(hglrc);
}

PFN_WGLGETCONTEXTGPUIDAMD _wglGetContextGPUIDAMD = &_get_wglGetContextGPUIDAMD;

static HGLRC __stdcall _fail_wglCreateAssociatedContextAMD(UINT id) {
    const char *_name = "wglCreateAssociatedContextAMD";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static HGLRC __stdcall _get_wglCreateAssociatedContextAMD(UINT id) {
    PFN_WGLCREATEASSOCIATEDCONTEXTAMD _ptr;
    _ptr = (PFN_WGLCREATEASSOCIATEDCONTEXTAMD)_getPrivateProcAddress("wglCreateAssociatedContextAMD");
    if (!_ptr) {
        _ptr = &_fail_wglCreateAssociatedContextAMD;
    }
    _wglCreateAssociatedContextAMD = _ptr;
    return _wglCreateAssociatedContextAMD(id);
}

PFN_WGLCREATEASSOCIATEDCONTEXTAMD _wglCreateAssociatedContextAMD = &_get_wglCreateAssociatedContextAMD;

static HGLRC __stdcall _fail_wglCreateAssociatedContextAttribsAMD(UINT id, HGLRC hShareContext, const int * attribList) {
    const char *_name = "wglCreateAssociatedContextAttribsAMD";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static HGLRC __stdcall _get_wglCreateAssociatedContextAttribsAMD(UINT id, HGLRC hShareContext, const int * attribList) {
    PFN_WGLCREATEASSOCIATEDCONTEXTATTRIBSAMD _ptr;
    _ptr = (PFN_WGLCREATEASSOCIATEDCONTEXTATTRIBSAMD)_getPrivateProcAddress("wglCreateAssociatedContextAttribsAMD");
    if (!_ptr) {
        _ptr = &_fail_wglCreateAssociatedContextAttribsAMD;
    }
    _wglCreateAssociatedContextAttribsAMD = _ptr;
    return _wglCreateAssociatedContextAttribsAMD(id, hShareContext, attribList);
}

PFN_WGLCREATEASSOCIATEDCONTEXTATTRIBSAMD _wglCreateAssociatedContextAttribsAMD = &_get_wglCreateAssociatedContextAttribsAMD;

static BOOL __stdcall _fail_wglDeleteAssociatedContextAMD(HGLRC hglrc) {
    const char *_name = "wglDeleteAssociatedContextAMD";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static BOOL __stdcall _get_wglDeleteAssociatedContextAMD(HGLRC hglrc) {
    PFN_WGLDELETEASSOCIATEDCONTEXTAMD _ptr;
    _ptr = (PFN_WGLDELETEASSOCIATEDCONTEXTAMD)_getPrivateProcAddress("wglDeleteAssociatedContextAMD");
    if (!_ptr) {
        _ptr = &_fail_wglDeleteAssociatedContextAMD;
    }
    _wglDeleteAssociatedContextAMD = _ptr;
    return _wglDeleteAssociatedContextAMD(hglrc);
}

PFN_WGLDELETEASSOCIATEDCONTEXTAMD _wglDeleteAssociatedContextAMD = &_get_wglDeleteAssociatedContextAMD;

static BOOL __stdcall _fail_wglMakeAssociatedContextCurrentAMD(HGLRC hglrc) {
    const char *_name = "wglMakeAssociatedContextCurrentAMD";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static BOOL __stdcall _get_wglMakeAssociatedContextCurrentAMD(HGLRC hglrc) {
    PFN_WGLMAKEASSOCIATEDCONTEXTCURRENTAMD _ptr;
    _ptr = (PFN_WGLMAKEASSOCIATEDCONTEXTCURRENTAMD)_getPrivateProcAddress("wglMakeAssociatedContextCurrentAMD");
    if (!_ptr) {
        _ptr = &_fail_wglMakeAssociatedContextCurrentAMD;
    }
    _wglMakeAssociatedContextCurrentAMD = _ptr;
    return _wglMakeAssociatedContextCurrentAMD(hglrc);
}

PFN_WGLMAKEASSOCIATEDCONTEXTCURRENTAMD _wglMakeAssociatedContextCurrentAMD = &_get_wglMakeAssociatedContextCurrentAMD;

static HGLRC __stdcall _fail_wglGetCurrentAssociatedContextAMD(void) {
    const char *_name = "wglGetCurrentAssociatedContextAMD";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static HGLRC __stdcall _get_wglGetCurrentAssociatedContextAMD(void) {
    PFN_WGLGETCURRENTASSOCIATEDCONTEXTAMD _ptr;
    _ptr = (PFN_WGLGETCURRENTASSOCIATEDCONTEXTAMD)_getPrivateProcAddress("wglGetCurrentAssociatedContextAMD");
    if (!_ptr) {
        _ptr = &_fail_wglGetCurrentAssociatedContextAMD;
    }
    _wglGetCurrentAssociatedContextAMD = _ptr;
    return _wglGetCurrentAssociatedContextAMD();
}

PFN_WGLGETCURRENTASSOCIATEDCONTEXTAMD _wglGetCurrentAssociatedContextAMD = &_get_wglGetCurrentAssociatedContextAMD;

static void __stdcall _fail_wglBlitContextFramebufferAMD(HGLRC dstCtx, GLint srcX0, GLint srcY0, GLint srcX1, GLint srcY1, GLint dstX0, GLint dstY0, GLint dstX1, GLint dstY1, GLbitfield mask, GLenum filter) {
    const char *_name = "wglBlitContextFramebufferAMD";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void __stdcall _get_wglBlitContextFramebufferAMD(HGLRC dstCtx, GLint srcX0, GLint srcY0, GLint srcX1, GLint srcY1, GLint dstX0, GLint dstY0, GLint dstX1, GLint dstY1, GLbitfield mask, GLenum filter) {
    PFN_WGLBLITCONTEXTFRAMEBUFFERAMD _ptr;
    _ptr = (PFN_WGLBLITCONTEXTFRAMEBUFFERAMD)_getPrivateProcAddress("wglBlitContextFramebufferAMD");
    if (!_ptr) {
        _ptr = &_fail_wglBlitContextFramebufferAMD;
    }
    _wglBlitContextFramebufferAMD = _ptr;
    _wglBlitContextFramebufferAMD(dstCtx, srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1, dstY1, mask, filter);
}

PFN_WGLBLITCONTEXTFRAMEBUFFERAMD _wglBlitContextFramebufferAMD = &_get_wglBlitContextFramebufferAMD;

static BOOL __stdcall _fail_wglBindVideoCaptureDeviceNV(UINT uVideoSlot, HVIDEOINPUTDEVICENV hDevice) {
    const char *_name = "wglBindVideoCaptureDeviceNV";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static BOOL __stdcall _get_wglBindVideoCaptureDeviceNV(UINT uVideoSlot, HVIDEOINPUTDEVICENV hDevice) {
    PFN_WGLBINDVIDEOCAPTUREDEVICENV _ptr;
    _ptr = (PFN_WGLBINDVIDEOCAPTUREDEVICENV)_getPrivateProcAddress("wglBindVideoCaptureDeviceNV");
    if (!_ptr) {
        _ptr = &_fail_wglBindVideoCaptureDeviceNV;
    }
    _wglBindVideoCaptureDeviceNV = _ptr;
    return _wglBindVideoCaptureDeviceNV(uVideoSlot, hDevice);
}

PFN_WGLBINDVIDEOCAPTUREDEVICENV _wglBindVideoCaptureDeviceNV = &_get_wglBindVideoCaptureDeviceNV;

static UINT __stdcall _fail_wglEnumerateVideoCaptureDevicesNV(HDC hDc, HVIDEOINPUTDEVICENV * phDeviceList) {
    const char *_name = "wglEnumerateVideoCaptureDevicesNV";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static UINT __stdcall _get_wglEnumerateVideoCaptureDevicesNV(HDC hDc, HVIDEOINPUTDEVICENV * phDeviceList) {
    PFN_WGLENUMERATEVIDEOCAPTUREDEVICESNV _ptr;
    _ptr = (PFN_WGLENUMERATEVIDEOCAPTUREDEVICESNV)_getPrivateProcAddress("wglEnumerateVideoCaptureDevicesNV");
    if (!_ptr) {
        _ptr = &_fail_wglEnumerateVideoCaptureDevicesNV;
    }
    _wglEnumerateVideoCaptureDevicesNV = _ptr;
    return _wglEnumerateVideoCaptureDevicesNV(hDc, phDeviceList);
}

PFN_WGLENUMERATEVIDEOCAPTUREDEVICESNV _wglEnumerateVideoCaptureDevicesNV = &_get_wglEnumerateVideoCaptureDevicesNV;

static BOOL __stdcall _fail_wglLockVideoCaptureDeviceNV(HDC hDc, HVIDEOINPUTDEVICENV hDevice) {
    const char *_name = "wglLockVideoCaptureDeviceNV";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static BOOL __stdcall _get_wglLockVideoCaptureDeviceNV(HDC hDc, HVIDEOINPUTDEVICENV hDevice) {
    PFN_WGLLOCKVIDEOCAPTUREDEVICENV _ptr;
    _ptr = (PFN_WGLLOCKVIDEOCAPTUREDEVICENV)_getPrivateProcAddress("wglLockVideoCaptureDeviceNV");
    if (!_ptr) {
        _ptr = &_fail_wglLockVideoCaptureDeviceNV;
    }
    _wglLockVideoCaptureDeviceNV = _ptr;
    return _wglLockVideoCaptureDeviceNV(hDc, hDevice);
}

PFN_WGLLOCKVIDEOCAPTUREDEVICENV _wglLockVideoCaptureDeviceNV = &_get_wglLockVideoCaptureDeviceNV;

static BOOL __stdcall _fail_wglQueryVideoCaptureDeviceNV(HDC hDc, HVIDEOINPUTDEVICENV hDevice, int iAttribute, int * piValue) {
    const char *_name = "wglQueryVideoCaptureDeviceNV";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static BOOL __stdcall _get_wglQueryVideoCaptureDeviceNV(HDC hDc, HVIDEOINPUTDEVICENV hDevice, int iAttribute, int * piValue) {
    PFN_WGLQUERYVIDEOCAPTUREDEVICENV _ptr;
    _ptr = (PFN_WGLQUERYVIDEOCAPTUREDEVICENV)_getPrivateProcAddress("wglQueryVideoCaptureDeviceNV");
    if (!_ptr) {
        _ptr = &_fail_wglQueryVideoCaptureDeviceNV;
    }
    _wglQueryVideoCaptureDeviceNV = _ptr;
    return _wglQueryVideoCaptureDeviceNV(hDc, hDevice, iAttribute, piValue);
}

PFN_WGLQUERYVIDEOCAPTUREDEVICENV _wglQueryVideoCaptureDeviceNV = &_get_wglQueryVideoCaptureDeviceNV;

static BOOL __stdcall _fail_wglReleaseVideoCaptureDeviceNV(HDC hDc, HVIDEOINPUTDEVICENV hDevice) {
    const char *_name = "wglReleaseVideoCaptureDeviceNV";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static BOOL __stdcall _get_wglReleaseVideoCaptureDeviceNV(HDC hDc, HVIDEOINPUTDEVICENV hDevice) {
    PFN_WGLRELEASEVIDEOCAPTUREDEVICENV _ptr;
    _ptr = (PFN_WGLRELEASEVIDEOCAPTUREDEVICENV)_getPrivateProcAddress("wglReleaseVideoCaptureDeviceNV");
    if (!_ptr) {
        _ptr = &_fail_wglReleaseVideoCaptureDeviceNV;
    }
    _wglReleaseVideoCaptureDeviceNV = _ptr;
    return _wglReleaseVideoCaptureDeviceNV(hDc, hDevice);
}

PFN_WGLRELEASEVIDEOCAPTUREDEVICENV _wglReleaseVideoCaptureDeviceNV = &_get_wglReleaseVideoCaptureDeviceNV;

static BOOL __stdcall _fail_wglCopyImageSubDataNV(HGLRC hSrcRC, GLuint srcName, GLenum srcTarget, GLint srcLevel, GLint srcX, GLint srcY, GLint srcZ, HGLRC hDstRC, GLuint dstName, GLenum dstTarget, GLint dstLevel, GLint dstX, GLint dstY, GLint dstZ, GLsizei width, GLsizei height, GLsizei depth) {
    const char *_name = "wglCopyImageSubDataNV";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static BOOL __stdcall _get_wglCopyImageSubDataNV(HGLRC hSrcRC, GLuint srcName, GLenum srcTarget, GLint srcLevel, GLint srcX, GLint srcY, GLint srcZ, HGLRC hDstRC, GLuint dstName, GLenum dstTarget, GLint dstLevel, GLint dstX, GLint dstY, GLint dstZ, GLsizei width, GLsizei height, GLsizei depth) {
    PFN_WGLCOPYIMAGESUBDATANV _ptr;
    _ptr = (PFN_WGLCOPYIMAGESUBDATANV)_getPrivateProcAddress("wglCopyImageSubDataNV");
    if (!_ptr) {
        _ptr = &_fail_wglCopyImageSubDataNV;
    }
    _wglCopyImageSubDataNV = _ptr;
    return _wglCopyImageSubDataNV(hSrcRC, srcName, srcTarget, srcLevel, srcX, srcY, srcZ, hDstRC, dstName, dstTarget, dstLevel, dstX, dstY, dstZ, width, height, depth);
}

PFN_WGLCOPYIMAGESUBDATANV _wglCopyImageSubDataNV = &_get_wglCopyImageSubDataNV;

static BOOL __stdcall _fail_wglDXSetResourceShareHandleNV(void * dxObject, HANDLE shareHandle) {
    const char *_name = "wglDXSetResourceShareHandleNV";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static BOOL __stdcall _get_wglDXSetResourceShareHandleNV(void * dxObject, HANDLE shareHandle) {
    PFN_WGLDXSETRESOURCESHAREHANDLENV _ptr;
    _ptr = (PFN_WGLDXSETRESOURCESHAREHANDLENV)_getPrivateProcAddress("wglDXSetResourceShareHandleNV");
    if (!_ptr) {
        _ptr = &_fail_wglDXSetResourceShareHandleNV;
    }
    _wglDXSetResourceShareHandleNV = _ptr;
    return _wglDXSetResourceShareHandleNV(dxObject, shareHandle);
}

PFN_WGLDXSETRESOURCESHAREHANDLENV _wglDXSetResourceShareHandleNV = &_get_wglDXSetResourceShareHandleNV;

static HANDLE __stdcall _fail_wglDXOpenDeviceNV(void * dxDevice) {
    const char *_name = "wglDXOpenDeviceNV";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static HANDLE __stdcall _get_wglDXOpenDeviceNV(void * dxDevice) {
    PFN_WGLDXOPENDEVICENV _ptr;
    _ptr = (PFN_WGLDXOPENDEVICENV)_getPrivateProcAddress("wglDXOpenDeviceNV");
    if (!_ptr) {
        _ptr = &_fail_wglDXOpenDeviceNV;
    }
    _wglDXOpenDeviceNV = _ptr;
    return _wglDXOpenDeviceNV(dxDevice);
}

PFN_WGLDXOPENDEVICENV _wglDXOpenDeviceNV = &_get_wglDXOpenDeviceNV;

static BOOL __stdcall _fail_wglDXCloseDeviceNV(HANDLE hDevice) {
    const char *_name = "wglDXCloseDeviceNV";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static BOOL __stdcall _get_wglDXCloseDeviceNV(HANDLE hDevice) {
    PFN_WGLDXCLOSEDEVICENV _ptr;
    _ptr = (PFN_WGLDXCLOSEDEVICENV)_getPrivateProcAddress("wglDXCloseDeviceNV");
    if (!_ptr) {
        _ptr = &_fail_wglDXCloseDeviceNV;
    }
    _wglDXCloseDeviceNV = _ptr;
    return _wglDXCloseDeviceNV(hDevice);
}

PFN_WGLDXCLOSEDEVICENV _wglDXCloseDeviceNV = &_get_wglDXCloseDeviceNV;

static HANDLE __stdcall _fail_wglDXRegisterObjectNV(HANDLE hDevice, void * dxObject, GLuint name, GLenum type, GLenum access) {
    const char *_name = "wglDXRegisterObjectNV";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static HANDLE __stdcall _get_wglDXRegisterObjectNV(HANDLE hDevice, void * dxObject, GLuint name, GLenum type, GLenum access) {
    PFN_WGLDXREGISTEROBJECTNV _ptr;
    _ptr = (PFN_WGLDXREGISTEROBJECTNV)_getPrivateProcAddress("wglDXRegisterObjectNV");
    if (!_ptr) {
        _ptr = &_fail_wglDXRegisterObjectNV;
    }
    _wglDXRegisterObjectNV = _ptr;
    return _wglDXRegisterObjectNV(hDevice, dxObject, name, type, access);
}

PFN_WGLDXREGISTEROBJECTNV _wglDXRegisterObjectNV = &_get_wglDXRegisterObjectNV;

static BOOL __stdcall _fail_wglDXUnregisterObjectNV(HANDLE hDevice, HANDLE hObject) {
    const char *_name = "wglDXUnregisterObjectNV";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static BOOL __stdcall _get_wglDXUnregisterObjectNV(HANDLE hDevice, HANDLE hObject) {
    PFN_WGLDXUNREGISTEROBJECTNV _ptr;
    _ptr = (PFN_WGLDXUNREGISTEROBJECTNV)_getPrivateProcAddress("wglDXUnregisterObjectNV");
    if (!_ptr) {
        _ptr = &_fail_wglDXUnregisterObjectNV;
    }
    _wglDXUnregisterObjectNV = _ptr;
    return _wglDXUnregisterObjectNV(hDevice, hObject);
}

PFN_WGLDXUNREGISTEROBJECTNV _wglDXUnregisterObjectNV = &_get_wglDXUnregisterObjectNV;

static BOOL __stdcall _fail_wglDXObjectAccessNV(HANDLE hObject, GLenum access) {
    const char *_name = "wglDXObjectAccessNV";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static BOOL __stdcall _get_wglDXObjectAccessNV(HANDLE hObject, GLenum access) {
    PFN_WGLDXOBJECTACCESSNV _ptr;
    _ptr = (PFN_WGLDXOBJECTACCESSNV)_getPrivateProcAddress("wglDXObjectAccessNV");
    if (!_ptr) {
        _ptr = &_fail_wglDXObjectAccessNV;
    }
    _wglDXObjectAccessNV = _ptr;
    return _wglDXObjectAccessNV(hObject, access);
}

PFN_WGLDXOBJECTACCESSNV _wglDXObjectAccessNV = &_get_wglDXObjectAccessNV;

static BOOL __stdcall _fail_wglDXLockObjectsNV(HANDLE hDevice, GLint count, HANDLE * hObjects) {
    const char *_name = "wglDXLockObjectsNV";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static BOOL __stdcall _get_wglDXLockObjectsNV(HANDLE hDevice, GLint count, HANDLE * hObjects) {
    PFN_WGLDXLOCKOBJECTSNV _ptr;
    _ptr = (PFN_WGLDXLOCKOBJECTSNV)_getPrivateProcAddress("wglDXLockObjectsNV");
    if (!_ptr) {
        _ptr = &_fail_wglDXLockObjectsNV;
    }
    _wglDXLockObjectsNV = _ptr;
    return _wglDXLockObjectsNV(hDevice, count, hObjects);
}

PFN_WGLDXLOCKOBJECTSNV _wglDXLockObjectsNV = &_get_wglDXLockObjectsNV;

static BOOL __stdcall _fail_wglDXUnlockObjectsNV(HANDLE hDevice, GLint count, HANDLE * hObjects) {
    const char *_name = "wglDXUnlockObjectsNV";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static BOOL __stdcall _get_wglDXUnlockObjectsNV(HANDLE hDevice, GLint count, HANDLE * hObjects) {
    PFN_WGLDXUNLOCKOBJECTSNV _ptr;
    _ptr = (PFN_WGLDXUNLOCKOBJECTSNV)_getPrivateProcAddress("wglDXUnlockObjectsNV");
    if (!_ptr) {
        _ptr = &_fail_wglDXUnlockObjectsNV;
    }
    _wglDXUnlockObjectsNV = _ptr;
    return _wglDXUnlockObjectsNV(hDevice, count, hObjects);
}

PFN_WGLDXUNLOCKOBJECTSNV _wglDXUnlockObjectsNV = &_get_wglDXUnlockObjectsNV;

static BOOL __stdcall _fail_wglDelayBeforeSwapNV(HDC hDC, GLfloat seconds) {
    const char *_name = "wglDelayBeforeSwapNV";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static BOOL __stdcall _get_wglDelayBeforeSwapNV(HDC hDC, GLfloat seconds) {
    PFN_WGLDELAYBEFORESWAPNV _ptr;
    _ptr = (PFN_WGLDELAYBEFORESWAPNV)_getPrivateProcAddress("wglDelayBeforeSwapNV");
    if (!_ptr) {
        _ptr = &_fail_wglDelayBeforeSwapNV;
    }
    _wglDelayBeforeSwapNV = _ptr;
    return _wglDelayBeforeSwapNV(hDC, seconds);
}

PFN_WGLDELAYBEFORESWAPNV _wglDelayBeforeSwapNV = &_get_wglDelayBeforeSwapNV;

static PROC __stdcall _fail_wglGetProcAddress(const char * lpszProc) {
    const char *_name = "wglGetProcAddress";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static PROC __stdcall _get_wglGetProcAddress(const char * lpszProc) {
    PFN_WGLGETPROCADDRESS _ptr;
    _ptr = (PFN_WGLGETPROCADDRESS)_getPublicProcAddress("wglGetProcAddress");
    if (!_ptr) {
        _ptr = &_fail_wglGetProcAddress;
    }
    _wglGetProcAddress = _ptr;
    return _wglGetProcAddress(lpszProc);
}

PFN_WGLGETPROCADDRESS _wglGetProcAddress = &_get_wglGetProcAddress;


#elif defined(__APPLE__)

static inline bool
translateDebugLabelIdentifier(GLenum & identifier)
{
    switch (identifier) {
    case GL_TEXTURE:
    case GL_FRAMEBUFFER:
    case GL_RENDERBUFFER:
    case GL_SAMPLER:
    case GL_TRANSFORM_FEEDBACK:
       return true;
    case GL_BUFFER:
       identifier = GL_BUFFER_OBJECT_EXT;
       return true;
    case GL_SHADER:
       identifier = GL_SHADER_OBJECT_EXT;
       return true;
    case GL_PROGRAM:
       identifier = GL_PROGRAM_OBJECT_EXT;
       return true;
    case GL_VERTEX_ARRAY:
       identifier = GL_VERTEX_ARRAY_OBJECT_EXT;
       return true;
    case GL_QUERY:
       identifier = GL_QUERY_OBJECT_EXT;
       return true;
    case GL_PROGRAM_PIPELINE:
       identifier = GL_PROGRAM_PIPELINE_OBJECT_EXT;
       return true;
    default:
       return false;
    }
}

static CGLError _fail_CGLSetCurrentContext(CGLContextObj ctx) {
    const char *_name = "CGLSetCurrentContext";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static CGLError _get_CGLSetCurrentContext(CGLContextObj ctx) {
    PFN_CGLSETCURRENTCONTEXT _ptr;
    _ptr = (PFN_CGLSETCURRENTCONTEXT)_getPublicProcAddress("CGLSetCurrentContext");
    if (!_ptr) {
        _ptr = &_fail_CGLSetCurrentContext;
    }
    _CGLSetCurrentContext = _ptr;
    return _CGLSetCurrentContext(ctx);
}

PFN_CGLSETCURRENTCONTEXT _CGLSetCurrentContext = &_get_CGLSetCurrentContext;

static CGLContextObj _fail_CGLGetCurrentContext(void) {
    const char *_name = "CGLGetCurrentContext";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static CGLContextObj _get_CGLGetCurrentContext(void) {
    PFN_CGLGETCURRENTCONTEXT _ptr;
    _ptr = (PFN_CGLGETCURRENTCONTEXT)_getPublicProcAddress("CGLGetCurrentContext");
    if (!_ptr) {
        _ptr = &_fail_CGLGetCurrentContext;
    }
    _CGLGetCurrentContext = _ptr;
    return _CGLGetCurrentContext();
}

PFN_CGLGETCURRENTCONTEXT _CGLGetCurrentContext = &_get_CGLGetCurrentContext;

static CGLError _fail_CGLChoosePixelFormat(const CGLPixelFormatAttribute * attribs, CGLPixelFormatObj * pix, GLint * npix) {
    const char *_name = "CGLChoosePixelFormat";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static CGLError _get_CGLChoosePixelFormat(const CGLPixelFormatAttribute * attribs, CGLPixelFormatObj * pix, GLint * npix) {
    PFN_CGLCHOOSEPIXELFORMAT _ptr;
    _ptr = (PFN_CGLCHOOSEPIXELFORMAT)_getPublicProcAddress("CGLChoosePixelFormat");
    if (!_ptr) {
        _ptr = &_fail_CGLChoosePixelFormat;
    }
    _CGLChoosePixelFormat = _ptr;
    return _CGLChoosePixelFormat(attribs, pix, npix);
}

PFN_CGLCHOOSEPIXELFORMAT _CGLChoosePixelFormat = &_get_CGLChoosePixelFormat;

static CGLError _fail_CGLDestroyPixelFormat(CGLPixelFormatObj pix) {
    const char *_name = "CGLDestroyPixelFormat";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static CGLError _get_CGLDestroyPixelFormat(CGLPixelFormatObj pix) {
    PFN_CGLDESTROYPIXELFORMAT _ptr;
    _ptr = (PFN_CGLDESTROYPIXELFORMAT)_getPublicProcAddress("CGLDestroyPixelFormat");
    if (!_ptr) {
        _ptr = &_fail_CGLDestroyPixelFormat;
    }
    _CGLDestroyPixelFormat = _ptr;
    return _CGLDestroyPixelFormat(pix);
}

PFN_CGLDESTROYPIXELFORMAT _CGLDestroyPixelFormat = &_get_CGLDestroyPixelFormat;

static CGLError _fail_CGLDescribePixelFormat(CGLPixelFormatObj pix, GLint pix_num, CGLPixelFormatAttribute attrib, GLint * value) {
    const char *_name = "CGLDescribePixelFormat";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static CGLError _get_CGLDescribePixelFormat(CGLPixelFormatObj pix, GLint pix_num, CGLPixelFormatAttribute attrib, GLint * value) {
    PFN_CGLDESCRIBEPIXELFORMAT _ptr;
    _ptr = (PFN_CGLDESCRIBEPIXELFORMAT)_getPublicProcAddress("CGLDescribePixelFormat");
    if (!_ptr) {
        _ptr = &_fail_CGLDescribePixelFormat;
    }
    _CGLDescribePixelFormat = _ptr;
    return _CGLDescribePixelFormat(pix, pix_num, attrib, value);
}

PFN_CGLDESCRIBEPIXELFORMAT _CGLDescribePixelFormat = &_get_CGLDescribePixelFormat;

static void _fail_CGLReleasePixelFormat(CGLPixelFormatObj pix) {
    const char *_name = "CGLReleasePixelFormat";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void _get_CGLReleasePixelFormat(CGLPixelFormatObj pix) {
    PFN_CGLRELEASEPIXELFORMAT _ptr;
    _ptr = (PFN_CGLRELEASEPIXELFORMAT)_getPublicProcAddress("CGLReleasePixelFormat");
    if (!_ptr) {
        _ptr = &_fail_CGLReleasePixelFormat;
    }
    _CGLReleasePixelFormat = _ptr;
    _CGLReleasePixelFormat(pix);
}

PFN_CGLRELEASEPIXELFORMAT _CGLReleasePixelFormat = &_get_CGLReleasePixelFormat;

static CGLPixelFormatObj _fail_CGLRetainPixelFormat(CGLPixelFormatObj pix) {
    const char *_name = "CGLRetainPixelFormat";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static CGLPixelFormatObj _get_CGLRetainPixelFormat(CGLPixelFormatObj pix) {
    PFN_CGLRETAINPIXELFORMAT _ptr;
    _ptr = (PFN_CGLRETAINPIXELFORMAT)_getPublicProcAddress("CGLRetainPixelFormat");
    if (!_ptr) {
        _ptr = &_fail_CGLRetainPixelFormat;
    }
    _CGLRetainPixelFormat = _ptr;
    return _CGLRetainPixelFormat(pix);
}

PFN_CGLRETAINPIXELFORMAT _CGLRetainPixelFormat = &_get_CGLRetainPixelFormat;

static GLuint _fail_CGLGetPixelFormatRetainCount(CGLPixelFormatObj pix) {
    const char *_name = "CGLGetPixelFormatRetainCount";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static GLuint _get_CGLGetPixelFormatRetainCount(CGLPixelFormatObj pix) {
    PFN_CGLGETPIXELFORMATRETAINCOUNT _ptr;
    _ptr = (PFN_CGLGETPIXELFORMATRETAINCOUNT)_getPublicProcAddress("CGLGetPixelFormatRetainCount");
    if (!_ptr) {
        _ptr = &_fail_CGLGetPixelFormatRetainCount;
    }
    _CGLGetPixelFormatRetainCount = _ptr;
    return _CGLGetPixelFormatRetainCount(pix);
}

PFN_CGLGETPIXELFORMATRETAINCOUNT _CGLGetPixelFormatRetainCount = &_get_CGLGetPixelFormatRetainCount;

static CGLError _fail_CGLQueryRendererInfo(GLuint display_mask, CGLRendererInfoObj * rend, GLint * nrend) {
    const char *_name = "CGLQueryRendererInfo";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static CGLError _get_CGLQueryRendererInfo(GLuint display_mask, CGLRendererInfoObj * rend, GLint * nrend) {
    PFN_CGLQUERYRENDERERINFO _ptr;
    _ptr = (PFN_CGLQUERYRENDERERINFO)_getPublicProcAddress("CGLQueryRendererInfo");
    if (!_ptr) {
        _ptr = &_fail_CGLQueryRendererInfo;
    }
    _CGLQueryRendererInfo = _ptr;
    return _CGLQueryRendererInfo(display_mask, rend, nrend);
}

PFN_CGLQUERYRENDERERINFO _CGLQueryRendererInfo = &_get_CGLQueryRendererInfo;

static CGLError _fail_CGLDestroyRendererInfo(CGLRendererInfoObj rend) {
    const char *_name = "CGLDestroyRendererInfo";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static CGLError _get_CGLDestroyRendererInfo(CGLRendererInfoObj rend) {
    PFN_CGLDESTROYRENDERERINFO _ptr;
    _ptr = (PFN_CGLDESTROYRENDERERINFO)_getPublicProcAddress("CGLDestroyRendererInfo");
    if (!_ptr) {
        _ptr = &_fail_CGLDestroyRendererInfo;
    }
    _CGLDestroyRendererInfo = _ptr;
    return _CGLDestroyRendererInfo(rend);
}

PFN_CGLDESTROYRENDERERINFO _CGLDestroyRendererInfo = &_get_CGLDestroyRendererInfo;

static CGLError _fail_CGLDescribeRenderer(CGLRendererInfoObj rend, GLint rend_num, CGLRendererProperty prop, GLint * value) {
    const char *_name = "CGLDescribeRenderer";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static CGLError _get_CGLDescribeRenderer(CGLRendererInfoObj rend, GLint rend_num, CGLRendererProperty prop, GLint * value) {
    PFN_CGLDESCRIBERENDERER _ptr;
    _ptr = (PFN_CGLDESCRIBERENDERER)_getPublicProcAddress("CGLDescribeRenderer");
    if (!_ptr) {
        _ptr = &_fail_CGLDescribeRenderer;
    }
    _CGLDescribeRenderer = _ptr;
    return _CGLDescribeRenderer(rend, rend_num, prop, value);
}

PFN_CGLDESCRIBERENDERER _CGLDescribeRenderer = &_get_CGLDescribeRenderer;

static CGLError _fail_CGLCreateContext(CGLPixelFormatObj pix, CGLContextObj share, CGLContextObj * ctx) {
    const char *_name = "CGLCreateContext";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static CGLError _get_CGLCreateContext(CGLPixelFormatObj pix, CGLContextObj share, CGLContextObj * ctx) {
    PFN_CGLCREATECONTEXT _ptr;
    _ptr = (PFN_CGLCREATECONTEXT)_getPublicProcAddress("CGLCreateContext");
    if (!_ptr) {
        _ptr = &_fail_CGLCreateContext;
    }
    _CGLCreateContext = _ptr;
    return _CGLCreateContext(pix, share, ctx);
}

PFN_CGLCREATECONTEXT _CGLCreateContext = &_get_CGLCreateContext;

static CGLError _fail_CGLDestroyContext(CGLContextObj ctx) {
    const char *_name = "CGLDestroyContext";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static CGLError _get_CGLDestroyContext(CGLContextObj ctx) {
    PFN_CGLDESTROYCONTEXT _ptr;
    _ptr = (PFN_CGLDESTROYCONTEXT)_getPublicProcAddress("CGLDestroyContext");
    if (!_ptr) {
        _ptr = &_fail_CGLDestroyContext;
    }
    _CGLDestroyContext = _ptr;
    return _CGLDestroyContext(ctx);
}

PFN_CGLDESTROYCONTEXT _CGLDestroyContext = &_get_CGLDestroyContext;

static CGLError _fail_CGLCopyContext(CGLContextObj src, CGLContextObj dst, GLbitfield mask) {
    const char *_name = "CGLCopyContext";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static CGLError _get_CGLCopyContext(CGLContextObj src, CGLContextObj dst, GLbitfield mask) {
    PFN_CGLCOPYCONTEXT _ptr;
    _ptr = (PFN_CGLCOPYCONTEXT)_getPublicProcAddress("CGLCopyContext");
    if (!_ptr) {
        _ptr = &_fail_CGLCopyContext;
    }
    _CGLCopyContext = _ptr;
    return _CGLCopyContext(src, dst, mask);
}

PFN_CGLCOPYCONTEXT _CGLCopyContext = &_get_CGLCopyContext;

static CGLContextObj _fail_CGLRetainContext(CGLContextObj ctx) {
    const char *_name = "CGLRetainContext";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static CGLContextObj _get_CGLRetainContext(CGLContextObj ctx) {
    PFN_CGLRETAINCONTEXT _ptr;
    _ptr = (PFN_CGLRETAINCONTEXT)_getPublicProcAddress("CGLRetainContext");
    if (!_ptr) {
        _ptr = &_fail_CGLRetainContext;
    }
    _CGLRetainContext = _ptr;
    return _CGLRetainContext(ctx);
}

PFN_CGLRETAINCONTEXT _CGLRetainContext = &_get_CGLRetainContext;

static void _fail_CGLReleaseContext(CGLContextObj ctx) {
    const char *_name = "CGLReleaseContext";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void _get_CGLReleaseContext(CGLContextObj ctx) {
    PFN_CGLRELEASECONTEXT _ptr;
    _ptr = (PFN_CGLRELEASECONTEXT)_getPublicProcAddress("CGLReleaseContext");
    if (!_ptr) {
        _ptr = &_fail_CGLReleaseContext;
    }
    _CGLReleaseContext = _ptr;
    _CGLReleaseContext(ctx);
}

PFN_CGLRELEASECONTEXT _CGLReleaseContext = &_get_CGLReleaseContext;

static GLuint _fail_CGLGetContextRetainCount(CGLContextObj ctx) {
    const char *_name = "CGLGetContextRetainCount";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static GLuint _get_CGLGetContextRetainCount(CGLContextObj ctx) {
    PFN_CGLGETCONTEXTRETAINCOUNT _ptr;
    _ptr = (PFN_CGLGETCONTEXTRETAINCOUNT)_getPublicProcAddress("CGLGetContextRetainCount");
    if (!_ptr) {
        _ptr = &_fail_CGLGetContextRetainCount;
    }
    _CGLGetContextRetainCount = _ptr;
    return _CGLGetContextRetainCount(ctx);
}

PFN_CGLGETCONTEXTRETAINCOUNT _CGLGetContextRetainCount = &_get_CGLGetContextRetainCount;

static CGLPixelFormatObj _fail_CGLGetPixelFormat(CGLContextObj ctx) {
    const char *_name = "CGLGetPixelFormat";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static CGLPixelFormatObj _get_CGLGetPixelFormat(CGLContextObj ctx) {
    PFN_CGLGETPIXELFORMAT _ptr;
    _ptr = (PFN_CGLGETPIXELFORMAT)_getPublicProcAddress("CGLGetPixelFormat");
    if (!_ptr) {
        _ptr = &_fail_CGLGetPixelFormat;
    }
    _CGLGetPixelFormat = _ptr;
    return _CGLGetPixelFormat(ctx);
}

PFN_CGLGETPIXELFORMAT _CGLGetPixelFormat = &_get_CGLGetPixelFormat;

static CGLError _fail_CGLCreatePBuffer(GLsizei width, GLsizei height, GLenum target, GLenum internalFormat, GLint max_level, CGLPBufferObj * pbuffer) {
    const char *_name = "CGLCreatePBuffer";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static CGLError _get_CGLCreatePBuffer(GLsizei width, GLsizei height, GLenum target, GLenum internalFormat, GLint max_level, CGLPBufferObj * pbuffer) {
    PFN_CGLCREATEPBUFFER _ptr;
    _ptr = (PFN_CGLCREATEPBUFFER)_getPublicProcAddress("CGLCreatePBuffer");
    if (!_ptr) {
        _ptr = &_fail_CGLCreatePBuffer;
    }
    _CGLCreatePBuffer = _ptr;
    return _CGLCreatePBuffer(width, height, target, internalFormat, max_level, pbuffer);
}

PFN_CGLCREATEPBUFFER _CGLCreatePBuffer = &_get_CGLCreatePBuffer;

static CGLError _fail_CGLDestroyPBuffer(CGLPBufferObj pbuffer) {
    const char *_name = "CGLDestroyPBuffer";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static CGLError _get_CGLDestroyPBuffer(CGLPBufferObj pbuffer) {
    PFN_CGLDESTROYPBUFFER _ptr;
    _ptr = (PFN_CGLDESTROYPBUFFER)_getPublicProcAddress("CGLDestroyPBuffer");
    if (!_ptr) {
        _ptr = &_fail_CGLDestroyPBuffer;
    }
    _CGLDestroyPBuffer = _ptr;
    return _CGLDestroyPBuffer(pbuffer);
}

PFN_CGLDESTROYPBUFFER _CGLDestroyPBuffer = &_get_CGLDestroyPBuffer;

static CGLError _fail_CGLDescribePBuffer(CGLPBufferObj obj, GLsizei * width, GLsizei * height, GLenum * target, GLenum * internalFormat, GLint * mipmap) {
    const char *_name = "CGLDescribePBuffer";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static CGLError _get_CGLDescribePBuffer(CGLPBufferObj obj, GLsizei * width, GLsizei * height, GLenum * target, GLenum * internalFormat, GLint * mipmap) {
    PFN_CGLDESCRIBEPBUFFER _ptr;
    _ptr = (PFN_CGLDESCRIBEPBUFFER)_getPublicProcAddress("CGLDescribePBuffer");
    if (!_ptr) {
        _ptr = &_fail_CGLDescribePBuffer;
    }
    _CGLDescribePBuffer = _ptr;
    return _CGLDescribePBuffer(obj, width, height, target, internalFormat, mipmap);
}

PFN_CGLDESCRIBEPBUFFER _CGLDescribePBuffer = &_get_CGLDescribePBuffer;

static CGLError _fail_CGLTexImagePBuffer(CGLContextObj ctx, CGLPBufferObj pbuffer, GLenum source) {
    const char *_name = "CGLTexImagePBuffer";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static CGLError _get_CGLTexImagePBuffer(CGLContextObj ctx, CGLPBufferObj pbuffer, GLenum source) {
    PFN_CGLTEXIMAGEPBUFFER _ptr;
    _ptr = (PFN_CGLTEXIMAGEPBUFFER)_getPublicProcAddress("CGLTexImagePBuffer");
    if (!_ptr) {
        _ptr = &_fail_CGLTexImagePBuffer;
    }
    _CGLTexImagePBuffer = _ptr;
    return _CGLTexImagePBuffer(ctx, pbuffer, source);
}

PFN_CGLTEXIMAGEPBUFFER _CGLTexImagePBuffer = &_get_CGLTexImagePBuffer;

static CGLPBufferObj _fail_CGLRetainPBuffer(CGLPBufferObj pbuffer) {
    const char *_name = "CGLRetainPBuffer";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static CGLPBufferObj _get_CGLRetainPBuffer(CGLPBufferObj pbuffer) {
    PFN_CGLRETAINPBUFFER _ptr;
    _ptr = (PFN_CGLRETAINPBUFFER)_getPublicProcAddress("CGLRetainPBuffer");
    if (!_ptr) {
        _ptr = &_fail_CGLRetainPBuffer;
    }
    _CGLRetainPBuffer = _ptr;
    return _CGLRetainPBuffer(pbuffer);
}

PFN_CGLRETAINPBUFFER _CGLRetainPBuffer = &_get_CGLRetainPBuffer;

static void _fail_CGLReleasePBuffer(CGLPBufferObj pbuffer) {
    const char *_name = "CGLReleasePBuffer";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void _get_CGLReleasePBuffer(CGLPBufferObj pbuffer) {
    PFN_CGLRELEASEPBUFFER _ptr;
    _ptr = (PFN_CGLRELEASEPBUFFER)_getPublicProcAddress("CGLReleasePBuffer");
    if (!_ptr) {
        _ptr = &_fail_CGLReleasePBuffer;
    }
    _CGLReleasePBuffer = _ptr;
    _CGLReleasePBuffer(pbuffer);
}

PFN_CGLRELEASEPBUFFER _CGLReleasePBuffer = &_get_CGLReleasePBuffer;

static GLuint _fail_CGLGetPBufferRetainCount(CGLPBufferObj pbuffer) {
    const char *_name = "CGLGetPBufferRetainCount";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static GLuint _get_CGLGetPBufferRetainCount(CGLPBufferObj pbuffer) {
    PFN_CGLGETPBUFFERRETAINCOUNT _ptr;
    _ptr = (PFN_CGLGETPBUFFERRETAINCOUNT)_getPublicProcAddress("CGLGetPBufferRetainCount");
    if (!_ptr) {
        _ptr = &_fail_CGLGetPBufferRetainCount;
    }
    _CGLGetPBufferRetainCount = _ptr;
    return _CGLGetPBufferRetainCount(pbuffer);
}

PFN_CGLGETPBUFFERRETAINCOUNT _CGLGetPBufferRetainCount = &_get_CGLGetPBufferRetainCount;

static CGLError _fail_CGLSetOffScreen(CGLContextObj ctx, GLsizei width, GLsizei height, GLint rowbytes, void * baseaddr) {
    const char *_name = "CGLSetOffScreen";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static CGLError _get_CGLSetOffScreen(CGLContextObj ctx, GLsizei width, GLsizei height, GLint rowbytes, void * baseaddr) {
    PFN_CGLSETOFFSCREEN _ptr;
    _ptr = (PFN_CGLSETOFFSCREEN)_getPublicProcAddress("CGLSetOffScreen");
    if (!_ptr) {
        _ptr = &_fail_CGLSetOffScreen;
    }
    _CGLSetOffScreen = _ptr;
    return _CGLSetOffScreen(ctx, width, height, rowbytes, baseaddr);
}

PFN_CGLSETOFFSCREEN _CGLSetOffScreen = &_get_CGLSetOffScreen;

static CGLError _fail_CGLGetOffScreen(CGLContextObj ctx, GLsizei * width, GLsizei * height, GLint * rowbytes, void * * baseaddr) {
    const char *_name = "CGLGetOffScreen";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static CGLError _get_CGLGetOffScreen(CGLContextObj ctx, GLsizei * width, GLsizei * height, GLint * rowbytes, void * * baseaddr) {
    PFN_CGLGETOFFSCREEN _ptr;
    _ptr = (PFN_CGLGETOFFSCREEN)_getPublicProcAddress("CGLGetOffScreen");
    if (!_ptr) {
        _ptr = &_fail_CGLGetOffScreen;
    }
    _CGLGetOffScreen = _ptr;
    return _CGLGetOffScreen(ctx, width, height, rowbytes, baseaddr);
}

PFN_CGLGETOFFSCREEN _CGLGetOffScreen = &_get_CGLGetOffScreen;

static CGLError _fail_CGLSetFullScreen(CGLContextObj ctx) {
    const char *_name = "CGLSetFullScreen";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static CGLError _get_CGLSetFullScreen(CGLContextObj ctx) {
    PFN_CGLSETFULLSCREEN _ptr;
    _ptr = (PFN_CGLSETFULLSCREEN)_getPublicProcAddress("CGLSetFullScreen");
    if (!_ptr) {
        _ptr = &_fail_CGLSetFullScreen;
    }
    _CGLSetFullScreen = _ptr;
    return _CGLSetFullScreen(ctx);
}

PFN_CGLSETFULLSCREEN _CGLSetFullScreen = &_get_CGLSetFullScreen;

static CGLError _fail_CGLSetFullScreenOnDisplay(CGLContextObj ctx, GLuint display_mask) {
    const char *_name = "CGLSetFullScreenOnDisplay";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static CGLError _get_CGLSetFullScreenOnDisplay(CGLContextObj ctx, GLuint display_mask) {
    PFN_CGLSETFULLSCREENONDISPLAY _ptr;
    _ptr = (PFN_CGLSETFULLSCREENONDISPLAY)_getPublicProcAddress("CGLSetFullScreenOnDisplay");
    if (!_ptr) {
        _ptr = &_fail_CGLSetFullScreenOnDisplay;
    }
    _CGLSetFullScreenOnDisplay = _ptr;
    return _CGLSetFullScreenOnDisplay(ctx, display_mask);
}

PFN_CGLSETFULLSCREENONDISPLAY _CGLSetFullScreenOnDisplay = &_get_CGLSetFullScreenOnDisplay;

static CGLError _fail_CGLSetPBuffer(CGLContextObj ctx, CGLPBufferObj pbuffer, GLenum face, GLint level, GLint screen) {
    const char *_name = "CGLSetPBuffer";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static CGLError _get_CGLSetPBuffer(CGLContextObj ctx, CGLPBufferObj pbuffer, GLenum face, GLint level, GLint screen) {
    PFN_CGLSETPBUFFER _ptr;
    _ptr = (PFN_CGLSETPBUFFER)_getPublicProcAddress("CGLSetPBuffer");
    if (!_ptr) {
        _ptr = &_fail_CGLSetPBuffer;
    }
    _CGLSetPBuffer = _ptr;
    return _CGLSetPBuffer(ctx, pbuffer, face, level, screen);
}

PFN_CGLSETPBUFFER _CGLSetPBuffer = &_get_CGLSetPBuffer;

static CGLError _fail_CGLGetPBuffer(CGLContextObj ctx, CGLPBufferObj * pbuffer, GLenum * face, GLint * level, GLint * screen) {
    const char *_name = "CGLGetPBuffer";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static CGLError _get_CGLGetPBuffer(CGLContextObj ctx, CGLPBufferObj * pbuffer, GLenum * face, GLint * level, GLint * screen) {
    PFN_CGLGETPBUFFER _ptr;
    _ptr = (PFN_CGLGETPBUFFER)_getPublicProcAddress("CGLGetPBuffer");
    if (!_ptr) {
        _ptr = &_fail_CGLGetPBuffer;
    }
    _CGLGetPBuffer = _ptr;
    return _CGLGetPBuffer(ctx, pbuffer, face, level, screen);
}

PFN_CGLGETPBUFFER _CGLGetPBuffer = &_get_CGLGetPBuffer;

static CGLError _fail_CGLClearDrawable(CGLContextObj ctx) {
    const char *_name = "CGLClearDrawable";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static CGLError _get_CGLClearDrawable(CGLContextObj ctx) {
    PFN_CGLCLEARDRAWABLE _ptr;
    _ptr = (PFN_CGLCLEARDRAWABLE)_getPublicProcAddress("CGLClearDrawable");
    if (!_ptr) {
        _ptr = &_fail_CGLClearDrawable;
    }
    _CGLClearDrawable = _ptr;
    return _CGLClearDrawable(ctx);
}

PFN_CGLCLEARDRAWABLE _CGLClearDrawable = &_get_CGLClearDrawable;

static CGLError _fail_CGLFlushDrawable(CGLContextObj ctx) {
    const char *_name = "CGLFlushDrawable";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static CGLError _get_CGLFlushDrawable(CGLContextObj ctx) {
    PFN_CGLFLUSHDRAWABLE _ptr;
    _ptr = (PFN_CGLFLUSHDRAWABLE)_getPublicProcAddress("CGLFlushDrawable");
    if (!_ptr) {
        _ptr = &_fail_CGLFlushDrawable;
    }
    _CGLFlushDrawable = _ptr;
    return _CGLFlushDrawable(ctx);
}

PFN_CGLFLUSHDRAWABLE _CGLFlushDrawable = &_get_CGLFlushDrawable;

static CGLError _fail_CGLEnable(CGLContextObj ctx, CGLContextEnable pname) {
    const char *_name = "CGLEnable";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static CGLError _get_CGLEnable(CGLContextObj ctx, CGLContextEnable pname) {
    PFN_CGLENABLE _ptr;
    _ptr = (PFN_CGLENABLE)_getPublicProcAddress("CGLEnable");
    if (!_ptr) {
        _ptr = &_fail_CGLEnable;
    }
    _CGLEnable = _ptr;
    return _CGLEnable(ctx, pname);
}

PFN_CGLENABLE _CGLEnable = &_get_CGLEnable;

static CGLError _fail_CGLDisable(CGLContextObj ctx, CGLContextEnable pname) {
    const char *_name = "CGLDisable";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static CGLError _get_CGLDisable(CGLContextObj ctx, CGLContextEnable pname) {
    PFN_CGLDISABLE _ptr;
    _ptr = (PFN_CGLDISABLE)_getPublicProcAddress("CGLDisable");
    if (!_ptr) {
        _ptr = &_fail_CGLDisable;
    }
    _CGLDisable = _ptr;
    return _CGLDisable(ctx, pname);
}

PFN_CGLDISABLE _CGLDisable = &_get_CGLDisable;

static CGLError _fail_CGLIsEnabled(CGLContextObj ctx, CGLContextEnable pname, GLint * enable) {
    const char *_name = "CGLIsEnabled";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static CGLError _get_CGLIsEnabled(CGLContextObj ctx, CGLContextEnable pname, GLint * enable) {
    PFN_CGLISENABLED _ptr;
    _ptr = (PFN_CGLISENABLED)_getPublicProcAddress("CGLIsEnabled");
    if (!_ptr) {
        _ptr = &_fail_CGLIsEnabled;
    }
    _CGLIsEnabled = _ptr;
    return _CGLIsEnabled(ctx, pname, enable);
}

PFN_CGLISENABLED _CGLIsEnabled = &_get_CGLIsEnabled;

static CGLError _fail_CGLSetParameter(CGLContextObj ctx, CGLContextParameter pname, const GLint * params) {
    const char *_name = "CGLSetParameter";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static CGLError _get_CGLSetParameter(CGLContextObj ctx, CGLContextParameter pname, const GLint * params) {
    PFN_CGLSETPARAMETER _ptr;
    _ptr = (PFN_CGLSETPARAMETER)_getPublicProcAddress("CGLSetParameter");
    if (!_ptr) {
        _ptr = &_fail_CGLSetParameter;
    }
    _CGLSetParameter = _ptr;
    return _CGLSetParameter(ctx, pname, params);
}

PFN_CGLSETPARAMETER _CGLSetParameter = &_get_CGLSetParameter;

static CGLError _fail_CGLGetParameter(CGLContextObj ctx, CGLContextParameter pname, GLint * params) {
    const char *_name = "CGLGetParameter";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static CGLError _get_CGLGetParameter(CGLContextObj ctx, CGLContextParameter pname, GLint * params) {
    PFN_CGLGETPARAMETER _ptr;
    _ptr = (PFN_CGLGETPARAMETER)_getPublicProcAddress("CGLGetParameter");
    if (!_ptr) {
        _ptr = &_fail_CGLGetParameter;
    }
    _CGLGetParameter = _ptr;
    return _CGLGetParameter(ctx, pname, params);
}

PFN_CGLGETPARAMETER _CGLGetParameter = &_get_CGLGetParameter;

static CGLError _fail_CGLSetVirtualScreen(CGLContextObj ctx, GLint screen) {
    const char *_name = "CGLSetVirtualScreen";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static CGLError _get_CGLSetVirtualScreen(CGLContextObj ctx, GLint screen) {
    PFN_CGLSETVIRTUALSCREEN _ptr;
    _ptr = (PFN_CGLSETVIRTUALSCREEN)_getPublicProcAddress("CGLSetVirtualScreen");
    if (!_ptr) {
        _ptr = &_fail_CGLSetVirtualScreen;
    }
    _CGLSetVirtualScreen = _ptr;
    return _CGLSetVirtualScreen(ctx, screen);
}

PFN_CGLSETVIRTUALSCREEN _CGLSetVirtualScreen = &_get_CGLSetVirtualScreen;

static CGLError _fail_CGLGetVirtualScreen(CGLContextObj ctx, GLint * screen) {
    const char *_name = "CGLGetVirtualScreen";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static CGLError _get_CGLGetVirtualScreen(CGLContextObj ctx, GLint * screen) {
    PFN_CGLGETVIRTUALSCREEN _ptr;
    _ptr = (PFN_CGLGETVIRTUALSCREEN)_getPublicProcAddress("CGLGetVirtualScreen");
    if (!_ptr) {
        _ptr = &_fail_CGLGetVirtualScreen;
    }
    _CGLGetVirtualScreen = _ptr;
    return _CGLGetVirtualScreen(ctx, screen);
}

PFN_CGLGETVIRTUALSCREEN _CGLGetVirtualScreen = &_get_CGLGetVirtualScreen;

static CGLError _fail_CGLSetGlobalOption(CGLGlobalOption pname, const GLint * params) {
    const char *_name = "CGLSetGlobalOption";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static CGLError _get_CGLSetGlobalOption(CGLGlobalOption pname, const GLint * params) {
    PFN_CGLSETGLOBALOPTION _ptr;
    _ptr = (PFN_CGLSETGLOBALOPTION)_getPublicProcAddress("CGLSetGlobalOption");
    if (!_ptr) {
        _ptr = &_fail_CGLSetGlobalOption;
    }
    _CGLSetGlobalOption = _ptr;
    return _CGLSetGlobalOption(pname, params);
}

PFN_CGLSETGLOBALOPTION _CGLSetGlobalOption = &_get_CGLSetGlobalOption;

static CGLError _fail_CGLGetGlobalOption(CGLGlobalOption pname, GLint * params) {
    const char *_name = "CGLGetGlobalOption";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static CGLError _get_CGLGetGlobalOption(CGLGlobalOption pname, GLint * params) {
    PFN_CGLGETGLOBALOPTION _ptr;
    _ptr = (PFN_CGLGETGLOBALOPTION)_getPublicProcAddress("CGLGetGlobalOption");
    if (!_ptr) {
        _ptr = &_fail_CGLGetGlobalOption;
    }
    _CGLGetGlobalOption = _ptr;
    return _CGLGetGlobalOption(pname, params);
}

PFN_CGLGETGLOBALOPTION _CGLGetGlobalOption = &_get_CGLGetGlobalOption;

static CGLError _fail_CGLSetOption(CGLGlobalOption pname, GLint param) {
    const char *_name = "CGLSetOption";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static CGLError _get_CGLSetOption(CGLGlobalOption pname, GLint param) {
    PFN_CGLSETOPTION _ptr;
    _ptr = (PFN_CGLSETOPTION)_getPublicProcAddress("CGLSetOption");
    if (!_ptr) {
        _ptr = &_fail_CGLSetOption;
    }
    _CGLSetOption = _ptr;
    return _CGLSetOption(pname, param);
}

PFN_CGLSETOPTION _CGLSetOption = &_get_CGLSetOption;

static CGLError _fail_CGLGetOption(CGLGlobalOption pname, GLint * param) {
    const char *_name = "CGLGetOption";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static CGLError _get_CGLGetOption(CGLGlobalOption pname, GLint * param) {
    PFN_CGLGETOPTION _ptr;
    _ptr = (PFN_CGLGETOPTION)_getPublicProcAddress("CGLGetOption");
    if (!_ptr) {
        _ptr = &_fail_CGLGetOption;
    }
    _CGLGetOption = _ptr;
    return _CGLGetOption(pname, param);
}

PFN_CGLGETOPTION _CGLGetOption = &_get_CGLGetOption;

static CGLError _fail_CGLLockContext(CGLContextObj ctx) {
    const char *_name = "CGLLockContext";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static CGLError _get_CGLLockContext(CGLContextObj ctx) {
    PFN_CGLLOCKCONTEXT _ptr;
    _ptr = (PFN_CGLLOCKCONTEXT)_getPublicProcAddress("CGLLockContext");
    if (!_ptr) {
        _ptr = &_fail_CGLLockContext;
    }
    _CGLLockContext = _ptr;
    return _CGLLockContext(ctx);
}

PFN_CGLLOCKCONTEXT _CGLLockContext = &_get_CGLLockContext;

static CGLError _fail_CGLUnlockContext(CGLContextObj ctx) {
    const char *_name = "CGLUnlockContext";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static CGLError _get_CGLUnlockContext(CGLContextObj ctx) {
    PFN_CGLUNLOCKCONTEXT _ptr;
    _ptr = (PFN_CGLUNLOCKCONTEXT)_getPublicProcAddress("CGLUnlockContext");
    if (!_ptr) {
        _ptr = &_fail_CGLUnlockContext;
    }
    _CGLUnlockContext = _ptr;
    return _CGLUnlockContext(ctx);
}

PFN_CGLUNLOCKCONTEXT _CGLUnlockContext = &_get_CGLUnlockContext;

static void _fail_CGLGetVersion(GLint * majorvers, GLint * minorvers) {
    const char *_name = "CGLGetVersion";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void _get_CGLGetVersion(GLint * majorvers, GLint * minorvers) {
    PFN_CGLGETVERSION _ptr;
    _ptr = (PFN_CGLGETVERSION)_getPublicProcAddress("CGLGetVersion");
    if (!_ptr) {
        _ptr = &_fail_CGLGetVersion;
    }
    _CGLGetVersion = _ptr;
    _CGLGetVersion(majorvers, minorvers);
}

PFN_CGLGETVERSION _CGLGetVersion = &_get_CGLGetVersion;

static const char * _fail_CGLErrorString(CGLError error) {
    const char *_name = "CGLErrorString";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static const char * _get_CGLErrorString(CGLError error) {
    PFN_CGLERRORSTRING _ptr;
    _ptr = (PFN_CGLERRORSTRING)_getPublicProcAddress("CGLErrorString");
    if (!_ptr) {
        _ptr = &_fail_CGLErrorString;
    }
    _CGLErrorString = _ptr;
    return _CGLErrorString(error);
}

PFN_CGLERRORSTRING _CGLErrorString = &_get_CGLErrorString;

static CGLError _fail_CGLTexImageIOSurface2D(CGLContextObj ctx, GLenum target, GLenum internal_format, GLsizei width, GLsizei height, GLenum format, GLenum type, IOSurfaceRef ioSurface, GLuint plane) {
    const char *_name = "CGLTexImageIOSurface2D";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static CGLError _get_CGLTexImageIOSurface2D(CGLContextObj ctx, GLenum target, GLenum internal_format, GLsizei width, GLsizei height, GLenum format, GLenum type, IOSurfaceRef ioSurface, GLuint plane) {
    PFN_CGLTEXIMAGEIOSURFACE2D _ptr;
    _ptr = (PFN_CGLTEXIMAGEIOSURFACE2D)_getPublicProcAddress("CGLTexImageIOSurface2D");
    if (!_ptr) {
        _ptr = &_fail_CGLTexImageIOSurface2D;
    }
    _CGLTexImageIOSurface2D = _ptr;
    return _CGLTexImageIOSurface2D(ctx, target, internal_format, width, height, format, type, ioSurface, plane);
}

PFN_CGLTEXIMAGEIOSURFACE2D _CGLTexImageIOSurface2D = &_get_CGLTexImageIOSurface2D;

static CGLShareGroupObj _fail_CGLGetShareGroup(CGLContextObj ctx) {
    const char *_name = "CGLGetShareGroup";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static CGLShareGroupObj _get_CGLGetShareGroup(CGLContextObj ctx) {
    PFN_CGLGETSHAREGROUP _ptr;
    _ptr = (PFN_CGLGETSHAREGROUP)_getPublicProcAddress("CGLGetShareGroup");
    if (!_ptr) {
        _ptr = &_fail_CGLGetShareGroup;
    }
    _CGLGetShareGroup = _ptr;
    return _CGLGetShareGroup(ctx);
}

PFN_CGLGETSHAREGROUP _CGLGetShareGroup = &_get_CGLGetShareGroup;

static CGLError _fail_CGLSetSurface(CGLContextObj ctx, CGSConnectionID cid, CGSWindowID wid, CGSSurfaceID sid) {
    const char *_name = "CGLSetSurface";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static CGLError _get_CGLSetSurface(CGLContextObj ctx, CGSConnectionID cid, CGSWindowID wid, CGSSurfaceID sid) {
    PFN_CGLSETSURFACE _ptr;
    _ptr = (PFN_CGLSETSURFACE)_getPublicProcAddress("CGLSetSurface");
    if (!_ptr) {
        _ptr = &_fail_CGLSetSurface;
    }
    _CGLSetSurface = _ptr;
    return _CGLSetSurface(ctx, cid, wid, sid);
}

PFN_CGLSETSURFACE _CGLSetSurface = &_get_CGLSetSurface;

static CGLError _fail_CGLGetSurface(CGLContextObj ctx, CGSConnectionID * cid, CGSWindowID * wid, CGSSurfaceID * sid) {
    const char *_name = "CGLGetSurface";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static CGLError _get_CGLGetSurface(CGLContextObj ctx, CGSConnectionID * cid, CGSWindowID * wid, CGSSurfaceID * sid) {
    PFN_CGLGETSURFACE _ptr;
    _ptr = (PFN_CGLGETSURFACE)_getPublicProcAddress("CGLGetSurface");
    if (!_ptr) {
        _ptr = &_fail_CGLGetSurface;
    }
    _CGLGetSurface = _ptr;
    return _CGLGetSurface(ctx, cid, wid, sid);
}

PFN_CGLGETSURFACE _CGLGetSurface = &_get_CGLGetSurface;

static CGLError _fail_CGLUpdateContext(CGLContextObj ctx) {
    const char *_name = "CGLUpdateContext";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static CGLError _get_CGLUpdateContext(CGLContextObj ctx) {
    PFN_CGLUPDATECONTEXT _ptr;
    _ptr = (PFN_CGLUPDATECONTEXT)_getPublicProcAddress("CGLUpdateContext");
    if (!_ptr) {
        _ptr = &_fail_CGLUpdateContext;
    }
    _CGLUpdateContext = _ptr;
    return _CGLUpdateContext(ctx);
}

PFN_CGLUPDATECONTEXT _CGLUpdateContext = &_get_CGLUpdateContext;

static CGLError _fail_CGLOpenCLMuxLockDown(void) {
    const char *_name = "CGLOpenCLMuxLockDown";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static CGLError _get_CGLOpenCLMuxLockDown(void) {
    PFN_CGLOPENCLMUXLOCKDOWN _ptr;
    _ptr = (PFN_CGLOPENCLMUXLOCKDOWN)_getPublicProcAddress("CGLOpenCLMuxLockDown");
    if (!_ptr) {
        _ptr = &_fail_CGLOpenCLMuxLockDown;
    }
    _CGLOpenCLMuxLockDown = _ptr;
    return _CGLOpenCLMuxLockDown();
}

PFN_CGLOPENCLMUXLOCKDOWN _CGLOpenCLMuxLockDown = &_get_CGLOpenCLMuxLockDown;

static GLboolean _fail_CGLAreContextsShared(CGLContextObj ctx1, CGLContextObj ctx2) {
    const char *_name = "CGLAreContextsShared";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static GLboolean _get_CGLAreContextsShared(CGLContextObj ctx1, CGLContextObj ctx2) {
    PFN_CGLARECONTEXTSSHARED _ptr;
    _ptr = (PFN_CGLARECONTEXTSSHARED)_getPublicProcAddress("CGLAreContextsShared");
    if (!_ptr) {
        _ptr = &_fail_CGLAreContextsShared;
    }
    _CGLAreContextsShared = _ptr;
    return _CGLAreContextsShared(ctx1, ctx2);
}

PFN_CGLARECONTEXTSSHARED _CGLAreContextsShared = &_get_CGLAreContextsShared;

static CGLContextObj _fail_CGLGetNextContext(CGLContextObj ctx) {
    const char *_name = "CGLGetNextContext";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static CGLContextObj _get_CGLGetNextContext(CGLContextObj ctx) {
    PFN_CGLGETNEXTCONTEXT _ptr;
    _ptr = (PFN_CGLGETNEXTCONTEXT)_getPublicProcAddress("CGLGetNextContext");
    if (!_ptr) {
        _ptr = &_fail_CGLGetNextContext;
    }
    _CGLGetNextContext = _ptr;
    return _CGLGetNextContext(ctx);
}

PFN_CGLGETNEXTCONTEXT _CGLGetNextContext = &_get_CGLGetNextContext;

static void * _fail_CGLFrontDispatch(CGLContextObj ctx) {
    const char *_name = "CGLFrontDispatch";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static void * _get_CGLFrontDispatch(CGLContextObj ctx) {
    PFN_CGLFRONTDISPATCH _ptr;
    _ptr = (PFN_CGLFRONTDISPATCH)_getPublicProcAddress("CGLFrontDispatch");
    if (!_ptr) {
        _ptr = &_fail_CGLFrontDispatch;
    }
    _CGLFrontDispatch = _ptr;
    return _CGLFrontDispatch(ctx);
}

PFN_CGLFRONTDISPATCH _CGLFrontDispatch = &_get_CGLFrontDispatch;

static void * _fail_CGLBackDispatch(CGLContextObj ctx) {
    const char *_name = "CGLBackDispatch";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static void * _get_CGLBackDispatch(CGLContextObj ctx) {
    PFN_CGLBACKDISPATCH _ptr;
    _ptr = (PFN_CGLBACKDISPATCH)_getPublicProcAddress("CGLBackDispatch");
    if (!_ptr) {
        _ptr = &_fail_CGLBackDispatch;
    }
    _CGLBackDispatch = _ptr;
    return _CGLBackDispatch(ctx);
}

PFN_CGLBACKDISPATCH _CGLBackDispatch = &_get_CGLBackDispatch;

static void _fail_CGLSelectDispatch(CGLContextObj ctx, void * dispatch) {
    const char *_name = "CGLSelectDispatch";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void _get_CGLSelectDispatch(CGLContextObj ctx, void * dispatch) {
    PFN_CGLSELECTDISPATCH _ptr;
    _ptr = (PFN_CGLSELECTDISPATCH)_getPublicProcAddress("CGLSelectDispatch");
    if (!_ptr) {
        _ptr = &_fail_CGLSelectDispatch;
    }
    _CGLSelectDispatch = _ptr;
    _CGLSelectDispatch(ctx, dispatch);
}

PFN_CGLSELECTDISPATCH _CGLSelectDispatch = &_get_CGLSelectDispatch;

static void _fail_CGLSelectDispatchBounded(CGLContextObj ctx, void * dispatch, GLint size) {
    const char *_name = "CGLSelectDispatchBounded";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void _get_CGLSelectDispatchBounded(CGLContextObj ctx, void * dispatch, GLint size) {
    PFN_CGLSELECTDISPATCHBOUNDED _ptr;
    _ptr = (PFN_CGLSELECTDISPATCHBOUNDED)_getPublicProcAddress("CGLSelectDispatchBounded");
    if (!_ptr) {
        _ptr = &_fail_CGLSelectDispatchBounded;
    }
    _CGLSelectDispatchBounded = _ptr;
    _CGLSelectDispatchBounded(ctx, dispatch, size);
}

PFN_CGLSELECTDISPATCHBOUNDED _CGLSelectDispatchBounded = &_get_CGLSelectDispatchBounded;

static void _fail_CGLSelectDispatchFunction(CGLContextObj ctx, void * functionPtr, GLint functionId) {
    const char *_name = "CGLSelectDispatchFunction";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void _get_CGLSelectDispatchFunction(CGLContextObj ctx, void * functionPtr, GLint functionId) {
    PFN_CGLSELECTDISPATCHFUNCTION _ptr;
    _ptr = (PFN_CGLSELECTDISPATCHFUNCTION)_getPublicProcAddress("CGLSelectDispatchFunction");
    if (!_ptr) {
        _ptr = &_fail_CGLSelectDispatchFunction;
    }
    _CGLSelectDispatchFunction = _ptr;
    _CGLSelectDispatchFunction(ctx, functionPtr, functionId);
}

PFN_CGLSELECTDISPATCHFUNCTION _CGLSelectDispatchFunction = &_get_CGLSelectDispatchFunction;

static void _fail_CGLRestoreDispatch(CGLContextObj ctx) {
    const char *_name = "CGLRestoreDispatch";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void _get_CGLRestoreDispatch(CGLContextObj ctx) {
    PFN_CGLRESTOREDISPATCH _ptr;
    _ptr = (PFN_CGLRESTOREDISPATCH)_getPublicProcAddress("CGLRestoreDispatch");
    if (!_ptr) {
        _ptr = &_fail_CGLRestoreDispatch;
    }
    _CGLRestoreDispatch = _ptr;
    _CGLRestoreDispatch(ctx);
}

PFN_CGLRESTOREDISPATCH _CGLRestoreDispatch = &_get_CGLRestoreDispatch;

static void _fail_CGLRestoreDispatchFunction(CGLContextObj ctx, GLint functionId) {
    const char *_name = "CGLRestoreDispatchFunction";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void _get_CGLRestoreDispatchFunction(CGLContextObj ctx, GLint functionId) {
    PFN_CGLRESTOREDISPATCHFUNCTION _ptr;
    _ptr = (PFN_CGLRESTOREDISPATCHFUNCTION)_getPublicProcAddress("CGLRestoreDispatchFunction");
    if (!_ptr) {
        _ptr = &_fail_CGLRestoreDispatchFunction;
    }
    _CGLRestoreDispatchFunction = _ptr;
    _CGLRestoreDispatchFunction(ctx, functionId);
}

PFN_CGLRESTOREDISPATCHFUNCTION _CGLRestoreDispatchFunction = &_get_CGLRestoreDispatchFunction;

static CGLError _fail_CGLSetPBufferVolatileState(CGLPBufferObj pbuffer, void * state) {
    const char *_name = "CGLSetPBufferVolatileState";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static CGLError _get_CGLSetPBufferVolatileState(CGLPBufferObj pbuffer, void * state) {
    PFN_CGLSETPBUFFERVOLATILESTATE _ptr;
    _ptr = (PFN_CGLSETPBUFFERVOLATILESTATE)_getPublicProcAddress("CGLSetPBufferVolatileState");
    if (!_ptr) {
        _ptr = &_fail_CGLSetPBufferVolatileState;
    }
    _CGLSetPBufferVolatileState = _ptr;
    return _CGLSetPBufferVolatileState(pbuffer, state);
}

PFN_CGLSETPBUFFERVOLATILESTATE _CGLSetPBufferVolatileState = &_get_CGLSetPBufferVolatileState;


#elif defined(HAVE_X11)

static XVisualInfo * _fail_glXChooseVisual(Display * dpy, int screen, int * attribList) {
    const char *_name = "glXChooseVisual";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static XVisualInfo * _get_glXChooseVisual(Display * dpy, int screen, int * attribList) {
    PFN_GLXCHOOSEVISUAL _ptr;
    _ptr = (PFN_GLXCHOOSEVISUAL)_getPublicProcAddress("glXChooseVisual");
    if (!_ptr) {
        _ptr = &_fail_glXChooseVisual;
    }
    _glXChooseVisual = _ptr;
    return _glXChooseVisual(dpy, screen, attribList);
}

PFN_GLXCHOOSEVISUAL _glXChooseVisual = &_get_glXChooseVisual;

static GLXContext _fail_glXCreateContext(Display * dpy, XVisualInfo * vis, GLXContext shareList, int direct) {
    const char *_name = "glXCreateContext";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static GLXContext _get_glXCreateContext(Display * dpy, XVisualInfo * vis, GLXContext shareList, int direct) {
    PFN_GLXCREATECONTEXT _ptr;
    _ptr = (PFN_GLXCREATECONTEXT)_getPublicProcAddress("glXCreateContext");
    if (!_ptr) {
        _ptr = &_fail_glXCreateContext;
    }
    _glXCreateContext = _ptr;
    return _glXCreateContext(dpy, vis, shareList, direct);
}

PFN_GLXCREATECONTEXT _glXCreateContext = &_get_glXCreateContext;

static void _fail_glXDestroyContext(Display * dpy, GLXContext ctx) {
    const char *_name = "glXDestroyContext";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void _get_glXDestroyContext(Display * dpy, GLXContext ctx) {
    PFN_GLXDESTROYCONTEXT _ptr;
    _ptr = (PFN_GLXDESTROYCONTEXT)_getPublicProcAddress("glXDestroyContext");
    if (!_ptr) {
        _ptr = &_fail_glXDestroyContext;
    }
    _glXDestroyContext = _ptr;
    _glXDestroyContext(dpy, ctx);
}

PFN_GLXDESTROYCONTEXT _glXDestroyContext = &_get_glXDestroyContext;

static int _fail_glXMakeCurrent(Display * dpy, GLXDrawable drawable, GLXContext ctx) {
    const char *_name = "glXMakeCurrent";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static int _get_glXMakeCurrent(Display * dpy, GLXDrawable drawable, GLXContext ctx) {
    PFN_GLXMAKECURRENT _ptr;
    _ptr = (PFN_GLXMAKECURRENT)_getPublicProcAddress("glXMakeCurrent");
    if (!_ptr) {
        _ptr = &_fail_glXMakeCurrent;
    }
    _glXMakeCurrent = _ptr;
    return _glXMakeCurrent(dpy, drawable, ctx);
}

PFN_GLXMAKECURRENT _glXMakeCurrent = &_get_glXMakeCurrent;

static void _fail_glXCopyContext(Display * dpy, GLXContext src, GLXContext dst, unsigned long mask) {
    const char *_name = "glXCopyContext";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void _get_glXCopyContext(Display * dpy, GLXContext src, GLXContext dst, unsigned long mask) {
    PFN_GLXCOPYCONTEXT _ptr;
    _ptr = (PFN_GLXCOPYCONTEXT)_getPublicProcAddress("glXCopyContext");
    if (!_ptr) {
        _ptr = &_fail_glXCopyContext;
    }
    _glXCopyContext = _ptr;
    _glXCopyContext(dpy, src, dst, mask);
}

PFN_GLXCOPYCONTEXT _glXCopyContext = &_get_glXCopyContext;

static void _fail_glXSwapBuffers(Display * dpy, GLXDrawable drawable) {
    const char *_name = "glXSwapBuffers";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void _get_glXSwapBuffers(Display * dpy, GLXDrawable drawable) {
    PFN_GLXSWAPBUFFERS _ptr;
    _ptr = (PFN_GLXSWAPBUFFERS)_getPublicProcAddress("glXSwapBuffers");
    if (!_ptr) {
        _ptr = &_fail_glXSwapBuffers;
    }
    _glXSwapBuffers = _ptr;
    _glXSwapBuffers(dpy, drawable);
}

PFN_GLXSWAPBUFFERS _glXSwapBuffers = &_get_glXSwapBuffers;

static GLXPixmap _fail_glXCreateGLXPixmap(Display * dpy, XVisualInfo * visual, Pixmap pixmap) {
    const char *_name = "glXCreateGLXPixmap";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static GLXPixmap _get_glXCreateGLXPixmap(Display * dpy, XVisualInfo * visual, Pixmap pixmap) {
    PFN_GLXCREATEGLXPIXMAP _ptr;
    _ptr = (PFN_GLXCREATEGLXPIXMAP)_getPublicProcAddress("glXCreateGLXPixmap");
    if (!_ptr) {
        _ptr = &_fail_glXCreateGLXPixmap;
    }
    _glXCreateGLXPixmap = _ptr;
    return _glXCreateGLXPixmap(dpy, visual, pixmap);
}

PFN_GLXCREATEGLXPIXMAP _glXCreateGLXPixmap = &_get_glXCreateGLXPixmap;

static void _fail_glXDestroyGLXPixmap(Display * dpy, GLXPixmap pixmap) {
    const char *_name = "glXDestroyGLXPixmap";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void _get_glXDestroyGLXPixmap(Display * dpy, GLXPixmap pixmap) {
    PFN_GLXDESTROYGLXPIXMAP _ptr;
    _ptr = (PFN_GLXDESTROYGLXPIXMAP)_getPublicProcAddress("glXDestroyGLXPixmap");
    if (!_ptr) {
        _ptr = &_fail_glXDestroyGLXPixmap;
    }
    _glXDestroyGLXPixmap = _ptr;
    _glXDestroyGLXPixmap(dpy, pixmap);
}

PFN_GLXDESTROYGLXPIXMAP _glXDestroyGLXPixmap = &_get_glXDestroyGLXPixmap;

static int _fail_glXQueryExtension(Display * dpy, int * errorb, int * event) {
    const char *_name = "glXQueryExtension";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static int _get_glXQueryExtension(Display * dpy, int * errorb, int * event) {
    PFN_GLXQUERYEXTENSION _ptr;
    _ptr = (PFN_GLXQUERYEXTENSION)_getPublicProcAddress("glXQueryExtension");
    if (!_ptr) {
        _ptr = &_fail_glXQueryExtension;
    }
    _glXQueryExtension = _ptr;
    return _glXQueryExtension(dpy, errorb, event);
}

PFN_GLXQUERYEXTENSION _glXQueryExtension = &_get_glXQueryExtension;

static int _fail_glXQueryVersion(Display * dpy, int * maj, int * min) {
    const char *_name = "glXQueryVersion";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static int _get_glXQueryVersion(Display * dpy, int * maj, int * min) {
    PFN_GLXQUERYVERSION _ptr;
    _ptr = (PFN_GLXQUERYVERSION)_getPublicProcAddress("glXQueryVersion");
    if (!_ptr) {
        _ptr = &_fail_glXQueryVersion;
    }
    _glXQueryVersion = _ptr;
    return _glXQueryVersion(dpy, maj, min);
}

PFN_GLXQUERYVERSION _glXQueryVersion = &_get_glXQueryVersion;

static int _fail_glXIsDirect(Display * dpy, GLXContext ctx) {
    const char *_name = "glXIsDirect";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static int _get_glXIsDirect(Display * dpy, GLXContext ctx) {
    PFN_GLXISDIRECT _ptr;
    _ptr = (PFN_GLXISDIRECT)_getPublicProcAddress("glXIsDirect");
    if (!_ptr) {
        _ptr = &_fail_glXIsDirect;
    }
    _glXIsDirect = _ptr;
    return _glXIsDirect(dpy, ctx);
}

PFN_GLXISDIRECT _glXIsDirect = &_get_glXIsDirect;

static int _fail_glXGetConfig(Display * dpy, XVisualInfo * visual, int attrib, int * value) {
    const char *_name = "glXGetConfig";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static int _get_glXGetConfig(Display * dpy, XVisualInfo * visual, int attrib, int * value) {
    PFN_GLXGETCONFIG _ptr;
    _ptr = (PFN_GLXGETCONFIG)_getPublicProcAddress("glXGetConfig");
    if (!_ptr) {
        _ptr = &_fail_glXGetConfig;
    }
    _glXGetConfig = _ptr;
    return _glXGetConfig(dpy, visual, attrib, value);
}

PFN_GLXGETCONFIG _glXGetConfig = &_get_glXGetConfig;

static GLXContext _fail_glXGetCurrentContext(void) {
    const char *_name = "glXGetCurrentContext";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static GLXContext _get_glXGetCurrentContext(void) {
    PFN_GLXGETCURRENTCONTEXT _ptr;
    _ptr = (PFN_GLXGETCURRENTCONTEXT)_getPublicProcAddress("glXGetCurrentContext");
    if (!_ptr) {
        _ptr = &_fail_glXGetCurrentContext;
    }
    _glXGetCurrentContext = _ptr;
    return _glXGetCurrentContext();
}

PFN_GLXGETCURRENTCONTEXT _glXGetCurrentContext = &_get_glXGetCurrentContext;

static GLXDrawable _fail_glXGetCurrentDrawable(void) {
    const char *_name = "glXGetCurrentDrawable";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static GLXDrawable _get_glXGetCurrentDrawable(void) {
    PFN_GLXGETCURRENTDRAWABLE _ptr;
    _ptr = (PFN_GLXGETCURRENTDRAWABLE)_getPublicProcAddress("glXGetCurrentDrawable");
    if (!_ptr) {
        _ptr = &_fail_glXGetCurrentDrawable;
    }
    _glXGetCurrentDrawable = _ptr;
    return _glXGetCurrentDrawable();
}

PFN_GLXGETCURRENTDRAWABLE _glXGetCurrentDrawable = &_get_glXGetCurrentDrawable;

static void _fail_glXWaitGL(void) {
    const char *_name = "glXWaitGL";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void _get_glXWaitGL(void) {
    PFN_GLXWAITGL _ptr;
    _ptr = (PFN_GLXWAITGL)_getPublicProcAddress("glXWaitGL");
    if (!_ptr) {
        _ptr = &_fail_glXWaitGL;
    }
    _glXWaitGL = _ptr;
    _glXWaitGL();
}

PFN_GLXWAITGL _glXWaitGL = &_get_glXWaitGL;

static void _fail_glXWaitX(void) {
    const char *_name = "glXWaitX";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void _get_glXWaitX(void) {
    PFN_GLXWAITX _ptr;
    _ptr = (PFN_GLXWAITX)_getPublicProcAddress("glXWaitX");
    if (!_ptr) {
        _ptr = &_fail_glXWaitX;
    }
    _glXWaitX = _ptr;
    _glXWaitX();
}

PFN_GLXWAITX _glXWaitX = &_get_glXWaitX;

static void _fail_glXUseXFont(Font font, int first, int count, int list) {
    const char *_name = "glXUseXFont";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void _get_glXUseXFont(Font font, int first, int count, int list) {
    PFN_GLXUSEXFONT _ptr;
    _ptr = (PFN_GLXUSEXFONT)_getPublicProcAddress("glXUseXFont");
    if (!_ptr) {
        _ptr = &_fail_glXUseXFont;
    }
    _glXUseXFont = _ptr;
    _glXUseXFont(font, first, count, list);
}

PFN_GLXUSEXFONT _glXUseXFont = &_get_glXUseXFont;

static const char * _fail_glXQueryExtensionsString(Display * dpy, int screen) {
    const char *_name = "glXQueryExtensionsString";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static const char * _get_glXQueryExtensionsString(Display * dpy, int screen) {
    PFN_GLXQUERYEXTENSIONSSTRING _ptr;
    _ptr = (PFN_GLXQUERYEXTENSIONSSTRING)_getPublicProcAddress("glXQueryExtensionsString");
    if (!_ptr) {
        _ptr = &_fail_glXQueryExtensionsString;
    }
    _glXQueryExtensionsString = _ptr;
    return _glXQueryExtensionsString(dpy, screen);
}

PFN_GLXQUERYEXTENSIONSSTRING _glXQueryExtensionsString = &_get_glXQueryExtensionsString;

static const char * _fail_glXQueryServerString(Display * dpy, int screen, int name) {
    const char *_name = "glXQueryServerString";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static const char * _get_glXQueryServerString(Display * dpy, int screen, int name) {
    PFN_GLXQUERYSERVERSTRING _ptr;
    _ptr = (PFN_GLXQUERYSERVERSTRING)_getPublicProcAddress("glXQueryServerString");
    if (!_ptr) {
        _ptr = &_fail_glXQueryServerString;
    }
    _glXQueryServerString = _ptr;
    return _glXQueryServerString(dpy, screen, name);
}

PFN_GLXQUERYSERVERSTRING _glXQueryServerString = &_get_glXQueryServerString;

static const char * _fail_glXGetClientString(Display * dpy, int name) {
    const char *_name = "glXGetClientString";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static const char * _get_glXGetClientString(Display * dpy, int name) {
    PFN_GLXGETCLIENTSTRING _ptr;
    _ptr = (PFN_GLXGETCLIENTSTRING)_getPublicProcAddress("glXGetClientString");
    if (!_ptr) {
        _ptr = &_fail_glXGetClientString;
    }
    _glXGetClientString = _ptr;
    return _glXGetClientString(dpy, name);
}

PFN_GLXGETCLIENTSTRING _glXGetClientString = &_get_glXGetClientString;

static Display * _fail_glXGetCurrentDisplay(void) {
    const char *_name = "glXGetCurrentDisplay";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static Display * _get_glXGetCurrentDisplay(void) {
    PFN_GLXGETCURRENTDISPLAY _ptr;
    _ptr = (PFN_GLXGETCURRENTDISPLAY)_getPublicProcAddress("glXGetCurrentDisplay");
    if (!_ptr) {
        _ptr = &_fail_glXGetCurrentDisplay;
    }
    _glXGetCurrentDisplay = _ptr;
    return _glXGetCurrentDisplay();
}

PFN_GLXGETCURRENTDISPLAY _glXGetCurrentDisplay = &_get_glXGetCurrentDisplay;

static GLXFBConfig * _fail_glXChooseFBConfig(Display * dpy, int screen, const int * attribList, int * nitems) {
    const char *_name = "glXChooseFBConfig";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static GLXFBConfig * _get_glXChooseFBConfig(Display * dpy, int screen, const int * attribList, int * nitems) {
    PFN_GLXCHOOSEFBCONFIG _ptr;
    _ptr = (PFN_GLXCHOOSEFBCONFIG)_getPublicProcAddress("glXChooseFBConfig");
    if (!_ptr) {
        _ptr = &_fail_glXChooseFBConfig;
    }
    _glXChooseFBConfig = _ptr;
    return _glXChooseFBConfig(dpy, screen, attribList, nitems);
}

PFN_GLXCHOOSEFBCONFIG _glXChooseFBConfig = &_get_glXChooseFBConfig;

static int _fail_glXGetFBConfigAttrib(Display * dpy, GLXFBConfig config, int attribute, int * value) {
    const char *_name = "glXGetFBConfigAttrib";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static int _get_glXGetFBConfigAttrib(Display * dpy, GLXFBConfig config, int attribute, int * value) {
    PFN_GLXGETFBCONFIGATTRIB _ptr;
    _ptr = (PFN_GLXGETFBCONFIGATTRIB)_getPublicProcAddress("glXGetFBConfigAttrib");
    if (!_ptr) {
        _ptr = &_fail_glXGetFBConfigAttrib;
    }
    _glXGetFBConfigAttrib = _ptr;
    return _glXGetFBConfigAttrib(dpy, config, attribute, value);
}

PFN_GLXGETFBCONFIGATTRIB _glXGetFBConfigAttrib = &_get_glXGetFBConfigAttrib;

static GLXFBConfig * _fail_glXGetFBConfigs(Display * dpy, int screen, int * nelements) {
    const char *_name = "glXGetFBConfigs";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static GLXFBConfig * _get_glXGetFBConfigs(Display * dpy, int screen, int * nelements) {
    PFN_GLXGETFBCONFIGS _ptr;
    _ptr = (PFN_GLXGETFBCONFIGS)_getPublicProcAddress("glXGetFBConfigs");
    if (!_ptr) {
        _ptr = &_fail_glXGetFBConfigs;
    }
    _glXGetFBConfigs = _ptr;
    return _glXGetFBConfigs(dpy, screen, nelements);
}

PFN_GLXGETFBCONFIGS _glXGetFBConfigs = &_get_glXGetFBConfigs;

static XVisualInfo * _fail_glXGetVisualFromFBConfig(Display * dpy, GLXFBConfig config) {
    const char *_name = "glXGetVisualFromFBConfig";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static XVisualInfo * _get_glXGetVisualFromFBConfig(Display * dpy, GLXFBConfig config) {
    PFN_GLXGETVISUALFROMFBCONFIG _ptr;
    _ptr = (PFN_GLXGETVISUALFROMFBCONFIG)_getPublicProcAddress("glXGetVisualFromFBConfig");
    if (!_ptr) {
        _ptr = &_fail_glXGetVisualFromFBConfig;
    }
    _glXGetVisualFromFBConfig = _ptr;
    return _glXGetVisualFromFBConfig(dpy, config);
}

PFN_GLXGETVISUALFROMFBCONFIG _glXGetVisualFromFBConfig = &_get_glXGetVisualFromFBConfig;

static GLXWindow _fail_glXCreateWindow(Display * dpy, GLXFBConfig config, Window win, const int * attribList) {
    const char *_name = "glXCreateWindow";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static GLXWindow _get_glXCreateWindow(Display * dpy, GLXFBConfig config, Window win, const int * attribList) {
    PFN_GLXCREATEWINDOW _ptr;
    _ptr = (PFN_GLXCREATEWINDOW)_getPublicProcAddress("glXCreateWindow");
    if (!_ptr) {
        _ptr = &_fail_glXCreateWindow;
    }
    _glXCreateWindow = _ptr;
    return _glXCreateWindow(dpy, config, win, attribList);
}

PFN_GLXCREATEWINDOW _glXCreateWindow = &_get_glXCreateWindow;

static void _fail_glXDestroyWindow(Display * dpy, GLXWindow window) {
    const char *_name = "glXDestroyWindow";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void _get_glXDestroyWindow(Display * dpy, GLXWindow window) {
    PFN_GLXDESTROYWINDOW _ptr;
    _ptr = (PFN_GLXDESTROYWINDOW)_getPublicProcAddress("glXDestroyWindow");
    if (!_ptr) {
        _ptr = &_fail_glXDestroyWindow;
    }
    _glXDestroyWindow = _ptr;
    _glXDestroyWindow(dpy, window);
}

PFN_GLXDESTROYWINDOW _glXDestroyWindow = &_get_glXDestroyWindow;

static GLXPixmap _fail_glXCreatePixmap(Display * dpy, GLXFBConfig config, Pixmap pixmap, const int * attribList) {
    const char *_name = "glXCreatePixmap";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static GLXPixmap _get_glXCreatePixmap(Display * dpy, GLXFBConfig config, Pixmap pixmap, const int * attribList) {
    PFN_GLXCREATEPIXMAP _ptr;
    _ptr = (PFN_GLXCREATEPIXMAP)_getPublicProcAddress("glXCreatePixmap");
    if (!_ptr) {
        _ptr = &_fail_glXCreatePixmap;
    }
    _glXCreatePixmap = _ptr;
    return _glXCreatePixmap(dpy, config, pixmap, attribList);
}

PFN_GLXCREATEPIXMAP _glXCreatePixmap = &_get_glXCreatePixmap;

static void _fail_glXDestroyPixmap(Display * dpy, GLXPixmap pixmap) {
    const char *_name = "glXDestroyPixmap";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void _get_glXDestroyPixmap(Display * dpy, GLXPixmap pixmap) {
    PFN_GLXDESTROYPIXMAP _ptr;
    _ptr = (PFN_GLXDESTROYPIXMAP)_getPublicProcAddress("glXDestroyPixmap");
    if (!_ptr) {
        _ptr = &_fail_glXDestroyPixmap;
    }
    _glXDestroyPixmap = _ptr;
    _glXDestroyPixmap(dpy, pixmap);
}

PFN_GLXDESTROYPIXMAP _glXDestroyPixmap = &_get_glXDestroyPixmap;

static GLXPbuffer _fail_glXCreatePbuffer(Display * dpy, GLXFBConfig config, const int * attribList) {
    const char *_name = "glXCreatePbuffer";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static GLXPbuffer _get_glXCreatePbuffer(Display * dpy, GLXFBConfig config, const int * attribList) {
    PFN_GLXCREATEPBUFFER _ptr;
    _ptr = (PFN_GLXCREATEPBUFFER)_getPublicProcAddress("glXCreatePbuffer");
    if (!_ptr) {
        _ptr = &_fail_glXCreatePbuffer;
    }
    _glXCreatePbuffer = _ptr;
    return _glXCreatePbuffer(dpy, config, attribList);
}

PFN_GLXCREATEPBUFFER _glXCreatePbuffer = &_get_glXCreatePbuffer;

static void _fail_glXDestroyPbuffer(Display * dpy, GLXPbuffer pbuf) {
    const char *_name = "glXDestroyPbuffer";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void _get_glXDestroyPbuffer(Display * dpy, GLXPbuffer pbuf) {
    PFN_GLXDESTROYPBUFFER _ptr;
    _ptr = (PFN_GLXDESTROYPBUFFER)_getPublicProcAddress("glXDestroyPbuffer");
    if (!_ptr) {
        _ptr = &_fail_glXDestroyPbuffer;
    }
    _glXDestroyPbuffer = _ptr;
    _glXDestroyPbuffer(dpy, pbuf);
}

PFN_GLXDESTROYPBUFFER _glXDestroyPbuffer = &_get_glXDestroyPbuffer;

static void _fail_glXQueryDrawable(Display * dpy, GLXDrawable draw, int attribute, unsigned int * value) {
    const char *_name = "glXQueryDrawable";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void _get_glXQueryDrawable(Display * dpy, GLXDrawable draw, int attribute, unsigned int * value) {
    PFN_GLXQUERYDRAWABLE _ptr;
    _ptr = (PFN_GLXQUERYDRAWABLE)_getPublicProcAddress("glXQueryDrawable");
    if (!_ptr) {
        _ptr = &_fail_glXQueryDrawable;
    }
    _glXQueryDrawable = _ptr;
    _glXQueryDrawable(dpy, draw, attribute, value);
}

PFN_GLXQUERYDRAWABLE _glXQueryDrawable = &_get_glXQueryDrawable;

static GLXContext _fail_glXCreateNewContext(Display * dpy, GLXFBConfig config, int renderType, GLXContext shareList, int direct) {
    const char *_name = "glXCreateNewContext";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static GLXContext _get_glXCreateNewContext(Display * dpy, GLXFBConfig config, int renderType, GLXContext shareList, int direct) {
    PFN_GLXCREATENEWCONTEXT _ptr;
    _ptr = (PFN_GLXCREATENEWCONTEXT)_getPublicProcAddress("glXCreateNewContext");
    if (!_ptr) {
        _ptr = &_fail_glXCreateNewContext;
    }
    _glXCreateNewContext = _ptr;
    return _glXCreateNewContext(dpy, config, renderType, shareList, direct);
}

PFN_GLXCREATENEWCONTEXT _glXCreateNewContext = &_get_glXCreateNewContext;

static int _fail_glXMakeContextCurrent(Display * dpy, GLXDrawable draw, GLXDrawable read, GLXContext ctx) {
    const char *_name = "glXMakeContextCurrent";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static int _get_glXMakeContextCurrent(Display * dpy, GLXDrawable draw, GLXDrawable read, GLXContext ctx) {
    PFN_GLXMAKECONTEXTCURRENT _ptr;
    _ptr = (PFN_GLXMAKECONTEXTCURRENT)_getPublicProcAddress("glXMakeContextCurrent");
    if (!_ptr) {
        _ptr = &_fail_glXMakeContextCurrent;
    }
    _glXMakeContextCurrent = _ptr;
    return _glXMakeContextCurrent(dpy, draw, read, ctx);
}

PFN_GLXMAKECONTEXTCURRENT _glXMakeContextCurrent = &_get_glXMakeContextCurrent;

static GLXDrawable _fail_glXGetCurrentReadDrawable(void) {
    const char *_name = "glXGetCurrentReadDrawable";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static GLXDrawable _get_glXGetCurrentReadDrawable(void) {
    PFN_GLXGETCURRENTREADDRAWABLE _ptr;
    _ptr = (PFN_GLXGETCURRENTREADDRAWABLE)_getPublicProcAddress("glXGetCurrentReadDrawable");
    if (!_ptr) {
        _ptr = &_fail_glXGetCurrentReadDrawable;
    }
    _glXGetCurrentReadDrawable = _ptr;
    return _glXGetCurrentReadDrawable();
}

PFN_GLXGETCURRENTREADDRAWABLE _glXGetCurrentReadDrawable = &_get_glXGetCurrentReadDrawable;

static int _fail_glXQueryContext(Display * dpy, GLXContext ctx, int attribute, int * value) {
    const char *_name = "glXQueryContext";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static int _get_glXQueryContext(Display * dpy, GLXContext ctx, int attribute, int * value) {
    PFN_GLXQUERYCONTEXT _ptr;
    _ptr = (PFN_GLXQUERYCONTEXT)_getPublicProcAddress("glXQueryContext");
    if (!_ptr) {
        _ptr = &_fail_glXQueryContext;
    }
    _glXQueryContext = _ptr;
    return _glXQueryContext(dpy, ctx, attribute, value);
}

PFN_GLXQUERYCONTEXT _glXQueryContext = &_get_glXQueryContext;

static void _fail_glXSelectEvent(Display * dpy, GLXDrawable drawable, unsigned long mask) {
    const char *_name = "glXSelectEvent";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void _get_glXSelectEvent(Display * dpy, GLXDrawable drawable, unsigned long mask) {
    PFN_GLXSELECTEVENT _ptr;
    _ptr = (PFN_GLXSELECTEVENT)_getPublicProcAddress("glXSelectEvent");
    if (!_ptr) {
        _ptr = &_fail_glXSelectEvent;
    }
    _glXSelectEvent = _ptr;
    _glXSelectEvent(dpy, drawable, mask);
}

PFN_GLXSELECTEVENT _glXSelectEvent = &_get_glXSelectEvent;

static void _fail_glXGetSelectedEvent(Display * dpy, GLXDrawable drawable, unsigned long * mask) {
    const char *_name = "glXGetSelectedEvent";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void _get_glXGetSelectedEvent(Display * dpy, GLXDrawable drawable, unsigned long * mask) {
    PFN_GLXGETSELECTEDEVENT _ptr;
    _ptr = (PFN_GLXGETSELECTEDEVENT)_getPublicProcAddress("glXGetSelectedEvent");
    if (!_ptr) {
        _ptr = &_fail_glXGetSelectedEvent;
    }
    _glXGetSelectedEvent = _ptr;
    _glXGetSelectedEvent(dpy, drawable, mask);
}

PFN_GLXGETSELECTEDEVENT _glXGetSelectedEvent = &_get_glXGetSelectedEvent;

static GLXContext _fail_glXCreateContextAttribsARB(Display * dpy, GLXFBConfig config, GLXContext share_context, int direct, const int * attrib_list) {
    const char *_name = "glXCreateContextAttribsARB";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static GLXContext _get_glXCreateContextAttribsARB(Display * dpy, GLXFBConfig config, GLXContext share_context, int direct, const int * attrib_list) {
    PFN_GLXCREATECONTEXTATTRIBSARB _ptr;
    _ptr = (PFN_GLXCREATECONTEXTATTRIBSARB)_getPrivateProcAddress("glXCreateContextAttribsARB");
    if (!_ptr) {
        _ptr = &_fail_glXCreateContextAttribsARB;
    }
    _glXCreateContextAttribsARB = _ptr;
    return _glXCreateContextAttribsARB(dpy, config, share_context, direct, attrib_list);
}

PFN_GLXCREATECONTEXTATTRIBSARB _glXCreateContextAttribsARB = &_get_glXCreateContextAttribsARB;

static Display * _fail_glXGetCurrentDisplayEXT(void) {
    const char *_name = "glXGetCurrentDisplayEXT";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static Display * _get_glXGetCurrentDisplayEXT(void) {
    PFN_GLXGETCURRENTDISPLAYEXT _ptr;
    _ptr = (PFN_GLXGETCURRENTDISPLAYEXT)_getPrivateProcAddress("glXGetCurrentDisplayEXT");
    if (!_ptr) {
        _ptr = &_fail_glXGetCurrentDisplayEXT;
    }
    _glXGetCurrentDisplayEXT = _ptr;
    return _glXGetCurrentDisplayEXT();
}

PFN_GLXGETCURRENTDISPLAYEXT _glXGetCurrentDisplayEXT = &_get_glXGetCurrentDisplayEXT;

static int _fail_glXQueryContextInfoEXT(Display * dpy, GLXContext context, int attribute, int * value) {
    const char *_name = "glXQueryContextInfoEXT";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static int _get_glXQueryContextInfoEXT(Display * dpy, GLXContext context, int attribute, int * value) {
    PFN_GLXQUERYCONTEXTINFOEXT _ptr;
    _ptr = (PFN_GLXQUERYCONTEXTINFOEXT)_getPrivateProcAddress("glXQueryContextInfoEXT");
    if (!_ptr) {
        _ptr = &_fail_glXQueryContextInfoEXT;
    }
    _glXQueryContextInfoEXT = _ptr;
    return _glXQueryContextInfoEXT(dpy, context, attribute, value);
}

PFN_GLXQUERYCONTEXTINFOEXT _glXQueryContextInfoEXT = &_get_glXQueryContextInfoEXT;

static GLXContextID _fail_glXGetContextIDEXT(const GLXContext context) {
    const char *_name = "glXGetContextIDEXT";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static GLXContextID _get_glXGetContextIDEXT(const GLXContext context) {
    PFN_GLXGETCONTEXTIDEXT _ptr;
    _ptr = (PFN_GLXGETCONTEXTIDEXT)_getPrivateProcAddress("glXGetContextIDEXT");
    if (!_ptr) {
        _ptr = &_fail_glXGetContextIDEXT;
    }
    _glXGetContextIDEXT = _ptr;
    return _glXGetContextIDEXT(context);
}

PFN_GLXGETCONTEXTIDEXT _glXGetContextIDEXT = &_get_glXGetContextIDEXT;

static GLXContext _fail_glXImportContextEXT(Display * dpy, GLXContextID contextID) {
    const char *_name = "glXImportContextEXT";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static GLXContext _get_glXImportContextEXT(Display * dpy, GLXContextID contextID) {
    PFN_GLXIMPORTCONTEXTEXT _ptr;
    _ptr = (PFN_GLXIMPORTCONTEXTEXT)_getPrivateProcAddress("glXImportContextEXT");
    if (!_ptr) {
        _ptr = &_fail_glXImportContextEXT;
    }
    _glXImportContextEXT = _ptr;
    return _glXImportContextEXT(dpy, contextID);
}

PFN_GLXIMPORTCONTEXTEXT _glXImportContextEXT = &_get_glXImportContextEXT;

static void _fail_glXFreeContextEXT(Display * dpy, GLXContext context) {
    const char *_name = "glXFreeContextEXT";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void _get_glXFreeContextEXT(Display * dpy, GLXContext context) {
    PFN_GLXFREECONTEXTEXT _ptr;
    _ptr = (PFN_GLXFREECONTEXTEXT)_getPrivateProcAddress("glXFreeContextEXT");
    if (!_ptr) {
        _ptr = &_fail_glXFreeContextEXT;
    }
    _glXFreeContextEXT = _ptr;
    _glXFreeContextEXT(dpy, context);
}

PFN_GLXFREECONTEXTEXT _glXFreeContextEXT = &_get_glXFreeContextEXT;

static void _fail_glXSwapIntervalEXT(Display * dpy, GLXDrawable drawable, int interval) {
    const char *_name = "glXSwapIntervalEXT";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void _get_glXSwapIntervalEXT(Display * dpy, GLXDrawable drawable, int interval) {
    PFN_GLXSWAPINTERVALEXT _ptr;
    _ptr = (PFN_GLXSWAPINTERVALEXT)_getPrivateProcAddress("glXSwapIntervalEXT");
    if (!_ptr) {
        _ptr = &_fail_glXSwapIntervalEXT;
    }
    _glXSwapIntervalEXT = _ptr;
    _glXSwapIntervalEXT(dpy, drawable, interval);
}

PFN_GLXSWAPINTERVALEXT _glXSwapIntervalEXT = &_get_glXSwapIntervalEXT;

static void _fail_glXBindTexImageEXT(Display * display, GLXDrawable drawable, int buffer, const int * attrib_list) {
    const char *_name = "glXBindTexImageEXT";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void _get_glXBindTexImageEXT(Display * display, GLXDrawable drawable, int buffer, const int * attrib_list) {
    PFN_GLXBINDTEXIMAGEEXT _ptr;
    _ptr = (PFN_GLXBINDTEXIMAGEEXT)_getPrivateProcAddress("glXBindTexImageEXT");
    if (!_ptr) {
        _ptr = &_fail_glXBindTexImageEXT;
    }
    _glXBindTexImageEXT = _ptr;
    _glXBindTexImageEXT(display, drawable, buffer, attrib_list);
}

PFN_GLXBINDTEXIMAGEEXT _glXBindTexImageEXT = &_get_glXBindTexImageEXT;

static void _fail_glXReleaseTexImageEXT(Display * display, GLXDrawable drawable, int buffer) {
    const char *_name = "glXReleaseTexImageEXT";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void _get_glXReleaseTexImageEXT(Display * display, GLXDrawable drawable, int buffer) {
    PFN_GLXRELEASETEXIMAGEEXT _ptr;
    _ptr = (PFN_GLXRELEASETEXIMAGEEXT)_getPrivateProcAddress("glXReleaseTexImageEXT");
    if (!_ptr) {
        _ptr = &_fail_glXReleaseTexImageEXT;
    }
    _glXReleaseTexImageEXT = _ptr;
    _glXReleaseTexImageEXT(display, drawable, buffer);
}

PFN_GLXRELEASETEXIMAGEEXT _glXReleaseTexImageEXT = &_get_glXReleaseTexImageEXT;

static unsigned int _fail_glXGetAGPOffsetMESA(const void * pointer) {
    const char *_name = "glXGetAGPOffsetMESA";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static unsigned int _get_glXGetAGPOffsetMESA(const void * pointer) {
    PFN_GLXGETAGPOFFSETMESA _ptr;
    _ptr = (PFN_GLXGETAGPOFFSETMESA)_getPrivateProcAddress("glXGetAGPOffsetMESA");
    if (!_ptr) {
        _ptr = &_fail_glXGetAGPOffsetMESA;
    }
    _glXGetAGPOffsetMESA = _ptr;
    return _glXGetAGPOffsetMESA(pointer);
}

PFN_GLXGETAGPOFFSETMESA _glXGetAGPOffsetMESA = &_get_glXGetAGPOffsetMESA;

static void _fail_glXCopySubBufferMESA(Display * dpy, GLXDrawable drawable, int x, int y, int width, int height) {
    const char *_name = "glXCopySubBufferMESA";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void _get_glXCopySubBufferMESA(Display * dpy, GLXDrawable drawable, int x, int y, int width, int height) {
    PFN_GLXCOPYSUBBUFFERMESA _ptr;
    _ptr = (PFN_GLXCOPYSUBBUFFERMESA)_getPrivateProcAddress("glXCopySubBufferMESA");
    if (!_ptr) {
        _ptr = &_fail_glXCopySubBufferMESA;
    }
    _glXCopySubBufferMESA = _ptr;
    _glXCopySubBufferMESA(dpy, drawable, x, y, width, height);
}

PFN_GLXCOPYSUBBUFFERMESA _glXCopySubBufferMESA = &_get_glXCopySubBufferMESA;

static GLXPixmap _fail_glXCreateGLXPixmapMESA(Display * dpy, XVisualInfo * visual, Pixmap pixmap, Colormap cmap) {
    const char *_name = "glXCreateGLXPixmapMESA";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static GLXPixmap _get_glXCreateGLXPixmapMESA(Display * dpy, XVisualInfo * visual, Pixmap pixmap, Colormap cmap) {
    PFN_GLXCREATEGLXPIXMAPMESA _ptr;
    _ptr = (PFN_GLXCREATEGLXPIXMAPMESA)_getPrivateProcAddress("glXCreateGLXPixmapMESA");
    if (!_ptr) {
        _ptr = &_fail_glXCreateGLXPixmapMESA;
    }
    _glXCreateGLXPixmapMESA = _ptr;
    return _glXCreateGLXPixmapMESA(dpy, visual, pixmap, cmap);
}

PFN_GLXCREATEGLXPIXMAPMESA _glXCreateGLXPixmapMESA = &_get_glXCreateGLXPixmapMESA;

static int APIENTRY _fail_glXQueryCurrentRendererIntegerMESA(int attribute, unsigned int * value) {
    const char *_name = "glXQueryCurrentRendererIntegerMESA";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static int APIENTRY _get_glXQueryCurrentRendererIntegerMESA(int attribute, unsigned int * value) {
    PFN_GLXQUERYCURRENTRENDERERINTEGERMESA _ptr;
    _ptr = (PFN_GLXQUERYCURRENTRENDERERINTEGERMESA)_getPrivateProcAddress("glXQueryCurrentRendererIntegerMESA");
    if (!_ptr) {
        _ptr = &_fail_glXQueryCurrentRendererIntegerMESA;
    }
    _glXQueryCurrentRendererIntegerMESA = _ptr;
    return _glXQueryCurrentRendererIntegerMESA(attribute, value);
}

PFN_GLXQUERYCURRENTRENDERERINTEGERMESA _glXQueryCurrentRendererIntegerMESA = &_get_glXQueryCurrentRendererIntegerMESA;

static const char * APIENTRY _fail_glXQueryCurrentRendererStringMESA(int attribute) {
    const char *_name = "glXQueryCurrentRendererStringMESA";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static const char * APIENTRY _get_glXQueryCurrentRendererStringMESA(int attribute) {
    PFN_GLXQUERYCURRENTRENDERERSTRINGMESA _ptr;
    _ptr = (PFN_GLXQUERYCURRENTRENDERERSTRINGMESA)_getPrivateProcAddress("glXQueryCurrentRendererStringMESA");
    if (!_ptr) {
        _ptr = &_fail_glXQueryCurrentRendererStringMESA;
    }
    _glXQueryCurrentRendererStringMESA = _ptr;
    return _glXQueryCurrentRendererStringMESA(attribute);
}

PFN_GLXQUERYCURRENTRENDERERSTRINGMESA _glXQueryCurrentRendererStringMESA = &_get_glXQueryCurrentRendererStringMESA;

static int APIENTRY _fail_glXQueryRendererIntegerMESA(Display * dpy, int screen, int renderer, int attribute, unsigned int * value) {
    const char *_name = "glXQueryRendererIntegerMESA";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static int APIENTRY _get_glXQueryRendererIntegerMESA(Display * dpy, int screen, int renderer, int attribute, unsigned int * value) {
    PFN_GLXQUERYRENDERERINTEGERMESA _ptr;
    _ptr = (PFN_GLXQUERYRENDERERINTEGERMESA)_getPrivateProcAddress("glXQueryRendererIntegerMESA");
    if (!_ptr) {
        _ptr = &_fail_glXQueryRendererIntegerMESA;
    }
    _glXQueryRendererIntegerMESA = _ptr;
    return _glXQueryRendererIntegerMESA(dpy, screen, renderer, attribute, value);
}

PFN_GLXQUERYRENDERERINTEGERMESA _glXQueryRendererIntegerMESA = &_get_glXQueryRendererIntegerMESA;

static const char * APIENTRY _fail_glXQueryRendererStringMESA(Display * dpy, int screen, int renderer, int attribute) {
    const char *_name = "glXQueryRendererStringMESA";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static const char * APIENTRY _get_glXQueryRendererStringMESA(Display * dpy, int screen, int renderer, int attribute) {
    PFN_GLXQUERYRENDERERSTRINGMESA _ptr;
    _ptr = (PFN_GLXQUERYRENDERERSTRINGMESA)_getPrivateProcAddress("glXQueryRendererStringMESA");
    if (!_ptr) {
        _ptr = &_fail_glXQueryRendererStringMESA;
    }
    _glXQueryRendererStringMESA = _ptr;
    return _glXQueryRendererStringMESA(dpy, screen, renderer, attribute);
}

PFN_GLXQUERYRENDERERSTRINGMESA _glXQueryRendererStringMESA = &_get_glXQueryRendererStringMESA;

static int _fail_glXReleaseBuffersMESA(Display * dpy, GLXDrawable drawable) {
    const char *_name = "glXReleaseBuffersMESA";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static int _get_glXReleaseBuffersMESA(Display * dpy, GLXDrawable drawable) {
    PFN_GLXRELEASEBUFFERSMESA _ptr;
    _ptr = (PFN_GLXRELEASEBUFFERSMESA)_getPrivateProcAddress("glXReleaseBuffersMESA");
    if (!_ptr) {
        _ptr = &_fail_glXReleaseBuffersMESA;
    }
    _glXReleaseBuffersMESA = _ptr;
    return _glXReleaseBuffersMESA(dpy, drawable);
}

PFN_GLXRELEASEBUFFERSMESA _glXReleaseBuffersMESA = &_get_glXReleaseBuffersMESA;

static GLboolean _fail_glXSet3DfxModeMESA(GLint mode) {
    const char *_name = "glXSet3DfxModeMESA";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static GLboolean _get_glXSet3DfxModeMESA(GLint mode) {
    PFN_GLXSET3DFXMODEMESA _ptr;
    _ptr = (PFN_GLXSET3DFXMODEMESA)_getPrivateProcAddress("glXSet3DfxModeMESA");
    if (!_ptr) {
        _ptr = &_fail_glXSet3DfxModeMESA;
    }
    _glXSet3DfxModeMESA = _ptr;
    return _glXSet3DfxModeMESA(mode);
}

PFN_GLXSET3DFXMODEMESA _glXSet3DfxModeMESA = &_get_glXSet3DfxModeMESA;

static int _fail_glXSwapIntervalMESA(unsigned int interval) {
    const char *_name = "glXSwapIntervalMESA";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static int _get_glXSwapIntervalMESA(unsigned int interval) {
    PFN_GLXSWAPINTERVALMESA _ptr;
    _ptr = (PFN_GLXSWAPINTERVALMESA)_getPrivateProcAddress("glXSwapIntervalMESA");
    if (!_ptr) {
        _ptr = &_fail_glXSwapIntervalMESA;
    }
    _glXSwapIntervalMESA = _ptr;
    return _glXSwapIntervalMESA(interval);
}

PFN_GLXSWAPINTERVALMESA _glXSwapIntervalMESA = &_get_glXSwapIntervalMESA;

static int _fail_glXGetSwapIntervalMESA(void) {
    const char *_name = "glXGetSwapIntervalMESA";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static int _get_glXGetSwapIntervalMESA(void) {
    PFN_GLXGETSWAPINTERVALMESA _ptr;
    _ptr = (PFN_GLXGETSWAPINTERVALMESA)_getPrivateProcAddress("glXGetSwapIntervalMESA");
    if (!_ptr) {
        _ptr = &_fail_glXGetSwapIntervalMESA;
    }
    _glXGetSwapIntervalMESA = _ptr;
    return _glXGetSwapIntervalMESA();
}

PFN_GLXGETSWAPINTERVALMESA _glXGetSwapIntervalMESA = &_get_glXGetSwapIntervalMESA;

static void _fail_glXCopyImageSubDataNV(Display * dpy, GLXContext srcCtx, GLuint srcName, GLenum srcTarget, GLint srcLevel, GLint srcX, GLint srcY, GLint srcZ, GLXContext dstCtx, GLuint dstName, GLenum dstTarget, GLint dstLevel, GLint dstX, GLint dstY, GLint dstZ, GLsizei width, GLsizei height, GLsizei depth) {
    const char *_name = "glXCopyImageSubDataNV";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void _get_glXCopyImageSubDataNV(Display * dpy, GLXContext srcCtx, GLuint srcName, GLenum srcTarget, GLint srcLevel, GLint srcX, GLint srcY, GLint srcZ, GLXContext dstCtx, GLuint dstName, GLenum dstTarget, GLint dstLevel, GLint dstX, GLint dstY, GLint dstZ, GLsizei width, GLsizei height, GLsizei depth) {
    PFN_GLXCOPYIMAGESUBDATANV _ptr;
    _ptr = (PFN_GLXCOPYIMAGESUBDATANV)_getPrivateProcAddress("glXCopyImageSubDataNV");
    if (!_ptr) {
        _ptr = &_fail_glXCopyImageSubDataNV;
    }
    _glXCopyImageSubDataNV = _ptr;
    _glXCopyImageSubDataNV(dpy, srcCtx, srcName, srcTarget, srcLevel, srcX, srcY, srcZ, dstCtx, dstName, dstTarget, dstLevel, dstX, dstY, dstZ, width, height, depth);
}

PFN_GLXCOPYIMAGESUBDATANV _glXCopyImageSubDataNV = &_get_glXCopyImageSubDataNV;

static unsigned int * _fail_glXEnumerateVideoDevicesNV(Display * dpy, int screen, int * nelements) {
    const char *_name = "glXEnumerateVideoDevicesNV";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static unsigned int * _get_glXEnumerateVideoDevicesNV(Display * dpy, int screen, int * nelements) {
    PFN_GLXENUMERATEVIDEODEVICESNV _ptr;
    _ptr = (PFN_GLXENUMERATEVIDEODEVICESNV)_getPrivateProcAddress("glXEnumerateVideoDevicesNV");
    if (!_ptr) {
        _ptr = &_fail_glXEnumerateVideoDevicesNV;
    }
    _glXEnumerateVideoDevicesNV = _ptr;
    return _glXEnumerateVideoDevicesNV(dpy, screen, nelements);
}

PFN_GLXENUMERATEVIDEODEVICESNV _glXEnumerateVideoDevicesNV = &_get_glXEnumerateVideoDevicesNV;

static int _fail_glXBindVideoDeviceNV(Display * dpy, unsigned int video_slot, unsigned int video_device, const int * attrib_list) {
    const char *_name = "glXBindVideoDeviceNV";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static int _get_glXBindVideoDeviceNV(Display * dpy, unsigned int video_slot, unsigned int video_device, const int * attrib_list) {
    PFN_GLXBINDVIDEODEVICENV _ptr;
    _ptr = (PFN_GLXBINDVIDEODEVICENV)_getPrivateProcAddress("glXBindVideoDeviceNV");
    if (!_ptr) {
        _ptr = &_fail_glXBindVideoDeviceNV;
    }
    _glXBindVideoDeviceNV = _ptr;
    return _glXBindVideoDeviceNV(dpy, video_slot, video_device, attrib_list);
}

PFN_GLXBINDVIDEODEVICENV _glXBindVideoDeviceNV = &_get_glXBindVideoDeviceNV;

static int _fail_glXJoinSwapGroupNV(Display * dpy, GLXDrawable drawable, GLuint group) {
    const char *_name = "glXJoinSwapGroupNV";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static int _get_glXJoinSwapGroupNV(Display * dpy, GLXDrawable drawable, GLuint group) {
    PFN_GLXJOINSWAPGROUPNV _ptr;
    _ptr = (PFN_GLXJOINSWAPGROUPNV)_getPrivateProcAddress("glXJoinSwapGroupNV");
    if (!_ptr) {
        _ptr = &_fail_glXJoinSwapGroupNV;
    }
    _glXJoinSwapGroupNV = _ptr;
    return _glXJoinSwapGroupNV(dpy, drawable, group);
}

PFN_GLXJOINSWAPGROUPNV _glXJoinSwapGroupNV = &_get_glXJoinSwapGroupNV;

static int _fail_glXBindSwapBarrierNV(Display * dpy, GLuint group, GLuint barrier) {
    const char *_name = "glXBindSwapBarrierNV";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static int _get_glXBindSwapBarrierNV(Display * dpy, GLuint group, GLuint barrier) {
    PFN_GLXBINDSWAPBARRIERNV _ptr;
    _ptr = (PFN_GLXBINDSWAPBARRIERNV)_getPrivateProcAddress("glXBindSwapBarrierNV");
    if (!_ptr) {
        _ptr = &_fail_glXBindSwapBarrierNV;
    }
    _glXBindSwapBarrierNV = _ptr;
    return _glXBindSwapBarrierNV(dpy, group, barrier);
}

PFN_GLXBINDSWAPBARRIERNV _glXBindSwapBarrierNV = &_get_glXBindSwapBarrierNV;

static int _fail_glXQuerySwapGroupNV(Display * dpy, GLXDrawable drawable, GLuint * group, GLuint * barrier) {
    const char *_name = "glXQuerySwapGroupNV";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static int _get_glXQuerySwapGroupNV(Display * dpy, GLXDrawable drawable, GLuint * group, GLuint * barrier) {
    PFN_GLXQUERYSWAPGROUPNV _ptr;
    _ptr = (PFN_GLXQUERYSWAPGROUPNV)_getPrivateProcAddress("glXQuerySwapGroupNV");
    if (!_ptr) {
        _ptr = &_fail_glXQuerySwapGroupNV;
    }
    _glXQuerySwapGroupNV = _ptr;
    return _glXQuerySwapGroupNV(dpy, drawable, group, barrier);
}

PFN_GLXQUERYSWAPGROUPNV _glXQuerySwapGroupNV = &_get_glXQuerySwapGroupNV;

static int _fail_glXQueryMaxSwapGroupsNV(Display * dpy, int screen, GLuint * maxGroups, GLuint * maxBarriers) {
    const char *_name = "glXQueryMaxSwapGroupsNV";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static int _get_glXQueryMaxSwapGroupsNV(Display * dpy, int screen, GLuint * maxGroups, GLuint * maxBarriers) {
    PFN_GLXQUERYMAXSWAPGROUPSNV _ptr;
    _ptr = (PFN_GLXQUERYMAXSWAPGROUPSNV)_getPrivateProcAddress("glXQueryMaxSwapGroupsNV");
    if (!_ptr) {
        _ptr = &_fail_glXQueryMaxSwapGroupsNV;
    }
    _glXQueryMaxSwapGroupsNV = _ptr;
    return _glXQueryMaxSwapGroupsNV(dpy, screen, maxGroups, maxBarriers);
}

PFN_GLXQUERYMAXSWAPGROUPSNV _glXQueryMaxSwapGroupsNV = &_get_glXQueryMaxSwapGroupsNV;

static int _fail_glXQueryFrameCountNV(Display * dpy, int screen, GLuint * count) {
    const char *_name = "glXQueryFrameCountNV";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static int _get_glXQueryFrameCountNV(Display * dpy, int screen, GLuint * count) {
    PFN_GLXQUERYFRAMECOUNTNV _ptr;
    _ptr = (PFN_GLXQUERYFRAMECOUNTNV)_getPrivateProcAddress("glXQueryFrameCountNV");
    if (!_ptr) {
        _ptr = &_fail_glXQueryFrameCountNV;
    }
    _glXQueryFrameCountNV = _ptr;
    return _glXQueryFrameCountNV(dpy, screen, count);
}

PFN_GLXQUERYFRAMECOUNTNV _glXQueryFrameCountNV = &_get_glXQueryFrameCountNV;

static int _fail_glXResetFrameCountNV(Display * dpy, int screen) {
    const char *_name = "glXResetFrameCountNV";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static int _get_glXResetFrameCountNV(Display * dpy, int screen) {
    PFN_GLXRESETFRAMECOUNTNV _ptr;
    _ptr = (PFN_GLXRESETFRAMECOUNTNV)_getPrivateProcAddress("glXResetFrameCountNV");
    if (!_ptr) {
        _ptr = &_fail_glXResetFrameCountNV;
    }
    _glXResetFrameCountNV = _ptr;
    return _glXResetFrameCountNV(dpy, screen);
}

PFN_GLXRESETFRAMECOUNTNV _glXResetFrameCountNV = &_get_glXResetFrameCountNV;

static void * _fail_glXAllocateMemoryNV(GLsizei size, GLfloat readfreq, GLfloat writefreq, GLfloat priority) {
    const char *_name = "glXAllocateMemoryNV";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static void * _get_glXAllocateMemoryNV(GLsizei size, GLfloat readfreq, GLfloat writefreq, GLfloat priority) {
    PFN_GLXALLOCATEMEMORYNV _ptr;
    _ptr = (PFN_GLXALLOCATEMEMORYNV)_getPrivateProcAddress("glXAllocateMemoryNV");
    if (!_ptr) {
        _ptr = &_fail_glXAllocateMemoryNV;
    }
    _glXAllocateMemoryNV = _ptr;
    return _glXAllocateMemoryNV(size, readfreq, writefreq, priority);
}

PFN_GLXALLOCATEMEMORYNV _glXAllocateMemoryNV = &_get_glXAllocateMemoryNV;

static void _fail_glXFreeMemoryNV(void * pointer) {
    const char *_name = "glXFreeMemoryNV";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void _get_glXFreeMemoryNV(void * pointer) {
    PFN_GLXFREEMEMORYNV _ptr;
    _ptr = (PFN_GLXFREEMEMORYNV)_getPrivateProcAddress("glXFreeMemoryNV");
    if (!_ptr) {
        _ptr = &_fail_glXFreeMemoryNV;
    }
    _glXFreeMemoryNV = _ptr;
    _glXFreeMemoryNV(pointer);
}

PFN_GLXFREEMEMORYNV _glXFreeMemoryNV = &_get_glXFreeMemoryNV;

static int _fail_glXBindVideoCaptureDeviceNV(Display * dpy, unsigned int video_capture_slot, GLXVideoCaptureDeviceNV device) {
    const char *_name = "glXBindVideoCaptureDeviceNV";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static int _get_glXBindVideoCaptureDeviceNV(Display * dpy, unsigned int video_capture_slot, GLXVideoCaptureDeviceNV device) {
    PFN_GLXBINDVIDEOCAPTUREDEVICENV _ptr;
    _ptr = (PFN_GLXBINDVIDEOCAPTUREDEVICENV)_getPrivateProcAddress("glXBindVideoCaptureDeviceNV");
    if (!_ptr) {
        _ptr = &_fail_glXBindVideoCaptureDeviceNV;
    }
    _glXBindVideoCaptureDeviceNV = _ptr;
    return _glXBindVideoCaptureDeviceNV(dpy, video_capture_slot, device);
}

PFN_GLXBINDVIDEOCAPTUREDEVICENV _glXBindVideoCaptureDeviceNV = &_get_glXBindVideoCaptureDeviceNV;

static GLXVideoCaptureDeviceNV * _fail_glXEnumerateVideoCaptureDevicesNV(Display * dpy, int screen, int * nelements) {
    const char *_name = "glXEnumerateVideoCaptureDevicesNV";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static GLXVideoCaptureDeviceNV * _get_glXEnumerateVideoCaptureDevicesNV(Display * dpy, int screen, int * nelements) {
    PFN_GLXENUMERATEVIDEOCAPTUREDEVICESNV _ptr;
    _ptr = (PFN_GLXENUMERATEVIDEOCAPTUREDEVICESNV)_getPrivateProcAddress("glXEnumerateVideoCaptureDevicesNV");
    if (!_ptr) {
        _ptr = &_fail_glXEnumerateVideoCaptureDevicesNV;
    }
    _glXEnumerateVideoCaptureDevicesNV = _ptr;
    return _glXEnumerateVideoCaptureDevicesNV(dpy, screen, nelements);
}

PFN_GLXENUMERATEVIDEOCAPTUREDEVICESNV _glXEnumerateVideoCaptureDevicesNV = &_get_glXEnumerateVideoCaptureDevicesNV;

static void _fail_glXLockVideoCaptureDeviceNV(Display * dpy, GLXVideoCaptureDeviceNV device) {
    const char *_name = "glXLockVideoCaptureDeviceNV";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void _get_glXLockVideoCaptureDeviceNV(Display * dpy, GLXVideoCaptureDeviceNV device) {
    PFN_GLXLOCKVIDEOCAPTUREDEVICENV _ptr;
    _ptr = (PFN_GLXLOCKVIDEOCAPTUREDEVICENV)_getPrivateProcAddress("glXLockVideoCaptureDeviceNV");
    if (!_ptr) {
        _ptr = &_fail_glXLockVideoCaptureDeviceNV;
    }
    _glXLockVideoCaptureDeviceNV = _ptr;
    _glXLockVideoCaptureDeviceNV(dpy, device);
}

PFN_GLXLOCKVIDEOCAPTUREDEVICENV _glXLockVideoCaptureDeviceNV = &_get_glXLockVideoCaptureDeviceNV;

static int _fail_glXQueryVideoCaptureDeviceNV(Display * dpy, GLXVideoCaptureDeviceNV device, int attribute, int * value) {
    const char *_name = "glXQueryVideoCaptureDeviceNV";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static int _get_glXQueryVideoCaptureDeviceNV(Display * dpy, GLXVideoCaptureDeviceNV device, int attribute, int * value) {
    PFN_GLXQUERYVIDEOCAPTUREDEVICENV _ptr;
    _ptr = (PFN_GLXQUERYVIDEOCAPTUREDEVICENV)_getPrivateProcAddress("glXQueryVideoCaptureDeviceNV");
    if (!_ptr) {
        _ptr = &_fail_glXQueryVideoCaptureDeviceNV;
    }
    _glXQueryVideoCaptureDeviceNV = _ptr;
    return _glXQueryVideoCaptureDeviceNV(dpy, device, attribute, value);
}

PFN_GLXQUERYVIDEOCAPTUREDEVICENV _glXQueryVideoCaptureDeviceNV = &_get_glXQueryVideoCaptureDeviceNV;

static void _fail_glXReleaseVideoCaptureDeviceNV(Display * dpy, GLXVideoCaptureDeviceNV device) {
    const char *_name = "glXReleaseVideoCaptureDeviceNV";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void _get_glXReleaseVideoCaptureDeviceNV(Display * dpy, GLXVideoCaptureDeviceNV device) {
    PFN_GLXRELEASEVIDEOCAPTUREDEVICENV _ptr;
    _ptr = (PFN_GLXRELEASEVIDEOCAPTUREDEVICENV)_getPrivateProcAddress("glXReleaseVideoCaptureDeviceNV");
    if (!_ptr) {
        _ptr = &_fail_glXReleaseVideoCaptureDeviceNV;
    }
    _glXReleaseVideoCaptureDeviceNV = _ptr;
    _glXReleaseVideoCaptureDeviceNV(dpy, device);
}

PFN_GLXRELEASEVIDEOCAPTUREDEVICENV _glXReleaseVideoCaptureDeviceNV = &_get_glXReleaseVideoCaptureDeviceNV;

static int _fail_glXGetVideoDeviceNV(Display * dpy, int screen, int numVideoDevices, GLXVideoDeviceNV * pVideoDevice) {
    const char *_name = "glXGetVideoDeviceNV";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static int _get_glXGetVideoDeviceNV(Display * dpy, int screen, int numVideoDevices, GLXVideoDeviceNV * pVideoDevice) {
    PFN_GLXGETVIDEODEVICENV _ptr;
    _ptr = (PFN_GLXGETVIDEODEVICENV)_getPrivateProcAddress("glXGetVideoDeviceNV");
    if (!_ptr) {
        _ptr = &_fail_glXGetVideoDeviceNV;
    }
    _glXGetVideoDeviceNV = _ptr;
    return _glXGetVideoDeviceNV(dpy, screen, numVideoDevices, pVideoDevice);
}

PFN_GLXGETVIDEODEVICENV _glXGetVideoDeviceNV = &_get_glXGetVideoDeviceNV;

static int _fail_glXReleaseVideoDeviceNV(Display * dpy, int screen, GLXVideoDeviceNV VideoDevice) {
    const char *_name = "glXReleaseVideoDeviceNV";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static int _get_glXReleaseVideoDeviceNV(Display * dpy, int screen, GLXVideoDeviceNV VideoDevice) {
    PFN_GLXRELEASEVIDEODEVICENV _ptr;
    _ptr = (PFN_GLXRELEASEVIDEODEVICENV)_getPrivateProcAddress("glXReleaseVideoDeviceNV");
    if (!_ptr) {
        _ptr = &_fail_glXReleaseVideoDeviceNV;
    }
    _glXReleaseVideoDeviceNV = _ptr;
    return _glXReleaseVideoDeviceNV(dpy, screen, VideoDevice);
}

PFN_GLXRELEASEVIDEODEVICENV _glXReleaseVideoDeviceNV = &_get_glXReleaseVideoDeviceNV;

static int _fail_glXBindVideoImageNV(Display * dpy, GLXVideoDeviceNV VideoDevice, GLXPbuffer pbuf, int iVideoBuffer) {
    const char *_name = "glXBindVideoImageNV";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static int _get_glXBindVideoImageNV(Display * dpy, GLXVideoDeviceNV VideoDevice, GLXPbuffer pbuf, int iVideoBuffer) {
    PFN_GLXBINDVIDEOIMAGENV _ptr;
    _ptr = (PFN_GLXBINDVIDEOIMAGENV)_getPrivateProcAddress("glXBindVideoImageNV");
    if (!_ptr) {
        _ptr = &_fail_glXBindVideoImageNV;
    }
    _glXBindVideoImageNV = _ptr;
    return _glXBindVideoImageNV(dpy, VideoDevice, pbuf, iVideoBuffer);
}

PFN_GLXBINDVIDEOIMAGENV _glXBindVideoImageNV = &_get_glXBindVideoImageNV;

static int _fail_glXReleaseVideoImageNV(Display * dpy, GLXPbuffer pbuf) {
    const char *_name = "glXReleaseVideoImageNV";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static int _get_glXReleaseVideoImageNV(Display * dpy, GLXPbuffer pbuf) {
    PFN_GLXRELEASEVIDEOIMAGENV _ptr;
    _ptr = (PFN_GLXRELEASEVIDEOIMAGENV)_getPrivateProcAddress("glXReleaseVideoImageNV");
    if (!_ptr) {
        _ptr = &_fail_glXReleaseVideoImageNV;
    }
    _glXReleaseVideoImageNV = _ptr;
    return _glXReleaseVideoImageNV(dpy, pbuf);
}

PFN_GLXRELEASEVIDEOIMAGENV _glXReleaseVideoImageNV = &_get_glXReleaseVideoImageNV;

static int _fail_glXSendPbufferToVideoNV(Display * dpy, GLXPbuffer pbuf, int iBufferType, unsigned long * pulCounterPbuffer, GLboolean bBlock) {
    const char *_name = "glXSendPbufferToVideoNV";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static int _get_glXSendPbufferToVideoNV(Display * dpy, GLXPbuffer pbuf, int iBufferType, unsigned long * pulCounterPbuffer, GLboolean bBlock) {
    PFN_GLXSENDPBUFFERTOVIDEONV _ptr;
    _ptr = (PFN_GLXSENDPBUFFERTOVIDEONV)_getPrivateProcAddress("glXSendPbufferToVideoNV");
    if (!_ptr) {
        _ptr = &_fail_glXSendPbufferToVideoNV;
    }
    _glXSendPbufferToVideoNV = _ptr;
    return _glXSendPbufferToVideoNV(dpy, pbuf, iBufferType, pulCounterPbuffer, bBlock);
}

PFN_GLXSENDPBUFFERTOVIDEONV _glXSendPbufferToVideoNV = &_get_glXSendPbufferToVideoNV;

static int _fail_glXGetVideoInfoNV(Display * dpy, int screen, GLXVideoDeviceNV VideoDevice, unsigned long * pulCounterOutputPbuffer, unsigned long * pulCounterOutputVideo) {
    const char *_name = "glXGetVideoInfoNV";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static int _get_glXGetVideoInfoNV(Display * dpy, int screen, GLXVideoDeviceNV VideoDevice, unsigned long * pulCounterOutputPbuffer, unsigned long * pulCounterOutputVideo) {
    PFN_GLXGETVIDEOINFONV _ptr;
    _ptr = (PFN_GLXGETVIDEOINFONV)_getPrivateProcAddress("glXGetVideoInfoNV");
    if (!_ptr) {
        _ptr = &_fail_glXGetVideoInfoNV;
    }
    _glXGetVideoInfoNV = _ptr;
    return _glXGetVideoInfoNV(dpy, screen, VideoDevice, pulCounterOutputPbuffer, pulCounterOutputVideo);
}

PFN_GLXGETVIDEOINFONV _glXGetVideoInfoNV = &_get_glXGetVideoInfoNV;

static int _fail_glXGetSyncValuesOML(Display * dpy, GLXDrawable drawable, int64_t * ust, int64_t * msc, int64_t * sbc) {
    const char *_name = "glXGetSyncValuesOML";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static int _get_glXGetSyncValuesOML(Display * dpy, GLXDrawable drawable, int64_t * ust, int64_t * msc, int64_t * sbc) {
    PFN_GLXGETSYNCVALUESOML _ptr;
    _ptr = (PFN_GLXGETSYNCVALUESOML)_getPrivateProcAddress("glXGetSyncValuesOML");
    if (!_ptr) {
        _ptr = &_fail_glXGetSyncValuesOML;
    }
    _glXGetSyncValuesOML = _ptr;
    return _glXGetSyncValuesOML(dpy, drawable, ust, msc, sbc);
}

PFN_GLXGETSYNCVALUESOML _glXGetSyncValuesOML = &_get_glXGetSyncValuesOML;

static int _fail_glXGetMscRateOML(Display * dpy, GLXDrawable drawable, int32_t * numerator, int32_t * denominator) {
    const char *_name = "glXGetMscRateOML";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static int _get_glXGetMscRateOML(Display * dpy, GLXDrawable drawable, int32_t * numerator, int32_t * denominator) {
    PFN_GLXGETMSCRATEOML _ptr;
    _ptr = (PFN_GLXGETMSCRATEOML)_getPrivateProcAddress("glXGetMscRateOML");
    if (!_ptr) {
        _ptr = &_fail_glXGetMscRateOML;
    }
    _glXGetMscRateOML = _ptr;
    return _glXGetMscRateOML(dpy, drawable, numerator, denominator);
}

PFN_GLXGETMSCRATEOML _glXGetMscRateOML = &_get_glXGetMscRateOML;

static int64_t _fail_glXSwapBuffersMscOML(Display * dpy, GLXDrawable drawable, int64_t target_msc, int64_t divisor, int64_t remainder) {
    const char *_name = "glXSwapBuffersMscOML";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static int64_t _get_glXSwapBuffersMscOML(Display * dpy, GLXDrawable drawable, int64_t target_msc, int64_t divisor, int64_t remainder) {
    PFN_GLXSWAPBUFFERSMSCOML _ptr;
    _ptr = (PFN_GLXSWAPBUFFERSMSCOML)_getPrivateProcAddress("glXSwapBuffersMscOML");
    if (!_ptr) {
        _ptr = &_fail_glXSwapBuffersMscOML;
    }
    _glXSwapBuffersMscOML = _ptr;
    return _glXSwapBuffersMscOML(dpy, drawable, target_msc, divisor, remainder);
}

PFN_GLXSWAPBUFFERSMSCOML _glXSwapBuffersMscOML = &_get_glXSwapBuffersMscOML;

static int _fail_glXWaitForMscOML(Display * dpy, GLXDrawable drawable, int64_t target_msc, int64_t divisor, int64_t remainder, int64_t * ust, int64_t * msc, int64_t * sbc) {
    const char *_name = "glXWaitForMscOML";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static int _get_glXWaitForMscOML(Display * dpy, GLXDrawable drawable, int64_t target_msc, int64_t divisor, int64_t remainder, int64_t * ust, int64_t * msc, int64_t * sbc) {
    PFN_GLXWAITFORMSCOML _ptr;
    _ptr = (PFN_GLXWAITFORMSCOML)_getPrivateProcAddress("glXWaitForMscOML");
    if (!_ptr) {
        _ptr = &_fail_glXWaitForMscOML;
    }
    _glXWaitForMscOML = _ptr;
    return _glXWaitForMscOML(dpy, drawable, target_msc, divisor, remainder, ust, msc, sbc);
}

PFN_GLXWAITFORMSCOML _glXWaitForMscOML = &_get_glXWaitForMscOML;

static int _fail_glXWaitForSbcOML(Display * dpy, GLXDrawable drawable, int64_t target_sbc, int64_t * ust, int64_t * msc, int64_t * sbc) {
    const char *_name = "glXWaitForSbcOML";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static int _get_glXWaitForSbcOML(Display * dpy, GLXDrawable drawable, int64_t target_sbc, int64_t * ust, int64_t * msc, int64_t * sbc) {
    PFN_GLXWAITFORSBCOML _ptr;
    _ptr = (PFN_GLXWAITFORSBCOML)_getPrivateProcAddress("glXWaitForSbcOML");
    if (!_ptr) {
        _ptr = &_fail_glXWaitForSbcOML;
    }
    _glXWaitForSbcOML = _ptr;
    return _glXWaitForSbcOML(dpy, drawable, target_sbc, ust, msc, sbc);
}

PFN_GLXWAITFORSBCOML _glXWaitForSbcOML = &_get_glXWaitForSbcOML;

static void _fail_glXCushionSGI(Display * dpy, Window window, float cushion) {
    const char *_name = "glXCushionSGI";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void _get_glXCushionSGI(Display * dpy, Window window, float cushion) {
    PFN_GLXCUSHIONSGI _ptr;
    _ptr = (PFN_GLXCUSHIONSGI)_getPrivateProcAddress("glXCushionSGI");
    if (!_ptr) {
        _ptr = &_fail_glXCushionSGI;
    }
    _glXCushionSGI = _ptr;
    _glXCushionSGI(dpy, window, cushion);
}

PFN_GLXCUSHIONSGI _glXCushionSGI = &_get_glXCushionSGI;

static int _fail_glXMakeCurrentReadSGI(Display * dpy, GLXDrawable draw, GLXDrawable read, GLXContext ctx) {
    const char *_name = "glXMakeCurrentReadSGI";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static int _get_glXMakeCurrentReadSGI(Display * dpy, GLXDrawable draw, GLXDrawable read, GLXContext ctx) {
    PFN_GLXMAKECURRENTREADSGI _ptr;
    _ptr = (PFN_GLXMAKECURRENTREADSGI)_getPrivateProcAddress("glXMakeCurrentReadSGI");
    if (!_ptr) {
        _ptr = &_fail_glXMakeCurrentReadSGI;
    }
    _glXMakeCurrentReadSGI = _ptr;
    return _glXMakeCurrentReadSGI(dpy, draw, read, ctx);
}

PFN_GLXMAKECURRENTREADSGI _glXMakeCurrentReadSGI = &_get_glXMakeCurrentReadSGI;

static GLXDrawable _fail_glXGetCurrentReadDrawableSGI(void) {
    const char *_name = "glXGetCurrentReadDrawableSGI";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static GLXDrawable _get_glXGetCurrentReadDrawableSGI(void) {
    PFN_GLXGETCURRENTREADDRAWABLESGI _ptr;
    _ptr = (PFN_GLXGETCURRENTREADDRAWABLESGI)_getPrivateProcAddress("glXGetCurrentReadDrawableSGI");
    if (!_ptr) {
        _ptr = &_fail_glXGetCurrentReadDrawableSGI;
    }
    _glXGetCurrentReadDrawableSGI = _ptr;
    return _glXGetCurrentReadDrawableSGI();
}

PFN_GLXGETCURRENTREADDRAWABLESGI _glXGetCurrentReadDrawableSGI = &_get_glXGetCurrentReadDrawableSGI;

static int _fail_glXSwapIntervalSGI(int interval) {
    const char *_name = "glXSwapIntervalSGI";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static int _get_glXSwapIntervalSGI(int interval) {
    PFN_GLXSWAPINTERVALSGI _ptr;
    _ptr = (PFN_GLXSWAPINTERVALSGI)_getPrivateProcAddress("glXSwapIntervalSGI");
    if (!_ptr) {
        _ptr = &_fail_glXSwapIntervalSGI;
    }
    _glXSwapIntervalSGI = _ptr;
    return _glXSwapIntervalSGI(interval);
}

PFN_GLXSWAPINTERVALSGI _glXSwapIntervalSGI = &_get_glXSwapIntervalSGI;

static int _fail_glXGetVideoSyncSGI(unsigned int * count) {
    const char *_name = "glXGetVideoSyncSGI";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static int _get_glXGetVideoSyncSGI(unsigned int * count) {
    PFN_GLXGETVIDEOSYNCSGI _ptr;
    _ptr = (PFN_GLXGETVIDEOSYNCSGI)_getPrivateProcAddress("glXGetVideoSyncSGI");
    if (!_ptr) {
        _ptr = &_fail_glXGetVideoSyncSGI;
    }
    _glXGetVideoSyncSGI = _ptr;
    return _glXGetVideoSyncSGI(count);
}

PFN_GLXGETVIDEOSYNCSGI _glXGetVideoSyncSGI = &_get_glXGetVideoSyncSGI;

static int _fail_glXWaitVideoSyncSGI(int divisor, int remainder, unsigned int * count) {
    const char *_name = "glXWaitVideoSyncSGI";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static int _get_glXWaitVideoSyncSGI(int divisor, int remainder, unsigned int * count) {
    PFN_GLXWAITVIDEOSYNCSGI _ptr;
    _ptr = (PFN_GLXWAITVIDEOSYNCSGI)_getPrivateProcAddress("glXWaitVideoSyncSGI");
    if (!_ptr) {
        _ptr = &_fail_glXWaitVideoSyncSGI;
    }
    _glXWaitVideoSyncSGI = _ptr;
    return _glXWaitVideoSyncSGI(divisor, remainder, count);
}

PFN_GLXWAITVIDEOSYNCSGI _glXWaitVideoSyncSGI = &_get_glXWaitVideoSyncSGI;

static int _fail_glXGetFBConfigAttribSGIX(Display * dpy, GLXFBConfigSGIX config, int attribute, int * value) {
    const char *_name = "glXGetFBConfigAttribSGIX";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static int _get_glXGetFBConfigAttribSGIX(Display * dpy, GLXFBConfigSGIX config, int attribute, int * value) {
    PFN_GLXGETFBCONFIGATTRIBSGIX _ptr;
    _ptr = (PFN_GLXGETFBCONFIGATTRIBSGIX)_getPrivateProcAddress("glXGetFBConfigAttribSGIX");
    if (!_ptr) {
        _ptr = &_fail_glXGetFBConfigAttribSGIX;
    }
    _glXGetFBConfigAttribSGIX = _ptr;
    return _glXGetFBConfigAttribSGIX(dpy, config, attribute, value);
}

PFN_GLXGETFBCONFIGATTRIBSGIX _glXGetFBConfigAttribSGIX = &_get_glXGetFBConfigAttribSGIX;

static GLXFBConfigSGIX * _fail_glXChooseFBConfigSGIX(Display * dpy, int screen, int * attrib_list, int * nelements) {
    const char *_name = "glXChooseFBConfigSGIX";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static GLXFBConfigSGIX * _get_glXChooseFBConfigSGIX(Display * dpy, int screen, int * attrib_list, int * nelements) {
    PFN_GLXCHOOSEFBCONFIGSGIX _ptr;
    _ptr = (PFN_GLXCHOOSEFBCONFIGSGIX)_getPrivateProcAddress("glXChooseFBConfigSGIX");
    if (!_ptr) {
        _ptr = &_fail_glXChooseFBConfigSGIX;
    }
    _glXChooseFBConfigSGIX = _ptr;
    return _glXChooseFBConfigSGIX(dpy, screen, attrib_list, nelements);
}

PFN_GLXCHOOSEFBCONFIGSGIX _glXChooseFBConfigSGIX = &_get_glXChooseFBConfigSGIX;

static GLXPixmap _fail_glXCreateGLXPixmapWithConfigSGIX(Display * dpy, GLXFBConfigSGIX config, Pixmap pixmap) {
    const char *_name = "glXCreateGLXPixmapWithConfigSGIX";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static GLXPixmap _get_glXCreateGLXPixmapWithConfigSGIX(Display * dpy, GLXFBConfigSGIX config, Pixmap pixmap) {
    PFN_GLXCREATEGLXPIXMAPWITHCONFIGSGIX _ptr;
    _ptr = (PFN_GLXCREATEGLXPIXMAPWITHCONFIGSGIX)_getPrivateProcAddress("glXCreateGLXPixmapWithConfigSGIX");
    if (!_ptr) {
        _ptr = &_fail_glXCreateGLXPixmapWithConfigSGIX;
    }
    _glXCreateGLXPixmapWithConfigSGIX = _ptr;
    return _glXCreateGLXPixmapWithConfigSGIX(dpy, config, pixmap);
}

PFN_GLXCREATEGLXPIXMAPWITHCONFIGSGIX _glXCreateGLXPixmapWithConfigSGIX = &_get_glXCreateGLXPixmapWithConfigSGIX;

static GLXContext _fail_glXCreateContextWithConfigSGIX(Display * dpy, GLXFBConfigSGIX config, int render_type, GLXContext share_list, int direct) {
    const char *_name = "glXCreateContextWithConfigSGIX";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static GLXContext _get_glXCreateContextWithConfigSGIX(Display * dpy, GLXFBConfigSGIX config, int render_type, GLXContext share_list, int direct) {
    PFN_GLXCREATECONTEXTWITHCONFIGSGIX _ptr;
    _ptr = (PFN_GLXCREATECONTEXTWITHCONFIGSGIX)_getPrivateProcAddress("glXCreateContextWithConfigSGIX");
    if (!_ptr) {
        _ptr = &_fail_glXCreateContextWithConfigSGIX;
    }
    _glXCreateContextWithConfigSGIX = _ptr;
    return _glXCreateContextWithConfigSGIX(dpy, config, render_type, share_list, direct);
}

PFN_GLXCREATECONTEXTWITHCONFIGSGIX _glXCreateContextWithConfigSGIX = &_get_glXCreateContextWithConfigSGIX;

static XVisualInfo * _fail_glXGetVisualFromFBConfigSGIX(Display * dpy, GLXFBConfigSGIX config) {
    const char *_name = "glXGetVisualFromFBConfigSGIX";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static XVisualInfo * _get_glXGetVisualFromFBConfigSGIX(Display * dpy, GLXFBConfigSGIX config) {
    PFN_GLXGETVISUALFROMFBCONFIGSGIX _ptr;
    _ptr = (PFN_GLXGETVISUALFROMFBCONFIGSGIX)_getPrivateProcAddress("glXGetVisualFromFBConfigSGIX");
    if (!_ptr) {
        _ptr = &_fail_glXGetVisualFromFBConfigSGIX;
    }
    _glXGetVisualFromFBConfigSGIX = _ptr;
    return _glXGetVisualFromFBConfigSGIX(dpy, config);
}

PFN_GLXGETVISUALFROMFBCONFIGSGIX _glXGetVisualFromFBConfigSGIX = &_get_glXGetVisualFromFBConfigSGIX;

static GLXFBConfigSGIX _fail_glXGetFBConfigFromVisualSGIX(Display * dpy, XVisualInfo * vis) {
    const char *_name = "glXGetFBConfigFromVisualSGIX";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static GLXFBConfigSGIX _get_glXGetFBConfigFromVisualSGIX(Display * dpy, XVisualInfo * vis) {
    PFN_GLXGETFBCONFIGFROMVISUALSGIX _ptr;
    _ptr = (PFN_GLXGETFBCONFIGFROMVISUALSGIX)_getPrivateProcAddress("glXGetFBConfigFromVisualSGIX");
    if (!_ptr) {
        _ptr = &_fail_glXGetFBConfigFromVisualSGIX;
    }
    _glXGetFBConfigFromVisualSGIX = _ptr;
    return _glXGetFBConfigFromVisualSGIX(dpy, vis);
}

PFN_GLXGETFBCONFIGFROMVISUALSGIX _glXGetFBConfigFromVisualSGIX = &_get_glXGetFBConfigFromVisualSGIX;

static GLXPbufferSGIX _fail_glXCreateGLXPbufferSGIX(Display * dpy, GLXFBConfigSGIX config, unsigned int width, unsigned int height, int * attrib_list) {
    const char *_name = "glXCreateGLXPbufferSGIX";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static GLXPbufferSGIX _get_glXCreateGLXPbufferSGIX(Display * dpy, GLXFBConfigSGIX config, unsigned int width, unsigned int height, int * attrib_list) {
    PFN_GLXCREATEGLXPBUFFERSGIX _ptr;
    _ptr = (PFN_GLXCREATEGLXPBUFFERSGIX)_getPrivateProcAddress("glXCreateGLXPbufferSGIX");
    if (!_ptr) {
        _ptr = &_fail_glXCreateGLXPbufferSGIX;
    }
    _glXCreateGLXPbufferSGIX = _ptr;
    return _glXCreateGLXPbufferSGIX(dpy, config, width, height, attrib_list);
}

PFN_GLXCREATEGLXPBUFFERSGIX _glXCreateGLXPbufferSGIX = &_get_glXCreateGLXPbufferSGIX;

static void _fail_glXDestroyGLXPbufferSGIX(Display * dpy, GLXPbufferSGIX pbuf) {
    const char *_name = "glXDestroyGLXPbufferSGIX";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void _get_glXDestroyGLXPbufferSGIX(Display * dpy, GLXPbufferSGIX pbuf) {
    PFN_GLXDESTROYGLXPBUFFERSGIX _ptr;
    _ptr = (PFN_GLXDESTROYGLXPBUFFERSGIX)_getPrivateProcAddress("glXDestroyGLXPbufferSGIX");
    if (!_ptr) {
        _ptr = &_fail_glXDestroyGLXPbufferSGIX;
    }
    _glXDestroyGLXPbufferSGIX = _ptr;
    _glXDestroyGLXPbufferSGIX(dpy, pbuf);
}

PFN_GLXDESTROYGLXPBUFFERSGIX _glXDestroyGLXPbufferSGIX = &_get_glXDestroyGLXPbufferSGIX;

static void _fail_glXQueryGLXPbufferSGIX(Display * dpy, GLXPbufferSGIX pbuf, int attribute, unsigned int * value) {
    const char *_name = "glXQueryGLXPbufferSGIX";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void _get_glXQueryGLXPbufferSGIX(Display * dpy, GLXPbufferSGIX pbuf, int attribute, unsigned int * value) {
    PFN_GLXQUERYGLXPBUFFERSGIX _ptr;
    _ptr = (PFN_GLXQUERYGLXPBUFFERSGIX)_getPrivateProcAddress("glXQueryGLXPbufferSGIX");
    if (!_ptr) {
        _ptr = &_fail_glXQueryGLXPbufferSGIX;
    }
    _glXQueryGLXPbufferSGIX = _ptr;
    _glXQueryGLXPbufferSGIX(dpy, pbuf, attribute, value);
}

PFN_GLXQUERYGLXPBUFFERSGIX _glXQueryGLXPbufferSGIX = &_get_glXQueryGLXPbufferSGIX;

static void _fail_glXSelectEventSGIX(Display * dpy, GLXDrawable drawable, unsigned long mask) {
    const char *_name = "glXSelectEventSGIX";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void _get_glXSelectEventSGIX(Display * dpy, GLXDrawable drawable, unsigned long mask) {
    PFN_GLXSELECTEVENTSGIX _ptr;
    _ptr = (PFN_GLXSELECTEVENTSGIX)_getPrivateProcAddress("glXSelectEventSGIX");
    if (!_ptr) {
        _ptr = &_fail_glXSelectEventSGIX;
    }
    _glXSelectEventSGIX = _ptr;
    _glXSelectEventSGIX(dpy, drawable, mask);
}

PFN_GLXSELECTEVENTSGIX _glXSelectEventSGIX = &_get_glXSelectEventSGIX;

static void _fail_glXGetSelectedEventSGIX(Display * dpy, GLXDrawable drawable, unsigned long * mask) {
    const char *_name = "glXGetSelectedEventSGIX";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void _get_glXGetSelectedEventSGIX(Display * dpy, GLXDrawable drawable, unsigned long * mask) {
    PFN_GLXGETSELECTEDEVENTSGIX _ptr;
    _ptr = (PFN_GLXGETSELECTEDEVENTSGIX)_getPrivateProcAddress("glXGetSelectedEventSGIX");
    if (!_ptr) {
        _ptr = &_fail_glXGetSelectedEventSGIX;
    }
    _glXGetSelectedEventSGIX = _ptr;
    _glXGetSelectedEventSGIX(dpy, drawable, mask);
}

PFN_GLXGETSELECTEDEVENTSGIX _glXGetSelectedEventSGIX = &_get_glXGetSelectedEventSGIX;

static void _fail_glXBindSwapBarrierSGIX(Display * dpy, GLXDrawable drawable, int barrier) {
    const char *_name = "glXBindSwapBarrierSGIX";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void _get_glXBindSwapBarrierSGIX(Display * dpy, GLXDrawable drawable, int barrier) {
    PFN_GLXBINDSWAPBARRIERSGIX _ptr;
    _ptr = (PFN_GLXBINDSWAPBARRIERSGIX)_getPrivateProcAddress("glXBindSwapBarrierSGIX");
    if (!_ptr) {
        _ptr = &_fail_glXBindSwapBarrierSGIX;
    }
    _glXBindSwapBarrierSGIX = _ptr;
    _glXBindSwapBarrierSGIX(dpy, drawable, barrier);
}

PFN_GLXBINDSWAPBARRIERSGIX _glXBindSwapBarrierSGIX = &_get_glXBindSwapBarrierSGIX;

static int _fail_glXQueryMaxSwapBarriersSGIX(Display * dpy, int screen, int * max) {
    const char *_name = "glXQueryMaxSwapBarriersSGIX";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static int _get_glXQueryMaxSwapBarriersSGIX(Display * dpy, int screen, int * max) {
    PFN_GLXQUERYMAXSWAPBARRIERSSGIX _ptr;
    _ptr = (PFN_GLXQUERYMAXSWAPBARRIERSSGIX)_getPrivateProcAddress("glXQueryMaxSwapBarriersSGIX");
    if (!_ptr) {
        _ptr = &_fail_glXQueryMaxSwapBarriersSGIX;
    }
    _glXQueryMaxSwapBarriersSGIX = _ptr;
    return _glXQueryMaxSwapBarriersSGIX(dpy, screen, max);
}

PFN_GLXQUERYMAXSWAPBARRIERSSGIX _glXQueryMaxSwapBarriersSGIX = &_get_glXQueryMaxSwapBarriersSGIX;

static void _fail_glXJoinSwapGroupSGIX(Display * dpy, GLXDrawable drawable, GLXDrawable member) {
    const char *_name = "glXJoinSwapGroupSGIX";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void _get_glXJoinSwapGroupSGIX(Display * dpy, GLXDrawable drawable, GLXDrawable member) {
    PFN_GLXJOINSWAPGROUPSGIX _ptr;
    _ptr = (PFN_GLXJOINSWAPGROUPSGIX)_getPrivateProcAddress("glXJoinSwapGroupSGIX");
    if (!_ptr) {
        _ptr = &_fail_glXJoinSwapGroupSGIX;
    }
    _glXJoinSwapGroupSGIX = _ptr;
    _glXJoinSwapGroupSGIX(dpy, drawable, member);
}

PFN_GLXJOINSWAPGROUPSGIX _glXJoinSwapGroupSGIX = &_get_glXJoinSwapGroupSGIX;

static int _fail_glXBindChannelToWindowSGIX(Display * display, int screen, int channel, Window window) {
    const char *_name = "glXBindChannelToWindowSGIX";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static int _get_glXBindChannelToWindowSGIX(Display * display, int screen, int channel, Window window) {
    PFN_GLXBINDCHANNELTOWINDOWSGIX _ptr;
    _ptr = (PFN_GLXBINDCHANNELTOWINDOWSGIX)_getPrivateProcAddress("glXBindChannelToWindowSGIX");
    if (!_ptr) {
        _ptr = &_fail_glXBindChannelToWindowSGIX;
    }
    _glXBindChannelToWindowSGIX = _ptr;
    return _glXBindChannelToWindowSGIX(display, screen, channel, window);
}

PFN_GLXBINDCHANNELTOWINDOWSGIX _glXBindChannelToWindowSGIX = &_get_glXBindChannelToWindowSGIX;

static int _fail_glXChannelRectSGIX(Display * display, int screen, int channel, int x, int y, int w, int h) {
    const char *_name = "glXChannelRectSGIX";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static int _get_glXChannelRectSGIX(Display * display, int screen, int channel, int x, int y, int w, int h) {
    PFN_GLXCHANNELRECTSGIX _ptr;
    _ptr = (PFN_GLXCHANNELRECTSGIX)_getPrivateProcAddress("glXChannelRectSGIX");
    if (!_ptr) {
        _ptr = &_fail_glXChannelRectSGIX;
    }
    _glXChannelRectSGIX = _ptr;
    return _glXChannelRectSGIX(display, screen, channel, x, y, w, h);
}

PFN_GLXCHANNELRECTSGIX _glXChannelRectSGIX = &_get_glXChannelRectSGIX;

static int _fail_glXQueryChannelRectSGIX(Display * display, int screen, int channel, int * dx, int * dy, int * dw, int * dh) {
    const char *_name = "glXQueryChannelRectSGIX";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static int _get_glXQueryChannelRectSGIX(Display * display, int screen, int channel, int * dx, int * dy, int * dw, int * dh) {
    PFN_GLXQUERYCHANNELRECTSGIX _ptr;
    _ptr = (PFN_GLXQUERYCHANNELRECTSGIX)_getPrivateProcAddress("glXQueryChannelRectSGIX");
    if (!_ptr) {
        _ptr = &_fail_glXQueryChannelRectSGIX;
    }
    _glXQueryChannelRectSGIX = _ptr;
    return _glXQueryChannelRectSGIX(display, screen, channel, dx, dy, dw, dh);
}

PFN_GLXQUERYCHANNELRECTSGIX _glXQueryChannelRectSGIX = &_get_glXQueryChannelRectSGIX;

static int _fail_glXQueryChannelDeltasSGIX(Display * display, int screen, int channel, int * x, int * y, int * w, int * h) {
    const char *_name = "glXQueryChannelDeltasSGIX";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static int _get_glXQueryChannelDeltasSGIX(Display * display, int screen, int channel, int * x, int * y, int * w, int * h) {
    PFN_GLXQUERYCHANNELDELTASSGIX _ptr;
    _ptr = (PFN_GLXQUERYCHANNELDELTASSGIX)_getPrivateProcAddress("glXQueryChannelDeltasSGIX");
    if (!_ptr) {
        _ptr = &_fail_glXQueryChannelDeltasSGIX;
    }
    _glXQueryChannelDeltasSGIX = _ptr;
    return _glXQueryChannelDeltasSGIX(display, screen, channel, x, y, w, h);
}

PFN_GLXQUERYCHANNELDELTASSGIX _glXQueryChannelDeltasSGIX = &_get_glXQueryChannelDeltasSGIX;

static int _fail_glXChannelRectSyncSGIX(Display * display, int screen, int channel, GLenum synctype) {
    const char *_name = "glXChannelRectSyncSGIX";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static int _get_glXChannelRectSyncSGIX(Display * display, int screen, int channel, GLenum synctype) {
    PFN_GLXCHANNELRECTSYNCSGIX _ptr;
    _ptr = (PFN_GLXCHANNELRECTSYNCSGIX)_getPrivateProcAddress("glXChannelRectSyncSGIX");
    if (!_ptr) {
        _ptr = &_fail_glXChannelRectSyncSGIX;
    }
    _glXChannelRectSyncSGIX = _ptr;
    return _glXChannelRectSyncSGIX(display, screen, channel, synctype);
}

PFN_GLXCHANNELRECTSYNCSGIX _glXChannelRectSyncSGIX = &_get_glXChannelRectSyncSGIX;

static __GLXextFuncPtr _fail_glXGetProcAddressARB(const GLubyte * procName) {
    const char *_name = "glXGetProcAddressARB";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static __GLXextFuncPtr _get_glXGetProcAddressARB(const GLubyte * procName) {
    PFN_GLXGETPROCADDRESSARB _ptr;
    _ptr = (PFN_GLXGETPROCADDRESSARB)_getPublicProcAddress("glXGetProcAddressARB");
    if (!_ptr) {
        _ptr = &_fail_glXGetProcAddressARB;
    }
    _glXGetProcAddressARB = _ptr;
    return _glXGetProcAddressARB(procName);
}

PFN_GLXGETPROCADDRESSARB _glXGetProcAddressARB = &_get_glXGetProcAddressARB;

static __GLXextFuncPtr _fail_glXGetProcAddress(const GLubyte * procName) {
    const char *_name = "glXGetProcAddress";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static __GLXextFuncPtr _get_glXGetProcAddress(const GLubyte * procName) {
    PFN_GLXGETPROCADDRESS _ptr;
    _ptr = (PFN_GLXGETPROCADDRESS)_getPublicProcAddress("glXGetProcAddress");
    if (!_ptr) {
        _ptr = &_fail_glXGetProcAddress;
    }
    _glXGetProcAddress = _ptr;
    return _glXGetProcAddress(procName);
}

PFN_GLXGETPROCADDRESS _glXGetProcAddress = &_get_glXGetProcAddress;


#endif

static void APIENTRY _fail_glCullFace(GLenum mode) {
    const char *_name = "glCullFace";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glCullFace(GLenum mode) {
    PFN_GLCULLFACE _ptr;
    _ptr = (PFN_GLCULLFACE)_getPublicProcAddress("glCullFace");
    if (!_ptr) {
        _ptr = &_fail_glCullFace;
    }
    _glCullFace = _ptr;
    _glCullFace(mode);
}

PFN_GLCULLFACE _glCullFace = &_get_glCullFace;

static void APIENTRY _fail_glFrontFace(GLenum mode) {
    const char *_name = "glFrontFace";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glFrontFace(GLenum mode) {
    PFN_GLFRONTFACE _ptr;
    _ptr = (PFN_GLFRONTFACE)_getPublicProcAddress("glFrontFace");
    if (!_ptr) {
        _ptr = &_fail_glFrontFace;
    }
    _glFrontFace = _ptr;
    _glFrontFace(mode);
}

PFN_GLFRONTFACE _glFrontFace = &_get_glFrontFace;

static void APIENTRY _fail_glHint(GLenum target, GLenum mode) {
    const char *_name = "glHint";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glHint(GLenum target, GLenum mode) {
    PFN_GLHINT _ptr;
    _ptr = (PFN_GLHINT)_getPublicProcAddress("glHint");
    if (!_ptr) {
        _ptr = &_fail_glHint;
    }
    _glHint = _ptr;
    _glHint(target, mode);
}

PFN_GLHINT _glHint = &_get_glHint;

static void APIENTRY _fail_glLineWidth(GLfloat width) {
    const char *_name = "glLineWidth";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glLineWidth(GLfloat width) {
    PFN_GLLINEWIDTH _ptr;
    _ptr = (PFN_GLLINEWIDTH)_getPublicProcAddress("glLineWidth");
    if (!_ptr) {
        _ptr = &_fail_glLineWidth;
    }
    _glLineWidth = _ptr;
    _glLineWidth(width);
}

PFN_GLLINEWIDTH _glLineWidth = &_get_glLineWidth;

static void APIENTRY _fail_glPointSize(GLfloat size) {
    const char *_name = "glPointSize";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glPointSize(GLfloat size) {
    PFN_GLPOINTSIZE _ptr;
    _ptr = (PFN_GLPOINTSIZE)_getPublicProcAddress("glPointSize");
    if (!_ptr) {
        _ptr = &_fail_glPointSize;
    }
    _glPointSize = _ptr;
    _glPointSize(size);
}

PFN_GLPOINTSIZE _glPointSize = &_get_glPointSize;

static void APIENTRY _fail_glPolygonMode(GLenum face, GLenum mode) {
    const char *_name = "glPolygonMode";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glPolygonMode(GLenum face, GLenum mode) {
    PFN_GLPOLYGONMODE _ptr;
    _ptr = (PFN_GLPOLYGONMODE)_getPublicProcAddress("glPolygonMode");
    if (!_ptr) {
        _ptr = &_fail_glPolygonMode;
    }
    _glPolygonMode = _ptr;
    _glPolygonMode(face, mode);
}

PFN_GLPOLYGONMODE _glPolygonMode = &_get_glPolygonMode;

static void APIENTRY _fail_glScissor(GLint x, GLint y, GLsizei width, GLsizei height) {
    const char *_name = "glScissor";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glScissor(GLint x, GLint y, GLsizei width, GLsizei height) {
    PFN_GLSCISSOR _ptr;
    _ptr = (PFN_GLSCISSOR)_getPublicProcAddress("glScissor");
    if (!_ptr) {
        _ptr = &_fail_glScissor;
    }
    _glScissor = _ptr;
    _glScissor(x, y, width, height);
}

PFN_GLSCISSOR _glScissor = &_get_glScissor;

static void APIENTRY _fail_glTexParameterf(GLenum target, GLenum pname, GLfloat param) {
    const char *_name = "glTexParameterf";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glTexParameterf(GLenum target, GLenum pname, GLfloat param) {
    PFN_GLTEXPARAMETERF _ptr;
    _ptr = (PFN_GLTEXPARAMETERF)_getPublicProcAddress("glTexParameterf");
    if (!_ptr) {
        _ptr = &_fail_glTexParameterf;
    }
    _glTexParameterf = _ptr;
    _glTexParameterf(target, pname, param);
}

PFN_GLTEXPARAMETERF _glTexParameterf = &_get_glTexParameterf;

static void APIENTRY _fail_glTexParameterfv(GLenum target, GLenum pname, const GLfloat * params) {
    const char *_name = "glTexParameterfv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glTexParameterfv(GLenum target, GLenum pname, const GLfloat * params) {
    PFN_GLTEXPARAMETERFV _ptr;
    _ptr = (PFN_GLTEXPARAMETERFV)_getPublicProcAddress("glTexParameterfv");
    if (!_ptr) {
        _ptr = &_fail_glTexParameterfv;
    }
    _glTexParameterfv = _ptr;
    _glTexParameterfv(target, pname, params);
}

PFN_GLTEXPARAMETERFV _glTexParameterfv = &_get_glTexParameterfv;

static void APIENTRY _fail_glTexParameteri(GLenum target, GLenum pname, GLint param) {
    const char *_name = "glTexParameteri";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glTexParameteri(GLenum target, GLenum pname, GLint param) {
    PFN_GLTEXPARAMETERI _ptr;
    _ptr = (PFN_GLTEXPARAMETERI)_getPublicProcAddress("glTexParameteri");
    if (!_ptr) {
        _ptr = &_fail_glTexParameteri;
    }
    _glTexParameteri = _ptr;
    _glTexParameteri(target, pname, param);
}

PFN_GLTEXPARAMETERI _glTexParameteri = &_get_glTexParameteri;

static void APIENTRY _fail_glTexParameteriv(GLenum target, GLenum pname, const GLint * params) {
    const char *_name = "glTexParameteriv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glTexParameteriv(GLenum target, GLenum pname, const GLint * params) {
    PFN_GLTEXPARAMETERIV _ptr;
    _ptr = (PFN_GLTEXPARAMETERIV)_getPublicProcAddress("glTexParameteriv");
    if (!_ptr) {
        _ptr = &_fail_glTexParameteriv;
    }
    _glTexParameteriv = _ptr;
    _glTexParameteriv(target, pname, params);
}

PFN_GLTEXPARAMETERIV _glTexParameteriv = &_get_glTexParameteriv;

static void APIENTRY _fail_glTexImage1D(GLenum target, GLint level, GLint internalformat, GLsizei width, GLint border, GLenum format, GLenum type, const GLvoid * pixels) {
    const char *_name = "glTexImage1D";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glTexImage1D(GLenum target, GLint level, GLint internalformat, GLsizei width, GLint border, GLenum format, GLenum type, const GLvoid * pixels) {
    PFN_GLTEXIMAGE1D _ptr;
    _ptr = (PFN_GLTEXIMAGE1D)_getPublicProcAddress("glTexImage1D");
    if (!_ptr) {
        _ptr = &_fail_glTexImage1D;
    }
    _glTexImage1D = _ptr;
    _glTexImage1D(target, level, internalformat, width, border, format, type, pixels);
}

PFN_GLTEXIMAGE1D _glTexImage1D = &_get_glTexImage1D;

static void APIENTRY _fail_glTexImage2D(GLenum target, GLint level, GLint internalformat, GLsizei width, GLsizei height, GLint border, GLenum format, GLenum type, const GLvoid * pixels) {
    const char *_name = "glTexImage2D";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glTexImage2D(GLenum target, GLint level, GLint internalformat, GLsizei width, GLsizei height, GLint border, GLenum format, GLenum type, const GLvoid * pixels) {
    PFN_GLTEXIMAGE2D _ptr;
    _ptr = (PFN_GLTEXIMAGE2D)_getPublicProcAddress("glTexImage2D");
    if (!_ptr) {
        _ptr = &_fail_glTexImage2D;
    }
    _glTexImage2D = _ptr;
    _glTexImage2D(target, level, internalformat, width, height, border, format, type, pixels);
}

PFN_GLTEXIMAGE2D _glTexImage2D = &_get_glTexImage2D;

static void APIENTRY _fail_glDrawBuffer(GLenum mode) {
    const char *_name = "glDrawBuffer";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glDrawBuffer(GLenum mode) {
    PFN_GLDRAWBUFFER _ptr;
    _ptr = (PFN_GLDRAWBUFFER)_getPublicProcAddress("glDrawBuffer");
    if (!_ptr) {
        _ptr = &_fail_glDrawBuffer;
    }
    _glDrawBuffer = _ptr;
    _glDrawBuffer(mode);
}

PFN_GLDRAWBUFFER _glDrawBuffer = &_get_glDrawBuffer;

static void APIENTRY _fail_glClear(GLbitfield mask) {
    const char *_name = "glClear";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glClear(GLbitfield mask) {
    PFN_GLCLEAR _ptr;
    _ptr = (PFN_GLCLEAR)_getPublicProcAddress("glClear");
    if (!_ptr) {
        _ptr = &_fail_glClear;
    }
    _glClear = _ptr;
    _glClear(mask);
}

PFN_GLCLEAR _glClear = &_get_glClear;

static void APIENTRY _fail_glClearColor(GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha) {
    const char *_name = "glClearColor";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glClearColor(GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha) {
    PFN_GLCLEARCOLOR _ptr;
    _ptr = (PFN_GLCLEARCOLOR)_getPublicProcAddress("glClearColor");
    if (!_ptr) {
        _ptr = &_fail_glClearColor;
    }
    _glClearColor = _ptr;
    _glClearColor(red, green, blue, alpha);
}

PFN_GLCLEARCOLOR _glClearColor = &_get_glClearColor;

static void APIENTRY _fail_glClearStencil(GLint s) {
    const char *_name = "glClearStencil";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glClearStencil(GLint s) {
    PFN_GLCLEARSTENCIL _ptr;
    _ptr = (PFN_GLCLEARSTENCIL)_getPublicProcAddress("glClearStencil");
    if (!_ptr) {
        _ptr = &_fail_glClearStencil;
    }
    _glClearStencil = _ptr;
    _glClearStencil(s);
}

PFN_GLCLEARSTENCIL _glClearStencil = &_get_glClearStencil;

static void APIENTRY _fail_glClearDepth(GLdouble depth) {
    const char *_name = "glClearDepth";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glClearDepth(GLdouble depth) {
    PFN_GLCLEARDEPTH _ptr;
    _ptr = (PFN_GLCLEARDEPTH)_getPublicProcAddress("glClearDepth");
    if (!_ptr) {
        _ptr = &_fail_glClearDepth;
    }
    _glClearDepth = _ptr;
    _glClearDepth(depth);
}

PFN_GLCLEARDEPTH _glClearDepth = &_get_glClearDepth;

static void APIENTRY _fail_glStencilMask(GLuint mask) {
    const char *_name = "glStencilMask";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glStencilMask(GLuint mask) {
    PFN_GLSTENCILMASK _ptr;
    _ptr = (PFN_GLSTENCILMASK)_getPublicProcAddress("glStencilMask");
    if (!_ptr) {
        _ptr = &_fail_glStencilMask;
    }
    _glStencilMask = _ptr;
    _glStencilMask(mask);
}

PFN_GLSTENCILMASK _glStencilMask = &_get_glStencilMask;

static void APIENTRY _fail_glColorMask(GLboolean red, GLboolean green, GLboolean blue, GLboolean alpha) {
    const char *_name = "glColorMask";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glColorMask(GLboolean red, GLboolean green, GLboolean blue, GLboolean alpha) {
    PFN_GLCOLORMASK _ptr;
    _ptr = (PFN_GLCOLORMASK)_getPublicProcAddress("glColorMask");
    if (!_ptr) {
        _ptr = &_fail_glColorMask;
    }
    _glColorMask = _ptr;
    _glColorMask(red, green, blue, alpha);
}

PFN_GLCOLORMASK _glColorMask = &_get_glColorMask;

static void APIENTRY _fail_glDepthMask(GLboolean flag) {
    const char *_name = "glDepthMask";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glDepthMask(GLboolean flag) {
    PFN_GLDEPTHMASK _ptr;
    _ptr = (PFN_GLDEPTHMASK)_getPublicProcAddress("glDepthMask");
    if (!_ptr) {
        _ptr = &_fail_glDepthMask;
    }
    _glDepthMask = _ptr;
    _glDepthMask(flag);
}

PFN_GLDEPTHMASK _glDepthMask = &_get_glDepthMask;

static void APIENTRY _fail_glDisable(GLenum cap) {
    const char *_name = "glDisable";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glDisable(GLenum cap) {
    PFN_GLDISABLE _ptr;
    _ptr = (PFN_GLDISABLE)_getPublicProcAddress("glDisable");
    if (!_ptr) {
        _ptr = &_fail_glDisable;
    }
    _glDisable = _ptr;
    _glDisable(cap);
}

PFN_GLDISABLE _glDisable = &_get_glDisable;

static void APIENTRY _fail_glEnable(GLenum cap) {
    const char *_name = "glEnable";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glEnable(GLenum cap) {
    PFN_GLENABLE _ptr;
    _ptr = (PFN_GLENABLE)_getPublicProcAddress("glEnable");
    if (!_ptr) {
        _ptr = &_fail_glEnable;
    }
    _glEnable = _ptr;
    _glEnable(cap);
}

PFN_GLENABLE _glEnable = &_get_glEnable;

static void APIENTRY _fail_glFinish(void) {
    const char *_name = "glFinish";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glFinish(void) {
    PFN_GLFINISH _ptr;
    _ptr = (PFN_GLFINISH)_getPublicProcAddress("glFinish");
    if (!_ptr) {
        _ptr = &_fail_glFinish;
    }
    _glFinish = _ptr;
    _glFinish();
}

PFN_GLFINISH _glFinish = &_get_glFinish;

static void APIENTRY _fail_glFlush(void) {
    const char *_name = "glFlush";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glFlush(void) {
    PFN_GLFLUSH _ptr;
    _ptr = (PFN_GLFLUSH)_getPublicProcAddress("glFlush");
    if (!_ptr) {
        _ptr = &_fail_glFlush;
    }
    _glFlush = _ptr;
    _glFlush();
}

PFN_GLFLUSH _glFlush = &_get_glFlush;

static void APIENTRY _fail_glBlendFunc(GLenum sfactor, GLenum dfactor) {
    const char *_name = "glBlendFunc";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glBlendFunc(GLenum sfactor, GLenum dfactor) {
    PFN_GLBLENDFUNC _ptr;
    _ptr = (PFN_GLBLENDFUNC)_getPublicProcAddress("glBlendFunc");
    if (!_ptr) {
        _ptr = &_fail_glBlendFunc;
    }
    _glBlendFunc = _ptr;
    _glBlendFunc(sfactor, dfactor);
}

PFN_GLBLENDFUNC _glBlendFunc = &_get_glBlendFunc;

static void APIENTRY _fail_glLogicOp(GLenum opcode) {
    const char *_name = "glLogicOp";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glLogicOp(GLenum opcode) {
    PFN_GLLOGICOP _ptr;
    _ptr = (PFN_GLLOGICOP)_getPublicProcAddress("glLogicOp");
    if (!_ptr) {
        _ptr = &_fail_glLogicOp;
    }
    _glLogicOp = _ptr;
    _glLogicOp(opcode);
}

PFN_GLLOGICOP _glLogicOp = &_get_glLogicOp;

static void APIENTRY _fail_glStencilFunc(GLenum func, GLint ref, GLuint mask) {
    const char *_name = "glStencilFunc";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glStencilFunc(GLenum func, GLint ref, GLuint mask) {
    PFN_GLSTENCILFUNC _ptr;
    _ptr = (PFN_GLSTENCILFUNC)_getPublicProcAddress("glStencilFunc");
    if (!_ptr) {
        _ptr = &_fail_glStencilFunc;
    }
    _glStencilFunc = _ptr;
    _glStencilFunc(func, ref, mask);
}

PFN_GLSTENCILFUNC _glStencilFunc = &_get_glStencilFunc;

static void APIENTRY _fail_glStencilOp(GLenum fail, GLenum zfail, GLenum zpass) {
    const char *_name = "glStencilOp";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glStencilOp(GLenum fail, GLenum zfail, GLenum zpass) {
    PFN_GLSTENCILOP _ptr;
    _ptr = (PFN_GLSTENCILOP)_getPublicProcAddress("glStencilOp");
    if (!_ptr) {
        _ptr = &_fail_glStencilOp;
    }
    _glStencilOp = _ptr;
    _glStencilOp(fail, zfail, zpass);
}

PFN_GLSTENCILOP _glStencilOp = &_get_glStencilOp;

static void APIENTRY _fail_glDepthFunc(GLenum func) {
    const char *_name = "glDepthFunc";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glDepthFunc(GLenum func) {
    PFN_GLDEPTHFUNC _ptr;
    _ptr = (PFN_GLDEPTHFUNC)_getPublicProcAddress("glDepthFunc");
    if (!_ptr) {
        _ptr = &_fail_glDepthFunc;
    }
    _glDepthFunc = _ptr;
    _glDepthFunc(func);
}

PFN_GLDEPTHFUNC _glDepthFunc = &_get_glDepthFunc;

static void APIENTRY _fail_glPixelStoref(GLenum pname, GLfloat param) {
    const char *_name = "glPixelStoref";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glPixelStoref(GLenum pname, GLfloat param) {
    PFN_GLPIXELSTOREF _ptr;
    _ptr = (PFN_GLPIXELSTOREF)_getPublicProcAddress("glPixelStoref");
    if (!_ptr) {
        _ptr = &_fail_glPixelStoref;
    }
    _glPixelStoref = _ptr;
    _glPixelStoref(pname, param);
}

PFN_GLPIXELSTOREF _glPixelStoref = &_get_glPixelStoref;

static void APIENTRY _fail_glPixelStorei(GLenum pname, GLint param) {
    const char *_name = "glPixelStorei";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glPixelStorei(GLenum pname, GLint param) {
    PFN_GLPIXELSTOREI _ptr;
    _ptr = (PFN_GLPIXELSTOREI)_getPublicProcAddress("glPixelStorei");
    if (!_ptr) {
        _ptr = &_fail_glPixelStorei;
    }
    _glPixelStorei = _ptr;
    _glPixelStorei(pname, param);
}

PFN_GLPIXELSTOREI _glPixelStorei = &_get_glPixelStorei;

static void APIENTRY _fail_glReadBuffer(GLenum mode) {
    const char *_name = "glReadBuffer";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glReadBuffer(GLenum mode) {
    PFN_GLREADBUFFER _ptr;
    _ptr = (PFN_GLREADBUFFER)_getPublicProcAddress("glReadBuffer");
    if (!_ptr) {
        _ptr = &_fail_glReadBuffer;
    }
    _glReadBuffer = _ptr;
    _glReadBuffer(mode);
}

PFN_GLREADBUFFER _glReadBuffer = &_get_glReadBuffer;

static void APIENTRY _fail_glReadPixels(GLint x, GLint y, GLsizei width, GLsizei height, GLenum format, GLenum type, GLvoid * pixels) {
    const char *_name = "glReadPixels";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glReadPixels(GLint x, GLint y, GLsizei width, GLsizei height, GLenum format, GLenum type, GLvoid * pixels) {
    PFN_GLREADPIXELS _ptr;
    _ptr = (PFN_GLREADPIXELS)_getPublicProcAddress("glReadPixels");
    if (!_ptr) {
        _ptr = &_fail_glReadPixels;
    }
    _glReadPixels = _ptr;
    _glReadPixels(x, y, width, height, format, type, pixels);
}

PFN_GLREADPIXELS _glReadPixels = &_get_glReadPixels;

static void APIENTRY _fail_glGetBooleanv(GLenum pname, GLboolean * params) {
    const char *_name = "glGetBooleanv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetBooleanv(GLenum pname, GLboolean * params) {
    PFN_GLGETBOOLEANV _ptr;
    _ptr = (PFN_GLGETBOOLEANV)_getPublicProcAddress("glGetBooleanv");
    if (!_ptr) {
        _ptr = &_fail_glGetBooleanv;
    }
    _glGetBooleanv = _ptr;
    _glGetBooleanv(pname, params);
}

PFN_GLGETBOOLEANV _glGetBooleanv = &_get_glGetBooleanv;

static void APIENTRY _fail_glGetDoublev(GLenum pname, GLdouble * params) {
    const char *_name = "glGetDoublev";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetDoublev(GLenum pname, GLdouble * params) {
    PFN_GLGETDOUBLEV _ptr;
    _ptr = (PFN_GLGETDOUBLEV)_getPublicProcAddress("glGetDoublev");
    if (!_ptr) {
        _ptr = &_fail_glGetDoublev;
    }
    _glGetDoublev = _ptr;
    _glGetDoublev(pname, params);
}

PFN_GLGETDOUBLEV _glGetDoublev = &_get_glGetDoublev;

static GLenum APIENTRY _fail_glGetError(void) {
    const char *_name = "glGetError";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static GLenum APIENTRY _get_glGetError(void) {
    PFN_GLGETERROR _ptr;
    _ptr = (PFN_GLGETERROR)_getPublicProcAddress("glGetError");
    if (!_ptr) {
        _ptr = &_fail_glGetError;
    }
    _glGetError = _ptr;
    return _glGetError();
}

PFN_GLGETERROR _glGetError = &_get_glGetError;

static void APIENTRY _fail_glGetFloatv(GLenum pname, GLfloat * params) {
    const char *_name = "glGetFloatv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetFloatv(GLenum pname, GLfloat * params) {
    PFN_GLGETFLOATV _ptr;
    _ptr = (PFN_GLGETFLOATV)_getPublicProcAddress("glGetFloatv");
    if (!_ptr) {
        _ptr = &_fail_glGetFloatv;
    }
    _glGetFloatv = _ptr;
    _glGetFloatv(pname, params);
}

PFN_GLGETFLOATV _glGetFloatv = &_get_glGetFloatv;

static void APIENTRY _fail_glGetIntegerv(GLenum pname, GLint * params) {
    const char *_name = "glGetIntegerv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetIntegerv(GLenum pname, GLint * params) {
    PFN_GLGETINTEGERV _ptr;
    _ptr = (PFN_GLGETINTEGERV)_getPublicProcAddress("glGetIntegerv");
    if (!_ptr) {
        _ptr = &_fail_glGetIntegerv;
    }
    _glGetIntegerv = _ptr;
    _glGetIntegerv(pname, params);
}

PFN_GLGETINTEGERV _glGetIntegerv = &_get_glGetIntegerv;

static const GLubyte * APIENTRY _fail_glGetString(GLenum name) {
    const char *_name = "glGetString";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static const GLubyte * APIENTRY _get_glGetString(GLenum name) {
    PFN_GLGETSTRING _ptr;
    _ptr = (PFN_GLGETSTRING)_getPublicProcAddress("glGetString");
    if (!_ptr) {
        _ptr = &_fail_glGetString;
    }
    _glGetString = _ptr;
    return _glGetString(name);
}

PFN_GLGETSTRING _glGetString = &_get_glGetString;

static void APIENTRY _fail_glGetTexImage(GLenum target, GLint level, GLenum format, GLenum type, GLvoid * pixels) {
    const char *_name = "glGetTexImage";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetTexImage(GLenum target, GLint level, GLenum format, GLenum type, GLvoid * pixels) {
    PFN_GLGETTEXIMAGE _ptr;
    _ptr = (PFN_GLGETTEXIMAGE)_getPublicProcAddress("glGetTexImage");
    if (!_ptr) {
        _ptr = &_fail_glGetTexImage;
    }
    _glGetTexImage = _ptr;
    _glGetTexImage(target, level, format, type, pixels);
}

PFN_GLGETTEXIMAGE _glGetTexImage = &_get_glGetTexImage;

static void APIENTRY _fail_glGetTexParameterfv(GLenum target, GLenum pname, GLfloat * params) {
    const char *_name = "glGetTexParameterfv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetTexParameterfv(GLenum target, GLenum pname, GLfloat * params) {
    PFN_GLGETTEXPARAMETERFV _ptr;
    _ptr = (PFN_GLGETTEXPARAMETERFV)_getPublicProcAddress("glGetTexParameterfv");
    if (!_ptr) {
        _ptr = &_fail_glGetTexParameterfv;
    }
    _glGetTexParameterfv = _ptr;
    _glGetTexParameterfv(target, pname, params);
}

PFN_GLGETTEXPARAMETERFV _glGetTexParameterfv = &_get_glGetTexParameterfv;

static void APIENTRY _fail_glGetTexParameteriv(GLenum target, GLenum pname, GLint * params) {
    const char *_name = "glGetTexParameteriv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetTexParameteriv(GLenum target, GLenum pname, GLint * params) {
    PFN_GLGETTEXPARAMETERIV _ptr;
    _ptr = (PFN_GLGETTEXPARAMETERIV)_getPublicProcAddress("glGetTexParameteriv");
    if (!_ptr) {
        _ptr = &_fail_glGetTexParameteriv;
    }
    _glGetTexParameteriv = _ptr;
    _glGetTexParameteriv(target, pname, params);
}

PFN_GLGETTEXPARAMETERIV _glGetTexParameteriv = &_get_glGetTexParameteriv;

static void APIENTRY _fail_glGetTexLevelParameterfv(GLenum target, GLint level, GLenum pname, GLfloat * params) {
    const char *_name = "glGetTexLevelParameterfv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetTexLevelParameterfv(GLenum target, GLint level, GLenum pname, GLfloat * params) {
    PFN_GLGETTEXLEVELPARAMETERFV _ptr;
    _ptr = (PFN_GLGETTEXLEVELPARAMETERFV)_getPublicProcAddress("glGetTexLevelParameterfv");
    if (!_ptr) {
        _ptr = &_fail_glGetTexLevelParameterfv;
    }
    _glGetTexLevelParameterfv = _ptr;
    _glGetTexLevelParameterfv(target, level, pname, params);
}

PFN_GLGETTEXLEVELPARAMETERFV _glGetTexLevelParameterfv = &_get_glGetTexLevelParameterfv;

static void APIENTRY _fail_glGetTexLevelParameteriv(GLenum target, GLint level, GLenum pname, GLint * params) {
    const char *_name = "glGetTexLevelParameteriv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetTexLevelParameteriv(GLenum target, GLint level, GLenum pname, GLint * params) {
    PFN_GLGETTEXLEVELPARAMETERIV _ptr;
    _ptr = (PFN_GLGETTEXLEVELPARAMETERIV)_getPublicProcAddress("glGetTexLevelParameteriv");
    if (!_ptr) {
        _ptr = &_fail_glGetTexLevelParameteriv;
    }
    _glGetTexLevelParameteriv = _ptr;
    _glGetTexLevelParameteriv(target, level, pname, params);
}

PFN_GLGETTEXLEVELPARAMETERIV _glGetTexLevelParameteriv = &_get_glGetTexLevelParameteriv;

static GLboolean APIENTRY _fail_glIsEnabled(GLenum cap) {
    const char *_name = "glIsEnabled";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static GLboolean APIENTRY _get_glIsEnabled(GLenum cap) {
    PFN_GLISENABLED _ptr;
    _ptr = (PFN_GLISENABLED)_getPublicProcAddress("glIsEnabled");
    if (!_ptr) {
        _ptr = &_fail_glIsEnabled;
    }
    _glIsEnabled = _ptr;
    return _glIsEnabled(cap);
}

PFN_GLISENABLED _glIsEnabled = &_get_glIsEnabled;

static void APIENTRY _fail_glDepthRange(GLdouble zNear, GLdouble zFar) {
    const char *_name = "glDepthRange";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glDepthRange(GLdouble zNear, GLdouble zFar) {
    PFN_GLDEPTHRANGE _ptr;
    _ptr = (PFN_GLDEPTHRANGE)_getPublicProcAddress("glDepthRange");
    if (!_ptr) {
        _ptr = &_fail_glDepthRange;
    }
    _glDepthRange = _ptr;
    _glDepthRange(zNear, zFar);
}

PFN_GLDEPTHRANGE _glDepthRange = &_get_glDepthRange;

static void APIENTRY _fail_glViewport(GLint x, GLint y, GLsizei width, GLsizei height) {
    const char *_name = "glViewport";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glViewport(GLint x, GLint y, GLsizei width, GLsizei height) {
    PFN_GLVIEWPORT _ptr;
    _ptr = (PFN_GLVIEWPORT)_getPublicProcAddress("glViewport");
    if (!_ptr) {
        _ptr = &_fail_glViewport;
    }
    _glViewport = _ptr;
    _glViewport(x, y, width, height);
}

PFN_GLVIEWPORT _glViewport = &_get_glViewport;

static void APIENTRY _fail_glNewList(GLuint list, GLenum mode) {
    const char *_name = "glNewList";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glNewList(GLuint list, GLenum mode) {
    PFN_GLNEWLIST _ptr;
    _ptr = (PFN_GLNEWLIST)_getPublicProcAddress("glNewList");
    if (!_ptr) {
        _ptr = &_fail_glNewList;
    }
    _glNewList = _ptr;
    _glNewList(list, mode);
}

PFN_GLNEWLIST _glNewList = &_get_glNewList;

static void APIENTRY _fail_glEndList(void) {
    const char *_name = "glEndList";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glEndList(void) {
    PFN_GLENDLIST _ptr;
    _ptr = (PFN_GLENDLIST)_getPublicProcAddress("glEndList");
    if (!_ptr) {
        _ptr = &_fail_glEndList;
    }
    _glEndList = _ptr;
    _glEndList();
}

PFN_GLENDLIST _glEndList = &_get_glEndList;

static void APIENTRY _fail_glCallList(GLuint list) {
    const char *_name = "glCallList";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glCallList(GLuint list) {
    PFN_GLCALLLIST _ptr;
    _ptr = (PFN_GLCALLLIST)_getPublicProcAddress("glCallList");
    if (!_ptr) {
        _ptr = &_fail_glCallList;
    }
    _glCallList = _ptr;
    _glCallList(list);
}

PFN_GLCALLLIST _glCallList = &_get_glCallList;

static void APIENTRY _fail_glCallLists(GLsizei n, GLenum type, const GLvoid * lists) {
    const char *_name = "glCallLists";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glCallLists(GLsizei n, GLenum type, const GLvoid * lists) {
    PFN_GLCALLLISTS _ptr;
    _ptr = (PFN_GLCALLLISTS)_getPublicProcAddress("glCallLists");
    if (!_ptr) {
        _ptr = &_fail_glCallLists;
    }
    _glCallLists = _ptr;
    _glCallLists(n, type, lists);
}

PFN_GLCALLLISTS _glCallLists = &_get_glCallLists;

static void APIENTRY _fail_glDeleteLists(GLuint list, GLsizei range) {
    const char *_name = "glDeleteLists";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glDeleteLists(GLuint list, GLsizei range) {
    PFN_GLDELETELISTS _ptr;
    _ptr = (PFN_GLDELETELISTS)_getPublicProcAddress("glDeleteLists");
    if (!_ptr) {
        _ptr = &_fail_glDeleteLists;
    }
    _glDeleteLists = _ptr;
    _glDeleteLists(list, range);
}

PFN_GLDELETELISTS _glDeleteLists = &_get_glDeleteLists;

static GLuint APIENTRY _fail_glGenLists(GLsizei range) {
    const char *_name = "glGenLists";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static GLuint APIENTRY _get_glGenLists(GLsizei range) {
    PFN_GLGENLISTS _ptr;
    _ptr = (PFN_GLGENLISTS)_getPublicProcAddress("glGenLists");
    if (!_ptr) {
        _ptr = &_fail_glGenLists;
    }
    _glGenLists = _ptr;
    return _glGenLists(range);
}

PFN_GLGENLISTS _glGenLists = &_get_glGenLists;

static void APIENTRY _fail_glListBase(GLuint base) {
    const char *_name = "glListBase";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glListBase(GLuint base) {
    PFN_GLLISTBASE _ptr;
    _ptr = (PFN_GLLISTBASE)_getPublicProcAddress("glListBase");
    if (!_ptr) {
        _ptr = &_fail_glListBase;
    }
    _glListBase = _ptr;
    _glListBase(base);
}

PFN_GLLISTBASE _glListBase = &_get_glListBase;

static void APIENTRY _fail_glBegin(GLenum mode) {
    const char *_name = "glBegin";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glBegin(GLenum mode) {
    PFN_GLBEGIN _ptr;
    _ptr = (PFN_GLBEGIN)_getPublicProcAddress("glBegin");
    if (!_ptr) {
        _ptr = &_fail_glBegin;
    }
    _glBegin = _ptr;
    _glBegin(mode);
}

PFN_GLBEGIN _glBegin = &_get_glBegin;

static void APIENTRY _fail_glBitmap(GLsizei width, GLsizei height, GLfloat xorig, GLfloat yorig, GLfloat xmove, GLfloat ymove, const GLubyte * bitmap) {
    const char *_name = "glBitmap";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glBitmap(GLsizei width, GLsizei height, GLfloat xorig, GLfloat yorig, GLfloat xmove, GLfloat ymove, const GLubyte * bitmap) {
    PFN_GLBITMAP _ptr;
    _ptr = (PFN_GLBITMAP)_getPublicProcAddress("glBitmap");
    if (!_ptr) {
        _ptr = &_fail_glBitmap;
    }
    _glBitmap = _ptr;
    _glBitmap(width, height, xorig, yorig, xmove, ymove, bitmap);
}

PFN_GLBITMAP _glBitmap = &_get_glBitmap;

static void APIENTRY _fail_glColor3b(GLbyte red, GLbyte green, GLbyte blue) {
    const char *_name = "glColor3b";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glColor3b(GLbyte red, GLbyte green, GLbyte blue) {
    PFN_GLCOLOR3B _ptr;
    _ptr = (PFN_GLCOLOR3B)_getPublicProcAddress("glColor3b");
    if (!_ptr) {
        _ptr = &_fail_glColor3b;
    }
    _glColor3b = _ptr;
    _glColor3b(red, green, blue);
}

PFN_GLCOLOR3B _glColor3b = &_get_glColor3b;

static void APIENTRY _fail_glColor3bv(const GLbyte * v) {
    const char *_name = "glColor3bv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glColor3bv(const GLbyte * v) {
    PFN_GLCOLOR3BV _ptr;
    _ptr = (PFN_GLCOLOR3BV)_getPublicProcAddress("glColor3bv");
    if (!_ptr) {
        _ptr = &_fail_glColor3bv;
    }
    _glColor3bv = _ptr;
    _glColor3bv(v);
}

PFN_GLCOLOR3BV _glColor3bv = &_get_glColor3bv;

static void APIENTRY _fail_glColor3d(GLdouble red, GLdouble green, GLdouble blue) {
    const char *_name = "glColor3d";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glColor3d(GLdouble red, GLdouble green, GLdouble blue) {
    PFN_GLCOLOR3D _ptr;
    _ptr = (PFN_GLCOLOR3D)_getPublicProcAddress("glColor3d");
    if (!_ptr) {
        _ptr = &_fail_glColor3d;
    }
    _glColor3d = _ptr;
    _glColor3d(red, green, blue);
}

PFN_GLCOLOR3D _glColor3d = &_get_glColor3d;

static void APIENTRY _fail_glColor3dv(const GLdouble * v) {
    const char *_name = "glColor3dv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glColor3dv(const GLdouble * v) {
    PFN_GLCOLOR3DV _ptr;
    _ptr = (PFN_GLCOLOR3DV)_getPublicProcAddress("glColor3dv");
    if (!_ptr) {
        _ptr = &_fail_glColor3dv;
    }
    _glColor3dv = _ptr;
    _glColor3dv(v);
}

PFN_GLCOLOR3DV _glColor3dv = &_get_glColor3dv;

static void APIENTRY _fail_glColor3f(GLfloat red, GLfloat green, GLfloat blue) {
    const char *_name = "glColor3f";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glColor3f(GLfloat red, GLfloat green, GLfloat blue) {
    PFN_GLCOLOR3F _ptr;
    _ptr = (PFN_GLCOLOR3F)_getPublicProcAddress("glColor3f");
    if (!_ptr) {
        _ptr = &_fail_glColor3f;
    }
    _glColor3f = _ptr;
    _glColor3f(red, green, blue);
}

PFN_GLCOLOR3F _glColor3f = &_get_glColor3f;

static void APIENTRY _fail_glColor3fv(const GLfloat * v) {
    const char *_name = "glColor3fv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glColor3fv(const GLfloat * v) {
    PFN_GLCOLOR3FV _ptr;
    _ptr = (PFN_GLCOLOR3FV)_getPublicProcAddress("glColor3fv");
    if (!_ptr) {
        _ptr = &_fail_glColor3fv;
    }
    _glColor3fv = _ptr;
    _glColor3fv(v);
}

PFN_GLCOLOR3FV _glColor3fv = &_get_glColor3fv;

static void APIENTRY _fail_glColor3i(GLint red, GLint green, GLint blue) {
    const char *_name = "glColor3i";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glColor3i(GLint red, GLint green, GLint blue) {
    PFN_GLCOLOR3I _ptr;
    _ptr = (PFN_GLCOLOR3I)_getPublicProcAddress("glColor3i");
    if (!_ptr) {
        _ptr = &_fail_glColor3i;
    }
    _glColor3i = _ptr;
    _glColor3i(red, green, blue);
}

PFN_GLCOLOR3I _glColor3i = &_get_glColor3i;

static void APIENTRY _fail_glColor3iv(const GLint * v) {
    const char *_name = "glColor3iv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glColor3iv(const GLint * v) {
    PFN_GLCOLOR3IV _ptr;
    _ptr = (PFN_GLCOLOR3IV)_getPublicProcAddress("glColor3iv");
    if (!_ptr) {
        _ptr = &_fail_glColor3iv;
    }
    _glColor3iv = _ptr;
    _glColor3iv(v);
}

PFN_GLCOLOR3IV _glColor3iv = &_get_glColor3iv;

static void APIENTRY _fail_glColor3s(GLshort red, GLshort green, GLshort blue) {
    const char *_name = "glColor3s";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glColor3s(GLshort red, GLshort green, GLshort blue) {
    PFN_GLCOLOR3S _ptr;
    _ptr = (PFN_GLCOLOR3S)_getPublicProcAddress("glColor3s");
    if (!_ptr) {
        _ptr = &_fail_glColor3s;
    }
    _glColor3s = _ptr;
    _glColor3s(red, green, blue);
}

PFN_GLCOLOR3S _glColor3s = &_get_glColor3s;

static void APIENTRY _fail_glColor3sv(const GLshort * v) {
    const char *_name = "glColor3sv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glColor3sv(const GLshort * v) {
    PFN_GLCOLOR3SV _ptr;
    _ptr = (PFN_GLCOLOR3SV)_getPublicProcAddress("glColor3sv");
    if (!_ptr) {
        _ptr = &_fail_glColor3sv;
    }
    _glColor3sv = _ptr;
    _glColor3sv(v);
}

PFN_GLCOLOR3SV _glColor3sv = &_get_glColor3sv;

static void APIENTRY _fail_glColor3ub(GLubyte red, GLubyte green, GLubyte blue) {
    const char *_name = "glColor3ub";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glColor3ub(GLubyte red, GLubyte green, GLubyte blue) {
    PFN_GLCOLOR3UB _ptr;
    _ptr = (PFN_GLCOLOR3UB)_getPublicProcAddress("glColor3ub");
    if (!_ptr) {
        _ptr = &_fail_glColor3ub;
    }
    _glColor3ub = _ptr;
    _glColor3ub(red, green, blue);
}

PFN_GLCOLOR3UB _glColor3ub = &_get_glColor3ub;

static void APIENTRY _fail_glColor3ubv(const GLubyte * v) {
    const char *_name = "glColor3ubv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glColor3ubv(const GLubyte * v) {
    PFN_GLCOLOR3UBV _ptr;
    _ptr = (PFN_GLCOLOR3UBV)_getPublicProcAddress("glColor3ubv");
    if (!_ptr) {
        _ptr = &_fail_glColor3ubv;
    }
    _glColor3ubv = _ptr;
    _glColor3ubv(v);
}

PFN_GLCOLOR3UBV _glColor3ubv = &_get_glColor3ubv;

static void APIENTRY _fail_glColor3ui(GLuint red, GLuint green, GLuint blue) {
    const char *_name = "glColor3ui";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glColor3ui(GLuint red, GLuint green, GLuint blue) {
    PFN_GLCOLOR3UI _ptr;
    _ptr = (PFN_GLCOLOR3UI)_getPublicProcAddress("glColor3ui");
    if (!_ptr) {
        _ptr = &_fail_glColor3ui;
    }
    _glColor3ui = _ptr;
    _glColor3ui(red, green, blue);
}

PFN_GLCOLOR3UI _glColor3ui = &_get_glColor3ui;

static void APIENTRY _fail_glColor3uiv(const GLuint * v) {
    const char *_name = "glColor3uiv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glColor3uiv(const GLuint * v) {
    PFN_GLCOLOR3UIV _ptr;
    _ptr = (PFN_GLCOLOR3UIV)_getPublicProcAddress("glColor3uiv");
    if (!_ptr) {
        _ptr = &_fail_glColor3uiv;
    }
    _glColor3uiv = _ptr;
    _glColor3uiv(v);
}

PFN_GLCOLOR3UIV _glColor3uiv = &_get_glColor3uiv;

static void APIENTRY _fail_glColor3us(GLushort red, GLushort green, GLushort blue) {
    const char *_name = "glColor3us";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glColor3us(GLushort red, GLushort green, GLushort blue) {
    PFN_GLCOLOR3US _ptr;
    _ptr = (PFN_GLCOLOR3US)_getPublicProcAddress("glColor3us");
    if (!_ptr) {
        _ptr = &_fail_glColor3us;
    }
    _glColor3us = _ptr;
    _glColor3us(red, green, blue);
}

PFN_GLCOLOR3US _glColor3us = &_get_glColor3us;

static void APIENTRY _fail_glColor3usv(const GLushort * v) {
    const char *_name = "glColor3usv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glColor3usv(const GLushort * v) {
    PFN_GLCOLOR3USV _ptr;
    _ptr = (PFN_GLCOLOR3USV)_getPublicProcAddress("glColor3usv");
    if (!_ptr) {
        _ptr = &_fail_glColor3usv;
    }
    _glColor3usv = _ptr;
    _glColor3usv(v);
}

PFN_GLCOLOR3USV _glColor3usv = &_get_glColor3usv;

static void APIENTRY _fail_glColor4b(GLbyte red, GLbyte green, GLbyte blue, GLbyte alpha) {
    const char *_name = "glColor4b";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glColor4b(GLbyte red, GLbyte green, GLbyte blue, GLbyte alpha) {
    PFN_GLCOLOR4B _ptr;
    _ptr = (PFN_GLCOLOR4B)_getPublicProcAddress("glColor4b");
    if (!_ptr) {
        _ptr = &_fail_glColor4b;
    }
    _glColor4b = _ptr;
    _glColor4b(red, green, blue, alpha);
}

PFN_GLCOLOR4B _glColor4b = &_get_glColor4b;

static void APIENTRY _fail_glColor4bv(const GLbyte * v) {
    const char *_name = "glColor4bv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glColor4bv(const GLbyte * v) {
    PFN_GLCOLOR4BV _ptr;
    _ptr = (PFN_GLCOLOR4BV)_getPublicProcAddress("glColor4bv");
    if (!_ptr) {
        _ptr = &_fail_glColor4bv;
    }
    _glColor4bv = _ptr;
    _glColor4bv(v);
}

PFN_GLCOLOR4BV _glColor4bv = &_get_glColor4bv;

static void APIENTRY _fail_glColor4d(GLdouble red, GLdouble green, GLdouble blue, GLdouble alpha) {
    const char *_name = "glColor4d";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glColor4d(GLdouble red, GLdouble green, GLdouble blue, GLdouble alpha) {
    PFN_GLCOLOR4D _ptr;
    _ptr = (PFN_GLCOLOR4D)_getPublicProcAddress("glColor4d");
    if (!_ptr) {
        _ptr = &_fail_glColor4d;
    }
    _glColor4d = _ptr;
    _glColor4d(red, green, blue, alpha);
}

PFN_GLCOLOR4D _glColor4d = &_get_glColor4d;

static void APIENTRY _fail_glColor4dv(const GLdouble * v) {
    const char *_name = "glColor4dv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glColor4dv(const GLdouble * v) {
    PFN_GLCOLOR4DV _ptr;
    _ptr = (PFN_GLCOLOR4DV)_getPublicProcAddress("glColor4dv");
    if (!_ptr) {
        _ptr = &_fail_glColor4dv;
    }
    _glColor4dv = _ptr;
    _glColor4dv(v);
}

PFN_GLCOLOR4DV _glColor4dv = &_get_glColor4dv;

static void APIENTRY _fail_glColor4f(GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha) {
    const char *_name = "glColor4f";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glColor4f(GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha) {
    PFN_GLCOLOR4F _ptr;
    _ptr = (PFN_GLCOLOR4F)_getPublicProcAddress("glColor4f");
    if (!_ptr) {
        _ptr = &_fail_glColor4f;
    }
    _glColor4f = _ptr;
    _glColor4f(red, green, blue, alpha);
}

PFN_GLCOLOR4F _glColor4f = &_get_glColor4f;

static void APIENTRY _fail_glColor4fv(const GLfloat * v) {
    const char *_name = "glColor4fv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glColor4fv(const GLfloat * v) {
    PFN_GLCOLOR4FV _ptr;
    _ptr = (PFN_GLCOLOR4FV)_getPublicProcAddress("glColor4fv");
    if (!_ptr) {
        _ptr = &_fail_glColor4fv;
    }
    _glColor4fv = _ptr;
    _glColor4fv(v);
}

PFN_GLCOLOR4FV _glColor4fv = &_get_glColor4fv;

static void APIENTRY _fail_glColor4i(GLint red, GLint green, GLint blue, GLint alpha) {
    const char *_name = "glColor4i";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glColor4i(GLint red, GLint green, GLint blue, GLint alpha) {
    PFN_GLCOLOR4I _ptr;
    _ptr = (PFN_GLCOLOR4I)_getPublicProcAddress("glColor4i");
    if (!_ptr) {
        _ptr = &_fail_glColor4i;
    }
    _glColor4i = _ptr;
    _glColor4i(red, green, blue, alpha);
}

PFN_GLCOLOR4I _glColor4i = &_get_glColor4i;

static void APIENTRY _fail_glColor4iv(const GLint * v) {
    const char *_name = "glColor4iv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glColor4iv(const GLint * v) {
    PFN_GLCOLOR4IV _ptr;
    _ptr = (PFN_GLCOLOR4IV)_getPublicProcAddress("glColor4iv");
    if (!_ptr) {
        _ptr = &_fail_glColor4iv;
    }
    _glColor4iv = _ptr;
    _glColor4iv(v);
}

PFN_GLCOLOR4IV _glColor4iv = &_get_glColor4iv;

static void APIENTRY _fail_glColor4s(GLshort red, GLshort green, GLshort blue, GLshort alpha) {
    const char *_name = "glColor4s";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glColor4s(GLshort red, GLshort green, GLshort blue, GLshort alpha) {
    PFN_GLCOLOR4S _ptr;
    _ptr = (PFN_GLCOLOR4S)_getPublicProcAddress("glColor4s");
    if (!_ptr) {
        _ptr = &_fail_glColor4s;
    }
    _glColor4s = _ptr;
    _glColor4s(red, green, blue, alpha);
}

PFN_GLCOLOR4S _glColor4s = &_get_glColor4s;

static void APIENTRY _fail_glColor4sv(const GLshort * v) {
    const char *_name = "glColor4sv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glColor4sv(const GLshort * v) {
    PFN_GLCOLOR4SV _ptr;
    _ptr = (PFN_GLCOLOR4SV)_getPublicProcAddress("glColor4sv");
    if (!_ptr) {
        _ptr = &_fail_glColor4sv;
    }
    _glColor4sv = _ptr;
    _glColor4sv(v);
}

PFN_GLCOLOR4SV _glColor4sv = &_get_glColor4sv;

static void APIENTRY _fail_glColor4ub(GLubyte red, GLubyte green, GLubyte blue, GLubyte alpha) {
    const char *_name = "glColor4ub";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glColor4ub(GLubyte red, GLubyte green, GLubyte blue, GLubyte alpha) {
    PFN_GLCOLOR4UB _ptr;
    _ptr = (PFN_GLCOLOR4UB)_getPublicProcAddress("glColor4ub");
    if (!_ptr) {
        _ptr = &_fail_glColor4ub;
    }
    _glColor4ub = _ptr;
    _glColor4ub(red, green, blue, alpha);
}

PFN_GLCOLOR4UB _glColor4ub = &_get_glColor4ub;

static void APIENTRY _fail_glColor4ubv(const GLubyte * v) {
    const char *_name = "glColor4ubv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glColor4ubv(const GLubyte * v) {
    PFN_GLCOLOR4UBV _ptr;
    _ptr = (PFN_GLCOLOR4UBV)_getPublicProcAddress("glColor4ubv");
    if (!_ptr) {
        _ptr = &_fail_glColor4ubv;
    }
    _glColor4ubv = _ptr;
    _glColor4ubv(v);
}

PFN_GLCOLOR4UBV _glColor4ubv = &_get_glColor4ubv;

static void APIENTRY _fail_glColor4ui(GLuint red, GLuint green, GLuint blue, GLuint alpha) {
    const char *_name = "glColor4ui";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glColor4ui(GLuint red, GLuint green, GLuint blue, GLuint alpha) {
    PFN_GLCOLOR4UI _ptr;
    _ptr = (PFN_GLCOLOR4UI)_getPublicProcAddress("glColor4ui");
    if (!_ptr) {
        _ptr = &_fail_glColor4ui;
    }
    _glColor4ui = _ptr;
    _glColor4ui(red, green, blue, alpha);
}

PFN_GLCOLOR4UI _glColor4ui = &_get_glColor4ui;

static void APIENTRY _fail_glColor4uiv(const GLuint * v) {
    const char *_name = "glColor4uiv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glColor4uiv(const GLuint * v) {
    PFN_GLCOLOR4UIV _ptr;
    _ptr = (PFN_GLCOLOR4UIV)_getPublicProcAddress("glColor4uiv");
    if (!_ptr) {
        _ptr = &_fail_glColor4uiv;
    }
    _glColor4uiv = _ptr;
    _glColor4uiv(v);
}

PFN_GLCOLOR4UIV _glColor4uiv = &_get_glColor4uiv;

static void APIENTRY _fail_glColor4us(GLushort red, GLushort green, GLushort blue, GLushort alpha) {
    const char *_name = "glColor4us";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glColor4us(GLushort red, GLushort green, GLushort blue, GLushort alpha) {
    PFN_GLCOLOR4US _ptr;
    _ptr = (PFN_GLCOLOR4US)_getPublicProcAddress("glColor4us");
    if (!_ptr) {
        _ptr = &_fail_glColor4us;
    }
    _glColor4us = _ptr;
    _glColor4us(red, green, blue, alpha);
}

PFN_GLCOLOR4US _glColor4us = &_get_glColor4us;

static void APIENTRY _fail_glColor4usv(const GLushort * v) {
    const char *_name = "glColor4usv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glColor4usv(const GLushort * v) {
    PFN_GLCOLOR4USV _ptr;
    _ptr = (PFN_GLCOLOR4USV)_getPublicProcAddress("glColor4usv");
    if (!_ptr) {
        _ptr = &_fail_glColor4usv;
    }
    _glColor4usv = _ptr;
    _glColor4usv(v);
}

PFN_GLCOLOR4USV _glColor4usv = &_get_glColor4usv;

static void APIENTRY _fail_glEdgeFlag(GLboolean flag) {
    const char *_name = "glEdgeFlag";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glEdgeFlag(GLboolean flag) {
    PFN_GLEDGEFLAG _ptr;
    _ptr = (PFN_GLEDGEFLAG)_getPublicProcAddress("glEdgeFlag");
    if (!_ptr) {
        _ptr = &_fail_glEdgeFlag;
    }
    _glEdgeFlag = _ptr;
    _glEdgeFlag(flag);
}

PFN_GLEDGEFLAG _glEdgeFlag = &_get_glEdgeFlag;

static void APIENTRY _fail_glEdgeFlagv(const GLboolean * flag) {
    const char *_name = "glEdgeFlagv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glEdgeFlagv(const GLboolean * flag) {
    PFN_GLEDGEFLAGV _ptr;
    _ptr = (PFN_GLEDGEFLAGV)_getPublicProcAddress("glEdgeFlagv");
    if (!_ptr) {
        _ptr = &_fail_glEdgeFlagv;
    }
    _glEdgeFlagv = _ptr;
    _glEdgeFlagv(flag);
}

PFN_GLEDGEFLAGV _glEdgeFlagv = &_get_glEdgeFlagv;

static void APIENTRY _fail_glEnd(void) {
    const char *_name = "glEnd";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glEnd(void) {
    PFN_GLEND _ptr;
    _ptr = (PFN_GLEND)_getPublicProcAddress("glEnd");
    if (!_ptr) {
        _ptr = &_fail_glEnd;
    }
    _glEnd = _ptr;
    _glEnd();
}

PFN_GLEND _glEnd = &_get_glEnd;

static void APIENTRY _fail_glIndexd(GLdouble c) {
    const char *_name = "glIndexd";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glIndexd(GLdouble c) {
    PFN_GLINDEXD _ptr;
    _ptr = (PFN_GLINDEXD)_getPublicProcAddress("glIndexd");
    if (!_ptr) {
        _ptr = &_fail_glIndexd;
    }
    _glIndexd = _ptr;
    _glIndexd(c);
}

PFN_GLINDEXD _glIndexd = &_get_glIndexd;

static void APIENTRY _fail_glIndexdv(const GLdouble * c) {
    const char *_name = "glIndexdv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glIndexdv(const GLdouble * c) {
    PFN_GLINDEXDV _ptr;
    _ptr = (PFN_GLINDEXDV)_getPublicProcAddress("glIndexdv");
    if (!_ptr) {
        _ptr = &_fail_glIndexdv;
    }
    _glIndexdv = _ptr;
    _glIndexdv(c);
}

PFN_GLINDEXDV _glIndexdv = &_get_glIndexdv;

static void APIENTRY _fail_glIndexf(GLfloat c) {
    const char *_name = "glIndexf";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glIndexf(GLfloat c) {
    PFN_GLINDEXF _ptr;
    _ptr = (PFN_GLINDEXF)_getPublicProcAddress("glIndexf");
    if (!_ptr) {
        _ptr = &_fail_glIndexf;
    }
    _glIndexf = _ptr;
    _glIndexf(c);
}

PFN_GLINDEXF _glIndexf = &_get_glIndexf;

static void APIENTRY _fail_glIndexfv(const GLfloat * c) {
    const char *_name = "glIndexfv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glIndexfv(const GLfloat * c) {
    PFN_GLINDEXFV _ptr;
    _ptr = (PFN_GLINDEXFV)_getPublicProcAddress("glIndexfv");
    if (!_ptr) {
        _ptr = &_fail_glIndexfv;
    }
    _glIndexfv = _ptr;
    _glIndexfv(c);
}

PFN_GLINDEXFV _glIndexfv = &_get_glIndexfv;

static void APIENTRY _fail_glIndexi(GLint c) {
    const char *_name = "glIndexi";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glIndexi(GLint c) {
    PFN_GLINDEXI _ptr;
    _ptr = (PFN_GLINDEXI)_getPublicProcAddress("glIndexi");
    if (!_ptr) {
        _ptr = &_fail_glIndexi;
    }
    _glIndexi = _ptr;
    _glIndexi(c);
}

PFN_GLINDEXI _glIndexi = &_get_glIndexi;

static void APIENTRY _fail_glIndexiv(const GLint * c) {
    const char *_name = "glIndexiv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glIndexiv(const GLint * c) {
    PFN_GLINDEXIV _ptr;
    _ptr = (PFN_GLINDEXIV)_getPublicProcAddress("glIndexiv");
    if (!_ptr) {
        _ptr = &_fail_glIndexiv;
    }
    _glIndexiv = _ptr;
    _glIndexiv(c);
}

PFN_GLINDEXIV _glIndexiv = &_get_glIndexiv;

static void APIENTRY _fail_glIndexs(GLshort c) {
    const char *_name = "glIndexs";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glIndexs(GLshort c) {
    PFN_GLINDEXS _ptr;
    _ptr = (PFN_GLINDEXS)_getPublicProcAddress("glIndexs");
    if (!_ptr) {
        _ptr = &_fail_glIndexs;
    }
    _glIndexs = _ptr;
    _glIndexs(c);
}

PFN_GLINDEXS _glIndexs = &_get_glIndexs;

static void APIENTRY _fail_glIndexsv(const GLshort * c) {
    const char *_name = "glIndexsv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glIndexsv(const GLshort * c) {
    PFN_GLINDEXSV _ptr;
    _ptr = (PFN_GLINDEXSV)_getPublicProcAddress("glIndexsv");
    if (!_ptr) {
        _ptr = &_fail_glIndexsv;
    }
    _glIndexsv = _ptr;
    _glIndexsv(c);
}

PFN_GLINDEXSV _glIndexsv = &_get_glIndexsv;

static void APIENTRY _fail_glNormal3b(GLbyte nx, GLbyte ny, GLbyte nz) {
    const char *_name = "glNormal3b";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glNormal3b(GLbyte nx, GLbyte ny, GLbyte nz) {
    PFN_GLNORMAL3B _ptr;
    _ptr = (PFN_GLNORMAL3B)_getPublicProcAddress("glNormal3b");
    if (!_ptr) {
        _ptr = &_fail_glNormal3b;
    }
    _glNormal3b = _ptr;
    _glNormal3b(nx, ny, nz);
}

PFN_GLNORMAL3B _glNormal3b = &_get_glNormal3b;

static void APIENTRY _fail_glNormal3bv(const GLbyte * v) {
    const char *_name = "glNormal3bv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glNormal3bv(const GLbyte * v) {
    PFN_GLNORMAL3BV _ptr;
    _ptr = (PFN_GLNORMAL3BV)_getPublicProcAddress("glNormal3bv");
    if (!_ptr) {
        _ptr = &_fail_glNormal3bv;
    }
    _glNormal3bv = _ptr;
    _glNormal3bv(v);
}

PFN_GLNORMAL3BV _glNormal3bv = &_get_glNormal3bv;

static void APIENTRY _fail_glNormal3d(GLdouble nx, GLdouble ny, GLdouble nz) {
    const char *_name = "glNormal3d";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glNormal3d(GLdouble nx, GLdouble ny, GLdouble nz) {
    PFN_GLNORMAL3D _ptr;
    _ptr = (PFN_GLNORMAL3D)_getPublicProcAddress("glNormal3d");
    if (!_ptr) {
        _ptr = &_fail_glNormal3d;
    }
    _glNormal3d = _ptr;
    _glNormal3d(nx, ny, nz);
}

PFN_GLNORMAL3D _glNormal3d = &_get_glNormal3d;

static void APIENTRY _fail_glNormal3dv(const GLdouble * v) {
    const char *_name = "glNormal3dv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glNormal3dv(const GLdouble * v) {
    PFN_GLNORMAL3DV _ptr;
    _ptr = (PFN_GLNORMAL3DV)_getPublicProcAddress("glNormal3dv");
    if (!_ptr) {
        _ptr = &_fail_glNormal3dv;
    }
    _glNormal3dv = _ptr;
    _glNormal3dv(v);
}

PFN_GLNORMAL3DV _glNormal3dv = &_get_glNormal3dv;

static void APIENTRY _fail_glNormal3f(GLfloat nx, GLfloat ny, GLfloat nz) {
    const char *_name = "glNormal3f";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glNormal3f(GLfloat nx, GLfloat ny, GLfloat nz) {
    PFN_GLNORMAL3F _ptr;
    _ptr = (PFN_GLNORMAL3F)_getPublicProcAddress("glNormal3f");
    if (!_ptr) {
        _ptr = &_fail_glNormal3f;
    }
    _glNormal3f = _ptr;
    _glNormal3f(nx, ny, nz);
}

PFN_GLNORMAL3F _glNormal3f = &_get_glNormal3f;

static void APIENTRY _fail_glNormal3fv(const GLfloat * v) {
    const char *_name = "glNormal3fv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glNormal3fv(const GLfloat * v) {
    PFN_GLNORMAL3FV _ptr;
    _ptr = (PFN_GLNORMAL3FV)_getPublicProcAddress("glNormal3fv");
    if (!_ptr) {
        _ptr = &_fail_glNormal3fv;
    }
    _glNormal3fv = _ptr;
    _glNormal3fv(v);
}

PFN_GLNORMAL3FV _glNormal3fv = &_get_glNormal3fv;

static void APIENTRY _fail_glNormal3i(GLint nx, GLint ny, GLint nz) {
    const char *_name = "glNormal3i";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glNormal3i(GLint nx, GLint ny, GLint nz) {
    PFN_GLNORMAL3I _ptr;
    _ptr = (PFN_GLNORMAL3I)_getPublicProcAddress("glNormal3i");
    if (!_ptr) {
        _ptr = &_fail_glNormal3i;
    }
    _glNormal3i = _ptr;
    _glNormal3i(nx, ny, nz);
}

PFN_GLNORMAL3I _glNormal3i = &_get_glNormal3i;

static void APIENTRY _fail_glNormal3iv(const GLint * v) {
    const char *_name = "glNormal3iv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glNormal3iv(const GLint * v) {
    PFN_GLNORMAL3IV _ptr;
    _ptr = (PFN_GLNORMAL3IV)_getPublicProcAddress("glNormal3iv");
    if (!_ptr) {
        _ptr = &_fail_glNormal3iv;
    }
    _glNormal3iv = _ptr;
    _glNormal3iv(v);
}

PFN_GLNORMAL3IV _glNormal3iv = &_get_glNormal3iv;

static void APIENTRY _fail_glNormal3s(GLshort nx, GLshort ny, GLshort nz) {
    const char *_name = "glNormal3s";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glNormal3s(GLshort nx, GLshort ny, GLshort nz) {
    PFN_GLNORMAL3S _ptr;
    _ptr = (PFN_GLNORMAL3S)_getPublicProcAddress("glNormal3s");
    if (!_ptr) {
        _ptr = &_fail_glNormal3s;
    }
    _glNormal3s = _ptr;
    _glNormal3s(nx, ny, nz);
}

PFN_GLNORMAL3S _glNormal3s = &_get_glNormal3s;

static void APIENTRY _fail_glNormal3sv(const GLshort * v) {
    const char *_name = "glNormal3sv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glNormal3sv(const GLshort * v) {
    PFN_GLNORMAL3SV _ptr;
    _ptr = (PFN_GLNORMAL3SV)_getPublicProcAddress("glNormal3sv");
    if (!_ptr) {
        _ptr = &_fail_glNormal3sv;
    }
    _glNormal3sv = _ptr;
    _glNormal3sv(v);
}

PFN_GLNORMAL3SV _glNormal3sv = &_get_glNormal3sv;

static void APIENTRY _fail_glRasterPos2d(GLdouble x, GLdouble y) {
    const char *_name = "glRasterPos2d";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glRasterPos2d(GLdouble x, GLdouble y) {
    PFN_GLRASTERPOS2D _ptr;
    _ptr = (PFN_GLRASTERPOS2D)_getPublicProcAddress("glRasterPos2d");
    if (!_ptr) {
        _ptr = &_fail_glRasterPos2d;
    }
    _glRasterPos2d = _ptr;
    _glRasterPos2d(x, y);
}

PFN_GLRASTERPOS2D _glRasterPos2d = &_get_glRasterPos2d;

static void APIENTRY _fail_glRasterPos2dv(const GLdouble * v) {
    const char *_name = "glRasterPos2dv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glRasterPos2dv(const GLdouble * v) {
    PFN_GLRASTERPOS2DV _ptr;
    _ptr = (PFN_GLRASTERPOS2DV)_getPublicProcAddress("glRasterPos2dv");
    if (!_ptr) {
        _ptr = &_fail_glRasterPos2dv;
    }
    _glRasterPos2dv = _ptr;
    _glRasterPos2dv(v);
}

PFN_GLRASTERPOS2DV _glRasterPos2dv = &_get_glRasterPos2dv;

static void APIENTRY _fail_glRasterPos2f(GLfloat x, GLfloat y) {
    const char *_name = "glRasterPos2f";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glRasterPos2f(GLfloat x, GLfloat y) {
    PFN_GLRASTERPOS2F _ptr;
    _ptr = (PFN_GLRASTERPOS2F)_getPublicProcAddress("glRasterPos2f");
    if (!_ptr) {
        _ptr = &_fail_glRasterPos2f;
    }
    _glRasterPos2f = _ptr;
    _glRasterPos2f(x, y);
}

PFN_GLRASTERPOS2F _glRasterPos2f = &_get_glRasterPos2f;

static void APIENTRY _fail_glRasterPos2fv(const GLfloat * v) {
    const char *_name = "glRasterPos2fv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glRasterPos2fv(const GLfloat * v) {
    PFN_GLRASTERPOS2FV _ptr;
    _ptr = (PFN_GLRASTERPOS2FV)_getPublicProcAddress("glRasterPos2fv");
    if (!_ptr) {
        _ptr = &_fail_glRasterPos2fv;
    }
    _glRasterPos2fv = _ptr;
    _glRasterPos2fv(v);
}

PFN_GLRASTERPOS2FV _glRasterPos2fv = &_get_glRasterPos2fv;

static void APIENTRY _fail_glRasterPos2i(GLint x, GLint y) {
    const char *_name = "glRasterPos2i";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glRasterPos2i(GLint x, GLint y) {
    PFN_GLRASTERPOS2I _ptr;
    _ptr = (PFN_GLRASTERPOS2I)_getPublicProcAddress("glRasterPos2i");
    if (!_ptr) {
        _ptr = &_fail_glRasterPos2i;
    }
    _glRasterPos2i = _ptr;
    _glRasterPos2i(x, y);
}

PFN_GLRASTERPOS2I _glRasterPos2i = &_get_glRasterPos2i;

static void APIENTRY _fail_glRasterPos2iv(const GLint * v) {
    const char *_name = "glRasterPos2iv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glRasterPos2iv(const GLint * v) {
    PFN_GLRASTERPOS2IV _ptr;
    _ptr = (PFN_GLRASTERPOS2IV)_getPublicProcAddress("glRasterPos2iv");
    if (!_ptr) {
        _ptr = &_fail_glRasterPos2iv;
    }
    _glRasterPos2iv = _ptr;
    _glRasterPos2iv(v);
}

PFN_GLRASTERPOS2IV _glRasterPos2iv = &_get_glRasterPos2iv;

static void APIENTRY _fail_glRasterPos2s(GLshort x, GLshort y) {
    const char *_name = "glRasterPos2s";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glRasterPos2s(GLshort x, GLshort y) {
    PFN_GLRASTERPOS2S _ptr;
    _ptr = (PFN_GLRASTERPOS2S)_getPublicProcAddress("glRasterPos2s");
    if (!_ptr) {
        _ptr = &_fail_glRasterPos2s;
    }
    _glRasterPos2s = _ptr;
    _glRasterPos2s(x, y);
}

PFN_GLRASTERPOS2S _glRasterPos2s = &_get_glRasterPos2s;

static void APIENTRY _fail_glRasterPos2sv(const GLshort * v) {
    const char *_name = "glRasterPos2sv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glRasterPos2sv(const GLshort * v) {
    PFN_GLRASTERPOS2SV _ptr;
    _ptr = (PFN_GLRASTERPOS2SV)_getPublicProcAddress("glRasterPos2sv");
    if (!_ptr) {
        _ptr = &_fail_glRasterPos2sv;
    }
    _glRasterPos2sv = _ptr;
    _glRasterPos2sv(v);
}

PFN_GLRASTERPOS2SV _glRasterPos2sv = &_get_glRasterPos2sv;

static void APIENTRY _fail_glRasterPos3d(GLdouble x, GLdouble y, GLdouble z) {
    const char *_name = "glRasterPos3d";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glRasterPos3d(GLdouble x, GLdouble y, GLdouble z) {
    PFN_GLRASTERPOS3D _ptr;
    _ptr = (PFN_GLRASTERPOS3D)_getPublicProcAddress("glRasterPos3d");
    if (!_ptr) {
        _ptr = &_fail_glRasterPos3d;
    }
    _glRasterPos3d = _ptr;
    _glRasterPos3d(x, y, z);
}

PFN_GLRASTERPOS3D _glRasterPos3d = &_get_glRasterPos3d;

static void APIENTRY _fail_glRasterPos3dv(const GLdouble * v) {
    const char *_name = "glRasterPos3dv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glRasterPos3dv(const GLdouble * v) {
    PFN_GLRASTERPOS3DV _ptr;
    _ptr = (PFN_GLRASTERPOS3DV)_getPublicProcAddress("glRasterPos3dv");
    if (!_ptr) {
        _ptr = &_fail_glRasterPos3dv;
    }
    _glRasterPos3dv = _ptr;
    _glRasterPos3dv(v);
}

PFN_GLRASTERPOS3DV _glRasterPos3dv = &_get_glRasterPos3dv;

static void APIENTRY _fail_glRasterPos3f(GLfloat x, GLfloat y, GLfloat z) {
    const char *_name = "glRasterPos3f";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glRasterPos3f(GLfloat x, GLfloat y, GLfloat z) {
    PFN_GLRASTERPOS3F _ptr;
    _ptr = (PFN_GLRASTERPOS3F)_getPublicProcAddress("glRasterPos3f");
    if (!_ptr) {
        _ptr = &_fail_glRasterPos3f;
    }
    _glRasterPos3f = _ptr;
    _glRasterPos3f(x, y, z);
}

PFN_GLRASTERPOS3F _glRasterPos3f = &_get_glRasterPos3f;

static void APIENTRY _fail_glRasterPos3fv(const GLfloat * v) {
    const char *_name = "glRasterPos3fv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glRasterPos3fv(const GLfloat * v) {
    PFN_GLRASTERPOS3FV _ptr;
    _ptr = (PFN_GLRASTERPOS3FV)_getPublicProcAddress("glRasterPos3fv");
    if (!_ptr) {
        _ptr = &_fail_glRasterPos3fv;
    }
    _glRasterPos3fv = _ptr;
    _glRasterPos3fv(v);
}

PFN_GLRASTERPOS3FV _glRasterPos3fv = &_get_glRasterPos3fv;

static void APIENTRY _fail_glRasterPos3i(GLint x, GLint y, GLint z) {
    const char *_name = "glRasterPos3i";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glRasterPos3i(GLint x, GLint y, GLint z) {
    PFN_GLRASTERPOS3I _ptr;
    _ptr = (PFN_GLRASTERPOS3I)_getPublicProcAddress("glRasterPos3i");
    if (!_ptr) {
        _ptr = &_fail_glRasterPos3i;
    }
    _glRasterPos3i = _ptr;
    _glRasterPos3i(x, y, z);
}

PFN_GLRASTERPOS3I _glRasterPos3i = &_get_glRasterPos3i;

static void APIENTRY _fail_glRasterPos3iv(const GLint * v) {
    const char *_name = "glRasterPos3iv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glRasterPos3iv(const GLint * v) {
    PFN_GLRASTERPOS3IV _ptr;
    _ptr = (PFN_GLRASTERPOS3IV)_getPublicProcAddress("glRasterPos3iv");
    if (!_ptr) {
        _ptr = &_fail_glRasterPos3iv;
    }
    _glRasterPos3iv = _ptr;
    _glRasterPos3iv(v);
}

PFN_GLRASTERPOS3IV _glRasterPos3iv = &_get_glRasterPos3iv;

static void APIENTRY _fail_glRasterPos3s(GLshort x, GLshort y, GLshort z) {
    const char *_name = "glRasterPos3s";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glRasterPos3s(GLshort x, GLshort y, GLshort z) {
    PFN_GLRASTERPOS3S _ptr;
    _ptr = (PFN_GLRASTERPOS3S)_getPublicProcAddress("glRasterPos3s");
    if (!_ptr) {
        _ptr = &_fail_glRasterPos3s;
    }
    _glRasterPos3s = _ptr;
    _glRasterPos3s(x, y, z);
}

PFN_GLRASTERPOS3S _glRasterPos3s = &_get_glRasterPos3s;

static void APIENTRY _fail_glRasterPos3sv(const GLshort * v) {
    const char *_name = "glRasterPos3sv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glRasterPos3sv(const GLshort * v) {
    PFN_GLRASTERPOS3SV _ptr;
    _ptr = (PFN_GLRASTERPOS3SV)_getPublicProcAddress("glRasterPos3sv");
    if (!_ptr) {
        _ptr = &_fail_glRasterPos3sv;
    }
    _glRasterPos3sv = _ptr;
    _glRasterPos3sv(v);
}

PFN_GLRASTERPOS3SV _glRasterPos3sv = &_get_glRasterPos3sv;

static void APIENTRY _fail_glRasterPos4d(GLdouble x, GLdouble y, GLdouble z, GLdouble w) {
    const char *_name = "glRasterPos4d";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glRasterPos4d(GLdouble x, GLdouble y, GLdouble z, GLdouble w) {
    PFN_GLRASTERPOS4D _ptr;
    _ptr = (PFN_GLRASTERPOS4D)_getPublicProcAddress("glRasterPos4d");
    if (!_ptr) {
        _ptr = &_fail_glRasterPos4d;
    }
    _glRasterPos4d = _ptr;
    _glRasterPos4d(x, y, z, w);
}

PFN_GLRASTERPOS4D _glRasterPos4d = &_get_glRasterPos4d;

static void APIENTRY _fail_glRasterPos4dv(const GLdouble * v) {
    const char *_name = "glRasterPos4dv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glRasterPos4dv(const GLdouble * v) {
    PFN_GLRASTERPOS4DV _ptr;
    _ptr = (PFN_GLRASTERPOS4DV)_getPublicProcAddress("glRasterPos4dv");
    if (!_ptr) {
        _ptr = &_fail_glRasterPos4dv;
    }
    _glRasterPos4dv = _ptr;
    _glRasterPos4dv(v);
}

PFN_GLRASTERPOS4DV _glRasterPos4dv = &_get_glRasterPos4dv;

static void APIENTRY _fail_glRasterPos4f(GLfloat x, GLfloat y, GLfloat z, GLfloat w) {
    const char *_name = "glRasterPos4f";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glRasterPos4f(GLfloat x, GLfloat y, GLfloat z, GLfloat w) {
    PFN_GLRASTERPOS4F _ptr;
    _ptr = (PFN_GLRASTERPOS4F)_getPublicProcAddress("glRasterPos4f");
    if (!_ptr) {
        _ptr = &_fail_glRasterPos4f;
    }
    _glRasterPos4f = _ptr;
    _glRasterPos4f(x, y, z, w);
}

PFN_GLRASTERPOS4F _glRasterPos4f = &_get_glRasterPos4f;

static void APIENTRY _fail_glRasterPos4fv(const GLfloat * v) {
    const char *_name = "glRasterPos4fv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glRasterPos4fv(const GLfloat * v) {
    PFN_GLRASTERPOS4FV _ptr;
    _ptr = (PFN_GLRASTERPOS4FV)_getPublicProcAddress("glRasterPos4fv");
    if (!_ptr) {
        _ptr = &_fail_glRasterPos4fv;
    }
    _glRasterPos4fv = _ptr;
    _glRasterPos4fv(v);
}

PFN_GLRASTERPOS4FV _glRasterPos4fv = &_get_glRasterPos4fv;

static void APIENTRY _fail_glRasterPos4i(GLint x, GLint y, GLint z, GLint w) {
    const char *_name = "glRasterPos4i";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glRasterPos4i(GLint x, GLint y, GLint z, GLint w) {
    PFN_GLRASTERPOS4I _ptr;
    _ptr = (PFN_GLRASTERPOS4I)_getPublicProcAddress("glRasterPos4i");
    if (!_ptr) {
        _ptr = &_fail_glRasterPos4i;
    }
    _glRasterPos4i = _ptr;
    _glRasterPos4i(x, y, z, w);
}

PFN_GLRASTERPOS4I _glRasterPos4i = &_get_glRasterPos4i;

static void APIENTRY _fail_glRasterPos4iv(const GLint * v) {
    const char *_name = "glRasterPos4iv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glRasterPos4iv(const GLint * v) {
    PFN_GLRASTERPOS4IV _ptr;
    _ptr = (PFN_GLRASTERPOS4IV)_getPublicProcAddress("glRasterPos4iv");
    if (!_ptr) {
        _ptr = &_fail_glRasterPos4iv;
    }
    _glRasterPos4iv = _ptr;
    _glRasterPos4iv(v);
}

PFN_GLRASTERPOS4IV _glRasterPos4iv = &_get_glRasterPos4iv;

static void APIENTRY _fail_glRasterPos4s(GLshort x, GLshort y, GLshort z, GLshort w) {
    const char *_name = "glRasterPos4s";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glRasterPos4s(GLshort x, GLshort y, GLshort z, GLshort w) {
    PFN_GLRASTERPOS4S _ptr;
    _ptr = (PFN_GLRASTERPOS4S)_getPublicProcAddress("glRasterPos4s");
    if (!_ptr) {
        _ptr = &_fail_glRasterPos4s;
    }
    _glRasterPos4s = _ptr;
    _glRasterPos4s(x, y, z, w);
}

PFN_GLRASTERPOS4S _glRasterPos4s = &_get_glRasterPos4s;

static void APIENTRY _fail_glRasterPos4sv(const GLshort * v) {
    const char *_name = "glRasterPos4sv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glRasterPos4sv(const GLshort * v) {
    PFN_GLRASTERPOS4SV _ptr;
    _ptr = (PFN_GLRASTERPOS4SV)_getPublicProcAddress("glRasterPos4sv");
    if (!_ptr) {
        _ptr = &_fail_glRasterPos4sv;
    }
    _glRasterPos4sv = _ptr;
    _glRasterPos4sv(v);
}

PFN_GLRASTERPOS4SV _glRasterPos4sv = &_get_glRasterPos4sv;

static void APIENTRY _fail_glRectd(GLdouble x1, GLdouble y1, GLdouble x2, GLdouble y2) {
    const char *_name = "glRectd";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glRectd(GLdouble x1, GLdouble y1, GLdouble x2, GLdouble y2) {
    PFN_GLRECTD _ptr;
    _ptr = (PFN_GLRECTD)_getPublicProcAddress("glRectd");
    if (!_ptr) {
        _ptr = &_fail_glRectd;
    }
    _glRectd = _ptr;
    _glRectd(x1, y1, x2, y2);
}

PFN_GLRECTD _glRectd = &_get_glRectd;

static void APIENTRY _fail_glRectdv(const GLdouble * v1, const GLdouble * v2) {
    const char *_name = "glRectdv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glRectdv(const GLdouble * v1, const GLdouble * v2) {
    PFN_GLRECTDV _ptr;
    _ptr = (PFN_GLRECTDV)_getPublicProcAddress("glRectdv");
    if (!_ptr) {
        _ptr = &_fail_glRectdv;
    }
    _glRectdv = _ptr;
    _glRectdv(v1, v2);
}

PFN_GLRECTDV _glRectdv = &_get_glRectdv;

static void APIENTRY _fail_glRectf(GLfloat x1, GLfloat y1, GLfloat x2, GLfloat y2) {
    const char *_name = "glRectf";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glRectf(GLfloat x1, GLfloat y1, GLfloat x2, GLfloat y2) {
    PFN_GLRECTF _ptr;
    _ptr = (PFN_GLRECTF)_getPublicProcAddress("glRectf");
    if (!_ptr) {
        _ptr = &_fail_glRectf;
    }
    _glRectf = _ptr;
    _glRectf(x1, y1, x2, y2);
}

PFN_GLRECTF _glRectf = &_get_glRectf;

static void APIENTRY _fail_glRectfv(const GLfloat * v1, const GLfloat * v2) {
    const char *_name = "glRectfv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glRectfv(const GLfloat * v1, const GLfloat * v2) {
    PFN_GLRECTFV _ptr;
    _ptr = (PFN_GLRECTFV)_getPublicProcAddress("glRectfv");
    if (!_ptr) {
        _ptr = &_fail_glRectfv;
    }
    _glRectfv = _ptr;
    _glRectfv(v1, v2);
}

PFN_GLRECTFV _glRectfv = &_get_glRectfv;

static void APIENTRY _fail_glRecti(GLint x1, GLint y1, GLint x2, GLint y2) {
    const char *_name = "glRecti";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glRecti(GLint x1, GLint y1, GLint x2, GLint y2) {
    PFN_GLRECTI _ptr;
    _ptr = (PFN_GLRECTI)_getPublicProcAddress("glRecti");
    if (!_ptr) {
        _ptr = &_fail_glRecti;
    }
    _glRecti = _ptr;
    _glRecti(x1, y1, x2, y2);
}

PFN_GLRECTI _glRecti = &_get_glRecti;

static void APIENTRY _fail_glRectiv(const GLint * v1, const GLint * v2) {
    const char *_name = "glRectiv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glRectiv(const GLint * v1, const GLint * v2) {
    PFN_GLRECTIV _ptr;
    _ptr = (PFN_GLRECTIV)_getPublicProcAddress("glRectiv");
    if (!_ptr) {
        _ptr = &_fail_glRectiv;
    }
    _glRectiv = _ptr;
    _glRectiv(v1, v2);
}

PFN_GLRECTIV _glRectiv = &_get_glRectiv;

static void APIENTRY _fail_glRects(GLshort x1, GLshort y1, GLshort x2, GLshort y2) {
    const char *_name = "glRects";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glRects(GLshort x1, GLshort y1, GLshort x2, GLshort y2) {
    PFN_GLRECTS _ptr;
    _ptr = (PFN_GLRECTS)_getPublicProcAddress("glRects");
    if (!_ptr) {
        _ptr = &_fail_glRects;
    }
    _glRects = _ptr;
    _glRects(x1, y1, x2, y2);
}

PFN_GLRECTS _glRects = &_get_glRects;

static void APIENTRY _fail_glRectsv(const GLshort * v1, const GLshort * v2) {
    const char *_name = "glRectsv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glRectsv(const GLshort * v1, const GLshort * v2) {
    PFN_GLRECTSV _ptr;
    _ptr = (PFN_GLRECTSV)_getPublicProcAddress("glRectsv");
    if (!_ptr) {
        _ptr = &_fail_glRectsv;
    }
    _glRectsv = _ptr;
    _glRectsv(v1, v2);
}

PFN_GLRECTSV _glRectsv = &_get_glRectsv;

static void APIENTRY _fail_glTexCoord1d(GLdouble s) {
    const char *_name = "glTexCoord1d";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glTexCoord1d(GLdouble s) {
    PFN_GLTEXCOORD1D _ptr;
    _ptr = (PFN_GLTEXCOORD1D)_getPublicProcAddress("glTexCoord1d");
    if (!_ptr) {
        _ptr = &_fail_glTexCoord1d;
    }
    _glTexCoord1d = _ptr;
    _glTexCoord1d(s);
}

PFN_GLTEXCOORD1D _glTexCoord1d = &_get_glTexCoord1d;

static void APIENTRY _fail_glTexCoord1dv(const GLdouble * v) {
    const char *_name = "glTexCoord1dv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glTexCoord1dv(const GLdouble * v) {
    PFN_GLTEXCOORD1DV _ptr;
    _ptr = (PFN_GLTEXCOORD1DV)_getPublicProcAddress("glTexCoord1dv");
    if (!_ptr) {
        _ptr = &_fail_glTexCoord1dv;
    }
    _glTexCoord1dv = _ptr;
    _glTexCoord1dv(v);
}

PFN_GLTEXCOORD1DV _glTexCoord1dv = &_get_glTexCoord1dv;

static void APIENTRY _fail_glTexCoord1f(GLfloat s) {
    const char *_name = "glTexCoord1f";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glTexCoord1f(GLfloat s) {
    PFN_GLTEXCOORD1F _ptr;
    _ptr = (PFN_GLTEXCOORD1F)_getPublicProcAddress("glTexCoord1f");
    if (!_ptr) {
        _ptr = &_fail_glTexCoord1f;
    }
    _glTexCoord1f = _ptr;
    _glTexCoord1f(s);
}

PFN_GLTEXCOORD1F _glTexCoord1f = &_get_glTexCoord1f;

static void APIENTRY _fail_glTexCoord1fv(const GLfloat * v) {
    const char *_name = "glTexCoord1fv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glTexCoord1fv(const GLfloat * v) {
    PFN_GLTEXCOORD1FV _ptr;
    _ptr = (PFN_GLTEXCOORD1FV)_getPublicProcAddress("glTexCoord1fv");
    if (!_ptr) {
        _ptr = &_fail_glTexCoord1fv;
    }
    _glTexCoord1fv = _ptr;
    _glTexCoord1fv(v);
}

PFN_GLTEXCOORD1FV _glTexCoord1fv = &_get_glTexCoord1fv;

static void APIENTRY _fail_glTexCoord1i(GLint s) {
    const char *_name = "glTexCoord1i";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glTexCoord1i(GLint s) {
    PFN_GLTEXCOORD1I _ptr;
    _ptr = (PFN_GLTEXCOORD1I)_getPublicProcAddress("glTexCoord1i");
    if (!_ptr) {
        _ptr = &_fail_glTexCoord1i;
    }
    _glTexCoord1i = _ptr;
    _glTexCoord1i(s);
}

PFN_GLTEXCOORD1I _glTexCoord1i = &_get_glTexCoord1i;

static void APIENTRY _fail_glTexCoord1iv(const GLint * v) {
    const char *_name = "glTexCoord1iv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glTexCoord1iv(const GLint * v) {
    PFN_GLTEXCOORD1IV _ptr;
    _ptr = (PFN_GLTEXCOORD1IV)_getPublicProcAddress("glTexCoord1iv");
    if (!_ptr) {
        _ptr = &_fail_glTexCoord1iv;
    }
    _glTexCoord1iv = _ptr;
    _glTexCoord1iv(v);
}

PFN_GLTEXCOORD1IV _glTexCoord1iv = &_get_glTexCoord1iv;

static void APIENTRY _fail_glTexCoord1s(GLshort s) {
    const char *_name = "glTexCoord1s";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glTexCoord1s(GLshort s) {
    PFN_GLTEXCOORD1S _ptr;
    _ptr = (PFN_GLTEXCOORD1S)_getPublicProcAddress("glTexCoord1s");
    if (!_ptr) {
        _ptr = &_fail_glTexCoord1s;
    }
    _glTexCoord1s = _ptr;
    _glTexCoord1s(s);
}

PFN_GLTEXCOORD1S _glTexCoord1s = &_get_glTexCoord1s;

static void APIENTRY _fail_glTexCoord1sv(const GLshort * v) {
    const char *_name = "glTexCoord1sv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glTexCoord1sv(const GLshort * v) {
    PFN_GLTEXCOORD1SV _ptr;
    _ptr = (PFN_GLTEXCOORD1SV)_getPublicProcAddress("glTexCoord1sv");
    if (!_ptr) {
        _ptr = &_fail_glTexCoord1sv;
    }
    _glTexCoord1sv = _ptr;
    _glTexCoord1sv(v);
}

PFN_GLTEXCOORD1SV _glTexCoord1sv = &_get_glTexCoord1sv;

static void APIENTRY _fail_glTexCoord2d(GLdouble s, GLdouble t) {
    const char *_name = "glTexCoord2d";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glTexCoord2d(GLdouble s, GLdouble t) {
    PFN_GLTEXCOORD2D _ptr;
    _ptr = (PFN_GLTEXCOORD2D)_getPublicProcAddress("glTexCoord2d");
    if (!_ptr) {
        _ptr = &_fail_glTexCoord2d;
    }
    _glTexCoord2d = _ptr;
    _glTexCoord2d(s, t);
}

PFN_GLTEXCOORD2D _glTexCoord2d = &_get_glTexCoord2d;

static void APIENTRY _fail_glTexCoord2dv(const GLdouble * v) {
    const char *_name = "glTexCoord2dv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glTexCoord2dv(const GLdouble * v) {
    PFN_GLTEXCOORD2DV _ptr;
    _ptr = (PFN_GLTEXCOORD2DV)_getPublicProcAddress("glTexCoord2dv");
    if (!_ptr) {
        _ptr = &_fail_glTexCoord2dv;
    }
    _glTexCoord2dv = _ptr;
    _glTexCoord2dv(v);
}

PFN_GLTEXCOORD2DV _glTexCoord2dv = &_get_glTexCoord2dv;

static void APIENTRY _fail_glTexCoord2f(GLfloat s, GLfloat t) {
    const char *_name = "glTexCoord2f";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glTexCoord2f(GLfloat s, GLfloat t) {
    PFN_GLTEXCOORD2F _ptr;
    _ptr = (PFN_GLTEXCOORD2F)_getPublicProcAddress("glTexCoord2f");
    if (!_ptr) {
        _ptr = &_fail_glTexCoord2f;
    }
    _glTexCoord2f = _ptr;
    _glTexCoord2f(s, t);
}

PFN_GLTEXCOORD2F _glTexCoord2f = &_get_glTexCoord2f;

static void APIENTRY _fail_glTexCoord2fv(const GLfloat * v) {
    const char *_name = "glTexCoord2fv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glTexCoord2fv(const GLfloat * v) {
    PFN_GLTEXCOORD2FV _ptr;
    _ptr = (PFN_GLTEXCOORD2FV)_getPublicProcAddress("glTexCoord2fv");
    if (!_ptr) {
        _ptr = &_fail_glTexCoord2fv;
    }
    _glTexCoord2fv = _ptr;
    _glTexCoord2fv(v);
}

PFN_GLTEXCOORD2FV _glTexCoord2fv = &_get_glTexCoord2fv;

static void APIENTRY _fail_glTexCoord2i(GLint s, GLint t) {
    const char *_name = "glTexCoord2i";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glTexCoord2i(GLint s, GLint t) {
    PFN_GLTEXCOORD2I _ptr;
    _ptr = (PFN_GLTEXCOORD2I)_getPublicProcAddress("glTexCoord2i");
    if (!_ptr) {
        _ptr = &_fail_glTexCoord2i;
    }
    _glTexCoord2i = _ptr;
    _glTexCoord2i(s, t);
}

PFN_GLTEXCOORD2I _glTexCoord2i = &_get_glTexCoord2i;

static void APIENTRY _fail_glTexCoord2iv(const GLint * v) {
    const char *_name = "glTexCoord2iv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glTexCoord2iv(const GLint * v) {
    PFN_GLTEXCOORD2IV _ptr;
    _ptr = (PFN_GLTEXCOORD2IV)_getPublicProcAddress("glTexCoord2iv");
    if (!_ptr) {
        _ptr = &_fail_glTexCoord2iv;
    }
    _glTexCoord2iv = _ptr;
    _glTexCoord2iv(v);
}

PFN_GLTEXCOORD2IV _glTexCoord2iv = &_get_glTexCoord2iv;

static void APIENTRY _fail_glTexCoord2s(GLshort s, GLshort t) {
    const char *_name = "glTexCoord2s";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glTexCoord2s(GLshort s, GLshort t) {
    PFN_GLTEXCOORD2S _ptr;
    _ptr = (PFN_GLTEXCOORD2S)_getPublicProcAddress("glTexCoord2s");
    if (!_ptr) {
        _ptr = &_fail_glTexCoord2s;
    }
    _glTexCoord2s = _ptr;
    _glTexCoord2s(s, t);
}

PFN_GLTEXCOORD2S _glTexCoord2s = &_get_glTexCoord2s;

static void APIENTRY _fail_glTexCoord2sv(const GLshort * v) {
    const char *_name = "glTexCoord2sv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glTexCoord2sv(const GLshort * v) {
    PFN_GLTEXCOORD2SV _ptr;
    _ptr = (PFN_GLTEXCOORD2SV)_getPublicProcAddress("glTexCoord2sv");
    if (!_ptr) {
        _ptr = &_fail_glTexCoord2sv;
    }
    _glTexCoord2sv = _ptr;
    _glTexCoord2sv(v);
}

PFN_GLTEXCOORD2SV _glTexCoord2sv = &_get_glTexCoord2sv;

static void APIENTRY _fail_glTexCoord3d(GLdouble s, GLdouble t, GLdouble r) {
    const char *_name = "glTexCoord3d";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glTexCoord3d(GLdouble s, GLdouble t, GLdouble r) {
    PFN_GLTEXCOORD3D _ptr;
    _ptr = (PFN_GLTEXCOORD3D)_getPublicProcAddress("glTexCoord3d");
    if (!_ptr) {
        _ptr = &_fail_glTexCoord3d;
    }
    _glTexCoord3d = _ptr;
    _glTexCoord3d(s, t, r);
}

PFN_GLTEXCOORD3D _glTexCoord3d = &_get_glTexCoord3d;

static void APIENTRY _fail_glTexCoord3dv(const GLdouble * v) {
    const char *_name = "glTexCoord3dv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glTexCoord3dv(const GLdouble * v) {
    PFN_GLTEXCOORD3DV _ptr;
    _ptr = (PFN_GLTEXCOORD3DV)_getPublicProcAddress("glTexCoord3dv");
    if (!_ptr) {
        _ptr = &_fail_glTexCoord3dv;
    }
    _glTexCoord3dv = _ptr;
    _glTexCoord3dv(v);
}

PFN_GLTEXCOORD3DV _glTexCoord3dv = &_get_glTexCoord3dv;

static void APIENTRY _fail_glTexCoord3f(GLfloat s, GLfloat t, GLfloat r) {
    const char *_name = "glTexCoord3f";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glTexCoord3f(GLfloat s, GLfloat t, GLfloat r) {
    PFN_GLTEXCOORD3F _ptr;
    _ptr = (PFN_GLTEXCOORD3F)_getPublicProcAddress("glTexCoord3f");
    if (!_ptr) {
        _ptr = &_fail_glTexCoord3f;
    }
    _glTexCoord3f = _ptr;
    _glTexCoord3f(s, t, r);
}

PFN_GLTEXCOORD3F _glTexCoord3f = &_get_glTexCoord3f;

static void APIENTRY _fail_glTexCoord3fv(const GLfloat * v) {
    const char *_name = "glTexCoord3fv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glTexCoord3fv(const GLfloat * v) {
    PFN_GLTEXCOORD3FV _ptr;
    _ptr = (PFN_GLTEXCOORD3FV)_getPublicProcAddress("glTexCoord3fv");
    if (!_ptr) {
        _ptr = &_fail_glTexCoord3fv;
    }
    _glTexCoord3fv = _ptr;
    _glTexCoord3fv(v);
}

PFN_GLTEXCOORD3FV _glTexCoord3fv = &_get_glTexCoord3fv;

static void APIENTRY _fail_glTexCoord3i(GLint s, GLint t, GLint r) {
    const char *_name = "glTexCoord3i";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glTexCoord3i(GLint s, GLint t, GLint r) {
    PFN_GLTEXCOORD3I _ptr;
    _ptr = (PFN_GLTEXCOORD3I)_getPublicProcAddress("glTexCoord3i");
    if (!_ptr) {
        _ptr = &_fail_glTexCoord3i;
    }
    _glTexCoord3i = _ptr;
    _glTexCoord3i(s, t, r);
}

PFN_GLTEXCOORD3I _glTexCoord3i = &_get_glTexCoord3i;

static void APIENTRY _fail_glTexCoord3iv(const GLint * v) {
    const char *_name = "glTexCoord3iv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glTexCoord3iv(const GLint * v) {
    PFN_GLTEXCOORD3IV _ptr;
    _ptr = (PFN_GLTEXCOORD3IV)_getPublicProcAddress("glTexCoord3iv");
    if (!_ptr) {
        _ptr = &_fail_glTexCoord3iv;
    }
    _glTexCoord3iv = _ptr;
    _glTexCoord3iv(v);
}

PFN_GLTEXCOORD3IV _glTexCoord3iv = &_get_glTexCoord3iv;

static void APIENTRY _fail_glTexCoord3s(GLshort s, GLshort t, GLshort r) {
    const char *_name = "glTexCoord3s";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glTexCoord3s(GLshort s, GLshort t, GLshort r) {
    PFN_GLTEXCOORD3S _ptr;
    _ptr = (PFN_GLTEXCOORD3S)_getPublicProcAddress("glTexCoord3s");
    if (!_ptr) {
        _ptr = &_fail_glTexCoord3s;
    }
    _glTexCoord3s = _ptr;
    _glTexCoord3s(s, t, r);
}

PFN_GLTEXCOORD3S _glTexCoord3s = &_get_glTexCoord3s;

static void APIENTRY _fail_glTexCoord3sv(const GLshort * v) {
    const char *_name = "glTexCoord3sv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glTexCoord3sv(const GLshort * v) {
    PFN_GLTEXCOORD3SV _ptr;
    _ptr = (PFN_GLTEXCOORD3SV)_getPublicProcAddress("glTexCoord3sv");
    if (!_ptr) {
        _ptr = &_fail_glTexCoord3sv;
    }
    _glTexCoord3sv = _ptr;
    _glTexCoord3sv(v);
}

PFN_GLTEXCOORD3SV _glTexCoord3sv = &_get_glTexCoord3sv;

static void APIENTRY _fail_glTexCoord4d(GLdouble s, GLdouble t, GLdouble r, GLdouble q) {
    const char *_name = "glTexCoord4d";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glTexCoord4d(GLdouble s, GLdouble t, GLdouble r, GLdouble q) {
    PFN_GLTEXCOORD4D _ptr;
    _ptr = (PFN_GLTEXCOORD4D)_getPublicProcAddress("glTexCoord4d");
    if (!_ptr) {
        _ptr = &_fail_glTexCoord4d;
    }
    _glTexCoord4d = _ptr;
    _glTexCoord4d(s, t, r, q);
}

PFN_GLTEXCOORD4D _glTexCoord4d = &_get_glTexCoord4d;

static void APIENTRY _fail_glTexCoord4dv(const GLdouble * v) {
    const char *_name = "glTexCoord4dv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glTexCoord4dv(const GLdouble * v) {
    PFN_GLTEXCOORD4DV _ptr;
    _ptr = (PFN_GLTEXCOORD4DV)_getPublicProcAddress("glTexCoord4dv");
    if (!_ptr) {
        _ptr = &_fail_glTexCoord4dv;
    }
    _glTexCoord4dv = _ptr;
    _glTexCoord4dv(v);
}

PFN_GLTEXCOORD4DV _glTexCoord4dv = &_get_glTexCoord4dv;

static void APIENTRY _fail_glTexCoord4f(GLfloat s, GLfloat t, GLfloat r, GLfloat q) {
    const char *_name = "glTexCoord4f";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glTexCoord4f(GLfloat s, GLfloat t, GLfloat r, GLfloat q) {
    PFN_GLTEXCOORD4F _ptr;
    _ptr = (PFN_GLTEXCOORD4F)_getPublicProcAddress("glTexCoord4f");
    if (!_ptr) {
        _ptr = &_fail_glTexCoord4f;
    }
    _glTexCoord4f = _ptr;
    _glTexCoord4f(s, t, r, q);
}

PFN_GLTEXCOORD4F _glTexCoord4f = &_get_glTexCoord4f;

static void APIENTRY _fail_glTexCoord4fv(const GLfloat * v) {
    const char *_name = "glTexCoord4fv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glTexCoord4fv(const GLfloat * v) {
    PFN_GLTEXCOORD4FV _ptr;
    _ptr = (PFN_GLTEXCOORD4FV)_getPublicProcAddress("glTexCoord4fv");
    if (!_ptr) {
        _ptr = &_fail_glTexCoord4fv;
    }
    _glTexCoord4fv = _ptr;
    _glTexCoord4fv(v);
}

PFN_GLTEXCOORD4FV _glTexCoord4fv = &_get_glTexCoord4fv;

static void APIENTRY _fail_glTexCoord4i(GLint s, GLint t, GLint r, GLint q) {
    const char *_name = "glTexCoord4i";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glTexCoord4i(GLint s, GLint t, GLint r, GLint q) {
    PFN_GLTEXCOORD4I _ptr;
    _ptr = (PFN_GLTEXCOORD4I)_getPublicProcAddress("glTexCoord4i");
    if (!_ptr) {
        _ptr = &_fail_glTexCoord4i;
    }
    _glTexCoord4i = _ptr;
    _glTexCoord4i(s, t, r, q);
}

PFN_GLTEXCOORD4I _glTexCoord4i = &_get_glTexCoord4i;

static void APIENTRY _fail_glTexCoord4iv(const GLint * v) {
    const char *_name = "glTexCoord4iv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glTexCoord4iv(const GLint * v) {
    PFN_GLTEXCOORD4IV _ptr;
    _ptr = (PFN_GLTEXCOORD4IV)_getPublicProcAddress("glTexCoord4iv");
    if (!_ptr) {
        _ptr = &_fail_glTexCoord4iv;
    }
    _glTexCoord4iv = _ptr;
    _glTexCoord4iv(v);
}

PFN_GLTEXCOORD4IV _glTexCoord4iv = &_get_glTexCoord4iv;

static void APIENTRY _fail_glTexCoord4s(GLshort s, GLshort t, GLshort r, GLshort q) {
    const char *_name = "glTexCoord4s";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glTexCoord4s(GLshort s, GLshort t, GLshort r, GLshort q) {
    PFN_GLTEXCOORD4S _ptr;
    _ptr = (PFN_GLTEXCOORD4S)_getPublicProcAddress("glTexCoord4s");
    if (!_ptr) {
        _ptr = &_fail_glTexCoord4s;
    }
    _glTexCoord4s = _ptr;
    _glTexCoord4s(s, t, r, q);
}

PFN_GLTEXCOORD4S _glTexCoord4s = &_get_glTexCoord4s;

static void APIENTRY _fail_glTexCoord4sv(const GLshort * v) {
    const char *_name = "glTexCoord4sv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glTexCoord4sv(const GLshort * v) {
    PFN_GLTEXCOORD4SV _ptr;
    _ptr = (PFN_GLTEXCOORD4SV)_getPublicProcAddress("glTexCoord4sv");
    if (!_ptr) {
        _ptr = &_fail_glTexCoord4sv;
    }
    _glTexCoord4sv = _ptr;
    _glTexCoord4sv(v);
}

PFN_GLTEXCOORD4SV _glTexCoord4sv = &_get_glTexCoord4sv;

static void APIENTRY _fail_glVertex2d(GLdouble x, GLdouble y) {
    const char *_name = "glVertex2d";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glVertex2d(GLdouble x, GLdouble y) {
    PFN_GLVERTEX2D _ptr;
    _ptr = (PFN_GLVERTEX2D)_getPublicProcAddress("glVertex2d");
    if (!_ptr) {
        _ptr = &_fail_glVertex2d;
    }
    _glVertex2d = _ptr;
    _glVertex2d(x, y);
}

PFN_GLVERTEX2D _glVertex2d = &_get_glVertex2d;

static void APIENTRY _fail_glVertex2dv(const GLdouble * v) {
    const char *_name = "glVertex2dv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glVertex2dv(const GLdouble * v) {
    PFN_GLVERTEX2DV _ptr;
    _ptr = (PFN_GLVERTEX2DV)_getPublicProcAddress("glVertex2dv");
    if (!_ptr) {
        _ptr = &_fail_glVertex2dv;
    }
    _glVertex2dv = _ptr;
    _glVertex2dv(v);
}

PFN_GLVERTEX2DV _glVertex2dv = &_get_glVertex2dv;

static void APIENTRY _fail_glVertex2f(GLfloat x, GLfloat y) {
    const char *_name = "glVertex2f";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glVertex2f(GLfloat x, GLfloat y) {
    PFN_GLVERTEX2F _ptr;
    _ptr = (PFN_GLVERTEX2F)_getPublicProcAddress("glVertex2f");
    if (!_ptr) {
        _ptr = &_fail_glVertex2f;
    }
    _glVertex2f = _ptr;
    _glVertex2f(x, y);
}

PFN_GLVERTEX2F _glVertex2f = &_get_glVertex2f;

static void APIENTRY _fail_glVertex2fv(const GLfloat * v) {
    const char *_name = "glVertex2fv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glVertex2fv(const GLfloat * v) {
    PFN_GLVERTEX2FV _ptr;
    _ptr = (PFN_GLVERTEX2FV)_getPublicProcAddress("glVertex2fv");
    if (!_ptr) {
        _ptr = &_fail_glVertex2fv;
    }
    _glVertex2fv = _ptr;
    _glVertex2fv(v);
}

PFN_GLVERTEX2FV _glVertex2fv = &_get_glVertex2fv;

static void APIENTRY _fail_glVertex2i(GLint x, GLint y) {
    const char *_name = "glVertex2i";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glVertex2i(GLint x, GLint y) {
    PFN_GLVERTEX2I _ptr;
    _ptr = (PFN_GLVERTEX2I)_getPublicProcAddress("glVertex2i");
    if (!_ptr) {
        _ptr = &_fail_glVertex2i;
    }
    _glVertex2i = _ptr;
    _glVertex2i(x, y);
}

PFN_GLVERTEX2I _glVertex2i = &_get_glVertex2i;

static void APIENTRY _fail_glVertex2iv(const GLint * v) {
    const char *_name = "glVertex2iv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glVertex2iv(const GLint * v) {
    PFN_GLVERTEX2IV _ptr;
    _ptr = (PFN_GLVERTEX2IV)_getPublicProcAddress("glVertex2iv");
    if (!_ptr) {
        _ptr = &_fail_glVertex2iv;
    }
    _glVertex2iv = _ptr;
    _glVertex2iv(v);
}

PFN_GLVERTEX2IV _glVertex2iv = &_get_glVertex2iv;

static void APIENTRY _fail_glVertex2s(GLshort x, GLshort y) {
    const char *_name = "glVertex2s";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glVertex2s(GLshort x, GLshort y) {
    PFN_GLVERTEX2S _ptr;
    _ptr = (PFN_GLVERTEX2S)_getPublicProcAddress("glVertex2s");
    if (!_ptr) {
        _ptr = &_fail_glVertex2s;
    }
    _glVertex2s = _ptr;
    _glVertex2s(x, y);
}

PFN_GLVERTEX2S _glVertex2s = &_get_glVertex2s;

static void APIENTRY _fail_glVertex2sv(const GLshort * v) {
    const char *_name = "glVertex2sv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glVertex2sv(const GLshort * v) {
    PFN_GLVERTEX2SV _ptr;
    _ptr = (PFN_GLVERTEX2SV)_getPublicProcAddress("glVertex2sv");
    if (!_ptr) {
        _ptr = &_fail_glVertex2sv;
    }
    _glVertex2sv = _ptr;
    _glVertex2sv(v);
}

PFN_GLVERTEX2SV _glVertex2sv = &_get_glVertex2sv;

static void APIENTRY _fail_glVertex3d(GLdouble x, GLdouble y, GLdouble z) {
    const char *_name = "glVertex3d";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glVertex3d(GLdouble x, GLdouble y, GLdouble z) {
    PFN_GLVERTEX3D _ptr;
    _ptr = (PFN_GLVERTEX3D)_getPublicProcAddress("glVertex3d");
    if (!_ptr) {
        _ptr = &_fail_glVertex3d;
    }
    _glVertex3d = _ptr;
    _glVertex3d(x, y, z);
}

PFN_GLVERTEX3D _glVertex3d = &_get_glVertex3d;

static void APIENTRY _fail_glVertex3dv(const GLdouble * v) {
    const char *_name = "glVertex3dv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glVertex3dv(const GLdouble * v) {
    PFN_GLVERTEX3DV _ptr;
    _ptr = (PFN_GLVERTEX3DV)_getPublicProcAddress("glVertex3dv");
    if (!_ptr) {
        _ptr = &_fail_glVertex3dv;
    }
    _glVertex3dv = _ptr;
    _glVertex3dv(v);
}

PFN_GLVERTEX3DV _glVertex3dv = &_get_glVertex3dv;

static void APIENTRY _fail_glVertex3f(GLfloat x, GLfloat y, GLfloat z) {
    const char *_name = "glVertex3f";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glVertex3f(GLfloat x, GLfloat y, GLfloat z) {
    PFN_GLVERTEX3F _ptr;
    _ptr = (PFN_GLVERTEX3F)_getPublicProcAddress("glVertex3f");
    if (!_ptr) {
        _ptr = &_fail_glVertex3f;
    }
    _glVertex3f = _ptr;
    _glVertex3f(x, y, z);
}

PFN_GLVERTEX3F _glVertex3f = &_get_glVertex3f;

static void APIENTRY _fail_glVertex3fv(const GLfloat * v) {
    const char *_name = "glVertex3fv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glVertex3fv(const GLfloat * v) {
    PFN_GLVERTEX3FV _ptr;
    _ptr = (PFN_GLVERTEX3FV)_getPublicProcAddress("glVertex3fv");
    if (!_ptr) {
        _ptr = &_fail_glVertex3fv;
    }
    _glVertex3fv = _ptr;
    _glVertex3fv(v);
}

PFN_GLVERTEX3FV _glVertex3fv = &_get_glVertex3fv;

static void APIENTRY _fail_glVertex3i(GLint x, GLint y, GLint z) {
    const char *_name = "glVertex3i";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glVertex3i(GLint x, GLint y, GLint z) {
    PFN_GLVERTEX3I _ptr;
    _ptr = (PFN_GLVERTEX3I)_getPublicProcAddress("glVertex3i");
    if (!_ptr) {
        _ptr = &_fail_glVertex3i;
    }
    _glVertex3i = _ptr;
    _glVertex3i(x, y, z);
}

PFN_GLVERTEX3I _glVertex3i = &_get_glVertex3i;

static void APIENTRY _fail_glVertex3iv(const GLint * v) {
    const char *_name = "glVertex3iv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glVertex3iv(const GLint * v) {
    PFN_GLVERTEX3IV _ptr;
    _ptr = (PFN_GLVERTEX3IV)_getPublicProcAddress("glVertex3iv");
    if (!_ptr) {
        _ptr = &_fail_glVertex3iv;
    }
    _glVertex3iv = _ptr;
    _glVertex3iv(v);
}

PFN_GLVERTEX3IV _glVertex3iv = &_get_glVertex3iv;

static void APIENTRY _fail_glVertex3s(GLshort x, GLshort y, GLshort z) {
    const char *_name = "glVertex3s";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glVertex3s(GLshort x, GLshort y, GLshort z) {
    PFN_GLVERTEX3S _ptr;
    _ptr = (PFN_GLVERTEX3S)_getPublicProcAddress("glVertex3s");
    if (!_ptr) {
        _ptr = &_fail_glVertex3s;
    }
    _glVertex3s = _ptr;
    _glVertex3s(x, y, z);
}

PFN_GLVERTEX3S _glVertex3s = &_get_glVertex3s;

static void APIENTRY _fail_glVertex3sv(const GLshort * v) {
    const char *_name = "glVertex3sv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glVertex3sv(const GLshort * v) {
    PFN_GLVERTEX3SV _ptr;
    _ptr = (PFN_GLVERTEX3SV)_getPublicProcAddress("glVertex3sv");
    if (!_ptr) {
        _ptr = &_fail_glVertex3sv;
    }
    _glVertex3sv = _ptr;
    _glVertex3sv(v);
}

PFN_GLVERTEX3SV _glVertex3sv = &_get_glVertex3sv;

static void APIENTRY _fail_glVertex4d(GLdouble x, GLdouble y, GLdouble z, GLdouble w) {
    const char *_name = "glVertex4d";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glVertex4d(GLdouble x, GLdouble y, GLdouble z, GLdouble w) {
    PFN_GLVERTEX4D _ptr;
    _ptr = (PFN_GLVERTEX4D)_getPublicProcAddress("glVertex4d");
    if (!_ptr) {
        _ptr = &_fail_glVertex4d;
    }
    _glVertex4d = _ptr;
    _glVertex4d(x, y, z, w);
}

PFN_GLVERTEX4D _glVertex4d = &_get_glVertex4d;

static void APIENTRY _fail_glVertex4dv(const GLdouble * v) {
    const char *_name = "glVertex4dv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glVertex4dv(const GLdouble * v) {
    PFN_GLVERTEX4DV _ptr;
    _ptr = (PFN_GLVERTEX4DV)_getPublicProcAddress("glVertex4dv");
    if (!_ptr) {
        _ptr = &_fail_glVertex4dv;
    }
    _glVertex4dv = _ptr;
    _glVertex4dv(v);
}

PFN_GLVERTEX4DV _glVertex4dv = &_get_glVertex4dv;

static void APIENTRY _fail_glVertex4f(GLfloat x, GLfloat y, GLfloat z, GLfloat w) {
    const char *_name = "glVertex4f";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glVertex4f(GLfloat x, GLfloat y, GLfloat z, GLfloat w) {
    PFN_GLVERTEX4F _ptr;
    _ptr = (PFN_GLVERTEX4F)_getPublicProcAddress("glVertex4f");
    if (!_ptr) {
        _ptr = &_fail_glVertex4f;
    }
    _glVertex4f = _ptr;
    _glVertex4f(x, y, z, w);
}

PFN_GLVERTEX4F _glVertex4f = &_get_glVertex4f;

static void APIENTRY _fail_glVertex4fv(const GLfloat * v) {
    const char *_name = "glVertex4fv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glVertex4fv(const GLfloat * v) {
    PFN_GLVERTEX4FV _ptr;
    _ptr = (PFN_GLVERTEX4FV)_getPublicProcAddress("glVertex4fv");
    if (!_ptr) {
        _ptr = &_fail_glVertex4fv;
    }
    _glVertex4fv = _ptr;
    _glVertex4fv(v);
}

PFN_GLVERTEX4FV _glVertex4fv = &_get_glVertex4fv;

static void APIENTRY _fail_glVertex4i(GLint x, GLint y, GLint z, GLint w) {
    const char *_name = "glVertex4i";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glVertex4i(GLint x, GLint y, GLint z, GLint w) {
    PFN_GLVERTEX4I _ptr;
    _ptr = (PFN_GLVERTEX4I)_getPublicProcAddress("glVertex4i");
    if (!_ptr) {
        _ptr = &_fail_glVertex4i;
    }
    _glVertex4i = _ptr;
    _glVertex4i(x, y, z, w);
}

PFN_GLVERTEX4I _glVertex4i = &_get_glVertex4i;

static void APIENTRY _fail_glVertex4iv(const GLint * v) {
    const char *_name = "glVertex4iv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glVertex4iv(const GLint * v) {
    PFN_GLVERTEX4IV _ptr;
    _ptr = (PFN_GLVERTEX4IV)_getPublicProcAddress("glVertex4iv");
    if (!_ptr) {
        _ptr = &_fail_glVertex4iv;
    }
    _glVertex4iv = _ptr;
    _glVertex4iv(v);
}

PFN_GLVERTEX4IV _glVertex4iv = &_get_glVertex4iv;

static void APIENTRY _fail_glVertex4s(GLshort x, GLshort y, GLshort z, GLshort w) {
    const char *_name = "glVertex4s";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glVertex4s(GLshort x, GLshort y, GLshort z, GLshort w) {
    PFN_GLVERTEX4S _ptr;
    _ptr = (PFN_GLVERTEX4S)_getPublicProcAddress("glVertex4s");
    if (!_ptr) {
        _ptr = &_fail_glVertex4s;
    }
    _glVertex4s = _ptr;
    _glVertex4s(x, y, z, w);
}

PFN_GLVERTEX4S _glVertex4s = &_get_glVertex4s;

static void APIENTRY _fail_glVertex4sv(const GLshort * v) {
    const char *_name = "glVertex4sv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glVertex4sv(const GLshort * v) {
    PFN_GLVERTEX4SV _ptr;
    _ptr = (PFN_GLVERTEX4SV)_getPublicProcAddress("glVertex4sv");
    if (!_ptr) {
        _ptr = &_fail_glVertex4sv;
    }
    _glVertex4sv = _ptr;
    _glVertex4sv(v);
}

PFN_GLVERTEX4SV _glVertex4sv = &_get_glVertex4sv;

static void APIENTRY _fail_glClipPlane(GLenum plane, const GLdouble * equation) {
    const char *_name = "glClipPlane";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glClipPlane(GLenum plane, const GLdouble * equation) {
    PFN_GLCLIPPLANE _ptr;
    _ptr = (PFN_GLCLIPPLANE)_getPublicProcAddress("glClipPlane");
    if (!_ptr) {
        _ptr = &_fail_glClipPlane;
    }
    _glClipPlane = _ptr;
    _glClipPlane(plane, equation);
}

PFN_GLCLIPPLANE _glClipPlane = &_get_glClipPlane;

static void APIENTRY _fail_glColorMaterial(GLenum face, GLenum mode) {
    const char *_name = "glColorMaterial";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glColorMaterial(GLenum face, GLenum mode) {
    PFN_GLCOLORMATERIAL _ptr;
    _ptr = (PFN_GLCOLORMATERIAL)_getPublicProcAddress("glColorMaterial");
    if (!_ptr) {
        _ptr = &_fail_glColorMaterial;
    }
    _glColorMaterial = _ptr;
    _glColorMaterial(face, mode);
}

PFN_GLCOLORMATERIAL _glColorMaterial = &_get_glColorMaterial;

static void APIENTRY _fail_glFogf(GLenum pname, GLfloat param) {
    const char *_name = "glFogf";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glFogf(GLenum pname, GLfloat param) {
    PFN_GLFOGF _ptr;
    _ptr = (PFN_GLFOGF)_getPublicProcAddress("glFogf");
    if (!_ptr) {
        _ptr = &_fail_glFogf;
    }
    _glFogf = _ptr;
    _glFogf(pname, param);
}

PFN_GLFOGF _glFogf = &_get_glFogf;

static void APIENTRY _fail_glFogfv(GLenum pname, const GLfloat * params) {
    const char *_name = "glFogfv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glFogfv(GLenum pname, const GLfloat * params) {
    PFN_GLFOGFV _ptr;
    _ptr = (PFN_GLFOGFV)_getPublicProcAddress("glFogfv");
    if (!_ptr) {
        _ptr = &_fail_glFogfv;
    }
    _glFogfv = _ptr;
    _glFogfv(pname, params);
}

PFN_GLFOGFV _glFogfv = &_get_glFogfv;

static void APIENTRY _fail_glFogi(GLenum pname, GLint param) {
    const char *_name = "glFogi";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glFogi(GLenum pname, GLint param) {
    PFN_GLFOGI _ptr;
    _ptr = (PFN_GLFOGI)_getPublicProcAddress("glFogi");
    if (!_ptr) {
        _ptr = &_fail_glFogi;
    }
    _glFogi = _ptr;
    _glFogi(pname, param);
}

PFN_GLFOGI _glFogi = &_get_glFogi;

static void APIENTRY _fail_glFogiv(GLenum pname, const GLint * params) {
    const char *_name = "glFogiv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glFogiv(GLenum pname, const GLint * params) {
    PFN_GLFOGIV _ptr;
    _ptr = (PFN_GLFOGIV)_getPublicProcAddress("glFogiv");
    if (!_ptr) {
        _ptr = &_fail_glFogiv;
    }
    _glFogiv = _ptr;
    _glFogiv(pname, params);
}

PFN_GLFOGIV _glFogiv = &_get_glFogiv;

static void APIENTRY _fail_glLightf(GLenum light, GLenum pname, GLfloat param) {
    const char *_name = "glLightf";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glLightf(GLenum light, GLenum pname, GLfloat param) {
    PFN_GLLIGHTF _ptr;
    _ptr = (PFN_GLLIGHTF)_getPublicProcAddress("glLightf");
    if (!_ptr) {
        _ptr = &_fail_glLightf;
    }
    _glLightf = _ptr;
    _glLightf(light, pname, param);
}

PFN_GLLIGHTF _glLightf = &_get_glLightf;

static void APIENTRY _fail_glLightfv(GLenum light, GLenum pname, const GLfloat * params) {
    const char *_name = "glLightfv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glLightfv(GLenum light, GLenum pname, const GLfloat * params) {
    PFN_GLLIGHTFV _ptr;
    _ptr = (PFN_GLLIGHTFV)_getPublicProcAddress("glLightfv");
    if (!_ptr) {
        _ptr = &_fail_glLightfv;
    }
    _glLightfv = _ptr;
    _glLightfv(light, pname, params);
}

PFN_GLLIGHTFV _glLightfv = &_get_glLightfv;

static void APIENTRY _fail_glLighti(GLenum light, GLenum pname, GLint param) {
    const char *_name = "glLighti";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glLighti(GLenum light, GLenum pname, GLint param) {
    PFN_GLLIGHTI _ptr;
    _ptr = (PFN_GLLIGHTI)_getPublicProcAddress("glLighti");
    if (!_ptr) {
        _ptr = &_fail_glLighti;
    }
    _glLighti = _ptr;
    _glLighti(light, pname, param);
}

PFN_GLLIGHTI _glLighti = &_get_glLighti;

static void APIENTRY _fail_glLightiv(GLenum light, GLenum pname, const GLint * params) {
    const char *_name = "glLightiv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glLightiv(GLenum light, GLenum pname, const GLint * params) {
    PFN_GLLIGHTIV _ptr;
    _ptr = (PFN_GLLIGHTIV)_getPublicProcAddress("glLightiv");
    if (!_ptr) {
        _ptr = &_fail_glLightiv;
    }
    _glLightiv = _ptr;
    _glLightiv(light, pname, params);
}

PFN_GLLIGHTIV _glLightiv = &_get_glLightiv;

static void APIENTRY _fail_glLightModelf(GLenum pname, GLfloat param) {
    const char *_name = "glLightModelf";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glLightModelf(GLenum pname, GLfloat param) {
    PFN_GLLIGHTMODELF _ptr;
    _ptr = (PFN_GLLIGHTMODELF)_getPublicProcAddress("glLightModelf");
    if (!_ptr) {
        _ptr = &_fail_glLightModelf;
    }
    _glLightModelf = _ptr;
    _glLightModelf(pname, param);
}

PFN_GLLIGHTMODELF _glLightModelf = &_get_glLightModelf;

static void APIENTRY _fail_glLightModelfv(GLenum pname, const GLfloat * params) {
    const char *_name = "glLightModelfv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glLightModelfv(GLenum pname, const GLfloat * params) {
    PFN_GLLIGHTMODELFV _ptr;
    _ptr = (PFN_GLLIGHTMODELFV)_getPublicProcAddress("glLightModelfv");
    if (!_ptr) {
        _ptr = &_fail_glLightModelfv;
    }
    _glLightModelfv = _ptr;
    _glLightModelfv(pname, params);
}

PFN_GLLIGHTMODELFV _glLightModelfv = &_get_glLightModelfv;

static void APIENTRY _fail_glLightModeli(GLenum pname, GLint param) {
    const char *_name = "glLightModeli";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glLightModeli(GLenum pname, GLint param) {
    PFN_GLLIGHTMODELI _ptr;
    _ptr = (PFN_GLLIGHTMODELI)_getPublicProcAddress("glLightModeli");
    if (!_ptr) {
        _ptr = &_fail_glLightModeli;
    }
    _glLightModeli = _ptr;
    _glLightModeli(pname, param);
}

PFN_GLLIGHTMODELI _glLightModeli = &_get_glLightModeli;

static void APIENTRY _fail_glLightModeliv(GLenum pname, const GLint * params) {
    const char *_name = "glLightModeliv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glLightModeliv(GLenum pname, const GLint * params) {
    PFN_GLLIGHTMODELIV _ptr;
    _ptr = (PFN_GLLIGHTMODELIV)_getPublicProcAddress("glLightModeliv");
    if (!_ptr) {
        _ptr = &_fail_glLightModeliv;
    }
    _glLightModeliv = _ptr;
    _glLightModeliv(pname, params);
}

PFN_GLLIGHTMODELIV _glLightModeliv = &_get_glLightModeliv;

static void APIENTRY _fail_glLineStipple(GLint factor, GLushort pattern) {
    const char *_name = "glLineStipple";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glLineStipple(GLint factor, GLushort pattern) {
    PFN_GLLINESTIPPLE _ptr;
    _ptr = (PFN_GLLINESTIPPLE)_getPublicProcAddress("glLineStipple");
    if (!_ptr) {
        _ptr = &_fail_glLineStipple;
    }
    _glLineStipple = _ptr;
    _glLineStipple(factor, pattern);
}

PFN_GLLINESTIPPLE _glLineStipple = &_get_glLineStipple;

static void APIENTRY _fail_glMaterialf(GLenum face, GLenum pname, GLfloat param) {
    const char *_name = "glMaterialf";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glMaterialf(GLenum face, GLenum pname, GLfloat param) {
    PFN_GLMATERIALF _ptr;
    _ptr = (PFN_GLMATERIALF)_getPublicProcAddress("glMaterialf");
    if (!_ptr) {
        _ptr = &_fail_glMaterialf;
    }
    _glMaterialf = _ptr;
    _glMaterialf(face, pname, param);
}

PFN_GLMATERIALF _glMaterialf = &_get_glMaterialf;

static void APIENTRY _fail_glMaterialfv(GLenum face, GLenum pname, const GLfloat * params) {
    const char *_name = "glMaterialfv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glMaterialfv(GLenum face, GLenum pname, const GLfloat * params) {
    PFN_GLMATERIALFV _ptr;
    _ptr = (PFN_GLMATERIALFV)_getPublicProcAddress("glMaterialfv");
    if (!_ptr) {
        _ptr = &_fail_glMaterialfv;
    }
    _glMaterialfv = _ptr;
    _glMaterialfv(face, pname, params);
}

PFN_GLMATERIALFV _glMaterialfv = &_get_glMaterialfv;

static void APIENTRY _fail_glMateriali(GLenum face, GLenum pname, GLint param) {
    const char *_name = "glMateriali";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glMateriali(GLenum face, GLenum pname, GLint param) {
    PFN_GLMATERIALI _ptr;
    _ptr = (PFN_GLMATERIALI)_getPublicProcAddress("glMateriali");
    if (!_ptr) {
        _ptr = &_fail_glMateriali;
    }
    _glMateriali = _ptr;
    _glMateriali(face, pname, param);
}

PFN_GLMATERIALI _glMateriali = &_get_glMateriali;

static void APIENTRY _fail_glMaterialiv(GLenum face, GLenum pname, const GLint * params) {
    const char *_name = "glMaterialiv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glMaterialiv(GLenum face, GLenum pname, const GLint * params) {
    PFN_GLMATERIALIV _ptr;
    _ptr = (PFN_GLMATERIALIV)_getPublicProcAddress("glMaterialiv");
    if (!_ptr) {
        _ptr = &_fail_glMaterialiv;
    }
    _glMaterialiv = _ptr;
    _glMaterialiv(face, pname, params);
}

PFN_GLMATERIALIV _glMaterialiv = &_get_glMaterialiv;

static void APIENTRY _fail_glPolygonStipple(const GLubyte * mask) {
    const char *_name = "glPolygonStipple";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glPolygonStipple(const GLubyte * mask) {
    PFN_GLPOLYGONSTIPPLE _ptr;
    _ptr = (PFN_GLPOLYGONSTIPPLE)_getPublicProcAddress("glPolygonStipple");
    if (!_ptr) {
        _ptr = &_fail_glPolygonStipple;
    }
    _glPolygonStipple = _ptr;
    _glPolygonStipple(mask);
}

PFN_GLPOLYGONSTIPPLE _glPolygonStipple = &_get_glPolygonStipple;

static void APIENTRY _fail_glShadeModel(GLenum mode) {
    const char *_name = "glShadeModel";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glShadeModel(GLenum mode) {
    PFN_GLSHADEMODEL _ptr;
    _ptr = (PFN_GLSHADEMODEL)_getPublicProcAddress("glShadeModel");
    if (!_ptr) {
        _ptr = &_fail_glShadeModel;
    }
    _glShadeModel = _ptr;
    _glShadeModel(mode);
}

PFN_GLSHADEMODEL _glShadeModel = &_get_glShadeModel;

static void APIENTRY _fail_glTexEnvf(GLenum target, GLenum pname, GLfloat param) {
    const char *_name = "glTexEnvf";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glTexEnvf(GLenum target, GLenum pname, GLfloat param) {
    PFN_GLTEXENVF _ptr;
    _ptr = (PFN_GLTEXENVF)_getPublicProcAddress("glTexEnvf");
    if (!_ptr) {
        _ptr = &_fail_glTexEnvf;
    }
    _glTexEnvf = _ptr;
    _glTexEnvf(target, pname, param);
}

PFN_GLTEXENVF _glTexEnvf = &_get_glTexEnvf;

static void APIENTRY _fail_glTexEnvfv(GLenum target, GLenum pname, const GLfloat * params) {
    const char *_name = "glTexEnvfv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glTexEnvfv(GLenum target, GLenum pname, const GLfloat * params) {
    PFN_GLTEXENVFV _ptr;
    _ptr = (PFN_GLTEXENVFV)_getPublicProcAddress("glTexEnvfv");
    if (!_ptr) {
        _ptr = &_fail_glTexEnvfv;
    }
    _glTexEnvfv = _ptr;
    _glTexEnvfv(target, pname, params);
}

PFN_GLTEXENVFV _glTexEnvfv = &_get_glTexEnvfv;

static void APIENTRY _fail_glTexEnvi(GLenum target, GLenum pname, GLint param) {
    const char *_name = "glTexEnvi";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glTexEnvi(GLenum target, GLenum pname, GLint param) {
    PFN_GLTEXENVI _ptr;
    _ptr = (PFN_GLTEXENVI)_getPublicProcAddress("glTexEnvi");
    if (!_ptr) {
        _ptr = &_fail_glTexEnvi;
    }
    _glTexEnvi = _ptr;
    _glTexEnvi(target, pname, param);
}

PFN_GLTEXENVI _glTexEnvi = &_get_glTexEnvi;

static void APIENTRY _fail_glTexEnviv(GLenum target, GLenum pname, const GLint * params) {
    const char *_name = "glTexEnviv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glTexEnviv(GLenum target, GLenum pname, const GLint * params) {
    PFN_GLTEXENVIV _ptr;
    _ptr = (PFN_GLTEXENVIV)_getPublicProcAddress("glTexEnviv");
    if (!_ptr) {
        _ptr = &_fail_glTexEnviv;
    }
    _glTexEnviv = _ptr;
    _glTexEnviv(target, pname, params);
}

PFN_GLTEXENVIV _glTexEnviv = &_get_glTexEnviv;

static void APIENTRY _fail_glTexGend(GLenum coord, GLenum pname, GLdouble param) {
    const char *_name = "glTexGend";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glTexGend(GLenum coord, GLenum pname, GLdouble param) {
    PFN_GLTEXGEND _ptr;
    _ptr = (PFN_GLTEXGEND)_getPublicProcAddress("glTexGend");
    if (!_ptr) {
        _ptr = &_fail_glTexGend;
    }
    _glTexGend = _ptr;
    _glTexGend(coord, pname, param);
}

PFN_GLTEXGEND _glTexGend = &_get_glTexGend;

static void APIENTRY _fail_glTexGendv(GLenum coord, GLenum pname, const GLdouble * params) {
    const char *_name = "glTexGendv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glTexGendv(GLenum coord, GLenum pname, const GLdouble * params) {
    PFN_GLTEXGENDV _ptr;
    _ptr = (PFN_GLTEXGENDV)_getPublicProcAddress("glTexGendv");
    if (!_ptr) {
        _ptr = &_fail_glTexGendv;
    }
    _glTexGendv = _ptr;
    _glTexGendv(coord, pname, params);
}

PFN_GLTEXGENDV _glTexGendv = &_get_glTexGendv;

static void APIENTRY _fail_glTexGenf(GLenum coord, GLenum pname, GLfloat param) {
    const char *_name = "glTexGenf";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glTexGenf(GLenum coord, GLenum pname, GLfloat param) {
    PFN_GLTEXGENF _ptr;
    _ptr = (PFN_GLTEXGENF)_getPublicProcAddress("glTexGenf");
    if (!_ptr) {
        _ptr = &_fail_glTexGenf;
    }
    _glTexGenf = _ptr;
    _glTexGenf(coord, pname, param);
}

PFN_GLTEXGENF _glTexGenf = &_get_glTexGenf;

static void APIENTRY _fail_glTexGenfv(GLenum coord, GLenum pname, const GLfloat * params) {
    const char *_name = "glTexGenfv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glTexGenfv(GLenum coord, GLenum pname, const GLfloat * params) {
    PFN_GLTEXGENFV _ptr;
    _ptr = (PFN_GLTEXGENFV)_getPublicProcAddress("glTexGenfv");
    if (!_ptr) {
        _ptr = &_fail_glTexGenfv;
    }
    _glTexGenfv = _ptr;
    _glTexGenfv(coord, pname, params);
}

PFN_GLTEXGENFV _glTexGenfv = &_get_glTexGenfv;

static void APIENTRY _fail_glTexGeni(GLenum coord, GLenum pname, GLint param) {
    const char *_name = "glTexGeni";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glTexGeni(GLenum coord, GLenum pname, GLint param) {
    PFN_GLTEXGENI _ptr;
    _ptr = (PFN_GLTEXGENI)_getPublicProcAddress("glTexGeni");
    if (!_ptr) {
        _ptr = &_fail_glTexGeni;
    }
    _glTexGeni = _ptr;
    _glTexGeni(coord, pname, param);
}

PFN_GLTEXGENI _glTexGeni = &_get_glTexGeni;

static void APIENTRY _fail_glTexGeniv(GLenum coord, GLenum pname, const GLint * params) {
    const char *_name = "glTexGeniv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glTexGeniv(GLenum coord, GLenum pname, const GLint * params) {
    PFN_GLTEXGENIV _ptr;
    _ptr = (PFN_GLTEXGENIV)_getPublicProcAddress("glTexGeniv");
    if (!_ptr) {
        _ptr = &_fail_glTexGeniv;
    }
    _glTexGeniv = _ptr;
    _glTexGeniv(coord, pname, params);
}

PFN_GLTEXGENIV _glTexGeniv = &_get_glTexGeniv;

static void APIENTRY _fail_glFeedbackBuffer(GLsizei size, GLenum type, GLfloat * buffer) {
    const char *_name = "glFeedbackBuffer";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glFeedbackBuffer(GLsizei size, GLenum type, GLfloat * buffer) {
    PFN_GLFEEDBACKBUFFER _ptr;
    _ptr = (PFN_GLFEEDBACKBUFFER)_getPublicProcAddress("glFeedbackBuffer");
    if (!_ptr) {
        _ptr = &_fail_glFeedbackBuffer;
    }
    _glFeedbackBuffer = _ptr;
    _glFeedbackBuffer(size, type, buffer);
}

PFN_GLFEEDBACKBUFFER _glFeedbackBuffer = &_get_glFeedbackBuffer;

static void APIENTRY _fail_glSelectBuffer(GLsizei size, GLuint * buffer) {
    const char *_name = "glSelectBuffer";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glSelectBuffer(GLsizei size, GLuint * buffer) {
    PFN_GLSELECTBUFFER _ptr;
    _ptr = (PFN_GLSELECTBUFFER)_getPublicProcAddress("glSelectBuffer");
    if (!_ptr) {
        _ptr = &_fail_glSelectBuffer;
    }
    _glSelectBuffer = _ptr;
    _glSelectBuffer(size, buffer);
}

PFN_GLSELECTBUFFER _glSelectBuffer = &_get_glSelectBuffer;

static GLint APIENTRY _fail_glRenderMode(GLenum mode) {
    const char *_name = "glRenderMode";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static GLint APIENTRY _get_glRenderMode(GLenum mode) {
    PFN_GLRENDERMODE _ptr;
    _ptr = (PFN_GLRENDERMODE)_getPublicProcAddress("glRenderMode");
    if (!_ptr) {
        _ptr = &_fail_glRenderMode;
    }
    _glRenderMode = _ptr;
    return _glRenderMode(mode);
}

PFN_GLRENDERMODE _glRenderMode = &_get_glRenderMode;

static void APIENTRY _fail_glInitNames(void) {
    const char *_name = "glInitNames";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glInitNames(void) {
    PFN_GLINITNAMES _ptr;
    _ptr = (PFN_GLINITNAMES)_getPublicProcAddress("glInitNames");
    if (!_ptr) {
        _ptr = &_fail_glInitNames;
    }
    _glInitNames = _ptr;
    _glInitNames();
}

PFN_GLINITNAMES _glInitNames = &_get_glInitNames;

static void APIENTRY _fail_glLoadName(GLuint name) {
    const char *_name = "glLoadName";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glLoadName(GLuint name) {
    PFN_GLLOADNAME _ptr;
    _ptr = (PFN_GLLOADNAME)_getPublicProcAddress("glLoadName");
    if (!_ptr) {
        _ptr = &_fail_glLoadName;
    }
    _glLoadName = _ptr;
    _glLoadName(name);
}

PFN_GLLOADNAME _glLoadName = &_get_glLoadName;

static void APIENTRY _fail_glPassThrough(GLfloat token) {
    const char *_name = "glPassThrough";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glPassThrough(GLfloat token) {
    PFN_GLPASSTHROUGH _ptr;
    _ptr = (PFN_GLPASSTHROUGH)_getPublicProcAddress("glPassThrough");
    if (!_ptr) {
        _ptr = &_fail_glPassThrough;
    }
    _glPassThrough = _ptr;
    _glPassThrough(token);
}

PFN_GLPASSTHROUGH _glPassThrough = &_get_glPassThrough;

static void APIENTRY _fail_glPopName(void) {
    const char *_name = "glPopName";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glPopName(void) {
    PFN_GLPOPNAME _ptr;
    _ptr = (PFN_GLPOPNAME)_getPublicProcAddress("glPopName");
    if (!_ptr) {
        _ptr = &_fail_glPopName;
    }
    _glPopName = _ptr;
    _glPopName();
}

PFN_GLPOPNAME _glPopName = &_get_glPopName;

static void APIENTRY _fail_glPushName(GLuint name) {
    const char *_name = "glPushName";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glPushName(GLuint name) {
    PFN_GLPUSHNAME _ptr;
    _ptr = (PFN_GLPUSHNAME)_getPublicProcAddress("glPushName");
    if (!_ptr) {
        _ptr = &_fail_glPushName;
    }
    _glPushName = _ptr;
    _glPushName(name);
}

PFN_GLPUSHNAME _glPushName = &_get_glPushName;

static void APIENTRY _fail_glClearAccum(GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha) {
    const char *_name = "glClearAccum";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glClearAccum(GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha) {
    PFN_GLCLEARACCUM _ptr;
    _ptr = (PFN_GLCLEARACCUM)_getPublicProcAddress("glClearAccum");
    if (!_ptr) {
        _ptr = &_fail_glClearAccum;
    }
    _glClearAccum = _ptr;
    _glClearAccum(red, green, blue, alpha);
}

PFN_GLCLEARACCUM _glClearAccum = &_get_glClearAccum;

static void APIENTRY _fail_glClearIndex(GLfloat c) {
    const char *_name = "glClearIndex";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glClearIndex(GLfloat c) {
    PFN_GLCLEARINDEX _ptr;
    _ptr = (PFN_GLCLEARINDEX)_getPublicProcAddress("glClearIndex");
    if (!_ptr) {
        _ptr = &_fail_glClearIndex;
    }
    _glClearIndex = _ptr;
    _glClearIndex(c);
}

PFN_GLCLEARINDEX _glClearIndex = &_get_glClearIndex;

static void APIENTRY _fail_glIndexMask(GLuint mask) {
    const char *_name = "glIndexMask";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glIndexMask(GLuint mask) {
    PFN_GLINDEXMASK _ptr;
    _ptr = (PFN_GLINDEXMASK)_getPublicProcAddress("glIndexMask");
    if (!_ptr) {
        _ptr = &_fail_glIndexMask;
    }
    _glIndexMask = _ptr;
    _glIndexMask(mask);
}

PFN_GLINDEXMASK _glIndexMask = &_get_glIndexMask;

static void APIENTRY _fail_glAccum(GLenum op, GLfloat value) {
    const char *_name = "glAccum";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glAccum(GLenum op, GLfloat value) {
    PFN_GLACCUM _ptr;
    _ptr = (PFN_GLACCUM)_getPublicProcAddress("glAccum");
    if (!_ptr) {
        _ptr = &_fail_glAccum;
    }
    _glAccum = _ptr;
    _glAccum(op, value);
}

PFN_GLACCUM _glAccum = &_get_glAccum;

static void APIENTRY _fail_glPopAttrib(void) {
    const char *_name = "glPopAttrib";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glPopAttrib(void) {
    PFN_GLPOPATTRIB _ptr;
    _ptr = (PFN_GLPOPATTRIB)_getPublicProcAddress("glPopAttrib");
    if (!_ptr) {
        _ptr = &_fail_glPopAttrib;
    }
    _glPopAttrib = _ptr;
    _glPopAttrib();
}

PFN_GLPOPATTRIB _glPopAttrib = &_get_glPopAttrib;

static void APIENTRY _fail_glPushAttrib(GLbitfield mask) {
    const char *_name = "glPushAttrib";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glPushAttrib(GLbitfield mask) {
    PFN_GLPUSHATTRIB _ptr;
    _ptr = (PFN_GLPUSHATTRIB)_getPublicProcAddress("glPushAttrib");
    if (!_ptr) {
        _ptr = &_fail_glPushAttrib;
    }
    _glPushAttrib = _ptr;
    _glPushAttrib(mask);
}

PFN_GLPUSHATTRIB _glPushAttrib = &_get_glPushAttrib;

static void APIENTRY _fail_glMap1d(GLenum target, GLdouble u1, GLdouble u2, GLint stride, GLint order, const GLdouble * points) {
    const char *_name = "glMap1d";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glMap1d(GLenum target, GLdouble u1, GLdouble u2, GLint stride, GLint order, const GLdouble * points) {
    PFN_GLMAP1D _ptr;
    _ptr = (PFN_GLMAP1D)_getPublicProcAddress("glMap1d");
    if (!_ptr) {
        _ptr = &_fail_glMap1d;
    }
    _glMap1d = _ptr;
    _glMap1d(target, u1, u2, stride, order, points);
}

PFN_GLMAP1D _glMap1d = &_get_glMap1d;

static void APIENTRY _fail_glMap1f(GLenum target, GLfloat u1, GLfloat u2, GLint stride, GLint order, const GLfloat * points) {
    const char *_name = "glMap1f";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glMap1f(GLenum target, GLfloat u1, GLfloat u2, GLint stride, GLint order, const GLfloat * points) {
    PFN_GLMAP1F _ptr;
    _ptr = (PFN_GLMAP1F)_getPublicProcAddress("glMap1f");
    if (!_ptr) {
        _ptr = &_fail_glMap1f;
    }
    _glMap1f = _ptr;
    _glMap1f(target, u1, u2, stride, order, points);
}

PFN_GLMAP1F _glMap1f = &_get_glMap1f;

static void APIENTRY _fail_glMap2d(GLenum target, GLdouble u1, GLdouble u2, GLint ustride, GLint uorder, GLdouble v1, GLdouble v2, GLint vstride, GLint vorder, const GLdouble * points) {
    const char *_name = "glMap2d";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glMap2d(GLenum target, GLdouble u1, GLdouble u2, GLint ustride, GLint uorder, GLdouble v1, GLdouble v2, GLint vstride, GLint vorder, const GLdouble * points) {
    PFN_GLMAP2D _ptr;
    _ptr = (PFN_GLMAP2D)_getPublicProcAddress("glMap2d");
    if (!_ptr) {
        _ptr = &_fail_glMap2d;
    }
    _glMap2d = _ptr;
    _glMap2d(target, u1, u2, ustride, uorder, v1, v2, vstride, vorder, points);
}

PFN_GLMAP2D _glMap2d = &_get_glMap2d;

static void APIENTRY _fail_glMap2f(GLenum target, GLfloat u1, GLfloat u2, GLint ustride, GLint uorder, GLfloat v1, GLfloat v2, GLint vstride, GLint vorder, const GLfloat * points) {
    const char *_name = "glMap2f";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glMap2f(GLenum target, GLfloat u1, GLfloat u2, GLint ustride, GLint uorder, GLfloat v1, GLfloat v2, GLint vstride, GLint vorder, const GLfloat * points) {
    PFN_GLMAP2F _ptr;
    _ptr = (PFN_GLMAP2F)_getPublicProcAddress("glMap2f");
    if (!_ptr) {
        _ptr = &_fail_glMap2f;
    }
    _glMap2f = _ptr;
    _glMap2f(target, u1, u2, ustride, uorder, v1, v2, vstride, vorder, points);
}

PFN_GLMAP2F _glMap2f = &_get_glMap2f;

static void APIENTRY _fail_glMapGrid1d(GLint un, GLdouble u1, GLdouble u2) {
    const char *_name = "glMapGrid1d";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glMapGrid1d(GLint un, GLdouble u1, GLdouble u2) {
    PFN_GLMAPGRID1D _ptr;
    _ptr = (PFN_GLMAPGRID1D)_getPublicProcAddress("glMapGrid1d");
    if (!_ptr) {
        _ptr = &_fail_glMapGrid1d;
    }
    _glMapGrid1d = _ptr;
    _glMapGrid1d(un, u1, u2);
}

PFN_GLMAPGRID1D _glMapGrid1d = &_get_glMapGrid1d;

static void APIENTRY _fail_glMapGrid1f(GLint un, GLfloat u1, GLfloat u2) {
    const char *_name = "glMapGrid1f";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glMapGrid1f(GLint un, GLfloat u1, GLfloat u2) {
    PFN_GLMAPGRID1F _ptr;
    _ptr = (PFN_GLMAPGRID1F)_getPublicProcAddress("glMapGrid1f");
    if (!_ptr) {
        _ptr = &_fail_glMapGrid1f;
    }
    _glMapGrid1f = _ptr;
    _glMapGrid1f(un, u1, u2);
}

PFN_GLMAPGRID1F _glMapGrid1f = &_get_glMapGrid1f;

static void APIENTRY _fail_glMapGrid2d(GLint un, GLdouble u1, GLdouble u2, GLint vn, GLdouble v1, GLdouble v2) {
    const char *_name = "glMapGrid2d";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glMapGrid2d(GLint un, GLdouble u1, GLdouble u2, GLint vn, GLdouble v1, GLdouble v2) {
    PFN_GLMAPGRID2D _ptr;
    _ptr = (PFN_GLMAPGRID2D)_getPublicProcAddress("glMapGrid2d");
    if (!_ptr) {
        _ptr = &_fail_glMapGrid2d;
    }
    _glMapGrid2d = _ptr;
    _glMapGrid2d(un, u1, u2, vn, v1, v2);
}

PFN_GLMAPGRID2D _glMapGrid2d = &_get_glMapGrid2d;

static void APIENTRY _fail_glMapGrid2f(GLint un, GLfloat u1, GLfloat u2, GLint vn, GLfloat v1, GLfloat v2) {
    const char *_name = "glMapGrid2f";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glMapGrid2f(GLint un, GLfloat u1, GLfloat u2, GLint vn, GLfloat v1, GLfloat v2) {
    PFN_GLMAPGRID2F _ptr;
    _ptr = (PFN_GLMAPGRID2F)_getPublicProcAddress("glMapGrid2f");
    if (!_ptr) {
        _ptr = &_fail_glMapGrid2f;
    }
    _glMapGrid2f = _ptr;
    _glMapGrid2f(un, u1, u2, vn, v1, v2);
}

PFN_GLMAPGRID2F _glMapGrid2f = &_get_glMapGrid2f;

static void APIENTRY _fail_glEvalCoord1d(GLdouble u) {
    const char *_name = "glEvalCoord1d";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glEvalCoord1d(GLdouble u) {
    PFN_GLEVALCOORD1D _ptr;
    _ptr = (PFN_GLEVALCOORD1D)_getPublicProcAddress("glEvalCoord1d");
    if (!_ptr) {
        _ptr = &_fail_glEvalCoord1d;
    }
    _glEvalCoord1d = _ptr;
    _glEvalCoord1d(u);
}

PFN_GLEVALCOORD1D _glEvalCoord1d = &_get_glEvalCoord1d;

static void APIENTRY _fail_glEvalCoord1dv(const GLdouble * u) {
    const char *_name = "glEvalCoord1dv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glEvalCoord1dv(const GLdouble * u) {
    PFN_GLEVALCOORD1DV _ptr;
    _ptr = (PFN_GLEVALCOORD1DV)_getPublicProcAddress("glEvalCoord1dv");
    if (!_ptr) {
        _ptr = &_fail_glEvalCoord1dv;
    }
    _glEvalCoord1dv = _ptr;
    _glEvalCoord1dv(u);
}

PFN_GLEVALCOORD1DV _glEvalCoord1dv = &_get_glEvalCoord1dv;

static void APIENTRY _fail_glEvalCoord1f(GLfloat u) {
    const char *_name = "glEvalCoord1f";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glEvalCoord1f(GLfloat u) {
    PFN_GLEVALCOORD1F _ptr;
    _ptr = (PFN_GLEVALCOORD1F)_getPublicProcAddress("glEvalCoord1f");
    if (!_ptr) {
        _ptr = &_fail_glEvalCoord1f;
    }
    _glEvalCoord1f = _ptr;
    _glEvalCoord1f(u);
}

PFN_GLEVALCOORD1F _glEvalCoord1f = &_get_glEvalCoord1f;

static void APIENTRY _fail_glEvalCoord1fv(const GLfloat * u) {
    const char *_name = "glEvalCoord1fv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glEvalCoord1fv(const GLfloat * u) {
    PFN_GLEVALCOORD1FV _ptr;
    _ptr = (PFN_GLEVALCOORD1FV)_getPublicProcAddress("glEvalCoord1fv");
    if (!_ptr) {
        _ptr = &_fail_glEvalCoord1fv;
    }
    _glEvalCoord1fv = _ptr;
    _glEvalCoord1fv(u);
}

PFN_GLEVALCOORD1FV _glEvalCoord1fv = &_get_glEvalCoord1fv;

static void APIENTRY _fail_glEvalCoord2d(GLdouble u, GLdouble v) {
    const char *_name = "glEvalCoord2d";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glEvalCoord2d(GLdouble u, GLdouble v) {
    PFN_GLEVALCOORD2D _ptr;
    _ptr = (PFN_GLEVALCOORD2D)_getPublicProcAddress("glEvalCoord2d");
    if (!_ptr) {
        _ptr = &_fail_glEvalCoord2d;
    }
    _glEvalCoord2d = _ptr;
    _glEvalCoord2d(u, v);
}

PFN_GLEVALCOORD2D _glEvalCoord2d = &_get_glEvalCoord2d;

static void APIENTRY _fail_glEvalCoord2dv(const GLdouble * u) {
    const char *_name = "glEvalCoord2dv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glEvalCoord2dv(const GLdouble * u) {
    PFN_GLEVALCOORD2DV _ptr;
    _ptr = (PFN_GLEVALCOORD2DV)_getPublicProcAddress("glEvalCoord2dv");
    if (!_ptr) {
        _ptr = &_fail_glEvalCoord2dv;
    }
    _glEvalCoord2dv = _ptr;
    _glEvalCoord2dv(u);
}

PFN_GLEVALCOORD2DV _glEvalCoord2dv = &_get_glEvalCoord2dv;

static void APIENTRY _fail_glEvalCoord2f(GLfloat u, GLfloat v) {
    const char *_name = "glEvalCoord2f";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glEvalCoord2f(GLfloat u, GLfloat v) {
    PFN_GLEVALCOORD2F _ptr;
    _ptr = (PFN_GLEVALCOORD2F)_getPublicProcAddress("glEvalCoord2f");
    if (!_ptr) {
        _ptr = &_fail_glEvalCoord2f;
    }
    _glEvalCoord2f = _ptr;
    _glEvalCoord2f(u, v);
}

PFN_GLEVALCOORD2F _glEvalCoord2f = &_get_glEvalCoord2f;

static void APIENTRY _fail_glEvalCoord2fv(const GLfloat * u) {
    const char *_name = "glEvalCoord2fv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glEvalCoord2fv(const GLfloat * u) {
    PFN_GLEVALCOORD2FV _ptr;
    _ptr = (PFN_GLEVALCOORD2FV)_getPublicProcAddress("glEvalCoord2fv");
    if (!_ptr) {
        _ptr = &_fail_glEvalCoord2fv;
    }
    _glEvalCoord2fv = _ptr;
    _glEvalCoord2fv(u);
}

PFN_GLEVALCOORD2FV _glEvalCoord2fv = &_get_glEvalCoord2fv;

static void APIENTRY _fail_glEvalMesh1(GLenum mode, GLint i1, GLint i2) {
    const char *_name = "glEvalMesh1";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glEvalMesh1(GLenum mode, GLint i1, GLint i2) {
    PFN_GLEVALMESH1 _ptr;
    _ptr = (PFN_GLEVALMESH1)_getPublicProcAddress("glEvalMesh1");
    if (!_ptr) {
        _ptr = &_fail_glEvalMesh1;
    }
    _glEvalMesh1 = _ptr;
    _glEvalMesh1(mode, i1, i2);
}

PFN_GLEVALMESH1 _glEvalMesh1 = &_get_glEvalMesh1;

static void APIENTRY _fail_glEvalPoint1(GLint i) {
    const char *_name = "glEvalPoint1";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glEvalPoint1(GLint i) {
    PFN_GLEVALPOINT1 _ptr;
    _ptr = (PFN_GLEVALPOINT1)_getPublicProcAddress("glEvalPoint1");
    if (!_ptr) {
        _ptr = &_fail_glEvalPoint1;
    }
    _glEvalPoint1 = _ptr;
    _glEvalPoint1(i);
}

PFN_GLEVALPOINT1 _glEvalPoint1 = &_get_glEvalPoint1;

static void APIENTRY _fail_glEvalMesh2(GLenum mode, GLint i1, GLint i2, GLint j1, GLint j2) {
    const char *_name = "glEvalMesh2";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glEvalMesh2(GLenum mode, GLint i1, GLint i2, GLint j1, GLint j2) {
    PFN_GLEVALMESH2 _ptr;
    _ptr = (PFN_GLEVALMESH2)_getPublicProcAddress("glEvalMesh2");
    if (!_ptr) {
        _ptr = &_fail_glEvalMesh2;
    }
    _glEvalMesh2 = _ptr;
    _glEvalMesh2(mode, i1, i2, j1, j2);
}

PFN_GLEVALMESH2 _glEvalMesh2 = &_get_glEvalMesh2;

static void APIENTRY _fail_glEvalPoint2(GLint i, GLint j) {
    const char *_name = "glEvalPoint2";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glEvalPoint2(GLint i, GLint j) {
    PFN_GLEVALPOINT2 _ptr;
    _ptr = (PFN_GLEVALPOINT2)_getPublicProcAddress("glEvalPoint2");
    if (!_ptr) {
        _ptr = &_fail_glEvalPoint2;
    }
    _glEvalPoint2 = _ptr;
    _glEvalPoint2(i, j);
}

PFN_GLEVALPOINT2 _glEvalPoint2 = &_get_glEvalPoint2;

static void APIENTRY _fail_glAlphaFunc(GLenum func, GLfloat ref) {
    const char *_name = "glAlphaFunc";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glAlphaFunc(GLenum func, GLfloat ref) {
    PFN_GLALPHAFUNC _ptr;
    _ptr = (PFN_GLALPHAFUNC)_getPublicProcAddress("glAlphaFunc");
    if (!_ptr) {
        _ptr = &_fail_glAlphaFunc;
    }
    _glAlphaFunc = _ptr;
    _glAlphaFunc(func, ref);
}

PFN_GLALPHAFUNC _glAlphaFunc = &_get_glAlphaFunc;

static void APIENTRY _fail_glPixelZoom(GLfloat xfactor, GLfloat yfactor) {
    const char *_name = "glPixelZoom";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glPixelZoom(GLfloat xfactor, GLfloat yfactor) {
    PFN_GLPIXELZOOM _ptr;
    _ptr = (PFN_GLPIXELZOOM)_getPublicProcAddress("glPixelZoom");
    if (!_ptr) {
        _ptr = &_fail_glPixelZoom;
    }
    _glPixelZoom = _ptr;
    _glPixelZoom(xfactor, yfactor);
}

PFN_GLPIXELZOOM _glPixelZoom = &_get_glPixelZoom;

static void APIENTRY _fail_glPixelTransferf(GLenum pname, GLfloat param) {
    const char *_name = "glPixelTransferf";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glPixelTransferf(GLenum pname, GLfloat param) {
    PFN_GLPIXELTRANSFERF _ptr;
    _ptr = (PFN_GLPIXELTRANSFERF)_getPublicProcAddress("glPixelTransferf");
    if (!_ptr) {
        _ptr = &_fail_glPixelTransferf;
    }
    _glPixelTransferf = _ptr;
    _glPixelTransferf(pname, param);
}

PFN_GLPIXELTRANSFERF _glPixelTransferf = &_get_glPixelTransferf;

static void APIENTRY _fail_glPixelTransferi(GLenum pname, GLint param) {
    const char *_name = "glPixelTransferi";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glPixelTransferi(GLenum pname, GLint param) {
    PFN_GLPIXELTRANSFERI _ptr;
    _ptr = (PFN_GLPIXELTRANSFERI)_getPublicProcAddress("glPixelTransferi");
    if (!_ptr) {
        _ptr = &_fail_glPixelTransferi;
    }
    _glPixelTransferi = _ptr;
    _glPixelTransferi(pname, param);
}

PFN_GLPIXELTRANSFERI _glPixelTransferi = &_get_glPixelTransferi;

static void APIENTRY _fail_glPixelMapfv(GLenum map, GLsizei mapsize, const GLfloat * values) {
    const char *_name = "glPixelMapfv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glPixelMapfv(GLenum map, GLsizei mapsize, const GLfloat * values) {
    PFN_GLPIXELMAPFV _ptr;
    _ptr = (PFN_GLPIXELMAPFV)_getPublicProcAddress("glPixelMapfv");
    if (!_ptr) {
        _ptr = &_fail_glPixelMapfv;
    }
    _glPixelMapfv = _ptr;
    _glPixelMapfv(map, mapsize, values);
}

PFN_GLPIXELMAPFV _glPixelMapfv = &_get_glPixelMapfv;

static void APIENTRY _fail_glPixelMapuiv(GLenum map, GLsizei mapsize, const GLuint * values) {
    const char *_name = "glPixelMapuiv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glPixelMapuiv(GLenum map, GLsizei mapsize, const GLuint * values) {
    PFN_GLPIXELMAPUIV _ptr;
    _ptr = (PFN_GLPIXELMAPUIV)_getPublicProcAddress("glPixelMapuiv");
    if (!_ptr) {
        _ptr = &_fail_glPixelMapuiv;
    }
    _glPixelMapuiv = _ptr;
    _glPixelMapuiv(map, mapsize, values);
}

PFN_GLPIXELMAPUIV _glPixelMapuiv = &_get_glPixelMapuiv;

static void APIENTRY _fail_glPixelMapusv(GLenum map, GLsizei mapsize, const GLushort * values) {
    const char *_name = "glPixelMapusv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glPixelMapusv(GLenum map, GLsizei mapsize, const GLushort * values) {
    PFN_GLPIXELMAPUSV _ptr;
    _ptr = (PFN_GLPIXELMAPUSV)_getPublicProcAddress("glPixelMapusv");
    if (!_ptr) {
        _ptr = &_fail_glPixelMapusv;
    }
    _glPixelMapusv = _ptr;
    _glPixelMapusv(map, mapsize, values);
}

PFN_GLPIXELMAPUSV _glPixelMapusv = &_get_glPixelMapusv;

static void APIENTRY _fail_glCopyPixels(GLint x, GLint y, GLsizei width, GLsizei height, GLenum type) {
    const char *_name = "glCopyPixels";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glCopyPixels(GLint x, GLint y, GLsizei width, GLsizei height, GLenum type) {
    PFN_GLCOPYPIXELS _ptr;
    _ptr = (PFN_GLCOPYPIXELS)_getPublicProcAddress("glCopyPixels");
    if (!_ptr) {
        _ptr = &_fail_glCopyPixels;
    }
    _glCopyPixels = _ptr;
    _glCopyPixels(x, y, width, height, type);
}

PFN_GLCOPYPIXELS _glCopyPixels = &_get_glCopyPixels;

static void APIENTRY _fail_glDrawPixels(GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid * pixels) {
    const char *_name = "glDrawPixels";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glDrawPixels(GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid * pixels) {
    PFN_GLDRAWPIXELS _ptr;
    _ptr = (PFN_GLDRAWPIXELS)_getPublicProcAddress("glDrawPixels");
    if (!_ptr) {
        _ptr = &_fail_glDrawPixels;
    }
    _glDrawPixels = _ptr;
    _glDrawPixels(width, height, format, type, pixels);
}

PFN_GLDRAWPIXELS _glDrawPixels = &_get_glDrawPixels;

static void APIENTRY _fail_glGetClipPlane(GLenum plane, GLdouble * equation) {
    const char *_name = "glGetClipPlane";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetClipPlane(GLenum plane, GLdouble * equation) {
    PFN_GLGETCLIPPLANE _ptr;
    _ptr = (PFN_GLGETCLIPPLANE)_getPublicProcAddress("glGetClipPlane");
    if (!_ptr) {
        _ptr = &_fail_glGetClipPlane;
    }
    _glGetClipPlane = _ptr;
    _glGetClipPlane(plane, equation);
}

PFN_GLGETCLIPPLANE _glGetClipPlane = &_get_glGetClipPlane;

static void APIENTRY _fail_glGetLightfv(GLenum light, GLenum pname, GLfloat * params) {
    const char *_name = "glGetLightfv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetLightfv(GLenum light, GLenum pname, GLfloat * params) {
    PFN_GLGETLIGHTFV _ptr;
    _ptr = (PFN_GLGETLIGHTFV)_getPublicProcAddress("glGetLightfv");
    if (!_ptr) {
        _ptr = &_fail_glGetLightfv;
    }
    _glGetLightfv = _ptr;
    _glGetLightfv(light, pname, params);
}

PFN_GLGETLIGHTFV _glGetLightfv = &_get_glGetLightfv;

static void APIENTRY _fail_glGetLightiv(GLenum light, GLenum pname, GLint * params) {
    const char *_name = "glGetLightiv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetLightiv(GLenum light, GLenum pname, GLint * params) {
    PFN_GLGETLIGHTIV _ptr;
    _ptr = (PFN_GLGETLIGHTIV)_getPublicProcAddress("glGetLightiv");
    if (!_ptr) {
        _ptr = &_fail_glGetLightiv;
    }
    _glGetLightiv = _ptr;
    _glGetLightiv(light, pname, params);
}

PFN_GLGETLIGHTIV _glGetLightiv = &_get_glGetLightiv;

static void APIENTRY _fail_glGetMapdv(GLenum target, GLenum query, GLdouble * v) {
    const char *_name = "glGetMapdv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetMapdv(GLenum target, GLenum query, GLdouble * v) {
    PFN_GLGETMAPDV _ptr;
    _ptr = (PFN_GLGETMAPDV)_getPublicProcAddress("glGetMapdv");
    if (!_ptr) {
        _ptr = &_fail_glGetMapdv;
    }
    _glGetMapdv = _ptr;
    _glGetMapdv(target, query, v);
}

PFN_GLGETMAPDV _glGetMapdv = &_get_glGetMapdv;

static void APIENTRY _fail_glGetMapfv(GLenum target, GLenum query, GLfloat * v) {
    const char *_name = "glGetMapfv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetMapfv(GLenum target, GLenum query, GLfloat * v) {
    PFN_GLGETMAPFV _ptr;
    _ptr = (PFN_GLGETMAPFV)_getPublicProcAddress("glGetMapfv");
    if (!_ptr) {
        _ptr = &_fail_glGetMapfv;
    }
    _glGetMapfv = _ptr;
    _glGetMapfv(target, query, v);
}

PFN_GLGETMAPFV _glGetMapfv = &_get_glGetMapfv;

static void APIENTRY _fail_glGetMapiv(GLenum target, GLenum query, GLint * v) {
    const char *_name = "glGetMapiv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetMapiv(GLenum target, GLenum query, GLint * v) {
    PFN_GLGETMAPIV _ptr;
    _ptr = (PFN_GLGETMAPIV)_getPublicProcAddress("glGetMapiv");
    if (!_ptr) {
        _ptr = &_fail_glGetMapiv;
    }
    _glGetMapiv = _ptr;
    _glGetMapiv(target, query, v);
}

PFN_GLGETMAPIV _glGetMapiv = &_get_glGetMapiv;

static void APIENTRY _fail_glGetMaterialfv(GLenum face, GLenum pname, GLfloat * params) {
    const char *_name = "glGetMaterialfv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetMaterialfv(GLenum face, GLenum pname, GLfloat * params) {
    PFN_GLGETMATERIALFV _ptr;
    _ptr = (PFN_GLGETMATERIALFV)_getPublicProcAddress("glGetMaterialfv");
    if (!_ptr) {
        _ptr = &_fail_glGetMaterialfv;
    }
    _glGetMaterialfv = _ptr;
    _glGetMaterialfv(face, pname, params);
}

PFN_GLGETMATERIALFV _glGetMaterialfv = &_get_glGetMaterialfv;

static void APIENTRY _fail_glGetMaterialiv(GLenum face, GLenum pname, GLint * params) {
    const char *_name = "glGetMaterialiv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetMaterialiv(GLenum face, GLenum pname, GLint * params) {
    PFN_GLGETMATERIALIV _ptr;
    _ptr = (PFN_GLGETMATERIALIV)_getPublicProcAddress("glGetMaterialiv");
    if (!_ptr) {
        _ptr = &_fail_glGetMaterialiv;
    }
    _glGetMaterialiv = _ptr;
    _glGetMaterialiv(face, pname, params);
}

PFN_GLGETMATERIALIV _glGetMaterialiv = &_get_glGetMaterialiv;

static void APIENTRY _fail_glGetPixelMapfv(GLenum map, GLfloat * values) {
    const char *_name = "glGetPixelMapfv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetPixelMapfv(GLenum map, GLfloat * values) {
    PFN_GLGETPIXELMAPFV _ptr;
    _ptr = (PFN_GLGETPIXELMAPFV)_getPublicProcAddress("glGetPixelMapfv");
    if (!_ptr) {
        _ptr = &_fail_glGetPixelMapfv;
    }
    _glGetPixelMapfv = _ptr;
    _glGetPixelMapfv(map, values);
}

PFN_GLGETPIXELMAPFV _glGetPixelMapfv = &_get_glGetPixelMapfv;

static void APIENTRY _fail_glGetPixelMapuiv(GLenum map, GLuint * values) {
    const char *_name = "glGetPixelMapuiv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetPixelMapuiv(GLenum map, GLuint * values) {
    PFN_GLGETPIXELMAPUIV _ptr;
    _ptr = (PFN_GLGETPIXELMAPUIV)_getPublicProcAddress("glGetPixelMapuiv");
    if (!_ptr) {
        _ptr = &_fail_glGetPixelMapuiv;
    }
    _glGetPixelMapuiv = _ptr;
    _glGetPixelMapuiv(map, values);
}

PFN_GLGETPIXELMAPUIV _glGetPixelMapuiv = &_get_glGetPixelMapuiv;

static void APIENTRY _fail_glGetPixelMapusv(GLenum map, GLushort * values) {
    const char *_name = "glGetPixelMapusv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetPixelMapusv(GLenum map, GLushort * values) {
    PFN_GLGETPIXELMAPUSV _ptr;
    _ptr = (PFN_GLGETPIXELMAPUSV)_getPublicProcAddress("glGetPixelMapusv");
    if (!_ptr) {
        _ptr = &_fail_glGetPixelMapusv;
    }
    _glGetPixelMapusv = _ptr;
    _glGetPixelMapusv(map, values);
}

PFN_GLGETPIXELMAPUSV _glGetPixelMapusv = &_get_glGetPixelMapusv;

static void APIENTRY _fail_glGetPolygonStipple(GLubyte * mask) {
    const char *_name = "glGetPolygonStipple";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetPolygonStipple(GLubyte * mask) {
    PFN_GLGETPOLYGONSTIPPLE _ptr;
    _ptr = (PFN_GLGETPOLYGONSTIPPLE)_getPublicProcAddress("glGetPolygonStipple");
    if (!_ptr) {
        _ptr = &_fail_glGetPolygonStipple;
    }
    _glGetPolygonStipple = _ptr;
    _glGetPolygonStipple(mask);
}

PFN_GLGETPOLYGONSTIPPLE _glGetPolygonStipple = &_get_glGetPolygonStipple;

static void APIENTRY _fail_glGetTexEnvfv(GLenum target, GLenum pname, GLfloat * params) {
    const char *_name = "glGetTexEnvfv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetTexEnvfv(GLenum target, GLenum pname, GLfloat * params) {
    PFN_GLGETTEXENVFV _ptr;
    _ptr = (PFN_GLGETTEXENVFV)_getPublicProcAddress("glGetTexEnvfv");
    if (!_ptr) {
        _ptr = &_fail_glGetTexEnvfv;
    }
    _glGetTexEnvfv = _ptr;
    _glGetTexEnvfv(target, pname, params);
}

PFN_GLGETTEXENVFV _glGetTexEnvfv = &_get_glGetTexEnvfv;

static void APIENTRY _fail_glGetTexEnviv(GLenum target, GLenum pname, GLint * params) {
    const char *_name = "glGetTexEnviv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetTexEnviv(GLenum target, GLenum pname, GLint * params) {
    PFN_GLGETTEXENVIV _ptr;
    _ptr = (PFN_GLGETTEXENVIV)_getPublicProcAddress("glGetTexEnviv");
    if (!_ptr) {
        _ptr = &_fail_glGetTexEnviv;
    }
    _glGetTexEnviv = _ptr;
    _glGetTexEnviv(target, pname, params);
}

PFN_GLGETTEXENVIV _glGetTexEnviv = &_get_glGetTexEnviv;

static void APIENTRY _fail_glGetTexGendv(GLenum coord, GLenum pname, GLdouble * params) {
    const char *_name = "glGetTexGendv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetTexGendv(GLenum coord, GLenum pname, GLdouble * params) {
    PFN_GLGETTEXGENDV _ptr;
    _ptr = (PFN_GLGETTEXGENDV)_getPublicProcAddress("glGetTexGendv");
    if (!_ptr) {
        _ptr = &_fail_glGetTexGendv;
    }
    _glGetTexGendv = _ptr;
    _glGetTexGendv(coord, pname, params);
}

PFN_GLGETTEXGENDV _glGetTexGendv = &_get_glGetTexGendv;

static void APIENTRY _fail_glGetTexGenfv(GLenum coord, GLenum pname, GLfloat * params) {
    const char *_name = "glGetTexGenfv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetTexGenfv(GLenum coord, GLenum pname, GLfloat * params) {
    PFN_GLGETTEXGENFV _ptr;
    _ptr = (PFN_GLGETTEXGENFV)_getPublicProcAddress("glGetTexGenfv");
    if (!_ptr) {
        _ptr = &_fail_glGetTexGenfv;
    }
    _glGetTexGenfv = _ptr;
    _glGetTexGenfv(coord, pname, params);
}

PFN_GLGETTEXGENFV _glGetTexGenfv = &_get_glGetTexGenfv;

static void APIENTRY _fail_glGetTexGeniv(GLenum coord, GLenum pname, GLint * params) {
    const char *_name = "glGetTexGeniv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetTexGeniv(GLenum coord, GLenum pname, GLint * params) {
    PFN_GLGETTEXGENIV _ptr;
    _ptr = (PFN_GLGETTEXGENIV)_getPublicProcAddress("glGetTexGeniv");
    if (!_ptr) {
        _ptr = &_fail_glGetTexGeniv;
    }
    _glGetTexGeniv = _ptr;
    _glGetTexGeniv(coord, pname, params);
}

PFN_GLGETTEXGENIV _glGetTexGeniv = &_get_glGetTexGeniv;

static GLboolean APIENTRY _fail_glIsList(GLuint list) {
    const char *_name = "glIsList";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static GLboolean APIENTRY _get_glIsList(GLuint list) {
    PFN_GLISLIST _ptr;
    _ptr = (PFN_GLISLIST)_getPublicProcAddress("glIsList");
    if (!_ptr) {
        _ptr = &_fail_glIsList;
    }
    _glIsList = _ptr;
    return _glIsList(list);
}

PFN_GLISLIST _glIsList = &_get_glIsList;

static void APIENTRY _fail_glFrustum(GLdouble left, GLdouble right, GLdouble bottom, GLdouble top, GLdouble zNear, GLdouble zFar) {
    const char *_name = "glFrustum";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glFrustum(GLdouble left, GLdouble right, GLdouble bottom, GLdouble top, GLdouble zNear, GLdouble zFar) {
    PFN_GLFRUSTUM _ptr;
    _ptr = (PFN_GLFRUSTUM)_getPublicProcAddress("glFrustum");
    if (!_ptr) {
        _ptr = &_fail_glFrustum;
    }
    _glFrustum = _ptr;
    _glFrustum(left, right, bottom, top, zNear, zFar);
}

PFN_GLFRUSTUM _glFrustum = &_get_glFrustum;

static void APIENTRY _fail_glLoadIdentity(void) {
    const char *_name = "glLoadIdentity";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glLoadIdentity(void) {
    PFN_GLLOADIDENTITY _ptr;
    _ptr = (PFN_GLLOADIDENTITY)_getPublicProcAddress("glLoadIdentity");
    if (!_ptr) {
        _ptr = &_fail_glLoadIdentity;
    }
    _glLoadIdentity = _ptr;
    _glLoadIdentity();
}

PFN_GLLOADIDENTITY _glLoadIdentity = &_get_glLoadIdentity;

static void APIENTRY _fail_glLoadMatrixf(const GLfloat * m) {
    const char *_name = "glLoadMatrixf";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glLoadMatrixf(const GLfloat * m) {
    PFN_GLLOADMATRIXF _ptr;
    _ptr = (PFN_GLLOADMATRIXF)_getPublicProcAddress("glLoadMatrixf");
    if (!_ptr) {
        _ptr = &_fail_glLoadMatrixf;
    }
    _glLoadMatrixf = _ptr;
    _glLoadMatrixf(m);
}

PFN_GLLOADMATRIXF _glLoadMatrixf = &_get_glLoadMatrixf;

static void APIENTRY _fail_glLoadMatrixd(const GLdouble * m) {
    const char *_name = "glLoadMatrixd";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glLoadMatrixd(const GLdouble * m) {
    PFN_GLLOADMATRIXD _ptr;
    _ptr = (PFN_GLLOADMATRIXD)_getPublicProcAddress("glLoadMatrixd");
    if (!_ptr) {
        _ptr = &_fail_glLoadMatrixd;
    }
    _glLoadMatrixd = _ptr;
    _glLoadMatrixd(m);
}

PFN_GLLOADMATRIXD _glLoadMatrixd = &_get_glLoadMatrixd;

static void APIENTRY _fail_glMatrixMode(GLenum mode) {
    const char *_name = "glMatrixMode";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glMatrixMode(GLenum mode) {
    PFN_GLMATRIXMODE _ptr;
    _ptr = (PFN_GLMATRIXMODE)_getPublicProcAddress("glMatrixMode");
    if (!_ptr) {
        _ptr = &_fail_glMatrixMode;
    }
    _glMatrixMode = _ptr;
    _glMatrixMode(mode);
}

PFN_GLMATRIXMODE _glMatrixMode = &_get_glMatrixMode;

static void APIENTRY _fail_glMultMatrixf(const GLfloat * m) {
    const char *_name = "glMultMatrixf";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glMultMatrixf(const GLfloat * m) {
    PFN_GLMULTMATRIXF _ptr;
    _ptr = (PFN_GLMULTMATRIXF)_getPublicProcAddress("glMultMatrixf");
    if (!_ptr) {
        _ptr = &_fail_glMultMatrixf;
    }
    _glMultMatrixf = _ptr;
    _glMultMatrixf(m);
}

PFN_GLMULTMATRIXF _glMultMatrixf = &_get_glMultMatrixf;

static void APIENTRY _fail_glMultMatrixd(const GLdouble * m) {
    const char *_name = "glMultMatrixd";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glMultMatrixd(const GLdouble * m) {
    PFN_GLMULTMATRIXD _ptr;
    _ptr = (PFN_GLMULTMATRIXD)_getPublicProcAddress("glMultMatrixd");
    if (!_ptr) {
        _ptr = &_fail_glMultMatrixd;
    }
    _glMultMatrixd = _ptr;
    _glMultMatrixd(m);
}

PFN_GLMULTMATRIXD _glMultMatrixd = &_get_glMultMatrixd;

static void APIENTRY _fail_glOrtho(GLdouble left, GLdouble right, GLdouble bottom, GLdouble top, GLdouble zNear, GLdouble zFar) {
    const char *_name = "glOrtho";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glOrtho(GLdouble left, GLdouble right, GLdouble bottom, GLdouble top, GLdouble zNear, GLdouble zFar) {
    PFN_GLORTHO _ptr;
    _ptr = (PFN_GLORTHO)_getPublicProcAddress("glOrtho");
    if (!_ptr) {
        _ptr = &_fail_glOrtho;
    }
    _glOrtho = _ptr;
    _glOrtho(left, right, bottom, top, zNear, zFar);
}

PFN_GLORTHO _glOrtho = &_get_glOrtho;

static void APIENTRY _fail_glPopMatrix(void) {
    const char *_name = "glPopMatrix";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glPopMatrix(void) {
    PFN_GLPOPMATRIX _ptr;
    _ptr = (PFN_GLPOPMATRIX)_getPublicProcAddress("glPopMatrix");
    if (!_ptr) {
        _ptr = &_fail_glPopMatrix;
    }
    _glPopMatrix = _ptr;
    _glPopMatrix();
}

PFN_GLPOPMATRIX _glPopMatrix = &_get_glPopMatrix;

static void APIENTRY _fail_glPushMatrix(void) {
    const char *_name = "glPushMatrix";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glPushMatrix(void) {
    PFN_GLPUSHMATRIX _ptr;
    _ptr = (PFN_GLPUSHMATRIX)_getPublicProcAddress("glPushMatrix");
    if (!_ptr) {
        _ptr = &_fail_glPushMatrix;
    }
    _glPushMatrix = _ptr;
    _glPushMatrix();
}

PFN_GLPUSHMATRIX _glPushMatrix = &_get_glPushMatrix;

static void APIENTRY _fail_glRotated(GLdouble angle, GLdouble x, GLdouble y, GLdouble z) {
    const char *_name = "glRotated";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glRotated(GLdouble angle, GLdouble x, GLdouble y, GLdouble z) {
    PFN_GLROTATED _ptr;
    _ptr = (PFN_GLROTATED)_getPublicProcAddress("glRotated");
    if (!_ptr) {
        _ptr = &_fail_glRotated;
    }
    _glRotated = _ptr;
    _glRotated(angle, x, y, z);
}

PFN_GLROTATED _glRotated = &_get_glRotated;

static void APIENTRY _fail_glRotatef(GLfloat angle, GLfloat x, GLfloat y, GLfloat z) {
    const char *_name = "glRotatef";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glRotatef(GLfloat angle, GLfloat x, GLfloat y, GLfloat z) {
    PFN_GLROTATEF _ptr;
    _ptr = (PFN_GLROTATEF)_getPublicProcAddress("glRotatef");
    if (!_ptr) {
        _ptr = &_fail_glRotatef;
    }
    _glRotatef = _ptr;
    _glRotatef(angle, x, y, z);
}

PFN_GLROTATEF _glRotatef = &_get_glRotatef;

static void APIENTRY _fail_glScaled(GLdouble x, GLdouble y, GLdouble z) {
    const char *_name = "glScaled";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glScaled(GLdouble x, GLdouble y, GLdouble z) {
    PFN_GLSCALED _ptr;
    _ptr = (PFN_GLSCALED)_getPublicProcAddress("glScaled");
    if (!_ptr) {
        _ptr = &_fail_glScaled;
    }
    _glScaled = _ptr;
    _glScaled(x, y, z);
}

PFN_GLSCALED _glScaled = &_get_glScaled;

static void APIENTRY _fail_glScalef(GLfloat x, GLfloat y, GLfloat z) {
    const char *_name = "glScalef";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glScalef(GLfloat x, GLfloat y, GLfloat z) {
    PFN_GLSCALEF _ptr;
    _ptr = (PFN_GLSCALEF)_getPublicProcAddress("glScalef");
    if (!_ptr) {
        _ptr = &_fail_glScalef;
    }
    _glScalef = _ptr;
    _glScalef(x, y, z);
}

PFN_GLSCALEF _glScalef = &_get_glScalef;

static void APIENTRY _fail_glTranslated(GLdouble x, GLdouble y, GLdouble z) {
    const char *_name = "glTranslated";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glTranslated(GLdouble x, GLdouble y, GLdouble z) {
    PFN_GLTRANSLATED _ptr;
    _ptr = (PFN_GLTRANSLATED)_getPublicProcAddress("glTranslated");
    if (!_ptr) {
        _ptr = &_fail_glTranslated;
    }
    _glTranslated = _ptr;
    _glTranslated(x, y, z);
}

PFN_GLTRANSLATED _glTranslated = &_get_glTranslated;

static void APIENTRY _fail_glTranslatef(GLfloat x, GLfloat y, GLfloat z) {
    const char *_name = "glTranslatef";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glTranslatef(GLfloat x, GLfloat y, GLfloat z) {
    PFN_GLTRANSLATEF _ptr;
    _ptr = (PFN_GLTRANSLATEF)_getPublicProcAddress("glTranslatef");
    if (!_ptr) {
        _ptr = &_fail_glTranslatef;
    }
    _glTranslatef = _ptr;
    _glTranslatef(x, y, z);
}

PFN_GLTRANSLATEF _glTranslatef = &_get_glTranslatef;

static void APIENTRY _fail_glDrawArrays(GLenum mode, GLint first, GLsizei count) {
    const char *_name = "glDrawArrays";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glDrawArrays(GLenum mode, GLint first, GLsizei count) {
    PFN_GLDRAWARRAYS _ptr;
    _ptr = (PFN_GLDRAWARRAYS)_getPublicProcAddress("glDrawArrays");
    if (!_ptr) {
        _ptr = &_fail_glDrawArrays;
    }
    _glDrawArrays = _ptr;
    _glDrawArrays(mode, first, count);
}

PFN_GLDRAWARRAYS _glDrawArrays = &_get_glDrawArrays;

static void APIENTRY _fail_glDrawElements(GLenum mode, GLsizei count, GLenum type, const GLvoid * indices) {
    const char *_name = "glDrawElements";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glDrawElements(GLenum mode, GLsizei count, GLenum type, const GLvoid * indices) {
    PFN_GLDRAWELEMENTS _ptr;
    _ptr = (PFN_GLDRAWELEMENTS)_getPublicProcAddress("glDrawElements");
    if (!_ptr) {
        _ptr = &_fail_glDrawElements;
    }
    _glDrawElements = _ptr;
    _glDrawElements(mode, count, type, indices);
}

PFN_GLDRAWELEMENTS _glDrawElements = &_get_glDrawElements;

static void APIENTRY _fail_glGetPointerv(GLenum pname, GLvoid * * params) {
    const char *_name = "glGetPointerv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetPointerv(GLenum pname, GLvoid * * params) {
    PFN_GLGETPOINTERV _ptr;
    _ptr = (PFN_GLGETPOINTERV)_getPublicProcAddress("glGetPointerv");
    if (!_ptr) {
        _ptr = &_fail_glGetPointerv;
    }
    _glGetPointerv = _ptr;
    _glGetPointerv(pname, params);
}

PFN_GLGETPOINTERV _glGetPointerv = &_get_glGetPointerv;

static void APIENTRY _fail_glPolygonOffset(GLfloat factor, GLfloat units) {
    const char *_name = "glPolygonOffset";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glPolygonOffset(GLfloat factor, GLfloat units) {
    PFN_GLPOLYGONOFFSET _ptr;
    _ptr = (PFN_GLPOLYGONOFFSET)_getPublicProcAddress("glPolygonOffset");
    if (!_ptr) {
        _ptr = &_fail_glPolygonOffset;
    }
    _glPolygonOffset = _ptr;
    _glPolygonOffset(factor, units);
}

PFN_GLPOLYGONOFFSET _glPolygonOffset = &_get_glPolygonOffset;

static void APIENTRY _fail_glCopyTexImage1D(GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLint border) {
    const char *_name = "glCopyTexImage1D";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glCopyTexImage1D(GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLint border) {
    PFN_GLCOPYTEXIMAGE1D _ptr;
    _ptr = (PFN_GLCOPYTEXIMAGE1D)_getPublicProcAddress("glCopyTexImage1D");
    if (!_ptr) {
        _ptr = &_fail_glCopyTexImage1D;
    }
    _glCopyTexImage1D = _ptr;
    _glCopyTexImage1D(target, level, internalformat, x, y, width, border);
}

PFN_GLCOPYTEXIMAGE1D _glCopyTexImage1D = &_get_glCopyTexImage1D;

static void APIENTRY _fail_glCopyTexImage2D(GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLsizei height, GLint border) {
    const char *_name = "glCopyTexImage2D";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glCopyTexImage2D(GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLsizei height, GLint border) {
    PFN_GLCOPYTEXIMAGE2D _ptr;
    _ptr = (PFN_GLCOPYTEXIMAGE2D)_getPublicProcAddress("glCopyTexImage2D");
    if (!_ptr) {
        _ptr = &_fail_glCopyTexImage2D;
    }
    _glCopyTexImage2D = _ptr;
    _glCopyTexImage2D(target, level, internalformat, x, y, width, height, border);
}

PFN_GLCOPYTEXIMAGE2D _glCopyTexImage2D = &_get_glCopyTexImage2D;

static void APIENTRY _fail_glCopyTexSubImage1D(GLenum target, GLint level, GLint xoffset, GLint x, GLint y, GLsizei width) {
    const char *_name = "glCopyTexSubImage1D";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glCopyTexSubImage1D(GLenum target, GLint level, GLint xoffset, GLint x, GLint y, GLsizei width) {
    PFN_GLCOPYTEXSUBIMAGE1D _ptr;
    _ptr = (PFN_GLCOPYTEXSUBIMAGE1D)_getPublicProcAddress("glCopyTexSubImage1D");
    if (!_ptr) {
        _ptr = &_fail_glCopyTexSubImage1D;
    }
    _glCopyTexSubImage1D = _ptr;
    _glCopyTexSubImage1D(target, level, xoffset, x, y, width);
}

PFN_GLCOPYTEXSUBIMAGE1D _glCopyTexSubImage1D = &_get_glCopyTexSubImage1D;

static void APIENTRY _fail_glCopyTexSubImage2D(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint x, GLint y, GLsizei width, GLsizei height) {
    const char *_name = "glCopyTexSubImage2D";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glCopyTexSubImage2D(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint x, GLint y, GLsizei width, GLsizei height) {
    PFN_GLCOPYTEXSUBIMAGE2D _ptr;
    _ptr = (PFN_GLCOPYTEXSUBIMAGE2D)_getPublicProcAddress("glCopyTexSubImage2D");
    if (!_ptr) {
        _ptr = &_fail_glCopyTexSubImage2D;
    }
    _glCopyTexSubImage2D = _ptr;
    _glCopyTexSubImage2D(target, level, xoffset, yoffset, x, y, width, height);
}

PFN_GLCOPYTEXSUBIMAGE2D _glCopyTexSubImage2D = &_get_glCopyTexSubImage2D;

static void APIENTRY _fail_glTexSubImage1D(GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLenum type, const GLvoid * pixels) {
    const char *_name = "glTexSubImage1D";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glTexSubImage1D(GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLenum type, const GLvoid * pixels) {
    PFN_GLTEXSUBIMAGE1D _ptr;
    _ptr = (PFN_GLTEXSUBIMAGE1D)_getPublicProcAddress("glTexSubImage1D");
    if (!_ptr) {
        _ptr = &_fail_glTexSubImage1D;
    }
    _glTexSubImage1D = _ptr;
    _glTexSubImage1D(target, level, xoffset, width, format, type, pixels);
}

PFN_GLTEXSUBIMAGE1D _glTexSubImage1D = &_get_glTexSubImage1D;

static void APIENTRY _fail_glTexSubImage2D(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid * pixels) {
    const char *_name = "glTexSubImage2D";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glTexSubImage2D(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid * pixels) {
    PFN_GLTEXSUBIMAGE2D _ptr;
    _ptr = (PFN_GLTEXSUBIMAGE2D)_getPublicProcAddress("glTexSubImage2D");
    if (!_ptr) {
        _ptr = &_fail_glTexSubImage2D;
    }
    _glTexSubImage2D = _ptr;
    _glTexSubImage2D(target, level, xoffset, yoffset, width, height, format, type, pixels);
}

PFN_GLTEXSUBIMAGE2D _glTexSubImage2D = &_get_glTexSubImage2D;

static void APIENTRY _fail_glBindTexture(GLenum target, GLuint texture) {
    const char *_name = "glBindTexture";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glBindTexture(GLenum target, GLuint texture) {
    PFN_GLBINDTEXTURE _ptr;
    _ptr = (PFN_GLBINDTEXTURE)_getPublicProcAddress("glBindTexture");
    if (!_ptr) {
        _ptr = &_fail_glBindTexture;
    }
    _glBindTexture = _ptr;
    _glBindTexture(target, texture);
}

PFN_GLBINDTEXTURE _glBindTexture = &_get_glBindTexture;

static void APIENTRY _fail_glDeleteTextures(GLsizei n, const GLuint * textures) {
    const char *_name = "glDeleteTextures";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glDeleteTextures(GLsizei n, const GLuint * textures) {
    PFN_GLDELETETEXTURES _ptr;
    _ptr = (PFN_GLDELETETEXTURES)_getPublicProcAddress("glDeleteTextures");
    if (!_ptr) {
        _ptr = &_fail_glDeleteTextures;
    }
    _glDeleteTextures = _ptr;
    _glDeleteTextures(n, textures);
}

PFN_GLDELETETEXTURES _glDeleteTextures = &_get_glDeleteTextures;

static void APIENTRY _fail_glGenTextures(GLsizei n, GLuint * textures) {
    const char *_name = "glGenTextures";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGenTextures(GLsizei n, GLuint * textures) {
    PFN_GLGENTEXTURES _ptr;
    _ptr = (PFN_GLGENTEXTURES)_getPublicProcAddress("glGenTextures");
    if (!_ptr) {
        _ptr = &_fail_glGenTextures;
    }
    _glGenTextures = _ptr;
    _glGenTextures(n, textures);
}

PFN_GLGENTEXTURES _glGenTextures = &_get_glGenTextures;

static GLboolean APIENTRY _fail_glIsTexture(GLuint texture) {
    const char *_name = "glIsTexture";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static GLboolean APIENTRY _get_glIsTexture(GLuint texture) {
    PFN_GLISTEXTURE _ptr;
    _ptr = (PFN_GLISTEXTURE)_getPublicProcAddress("glIsTexture");
    if (!_ptr) {
        _ptr = &_fail_glIsTexture;
    }
    _glIsTexture = _ptr;
    return _glIsTexture(texture);
}

PFN_GLISTEXTURE _glIsTexture = &_get_glIsTexture;

static void APIENTRY _fail_glArrayElement(GLint i) {
    const char *_name = "glArrayElement";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glArrayElement(GLint i) {
    PFN_GLARRAYELEMENT _ptr;
    _ptr = (PFN_GLARRAYELEMENT)_getPublicProcAddress("glArrayElement");
    if (!_ptr) {
        _ptr = &_fail_glArrayElement;
    }
    _glArrayElement = _ptr;
    _glArrayElement(i);
}

PFN_GLARRAYELEMENT _glArrayElement = &_get_glArrayElement;

static void APIENTRY _fail_glColorPointer(GLint size, GLenum type, GLsizei stride, const GLvoid * pointer) {
    const char *_name = "glColorPointer";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glColorPointer(GLint size, GLenum type, GLsizei stride, const GLvoid * pointer) {
    PFN_GLCOLORPOINTER _ptr;
    _ptr = (PFN_GLCOLORPOINTER)_getPublicProcAddress("glColorPointer");
    if (!_ptr) {
        _ptr = &_fail_glColorPointer;
    }
    _glColorPointer = _ptr;
    _glColorPointer(size, type, stride, pointer);
}

PFN_GLCOLORPOINTER _glColorPointer = &_get_glColorPointer;

static void APIENTRY _fail_glDisableClientState(GLenum array) {
    const char *_name = "glDisableClientState";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glDisableClientState(GLenum array) {
    PFN_GLDISABLECLIENTSTATE _ptr;
    _ptr = (PFN_GLDISABLECLIENTSTATE)_getPublicProcAddress("glDisableClientState");
    if (!_ptr) {
        _ptr = &_fail_glDisableClientState;
    }
    _glDisableClientState = _ptr;
    _glDisableClientState(array);
}

PFN_GLDISABLECLIENTSTATE _glDisableClientState = &_get_glDisableClientState;

static void APIENTRY _fail_glEdgeFlagPointer(GLsizei stride, const GLvoid * pointer) {
    const char *_name = "glEdgeFlagPointer";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glEdgeFlagPointer(GLsizei stride, const GLvoid * pointer) {
    PFN_GLEDGEFLAGPOINTER _ptr;
    _ptr = (PFN_GLEDGEFLAGPOINTER)_getPublicProcAddress("glEdgeFlagPointer");
    if (!_ptr) {
        _ptr = &_fail_glEdgeFlagPointer;
    }
    _glEdgeFlagPointer = _ptr;
    _glEdgeFlagPointer(stride, pointer);
}

PFN_GLEDGEFLAGPOINTER _glEdgeFlagPointer = &_get_glEdgeFlagPointer;

static void APIENTRY _fail_glEnableClientState(GLenum array) {
    const char *_name = "glEnableClientState";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glEnableClientState(GLenum array) {
    PFN_GLENABLECLIENTSTATE _ptr;
    _ptr = (PFN_GLENABLECLIENTSTATE)_getPublicProcAddress("glEnableClientState");
    if (!_ptr) {
        _ptr = &_fail_glEnableClientState;
    }
    _glEnableClientState = _ptr;
    _glEnableClientState(array);
}

PFN_GLENABLECLIENTSTATE _glEnableClientState = &_get_glEnableClientState;

static void APIENTRY _fail_glIndexPointer(GLenum type, GLsizei stride, const GLvoid * pointer) {
    const char *_name = "glIndexPointer";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glIndexPointer(GLenum type, GLsizei stride, const GLvoid * pointer) {
    PFN_GLINDEXPOINTER _ptr;
    _ptr = (PFN_GLINDEXPOINTER)_getPublicProcAddress("glIndexPointer");
    if (!_ptr) {
        _ptr = &_fail_glIndexPointer;
    }
    _glIndexPointer = _ptr;
    _glIndexPointer(type, stride, pointer);
}

PFN_GLINDEXPOINTER _glIndexPointer = &_get_glIndexPointer;

static void APIENTRY _fail_glInterleavedArrays(GLenum format, GLsizei stride, const GLvoid * pointer) {
    const char *_name = "glInterleavedArrays";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glInterleavedArrays(GLenum format, GLsizei stride, const GLvoid * pointer) {
    PFN_GLINTERLEAVEDARRAYS _ptr;
    _ptr = (PFN_GLINTERLEAVEDARRAYS)_getPublicProcAddress("glInterleavedArrays");
    if (!_ptr) {
        _ptr = &_fail_glInterleavedArrays;
    }
    _glInterleavedArrays = _ptr;
    _glInterleavedArrays(format, stride, pointer);
}

PFN_GLINTERLEAVEDARRAYS _glInterleavedArrays = &_get_glInterleavedArrays;

static void APIENTRY _fail_glNormalPointer(GLenum type, GLsizei stride, const GLvoid * pointer) {
    const char *_name = "glNormalPointer";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glNormalPointer(GLenum type, GLsizei stride, const GLvoid * pointer) {
    PFN_GLNORMALPOINTER _ptr;
    _ptr = (PFN_GLNORMALPOINTER)_getPublicProcAddress("glNormalPointer");
    if (!_ptr) {
        _ptr = &_fail_glNormalPointer;
    }
    _glNormalPointer = _ptr;
    _glNormalPointer(type, stride, pointer);
}

PFN_GLNORMALPOINTER _glNormalPointer = &_get_glNormalPointer;

static void APIENTRY _fail_glTexCoordPointer(GLint size, GLenum type, GLsizei stride, const GLvoid * pointer) {
    const char *_name = "glTexCoordPointer";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glTexCoordPointer(GLint size, GLenum type, GLsizei stride, const GLvoid * pointer) {
    PFN_GLTEXCOORDPOINTER _ptr;
    _ptr = (PFN_GLTEXCOORDPOINTER)_getPublicProcAddress("glTexCoordPointer");
    if (!_ptr) {
        _ptr = &_fail_glTexCoordPointer;
    }
    _glTexCoordPointer = _ptr;
    _glTexCoordPointer(size, type, stride, pointer);
}

PFN_GLTEXCOORDPOINTER _glTexCoordPointer = &_get_glTexCoordPointer;

static void APIENTRY _fail_glVertexPointer(GLint size, GLenum type, GLsizei stride, const GLvoid * pointer) {
    const char *_name = "glVertexPointer";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glVertexPointer(GLint size, GLenum type, GLsizei stride, const GLvoid * pointer) {
    PFN_GLVERTEXPOINTER _ptr;
    _ptr = (PFN_GLVERTEXPOINTER)_getPublicProcAddress("glVertexPointer");
    if (!_ptr) {
        _ptr = &_fail_glVertexPointer;
    }
    _glVertexPointer = _ptr;
    _glVertexPointer(size, type, stride, pointer);
}

PFN_GLVERTEXPOINTER _glVertexPointer = &_get_glVertexPointer;

static GLboolean APIENTRY _fail_glAreTexturesResident(GLsizei n, const GLuint * textures, GLboolean * residences) {
    const char *_name = "glAreTexturesResident";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static GLboolean APIENTRY _get_glAreTexturesResident(GLsizei n, const GLuint * textures, GLboolean * residences) {
    PFN_GLARETEXTURESRESIDENT _ptr;
    _ptr = (PFN_GLARETEXTURESRESIDENT)_getPublicProcAddress("glAreTexturesResident");
    if (!_ptr) {
        _ptr = &_fail_glAreTexturesResident;
    }
    _glAreTexturesResident = _ptr;
    return _glAreTexturesResident(n, textures, residences);
}

PFN_GLARETEXTURESRESIDENT _glAreTexturesResident = &_get_glAreTexturesResident;

static void APIENTRY _fail_glPrioritizeTextures(GLsizei n, const GLuint * textures, const GLclampf * priorities) {
    const char *_name = "glPrioritizeTextures";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glPrioritizeTextures(GLsizei n, const GLuint * textures, const GLclampf * priorities) {
    PFN_GLPRIORITIZETEXTURES _ptr;
    _ptr = (PFN_GLPRIORITIZETEXTURES)_getPublicProcAddress("glPrioritizeTextures");
    if (!_ptr) {
        _ptr = &_fail_glPrioritizeTextures;
    }
    _glPrioritizeTextures = _ptr;
    _glPrioritizeTextures(n, textures, priorities);
}

PFN_GLPRIORITIZETEXTURES _glPrioritizeTextures = &_get_glPrioritizeTextures;

static void APIENTRY _fail_glIndexub(GLubyte c) {
    const char *_name = "glIndexub";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glIndexub(GLubyte c) {
    PFN_GLINDEXUB _ptr;
    _ptr = (PFN_GLINDEXUB)_getPublicProcAddress("glIndexub");
    if (!_ptr) {
        _ptr = &_fail_glIndexub;
    }
    _glIndexub = _ptr;
    _glIndexub(c);
}

PFN_GLINDEXUB _glIndexub = &_get_glIndexub;

static void APIENTRY _fail_glIndexubv(const GLubyte * c) {
    const char *_name = "glIndexubv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glIndexubv(const GLubyte * c) {
    PFN_GLINDEXUBV _ptr;
    _ptr = (PFN_GLINDEXUBV)_getPublicProcAddress("glIndexubv");
    if (!_ptr) {
        _ptr = &_fail_glIndexubv;
    }
    _glIndexubv = _ptr;
    _glIndexubv(c);
}

PFN_GLINDEXUBV _glIndexubv = &_get_glIndexubv;

static void APIENTRY _fail_glPopClientAttrib(void) {
    const char *_name = "glPopClientAttrib";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glPopClientAttrib(void) {
    PFN_GLPOPCLIENTATTRIB _ptr;
    _ptr = (PFN_GLPOPCLIENTATTRIB)_getPublicProcAddress("glPopClientAttrib");
    if (!_ptr) {
        _ptr = &_fail_glPopClientAttrib;
    }
    _glPopClientAttrib = _ptr;
    _glPopClientAttrib();
}

PFN_GLPOPCLIENTATTRIB _glPopClientAttrib = &_get_glPopClientAttrib;

static void APIENTRY _fail_glPushClientAttrib(GLbitfield mask) {
    const char *_name = "glPushClientAttrib";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glPushClientAttrib(GLbitfield mask) {
    PFN_GLPUSHCLIENTATTRIB _ptr;
    _ptr = (PFN_GLPUSHCLIENTATTRIB)_getPublicProcAddress("glPushClientAttrib");
    if (!_ptr) {
        _ptr = &_fail_glPushClientAttrib;
    }
    _glPushClientAttrib = _ptr;
    _glPushClientAttrib(mask);
}

PFN_GLPUSHCLIENTATTRIB _glPushClientAttrib = &_get_glPushClientAttrib;

static void APIENTRY _fail_glBlendColor(GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha) {
    const char *_name = "glBlendColor";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glBlendColor(GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha) {
    PFN_GLBLENDCOLOR _ptr;
    _ptr = (PFN_GLBLENDCOLOR)_getPrivateProcAddress("glBlendColor");
    if (!_ptr) {
        _ptr = &_fail_glBlendColor;
    }
    _glBlendColor = _ptr;
    _glBlendColor(red, green, blue, alpha);
}

PFN_GLBLENDCOLOR _glBlendColor = &_get_glBlendColor;

static void APIENTRY _fail_glBlendEquation(GLenum mode) {
    const char *_name = "glBlendEquation";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glBlendEquation(GLenum mode) {
    PFN_GLBLENDEQUATION _ptr;
    _ptr = (PFN_GLBLENDEQUATION)_getPrivateProcAddress("glBlendEquation");
    if (!_ptr) {
        _ptr = &_fail_glBlendEquation;
    }
    _glBlendEquation = _ptr;
    _glBlendEquation(mode);
}

PFN_GLBLENDEQUATION _glBlendEquation = &_get_glBlendEquation;

static void APIENTRY _fail_glDrawRangeElements(GLenum mode, GLuint start, GLuint end, GLsizei count, GLenum type, const GLvoid * indices) {
    const char *_name = "glDrawRangeElements";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glDrawRangeElements(GLenum mode, GLuint start, GLuint end, GLsizei count, GLenum type, const GLvoid * indices) {
    PFN_GLDRAWRANGEELEMENTS _ptr;
    _ptr = (PFN_GLDRAWRANGEELEMENTS)_getPrivateProcAddress("glDrawRangeElements");
    if (!_ptr) {
        _ptr = &_fail_glDrawRangeElements;
    }
    _glDrawRangeElements = _ptr;
    _glDrawRangeElements(mode, start, end, count, type, indices);
}

PFN_GLDRAWRANGEELEMENTS _glDrawRangeElements = &_get_glDrawRangeElements;

static void APIENTRY _fail_glTexImage3D(GLenum target, GLint level, GLint internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLenum format, GLenum type, const GLvoid * pixels) {
    const char *_name = "glTexImage3D";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glTexImage3D(GLenum target, GLint level, GLint internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLenum format, GLenum type, const GLvoid * pixels) {
    PFN_GLTEXIMAGE3D _ptr;
    _ptr = (PFN_GLTEXIMAGE3D)_getPrivateProcAddress("glTexImage3D");
    if (!_ptr) {
        _ptr = &_fail_glTexImage3D;
    }
    _glTexImage3D = _ptr;
    _glTexImage3D(target, level, internalformat, width, height, depth, border, format, type, pixels);
}

PFN_GLTEXIMAGE3D _glTexImage3D = &_get_glTexImage3D;

static void APIENTRY _fail_glTexSubImage3D(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, const GLvoid * pixels) {
    const char *_name = "glTexSubImage3D";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glTexSubImage3D(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, const GLvoid * pixels) {
    PFN_GLTEXSUBIMAGE3D _ptr;
    _ptr = (PFN_GLTEXSUBIMAGE3D)_getPrivateProcAddress("glTexSubImage3D");
    if (!_ptr) {
        _ptr = &_fail_glTexSubImage3D;
    }
    _glTexSubImage3D = _ptr;
    _glTexSubImage3D(target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, pixels);
}

PFN_GLTEXSUBIMAGE3D _glTexSubImage3D = &_get_glTexSubImage3D;

static void APIENTRY _fail_glCopyTexSubImage3D(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLint x, GLint y, GLsizei width, GLsizei height) {
    const char *_name = "glCopyTexSubImage3D";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glCopyTexSubImage3D(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLint x, GLint y, GLsizei width, GLsizei height) {
    PFN_GLCOPYTEXSUBIMAGE3D _ptr;
    _ptr = (PFN_GLCOPYTEXSUBIMAGE3D)_getPrivateProcAddress("glCopyTexSubImage3D");
    if (!_ptr) {
        _ptr = &_fail_glCopyTexSubImage3D;
    }
    _glCopyTexSubImage3D = _ptr;
    _glCopyTexSubImage3D(target, level, xoffset, yoffset, zoffset, x, y, width, height);
}

PFN_GLCOPYTEXSUBIMAGE3D _glCopyTexSubImage3D = &_get_glCopyTexSubImage3D;

static void APIENTRY _fail_glColorTable(GLenum target, GLenum internalformat, GLsizei width, GLenum format, GLenum type, const GLvoid * table) {
    const char *_name = "glColorTable";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glColorTable(GLenum target, GLenum internalformat, GLsizei width, GLenum format, GLenum type, const GLvoid * table) {
    PFN_GLCOLORTABLE _ptr;
    _ptr = (PFN_GLCOLORTABLE)_getPrivateProcAddress("glColorTable");
    if (!_ptr) {
        _ptr = &_fail_glColorTable;
    }
    _glColorTable = _ptr;
    _glColorTable(target, internalformat, width, format, type, table);
}

PFN_GLCOLORTABLE _glColorTable = &_get_glColorTable;

static void APIENTRY _fail_glColorTableParameterfv(GLenum target, GLenum pname, const GLfloat * params) {
    const char *_name = "glColorTableParameterfv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glColorTableParameterfv(GLenum target, GLenum pname, const GLfloat * params) {
    PFN_GLCOLORTABLEPARAMETERFV _ptr;
    _ptr = (PFN_GLCOLORTABLEPARAMETERFV)_getPrivateProcAddress("glColorTableParameterfv");
    if (!_ptr) {
        _ptr = &_fail_glColorTableParameterfv;
    }
    _glColorTableParameterfv = _ptr;
    _glColorTableParameterfv(target, pname, params);
}

PFN_GLCOLORTABLEPARAMETERFV _glColorTableParameterfv = &_get_glColorTableParameterfv;

static void APIENTRY _fail_glColorTableParameteriv(GLenum target, GLenum pname, const GLint * params) {
    const char *_name = "glColorTableParameteriv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glColorTableParameteriv(GLenum target, GLenum pname, const GLint * params) {
    PFN_GLCOLORTABLEPARAMETERIV _ptr;
    _ptr = (PFN_GLCOLORTABLEPARAMETERIV)_getPrivateProcAddress("glColorTableParameteriv");
    if (!_ptr) {
        _ptr = &_fail_glColorTableParameteriv;
    }
    _glColorTableParameteriv = _ptr;
    _glColorTableParameteriv(target, pname, params);
}

PFN_GLCOLORTABLEPARAMETERIV _glColorTableParameteriv = &_get_glColorTableParameteriv;

static void APIENTRY _fail_glCopyColorTable(GLenum target, GLenum internalformat, GLint x, GLint y, GLsizei width) {
    const char *_name = "glCopyColorTable";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glCopyColorTable(GLenum target, GLenum internalformat, GLint x, GLint y, GLsizei width) {
    PFN_GLCOPYCOLORTABLE _ptr;
    _ptr = (PFN_GLCOPYCOLORTABLE)_getPrivateProcAddress("glCopyColorTable");
    if (!_ptr) {
        _ptr = &_fail_glCopyColorTable;
    }
    _glCopyColorTable = _ptr;
    _glCopyColorTable(target, internalformat, x, y, width);
}

PFN_GLCOPYCOLORTABLE _glCopyColorTable = &_get_glCopyColorTable;

static void APIENTRY _fail_glGetColorTable(GLenum target, GLenum format, GLenum type, GLvoid * table) {
    const char *_name = "glGetColorTable";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetColorTable(GLenum target, GLenum format, GLenum type, GLvoid * table) {
    PFN_GLGETCOLORTABLE _ptr;
    _ptr = (PFN_GLGETCOLORTABLE)_getPrivateProcAddress("glGetColorTable");
    if (!_ptr) {
        _ptr = &_fail_glGetColorTable;
    }
    _glGetColorTable = _ptr;
    _glGetColorTable(target, format, type, table);
}

PFN_GLGETCOLORTABLE _glGetColorTable = &_get_glGetColorTable;

static void APIENTRY _fail_glGetColorTableParameterfv(GLenum target, GLenum pname, GLfloat * params) {
    const char *_name = "glGetColorTableParameterfv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetColorTableParameterfv(GLenum target, GLenum pname, GLfloat * params) {
    PFN_GLGETCOLORTABLEPARAMETERFV _ptr;
    _ptr = (PFN_GLGETCOLORTABLEPARAMETERFV)_getPrivateProcAddress("glGetColorTableParameterfv");
    if (!_ptr) {
        _ptr = &_fail_glGetColorTableParameterfv;
    }
    _glGetColorTableParameterfv = _ptr;
    _glGetColorTableParameterfv(target, pname, params);
}

PFN_GLGETCOLORTABLEPARAMETERFV _glGetColorTableParameterfv = &_get_glGetColorTableParameterfv;

static void APIENTRY _fail_glGetColorTableParameteriv(GLenum target, GLenum pname, GLint * params) {
    const char *_name = "glGetColorTableParameteriv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetColorTableParameteriv(GLenum target, GLenum pname, GLint * params) {
    PFN_GLGETCOLORTABLEPARAMETERIV _ptr;
    _ptr = (PFN_GLGETCOLORTABLEPARAMETERIV)_getPrivateProcAddress("glGetColorTableParameteriv");
    if (!_ptr) {
        _ptr = &_fail_glGetColorTableParameteriv;
    }
    _glGetColorTableParameteriv = _ptr;
    _glGetColorTableParameteriv(target, pname, params);
}

PFN_GLGETCOLORTABLEPARAMETERIV _glGetColorTableParameteriv = &_get_glGetColorTableParameteriv;

static void APIENTRY _fail_glColorSubTable(GLenum target, GLsizei start, GLsizei count, GLenum format, GLenum type, const GLvoid * data) {
    const char *_name = "glColorSubTable";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glColorSubTable(GLenum target, GLsizei start, GLsizei count, GLenum format, GLenum type, const GLvoid * data) {
    PFN_GLCOLORSUBTABLE _ptr;
    _ptr = (PFN_GLCOLORSUBTABLE)_getPrivateProcAddress("glColorSubTable");
    if (!_ptr) {
        _ptr = &_fail_glColorSubTable;
    }
    _glColorSubTable = _ptr;
    _glColorSubTable(target, start, count, format, type, data);
}

PFN_GLCOLORSUBTABLE _glColorSubTable = &_get_glColorSubTable;

static void APIENTRY _fail_glCopyColorSubTable(GLenum target, GLsizei start, GLint x, GLint y, GLsizei width) {
    const char *_name = "glCopyColorSubTable";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glCopyColorSubTable(GLenum target, GLsizei start, GLint x, GLint y, GLsizei width) {
    PFN_GLCOPYCOLORSUBTABLE _ptr;
    _ptr = (PFN_GLCOPYCOLORSUBTABLE)_getPrivateProcAddress("glCopyColorSubTable");
    if (!_ptr) {
        _ptr = &_fail_glCopyColorSubTable;
    }
    _glCopyColorSubTable = _ptr;
    _glCopyColorSubTable(target, start, x, y, width);
}

PFN_GLCOPYCOLORSUBTABLE _glCopyColorSubTable = &_get_glCopyColorSubTable;

static void APIENTRY _fail_glConvolutionFilter1D(GLenum target, GLenum internalformat, GLsizei width, GLenum format, GLenum type, const GLvoid * image) {
    const char *_name = "glConvolutionFilter1D";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glConvolutionFilter1D(GLenum target, GLenum internalformat, GLsizei width, GLenum format, GLenum type, const GLvoid * image) {
    PFN_GLCONVOLUTIONFILTER1D _ptr;
    _ptr = (PFN_GLCONVOLUTIONFILTER1D)_getPrivateProcAddress("glConvolutionFilter1D");
    if (!_ptr) {
        _ptr = &_fail_glConvolutionFilter1D;
    }
    _glConvolutionFilter1D = _ptr;
    _glConvolutionFilter1D(target, internalformat, width, format, type, image);
}

PFN_GLCONVOLUTIONFILTER1D _glConvolutionFilter1D = &_get_glConvolutionFilter1D;

static void APIENTRY _fail_glConvolutionFilter2D(GLenum target, GLenum internalformat, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid * image) {
    const char *_name = "glConvolutionFilter2D";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glConvolutionFilter2D(GLenum target, GLenum internalformat, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid * image) {
    PFN_GLCONVOLUTIONFILTER2D _ptr;
    _ptr = (PFN_GLCONVOLUTIONFILTER2D)_getPrivateProcAddress("glConvolutionFilter2D");
    if (!_ptr) {
        _ptr = &_fail_glConvolutionFilter2D;
    }
    _glConvolutionFilter2D = _ptr;
    _glConvolutionFilter2D(target, internalformat, width, height, format, type, image);
}

PFN_GLCONVOLUTIONFILTER2D _glConvolutionFilter2D = &_get_glConvolutionFilter2D;

static void APIENTRY _fail_glConvolutionParameterf(GLenum target, GLenum pname, GLfloat params) {
    const char *_name = "glConvolutionParameterf";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glConvolutionParameterf(GLenum target, GLenum pname, GLfloat params) {
    PFN_GLCONVOLUTIONPARAMETERF _ptr;
    _ptr = (PFN_GLCONVOLUTIONPARAMETERF)_getPrivateProcAddress("glConvolutionParameterf");
    if (!_ptr) {
        _ptr = &_fail_glConvolutionParameterf;
    }
    _glConvolutionParameterf = _ptr;
    _glConvolutionParameterf(target, pname, params);
}

PFN_GLCONVOLUTIONPARAMETERF _glConvolutionParameterf = &_get_glConvolutionParameterf;

static void APIENTRY _fail_glConvolutionParameterfv(GLenum target, GLenum pname, const GLfloat * params) {
    const char *_name = "glConvolutionParameterfv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glConvolutionParameterfv(GLenum target, GLenum pname, const GLfloat * params) {
    PFN_GLCONVOLUTIONPARAMETERFV _ptr;
    _ptr = (PFN_GLCONVOLUTIONPARAMETERFV)_getPrivateProcAddress("glConvolutionParameterfv");
    if (!_ptr) {
        _ptr = &_fail_glConvolutionParameterfv;
    }
    _glConvolutionParameterfv = _ptr;
    _glConvolutionParameterfv(target, pname, params);
}

PFN_GLCONVOLUTIONPARAMETERFV _glConvolutionParameterfv = &_get_glConvolutionParameterfv;

static void APIENTRY _fail_glConvolutionParameteri(GLenum target, GLenum pname, GLint params) {
    const char *_name = "glConvolutionParameteri";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glConvolutionParameteri(GLenum target, GLenum pname, GLint params) {
    PFN_GLCONVOLUTIONPARAMETERI _ptr;
    _ptr = (PFN_GLCONVOLUTIONPARAMETERI)_getPrivateProcAddress("glConvolutionParameteri");
    if (!_ptr) {
        _ptr = &_fail_glConvolutionParameteri;
    }
    _glConvolutionParameteri = _ptr;
    _glConvolutionParameteri(target, pname, params);
}

PFN_GLCONVOLUTIONPARAMETERI _glConvolutionParameteri = &_get_glConvolutionParameteri;

static void APIENTRY _fail_glConvolutionParameteriv(GLenum target, GLenum pname, const GLint * params) {
    const char *_name = "glConvolutionParameteriv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glConvolutionParameteriv(GLenum target, GLenum pname, const GLint * params) {
    PFN_GLCONVOLUTIONPARAMETERIV _ptr;
    _ptr = (PFN_GLCONVOLUTIONPARAMETERIV)_getPrivateProcAddress("glConvolutionParameteriv");
    if (!_ptr) {
        _ptr = &_fail_glConvolutionParameteriv;
    }
    _glConvolutionParameteriv = _ptr;
    _glConvolutionParameteriv(target, pname, params);
}

PFN_GLCONVOLUTIONPARAMETERIV _glConvolutionParameteriv = &_get_glConvolutionParameteriv;

static void APIENTRY _fail_glCopyConvolutionFilter1D(GLenum target, GLenum internalformat, GLint x, GLint y, GLsizei width) {
    const char *_name = "glCopyConvolutionFilter1D";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glCopyConvolutionFilter1D(GLenum target, GLenum internalformat, GLint x, GLint y, GLsizei width) {
    PFN_GLCOPYCONVOLUTIONFILTER1D _ptr;
    _ptr = (PFN_GLCOPYCONVOLUTIONFILTER1D)_getPrivateProcAddress("glCopyConvolutionFilter1D");
    if (!_ptr) {
        _ptr = &_fail_glCopyConvolutionFilter1D;
    }
    _glCopyConvolutionFilter1D = _ptr;
    _glCopyConvolutionFilter1D(target, internalformat, x, y, width);
}

PFN_GLCOPYCONVOLUTIONFILTER1D _glCopyConvolutionFilter1D = &_get_glCopyConvolutionFilter1D;

static void APIENTRY _fail_glCopyConvolutionFilter2D(GLenum target, GLenum internalformat, GLint x, GLint y, GLsizei width, GLsizei height) {
    const char *_name = "glCopyConvolutionFilter2D";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glCopyConvolutionFilter2D(GLenum target, GLenum internalformat, GLint x, GLint y, GLsizei width, GLsizei height) {
    PFN_GLCOPYCONVOLUTIONFILTER2D _ptr;
    _ptr = (PFN_GLCOPYCONVOLUTIONFILTER2D)_getPrivateProcAddress("glCopyConvolutionFilter2D");
    if (!_ptr) {
        _ptr = &_fail_glCopyConvolutionFilter2D;
    }
    _glCopyConvolutionFilter2D = _ptr;
    _glCopyConvolutionFilter2D(target, internalformat, x, y, width, height);
}

PFN_GLCOPYCONVOLUTIONFILTER2D _glCopyConvolutionFilter2D = &_get_glCopyConvolutionFilter2D;

static void APIENTRY _fail_glGetConvolutionFilter(GLenum target, GLenum format, GLenum type, GLvoid * image) {
    const char *_name = "glGetConvolutionFilter";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetConvolutionFilter(GLenum target, GLenum format, GLenum type, GLvoid * image) {
    PFN_GLGETCONVOLUTIONFILTER _ptr;
    _ptr = (PFN_GLGETCONVOLUTIONFILTER)_getPrivateProcAddress("glGetConvolutionFilter");
    if (!_ptr) {
        _ptr = &_fail_glGetConvolutionFilter;
    }
    _glGetConvolutionFilter = _ptr;
    _glGetConvolutionFilter(target, format, type, image);
}

PFN_GLGETCONVOLUTIONFILTER _glGetConvolutionFilter = &_get_glGetConvolutionFilter;

static void APIENTRY _fail_glGetConvolutionParameterfv(GLenum target, GLenum pname, GLfloat * params) {
    const char *_name = "glGetConvolutionParameterfv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetConvolutionParameterfv(GLenum target, GLenum pname, GLfloat * params) {
    PFN_GLGETCONVOLUTIONPARAMETERFV _ptr;
    _ptr = (PFN_GLGETCONVOLUTIONPARAMETERFV)_getPrivateProcAddress("glGetConvolutionParameterfv");
    if (!_ptr) {
        _ptr = &_fail_glGetConvolutionParameterfv;
    }
    _glGetConvolutionParameterfv = _ptr;
    _glGetConvolutionParameterfv(target, pname, params);
}

PFN_GLGETCONVOLUTIONPARAMETERFV _glGetConvolutionParameterfv = &_get_glGetConvolutionParameterfv;

static void APIENTRY _fail_glGetConvolutionParameteriv(GLenum target, GLenum pname, GLint * params) {
    const char *_name = "glGetConvolutionParameteriv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetConvolutionParameteriv(GLenum target, GLenum pname, GLint * params) {
    PFN_GLGETCONVOLUTIONPARAMETERIV _ptr;
    _ptr = (PFN_GLGETCONVOLUTIONPARAMETERIV)_getPrivateProcAddress("glGetConvolutionParameteriv");
    if (!_ptr) {
        _ptr = &_fail_glGetConvolutionParameteriv;
    }
    _glGetConvolutionParameteriv = _ptr;
    _glGetConvolutionParameteriv(target, pname, params);
}

PFN_GLGETCONVOLUTIONPARAMETERIV _glGetConvolutionParameteriv = &_get_glGetConvolutionParameteriv;

static void APIENTRY _fail_glGetSeparableFilter(GLenum target, GLenum format, GLenum type, GLvoid * row, GLvoid * column, GLvoid * span) {
    const char *_name = "glGetSeparableFilter";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetSeparableFilter(GLenum target, GLenum format, GLenum type, GLvoid * row, GLvoid * column, GLvoid * span) {
    PFN_GLGETSEPARABLEFILTER _ptr;
    _ptr = (PFN_GLGETSEPARABLEFILTER)_getPrivateProcAddress("glGetSeparableFilter");
    if (!_ptr) {
        _ptr = &_fail_glGetSeparableFilter;
    }
    _glGetSeparableFilter = _ptr;
    _glGetSeparableFilter(target, format, type, row, column, span);
}

PFN_GLGETSEPARABLEFILTER _glGetSeparableFilter = &_get_glGetSeparableFilter;

static void APIENTRY _fail_glSeparableFilter2D(GLenum target, GLenum internalformat, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid * row, const GLvoid * column) {
    const char *_name = "glSeparableFilter2D";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glSeparableFilter2D(GLenum target, GLenum internalformat, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid * row, const GLvoid * column) {
    PFN_GLSEPARABLEFILTER2D _ptr;
    _ptr = (PFN_GLSEPARABLEFILTER2D)_getPrivateProcAddress("glSeparableFilter2D");
    if (!_ptr) {
        _ptr = &_fail_glSeparableFilter2D;
    }
    _glSeparableFilter2D = _ptr;
    _glSeparableFilter2D(target, internalformat, width, height, format, type, row, column);
}

PFN_GLSEPARABLEFILTER2D _glSeparableFilter2D = &_get_glSeparableFilter2D;

static void APIENTRY _fail_glGetHistogram(GLenum target, GLboolean reset, GLenum format, GLenum type, GLvoid * values) {
    const char *_name = "glGetHistogram";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetHistogram(GLenum target, GLboolean reset, GLenum format, GLenum type, GLvoid * values) {
    PFN_GLGETHISTOGRAM _ptr;
    _ptr = (PFN_GLGETHISTOGRAM)_getPrivateProcAddress("glGetHistogram");
    if (!_ptr) {
        _ptr = &_fail_glGetHistogram;
    }
    _glGetHistogram = _ptr;
    _glGetHistogram(target, reset, format, type, values);
}

PFN_GLGETHISTOGRAM _glGetHistogram = &_get_glGetHistogram;

static void APIENTRY _fail_glGetHistogramParameterfv(GLenum target, GLenum pname, GLfloat * params) {
    const char *_name = "glGetHistogramParameterfv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetHistogramParameterfv(GLenum target, GLenum pname, GLfloat * params) {
    PFN_GLGETHISTOGRAMPARAMETERFV _ptr;
    _ptr = (PFN_GLGETHISTOGRAMPARAMETERFV)_getPrivateProcAddress("glGetHistogramParameterfv");
    if (!_ptr) {
        _ptr = &_fail_glGetHistogramParameterfv;
    }
    _glGetHistogramParameterfv = _ptr;
    _glGetHistogramParameterfv(target, pname, params);
}

PFN_GLGETHISTOGRAMPARAMETERFV _glGetHistogramParameterfv = &_get_glGetHistogramParameterfv;

static void APIENTRY _fail_glGetHistogramParameteriv(GLenum target, GLenum pname, GLint * params) {
    const char *_name = "glGetHistogramParameteriv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetHistogramParameteriv(GLenum target, GLenum pname, GLint * params) {
    PFN_GLGETHISTOGRAMPARAMETERIV _ptr;
    _ptr = (PFN_GLGETHISTOGRAMPARAMETERIV)_getPrivateProcAddress("glGetHistogramParameteriv");
    if (!_ptr) {
        _ptr = &_fail_glGetHistogramParameteriv;
    }
    _glGetHistogramParameteriv = _ptr;
    _glGetHistogramParameteriv(target, pname, params);
}

PFN_GLGETHISTOGRAMPARAMETERIV _glGetHistogramParameteriv = &_get_glGetHistogramParameteriv;

static void APIENTRY _fail_glGetMinmax(GLenum target, GLboolean reset, GLenum format, GLenum type, GLvoid * values) {
    const char *_name = "glGetMinmax";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetMinmax(GLenum target, GLboolean reset, GLenum format, GLenum type, GLvoid * values) {
    PFN_GLGETMINMAX _ptr;
    _ptr = (PFN_GLGETMINMAX)_getPrivateProcAddress("glGetMinmax");
    if (!_ptr) {
        _ptr = &_fail_glGetMinmax;
    }
    _glGetMinmax = _ptr;
    _glGetMinmax(target, reset, format, type, values);
}

PFN_GLGETMINMAX _glGetMinmax = &_get_glGetMinmax;

static void APIENTRY _fail_glGetMinmaxParameterfv(GLenum target, GLenum pname, GLfloat * params) {
    const char *_name = "glGetMinmaxParameterfv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetMinmaxParameterfv(GLenum target, GLenum pname, GLfloat * params) {
    PFN_GLGETMINMAXPARAMETERFV _ptr;
    _ptr = (PFN_GLGETMINMAXPARAMETERFV)_getPrivateProcAddress("glGetMinmaxParameterfv");
    if (!_ptr) {
        _ptr = &_fail_glGetMinmaxParameterfv;
    }
    _glGetMinmaxParameterfv = _ptr;
    _glGetMinmaxParameterfv(target, pname, params);
}

PFN_GLGETMINMAXPARAMETERFV _glGetMinmaxParameterfv = &_get_glGetMinmaxParameterfv;

static void APIENTRY _fail_glGetMinmaxParameteriv(GLenum target, GLenum pname, GLint * params) {
    const char *_name = "glGetMinmaxParameteriv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetMinmaxParameteriv(GLenum target, GLenum pname, GLint * params) {
    PFN_GLGETMINMAXPARAMETERIV _ptr;
    _ptr = (PFN_GLGETMINMAXPARAMETERIV)_getPrivateProcAddress("glGetMinmaxParameteriv");
    if (!_ptr) {
        _ptr = &_fail_glGetMinmaxParameteriv;
    }
    _glGetMinmaxParameteriv = _ptr;
    _glGetMinmaxParameteriv(target, pname, params);
}

PFN_GLGETMINMAXPARAMETERIV _glGetMinmaxParameteriv = &_get_glGetMinmaxParameteriv;

static void APIENTRY _fail_glHistogram(GLenum target, GLsizei width, GLenum internalformat, GLboolean sink) {
    const char *_name = "glHistogram";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glHistogram(GLenum target, GLsizei width, GLenum internalformat, GLboolean sink) {
    PFN_GLHISTOGRAM _ptr;
    _ptr = (PFN_GLHISTOGRAM)_getPrivateProcAddress("glHistogram");
    if (!_ptr) {
        _ptr = &_fail_glHistogram;
    }
    _glHistogram = _ptr;
    _glHistogram(target, width, internalformat, sink);
}

PFN_GLHISTOGRAM _glHistogram = &_get_glHistogram;

static void APIENTRY _fail_glMinmax(GLenum target, GLenum internalformat, GLboolean sink) {
    const char *_name = "glMinmax";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glMinmax(GLenum target, GLenum internalformat, GLboolean sink) {
    PFN_GLMINMAX _ptr;
    _ptr = (PFN_GLMINMAX)_getPrivateProcAddress("glMinmax");
    if (!_ptr) {
        _ptr = &_fail_glMinmax;
    }
    _glMinmax = _ptr;
    _glMinmax(target, internalformat, sink);
}

PFN_GLMINMAX _glMinmax = &_get_glMinmax;

static void APIENTRY _fail_glResetHistogram(GLenum target) {
    const char *_name = "glResetHistogram";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glResetHistogram(GLenum target) {
    PFN_GLRESETHISTOGRAM _ptr;
    _ptr = (PFN_GLRESETHISTOGRAM)_getPrivateProcAddress("glResetHistogram");
    if (!_ptr) {
        _ptr = &_fail_glResetHistogram;
    }
    _glResetHistogram = _ptr;
    _glResetHistogram(target);
}

PFN_GLRESETHISTOGRAM _glResetHistogram = &_get_glResetHistogram;

static void APIENTRY _fail_glResetMinmax(GLenum target) {
    const char *_name = "glResetMinmax";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glResetMinmax(GLenum target) {
    PFN_GLRESETMINMAX _ptr;
    _ptr = (PFN_GLRESETMINMAX)_getPrivateProcAddress("glResetMinmax");
    if (!_ptr) {
        _ptr = &_fail_glResetMinmax;
    }
    _glResetMinmax = _ptr;
    _glResetMinmax(target);
}

PFN_GLRESETMINMAX _glResetMinmax = &_get_glResetMinmax;

static void APIENTRY _fail_glActiveTexture(GLenum texture) {
    const char *_name = "glActiveTexture";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glActiveTexture(GLenum texture) {
    PFN_GLACTIVETEXTURE _ptr;
    _ptr = (PFN_GLACTIVETEXTURE)_getPrivateProcAddress("glActiveTexture");
    if (!_ptr) {
        _ptr = &_fail_glActiveTexture;
    }
    _glActiveTexture = _ptr;
    _glActiveTexture(texture);
}

PFN_GLACTIVETEXTURE _glActiveTexture = &_get_glActiveTexture;

static void APIENTRY _fail_glSampleCoverage(GLfloat value, GLboolean invert) {
    const char *_name = "glSampleCoverage";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glSampleCoverage(GLfloat value, GLboolean invert) {
    PFN_GLSAMPLECOVERAGE _ptr;
    _ptr = (PFN_GLSAMPLECOVERAGE)_getPrivateProcAddress("glSampleCoverage");
    if (!_ptr) {
        _ptr = &_fail_glSampleCoverage;
    }
    _glSampleCoverage = _ptr;
    _glSampleCoverage(value, invert);
}

PFN_GLSAMPLECOVERAGE _glSampleCoverage = &_get_glSampleCoverage;

static void APIENTRY _fail_glCompressedTexImage3D(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLsizei imageSize, const GLvoid * data) {
    const char *_name = "glCompressedTexImage3D";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glCompressedTexImage3D(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLsizei imageSize, const GLvoid * data) {
    PFN_GLCOMPRESSEDTEXIMAGE3D _ptr;
    _ptr = (PFN_GLCOMPRESSEDTEXIMAGE3D)_getPrivateProcAddress("glCompressedTexImage3D");
    if (!_ptr) {
        _ptr = &_fail_glCompressedTexImage3D;
    }
    _glCompressedTexImage3D = _ptr;
    _glCompressedTexImage3D(target, level, internalformat, width, height, depth, border, imageSize, data);
}

PFN_GLCOMPRESSEDTEXIMAGE3D _glCompressedTexImage3D = &_get_glCompressedTexImage3D;

static void APIENTRY _fail_glCompressedTexImage2D(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLint border, GLsizei imageSize, const GLvoid * data) {
    const char *_name = "glCompressedTexImage2D";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glCompressedTexImage2D(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLint border, GLsizei imageSize, const GLvoid * data) {
    PFN_GLCOMPRESSEDTEXIMAGE2D _ptr;
    _ptr = (PFN_GLCOMPRESSEDTEXIMAGE2D)_getPrivateProcAddress("glCompressedTexImage2D");
    if (!_ptr) {
        _ptr = &_fail_glCompressedTexImage2D;
    }
    _glCompressedTexImage2D = _ptr;
    _glCompressedTexImage2D(target, level, internalformat, width, height, border, imageSize, data);
}

PFN_GLCOMPRESSEDTEXIMAGE2D _glCompressedTexImage2D = &_get_glCompressedTexImage2D;

static void APIENTRY _fail_glCompressedTexImage1D(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLint border, GLsizei imageSize, const GLvoid * data) {
    const char *_name = "glCompressedTexImage1D";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glCompressedTexImage1D(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLint border, GLsizei imageSize, const GLvoid * data) {
    PFN_GLCOMPRESSEDTEXIMAGE1D _ptr;
    _ptr = (PFN_GLCOMPRESSEDTEXIMAGE1D)_getPrivateProcAddress("glCompressedTexImage1D");
    if (!_ptr) {
        _ptr = &_fail_glCompressedTexImage1D;
    }
    _glCompressedTexImage1D = _ptr;
    _glCompressedTexImage1D(target, level, internalformat, width, border, imageSize, data);
}

PFN_GLCOMPRESSEDTEXIMAGE1D _glCompressedTexImage1D = &_get_glCompressedTexImage1D;

static void APIENTRY _fail_glCompressedTexSubImage3D(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLsizei imageSize, const GLvoid * data) {
    const char *_name = "glCompressedTexSubImage3D";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glCompressedTexSubImage3D(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLsizei imageSize, const GLvoid * data) {
    PFN_GLCOMPRESSEDTEXSUBIMAGE3D _ptr;
    _ptr = (PFN_GLCOMPRESSEDTEXSUBIMAGE3D)_getPrivateProcAddress("glCompressedTexSubImage3D");
    if (!_ptr) {
        _ptr = &_fail_glCompressedTexSubImage3D;
    }
    _glCompressedTexSubImage3D = _ptr;
    _glCompressedTexSubImage3D(target, level, xoffset, yoffset, zoffset, width, height, depth, format, imageSize, data);
}

PFN_GLCOMPRESSEDTEXSUBIMAGE3D _glCompressedTexSubImage3D = &_get_glCompressedTexSubImage3D;

static void APIENTRY _fail_glCompressedTexSubImage2D(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLsizei imageSize, const GLvoid * data) {
    const char *_name = "glCompressedTexSubImage2D";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glCompressedTexSubImage2D(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLsizei imageSize, const GLvoid * data) {
    PFN_GLCOMPRESSEDTEXSUBIMAGE2D _ptr;
    _ptr = (PFN_GLCOMPRESSEDTEXSUBIMAGE2D)_getPrivateProcAddress("glCompressedTexSubImage2D");
    if (!_ptr) {
        _ptr = &_fail_glCompressedTexSubImage2D;
    }
    _glCompressedTexSubImage2D = _ptr;
    _glCompressedTexSubImage2D(target, level, xoffset, yoffset, width, height, format, imageSize, data);
}

PFN_GLCOMPRESSEDTEXSUBIMAGE2D _glCompressedTexSubImage2D = &_get_glCompressedTexSubImage2D;

static void APIENTRY _fail_glCompressedTexSubImage1D(GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLsizei imageSize, const GLvoid * data) {
    const char *_name = "glCompressedTexSubImage1D";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glCompressedTexSubImage1D(GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLsizei imageSize, const GLvoid * data) {
    PFN_GLCOMPRESSEDTEXSUBIMAGE1D _ptr;
    _ptr = (PFN_GLCOMPRESSEDTEXSUBIMAGE1D)_getPrivateProcAddress("glCompressedTexSubImage1D");
    if (!_ptr) {
        _ptr = &_fail_glCompressedTexSubImage1D;
    }
    _glCompressedTexSubImage1D = _ptr;
    _glCompressedTexSubImage1D(target, level, xoffset, width, format, imageSize, data);
}

PFN_GLCOMPRESSEDTEXSUBIMAGE1D _glCompressedTexSubImage1D = &_get_glCompressedTexSubImage1D;

static void APIENTRY _fail_glGetCompressedTexImage(GLenum target, GLint level, GLvoid * img) {
    const char *_name = "glGetCompressedTexImage";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetCompressedTexImage(GLenum target, GLint level, GLvoid * img) {
    PFN_GLGETCOMPRESSEDTEXIMAGE _ptr;
    _ptr = (PFN_GLGETCOMPRESSEDTEXIMAGE)_getPrivateProcAddress("glGetCompressedTexImage");
    if (!_ptr) {
        _ptr = &_fail_glGetCompressedTexImage;
    }
    _glGetCompressedTexImage = _ptr;
    _glGetCompressedTexImage(target, level, img);
}

PFN_GLGETCOMPRESSEDTEXIMAGE _glGetCompressedTexImage = &_get_glGetCompressedTexImage;

static void APIENTRY _fail_glClientActiveTexture(GLenum texture) {
    const char *_name = "glClientActiveTexture";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glClientActiveTexture(GLenum texture) {
    PFN_GLCLIENTACTIVETEXTURE _ptr;
    _ptr = (PFN_GLCLIENTACTIVETEXTURE)_getPrivateProcAddress("glClientActiveTexture");
    if (!_ptr) {
        _ptr = &_fail_glClientActiveTexture;
    }
    _glClientActiveTexture = _ptr;
    _glClientActiveTexture(texture);
}

PFN_GLCLIENTACTIVETEXTURE _glClientActiveTexture = &_get_glClientActiveTexture;

static void APIENTRY _fail_glMultiTexCoord1d(GLenum target, GLdouble s) {
    const char *_name = "glMultiTexCoord1d";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glMultiTexCoord1d(GLenum target, GLdouble s) {
    PFN_GLMULTITEXCOORD1D _ptr;
    _ptr = (PFN_GLMULTITEXCOORD1D)_getPrivateProcAddress("glMultiTexCoord1d");
    if (!_ptr) {
        _ptr = &_fail_glMultiTexCoord1d;
    }
    _glMultiTexCoord1d = _ptr;
    _glMultiTexCoord1d(target, s);
}

PFN_GLMULTITEXCOORD1D _glMultiTexCoord1d = &_get_glMultiTexCoord1d;

static void APIENTRY _fail_glMultiTexCoord1dv(GLenum target, const GLdouble * v) {
    const char *_name = "glMultiTexCoord1dv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glMultiTexCoord1dv(GLenum target, const GLdouble * v) {
    PFN_GLMULTITEXCOORD1DV _ptr;
    _ptr = (PFN_GLMULTITEXCOORD1DV)_getPrivateProcAddress("glMultiTexCoord1dv");
    if (!_ptr) {
        _ptr = &_fail_glMultiTexCoord1dv;
    }
    _glMultiTexCoord1dv = _ptr;
    _glMultiTexCoord1dv(target, v);
}

PFN_GLMULTITEXCOORD1DV _glMultiTexCoord1dv = &_get_glMultiTexCoord1dv;

static void APIENTRY _fail_glMultiTexCoord1f(GLenum target, GLfloat s) {
    const char *_name = "glMultiTexCoord1f";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glMultiTexCoord1f(GLenum target, GLfloat s) {
    PFN_GLMULTITEXCOORD1F _ptr;
    _ptr = (PFN_GLMULTITEXCOORD1F)_getPrivateProcAddress("glMultiTexCoord1f");
    if (!_ptr) {
        _ptr = &_fail_glMultiTexCoord1f;
    }
    _glMultiTexCoord1f = _ptr;
    _glMultiTexCoord1f(target, s);
}

PFN_GLMULTITEXCOORD1F _glMultiTexCoord1f = &_get_glMultiTexCoord1f;

static void APIENTRY _fail_glMultiTexCoord1fv(GLenum target, const GLfloat * v) {
    const char *_name = "glMultiTexCoord1fv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glMultiTexCoord1fv(GLenum target, const GLfloat * v) {
    PFN_GLMULTITEXCOORD1FV _ptr;
    _ptr = (PFN_GLMULTITEXCOORD1FV)_getPrivateProcAddress("glMultiTexCoord1fv");
    if (!_ptr) {
        _ptr = &_fail_glMultiTexCoord1fv;
    }
    _glMultiTexCoord1fv = _ptr;
    _glMultiTexCoord1fv(target, v);
}

PFN_GLMULTITEXCOORD1FV _glMultiTexCoord1fv = &_get_glMultiTexCoord1fv;

static void APIENTRY _fail_glMultiTexCoord1i(GLenum target, GLint s) {
    const char *_name = "glMultiTexCoord1i";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glMultiTexCoord1i(GLenum target, GLint s) {
    PFN_GLMULTITEXCOORD1I _ptr;
    _ptr = (PFN_GLMULTITEXCOORD1I)_getPrivateProcAddress("glMultiTexCoord1i");
    if (!_ptr) {
        _ptr = &_fail_glMultiTexCoord1i;
    }
    _glMultiTexCoord1i = _ptr;
    _glMultiTexCoord1i(target, s);
}

PFN_GLMULTITEXCOORD1I _glMultiTexCoord1i = &_get_glMultiTexCoord1i;

static void APIENTRY _fail_glMultiTexCoord1iv(GLenum target, const GLint * v) {
    const char *_name = "glMultiTexCoord1iv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glMultiTexCoord1iv(GLenum target, const GLint * v) {
    PFN_GLMULTITEXCOORD1IV _ptr;
    _ptr = (PFN_GLMULTITEXCOORD1IV)_getPrivateProcAddress("glMultiTexCoord1iv");
    if (!_ptr) {
        _ptr = &_fail_glMultiTexCoord1iv;
    }
    _glMultiTexCoord1iv = _ptr;
    _glMultiTexCoord1iv(target, v);
}

PFN_GLMULTITEXCOORD1IV _glMultiTexCoord1iv = &_get_glMultiTexCoord1iv;

static void APIENTRY _fail_glMultiTexCoord1s(GLenum target, GLshort s) {
    const char *_name = "glMultiTexCoord1s";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glMultiTexCoord1s(GLenum target, GLshort s) {
    PFN_GLMULTITEXCOORD1S _ptr;
    _ptr = (PFN_GLMULTITEXCOORD1S)_getPrivateProcAddress("glMultiTexCoord1s");
    if (!_ptr) {
        _ptr = &_fail_glMultiTexCoord1s;
    }
    _glMultiTexCoord1s = _ptr;
    _glMultiTexCoord1s(target, s);
}

PFN_GLMULTITEXCOORD1S _glMultiTexCoord1s = &_get_glMultiTexCoord1s;

static void APIENTRY _fail_glMultiTexCoord1sv(GLenum target, const GLshort * v) {
    const char *_name = "glMultiTexCoord1sv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glMultiTexCoord1sv(GLenum target, const GLshort * v) {
    PFN_GLMULTITEXCOORD1SV _ptr;
    _ptr = (PFN_GLMULTITEXCOORD1SV)_getPrivateProcAddress("glMultiTexCoord1sv");
    if (!_ptr) {
        _ptr = &_fail_glMultiTexCoord1sv;
    }
    _glMultiTexCoord1sv = _ptr;
    _glMultiTexCoord1sv(target, v);
}

PFN_GLMULTITEXCOORD1SV _glMultiTexCoord1sv = &_get_glMultiTexCoord1sv;

static void APIENTRY _fail_glMultiTexCoord2d(GLenum target, GLdouble s, GLdouble t) {
    const char *_name = "glMultiTexCoord2d";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glMultiTexCoord2d(GLenum target, GLdouble s, GLdouble t) {
    PFN_GLMULTITEXCOORD2D _ptr;
    _ptr = (PFN_GLMULTITEXCOORD2D)_getPrivateProcAddress("glMultiTexCoord2d");
    if (!_ptr) {
        _ptr = &_fail_glMultiTexCoord2d;
    }
    _glMultiTexCoord2d = _ptr;
    _glMultiTexCoord2d(target, s, t);
}

PFN_GLMULTITEXCOORD2D _glMultiTexCoord2d = &_get_glMultiTexCoord2d;

static void APIENTRY _fail_glMultiTexCoord2dv(GLenum target, const GLdouble * v) {
    const char *_name = "glMultiTexCoord2dv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glMultiTexCoord2dv(GLenum target, const GLdouble * v) {
    PFN_GLMULTITEXCOORD2DV _ptr;
    _ptr = (PFN_GLMULTITEXCOORD2DV)_getPrivateProcAddress("glMultiTexCoord2dv");
    if (!_ptr) {
        _ptr = &_fail_glMultiTexCoord2dv;
    }
    _glMultiTexCoord2dv = _ptr;
    _glMultiTexCoord2dv(target, v);
}

PFN_GLMULTITEXCOORD2DV _glMultiTexCoord2dv = &_get_glMultiTexCoord2dv;

static void APIENTRY _fail_glMultiTexCoord2f(GLenum target, GLfloat s, GLfloat t) {
    const char *_name = "glMultiTexCoord2f";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glMultiTexCoord2f(GLenum target, GLfloat s, GLfloat t) {
    PFN_GLMULTITEXCOORD2F _ptr;
    _ptr = (PFN_GLMULTITEXCOORD2F)_getPrivateProcAddress("glMultiTexCoord2f");
    if (!_ptr) {
        _ptr = &_fail_glMultiTexCoord2f;
    }
    _glMultiTexCoord2f = _ptr;
    _glMultiTexCoord2f(target, s, t);
}

PFN_GLMULTITEXCOORD2F _glMultiTexCoord2f = &_get_glMultiTexCoord2f;

static void APIENTRY _fail_glMultiTexCoord2fv(GLenum target, const GLfloat * v) {
    const char *_name = "glMultiTexCoord2fv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glMultiTexCoord2fv(GLenum target, const GLfloat * v) {
    PFN_GLMULTITEXCOORD2FV _ptr;
    _ptr = (PFN_GLMULTITEXCOORD2FV)_getPrivateProcAddress("glMultiTexCoord2fv");
    if (!_ptr) {
        _ptr = &_fail_glMultiTexCoord2fv;
    }
    _glMultiTexCoord2fv = _ptr;
    _glMultiTexCoord2fv(target, v);
}

PFN_GLMULTITEXCOORD2FV _glMultiTexCoord2fv = &_get_glMultiTexCoord2fv;

static void APIENTRY _fail_glMultiTexCoord2i(GLenum target, GLint s, GLint t) {
    const char *_name = "glMultiTexCoord2i";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glMultiTexCoord2i(GLenum target, GLint s, GLint t) {
    PFN_GLMULTITEXCOORD2I _ptr;
    _ptr = (PFN_GLMULTITEXCOORD2I)_getPrivateProcAddress("glMultiTexCoord2i");
    if (!_ptr) {
        _ptr = &_fail_glMultiTexCoord2i;
    }
    _glMultiTexCoord2i = _ptr;
    _glMultiTexCoord2i(target, s, t);
}

PFN_GLMULTITEXCOORD2I _glMultiTexCoord2i = &_get_glMultiTexCoord2i;

static void APIENTRY _fail_glMultiTexCoord2iv(GLenum target, const GLint * v) {
    const char *_name = "glMultiTexCoord2iv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glMultiTexCoord2iv(GLenum target, const GLint * v) {
    PFN_GLMULTITEXCOORD2IV _ptr;
    _ptr = (PFN_GLMULTITEXCOORD2IV)_getPrivateProcAddress("glMultiTexCoord2iv");
    if (!_ptr) {
        _ptr = &_fail_glMultiTexCoord2iv;
    }
    _glMultiTexCoord2iv = _ptr;
    _glMultiTexCoord2iv(target, v);
}

PFN_GLMULTITEXCOORD2IV _glMultiTexCoord2iv = &_get_glMultiTexCoord2iv;

static void APIENTRY _fail_glMultiTexCoord2s(GLenum target, GLshort s, GLshort t) {
    const char *_name = "glMultiTexCoord2s";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glMultiTexCoord2s(GLenum target, GLshort s, GLshort t) {
    PFN_GLMULTITEXCOORD2S _ptr;
    _ptr = (PFN_GLMULTITEXCOORD2S)_getPrivateProcAddress("glMultiTexCoord2s");
    if (!_ptr) {
        _ptr = &_fail_glMultiTexCoord2s;
    }
    _glMultiTexCoord2s = _ptr;
    _glMultiTexCoord2s(target, s, t);
}

PFN_GLMULTITEXCOORD2S _glMultiTexCoord2s = &_get_glMultiTexCoord2s;

static void APIENTRY _fail_glMultiTexCoord2sv(GLenum target, const GLshort * v) {
    const char *_name = "glMultiTexCoord2sv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glMultiTexCoord2sv(GLenum target, const GLshort * v) {
    PFN_GLMULTITEXCOORD2SV _ptr;
    _ptr = (PFN_GLMULTITEXCOORD2SV)_getPrivateProcAddress("glMultiTexCoord2sv");
    if (!_ptr) {
        _ptr = &_fail_glMultiTexCoord2sv;
    }
    _glMultiTexCoord2sv = _ptr;
    _glMultiTexCoord2sv(target, v);
}

PFN_GLMULTITEXCOORD2SV _glMultiTexCoord2sv = &_get_glMultiTexCoord2sv;

static void APIENTRY _fail_glMultiTexCoord3d(GLenum target, GLdouble s, GLdouble t, GLdouble r) {
    const char *_name = "glMultiTexCoord3d";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glMultiTexCoord3d(GLenum target, GLdouble s, GLdouble t, GLdouble r) {
    PFN_GLMULTITEXCOORD3D _ptr;
    _ptr = (PFN_GLMULTITEXCOORD3D)_getPrivateProcAddress("glMultiTexCoord3d");
    if (!_ptr) {
        _ptr = &_fail_glMultiTexCoord3d;
    }
    _glMultiTexCoord3d = _ptr;
    _glMultiTexCoord3d(target, s, t, r);
}

PFN_GLMULTITEXCOORD3D _glMultiTexCoord3d = &_get_glMultiTexCoord3d;

static void APIENTRY _fail_glMultiTexCoord3dv(GLenum target, const GLdouble * v) {
    const char *_name = "glMultiTexCoord3dv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glMultiTexCoord3dv(GLenum target, const GLdouble * v) {
    PFN_GLMULTITEXCOORD3DV _ptr;
    _ptr = (PFN_GLMULTITEXCOORD3DV)_getPrivateProcAddress("glMultiTexCoord3dv");
    if (!_ptr) {
        _ptr = &_fail_glMultiTexCoord3dv;
    }
    _glMultiTexCoord3dv = _ptr;
    _glMultiTexCoord3dv(target, v);
}

PFN_GLMULTITEXCOORD3DV _glMultiTexCoord3dv = &_get_glMultiTexCoord3dv;

static void APIENTRY _fail_glMultiTexCoord3f(GLenum target, GLfloat s, GLfloat t, GLfloat r) {
    const char *_name = "glMultiTexCoord3f";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glMultiTexCoord3f(GLenum target, GLfloat s, GLfloat t, GLfloat r) {
    PFN_GLMULTITEXCOORD3F _ptr;
    _ptr = (PFN_GLMULTITEXCOORD3F)_getPrivateProcAddress("glMultiTexCoord3f");
    if (!_ptr) {
        _ptr = &_fail_glMultiTexCoord3f;
    }
    _glMultiTexCoord3f = _ptr;
    _glMultiTexCoord3f(target, s, t, r);
}

PFN_GLMULTITEXCOORD3F _glMultiTexCoord3f = &_get_glMultiTexCoord3f;

static void APIENTRY _fail_glMultiTexCoord3fv(GLenum target, const GLfloat * v) {
    const char *_name = "glMultiTexCoord3fv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glMultiTexCoord3fv(GLenum target, const GLfloat * v) {
    PFN_GLMULTITEXCOORD3FV _ptr;
    _ptr = (PFN_GLMULTITEXCOORD3FV)_getPrivateProcAddress("glMultiTexCoord3fv");
    if (!_ptr) {
        _ptr = &_fail_glMultiTexCoord3fv;
    }
    _glMultiTexCoord3fv = _ptr;
    _glMultiTexCoord3fv(target, v);
}

PFN_GLMULTITEXCOORD3FV _glMultiTexCoord3fv = &_get_glMultiTexCoord3fv;

static void APIENTRY _fail_glMultiTexCoord3i(GLenum target, GLint s, GLint t, GLint r) {
    const char *_name = "glMultiTexCoord3i";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glMultiTexCoord3i(GLenum target, GLint s, GLint t, GLint r) {
    PFN_GLMULTITEXCOORD3I _ptr;
    _ptr = (PFN_GLMULTITEXCOORD3I)_getPrivateProcAddress("glMultiTexCoord3i");
    if (!_ptr) {
        _ptr = &_fail_glMultiTexCoord3i;
    }
    _glMultiTexCoord3i = _ptr;
    _glMultiTexCoord3i(target, s, t, r);
}

PFN_GLMULTITEXCOORD3I _glMultiTexCoord3i = &_get_glMultiTexCoord3i;

static void APIENTRY _fail_glMultiTexCoord3iv(GLenum target, const GLint * v) {
    const char *_name = "glMultiTexCoord3iv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glMultiTexCoord3iv(GLenum target, const GLint * v) {
    PFN_GLMULTITEXCOORD3IV _ptr;
    _ptr = (PFN_GLMULTITEXCOORD3IV)_getPrivateProcAddress("glMultiTexCoord3iv");
    if (!_ptr) {
        _ptr = &_fail_glMultiTexCoord3iv;
    }
    _glMultiTexCoord3iv = _ptr;
    _glMultiTexCoord3iv(target, v);
}

PFN_GLMULTITEXCOORD3IV _glMultiTexCoord3iv = &_get_glMultiTexCoord3iv;

static void APIENTRY _fail_glMultiTexCoord3s(GLenum target, GLshort s, GLshort t, GLshort r) {
    const char *_name = "glMultiTexCoord3s";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glMultiTexCoord3s(GLenum target, GLshort s, GLshort t, GLshort r) {
    PFN_GLMULTITEXCOORD3S _ptr;
    _ptr = (PFN_GLMULTITEXCOORD3S)_getPrivateProcAddress("glMultiTexCoord3s");
    if (!_ptr) {
        _ptr = &_fail_glMultiTexCoord3s;
    }
    _glMultiTexCoord3s = _ptr;
    _glMultiTexCoord3s(target, s, t, r);
}

PFN_GLMULTITEXCOORD3S _glMultiTexCoord3s = &_get_glMultiTexCoord3s;

static void APIENTRY _fail_glMultiTexCoord3sv(GLenum target, const GLshort * v) {
    const char *_name = "glMultiTexCoord3sv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glMultiTexCoord3sv(GLenum target, const GLshort * v) {
    PFN_GLMULTITEXCOORD3SV _ptr;
    _ptr = (PFN_GLMULTITEXCOORD3SV)_getPrivateProcAddress("glMultiTexCoord3sv");
    if (!_ptr) {
        _ptr = &_fail_glMultiTexCoord3sv;
    }
    _glMultiTexCoord3sv = _ptr;
    _glMultiTexCoord3sv(target, v);
}

PFN_GLMULTITEXCOORD3SV _glMultiTexCoord3sv = &_get_glMultiTexCoord3sv;

static void APIENTRY _fail_glMultiTexCoord4d(GLenum target, GLdouble s, GLdouble t, GLdouble r, GLdouble q) {
    const char *_name = "glMultiTexCoord4d";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glMultiTexCoord4d(GLenum target, GLdouble s, GLdouble t, GLdouble r, GLdouble q) {
    PFN_GLMULTITEXCOORD4D _ptr;
    _ptr = (PFN_GLMULTITEXCOORD4D)_getPrivateProcAddress("glMultiTexCoord4d");
    if (!_ptr) {
        _ptr = &_fail_glMultiTexCoord4d;
    }
    _glMultiTexCoord4d = _ptr;
    _glMultiTexCoord4d(target, s, t, r, q);
}

PFN_GLMULTITEXCOORD4D _glMultiTexCoord4d = &_get_glMultiTexCoord4d;

static void APIENTRY _fail_glMultiTexCoord4dv(GLenum target, const GLdouble * v) {
    const char *_name = "glMultiTexCoord4dv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glMultiTexCoord4dv(GLenum target, const GLdouble * v) {
    PFN_GLMULTITEXCOORD4DV _ptr;
    _ptr = (PFN_GLMULTITEXCOORD4DV)_getPrivateProcAddress("glMultiTexCoord4dv");
    if (!_ptr) {
        _ptr = &_fail_glMultiTexCoord4dv;
    }
    _glMultiTexCoord4dv = _ptr;
    _glMultiTexCoord4dv(target, v);
}

PFN_GLMULTITEXCOORD4DV _glMultiTexCoord4dv = &_get_glMultiTexCoord4dv;

static void APIENTRY _fail_glMultiTexCoord4f(GLenum target, GLfloat s, GLfloat t, GLfloat r, GLfloat q) {
    const char *_name = "glMultiTexCoord4f";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glMultiTexCoord4f(GLenum target, GLfloat s, GLfloat t, GLfloat r, GLfloat q) {
    PFN_GLMULTITEXCOORD4F _ptr;
    _ptr = (PFN_GLMULTITEXCOORD4F)_getPrivateProcAddress("glMultiTexCoord4f");
    if (!_ptr) {
        _ptr = &_fail_glMultiTexCoord4f;
    }
    _glMultiTexCoord4f = _ptr;
    _glMultiTexCoord4f(target, s, t, r, q);
}

PFN_GLMULTITEXCOORD4F _glMultiTexCoord4f = &_get_glMultiTexCoord4f;

static void APIENTRY _fail_glMultiTexCoord4fv(GLenum target, const GLfloat * v) {
    const char *_name = "glMultiTexCoord4fv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glMultiTexCoord4fv(GLenum target, const GLfloat * v) {
    PFN_GLMULTITEXCOORD4FV _ptr;
    _ptr = (PFN_GLMULTITEXCOORD4FV)_getPrivateProcAddress("glMultiTexCoord4fv");
    if (!_ptr) {
        _ptr = &_fail_glMultiTexCoord4fv;
    }
    _glMultiTexCoord4fv = _ptr;
    _glMultiTexCoord4fv(target, v);
}

PFN_GLMULTITEXCOORD4FV _glMultiTexCoord4fv = &_get_glMultiTexCoord4fv;

static void APIENTRY _fail_glMultiTexCoord4i(GLenum target, GLint s, GLint t, GLint r, GLint q) {
    const char *_name = "glMultiTexCoord4i";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glMultiTexCoord4i(GLenum target, GLint s, GLint t, GLint r, GLint q) {
    PFN_GLMULTITEXCOORD4I _ptr;
    _ptr = (PFN_GLMULTITEXCOORD4I)_getPrivateProcAddress("glMultiTexCoord4i");
    if (!_ptr) {
        _ptr = &_fail_glMultiTexCoord4i;
    }
    _glMultiTexCoord4i = _ptr;
    _glMultiTexCoord4i(target, s, t, r, q);
}

PFN_GLMULTITEXCOORD4I _glMultiTexCoord4i = &_get_glMultiTexCoord4i;

static void APIENTRY _fail_glMultiTexCoord4iv(GLenum target, const GLint * v) {
    const char *_name = "glMultiTexCoord4iv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glMultiTexCoord4iv(GLenum target, const GLint * v) {
    PFN_GLMULTITEXCOORD4IV _ptr;
    _ptr = (PFN_GLMULTITEXCOORD4IV)_getPrivateProcAddress("glMultiTexCoord4iv");
    if (!_ptr) {
        _ptr = &_fail_glMultiTexCoord4iv;
    }
    _glMultiTexCoord4iv = _ptr;
    _glMultiTexCoord4iv(target, v);
}

PFN_GLMULTITEXCOORD4IV _glMultiTexCoord4iv = &_get_glMultiTexCoord4iv;

static void APIENTRY _fail_glMultiTexCoord4s(GLenum target, GLshort s, GLshort t, GLshort r, GLshort q) {
    const char *_name = "glMultiTexCoord4s";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glMultiTexCoord4s(GLenum target, GLshort s, GLshort t, GLshort r, GLshort q) {
    PFN_GLMULTITEXCOORD4S _ptr;
    _ptr = (PFN_GLMULTITEXCOORD4S)_getPrivateProcAddress("glMultiTexCoord4s");
    if (!_ptr) {
        _ptr = &_fail_glMultiTexCoord4s;
    }
    _glMultiTexCoord4s = _ptr;
    _glMultiTexCoord4s(target, s, t, r, q);
}

PFN_GLMULTITEXCOORD4S _glMultiTexCoord4s = &_get_glMultiTexCoord4s;

static void APIENTRY _fail_glMultiTexCoord4sv(GLenum target, const GLshort * v) {
    const char *_name = "glMultiTexCoord4sv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glMultiTexCoord4sv(GLenum target, const GLshort * v) {
    PFN_GLMULTITEXCOORD4SV _ptr;
    _ptr = (PFN_GLMULTITEXCOORD4SV)_getPrivateProcAddress("glMultiTexCoord4sv");
    if (!_ptr) {
        _ptr = &_fail_glMultiTexCoord4sv;
    }
    _glMultiTexCoord4sv = _ptr;
    _glMultiTexCoord4sv(target, v);
}

PFN_GLMULTITEXCOORD4SV _glMultiTexCoord4sv = &_get_glMultiTexCoord4sv;

static void APIENTRY _fail_glLoadTransposeMatrixf(const GLfloat * m) {
    const char *_name = "glLoadTransposeMatrixf";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glLoadTransposeMatrixf(const GLfloat * m) {
    PFN_GLLOADTRANSPOSEMATRIXF _ptr;
    _ptr = (PFN_GLLOADTRANSPOSEMATRIXF)_getPrivateProcAddress("glLoadTransposeMatrixf");
    if (!_ptr) {
        _ptr = &_fail_glLoadTransposeMatrixf;
    }
    _glLoadTransposeMatrixf = _ptr;
    _glLoadTransposeMatrixf(m);
}

PFN_GLLOADTRANSPOSEMATRIXF _glLoadTransposeMatrixf = &_get_glLoadTransposeMatrixf;

static void APIENTRY _fail_glLoadTransposeMatrixd(const GLdouble * m) {
    const char *_name = "glLoadTransposeMatrixd";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glLoadTransposeMatrixd(const GLdouble * m) {
    PFN_GLLOADTRANSPOSEMATRIXD _ptr;
    _ptr = (PFN_GLLOADTRANSPOSEMATRIXD)_getPrivateProcAddress("glLoadTransposeMatrixd");
    if (!_ptr) {
        _ptr = &_fail_glLoadTransposeMatrixd;
    }
    _glLoadTransposeMatrixd = _ptr;
    _glLoadTransposeMatrixd(m);
}

PFN_GLLOADTRANSPOSEMATRIXD _glLoadTransposeMatrixd = &_get_glLoadTransposeMatrixd;

static void APIENTRY _fail_glMultTransposeMatrixf(const GLfloat * m) {
    const char *_name = "glMultTransposeMatrixf";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glMultTransposeMatrixf(const GLfloat * m) {
    PFN_GLMULTTRANSPOSEMATRIXF _ptr;
    _ptr = (PFN_GLMULTTRANSPOSEMATRIXF)_getPrivateProcAddress("glMultTransposeMatrixf");
    if (!_ptr) {
        _ptr = &_fail_glMultTransposeMatrixf;
    }
    _glMultTransposeMatrixf = _ptr;
    _glMultTransposeMatrixf(m);
}

PFN_GLMULTTRANSPOSEMATRIXF _glMultTransposeMatrixf = &_get_glMultTransposeMatrixf;

static void APIENTRY _fail_glMultTransposeMatrixd(const GLdouble * m) {
    const char *_name = "glMultTransposeMatrixd";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glMultTransposeMatrixd(const GLdouble * m) {
    PFN_GLMULTTRANSPOSEMATRIXD _ptr;
    _ptr = (PFN_GLMULTTRANSPOSEMATRIXD)_getPrivateProcAddress("glMultTransposeMatrixd");
    if (!_ptr) {
        _ptr = &_fail_glMultTransposeMatrixd;
    }
    _glMultTransposeMatrixd = _ptr;
    _glMultTransposeMatrixd(m);
}

PFN_GLMULTTRANSPOSEMATRIXD _glMultTransposeMatrixd = &_get_glMultTransposeMatrixd;

static void APIENTRY _fail_glBlendFuncSeparate(GLenum sfactorRGB, GLenum dfactorRGB, GLenum sfactorAlpha, GLenum dfactorAlpha) {
    const char *_name = "glBlendFuncSeparate";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glBlendFuncSeparate(GLenum sfactorRGB, GLenum dfactorRGB, GLenum sfactorAlpha, GLenum dfactorAlpha) {
    PFN_GLBLENDFUNCSEPARATE _ptr;
    _ptr = (PFN_GLBLENDFUNCSEPARATE)_getPrivateProcAddress("glBlendFuncSeparate");
    if (!_ptr) {
        _ptr = &_fail_glBlendFuncSeparate;
    }
    _glBlendFuncSeparate = _ptr;
    _glBlendFuncSeparate(sfactorRGB, dfactorRGB, sfactorAlpha, dfactorAlpha);
}

PFN_GLBLENDFUNCSEPARATE _glBlendFuncSeparate = &_get_glBlendFuncSeparate;

static void APIENTRY _fail_glMultiDrawArrays(GLenum mode, const GLint * first, const GLsizei * count, GLsizei drawcount) {
    const char *_name = "glMultiDrawArrays";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glMultiDrawArrays(GLenum mode, const GLint * first, const GLsizei * count, GLsizei drawcount) {
    PFN_GLMULTIDRAWARRAYS _ptr;
    _ptr = (PFN_GLMULTIDRAWARRAYS)_getPrivateProcAddress("glMultiDrawArrays");
    if (!_ptr) {
        _ptr = &_fail_glMultiDrawArrays;
    }
    _glMultiDrawArrays = _ptr;
    _glMultiDrawArrays(mode, first, count, drawcount);
}

PFN_GLMULTIDRAWARRAYS _glMultiDrawArrays = &_get_glMultiDrawArrays;

static void APIENTRY _fail_glMultiDrawElements(GLenum mode, const GLsizei * count, GLenum type, const GLvoid * const * indices, GLsizei drawcount) {
    const char *_name = "glMultiDrawElements";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glMultiDrawElements(GLenum mode, const GLsizei * count, GLenum type, const GLvoid * const * indices, GLsizei drawcount) {
    PFN_GLMULTIDRAWELEMENTS _ptr;
    _ptr = (PFN_GLMULTIDRAWELEMENTS)_getPrivateProcAddress("glMultiDrawElements");
    if (!_ptr) {
        _ptr = &_fail_glMultiDrawElements;
    }
    _glMultiDrawElements = _ptr;
    _glMultiDrawElements(mode, count, type, indices, drawcount);
}

PFN_GLMULTIDRAWELEMENTS _glMultiDrawElements = &_get_glMultiDrawElements;

static void APIENTRY _fail_glPointParameterf(GLenum pname, GLfloat param) {
    const char *_name = "glPointParameterf";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glPointParameterf(GLenum pname, GLfloat param) {
    PFN_GLPOINTPARAMETERF _ptr;
    _ptr = (PFN_GLPOINTPARAMETERF)_getPrivateProcAddress("glPointParameterf");
    if (!_ptr) {
        _ptr = &_fail_glPointParameterf;
    }
    _glPointParameterf = _ptr;
    _glPointParameterf(pname, param);
}

PFN_GLPOINTPARAMETERF _glPointParameterf = &_get_glPointParameterf;

static void APIENTRY _fail_glPointParameterfv(GLenum pname, const GLfloat * params) {
    const char *_name = "glPointParameterfv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glPointParameterfv(GLenum pname, const GLfloat * params) {
    PFN_GLPOINTPARAMETERFV _ptr;
    _ptr = (PFN_GLPOINTPARAMETERFV)_getPrivateProcAddress("glPointParameterfv");
    if (!_ptr) {
        _ptr = &_fail_glPointParameterfv;
    }
    _glPointParameterfv = _ptr;
    _glPointParameterfv(pname, params);
}

PFN_GLPOINTPARAMETERFV _glPointParameterfv = &_get_glPointParameterfv;

static void APIENTRY _fail_glPointParameteri(GLenum pname, GLint param) {
    const char *_name = "glPointParameteri";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glPointParameteri(GLenum pname, GLint param) {
    PFN_GLPOINTPARAMETERI _ptr;
    _ptr = (PFN_GLPOINTPARAMETERI)_getPrivateProcAddress("glPointParameteri");
    if (!_ptr) {
        _ptr = &_fail_glPointParameteri;
    }
    _glPointParameteri = _ptr;
    _glPointParameteri(pname, param);
}

PFN_GLPOINTPARAMETERI _glPointParameteri = &_get_glPointParameteri;

static void APIENTRY _fail_glPointParameteriv(GLenum pname, const GLint * params) {
    const char *_name = "glPointParameteriv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glPointParameteriv(GLenum pname, const GLint * params) {
    PFN_GLPOINTPARAMETERIV _ptr;
    _ptr = (PFN_GLPOINTPARAMETERIV)_getPrivateProcAddress("glPointParameteriv");
    if (!_ptr) {
        _ptr = &_fail_glPointParameteriv;
    }
    _glPointParameteriv = _ptr;
    _glPointParameteriv(pname, params);
}

PFN_GLPOINTPARAMETERIV _glPointParameteriv = &_get_glPointParameteriv;

static void APIENTRY _fail_glFogCoordf(GLfloat coord) {
    const char *_name = "glFogCoordf";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glFogCoordf(GLfloat coord) {
    PFN_GLFOGCOORDF _ptr;
    _ptr = (PFN_GLFOGCOORDF)_getPrivateProcAddress("glFogCoordf");
    if (!_ptr) {
        _ptr = &_fail_glFogCoordf;
    }
    _glFogCoordf = _ptr;
    _glFogCoordf(coord);
}

PFN_GLFOGCOORDF _glFogCoordf = &_get_glFogCoordf;

static void APIENTRY _fail_glFogCoordfv(const GLfloat * coord) {
    const char *_name = "glFogCoordfv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glFogCoordfv(const GLfloat * coord) {
    PFN_GLFOGCOORDFV _ptr;
    _ptr = (PFN_GLFOGCOORDFV)_getPrivateProcAddress("glFogCoordfv");
    if (!_ptr) {
        _ptr = &_fail_glFogCoordfv;
    }
    _glFogCoordfv = _ptr;
    _glFogCoordfv(coord);
}

PFN_GLFOGCOORDFV _glFogCoordfv = &_get_glFogCoordfv;

static void APIENTRY _fail_glFogCoordd(GLdouble coord) {
    const char *_name = "glFogCoordd";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glFogCoordd(GLdouble coord) {
    PFN_GLFOGCOORDD _ptr;
    _ptr = (PFN_GLFOGCOORDD)_getPrivateProcAddress("glFogCoordd");
    if (!_ptr) {
        _ptr = &_fail_glFogCoordd;
    }
    _glFogCoordd = _ptr;
    _glFogCoordd(coord);
}

PFN_GLFOGCOORDD _glFogCoordd = &_get_glFogCoordd;

static void APIENTRY _fail_glFogCoorddv(const GLdouble * coord) {
    const char *_name = "glFogCoorddv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glFogCoorddv(const GLdouble * coord) {
    PFN_GLFOGCOORDDV _ptr;
    _ptr = (PFN_GLFOGCOORDDV)_getPrivateProcAddress("glFogCoorddv");
    if (!_ptr) {
        _ptr = &_fail_glFogCoorddv;
    }
    _glFogCoorddv = _ptr;
    _glFogCoorddv(coord);
}

PFN_GLFOGCOORDDV _glFogCoorddv = &_get_glFogCoorddv;

static void APIENTRY _fail_glFogCoordPointer(GLenum type, GLsizei stride, const GLvoid * pointer) {
    const char *_name = "glFogCoordPointer";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glFogCoordPointer(GLenum type, GLsizei stride, const GLvoid * pointer) {
    PFN_GLFOGCOORDPOINTER _ptr;
    _ptr = (PFN_GLFOGCOORDPOINTER)_getPrivateProcAddress("glFogCoordPointer");
    if (!_ptr) {
        _ptr = &_fail_glFogCoordPointer;
    }
    _glFogCoordPointer = _ptr;
    _glFogCoordPointer(type, stride, pointer);
}

PFN_GLFOGCOORDPOINTER _glFogCoordPointer = &_get_glFogCoordPointer;

static void APIENTRY _fail_glSecondaryColor3b(GLbyte red, GLbyte green, GLbyte blue) {
    const char *_name = "glSecondaryColor3b";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glSecondaryColor3b(GLbyte red, GLbyte green, GLbyte blue) {
    PFN_GLSECONDARYCOLOR3B _ptr;
    _ptr = (PFN_GLSECONDARYCOLOR3B)_getPrivateProcAddress("glSecondaryColor3b");
    if (!_ptr) {
        _ptr = &_fail_glSecondaryColor3b;
    }
    _glSecondaryColor3b = _ptr;
    _glSecondaryColor3b(red, green, blue);
}

PFN_GLSECONDARYCOLOR3B _glSecondaryColor3b = &_get_glSecondaryColor3b;

static void APIENTRY _fail_glSecondaryColor3bv(const GLbyte * v) {
    const char *_name = "glSecondaryColor3bv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glSecondaryColor3bv(const GLbyte * v) {
    PFN_GLSECONDARYCOLOR3BV _ptr;
    _ptr = (PFN_GLSECONDARYCOLOR3BV)_getPrivateProcAddress("glSecondaryColor3bv");
    if (!_ptr) {
        _ptr = &_fail_glSecondaryColor3bv;
    }
    _glSecondaryColor3bv = _ptr;
    _glSecondaryColor3bv(v);
}

PFN_GLSECONDARYCOLOR3BV _glSecondaryColor3bv = &_get_glSecondaryColor3bv;

static void APIENTRY _fail_glSecondaryColor3d(GLdouble red, GLdouble green, GLdouble blue) {
    const char *_name = "glSecondaryColor3d";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glSecondaryColor3d(GLdouble red, GLdouble green, GLdouble blue) {
    PFN_GLSECONDARYCOLOR3D _ptr;
    _ptr = (PFN_GLSECONDARYCOLOR3D)_getPrivateProcAddress("glSecondaryColor3d");
    if (!_ptr) {
        _ptr = &_fail_glSecondaryColor3d;
    }
    _glSecondaryColor3d = _ptr;
    _glSecondaryColor3d(red, green, blue);
}

PFN_GLSECONDARYCOLOR3D _glSecondaryColor3d = &_get_glSecondaryColor3d;

static void APIENTRY _fail_glSecondaryColor3dv(const GLdouble * v) {
    const char *_name = "glSecondaryColor3dv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glSecondaryColor3dv(const GLdouble * v) {
    PFN_GLSECONDARYCOLOR3DV _ptr;
    _ptr = (PFN_GLSECONDARYCOLOR3DV)_getPrivateProcAddress("glSecondaryColor3dv");
    if (!_ptr) {
        _ptr = &_fail_glSecondaryColor3dv;
    }
    _glSecondaryColor3dv = _ptr;
    _glSecondaryColor3dv(v);
}

PFN_GLSECONDARYCOLOR3DV _glSecondaryColor3dv = &_get_glSecondaryColor3dv;

static void APIENTRY _fail_glSecondaryColor3f(GLfloat red, GLfloat green, GLfloat blue) {
    const char *_name = "glSecondaryColor3f";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glSecondaryColor3f(GLfloat red, GLfloat green, GLfloat blue) {
    PFN_GLSECONDARYCOLOR3F _ptr;
    _ptr = (PFN_GLSECONDARYCOLOR3F)_getPrivateProcAddress("glSecondaryColor3f");
    if (!_ptr) {
        _ptr = &_fail_glSecondaryColor3f;
    }
    _glSecondaryColor3f = _ptr;
    _glSecondaryColor3f(red, green, blue);
}

PFN_GLSECONDARYCOLOR3F _glSecondaryColor3f = &_get_glSecondaryColor3f;

static void APIENTRY _fail_glSecondaryColor3fv(const GLfloat * v) {
    const char *_name = "glSecondaryColor3fv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glSecondaryColor3fv(const GLfloat * v) {
    PFN_GLSECONDARYCOLOR3FV _ptr;
    _ptr = (PFN_GLSECONDARYCOLOR3FV)_getPrivateProcAddress("glSecondaryColor3fv");
    if (!_ptr) {
        _ptr = &_fail_glSecondaryColor3fv;
    }
    _glSecondaryColor3fv = _ptr;
    _glSecondaryColor3fv(v);
}

PFN_GLSECONDARYCOLOR3FV _glSecondaryColor3fv = &_get_glSecondaryColor3fv;

static void APIENTRY _fail_glSecondaryColor3i(GLint red, GLint green, GLint blue) {
    const char *_name = "glSecondaryColor3i";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glSecondaryColor3i(GLint red, GLint green, GLint blue) {
    PFN_GLSECONDARYCOLOR3I _ptr;
    _ptr = (PFN_GLSECONDARYCOLOR3I)_getPrivateProcAddress("glSecondaryColor3i");
    if (!_ptr) {
        _ptr = &_fail_glSecondaryColor3i;
    }
    _glSecondaryColor3i = _ptr;
    _glSecondaryColor3i(red, green, blue);
}

PFN_GLSECONDARYCOLOR3I _glSecondaryColor3i = &_get_glSecondaryColor3i;

static void APIENTRY _fail_glSecondaryColor3iv(const GLint * v) {
    const char *_name = "glSecondaryColor3iv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glSecondaryColor3iv(const GLint * v) {
    PFN_GLSECONDARYCOLOR3IV _ptr;
    _ptr = (PFN_GLSECONDARYCOLOR3IV)_getPrivateProcAddress("glSecondaryColor3iv");
    if (!_ptr) {
        _ptr = &_fail_glSecondaryColor3iv;
    }
    _glSecondaryColor3iv = _ptr;
    _glSecondaryColor3iv(v);
}

PFN_GLSECONDARYCOLOR3IV _glSecondaryColor3iv = &_get_glSecondaryColor3iv;

static void APIENTRY _fail_glSecondaryColor3s(GLshort red, GLshort green, GLshort blue) {
    const char *_name = "glSecondaryColor3s";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glSecondaryColor3s(GLshort red, GLshort green, GLshort blue) {
    PFN_GLSECONDARYCOLOR3S _ptr;
    _ptr = (PFN_GLSECONDARYCOLOR3S)_getPrivateProcAddress("glSecondaryColor3s");
    if (!_ptr) {
        _ptr = &_fail_glSecondaryColor3s;
    }
    _glSecondaryColor3s = _ptr;
    _glSecondaryColor3s(red, green, blue);
}

PFN_GLSECONDARYCOLOR3S _glSecondaryColor3s = &_get_glSecondaryColor3s;

static void APIENTRY _fail_glSecondaryColor3sv(const GLshort * v) {
    const char *_name = "glSecondaryColor3sv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glSecondaryColor3sv(const GLshort * v) {
    PFN_GLSECONDARYCOLOR3SV _ptr;
    _ptr = (PFN_GLSECONDARYCOLOR3SV)_getPrivateProcAddress("glSecondaryColor3sv");
    if (!_ptr) {
        _ptr = &_fail_glSecondaryColor3sv;
    }
    _glSecondaryColor3sv = _ptr;
    _glSecondaryColor3sv(v);
}

PFN_GLSECONDARYCOLOR3SV _glSecondaryColor3sv = &_get_glSecondaryColor3sv;

static void APIENTRY _fail_glSecondaryColor3ub(GLubyte red, GLubyte green, GLubyte blue) {
    const char *_name = "glSecondaryColor3ub";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glSecondaryColor3ub(GLubyte red, GLubyte green, GLubyte blue) {
    PFN_GLSECONDARYCOLOR3UB _ptr;
    _ptr = (PFN_GLSECONDARYCOLOR3UB)_getPrivateProcAddress("glSecondaryColor3ub");
    if (!_ptr) {
        _ptr = &_fail_glSecondaryColor3ub;
    }
    _glSecondaryColor3ub = _ptr;
    _glSecondaryColor3ub(red, green, blue);
}

PFN_GLSECONDARYCOLOR3UB _glSecondaryColor3ub = &_get_glSecondaryColor3ub;

static void APIENTRY _fail_glSecondaryColor3ubv(const GLubyte * v) {
    const char *_name = "glSecondaryColor3ubv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glSecondaryColor3ubv(const GLubyte * v) {
    PFN_GLSECONDARYCOLOR3UBV _ptr;
    _ptr = (PFN_GLSECONDARYCOLOR3UBV)_getPrivateProcAddress("glSecondaryColor3ubv");
    if (!_ptr) {
        _ptr = &_fail_glSecondaryColor3ubv;
    }
    _glSecondaryColor3ubv = _ptr;
    _glSecondaryColor3ubv(v);
}

PFN_GLSECONDARYCOLOR3UBV _glSecondaryColor3ubv = &_get_glSecondaryColor3ubv;

static void APIENTRY _fail_glSecondaryColor3ui(GLuint red, GLuint green, GLuint blue) {
    const char *_name = "glSecondaryColor3ui";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glSecondaryColor3ui(GLuint red, GLuint green, GLuint blue) {
    PFN_GLSECONDARYCOLOR3UI _ptr;
    _ptr = (PFN_GLSECONDARYCOLOR3UI)_getPrivateProcAddress("glSecondaryColor3ui");
    if (!_ptr) {
        _ptr = &_fail_glSecondaryColor3ui;
    }
    _glSecondaryColor3ui = _ptr;
    _glSecondaryColor3ui(red, green, blue);
}

PFN_GLSECONDARYCOLOR3UI _glSecondaryColor3ui = &_get_glSecondaryColor3ui;

static void APIENTRY _fail_glSecondaryColor3uiv(const GLuint * v) {
    const char *_name = "glSecondaryColor3uiv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glSecondaryColor3uiv(const GLuint * v) {
    PFN_GLSECONDARYCOLOR3UIV _ptr;
    _ptr = (PFN_GLSECONDARYCOLOR3UIV)_getPrivateProcAddress("glSecondaryColor3uiv");
    if (!_ptr) {
        _ptr = &_fail_glSecondaryColor3uiv;
    }
    _glSecondaryColor3uiv = _ptr;
    _glSecondaryColor3uiv(v);
}

PFN_GLSECONDARYCOLOR3UIV _glSecondaryColor3uiv = &_get_glSecondaryColor3uiv;

static void APIENTRY _fail_glSecondaryColor3us(GLushort red, GLushort green, GLushort blue) {
    const char *_name = "glSecondaryColor3us";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glSecondaryColor3us(GLushort red, GLushort green, GLushort blue) {
    PFN_GLSECONDARYCOLOR3US _ptr;
    _ptr = (PFN_GLSECONDARYCOLOR3US)_getPrivateProcAddress("glSecondaryColor3us");
    if (!_ptr) {
        _ptr = &_fail_glSecondaryColor3us;
    }
    _glSecondaryColor3us = _ptr;
    _glSecondaryColor3us(red, green, blue);
}

PFN_GLSECONDARYCOLOR3US _glSecondaryColor3us = &_get_glSecondaryColor3us;

static void APIENTRY _fail_glSecondaryColor3usv(const GLushort * v) {
    const char *_name = "glSecondaryColor3usv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glSecondaryColor3usv(const GLushort * v) {
    PFN_GLSECONDARYCOLOR3USV _ptr;
    _ptr = (PFN_GLSECONDARYCOLOR3USV)_getPrivateProcAddress("glSecondaryColor3usv");
    if (!_ptr) {
        _ptr = &_fail_glSecondaryColor3usv;
    }
    _glSecondaryColor3usv = _ptr;
    _glSecondaryColor3usv(v);
}

PFN_GLSECONDARYCOLOR3USV _glSecondaryColor3usv = &_get_glSecondaryColor3usv;

static void APIENTRY _fail_glSecondaryColorPointer(GLint size, GLenum type, GLsizei stride, const GLvoid * pointer) {
    const char *_name = "glSecondaryColorPointer";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glSecondaryColorPointer(GLint size, GLenum type, GLsizei stride, const GLvoid * pointer) {
    PFN_GLSECONDARYCOLORPOINTER _ptr;
    _ptr = (PFN_GLSECONDARYCOLORPOINTER)_getPrivateProcAddress("glSecondaryColorPointer");
    if (!_ptr) {
        _ptr = &_fail_glSecondaryColorPointer;
    }
    _glSecondaryColorPointer = _ptr;
    _glSecondaryColorPointer(size, type, stride, pointer);
}

PFN_GLSECONDARYCOLORPOINTER _glSecondaryColorPointer = &_get_glSecondaryColorPointer;

static void APIENTRY _fail_glWindowPos2d(GLdouble x, GLdouble y) {
    const char *_name = "glWindowPos2d";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glWindowPos2d(GLdouble x, GLdouble y) {
    PFN_GLWINDOWPOS2D _ptr;
    _ptr = (PFN_GLWINDOWPOS2D)_getPrivateProcAddress("glWindowPos2d");
    if (!_ptr) {
        _ptr = &_fail_glWindowPos2d;
    }
    _glWindowPos2d = _ptr;
    _glWindowPos2d(x, y);
}

PFN_GLWINDOWPOS2D _glWindowPos2d = &_get_glWindowPos2d;

static void APIENTRY _fail_glWindowPos2dv(const GLdouble * v) {
    const char *_name = "glWindowPos2dv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glWindowPos2dv(const GLdouble * v) {
    PFN_GLWINDOWPOS2DV _ptr;
    _ptr = (PFN_GLWINDOWPOS2DV)_getPrivateProcAddress("glWindowPos2dv");
    if (!_ptr) {
        _ptr = &_fail_glWindowPos2dv;
    }
    _glWindowPos2dv = _ptr;
    _glWindowPos2dv(v);
}

PFN_GLWINDOWPOS2DV _glWindowPos2dv = &_get_glWindowPos2dv;

static void APIENTRY _fail_glWindowPos2f(GLfloat x, GLfloat y) {
    const char *_name = "glWindowPos2f";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glWindowPos2f(GLfloat x, GLfloat y) {
    PFN_GLWINDOWPOS2F _ptr;
    _ptr = (PFN_GLWINDOWPOS2F)_getPrivateProcAddress("glWindowPos2f");
    if (!_ptr) {
        _ptr = &_fail_glWindowPos2f;
    }
    _glWindowPos2f = _ptr;
    _glWindowPos2f(x, y);
}

PFN_GLWINDOWPOS2F _glWindowPos2f = &_get_glWindowPos2f;

static void APIENTRY _fail_glWindowPos2fv(const GLfloat * v) {
    const char *_name = "glWindowPos2fv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glWindowPos2fv(const GLfloat * v) {
    PFN_GLWINDOWPOS2FV _ptr;
    _ptr = (PFN_GLWINDOWPOS2FV)_getPrivateProcAddress("glWindowPos2fv");
    if (!_ptr) {
        _ptr = &_fail_glWindowPos2fv;
    }
    _glWindowPos2fv = _ptr;
    _glWindowPos2fv(v);
}

PFN_GLWINDOWPOS2FV _glWindowPos2fv = &_get_glWindowPos2fv;

static void APIENTRY _fail_glWindowPos2i(GLint x, GLint y) {
    const char *_name = "glWindowPos2i";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glWindowPos2i(GLint x, GLint y) {
    PFN_GLWINDOWPOS2I _ptr;
    _ptr = (PFN_GLWINDOWPOS2I)_getPrivateProcAddress("glWindowPos2i");
    if (!_ptr) {
        _ptr = &_fail_glWindowPos2i;
    }
    _glWindowPos2i = _ptr;
    _glWindowPos2i(x, y);
}

PFN_GLWINDOWPOS2I _glWindowPos2i = &_get_glWindowPos2i;

static void APIENTRY _fail_glWindowPos2iv(const GLint * v) {
    const char *_name = "glWindowPos2iv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glWindowPos2iv(const GLint * v) {
    PFN_GLWINDOWPOS2IV _ptr;
    _ptr = (PFN_GLWINDOWPOS2IV)_getPrivateProcAddress("glWindowPos2iv");
    if (!_ptr) {
        _ptr = &_fail_glWindowPos2iv;
    }
    _glWindowPos2iv = _ptr;
    _glWindowPos2iv(v);
}

PFN_GLWINDOWPOS2IV _glWindowPos2iv = &_get_glWindowPos2iv;

static void APIENTRY _fail_glWindowPos2s(GLshort x, GLshort y) {
    const char *_name = "glWindowPos2s";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glWindowPos2s(GLshort x, GLshort y) {
    PFN_GLWINDOWPOS2S _ptr;
    _ptr = (PFN_GLWINDOWPOS2S)_getPrivateProcAddress("glWindowPos2s");
    if (!_ptr) {
        _ptr = &_fail_glWindowPos2s;
    }
    _glWindowPos2s = _ptr;
    _glWindowPos2s(x, y);
}

PFN_GLWINDOWPOS2S _glWindowPos2s = &_get_glWindowPos2s;

static void APIENTRY _fail_glWindowPos2sv(const GLshort * v) {
    const char *_name = "glWindowPos2sv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glWindowPos2sv(const GLshort * v) {
    PFN_GLWINDOWPOS2SV _ptr;
    _ptr = (PFN_GLWINDOWPOS2SV)_getPrivateProcAddress("glWindowPos2sv");
    if (!_ptr) {
        _ptr = &_fail_glWindowPos2sv;
    }
    _glWindowPos2sv = _ptr;
    _glWindowPos2sv(v);
}

PFN_GLWINDOWPOS2SV _glWindowPos2sv = &_get_glWindowPos2sv;

static void APIENTRY _fail_glWindowPos3d(GLdouble x, GLdouble y, GLdouble z) {
    const char *_name = "glWindowPos3d";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glWindowPos3d(GLdouble x, GLdouble y, GLdouble z) {
    PFN_GLWINDOWPOS3D _ptr;
    _ptr = (PFN_GLWINDOWPOS3D)_getPrivateProcAddress("glWindowPos3d");
    if (!_ptr) {
        _ptr = &_fail_glWindowPos3d;
    }
    _glWindowPos3d = _ptr;
    _glWindowPos3d(x, y, z);
}

PFN_GLWINDOWPOS3D _glWindowPos3d = &_get_glWindowPos3d;

static void APIENTRY _fail_glWindowPos3dv(const GLdouble * v) {
    const char *_name = "glWindowPos3dv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glWindowPos3dv(const GLdouble * v) {
    PFN_GLWINDOWPOS3DV _ptr;
    _ptr = (PFN_GLWINDOWPOS3DV)_getPrivateProcAddress("glWindowPos3dv");
    if (!_ptr) {
        _ptr = &_fail_glWindowPos3dv;
    }
    _glWindowPos3dv = _ptr;
    _glWindowPos3dv(v);
}

PFN_GLWINDOWPOS3DV _glWindowPos3dv = &_get_glWindowPos3dv;

static void APIENTRY _fail_glWindowPos3f(GLfloat x, GLfloat y, GLfloat z) {
    const char *_name = "glWindowPos3f";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glWindowPos3f(GLfloat x, GLfloat y, GLfloat z) {
    PFN_GLWINDOWPOS3F _ptr;
    _ptr = (PFN_GLWINDOWPOS3F)_getPrivateProcAddress("glWindowPos3f");
    if (!_ptr) {
        _ptr = &_fail_glWindowPos3f;
    }
    _glWindowPos3f = _ptr;
    _glWindowPos3f(x, y, z);
}

PFN_GLWINDOWPOS3F _glWindowPos3f = &_get_glWindowPos3f;

static void APIENTRY _fail_glWindowPos3fv(const GLfloat * v) {
    const char *_name = "glWindowPos3fv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glWindowPos3fv(const GLfloat * v) {
    PFN_GLWINDOWPOS3FV _ptr;
    _ptr = (PFN_GLWINDOWPOS3FV)_getPrivateProcAddress("glWindowPos3fv");
    if (!_ptr) {
        _ptr = &_fail_glWindowPos3fv;
    }
    _glWindowPos3fv = _ptr;
    _glWindowPos3fv(v);
}

PFN_GLWINDOWPOS3FV _glWindowPos3fv = &_get_glWindowPos3fv;

static void APIENTRY _fail_glWindowPos3i(GLint x, GLint y, GLint z) {
    const char *_name = "glWindowPos3i";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glWindowPos3i(GLint x, GLint y, GLint z) {
    PFN_GLWINDOWPOS3I _ptr;
    _ptr = (PFN_GLWINDOWPOS3I)_getPrivateProcAddress("glWindowPos3i");
    if (!_ptr) {
        _ptr = &_fail_glWindowPos3i;
    }
    _glWindowPos3i = _ptr;
    _glWindowPos3i(x, y, z);
}

PFN_GLWINDOWPOS3I _glWindowPos3i = &_get_glWindowPos3i;

static void APIENTRY _fail_glWindowPos3iv(const GLint * v) {
    const char *_name = "glWindowPos3iv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glWindowPos3iv(const GLint * v) {
    PFN_GLWINDOWPOS3IV _ptr;
    _ptr = (PFN_GLWINDOWPOS3IV)_getPrivateProcAddress("glWindowPos3iv");
    if (!_ptr) {
        _ptr = &_fail_glWindowPos3iv;
    }
    _glWindowPos3iv = _ptr;
    _glWindowPos3iv(v);
}

PFN_GLWINDOWPOS3IV _glWindowPos3iv = &_get_glWindowPos3iv;

static void APIENTRY _fail_glWindowPos3s(GLshort x, GLshort y, GLshort z) {
    const char *_name = "glWindowPos3s";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glWindowPos3s(GLshort x, GLshort y, GLshort z) {
    PFN_GLWINDOWPOS3S _ptr;
    _ptr = (PFN_GLWINDOWPOS3S)_getPrivateProcAddress("glWindowPos3s");
    if (!_ptr) {
        _ptr = &_fail_glWindowPos3s;
    }
    _glWindowPos3s = _ptr;
    _glWindowPos3s(x, y, z);
}

PFN_GLWINDOWPOS3S _glWindowPos3s = &_get_glWindowPos3s;

static void APIENTRY _fail_glWindowPos3sv(const GLshort * v) {
    const char *_name = "glWindowPos3sv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glWindowPos3sv(const GLshort * v) {
    PFN_GLWINDOWPOS3SV _ptr;
    _ptr = (PFN_GLWINDOWPOS3SV)_getPrivateProcAddress("glWindowPos3sv");
    if (!_ptr) {
        _ptr = &_fail_glWindowPos3sv;
    }
    _glWindowPos3sv = _ptr;
    _glWindowPos3sv(v);
}

PFN_GLWINDOWPOS3SV _glWindowPos3sv = &_get_glWindowPos3sv;

static void APIENTRY _fail_glGenQueries(GLsizei n, GLuint * ids) {
    const char *_name = "glGenQueries";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGenQueries(GLsizei n, GLuint * ids) {
    PFN_GLGENQUERIES _ptr;
    _ptr = (PFN_GLGENQUERIES)_getPrivateProcAddress("glGenQueries");
    if (!_ptr) {
        _ptr = &_fail_glGenQueries;
    }
    _glGenQueries = _ptr;
    _glGenQueries(n, ids);
}

PFN_GLGENQUERIES _glGenQueries = &_get_glGenQueries;

static void APIENTRY _fail_glDeleteQueries(GLsizei n, const GLuint * ids) {
    const char *_name = "glDeleteQueries";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glDeleteQueries(GLsizei n, const GLuint * ids) {
    PFN_GLDELETEQUERIES _ptr;
    _ptr = (PFN_GLDELETEQUERIES)_getPrivateProcAddress("glDeleteQueries");
    if (!_ptr) {
        _ptr = &_fail_glDeleteQueries;
    }
    _glDeleteQueries = _ptr;
    _glDeleteQueries(n, ids);
}

PFN_GLDELETEQUERIES _glDeleteQueries = &_get_glDeleteQueries;

static GLboolean APIENTRY _fail_glIsQuery(GLuint id) {
    const char *_name = "glIsQuery";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static GLboolean APIENTRY _get_glIsQuery(GLuint id) {
    PFN_GLISQUERY _ptr;
    _ptr = (PFN_GLISQUERY)_getPrivateProcAddress("glIsQuery");
    if (!_ptr) {
        _ptr = &_fail_glIsQuery;
    }
    _glIsQuery = _ptr;
    return _glIsQuery(id);
}

PFN_GLISQUERY _glIsQuery = &_get_glIsQuery;

static void APIENTRY _fail_glBeginQuery(GLenum target, GLuint id) {
    const char *_name = "glBeginQuery";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glBeginQuery(GLenum target, GLuint id) {
    PFN_GLBEGINQUERY _ptr;
    _ptr = (PFN_GLBEGINQUERY)_getPrivateProcAddress("glBeginQuery");
    if (!_ptr) {
        _ptr = &_fail_glBeginQuery;
    }
    _glBeginQuery = _ptr;
    _glBeginQuery(target, id);
}

PFN_GLBEGINQUERY _glBeginQuery = &_get_glBeginQuery;

static void APIENTRY _fail_glEndQuery(GLenum target) {
    const char *_name = "glEndQuery";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glEndQuery(GLenum target) {
    PFN_GLENDQUERY _ptr;
    _ptr = (PFN_GLENDQUERY)_getPrivateProcAddress("glEndQuery");
    if (!_ptr) {
        _ptr = &_fail_glEndQuery;
    }
    _glEndQuery = _ptr;
    _glEndQuery(target);
}

PFN_GLENDQUERY _glEndQuery = &_get_glEndQuery;

static void APIENTRY _fail_glGetQueryiv(GLenum target, GLenum pname, GLint * params) {
    const char *_name = "glGetQueryiv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetQueryiv(GLenum target, GLenum pname, GLint * params) {
    PFN_GLGETQUERYIV _ptr;
    _ptr = (PFN_GLGETQUERYIV)_getPrivateProcAddress("glGetQueryiv");
    if (!_ptr) {
        _ptr = &_fail_glGetQueryiv;
    }
    _glGetQueryiv = _ptr;
    _glGetQueryiv(target, pname, params);
}

PFN_GLGETQUERYIV _glGetQueryiv = &_get_glGetQueryiv;

static void APIENTRY _fail_glGetQueryObjectiv(GLuint id, GLenum pname, GLint * params) {
    const char *_name = "glGetQueryObjectiv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetQueryObjectiv(GLuint id, GLenum pname, GLint * params) {
    PFN_GLGETQUERYOBJECTIV _ptr;
    _ptr = (PFN_GLGETQUERYOBJECTIV)_getPrivateProcAddress("glGetQueryObjectiv");
    if (!_ptr) {
        _ptr = &_fail_glGetQueryObjectiv;
    }
    _glGetQueryObjectiv = _ptr;
    _glGetQueryObjectiv(id, pname, params);
}

PFN_GLGETQUERYOBJECTIV _glGetQueryObjectiv = &_get_glGetQueryObjectiv;

static void APIENTRY _fail_glGetQueryObjectuiv(GLuint id, GLenum pname, GLuint * params) {
    const char *_name = "glGetQueryObjectuiv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetQueryObjectuiv(GLuint id, GLenum pname, GLuint * params) {
    PFN_GLGETQUERYOBJECTUIV _ptr;
    _ptr = (PFN_GLGETQUERYOBJECTUIV)_getPrivateProcAddress("glGetQueryObjectuiv");
    if (!_ptr) {
        _ptr = &_fail_glGetQueryObjectuiv;
    }
    _glGetQueryObjectuiv = _ptr;
    _glGetQueryObjectuiv(id, pname, params);
}

PFN_GLGETQUERYOBJECTUIV _glGetQueryObjectuiv = &_get_glGetQueryObjectuiv;

static void APIENTRY _fail_glBindBuffer(GLenum target, GLuint buffer) {
    const char *_name = "glBindBuffer";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glBindBuffer(GLenum target, GLuint buffer) {
    PFN_GLBINDBUFFER _ptr;
    _ptr = (PFN_GLBINDBUFFER)_getPrivateProcAddress("glBindBuffer");
    if (!_ptr) {
        _ptr = &_fail_glBindBuffer;
    }
    _glBindBuffer = _ptr;
    _glBindBuffer(target, buffer);
}

PFN_GLBINDBUFFER _glBindBuffer = &_get_glBindBuffer;

static void APIENTRY _fail_glDeleteBuffers(GLsizei n, const GLuint * buffers) {
    const char *_name = "glDeleteBuffers";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glDeleteBuffers(GLsizei n, const GLuint * buffers) {
    PFN_GLDELETEBUFFERS _ptr;
    _ptr = (PFN_GLDELETEBUFFERS)_getPrivateProcAddress("glDeleteBuffers");
    if (!_ptr) {
        _ptr = &_fail_glDeleteBuffers;
    }
    _glDeleteBuffers = _ptr;
    _glDeleteBuffers(n, buffers);
}

PFN_GLDELETEBUFFERS _glDeleteBuffers = &_get_glDeleteBuffers;

static void APIENTRY _fail_glGenBuffers(GLsizei n, GLuint * buffers) {
    const char *_name = "glGenBuffers";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGenBuffers(GLsizei n, GLuint * buffers) {
    PFN_GLGENBUFFERS _ptr;
    _ptr = (PFN_GLGENBUFFERS)_getPrivateProcAddress("glGenBuffers");
    if (!_ptr) {
        _ptr = &_fail_glGenBuffers;
    }
    _glGenBuffers = _ptr;
    _glGenBuffers(n, buffers);
}

PFN_GLGENBUFFERS _glGenBuffers = &_get_glGenBuffers;

static GLboolean APIENTRY _fail_glIsBuffer(GLuint buffer) {
    const char *_name = "glIsBuffer";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static GLboolean APIENTRY _get_glIsBuffer(GLuint buffer) {
    PFN_GLISBUFFER _ptr;
    _ptr = (PFN_GLISBUFFER)_getPrivateProcAddress("glIsBuffer");
    if (!_ptr) {
        _ptr = &_fail_glIsBuffer;
    }
    _glIsBuffer = _ptr;
    return _glIsBuffer(buffer);
}

PFN_GLISBUFFER _glIsBuffer = &_get_glIsBuffer;

static void APIENTRY _fail_glBufferData(GLenum target, GLsizeiptr size, const GLvoid * data, GLenum usage) {
    const char *_name = "glBufferData";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glBufferData(GLenum target, GLsizeiptr size, const GLvoid * data, GLenum usage) {
    PFN_GLBUFFERDATA _ptr;
    _ptr = (PFN_GLBUFFERDATA)_getPrivateProcAddress("glBufferData");
    if (!_ptr) {
        _ptr = &_fail_glBufferData;
    }
    _glBufferData = _ptr;
    _glBufferData(target, size, data, usage);
}

PFN_GLBUFFERDATA _glBufferData = &_get_glBufferData;

static void APIENTRY _fail_glBufferSubData(GLenum target, GLintptr offset, GLsizeiptr size, const GLvoid * data) {
    const char *_name = "glBufferSubData";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glBufferSubData(GLenum target, GLintptr offset, GLsizeiptr size, const GLvoid * data) {
    PFN_GLBUFFERSUBDATA _ptr;
    _ptr = (PFN_GLBUFFERSUBDATA)_getPrivateProcAddress("glBufferSubData");
    if (!_ptr) {
        _ptr = &_fail_glBufferSubData;
    }
    _glBufferSubData = _ptr;
    _glBufferSubData(target, offset, size, data);
}

PFN_GLBUFFERSUBDATA _glBufferSubData = &_get_glBufferSubData;

static void APIENTRY _fail_glGetBufferSubData(GLenum target, GLintptr offset, GLsizeiptr size, GLvoid * data) {
    const char *_name = "glGetBufferSubData";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetBufferSubData(GLenum target, GLintptr offset, GLsizeiptr size, GLvoid * data) {
    PFN_GLGETBUFFERSUBDATA _ptr;
    _ptr = (PFN_GLGETBUFFERSUBDATA)_getPrivateProcAddress("glGetBufferSubData");
    if (!_ptr) {
        _ptr = &_fail_glGetBufferSubData;
    }
    _glGetBufferSubData = _ptr;
    _glGetBufferSubData(target, offset, size, data);
}

PFN_GLGETBUFFERSUBDATA _glGetBufferSubData = &_get_glGetBufferSubData;

static GLvoid * APIENTRY _fail_glMapBuffer(GLenum target, GLenum access) {
    const char *_name = "glMapBuffer";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static GLvoid * APIENTRY _get_glMapBuffer(GLenum target, GLenum access) {
    PFN_GLMAPBUFFER _ptr;
    _ptr = (PFN_GLMAPBUFFER)_getPrivateProcAddress("glMapBuffer");
    if (!_ptr) {
        _ptr = &_fail_glMapBuffer;
    }
    _glMapBuffer = _ptr;
    return _glMapBuffer(target, access);
}

PFN_GLMAPBUFFER _glMapBuffer = &_get_glMapBuffer;

static GLboolean APIENTRY _fail_glUnmapBuffer(GLenum target) {
    const char *_name = "glUnmapBuffer";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static GLboolean APIENTRY _get_glUnmapBuffer(GLenum target) {
    PFN_GLUNMAPBUFFER _ptr;
    _ptr = (PFN_GLUNMAPBUFFER)_getPrivateProcAddress("glUnmapBuffer");
    if (!_ptr) {
        _ptr = &_fail_glUnmapBuffer;
    }
    _glUnmapBuffer = _ptr;
    return _glUnmapBuffer(target);
}

PFN_GLUNMAPBUFFER _glUnmapBuffer = &_get_glUnmapBuffer;

static void APIENTRY _fail_glGetBufferParameteriv(GLenum target, GLenum pname, GLint * params) {
    const char *_name = "glGetBufferParameteriv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetBufferParameteriv(GLenum target, GLenum pname, GLint * params) {
    PFN_GLGETBUFFERPARAMETERIV _ptr;
    _ptr = (PFN_GLGETBUFFERPARAMETERIV)_getPrivateProcAddress("glGetBufferParameteriv");
    if (!_ptr) {
        _ptr = &_fail_glGetBufferParameteriv;
    }
    _glGetBufferParameteriv = _ptr;
    _glGetBufferParameteriv(target, pname, params);
}

PFN_GLGETBUFFERPARAMETERIV _glGetBufferParameteriv = &_get_glGetBufferParameteriv;

static void APIENTRY _fail_glGetBufferPointerv(GLenum target, GLenum pname, GLvoid * * params) {
    const char *_name = "glGetBufferPointerv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetBufferPointerv(GLenum target, GLenum pname, GLvoid * * params) {
    PFN_GLGETBUFFERPOINTERV _ptr;
    _ptr = (PFN_GLGETBUFFERPOINTERV)_getPrivateProcAddress("glGetBufferPointerv");
    if (!_ptr) {
        _ptr = &_fail_glGetBufferPointerv;
    }
    _glGetBufferPointerv = _ptr;
    _glGetBufferPointerv(target, pname, params);
}

PFN_GLGETBUFFERPOINTERV _glGetBufferPointerv = &_get_glGetBufferPointerv;

static void APIENTRY _fail_glBlendEquationSeparate(GLenum modeRGB, GLenum modeAlpha) {
    const char *_name = "glBlendEquationSeparate";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glBlendEquationSeparate(GLenum modeRGB, GLenum modeAlpha) {
    PFN_GLBLENDEQUATIONSEPARATE _ptr;
    _ptr = (PFN_GLBLENDEQUATIONSEPARATE)_getPrivateProcAddress("glBlendEquationSeparate");
    if (!_ptr) {
        _ptr = &_fail_glBlendEquationSeparate;
    }
    _glBlendEquationSeparate = _ptr;
    _glBlendEquationSeparate(modeRGB, modeAlpha);
}

PFN_GLBLENDEQUATIONSEPARATE _glBlendEquationSeparate = &_get_glBlendEquationSeparate;

static void APIENTRY _fail_glDrawBuffers(GLsizei n, const GLenum * bufs) {
    const char *_name = "glDrawBuffers";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glDrawBuffers(GLsizei n, const GLenum * bufs) {
    PFN_GLDRAWBUFFERS _ptr;
    _ptr = (PFN_GLDRAWBUFFERS)_getPrivateProcAddress("glDrawBuffers");
    if (!_ptr) {
        _ptr = &_fail_glDrawBuffers;
    }
    _glDrawBuffers = _ptr;
    _glDrawBuffers(n, bufs);
}

PFN_GLDRAWBUFFERS _glDrawBuffers = &_get_glDrawBuffers;

static void APIENTRY _fail_glStencilOpSeparate(GLenum face, GLenum sfail, GLenum dpfail, GLenum dppass) {
    const char *_name = "glStencilOpSeparate";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glStencilOpSeparate(GLenum face, GLenum sfail, GLenum dpfail, GLenum dppass) {
    PFN_GLSTENCILOPSEPARATE _ptr;
    _ptr = (PFN_GLSTENCILOPSEPARATE)_getPrivateProcAddress("glStencilOpSeparate");
    if (!_ptr) {
        _ptr = &_fail_glStencilOpSeparate;
    }
    _glStencilOpSeparate = _ptr;
    _glStencilOpSeparate(face, sfail, dpfail, dppass);
}

PFN_GLSTENCILOPSEPARATE _glStencilOpSeparate = &_get_glStencilOpSeparate;

static void APIENTRY _fail_glStencilFuncSeparate(GLenum face, GLenum func, GLint ref, GLuint mask) {
    const char *_name = "glStencilFuncSeparate";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glStencilFuncSeparate(GLenum face, GLenum func, GLint ref, GLuint mask) {
    PFN_GLSTENCILFUNCSEPARATE _ptr;
    _ptr = (PFN_GLSTENCILFUNCSEPARATE)_getPrivateProcAddress("glStencilFuncSeparate");
    if (!_ptr) {
        _ptr = &_fail_glStencilFuncSeparate;
    }
    _glStencilFuncSeparate = _ptr;
    _glStencilFuncSeparate(face, func, ref, mask);
}

PFN_GLSTENCILFUNCSEPARATE _glStencilFuncSeparate = &_get_glStencilFuncSeparate;

static void APIENTRY _fail_glStencilMaskSeparate(GLenum face, GLuint mask) {
    const char *_name = "glStencilMaskSeparate";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glStencilMaskSeparate(GLenum face, GLuint mask) {
    PFN_GLSTENCILMASKSEPARATE _ptr;
    _ptr = (PFN_GLSTENCILMASKSEPARATE)_getPrivateProcAddress("glStencilMaskSeparate");
    if (!_ptr) {
        _ptr = &_fail_glStencilMaskSeparate;
    }
    _glStencilMaskSeparate = _ptr;
    _glStencilMaskSeparate(face, mask);
}

PFN_GLSTENCILMASKSEPARATE _glStencilMaskSeparate = &_get_glStencilMaskSeparate;

static void APIENTRY _fail_glAttachShader(GLuint program, GLuint shader) {
    const char *_name = "glAttachShader";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glAttachShader(GLuint program, GLuint shader) {
    PFN_GLATTACHSHADER _ptr;
    _ptr = (PFN_GLATTACHSHADER)_getPrivateProcAddress("glAttachShader");
    if (!_ptr) {
        _ptr = &_fail_glAttachShader;
    }
    _glAttachShader = _ptr;
    _glAttachShader(program, shader);
}

PFN_GLATTACHSHADER _glAttachShader = &_get_glAttachShader;

static void APIENTRY _fail_glBindAttribLocation(GLuint program, GLuint index, const GLchar * name) {
    const char *_name = "glBindAttribLocation";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glBindAttribLocation(GLuint program, GLuint index, const GLchar * name) {
    PFN_GLBINDATTRIBLOCATION _ptr;
    _ptr = (PFN_GLBINDATTRIBLOCATION)_getPrivateProcAddress("glBindAttribLocation");
    if (!_ptr) {
        _ptr = &_fail_glBindAttribLocation;
    }
    _glBindAttribLocation = _ptr;
    _glBindAttribLocation(program, index, name);
}

PFN_GLBINDATTRIBLOCATION _glBindAttribLocation = &_get_glBindAttribLocation;

static void APIENTRY _fail_glCompileShader(GLuint shader) {
    const char *_name = "glCompileShader";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glCompileShader(GLuint shader) {
    PFN_GLCOMPILESHADER _ptr;
    _ptr = (PFN_GLCOMPILESHADER)_getPrivateProcAddress("glCompileShader");
    if (!_ptr) {
        _ptr = &_fail_glCompileShader;
    }
    _glCompileShader = _ptr;
    _glCompileShader(shader);
}

PFN_GLCOMPILESHADER _glCompileShader = &_get_glCompileShader;

static GLuint APIENTRY _fail_glCreateProgram(void) {
    const char *_name = "glCreateProgram";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static GLuint APIENTRY _get_glCreateProgram(void) {
    PFN_GLCREATEPROGRAM _ptr;
    _ptr = (PFN_GLCREATEPROGRAM)_getPrivateProcAddress("glCreateProgram");
    if (!_ptr) {
        _ptr = &_fail_glCreateProgram;
    }
    _glCreateProgram = _ptr;
    return _glCreateProgram();
}

PFN_GLCREATEPROGRAM _glCreateProgram = &_get_glCreateProgram;

static GLuint APIENTRY _fail_glCreateShader(GLenum type) {
    const char *_name = "glCreateShader";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static GLuint APIENTRY _get_glCreateShader(GLenum type) {
    PFN_GLCREATESHADER _ptr;
    _ptr = (PFN_GLCREATESHADER)_getPrivateProcAddress("glCreateShader");
    if (!_ptr) {
        _ptr = &_fail_glCreateShader;
    }
    _glCreateShader = _ptr;
    return _glCreateShader(type);
}

PFN_GLCREATESHADER _glCreateShader = &_get_glCreateShader;

static void APIENTRY _fail_glDeleteProgram(GLuint program) {
    const char *_name = "glDeleteProgram";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glDeleteProgram(GLuint program) {
    PFN_GLDELETEPROGRAM _ptr;
    _ptr = (PFN_GLDELETEPROGRAM)_getPrivateProcAddress("glDeleteProgram");
    if (!_ptr) {
        _ptr = &_fail_glDeleteProgram;
    }
    _glDeleteProgram = _ptr;
    _glDeleteProgram(program);
}

PFN_GLDELETEPROGRAM _glDeleteProgram = &_get_glDeleteProgram;

static void APIENTRY _fail_glDeleteShader(GLuint shader) {
    const char *_name = "glDeleteShader";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glDeleteShader(GLuint shader) {
    PFN_GLDELETESHADER _ptr;
    _ptr = (PFN_GLDELETESHADER)_getPrivateProcAddress("glDeleteShader");
    if (!_ptr) {
        _ptr = &_fail_glDeleteShader;
    }
    _glDeleteShader = _ptr;
    _glDeleteShader(shader);
}

PFN_GLDELETESHADER _glDeleteShader = &_get_glDeleteShader;

static void APIENTRY _fail_glDetachShader(GLuint program, GLuint shader) {
    const char *_name = "glDetachShader";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glDetachShader(GLuint program, GLuint shader) {
    PFN_GLDETACHSHADER _ptr;
    _ptr = (PFN_GLDETACHSHADER)_getPrivateProcAddress("glDetachShader");
    if (!_ptr) {
        _ptr = &_fail_glDetachShader;
    }
    _glDetachShader = _ptr;
    _glDetachShader(program, shader);
}

PFN_GLDETACHSHADER _glDetachShader = &_get_glDetachShader;

static void APIENTRY _fail_glDisableVertexAttribArray(GLuint index) {
    const char *_name = "glDisableVertexAttribArray";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glDisableVertexAttribArray(GLuint index) {
    PFN_GLDISABLEVERTEXATTRIBARRAY _ptr;
    _ptr = (PFN_GLDISABLEVERTEXATTRIBARRAY)_getPrivateProcAddress("glDisableVertexAttribArray");
    if (!_ptr) {
        _ptr = &_fail_glDisableVertexAttribArray;
    }
    _glDisableVertexAttribArray = _ptr;
    _glDisableVertexAttribArray(index);
}

PFN_GLDISABLEVERTEXATTRIBARRAY _glDisableVertexAttribArray = &_get_glDisableVertexAttribArray;

static void APIENTRY _fail_glEnableVertexAttribArray(GLuint index) {
    const char *_name = "glEnableVertexAttribArray";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glEnableVertexAttribArray(GLuint index) {
    PFN_GLENABLEVERTEXATTRIBARRAY _ptr;
    _ptr = (PFN_GLENABLEVERTEXATTRIBARRAY)_getPrivateProcAddress("glEnableVertexAttribArray");
    if (!_ptr) {
        _ptr = &_fail_glEnableVertexAttribArray;
    }
    _glEnableVertexAttribArray = _ptr;
    _glEnableVertexAttribArray(index);
}

PFN_GLENABLEVERTEXATTRIBARRAY _glEnableVertexAttribArray = &_get_glEnableVertexAttribArray;

static void APIENTRY _fail_glGetActiveAttrib(GLuint program, GLuint index, GLsizei bufSize, GLsizei * length, GLint * size, GLenum * type, GLchar * name) {
    const char *_name = "glGetActiveAttrib";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetActiveAttrib(GLuint program, GLuint index, GLsizei bufSize, GLsizei * length, GLint * size, GLenum * type, GLchar * name) {
    PFN_GLGETACTIVEATTRIB _ptr;
    _ptr = (PFN_GLGETACTIVEATTRIB)_getPrivateProcAddress("glGetActiveAttrib");
    if (!_ptr) {
        _ptr = &_fail_glGetActiveAttrib;
    }
    _glGetActiveAttrib = _ptr;
    _glGetActiveAttrib(program, index, bufSize, length, size, type, name);
}

PFN_GLGETACTIVEATTRIB _glGetActiveAttrib = &_get_glGetActiveAttrib;

static void APIENTRY _fail_glGetActiveUniform(GLuint program, GLuint index, GLsizei bufSize, GLsizei * length, GLint * size, GLenum * type, GLchar * name) {
    const char *_name = "glGetActiveUniform";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetActiveUniform(GLuint program, GLuint index, GLsizei bufSize, GLsizei * length, GLint * size, GLenum * type, GLchar * name) {
    PFN_GLGETACTIVEUNIFORM _ptr;
    _ptr = (PFN_GLGETACTIVEUNIFORM)_getPrivateProcAddress("glGetActiveUniform");
    if (!_ptr) {
        _ptr = &_fail_glGetActiveUniform;
    }
    _glGetActiveUniform = _ptr;
    _glGetActiveUniform(program, index, bufSize, length, size, type, name);
}

PFN_GLGETACTIVEUNIFORM _glGetActiveUniform = &_get_glGetActiveUniform;

static void APIENTRY _fail_glGetAttachedShaders(GLuint program, GLsizei maxCount, GLsizei * count, GLuint * obj) {
    const char *_name = "glGetAttachedShaders";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetAttachedShaders(GLuint program, GLsizei maxCount, GLsizei * count, GLuint * obj) {
    PFN_GLGETATTACHEDSHADERS _ptr;
    _ptr = (PFN_GLGETATTACHEDSHADERS)_getPrivateProcAddress("glGetAttachedShaders");
    if (!_ptr) {
        _ptr = &_fail_glGetAttachedShaders;
    }
    _glGetAttachedShaders = _ptr;
    _glGetAttachedShaders(program, maxCount, count, obj);
}

PFN_GLGETATTACHEDSHADERS _glGetAttachedShaders = &_get_glGetAttachedShaders;

static GLint APIENTRY _fail_glGetAttribLocation(GLuint program, const GLchar * name) {
    const char *_name = "glGetAttribLocation";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static GLint APIENTRY _get_glGetAttribLocation(GLuint program, const GLchar * name) {
    PFN_GLGETATTRIBLOCATION _ptr;
    _ptr = (PFN_GLGETATTRIBLOCATION)_getPrivateProcAddress("glGetAttribLocation");
    if (!_ptr) {
        _ptr = &_fail_glGetAttribLocation;
    }
    _glGetAttribLocation = _ptr;
    return _glGetAttribLocation(program, name);
}

PFN_GLGETATTRIBLOCATION _glGetAttribLocation = &_get_glGetAttribLocation;

static void APIENTRY _fail_glGetProgramiv(GLuint program, GLenum pname, GLint * params) {
    const char *_name = "glGetProgramiv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetProgramiv(GLuint program, GLenum pname, GLint * params) {
    PFN_GLGETPROGRAMIV _ptr;
    _ptr = (PFN_GLGETPROGRAMIV)_getPrivateProcAddress("glGetProgramiv");
    if (!_ptr) {
        _ptr = &_fail_glGetProgramiv;
    }
    _glGetProgramiv = _ptr;
    _glGetProgramiv(program, pname, params);
}

PFN_GLGETPROGRAMIV _glGetProgramiv = &_get_glGetProgramiv;

static void APIENTRY _fail_glGetProgramInfoLog(GLuint program, GLsizei bufSize, GLsizei * length, GLchar * infoLog) {
    const char *_name = "glGetProgramInfoLog";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetProgramInfoLog(GLuint program, GLsizei bufSize, GLsizei * length, GLchar * infoLog) {
    PFN_GLGETPROGRAMINFOLOG _ptr;
    _ptr = (PFN_GLGETPROGRAMINFOLOG)_getPrivateProcAddress("glGetProgramInfoLog");
    if (!_ptr) {
        _ptr = &_fail_glGetProgramInfoLog;
    }
    _glGetProgramInfoLog = _ptr;
    _glGetProgramInfoLog(program, bufSize, length, infoLog);
}

PFN_GLGETPROGRAMINFOLOG _glGetProgramInfoLog = &_get_glGetProgramInfoLog;

static void APIENTRY _fail_glGetShaderiv(GLuint shader, GLenum pname, GLint * params) {
    const char *_name = "glGetShaderiv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetShaderiv(GLuint shader, GLenum pname, GLint * params) {
    PFN_GLGETSHADERIV _ptr;
    _ptr = (PFN_GLGETSHADERIV)_getPrivateProcAddress("glGetShaderiv");
    if (!_ptr) {
        _ptr = &_fail_glGetShaderiv;
    }
    _glGetShaderiv = _ptr;
    _glGetShaderiv(shader, pname, params);
}

PFN_GLGETSHADERIV _glGetShaderiv = &_get_glGetShaderiv;

static void APIENTRY _fail_glGetShaderInfoLog(GLuint shader, GLsizei bufSize, GLsizei * length, GLchar * infoLog) {
    const char *_name = "glGetShaderInfoLog";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetShaderInfoLog(GLuint shader, GLsizei bufSize, GLsizei * length, GLchar * infoLog) {
    PFN_GLGETSHADERINFOLOG _ptr;
    _ptr = (PFN_GLGETSHADERINFOLOG)_getPrivateProcAddress("glGetShaderInfoLog");
    if (!_ptr) {
        _ptr = &_fail_glGetShaderInfoLog;
    }
    _glGetShaderInfoLog = _ptr;
    _glGetShaderInfoLog(shader, bufSize, length, infoLog);
}

PFN_GLGETSHADERINFOLOG _glGetShaderInfoLog = &_get_glGetShaderInfoLog;

static void APIENTRY _fail_glGetShaderSource(GLuint shader, GLsizei bufSize, GLsizei * length, GLchar * source) {
    const char *_name = "glGetShaderSource";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetShaderSource(GLuint shader, GLsizei bufSize, GLsizei * length, GLchar * source) {
    PFN_GLGETSHADERSOURCE _ptr;
    _ptr = (PFN_GLGETSHADERSOURCE)_getPrivateProcAddress("glGetShaderSource");
    if (!_ptr) {
        _ptr = &_fail_glGetShaderSource;
    }
    _glGetShaderSource = _ptr;
    _glGetShaderSource(shader, bufSize, length, source);
}

PFN_GLGETSHADERSOURCE _glGetShaderSource = &_get_glGetShaderSource;

static GLint APIENTRY _fail_glGetUniformLocation(GLuint program, const GLchar * name) {
    const char *_name = "glGetUniformLocation";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static GLint APIENTRY _get_glGetUniformLocation(GLuint program, const GLchar * name) {
    PFN_GLGETUNIFORMLOCATION _ptr;
    _ptr = (PFN_GLGETUNIFORMLOCATION)_getPrivateProcAddress("glGetUniformLocation");
    if (!_ptr) {
        _ptr = &_fail_glGetUniformLocation;
    }
    _glGetUniformLocation = _ptr;
    return _glGetUniformLocation(program, name);
}

PFN_GLGETUNIFORMLOCATION _glGetUniformLocation = &_get_glGetUniformLocation;

static void APIENTRY _fail_glGetUniformfv(GLuint program, GLint location, GLfloat * params) {
    const char *_name = "glGetUniformfv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetUniformfv(GLuint program, GLint location, GLfloat * params) {
    PFN_GLGETUNIFORMFV _ptr;
    _ptr = (PFN_GLGETUNIFORMFV)_getPrivateProcAddress("glGetUniformfv");
    if (!_ptr) {
        _ptr = &_fail_glGetUniformfv;
    }
    _glGetUniformfv = _ptr;
    _glGetUniformfv(program, location, params);
}

PFN_GLGETUNIFORMFV _glGetUniformfv = &_get_glGetUniformfv;

static void APIENTRY _fail_glGetUniformiv(GLuint program, GLint location, GLint * params) {
    const char *_name = "glGetUniformiv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetUniformiv(GLuint program, GLint location, GLint * params) {
    PFN_GLGETUNIFORMIV _ptr;
    _ptr = (PFN_GLGETUNIFORMIV)_getPrivateProcAddress("glGetUniformiv");
    if (!_ptr) {
        _ptr = &_fail_glGetUniformiv;
    }
    _glGetUniformiv = _ptr;
    _glGetUniformiv(program, location, params);
}

PFN_GLGETUNIFORMIV _glGetUniformiv = &_get_glGetUniformiv;

static void APIENTRY _fail_glGetVertexAttribdv(GLuint index, GLenum pname, GLdouble * params) {
    const char *_name = "glGetVertexAttribdv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetVertexAttribdv(GLuint index, GLenum pname, GLdouble * params) {
    PFN_GLGETVERTEXATTRIBDV _ptr;
    _ptr = (PFN_GLGETVERTEXATTRIBDV)_getPrivateProcAddress("glGetVertexAttribdv");
    if (!_ptr) {
        _ptr = &_fail_glGetVertexAttribdv;
    }
    _glGetVertexAttribdv = _ptr;
    _glGetVertexAttribdv(index, pname, params);
}

PFN_GLGETVERTEXATTRIBDV _glGetVertexAttribdv = &_get_glGetVertexAttribdv;

static void APIENTRY _fail_glGetVertexAttribfv(GLuint index, GLenum pname, GLfloat * params) {
    const char *_name = "glGetVertexAttribfv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetVertexAttribfv(GLuint index, GLenum pname, GLfloat * params) {
    PFN_GLGETVERTEXATTRIBFV _ptr;
    _ptr = (PFN_GLGETVERTEXATTRIBFV)_getPrivateProcAddress("glGetVertexAttribfv");
    if (!_ptr) {
        _ptr = &_fail_glGetVertexAttribfv;
    }
    _glGetVertexAttribfv = _ptr;
    _glGetVertexAttribfv(index, pname, params);
}

PFN_GLGETVERTEXATTRIBFV _glGetVertexAttribfv = &_get_glGetVertexAttribfv;

static void APIENTRY _fail_glGetVertexAttribiv(GLuint index, GLenum pname, GLint * params) {
    const char *_name = "glGetVertexAttribiv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetVertexAttribiv(GLuint index, GLenum pname, GLint * params) {
    PFN_GLGETVERTEXATTRIBIV _ptr;
    _ptr = (PFN_GLGETVERTEXATTRIBIV)_getPrivateProcAddress("glGetVertexAttribiv");
    if (!_ptr) {
        _ptr = &_fail_glGetVertexAttribiv;
    }
    _glGetVertexAttribiv = _ptr;
    _glGetVertexAttribiv(index, pname, params);
}

PFN_GLGETVERTEXATTRIBIV _glGetVertexAttribiv = &_get_glGetVertexAttribiv;

static void APIENTRY _fail_glGetVertexAttribPointerv(GLuint index, GLenum pname, GLvoid * * pointer) {
    const char *_name = "glGetVertexAttribPointerv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetVertexAttribPointerv(GLuint index, GLenum pname, GLvoid * * pointer) {
    PFN_GLGETVERTEXATTRIBPOINTERV _ptr;
    _ptr = (PFN_GLGETVERTEXATTRIBPOINTERV)_getPrivateProcAddress("glGetVertexAttribPointerv");
    if (!_ptr) {
        _ptr = &_fail_glGetVertexAttribPointerv;
    }
    _glGetVertexAttribPointerv = _ptr;
    _glGetVertexAttribPointerv(index, pname, pointer);
}

PFN_GLGETVERTEXATTRIBPOINTERV _glGetVertexAttribPointerv = &_get_glGetVertexAttribPointerv;

static GLboolean APIENTRY _fail_glIsProgram(GLuint program) {
    const char *_name = "glIsProgram";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static GLboolean APIENTRY _get_glIsProgram(GLuint program) {
    PFN_GLISPROGRAM _ptr;
    _ptr = (PFN_GLISPROGRAM)_getPrivateProcAddress("glIsProgram");
    if (!_ptr) {
        _ptr = &_fail_glIsProgram;
    }
    _glIsProgram = _ptr;
    return _glIsProgram(program);
}

PFN_GLISPROGRAM _glIsProgram = &_get_glIsProgram;

static GLboolean APIENTRY _fail_glIsShader(GLuint shader) {
    const char *_name = "glIsShader";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static GLboolean APIENTRY _get_glIsShader(GLuint shader) {
    PFN_GLISSHADER _ptr;
    _ptr = (PFN_GLISSHADER)_getPrivateProcAddress("glIsShader");
    if (!_ptr) {
        _ptr = &_fail_glIsShader;
    }
    _glIsShader = _ptr;
    return _glIsShader(shader);
}

PFN_GLISSHADER _glIsShader = &_get_glIsShader;

static void APIENTRY _fail_glLinkProgram(GLuint program) {
    const char *_name = "glLinkProgram";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glLinkProgram(GLuint program) {
    PFN_GLLINKPROGRAM _ptr;
    _ptr = (PFN_GLLINKPROGRAM)_getPrivateProcAddress("glLinkProgram");
    if (!_ptr) {
        _ptr = &_fail_glLinkProgram;
    }
    _glLinkProgram = _ptr;
    _glLinkProgram(program);
}

PFN_GLLINKPROGRAM _glLinkProgram = &_get_glLinkProgram;

static void APIENTRY _fail_glShaderSource(GLuint shader, GLsizei count, const GLchar * const * string, const GLint * length) {
    const char *_name = "glShaderSource";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glShaderSource(GLuint shader, GLsizei count, const GLchar * const * string, const GLint * length) {
    PFN_GLSHADERSOURCE _ptr;
    _ptr = (PFN_GLSHADERSOURCE)_getPrivateProcAddress("glShaderSource");
    if (!_ptr) {
        _ptr = &_fail_glShaderSource;
    }
    _glShaderSource = _ptr;
    _glShaderSource(shader, count, string, length);
}

PFN_GLSHADERSOURCE _glShaderSource = &_get_glShaderSource;

static void APIENTRY _fail_glUseProgram(GLuint program) {
    const char *_name = "glUseProgram";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glUseProgram(GLuint program) {
    PFN_GLUSEPROGRAM _ptr;
    _ptr = (PFN_GLUSEPROGRAM)_getPrivateProcAddress("glUseProgram");
    if (!_ptr) {
        _ptr = &_fail_glUseProgram;
    }
    _glUseProgram = _ptr;
    _glUseProgram(program);
}

PFN_GLUSEPROGRAM _glUseProgram = &_get_glUseProgram;

static void APIENTRY _fail_glUniform1f(GLint location, GLfloat v0) {
    const char *_name = "glUniform1f";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glUniform1f(GLint location, GLfloat v0) {
    PFN_GLUNIFORM1F _ptr;
    _ptr = (PFN_GLUNIFORM1F)_getPrivateProcAddress("glUniform1f");
    if (!_ptr) {
        _ptr = &_fail_glUniform1f;
    }
    _glUniform1f = _ptr;
    _glUniform1f(location, v0);
}

PFN_GLUNIFORM1F _glUniform1f = &_get_glUniform1f;

static void APIENTRY _fail_glUniform2f(GLint location, GLfloat v0, GLfloat v1) {
    const char *_name = "glUniform2f";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glUniform2f(GLint location, GLfloat v0, GLfloat v1) {
    PFN_GLUNIFORM2F _ptr;
    _ptr = (PFN_GLUNIFORM2F)_getPrivateProcAddress("glUniform2f");
    if (!_ptr) {
        _ptr = &_fail_glUniform2f;
    }
    _glUniform2f = _ptr;
    _glUniform2f(location, v0, v1);
}

PFN_GLUNIFORM2F _glUniform2f = &_get_glUniform2f;

static void APIENTRY _fail_glUniform3f(GLint location, GLfloat v0, GLfloat v1, GLfloat v2) {
    const char *_name = "glUniform3f";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glUniform3f(GLint location, GLfloat v0, GLfloat v1, GLfloat v2) {
    PFN_GLUNIFORM3F _ptr;
    _ptr = (PFN_GLUNIFORM3F)_getPrivateProcAddress("glUniform3f");
    if (!_ptr) {
        _ptr = &_fail_glUniform3f;
    }
    _glUniform3f = _ptr;
    _glUniform3f(location, v0, v1, v2);
}

PFN_GLUNIFORM3F _glUniform3f = &_get_glUniform3f;

static void APIENTRY _fail_glUniform4f(GLint location, GLfloat v0, GLfloat v1, GLfloat v2, GLfloat v3) {
    const char *_name = "glUniform4f";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glUniform4f(GLint location, GLfloat v0, GLfloat v1, GLfloat v2, GLfloat v3) {
    PFN_GLUNIFORM4F _ptr;
    _ptr = (PFN_GLUNIFORM4F)_getPrivateProcAddress("glUniform4f");
    if (!_ptr) {
        _ptr = &_fail_glUniform4f;
    }
    _glUniform4f = _ptr;
    _glUniform4f(location, v0, v1, v2, v3);
}

PFN_GLUNIFORM4F _glUniform4f = &_get_glUniform4f;

static void APIENTRY _fail_glUniform1i(GLint location, GLint v0) {
    const char *_name = "glUniform1i";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glUniform1i(GLint location, GLint v0) {
    PFN_GLUNIFORM1I _ptr;
    _ptr = (PFN_GLUNIFORM1I)_getPrivateProcAddress("glUniform1i");
    if (!_ptr) {
        _ptr = &_fail_glUniform1i;
    }
    _glUniform1i = _ptr;
    _glUniform1i(location, v0);
}

PFN_GLUNIFORM1I _glUniform1i = &_get_glUniform1i;

static void APIENTRY _fail_glUniform2i(GLint location, GLint v0, GLint v1) {
    const char *_name = "glUniform2i";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glUniform2i(GLint location, GLint v0, GLint v1) {
    PFN_GLUNIFORM2I _ptr;
    _ptr = (PFN_GLUNIFORM2I)_getPrivateProcAddress("glUniform2i");
    if (!_ptr) {
        _ptr = &_fail_glUniform2i;
    }
    _glUniform2i = _ptr;
    _glUniform2i(location, v0, v1);
}

PFN_GLUNIFORM2I _glUniform2i = &_get_glUniform2i;

static void APIENTRY _fail_glUniform3i(GLint location, GLint v0, GLint v1, GLint v2) {
    const char *_name = "glUniform3i";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glUniform3i(GLint location, GLint v0, GLint v1, GLint v2) {
    PFN_GLUNIFORM3I _ptr;
    _ptr = (PFN_GLUNIFORM3I)_getPrivateProcAddress("glUniform3i");
    if (!_ptr) {
        _ptr = &_fail_glUniform3i;
    }
    _glUniform3i = _ptr;
    _glUniform3i(location, v0, v1, v2);
}

PFN_GLUNIFORM3I _glUniform3i = &_get_glUniform3i;

static void APIENTRY _fail_glUniform4i(GLint location, GLint v0, GLint v1, GLint v2, GLint v3) {
    const char *_name = "glUniform4i";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glUniform4i(GLint location, GLint v0, GLint v1, GLint v2, GLint v3) {
    PFN_GLUNIFORM4I _ptr;
    _ptr = (PFN_GLUNIFORM4I)_getPrivateProcAddress("glUniform4i");
    if (!_ptr) {
        _ptr = &_fail_glUniform4i;
    }
    _glUniform4i = _ptr;
    _glUniform4i(location, v0, v1, v2, v3);
}

PFN_GLUNIFORM4I _glUniform4i = &_get_glUniform4i;

static void APIENTRY _fail_glUniform1fv(GLint location, GLsizei count, const GLfloat * value) {
    const char *_name = "glUniform1fv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glUniform1fv(GLint location, GLsizei count, const GLfloat * value) {
    PFN_GLUNIFORM1FV _ptr;
    _ptr = (PFN_GLUNIFORM1FV)_getPrivateProcAddress("glUniform1fv");
    if (!_ptr) {
        _ptr = &_fail_glUniform1fv;
    }
    _glUniform1fv = _ptr;
    _glUniform1fv(location, count, value);
}

PFN_GLUNIFORM1FV _glUniform1fv = &_get_glUniform1fv;

static void APIENTRY _fail_glUniform2fv(GLint location, GLsizei count, const GLfloat * value) {
    const char *_name = "glUniform2fv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glUniform2fv(GLint location, GLsizei count, const GLfloat * value) {
    PFN_GLUNIFORM2FV _ptr;
    _ptr = (PFN_GLUNIFORM2FV)_getPrivateProcAddress("glUniform2fv");
    if (!_ptr) {
        _ptr = &_fail_glUniform2fv;
    }
    _glUniform2fv = _ptr;
    _glUniform2fv(location, count, value);
}

PFN_GLUNIFORM2FV _glUniform2fv = &_get_glUniform2fv;

static void APIENTRY _fail_glUniform3fv(GLint location, GLsizei count, const GLfloat * value) {
    const char *_name = "glUniform3fv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glUniform3fv(GLint location, GLsizei count, const GLfloat * value) {
    PFN_GLUNIFORM3FV _ptr;
    _ptr = (PFN_GLUNIFORM3FV)_getPrivateProcAddress("glUniform3fv");
    if (!_ptr) {
        _ptr = &_fail_glUniform3fv;
    }
    _glUniform3fv = _ptr;
    _glUniform3fv(location, count, value);
}

PFN_GLUNIFORM3FV _glUniform3fv = &_get_glUniform3fv;

static void APIENTRY _fail_glUniform4fv(GLint location, GLsizei count, const GLfloat * value) {
    const char *_name = "glUniform4fv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glUniform4fv(GLint location, GLsizei count, const GLfloat * value) {
    PFN_GLUNIFORM4FV _ptr;
    _ptr = (PFN_GLUNIFORM4FV)_getPrivateProcAddress("glUniform4fv");
    if (!_ptr) {
        _ptr = &_fail_glUniform4fv;
    }
    _glUniform4fv = _ptr;
    _glUniform4fv(location, count, value);
}

PFN_GLUNIFORM4FV _glUniform4fv = &_get_glUniform4fv;

static void APIENTRY _fail_glUniform1iv(GLint location, GLsizei count, const GLint * value) {
    const char *_name = "glUniform1iv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glUniform1iv(GLint location, GLsizei count, const GLint * value) {
    PFN_GLUNIFORM1IV _ptr;
    _ptr = (PFN_GLUNIFORM1IV)_getPrivateProcAddress("glUniform1iv");
    if (!_ptr) {
        _ptr = &_fail_glUniform1iv;
    }
    _glUniform1iv = _ptr;
    _glUniform1iv(location, count, value);
}

PFN_GLUNIFORM1IV _glUniform1iv = &_get_glUniform1iv;

static void APIENTRY _fail_glUniform2iv(GLint location, GLsizei count, const GLint * value) {
    const char *_name = "glUniform2iv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glUniform2iv(GLint location, GLsizei count, const GLint * value) {
    PFN_GLUNIFORM2IV _ptr;
    _ptr = (PFN_GLUNIFORM2IV)_getPrivateProcAddress("glUniform2iv");
    if (!_ptr) {
        _ptr = &_fail_glUniform2iv;
    }
    _glUniform2iv = _ptr;
    _glUniform2iv(location, count, value);
}

PFN_GLUNIFORM2IV _glUniform2iv = &_get_glUniform2iv;

static void APIENTRY _fail_glUniform3iv(GLint location, GLsizei count, const GLint * value) {
    const char *_name = "glUniform3iv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glUniform3iv(GLint location, GLsizei count, const GLint * value) {
    PFN_GLUNIFORM3IV _ptr;
    _ptr = (PFN_GLUNIFORM3IV)_getPrivateProcAddress("glUniform3iv");
    if (!_ptr) {
        _ptr = &_fail_glUniform3iv;
    }
    _glUniform3iv = _ptr;
    _glUniform3iv(location, count, value);
}

PFN_GLUNIFORM3IV _glUniform3iv = &_get_glUniform3iv;

static void APIENTRY _fail_glUniform4iv(GLint location, GLsizei count, const GLint * value) {
    const char *_name = "glUniform4iv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glUniform4iv(GLint location, GLsizei count, const GLint * value) {
    PFN_GLUNIFORM4IV _ptr;
    _ptr = (PFN_GLUNIFORM4IV)_getPrivateProcAddress("glUniform4iv");
    if (!_ptr) {
        _ptr = &_fail_glUniform4iv;
    }
    _glUniform4iv = _ptr;
    _glUniform4iv(location, count, value);
}

PFN_GLUNIFORM4IV _glUniform4iv = &_get_glUniform4iv;

static void APIENTRY _fail_glUniformMatrix2fv(GLint location, GLsizei count, GLboolean transpose, const GLfloat * value) {
    const char *_name = "glUniformMatrix2fv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glUniformMatrix2fv(GLint location, GLsizei count, GLboolean transpose, const GLfloat * value) {
    PFN_GLUNIFORMMATRIX2FV _ptr;
    _ptr = (PFN_GLUNIFORMMATRIX2FV)_getPrivateProcAddress("glUniformMatrix2fv");
    if (!_ptr) {
        _ptr = &_fail_glUniformMatrix2fv;
    }
    _glUniformMatrix2fv = _ptr;
    _glUniformMatrix2fv(location, count, transpose, value);
}

PFN_GLUNIFORMMATRIX2FV _glUniformMatrix2fv = &_get_glUniformMatrix2fv;

static void APIENTRY _fail_glUniformMatrix3fv(GLint location, GLsizei count, GLboolean transpose, const GLfloat * value) {
    const char *_name = "glUniformMatrix3fv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glUniformMatrix3fv(GLint location, GLsizei count, GLboolean transpose, const GLfloat * value) {
    PFN_GLUNIFORMMATRIX3FV _ptr;
    _ptr = (PFN_GLUNIFORMMATRIX3FV)_getPrivateProcAddress("glUniformMatrix3fv");
    if (!_ptr) {
        _ptr = &_fail_glUniformMatrix3fv;
    }
    _glUniformMatrix3fv = _ptr;
    _glUniformMatrix3fv(location, count, transpose, value);
}

PFN_GLUNIFORMMATRIX3FV _glUniformMatrix3fv = &_get_glUniformMatrix3fv;

static void APIENTRY _fail_glUniformMatrix4fv(GLint location, GLsizei count, GLboolean transpose, const GLfloat * value) {
    const char *_name = "glUniformMatrix4fv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glUniformMatrix4fv(GLint location, GLsizei count, GLboolean transpose, const GLfloat * value) {
    PFN_GLUNIFORMMATRIX4FV _ptr;
    _ptr = (PFN_GLUNIFORMMATRIX4FV)_getPrivateProcAddress("glUniformMatrix4fv");
    if (!_ptr) {
        _ptr = &_fail_glUniformMatrix4fv;
    }
    _glUniformMatrix4fv = _ptr;
    _glUniformMatrix4fv(location, count, transpose, value);
}

PFN_GLUNIFORMMATRIX4FV _glUniformMatrix4fv = &_get_glUniformMatrix4fv;

static void APIENTRY _fail_glValidateProgram(GLuint program) {
    const char *_name = "glValidateProgram";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glValidateProgram(GLuint program) {
    PFN_GLVALIDATEPROGRAM _ptr;
    _ptr = (PFN_GLVALIDATEPROGRAM)_getPrivateProcAddress("glValidateProgram");
    if (!_ptr) {
        _ptr = &_fail_glValidateProgram;
    }
    _glValidateProgram = _ptr;
    _glValidateProgram(program);
}

PFN_GLVALIDATEPROGRAM _glValidateProgram = &_get_glValidateProgram;

static void APIENTRY _fail_glVertexAttrib1d(GLuint index, GLdouble x) {
    const char *_name = "glVertexAttrib1d";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glVertexAttrib1d(GLuint index, GLdouble x) {
    PFN_GLVERTEXATTRIB1D _ptr;
    _ptr = (PFN_GLVERTEXATTRIB1D)_getPrivateProcAddress("glVertexAttrib1d");
    if (!_ptr) {
        _ptr = &_fail_glVertexAttrib1d;
    }
    _glVertexAttrib1d = _ptr;
    _glVertexAttrib1d(index, x);
}

PFN_GLVERTEXATTRIB1D _glVertexAttrib1d = &_get_glVertexAttrib1d;

static void APIENTRY _fail_glVertexAttrib1dv(GLuint index, const GLdouble * v) {
    const char *_name = "glVertexAttrib1dv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glVertexAttrib1dv(GLuint index, const GLdouble * v) {
    PFN_GLVERTEXATTRIB1DV _ptr;
    _ptr = (PFN_GLVERTEXATTRIB1DV)_getPrivateProcAddress("glVertexAttrib1dv");
    if (!_ptr) {
        _ptr = &_fail_glVertexAttrib1dv;
    }
    _glVertexAttrib1dv = _ptr;
    _glVertexAttrib1dv(index, v);
}

PFN_GLVERTEXATTRIB1DV _glVertexAttrib1dv = &_get_glVertexAttrib1dv;

static void APIENTRY _fail_glVertexAttrib1f(GLuint index, GLfloat x) {
    const char *_name = "glVertexAttrib1f";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glVertexAttrib1f(GLuint index, GLfloat x) {
    PFN_GLVERTEXATTRIB1F _ptr;
    _ptr = (PFN_GLVERTEXATTRIB1F)_getPrivateProcAddress("glVertexAttrib1f");
    if (!_ptr) {
        _ptr = &_fail_glVertexAttrib1f;
    }
    _glVertexAttrib1f = _ptr;
    _glVertexAttrib1f(index, x);
}

PFN_GLVERTEXATTRIB1F _glVertexAttrib1f = &_get_glVertexAttrib1f;

static void APIENTRY _fail_glVertexAttrib1fv(GLuint index, const GLfloat * v) {
    const char *_name = "glVertexAttrib1fv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glVertexAttrib1fv(GLuint index, const GLfloat * v) {
    PFN_GLVERTEXATTRIB1FV _ptr;
    _ptr = (PFN_GLVERTEXATTRIB1FV)_getPrivateProcAddress("glVertexAttrib1fv");
    if (!_ptr) {
        _ptr = &_fail_glVertexAttrib1fv;
    }
    _glVertexAttrib1fv = _ptr;
    _glVertexAttrib1fv(index, v);
}

PFN_GLVERTEXATTRIB1FV _glVertexAttrib1fv = &_get_glVertexAttrib1fv;

static void APIENTRY _fail_glVertexAttrib1s(GLuint index, GLshort x) {
    const char *_name = "glVertexAttrib1s";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glVertexAttrib1s(GLuint index, GLshort x) {
    PFN_GLVERTEXATTRIB1S _ptr;
    _ptr = (PFN_GLVERTEXATTRIB1S)_getPrivateProcAddress("glVertexAttrib1s");
    if (!_ptr) {
        _ptr = &_fail_glVertexAttrib1s;
    }
    _glVertexAttrib1s = _ptr;
    _glVertexAttrib1s(index, x);
}

PFN_GLVERTEXATTRIB1S _glVertexAttrib1s = &_get_glVertexAttrib1s;

static void APIENTRY _fail_glVertexAttrib1sv(GLuint index, const GLshort * v) {
    const char *_name = "glVertexAttrib1sv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glVertexAttrib1sv(GLuint index, const GLshort * v) {
    PFN_GLVERTEXATTRIB1SV _ptr;
    _ptr = (PFN_GLVERTEXATTRIB1SV)_getPrivateProcAddress("glVertexAttrib1sv");
    if (!_ptr) {
        _ptr = &_fail_glVertexAttrib1sv;
    }
    _glVertexAttrib1sv = _ptr;
    _glVertexAttrib1sv(index, v);
}

PFN_GLVERTEXATTRIB1SV _glVertexAttrib1sv = &_get_glVertexAttrib1sv;

static void APIENTRY _fail_glVertexAttrib2d(GLuint index, GLdouble x, GLdouble y) {
    const char *_name = "glVertexAttrib2d";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glVertexAttrib2d(GLuint index, GLdouble x, GLdouble y) {
    PFN_GLVERTEXATTRIB2D _ptr;
    _ptr = (PFN_GLVERTEXATTRIB2D)_getPrivateProcAddress("glVertexAttrib2d");
    if (!_ptr) {
        _ptr = &_fail_glVertexAttrib2d;
    }
    _glVertexAttrib2d = _ptr;
    _glVertexAttrib2d(index, x, y);
}

PFN_GLVERTEXATTRIB2D _glVertexAttrib2d = &_get_glVertexAttrib2d;

static void APIENTRY _fail_glVertexAttrib2dv(GLuint index, const GLdouble * v) {
    const char *_name = "glVertexAttrib2dv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glVertexAttrib2dv(GLuint index, const GLdouble * v) {
    PFN_GLVERTEXATTRIB2DV _ptr;
    _ptr = (PFN_GLVERTEXATTRIB2DV)_getPrivateProcAddress("glVertexAttrib2dv");
    if (!_ptr) {
        _ptr = &_fail_glVertexAttrib2dv;
    }
    _glVertexAttrib2dv = _ptr;
    _glVertexAttrib2dv(index, v);
}

PFN_GLVERTEXATTRIB2DV _glVertexAttrib2dv = &_get_glVertexAttrib2dv;

static void APIENTRY _fail_glVertexAttrib2f(GLuint index, GLfloat x, GLfloat y) {
    const char *_name = "glVertexAttrib2f";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glVertexAttrib2f(GLuint index, GLfloat x, GLfloat y) {
    PFN_GLVERTEXATTRIB2F _ptr;
    _ptr = (PFN_GLVERTEXATTRIB2F)_getPrivateProcAddress("glVertexAttrib2f");
    if (!_ptr) {
        _ptr = &_fail_glVertexAttrib2f;
    }
    _glVertexAttrib2f = _ptr;
    _glVertexAttrib2f(index, x, y);
}

PFN_GLVERTEXATTRIB2F _glVertexAttrib2f = &_get_glVertexAttrib2f;

static void APIENTRY _fail_glVertexAttrib2fv(GLuint index, const GLfloat * v) {
    const char *_name = "glVertexAttrib2fv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glVertexAttrib2fv(GLuint index, const GLfloat * v) {
    PFN_GLVERTEXATTRIB2FV _ptr;
    _ptr = (PFN_GLVERTEXATTRIB2FV)_getPrivateProcAddress("glVertexAttrib2fv");
    if (!_ptr) {
        _ptr = &_fail_glVertexAttrib2fv;
    }
    _glVertexAttrib2fv = _ptr;
    _glVertexAttrib2fv(index, v);
}

PFN_GLVERTEXATTRIB2FV _glVertexAttrib2fv = &_get_glVertexAttrib2fv;

static void APIENTRY _fail_glVertexAttrib2s(GLuint index, GLshort x, GLshort y) {
    const char *_name = "glVertexAttrib2s";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glVertexAttrib2s(GLuint index, GLshort x, GLshort y) {
    PFN_GLVERTEXATTRIB2S _ptr;
    _ptr = (PFN_GLVERTEXATTRIB2S)_getPrivateProcAddress("glVertexAttrib2s");
    if (!_ptr) {
        _ptr = &_fail_glVertexAttrib2s;
    }
    _glVertexAttrib2s = _ptr;
    _glVertexAttrib2s(index, x, y);
}

PFN_GLVERTEXATTRIB2S _glVertexAttrib2s = &_get_glVertexAttrib2s;

static void APIENTRY _fail_glVertexAttrib2sv(GLuint index, const GLshort * v) {
    const char *_name = "glVertexAttrib2sv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glVertexAttrib2sv(GLuint index, const GLshort * v) {
    PFN_GLVERTEXATTRIB2SV _ptr;
    _ptr = (PFN_GLVERTEXATTRIB2SV)_getPrivateProcAddress("glVertexAttrib2sv");
    if (!_ptr) {
        _ptr = &_fail_glVertexAttrib2sv;
    }
    _glVertexAttrib2sv = _ptr;
    _glVertexAttrib2sv(index, v);
}

PFN_GLVERTEXATTRIB2SV _glVertexAttrib2sv = &_get_glVertexAttrib2sv;

static void APIENTRY _fail_glVertexAttrib3d(GLuint index, GLdouble x, GLdouble y, GLdouble z) {
    const char *_name = "glVertexAttrib3d";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glVertexAttrib3d(GLuint index, GLdouble x, GLdouble y, GLdouble z) {
    PFN_GLVERTEXATTRIB3D _ptr;
    _ptr = (PFN_GLVERTEXATTRIB3D)_getPrivateProcAddress("glVertexAttrib3d");
    if (!_ptr) {
        _ptr = &_fail_glVertexAttrib3d;
    }
    _glVertexAttrib3d = _ptr;
    _glVertexAttrib3d(index, x, y, z);
}

PFN_GLVERTEXATTRIB3D _glVertexAttrib3d = &_get_glVertexAttrib3d;

static void APIENTRY _fail_glVertexAttrib3dv(GLuint index, const GLdouble * v) {
    const char *_name = "glVertexAttrib3dv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glVertexAttrib3dv(GLuint index, const GLdouble * v) {
    PFN_GLVERTEXATTRIB3DV _ptr;
    _ptr = (PFN_GLVERTEXATTRIB3DV)_getPrivateProcAddress("glVertexAttrib3dv");
    if (!_ptr) {
        _ptr = &_fail_glVertexAttrib3dv;
    }
    _glVertexAttrib3dv = _ptr;
    _glVertexAttrib3dv(index, v);
}

PFN_GLVERTEXATTRIB3DV _glVertexAttrib3dv = &_get_glVertexAttrib3dv;

static void APIENTRY _fail_glVertexAttrib3f(GLuint index, GLfloat x, GLfloat y, GLfloat z) {
    const char *_name = "glVertexAttrib3f";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glVertexAttrib3f(GLuint index, GLfloat x, GLfloat y, GLfloat z) {
    PFN_GLVERTEXATTRIB3F _ptr;
    _ptr = (PFN_GLVERTEXATTRIB3F)_getPrivateProcAddress("glVertexAttrib3f");
    if (!_ptr) {
        _ptr = &_fail_glVertexAttrib3f;
    }
    _glVertexAttrib3f = _ptr;
    _glVertexAttrib3f(index, x, y, z);
}

PFN_GLVERTEXATTRIB3F _glVertexAttrib3f = &_get_glVertexAttrib3f;

static void APIENTRY _fail_glVertexAttrib3fv(GLuint index, const GLfloat * v) {
    const char *_name = "glVertexAttrib3fv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glVertexAttrib3fv(GLuint index, const GLfloat * v) {
    PFN_GLVERTEXATTRIB3FV _ptr;
    _ptr = (PFN_GLVERTEXATTRIB3FV)_getPrivateProcAddress("glVertexAttrib3fv");
    if (!_ptr) {
        _ptr = &_fail_glVertexAttrib3fv;
    }
    _glVertexAttrib3fv = _ptr;
    _glVertexAttrib3fv(index, v);
}

PFN_GLVERTEXATTRIB3FV _glVertexAttrib3fv = &_get_glVertexAttrib3fv;

static void APIENTRY _fail_glVertexAttrib3s(GLuint index, GLshort x, GLshort y, GLshort z) {
    const char *_name = "glVertexAttrib3s";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glVertexAttrib3s(GLuint index, GLshort x, GLshort y, GLshort z) {
    PFN_GLVERTEXATTRIB3S _ptr;
    _ptr = (PFN_GLVERTEXATTRIB3S)_getPrivateProcAddress("glVertexAttrib3s");
    if (!_ptr) {
        _ptr = &_fail_glVertexAttrib3s;
    }
    _glVertexAttrib3s = _ptr;
    _glVertexAttrib3s(index, x, y, z);
}

PFN_GLVERTEXATTRIB3S _glVertexAttrib3s = &_get_glVertexAttrib3s;

static void APIENTRY _fail_glVertexAttrib3sv(GLuint index, const GLshort * v) {
    const char *_name = "glVertexAttrib3sv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glVertexAttrib3sv(GLuint index, const GLshort * v) {
    PFN_GLVERTEXATTRIB3SV _ptr;
    _ptr = (PFN_GLVERTEXATTRIB3SV)_getPrivateProcAddress("glVertexAttrib3sv");
    if (!_ptr) {
        _ptr = &_fail_glVertexAttrib3sv;
    }
    _glVertexAttrib3sv = _ptr;
    _glVertexAttrib3sv(index, v);
}

PFN_GLVERTEXATTRIB3SV _glVertexAttrib3sv = &_get_glVertexAttrib3sv;

static void APIENTRY _fail_glVertexAttrib4Nbv(GLuint index, const GLbyte * v) {
    const char *_name = "glVertexAttrib4Nbv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glVertexAttrib4Nbv(GLuint index, const GLbyte * v) {
    PFN_GLVERTEXATTRIB4NBV _ptr;
    _ptr = (PFN_GLVERTEXATTRIB4NBV)_getPrivateProcAddress("glVertexAttrib4Nbv");
    if (!_ptr) {
        _ptr = &_fail_glVertexAttrib4Nbv;
    }
    _glVertexAttrib4Nbv = _ptr;
    _glVertexAttrib4Nbv(index, v);
}

PFN_GLVERTEXATTRIB4NBV _glVertexAttrib4Nbv = &_get_glVertexAttrib4Nbv;

static void APIENTRY _fail_glVertexAttrib4Niv(GLuint index, const GLint * v) {
    const char *_name = "glVertexAttrib4Niv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glVertexAttrib4Niv(GLuint index, const GLint * v) {
    PFN_GLVERTEXATTRIB4NIV _ptr;
    _ptr = (PFN_GLVERTEXATTRIB4NIV)_getPrivateProcAddress("glVertexAttrib4Niv");
    if (!_ptr) {
        _ptr = &_fail_glVertexAttrib4Niv;
    }
    _glVertexAttrib4Niv = _ptr;
    _glVertexAttrib4Niv(index, v);
}

PFN_GLVERTEXATTRIB4NIV _glVertexAttrib4Niv = &_get_glVertexAttrib4Niv;

static void APIENTRY _fail_glVertexAttrib4Nsv(GLuint index, const GLshort * v) {
    const char *_name = "glVertexAttrib4Nsv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glVertexAttrib4Nsv(GLuint index, const GLshort * v) {
    PFN_GLVERTEXATTRIB4NSV _ptr;
    _ptr = (PFN_GLVERTEXATTRIB4NSV)_getPrivateProcAddress("glVertexAttrib4Nsv");
    if (!_ptr) {
        _ptr = &_fail_glVertexAttrib4Nsv;
    }
    _glVertexAttrib4Nsv = _ptr;
    _glVertexAttrib4Nsv(index, v);
}

PFN_GLVERTEXATTRIB4NSV _glVertexAttrib4Nsv = &_get_glVertexAttrib4Nsv;

static void APIENTRY _fail_glVertexAttrib4Nub(GLuint index, GLubyte x, GLubyte y, GLubyte z, GLubyte w) {
    const char *_name = "glVertexAttrib4Nub";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glVertexAttrib4Nub(GLuint index, GLubyte x, GLubyte y, GLubyte z, GLubyte w) {
    PFN_GLVERTEXATTRIB4NUB _ptr;
    _ptr = (PFN_GLVERTEXATTRIB4NUB)_getPrivateProcAddress("glVertexAttrib4Nub");
    if (!_ptr) {
        _ptr = &_fail_glVertexAttrib4Nub;
    }
    _glVertexAttrib4Nub = _ptr;
    _glVertexAttrib4Nub(index, x, y, z, w);
}

PFN_GLVERTEXATTRIB4NUB _glVertexAttrib4Nub = &_get_glVertexAttrib4Nub;

static void APIENTRY _fail_glVertexAttrib4Nubv(GLuint index, const GLubyte * v) {
    const char *_name = "glVertexAttrib4Nubv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glVertexAttrib4Nubv(GLuint index, const GLubyte * v) {
    PFN_GLVERTEXATTRIB4NUBV _ptr;
    _ptr = (PFN_GLVERTEXATTRIB4NUBV)_getPrivateProcAddress("glVertexAttrib4Nubv");
    if (!_ptr) {
        _ptr = &_fail_glVertexAttrib4Nubv;
    }
    _glVertexAttrib4Nubv = _ptr;
    _glVertexAttrib4Nubv(index, v);
}

PFN_GLVERTEXATTRIB4NUBV _glVertexAttrib4Nubv = &_get_glVertexAttrib4Nubv;

static void APIENTRY _fail_glVertexAttrib4Nuiv(GLuint index, const GLuint * v) {
    const char *_name = "glVertexAttrib4Nuiv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glVertexAttrib4Nuiv(GLuint index, const GLuint * v) {
    PFN_GLVERTEXATTRIB4NUIV _ptr;
    _ptr = (PFN_GLVERTEXATTRIB4NUIV)_getPrivateProcAddress("glVertexAttrib4Nuiv");
    if (!_ptr) {
        _ptr = &_fail_glVertexAttrib4Nuiv;
    }
    _glVertexAttrib4Nuiv = _ptr;
    _glVertexAttrib4Nuiv(index, v);
}

PFN_GLVERTEXATTRIB4NUIV _glVertexAttrib4Nuiv = &_get_glVertexAttrib4Nuiv;

static void APIENTRY _fail_glVertexAttrib4Nusv(GLuint index, const GLushort * v) {
    const char *_name = "glVertexAttrib4Nusv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glVertexAttrib4Nusv(GLuint index, const GLushort * v) {
    PFN_GLVERTEXATTRIB4NUSV _ptr;
    _ptr = (PFN_GLVERTEXATTRIB4NUSV)_getPrivateProcAddress("glVertexAttrib4Nusv");
    if (!_ptr) {
        _ptr = &_fail_glVertexAttrib4Nusv;
    }
    _glVertexAttrib4Nusv = _ptr;
    _glVertexAttrib4Nusv(index, v);
}

PFN_GLVERTEXATTRIB4NUSV _glVertexAttrib4Nusv = &_get_glVertexAttrib4Nusv;

static void APIENTRY _fail_glVertexAttrib4bv(GLuint index, const GLbyte * v) {
    const char *_name = "glVertexAttrib4bv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glVertexAttrib4bv(GLuint index, const GLbyte * v) {
    PFN_GLVERTEXATTRIB4BV _ptr;
    _ptr = (PFN_GLVERTEXATTRIB4BV)_getPrivateProcAddress("glVertexAttrib4bv");
    if (!_ptr) {
        _ptr = &_fail_glVertexAttrib4bv;
    }
    _glVertexAttrib4bv = _ptr;
    _glVertexAttrib4bv(index, v);
}

PFN_GLVERTEXATTRIB4BV _glVertexAttrib4bv = &_get_glVertexAttrib4bv;

static void APIENTRY _fail_glVertexAttrib4d(GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w) {
    const char *_name = "glVertexAttrib4d";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glVertexAttrib4d(GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w) {
    PFN_GLVERTEXATTRIB4D _ptr;
    _ptr = (PFN_GLVERTEXATTRIB4D)_getPrivateProcAddress("glVertexAttrib4d");
    if (!_ptr) {
        _ptr = &_fail_glVertexAttrib4d;
    }
    _glVertexAttrib4d = _ptr;
    _glVertexAttrib4d(index, x, y, z, w);
}

PFN_GLVERTEXATTRIB4D _glVertexAttrib4d = &_get_glVertexAttrib4d;

static void APIENTRY _fail_glVertexAttrib4dv(GLuint index, const GLdouble * v) {
    const char *_name = "glVertexAttrib4dv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glVertexAttrib4dv(GLuint index, const GLdouble * v) {
    PFN_GLVERTEXATTRIB4DV _ptr;
    _ptr = (PFN_GLVERTEXATTRIB4DV)_getPrivateProcAddress("glVertexAttrib4dv");
    if (!_ptr) {
        _ptr = &_fail_glVertexAttrib4dv;
    }
    _glVertexAttrib4dv = _ptr;
    _glVertexAttrib4dv(index, v);
}

PFN_GLVERTEXATTRIB4DV _glVertexAttrib4dv = &_get_glVertexAttrib4dv;

static void APIENTRY _fail_glVertexAttrib4f(GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w) {
    const char *_name = "glVertexAttrib4f";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glVertexAttrib4f(GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w) {
    PFN_GLVERTEXATTRIB4F _ptr;
    _ptr = (PFN_GLVERTEXATTRIB4F)_getPrivateProcAddress("glVertexAttrib4f");
    if (!_ptr) {
        _ptr = &_fail_glVertexAttrib4f;
    }
    _glVertexAttrib4f = _ptr;
    _glVertexAttrib4f(index, x, y, z, w);
}

PFN_GLVERTEXATTRIB4F _glVertexAttrib4f = &_get_glVertexAttrib4f;

static void APIENTRY _fail_glVertexAttrib4fv(GLuint index, const GLfloat * v) {
    const char *_name = "glVertexAttrib4fv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glVertexAttrib4fv(GLuint index, const GLfloat * v) {
    PFN_GLVERTEXATTRIB4FV _ptr;
    _ptr = (PFN_GLVERTEXATTRIB4FV)_getPrivateProcAddress("glVertexAttrib4fv");
    if (!_ptr) {
        _ptr = &_fail_glVertexAttrib4fv;
    }
    _glVertexAttrib4fv = _ptr;
    _glVertexAttrib4fv(index, v);
}

PFN_GLVERTEXATTRIB4FV _glVertexAttrib4fv = &_get_glVertexAttrib4fv;

static void APIENTRY _fail_glVertexAttrib4iv(GLuint index, const GLint * v) {
    const char *_name = "glVertexAttrib4iv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glVertexAttrib4iv(GLuint index, const GLint * v) {
    PFN_GLVERTEXATTRIB4IV _ptr;
    _ptr = (PFN_GLVERTEXATTRIB4IV)_getPrivateProcAddress("glVertexAttrib4iv");
    if (!_ptr) {
        _ptr = &_fail_glVertexAttrib4iv;
    }
    _glVertexAttrib4iv = _ptr;
    _glVertexAttrib4iv(index, v);
}

PFN_GLVERTEXATTRIB4IV _glVertexAttrib4iv = &_get_glVertexAttrib4iv;

static void APIENTRY _fail_glVertexAttrib4s(GLuint index, GLshort x, GLshort y, GLshort z, GLshort w) {
    const char *_name = "glVertexAttrib4s";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glVertexAttrib4s(GLuint index, GLshort x, GLshort y, GLshort z, GLshort w) {
    PFN_GLVERTEXATTRIB4S _ptr;
    _ptr = (PFN_GLVERTEXATTRIB4S)_getPrivateProcAddress("glVertexAttrib4s");
    if (!_ptr) {
        _ptr = &_fail_glVertexAttrib4s;
    }
    _glVertexAttrib4s = _ptr;
    _glVertexAttrib4s(index, x, y, z, w);
}

PFN_GLVERTEXATTRIB4S _glVertexAttrib4s = &_get_glVertexAttrib4s;

static void APIENTRY _fail_glVertexAttrib4sv(GLuint index, const GLshort * v) {
    const char *_name = "glVertexAttrib4sv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glVertexAttrib4sv(GLuint index, const GLshort * v) {
    PFN_GLVERTEXATTRIB4SV _ptr;
    _ptr = (PFN_GLVERTEXATTRIB4SV)_getPrivateProcAddress("glVertexAttrib4sv");
    if (!_ptr) {
        _ptr = &_fail_glVertexAttrib4sv;
    }
    _glVertexAttrib4sv = _ptr;
    _glVertexAttrib4sv(index, v);
}

PFN_GLVERTEXATTRIB4SV _glVertexAttrib4sv = &_get_glVertexAttrib4sv;

static void APIENTRY _fail_glVertexAttrib4ubv(GLuint index, const GLubyte * v) {
    const char *_name = "glVertexAttrib4ubv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glVertexAttrib4ubv(GLuint index, const GLubyte * v) {
    PFN_GLVERTEXATTRIB4UBV _ptr;
    _ptr = (PFN_GLVERTEXATTRIB4UBV)_getPrivateProcAddress("glVertexAttrib4ubv");
    if (!_ptr) {
        _ptr = &_fail_glVertexAttrib4ubv;
    }
    _glVertexAttrib4ubv = _ptr;
    _glVertexAttrib4ubv(index, v);
}

PFN_GLVERTEXATTRIB4UBV _glVertexAttrib4ubv = &_get_glVertexAttrib4ubv;

static void APIENTRY _fail_glVertexAttrib4uiv(GLuint index, const GLuint * v) {
    const char *_name = "glVertexAttrib4uiv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glVertexAttrib4uiv(GLuint index, const GLuint * v) {
    PFN_GLVERTEXATTRIB4UIV _ptr;
    _ptr = (PFN_GLVERTEXATTRIB4UIV)_getPrivateProcAddress("glVertexAttrib4uiv");
    if (!_ptr) {
        _ptr = &_fail_glVertexAttrib4uiv;
    }
    _glVertexAttrib4uiv = _ptr;
    _glVertexAttrib4uiv(index, v);
}

PFN_GLVERTEXATTRIB4UIV _glVertexAttrib4uiv = &_get_glVertexAttrib4uiv;

static void APIENTRY _fail_glVertexAttrib4usv(GLuint index, const GLushort * v) {
    const char *_name = "glVertexAttrib4usv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glVertexAttrib4usv(GLuint index, const GLushort * v) {
    PFN_GLVERTEXATTRIB4USV _ptr;
    _ptr = (PFN_GLVERTEXATTRIB4USV)_getPrivateProcAddress("glVertexAttrib4usv");
    if (!_ptr) {
        _ptr = &_fail_glVertexAttrib4usv;
    }
    _glVertexAttrib4usv = _ptr;
    _glVertexAttrib4usv(index, v);
}

PFN_GLVERTEXATTRIB4USV _glVertexAttrib4usv = &_get_glVertexAttrib4usv;

static void APIENTRY _fail_glVertexAttribPointer(GLuint index, GLint size, GLenum type, GLboolean normalized, GLsizei stride, const GLvoid * pointer) {
    const char *_name = "glVertexAttribPointer";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glVertexAttribPointer(GLuint index, GLint size, GLenum type, GLboolean normalized, GLsizei stride, const GLvoid * pointer) {
    PFN_GLVERTEXATTRIBPOINTER _ptr;
    _ptr = (PFN_GLVERTEXATTRIBPOINTER)_getPrivateProcAddress("glVertexAttribPointer");
    if (!_ptr) {
        _ptr = &_fail_glVertexAttribPointer;
    }
    _glVertexAttribPointer = _ptr;
    _glVertexAttribPointer(index, size, type, normalized, stride, pointer);
}

PFN_GLVERTEXATTRIBPOINTER _glVertexAttribPointer = &_get_glVertexAttribPointer;

static void APIENTRY _fail_glUniformMatrix2x3fv(GLint location, GLsizei count, GLboolean transpose, const GLfloat * value) {
    const char *_name = "glUniformMatrix2x3fv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glUniformMatrix2x3fv(GLint location, GLsizei count, GLboolean transpose, const GLfloat * value) {
    PFN_GLUNIFORMMATRIX2X3FV _ptr;
    _ptr = (PFN_GLUNIFORMMATRIX2X3FV)_getPrivateProcAddress("glUniformMatrix2x3fv");
    if (!_ptr) {
        _ptr = &_fail_glUniformMatrix2x3fv;
    }
    _glUniformMatrix2x3fv = _ptr;
    _glUniformMatrix2x3fv(location, count, transpose, value);
}

PFN_GLUNIFORMMATRIX2X3FV _glUniformMatrix2x3fv = &_get_glUniformMatrix2x3fv;

static void APIENTRY _fail_glUniformMatrix3x2fv(GLint location, GLsizei count, GLboolean transpose, const GLfloat * value) {
    const char *_name = "glUniformMatrix3x2fv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glUniformMatrix3x2fv(GLint location, GLsizei count, GLboolean transpose, const GLfloat * value) {
    PFN_GLUNIFORMMATRIX3X2FV _ptr;
    _ptr = (PFN_GLUNIFORMMATRIX3X2FV)_getPrivateProcAddress("glUniformMatrix3x2fv");
    if (!_ptr) {
        _ptr = &_fail_glUniformMatrix3x2fv;
    }
    _glUniformMatrix3x2fv = _ptr;
    _glUniformMatrix3x2fv(location, count, transpose, value);
}

PFN_GLUNIFORMMATRIX3X2FV _glUniformMatrix3x2fv = &_get_glUniformMatrix3x2fv;

static void APIENTRY _fail_glUniformMatrix2x4fv(GLint location, GLsizei count, GLboolean transpose, const GLfloat * value) {
    const char *_name = "glUniformMatrix2x4fv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glUniformMatrix2x4fv(GLint location, GLsizei count, GLboolean transpose, const GLfloat * value) {
    PFN_GLUNIFORMMATRIX2X4FV _ptr;
    _ptr = (PFN_GLUNIFORMMATRIX2X4FV)_getPrivateProcAddress("glUniformMatrix2x4fv");
    if (!_ptr) {
        _ptr = &_fail_glUniformMatrix2x4fv;
    }
    _glUniformMatrix2x4fv = _ptr;
    _glUniformMatrix2x4fv(location, count, transpose, value);
}

PFN_GLUNIFORMMATRIX2X4FV _glUniformMatrix2x4fv = &_get_glUniformMatrix2x4fv;

static void APIENTRY _fail_glUniformMatrix4x2fv(GLint location, GLsizei count, GLboolean transpose, const GLfloat * value) {
    const char *_name = "glUniformMatrix4x2fv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glUniformMatrix4x2fv(GLint location, GLsizei count, GLboolean transpose, const GLfloat * value) {
    PFN_GLUNIFORMMATRIX4X2FV _ptr;
    _ptr = (PFN_GLUNIFORMMATRIX4X2FV)_getPrivateProcAddress("glUniformMatrix4x2fv");
    if (!_ptr) {
        _ptr = &_fail_glUniformMatrix4x2fv;
    }
    _glUniformMatrix4x2fv = _ptr;
    _glUniformMatrix4x2fv(location, count, transpose, value);
}

PFN_GLUNIFORMMATRIX4X2FV _glUniformMatrix4x2fv = &_get_glUniformMatrix4x2fv;

static void APIENTRY _fail_glUniformMatrix3x4fv(GLint location, GLsizei count, GLboolean transpose, const GLfloat * value) {
    const char *_name = "glUniformMatrix3x4fv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glUniformMatrix3x4fv(GLint location, GLsizei count, GLboolean transpose, const GLfloat * value) {
    PFN_GLUNIFORMMATRIX3X4FV _ptr;
    _ptr = (PFN_GLUNIFORMMATRIX3X4FV)_getPrivateProcAddress("glUniformMatrix3x4fv");
    if (!_ptr) {
        _ptr = &_fail_glUniformMatrix3x4fv;
    }
    _glUniformMatrix3x4fv = _ptr;
    _glUniformMatrix3x4fv(location, count, transpose, value);
}

PFN_GLUNIFORMMATRIX3X4FV _glUniformMatrix3x4fv = &_get_glUniformMatrix3x4fv;

static void APIENTRY _fail_glUniformMatrix4x3fv(GLint location, GLsizei count, GLboolean transpose, const GLfloat * value) {
    const char *_name = "glUniformMatrix4x3fv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glUniformMatrix4x3fv(GLint location, GLsizei count, GLboolean transpose, const GLfloat * value) {
    PFN_GLUNIFORMMATRIX4X3FV _ptr;
    _ptr = (PFN_GLUNIFORMMATRIX4X3FV)_getPrivateProcAddress("glUniformMatrix4x3fv");
    if (!_ptr) {
        _ptr = &_fail_glUniformMatrix4x3fv;
    }
    _glUniformMatrix4x3fv = _ptr;
    _glUniformMatrix4x3fv(location, count, transpose, value);
}

PFN_GLUNIFORMMATRIX4X3FV _glUniformMatrix4x3fv = &_get_glUniformMatrix4x3fv;

static void APIENTRY _fail_glColorMaski(GLuint index, GLboolean r, GLboolean g, GLboolean b, GLboolean a) {
    const char *_name = "glColorMaski";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glColorMaski(GLuint index, GLboolean r, GLboolean g, GLboolean b, GLboolean a) {
    PFN_GLCOLORMASKI _ptr;
    _ptr = (PFN_GLCOLORMASKI)_getPrivateProcAddress("glColorMaski");
    if (!_ptr) {
        _ptr = &_fail_glColorMaski;
    }
    _glColorMaski = _ptr;
    _glColorMaski(index, r, g, b, a);
}

PFN_GLCOLORMASKI _glColorMaski = &_get_glColorMaski;

static void APIENTRY _fail_glGetBooleani_v(GLenum target, GLuint index, GLboolean * data) {
    const char *_name = "glGetBooleani_v";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetBooleani_v(GLenum target, GLuint index, GLboolean * data) {
    PFN_GLGETBOOLEANI_V _ptr;
    _ptr = (PFN_GLGETBOOLEANI_V)_getPrivateProcAddress("glGetBooleani_v");
    if (!_ptr) {
        _ptr = &_fail_glGetBooleani_v;
    }
    _glGetBooleani_v = _ptr;
    _glGetBooleani_v(target, index, data);
}

PFN_GLGETBOOLEANI_V _glGetBooleani_v = &_get_glGetBooleani_v;

static void APIENTRY _fail_glGetIntegeri_v(GLenum target, GLuint index, GLint * data) {
    const char *_name = "glGetIntegeri_v";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetIntegeri_v(GLenum target, GLuint index, GLint * data) {
    PFN_GLGETINTEGERI_V _ptr;
    _ptr = (PFN_GLGETINTEGERI_V)_getPrivateProcAddress("glGetIntegeri_v");
    if (!_ptr) {
        _ptr = &_fail_glGetIntegeri_v;
    }
    _glGetIntegeri_v = _ptr;
    _glGetIntegeri_v(target, index, data);
}

PFN_GLGETINTEGERI_V _glGetIntegeri_v = &_get_glGetIntegeri_v;

static void APIENTRY _fail_glEnablei(GLenum target, GLuint index) {
    const char *_name = "glEnablei";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glEnablei(GLenum target, GLuint index) {
    PFN_GLENABLEI _ptr;
    _ptr = (PFN_GLENABLEI)_getPrivateProcAddress("glEnablei");
    if (!_ptr) {
        _ptr = &_fail_glEnablei;
    }
    _glEnablei = _ptr;
    _glEnablei(target, index);
}

PFN_GLENABLEI _glEnablei = &_get_glEnablei;

static void APIENTRY _fail_glDisablei(GLenum target, GLuint index) {
    const char *_name = "glDisablei";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glDisablei(GLenum target, GLuint index) {
    PFN_GLDISABLEI _ptr;
    _ptr = (PFN_GLDISABLEI)_getPrivateProcAddress("glDisablei");
    if (!_ptr) {
        _ptr = &_fail_glDisablei;
    }
    _glDisablei = _ptr;
    _glDisablei(target, index);
}

PFN_GLDISABLEI _glDisablei = &_get_glDisablei;

static GLboolean APIENTRY _fail_glIsEnabledi(GLenum target, GLuint index) {
    const char *_name = "glIsEnabledi";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static GLboolean APIENTRY _get_glIsEnabledi(GLenum target, GLuint index) {
    PFN_GLISENABLEDI _ptr;
    _ptr = (PFN_GLISENABLEDI)_getPrivateProcAddress("glIsEnabledi");
    if (!_ptr) {
        _ptr = &_fail_glIsEnabledi;
    }
    _glIsEnabledi = _ptr;
    return _glIsEnabledi(target, index);
}

PFN_GLISENABLEDI _glIsEnabledi = &_get_glIsEnabledi;

static void APIENTRY _fail_glBeginTransformFeedback(GLenum primitiveMode) {
    const char *_name = "glBeginTransformFeedback";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glBeginTransformFeedback(GLenum primitiveMode) {
    PFN_GLBEGINTRANSFORMFEEDBACK _ptr;
    _ptr = (PFN_GLBEGINTRANSFORMFEEDBACK)_getPrivateProcAddress("glBeginTransformFeedback");
    if (!_ptr) {
        _ptr = &_fail_glBeginTransformFeedback;
    }
    _glBeginTransformFeedback = _ptr;
    _glBeginTransformFeedback(primitiveMode);
}

PFN_GLBEGINTRANSFORMFEEDBACK _glBeginTransformFeedback = &_get_glBeginTransformFeedback;

static void APIENTRY _fail_glEndTransformFeedback(void) {
    const char *_name = "glEndTransformFeedback";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glEndTransformFeedback(void) {
    PFN_GLENDTRANSFORMFEEDBACK _ptr;
    _ptr = (PFN_GLENDTRANSFORMFEEDBACK)_getPrivateProcAddress("glEndTransformFeedback");
    if (!_ptr) {
        _ptr = &_fail_glEndTransformFeedback;
    }
    _glEndTransformFeedback = _ptr;
    _glEndTransformFeedback();
}

PFN_GLENDTRANSFORMFEEDBACK _glEndTransformFeedback = &_get_glEndTransformFeedback;

static void APIENTRY _fail_glBindBufferRange(GLenum target, GLuint index, GLuint buffer, GLintptr offset, GLsizeiptr size) {
    const char *_name = "glBindBufferRange";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glBindBufferRange(GLenum target, GLuint index, GLuint buffer, GLintptr offset, GLsizeiptr size) {
    PFN_GLBINDBUFFERRANGE _ptr;
    _ptr = (PFN_GLBINDBUFFERRANGE)_getPrivateProcAddress("glBindBufferRange");
    if (!_ptr) {
        _ptr = &_fail_glBindBufferRange;
    }
    _glBindBufferRange = _ptr;
    _glBindBufferRange(target, index, buffer, offset, size);
}

PFN_GLBINDBUFFERRANGE _glBindBufferRange = &_get_glBindBufferRange;

static void APIENTRY _fail_glBindBufferBase(GLenum target, GLuint index, GLuint buffer) {
    const char *_name = "glBindBufferBase";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glBindBufferBase(GLenum target, GLuint index, GLuint buffer) {
    PFN_GLBINDBUFFERBASE _ptr;
    _ptr = (PFN_GLBINDBUFFERBASE)_getPrivateProcAddress("glBindBufferBase");
    if (!_ptr) {
        _ptr = &_fail_glBindBufferBase;
    }
    _glBindBufferBase = _ptr;
    _glBindBufferBase(target, index, buffer);
}

PFN_GLBINDBUFFERBASE _glBindBufferBase = &_get_glBindBufferBase;

static void APIENTRY _fail_glTransformFeedbackVaryings(GLuint program, GLsizei count, const GLchar * const * varyings, GLenum bufferMode) {
    const char *_name = "glTransformFeedbackVaryings";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glTransformFeedbackVaryings(GLuint program, GLsizei count, const GLchar * const * varyings, GLenum bufferMode) {
    PFN_GLTRANSFORMFEEDBACKVARYINGS _ptr;
    _ptr = (PFN_GLTRANSFORMFEEDBACKVARYINGS)_getPrivateProcAddress("glTransformFeedbackVaryings");
    if (!_ptr) {
        _ptr = &_fail_glTransformFeedbackVaryings;
    }
    _glTransformFeedbackVaryings = _ptr;
    _glTransformFeedbackVaryings(program, count, varyings, bufferMode);
}

PFN_GLTRANSFORMFEEDBACKVARYINGS _glTransformFeedbackVaryings = &_get_glTransformFeedbackVaryings;

static void APIENTRY _fail_glGetTransformFeedbackVarying(GLuint program, GLuint index, GLsizei bufSize, GLsizei * length, GLsizei * size, GLenum * type, GLchar * name) {
    const char *_name = "glGetTransformFeedbackVarying";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetTransformFeedbackVarying(GLuint program, GLuint index, GLsizei bufSize, GLsizei * length, GLsizei * size, GLenum * type, GLchar * name) {
    PFN_GLGETTRANSFORMFEEDBACKVARYING _ptr;
    _ptr = (PFN_GLGETTRANSFORMFEEDBACKVARYING)_getPrivateProcAddress("glGetTransformFeedbackVarying");
    if (!_ptr) {
        _ptr = &_fail_glGetTransformFeedbackVarying;
    }
    _glGetTransformFeedbackVarying = _ptr;
    _glGetTransformFeedbackVarying(program, index, bufSize, length, size, type, name);
}

PFN_GLGETTRANSFORMFEEDBACKVARYING _glGetTransformFeedbackVarying = &_get_glGetTransformFeedbackVarying;

static void APIENTRY _fail_glClampColor(GLenum target, GLenum clamp) {
    const char *_name = "glClampColor";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glClampColor(GLenum target, GLenum clamp) {
    PFN_GLCLAMPCOLOR _ptr;
    _ptr = (PFN_GLCLAMPCOLOR)_getPrivateProcAddress("glClampColor");
    if (!_ptr) {
        _ptr = &_fail_glClampColor;
    }
    _glClampColor = _ptr;
    _glClampColor(target, clamp);
}

PFN_GLCLAMPCOLOR _glClampColor = &_get_glClampColor;

static void APIENTRY _fail_glBeginConditionalRender(GLuint id, GLenum mode) {
    const char *_name = "glBeginConditionalRender";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glBeginConditionalRender(GLuint id, GLenum mode) {
    PFN_GLBEGINCONDITIONALRENDER _ptr;
    _ptr = (PFN_GLBEGINCONDITIONALRENDER)_getPrivateProcAddress("glBeginConditionalRender");
    if (!_ptr) {
        _ptr = &_fail_glBeginConditionalRender;
    }
    _glBeginConditionalRender = _ptr;
    _glBeginConditionalRender(id, mode);
}

PFN_GLBEGINCONDITIONALRENDER _glBeginConditionalRender = &_get_glBeginConditionalRender;

static void APIENTRY _fail_glEndConditionalRender(void) {
    const char *_name = "glEndConditionalRender";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glEndConditionalRender(void) {
    PFN_GLENDCONDITIONALRENDER _ptr;
    _ptr = (PFN_GLENDCONDITIONALRENDER)_getPrivateProcAddress("glEndConditionalRender");
    if (!_ptr) {
        _ptr = &_fail_glEndConditionalRender;
    }
    _glEndConditionalRender = _ptr;
    _glEndConditionalRender();
}

PFN_GLENDCONDITIONALRENDER _glEndConditionalRender = &_get_glEndConditionalRender;

static void APIENTRY _fail_glVertexAttribIPointer(GLuint index, GLint size, GLenum type, GLsizei stride, const GLvoid * pointer) {
    const char *_name = "glVertexAttribIPointer";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glVertexAttribIPointer(GLuint index, GLint size, GLenum type, GLsizei stride, const GLvoid * pointer) {
    PFN_GLVERTEXATTRIBIPOINTER _ptr;
    _ptr = (PFN_GLVERTEXATTRIBIPOINTER)_getPrivateProcAddress("glVertexAttribIPointer");
    if (!_ptr) {
        _ptr = &_fail_glVertexAttribIPointer;
    }
    _glVertexAttribIPointer = _ptr;
    _glVertexAttribIPointer(index, size, type, stride, pointer);
}

PFN_GLVERTEXATTRIBIPOINTER _glVertexAttribIPointer = &_get_glVertexAttribIPointer;

static void APIENTRY _fail_glGetVertexAttribIiv(GLuint index, GLenum pname, GLint * params) {
    const char *_name = "glGetVertexAttribIiv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetVertexAttribIiv(GLuint index, GLenum pname, GLint * params) {
    PFN_GLGETVERTEXATTRIBIIV _ptr;
    _ptr = (PFN_GLGETVERTEXATTRIBIIV)_getPrivateProcAddress("glGetVertexAttribIiv");
    if (!_ptr) {
        _ptr = &_fail_glGetVertexAttribIiv;
    }
    _glGetVertexAttribIiv = _ptr;
    _glGetVertexAttribIiv(index, pname, params);
}

PFN_GLGETVERTEXATTRIBIIV _glGetVertexAttribIiv = &_get_glGetVertexAttribIiv;

static void APIENTRY _fail_glGetVertexAttribIuiv(GLuint index, GLenum pname, GLuint * params) {
    const char *_name = "glGetVertexAttribIuiv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetVertexAttribIuiv(GLuint index, GLenum pname, GLuint * params) {
    PFN_GLGETVERTEXATTRIBIUIV _ptr;
    _ptr = (PFN_GLGETVERTEXATTRIBIUIV)_getPrivateProcAddress("glGetVertexAttribIuiv");
    if (!_ptr) {
        _ptr = &_fail_glGetVertexAttribIuiv;
    }
    _glGetVertexAttribIuiv = _ptr;
    _glGetVertexAttribIuiv(index, pname, params);
}

PFN_GLGETVERTEXATTRIBIUIV _glGetVertexAttribIuiv = &_get_glGetVertexAttribIuiv;

static void APIENTRY _fail_glVertexAttribI1i(GLuint index, GLint x) {
    const char *_name = "glVertexAttribI1i";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glVertexAttribI1i(GLuint index, GLint x) {
    PFN_GLVERTEXATTRIBI1I _ptr;
    _ptr = (PFN_GLVERTEXATTRIBI1I)_getPrivateProcAddress("glVertexAttribI1i");
    if (!_ptr) {
        _ptr = &_fail_glVertexAttribI1i;
    }
    _glVertexAttribI1i = _ptr;
    _glVertexAttribI1i(index, x);
}

PFN_GLVERTEXATTRIBI1I _glVertexAttribI1i = &_get_glVertexAttribI1i;

static void APIENTRY _fail_glVertexAttribI2i(GLuint index, GLint x, GLint y) {
    const char *_name = "glVertexAttribI2i";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glVertexAttribI2i(GLuint index, GLint x, GLint y) {
    PFN_GLVERTEXATTRIBI2I _ptr;
    _ptr = (PFN_GLVERTEXATTRIBI2I)_getPrivateProcAddress("glVertexAttribI2i");
    if (!_ptr) {
        _ptr = &_fail_glVertexAttribI2i;
    }
    _glVertexAttribI2i = _ptr;
    _glVertexAttribI2i(index, x, y);
}

PFN_GLVERTEXATTRIBI2I _glVertexAttribI2i = &_get_glVertexAttribI2i;

static void APIENTRY _fail_glVertexAttribI3i(GLuint index, GLint x, GLint y, GLint z) {
    const char *_name = "glVertexAttribI3i";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glVertexAttribI3i(GLuint index, GLint x, GLint y, GLint z) {
    PFN_GLVERTEXATTRIBI3I _ptr;
    _ptr = (PFN_GLVERTEXATTRIBI3I)_getPrivateProcAddress("glVertexAttribI3i");
    if (!_ptr) {
        _ptr = &_fail_glVertexAttribI3i;
    }
    _glVertexAttribI3i = _ptr;
    _glVertexAttribI3i(index, x, y, z);
}

PFN_GLVERTEXATTRIBI3I _glVertexAttribI3i = &_get_glVertexAttribI3i;

static void APIENTRY _fail_glVertexAttribI4i(GLuint index, GLint x, GLint y, GLint z, GLint w) {
    const char *_name = "glVertexAttribI4i";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glVertexAttribI4i(GLuint index, GLint x, GLint y, GLint z, GLint w) {
    PFN_GLVERTEXATTRIBI4I _ptr;
    _ptr = (PFN_GLVERTEXATTRIBI4I)_getPrivateProcAddress("glVertexAttribI4i");
    if (!_ptr) {
        _ptr = &_fail_glVertexAttribI4i;
    }
    _glVertexAttribI4i = _ptr;
    _glVertexAttribI4i(index, x, y, z, w);
}

PFN_GLVERTEXATTRIBI4I _glVertexAttribI4i = &_get_glVertexAttribI4i;

static void APIENTRY _fail_glVertexAttribI1ui(GLuint index, GLuint x) {
    const char *_name = "glVertexAttribI1ui";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glVertexAttribI1ui(GLuint index, GLuint x) {
    PFN_GLVERTEXATTRIBI1UI _ptr;
    _ptr = (PFN_GLVERTEXATTRIBI1UI)_getPrivateProcAddress("glVertexAttribI1ui");
    if (!_ptr) {
        _ptr = &_fail_glVertexAttribI1ui;
    }
    _glVertexAttribI1ui = _ptr;
    _glVertexAttribI1ui(index, x);
}

PFN_GLVERTEXATTRIBI1UI _glVertexAttribI1ui = &_get_glVertexAttribI1ui;

static void APIENTRY _fail_glVertexAttribI2ui(GLuint index, GLuint x, GLuint y) {
    const char *_name = "glVertexAttribI2ui";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glVertexAttribI2ui(GLuint index, GLuint x, GLuint y) {
    PFN_GLVERTEXATTRIBI2UI _ptr;
    _ptr = (PFN_GLVERTEXATTRIBI2UI)_getPrivateProcAddress("glVertexAttribI2ui");
    if (!_ptr) {
        _ptr = &_fail_glVertexAttribI2ui;
    }
    _glVertexAttribI2ui = _ptr;
    _glVertexAttribI2ui(index, x, y);
}

PFN_GLVERTEXATTRIBI2UI _glVertexAttribI2ui = &_get_glVertexAttribI2ui;

static void APIENTRY _fail_glVertexAttribI3ui(GLuint index, GLuint x, GLuint y, GLuint z) {
    const char *_name = "glVertexAttribI3ui";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glVertexAttribI3ui(GLuint index, GLuint x, GLuint y, GLuint z) {
    PFN_GLVERTEXATTRIBI3UI _ptr;
    _ptr = (PFN_GLVERTEXATTRIBI3UI)_getPrivateProcAddress("glVertexAttribI3ui");
    if (!_ptr) {
        _ptr = &_fail_glVertexAttribI3ui;
    }
    _glVertexAttribI3ui = _ptr;
    _glVertexAttribI3ui(index, x, y, z);
}

PFN_GLVERTEXATTRIBI3UI _glVertexAttribI3ui = &_get_glVertexAttribI3ui;

static void APIENTRY _fail_glVertexAttribI4ui(GLuint index, GLuint x, GLuint y, GLuint z, GLuint w) {
    const char *_name = "glVertexAttribI4ui";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glVertexAttribI4ui(GLuint index, GLuint x, GLuint y, GLuint z, GLuint w) {
    PFN_GLVERTEXATTRIBI4UI _ptr;
    _ptr = (PFN_GLVERTEXATTRIBI4UI)_getPrivateProcAddress("glVertexAttribI4ui");
    if (!_ptr) {
        _ptr = &_fail_glVertexAttribI4ui;
    }
    _glVertexAttribI4ui = _ptr;
    _glVertexAttribI4ui(index, x, y, z, w);
}

PFN_GLVERTEXATTRIBI4UI _glVertexAttribI4ui = &_get_glVertexAttribI4ui;

static void APIENTRY _fail_glVertexAttribI1iv(GLuint index, const GLint * v) {
    const char *_name = "glVertexAttribI1iv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glVertexAttribI1iv(GLuint index, const GLint * v) {
    PFN_GLVERTEXATTRIBI1IV _ptr;
    _ptr = (PFN_GLVERTEXATTRIBI1IV)_getPrivateProcAddress("glVertexAttribI1iv");
    if (!_ptr) {
        _ptr = &_fail_glVertexAttribI1iv;
    }
    _glVertexAttribI1iv = _ptr;
    _glVertexAttribI1iv(index, v);
}

PFN_GLVERTEXATTRIBI1IV _glVertexAttribI1iv = &_get_glVertexAttribI1iv;

static void APIENTRY _fail_glVertexAttribI2iv(GLuint index, const GLint * v) {
    const char *_name = "glVertexAttribI2iv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glVertexAttribI2iv(GLuint index, const GLint * v) {
    PFN_GLVERTEXATTRIBI2IV _ptr;
    _ptr = (PFN_GLVERTEXATTRIBI2IV)_getPrivateProcAddress("glVertexAttribI2iv");
    if (!_ptr) {
        _ptr = &_fail_glVertexAttribI2iv;
    }
    _glVertexAttribI2iv = _ptr;
    _glVertexAttribI2iv(index, v);
}

PFN_GLVERTEXATTRIBI2IV _glVertexAttribI2iv = &_get_glVertexAttribI2iv;

static void APIENTRY _fail_glVertexAttribI3iv(GLuint index, const GLint * v) {
    const char *_name = "glVertexAttribI3iv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glVertexAttribI3iv(GLuint index, const GLint * v) {
    PFN_GLVERTEXATTRIBI3IV _ptr;
    _ptr = (PFN_GLVERTEXATTRIBI3IV)_getPrivateProcAddress("glVertexAttribI3iv");
    if (!_ptr) {
        _ptr = &_fail_glVertexAttribI3iv;
    }
    _glVertexAttribI3iv = _ptr;
    _glVertexAttribI3iv(index, v);
}

PFN_GLVERTEXATTRIBI3IV _glVertexAttribI3iv = &_get_glVertexAttribI3iv;

static void APIENTRY _fail_glVertexAttribI4iv(GLuint index, const GLint * v) {
    const char *_name = "glVertexAttribI4iv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glVertexAttribI4iv(GLuint index, const GLint * v) {
    PFN_GLVERTEXATTRIBI4IV _ptr;
    _ptr = (PFN_GLVERTEXATTRIBI4IV)_getPrivateProcAddress("glVertexAttribI4iv");
    if (!_ptr) {
        _ptr = &_fail_glVertexAttribI4iv;
    }
    _glVertexAttribI4iv = _ptr;
    _glVertexAttribI4iv(index, v);
}

PFN_GLVERTEXATTRIBI4IV _glVertexAttribI4iv = &_get_glVertexAttribI4iv;

static void APIENTRY _fail_glVertexAttribI1uiv(GLuint index, const GLuint * v) {
    const char *_name = "glVertexAttribI1uiv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glVertexAttribI1uiv(GLuint index, const GLuint * v) {
    PFN_GLVERTEXATTRIBI1UIV _ptr;
    _ptr = (PFN_GLVERTEXATTRIBI1UIV)_getPrivateProcAddress("glVertexAttribI1uiv");
    if (!_ptr) {
        _ptr = &_fail_glVertexAttribI1uiv;
    }
    _glVertexAttribI1uiv = _ptr;
    _glVertexAttribI1uiv(index, v);
}

PFN_GLVERTEXATTRIBI1UIV _glVertexAttribI1uiv = &_get_glVertexAttribI1uiv;

static void APIENTRY _fail_glVertexAttribI2uiv(GLuint index, const GLuint * v) {
    const char *_name = "glVertexAttribI2uiv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glVertexAttribI2uiv(GLuint index, const GLuint * v) {
    PFN_GLVERTEXATTRIBI2UIV _ptr;
    _ptr = (PFN_GLVERTEXATTRIBI2UIV)_getPrivateProcAddress("glVertexAttribI2uiv");
    if (!_ptr) {
        _ptr = &_fail_glVertexAttribI2uiv;
    }
    _glVertexAttribI2uiv = _ptr;
    _glVertexAttribI2uiv(index, v);
}

PFN_GLVERTEXATTRIBI2UIV _glVertexAttribI2uiv = &_get_glVertexAttribI2uiv;

static void APIENTRY _fail_glVertexAttribI3uiv(GLuint index, const GLuint * v) {
    const char *_name = "glVertexAttribI3uiv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glVertexAttribI3uiv(GLuint index, const GLuint * v) {
    PFN_GLVERTEXATTRIBI3UIV _ptr;
    _ptr = (PFN_GLVERTEXATTRIBI3UIV)_getPrivateProcAddress("glVertexAttribI3uiv");
    if (!_ptr) {
        _ptr = &_fail_glVertexAttribI3uiv;
    }
    _glVertexAttribI3uiv = _ptr;
    _glVertexAttribI3uiv(index, v);
}

PFN_GLVERTEXATTRIBI3UIV _glVertexAttribI3uiv = &_get_glVertexAttribI3uiv;

static void APIENTRY _fail_glVertexAttribI4uiv(GLuint index, const GLuint * v) {
    const char *_name = "glVertexAttribI4uiv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glVertexAttribI4uiv(GLuint index, const GLuint * v) {
    PFN_GLVERTEXATTRIBI4UIV _ptr;
    _ptr = (PFN_GLVERTEXATTRIBI4UIV)_getPrivateProcAddress("glVertexAttribI4uiv");
    if (!_ptr) {
        _ptr = &_fail_glVertexAttribI4uiv;
    }
    _glVertexAttribI4uiv = _ptr;
    _glVertexAttribI4uiv(index, v);
}

PFN_GLVERTEXATTRIBI4UIV _glVertexAttribI4uiv = &_get_glVertexAttribI4uiv;

static void APIENTRY _fail_glVertexAttribI4bv(GLuint index, const GLbyte * v) {
    const char *_name = "glVertexAttribI4bv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glVertexAttribI4bv(GLuint index, const GLbyte * v) {
    PFN_GLVERTEXATTRIBI4BV _ptr;
    _ptr = (PFN_GLVERTEXATTRIBI4BV)_getPrivateProcAddress("glVertexAttribI4bv");
    if (!_ptr) {
        _ptr = &_fail_glVertexAttribI4bv;
    }
    _glVertexAttribI4bv = _ptr;
    _glVertexAttribI4bv(index, v);
}

PFN_GLVERTEXATTRIBI4BV _glVertexAttribI4bv = &_get_glVertexAttribI4bv;

static void APIENTRY _fail_glVertexAttribI4sv(GLuint index, const GLshort * v) {
    const char *_name = "glVertexAttribI4sv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glVertexAttribI4sv(GLuint index, const GLshort * v) {
    PFN_GLVERTEXATTRIBI4SV _ptr;
    _ptr = (PFN_GLVERTEXATTRIBI4SV)_getPrivateProcAddress("glVertexAttribI4sv");
    if (!_ptr) {
        _ptr = &_fail_glVertexAttribI4sv;
    }
    _glVertexAttribI4sv = _ptr;
    _glVertexAttribI4sv(index, v);
}

PFN_GLVERTEXATTRIBI4SV _glVertexAttribI4sv = &_get_glVertexAttribI4sv;

static void APIENTRY _fail_glVertexAttribI4ubv(GLuint index, const GLubyte * v) {
    const char *_name = "glVertexAttribI4ubv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glVertexAttribI4ubv(GLuint index, const GLubyte * v) {
    PFN_GLVERTEXATTRIBI4UBV _ptr;
    _ptr = (PFN_GLVERTEXATTRIBI4UBV)_getPrivateProcAddress("glVertexAttribI4ubv");
    if (!_ptr) {
        _ptr = &_fail_glVertexAttribI4ubv;
    }
    _glVertexAttribI4ubv = _ptr;
    _glVertexAttribI4ubv(index, v);
}

PFN_GLVERTEXATTRIBI4UBV _glVertexAttribI4ubv = &_get_glVertexAttribI4ubv;

static void APIENTRY _fail_glVertexAttribI4usv(GLuint index, const GLushort * v) {
    const char *_name = "glVertexAttribI4usv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glVertexAttribI4usv(GLuint index, const GLushort * v) {
    PFN_GLVERTEXATTRIBI4USV _ptr;
    _ptr = (PFN_GLVERTEXATTRIBI4USV)_getPrivateProcAddress("glVertexAttribI4usv");
    if (!_ptr) {
        _ptr = &_fail_glVertexAttribI4usv;
    }
    _glVertexAttribI4usv = _ptr;
    _glVertexAttribI4usv(index, v);
}

PFN_GLVERTEXATTRIBI4USV _glVertexAttribI4usv = &_get_glVertexAttribI4usv;

static void APIENTRY _fail_glGetUniformuiv(GLuint program, GLint location, GLuint * params) {
    const char *_name = "glGetUniformuiv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetUniformuiv(GLuint program, GLint location, GLuint * params) {
    PFN_GLGETUNIFORMUIV _ptr;
    _ptr = (PFN_GLGETUNIFORMUIV)_getPrivateProcAddress("glGetUniformuiv");
    if (!_ptr) {
        _ptr = &_fail_glGetUniformuiv;
    }
    _glGetUniformuiv = _ptr;
    _glGetUniformuiv(program, location, params);
}

PFN_GLGETUNIFORMUIV _glGetUniformuiv = &_get_glGetUniformuiv;

static void APIENTRY _fail_glBindFragDataLocation(GLuint program, GLuint color, const GLchar * name) {
    const char *_name = "glBindFragDataLocation";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glBindFragDataLocation(GLuint program, GLuint color, const GLchar * name) {
    PFN_GLBINDFRAGDATALOCATION _ptr;
    _ptr = (PFN_GLBINDFRAGDATALOCATION)_getPrivateProcAddress("glBindFragDataLocation");
    if (!_ptr) {
        _ptr = &_fail_glBindFragDataLocation;
    }
    _glBindFragDataLocation = _ptr;
    _glBindFragDataLocation(program, color, name);
}

PFN_GLBINDFRAGDATALOCATION _glBindFragDataLocation = &_get_glBindFragDataLocation;

static GLint APIENTRY _fail_glGetFragDataLocation(GLuint program, const GLchar * name) {
    const char *_name = "glGetFragDataLocation";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static GLint APIENTRY _get_glGetFragDataLocation(GLuint program, const GLchar * name) {
    PFN_GLGETFRAGDATALOCATION _ptr;
    _ptr = (PFN_GLGETFRAGDATALOCATION)_getPrivateProcAddress("glGetFragDataLocation");
    if (!_ptr) {
        _ptr = &_fail_glGetFragDataLocation;
    }
    _glGetFragDataLocation = _ptr;
    return _glGetFragDataLocation(program, name);
}

PFN_GLGETFRAGDATALOCATION _glGetFragDataLocation = &_get_glGetFragDataLocation;

static void APIENTRY _fail_glUniform1ui(GLint location, GLuint v0) {
    const char *_name = "glUniform1ui";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glUniform1ui(GLint location, GLuint v0) {
    PFN_GLUNIFORM1UI _ptr;
    _ptr = (PFN_GLUNIFORM1UI)_getPrivateProcAddress("glUniform1ui");
    if (!_ptr) {
        _ptr = &_fail_glUniform1ui;
    }
    _glUniform1ui = _ptr;
    _glUniform1ui(location, v0);
}

PFN_GLUNIFORM1UI _glUniform1ui = &_get_glUniform1ui;

static void APIENTRY _fail_glUniform2ui(GLint location, GLuint v0, GLuint v1) {
    const char *_name = "glUniform2ui";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glUniform2ui(GLint location, GLuint v0, GLuint v1) {
    PFN_GLUNIFORM2UI _ptr;
    _ptr = (PFN_GLUNIFORM2UI)_getPrivateProcAddress("glUniform2ui");
    if (!_ptr) {
        _ptr = &_fail_glUniform2ui;
    }
    _glUniform2ui = _ptr;
    _glUniform2ui(location, v0, v1);
}

PFN_GLUNIFORM2UI _glUniform2ui = &_get_glUniform2ui;

static void APIENTRY _fail_glUniform3ui(GLint location, GLuint v0, GLuint v1, GLuint v2) {
    const char *_name = "glUniform3ui";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glUniform3ui(GLint location, GLuint v0, GLuint v1, GLuint v2) {
    PFN_GLUNIFORM3UI _ptr;
    _ptr = (PFN_GLUNIFORM3UI)_getPrivateProcAddress("glUniform3ui");
    if (!_ptr) {
        _ptr = &_fail_glUniform3ui;
    }
    _glUniform3ui = _ptr;
    _glUniform3ui(location, v0, v1, v2);
}

PFN_GLUNIFORM3UI _glUniform3ui = &_get_glUniform3ui;

static void APIENTRY _fail_glUniform4ui(GLint location, GLuint v0, GLuint v1, GLuint v2, GLuint v3) {
    const char *_name = "glUniform4ui";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glUniform4ui(GLint location, GLuint v0, GLuint v1, GLuint v2, GLuint v3) {
    PFN_GLUNIFORM4UI _ptr;
    _ptr = (PFN_GLUNIFORM4UI)_getPrivateProcAddress("glUniform4ui");
    if (!_ptr) {
        _ptr = &_fail_glUniform4ui;
    }
    _glUniform4ui = _ptr;
    _glUniform4ui(location, v0, v1, v2, v3);
}

PFN_GLUNIFORM4UI _glUniform4ui = &_get_glUniform4ui;

static void APIENTRY _fail_glUniform1uiv(GLint location, GLsizei count, const GLuint * value) {
    const char *_name = "glUniform1uiv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glUniform1uiv(GLint location, GLsizei count, const GLuint * value) {
    PFN_GLUNIFORM1UIV _ptr;
    _ptr = (PFN_GLUNIFORM1UIV)_getPrivateProcAddress("glUniform1uiv");
    if (!_ptr) {
        _ptr = &_fail_glUniform1uiv;
    }
    _glUniform1uiv = _ptr;
    _glUniform1uiv(location, count, value);
}

PFN_GLUNIFORM1UIV _glUniform1uiv = &_get_glUniform1uiv;

static void APIENTRY _fail_glUniform2uiv(GLint location, GLsizei count, const GLuint * value) {
    const char *_name = "glUniform2uiv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glUniform2uiv(GLint location, GLsizei count, const GLuint * value) {
    PFN_GLUNIFORM2UIV _ptr;
    _ptr = (PFN_GLUNIFORM2UIV)_getPrivateProcAddress("glUniform2uiv");
    if (!_ptr) {
        _ptr = &_fail_glUniform2uiv;
    }
    _glUniform2uiv = _ptr;
    _glUniform2uiv(location, count, value);
}

PFN_GLUNIFORM2UIV _glUniform2uiv = &_get_glUniform2uiv;

static void APIENTRY _fail_glUniform3uiv(GLint location, GLsizei count, const GLuint * value) {
    const char *_name = "glUniform3uiv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glUniform3uiv(GLint location, GLsizei count, const GLuint * value) {
    PFN_GLUNIFORM3UIV _ptr;
    _ptr = (PFN_GLUNIFORM3UIV)_getPrivateProcAddress("glUniform3uiv");
    if (!_ptr) {
        _ptr = &_fail_glUniform3uiv;
    }
    _glUniform3uiv = _ptr;
    _glUniform3uiv(location, count, value);
}

PFN_GLUNIFORM3UIV _glUniform3uiv = &_get_glUniform3uiv;

static void APIENTRY _fail_glUniform4uiv(GLint location, GLsizei count, const GLuint * value) {
    const char *_name = "glUniform4uiv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glUniform4uiv(GLint location, GLsizei count, const GLuint * value) {
    PFN_GLUNIFORM4UIV _ptr;
    _ptr = (PFN_GLUNIFORM4UIV)_getPrivateProcAddress("glUniform4uiv");
    if (!_ptr) {
        _ptr = &_fail_glUniform4uiv;
    }
    _glUniform4uiv = _ptr;
    _glUniform4uiv(location, count, value);
}

PFN_GLUNIFORM4UIV _glUniform4uiv = &_get_glUniform4uiv;

static void APIENTRY _fail_glTexParameterIiv(GLenum target, GLenum pname, const GLint * params) {
    const char *_name = "glTexParameterIiv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glTexParameterIiv(GLenum target, GLenum pname, const GLint * params) {
    PFN_GLTEXPARAMETERIIV _ptr;
    _ptr = (PFN_GLTEXPARAMETERIIV)_getPrivateProcAddress("glTexParameterIiv");
    if (!_ptr) {
        _ptr = &_fail_glTexParameterIiv;
    }
    _glTexParameterIiv = _ptr;
    _glTexParameterIiv(target, pname, params);
}

PFN_GLTEXPARAMETERIIV _glTexParameterIiv = &_get_glTexParameterIiv;

static void APIENTRY _fail_glTexParameterIuiv(GLenum target, GLenum pname, const GLuint * params) {
    const char *_name = "glTexParameterIuiv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glTexParameterIuiv(GLenum target, GLenum pname, const GLuint * params) {
    PFN_GLTEXPARAMETERIUIV _ptr;
    _ptr = (PFN_GLTEXPARAMETERIUIV)_getPrivateProcAddress("glTexParameterIuiv");
    if (!_ptr) {
        _ptr = &_fail_glTexParameterIuiv;
    }
    _glTexParameterIuiv = _ptr;
    _glTexParameterIuiv(target, pname, params);
}

PFN_GLTEXPARAMETERIUIV _glTexParameterIuiv = &_get_glTexParameterIuiv;

static void APIENTRY _fail_glGetTexParameterIiv(GLenum target, GLenum pname, GLint * params) {
    const char *_name = "glGetTexParameterIiv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetTexParameterIiv(GLenum target, GLenum pname, GLint * params) {
    PFN_GLGETTEXPARAMETERIIV _ptr;
    _ptr = (PFN_GLGETTEXPARAMETERIIV)_getPrivateProcAddress("glGetTexParameterIiv");
    if (!_ptr) {
        _ptr = &_fail_glGetTexParameterIiv;
    }
    _glGetTexParameterIiv = _ptr;
    _glGetTexParameterIiv(target, pname, params);
}

PFN_GLGETTEXPARAMETERIIV _glGetTexParameterIiv = &_get_glGetTexParameterIiv;

static void APIENTRY _fail_glGetTexParameterIuiv(GLenum target, GLenum pname, GLuint * params) {
    const char *_name = "glGetTexParameterIuiv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetTexParameterIuiv(GLenum target, GLenum pname, GLuint * params) {
    PFN_GLGETTEXPARAMETERIUIV _ptr;
    _ptr = (PFN_GLGETTEXPARAMETERIUIV)_getPrivateProcAddress("glGetTexParameterIuiv");
    if (!_ptr) {
        _ptr = &_fail_glGetTexParameterIuiv;
    }
    _glGetTexParameterIuiv = _ptr;
    _glGetTexParameterIuiv(target, pname, params);
}

PFN_GLGETTEXPARAMETERIUIV _glGetTexParameterIuiv = &_get_glGetTexParameterIuiv;

static void APIENTRY _fail_glClearBufferiv(GLenum buffer, GLint drawbuffer, const GLint * value) {
    const char *_name = "glClearBufferiv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glClearBufferiv(GLenum buffer, GLint drawbuffer, const GLint * value) {
    PFN_GLCLEARBUFFERIV _ptr;
    _ptr = (PFN_GLCLEARBUFFERIV)_getPrivateProcAddress("glClearBufferiv");
    if (!_ptr) {
        _ptr = &_fail_glClearBufferiv;
    }
    _glClearBufferiv = _ptr;
    _glClearBufferiv(buffer, drawbuffer, value);
}

PFN_GLCLEARBUFFERIV _glClearBufferiv = &_get_glClearBufferiv;

static void APIENTRY _fail_glClearBufferuiv(GLenum buffer, GLint drawbuffer, const GLuint * value) {
    const char *_name = "glClearBufferuiv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glClearBufferuiv(GLenum buffer, GLint drawbuffer, const GLuint * value) {
    PFN_GLCLEARBUFFERUIV _ptr;
    _ptr = (PFN_GLCLEARBUFFERUIV)_getPrivateProcAddress("glClearBufferuiv");
    if (!_ptr) {
        _ptr = &_fail_glClearBufferuiv;
    }
    _glClearBufferuiv = _ptr;
    _glClearBufferuiv(buffer, drawbuffer, value);
}

PFN_GLCLEARBUFFERUIV _glClearBufferuiv = &_get_glClearBufferuiv;

static void APIENTRY _fail_glClearBufferfv(GLenum buffer, GLint drawbuffer, const GLfloat * value) {
    const char *_name = "glClearBufferfv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glClearBufferfv(GLenum buffer, GLint drawbuffer, const GLfloat * value) {
    PFN_GLCLEARBUFFERFV _ptr;
    _ptr = (PFN_GLCLEARBUFFERFV)_getPrivateProcAddress("glClearBufferfv");
    if (!_ptr) {
        _ptr = &_fail_glClearBufferfv;
    }
    _glClearBufferfv = _ptr;
    _glClearBufferfv(buffer, drawbuffer, value);
}

PFN_GLCLEARBUFFERFV _glClearBufferfv = &_get_glClearBufferfv;

static void APIENTRY _fail_glClearBufferfi(GLenum buffer, GLint drawbuffer, GLfloat depth, GLint stencil) {
    const char *_name = "glClearBufferfi";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glClearBufferfi(GLenum buffer, GLint drawbuffer, GLfloat depth, GLint stencil) {
    PFN_GLCLEARBUFFERFI _ptr;
    _ptr = (PFN_GLCLEARBUFFERFI)_getPrivateProcAddress("glClearBufferfi");
    if (!_ptr) {
        _ptr = &_fail_glClearBufferfi;
    }
    _glClearBufferfi = _ptr;
    _glClearBufferfi(buffer, drawbuffer, depth, stencil);
}

PFN_GLCLEARBUFFERFI _glClearBufferfi = &_get_glClearBufferfi;

static const GLubyte * APIENTRY _fail_glGetStringi(GLenum name, GLuint index) {
    const char *_name = "glGetStringi";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static const GLubyte * APIENTRY _get_glGetStringi(GLenum name, GLuint index) {
    PFN_GLGETSTRINGI _ptr;
    _ptr = (PFN_GLGETSTRINGI)_getPrivateProcAddress("glGetStringi");
    if (!_ptr) {
        _ptr = &_fail_glGetStringi;
    }
    _glGetStringi = _ptr;
    return _glGetStringi(name, index);
}

PFN_GLGETSTRINGI _glGetStringi = &_get_glGetStringi;

static void APIENTRY _fail_glDrawArraysInstanced(GLenum mode, GLint first, GLsizei count, GLsizei instancecount) {
    const char *_name = "glDrawArraysInstanced";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glDrawArraysInstanced(GLenum mode, GLint first, GLsizei count, GLsizei instancecount) {
    PFN_GLDRAWARRAYSINSTANCED _ptr;
    _ptr = (PFN_GLDRAWARRAYSINSTANCED)_getPrivateProcAddress("glDrawArraysInstanced");
    if (!_ptr) {
        _ptr = &_fail_glDrawArraysInstanced;
    }
    _glDrawArraysInstanced = _ptr;
    _glDrawArraysInstanced(mode, first, count, instancecount);
}

PFN_GLDRAWARRAYSINSTANCED _glDrawArraysInstanced = &_get_glDrawArraysInstanced;

static void APIENTRY _fail_glDrawElementsInstanced(GLenum mode, GLsizei count, GLenum type, const GLvoid * indices, GLsizei instancecount) {
    const char *_name = "glDrawElementsInstanced";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glDrawElementsInstanced(GLenum mode, GLsizei count, GLenum type, const GLvoid * indices, GLsizei instancecount) {
    PFN_GLDRAWELEMENTSINSTANCED _ptr;
    _ptr = (PFN_GLDRAWELEMENTSINSTANCED)_getPrivateProcAddress("glDrawElementsInstanced");
    if (!_ptr) {
        _ptr = &_fail_glDrawElementsInstanced;
    }
    _glDrawElementsInstanced = _ptr;
    _glDrawElementsInstanced(mode, count, type, indices, instancecount);
}

PFN_GLDRAWELEMENTSINSTANCED _glDrawElementsInstanced = &_get_glDrawElementsInstanced;

static void APIENTRY _fail_glTexBuffer(GLenum target, GLenum internalformat, GLuint buffer) {
    const char *_name = "glTexBuffer";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glTexBuffer(GLenum target, GLenum internalformat, GLuint buffer) {
    PFN_GLTEXBUFFER _ptr;
    _ptr = (PFN_GLTEXBUFFER)_getPrivateProcAddress("glTexBuffer");
    if (!_ptr) {
        _ptr = &_fail_glTexBuffer;
    }
    _glTexBuffer = _ptr;
    _glTexBuffer(target, internalformat, buffer);
}

PFN_GLTEXBUFFER _glTexBuffer = &_get_glTexBuffer;

static void APIENTRY _fail_glPrimitiveRestartIndex(GLuint index) {
    const char *_name = "glPrimitiveRestartIndex";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glPrimitiveRestartIndex(GLuint index) {
    PFN_GLPRIMITIVERESTARTINDEX _ptr;
    _ptr = (PFN_GLPRIMITIVERESTARTINDEX)_getPrivateProcAddress("glPrimitiveRestartIndex");
    if (!_ptr) {
        _ptr = &_fail_glPrimitiveRestartIndex;
    }
    _glPrimitiveRestartIndex = _ptr;
    _glPrimitiveRestartIndex(index);
}

PFN_GLPRIMITIVERESTARTINDEX _glPrimitiveRestartIndex = &_get_glPrimitiveRestartIndex;

static void APIENTRY _fail_glGetInteger64i_v(GLenum target, GLuint index, GLint64 * data) {
    const char *_name = "glGetInteger64i_v";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetInteger64i_v(GLenum target, GLuint index, GLint64 * data) {
    PFN_GLGETINTEGER64I_V _ptr;
    _ptr = (PFN_GLGETINTEGER64I_V)_getPrivateProcAddress("glGetInteger64i_v");
    if (!_ptr) {
        _ptr = &_fail_glGetInteger64i_v;
    }
    _glGetInteger64i_v = _ptr;
    _glGetInteger64i_v(target, index, data);
}

PFN_GLGETINTEGER64I_V _glGetInteger64i_v = &_get_glGetInteger64i_v;

static void APIENTRY _fail_glGetBufferParameteri64v(GLenum target, GLenum pname, GLint64 * params) {
    const char *_name = "glGetBufferParameteri64v";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetBufferParameteri64v(GLenum target, GLenum pname, GLint64 * params) {
    PFN_GLGETBUFFERPARAMETERI64V _ptr;
    _ptr = (PFN_GLGETBUFFERPARAMETERI64V)_getPrivateProcAddress("glGetBufferParameteri64v");
    if (!_ptr) {
        _ptr = &_fail_glGetBufferParameteri64v;
    }
    _glGetBufferParameteri64v = _ptr;
    _glGetBufferParameteri64v(target, pname, params);
}

PFN_GLGETBUFFERPARAMETERI64V _glGetBufferParameteri64v = &_get_glGetBufferParameteri64v;

static void APIENTRY _fail_glFramebufferTexture(GLenum target, GLenum attachment, GLuint texture, GLint level) {
    const char *_name = "glFramebufferTexture";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glFramebufferTexture(GLenum target, GLenum attachment, GLuint texture, GLint level) {
    PFN_GLFRAMEBUFFERTEXTURE _ptr;
    _ptr = (PFN_GLFRAMEBUFFERTEXTURE)_getPrivateProcAddress("glFramebufferTexture");
    if (!_ptr) {
        _ptr = &_fail_glFramebufferTexture;
    }
    _glFramebufferTexture = _ptr;
    _glFramebufferTexture(target, attachment, texture, level);
}

PFN_GLFRAMEBUFFERTEXTURE _glFramebufferTexture = &_get_glFramebufferTexture;

static void APIENTRY _fail_glVertexAttribDivisor(GLuint index, GLuint divisor) {
    const char *_name = "glVertexAttribDivisor";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glVertexAttribDivisor(GLuint index, GLuint divisor) {
    PFN_GLVERTEXATTRIBDIVISOR _ptr;
    _ptr = (PFN_GLVERTEXATTRIBDIVISOR)_getPrivateProcAddress("glVertexAttribDivisor");
    if (!_ptr) {
        _ptr = &_fail_glVertexAttribDivisor;
    }
    _glVertexAttribDivisor = _ptr;
    _glVertexAttribDivisor(index, divisor);
}

PFN_GLVERTEXATTRIBDIVISOR _glVertexAttribDivisor = &_get_glVertexAttribDivisor;

static void APIENTRY _fail_glMinSampleShading(GLfloat value) {
    const char *_name = "glMinSampleShading";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glMinSampleShading(GLfloat value) {
    PFN_GLMINSAMPLESHADING _ptr;
    _ptr = (PFN_GLMINSAMPLESHADING)_getPrivateProcAddress("glMinSampleShading");
    if (!_ptr) {
        _ptr = &_fail_glMinSampleShading;
    }
    _glMinSampleShading = _ptr;
    _glMinSampleShading(value);
}

PFN_GLMINSAMPLESHADING _glMinSampleShading = &_get_glMinSampleShading;

static void APIENTRY _fail_glBlendEquationi(GLuint buf, GLenum mode) {
    const char *_name = "glBlendEquationi";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glBlendEquationi(GLuint buf, GLenum mode) {
    PFN_GLBLENDEQUATIONI _ptr;
    _ptr = (PFN_GLBLENDEQUATIONI)_getPrivateProcAddress("glBlendEquationi");
    if (!_ptr) {
        _ptr = &_fail_glBlendEquationi;
    }
    _glBlendEquationi = _ptr;
    _glBlendEquationi(buf, mode);
}

PFN_GLBLENDEQUATIONI _glBlendEquationi = &_get_glBlendEquationi;

static void APIENTRY _fail_glBlendEquationSeparatei(GLuint buf, GLenum modeRGB, GLenum modeAlpha) {
    const char *_name = "glBlendEquationSeparatei";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glBlendEquationSeparatei(GLuint buf, GLenum modeRGB, GLenum modeAlpha) {
    PFN_GLBLENDEQUATIONSEPARATEI _ptr;
    _ptr = (PFN_GLBLENDEQUATIONSEPARATEI)_getPrivateProcAddress("glBlendEquationSeparatei");
    if (!_ptr) {
        _ptr = &_fail_glBlendEquationSeparatei;
    }
    _glBlendEquationSeparatei = _ptr;
    _glBlendEquationSeparatei(buf, modeRGB, modeAlpha);
}

PFN_GLBLENDEQUATIONSEPARATEI _glBlendEquationSeparatei = &_get_glBlendEquationSeparatei;

static void APIENTRY _fail_glBlendFunci(GLuint buf, GLenum src, GLenum dst) {
    const char *_name = "glBlendFunci";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glBlendFunci(GLuint buf, GLenum src, GLenum dst) {
    PFN_GLBLENDFUNCI _ptr;
    _ptr = (PFN_GLBLENDFUNCI)_getPrivateProcAddress("glBlendFunci");
    if (!_ptr) {
        _ptr = &_fail_glBlendFunci;
    }
    _glBlendFunci = _ptr;
    _glBlendFunci(buf, src, dst);
}

PFN_GLBLENDFUNCI _glBlendFunci = &_get_glBlendFunci;

static void APIENTRY _fail_glBlendFuncSeparatei(GLuint buf, GLenum srcRGB, GLenum dstRGB, GLenum srcAlpha, GLenum dstAlpha) {
    const char *_name = "glBlendFuncSeparatei";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glBlendFuncSeparatei(GLuint buf, GLenum srcRGB, GLenum dstRGB, GLenum srcAlpha, GLenum dstAlpha) {
    PFN_GLBLENDFUNCSEPARATEI _ptr;
    _ptr = (PFN_GLBLENDFUNCSEPARATEI)_getPrivateProcAddress("glBlendFuncSeparatei");
    if (!_ptr) {
        _ptr = &_fail_glBlendFuncSeparatei;
    }
    _glBlendFuncSeparatei = _ptr;
    _glBlendFuncSeparatei(buf, srcRGB, dstRGB, srcAlpha, dstAlpha);
}

PFN_GLBLENDFUNCSEPARATEI _glBlendFuncSeparatei = &_get_glBlendFuncSeparatei;

static void APIENTRY _fail_glGetnCompressedTexImage(GLenum target, GLint lod, GLsizei bufSize, void * pixels) {
    const char *_name = "glGetnCompressedTexImage";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetnCompressedTexImage(GLenum target, GLint lod, GLsizei bufSize, void * pixels) {
    PFN_GLGETNCOMPRESSEDTEXIMAGE _ptr;
    _ptr = (PFN_GLGETNCOMPRESSEDTEXIMAGE)_getPrivateProcAddress("glGetnCompressedTexImage");
    if (!_ptr) {
        _ptr = &_fail_glGetnCompressedTexImage;
    }
    _glGetnCompressedTexImage = _ptr;
    _glGetnCompressedTexImage(target, lod, bufSize, pixels);
}

PFN_GLGETNCOMPRESSEDTEXIMAGE _glGetnCompressedTexImage = &_get_glGetnCompressedTexImage;

static void APIENTRY _fail_glGetnTexImage(GLenum target, GLint level, GLenum format, GLenum type, GLsizei bufSize, void * pixels) {
    const char *_name = "glGetnTexImage";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetnTexImage(GLenum target, GLint level, GLenum format, GLenum type, GLsizei bufSize, void * pixels) {
    PFN_GLGETNTEXIMAGE _ptr;
    _ptr = (PFN_GLGETNTEXIMAGE)_getPrivateProcAddress("glGetnTexImage");
    if (!_ptr) {
        _ptr = &_fail_glGetnTexImage;
    }
    _glGetnTexImage = _ptr;
    _glGetnTexImage(target, level, format, type, bufSize, pixels);
}

PFN_GLGETNTEXIMAGE _glGetnTexImage = &_get_glGetnTexImage;

static void APIENTRY _fail_glGetnUniformdv(GLuint program, GLint location, GLsizei bufSize, GLdouble * params) {
    const char *_name = "glGetnUniformdv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetnUniformdv(GLuint program, GLint location, GLsizei bufSize, GLdouble * params) {
    PFN_GLGETNUNIFORMDV _ptr;
    _ptr = (PFN_GLGETNUNIFORMDV)_getPrivateProcAddress("glGetnUniformdv");
    if (!_ptr) {
        _ptr = &_fail_glGetnUniformdv;
    }
    _glGetnUniformdv = _ptr;
    _glGetnUniformdv(program, location, bufSize, params);
}

PFN_GLGETNUNIFORMDV _glGetnUniformdv = &_get_glGetnUniformdv;

static void APIENTRY _fail_glGetnMapdv(GLenum target, GLenum query, GLsizei bufSize, GLdouble * v) {
    const char *_name = "glGetnMapdv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetnMapdv(GLenum target, GLenum query, GLsizei bufSize, GLdouble * v) {
    PFN_GLGETNMAPDV _ptr;
    _ptr = (PFN_GLGETNMAPDV)_getPrivateProcAddress("glGetnMapdv");
    if (!_ptr) {
        _ptr = &_fail_glGetnMapdv;
    }
    _glGetnMapdv = _ptr;
    _glGetnMapdv(target, query, bufSize, v);
}

PFN_GLGETNMAPDV _glGetnMapdv = &_get_glGetnMapdv;

static void APIENTRY _fail_glGetnMapfv(GLenum target, GLenum query, GLsizei bufSize, GLfloat * v) {
    const char *_name = "glGetnMapfv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetnMapfv(GLenum target, GLenum query, GLsizei bufSize, GLfloat * v) {
    PFN_GLGETNMAPFV _ptr;
    _ptr = (PFN_GLGETNMAPFV)_getPrivateProcAddress("glGetnMapfv");
    if (!_ptr) {
        _ptr = &_fail_glGetnMapfv;
    }
    _glGetnMapfv = _ptr;
    _glGetnMapfv(target, query, bufSize, v);
}

PFN_GLGETNMAPFV _glGetnMapfv = &_get_glGetnMapfv;

static void APIENTRY _fail_glGetnMapiv(GLenum target, GLenum query, GLsizei bufSize, GLint * v) {
    const char *_name = "glGetnMapiv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetnMapiv(GLenum target, GLenum query, GLsizei bufSize, GLint * v) {
    PFN_GLGETNMAPIV _ptr;
    _ptr = (PFN_GLGETNMAPIV)_getPrivateProcAddress("glGetnMapiv");
    if (!_ptr) {
        _ptr = &_fail_glGetnMapiv;
    }
    _glGetnMapiv = _ptr;
    _glGetnMapiv(target, query, bufSize, v);
}

PFN_GLGETNMAPIV _glGetnMapiv = &_get_glGetnMapiv;

static void APIENTRY _fail_glGetnPixelMapfv(GLenum map, GLsizei bufSize, GLfloat * values) {
    const char *_name = "glGetnPixelMapfv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetnPixelMapfv(GLenum map, GLsizei bufSize, GLfloat * values) {
    PFN_GLGETNPIXELMAPFV _ptr;
    _ptr = (PFN_GLGETNPIXELMAPFV)_getPrivateProcAddress("glGetnPixelMapfv");
    if (!_ptr) {
        _ptr = &_fail_glGetnPixelMapfv;
    }
    _glGetnPixelMapfv = _ptr;
    _glGetnPixelMapfv(map, bufSize, values);
}

PFN_GLGETNPIXELMAPFV _glGetnPixelMapfv = &_get_glGetnPixelMapfv;

static void APIENTRY _fail_glGetnPixelMapuiv(GLenum map, GLsizei bufSize, GLuint * values) {
    const char *_name = "glGetnPixelMapuiv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetnPixelMapuiv(GLenum map, GLsizei bufSize, GLuint * values) {
    PFN_GLGETNPIXELMAPUIV _ptr;
    _ptr = (PFN_GLGETNPIXELMAPUIV)_getPrivateProcAddress("glGetnPixelMapuiv");
    if (!_ptr) {
        _ptr = &_fail_glGetnPixelMapuiv;
    }
    _glGetnPixelMapuiv = _ptr;
    _glGetnPixelMapuiv(map, bufSize, values);
}

PFN_GLGETNPIXELMAPUIV _glGetnPixelMapuiv = &_get_glGetnPixelMapuiv;

static void APIENTRY _fail_glGetnPixelMapusv(GLenum map, GLsizei bufSize, GLushort * values) {
    const char *_name = "glGetnPixelMapusv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetnPixelMapusv(GLenum map, GLsizei bufSize, GLushort * values) {
    PFN_GLGETNPIXELMAPUSV _ptr;
    _ptr = (PFN_GLGETNPIXELMAPUSV)_getPrivateProcAddress("glGetnPixelMapusv");
    if (!_ptr) {
        _ptr = &_fail_glGetnPixelMapusv;
    }
    _glGetnPixelMapusv = _ptr;
    _glGetnPixelMapusv(map, bufSize, values);
}

PFN_GLGETNPIXELMAPUSV _glGetnPixelMapusv = &_get_glGetnPixelMapusv;

static void APIENTRY _fail_glGetnPolygonStipple(GLsizei bufSize, GLubyte * pattern) {
    const char *_name = "glGetnPolygonStipple";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetnPolygonStipple(GLsizei bufSize, GLubyte * pattern) {
    PFN_GLGETNPOLYGONSTIPPLE _ptr;
    _ptr = (PFN_GLGETNPOLYGONSTIPPLE)_getPrivateProcAddress("glGetnPolygonStipple");
    if (!_ptr) {
        _ptr = &_fail_glGetnPolygonStipple;
    }
    _glGetnPolygonStipple = _ptr;
    _glGetnPolygonStipple(bufSize, pattern);
}

PFN_GLGETNPOLYGONSTIPPLE _glGetnPolygonStipple = &_get_glGetnPolygonStipple;

static void APIENTRY _fail_glGetnColorTable(GLenum target, GLenum format, GLenum type, GLsizei bufSize, void * table) {
    const char *_name = "glGetnColorTable";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetnColorTable(GLenum target, GLenum format, GLenum type, GLsizei bufSize, void * table) {
    PFN_GLGETNCOLORTABLE _ptr;
    _ptr = (PFN_GLGETNCOLORTABLE)_getPrivateProcAddress("glGetnColorTable");
    if (!_ptr) {
        _ptr = &_fail_glGetnColorTable;
    }
    _glGetnColorTable = _ptr;
    _glGetnColorTable(target, format, type, bufSize, table);
}

PFN_GLGETNCOLORTABLE _glGetnColorTable = &_get_glGetnColorTable;

static void APIENTRY _fail_glGetnConvolutionFilter(GLenum target, GLenum format, GLenum type, GLsizei bufSize, void * image) {
    const char *_name = "glGetnConvolutionFilter";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetnConvolutionFilter(GLenum target, GLenum format, GLenum type, GLsizei bufSize, void * image) {
    PFN_GLGETNCONVOLUTIONFILTER _ptr;
    _ptr = (PFN_GLGETNCONVOLUTIONFILTER)_getPrivateProcAddress("glGetnConvolutionFilter");
    if (!_ptr) {
        _ptr = &_fail_glGetnConvolutionFilter;
    }
    _glGetnConvolutionFilter = _ptr;
    _glGetnConvolutionFilter(target, format, type, bufSize, image);
}

PFN_GLGETNCONVOLUTIONFILTER _glGetnConvolutionFilter = &_get_glGetnConvolutionFilter;

static void APIENTRY _fail_glGetnSeparableFilter(GLenum target, GLenum format, GLenum type, GLsizei rowBufSize, void * row, GLsizei columnBufSize, void * column, GLvoid * span) {
    const char *_name = "glGetnSeparableFilter";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetnSeparableFilter(GLenum target, GLenum format, GLenum type, GLsizei rowBufSize, void * row, GLsizei columnBufSize, void * column, GLvoid * span) {
    PFN_GLGETNSEPARABLEFILTER _ptr;
    _ptr = (PFN_GLGETNSEPARABLEFILTER)_getPrivateProcAddress("glGetnSeparableFilter");
    if (!_ptr) {
        _ptr = &_fail_glGetnSeparableFilter;
    }
    _glGetnSeparableFilter = _ptr;
    _glGetnSeparableFilter(target, format, type, rowBufSize, row, columnBufSize, column, span);
}

PFN_GLGETNSEPARABLEFILTER _glGetnSeparableFilter = &_get_glGetnSeparableFilter;

static void APIENTRY _fail_glGetnHistogram(GLenum target, GLboolean reset, GLenum format, GLenum type, GLsizei bufSize, void * values) {
    const char *_name = "glGetnHistogram";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetnHistogram(GLenum target, GLboolean reset, GLenum format, GLenum type, GLsizei bufSize, void * values) {
    PFN_GLGETNHISTOGRAM _ptr;
    _ptr = (PFN_GLGETNHISTOGRAM)_getPrivateProcAddress("glGetnHistogram");
    if (!_ptr) {
        _ptr = &_fail_glGetnHistogram;
    }
    _glGetnHistogram = _ptr;
    _glGetnHistogram(target, reset, format, type, bufSize, values);
}

PFN_GLGETNHISTOGRAM _glGetnHistogram = &_get_glGetnHistogram;

static void APIENTRY _fail_glGetnMinmax(GLenum target, GLboolean reset, GLenum format, GLenum type, GLsizei bufSize, void * values) {
    const char *_name = "glGetnMinmax";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetnMinmax(GLenum target, GLboolean reset, GLenum format, GLenum type, GLsizei bufSize, void * values) {
    PFN_GLGETNMINMAX _ptr;
    _ptr = (PFN_GLGETNMINMAX)_getPrivateProcAddress("glGetnMinmax");
    if (!_ptr) {
        _ptr = &_fail_glGetnMinmax;
    }
    _glGetnMinmax = _ptr;
    _glGetnMinmax(target, reset, format, type, bufSize, values);
}

PFN_GLGETNMINMAX _glGetnMinmax = &_get_glGetnMinmax;

static void APIENTRY _fail_glSpecializeShader(GLuint shader, const GLchar * pEntryPoint, GLuint numSpecializationConstants, const GLuint * pConstantIndex, const GLuint * pConstantValue) {
    const char *_name = "glSpecializeShader";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glSpecializeShader(GLuint shader, const GLchar * pEntryPoint, GLuint numSpecializationConstants, const GLuint * pConstantIndex, const GLuint * pConstantValue) {
    PFN_GLSPECIALIZESHADER _ptr;
    _ptr = (PFN_GLSPECIALIZESHADER)_getPrivateProcAddress("glSpecializeShader");
    if (!_ptr) {
        _ptr = &_fail_glSpecializeShader;
    }
    _glSpecializeShader = _ptr;
    _glSpecializeShader(shader, pEntryPoint, numSpecializationConstants, pConstantIndex, pConstantValue);
}

PFN_GLSPECIALIZESHADER _glSpecializeShader = &_get_glSpecializeShader;

static void APIENTRY _fail_glMultiDrawArraysIndirectCount(GLenum mode, const GLvoid * indirect, GLintptr drawcount, GLsizei maxdrawcount, GLsizei stride) {
    const char *_name = "glMultiDrawArraysIndirectCount";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glMultiDrawArraysIndirectCount(GLenum mode, const GLvoid * indirect, GLintptr drawcount, GLsizei maxdrawcount, GLsizei stride) {
    PFN_GLMULTIDRAWARRAYSINDIRECTCOUNT _ptr;
    _ptr = (PFN_GLMULTIDRAWARRAYSINDIRECTCOUNT)_getPrivateProcAddress("glMultiDrawArraysIndirectCount");
    if (!_ptr) {
        _ptr = &_fail_glMultiDrawArraysIndirectCount;
    }
    _glMultiDrawArraysIndirectCount = _ptr;
    _glMultiDrawArraysIndirectCount(mode, indirect, drawcount, maxdrawcount, stride);
}

PFN_GLMULTIDRAWARRAYSINDIRECTCOUNT _glMultiDrawArraysIndirectCount = &_get_glMultiDrawArraysIndirectCount;

static void APIENTRY _fail_glMultiDrawElementsIndirectCount(GLenum mode, GLenum type, const GLvoid * indirect, GLintptr drawcount, GLsizei maxdrawcount, GLsizei stride) {
    const char *_name = "glMultiDrawElementsIndirectCount";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glMultiDrawElementsIndirectCount(GLenum mode, GLenum type, const GLvoid * indirect, GLintptr drawcount, GLsizei maxdrawcount, GLsizei stride) {
    PFN_GLMULTIDRAWELEMENTSINDIRECTCOUNT _ptr;
    _ptr = (PFN_GLMULTIDRAWELEMENTSINDIRECTCOUNT)_getPrivateProcAddress("glMultiDrawElementsIndirectCount");
    if (!_ptr) {
        _ptr = &_fail_glMultiDrawElementsIndirectCount;
    }
    _glMultiDrawElementsIndirectCount = _ptr;
    _glMultiDrawElementsIndirectCount(mode, type, indirect, drawcount, maxdrawcount, stride);
}

PFN_GLMULTIDRAWELEMENTSINDIRECTCOUNT _glMultiDrawElementsIndirectCount = &_get_glMultiDrawElementsIndirectCount;

static void APIENTRY _fail_glClipPlanef(GLenum plane, const GLfloat * equation) {
    const char *_name = "glClipPlanef";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glClipPlanef(GLenum plane, const GLfloat * equation) {
    PFN_GLCLIPPLANEF _ptr;
    _ptr = (PFN_GLCLIPPLANEF)_getPrivateProcAddress("glClipPlanef");
    if (!_ptr) {
        _ptr = &_fail_glClipPlanef;
    }
    _glClipPlanef = _ptr;
    _glClipPlanef(plane, equation);
}

PFN_GLCLIPPLANEF _glClipPlanef = &_get_glClipPlanef;

static void APIENTRY _fail_glFrustumf(GLfloat left, GLfloat right, GLfloat bottom, GLfloat top, GLfloat zNear, GLfloat zFar) {
    const char *_name = "glFrustumf";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glFrustumf(GLfloat left, GLfloat right, GLfloat bottom, GLfloat top, GLfloat zNear, GLfloat zFar) {
    PFN_GLFRUSTUMF _ptr;
    _ptr = (PFN_GLFRUSTUMF)_getPrivateProcAddress("glFrustumf");
    if (!_ptr) {
        _ptr = &_fail_glFrustumf;
    }
    _glFrustumf = _ptr;
    _glFrustumf(left, right, bottom, top, zNear, zFar);
}

PFN_GLFRUSTUMF _glFrustumf = &_get_glFrustumf;

static void APIENTRY _fail_glGetClipPlanef(GLenum plane, GLfloat * equation) {
    const char *_name = "glGetClipPlanef";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetClipPlanef(GLenum plane, GLfloat * equation) {
    PFN_GLGETCLIPPLANEF _ptr;
    _ptr = (PFN_GLGETCLIPPLANEF)_getPrivateProcAddress("glGetClipPlanef");
    if (!_ptr) {
        _ptr = &_fail_glGetClipPlanef;
    }
    _glGetClipPlanef = _ptr;
    _glGetClipPlanef(plane, equation);
}

PFN_GLGETCLIPPLANEF _glGetClipPlanef = &_get_glGetClipPlanef;

static void APIENTRY _fail_glOrthof(GLfloat left, GLfloat right, GLfloat bottom, GLfloat top, GLfloat zNear, GLfloat zFar) {
    const char *_name = "glOrthof";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glOrthof(GLfloat left, GLfloat right, GLfloat bottom, GLfloat top, GLfloat zNear, GLfloat zFar) {
    PFN_GLORTHOF _ptr;
    _ptr = (PFN_GLORTHOF)_getPrivateProcAddress("glOrthof");
    if (!_ptr) {
        _ptr = &_fail_glOrthof;
    }
    _glOrthof = _ptr;
    _glOrthof(left, right, bottom, top, zNear, zFar);
}

PFN_GLORTHOF _glOrthof = &_get_glOrthof;

static void APIENTRY _fail_glAlphaFuncx(GLenum func, GLclampx ref) {
    const char *_name = "glAlphaFuncx";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glAlphaFuncx(GLenum func, GLclampx ref) {
    PFN_GLALPHAFUNCX _ptr;
    _ptr = (PFN_GLALPHAFUNCX)_getPrivateProcAddress("glAlphaFuncx");
    if (!_ptr) {
        _ptr = &_fail_glAlphaFuncx;
    }
    _glAlphaFuncx = _ptr;
    _glAlphaFuncx(func, ref);
}

PFN_GLALPHAFUNCX _glAlphaFuncx = &_get_glAlphaFuncx;

static void APIENTRY _fail_glClearColorx(GLclampx red, GLclampx green, GLclampx blue, GLclampx alpha) {
    const char *_name = "glClearColorx";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glClearColorx(GLclampx red, GLclampx green, GLclampx blue, GLclampx alpha) {
    PFN_GLCLEARCOLORX _ptr;
    _ptr = (PFN_GLCLEARCOLORX)_getPrivateProcAddress("glClearColorx");
    if (!_ptr) {
        _ptr = &_fail_glClearColorx;
    }
    _glClearColorx = _ptr;
    _glClearColorx(red, green, blue, alpha);
}

PFN_GLCLEARCOLORX _glClearColorx = &_get_glClearColorx;

static void APIENTRY _fail_glClearDepthx(GLclampx depth) {
    const char *_name = "glClearDepthx";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glClearDepthx(GLclampx depth) {
    PFN_GLCLEARDEPTHX _ptr;
    _ptr = (PFN_GLCLEARDEPTHX)_getPrivateProcAddress("glClearDepthx");
    if (!_ptr) {
        _ptr = &_fail_glClearDepthx;
    }
    _glClearDepthx = _ptr;
    _glClearDepthx(depth);
}

PFN_GLCLEARDEPTHX _glClearDepthx = &_get_glClearDepthx;

static void APIENTRY _fail_glClipPlanex(GLenum plane, const GLfixed * equation) {
    const char *_name = "glClipPlanex";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glClipPlanex(GLenum plane, const GLfixed * equation) {
    PFN_GLCLIPPLANEX _ptr;
    _ptr = (PFN_GLCLIPPLANEX)_getPrivateProcAddress("glClipPlanex");
    if (!_ptr) {
        _ptr = &_fail_glClipPlanex;
    }
    _glClipPlanex = _ptr;
    _glClipPlanex(plane, equation);
}

PFN_GLCLIPPLANEX _glClipPlanex = &_get_glClipPlanex;

static void APIENTRY _fail_glColor4x(GLfixed red, GLfixed green, GLfixed blue, GLfixed alpha) {
    const char *_name = "glColor4x";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glColor4x(GLfixed red, GLfixed green, GLfixed blue, GLfixed alpha) {
    PFN_GLCOLOR4X _ptr;
    _ptr = (PFN_GLCOLOR4X)_getPrivateProcAddress("glColor4x");
    if (!_ptr) {
        _ptr = &_fail_glColor4x;
    }
    _glColor4x = _ptr;
    _glColor4x(red, green, blue, alpha);
}

PFN_GLCOLOR4X _glColor4x = &_get_glColor4x;

static void APIENTRY _fail_glDepthRangex(GLclampx zNear, GLclampx zFar) {
    const char *_name = "glDepthRangex";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glDepthRangex(GLclampx zNear, GLclampx zFar) {
    PFN_GLDEPTHRANGEX _ptr;
    _ptr = (PFN_GLDEPTHRANGEX)_getPrivateProcAddress("glDepthRangex");
    if (!_ptr) {
        _ptr = &_fail_glDepthRangex;
    }
    _glDepthRangex = _ptr;
    _glDepthRangex(zNear, zFar);
}

PFN_GLDEPTHRANGEX _glDepthRangex = &_get_glDepthRangex;

static void APIENTRY _fail_glFogx(GLenum pname, GLfixed param) {
    const char *_name = "glFogx";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glFogx(GLenum pname, GLfixed param) {
    PFN_GLFOGX _ptr;
    _ptr = (PFN_GLFOGX)_getPrivateProcAddress("glFogx");
    if (!_ptr) {
        _ptr = &_fail_glFogx;
    }
    _glFogx = _ptr;
    _glFogx(pname, param);
}

PFN_GLFOGX _glFogx = &_get_glFogx;

static void APIENTRY _fail_glFogxv(GLenum pname, const GLfixed * params) {
    const char *_name = "glFogxv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glFogxv(GLenum pname, const GLfixed * params) {
    PFN_GLFOGXV _ptr;
    _ptr = (PFN_GLFOGXV)_getPrivateProcAddress("glFogxv");
    if (!_ptr) {
        _ptr = &_fail_glFogxv;
    }
    _glFogxv = _ptr;
    _glFogxv(pname, params);
}

PFN_GLFOGXV _glFogxv = &_get_glFogxv;

static void APIENTRY _fail_glFrustumx(GLfixed left, GLfixed right, GLfixed bottom, GLfixed top, GLfixed zNear, GLfixed zFar) {
    const char *_name = "glFrustumx";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glFrustumx(GLfixed left, GLfixed right, GLfixed bottom, GLfixed top, GLfixed zNear, GLfixed zFar) {
    PFN_GLFRUSTUMX _ptr;
    _ptr = (PFN_GLFRUSTUMX)_getPrivateProcAddress("glFrustumx");
    if (!_ptr) {
        _ptr = &_fail_glFrustumx;
    }
    _glFrustumx = _ptr;
    _glFrustumx(left, right, bottom, top, zNear, zFar);
}

PFN_GLFRUSTUMX _glFrustumx = &_get_glFrustumx;

static void APIENTRY _fail_glGetClipPlanex(GLenum plane, GLfixed * equation) {
    const char *_name = "glGetClipPlanex";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetClipPlanex(GLenum plane, GLfixed * equation) {
    PFN_GLGETCLIPPLANEX _ptr;
    _ptr = (PFN_GLGETCLIPPLANEX)_getPrivateProcAddress("glGetClipPlanex");
    if (!_ptr) {
        _ptr = &_fail_glGetClipPlanex;
    }
    _glGetClipPlanex = _ptr;
    _glGetClipPlanex(plane, equation);
}

PFN_GLGETCLIPPLANEX _glGetClipPlanex = &_get_glGetClipPlanex;

static void APIENTRY _fail_glGetFixedv(GLenum pname, GLfixed * params) {
    const char *_name = "glGetFixedv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetFixedv(GLenum pname, GLfixed * params) {
    PFN_GLGETFIXEDV _ptr;
    _ptr = (PFN_GLGETFIXEDV)_getPrivateProcAddress("glGetFixedv");
    if (!_ptr) {
        _ptr = &_fail_glGetFixedv;
    }
    _glGetFixedv = _ptr;
    _glGetFixedv(pname, params);
}

PFN_GLGETFIXEDV _glGetFixedv = &_get_glGetFixedv;

static void APIENTRY _fail_glGetLightxv(GLenum light, GLenum pname, GLfixed * params) {
    const char *_name = "glGetLightxv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetLightxv(GLenum light, GLenum pname, GLfixed * params) {
    PFN_GLGETLIGHTXV _ptr;
    _ptr = (PFN_GLGETLIGHTXV)_getPrivateProcAddress("glGetLightxv");
    if (!_ptr) {
        _ptr = &_fail_glGetLightxv;
    }
    _glGetLightxv = _ptr;
    _glGetLightxv(light, pname, params);
}

PFN_GLGETLIGHTXV _glGetLightxv = &_get_glGetLightxv;

static void APIENTRY _fail_glGetMaterialxv(GLenum face, GLenum pname, GLfixed * params) {
    const char *_name = "glGetMaterialxv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetMaterialxv(GLenum face, GLenum pname, GLfixed * params) {
    PFN_GLGETMATERIALXV _ptr;
    _ptr = (PFN_GLGETMATERIALXV)_getPrivateProcAddress("glGetMaterialxv");
    if (!_ptr) {
        _ptr = &_fail_glGetMaterialxv;
    }
    _glGetMaterialxv = _ptr;
    _glGetMaterialxv(face, pname, params);
}

PFN_GLGETMATERIALXV _glGetMaterialxv = &_get_glGetMaterialxv;

static void APIENTRY _fail_glGetTexEnvxv(GLenum target, GLenum pname, GLfixed * params) {
    const char *_name = "glGetTexEnvxv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetTexEnvxv(GLenum target, GLenum pname, GLfixed * params) {
    PFN_GLGETTEXENVXV _ptr;
    _ptr = (PFN_GLGETTEXENVXV)_getPrivateProcAddress("glGetTexEnvxv");
    if (!_ptr) {
        _ptr = &_fail_glGetTexEnvxv;
    }
    _glGetTexEnvxv = _ptr;
    _glGetTexEnvxv(target, pname, params);
}

PFN_GLGETTEXENVXV _glGetTexEnvxv = &_get_glGetTexEnvxv;

static void APIENTRY _fail_glGetTexParameterxv(GLenum target, GLenum pname, GLfixed * params) {
    const char *_name = "glGetTexParameterxv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetTexParameterxv(GLenum target, GLenum pname, GLfixed * params) {
    PFN_GLGETTEXPARAMETERXV _ptr;
    _ptr = (PFN_GLGETTEXPARAMETERXV)_getPrivateProcAddress("glGetTexParameterxv");
    if (!_ptr) {
        _ptr = &_fail_glGetTexParameterxv;
    }
    _glGetTexParameterxv = _ptr;
    _glGetTexParameterxv(target, pname, params);
}

PFN_GLGETTEXPARAMETERXV _glGetTexParameterxv = &_get_glGetTexParameterxv;

static void APIENTRY _fail_glLightModelx(GLenum pname, GLfixed param) {
    const char *_name = "glLightModelx";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glLightModelx(GLenum pname, GLfixed param) {
    PFN_GLLIGHTMODELX _ptr;
    _ptr = (PFN_GLLIGHTMODELX)_getPrivateProcAddress("glLightModelx");
    if (!_ptr) {
        _ptr = &_fail_glLightModelx;
    }
    _glLightModelx = _ptr;
    _glLightModelx(pname, param);
}

PFN_GLLIGHTMODELX _glLightModelx = &_get_glLightModelx;

static void APIENTRY _fail_glLightModelxv(GLenum pname, const GLfixed * params) {
    const char *_name = "glLightModelxv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glLightModelxv(GLenum pname, const GLfixed * params) {
    PFN_GLLIGHTMODELXV _ptr;
    _ptr = (PFN_GLLIGHTMODELXV)_getPrivateProcAddress("glLightModelxv");
    if (!_ptr) {
        _ptr = &_fail_glLightModelxv;
    }
    _glLightModelxv = _ptr;
    _glLightModelxv(pname, params);
}

PFN_GLLIGHTMODELXV _glLightModelxv = &_get_glLightModelxv;

static void APIENTRY _fail_glLightx(GLenum light, GLenum pname, GLfixed param) {
    const char *_name = "glLightx";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glLightx(GLenum light, GLenum pname, GLfixed param) {
    PFN_GLLIGHTX _ptr;
    _ptr = (PFN_GLLIGHTX)_getPrivateProcAddress("glLightx");
    if (!_ptr) {
        _ptr = &_fail_glLightx;
    }
    _glLightx = _ptr;
    _glLightx(light, pname, param);
}

PFN_GLLIGHTX _glLightx = &_get_glLightx;

static void APIENTRY _fail_glLightxv(GLenum light, GLenum pname, const GLfixed * params) {
    const char *_name = "glLightxv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glLightxv(GLenum light, GLenum pname, const GLfixed * params) {
    PFN_GLLIGHTXV _ptr;
    _ptr = (PFN_GLLIGHTXV)_getPrivateProcAddress("glLightxv");
    if (!_ptr) {
        _ptr = &_fail_glLightxv;
    }
    _glLightxv = _ptr;
    _glLightxv(light, pname, params);
}

PFN_GLLIGHTXV _glLightxv = &_get_glLightxv;

static void APIENTRY _fail_glLineWidthx(GLfixed width) {
    const char *_name = "glLineWidthx";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glLineWidthx(GLfixed width) {
    PFN_GLLINEWIDTHX _ptr;
    _ptr = (PFN_GLLINEWIDTHX)_getPrivateProcAddress("glLineWidthx");
    if (!_ptr) {
        _ptr = &_fail_glLineWidthx;
    }
    _glLineWidthx = _ptr;
    _glLineWidthx(width);
}

PFN_GLLINEWIDTHX _glLineWidthx = &_get_glLineWidthx;

static void APIENTRY _fail_glLoadMatrixx(const GLfixed * m) {
    const char *_name = "glLoadMatrixx";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glLoadMatrixx(const GLfixed * m) {
    PFN_GLLOADMATRIXX _ptr;
    _ptr = (PFN_GLLOADMATRIXX)_getPrivateProcAddress("glLoadMatrixx");
    if (!_ptr) {
        _ptr = &_fail_glLoadMatrixx;
    }
    _glLoadMatrixx = _ptr;
    _glLoadMatrixx(m);
}

PFN_GLLOADMATRIXX _glLoadMatrixx = &_get_glLoadMatrixx;

static void APIENTRY _fail_glMaterialx(GLenum face, GLenum pname, GLfixed param) {
    const char *_name = "glMaterialx";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glMaterialx(GLenum face, GLenum pname, GLfixed param) {
    PFN_GLMATERIALX _ptr;
    _ptr = (PFN_GLMATERIALX)_getPrivateProcAddress("glMaterialx");
    if (!_ptr) {
        _ptr = &_fail_glMaterialx;
    }
    _glMaterialx = _ptr;
    _glMaterialx(face, pname, param);
}

PFN_GLMATERIALX _glMaterialx = &_get_glMaterialx;

static void APIENTRY _fail_glMaterialxv(GLenum face, GLenum pname, const GLfixed * params) {
    const char *_name = "glMaterialxv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glMaterialxv(GLenum face, GLenum pname, const GLfixed * params) {
    PFN_GLMATERIALXV _ptr;
    _ptr = (PFN_GLMATERIALXV)_getPrivateProcAddress("glMaterialxv");
    if (!_ptr) {
        _ptr = &_fail_glMaterialxv;
    }
    _glMaterialxv = _ptr;
    _glMaterialxv(face, pname, params);
}

PFN_GLMATERIALXV _glMaterialxv = &_get_glMaterialxv;

static void APIENTRY _fail_glMultMatrixx(const GLfixed * m) {
    const char *_name = "glMultMatrixx";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glMultMatrixx(const GLfixed * m) {
    PFN_GLMULTMATRIXX _ptr;
    _ptr = (PFN_GLMULTMATRIXX)_getPrivateProcAddress("glMultMatrixx");
    if (!_ptr) {
        _ptr = &_fail_glMultMatrixx;
    }
    _glMultMatrixx = _ptr;
    _glMultMatrixx(m);
}

PFN_GLMULTMATRIXX _glMultMatrixx = &_get_glMultMatrixx;

static void APIENTRY _fail_glMultiTexCoord4x(GLenum target, GLfixed s, GLfixed t, GLfixed r, GLfixed q) {
    const char *_name = "glMultiTexCoord4x";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glMultiTexCoord4x(GLenum target, GLfixed s, GLfixed t, GLfixed r, GLfixed q) {
    PFN_GLMULTITEXCOORD4X _ptr;
    _ptr = (PFN_GLMULTITEXCOORD4X)_getPrivateProcAddress("glMultiTexCoord4x");
    if (!_ptr) {
        _ptr = &_fail_glMultiTexCoord4x;
    }
    _glMultiTexCoord4x = _ptr;
    _glMultiTexCoord4x(target, s, t, r, q);
}

PFN_GLMULTITEXCOORD4X _glMultiTexCoord4x = &_get_glMultiTexCoord4x;

static void APIENTRY _fail_glNormal3x(GLfixed nx, GLfixed ny, GLfixed nz) {
    const char *_name = "glNormal3x";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glNormal3x(GLfixed nx, GLfixed ny, GLfixed nz) {
    PFN_GLNORMAL3X _ptr;
    _ptr = (PFN_GLNORMAL3X)_getPrivateProcAddress("glNormal3x");
    if (!_ptr) {
        _ptr = &_fail_glNormal3x;
    }
    _glNormal3x = _ptr;
    _glNormal3x(nx, ny, nz);
}

PFN_GLNORMAL3X _glNormal3x = &_get_glNormal3x;

static void APIENTRY _fail_glOrthox(GLfixed left, GLfixed right, GLfixed bottom, GLfixed top, GLfixed zNear, GLfixed zFar) {
    const char *_name = "glOrthox";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glOrthox(GLfixed left, GLfixed right, GLfixed bottom, GLfixed top, GLfixed zNear, GLfixed zFar) {
    PFN_GLORTHOX _ptr;
    _ptr = (PFN_GLORTHOX)_getPrivateProcAddress("glOrthox");
    if (!_ptr) {
        _ptr = &_fail_glOrthox;
    }
    _glOrthox = _ptr;
    _glOrthox(left, right, bottom, top, zNear, zFar);
}

PFN_GLORTHOX _glOrthox = &_get_glOrthox;

static void APIENTRY _fail_glPointParameterx(GLenum pname, GLfixed param) {
    const char *_name = "glPointParameterx";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glPointParameterx(GLenum pname, GLfixed param) {
    PFN_GLPOINTPARAMETERX _ptr;
    _ptr = (PFN_GLPOINTPARAMETERX)_getPrivateProcAddress("glPointParameterx");
    if (!_ptr) {
        _ptr = &_fail_glPointParameterx;
    }
    _glPointParameterx = _ptr;
    _glPointParameterx(pname, param);
}

PFN_GLPOINTPARAMETERX _glPointParameterx = &_get_glPointParameterx;

static void APIENTRY _fail_glPointParameterxv(GLenum pname, const GLfixed * params) {
    const char *_name = "glPointParameterxv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glPointParameterxv(GLenum pname, const GLfixed * params) {
    PFN_GLPOINTPARAMETERXV _ptr;
    _ptr = (PFN_GLPOINTPARAMETERXV)_getPrivateProcAddress("glPointParameterxv");
    if (!_ptr) {
        _ptr = &_fail_glPointParameterxv;
    }
    _glPointParameterxv = _ptr;
    _glPointParameterxv(pname, params);
}

PFN_GLPOINTPARAMETERXV _glPointParameterxv = &_get_glPointParameterxv;

static void APIENTRY _fail_glPointSizex(GLfixed size) {
    const char *_name = "glPointSizex";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glPointSizex(GLfixed size) {
    PFN_GLPOINTSIZEX _ptr;
    _ptr = (PFN_GLPOINTSIZEX)_getPrivateProcAddress("glPointSizex");
    if (!_ptr) {
        _ptr = &_fail_glPointSizex;
    }
    _glPointSizex = _ptr;
    _glPointSizex(size);
}

PFN_GLPOINTSIZEX _glPointSizex = &_get_glPointSizex;

static void APIENTRY _fail_glPolygonOffsetx(GLfixed factor, GLfixed units) {
    const char *_name = "glPolygonOffsetx";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glPolygonOffsetx(GLfixed factor, GLfixed units) {
    PFN_GLPOLYGONOFFSETX _ptr;
    _ptr = (PFN_GLPOLYGONOFFSETX)_getPrivateProcAddress("glPolygonOffsetx");
    if (!_ptr) {
        _ptr = &_fail_glPolygonOffsetx;
    }
    _glPolygonOffsetx = _ptr;
    _glPolygonOffsetx(factor, units);
}

PFN_GLPOLYGONOFFSETX _glPolygonOffsetx = &_get_glPolygonOffsetx;

static void APIENTRY _fail_glRotatex(GLfixed angle, GLfixed x, GLfixed y, GLfixed z) {
    const char *_name = "glRotatex";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glRotatex(GLfixed angle, GLfixed x, GLfixed y, GLfixed z) {
    PFN_GLROTATEX _ptr;
    _ptr = (PFN_GLROTATEX)_getPrivateProcAddress("glRotatex");
    if (!_ptr) {
        _ptr = &_fail_glRotatex;
    }
    _glRotatex = _ptr;
    _glRotatex(angle, x, y, z);
}

PFN_GLROTATEX _glRotatex = &_get_glRotatex;

static void APIENTRY _fail_glSampleCoveragex(GLclampx value, GLboolean invert) {
    const char *_name = "glSampleCoveragex";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glSampleCoveragex(GLclampx value, GLboolean invert) {
    PFN_GLSAMPLECOVERAGEX _ptr;
    _ptr = (PFN_GLSAMPLECOVERAGEX)_getPrivateProcAddress("glSampleCoveragex");
    if (!_ptr) {
        _ptr = &_fail_glSampleCoveragex;
    }
    _glSampleCoveragex = _ptr;
    _glSampleCoveragex(value, invert);
}

PFN_GLSAMPLECOVERAGEX _glSampleCoveragex = &_get_glSampleCoveragex;

static void APIENTRY _fail_glScalex(GLfixed x, GLfixed y, GLfixed z) {
    const char *_name = "glScalex";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glScalex(GLfixed x, GLfixed y, GLfixed z) {
    PFN_GLSCALEX _ptr;
    _ptr = (PFN_GLSCALEX)_getPrivateProcAddress("glScalex");
    if (!_ptr) {
        _ptr = &_fail_glScalex;
    }
    _glScalex = _ptr;
    _glScalex(x, y, z);
}

PFN_GLSCALEX _glScalex = &_get_glScalex;

static void APIENTRY _fail_glTexEnvx(GLenum target, GLenum pname, GLfixed param) {
    const char *_name = "glTexEnvx";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glTexEnvx(GLenum target, GLenum pname, GLfixed param) {
    PFN_GLTEXENVX _ptr;
    _ptr = (PFN_GLTEXENVX)_getPrivateProcAddress("glTexEnvx");
    if (!_ptr) {
        _ptr = &_fail_glTexEnvx;
    }
    _glTexEnvx = _ptr;
    _glTexEnvx(target, pname, param);
}

PFN_GLTEXENVX _glTexEnvx = &_get_glTexEnvx;

static void APIENTRY _fail_glTexEnvxv(GLenum target, GLenum pname, const GLfixed * params) {
    const char *_name = "glTexEnvxv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glTexEnvxv(GLenum target, GLenum pname, const GLfixed * params) {
    PFN_GLTEXENVXV _ptr;
    _ptr = (PFN_GLTEXENVXV)_getPrivateProcAddress("glTexEnvxv");
    if (!_ptr) {
        _ptr = &_fail_glTexEnvxv;
    }
    _glTexEnvxv = _ptr;
    _glTexEnvxv(target, pname, params);
}

PFN_GLTEXENVXV _glTexEnvxv = &_get_glTexEnvxv;

static void APIENTRY _fail_glTexParameterx(GLenum target, GLenum pname, GLfixed param) {
    const char *_name = "glTexParameterx";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glTexParameterx(GLenum target, GLenum pname, GLfixed param) {
    PFN_GLTEXPARAMETERX _ptr;
    _ptr = (PFN_GLTEXPARAMETERX)_getPrivateProcAddress("glTexParameterx");
    if (!_ptr) {
        _ptr = &_fail_glTexParameterx;
    }
    _glTexParameterx = _ptr;
    _glTexParameterx(target, pname, param);
}

PFN_GLTEXPARAMETERX _glTexParameterx = &_get_glTexParameterx;

static void APIENTRY _fail_glTexParameterxv(GLenum target, GLenum pname, const GLfixed * params) {
    const char *_name = "glTexParameterxv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glTexParameterxv(GLenum target, GLenum pname, const GLfixed * params) {
    PFN_GLTEXPARAMETERXV _ptr;
    _ptr = (PFN_GLTEXPARAMETERXV)_getPrivateProcAddress("glTexParameterxv");
    if (!_ptr) {
        _ptr = &_fail_glTexParameterxv;
    }
    _glTexParameterxv = _ptr;
    _glTexParameterxv(target, pname, params);
}

PFN_GLTEXPARAMETERXV _glTexParameterxv = &_get_glTexParameterxv;

static void APIENTRY _fail_glTranslatex(GLfixed x, GLfixed y, GLfixed z) {
    const char *_name = "glTranslatex";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glTranslatex(GLfixed x, GLfixed y, GLfixed z) {
    PFN_GLTRANSLATEX _ptr;
    _ptr = (PFN_GLTRANSLATEX)_getPrivateProcAddress("glTranslatex");
    if (!_ptr) {
        _ptr = &_fail_glTranslatex;
    }
    _glTranslatex = _ptr;
    _glTranslatex(x, y, z);
}

PFN_GLTRANSLATEX _glTranslatex = &_get_glTranslatex;

static void APIENTRY _fail_glBlendBarrier(void) {
    const char *_name = "glBlendBarrier";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glBlendBarrier(void) {
    PFN_GLBLENDBARRIER _ptr;
    _ptr = (PFN_GLBLENDBARRIER)_getPrivateProcAddress("glBlendBarrier");
    if (!_ptr) {
        _ptr = &_fail_glBlendBarrier;
    }
    _glBlendBarrier = _ptr;
    _glBlendBarrier();
}

PFN_GLBLENDBARRIER _glBlendBarrier = &_get_glBlendBarrier;

static void APIENTRY _fail_glPrimitiveBoundingBox(GLfloat minX, GLfloat minY, GLfloat minZ, GLfloat minW, GLfloat maxX, GLfloat maxY, GLfloat maxZ, GLfloat maxW) {
    const char *_name = "glPrimitiveBoundingBox";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glPrimitiveBoundingBox(GLfloat minX, GLfloat minY, GLfloat minZ, GLfloat minW, GLfloat maxX, GLfloat maxY, GLfloat maxZ, GLfloat maxW) {
    PFN_GLPRIMITIVEBOUNDINGBOX _ptr;
    _ptr = (PFN_GLPRIMITIVEBOUNDINGBOX)_getPrivateProcAddress("glPrimitiveBoundingBox");
    if (!_ptr) {
        _ptr = &_fail_glPrimitiveBoundingBox;
    }
    _glPrimitiveBoundingBox = _ptr;
    _glPrimitiveBoundingBox(minX, minY, minZ, minW, maxX, maxY, maxZ, maxW);
}

PFN_GLPRIMITIVEBOUNDINGBOX _glPrimitiveBoundingBox = &_get_glPrimitiveBoundingBox;

static void APIENTRY _fail_glTbufferMask3DFX(GLuint mask) {
    const char *_name = "glTbufferMask3DFX";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glTbufferMask3DFX(GLuint mask) {
    PFN_GLTBUFFERMASK3DFX _ptr;
    _ptr = (PFN_GLTBUFFERMASK3DFX)_getPrivateProcAddress("glTbufferMask3DFX");
    if (!_ptr) {
        _ptr = &_fail_glTbufferMask3DFX;
    }
    _glTbufferMask3DFX = _ptr;
    _glTbufferMask3DFX(mask);
}

PFN_GLTBUFFERMASK3DFX _glTbufferMask3DFX = &_get_glTbufferMask3DFX;

static void APIENTRY _fail_glDebugMessageEnableAMD(GLenum category, GLenum severity, GLsizei count, const GLuint * ids, GLboolean enabled) {
}

static void APIENTRY _get_glDebugMessageEnableAMD(GLenum category, GLenum severity, GLsizei count, const GLuint * ids, GLboolean enabled) {
    PFN_GLDEBUGMESSAGEENABLEAMD _ptr;
    _ptr = (PFN_GLDEBUGMESSAGEENABLEAMD)_getPrivateProcAddress("glDebugMessageEnableAMD");
    if (!_ptr) {
        _ptr = &_fail_glDebugMessageEnableAMD;
    }
    _glDebugMessageEnableAMD = _ptr;
    _glDebugMessageEnableAMD(category, severity, count, ids, enabled);
}

PFN_GLDEBUGMESSAGEENABLEAMD _glDebugMessageEnableAMD = &_get_glDebugMessageEnableAMD;

static void APIENTRY _fail_glDebugMessageInsertAMD(GLenum category, GLenum severity, GLuint id, GLsizei length, const GLchar * buf) {
}

static void APIENTRY _get_glDebugMessageInsertAMD(GLenum category, GLenum severity, GLuint id, GLsizei length, const GLchar * buf) {
    PFN_GLDEBUGMESSAGEINSERTAMD _ptr;
    _ptr = (PFN_GLDEBUGMESSAGEINSERTAMD)_getPrivateProcAddress("glDebugMessageInsertAMD");
    if (!_ptr) {
        _ptr = &_fail_glDebugMessageInsertAMD;
    }
    _glDebugMessageInsertAMD = _ptr;
    _glDebugMessageInsertAMD(category, severity, id, length, buf);
}

PFN_GLDEBUGMESSAGEINSERTAMD _glDebugMessageInsertAMD = &_get_glDebugMessageInsertAMD;

static void APIENTRY _fail_glDebugMessageCallbackAMD(GLDEBUGPROCAMD callback, GLvoid * userParam) {
}

static void APIENTRY _get_glDebugMessageCallbackAMD(GLDEBUGPROCAMD callback, GLvoid * userParam) {
    PFN_GLDEBUGMESSAGECALLBACKAMD _ptr;
    _ptr = (PFN_GLDEBUGMESSAGECALLBACKAMD)_getPrivateProcAddress("glDebugMessageCallbackAMD");
    if (!_ptr) {
        _ptr = &_fail_glDebugMessageCallbackAMD;
    }
    _glDebugMessageCallbackAMD = _ptr;
    _glDebugMessageCallbackAMD(callback, userParam);
}

PFN_GLDEBUGMESSAGECALLBACKAMD _glDebugMessageCallbackAMD = &_get_glDebugMessageCallbackAMD;

static GLuint APIENTRY _fail_glGetDebugMessageLogAMD(GLuint count, GLsizei bufsize, GLenum * categories, GLuint * severities, GLuint * ids, GLsizei * lengths, GLchar * message) {
    if (categories != 0) *categories = 0;
    if (ids != 0) *ids = 0;
    if (severities != 0) *severities = 0;
    if (lengths != 0) *lengths = 0;
    if (message != 0 && bufsize > 0) *message = 0;
    return 0;
}

static GLuint APIENTRY _get_glGetDebugMessageLogAMD(GLuint count, GLsizei bufsize, GLenum * categories, GLuint * severities, GLuint * ids, GLsizei * lengths, GLchar * message) {
    PFN_GLGETDEBUGMESSAGELOGAMD _ptr;
    _ptr = (PFN_GLGETDEBUGMESSAGELOGAMD)_getPrivateProcAddress("glGetDebugMessageLogAMD");
    if (!_ptr) {
        _ptr = &_fail_glGetDebugMessageLogAMD;
    }
    _glGetDebugMessageLogAMD = _ptr;
    return _glGetDebugMessageLogAMD(count, bufsize, categories, severities, ids, lengths, message);
}

PFN_GLGETDEBUGMESSAGELOGAMD _glGetDebugMessageLogAMD = &_get_glGetDebugMessageLogAMD;

static void APIENTRY _fail_glBlendFuncIndexedAMD(GLuint buf, GLenum src, GLenum dst) {
    const char *_name = "glBlendFuncIndexedAMD";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glBlendFuncIndexedAMD(GLuint buf, GLenum src, GLenum dst) {
    PFN_GLBLENDFUNCINDEXEDAMD _ptr;
    _ptr = (PFN_GLBLENDFUNCINDEXEDAMD)_getPrivateProcAddress("glBlendFuncIndexedAMD");
    if (!_ptr) {
        _ptr = &_fail_glBlendFuncIndexedAMD;
    }
    _glBlendFuncIndexedAMD = _ptr;
    _glBlendFuncIndexedAMD(buf, src, dst);
}

PFN_GLBLENDFUNCINDEXEDAMD _glBlendFuncIndexedAMD = &_get_glBlendFuncIndexedAMD;

static void APIENTRY _fail_glBlendFuncSeparateIndexedAMD(GLuint buf, GLenum srcRGB, GLenum dstRGB, GLenum srcAlpha, GLenum dstAlpha) {
    const char *_name = "glBlendFuncSeparateIndexedAMD";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glBlendFuncSeparateIndexedAMD(GLuint buf, GLenum srcRGB, GLenum dstRGB, GLenum srcAlpha, GLenum dstAlpha) {
    PFN_GLBLENDFUNCSEPARATEINDEXEDAMD _ptr;
    _ptr = (PFN_GLBLENDFUNCSEPARATEINDEXEDAMD)_getPrivateProcAddress("glBlendFuncSeparateIndexedAMD");
    if (!_ptr) {
        _ptr = &_fail_glBlendFuncSeparateIndexedAMD;
    }
    _glBlendFuncSeparateIndexedAMD = _ptr;
    _glBlendFuncSeparateIndexedAMD(buf, srcRGB, dstRGB, srcAlpha, dstAlpha);
}

PFN_GLBLENDFUNCSEPARATEINDEXEDAMD _glBlendFuncSeparateIndexedAMD = &_get_glBlendFuncSeparateIndexedAMD;

static void APIENTRY _fail_glBlendEquationIndexedAMD(GLuint buf, GLenum mode) {
    const char *_name = "glBlendEquationIndexedAMD";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glBlendEquationIndexedAMD(GLuint buf, GLenum mode) {
    PFN_GLBLENDEQUATIONINDEXEDAMD _ptr;
    _ptr = (PFN_GLBLENDEQUATIONINDEXEDAMD)_getPrivateProcAddress("glBlendEquationIndexedAMD");
    if (!_ptr) {
        _ptr = &_fail_glBlendEquationIndexedAMD;
    }
    _glBlendEquationIndexedAMD = _ptr;
    _glBlendEquationIndexedAMD(buf, mode);
}

PFN_GLBLENDEQUATIONINDEXEDAMD _glBlendEquationIndexedAMD = &_get_glBlendEquationIndexedAMD;

static void APIENTRY _fail_glBlendEquationSeparateIndexedAMD(GLuint buf, GLenum modeRGB, GLenum modeAlpha) {
    const char *_name = "glBlendEquationSeparateIndexedAMD";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glBlendEquationSeparateIndexedAMD(GLuint buf, GLenum modeRGB, GLenum modeAlpha) {
    PFN_GLBLENDEQUATIONSEPARATEINDEXEDAMD _ptr;
    _ptr = (PFN_GLBLENDEQUATIONSEPARATEINDEXEDAMD)_getPrivateProcAddress("glBlendEquationSeparateIndexedAMD");
    if (!_ptr) {
        _ptr = &_fail_glBlendEquationSeparateIndexedAMD;
    }
    _glBlendEquationSeparateIndexedAMD = _ptr;
    _glBlendEquationSeparateIndexedAMD(buf, modeRGB, modeAlpha);
}

PFN_GLBLENDEQUATIONSEPARATEINDEXEDAMD _glBlendEquationSeparateIndexedAMD = &_get_glBlendEquationSeparateIndexedAMD;

static void APIENTRY _fail_glVertexAttribParameteriAMD(GLuint index, GLenum pname, GLint param) {
    const char *_name = "glVertexAttribParameteriAMD";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glVertexAttribParameteriAMD(GLuint index, GLenum pname, GLint param) {
    PFN_GLVERTEXATTRIBPARAMETERIAMD _ptr;
    _ptr = (PFN_GLVERTEXATTRIBPARAMETERIAMD)_getPrivateProcAddress("glVertexAttribParameteriAMD");
    if (!_ptr) {
        _ptr = &_fail_glVertexAttribParameteriAMD;
    }
    _glVertexAttribParameteriAMD = _ptr;
    _glVertexAttribParameteriAMD(index, pname, param);
}

PFN_GLVERTEXATTRIBPARAMETERIAMD _glVertexAttribParameteriAMD = &_get_glVertexAttribParameteriAMD;

static void APIENTRY _fail_glMultiDrawArraysIndirectAMD(GLenum mode, const GLvoid * indirect, GLsizei drawcount, GLsizei stride) {
    const char *_name = "glMultiDrawArraysIndirectAMD";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glMultiDrawArraysIndirectAMD(GLenum mode, const GLvoid * indirect, GLsizei drawcount, GLsizei stride) {
    PFN_GLMULTIDRAWARRAYSINDIRECTAMD _ptr;
    _ptr = (PFN_GLMULTIDRAWARRAYSINDIRECTAMD)_getPrivateProcAddress("glMultiDrawArraysIndirectAMD");
    if (!_ptr) {
        _ptr = &_fail_glMultiDrawArraysIndirectAMD;
    }
    _glMultiDrawArraysIndirectAMD = _ptr;
    _glMultiDrawArraysIndirectAMD(mode, indirect, drawcount, stride);
}

PFN_GLMULTIDRAWARRAYSINDIRECTAMD _glMultiDrawArraysIndirectAMD = &_get_glMultiDrawArraysIndirectAMD;

static void APIENTRY _fail_glMultiDrawElementsIndirectAMD(GLenum mode, GLenum type, const GLvoid * indirect, GLsizei drawcount, GLsizei stride) {
    const char *_name = "glMultiDrawElementsIndirectAMD";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glMultiDrawElementsIndirectAMD(GLenum mode, GLenum type, const GLvoid * indirect, GLsizei drawcount, GLsizei stride) {
    PFN_GLMULTIDRAWELEMENTSINDIRECTAMD _ptr;
    _ptr = (PFN_GLMULTIDRAWELEMENTSINDIRECTAMD)_getPrivateProcAddress("glMultiDrawElementsIndirectAMD");
    if (!_ptr) {
        _ptr = &_fail_glMultiDrawElementsIndirectAMD;
    }
    _glMultiDrawElementsIndirectAMD = _ptr;
    _glMultiDrawElementsIndirectAMD(mode, type, indirect, drawcount, stride);
}

PFN_GLMULTIDRAWELEMENTSINDIRECTAMD _glMultiDrawElementsIndirectAMD = &_get_glMultiDrawElementsIndirectAMD;

static void APIENTRY _fail_glGenNamesAMD(GLenum identifier, GLuint num, GLuint * names) {
    const char *_name = "glGenNamesAMD";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGenNamesAMD(GLenum identifier, GLuint num, GLuint * names) {
    PFN_GLGENNAMESAMD _ptr;
    _ptr = (PFN_GLGENNAMESAMD)_getPrivateProcAddress("glGenNamesAMD");
    if (!_ptr) {
        _ptr = &_fail_glGenNamesAMD;
    }
    _glGenNamesAMD = _ptr;
    _glGenNamesAMD(identifier, num, names);
}

PFN_GLGENNAMESAMD _glGenNamesAMD = &_get_glGenNamesAMD;

static void APIENTRY _fail_glDeleteNamesAMD(GLenum identifier, GLuint num, const GLuint * names) {
    const char *_name = "glDeleteNamesAMD";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glDeleteNamesAMD(GLenum identifier, GLuint num, const GLuint * names) {
    PFN_GLDELETENAMESAMD _ptr;
    _ptr = (PFN_GLDELETENAMESAMD)_getPrivateProcAddress("glDeleteNamesAMD");
    if (!_ptr) {
        _ptr = &_fail_glDeleteNamesAMD;
    }
    _glDeleteNamesAMD = _ptr;
    _glDeleteNamesAMD(identifier, num, names);
}

PFN_GLDELETENAMESAMD _glDeleteNamesAMD = &_get_glDeleteNamesAMD;

static GLboolean APIENTRY _fail_glIsNameAMD(GLenum identifier, GLuint name) {
    const char *_name = "glIsNameAMD";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static GLboolean APIENTRY _get_glIsNameAMD(GLenum identifier, GLuint name) {
    PFN_GLISNAMEAMD _ptr;
    _ptr = (PFN_GLISNAMEAMD)_getPrivateProcAddress("glIsNameAMD");
    if (!_ptr) {
        _ptr = &_fail_glIsNameAMD;
    }
    _glIsNameAMD = _ptr;
    return _glIsNameAMD(identifier, name);
}

PFN_GLISNAMEAMD _glIsNameAMD = &_get_glIsNameAMD;

static void APIENTRY _fail_glQueryObjectParameteruiAMD(GLenum target, GLuint id, GLenum pname, GLuint param) {
    const char *_name = "glQueryObjectParameteruiAMD";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glQueryObjectParameteruiAMD(GLenum target, GLuint id, GLenum pname, GLuint param) {
    PFN_GLQUERYOBJECTPARAMETERUIAMD _ptr;
    _ptr = (PFN_GLQUERYOBJECTPARAMETERUIAMD)_getPrivateProcAddress("glQueryObjectParameteruiAMD");
    if (!_ptr) {
        _ptr = &_fail_glQueryObjectParameteruiAMD;
    }
    _glQueryObjectParameteruiAMD = _ptr;
    _glQueryObjectParameteruiAMD(target, id, pname, param);
}

PFN_GLQUERYOBJECTPARAMETERUIAMD _glQueryObjectParameteruiAMD = &_get_glQueryObjectParameteruiAMD;

static void APIENTRY _fail_glGetPerfMonitorGroupsAMD(GLint * numGroups, GLsizei groupsSize, GLuint * groups) {
    const char *_name = "glGetPerfMonitorGroupsAMD";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetPerfMonitorGroupsAMD(GLint * numGroups, GLsizei groupsSize, GLuint * groups) {
    PFN_GLGETPERFMONITORGROUPSAMD _ptr;
    _ptr = (PFN_GLGETPERFMONITORGROUPSAMD)_getPrivateProcAddress("glGetPerfMonitorGroupsAMD");
    if (!_ptr) {
        _ptr = &_fail_glGetPerfMonitorGroupsAMD;
    }
    _glGetPerfMonitorGroupsAMD = _ptr;
    _glGetPerfMonitorGroupsAMD(numGroups, groupsSize, groups);
}

PFN_GLGETPERFMONITORGROUPSAMD _glGetPerfMonitorGroupsAMD = &_get_glGetPerfMonitorGroupsAMD;

static void APIENTRY _fail_glGetPerfMonitorCountersAMD(GLuint group, GLint * numCounters, GLint * maxActiveCounters, GLsizei counterSize, GLuint * counters) {
    const char *_name = "glGetPerfMonitorCountersAMD";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetPerfMonitorCountersAMD(GLuint group, GLint * numCounters, GLint * maxActiveCounters, GLsizei counterSize, GLuint * counters) {
    PFN_GLGETPERFMONITORCOUNTERSAMD _ptr;
    _ptr = (PFN_GLGETPERFMONITORCOUNTERSAMD)_getPrivateProcAddress("glGetPerfMonitorCountersAMD");
    if (!_ptr) {
        _ptr = &_fail_glGetPerfMonitorCountersAMD;
    }
    _glGetPerfMonitorCountersAMD = _ptr;
    _glGetPerfMonitorCountersAMD(group, numCounters, maxActiveCounters, counterSize, counters);
}

PFN_GLGETPERFMONITORCOUNTERSAMD _glGetPerfMonitorCountersAMD = &_get_glGetPerfMonitorCountersAMD;

static void APIENTRY _fail_glGetPerfMonitorGroupStringAMD(GLuint group, GLsizei bufSize, GLsizei * length, GLchar * groupString) {
    const char *_name = "glGetPerfMonitorGroupStringAMD";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetPerfMonitorGroupStringAMD(GLuint group, GLsizei bufSize, GLsizei * length, GLchar * groupString) {
    PFN_GLGETPERFMONITORGROUPSTRINGAMD _ptr;
    _ptr = (PFN_GLGETPERFMONITORGROUPSTRINGAMD)_getPrivateProcAddress("glGetPerfMonitorGroupStringAMD");
    if (!_ptr) {
        _ptr = &_fail_glGetPerfMonitorGroupStringAMD;
    }
    _glGetPerfMonitorGroupStringAMD = _ptr;
    _glGetPerfMonitorGroupStringAMD(group, bufSize, length, groupString);
}

PFN_GLGETPERFMONITORGROUPSTRINGAMD _glGetPerfMonitorGroupStringAMD = &_get_glGetPerfMonitorGroupStringAMD;

static void APIENTRY _fail_glGetPerfMonitorCounterStringAMD(GLuint group, GLuint counter, GLsizei bufSize, GLsizei * length, GLchar * counterString) {
    const char *_name = "glGetPerfMonitorCounterStringAMD";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetPerfMonitorCounterStringAMD(GLuint group, GLuint counter, GLsizei bufSize, GLsizei * length, GLchar * counterString) {
    PFN_GLGETPERFMONITORCOUNTERSTRINGAMD _ptr;
    _ptr = (PFN_GLGETPERFMONITORCOUNTERSTRINGAMD)_getPrivateProcAddress("glGetPerfMonitorCounterStringAMD");
    if (!_ptr) {
        _ptr = &_fail_glGetPerfMonitorCounterStringAMD;
    }
    _glGetPerfMonitorCounterStringAMD = _ptr;
    _glGetPerfMonitorCounterStringAMD(group, counter, bufSize, length, counterString);
}

PFN_GLGETPERFMONITORCOUNTERSTRINGAMD _glGetPerfMonitorCounterStringAMD = &_get_glGetPerfMonitorCounterStringAMD;

static void APIENTRY _fail_glGetPerfMonitorCounterInfoAMD(GLuint group, GLuint counter, GLenum pname, GLvoid * data) {
    const char *_name = "glGetPerfMonitorCounterInfoAMD";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetPerfMonitorCounterInfoAMD(GLuint group, GLuint counter, GLenum pname, GLvoid * data) {
    PFN_GLGETPERFMONITORCOUNTERINFOAMD _ptr;
    _ptr = (PFN_GLGETPERFMONITORCOUNTERINFOAMD)_getPrivateProcAddress("glGetPerfMonitorCounterInfoAMD");
    if (!_ptr) {
        _ptr = &_fail_glGetPerfMonitorCounterInfoAMD;
    }
    _glGetPerfMonitorCounterInfoAMD = _ptr;
    _glGetPerfMonitorCounterInfoAMD(group, counter, pname, data);
}

PFN_GLGETPERFMONITORCOUNTERINFOAMD _glGetPerfMonitorCounterInfoAMD = &_get_glGetPerfMonitorCounterInfoAMD;

static void APIENTRY _fail_glGenPerfMonitorsAMD(GLsizei n, GLuint * monitors) {
    const char *_name = "glGenPerfMonitorsAMD";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGenPerfMonitorsAMD(GLsizei n, GLuint * monitors) {
    PFN_GLGENPERFMONITORSAMD _ptr;
    _ptr = (PFN_GLGENPERFMONITORSAMD)_getPrivateProcAddress("glGenPerfMonitorsAMD");
    if (!_ptr) {
        _ptr = &_fail_glGenPerfMonitorsAMD;
    }
    _glGenPerfMonitorsAMD = _ptr;
    _glGenPerfMonitorsAMD(n, monitors);
}

PFN_GLGENPERFMONITORSAMD _glGenPerfMonitorsAMD = &_get_glGenPerfMonitorsAMD;

static void APIENTRY _fail_glDeletePerfMonitorsAMD(GLsizei n, GLuint * monitors) {
    const char *_name = "glDeletePerfMonitorsAMD";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glDeletePerfMonitorsAMD(GLsizei n, GLuint * monitors) {
    PFN_GLDELETEPERFMONITORSAMD _ptr;
    _ptr = (PFN_GLDELETEPERFMONITORSAMD)_getPrivateProcAddress("glDeletePerfMonitorsAMD");
    if (!_ptr) {
        _ptr = &_fail_glDeletePerfMonitorsAMD;
    }
    _glDeletePerfMonitorsAMD = _ptr;
    _glDeletePerfMonitorsAMD(n, monitors);
}

PFN_GLDELETEPERFMONITORSAMD _glDeletePerfMonitorsAMD = &_get_glDeletePerfMonitorsAMD;

static void APIENTRY _fail_glSelectPerfMonitorCountersAMD(GLuint monitor, GLboolean enable, GLuint group, GLint numCounters, GLuint * counterList) {
    const char *_name = "glSelectPerfMonitorCountersAMD";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glSelectPerfMonitorCountersAMD(GLuint monitor, GLboolean enable, GLuint group, GLint numCounters, GLuint * counterList) {
    PFN_GLSELECTPERFMONITORCOUNTERSAMD _ptr;
    _ptr = (PFN_GLSELECTPERFMONITORCOUNTERSAMD)_getPrivateProcAddress("glSelectPerfMonitorCountersAMD");
    if (!_ptr) {
        _ptr = &_fail_glSelectPerfMonitorCountersAMD;
    }
    _glSelectPerfMonitorCountersAMD = _ptr;
    _glSelectPerfMonitorCountersAMD(monitor, enable, group, numCounters, counterList);
}

PFN_GLSELECTPERFMONITORCOUNTERSAMD _glSelectPerfMonitorCountersAMD = &_get_glSelectPerfMonitorCountersAMD;

static void APIENTRY _fail_glBeginPerfMonitorAMD(GLuint monitor) {
    const char *_name = "glBeginPerfMonitorAMD";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glBeginPerfMonitorAMD(GLuint monitor) {
    PFN_GLBEGINPERFMONITORAMD _ptr;
    _ptr = (PFN_GLBEGINPERFMONITORAMD)_getPrivateProcAddress("glBeginPerfMonitorAMD");
    if (!_ptr) {
        _ptr = &_fail_glBeginPerfMonitorAMD;
    }
    _glBeginPerfMonitorAMD = _ptr;
    _glBeginPerfMonitorAMD(monitor);
}

PFN_GLBEGINPERFMONITORAMD _glBeginPerfMonitorAMD = &_get_glBeginPerfMonitorAMD;

static void APIENTRY _fail_glEndPerfMonitorAMD(GLuint monitor) {
    const char *_name = "glEndPerfMonitorAMD";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glEndPerfMonitorAMD(GLuint monitor) {
    PFN_GLENDPERFMONITORAMD _ptr;
    _ptr = (PFN_GLENDPERFMONITORAMD)_getPrivateProcAddress("glEndPerfMonitorAMD");
    if (!_ptr) {
        _ptr = &_fail_glEndPerfMonitorAMD;
    }
    _glEndPerfMonitorAMD = _ptr;
    _glEndPerfMonitorAMD(monitor);
}

PFN_GLENDPERFMONITORAMD _glEndPerfMonitorAMD = &_get_glEndPerfMonitorAMD;

static void APIENTRY _fail_glGetPerfMonitorCounterDataAMD(GLuint monitor, GLenum pname, GLsizei dataSize, GLuint * data, GLint * bytesWritten) {
    const char *_name = "glGetPerfMonitorCounterDataAMD";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetPerfMonitorCounterDataAMD(GLuint monitor, GLenum pname, GLsizei dataSize, GLuint * data, GLint * bytesWritten) {
    PFN_GLGETPERFMONITORCOUNTERDATAAMD _ptr;
    _ptr = (PFN_GLGETPERFMONITORCOUNTERDATAAMD)_getPrivateProcAddress("glGetPerfMonitorCounterDataAMD");
    if (!_ptr) {
        _ptr = &_fail_glGetPerfMonitorCounterDataAMD;
    }
    _glGetPerfMonitorCounterDataAMD = _ptr;
    _glGetPerfMonitorCounterDataAMD(monitor, pname, dataSize, data, bytesWritten);
}

PFN_GLGETPERFMONITORCOUNTERDATAAMD _glGetPerfMonitorCounterDataAMD = &_get_glGetPerfMonitorCounterDataAMD;

static void APIENTRY _fail_glSetMultisamplefvAMD(GLenum pname, GLuint index, const GLfloat * val) {
    const char *_name = "glSetMultisamplefvAMD";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glSetMultisamplefvAMD(GLenum pname, GLuint index, const GLfloat * val) {
    PFN_GLSETMULTISAMPLEFVAMD _ptr;
    _ptr = (PFN_GLSETMULTISAMPLEFVAMD)_getPrivateProcAddress("glSetMultisamplefvAMD");
    if (!_ptr) {
        _ptr = &_fail_glSetMultisamplefvAMD;
    }
    _glSetMultisamplefvAMD = _ptr;
    _glSetMultisamplefvAMD(pname, index, val);
}

PFN_GLSETMULTISAMPLEFVAMD _glSetMultisamplefvAMD = &_get_glSetMultisamplefvAMD;

static void APIENTRY _fail_glTexStorageSparseAMD(GLenum target, GLenum internalFormat, GLsizei width, GLsizei height, GLsizei depth, GLsizei layers, GLbitfield flags) {
    const char *_name = "glTexStorageSparseAMD";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glTexStorageSparseAMD(GLenum target, GLenum internalFormat, GLsizei width, GLsizei height, GLsizei depth, GLsizei layers, GLbitfield flags) {
    PFN_GLTEXSTORAGESPARSEAMD _ptr;
    _ptr = (PFN_GLTEXSTORAGESPARSEAMD)_getPrivateProcAddress("glTexStorageSparseAMD");
    if (!_ptr) {
        _ptr = &_fail_glTexStorageSparseAMD;
    }
    _glTexStorageSparseAMD = _ptr;
    _glTexStorageSparseAMD(target, internalFormat, width, height, depth, layers, flags);
}

PFN_GLTEXSTORAGESPARSEAMD _glTexStorageSparseAMD = &_get_glTexStorageSparseAMD;

static void APIENTRY _fail_glTextureStorageSparseAMD(GLuint texture, GLenum target, GLenum internalFormat, GLsizei width, GLsizei height, GLsizei depth, GLsizei layers, GLbitfield flags) {
    const char *_name = "glTextureStorageSparseAMD";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glTextureStorageSparseAMD(GLuint texture, GLenum target, GLenum internalFormat, GLsizei width, GLsizei height, GLsizei depth, GLsizei layers, GLbitfield flags) {
    PFN_GLTEXTURESTORAGESPARSEAMD _ptr;
    _ptr = (PFN_GLTEXTURESTORAGESPARSEAMD)_getPrivateProcAddress("glTextureStorageSparseAMD");
    if (!_ptr) {
        _ptr = &_fail_glTextureStorageSparseAMD;
    }
    _glTextureStorageSparseAMD = _ptr;
    _glTextureStorageSparseAMD(texture, target, internalFormat, width, height, depth, layers, flags);
}

PFN_GLTEXTURESTORAGESPARSEAMD _glTextureStorageSparseAMD = &_get_glTextureStorageSparseAMD;

static void APIENTRY _fail_glStencilOpValueAMD(GLenum face, GLuint value) {
    const char *_name = "glStencilOpValueAMD";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glStencilOpValueAMD(GLenum face, GLuint value) {
    PFN_GLSTENCILOPVALUEAMD _ptr;
    _ptr = (PFN_GLSTENCILOPVALUEAMD)_getPrivateProcAddress("glStencilOpValueAMD");
    if (!_ptr) {
        _ptr = &_fail_glStencilOpValueAMD;
    }
    _glStencilOpValueAMD = _ptr;
    _glStencilOpValueAMD(face, value);
}

PFN_GLSTENCILOPVALUEAMD _glStencilOpValueAMD = &_get_glStencilOpValueAMD;

static void APIENTRY _fail_glTessellationFactorAMD(GLfloat factor) {
    const char *_name = "glTessellationFactorAMD";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glTessellationFactorAMD(GLfloat factor) {
    PFN_GLTESSELLATIONFACTORAMD _ptr;
    _ptr = (PFN_GLTESSELLATIONFACTORAMD)_getPrivateProcAddress("glTessellationFactorAMD");
    if (!_ptr) {
        _ptr = &_fail_glTessellationFactorAMD;
    }
    _glTessellationFactorAMD = _ptr;
    _glTessellationFactorAMD(factor);
}

PFN_GLTESSELLATIONFACTORAMD _glTessellationFactorAMD = &_get_glTessellationFactorAMD;

static void APIENTRY _fail_glTessellationModeAMD(GLenum mode) {
    const char *_name = "glTessellationModeAMD";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glTessellationModeAMD(GLenum mode) {
    PFN_GLTESSELLATIONMODEAMD _ptr;
    _ptr = (PFN_GLTESSELLATIONMODEAMD)_getPrivateProcAddress("glTessellationModeAMD");
    if (!_ptr) {
        _ptr = &_fail_glTessellationModeAMD;
    }
    _glTessellationModeAMD = _ptr;
    _glTessellationModeAMD(mode);
}

PFN_GLTESSELLATIONMODEAMD _glTessellationModeAMD = &_get_glTessellationModeAMD;

static void APIENTRY _fail_glBlitFramebufferANGLE(GLint srcX0, GLint srcY0, GLint srcX1, GLint srcY1, GLint dstX0, GLint dstY0, GLint dstX1, GLint dstY1, GLbitfield mask, GLenum filter) {
    const char *_name = "glBlitFramebufferANGLE";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glBlitFramebufferANGLE(GLint srcX0, GLint srcY0, GLint srcX1, GLint srcY1, GLint dstX0, GLint dstY0, GLint dstX1, GLint dstY1, GLbitfield mask, GLenum filter) {
    PFN_GLBLITFRAMEBUFFERANGLE _ptr;
    _ptr = (PFN_GLBLITFRAMEBUFFERANGLE)_getPrivateProcAddress("glBlitFramebufferANGLE");
    if (!_ptr) {
        _ptr = &_fail_glBlitFramebufferANGLE;
    }
    _glBlitFramebufferANGLE = _ptr;
    _glBlitFramebufferANGLE(srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1, dstY1, mask, filter);
}

PFN_GLBLITFRAMEBUFFERANGLE _glBlitFramebufferANGLE = &_get_glBlitFramebufferANGLE;

static void APIENTRY _fail_glRenderbufferStorageMultisampleANGLE(GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height) {
    const char *_name = "glRenderbufferStorageMultisampleANGLE";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glRenderbufferStorageMultisampleANGLE(GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height) {
    PFN_GLRENDERBUFFERSTORAGEMULTISAMPLEANGLE _ptr;
    _ptr = (PFN_GLRENDERBUFFERSTORAGEMULTISAMPLEANGLE)_getPrivateProcAddress("glRenderbufferStorageMultisampleANGLE");
    if (!_ptr) {
        _ptr = &_fail_glRenderbufferStorageMultisampleANGLE;
    }
    _glRenderbufferStorageMultisampleANGLE = _ptr;
    _glRenderbufferStorageMultisampleANGLE(target, samples, internalformat, width, height);
}

PFN_GLRENDERBUFFERSTORAGEMULTISAMPLEANGLE _glRenderbufferStorageMultisampleANGLE = &_get_glRenderbufferStorageMultisampleANGLE;

static void APIENTRY _fail_glDrawArraysInstancedANGLE(GLenum mode, GLint first, GLsizei count, GLsizei instancecount) {
    const char *_name = "glDrawArraysInstancedANGLE";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glDrawArraysInstancedANGLE(GLenum mode, GLint first, GLsizei count, GLsizei instancecount) {
    PFN_GLDRAWARRAYSINSTANCEDANGLE _ptr;
    _ptr = (PFN_GLDRAWARRAYSINSTANCEDANGLE)_getPrivateProcAddress("glDrawArraysInstancedANGLE");
    if (!_ptr) {
        _ptr = &_fail_glDrawArraysInstancedANGLE;
    }
    _glDrawArraysInstancedANGLE = _ptr;
    _glDrawArraysInstancedANGLE(mode, first, count, instancecount);
}

PFN_GLDRAWARRAYSINSTANCEDANGLE _glDrawArraysInstancedANGLE = &_get_glDrawArraysInstancedANGLE;

static void APIENTRY _fail_glDrawElementsInstancedANGLE(GLenum mode, GLsizei count, GLenum type, const GLvoid * indices, GLsizei instancecount) {
    const char *_name = "glDrawElementsInstancedANGLE";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glDrawElementsInstancedANGLE(GLenum mode, GLsizei count, GLenum type, const GLvoid * indices, GLsizei instancecount) {
    PFN_GLDRAWELEMENTSINSTANCEDANGLE _ptr;
    _ptr = (PFN_GLDRAWELEMENTSINSTANCEDANGLE)_getPrivateProcAddress("glDrawElementsInstancedANGLE");
    if (!_ptr) {
        _ptr = &_fail_glDrawElementsInstancedANGLE;
    }
    _glDrawElementsInstancedANGLE = _ptr;
    _glDrawElementsInstancedANGLE(mode, count, type, indices, instancecount);
}

PFN_GLDRAWELEMENTSINSTANCEDANGLE _glDrawElementsInstancedANGLE = &_get_glDrawElementsInstancedANGLE;

static void APIENTRY _fail_glVertexAttribDivisorANGLE(GLuint index, GLuint divisor) {
    const char *_name = "glVertexAttribDivisorANGLE";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glVertexAttribDivisorANGLE(GLuint index, GLuint divisor) {
    PFN_GLVERTEXATTRIBDIVISORANGLE _ptr;
    _ptr = (PFN_GLVERTEXATTRIBDIVISORANGLE)_getPrivateProcAddress("glVertexAttribDivisorANGLE");
    if (!_ptr) {
        _ptr = &_fail_glVertexAttribDivisorANGLE;
    }
    _glVertexAttribDivisorANGLE = _ptr;
    _glVertexAttribDivisorANGLE(index, divisor);
}

PFN_GLVERTEXATTRIBDIVISORANGLE _glVertexAttribDivisorANGLE = &_get_glVertexAttribDivisorANGLE;

static void APIENTRY _fail_glGenQueriesANGLE(GLsizei n, GLuint * ids) {
    const char *_name = "glGenQueriesANGLE";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGenQueriesANGLE(GLsizei n, GLuint * ids) {
    PFN_GLGENQUERIESANGLE _ptr;
    _ptr = (PFN_GLGENQUERIESANGLE)_getPrivateProcAddress("glGenQueriesANGLE");
    if (!_ptr) {
        _ptr = &_fail_glGenQueriesANGLE;
    }
    _glGenQueriesANGLE = _ptr;
    _glGenQueriesANGLE(n, ids);
}

PFN_GLGENQUERIESANGLE _glGenQueriesANGLE = &_get_glGenQueriesANGLE;

static void APIENTRY _fail_glDeleteQueriesANGLE(GLsizei n, const GLuint * ids) {
    const char *_name = "glDeleteQueriesANGLE";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glDeleteQueriesANGLE(GLsizei n, const GLuint * ids) {
    PFN_GLDELETEQUERIESANGLE _ptr;
    _ptr = (PFN_GLDELETEQUERIESANGLE)_getPrivateProcAddress("glDeleteQueriesANGLE");
    if (!_ptr) {
        _ptr = &_fail_glDeleteQueriesANGLE;
    }
    _glDeleteQueriesANGLE = _ptr;
    _glDeleteQueriesANGLE(n, ids);
}

PFN_GLDELETEQUERIESANGLE _glDeleteQueriesANGLE = &_get_glDeleteQueriesANGLE;

static GLboolean APIENTRY _fail_glIsQueryANGLE(GLuint id) {
    const char *_name = "glIsQueryANGLE";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static GLboolean APIENTRY _get_glIsQueryANGLE(GLuint id) {
    PFN_GLISQUERYANGLE _ptr;
    _ptr = (PFN_GLISQUERYANGLE)_getPrivateProcAddress("glIsQueryANGLE");
    if (!_ptr) {
        _ptr = &_fail_glIsQueryANGLE;
    }
    _glIsQueryANGLE = _ptr;
    return _glIsQueryANGLE(id);
}

PFN_GLISQUERYANGLE _glIsQueryANGLE = &_get_glIsQueryANGLE;

static void APIENTRY _fail_glBeginQueryANGLE(GLenum target, GLuint id) {
    const char *_name = "glBeginQueryANGLE";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glBeginQueryANGLE(GLenum target, GLuint id) {
    PFN_GLBEGINQUERYANGLE _ptr;
    _ptr = (PFN_GLBEGINQUERYANGLE)_getPrivateProcAddress("glBeginQueryANGLE");
    if (!_ptr) {
        _ptr = &_fail_glBeginQueryANGLE;
    }
    _glBeginQueryANGLE = _ptr;
    _glBeginQueryANGLE(target, id);
}

PFN_GLBEGINQUERYANGLE _glBeginQueryANGLE = &_get_glBeginQueryANGLE;

static void APIENTRY _fail_glEndQueryANGLE(GLenum target) {
    const char *_name = "glEndQueryANGLE";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glEndQueryANGLE(GLenum target) {
    PFN_GLENDQUERYANGLE _ptr;
    _ptr = (PFN_GLENDQUERYANGLE)_getPrivateProcAddress("glEndQueryANGLE");
    if (!_ptr) {
        _ptr = &_fail_glEndQueryANGLE;
    }
    _glEndQueryANGLE = _ptr;
    _glEndQueryANGLE(target);
}

PFN_GLENDQUERYANGLE _glEndQueryANGLE = &_get_glEndQueryANGLE;

static void APIENTRY _fail_glQueryCounterANGLE(GLuint id, GLenum target) {
    const char *_name = "glQueryCounterANGLE";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glQueryCounterANGLE(GLuint id, GLenum target) {
    PFN_GLQUERYCOUNTERANGLE _ptr;
    _ptr = (PFN_GLQUERYCOUNTERANGLE)_getPrivateProcAddress("glQueryCounterANGLE");
    if (!_ptr) {
        _ptr = &_fail_glQueryCounterANGLE;
    }
    _glQueryCounterANGLE = _ptr;
    _glQueryCounterANGLE(id, target);
}

PFN_GLQUERYCOUNTERANGLE _glQueryCounterANGLE = &_get_glQueryCounterANGLE;

static void APIENTRY _fail_glGetQueryivANGLE(GLenum target, GLenum pname, GLint * params) {
    const char *_name = "glGetQueryivANGLE";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetQueryivANGLE(GLenum target, GLenum pname, GLint * params) {
    PFN_GLGETQUERYIVANGLE _ptr;
    _ptr = (PFN_GLGETQUERYIVANGLE)_getPrivateProcAddress("glGetQueryivANGLE");
    if (!_ptr) {
        _ptr = &_fail_glGetQueryivANGLE;
    }
    _glGetQueryivANGLE = _ptr;
    _glGetQueryivANGLE(target, pname, params);
}

PFN_GLGETQUERYIVANGLE _glGetQueryivANGLE = &_get_glGetQueryivANGLE;

static void APIENTRY _fail_glGetQueryObjectivANGLE(GLuint id, GLenum pname, GLint * params) {
    const char *_name = "glGetQueryObjectivANGLE";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetQueryObjectivANGLE(GLuint id, GLenum pname, GLint * params) {
    PFN_GLGETQUERYOBJECTIVANGLE _ptr;
    _ptr = (PFN_GLGETQUERYOBJECTIVANGLE)_getPrivateProcAddress("glGetQueryObjectivANGLE");
    if (!_ptr) {
        _ptr = &_fail_glGetQueryObjectivANGLE;
    }
    _glGetQueryObjectivANGLE = _ptr;
    _glGetQueryObjectivANGLE(id, pname, params);
}

PFN_GLGETQUERYOBJECTIVANGLE _glGetQueryObjectivANGLE = &_get_glGetQueryObjectivANGLE;

static void APIENTRY _fail_glGetQueryObjectuivANGLE(GLuint id, GLenum pname, GLuint * params) {
    const char *_name = "glGetQueryObjectuivANGLE";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetQueryObjectuivANGLE(GLuint id, GLenum pname, GLuint * params) {
    PFN_GLGETQUERYOBJECTUIVANGLE _ptr;
    _ptr = (PFN_GLGETQUERYOBJECTUIVANGLE)_getPrivateProcAddress("glGetQueryObjectuivANGLE");
    if (!_ptr) {
        _ptr = &_fail_glGetQueryObjectuivANGLE;
    }
    _glGetQueryObjectuivANGLE = _ptr;
    _glGetQueryObjectuivANGLE(id, pname, params);
}

PFN_GLGETQUERYOBJECTUIVANGLE _glGetQueryObjectuivANGLE = &_get_glGetQueryObjectuivANGLE;

static void APIENTRY _fail_glGetQueryObjecti64vANGLE(GLuint id, GLenum pname, GLint64 * params) {
    const char *_name = "glGetQueryObjecti64vANGLE";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetQueryObjecti64vANGLE(GLuint id, GLenum pname, GLint64 * params) {
    PFN_GLGETQUERYOBJECTI64VANGLE _ptr;
    _ptr = (PFN_GLGETQUERYOBJECTI64VANGLE)_getPrivateProcAddress("glGetQueryObjecti64vANGLE");
    if (!_ptr) {
        _ptr = &_fail_glGetQueryObjecti64vANGLE;
    }
    _glGetQueryObjecti64vANGLE = _ptr;
    _glGetQueryObjecti64vANGLE(id, pname, params);
}

PFN_GLGETQUERYOBJECTI64VANGLE _glGetQueryObjecti64vANGLE = &_get_glGetQueryObjecti64vANGLE;

static void APIENTRY _fail_glGetQueryObjectui64vANGLE(GLuint id, GLenum pname, GLuint64 * params) {
    const char *_name = "glGetQueryObjectui64vANGLE";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetQueryObjectui64vANGLE(GLuint id, GLenum pname, GLuint64 * params) {
    PFN_GLGETQUERYOBJECTUI64VANGLE _ptr;
    _ptr = (PFN_GLGETQUERYOBJECTUI64VANGLE)_getPrivateProcAddress("glGetQueryObjectui64vANGLE");
    if (!_ptr) {
        _ptr = &_fail_glGetQueryObjectui64vANGLE;
    }
    _glGetQueryObjectui64vANGLE = _ptr;
    _glGetQueryObjectui64vANGLE(id, pname, params);
}

PFN_GLGETQUERYOBJECTUI64VANGLE _glGetQueryObjectui64vANGLE = &_get_glGetQueryObjectui64vANGLE;

static void APIENTRY _fail_glGetTranslatedShaderSourceANGLE(GLuint shader, GLsizei bufsize, GLsizei * length, GLchar * source) {
    const char *_name = "glGetTranslatedShaderSourceANGLE";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetTranslatedShaderSourceANGLE(GLuint shader, GLsizei bufsize, GLsizei * length, GLchar * source) {
    PFN_GLGETTRANSLATEDSHADERSOURCEANGLE _ptr;
    _ptr = (PFN_GLGETTRANSLATEDSHADERSOURCEANGLE)_getPrivateProcAddress("glGetTranslatedShaderSourceANGLE");
    if (!_ptr) {
        _ptr = &_fail_glGetTranslatedShaderSourceANGLE;
    }
    _glGetTranslatedShaderSourceANGLE = _ptr;
    _glGetTranslatedShaderSourceANGLE(shader, bufsize, length, source);
}

PFN_GLGETTRANSLATEDSHADERSOURCEANGLE _glGetTranslatedShaderSourceANGLE = &_get_glGetTranslatedShaderSourceANGLE;

static void APIENTRY _fail_glCopyTextureLevelsAPPLE(GLuint destinationTexture, GLuint sourceTexture, GLint sourceBaseLevel, GLsizei sourceLevelCount) {
    const char *_name = "glCopyTextureLevelsAPPLE";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glCopyTextureLevelsAPPLE(GLuint destinationTexture, GLuint sourceTexture, GLint sourceBaseLevel, GLsizei sourceLevelCount) {
    PFN_GLCOPYTEXTURELEVELSAPPLE _ptr;
    _ptr = (PFN_GLCOPYTEXTURELEVELSAPPLE)_getPrivateProcAddress("glCopyTextureLevelsAPPLE");
    if (!_ptr) {
        _ptr = &_fail_glCopyTextureLevelsAPPLE;
    }
    _glCopyTextureLevelsAPPLE = _ptr;
    _glCopyTextureLevelsAPPLE(destinationTexture, sourceTexture, sourceBaseLevel, sourceLevelCount);
}

PFN_GLCOPYTEXTURELEVELSAPPLE _glCopyTextureLevelsAPPLE = &_get_glCopyTextureLevelsAPPLE;

static void APIENTRY _fail_glElementPointerAPPLE(GLenum type, const GLvoid * pointer) {
    const char *_name = "glElementPointerAPPLE";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glElementPointerAPPLE(GLenum type, const GLvoid * pointer) {
    PFN_GLELEMENTPOINTERAPPLE _ptr;
    _ptr = (PFN_GLELEMENTPOINTERAPPLE)_getPrivateProcAddress("glElementPointerAPPLE");
    if (!_ptr) {
        _ptr = &_fail_glElementPointerAPPLE;
    }
    _glElementPointerAPPLE = _ptr;
    _glElementPointerAPPLE(type, pointer);
}

PFN_GLELEMENTPOINTERAPPLE _glElementPointerAPPLE = &_get_glElementPointerAPPLE;

static void APIENTRY _fail_glDrawElementArrayAPPLE(GLenum mode, GLint first, GLsizei count) {
    const char *_name = "glDrawElementArrayAPPLE";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glDrawElementArrayAPPLE(GLenum mode, GLint first, GLsizei count) {
    PFN_GLDRAWELEMENTARRAYAPPLE _ptr;
    _ptr = (PFN_GLDRAWELEMENTARRAYAPPLE)_getPrivateProcAddress("glDrawElementArrayAPPLE");
    if (!_ptr) {
        _ptr = &_fail_glDrawElementArrayAPPLE;
    }
    _glDrawElementArrayAPPLE = _ptr;
    _glDrawElementArrayAPPLE(mode, first, count);
}

PFN_GLDRAWELEMENTARRAYAPPLE _glDrawElementArrayAPPLE = &_get_glDrawElementArrayAPPLE;

static void APIENTRY _fail_glDrawRangeElementArrayAPPLE(GLenum mode, GLuint start, GLuint end, GLint first, GLsizei count) {
    const char *_name = "glDrawRangeElementArrayAPPLE";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glDrawRangeElementArrayAPPLE(GLenum mode, GLuint start, GLuint end, GLint first, GLsizei count) {
    PFN_GLDRAWRANGEELEMENTARRAYAPPLE _ptr;
    _ptr = (PFN_GLDRAWRANGEELEMENTARRAYAPPLE)_getPrivateProcAddress("glDrawRangeElementArrayAPPLE");
    if (!_ptr) {
        _ptr = &_fail_glDrawRangeElementArrayAPPLE;
    }
    _glDrawRangeElementArrayAPPLE = _ptr;
    _glDrawRangeElementArrayAPPLE(mode, start, end, first, count);
}

PFN_GLDRAWRANGEELEMENTARRAYAPPLE _glDrawRangeElementArrayAPPLE = &_get_glDrawRangeElementArrayAPPLE;

static void APIENTRY _fail_glMultiDrawElementArrayAPPLE(GLenum mode, const GLint * first, const GLsizei * count, GLsizei drawcount) {
    const char *_name = "glMultiDrawElementArrayAPPLE";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glMultiDrawElementArrayAPPLE(GLenum mode, const GLint * first, const GLsizei * count, GLsizei drawcount) {
    PFN_GLMULTIDRAWELEMENTARRAYAPPLE _ptr;
    _ptr = (PFN_GLMULTIDRAWELEMENTARRAYAPPLE)_getPrivateProcAddress("glMultiDrawElementArrayAPPLE");
    if (!_ptr) {
        _ptr = &_fail_glMultiDrawElementArrayAPPLE;
    }
    _glMultiDrawElementArrayAPPLE = _ptr;
    _glMultiDrawElementArrayAPPLE(mode, first, count, drawcount);
}

PFN_GLMULTIDRAWELEMENTARRAYAPPLE _glMultiDrawElementArrayAPPLE = &_get_glMultiDrawElementArrayAPPLE;

static void APIENTRY _fail_glMultiDrawRangeElementArrayAPPLE(GLenum mode, GLuint start, GLuint end, const GLint * first, const GLsizei * count, GLsizei drawcount) {
    const char *_name = "glMultiDrawRangeElementArrayAPPLE";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glMultiDrawRangeElementArrayAPPLE(GLenum mode, GLuint start, GLuint end, const GLint * first, const GLsizei * count, GLsizei drawcount) {
    PFN_GLMULTIDRAWRANGEELEMENTARRAYAPPLE _ptr;
    _ptr = (PFN_GLMULTIDRAWRANGEELEMENTARRAYAPPLE)_getPrivateProcAddress("glMultiDrawRangeElementArrayAPPLE");
    if (!_ptr) {
        _ptr = &_fail_glMultiDrawRangeElementArrayAPPLE;
    }
    _glMultiDrawRangeElementArrayAPPLE = _ptr;
    _glMultiDrawRangeElementArrayAPPLE(mode, start, end, first, count, drawcount);
}

PFN_GLMULTIDRAWRANGEELEMENTARRAYAPPLE _glMultiDrawRangeElementArrayAPPLE = &_get_glMultiDrawRangeElementArrayAPPLE;

static void APIENTRY _fail_glGenFencesAPPLE(GLsizei n, GLuint * fences) {
    const char *_name = "glGenFencesAPPLE";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGenFencesAPPLE(GLsizei n, GLuint * fences) {
    PFN_GLGENFENCESAPPLE _ptr;
    _ptr = (PFN_GLGENFENCESAPPLE)_getPrivateProcAddress("glGenFencesAPPLE");
    if (!_ptr) {
        _ptr = &_fail_glGenFencesAPPLE;
    }
    _glGenFencesAPPLE = _ptr;
    _glGenFencesAPPLE(n, fences);
}

PFN_GLGENFENCESAPPLE _glGenFencesAPPLE = &_get_glGenFencesAPPLE;

static void APIENTRY _fail_glDeleteFencesAPPLE(GLsizei n, const GLuint * fences) {
    const char *_name = "glDeleteFencesAPPLE";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glDeleteFencesAPPLE(GLsizei n, const GLuint * fences) {
    PFN_GLDELETEFENCESAPPLE _ptr;
    _ptr = (PFN_GLDELETEFENCESAPPLE)_getPrivateProcAddress("glDeleteFencesAPPLE");
    if (!_ptr) {
        _ptr = &_fail_glDeleteFencesAPPLE;
    }
    _glDeleteFencesAPPLE = _ptr;
    _glDeleteFencesAPPLE(n, fences);
}

PFN_GLDELETEFENCESAPPLE _glDeleteFencesAPPLE = &_get_glDeleteFencesAPPLE;

static void APIENTRY _fail_glSetFenceAPPLE(GLuint fence) {
    const char *_name = "glSetFenceAPPLE";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glSetFenceAPPLE(GLuint fence) {
    PFN_GLSETFENCEAPPLE _ptr;
    _ptr = (PFN_GLSETFENCEAPPLE)_getPrivateProcAddress("glSetFenceAPPLE");
    if (!_ptr) {
        _ptr = &_fail_glSetFenceAPPLE;
    }
    _glSetFenceAPPLE = _ptr;
    _glSetFenceAPPLE(fence);
}

PFN_GLSETFENCEAPPLE _glSetFenceAPPLE = &_get_glSetFenceAPPLE;

static GLboolean APIENTRY _fail_glIsFenceAPPLE(GLuint fence) {
    const char *_name = "glIsFenceAPPLE";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static GLboolean APIENTRY _get_glIsFenceAPPLE(GLuint fence) {
    PFN_GLISFENCEAPPLE _ptr;
    _ptr = (PFN_GLISFENCEAPPLE)_getPrivateProcAddress("glIsFenceAPPLE");
    if (!_ptr) {
        _ptr = &_fail_glIsFenceAPPLE;
    }
    _glIsFenceAPPLE = _ptr;
    return _glIsFenceAPPLE(fence);
}

PFN_GLISFENCEAPPLE _glIsFenceAPPLE = &_get_glIsFenceAPPLE;

static GLboolean APIENTRY _fail_glTestFenceAPPLE(GLuint fence) {
    const char *_name = "glTestFenceAPPLE";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static GLboolean APIENTRY _get_glTestFenceAPPLE(GLuint fence) {
    PFN_GLTESTFENCEAPPLE _ptr;
    _ptr = (PFN_GLTESTFENCEAPPLE)_getPrivateProcAddress("glTestFenceAPPLE");
    if (!_ptr) {
        _ptr = &_fail_glTestFenceAPPLE;
    }
    _glTestFenceAPPLE = _ptr;
    return _glTestFenceAPPLE(fence);
}

PFN_GLTESTFENCEAPPLE _glTestFenceAPPLE = &_get_glTestFenceAPPLE;

static void APIENTRY _fail_glFinishFenceAPPLE(GLuint fence) {
    const char *_name = "glFinishFenceAPPLE";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glFinishFenceAPPLE(GLuint fence) {
    PFN_GLFINISHFENCEAPPLE _ptr;
    _ptr = (PFN_GLFINISHFENCEAPPLE)_getPrivateProcAddress("glFinishFenceAPPLE");
    if (!_ptr) {
        _ptr = &_fail_glFinishFenceAPPLE;
    }
    _glFinishFenceAPPLE = _ptr;
    _glFinishFenceAPPLE(fence);
}

PFN_GLFINISHFENCEAPPLE _glFinishFenceAPPLE = &_get_glFinishFenceAPPLE;

static GLboolean APIENTRY _fail_glTestObjectAPPLE(GLenum object, GLuint name) {
    const char *_name = "glTestObjectAPPLE";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static GLboolean APIENTRY _get_glTestObjectAPPLE(GLenum object, GLuint name) {
    PFN_GLTESTOBJECTAPPLE _ptr;
    _ptr = (PFN_GLTESTOBJECTAPPLE)_getPrivateProcAddress("glTestObjectAPPLE");
    if (!_ptr) {
        _ptr = &_fail_glTestObjectAPPLE;
    }
    _glTestObjectAPPLE = _ptr;
    return _glTestObjectAPPLE(object, name);
}

PFN_GLTESTOBJECTAPPLE _glTestObjectAPPLE = &_get_glTestObjectAPPLE;

static void APIENTRY _fail_glFinishObjectAPPLE(GLenum object, GLint name) {
    const char *_name = "glFinishObjectAPPLE";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glFinishObjectAPPLE(GLenum object, GLint name) {
    PFN_GLFINISHOBJECTAPPLE _ptr;
    _ptr = (PFN_GLFINISHOBJECTAPPLE)_getPrivateProcAddress("glFinishObjectAPPLE");
    if (!_ptr) {
        _ptr = &_fail_glFinishObjectAPPLE;
    }
    _glFinishObjectAPPLE = _ptr;
    _glFinishObjectAPPLE(object, name);
}

PFN_GLFINISHOBJECTAPPLE _glFinishObjectAPPLE = &_get_glFinishObjectAPPLE;

static void APIENTRY _fail_glBufferParameteriAPPLE(GLenum target, GLenum pname, GLint param) {
    const char *_name = "glBufferParameteriAPPLE";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glBufferParameteriAPPLE(GLenum target, GLenum pname, GLint param) {
    PFN_GLBUFFERPARAMETERIAPPLE _ptr;
    _ptr = (PFN_GLBUFFERPARAMETERIAPPLE)_getPrivateProcAddress("glBufferParameteriAPPLE");
    if (!_ptr) {
        _ptr = &_fail_glBufferParameteriAPPLE;
    }
    _glBufferParameteriAPPLE = _ptr;
    _glBufferParameteriAPPLE(target, pname, param);
}

PFN_GLBUFFERPARAMETERIAPPLE _glBufferParameteriAPPLE = &_get_glBufferParameteriAPPLE;

static void APIENTRY _fail_glFlushMappedBufferRangeAPPLE(GLenum target, GLintptr offset, GLsizeiptr size) {
    const char *_name = "glFlushMappedBufferRangeAPPLE";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glFlushMappedBufferRangeAPPLE(GLenum target, GLintptr offset, GLsizeiptr size) {
    PFN_GLFLUSHMAPPEDBUFFERRANGEAPPLE _ptr;
    _ptr = (PFN_GLFLUSHMAPPEDBUFFERRANGEAPPLE)_getPrivateProcAddress("glFlushMappedBufferRangeAPPLE");
    if (!_ptr) {
        _ptr = &_fail_glFlushMappedBufferRangeAPPLE;
    }
    _glFlushMappedBufferRangeAPPLE = _ptr;
    _glFlushMappedBufferRangeAPPLE(target, offset, size);
}

PFN_GLFLUSHMAPPEDBUFFERRANGEAPPLE _glFlushMappedBufferRangeAPPLE = &_get_glFlushMappedBufferRangeAPPLE;

static void APIENTRY _fail_glFlushRenderAPPLE(void) {
    const char *_name = "glFlushRenderAPPLE";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glFlushRenderAPPLE(void) {
    PFN_GLFLUSHRENDERAPPLE _ptr;
    _ptr = (PFN_GLFLUSHRENDERAPPLE)_getPrivateProcAddress("glFlushRenderAPPLE");
    if (!_ptr) {
        _ptr = &_fail_glFlushRenderAPPLE;
    }
    _glFlushRenderAPPLE = _ptr;
    _glFlushRenderAPPLE();
}

PFN_GLFLUSHRENDERAPPLE _glFlushRenderAPPLE = &_get_glFlushRenderAPPLE;

static void APIENTRY _fail_glFinishRenderAPPLE(void) {
    const char *_name = "glFinishRenderAPPLE";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glFinishRenderAPPLE(void) {
    PFN_GLFINISHRENDERAPPLE _ptr;
    _ptr = (PFN_GLFINISHRENDERAPPLE)_getPrivateProcAddress("glFinishRenderAPPLE");
    if (!_ptr) {
        _ptr = &_fail_glFinishRenderAPPLE;
    }
    _glFinishRenderAPPLE = _ptr;
    _glFinishRenderAPPLE();
}

PFN_GLFINISHRENDERAPPLE _glFinishRenderAPPLE = &_get_glFinishRenderAPPLE;

static void APIENTRY _fail_glSwapAPPLE(void) {
    const char *_name = "glSwapAPPLE";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glSwapAPPLE(void) {
    PFN_GLSWAPAPPLE _ptr;
    _ptr = (PFN_GLSWAPAPPLE)_getPrivateProcAddress("glSwapAPPLE");
    if (!_ptr) {
        _ptr = &_fail_glSwapAPPLE;
    }
    _glSwapAPPLE = _ptr;
    _glSwapAPPLE();
}

PFN_GLSWAPAPPLE _glSwapAPPLE = &_get_glSwapAPPLE;

static void APIENTRY _fail_glRenderbufferStorageMultisampleAPPLE(GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height) {
    const char *_name = "glRenderbufferStorageMultisampleAPPLE";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glRenderbufferStorageMultisampleAPPLE(GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height) {
    PFN_GLRENDERBUFFERSTORAGEMULTISAMPLEAPPLE _ptr;
    _ptr = (PFN_GLRENDERBUFFERSTORAGEMULTISAMPLEAPPLE)_getPrivateProcAddress("glRenderbufferStorageMultisampleAPPLE");
    if (!_ptr) {
        _ptr = &_fail_glRenderbufferStorageMultisampleAPPLE;
    }
    _glRenderbufferStorageMultisampleAPPLE = _ptr;
    _glRenderbufferStorageMultisampleAPPLE(target, samples, internalformat, width, height);
}

PFN_GLRENDERBUFFERSTORAGEMULTISAMPLEAPPLE _glRenderbufferStorageMultisampleAPPLE = &_get_glRenderbufferStorageMultisampleAPPLE;

static void APIENTRY _fail_glResolveMultisampleFramebufferAPPLE(void) {
    const char *_name = "glResolveMultisampleFramebufferAPPLE";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glResolveMultisampleFramebufferAPPLE(void) {
    PFN_GLRESOLVEMULTISAMPLEFRAMEBUFFERAPPLE _ptr;
    _ptr = (PFN_GLRESOLVEMULTISAMPLEFRAMEBUFFERAPPLE)_getPrivateProcAddress("glResolveMultisampleFramebufferAPPLE");
    if (!_ptr) {
        _ptr = &_fail_glResolveMultisampleFramebufferAPPLE;
    }
    _glResolveMultisampleFramebufferAPPLE = _ptr;
    _glResolveMultisampleFramebufferAPPLE();
}

PFN_GLRESOLVEMULTISAMPLEFRAMEBUFFERAPPLE _glResolveMultisampleFramebufferAPPLE = &_get_glResolveMultisampleFramebufferAPPLE;

static GLenum APIENTRY _fail_glObjectPurgeableAPPLE(GLenum objectType, GLuint name, GLenum option) {
    const char *_name = "glObjectPurgeableAPPLE";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static GLenum APIENTRY _get_glObjectPurgeableAPPLE(GLenum objectType, GLuint name, GLenum option) {
    PFN_GLOBJECTPURGEABLEAPPLE _ptr;
    _ptr = (PFN_GLOBJECTPURGEABLEAPPLE)_getPrivateProcAddress("glObjectPurgeableAPPLE");
    if (!_ptr) {
        _ptr = &_fail_glObjectPurgeableAPPLE;
    }
    _glObjectPurgeableAPPLE = _ptr;
    return _glObjectPurgeableAPPLE(objectType, name, option);
}

PFN_GLOBJECTPURGEABLEAPPLE _glObjectPurgeableAPPLE = &_get_glObjectPurgeableAPPLE;

static GLenum APIENTRY _fail_glObjectUnpurgeableAPPLE(GLenum objectType, GLuint name, GLenum option) {
    const char *_name = "glObjectUnpurgeableAPPLE";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static GLenum APIENTRY _get_glObjectUnpurgeableAPPLE(GLenum objectType, GLuint name, GLenum option) {
    PFN_GLOBJECTUNPURGEABLEAPPLE _ptr;
    _ptr = (PFN_GLOBJECTUNPURGEABLEAPPLE)_getPrivateProcAddress("glObjectUnpurgeableAPPLE");
    if (!_ptr) {
        _ptr = &_fail_glObjectUnpurgeableAPPLE;
    }
    _glObjectUnpurgeableAPPLE = _ptr;
    return _glObjectUnpurgeableAPPLE(objectType, name, option);
}

PFN_GLOBJECTUNPURGEABLEAPPLE _glObjectUnpurgeableAPPLE = &_get_glObjectUnpurgeableAPPLE;

static void APIENTRY _fail_glGetObjectParameterivAPPLE(GLenum objectType, GLuint name, GLenum pname, GLint * params) {
    const char *_name = "glGetObjectParameterivAPPLE";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetObjectParameterivAPPLE(GLenum objectType, GLuint name, GLenum pname, GLint * params) {
    PFN_GLGETOBJECTPARAMETERIVAPPLE _ptr;
    _ptr = (PFN_GLGETOBJECTPARAMETERIVAPPLE)_getPrivateProcAddress("glGetObjectParameterivAPPLE");
    if (!_ptr) {
        _ptr = &_fail_glGetObjectParameterivAPPLE;
    }
    _glGetObjectParameterivAPPLE = _ptr;
    _glGetObjectParameterivAPPLE(objectType, name, pname, params);
}

PFN_GLGETOBJECTPARAMETERIVAPPLE _glGetObjectParameterivAPPLE = &_get_glGetObjectParameterivAPPLE;

static void APIENTRY _fail_glPointSizePointerAPPLE(GLenum type, GLsizei stride, const GLvoid * pointer) {
    const char *_name = "glPointSizePointerAPPLE";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glPointSizePointerAPPLE(GLenum type, GLsizei stride, const GLvoid * pointer) {
    PFN_GLPOINTSIZEPOINTERAPPLE _ptr;
    _ptr = (PFN_GLPOINTSIZEPOINTERAPPLE)_getPrivateProcAddress("glPointSizePointerAPPLE");
    if (!_ptr) {
        _ptr = &_fail_glPointSizePointerAPPLE;
    }
    _glPointSizePointerAPPLE = _ptr;
    _glPointSizePointerAPPLE(type, stride, pointer);
}

PFN_GLPOINTSIZEPOINTERAPPLE _glPointSizePointerAPPLE = &_get_glPointSizePointerAPPLE;

static void APIENTRY _fail_glVertexPointSizefAPPLE(GLfloat size) {
    const char *_name = "glVertexPointSizefAPPLE";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glVertexPointSizefAPPLE(GLfloat size) {
    PFN_GLVERTEXPOINTSIZEFAPPLE _ptr;
    _ptr = (PFN_GLVERTEXPOINTSIZEFAPPLE)_getPrivateProcAddress("glVertexPointSizefAPPLE");
    if (!_ptr) {
        _ptr = &_fail_glVertexPointSizefAPPLE;
    }
    _glVertexPointSizefAPPLE = _ptr;
    _glVertexPointSizefAPPLE(size);
}

PFN_GLVERTEXPOINTSIZEFAPPLE _glVertexPointSizefAPPLE = &_get_glVertexPointSizefAPPLE;

static GLsync APIENTRY _fail_glFenceSyncAPPLE(GLenum condition, GLbitfield flags) {
    const char *_name = "glFenceSyncAPPLE";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static GLsync APIENTRY _get_glFenceSyncAPPLE(GLenum condition, GLbitfield flags) {
    PFN_GLFENCESYNCAPPLE _ptr;
    _ptr = (PFN_GLFENCESYNCAPPLE)_getPrivateProcAddress("glFenceSyncAPPLE");
    if (!_ptr) {
        _ptr = &_fail_glFenceSyncAPPLE;
    }
    _glFenceSyncAPPLE = _ptr;
    return _glFenceSyncAPPLE(condition, flags);
}

PFN_GLFENCESYNCAPPLE _glFenceSyncAPPLE = &_get_glFenceSyncAPPLE;

static GLboolean APIENTRY _fail_glIsSyncAPPLE(GLsync sync) {
    const char *_name = "glIsSyncAPPLE";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static GLboolean APIENTRY _get_glIsSyncAPPLE(GLsync sync) {
    PFN_GLISSYNCAPPLE _ptr;
    _ptr = (PFN_GLISSYNCAPPLE)_getPrivateProcAddress("glIsSyncAPPLE");
    if (!_ptr) {
        _ptr = &_fail_glIsSyncAPPLE;
    }
    _glIsSyncAPPLE = _ptr;
    return _glIsSyncAPPLE(sync);
}

PFN_GLISSYNCAPPLE _glIsSyncAPPLE = &_get_glIsSyncAPPLE;

static void APIENTRY _fail_glDeleteSyncAPPLE(GLsync sync) {
    const char *_name = "glDeleteSyncAPPLE";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glDeleteSyncAPPLE(GLsync sync) {
    PFN_GLDELETESYNCAPPLE _ptr;
    _ptr = (PFN_GLDELETESYNCAPPLE)_getPrivateProcAddress("glDeleteSyncAPPLE");
    if (!_ptr) {
        _ptr = &_fail_glDeleteSyncAPPLE;
    }
    _glDeleteSyncAPPLE = _ptr;
    _glDeleteSyncAPPLE(sync);
}

PFN_GLDELETESYNCAPPLE _glDeleteSyncAPPLE = &_get_glDeleteSyncAPPLE;

static GLenum APIENTRY _fail_glClientWaitSyncAPPLE(GLsync sync, GLbitfield flags, GLuint64 timeout) {
    const char *_name = "glClientWaitSyncAPPLE";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static GLenum APIENTRY _get_glClientWaitSyncAPPLE(GLsync sync, GLbitfield flags, GLuint64 timeout) {
    PFN_GLCLIENTWAITSYNCAPPLE _ptr;
    _ptr = (PFN_GLCLIENTWAITSYNCAPPLE)_getPrivateProcAddress("glClientWaitSyncAPPLE");
    if (!_ptr) {
        _ptr = &_fail_glClientWaitSyncAPPLE;
    }
    _glClientWaitSyncAPPLE = _ptr;
    return _glClientWaitSyncAPPLE(sync, flags, timeout);
}

PFN_GLCLIENTWAITSYNCAPPLE _glClientWaitSyncAPPLE = &_get_glClientWaitSyncAPPLE;

static void APIENTRY _fail_glWaitSyncAPPLE(GLsync sync, GLbitfield flags, GLuint64 timeout) {
    const char *_name = "glWaitSyncAPPLE";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glWaitSyncAPPLE(GLsync sync, GLbitfield flags, GLuint64 timeout) {
    PFN_GLWAITSYNCAPPLE _ptr;
    _ptr = (PFN_GLWAITSYNCAPPLE)_getPrivateProcAddress("glWaitSyncAPPLE");
    if (!_ptr) {
        _ptr = &_fail_glWaitSyncAPPLE;
    }
    _glWaitSyncAPPLE = _ptr;
    _glWaitSyncAPPLE(sync, flags, timeout);
}

PFN_GLWAITSYNCAPPLE _glWaitSyncAPPLE = &_get_glWaitSyncAPPLE;

static void APIENTRY _fail_glGetInteger64vAPPLE(GLenum pname, GLint64 * params) {
    const char *_name = "glGetInteger64vAPPLE";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetInteger64vAPPLE(GLenum pname, GLint64 * params) {
    PFN_GLGETINTEGER64VAPPLE _ptr;
    _ptr = (PFN_GLGETINTEGER64VAPPLE)_getPrivateProcAddress("glGetInteger64vAPPLE");
    if (!_ptr) {
        _ptr = &_fail_glGetInteger64vAPPLE;
    }
    _glGetInteger64vAPPLE = _ptr;
    _glGetInteger64vAPPLE(pname, params);
}

PFN_GLGETINTEGER64VAPPLE _glGetInteger64vAPPLE = &_get_glGetInteger64vAPPLE;

static void APIENTRY _fail_glGetSyncivAPPLE(GLsync sync, GLenum pname, GLsizei bufSize, GLsizei * length, GLint * values) {
    const char *_name = "glGetSyncivAPPLE";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetSyncivAPPLE(GLsync sync, GLenum pname, GLsizei bufSize, GLsizei * length, GLint * values) {
    PFN_GLGETSYNCIVAPPLE _ptr;
    _ptr = (PFN_GLGETSYNCIVAPPLE)_getPrivateProcAddress("glGetSyncivAPPLE");
    if (!_ptr) {
        _ptr = &_fail_glGetSyncivAPPLE;
    }
    _glGetSyncivAPPLE = _ptr;
    _glGetSyncivAPPLE(sync, pname, bufSize, length, values);
}

PFN_GLGETSYNCIVAPPLE _glGetSyncivAPPLE = &_get_glGetSyncivAPPLE;

static void APIENTRY _fail_glTextureRangeAPPLE(GLenum target, GLsizei length, const GLvoid * pointer) {
    const char *_name = "glTextureRangeAPPLE";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glTextureRangeAPPLE(GLenum target, GLsizei length, const GLvoid * pointer) {
    PFN_GLTEXTURERANGEAPPLE _ptr;
    _ptr = (PFN_GLTEXTURERANGEAPPLE)_getPrivateProcAddress("glTextureRangeAPPLE");
    if (!_ptr) {
        _ptr = &_fail_glTextureRangeAPPLE;
    }
    _glTextureRangeAPPLE = _ptr;
    _glTextureRangeAPPLE(target, length, pointer);
}

PFN_GLTEXTURERANGEAPPLE _glTextureRangeAPPLE = &_get_glTextureRangeAPPLE;

static void APIENTRY _fail_glGetTexParameterPointervAPPLE(GLenum target, GLenum pname, GLvoid * * params) {
    const char *_name = "glGetTexParameterPointervAPPLE";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetTexParameterPointervAPPLE(GLenum target, GLenum pname, GLvoid * * params) {
    PFN_GLGETTEXPARAMETERPOINTERVAPPLE _ptr;
    _ptr = (PFN_GLGETTEXPARAMETERPOINTERVAPPLE)_getPrivateProcAddress("glGetTexParameterPointervAPPLE");
    if (!_ptr) {
        _ptr = &_fail_glGetTexParameterPointervAPPLE;
    }
    _glGetTexParameterPointervAPPLE = _ptr;
    _glGetTexParameterPointervAPPLE(target, pname, params);
}

PFN_GLGETTEXPARAMETERPOINTERVAPPLE _glGetTexParameterPointervAPPLE = &_get_glGetTexParameterPointervAPPLE;

static void APIENTRY _fail_glBindVertexArrayAPPLE(GLuint array) {
    const char *_name = "glBindVertexArrayAPPLE";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glBindVertexArrayAPPLE(GLuint array) {
    PFN_GLBINDVERTEXARRAYAPPLE _ptr;
    _ptr = (PFN_GLBINDVERTEXARRAYAPPLE)_getPrivateProcAddress("glBindVertexArrayAPPLE");
    if (!_ptr) {
        _ptr = &_fail_glBindVertexArrayAPPLE;
    }
    _glBindVertexArrayAPPLE = _ptr;
    _glBindVertexArrayAPPLE(array);
}

PFN_GLBINDVERTEXARRAYAPPLE _glBindVertexArrayAPPLE = &_get_glBindVertexArrayAPPLE;

static void APIENTRY _fail_glDeleteVertexArraysAPPLE(GLsizei n, const GLuint * arrays) {
    const char *_name = "glDeleteVertexArraysAPPLE";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glDeleteVertexArraysAPPLE(GLsizei n, const GLuint * arrays) {
    PFN_GLDELETEVERTEXARRAYSAPPLE _ptr;
    _ptr = (PFN_GLDELETEVERTEXARRAYSAPPLE)_getPrivateProcAddress("glDeleteVertexArraysAPPLE");
    if (!_ptr) {
        _ptr = &_fail_glDeleteVertexArraysAPPLE;
    }
    _glDeleteVertexArraysAPPLE = _ptr;
    _glDeleteVertexArraysAPPLE(n, arrays);
}

PFN_GLDELETEVERTEXARRAYSAPPLE _glDeleteVertexArraysAPPLE = &_get_glDeleteVertexArraysAPPLE;

static void APIENTRY _fail_glGenVertexArraysAPPLE(GLsizei n, GLuint * arrays) {
    const char *_name = "glGenVertexArraysAPPLE";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGenVertexArraysAPPLE(GLsizei n, GLuint * arrays) {
    PFN_GLGENVERTEXARRAYSAPPLE _ptr;
    _ptr = (PFN_GLGENVERTEXARRAYSAPPLE)_getPrivateProcAddress("glGenVertexArraysAPPLE");
    if (!_ptr) {
        _ptr = &_fail_glGenVertexArraysAPPLE;
    }
    _glGenVertexArraysAPPLE = _ptr;
    _glGenVertexArraysAPPLE(n, arrays);
}

PFN_GLGENVERTEXARRAYSAPPLE _glGenVertexArraysAPPLE = &_get_glGenVertexArraysAPPLE;

static GLboolean APIENTRY _fail_glIsVertexArrayAPPLE(GLuint array) {
    const char *_name = "glIsVertexArrayAPPLE";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static GLboolean APIENTRY _get_glIsVertexArrayAPPLE(GLuint array) {
    PFN_GLISVERTEXARRAYAPPLE _ptr;
    _ptr = (PFN_GLISVERTEXARRAYAPPLE)_getPrivateProcAddress("glIsVertexArrayAPPLE");
    if (!_ptr) {
        _ptr = &_fail_glIsVertexArrayAPPLE;
    }
    _glIsVertexArrayAPPLE = _ptr;
    return _glIsVertexArrayAPPLE(array);
}

PFN_GLISVERTEXARRAYAPPLE _glIsVertexArrayAPPLE = &_get_glIsVertexArrayAPPLE;

static void APIENTRY _fail_glVertexArrayRangeAPPLE(GLsizei length, GLvoid * pointer) {
    const char *_name = "glVertexArrayRangeAPPLE";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glVertexArrayRangeAPPLE(GLsizei length, GLvoid * pointer) {
    PFN_GLVERTEXARRAYRANGEAPPLE _ptr;
    _ptr = (PFN_GLVERTEXARRAYRANGEAPPLE)_getPrivateProcAddress("glVertexArrayRangeAPPLE");
    if (!_ptr) {
        _ptr = &_fail_glVertexArrayRangeAPPLE;
    }
    _glVertexArrayRangeAPPLE = _ptr;
    _glVertexArrayRangeAPPLE(length, pointer);
}

PFN_GLVERTEXARRAYRANGEAPPLE _glVertexArrayRangeAPPLE = &_get_glVertexArrayRangeAPPLE;

static void APIENTRY _fail_glFlushVertexArrayRangeAPPLE(GLsizei length, GLvoid * pointer) {
    const char *_name = "glFlushVertexArrayRangeAPPLE";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glFlushVertexArrayRangeAPPLE(GLsizei length, GLvoid * pointer) {
    PFN_GLFLUSHVERTEXARRAYRANGEAPPLE _ptr;
    _ptr = (PFN_GLFLUSHVERTEXARRAYRANGEAPPLE)_getPrivateProcAddress("glFlushVertexArrayRangeAPPLE");
    if (!_ptr) {
        _ptr = &_fail_glFlushVertexArrayRangeAPPLE;
    }
    _glFlushVertexArrayRangeAPPLE = _ptr;
    _glFlushVertexArrayRangeAPPLE(length, pointer);
}

PFN_GLFLUSHVERTEXARRAYRANGEAPPLE _glFlushVertexArrayRangeAPPLE = &_get_glFlushVertexArrayRangeAPPLE;

static void APIENTRY _fail_glVertexArrayParameteriAPPLE(GLenum pname, GLint param) {
    const char *_name = "glVertexArrayParameteriAPPLE";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glVertexArrayParameteriAPPLE(GLenum pname, GLint param) {
    PFN_GLVERTEXARRAYPARAMETERIAPPLE _ptr;
    _ptr = (PFN_GLVERTEXARRAYPARAMETERIAPPLE)_getPrivateProcAddress("glVertexArrayParameteriAPPLE");
    if (!_ptr) {
        _ptr = &_fail_glVertexArrayParameteriAPPLE;
    }
    _glVertexArrayParameteriAPPLE = _ptr;
    _glVertexArrayParameteriAPPLE(pname, param);
}

PFN_GLVERTEXARRAYPARAMETERIAPPLE _glVertexArrayParameteriAPPLE = &_get_glVertexArrayParameteriAPPLE;

static void APIENTRY _fail_glEnableVertexAttribAPPLE(GLuint index, GLenum pname) {
    const char *_name = "glEnableVertexAttribAPPLE";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glEnableVertexAttribAPPLE(GLuint index, GLenum pname) {
    PFN_GLENABLEVERTEXATTRIBAPPLE _ptr;
    _ptr = (PFN_GLENABLEVERTEXATTRIBAPPLE)_getPrivateProcAddress("glEnableVertexAttribAPPLE");
    if (!_ptr) {
        _ptr = &_fail_glEnableVertexAttribAPPLE;
    }
    _glEnableVertexAttribAPPLE = _ptr;
    _glEnableVertexAttribAPPLE(index, pname);
}

PFN_GLENABLEVERTEXATTRIBAPPLE _glEnableVertexAttribAPPLE = &_get_glEnableVertexAttribAPPLE;

static void APIENTRY _fail_glDisableVertexAttribAPPLE(GLuint index, GLenum pname) {
    const char *_name = "glDisableVertexAttribAPPLE";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glDisableVertexAttribAPPLE(GLuint index, GLenum pname) {
    PFN_GLDISABLEVERTEXATTRIBAPPLE _ptr;
    _ptr = (PFN_GLDISABLEVERTEXATTRIBAPPLE)_getPrivateProcAddress("glDisableVertexAttribAPPLE");
    if (!_ptr) {
        _ptr = &_fail_glDisableVertexAttribAPPLE;
    }
    _glDisableVertexAttribAPPLE = _ptr;
    _glDisableVertexAttribAPPLE(index, pname);
}

PFN_GLDISABLEVERTEXATTRIBAPPLE _glDisableVertexAttribAPPLE = &_get_glDisableVertexAttribAPPLE;

static GLboolean APIENTRY _fail_glIsVertexAttribEnabledAPPLE(GLuint index, GLenum pname) {
    const char *_name = "glIsVertexAttribEnabledAPPLE";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static GLboolean APIENTRY _get_glIsVertexAttribEnabledAPPLE(GLuint index, GLenum pname) {
    PFN_GLISVERTEXATTRIBENABLEDAPPLE _ptr;
    _ptr = (PFN_GLISVERTEXATTRIBENABLEDAPPLE)_getPrivateProcAddress("glIsVertexAttribEnabledAPPLE");
    if (!_ptr) {
        _ptr = &_fail_glIsVertexAttribEnabledAPPLE;
    }
    _glIsVertexAttribEnabledAPPLE = _ptr;
    return _glIsVertexAttribEnabledAPPLE(index, pname);
}

PFN_GLISVERTEXATTRIBENABLEDAPPLE _glIsVertexAttribEnabledAPPLE = &_get_glIsVertexAttribEnabledAPPLE;

static void APIENTRY _fail_glMapVertexAttrib1dAPPLE(GLuint index, GLuint size, GLdouble u1, GLdouble u2, GLint stride, GLint order, const GLdouble * points) {
    const char *_name = "glMapVertexAttrib1dAPPLE";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glMapVertexAttrib1dAPPLE(GLuint index, GLuint size, GLdouble u1, GLdouble u2, GLint stride, GLint order, const GLdouble * points) {
    PFN_GLMAPVERTEXATTRIB1DAPPLE _ptr;
    _ptr = (PFN_GLMAPVERTEXATTRIB1DAPPLE)_getPrivateProcAddress("glMapVertexAttrib1dAPPLE");
    if (!_ptr) {
        _ptr = &_fail_glMapVertexAttrib1dAPPLE;
    }
    _glMapVertexAttrib1dAPPLE = _ptr;
    _glMapVertexAttrib1dAPPLE(index, size, u1, u2, stride, order, points);
}

PFN_GLMAPVERTEXATTRIB1DAPPLE _glMapVertexAttrib1dAPPLE = &_get_glMapVertexAttrib1dAPPLE;

static void APIENTRY _fail_glMapVertexAttrib1fAPPLE(GLuint index, GLuint size, GLfloat u1, GLfloat u2, GLint stride, GLint order, const GLfloat * points) {
    const char *_name = "glMapVertexAttrib1fAPPLE";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glMapVertexAttrib1fAPPLE(GLuint index, GLuint size, GLfloat u1, GLfloat u2, GLint stride, GLint order, const GLfloat * points) {
    PFN_GLMAPVERTEXATTRIB1FAPPLE _ptr;
    _ptr = (PFN_GLMAPVERTEXATTRIB1FAPPLE)_getPrivateProcAddress("glMapVertexAttrib1fAPPLE");
    if (!_ptr) {
        _ptr = &_fail_glMapVertexAttrib1fAPPLE;
    }
    _glMapVertexAttrib1fAPPLE = _ptr;
    _glMapVertexAttrib1fAPPLE(index, size, u1, u2, stride, order, points);
}

PFN_GLMAPVERTEXATTRIB1FAPPLE _glMapVertexAttrib1fAPPLE = &_get_glMapVertexAttrib1fAPPLE;

static void APIENTRY _fail_glMapVertexAttrib2dAPPLE(GLuint index, GLuint size, GLdouble u1, GLdouble u2, GLint ustride, GLint uorder, GLdouble v1, GLdouble v2, GLint vstride, GLint vorder, const GLdouble * points) {
    const char *_name = "glMapVertexAttrib2dAPPLE";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glMapVertexAttrib2dAPPLE(GLuint index, GLuint size, GLdouble u1, GLdouble u2, GLint ustride, GLint uorder, GLdouble v1, GLdouble v2, GLint vstride, GLint vorder, const GLdouble * points) {
    PFN_GLMAPVERTEXATTRIB2DAPPLE _ptr;
    _ptr = (PFN_GLMAPVERTEXATTRIB2DAPPLE)_getPrivateProcAddress("glMapVertexAttrib2dAPPLE");
    if (!_ptr) {
        _ptr = &_fail_glMapVertexAttrib2dAPPLE;
    }
    _glMapVertexAttrib2dAPPLE = _ptr;
    _glMapVertexAttrib2dAPPLE(index, size, u1, u2, ustride, uorder, v1, v2, vstride, vorder, points);
}

PFN_GLMAPVERTEXATTRIB2DAPPLE _glMapVertexAttrib2dAPPLE = &_get_glMapVertexAttrib2dAPPLE;

static void APIENTRY _fail_glMapVertexAttrib2fAPPLE(GLuint index, GLuint size, GLfloat u1, GLfloat u2, GLint ustride, GLint uorder, GLfloat v1, GLfloat v2, GLint vstride, GLint vorder, const GLfloat * points) {
    const char *_name = "glMapVertexAttrib2fAPPLE";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glMapVertexAttrib2fAPPLE(GLuint index, GLuint size, GLfloat u1, GLfloat u2, GLint ustride, GLint uorder, GLfloat v1, GLfloat v2, GLint vstride, GLint vorder, const GLfloat * points) {
    PFN_GLMAPVERTEXATTRIB2FAPPLE _ptr;
    _ptr = (PFN_GLMAPVERTEXATTRIB2FAPPLE)_getPrivateProcAddress("glMapVertexAttrib2fAPPLE");
    if (!_ptr) {
        _ptr = &_fail_glMapVertexAttrib2fAPPLE;
    }
    _glMapVertexAttrib2fAPPLE = _ptr;
    _glMapVertexAttrib2fAPPLE(index, size, u1, u2, ustride, uorder, v1, v2, vstride, vorder, points);
}

PFN_GLMAPVERTEXATTRIB2FAPPLE _glMapVertexAttrib2fAPPLE = &_get_glMapVertexAttrib2fAPPLE;

static void APIENTRY _fail_glReleaseShaderCompiler(void) {
    const char *_name = "glReleaseShaderCompiler";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glReleaseShaderCompiler(void) {
    PFN_GLRELEASESHADERCOMPILER _ptr;
    _ptr = (PFN_GLRELEASESHADERCOMPILER)_getPrivateProcAddress("glReleaseShaderCompiler");
    if (!_ptr) {
        _ptr = &_fail_glReleaseShaderCompiler;
    }
    _glReleaseShaderCompiler = _ptr;
    _glReleaseShaderCompiler();
}

PFN_GLRELEASESHADERCOMPILER _glReleaseShaderCompiler = &_get_glReleaseShaderCompiler;

static void APIENTRY _fail_glShaderBinary(GLsizei count, const GLuint * shaders, GLenum binaryformat, const GLvoid * binary, GLsizei length) {
    const char *_name = "glShaderBinary";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glShaderBinary(GLsizei count, const GLuint * shaders, GLenum binaryformat, const GLvoid * binary, GLsizei length) {
    PFN_GLSHADERBINARY _ptr;
    _ptr = (PFN_GLSHADERBINARY)_getPrivateProcAddress("glShaderBinary");
    if (!_ptr) {
        _ptr = &_fail_glShaderBinary;
    }
    _glShaderBinary = _ptr;
    _glShaderBinary(count, shaders, binaryformat, binary, length);
}

PFN_GLSHADERBINARY _glShaderBinary = &_get_glShaderBinary;

static void APIENTRY _fail_glGetShaderPrecisionFormat(GLenum shadertype, GLenum precisiontype, GLint * range, GLint * precision) {
    const char *_name = "glGetShaderPrecisionFormat";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetShaderPrecisionFormat(GLenum shadertype, GLenum precisiontype, GLint * range, GLint * precision) {
    PFN_GLGETSHADERPRECISIONFORMAT _ptr;
    _ptr = (PFN_GLGETSHADERPRECISIONFORMAT)_getPrivateProcAddress("glGetShaderPrecisionFormat");
    if (!_ptr) {
        _ptr = &_fail_glGetShaderPrecisionFormat;
    }
    _glGetShaderPrecisionFormat = _ptr;
    _glGetShaderPrecisionFormat(shadertype, precisiontype, range, precision);
}

PFN_GLGETSHADERPRECISIONFORMAT _glGetShaderPrecisionFormat = &_get_glGetShaderPrecisionFormat;

static void APIENTRY _fail_glDepthRangef(GLfloat n, GLfloat f) {
    const char *_name = "glDepthRangef";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glDepthRangef(GLfloat n, GLfloat f) {
    PFN_GLDEPTHRANGEF _ptr;
    _ptr = (PFN_GLDEPTHRANGEF)_getPrivateProcAddress("glDepthRangef");
    if (!_ptr) {
        _ptr = &_fail_glDepthRangef;
    }
    _glDepthRangef = _ptr;
    _glDepthRangef(n, f);
}

PFN_GLDEPTHRANGEF _glDepthRangef = &_get_glDepthRangef;

static void APIENTRY _fail_glClearDepthf(GLfloat d) {
    const char *_name = "glClearDepthf";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glClearDepthf(GLfloat d) {
    PFN_GLCLEARDEPTHF _ptr;
    _ptr = (PFN_GLCLEARDEPTHF)_getPrivateProcAddress("glClearDepthf");
    if (!_ptr) {
        _ptr = &_fail_glClearDepthf;
    }
    _glClearDepthf = _ptr;
    _glClearDepthf(d);
}

PFN_GLCLEARDEPTHF _glClearDepthf = &_get_glClearDepthf;

static void APIENTRY _fail_glMemoryBarrierByRegion(GLbitfield barriers) {
    const char *_name = "glMemoryBarrierByRegion";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glMemoryBarrierByRegion(GLbitfield barriers) {
    PFN_GLMEMORYBARRIERBYREGION _ptr;
    _ptr = (PFN_GLMEMORYBARRIERBYREGION)_getPrivateProcAddress("glMemoryBarrierByRegion");
    if (!_ptr) {
        _ptr = &_fail_glMemoryBarrierByRegion;
    }
    _glMemoryBarrierByRegion = _ptr;
    _glMemoryBarrierByRegion(barriers);
}

PFN_GLMEMORYBARRIERBYREGION _glMemoryBarrierByRegion = &_get_glMemoryBarrierByRegion;

static void APIENTRY _fail_glPrimitiveBoundingBoxARB(GLfloat minX, GLfloat minY, GLfloat minZ, GLfloat minW, GLfloat maxX, GLfloat maxY, GLfloat maxZ, GLfloat maxW) {
    const char *_name = "glPrimitiveBoundingBoxARB";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glPrimitiveBoundingBoxARB(GLfloat minX, GLfloat minY, GLfloat minZ, GLfloat minW, GLfloat maxX, GLfloat maxY, GLfloat maxZ, GLfloat maxW) {
    PFN_GLPRIMITIVEBOUNDINGBOXARB _ptr;
    _ptr = (PFN_GLPRIMITIVEBOUNDINGBOXARB)_getPrivateProcAddress("glPrimitiveBoundingBoxARB");
    if (!_ptr) {
        _ptr = &_fail_glPrimitiveBoundingBoxARB;
    }
    _glPrimitiveBoundingBoxARB = _ptr;
    _glPrimitiveBoundingBoxARB(minX, minY, minZ, minW, maxX, maxY, maxZ, maxW);
}

PFN_GLPRIMITIVEBOUNDINGBOXARB _glPrimitiveBoundingBoxARB = &_get_glPrimitiveBoundingBoxARB;

static void APIENTRY _fail_glDrawArraysInstancedBaseInstance(GLenum mode, GLint first, GLsizei count, GLsizei instancecount, GLuint baseinstance) {
    const char *_name = "glDrawArraysInstancedBaseInstance";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glDrawArraysInstancedBaseInstance(GLenum mode, GLint first, GLsizei count, GLsizei instancecount, GLuint baseinstance) {
    PFN_GLDRAWARRAYSINSTANCEDBASEINSTANCE _ptr;
    _ptr = (PFN_GLDRAWARRAYSINSTANCEDBASEINSTANCE)_getPrivateProcAddress("glDrawArraysInstancedBaseInstance");
    if (!_ptr) {
        _ptr = &_fail_glDrawArraysInstancedBaseInstance;
    }
    _glDrawArraysInstancedBaseInstance = _ptr;
    _glDrawArraysInstancedBaseInstance(mode, first, count, instancecount, baseinstance);
}

PFN_GLDRAWARRAYSINSTANCEDBASEINSTANCE _glDrawArraysInstancedBaseInstance = &_get_glDrawArraysInstancedBaseInstance;

static void APIENTRY _fail_glDrawElementsInstancedBaseInstance(GLenum mode, GLsizei count, GLenum type, const GLvoid * indices, GLsizei instancecount, GLuint baseinstance) {
    const char *_name = "glDrawElementsInstancedBaseInstance";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glDrawElementsInstancedBaseInstance(GLenum mode, GLsizei count, GLenum type, const GLvoid * indices, GLsizei instancecount, GLuint baseinstance) {
    PFN_GLDRAWELEMENTSINSTANCEDBASEINSTANCE _ptr;
    _ptr = (PFN_GLDRAWELEMENTSINSTANCEDBASEINSTANCE)_getPrivateProcAddress("glDrawElementsInstancedBaseInstance");
    if (!_ptr) {
        _ptr = &_fail_glDrawElementsInstancedBaseInstance;
    }
    _glDrawElementsInstancedBaseInstance = _ptr;
    _glDrawElementsInstancedBaseInstance(mode, count, type, indices, instancecount, baseinstance);
}

PFN_GLDRAWELEMENTSINSTANCEDBASEINSTANCE _glDrawElementsInstancedBaseInstance = &_get_glDrawElementsInstancedBaseInstance;

static void APIENTRY _fail_glDrawElementsInstancedBaseVertexBaseInstance(GLenum mode, GLsizei count, GLenum type, const GLvoid * indices, GLsizei instancecount, GLint basevertex, GLuint baseinstance) {
    const char *_name = "glDrawElementsInstancedBaseVertexBaseInstance";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glDrawElementsInstancedBaseVertexBaseInstance(GLenum mode, GLsizei count, GLenum type, const GLvoid * indices, GLsizei instancecount, GLint basevertex, GLuint baseinstance) {
    PFN_GLDRAWELEMENTSINSTANCEDBASEVERTEXBASEINSTANCE _ptr;
    _ptr = (PFN_GLDRAWELEMENTSINSTANCEDBASEVERTEXBASEINSTANCE)_getPrivateProcAddress("glDrawElementsInstancedBaseVertexBaseInstance");
    if (!_ptr) {
        _ptr = &_fail_glDrawElementsInstancedBaseVertexBaseInstance;
    }
    _glDrawElementsInstancedBaseVertexBaseInstance = _ptr;
    _glDrawElementsInstancedBaseVertexBaseInstance(mode, count, type, indices, instancecount, basevertex, baseinstance);
}

PFN_GLDRAWELEMENTSINSTANCEDBASEVERTEXBASEINSTANCE _glDrawElementsInstancedBaseVertexBaseInstance = &_get_glDrawElementsInstancedBaseVertexBaseInstance;

static GLuint64 APIENTRY _fail_glGetTextureHandleARB(GLuint texture) {
    const char *_name = "glGetTextureHandleARB";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static GLuint64 APIENTRY _get_glGetTextureHandleARB(GLuint texture) {
    PFN_GLGETTEXTUREHANDLEARB _ptr;
    _ptr = (PFN_GLGETTEXTUREHANDLEARB)_getPrivateProcAddress("glGetTextureHandleARB");
    if (!_ptr) {
        _ptr = &_fail_glGetTextureHandleARB;
    }
    _glGetTextureHandleARB = _ptr;
    return _glGetTextureHandleARB(texture);
}

PFN_GLGETTEXTUREHANDLEARB _glGetTextureHandleARB = &_get_glGetTextureHandleARB;

static GLuint64 APIENTRY _fail_glGetTextureSamplerHandleARB(GLuint texture, GLuint sampler) {
    const char *_name = "glGetTextureSamplerHandleARB";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static GLuint64 APIENTRY _get_glGetTextureSamplerHandleARB(GLuint texture, GLuint sampler) {
    PFN_GLGETTEXTURESAMPLERHANDLEARB _ptr;
    _ptr = (PFN_GLGETTEXTURESAMPLERHANDLEARB)_getPrivateProcAddress("glGetTextureSamplerHandleARB");
    if (!_ptr) {
        _ptr = &_fail_glGetTextureSamplerHandleARB;
    }
    _glGetTextureSamplerHandleARB = _ptr;
    return _glGetTextureSamplerHandleARB(texture, sampler);
}

PFN_GLGETTEXTURESAMPLERHANDLEARB _glGetTextureSamplerHandleARB = &_get_glGetTextureSamplerHandleARB;

static void APIENTRY _fail_glMakeTextureHandleResidentARB(GLuint64 handle) {
    const char *_name = "glMakeTextureHandleResidentARB";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glMakeTextureHandleResidentARB(GLuint64 handle) {
    PFN_GLMAKETEXTUREHANDLERESIDENTARB _ptr;
    _ptr = (PFN_GLMAKETEXTUREHANDLERESIDENTARB)_getPrivateProcAddress("glMakeTextureHandleResidentARB");
    if (!_ptr) {
        _ptr = &_fail_glMakeTextureHandleResidentARB;
    }
    _glMakeTextureHandleResidentARB = _ptr;
    _glMakeTextureHandleResidentARB(handle);
}

PFN_GLMAKETEXTUREHANDLERESIDENTARB _glMakeTextureHandleResidentARB = &_get_glMakeTextureHandleResidentARB;

static void APIENTRY _fail_glMakeTextureHandleNonResidentARB(GLuint64 handle) {
    const char *_name = "glMakeTextureHandleNonResidentARB";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glMakeTextureHandleNonResidentARB(GLuint64 handle) {
    PFN_GLMAKETEXTUREHANDLENONRESIDENTARB _ptr;
    _ptr = (PFN_GLMAKETEXTUREHANDLENONRESIDENTARB)_getPrivateProcAddress("glMakeTextureHandleNonResidentARB");
    if (!_ptr) {
        _ptr = &_fail_glMakeTextureHandleNonResidentARB;
    }
    _glMakeTextureHandleNonResidentARB = _ptr;
    _glMakeTextureHandleNonResidentARB(handle);
}

PFN_GLMAKETEXTUREHANDLENONRESIDENTARB _glMakeTextureHandleNonResidentARB = &_get_glMakeTextureHandleNonResidentARB;

static GLuint64 APIENTRY _fail_glGetImageHandleARB(GLuint texture, GLint level, GLboolean layered, GLint layer, GLenum format) {
    const char *_name = "glGetImageHandleARB";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static GLuint64 APIENTRY _get_glGetImageHandleARB(GLuint texture, GLint level, GLboolean layered, GLint layer, GLenum format) {
    PFN_GLGETIMAGEHANDLEARB _ptr;
    _ptr = (PFN_GLGETIMAGEHANDLEARB)_getPrivateProcAddress("glGetImageHandleARB");
    if (!_ptr) {
        _ptr = &_fail_glGetImageHandleARB;
    }
    _glGetImageHandleARB = _ptr;
    return _glGetImageHandleARB(texture, level, layered, layer, format);
}

PFN_GLGETIMAGEHANDLEARB _glGetImageHandleARB = &_get_glGetImageHandleARB;

static void APIENTRY _fail_glMakeImageHandleResidentARB(GLuint64 handle, GLenum access) {
    const char *_name = "glMakeImageHandleResidentARB";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glMakeImageHandleResidentARB(GLuint64 handle, GLenum access) {
    PFN_GLMAKEIMAGEHANDLERESIDENTARB _ptr;
    _ptr = (PFN_GLMAKEIMAGEHANDLERESIDENTARB)_getPrivateProcAddress("glMakeImageHandleResidentARB");
    if (!_ptr) {
        _ptr = &_fail_glMakeImageHandleResidentARB;
    }
    _glMakeImageHandleResidentARB = _ptr;
    _glMakeImageHandleResidentARB(handle, access);
}

PFN_GLMAKEIMAGEHANDLERESIDENTARB _glMakeImageHandleResidentARB = &_get_glMakeImageHandleResidentARB;

static void APIENTRY _fail_glMakeImageHandleNonResidentARB(GLuint64 handle) {
    const char *_name = "glMakeImageHandleNonResidentARB";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glMakeImageHandleNonResidentARB(GLuint64 handle) {
    PFN_GLMAKEIMAGEHANDLENONRESIDENTARB _ptr;
    _ptr = (PFN_GLMAKEIMAGEHANDLENONRESIDENTARB)_getPrivateProcAddress("glMakeImageHandleNonResidentARB");
    if (!_ptr) {
        _ptr = &_fail_glMakeImageHandleNonResidentARB;
    }
    _glMakeImageHandleNonResidentARB = _ptr;
    _glMakeImageHandleNonResidentARB(handle);
}

PFN_GLMAKEIMAGEHANDLENONRESIDENTARB _glMakeImageHandleNonResidentARB = &_get_glMakeImageHandleNonResidentARB;

static void APIENTRY _fail_glUniformHandleui64ARB(GLint location, GLuint64 value) {
    const char *_name = "glUniformHandleui64ARB";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glUniformHandleui64ARB(GLint location, GLuint64 value) {
    PFN_GLUNIFORMHANDLEUI64ARB _ptr;
    _ptr = (PFN_GLUNIFORMHANDLEUI64ARB)_getPrivateProcAddress("glUniformHandleui64ARB");
    if (!_ptr) {
        _ptr = &_fail_glUniformHandleui64ARB;
    }
    _glUniformHandleui64ARB = _ptr;
    _glUniformHandleui64ARB(location, value);
}

PFN_GLUNIFORMHANDLEUI64ARB _glUniformHandleui64ARB = &_get_glUniformHandleui64ARB;

static void APIENTRY _fail_glUniformHandleui64vARB(GLint location, GLsizei count, const GLuint64 * value) {
    const char *_name = "glUniformHandleui64vARB";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glUniformHandleui64vARB(GLint location, GLsizei count, const GLuint64 * value) {
    PFN_GLUNIFORMHANDLEUI64VARB _ptr;
    _ptr = (PFN_GLUNIFORMHANDLEUI64VARB)_getPrivateProcAddress("glUniformHandleui64vARB");
    if (!_ptr) {
        _ptr = &_fail_glUniformHandleui64vARB;
    }
    _glUniformHandleui64vARB = _ptr;
    _glUniformHandleui64vARB(location, count, value);
}

PFN_GLUNIFORMHANDLEUI64VARB _glUniformHandleui64vARB = &_get_glUniformHandleui64vARB;

static void APIENTRY _fail_glProgramUniformHandleui64ARB(GLuint program, GLint location, GLuint64 value) {
    const char *_name = "glProgramUniformHandleui64ARB";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glProgramUniformHandleui64ARB(GLuint program, GLint location, GLuint64 value) {
    PFN_GLPROGRAMUNIFORMHANDLEUI64ARB _ptr;
    _ptr = (PFN_GLPROGRAMUNIFORMHANDLEUI64ARB)_getPrivateProcAddress("glProgramUniformHandleui64ARB");
    if (!_ptr) {
        _ptr = &_fail_glProgramUniformHandleui64ARB;
    }
    _glProgramUniformHandleui64ARB = _ptr;
    _glProgramUniformHandleui64ARB(program, location, value);
}

PFN_GLPROGRAMUNIFORMHANDLEUI64ARB _glProgramUniformHandleui64ARB = &_get_glProgramUniformHandleui64ARB;

static void APIENTRY _fail_glProgramUniformHandleui64vARB(GLuint program, GLint location, GLsizei count, const GLuint64 * values) {
    const char *_name = "glProgramUniformHandleui64vARB";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glProgramUniformHandleui64vARB(GLuint program, GLint location, GLsizei count, const GLuint64 * values) {
    PFN_GLPROGRAMUNIFORMHANDLEUI64VARB _ptr;
    _ptr = (PFN_GLPROGRAMUNIFORMHANDLEUI64VARB)_getPrivateProcAddress("glProgramUniformHandleui64vARB");
    if (!_ptr) {
        _ptr = &_fail_glProgramUniformHandleui64vARB;
    }
    _glProgramUniformHandleui64vARB = _ptr;
    _glProgramUniformHandleui64vARB(program, location, count, values);
}

PFN_GLPROGRAMUNIFORMHANDLEUI64VARB _glProgramUniformHandleui64vARB = &_get_glProgramUniformHandleui64vARB;

static GLboolean APIENTRY _fail_glIsTextureHandleResidentARB(GLuint64 handle) {
    const char *_name = "glIsTextureHandleResidentARB";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static GLboolean APIENTRY _get_glIsTextureHandleResidentARB(GLuint64 handle) {
    PFN_GLISTEXTUREHANDLERESIDENTARB _ptr;
    _ptr = (PFN_GLISTEXTUREHANDLERESIDENTARB)_getPrivateProcAddress("glIsTextureHandleResidentARB");
    if (!_ptr) {
        _ptr = &_fail_glIsTextureHandleResidentARB;
    }
    _glIsTextureHandleResidentARB = _ptr;
    return _glIsTextureHandleResidentARB(handle);
}

PFN_GLISTEXTUREHANDLERESIDENTARB _glIsTextureHandleResidentARB = &_get_glIsTextureHandleResidentARB;

static GLboolean APIENTRY _fail_glIsImageHandleResidentARB(GLuint64 handle) {
    const char *_name = "glIsImageHandleResidentARB";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static GLboolean APIENTRY _get_glIsImageHandleResidentARB(GLuint64 handle) {
    PFN_GLISIMAGEHANDLERESIDENTARB _ptr;
    _ptr = (PFN_GLISIMAGEHANDLERESIDENTARB)_getPrivateProcAddress("glIsImageHandleResidentARB");
    if (!_ptr) {
        _ptr = &_fail_glIsImageHandleResidentARB;
    }
    _glIsImageHandleResidentARB = _ptr;
    return _glIsImageHandleResidentARB(handle);
}

PFN_GLISIMAGEHANDLERESIDENTARB _glIsImageHandleResidentARB = &_get_glIsImageHandleResidentARB;

static void APIENTRY _fail_glVertexAttribL1ui64ARB(GLuint index, GLuint64 x) {
    const char *_name = "glVertexAttribL1ui64ARB";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glVertexAttribL1ui64ARB(GLuint index, GLuint64 x) {
    PFN_GLVERTEXATTRIBL1UI64ARB _ptr;
    _ptr = (PFN_GLVERTEXATTRIBL1UI64ARB)_getPrivateProcAddress("glVertexAttribL1ui64ARB");
    if (!_ptr) {
        _ptr = &_fail_glVertexAttribL1ui64ARB;
    }
    _glVertexAttribL1ui64ARB = _ptr;
    _glVertexAttribL1ui64ARB(index, x);
}

PFN_GLVERTEXATTRIBL1UI64ARB _glVertexAttribL1ui64ARB = &_get_glVertexAttribL1ui64ARB;

static void APIENTRY _fail_glVertexAttribL1ui64vARB(GLuint index, const GLuint64 * v) {
    const char *_name = "glVertexAttribL1ui64vARB";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glVertexAttribL1ui64vARB(GLuint index, const GLuint64 * v) {
    PFN_GLVERTEXATTRIBL1UI64VARB _ptr;
    _ptr = (PFN_GLVERTEXATTRIBL1UI64VARB)_getPrivateProcAddress("glVertexAttribL1ui64vARB");
    if (!_ptr) {
        _ptr = &_fail_glVertexAttribL1ui64vARB;
    }
    _glVertexAttribL1ui64vARB = _ptr;
    _glVertexAttribL1ui64vARB(index, v);
}

PFN_GLVERTEXATTRIBL1UI64VARB _glVertexAttribL1ui64vARB = &_get_glVertexAttribL1ui64vARB;

static void APIENTRY _fail_glGetVertexAttribLui64vARB(GLuint index, GLenum pname, GLuint64 * params) {
    const char *_name = "glGetVertexAttribLui64vARB";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetVertexAttribLui64vARB(GLuint index, GLenum pname, GLuint64 * params) {
    PFN_GLGETVERTEXATTRIBLUI64VARB _ptr;
    _ptr = (PFN_GLGETVERTEXATTRIBLUI64VARB)_getPrivateProcAddress("glGetVertexAttribLui64vARB");
    if (!_ptr) {
        _ptr = &_fail_glGetVertexAttribLui64vARB;
    }
    _glGetVertexAttribLui64vARB = _ptr;
    _glGetVertexAttribLui64vARB(index, pname, params);
}

PFN_GLGETVERTEXATTRIBLUI64VARB _glGetVertexAttribLui64vARB = &_get_glGetVertexAttribLui64vARB;

static void APIENTRY _fail_glBindFragDataLocationIndexed(GLuint program, GLuint colorNumber, GLuint index, const GLchar * name) {
    const char *_name = "glBindFragDataLocationIndexed";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glBindFragDataLocationIndexed(GLuint program, GLuint colorNumber, GLuint index, const GLchar * name) {
    PFN_GLBINDFRAGDATALOCATIONINDEXED _ptr;
    _ptr = (PFN_GLBINDFRAGDATALOCATIONINDEXED)_getPrivateProcAddress("glBindFragDataLocationIndexed");
    if (!_ptr) {
        _ptr = &_fail_glBindFragDataLocationIndexed;
    }
    _glBindFragDataLocationIndexed = _ptr;
    _glBindFragDataLocationIndexed(program, colorNumber, index, name);
}

PFN_GLBINDFRAGDATALOCATIONINDEXED _glBindFragDataLocationIndexed = &_get_glBindFragDataLocationIndexed;

static GLint APIENTRY _fail_glGetFragDataIndex(GLuint program, const GLchar * name) {
    const char *_name = "glGetFragDataIndex";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static GLint APIENTRY _get_glGetFragDataIndex(GLuint program, const GLchar * name) {
    PFN_GLGETFRAGDATAINDEX _ptr;
    _ptr = (PFN_GLGETFRAGDATAINDEX)_getPrivateProcAddress("glGetFragDataIndex");
    if (!_ptr) {
        _ptr = &_fail_glGetFragDataIndex;
    }
    _glGetFragDataIndex = _ptr;
    return _glGetFragDataIndex(program, name);
}

PFN_GLGETFRAGDATAINDEX _glGetFragDataIndex = &_get_glGetFragDataIndex;

static void APIENTRY _fail_glBufferStorage(GLenum target, GLsizeiptr size, const GLvoid * data, GLbitfield flags) {
    const char *_name = "glBufferStorage";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glBufferStorage(GLenum target, GLsizeiptr size, const GLvoid * data, GLbitfield flags) {
    PFN_GLBUFFERSTORAGE _ptr;
    _ptr = (PFN_GLBUFFERSTORAGE)_getPrivateProcAddress("glBufferStorage");
    if (!_ptr) {
        _ptr = &_fail_glBufferStorage;
    }
    _glBufferStorage = _ptr;
    _glBufferStorage(target, size, data, flags);
}

PFN_GLBUFFERSTORAGE _glBufferStorage = &_get_glBufferStorage;

static GLsync APIENTRY _fail_glCreateSyncFromCLeventARB(struct _cl_context * context, struct _cl_event * event, GLbitfield flags) {
    const char *_name = "glCreateSyncFromCLeventARB";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static GLsync APIENTRY _get_glCreateSyncFromCLeventARB(struct _cl_context * context, struct _cl_event * event, GLbitfield flags) {
    PFN_GLCREATESYNCFROMCLEVENTARB _ptr;
    _ptr = (PFN_GLCREATESYNCFROMCLEVENTARB)_getPrivateProcAddress("glCreateSyncFromCLeventARB");
    if (!_ptr) {
        _ptr = &_fail_glCreateSyncFromCLeventARB;
    }
    _glCreateSyncFromCLeventARB = _ptr;
    return _glCreateSyncFromCLeventARB(context, event, flags);
}

PFN_GLCREATESYNCFROMCLEVENTARB _glCreateSyncFromCLeventARB = &_get_glCreateSyncFromCLeventARB;

static void APIENTRY _fail_glClearBufferData(GLenum target, GLenum internalformat, GLenum format, GLenum type, const void * data) {
    const char *_name = "glClearBufferData";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glClearBufferData(GLenum target, GLenum internalformat, GLenum format, GLenum type, const void * data) {
    PFN_GLCLEARBUFFERDATA _ptr;
    _ptr = (PFN_GLCLEARBUFFERDATA)_getPrivateProcAddress("glClearBufferData");
    if (!_ptr) {
        _ptr = &_fail_glClearBufferData;
    }
    _glClearBufferData = _ptr;
    _glClearBufferData(target, internalformat, format, type, data);
}

PFN_GLCLEARBUFFERDATA _glClearBufferData = &_get_glClearBufferData;

static void APIENTRY _fail_glClearBufferSubData(GLenum target, GLenum internalformat, GLintptr offset, GLsizeiptr size, GLenum format, GLenum type, const void * data) {
    const char *_name = "glClearBufferSubData";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glClearBufferSubData(GLenum target, GLenum internalformat, GLintptr offset, GLsizeiptr size, GLenum format, GLenum type, const void * data) {
    PFN_GLCLEARBUFFERSUBDATA _ptr;
    _ptr = (PFN_GLCLEARBUFFERSUBDATA)_getPrivateProcAddress("glClearBufferSubData");
    if (!_ptr) {
        _ptr = &_fail_glClearBufferSubData;
    }
    _glClearBufferSubData = _ptr;
    _glClearBufferSubData(target, internalformat, offset, size, format, type, data);
}

PFN_GLCLEARBUFFERSUBDATA _glClearBufferSubData = &_get_glClearBufferSubData;

static void APIENTRY _fail_glClearTexImage(GLuint texture, GLint level, GLenum format, GLenum type, const GLvoid * data) {
    const char *_name = "glClearTexImage";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glClearTexImage(GLuint texture, GLint level, GLenum format, GLenum type, const GLvoid * data) {
    PFN_GLCLEARTEXIMAGE _ptr;
    _ptr = (PFN_GLCLEARTEXIMAGE)_getPrivateProcAddress("glClearTexImage");
    if (!_ptr) {
        _ptr = &_fail_glClearTexImage;
    }
    _glClearTexImage = _ptr;
    _glClearTexImage(texture, level, format, type, data);
}

PFN_GLCLEARTEXIMAGE _glClearTexImage = &_get_glClearTexImage;

static void APIENTRY _fail_glClearTexSubImage(GLuint texture, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, const GLvoid * data) {
    const char *_name = "glClearTexSubImage";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glClearTexSubImage(GLuint texture, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, const GLvoid * data) {
    PFN_GLCLEARTEXSUBIMAGE _ptr;
    _ptr = (PFN_GLCLEARTEXSUBIMAGE)_getPrivateProcAddress("glClearTexSubImage");
    if (!_ptr) {
        _ptr = &_fail_glClearTexSubImage;
    }
    _glClearTexSubImage = _ptr;
    _glClearTexSubImage(texture, level, xoffset, yoffset, zoffset, width, height, depth, format, type, data);
}

PFN_GLCLEARTEXSUBIMAGE _glClearTexSubImage = &_get_glClearTexSubImage;

static void APIENTRY _fail_glClipControl(GLenum origin, GLenum depth) {
    const char *_name = "glClipControl";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glClipControl(GLenum origin, GLenum depth) {
    PFN_GLCLIPCONTROL _ptr;
    _ptr = (PFN_GLCLIPCONTROL)_getPrivateProcAddress("glClipControl");
    if (!_ptr) {
        _ptr = &_fail_glClipControl;
    }
    _glClipControl = _ptr;
    _glClipControl(origin, depth);
}

PFN_GLCLIPCONTROL _glClipControl = &_get_glClipControl;

static void APIENTRY _fail_glClampColorARB(GLenum target, GLenum clamp) {
    const char *_name = "glClampColorARB";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glClampColorARB(GLenum target, GLenum clamp) {
    PFN_GLCLAMPCOLORARB _ptr;
    _ptr = (PFN_GLCLAMPCOLORARB)_getPrivateProcAddress("glClampColorARB");
    if (!_ptr) {
        _ptr = &_fail_glClampColorARB;
    }
    _glClampColorARB = _ptr;
    _glClampColorARB(target, clamp);
}

PFN_GLCLAMPCOLORARB _glClampColorARB = &_get_glClampColorARB;

static void APIENTRY _fail_glDispatchCompute(GLuint num_groups_x, GLuint num_groups_y, GLuint num_groups_z) {
    const char *_name = "glDispatchCompute";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glDispatchCompute(GLuint num_groups_x, GLuint num_groups_y, GLuint num_groups_z) {
    PFN_GLDISPATCHCOMPUTE _ptr;
    _ptr = (PFN_GLDISPATCHCOMPUTE)_getPrivateProcAddress("glDispatchCompute");
    if (!_ptr) {
        _ptr = &_fail_glDispatchCompute;
    }
    _glDispatchCompute = _ptr;
    _glDispatchCompute(num_groups_x, num_groups_y, num_groups_z);
}

PFN_GLDISPATCHCOMPUTE _glDispatchCompute = &_get_glDispatchCompute;

static void APIENTRY _fail_glDispatchComputeIndirect(GLintptr indirect) {
    const char *_name = "glDispatchComputeIndirect";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glDispatchComputeIndirect(GLintptr indirect) {
    PFN_GLDISPATCHCOMPUTEINDIRECT _ptr;
    _ptr = (PFN_GLDISPATCHCOMPUTEINDIRECT)_getPrivateProcAddress("glDispatchComputeIndirect");
    if (!_ptr) {
        _ptr = &_fail_glDispatchComputeIndirect;
    }
    _glDispatchComputeIndirect = _ptr;
    _glDispatchComputeIndirect(indirect);
}

PFN_GLDISPATCHCOMPUTEINDIRECT _glDispatchComputeIndirect = &_get_glDispatchComputeIndirect;

static void APIENTRY _fail_glDispatchComputeGroupSizeARB(GLuint num_groups_x, GLuint num_groups_y, GLuint num_groups_z, GLuint group_size_x, GLuint group_size_y, GLuint group_size_z) {
    const char *_name = "glDispatchComputeGroupSizeARB";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glDispatchComputeGroupSizeARB(GLuint num_groups_x, GLuint num_groups_y, GLuint num_groups_z, GLuint group_size_x, GLuint group_size_y, GLuint group_size_z) {
    PFN_GLDISPATCHCOMPUTEGROUPSIZEARB _ptr;
    _ptr = (PFN_GLDISPATCHCOMPUTEGROUPSIZEARB)_getPrivateProcAddress("glDispatchComputeGroupSizeARB");
    if (!_ptr) {
        _ptr = &_fail_glDispatchComputeGroupSizeARB;
    }
    _glDispatchComputeGroupSizeARB = _ptr;
    _glDispatchComputeGroupSizeARB(num_groups_x, num_groups_y, num_groups_z, group_size_x, group_size_y, group_size_z);
}

PFN_GLDISPATCHCOMPUTEGROUPSIZEARB _glDispatchComputeGroupSizeARB = &_get_glDispatchComputeGroupSizeARB;

static void APIENTRY _fail_glCopyBufferSubData(GLenum readTarget, GLenum writeTarget, GLintptr readOffset, GLintptr writeOffset, GLsizeiptr size) {
    const char *_name = "glCopyBufferSubData";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glCopyBufferSubData(GLenum readTarget, GLenum writeTarget, GLintptr readOffset, GLintptr writeOffset, GLsizeiptr size) {
    PFN_GLCOPYBUFFERSUBDATA _ptr;
    _ptr = (PFN_GLCOPYBUFFERSUBDATA)_getPrivateProcAddress("glCopyBufferSubData");
    if (!_ptr) {
        _ptr = &_fail_glCopyBufferSubData;
    }
    _glCopyBufferSubData = _ptr;
    _glCopyBufferSubData(readTarget, writeTarget, readOffset, writeOffset, size);
}

PFN_GLCOPYBUFFERSUBDATA _glCopyBufferSubData = &_get_glCopyBufferSubData;

static void APIENTRY _fail_glCopyImageSubData(GLuint srcName, GLenum srcTarget, GLint srcLevel, GLint srcX, GLint srcY, GLint srcZ, GLuint dstName, GLenum dstTarget, GLint dstLevel, GLint dstX, GLint dstY, GLint dstZ, GLsizei srcWidth, GLsizei srcHeight, GLsizei srcDepth) {
    const char *_name = "glCopyImageSubData";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glCopyImageSubData(GLuint srcName, GLenum srcTarget, GLint srcLevel, GLint srcX, GLint srcY, GLint srcZ, GLuint dstName, GLenum dstTarget, GLint dstLevel, GLint dstX, GLint dstY, GLint dstZ, GLsizei srcWidth, GLsizei srcHeight, GLsizei srcDepth) {
    PFN_GLCOPYIMAGESUBDATA _ptr;
    _ptr = (PFN_GLCOPYIMAGESUBDATA)_getPrivateProcAddress("glCopyImageSubData");
    if (!_ptr) {
        _ptr = &_fail_glCopyImageSubData;
    }
    _glCopyImageSubData = _ptr;
    _glCopyImageSubData(srcName, srcTarget, srcLevel, srcX, srcY, srcZ, dstName, dstTarget, dstLevel, dstX, dstY, dstZ, srcWidth, srcHeight, srcDepth);
}

PFN_GLCOPYIMAGESUBDATA _glCopyImageSubData = &_get_glCopyImageSubData;

static void APIENTRY _fail_glDebugMessageControlARB(GLenum source, GLenum type, GLenum severity, GLsizei count, const GLuint * ids, GLboolean enabled) {
}

static void APIENTRY _get_glDebugMessageControlARB(GLenum source, GLenum type, GLenum severity, GLsizei count, const GLuint * ids, GLboolean enabled) {
    PFN_GLDEBUGMESSAGECONTROLARB _ptr;
    _ptr = (PFN_GLDEBUGMESSAGECONTROLARB)_getPrivateProcAddress("glDebugMessageControlARB");
    if (!_ptr) {
        _ptr = &_fail_glDebugMessageControlARB;
    }
    _glDebugMessageControlARB = _ptr;
    _glDebugMessageControlARB(source, type, severity, count, ids, enabled);
}

PFN_GLDEBUGMESSAGECONTROLARB _glDebugMessageControlARB = &_get_glDebugMessageControlARB;

static void APIENTRY _fail_glDebugMessageInsertARB(GLenum source, GLenum type, GLuint id, GLenum severity, GLsizei length, const GLchar * buf) {
}

static void APIENTRY _get_glDebugMessageInsertARB(GLenum source, GLenum type, GLuint id, GLenum severity, GLsizei length, const GLchar * buf) {
    PFN_GLDEBUGMESSAGEINSERTARB _ptr;
    _ptr = (PFN_GLDEBUGMESSAGEINSERTARB)_getPrivateProcAddress("glDebugMessageInsertARB");
    if (!_ptr) {
        _ptr = &_fail_glDebugMessageInsertARB;
    }
    _glDebugMessageInsertARB = _ptr;
    _glDebugMessageInsertARB(source, type, id, severity, length, buf);
}

PFN_GLDEBUGMESSAGEINSERTARB _glDebugMessageInsertARB = &_get_glDebugMessageInsertARB;

static void APIENTRY _fail_glDebugMessageCallbackARB(GLDEBUGPROCARB callback, const GLvoid * userParam) {
}

static void APIENTRY _get_glDebugMessageCallbackARB(GLDEBUGPROCARB callback, const GLvoid * userParam) {
    PFN_GLDEBUGMESSAGECALLBACKARB _ptr;
    _ptr = (PFN_GLDEBUGMESSAGECALLBACKARB)_getPrivateProcAddress("glDebugMessageCallbackARB");
    if (!_ptr) {
        _ptr = &_fail_glDebugMessageCallbackARB;
    }
    _glDebugMessageCallbackARB = _ptr;
    _glDebugMessageCallbackARB(callback, userParam);
}

PFN_GLDEBUGMESSAGECALLBACKARB _glDebugMessageCallbackARB = &_get_glDebugMessageCallbackARB;

static GLuint APIENTRY _fail_glGetDebugMessageLogARB(GLuint count, GLsizei bufsize, GLenum * sources, GLenum * types, GLuint * ids, GLenum * severities, GLsizei * lengths, GLchar * messageLog) {
    if (sources != 0) *sources = 0;
    if (types != 0) *types = 0;
    if (ids != 0) *ids = 0;
    if (severities != 0) *severities = 0;
    if (lengths != 0) *lengths = 0;
    if (messageLog != 0 && bufsize > 0) *messageLog = 0;
    return 0;
}

static GLuint APIENTRY _get_glGetDebugMessageLogARB(GLuint count, GLsizei bufsize, GLenum * sources, GLenum * types, GLuint * ids, GLenum * severities, GLsizei * lengths, GLchar * messageLog) {
    PFN_GLGETDEBUGMESSAGELOGARB _ptr;
    _ptr = (PFN_GLGETDEBUGMESSAGELOGARB)_getPrivateProcAddress("glGetDebugMessageLogARB");
    if (!_ptr) {
        _ptr = &_fail_glGetDebugMessageLogARB;
    }
    _glGetDebugMessageLogARB = _ptr;
    return _glGetDebugMessageLogARB(count, bufsize, sources, types, ids, severities, lengths, messageLog);
}

PFN_GLGETDEBUGMESSAGELOGARB _glGetDebugMessageLogARB = &_get_glGetDebugMessageLogARB;

static void APIENTRY _fail_glCreateTransformFeedbacks(GLsizei n, GLuint * ids) {
    const char *_name = "glCreateTransformFeedbacks";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glCreateTransformFeedbacks(GLsizei n, GLuint * ids) {
    PFN_GLCREATETRANSFORMFEEDBACKS _ptr;
    _ptr = (PFN_GLCREATETRANSFORMFEEDBACKS)_getPrivateProcAddress("glCreateTransformFeedbacks");
    if (!_ptr) {
        _ptr = &_fail_glCreateTransformFeedbacks;
    }
    _glCreateTransformFeedbacks = _ptr;
    _glCreateTransformFeedbacks(n, ids);
}

PFN_GLCREATETRANSFORMFEEDBACKS _glCreateTransformFeedbacks = &_get_glCreateTransformFeedbacks;

static void APIENTRY _fail_glTransformFeedbackBufferBase(GLuint xfb, GLuint index, GLuint buffer) {
    const char *_name = "glTransformFeedbackBufferBase";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glTransformFeedbackBufferBase(GLuint xfb, GLuint index, GLuint buffer) {
    PFN_GLTRANSFORMFEEDBACKBUFFERBASE _ptr;
    _ptr = (PFN_GLTRANSFORMFEEDBACKBUFFERBASE)_getPrivateProcAddress("glTransformFeedbackBufferBase");
    if (!_ptr) {
        _ptr = &_fail_glTransformFeedbackBufferBase;
    }
    _glTransformFeedbackBufferBase = _ptr;
    _glTransformFeedbackBufferBase(xfb, index, buffer);
}

PFN_GLTRANSFORMFEEDBACKBUFFERBASE _glTransformFeedbackBufferBase = &_get_glTransformFeedbackBufferBase;

static void APIENTRY _fail_glTransformFeedbackBufferRange(GLuint xfb, GLuint index, GLuint buffer, GLintptr offset, GLsizeiptr size) {
    const char *_name = "glTransformFeedbackBufferRange";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glTransformFeedbackBufferRange(GLuint xfb, GLuint index, GLuint buffer, GLintptr offset, GLsizeiptr size) {
    PFN_GLTRANSFORMFEEDBACKBUFFERRANGE _ptr;
    _ptr = (PFN_GLTRANSFORMFEEDBACKBUFFERRANGE)_getPrivateProcAddress("glTransformFeedbackBufferRange");
    if (!_ptr) {
        _ptr = &_fail_glTransformFeedbackBufferRange;
    }
    _glTransformFeedbackBufferRange = _ptr;
    _glTransformFeedbackBufferRange(xfb, index, buffer, offset, size);
}

PFN_GLTRANSFORMFEEDBACKBUFFERRANGE _glTransformFeedbackBufferRange = &_get_glTransformFeedbackBufferRange;

static void APIENTRY _fail_glGetTransformFeedbackiv(GLuint xfb, GLenum pname, GLint * param) {
    const char *_name = "glGetTransformFeedbackiv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetTransformFeedbackiv(GLuint xfb, GLenum pname, GLint * param) {
    PFN_GLGETTRANSFORMFEEDBACKIV _ptr;
    _ptr = (PFN_GLGETTRANSFORMFEEDBACKIV)_getPrivateProcAddress("glGetTransformFeedbackiv");
    if (!_ptr) {
        _ptr = &_fail_glGetTransformFeedbackiv;
    }
    _glGetTransformFeedbackiv = _ptr;
    _glGetTransformFeedbackiv(xfb, pname, param);
}

PFN_GLGETTRANSFORMFEEDBACKIV _glGetTransformFeedbackiv = &_get_glGetTransformFeedbackiv;

static void APIENTRY _fail_glGetTransformFeedbacki_v(GLuint xfb, GLenum pname, GLuint index, GLint * param) {
    const char *_name = "glGetTransformFeedbacki_v";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetTransformFeedbacki_v(GLuint xfb, GLenum pname, GLuint index, GLint * param) {
    PFN_GLGETTRANSFORMFEEDBACKI_V _ptr;
    _ptr = (PFN_GLGETTRANSFORMFEEDBACKI_V)_getPrivateProcAddress("glGetTransformFeedbacki_v");
    if (!_ptr) {
        _ptr = &_fail_glGetTransformFeedbacki_v;
    }
    _glGetTransformFeedbacki_v = _ptr;
    _glGetTransformFeedbacki_v(xfb, pname, index, param);
}

PFN_GLGETTRANSFORMFEEDBACKI_V _glGetTransformFeedbacki_v = &_get_glGetTransformFeedbacki_v;

static void APIENTRY _fail_glGetTransformFeedbacki64_v(GLuint xfb, GLenum pname, GLuint index, GLint64 * param) {
    const char *_name = "glGetTransformFeedbacki64_v";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetTransformFeedbacki64_v(GLuint xfb, GLenum pname, GLuint index, GLint64 * param) {
    PFN_GLGETTRANSFORMFEEDBACKI64_V _ptr;
    _ptr = (PFN_GLGETTRANSFORMFEEDBACKI64_V)_getPrivateProcAddress("glGetTransformFeedbacki64_v");
    if (!_ptr) {
        _ptr = &_fail_glGetTransformFeedbacki64_v;
    }
    _glGetTransformFeedbacki64_v = _ptr;
    _glGetTransformFeedbacki64_v(xfb, pname, index, param);
}

PFN_GLGETTRANSFORMFEEDBACKI64_V _glGetTransformFeedbacki64_v = &_get_glGetTransformFeedbacki64_v;

static void APIENTRY _fail_glCreateBuffers(GLsizei n, GLuint * buffers) {
    const char *_name = "glCreateBuffers";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glCreateBuffers(GLsizei n, GLuint * buffers) {
    PFN_GLCREATEBUFFERS _ptr;
    _ptr = (PFN_GLCREATEBUFFERS)_getPrivateProcAddress("glCreateBuffers");
    if (!_ptr) {
        _ptr = &_fail_glCreateBuffers;
    }
    _glCreateBuffers = _ptr;
    _glCreateBuffers(n, buffers);
}

PFN_GLCREATEBUFFERS _glCreateBuffers = &_get_glCreateBuffers;

static void APIENTRY _fail_glNamedBufferStorage(GLuint buffer, GLsizeiptr size, const void * data, GLbitfield flags) {
    const char *_name = "glNamedBufferStorage";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glNamedBufferStorage(GLuint buffer, GLsizeiptr size, const void * data, GLbitfield flags) {
    PFN_GLNAMEDBUFFERSTORAGE _ptr;
    _ptr = (PFN_GLNAMEDBUFFERSTORAGE)_getPrivateProcAddress("glNamedBufferStorage");
    if (!_ptr) {
        _ptr = &_fail_glNamedBufferStorage;
    }
    _glNamedBufferStorage = _ptr;
    _glNamedBufferStorage(buffer, size, data, flags);
}

PFN_GLNAMEDBUFFERSTORAGE _glNamedBufferStorage = &_get_glNamedBufferStorage;

static void APIENTRY _fail_glNamedBufferData(GLuint buffer, GLsizeiptr size, const void * data, GLenum usage) {
    const char *_name = "glNamedBufferData";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glNamedBufferData(GLuint buffer, GLsizeiptr size, const void * data, GLenum usage) {
    PFN_GLNAMEDBUFFERDATA _ptr;
    _ptr = (PFN_GLNAMEDBUFFERDATA)_getPrivateProcAddress("glNamedBufferData");
    if (!_ptr) {
        _ptr = &_fail_glNamedBufferData;
    }
    _glNamedBufferData = _ptr;
    _glNamedBufferData(buffer, size, data, usage);
}

PFN_GLNAMEDBUFFERDATA _glNamedBufferData = &_get_glNamedBufferData;

static void APIENTRY _fail_glNamedBufferSubData(GLuint buffer, GLintptr offset, GLsizeiptr size, const void * data) {
    const char *_name = "glNamedBufferSubData";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glNamedBufferSubData(GLuint buffer, GLintptr offset, GLsizeiptr size, const void * data) {
    PFN_GLNAMEDBUFFERSUBDATA _ptr;
    _ptr = (PFN_GLNAMEDBUFFERSUBDATA)_getPrivateProcAddress("glNamedBufferSubData");
    if (!_ptr) {
        _ptr = &_fail_glNamedBufferSubData;
    }
    _glNamedBufferSubData = _ptr;
    _glNamedBufferSubData(buffer, offset, size, data);
}

PFN_GLNAMEDBUFFERSUBDATA _glNamedBufferSubData = &_get_glNamedBufferSubData;

static void APIENTRY _fail_glCopyNamedBufferSubData(GLuint readBuffer, GLuint writeBuffer, GLintptr readOffset, GLintptr writeOffset, GLsizeiptr size) {
    const char *_name = "glCopyNamedBufferSubData";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glCopyNamedBufferSubData(GLuint readBuffer, GLuint writeBuffer, GLintptr readOffset, GLintptr writeOffset, GLsizeiptr size) {
    PFN_GLCOPYNAMEDBUFFERSUBDATA _ptr;
    _ptr = (PFN_GLCOPYNAMEDBUFFERSUBDATA)_getPrivateProcAddress("glCopyNamedBufferSubData");
    if (!_ptr) {
        _ptr = &_fail_glCopyNamedBufferSubData;
    }
    _glCopyNamedBufferSubData = _ptr;
    _glCopyNamedBufferSubData(readBuffer, writeBuffer, readOffset, writeOffset, size);
}

PFN_GLCOPYNAMEDBUFFERSUBDATA _glCopyNamedBufferSubData = &_get_glCopyNamedBufferSubData;

static void APIENTRY _fail_glClearNamedBufferData(GLuint buffer, GLenum internalformat, GLenum format, GLenum type, const void * data) {
    const char *_name = "glClearNamedBufferData";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glClearNamedBufferData(GLuint buffer, GLenum internalformat, GLenum format, GLenum type, const void * data) {
    PFN_GLCLEARNAMEDBUFFERDATA _ptr;
    _ptr = (PFN_GLCLEARNAMEDBUFFERDATA)_getPrivateProcAddress("glClearNamedBufferData");
    if (!_ptr) {
        _ptr = &_fail_glClearNamedBufferData;
    }
    _glClearNamedBufferData = _ptr;
    _glClearNamedBufferData(buffer, internalformat, format, type, data);
}

PFN_GLCLEARNAMEDBUFFERDATA _glClearNamedBufferData = &_get_glClearNamedBufferData;

static void APIENTRY _fail_glClearNamedBufferSubData(GLuint buffer, GLenum internalformat, GLintptr offset, GLsizeiptr size, GLenum format, GLenum type, const void * data) {
    const char *_name = "glClearNamedBufferSubData";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glClearNamedBufferSubData(GLuint buffer, GLenum internalformat, GLintptr offset, GLsizeiptr size, GLenum format, GLenum type, const void * data) {
    PFN_GLCLEARNAMEDBUFFERSUBDATA _ptr;
    _ptr = (PFN_GLCLEARNAMEDBUFFERSUBDATA)_getPrivateProcAddress("glClearNamedBufferSubData");
    if (!_ptr) {
        _ptr = &_fail_glClearNamedBufferSubData;
    }
    _glClearNamedBufferSubData = _ptr;
    _glClearNamedBufferSubData(buffer, internalformat, offset, size, format, type, data);
}

PFN_GLCLEARNAMEDBUFFERSUBDATA _glClearNamedBufferSubData = &_get_glClearNamedBufferSubData;

static GLvoid * APIENTRY _fail_glMapNamedBuffer(GLuint buffer, GLenum access) {
    const char *_name = "glMapNamedBuffer";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static GLvoid * APIENTRY _get_glMapNamedBuffer(GLuint buffer, GLenum access) {
    PFN_GLMAPNAMEDBUFFER _ptr;
    _ptr = (PFN_GLMAPNAMEDBUFFER)_getPrivateProcAddress("glMapNamedBuffer");
    if (!_ptr) {
        _ptr = &_fail_glMapNamedBuffer;
    }
    _glMapNamedBuffer = _ptr;
    return _glMapNamedBuffer(buffer, access);
}

PFN_GLMAPNAMEDBUFFER _glMapNamedBuffer = &_get_glMapNamedBuffer;

static GLvoid * APIENTRY _fail_glMapNamedBufferRange(GLuint buffer, GLintptr offset, GLsizeiptr length, GLbitfield access) {
    const char *_name = "glMapNamedBufferRange";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static GLvoid * APIENTRY _get_glMapNamedBufferRange(GLuint buffer, GLintptr offset, GLsizeiptr length, GLbitfield access) {
    PFN_GLMAPNAMEDBUFFERRANGE _ptr;
    _ptr = (PFN_GLMAPNAMEDBUFFERRANGE)_getPrivateProcAddress("glMapNamedBufferRange");
    if (!_ptr) {
        _ptr = &_fail_glMapNamedBufferRange;
    }
    _glMapNamedBufferRange = _ptr;
    return _glMapNamedBufferRange(buffer, offset, length, access);
}

PFN_GLMAPNAMEDBUFFERRANGE _glMapNamedBufferRange = &_get_glMapNamedBufferRange;

static GLboolean APIENTRY _fail_glUnmapNamedBuffer(GLuint buffer) {
    const char *_name = "glUnmapNamedBuffer";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static GLboolean APIENTRY _get_glUnmapNamedBuffer(GLuint buffer) {
    PFN_GLUNMAPNAMEDBUFFER _ptr;
    _ptr = (PFN_GLUNMAPNAMEDBUFFER)_getPrivateProcAddress("glUnmapNamedBuffer");
    if (!_ptr) {
        _ptr = &_fail_glUnmapNamedBuffer;
    }
    _glUnmapNamedBuffer = _ptr;
    return _glUnmapNamedBuffer(buffer);
}

PFN_GLUNMAPNAMEDBUFFER _glUnmapNamedBuffer = &_get_glUnmapNamedBuffer;

static void APIENTRY _fail_glFlushMappedNamedBufferRange(GLuint buffer, GLintptr offset, GLsizeiptr length) {
    const char *_name = "glFlushMappedNamedBufferRange";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glFlushMappedNamedBufferRange(GLuint buffer, GLintptr offset, GLsizeiptr length) {
    PFN_GLFLUSHMAPPEDNAMEDBUFFERRANGE _ptr;
    _ptr = (PFN_GLFLUSHMAPPEDNAMEDBUFFERRANGE)_getPrivateProcAddress("glFlushMappedNamedBufferRange");
    if (!_ptr) {
        _ptr = &_fail_glFlushMappedNamedBufferRange;
    }
    _glFlushMappedNamedBufferRange = _ptr;
    _glFlushMappedNamedBufferRange(buffer, offset, length);
}

PFN_GLFLUSHMAPPEDNAMEDBUFFERRANGE _glFlushMappedNamedBufferRange = &_get_glFlushMappedNamedBufferRange;

static void APIENTRY _fail_glGetNamedBufferParameteriv(GLuint buffer, GLenum pname, GLint * params) {
    const char *_name = "glGetNamedBufferParameteriv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetNamedBufferParameteriv(GLuint buffer, GLenum pname, GLint * params) {
    PFN_GLGETNAMEDBUFFERPARAMETERIV _ptr;
    _ptr = (PFN_GLGETNAMEDBUFFERPARAMETERIV)_getPrivateProcAddress("glGetNamedBufferParameteriv");
    if (!_ptr) {
        _ptr = &_fail_glGetNamedBufferParameteriv;
    }
    _glGetNamedBufferParameteriv = _ptr;
    _glGetNamedBufferParameteriv(buffer, pname, params);
}

PFN_GLGETNAMEDBUFFERPARAMETERIV _glGetNamedBufferParameteriv = &_get_glGetNamedBufferParameteriv;

static void APIENTRY _fail_glGetNamedBufferParameteri64v(GLuint buffer, GLenum pname, GLint64 * params) {
    const char *_name = "glGetNamedBufferParameteri64v";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetNamedBufferParameteri64v(GLuint buffer, GLenum pname, GLint64 * params) {
    PFN_GLGETNAMEDBUFFERPARAMETERI64V _ptr;
    _ptr = (PFN_GLGETNAMEDBUFFERPARAMETERI64V)_getPrivateProcAddress("glGetNamedBufferParameteri64v");
    if (!_ptr) {
        _ptr = &_fail_glGetNamedBufferParameteri64v;
    }
    _glGetNamedBufferParameteri64v = _ptr;
    _glGetNamedBufferParameteri64v(buffer, pname, params);
}

PFN_GLGETNAMEDBUFFERPARAMETERI64V _glGetNamedBufferParameteri64v = &_get_glGetNamedBufferParameteri64v;

static void APIENTRY _fail_glGetNamedBufferPointerv(GLuint buffer, GLenum pname, GLvoid * * params) {
    const char *_name = "glGetNamedBufferPointerv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetNamedBufferPointerv(GLuint buffer, GLenum pname, GLvoid * * params) {
    PFN_GLGETNAMEDBUFFERPOINTERV _ptr;
    _ptr = (PFN_GLGETNAMEDBUFFERPOINTERV)_getPrivateProcAddress("glGetNamedBufferPointerv");
    if (!_ptr) {
        _ptr = &_fail_glGetNamedBufferPointerv;
    }
    _glGetNamedBufferPointerv = _ptr;
    _glGetNamedBufferPointerv(buffer, pname, params);
}

PFN_GLGETNAMEDBUFFERPOINTERV _glGetNamedBufferPointerv = &_get_glGetNamedBufferPointerv;

static void APIENTRY _fail_glGetNamedBufferSubData(GLuint buffer, GLintptr offset, GLsizeiptr size, void * data) {
    const char *_name = "glGetNamedBufferSubData";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetNamedBufferSubData(GLuint buffer, GLintptr offset, GLsizeiptr size, void * data) {
    PFN_GLGETNAMEDBUFFERSUBDATA _ptr;
    _ptr = (PFN_GLGETNAMEDBUFFERSUBDATA)_getPrivateProcAddress("glGetNamedBufferSubData");
    if (!_ptr) {
        _ptr = &_fail_glGetNamedBufferSubData;
    }
    _glGetNamedBufferSubData = _ptr;
    _glGetNamedBufferSubData(buffer, offset, size, data);
}

PFN_GLGETNAMEDBUFFERSUBDATA _glGetNamedBufferSubData = &_get_glGetNamedBufferSubData;

static void APIENTRY _fail_glCreateFramebuffers(GLsizei n, GLuint * framebuffers) {
    const char *_name = "glCreateFramebuffers";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glCreateFramebuffers(GLsizei n, GLuint * framebuffers) {
    PFN_GLCREATEFRAMEBUFFERS _ptr;
    _ptr = (PFN_GLCREATEFRAMEBUFFERS)_getPrivateProcAddress("glCreateFramebuffers");
    if (!_ptr) {
        _ptr = &_fail_glCreateFramebuffers;
    }
    _glCreateFramebuffers = _ptr;
    _glCreateFramebuffers(n, framebuffers);
}

PFN_GLCREATEFRAMEBUFFERS _glCreateFramebuffers = &_get_glCreateFramebuffers;

static void APIENTRY _fail_glNamedFramebufferRenderbuffer(GLuint framebuffer, GLenum attachment, GLenum renderbuffertarget, GLuint renderbuffer) {
    const char *_name = "glNamedFramebufferRenderbuffer";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glNamedFramebufferRenderbuffer(GLuint framebuffer, GLenum attachment, GLenum renderbuffertarget, GLuint renderbuffer) {
    PFN_GLNAMEDFRAMEBUFFERRENDERBUFFER _ptr;
    _ptr = (PFN_GLNAMEDFRAMEBUFFERRENDERBUFFER)_getPrivateProcAddress("glNamedFramebufferRenderbuffer");
    if (!_ptr) {
        _ptr = &_fail_glNamedFramebufferRenderbuffer;
    }
    _glNamedFramebufferRenderbuffer = _ptr;
    _glNamedFramebufferRenderbuffer(framebuffer, attachment, renderbuffertarget, renderbuffer);
}

PFN_GLNAMEDFRAMEBUFFERRENDERBUFFER _glNamedFramebufferRenderbuffer = &_get_glNamedFramebufferRenderbuffer;

static void APIENTRY _fail_glNamedFramebufferParameteri(GLuint framebuffer, GLenum pname, GLint param) {
    const char *_name = "glNamedFramebufferParameteri";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glNamedFramebufferParameteri(GLuint framebuffer, GLenum pname, GLint param) {
    PFN_GLNAMEDFRAMEBUFFERPARAMETERI _ptr;
    _ptr = (PFN_GLNAMEDFRAMEBUFFERPARAMETERI)_getPrivateProcAddress("glNamedFramebufferParameteri");
    if (!_ptr) {
        _ptr = &_fail_glNamedFramebufferParameteri;
    }
    _glNamedFramebufferParameteri = _ptr;
    _glNamedFramebufferParameteri(framebuffer, pname, param);
}

PFN_GLNAMEDFRAMEBUFFERPARAMETERI _glNamedFramebufferParameteri = &_get_glNamedFramebufferParameteri;

static void APIENTRY _fail_glNamedFramebufferTexture(GLuint framebuffer, GLenum attachment, GLuint texture, GLint level) {
    const char *_name = "glNamedFramebufferTexture";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glNamedFramebufferTexture(GLuint framebuffer, GLenum attachment, GLuint texture, GLint level) {
    PFN_GLNAMEDFRAMEBUFFERTEXTURE _ptr;
    _ptr = (PFN_GLNAMEDFRAMEBUFFERTEXTURE)_getPrivateProcAddress("glNamedFramebufferTexture");
    if (!_ptr) {
        _ptr = &_fail_glNamedFramebufferTexture;
    }
    _glNamedFramebufferTexture = _ptr;
    _glNamedFramebufferTexture(framebuffer, attachment, texture, level);
}

PFN_GLNAMEDFRAMEBUFFERTEXTURE _glNamedFramebufferTexture = &_get_glNamedFramebufferTexture;

static void APIENTRY _fail_glNamedFramebufferTextureLayer(GLuint framebuffer, GLenum attachment, GLuint texture, GLint level, GLint layer) {
    const char *_name = "glNamedFramebufferTextureLayer";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glNamedFramebufferTextureLayer(GLuint framebuffer, GLenum attachment, GLuint texture, GLint level, GLint layer) {
    PFN_GLNAMEDFRAMEBUFFERTEXTURELAYER _ptr;
    _ptr = (PFN_GLNAMEDFRAMEBUFFERTEXTURELAYER)_getPrivateProcAddress("glNamedFramebufferTextureLayer");
    if (!_ptr) {
        _ptr = &_fail_glNamedFramebufferTextureLayer;
    }
    _glNamedFramebufferTextureLayer = _ptr;
    _glNamedFramebufferTextureLayer(framebuffer, attachment, texture, level, layer);
}

PFN_GLNAMEDFRAMEBUFFERTEXTURELAYER _glNamedFramebufferTextureLayer = &_get_glNamedFramebufferTextureLayer;

static void APIENTRY _fail_glNamedFramebufferDrawBuffer(GLuint framebuffer, GLenum buf) {
    const char *_name = "glNamedFramebufferDrawBuffer";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glNamedFramebufferDrawBuffer(GLuint framebuffer, GLenum buf) {
    PFN_GLNAMEDFRAMEBUFFERDRAWBUFFER _ptr;
    _ptr = (PFN_GLNAMEDFRAMEBUFFERDRAWBUFFER)_getPrivateProcAddress("glNamedFramebufferDrawBuffer");
    if (!_ptr) {
        _ptr = &_fail_glNamedFramebufferDrawBuffer;
    }
    _glNamedFramebufferDrawBuffer = _ptr;
    _glNamedFramebufferDrawBuffer(framebuffer, buf);
}

PFN_GLNAMEDFRAMEBUFFERDRAWBUFFER _glNamedFramebufferDrawBuffer = &_get_glNamedFramebufferDrawBuffer;

static void APIENTRY _fail_glNamedFramebufferDrawBuffers(GLuint framebuffer, GLsizei n, const GLenum * bufs) {
    const char *_name = "glNamedFramebufferDrawBuffers";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glNamedFramebufferDrawBuffers(GLuint framebuffer, GLsizei n, const GLenum * bufs) {
    PFN_GLNAMEDFRAMEBUFFERDRAWBUFFERS _ptr;
    _ptr = (PFN_GLNAMEDFRAMEBUFFERDRAWBUFFERS)_getPrivateProcAddress("glNamedFramebufferDrawBuffers");
    if (!_ptr) {
        _ptr = &_fail_glNamedFramebufferDrawBuffers;
    }
    _glNamedFramebufferDrawBuffers = _ptr;
    _glNamedFramebufferDrawBuffers(framebuffer, n, bufs);
}

PFN_GLNAMEDFRAMEBUFFERDRAWBUFFERS _glNamedFramebufferDrawBuffers = &_get_glNamedFramebufferDrawBuffers;

static void APIENTRY _fail_glNamedFramebufferReadBuffer(GLuint framebuffer, GLenum src) {
    const char *_name = "glNamedFramebufferReadBuffer";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glNamedFramebufferReadBuffer(GLuint framebuffer, GLenum src) {
    PFN_GLNAMEDFRAMEBUFFERREADBUFFER _ptr;
    _ptr = (PFN_GLNAMEDFRAMEBUFFERREADBUFFER)_getPrivateProcAddress("glNamedFramebufferReadBuffer");
    if (!_ptr) {
        _ptr = &_fail_glNamedFramebufferReadBuffer;
    }
    _glNamedFramebufferReadBuffer = _ptr;
    _glNamedFramebufferReadBuffer(framebuffer, src);
}

PFN_GLNAMEDFRAMEBUFFERREADBUFFER _glNamedFramebufferReadBuffer = &_get_glNamedFramebufferReadBuffer;

static void APIENTRY _fail_glInvalidateNamedFramebufferData(GLuint framebuffer, GLsizei numAttachments, const GLenum * attachments) {
    const char *_name = "glInvalidateNamedFramebufferData";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glInvalidateNamedFramebufferData(GLuint framebuffer, GLsizei numAttachments, const GLenum * attachments) {
    PFN_GLINVALIDATENAMEDFRAMEBUFFERDATA _ptr;
    _ptr = (PFN_GLINVALIDATENAMEDFRAMEBUFFERDATA)_getPrivateProcAddress("glInvalidateNamedFramebufferData");
    if (!_ptr) {
        _ptr = &_fail_glInvalidateNamedFramebufferData;
    }
    _glInvalidateNamedFramebufferData = _ptr;
    _glInvalidateNamedFramebufferData(framebuffer, numAttachments, attachments);
}

PFN_GLINVALIDATENAMEDFRAMEBUFFERDATA _glInvalidateNamedFramebufferData = &_get_glInvalidateNamedFramebufferData;

static void APIENTRY _fail_glInvalidateNamedFramebufferSubData(GLuint framebuffer, GLsizei numAttachments, const GLenum * attachments, GLint x, GLint y, GLsizei width, GLsizei height) {
    const char *_name = "glInvalidateNamedFramebufferSubData";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glInvalidateNamedFramebufferSubData(GLuint framebuffer, GLsizei numAttachments, const GLenum * attachments, GLint x, GLint y, GLsizei width, GLsizei height) {
    PFN_GLINVALIDATENAMEDFRAMEBUFFERSUBDATA _ptr;
    _ptr = (PFN_GLINVALIDATENAMEDFRAMEBUFFERSUBDATA)_getPrivateProcAddress("glInvalidateNamedFramebufferSubData");
    if (!_ptr) {
        _ptr = &_fail_glInvalidateNamedFramebufferSubData;
    }
    _glInvalidateNamedFramebufferSubData = _ptr;
    _glInvalidateNamedFramebufferSubData(framebuffer, numAttachments, attachments, x, y, width, height);
}

PFN_GLINVALIDATENAMEDFRAMEBUFFERSUBDATA _glInvalidateNamedFramebufferSubData = &_get_glInvalidateNamedFramebufferSubData;

static void APIENTRY _fail_glClearNamedFramebufferiv(GLuint framebuffer, GLenum buffer, GLint drawbuffer, const GLint * value) {
    const char *_name = "glClearNamedFramebufferiv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glClearNamedFramebufferiv(GLuint framebuffer, GLenum buffer, GLint drawbuffer, const GLint * value) {
    PFN_GLCLEARNAMEDFRAMEBUFFERIV _ptr;
    _ptr = (PFN_GLCLEARNAMEDFRAMEBUFFERIV)_getPrivateProcAddress("glClearNamedFramebufferiv");
    if (!_ptr) {
        _ptr = &_fail_glClearNamedFramebufferiv;
    }
    _glClearNamedFramebufferiv = _ptr;
    _glClearNamedFramebufferiv(framebuffer, buffer, drawbuffer, value);
}

PFN_GLCLEARNAMEDFRAMEBUFFERIV _glClearNamedFramebufferiv = &_get_glClearNamedFramebufferiv;

static void APIENTRY _fail_glClearNamedFramebufferuiv(GLuint framebuffer, GLenum buffer, GLint drawbuffer, const GLuint * value) {
    const char *_name = "glClearNamedFramebufferuiv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glClearNamedFramebufferuiv(GLuint framebuffer, GLenum buffer, GLint drawbuffer, const GLuint * value) {
    PFN_GLCLEARNAMEDFRAMEBUFFERUIV _ptr;
    _ptr = (PFN_GLCLEARNAMEDFRAMEBUFFERUIV)_getPrivateProcAddress("glClearNamedFramebufferuiv");
    if (!_ptr) {
        _ptr = &_fail_glClearNamedFramebufferuiv;
    }
    _glClearNamedFramebufferuiv = _ptr;
    _glClearNamedFramebufferuiv(framebuffer, buffer, drawbuffer, value);
}

PFN_GLCLEARNAMEDFRAMEBUFFERUIV _glClearNamedFramebufferuiv = &_get_glClearNamedFramebufferuiv;

static void APIENTRY _fail_glClearNamedFramebufferfv(GLuint framebuffer, GLenum buffer, GLint drawbuffer, const GLfloat * value) {
    const char *_name = "glClearNamedFramebufferfv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glClearNamedFramebufferfv(GLuint framebuffer, GLenum buffer, GLint drawbuffer, const GLfloat * value) {
    PFN_GLCLEARNAMEDFRAMEBUFFERFV _ptr;
    _ptr = (PFN_GLCLEARNAMEDFRAMEBUFFERFV)_getPrivateProcAddress("glClearNamedFramebufferfv");
    if (!_ptr) {
        _ptr = &_fail_glClearNamedFramebufferfv;
    }
    _glClearNamedFramebufferfv = _ptr;
    _glClearNamedFramebufferfv(framebuffer, buffer, drawbuffer, value);
}

PFN_GLCLEARNAMEDFRAMEBUFFERFV _glClearNamedFramebufferfv = &_get_glClearNamedFramebufferfv;

static void APIENTRY _fail_glClearNamedFramebufferfi(GLuint framebuffer, GLenum buffer, GLint drawbuffer, GLfloat depth, GLint stencil) {
    const char *_name = "glClearNamedFramebufferfi";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glClearNamedFramebufferfi(GLuint framebuffer, GLenum buffer, GLint drawbuffer, GLfloat depth, GLint stencil) {
    PFN_GLCLEARNAMEDFRAMEBUFFERFI _ptr;
    _ptr = (PFN_GLCLEARNAMEDFRAMEBUFFERFI)_getPrivateProcAddress("glClearNamedFramebufferfi");
    if (!_ptr) {
        _ptr = &_fail_glClearNamedFramebufferfi;
    }
    _glClearNamedFramebufferfi = _ptr;
    _glClearNamedFramebufferfi(framebuffer, buffer, drawbuffer, depth, stencil);
}

PFN_GLCLEARNAMEDFRAMEBUFFERFI _glClearNamedFramebufferfi = &_get_glClearNamedFramebufferfi;

static void APIENTRY _fail_glBlitNamedFramebuffer(GLuint readFramebuffer, GLuint drawFramebuffer, GLint srcX0, GLint srcY0, GLint srcX1, GLint srcY1, GLint dstX0, GLint dstY0, GLint dstX1, GLint dstY1, GLbitfield mask, GLenum filter) {
    const char *_name = "glBlitNamedFramebuffer";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glBlitNamedFramebuffer(GLuint readFramebuffer, GLuint drawFramebuffer, GLint srcX0, GLint srcY0, GLint srcX1, GLint srcY1, GLint dstX0, GLint dstY0, GLint dstX1, GLint dstY1, GLbitfield mask, GLenum filter) {
    PFN_GLBLITNAMEDFRAMEBUFFER _ptr;
    _ptr = (PFN_GLBLITNAMEDFRAMEBUFFER)_getPrivateProcAddress("glBlitNamedFramebuffer");
    if (!_ptr) {
        _ptr = &_fail_glBlitNamedFramebuffer;
    }
    _glBlitNamedFramebuffer = _ptr;
    _glBlitNamedFramebuffer(readFramebuffer, drawFramebuffer, srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1, dstY1, mask, filter);
}

PFN_GLBLITNAMEDFRAMEBUFFER _glBlitNamedFramebuffer = &_get_glBlitNamedFramebuffer;

static GLenum APIENTRY _fail_glCheckNamedFramebufferStatus(GLuint framebuffer, GLenum target) {
    const char *_name = "glCheckNamedFramebufferStatus";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static GLenum APIENTRY _get_glCheckNamedFramebufferStatus(GLuint framebuffer, GLenum target) {
    PFN_GLCHECKNAMEDFRAMEBUFFERSTATUS _ptr;
    _ptr = (PFN_GLCHECKNAMEDFRAMEBUFFERSTATUS)_getPrivateProcAddress("glCheckNamedFramebufferStatus");
    if (!_ptr) {
        _ptr = &_fail_glCheckNamedFramebufferStatus;
    }
    _glCheckNamedFramebufferStatus = _ptr;
    return _glCheckNamedFramebufferStatus(framebuffer, target);
}

PFN_GLCHECKNAMEDFRAMEBUFFERSTATUS _glCheckNamedFramebufferStatus = &_get_glCheckNamedFramebufferStatus;

static void APIENTRY _fail_glGetNamedFramebufferParameteriv(GLuint framebuffer, GLenum pname, GLint * param) {
    const char *_name = "glGetNamedFramebufferParameteriv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetNamedFramebufferParameteriv(GLuint framebuffer, GLenum pname, GLint * param) {
    PFN_GLGETNAMEDFRAMEBUFFERPARAMETERIV _ptr;
    _ptr = (PFN_GLGETNAMEDFRAMEBUFFERPARAMETERIV)_getPrivateProcAddress("glGetNamedFramebufferParameteriv");
    if (!_ptr) {
        _ptr = &_fail_glGetNamedFramebufferParameteriv;
    }
    _glGetNamedFramebufferParameteriv = _ptr;
    _glGetNamedFramebufferParameteriv(framebuffer, pname, param);
}

PFN_GLGETNAMEDFRAMEBUFFERPARAMETERIV _glGetNamedFramebufferParameteriv = &_get_glGetNamedFramebufferParameteriv;

static void APIENTRY _fail_glGetNamedFramebufferAttachmentParameteriv(GLuint framebuffer, GLenum attachment, GLenum pname, GLint * params) {
    const char *_name = "glGetNamedFramebufferAttachmentParameteriv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetNamedFramebufferAttachmentParameteriv(GLuint framebuffer, GLenum attachment, GLenum pname, GLint * params) {
    PFN_GLGETNAMEDFRAMEBUFFERATTACHMENTPARAMETERIV _ptr;
    _ptr = (PFN_GLGETNAMEDFRAMEBUFFERATTACHMENTPARAMETERIV)_getPrivateProcAddress("glGetNamedFramebufferAttachmentParameteriv");
    if (!_ptr) {
        _ptr = &_fail_glGetNamedFramebufferAttachmentParameteriv;
    }
    _glGetNamedFramebufferAttachmentParameteriv = _ptr;
    _glGetNamedFramebufferAttachmentParameteriv(framebuffer, attachment, pname, params);
}

PFN_GLGETNAMEDFRAMEBUFFERATTACHMENTPARAMETERIV _glGetNamedFramebufferAttachmentParameteriv = &_get_glGetNamedFramebufferAttachmentParameteriv;

static void APIENTRY _fail_glCreateRenderbuffers(GLsizei n, GLuint * renderbuffers) {
    const char *_name = "glCreateRenderbuffers";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glCreateRenderbuffers(GLsizei n, GLuint * renderbuffers) {
    PFN_GLCREATERENDERBUFFERS _ptr;
    _ptr = (PFN_GLCREATERENDERBUFFERS)_getPrivateProcAddress("glCreateRenderbuffers");
    if (!_ptr) {
        _ptr = &_fail_glCreateRenderbuffers;
    }
    _glCreateRenderbuffers = _ptr;
    _glCreateRenderbuffers(n, renderbuffers);
}

PFN_GLCREATERENDERBUFFERS _glCreateRenderbuffers = &_get_glCreateRenderbuffers;

static void APIENTRY _fail_glNamedRenderbufferStorage(GLuint renderbuffer, GLenum internalformat, GLsizei width, GLsizei height) {
    const char *_name = "glNamedRenderbufferStorage";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glNamedRenderbufferStorage(GLuint renderbuffer, GLenum internalformat, GLsizei width, GLsizei height) {
    PFN_GLNAMEDRENDERBUFFERSTORAGE _ptr;
    _ptr = (PFN_GLNAMEDRENDERBUFFERSTORAGE)_getPrivateProcAddress("glNamedRenderbufferStorage");
    if (!_ptr) {
        _ptr = &_fail_glNamedRenderbufferStorage;
    }
    _glNamedRenderbufferStorage = _ptr;
    _glNamedRenderbufferStorage(renderbuffer, internalformat, width, height);
}

PFN_GLNAMEDRENDERBUFFERSTORAGE _glNamedRenderbufferStorage = &_get_glNamedRenderbufferStorage;

static void APIENTRY _fail_glNamedRenderbufferStorageMultisample(GLuint renderbuffer, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height) {
    const char *_name = "glNamedRenderbufferStorageMultisample";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glNamedRenderbufferStorageMultisample(GLuint renderbuffer, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height) {
    PFN_GLNAMEDRENDERBUFFERSTORAGEMULTISAMPLE _ptr;
    _ptr = (PFN_GLNAMEDRENDERBUFFERSTORAGEMULTISAMPLE)_getPrivateProcAddress("glNamedRenderbufferStorageMultisample");
    if (!_ptr) {
        _ptr = &_fail_glNamedRenderbufferStorageMultisample;
    }
    _glNamedRenderbufferStorageMultisample = _ptr;
    _glNamedRenderbufferStorageMultisample(renderbuffer, samples, internalformat, width, height);
}

PFN_GLNAMEDRENDERBUFFERSTORAGEMULTISAMPLE _glNamedRenderbufferStorageMultisample = &_get_glNamedRenderbufferStorageMultisample;

static void APIENTRY _fail_glGetNamedRenderbufferParameteriv(GLuint renderbuffer, GLenum pname, GLint * params) {
    const char *_name = "glGetNamedRenderbufferParameteriv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetNamedRenderbufferParameteriv(GLuint renderbuffer, GLenum pname, GLint * params) {
    PFN_GLGETNAMEDRENDERBUFFERPARAMETERIV _ptr;
    _ptr = (PFN_GLGETNAMEDRENDERBUFFERPARAMETERIV)_getPrivateProcAddress("glGetNamedRenderbufferParameteriv");
    if (!_ptr) {
        _ptr = &_fail_glGetNamedRenderbufferParameteriv;
    }
    _glGetNamedRenderbufferParameteriv = _ptr;
    _glGetNamedRenderbufferParameteriv(renderbuffer, pname, params);
}

PFN_GLGETNAMEDRENDERBUFFERPARAMETERIV _glGetNamedRenderbufferParameteriv = &_get_glGetNamedRenderbufferParameteriv;

static void APIENTRY _fail_glCreateTextures(GLenum target, GLsizei n, GLuint * textures) {
    const char *_name = "glCreateTextures";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glCreateTextures(GLenum target, GLsizei n, GLuint * textures) {
    PFN_GLCREATETEXTURES _ptr;
    _ptr = (PFN_GLCREATETEXTURES)_getPrivateProcAddress("glCreateTextures");
    if (!_ptr) {
        _ptr = &_fail_glCreateTextures;
    }
    _glCreateTextures = _ptr;
    _glCreateTextures(target, n, textures);
}

PFN_GLCREATETEXTURES _glCreateTextures = &_get_glCreateTextures;

static void APIENTRY _fail_glTextureBuffer(GLuint texture, GLenum internalformat, GLuint buffer) {
    const char *_name = "glTextureBuffer";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glTextureBuffer(GLuint texture, GLenum internalformat, GLuint buffer) {
    PFN_GLTEXTUREBUFFER _ptr;
    _ptr = (PFN_GLTEXTUREBUFFER)_getPrivateProcAddress("glTextureBuffer");
    if (!_ptr) {
        _ptr = &_fail_glTextureBuffer;
    }
    _glTextureBuffer = _ptr;
    _glTextureBuffer(texture, internalformat, buffer);
}

PFN_GLTEXTUREBUFFER _glTextureBuffer = &_get_glTextureBuffer;

static void APIENTRY _fail_glTextureBufferRange(GLuint texture, GLenum internalformat, GLuint buffer, GLintptr offset, GLsizeiptr size) {
    const char *_name = "glTextureBufferRange";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glTextureBufferRange(GLuint texture, GLenum internalformat, GLuint buffer, GLintptr offset, GLsizeiptr size) {
    PFN_GLTEXTUREBUFFERRANGE _ptr;
    _ptr = (PFN_GLTEXTUREBUFFERRANGE)_getPrivateProcAddress("glTextureBufferRange");
    if (!_ptr) {
        _ptr = &_fail_glTextureBufferRange;
    }
    _glTextureBufferRange = _ptr;
    _glTextureBufferRange(texture, internalformat, buffer, offset, size);
}

PFN_GLTEXTUREBUFFERRANGE _glTextureBufferRange = &_get_glTextureBufferRange;

static void APIENTRY _fail_glTextureStorage1D(GLuint texture, GLsizei levels, GLenum internalformat, GLsizei width) {
    const char *_name = "glTextureStorage1D";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glTextureStorage1D(GLuint texture, GLsizei levels, GLenum internalformat, GLsizei width) {
    PFN_GLTEXTURESTORAGE1D _ptr;
    _ptr = (PFN_GLTEXTURESTORAGE1D)_getPrivateProcAddress("glTextureStorage1D");
    if (!_ptr) {
        _ptr = &_fail_glTextureStorage1D;
    }
    _glTextureStorage1D = _ptr;
    _glTextureStorage1D(texture, levels, internalformat, width);
}

PFN_GLTEXTURESTORAGE1D _glTextureStorage1D = &_get_glTextureStorage1D;

static void APIENTRY _fail_glTextureStorage2D(GLuint texture, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height) {
    const char *_name = "glTextureStorage2D";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glTextureStorage2D(GLuint texture, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height) {
    PFN_GLTEXTURESTORAGE2D _ptr;
    _ptr = (PFN_GLTEXTURESTORAGE2D)_getPrivateProcAddress("glTextureStorage2D");
    if (!_ptr) {
        _ptr = &_fail_glTextureStorage2D;
    }
    _glTextureStorage2D = _ptr;
    _glTextureStorage2D(texture, levels, internalformat, width, height);
}

PFN_GLTEXTURESTORAGE2D _glTextureStorage2D = &_get_glTextureStorage2D;

static void APIENTRY _fail_glTextureStorage3D(GLuint texture, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth) {
    const char *_name = "glTextureStorage3D";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glTextureStorage3D(GLuint texture, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth) {
    PFN_GLTEXTURESTORAGE3D _ptr;
    _ptr = (PFN_GLTEXTURESTORAGE3D)_getPrivateProcAddress("glTextureStorage3D");
    if (!_ptr) {
        _ptr = &_fail_glTextureStorage3D;
    }
    _glTextureStorage3D = _ptr;
    _glTextureStorage3D(texture, levels, internalformat, width, height, depth);
}

PFN_GLTEXTURESTORAGE3D _glTextureStorage3D = &_get_glTextureStorage3D;

static void APIENTRY _fail_glTextureStorage2DMultisample(GLuint texture, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height, GLboolean fixedsamplelocations) {
    const char *_name = "glTextureStorage2DMultisample";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glTextureStorage2DMultisample(GLuint texture, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height, GLboolean fixedsamplelocations) {
    PFN_GLTEXTURESTORAGE2DMULTISAMPLE _ptr;
    _ptr = (PFN_GLTEXTURESTORAGE2DMULTISAMPLE)_getPrivateProcAddress("glTextureStorage2DMultisample");
    if (!_ptr) {
        _ptr = &_fail_glTextureStorage2DMultisample;
    }
    _glTextureStorage2DMultisample = _ptr;
    _glTextureStorage2DMultisample(texture, samples, internalformat, width, height, fixedsamplelocations);
}

PFN_GLTEXTURESTORAGE2DMULTISAMPLE _glTextureStorage2DMultisample = &_get_glTextureStorage2DMultisample;

static void APIENTRY _fail_glTextureStorage3DMultisample(GLuint texture, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLboolean fixedsamplelocations) {
    const char *_name = "glTextureStorage3DMultisample";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glTextureStorage3DMultisample(GLuint texture, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLboolean fixedsamplelocations) {
    PFN_GLTEXTURESTORAGE3DMULTISAMPLE _ptr;
    _ptr = (PFN_GLTEXTURESTORAGE3DMULTISAMPLE)_getPrivateProcAddress("glTextureStorage3DMultisample");
    if (!_ptr) {
        _ptr = &_fail_glTextureStorage3DMultisample;
    }
    _glTextureStorage3DMultisample = _ptr;
    _glTextureStorage3DMultisample(texture, samples, internalformat, width, height, depth, fixedsamplelocations);
}

PFN_GLTEXTURESTORAGE3DMULTISAMPLE _glTextureStorage3DMultisample = &_get_glTextureStorage3DMultisample;

static void APIENTRY _fail_glTextureSubImage1D(GLuint texture, GLint level, GLint xoffset, GLsizei width, GLenum format, GLenum type, const void * pixels) {
    const char *_name = "glTextureSubImage1D";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glTextureSubImage1D(GLuint texture, GLint level, GLint xoffset, GLsizei width, GLenum format, GLenum type, const void * pixels) {
    PFN_GLTEXTURESUBIMAGE1D _ptr;
    _ptr = (PFN_GLTEXTURESUBIMAGE1D)_getPrivateProcAddress("glTextureSubImage1D");
    if (!_ptr) {
        _ptr = &_fail_glTextureSubImage1D;
    }
    _glTextureSubImage1D = _ptr;
    _glTextureSubImage1D(texture, level, xoffset, width, format, type, pixels);
}

PFN_GLTEXTURESUBIMAGE1D _glTextureSubImage1D = &_get_glTextureSubImage1D;

static void APIENTRY _fail_glTextureSubImage2D(GLuint texture, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, const void * pixels) {
    const char *_name = "glTextureSubImage2D";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glTextureSubImage2D(GLuint texture, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, const void * pixels) {
    PFN_GLTEXTURESUBIMAGE2D _ptr;
    _ptr = (PFN_GLTEXTURESUBIMAGE2D)_getPrivateProcAddress("glTextureSubImage2D");
    if (!_ptr) {
        _ptr = &_fail_glTextureSubImage2D;
    }
    _glTextureSubImage2D = _ptr;
    _glTextureSubImage2D(texture, level, xoffset, yoffset, width, height, format, type, pixels);
}

PFN_GLTEXTURESUBIMAGE2D _glTextureSubImage2D = &_get_glTextureSubImage2D;

static void APIENTRY _fail_glTextureSubImage3D(GLuint texture, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, const void * pixels) {
    const char *_name = "glTextureSubImage3D";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glTextureSubImage3D(GLuint texture, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, const void * pixels) {
    PFN_GLTEXTURESUBIMAGE3D _ptr;
    _ptr = (PFN_GLTEXTURESUBIMAGE3D)_getPrivateProcAddress("glTextureSubImage3D");
    if (!_ptr) {
        _ptr = &_fail_glTextureSubImage3D;
    }
    _glTextureSubImage3D = _ptr;
    _glTextureSubImage3D(texture, level, xoffset, yoffset, zoffset, width, height, depth, format, type, pixels);
}

PFN_GLTEXTURESUBIMAGE3D _glTextureSubImage3D = &_get_glTextureSubImage3D;

static void APIENTRY _fail_glCompressedTextureSubImage1D(GLuint texture, GLint level, GLint xoffset, GLsizei width, GLenum format, GLsizei imageSize, const void * data) {
    const char *_name = "glCompressedTextureSubImage1D";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glCompressedTextureSubImage1D(GLuint texture, GLint level, GLint xoffset, GLsizei width, GLenum format, GLsizei imageSize, const void * data) {
    PFN_GLCOMPRESSEDTEXTURESUBIMAGE1D _ptr;
    _ptr = (PFN_GLCOMPRESSEDTEXTURESUBIMAGE1D)_getPrivateProcAddress("glCompressedTextureSubImage1D");
    if (!_ptr) {
        _ptr = &_fail_glCompressedTextureSubImage1D;
    }
    _glCompressedTextureSubImage1D = _ptr;
    _glCompressedTextureSubImage1D(texture, level, xoffset, width, format, imageSize, data);
}

PFN_GLCOMPRESSEDTEXTURESUBIMAGE1D _glCompressedTextureSubImage1D = &_get_glCompressedTextureSubImage1D;

static void APIENTRY _fail_glCompressedTextureSubImage2D(GLuint texture, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLsizei imageSize, const void * data) {
    const char *_name = "glCompressedTextureSubImage2D";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glCompressedTextureSubImage2D(GLuint texture, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLsizei imageSize, const void * data) {
    PFN_GLCOMPRESSEDTEXTURESUBIMAGE2D _ptr;
    _ptr = (PFN_GLCOMPRESSEDTEXTURESUBIMAGE2D)_getPrivateProcAddress("glCompressedTextureSubImage2D");
    if (!_ptr) {
        _ptr = &_fail_glCompressedTextureSubImage2D;
    }
    _glCompressedTextureSubImage2D = _ptr;
    _glCompressedTextureSubImage2D(texture, level, xoffset, yoffset, width, height, format, imageSize, data);
}

PFN_GLCOMPRESSEDTEXTURESUBIMAGE2D _glCompressedTextureSubImage2D = &_get_glCompressedTextureSubImage2D;

static void APIENTRY _fail_glCompressedTextureSubImage3D(GLuint texture, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLsizei imageSize, const void * data) {
    const char *_name = "glCompressedTextureSubImage3D";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glCompressedTextureSubImage3D(GLuint texture, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLsizei imageSize, const void * data) {
    PFN_GLCOMPRESSEDTEXTURESUBIMAGE3D _ptr;
    _ptr = (PFN_GLCOMPRESSEDTEXTURESUBIMAGE3D)_getPrivateProcAddress("glCompressedTextureSubImage3D");
    if (!_ptr) {
        _ptr = &_fail_glCompressedTextureSubImage3D;
    }
    _glCompressedTextureSubImage3D = _ptr;
    _glCompressedTextureSubImage3D(texture, level, xoffset, yoffset, zoffset, width, height, depth, format, imageSize, data);
}

PFN_GLCOMPRESSEDTEXTURESUBIMAGE3D _glCompressedTextureSubImage3D = &_get_glCompressedTextureSubImage3D;

static void APIENTRY _fail_glCopyTextureSubImage1D(GLuint texture, GLint level, GLint xoffset, GLint x, GLint y, GLsizei width) {
    const char *_name = "glCopyTextureSubImage1D";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glCopyTextureSubImage1D(GLuint texture, GLint level, GLint xoffset, GLint x, GLint y, GLsizei width) {
    PFN_GLCOPYTEXTURESUBIMAGE1D _ptr;
    _ptr = (PFN_GLCOPYTEXTURESUBIMAGE1D)_getPrivateProcAddress("glCopyTextureSubImage1D");
    if (!_ptr) {
        _ptr = &_fail_glCopyTextureSubImage1D;
    }
    _glCopyTextureSubImage1D = _ptr;
    _glCopyTextureSubImage1D(texture, level, xoffset, x, y, width);
}

PFN_GLCOPYTEXTURESUBIMAGE1D _glCopyTextureSubImage1D = &_get_glCopyTextureSubImage1D;

static void APIENTRY _fail_glCopyTextureSubImage2D(GLuint texture, GLint level, GLint xoffset, GLint yoffset, GLint x, GLint y, GLsizei width, GLsizei height) {
    const char *_name = "glCopyTextureSubImage2D";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glCopyTextureSubImage2D(GLuint texture, GLint level, GLint xoffset, GLint yoffset, GLint x, GLint y, GLsizei width, GLsizei height) {
    PFN_GLCOPYTEXTURESUBIMAGE2D _ptr;
    _ptr = (PFN_GLCOPYTEXTURESUBIMAGE2D)_getPrivateProcAddress("glCopyTextureSubImage2D");
    if (!_ptr) {
        _ptr = &_fail_glCopyTextureSubImage2D;
    }
    _glCopyTextureSubImage2D = _ptr;
    _glCopyTextureSubImage2D(texture, level, xoffset, yoffset, x, y, width, height);
}

PFN_GLCOPYTEXTURESUBIMAGE2D _glCopyTextureSubImage2D = &_get_glCopyTextureSubImage2D;

static void APIENTRY _fail_glCopyTextureSubImage3D(GLuint texture, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLint x, GLint y, GLsizei width, GLsizei height) {
    const char *_name = "glCopyTextureSubImage3D";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glCopyTextureSubImage3D(GLuint texture, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLint x, GLint y, GLsizei width, GLsizei height) {
    PFN_GLCOPYTEXTURESUBIMAGE3D _ptr;
    _ptr = (PFN_GLCOPYTEXTURESUBIMAGE3D)_getPrivateProcAddress("glCopyTextureSubImage3D");
    if (!_ptr) {
        _ptr = &_fail_glCopyTextureSubImage3D;
    }
    _glCopyTextureSubImage3D = _ptr;
    _glCopyTextureSubImage3D(texture, level, xoffset, yoffset, zoffset, x, y, width, height);
}

PFN_GLCOPYTEXTURESUBIMAGE3D _glCopyTextureSubImage3D = &_get_glCopyTextureSubImage3D;

static void APIENTRY _fail_glTextureParameterf(GLuint texture, GLenum pname, GLfloat param) {
    const char *_name = "glTextureParameterf";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glTextureParameterf(GLuint texture, GLenum pname, GLfloat param) {
    PFN_GLTEXTUREPARAMETERF _ptr;
    _ptr = (PFN_GLTEXTUREPARAMETERF)_getPrivateProcAddress("glTextureParameterf");
    if (!_ptr) {
        _ptr = &_fail_glTextureParameterf;
    }
    _glTextureParameterf = _ptr;
    _glTextureParameterf(texture, pname, param);
}

PFN_GLTEXTUREPARAMETERF _glTextureParameterf = &_get_glTextureParameterf;

static void APIENTRY _fail_glTextureParameterfv(GLuint texture, GLenum pname, const GLfloat * params) {
    const char *_name = "glTextureParameterfv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glTextureParameterfv(GLuint texture, GLenum pname, const GLfloat * params) {
    PFN_GLTEXTUREPARAMETERFV _ptr;
    _ptr = (PFN_GLTEXTUREPARAMETERFV)_getPrivateProcAddress("glTextureParameterfv");
    if (!_ptr) {
        _ptr = &_fail_glTextureParameterfv;
    }
    _glTextureParameterfv = _ptr;
    _glTextureParameterfv(texture, pname, params);
}

PFN_GLTEXTUREPARAMETERFV _glTextureParameterfv = &_get_glTextureParameterfv;

static void APIENTRY _fail_glTextureParameteri(GLuint texture, GLenum pname, GLint param) {
    const char *_name = "glTextureParameteri";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glTextureParameteri(GLuint texture, GLenum pname, GLint param) {
    PFN_GLTEXTUREPARAMETERI _ptr;
    _ptr = (PFN_GLTEXTUREPARAMETERI)_getPrivateProcAddress("glTextureParameteri");
    if (!_ptr) {
        _ptr = &_fail_glTextureParameteri;
    }
    _glTextureParameteri = _ptr;
    _glTextureParameteri(texture, pname, param);
}

PFN_GLTEXTUREPARAMETERI _glTextureParameteri = &_get_glTextureParameteri;

static void APIENTRY _fail_glTextureParameterIiv(GLuint texture, GLenum pname, const GLint * params) {
    const char *_name = "glTextureParameterIiv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glTextureParameterIiv(GLuint texture, GLenum pname, const GLint * params) {
    PFN_GLTEXTUREPARAMETERIIV _ptr;
    _ptr = (PFN_GLTEXTUREPARAMETERIIV)_getPrivateProcAddress("glTextureParameterIiv");
    if (!_ptr) {
        _ptr = &_fail_glTextureParameterIiv;
    }
    _glTextureParameterIiv = _ptr;
    _glTextureParameterIiv(texture, pname, params);
}

PFN_GLTEXTUREPARAMETERIIV _glTextureParameterIiv = &_get_glTextureParameterIiv;

static void APIENTRY _fail_glTextureParameterIuiv(GLuint texture, GLenum pname, const GLuint * params) {
    const char *_name = "glTextureParameterIuiv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glTextureParameterIuiv(GLuint texture, GLenum pname, const GLuint * params) {
    PFN_GLTEXTUREPARAMETERIUIV _ptr;
    _ptr = (PFN_GLTEXTUREPARAMETERIUIV)_getPrivateProcAddress("glTextureParameterIuiv");
    if (!_ptr) {
        _ptr = &_fail_glTextureParameterIuiv;
    }
    _glTextureParameterIuiv = _ptr;
    _glTextureParameterIuiv(texture, pname, params);
}

PFN_GLTEXTUREPARAMETERIUIV _glTextureParameterIuiv = &_get_glTextureParameterIuiv;

static void APIENTRY _fail_glTextureParameteriv(GLuint texture, GLenum pname, const GLint * params) {
    const char *_name = "glTextureParameteriv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glTextureParameteriv(GLuint texture, GLenum pname, const GLint * params) {
    PFN_GLTEXTUREPARAMETERIV _ptr;
    _ptr = (PFN_GLTEXTUREPARAMETERIV)_getPrivateProcAddress("glTextureParameteriv");
    if (!_ptr) {
        _ptr = &_fail_glTextureParameteriv;
    }
    _glTextureParameteriv = _ptr;
    _glTextureParameteriv(texture, pname, params);
}

PFN_GLTEXTUREPARAMETERIV _glTextureParameteriv = &_get_glTextureParameteriv;

static void APIENTRY _fail_glGenerateTextureMipmap(GLuint texture) {
    const char *_name = "glGenerateTextureMipmap";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGenerateTextureMipmap(GLuint texture) {
    PFN_GLGENERATETEXTUREMIPMAP _ptr;
    _ptr = (PFN_GLGENERATETEXTUREMIPMAP)_getPrivateProcAddress("glGenerateTextureMipmap");
    if (!_ptr) {
        _ptr = &_fail_glGenerateTextureMipmap;
    }
    _glGenerateTextureMipmap = _ptr;
    _glGenerateTextureMipmap(texture);
}

PFN_GLGENERATETEXTUREMIPMAP _glGenerateTextureMipmap = &_get_glGenerateTextureMipmap;

static void APIENTRY _fail_glBindTextureUnit(GLuint unit, GLuint texture) {
    const char *_name = "glBindTextureUnit";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glBindTextureUnit(GLuint unit, GLuint texture) {
    PFN_GLBINDTEXTUREUNIT _ptr;
    _ptr = (PFN_GLBINDTEXTUREUNIT)_getPrivateProcAddress("glBindTextureUnit");
    if (!_ptr) {
        _ptr = &_fail_glBindTextureUnit;
    }
    _glBindTextureUnit = _ptr;
    _glBindTextureUnit(unit, texture);
}

PFN_GLBINDTEXTUREUNIT _glBindTextureUnit = &_get_glBindTextureUnit;

static void APIENTRY _fail_glGetTextureImage(GLuint texture, GLint level, GLenum format, GLenum type, GLsizei bufSize, GLvoid * pixels) {
    const char *_name = "glGetTextureImage";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetTextureImage(GLuint texture, GLint level, GLenum format, GLenum type, GLsizei bufSize, GLvoid * pixels) {
    PFN_GLGETTEXTUREIMAGE _ptr;
    _ptr = (PFN_GLGETTEXTUREIMAGE)_getPrivateProcAddress("glGetTextureImage");
    if (!_ptr) {
        _ptr = &_fail_glGetTextureImage;
    }
    _glGetTextureImage = _ptr;
    _glGetTextureImage(texture, level, format, type, bufSize, pixels);
}

PFN_GLGETTEXTUREIMAGE _glGetTextureImage = &_get_glGetTextureImage;

static void APIENTRY _fail_glGetCompressedTextureImage(GLuint texture, GLint level, GLsizei bufSize, GLvoid * pixels) {
    const char *_name = "glGetCompressedTextureImage";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetCompressedTextureImage(GLuint texture, GLint level, GLsizei bufSize, GLvoid * pixels) {
    PFN_GLGETCOMPRESSEDTEXTUREIMAGE _ptr;
    _ptr = (PFN_GLGETCOMPRESSEDTEXTUREIMAGE)_getPrivateProcAddress("glGetCompressedTextureImage");
    if (!_ptr) {
        _ptr = &_fail_glGetCompressedTextureImage;
    }
    _glGetCompressedTextureImage = _ptr;
    _glGetCompressedTextureImage(texture, level, bufSize, pixels);
}

PFN_GLGETCOMPRESSEDTEXTUREIMAGE _glGetCompressedTextureImage = &_get_glGetCompressedTextureImage;

static void APIENTRY _fail_glGetTextureLevelParameterfv(GLuint texture, GLint level, GLenum pname, GLfloat * params) {
    const char *_name = "glGetTextureLevelParameterfv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetTextureLevelParameterfv(GLuint texture, GLint level, GLenum pname, GLfloat * params) {
    PFN_GLGETTEXTURELEVELPARAMETERFV _ptr;
    _ptr = (PFN_GLGETTEXTURELEVELPARAMETERFV)_getPrivateProcAddress("glGetTextureLevelParameterfv");
    if (!_ptr) {
        _ptr = &_fail_glGetTextureLevelParameterfv;
    }
    _glGetTextureLevelParameterfv = _ptr;
    _glGetTextureLevelParameterfv(texture, level, pname, params);
}

PFN_GLGETTEXTURELEVELPARAMETERFV _glGetTextureLevelParameterfv = &_get_glGetTextureLevelParameterfv;

static void APIENTRY _fail_glGetTextureLevelParameteriv(GLuint texture, GLint level, GLenum pname, GLint * params) {
    const char *_name = "glGetTextureLevelParameteriv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetTextureLevelParameteriv(GLuint texture, GLint level, GLenum pname, GLint * params) {
    PFN_GLGETTEXTURELEVELPARAMETERIV _ptr;
    _ptr = (PFN_GLGETTEXTURELEVELPARAMETERIV)_getPrivateProcAddress("glGetTextureLevelParameteriv");
    if (!_ptr) {
        _ptr = &_fail_glGetTextureLevelParameteriv;
    }
    _glGetTextureLevelParameteriv = _ptr;
    _glGetTextureLevelParameteriv(texture, level, pname, params);
}

PFN_GLGETTEXTURELEVELPARAMETERIV _glGetTextureLevelParameteriv = &_get_glGetTextureLevelParameteriv;

static void APIENTRY _fail_glGetTextureParameterfv(GLuint texture, GLenum pname, GLfloat * params) {
    const char *_name = "glGetTextureParameterfv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetTextureParameterfv(GLuint texture, GLenum pname, GLfloat * params) {
    PFN_GLGETTEXTUREPARAMETERFV _ptr;
    _ptr = (PFN_GLGETTEXTUREPARAMETERFV)_getPrivateProcAddress("glGetTextureParameterfv");
    if (!_ptr) {
        _ptr = &_fail_glGetTextureParameterfv;
    }
    _glGetTextureParameterfv = _ptr;
    _glGetTextureParameterfv(texture, pname, params);
}

PFN_GLGETTEXTUREPARAMETERFV _glGetTextureParameterfv = &_get_glGetTextureParameterfv;

static void APIENTRY _fail_glGetTextureParameterIiv(GLuint texture, GLenum pname, GLint * params) {
    const char *_name = "glGetTextureParameterIiv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetTextureParameterIiv(GLuint texture, GLenum pname, GLint * params) {
    PFN_GLGETTEXTUREPARAMETERIIV _ptr;
    _ptr = (PFN_GLGETTEXTUREPARAMETERIIV)_getPrivateProcAddress("glGetTextureParameterIiv");
    if (!_ptr) {
        _ptr = &_fail_glGetTextureParameterIiv;
    }
    _glGetTextureParameterIiv = _ptr;
    _glGetTextureParameterIiv(texture, pname, params);
}

PFN_GLGETTEXTUREPARAMETERIIV _glGetTextureParameterIiv = &_get_glGetTextureParameterIiv;

static void APIENTRY _fail_glGetTextureParameterIuiv(GLuint texture, GLenum pname, GLuint * params) {
    const char *_name = "glGetTextureParameterIuiv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetTextureParameterIuiv(GLuint texture, GLenum pname, GLuint * params) {
    PFN_GLGETTEXTUREPARAMETERIUIV _ptr;
    _ptr = (PFN_GLGETTEXTUREPARAMETERIUIV)_getPrivateProcAddress("glGetTextureParameterIuiv");
    if (!_ptr) {
        _ptr = &_fail_glGetTextureParameterIuiv;
    }
    _glGetTextureParameterIuiv = _ptr;
    _glGetTextureParameterIuiv(texture, pname, params);
}

PFN_GLGETTEXTUREPARAMETERIUIV _glGetTextureParameterIuiv = &_get_glGetTextureParameterIuiv;

static void APIENTRY _fail_glGetTextureParameteriv(GLuint texture, GLenum pname, GLint * params) {
    const char *_name = "glGetTextureParameteriv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetTextureParameteriv(GLuint texture, GLenum pname, GLint * params) {
    PFN_GLGETTEXTUREPARAMETERIV _ptr;
    _ptr = (PFN_GLGETTEXTUREPARAMETERIV)_getPrivateProcAddress("glGetTextureParameteriv");
    if (!_ptr) {
        _ptr = &_fail_glGetTextureParameteriv;
    }
    _glGetTextureParameteriv = _ptr;
    _glGetTextureParameteriv(texture, pname, params);
}

PFN_GLGETTEXTUREPARAMETERIV _glGetTextureParameteriv = &_get_glGetTextureParameteriv;

static void APIENTRY _fail_glCreateVertexArrays(GLsizei n, GLuint * arrays) {
    const char *_name = "glCreateVertexArrays";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glCreateVertexArrays(GLsizei n, GLuint * arrays) {
    PFN_GLCREATEVERTEXARRAYS _ptr;
    _ptr = (PFN_GLCREATEVERTEXARRAYS)_getPrivateProcAddress("glCreateVertexArrays");
    if (!_ptr) {
        _ptr = &_fail_glCreateVertexArrays;
    }
    _glCreateVertexArrays = _ptr;
    _glCreateVertexArrays(n, arrays);
}

PFN_GLCREATEVERTEXARRAYS _glCreateVertexArrays = &_get_glCreateVertexArrays;

static void APIENTRY _fail_glDisableVertexArrayAttrib(GLuint vaobj, GLuint index) {
    const char *_name = "glDisableVertexArrayAttrib";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glDisableVertexArrayAttrib(GLuint vaobj, GLuint index) {
    PFN_GLDISABLEVERTEXARRAYATTRIB _ptr;
    _ptr = (PFN_GLDISABLEVERTEXARRAYATTRIB)_getPrivateProcAddress("glDisableVertexArrayAttrib");
    if (!_ptr) {
        _ptr = &_fail_glDisableVertexArrayAttrib;
    }
    _glDisableVertexArrayAttrib = _ptr;
    _glDisableVertexArrayAttrib(vaobj, index);
}

PFN_GLDISABLEVERTEXARRAYATTRIB _glDisableVertexArrayAttrib = &_get_glDisableVertexArrayAttrib;

static void APIENTRY _fail_glEnableVertexArrayAttrib(GLuint vaobj, GLuint index) {
    const char *_name = "glEnableVertexArrayAttrib";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glEnableVertexArrayAttrib(GLuint vaobj, GLuint index) {
    PFN_GLENABLEVERTEXARRAYATTRIB _ptr;
    _ptr = (PFN_GLENABLEVERTEXARRAYATTRIB)_getPrivateProcAddress("glEnableVertexArrayAttrib");
    if (!_ptr) {
        _ptr = &_fail_glEnableVertexArrayAttrib;
    }
    _glEnableVertexArrayAttrib = _ptr;
    _glEnableVertexArrayAttrib(vaobj, index);
}

PFN_GLENABLEVERTEXARRAYATTRIB _glEnableVertexArrayAttrib = &_get_glEnableVertexArrayAttrib;

static void APIENTRY _fail_glVertexArrayElementBuffer(GLuint vaobj, GLuint buffer) {
    const char *_name = "glVertexArrayElementBuffer";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glVertexArrayElementBuffer(GLuint vaobj, GLuint buffer) {
    PFN_GLVERTEXARRAYELEMENTBUFFER _ptr;
    _ptr = (PFN_GLVERTEXARRAYELEMENTBUFFER)_getPrivateProcAddress("glVertexArrayElementBuffer");
    if (!_ptr) {
        _ptr = &_fail_glVertexArrayElementBuffer;
    }
    _glVertexArrayElementBuffer = _ptr;
    _glVertexArrayElementBuffer(vaobj, buffer);
}

PFN_GLVERTEXARRAYELEMENTBUFFER _glVertexArrayElementBuffer = &_get_glVertexArrayElementBuffer;

static void APIENTRY _fail_glVertexArrayVertexBuffer(GLuint vaobj, GLuint bindingindex, GLuint buffer, GLintptr offset, GLsizei stride) {
    const char *_name = "glVertexArrayVertexBuffer";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glVertexArrayVertexBuffer(GLuint vaobj, GLuint bindingindex, GLuint buffer, GLintptr offset, GLsizei stride) {
    PFN_GLVERTEXARRAYVERTEXBUFFER _ptr;
    _ptr = (PFN_GLVERTEXARRAYVERTEXBUFFER)_getPrivateProcAddress("glVertexArrayVertexBuffer");
    if (!_ptr) {
        _ptr = &_fail_glVertexArrayVertexBuffer;
    }
    _glVertexArrayVertexBuffer = _ptr;
    _glVertexArrayVertexBuffer(vaobj, bindingindex, buffer, offset, stride);
}

PFN_GLVERTEXARRAYVERTEXBUFFER _glVertexArrayVertexBuffer = &_get_glVertexArrayVertexBuffer;

static void APIENTRY _fail_glVertexArrayVertexBuffers(GLuint vaobj, GLuint first, GLsizei count, const GLuint * buffers, const GLintptr * offsets, const GLsizei * strides) {
    const char *_name = "glVertexArrayVertexBuffers";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glVertexArrayVertexBuffers(GLuint vaobj, GLuint first, GLsizei count, const GLuint * buffers, const GLintptr * offsets, const GLsizei * strides) {
    PFN_GLVERTEXARRAYVERTEXBUFFERS _ptr;
    _ptr = (PFN_GLVERTEXARRAYVERTEXBUFFERS)_getPrivateProcAddress("glVertexArrayVertexBuffers");
    if (!_ptr) {
        _ptr = &_fail_glVertexArrayVertexBuffers;
    }
    _glVertexArrayVertexBuffers = _ptr;
    _glVertexArrayVertexBuffers(vaobj, first, count, buffers, offsets, strides);
}

PFN_GLVERTEXARRAYVERTEXBUFFERS _glVertexArrayVertexBuffers = &_get_glVertexArrayVertexBuffers;

static void APIENTRY _fail_glVertexArrayAttribBinding(GLuint vaobj, GLuint attribindex, GLuint bindingindex) {
    const char *_name = "glVertexArrayAttribBinding";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glVertexArrayAttribBinding(GLuint vaobj, GLuint attribindex, GLuint bindingindex) {
    PFN_GLVERTEXARRAYATTRIBBINDING _ptr;
    _ptr = (PFN_GLVERTEXARRAYATTRIBBINDING)_getPrivateProcAddress("glVertexArrayAttribBinding");
    if (!_ptr) {
        _ptr = &_fail_glVertexArrayAttribBinding;
    }
    _glVertexArrayAttribBinding = _ptr;
    _glVertexArrayAttribBinding(vaobj, attribindex, bindingindex);
}

PFN_GLVERTEXARRAYATTRIBBINDING _glVertexArrayAttribBinding = &_get_glVertexArrayAttribBinding;

static void APIENTRY _fail_glVertexArrayAttribFormat(GLuint vaobj, GLuint attribindex, GLint size, GLenum type, GLboolean normalized, GLuint relativeoffset) {
    const char *_name = "glVertexArrayAttribFormat";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glVertexArrayAttribFormat(GLuint vaobj, GLuint attribindex, GLint size, GLenum type, GLboolean normalized, GLuint relativeoffset) {
    PFN_GLVERTEXARRAYATTRIBFORMAT _ptr;
    _ptr = (PFN_GLVERTEXARRAYATTRIBFORMAT)_getPrivateProcAddress("glVertexArrayAttribFormat");
    if (!_ptr) {
        _ptr = &_fail_glVertexArrayAttribFormat;
    }
    _glVertexArrayAttribFormat = _ptr;
    _glVertexArrayAttribFormat(vaobj, attribindex, size, type, normalized, relativeoffset);
}

PFN_GLVERTEXARRAYATTRIBFORMAT _glVertexArrayAttribFormat = &_get_glVertexArrayAttribFormat;

static void APIENTRY _fail_glVertexArrayAttribIFormat(GLuint vaobj, GLuint attribindex, GLint size, GLenum type, GLuint relativeoffset) {
    const char *_name = "glVertexArrayAttribIFormat";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glVertexArrayAttribIFormat(GLuint vaobj, GLuint attribindex, GLint size, GLenum type, GLuint relativeoffset) {
    PFN_GLVERTEXARRAYATTRIBIFORMAT _ptr;
    _ptr = (PFN_GLVERTEXARRAYATTRIBIFORMAT)_getPrivateProcAddress("glVertexArrayAttribIFormat");
    if (!_ptr) {
        _ptr = &_fail_glVertexArrayAttribIFormat;
    }
    _glVertexArrayAttribIFormat = _ptr;
    _glVertexArrayAttribIFormat(vaobj, attribindex, size, type, relativeoffset);
}

PFN_GLVERTEXARRAYATTRIBIFORMAT _glVertexArrayAttribIFormat = &_get_glVertexArrayAttribIFormat;

static void APIENTRY _fail_glVertexArrayAttribLFormat(GLuint vaobj, GLuint attribindex, GLint size, GLenum type, GLuint relativeoffset) {
    const char *_name = "glVertexArrayAttribLFormat";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glVertexArrayAttribLFormat(GLuint vaobj, GLuint attribindex, GLint size, GLenum type, GLuint relativeoffset) {
    PFN_GLVERTEXARRAYATTRIBLFORMAT _ptr;
    _ptr = (PFN_GLVERTEXARRAYATTRIBLFORMAT)_getPrivateProcAddress("glVertexArrayAttribLFormat");
    if (!_ptr) {
        _ptr = &_fail_glVertexArrayAttribLFormat;
    }
    _glVertexArrayAttribLFormat = _ptr;
    _glVertexArrayAttribLFormat(vaobj, attribindex, size, type, relativeoffset);
}

PFN_GLVERTEXARRAYATTRIBLFORMAT _glVertexArrayAttribLFormat = &_get_glVertexArrayAttribLFormat;

static void APIENTRY _fail_glVertexArrayBindingDivisor(GLuint vaobj, GLuint bindingindex, GLuint divisor) {
    const char *_name = "glVertexArrayBindingDivisor";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glVertexArrayBindingDivisor(GLuint vaobj, GLuint bindingindex, GLuint divisor) {
    PFN_GLVERTEXARRAYBINDINGDIVISOR _ptr;
    _ptr = (PFN_GLVERTEXARRAYBINDINGDIVISOR)_getPrivateProcAddress("glVertexArrayBindingDivisor");
    if (!_ptr) {
        _ptr = &_fail_glVertexArrayBindingDivisor;
    }
    _glVertexArrayBindingDivisor = _ptr;
    _glVertexArrayBindingDivisor(vaobj, bindingindex, divisor);
}

PFN_GLVERTEXARRAYBINDINGDIVISOR _glVertexArrayBindingDivisor = &_get_glVertexArrayBindingDivisor;

static void APIENTRY _fail_glGetVertexArrayiv(GLuint vaobj, GLenum pname, GLint * param) {
    const char *_name = "glGetVertexArrayiv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetVertexArrayiv(GLuint vaobj, GLenum pname, GLint * param) {
    PFN_GLGETVERTEXARRAYIV _ptr;
    _ptr = (PFN_GLGETVERTEXARRAYIV)_getPrivateProcAddress("glGetVertexArrayiv");
    if (!_ptr) {
        _ptr = &_fail_glGetVertexArrayiv;
    }
    _glGetVertexArrayiv = _ptr;
    _glGetVertexArrayiv(vaobj, pname, param);
}

PFN_GLGETVERTEXARRAYIV _glGetVertexArrayiv = &_get_glGetVertexArrayiv;

static void APIENTRY _fail_glGetVertexArrayIndexediv(GLuint vaobj, GLuint index, GLenum pname, GLint * param) {
    const char *_name = "glGetVertexArrayIndexediv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetVertexArrayIndexediv(GLuint vaobj, GLuint index, GLenum pname, GLint * param) {
    PFN_GLGETVERTEXARRAYINDEXEDIV _ptr;
    _ptr = (PFN_GLGETVERTEXARRAYINDEXEDIV)_getPrivateProcAddress("glGetVertexArrayIndexediv");
    if (!_ptr) {
        _ptr = &_fail_glGetVertexArrayIndexediv;
    }
    _glGetVertexArrayIndexediv = _ptr;
    _glGetVertexArrayIndexediv(vaobj, index, pname, param);
}

PFN_GLGETVERTEXARRAYINDEXEDIV _glGetVertexArrayIndexediv = &_get_glGetVertexArrayIndexediv;

static void APIENTRY _fail_glGetVertexArrayIndexed64iv(GLuint vaobj, GLuint index, GLenum pname, GLint64 * param) {
    const char *_name = "glGetVertexArrayIndexed64iv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetVertexArrayIndexed64iv(GLuint vaobj, GLuint index, GLenum pname, GLint64 * param) {
    PFN_GLGETVERTEXARRAYINDEXED64IV _ptr;
    _ptr = (PFN_GLGETVERTEXARRAYINDEXED64IV)_getPrivateProcAddress("glGetVertexArrayIndexed64iv");
    if (!_ptr) {
        _ptr = &_fail_glGetVertexArrayIndexed64iv;
    }
    _glGetVertexArrayIndexed64iv = _ptr;
    _glGetVertexArrayIndexed64iv(vaobj, index, pname, param);
}

PFN_GLGETVERTEXARRAYINDEXED64IV _glGetVertexArrayIndexed64iv = &_get_glGetVertexArrayIndexed64iv;

static void APIENTRY _fail_glCreateSamplers(GLsizei n, GLuint * samplers) {
    const char *_name = "glCreateSamplers";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glCreateSamplers(GLsizei n, GLuint * samplers) {
    PFN_GLCREATESAMPLERS _ptr;
    _ptr = (PFN_GLCREATESAMPLERS)_getPrivateProcAddress("glCreateSamplers");
    if (!_ptr) {
        _ptr = &_fail_glCreateSamplers;
    }
    _glCreateSamplers = _ptr;
    _glCreateSamplers(n, samplers);
}

PFN_GLCREATESAMPLERS _glCreateSamplers = &_get_glCreateSamplers;

static void APIENTRY _fail_glCreateProgramPipelines(GLsizei n, GLuint * pipelines) {
    const char *_name = "glCreateProgramPipelines";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glCreateProgramPipelines(GLsizei n, GLuint * pipelines) {
    PFN_GLCREATEPROGRAMPIPELINES _ptr;
    _ptr = (PFN_GLCREATEPROGRAMPIPELINES)_getPrivateProcAddress("glCreateProgramPipelines");
    if (!_ptr) {
        _ptr = &_fail_glCreateProgramPipelines;
    }
    _glCreateProgramPipelines = _ptr;
    _glCreateProgramPipelines(n, pipelines);
}

PFN_GLCREATEPROGRAMPIPELINES _glCreateProgramPipelines = &_get_glCreateProgramPipelines;

static void APIENTRY _fail_glCreateQueries(GLenum target, GLsizei n, GLuint * ids) {
    const char *_name = "glCreateQueries";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glCreateQueries(GLenum target, GLsizei n, GLuint * ids) {
    PFN_GLCREATEQUERIES _ptr;
    _ptr = (PFN_GLCREATEQUERIES)_getPrivateProcAddress("glCreateQueries");
    if (!_ptr) {
        _ptr = &_fail_glCreateQueries;
    }
    _glCreateQueries = _ptr;
    _glCreateQueries(target, n, ids);
}

PFN_GLCREATEQUERIES _glCreateQueries = &_get_glCreateQueries;

static void APIENTRY _fail_glGetQueryBufferObjecti64v(GLuint id, GLuint buffer, GLenum pname, GLintptr offset) {
    const char *_name = "glGetQueryBufferObjecti64v";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetQueryBufferObjecti64v(GLuint id, GLuint buffer, GLenum pname, GLintptr offset) {
    PFN_GLGETQUERYBUFFEROBJECTI64V _ptr;
    _ptr = (PFN_GLGETQUERYBUFFEROBJECTI64V)_getPrivateProcAddress("glGetQueryBufferObjecti64v");
    if (!_ptr) {
        _ptr = &_fail_glGetQueryBufferObjecti64v;
    }
    _glGetQueryBufferObjecti64v = _ptr;
    _glGetQueryBufferObjecti64v(id, buffer, pname, offset);
}

PFN_GLGETQUERYBUFFEROBJECTI64V _glGetQueryBufferObjecti64v = &_get_glGetQueryBufferObjecti64v;

static void APIENTRY _fail_glGetQueryBufferObjectiv(GLuint id, GLuint buffer, GLenum pname, GLintptr offset) {
    const char *_name = "glGetQueryBufferObjectiv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetQueryBufferObjectiv(GLuint id, GLuint buffer, GLenum pname, GLintptr offset) {
    PFN_GLGETQUERYBUFFEROBJECTIV _ptr;
    _ptr = (PFN_GLGETQUERYBUFFEROBJECTIV)_getPrivateProcAddress("glGetQueryBufferObjectiv");
    if (!_ptr) {
        _ptr = &_fail_glGetQueryBufferObjectiv;
    }
    _glGetQueryBufferObjectiv = _ptr;
    _glGetQueryBufferObjectiv(id, buffer, pname, offset);
}

PFN_GLGETQUERYBUFFEROBJECTIV _glGetQueryBufferObjectiv = &_get_glGetQueryBufferObjectiv;

static void APIENTRY _fail_glGetQueryBufferObjectui64v(GLuint id, GLuint buffer, GLenum pname, GLintptr offset) {
    const char *_name = "glGetQueryBufferObjectui64v";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetQueryBufferObjectui64v(GLuint id, GLuint buffer, GLenum pname, GLintptr offset) {
    PFN_GLGETQUERYBUFFEROBJECTUI64V _ptr;
    _ptr = (PFN_GLGETQUERYBUFFEROBJECTUI64V)_getPrivateProcAddress("glGetQueryBufferObjectui64v");
    if (!_ptr) {
        _ptr = &_fail_glGetQueryBufferObjectui64v;
    }
    _glGetQueryBufferObjectui64v = _ptr;
    _glGetQueryBufferObjectui64v(id, buffer, pname, offset);
}

PFN_GLGETQUERYBUFFEROBJECTUI64V _glGetQueryBufferObjectui64v = &_get_glGetQueryBufferObjectui64v;

static void APIENTRY _fail_glGetQueryBufferObjectuiv(GLuint id, GLuint buffer, GLenum pname, GLintptr offset) {
    const char *_name = "glGetQueryBufferObjectuiv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetQueryBufferObjectuiv(GLuint id, GLuint buffer, GLenum pname, GLintptr offset) {
    PFN_GLGETQUERYBUFFEROBJECTUIV _ptr;
    _ptr = (PFN_GLGETQUERYBUFFEROBJECTUIV)_getPrivateProcAddress("glGetQueryBufferObjectuiv");
    if (!_ptr) {
        _ptr = &_fail_glGetQueryBufferObjectuiv;
    }
    _glGetQueryBufferObjectuiv = _ptr;
    _glGetQueryBufferObjectuiv(id, buffer, pname, offset);
}

PFN_GLGETQUERYBUFFEROBJECTUIV _glGetQueryBufferObjectuiv = &_get_glGetQueryBufferObjectuiv;

static void APIENTRY _fail_glDrawBuffersARB(GLsizei n, const GLenum * bufs) {
    const char *_name = "glDrawBuffersARB";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glDrawBuffersARB(GLsizei n, const GLenum * bufs) {
    PFN_GLDRAWBUFFERSARB _ptr;
    _ptr = (PFN_GLDRAWBUFFERSARB)_getPrivateProcAddress("glDrawBuffersARB");
    if (!_ptr) {
        _ptr = &_fail_glDrawBuffersARB;
    }
    _glDrawBuffersARB = _ptr;
    _glDrawBuffersARB(n, bufs);
}

PFN_GLDRAWBUFFERSARB _glDrawBuffersARB = &_get_glDrawBuffersARB;

static void APIENTRY _fail_glBlendEquationiARB(GLuint buf, GLenum mode) {
    const char *_name = "glBlendEquationiARB";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glBlendEquationiARB(GLuint buf, GLenum mode) {
    PFN_GLBLENDEQUATIONIARB _ptr;
    _ptr = (PFN_GLBLENDEQUATIONIARB)_getPrivateProcAddress("glBlendEquationiARB");
    if (!_ptr) {
        _ptr = &_fail_glBlendEquationiARB;
    }
    _glBlendEquationiARB = _ptr;
    _glBlendEquationiARB(buf, mode);
}

PFN_GLBLENDEQUATIONIARB _glBlendEquationiARB = &_get_glBlendEquationiARB;

static void APIENTRY _fail_glBlendEquationSeparateiARB(GLuint buf, GLenum modeRGB, GLenum modeAlpha) {
    const char *_name = "glBlendEquationSeparateiARB";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glBlendEquationSeparateiARB(GLuint buf, GLenum modeRGB, GLenum modeAlpha) {
    PFN_GLBLENDEQUATIONSEPARATEIARB _ptr;
    _ptr = (PFN_GLBLENDEQUATIONSEPARATEIARB)_getPrivateProcAddress("glBlendEquationSeparateiARB");
    if (!_ptr) {
        _ptr = &_fail_glBlendEquationSeparateiARB;
    }
    _glBlendEquationSeparateiARB = _ptr;
    _glBlendEquationSeparateiARB(buf, modeRGB, modeAlpha);
}

PFN_GLBLENDEQUATIONSEPARATEIARB _glBlendEquationSeparateiARB = &_get_glBlendEquationSeparateiARB;

static void APIENTRY _fail_glBlendFunciARB(GLuint buf, GLenum src, GLenum dst) {
    const char *_name = "glBlendFunciARB";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glBlendFunciARB(GLuint buf, GLenum src, GLenum dst) {
    PFN_GLBLENDFUNCIARB _ptr;
    _ptr = (PFN_GLBLENDFUNCIARB)_getPrivateProcAddress("glBlendFunciARB");
    if (!_ptr) {
        _ptr = &_fail_glBlendFunciARB;
    }
    _glBlendFunciARB = _ptr;
    _glBlendFunciARB(buf, src, dst);
}

PFN_GLBLENDFUNCIARB _glBlendFunciARB = &_get_glBlendFunciARB;

static void APIENTRY _fail_glBlendFuncSeparateiARB(GLuint buf, GLenum srcRGB, GLenum dstRGB, GLenum srcAlpha, GLenum dstAlpha) {
    const char *_name = "glBlendFuncSeparateiARB";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glBlendFuncSeparateiARB(GLuint buf, GLenum srcRGB, GLenum dstRGB, GLenum srcAlpha, GLenum dstAlpha) {
    PFN_GLBLENDFUNCSEPARATEIARB _ptr;
    _ptr = (PFN_GLBLENDFUNCSEPARATEIARB)_getPrivateProcAddress("glBlendFuncSeparateiARB");
    if (!_ptr) {
        _ptr = &_fail_glBlendFuncSeparateiARB;
    }
    _glBlendFuncSeparateiARB = _ptr;
    _glBlendFuncSeparateiARB(buf, srcRGB, dstRGB, srcAlpha, dstAlpha);
}

PFN_GLBLENDFUNCSEPARATEIARB _glBlendFuncSeparateiARB = &_get_glBlendFuncSeparateiARB;

static void APIENTRY _fail_glDrawElementsBaseVertex(GLenum mode, GLsizei count, GLenum type, const GLvoid * indices, GLint basevertex) {
    const char *_name = "glDrawElementsBaseVertex";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glDrawElementsBaseVertex(GLenum mode, GLsizei count, GLenum type, const GLvoid * indices, GLint basevertex) {
    PFN_GLDRAWELEMENTSBASEVERTEX _ptr;
    _ptr = (PFN_GLDRAWELEMENTSBASEVERTEX)_getPrivateProcAddress("glDrawElementsBaseVertex");
    if (!_ptr) {
        _ptr = &_fail_glDrawElementsBaseVertex;
    }
    _glDrawElementsBaseVertex = _ptr;
    _glDrawElementsBaseVertex(mode, count, type, indices, basevertex);
}

PFN_GLDRAWELEMENTSBASEVERTEX _glDrawElementsBaseVertex = &_get_glDrawElementsBaseVertex;

static void APIENTRY _fail_glDrawRangeElementsBaseVertex(GLenum mode, GLuint start, GLuint end, GLsizei count, GLenum type, const GLvoid * indices, GLint basevertex) {
    const char *_name = "glDrawRangeElementsBaseVertex";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glDrawRangeElementsBaseVertex(GLenum mode, GLuint start, GLuint end, GLsizei count, GLenum type, const GLvoid * indices, GLint basevertex) {
    PFN_GLDRAWRANGEELEMENTSBASEVERTEX _ptr;
    _ptr = (PFN_GLDRAWRANGEELEMENTSBASEVERTEX)_getPrivateProcAddress("glDrawRangeElementsBaseVertex");
    if (!_ptr) {
        _ptr = &_fail_glDrawRangeElementsBaseVertex;
    }
    _glDrawRangeElementsBaseVertex = _ptr;
    _glDrawRangeElementsBaseVertex(mode, start, end, count, type, indices, basevertex);
}

PFN_GLDRAWRANGEELEMENTSBASEVERTEX _glDrawRangeElementsBaseVertex = &_get_glDrawRangeElementsBaseVertex;

static void APIENTRY _fail_glDrawElementsInstancedBaseVertex(GLenum mode, GLsizei count, GLenum type, const GLvoid * indices, GLsizei instancecount, GLint basevertex) {
    const char *_name = "glDrawElementsInstancedBaseVertex";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glDrawElementsInstancedBaseVertex(GLenum mode, GLsizei count, GLenum type, const GLvoid * indices, GLsizei instancecount, GLint basevertex) {
    PFN_GLDRAWELEMENTSINSTANCEDBASEVERTEX _ptr;
    _ptr = (PFN_GLDRAWELEMENTSINSTANCEDBASEVERTEX)_getPrivateProcAddress("glDrawElementsInstancedBaseVertex");
    if (!_ptr) {
        _ptr = &_fail_glDrawElementsInstancedBaseVertex;
    }
    _glDrawElementsInstancedBaseVertex = _ptr;
    _glDrawElementsInstancedBaseVertex(mode, count, type, indices, instancecount, basevertex);
}

PFN_GLDRAWELEMENTSINSTANCEDBASEVERTEX _glDrawElementsInstancedBaseVertex = &_get_glDrawElementsInstancedBaseVertex;

static void APIENTRY _fail_glMultiDrawElementsBaseVertex(GLenum mode, const GLsizei * count, GLenum type, const GLvoid * const * indices, GLsizei drawcount, const GLint * basevertex) {
    const char *_name = "glMultiDrawElementsBaseVertex";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glMultiDrawElementsBaseVertex(GLenum mode, const GLsizei * count, GLenum type, const GLvoid * const * indices, GLsizei drawcount, const GLint * basevertex) {
    PFN_GLMULTIDRAWELEMENTSBASEVERTEX _ptr;
    _ptr = (PFN_GLMULTIDRAWELEMENTSBASEVERTEX)_getPrivateProcAddress("glMultiDrawElementsBaseVertex");
    if (!_ptr) {
        _ptr = &_fail_glMultiDrawElementsBaseVertex;
    }
    _glMultiDrawElementsBaseVertex = _ptr;
    _glMultiDrawElementsBaseVertex(mode, count, type, indices, drawcount, basevertex);
}

PFN_GLMULTIDRAWELEMENTSBASEVERTEX _glMultiDrawElementsBaseVertex = &_get_glMultiDrawElementsBaseVertex;

static void APIENTRY _fail_glDrawArraysIndirect(GLenum mode, const GLvoid * indirect) {
    const char *_name = "glDrawArraysIndirect";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glDrawArraysIndirect(GLenum mode, const GLvoid * indirect) {
    PFN_GLDRAWARRAYSINDIRECT _ptr;
    _ptr = (PFN_GLDRAWARRAYSINDIRECT)_getPrivateProcAddress("glDrawArraysIndirect");
    if (!_ptr) {
        _ptr = &_fail_glDrawArraysIndirect;
    }
    _glDrawArraysIndirect = _ptr;
    _glDrawArraysIndirect(mode, indirect);
}

PFN_GLDRAWARRAYSINDIRECT _glDrawArraysIndirect = &_get_glDrawArraysIndirect;

static void APIENTRY _fail_glDrawElementsIndirect(GLenum mode, GLenum type, const GLvoid * indirect) {
    const char *_name = "glDrawElementsIndirect";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glDrawElementsIndirect(GLenum mode, GLenum type, const GLvoid * indirect) {
    PFN_GLDRAWELEMENTSINDIRECT _ptr;
    _ptr = (PFN_GLDRAWELEMENTSINDIRECT)_getPrivateProcAddress("glDrawElementsIndirect");
    if (!_ptr) {
        _ptr = &_fail_glDrawElementsIndirect;
    }
    _glDrawElementsIndirect = _ptr;
    _glDrawElementsIndirect(mode, type, indirect);
}

PFN_GLDRAWELEMENTSINDIRECT _glDrawElementsIndirect = &_get_glDrawElementsIndirect;

static void APIENTRY _fail_glDrawArraysInstancedARB(GLenum mode, GLint first, GLsizei count, GLsizei instancecount) {
    const char *_name = "glDrawArraysInstancedARB";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glDrawArraysInstancedARB(GLenum mode, GLint first, GLsizei count, GLsizei instancecount) {
    PFN_GLDRAWARRAYSINSTANCEDARB _ptr;
    _ptr = (PFN_GLDRAWARRAYSINSTANCEDARB)_getPrivateProcAddress("glDrawArraysInstancedARB");
    if (!_ptr) {
        _ptr = &_fail_glDrawArraysInstancedARB;
    }
    _glDrawArraysInstancedARB = _ptr;
    _glDrawArraysInstancedARB(mode, first, count, instancecount);
}

PFN_GLDRAWARRAYSINSTANCEDARB _glDrawArraysInstancedARB = &_get_glDrawArraysInstancedARB;

static void APIENTRY _fail_glDrawElementsInstancedARB(GLenum mode, GLsizei count, GLenum type, const GLvoid * indices, GLsizei instancecount) {
    const char *_name = "glDrawElementsInstancedARB";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glDrawElementsInstancedARB(GLenum mode, GLsizei count, GLenum type, const GLvoid * indices, GLsizei instancecount) {
    PFN_GLDRAWELEMENTSINSTANCEDARB _ptr;
    _ptr = (PFN_GLDRAWELEMENTSINSTANCEDARB)_getPrivateProcAddress("glDrawElementsInstancedARB");
    if (!_ptr) {
        _ptr = &_fail_glDrawElementsInstancedARB;
    }
    _glDrawElementsInstancedARB = _ptr;
    _glDrawElementsInstancedARB(mode, count, type, indices, instancecount);
}

PFN_GLDRAWELEMENTSINSTANCEDARB _glDrawElementsInstancedARB = &_get_glDrawElementsInstancedARB;

static void APIENTRY _fail_glFramebufferParameteri(GLenum target, GLenum pname, GLint param) {
    const char *_name = "glFramebufferParameteri";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glFramebufferParameteri(GLenum target, GLenum pname, GLint param) {
    PFN_GLFRAMEBUFFERPARAMETERI _ptr;
    _ptr = (PFN_GLFRAMEBUFFERPARAMETERI)_getPrivateProcAddress("glFramebufferParameteri");
    if (!_ptr) {
        _ptr = &_fail_glFramebufferParameteri;
    }
    _glFramebufferParameteri = _ptr;
    _glFramebufferParameteri(target, pname, param);
}

PFN_GLFRAMEBUFFERPARAMETERI _glFramebufferParameteri = &_get_glFramebufferParameteri;

static void APIENTRY _fail_glGetFramebufferParameteriv(GLenum target, GLenum pname, GLint * params) {
    const char *_name = "glGetFramebufferParameteriv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetFramebufferParameteriv(GLenum target, GLenum pname, GLint * params) {
    PFN_GLGETFRAMEBUFFERPARAMETERIV _ptr;
    _ptr = (PFN_GLGETFRAMEBUFFERPARAMETERIV)_getPrivateProcAddress("glGetFramebufferParameteriv");
    if (!_ptr) {
        _ptr = &_fail_glGetFramebufferParameteriv;
    }
    _glGetFramebufferParameteriv = _ptr;
    _glGetFramebufferParameteriv(target, pname, params);
}

PFN_GLGETFRAMEBUFFERPARAMETERIV _glGetFramebufferParameteriv = &_get_glGetFramebufferParameteriv;

static GLboolean APIENTRY _fail_glIsRenderbuffer(GLuint renderbuffer) {
    const char *_name = "glIsRenderbuffer";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static GLboolean APIENTRY _get_glIsRenderbuffer(GLuint renderbuffer) {
    PFN_GLISRENDERBUFFER _ptr;
    _ptr = (PFN_GLISRENDERBUFFER)_getPrivateProcAddress("glIsRenderbuffer");
    if (!_ptr) {
        _ptr = &_fail_glIsRenderbuffer;
    }
    _glIsRenderbuffer = _ptr;
    return _glIsRenderbuffer(renderbuffer);
}

PFN_GLISRENDERBUFFER _glIsRenderbuffer = &_get_glIsRenderbuffer;

static void APIENTRY _fail_glBindRenderbuffer(GLenum target, GLuint renderbuffer) {
    const char *_name = "glBindRenderbuffer";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glBindRenderbuffer(GLenum target, GLuint renderbuffer) {
    PFN_GLBINDRENDERBUFFER _ptr;
    _ptr = (PFN_GLBINDRENDERBUFFER)_getPrivateProcAddress("glBindRenderbuffer");
    if (!_ptr) {
        _ptr = &_fail_glBindRenderbuffer;
    }
    _glBindRenderbuffer = _ptr;
    _glBindRenderbuffer(target, renderbuffer);
}

PFN_GLBINDRENDERBUFFER _glBindRenderbuffer = &_get_glBindRenderbuffer;

static void APIENTRY _fail_glDeleteRenderbuffers(GLsizei n, const GLuint * renderbuffers) {
    const char *_name = "glDeleteRenderbuffers";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glDeleteRenderbuffers(GLsizei n, const GLuint * renderbuffers) {
    PFN_GLDELETERENDERBUFFERS _ptr;
    _ptr = (PFN_GLDELETERENDERBUFFERS)_getPrivateProcAddress("glDeleteRenderbuffers");
    if (!_ptr) {
        _ptr = &_fail_glDeleteRenderbuffers;
    }
    _glDeleteRenderbuffers = _ptr;
    _glDeleteRenderbuffers(n, renderbuffers);
}

PFN_GLDELETERENDERBUFFERS _glDeleteRenderbuffers = &_get_glDeleteRenderbuffers;

static void APIENTRY _fail_glGenRenderbuffers(GLsizei n, GLuint * renderbuffers) {
    const char *_name = "glGenRenderbuffers";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGenRenderbuffers(GLsizei n, GLuint * renderbuffers) {
    PFN_GLGENRENDERBUFFERS _ptr;
    _ptr = (PFN_GLGENRENDERBUFFERS)_getPrivateProcAddress("glGenRenderbuffers");
    if (!_ptr) {
        _ptr = &_fail_glGenRenderbuffers;
    }
    _glGenRenderbuffers = _ptr;
    _glGenRenderbuffers(n, renderbuffers);
}

PFN_GLGENRENDERBUFFERS _glGenRenderbuffers = &_get_glGenRenderbuffers;

static void APIENTRY _fail_glRenderbufferStorage(GLenum target, GLenum internalformat, GLsizei width, GLsizei height) {
    const char *_name = "glRenderbufferStorage";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glRenderbufferStorage(GLenum target, GLenum internalformat, GLsizei width, GLsizei height) {
    PFN_GLRENDERBUFFERSTORAGE _ptr;
    _ptr = (PFN_GLRENDERBUFFERSTORAGE)_getPrivateProcAddress("glRenderbufferStorage");
    if (!_ptr) {
        _ptr = &_fail_glRenderbufferStorage;
    }
    _glRenderbufferStorage = _ptr;
    _glRenderbufferStorage(target, internalformat, width, height);
}

PFN_GLRENDERBUFFERSTORAGE _glRenderbufferStorage = &_get_glRenderbufferStorage;

static void APIENTRY _fail_glGetRenderbufferParameteriv(GLenum target, GLenum pname, GLint * params) {
    const char *_name = "glGetRenderbufferParameteriv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetRenderbufferParameteriv(GLenum target, GLenum pname, GLint * params) {
    PFN_GLGETRENDERBUFFERPARAMETERIV _ptr;
    _ptr = (PFN_GLGETRENDERBUFFERPARAMETERIV)_getPrivateProcAddress("glGetRenderbufferParameteriv");
    if (!_ptr) {
        _ptr = &_fail_glGetRenderbufferParameteriv;
    }
    _glGetRenderbufferParameteriv = _ptr;
    _glGetRenderbufferParameteriv(target, pname, params);
}

PFN_GLGETRENDERBUFFERPARAMETERIV _glGetRenderbufferParameteriv = &_get_glGetRenderbufferParameteriv;

static GLboolean APIENTRY _fail_glIsFramebuffer(GLuint framebuffer) {
    const char *_name = "glIsFramebuffer";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static GLboolean APIENTRY _get_glIsFramebuffer(GLuint framebuffer) {
    PFN_GLISFRAMEBUFFER _ptr;
    _ptr = (PFN_GLISFRAMEBUFFER)_getPrivateProcAddress("glIsFramebuffer");
    if (!_ptr) {
        _ptr = &_fail_glIsFramebuffer;
    }
    _glIsFramebuffer = _ptr;
    return _glIsFramebuffer(framebuffer);
}

PFN_GLISFRAMEBUFFER _glIsFramebuffer = &_get_glIsFramebuffer;

static void APIENTRY _fail_glBindFramebuffer(GLenum target, GLuint framebuffer) {
    const char *_name = "glBindFramebuffer";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glBindFramebuffer(GLenum target, GLuint framebuffer) {
    PFN_GLBINDFRAMEBUFFER _ptr;
    _ptr = (PFN_GLBINDFRAMEBUFFER)_getPrivateProcAddress("glBindFramebuffer");
    if (!_ptr) {
        _ptr = &_fail_glBindFramebuffer;
    }
    _glBindFramebuffer = _ptr;
    _glBindFramebuffer(target, framebuffer);
}

PFN_GLBINDFRAMEBUFFER _glBindFramebuffer = &_get_glBindFramebuffer;

static void APIENTRY _fail_glDeleteFramebuffers(GLsizei n, const GLuint * framebuffers) {
    const char *_name = "glDeleteFramebuffers";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glDeleteFramebuffers(GLsizei n, const GLuint * framebuffers) {
    PFN_GLDELETEFRAMEBUFFERS _ptr;
    _ptr = (PFN_GLDELETEFRAMEBUFFERS)_getPrivateProcAddress("glDeleteFramebuffers");
    if (!_ptr) {
        _ptr = &_fail_glDeleteFramebuffers;
    }
    _glDeleteFramebuffers = _ptr;
    _glDeleteFramebuffers(n, framebuffers);
}

PFN_GLDELETEFRAMEBUFFERS _glDeleteFramebuffers = &_get_glDeleteFramebuffers;

static void APIENTRY _fail_glGenFramebuffers(GLsizei n, GLuint * framebuffers) {
    const char *_name = "glGenFramebuffers";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGenFramebuffers(GLsizei n, GLuint * framebuffers) {
    PFN_GLGENFRAMEBUFFERS _ptr;
    _ptr = (PFN_GLGENFRAMEBUFFERS)_getPrivateProcAddress("glGenFramebuffers");
    if (!_ptr) {
        _ptr = &_fail_glGenFramebuffers;
    }
    _glGenFramebuffers = _ptr;
    _glGenFramebuffers(n, framebuffers);
}

PFN_GLGENFRAMEBUFFERS _glGenFramebuffers = &_get_glGenFramebuffers;

static GLenum APIENTRY _fail_glCheckFramebufferStatus(GLenum target) {
    const char *_name = "glCheckFramebufferStatus";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static GLenum APIENTRY _get_glCheckFramebufferStatus(GLenum target) {
    PFN_GLCHECKFRAMEBUFFERSTATUS _ptr;
    _ptr = (PFN_GLCHECKFRAMEBUFFERSTATUS)_getPrivateProcAddress("glCheckFramebufferStatus");
    if (!_ptr) {
        _ptr = &_fail_glCheckFramebufferStatus;
    }
    _glCheckFramebufferStatus = _ptr;
    return _glCheckFramebufferStatus(target);
}

PFN_GLCHECKFRAMEBUFFERSTATUS _glCheckFramebufferStatus = &_get_glCheckFramebufferStatus;

static void APIENTRY _fail_glFramebufferTexture1D(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level) {
    const char *_name = "glFramebufferTexture1D";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glFramebufferTexture1D(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level) {
    PFN_GLFRAMEBUFFERTEXTURE1D _ptr;
    _ptr = (PFN_GLFRAMEBUFFERTEXTURE1D)_getPrivateProcAddress("glFramebufferTexture1D");
    if (!_ptr) {
        _ptr = &_fail_glFramebufferTexture1D;
    }
    _glFramebufferTexture1D = _ptr;
    _glFramebufferTexture1D(target, attachment, textarget, texture, level);
}

PFN_GLFRAMEBUFFERTEXTURE1D _glFramebufferTexture1D = &_get_glFramebufferTexture1D;

static void APIENTRY _fail_glFramebufferTexture2D(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level) {
    const char *_name = "glFramebufferTexture2D";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glFramebufferTexture2D(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level) {
    PFN_GLFRAMEBUFFERTEXTURE2D _ptr;
    _ptr = (PFN_GLFRAMEBUFFERTEXTURE2D)_getPrivateProcAddress("glFramebufferTexture2D");
    if (!_ptr) {
        _ptr = &_fail_glFramebufferTexture2D;
    }
    _glFramebufferTexture2D = _ptr;
    _glFramebufferTexture2D(target, attachment, textarget, texture, level);
}

PFN_GLFRAMEBUFFERTEXTURE2D _glFramebufferTexture2D = &_get_glFramebufferTexture2D;

static void APIENTRY _fail_glFramebufferTexture3D(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level, GLint zoffset) {
    const char *_name = "glFramebufferTexture3D";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glFramebufferTexture3D(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level, GLint zoffset) {
    PFN_GLFRAMEBUFFERTEXTURE3D _ptr;
    _ptr = (PFN_GLFRAMEBUFFERTEXTURE3D)_getPrivateProcAddress("glFramebufferTexture3D");
    if (!_ptr) {
        _ptr = &_fail_glFramebufferTexture3D;
    }
    _glFramebufferTexture3D = _ptr;
    _glFramebufferTexture3D(target, attachment, textarget, texture, level, zoffset);
}

PFN_GLFRAMEBUFFERTEXTURE3D _glFramebufferTexture3D = &_get_glFramebufferTexture3D;

static void APIENTRY _fail_glFramebufferRenderbuffer(GLenum target, GLenum attachment, GLenum renderbuffertarget, GLuint renderbuffer) {
    const char *_name = "glFramebufferRenderbuffer";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glFramebufferRenderbuffer(GLenum target, GLenum attachment, GLenum renderbuffertarget, GLuint renderbuffer) {
    PFN_GLFRAMEBUFFERRENDERBUFFER _ptr;
    _ptr = (PFN_GLFRAMEBUFFERRENDERBUFFER)_getPrivateProcAddress("glFramebufferRenderbuffer");
    if (!_ptr) {
        _ptr = &_fail_glFramebufferRenderbuffer;
    }
    _glFramebufferRenderbuffer = _ptr;
    _glFramebufferRenderbuffer(target, attachment, renderbuffertarget, renderbuffer);
}

PFN_GLFRAMEBUFFERRENDERBUFFER _glFramebufferRenderbuffer = &_get_glFramebufferRenderbuffer;

static void APIENTRY _fail_glGetFramebufferAttachmentParameteriv(GLenum target, GLenum attachment, GLenum pname, GLint * params) {
    const char *_name = "glGetFramebufferAttachmentParameteriv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetFramebufferAttachmentParameteriv(GLenum target, GLenum attachment, GLenum pname, GLint * params) {
    PFN_GLGETFRAMEBUFFERATTACHMENTPARAMETERIV _ptr;
    _ptr = (PFN_GLGETFRAMEBUFFERATTACHMENTPARAMETERIV)_getPrivateProcAddress("glGetFramebufferAttachmentParameteriv");
    if (!_ptr) {
        _ptr = &_fail_glGetFramebufferAttachmentParameteriv;
    }
    _glGetFramebufferAttachmentParameteriv = _ptr;
    _glGetFramebufferAttachmentParameteriv(target, attachment, pname, params);
}

PFN_GLGETFRAMEBUFFERATTACHMENTPARAMETERIV _glGetFramebufferAttachmentParameteriv = &_get_glGetFramebufferAttachmentParameteriv;

static void APIENTRY _fail_glGenerateMipmap(GLenum target) {
    const char *_name = "glGenerateMipmap";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGenerateMipmap(GLenum target) {
    PFN_GLGENERATEMIPMAP _ptr;
    _ptr = (PFN_GLGENERATEMIPMAP)_getPrivateProcAddress("glGenerateMipmap");
    if (!_ptr) {
        _ptr = &_fail_glGenerateMipmap;
    }
    _glGenerateMipmap = _ptr;
    _glGenerateMipmap(target);
}

PFN_GLGENERATEMIPMAP _glGenerateMipmap = &_get_glGenerateMipmap;

static void APIENTRY _fail_glBlitFramebuffer(GLint srcX0, GLint srcY0, GLint srcX1, GLint srcY1, GLint dstX0, GLint dstY0, GLint dstX1, GLint dstY1, GLbitfield mask, GLenum filter) {
    const char *_name = "glBlitFramebuffer";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glBlitFramebuffer(GLint srcX0, GLint srcY0, GLint srcX1, GLint srcY1, GLint dstX0, GLint dstY0, GLint dstX1, GLint dstY1, GLbitfield mask, GLenum filter) {
    PFN_GLBLITFRAMEBUFFER _ptr;
    _ptr = (PFN_GLBLITFRAMEBUFFER)_getPrivateProcAddress("glBlitFramebuffer");
    if (!_ptr) {
        _ptr = &_fail_glBlitFramebuffer;
    }
    _glBlitFramebuffer = _ptr;
    _glBlitFramebuffer(srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1, dstY1, mask, filter);
}

PFN_GLBLITFRAMEBUFFER _glBlitFramebuffer = &_get_glBlitFramebuffer;

static void APIENTRY _fail_glRenderbufferStorageMultisample(GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height) {
    const char *_name = "glRenderbufferStorageMultisample";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glRenderbufferStorageMultisample(GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height) {
    PFN_GLRENDERBUFFERSTORAGEMULTISAMPLE _ptr;
    _ptr = (PFN_GLRENDERBUFFERSTORAGEMULTISAMPLE)_getPrivateProcAddress("glRenderbufferStorageMultisample");
    if (!_ptr) {
        _ptr = &_fail_glRenderbufferStorageMultisample;
    }
    _glRenderbufferStorageMultisample = _ptr;
    _glRenderbufferStorageMultisample(target, samples, internalformat, width, height);
}

PFN_GLRENDERBUFFERSTORAGEMULTISAMPLE _glRenderbufferStorageMultisample = &_get_glRenderbufferStorageMultisample;

static void APIENTRY _fail_glFramebufferTextureLayer(GLenum target, GLenum attachment, GLuint texture, GLint level, GLint layer) {
    const char *_name = "glFramebufferTextureLayer";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glFramebufferTextureLayer(GLenum target, GLenum attachment, GLuint texture, GLint level, GLint layer) {
    PFN_GLFRAMEBUFFERTEXTURELAYER _ptr;
    _ptr = (PFN_GLFRAMEBUFFERTEXTURELAYER)_getPrivateProcAddress("glFramebufferTextureLayer");
    if (!_ptr) {
        _ptr = &_fail_glFramebufferTextureLayer;
    }
    _glFramebufferTextureLayer = _ptr;
    _glFramebufferTextureLayer(target, attachment, texture, level, layer);
}

PFN_GLFRAMEBUFFERTEXTURELAYER _glFramebufferTextureLayer = &_get_glFramebufferTextureLayer;

static void APIENTRY _fail_glProgramParameteriARB(GLuint program, GLenum pname, GLint value) {
    const char *_name = "glProgramParameteriARB";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glProgramParameteriARB(GLuint program, GLenum pname, GLint value) {
    PFN_GLPROGRAMPARAMETERIARB _ptr;
    _ptr = (PFN_GLPROGRAMPARAMETERIARB)_getPrivateProcAddress("glProgramParameteriARB");
    if (!_ptr) {
        _ptr = &_fail_glProgramParameteriARB;
    }
    _glProgramParameteriARB = _ptr;
    _glProgramParameteriARB(program, pname, value);
}

PFN_GLPROGRAMPARAMETERIARB _glProgramParameteriARB = &_get_glProgramParameteriARB;

static void APIENTRY _fail_glFramebufferTextureARB(GLenum target, GLenum attachment, GLuint texture, GLint level) {
    const char *_name = "glFramebufferTextureARB";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glFramebufferTextureARB(GLenum target, GLenum attachment, GLuint texture, GLint level) {
    PFN_GLFRAMEBUFFERTEXTUREARB _ptr;
    _ptr = (PFN_GLFRAMEBUFFERTEXTUREARB)_getPrivateProcAddress("glFramebufferTextureARB");
    if (!_ptr) {
        _ptr = &_fail_glFramebufferTextureARB;
    }
    _glFramebufferTextureARB = _ptr;
    _glFramebufferTextureARB(target, attachment, texture, level);
}

PFN_GLFRAMEBUFFERTEXTUREARB _glFramebufferTextureARB = &_get_glFramebufferTextureARB;

static void APIENTRY _fail_glFramebufferTextureLayerARB(GLenum target, GLenum attachment, GLuint texture, GLint level, GLint layer) {
    const char *_name = "glFramebufferTextureLayerARB";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glFramebufferTextureLayerARB(GLenum target, GLenum attachment, GLuint texture, GLint level, GLint layer) {
    PFN_GLFRAMEBUFFERTEXTURELAYERARB _ptr;
    _ptr = (PFN_GLFRAMEBUFFERTEXTURELAYERARB)_getPrivateProcAddress("glFramebufferTextureLayerARB");
    if (!_ptr) {
        _ptr = &_fail_glFramebufferTextureLayerARB;
    }
    _glFramebufferTextureLayerARB = _ptr;
    _glFramebufferTextureLayerARB(target, attachment, texture, level, layer);
}

PFN_GLFRAMEBUFFERTEXTURELAYERARB _glFramebufferTextureLayerARB = &_get_glFramebufferTextureLayerARB;

static void APIENTRY _fail_glFramebufferTextureFaceARB(GLenum target, GLenum attachment, GLuint texture, GLint level, GLenum face) {
    const char *_name = "glFramebufferTextureFaceARB";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glFramebufferTextureFaceARB(GLenum target, GLenum attachment, GLuint texture, GLint level, GLenum face) {
    PFN_GLFRAMEBUFFERTEXTUREFACEARB _ptr;
    _ptr = (PFN_GLFRAMEBUFFERTEXTUREFACEARB)_getPrivateProcAddress("glFramebufferTextureFaceARB");
    if (!_ptr) {
        _ptr = &_fail_glFramebufferTextureFaceARB;
    }
    _glFramebufferTextureFaceARB = _ptr;
    _glFramebufferTextureFaceARB(target, attachment, texture, level, face);
}

PFN_GLFRAMEBUFFERTEXTUREFACEARB _glFramebufferTextureFaceARB = &_get_glFramebufferTextureFaceARB;

static void APIENTRY _fail_glGetProgramBinary(GLuint program, GLsizei bufSize, GLsizei * length, GLenum * binaryFormat, GLvoid * binary) {
    const char *_name = "glGetProgramBinary";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetProgramBinary(GLuint program, GLsizei bufSize, GLsizei * length, GLenum * binaryFormat, GLvoid * binary) {
    PFN_GLGETPROGRAMBINARY _ptr;
    _ptr = (PFN_GLGETPROGRAMBINARY)_getPrivateProcAddress("glGetProgramBinary");
    if (!_ptr) {
        _ptr = &_fail_glGetProgramBinary;
    }
    _glGetProgramBinary = _ptr;
    _glGetProgramBinary(program, bufSize, length, binaryFormat, binary);
}

PFN_GLGETPROGRAMBINARY _glGetProgramBinary = &_get_glGetProgramBinary;

static void APIENTRY _fail_glProgramBinary(GLuint program, GLenum binaryFormat, const GLvoid * binary, GLsizei length) {
    const char *_name = "glProgramBinary";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glProgramBinary(GLuint program, GLenum binaryFormat, const GLvoid * binary, GLsizei length) {
    PFN_GLPROGRAMBINARY _ptr;
    _ptr = (PFN_GLPROGRAMBINARY)_getPrivateProcAddress("glProgramBinary");
    if (!_ptr) {
        _ptr = &_fail_glProgramBinary;
    }
    _glProgramBinary = _ptr;
    _glProgramBinary(program, binaryFormat, binary, length);
}

PFN_GLPROGRAMBINARY _glProgramBinary = &_get_glProgramBinary;

static void APIENTRY _fail_glProgramParameteri(GLuint program, GLenum pname, GLint value) {
    const char *_name = "glProgramParameteri";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glProgramParameteri(GLuint program, GLenum pname, GLint value) {
    PFN_GLPROGRAMPARAMETERI _ptr;
    _ptr = (PFN_GLPROGRAMPARAMETERI)_getPrivateProcAddress("glProgramParameteri");
    if (!_ptr) {
        _ptr = &_fail_glProgramParameteri;
    }
    _glProgramParameteri = _ptr;
    _glProgramParameteri(program, pname, value);
}

PFN_GLPROGRAMPARAMETERI _glProgramParameteri = &_get_glProgramParameteri;

static void APIENTRY _fail_glGetTextureSubImage(GLuint texture, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, GLsizei bufSize, GLvoid * pixels) {
    const char *_name = "glGetTextureSubImage";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetTextureSubImage(GLuint texture, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, GLsizei bufSize, GLvoid * pixels) {
    PFN_GLGETTEXTURESUBIMAGE _ptr;
    _ptr = (PFN_GLGETTEXTURESUBIMAGE)_getPrivateProcAddress("glGetTextureSubImage");
    if (!_ptr) {
        _ptr = &_fail_glGetTextureSubImage;
    }
    _glGetTextureSubImage = _ptr;
    _glGetTextureSubImage(texture, level, xoffset, yoffset, zoffset, width, height, depth, format, type, bufSize, pixels);
}

PFN_GLGETTEXTURESUBIMAGE _glGetTextureSubImage = &_get_glGetTextureSubImage;

static void APIENTRY _fail_glGetCompressedTextureSubImage(GLuint texture, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLsizei bufSize, GLvoid * pixels) {
    const char *_name = "glGetCompressedTextureSubImage";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetCompressedTextureSubImage(GLuint texture, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLsizei bufSize, GLvoid * pixels) {
    PFN_GLGETCOMPRESSEDTEXTURESUBIMAGE _ptr;
    _ptr = (PFN_GLGETCOMPRESSEDTEXTURESUBIMAGE)_getPrivateProcAddress("glGetCompressedTextureSubImage");
    if (!_ptr) {
        _ptr = &_fail_glGetCompressedTextureSubImage;
    }
    _glGetCompressedTextureSubImage = _ptr;
    _glGetCompressedTextureSubImage(texture, level, xoffset, yoffset, zoffset, width, height, depth, bufSize, pixels);
}

PFN_GLGETCOMPRESSEDTEXTURESUBIMAGE _glGetCompressedTextureSubImage = &_get_glGetCompressedTextureSubImage;

static void APIENTRY _fail_glSpecializeShaderARB(GLuint shader, const GLchar * pEntryPoint, GLuint numSpecializationConstants, const GLuint * pConstantIndex, const GLuint * pConstantValue) {
    const char *_name = "glSpecializeShaderARB";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glSpecializeShaderARB(GLuint shader, const GLchar * pEntryPoint, GLuint numSpecializationConstants, const GLuint * pConstantIndex, const GLuint * pConstantValue) {
    PFN_GLSPECIALIZESHADERARB _ptr;
    _ptr = (PFN_GLSPECIALIZESHADERARB)_getPrivateProcAddress("glSpecializeShaderARB");
    if (!_ptr) {
        _ptr = &_fail_glSpecializeShaderARB;
    }
    _glSpecializeShaderARB = _ptr;
    _glSpecializeShaderARB(shader, pEntryPoint, numSpecializationConstants, pConstantIndex, pConstantValue);
}

PFN_GLSPECIALIZESHADERARB _glSpecializeShaderARB = &_get_glSpecializeShaderARB;

static void APIENTRY _fail_glUniform1d(GLint location, GLdouble x) {
    const char *_name = "glUniform1d";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glUniform1d(GLint location, GLdouble x) {
    PFN_GLUNIFORM1D _ptr;
    _ptr = (PFN_GLUNIFORM1D)_getPrivateProcAddress("glUniform1d");
    if (!_ptr) {
        _ptr = &_fail_glUniform1d;
    }
    _glUniform1d = _ptr;
    _glUniform1d(location, x);
}

PFN_GLUNIFORM1D _glUniform1d = &_get_glUniform1d;

static void APIENTRY _fail_glUniform2d(GLint location, GLdouble x, GLdouble y) {
    const char *_name = "glUniform2d";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glUniform2d(GLint location, GLdouble x, GLdouble y) {
    PFN_GLUNIFORM2D _ptr;
    _ptr = (PFN_GLUNIFORM2D)_getPrivateProcAddress("glUniform2d");
    if (!_ptr) {
        _ptr = &_fail_glUniform2d;
    }
    _glUniform2d = _ptr;
    _glUniform2d(location, x, y);
}

PFN_GLUNIFORM2D _glUniform2d = &_get_glUniform2d;

static void APIENTRY _fail_glUniform3d(GLint location, GLdouble x, GLdouble y, GLdouble z) {
    const char *_name = "glUniform3d";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glUniform3d(GLint location, GLdouble x, GLdouble y, GLdouble z) {
    PFN_GLUNIFORM3D _ptr;
    _ptr = (PFN_GLUNIFORM3D)_getPrivateProcAddress("glUniform3d");
    if (!_ptr) {
        _ptr = &_fail_glUniform3d;
    }
    _glUniform3d = _ptr;
    _glUniform3d(location, x, y, z);
}

PFN_GLUNIFORM3D _glUniform3d = &_get_glUniform3d;

static void APIENTRY _fail_glUniform4d(GLint location, GLdouble x, GLdouble y, GLdouble z, GLdouble w) {
    const char *_name = "glUniform4d";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glUniform4d(GLint location, GLdouble x, GLdouble y, GLdouble z, GLdouble w) {
    PFN_GLUNIFORM4D _ptr;
    _ptr = (PFN_GLUNIFORM4D)_getPrivateProcAddress("glUniform4d");
    if (!_ptr) {
        _ptr = &_fail_glUniform4d;
    }
    _glUniform4d = _ptr;
    _glUniform4d(location, x, y, z, w);
}

PFN_GLUNIFORM4D _glUniform4d = &_get_glUniform4d;

static void APIENTRY _fail_glUniform1dv(GLint location, GLsizei count, const GLdouble * value) {
    const char *_name = "glUniform1dv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glUniform1dv(GLint location, GLsizei count, const GLdouble * value) {
    PFN_GLUNIFORM1DV _ptr;
    _ptr = (PFN_GLUNIFORM1DV)_getPrivateProcAddress("glUniform1dv");
    if (!_ptr) {
        _ptr = &_fail_glUniform1dv;
    }
    _glUniform1dv = _ptr;
    _glUniform1dv(location, count, value);
}

PFN_GLUNIFORM1DV _glUniform1dv = &_get_glUniform1dv;

static void APIENTRY _fail_glUniform2dv(GLint location, GLsizei count, const GLdouble * value) {
    const char *_name = "glUniform2dv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glUniform2dv(GLint location, GLsizei count, const GLdouble * value) {
    PFN_GLUNIFORM2DV _ptr;
    _ptr = (PFN_GLUNIFORM2DV)_getPrivateProcAddress("glUniform2dv");
    if (!_ptr) {
        _ptr = &_fail_glUniform2dv;
    }
    _glUniform2dv = _ptr;
    _glUniform2dv(location, count, value);
}

PFN_GLUNIFORM2DV _glUniform2dv = &_get_glUniform2dv;

static void APIENTRY _fail_glUniform3dv(GLint location, GLsizei count, const GLdouble * value) {
    const char *_name = "glUniform3dv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glUniform3dv(GLint location, GLsizei count, const GLdouble * value) {
    PFN_GLUNIFORM3DV _ptr;
    _ptr = (PFN_GLUNIFORM3DV)_getPrivateProcAddress("glUniform3dv");
    if (!_ptr) {
        _ptr = &_fail_glUniform3dv;
    }
    _glUniform3dv = _ptr;
    _glUniform3dv(location, count, value);
}

PFN_GLUNIFORM3DV _glUniform3dv = &_get_glUniform3dv;

static void APIENTRY _fail_glUniform4dv(GLint location, GLsizei count, const GLdouble * value) {
    const char *_name = "glUniform4dv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glUniform4dv(GLint location, GLsizei count, const GLdouble * value) {
    PFN_GLUNIFORM4DV _ptr;
    _ptr = (PFN_GLUNIFORM4DV)_getPrivateProcAddress("glUniform4dv");
    if (!_ptr) {
        _ptr = &_fail_glUniform4dv;
    }
    _glUniform4dv = _ptr;
    _glUniform4dv(location, count, value);
}

PFN_GLUNIFORM4DV _glUniform4dv = &_get_glUniform4dv;

static void APIENTRY _fail_glUniformMatrix2dv(GLint location, GLsizei count, GLboolean transpose, const GLdouble * value) {
    const char *_name = "glUniformMatrix2dv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glUniformMatrix2dv(GLint location, GLsizei count, GLboolean transpose, const GLdouble * value) {
    PFN_GLUNIFORMMATRIX2DV _ptr;
    _ptr = (PFN_GLUNIFORMMATRIX2DV)_getPrivateProcAddress("glUniformMatrix2dv");
    if (!_ptr) {
        _ptr = &_fail_glUniformMatrix2dv;
    }
    _glUniformMatrix2dv = _ptr;
    _glUniformMatrix2dv(location, count, transpose, value);
}

PFN_GLUNIFORMMATRIX2DV _glUniformMatrix2dv = &_get_glUniformMatrix2dv;

static void APIENTRY _fail_glUniformMatrix3dv(GLint location, GLsizei count, GLboolean transpose, const GLdouble * value) {
    const char *_name = "glUniformMatrix3dv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glUniformMatrix3dv(GLint location, GLsizei count, GLboolean transpose, const GLdouble * value) {
    PFN_GLUNIFORMMATRIX3DV _ptr;
    _ptr = (PFN_GLUNIFORMMATRIX3DV)_getPrivateProcAddress("glUniformMatrix3dv");
    if (!_ptr) {
        _ptr = &_fail_glUniformMatrix3dv;
    }
    _glUniformMatrix3dv = _ptr;
    _glUniformMatrix3dv(location, count, transpose, value);
}

PFN_GLUNIFORMMATRIX3DV _glUniformMatrix3dv = &_get_glUniformMatrix3dv;

static void APIENTRY _fail_glUniformMatrix4dv(GLint location, GLsizei count, GLboolean transpose, const GLdouble * value) {
    const char *_name = "glUniformMatrix4dv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glUniformMatrix4dv(GLint location, GLsizei count, GLboolean transpose, const GLdouble * value) {
    PFN_GLUNIFORMMATRIX4DV _ptr;
    _ptr = (PFN_GLUNIFORMMATRIX4DV)_getPrivateProcAddress("glUniformMatrix4dv");
    if (!_ptr) {
        _ptr = &_fail_glUniformMatrix4dv;
    }
    _glUniformMatrix4dv = _ptr;
    _glUniformMatrix4dv(location, count, transpose, value);
}

PFN_GLUNIFORMMATRIX4DV _glUniformMatrix4dv = &_get_glUniformMatrix4dv;

static void APIENTRY _fail_glUniformMatrix2x3dv(GLint location, GLsizei count, GLboolean transpose, const GLdouble * value) {
    const char *_name = "glUniformMatrix2x3dv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glUniformMatrix2x3dv(GLint location, GLsizei count, GLboolean transpose, const GLdouble * value) {
    PFN_GLUNIFORMMATRIX2X3DV _ptr;
    _ptr = (PFN_GLUNIFORMMATRIX2X3DV)_getPrivateProcAddress("glUniformMatrix2x3dv");
    if (!_ptr) {
        _ptr = &_fail_glUniformMatrix2x3dv;
    }
    _glUniformMatrix2x3dv = _ptr;
    _glUniformMatrix2x3dv(location, count, transpose, value);
}

PFN_GLUNIFORMMATRIX2X3DV _glUniformMatrix2x3dv = &_get_glUniformMatrix2x3dv;

static void APIENTRY _fail_glUniformMatrix2x4dv(GLint location, GLsizei count, GLboolean transpose, const GLdouble * value) {
    const char *_name = "glUniformMatrix2x4dv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glUniformMatrix2x4dv(GLint location, GLsizei count, GLboolean transpose, const GLdouble * value) {
    PFN_GLUNIFORMMATRIX2X4DV _ptr;
    _ptr = (PFN_GLUNIFORMMATRIX2X4DV)_getPrivateProcAddress("glUniformMatrix2x4dv");
    if (!_ptr) {
        _ptr = &_fail_glUniformMatrix2x4dv;
    }
    _glUniformMatrix2x4dv = _ptr;
    _glUniformMatrix2x4dv(location, count, transpose, value);
}

PFN_GLUNIFORMMATRIX2X4DV _glUniformMatrix2x4dv = &_get_glUniformMatrix2x4dv;

static void APIENTRY _fail_glUniformMatrix3x2dv(GLint location, GLsizei count, GLboolean transpose, const GLdouble * value) {
    const char *_name = "glUniformMatrix3x2dv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glUniformMatrix3x2dv(GLint location, GLsizei count, GLboolean transpose, const GLdouble * value) {
    PFN_GLUNIFORMMATRIX3X2DV _ptr;
    _ptr = (PFN_GLUNIFORMMATRIX3X2DV)_getPrivateProcAddress("glUniformMatrix3x2dv");
    if (!_ptr) {
        _ptr = &_fail_glUniformMatrix3x2dv;
    }
    _glUniformMatrix3x2dv = _ptr;
    _glUniformMatrix3x2dv(location, count, transpose, value);
}

PFN_GLUNIFORMMATRIX3X2DV _glUniformMatrix3x2dv = &_get_glUniformMatrix3x2dv;

static void APIENTRY _fail_glUniformMatrix3x4dv(GLint location, GLsizei count, GLboolean transpose, const GLdouble * value) {
    const char *_name = "glUniformMatrix3x4dv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glUniformMatrix3x4dv(GLint location, GLsizei count, GLboolean transpose, const GLdouble * value) {
    PFN_GLUNIFORMMATRIX3X4DV _ptr;
    _ptr = (PFN_GLUNIFORMMATRIX3X4DV)_getPrivateProcAddress("glUniformMatrix3x4dv");
    if (!_ptr) {
        _ptr = &_fail_glUniformMatrix3x4dv;
    }
    _glUniformMatrix3x4dv = _ptr;
    _glUniformMatrix3x4dv(location, count, transpose, value);
}

PFN_GLUNIFORMMATRIX3X4DV _glUniformMatrix3x4dv = &_get_glUniformMatrix3x4dv;

static void APIENTRY _fail_glUniformMatrix4x2dv(GLint location, GLsizei count, GLboolean transpose, const GLdouble * value) {
    const char *_name = "glUniformMatrix4x2dv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glUniformMatrix4x2dv(GLint location, GLsizei count, GLboolean transpose, const GLdouble * value) {
    PFN_GLUNIFORMMATRIX4X2DV _ptr;
    _ptr = (PFN_GLUNIFORMMATRIX4X2DV)_getPrivateProcAddress("glUniformMatrix4x2dv");
    if (!_ptr) {
        _ptr = &_fail_glUniformMatrix4x2dv;
    }
    _glUniformMatrix4x2dv = _ptr;
    _glUniformMatrix4x2dv(location, count, transpose, value);
}

PFN_GLUNIFORMMATRIX4X2DV _glUniformMatrix4x2dv = &_get_glUniformMatrix4x2dv;

static void APIENTRY _fail_glUniformMatrix4x3dv(GLint location, GLsizei count, GLboolean transpose, const GLdouble * value) {
    const char *_name = "glUniformMatrix4x3dv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glUniformMatrix4x3dv(GLint location, GLsizei count, GLboolean transpose, const GLdouble * value) {
    PFN_GLUNIFORMMATRIX4X3DV _ptr;
    _ptr = (PFN_GLUNIFORMMATRIX4X3DV)_getPrivateProcAddress("glUniformMatrix4x3dv");
    if (!_ptr) {
        _ptr = &_fail_glUniformMatrix4x3dv;
    }
    _glUniformMatrix4x3dv = _ptr;
    _glUniformMatrix4x3dv(location, count, transpose, value);
}

PFN_GLUNIFORMMATRIX4X3DV _glUniformMatrix4x3dv = &_get_glUniformMatrix4x3dv;

static void APIENTRY _fail_glGetUniformdv(GLuint program, GLint location, GLdouble * params) {
    const char *_name = "glGetUniformdv";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetUniformdv(GLuint program, GLint location, GLdouble * params) {
    PFN_GLGETUNIFORMDV _ptr;
    _ptr = (PFN_GLGETUNIFORMDV)_getPrivateProcAddress("glGetUniformdv");
    if (!_ptr) {
        _ptr = &_fail_glGetUniformdv;
    }
    _glGetUniformdv = _ptr;
    _glGetUniformdv(program, location, params);
}

PFN_GLGETUNIFORMDV _glGetUniformdv = &_get_glGetUniformdv;

static void APIENTRY _fail_glUniform1i64ARB(GLint location, GLint64 x) {
    const char *_name = "glUniform1i64ARB";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glUniform1i64ARB(GLint location, GLint64 x) {
    PFN_GLUNIFORM1I64ARB _ptr;
    _ptr = (PFN_GLUNIFORM1I64ARB)_getPrivateProcAddress("glUniform1i64ARB");
    if (!_ptr) {
        _ptr = &_fail_glUniform1i64ARB;
    }
    _glUniform1i64ARB = _ptr;
    _glUniform1i64ARB(location, x);
}

PFN_GLUNIFORM1I64ARB _glUniform1i64ARB = &_get_glUniform1i64ARB;

static void APIENTRY _fail_glUniform2i64ARB(GLint location, GLint64 x, GLint64 y) {
    const char *_name = "glUniform2i64ARB";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glUniform2i64ARB(GLint location, GLint64 x, GLint64 y) {
    PFN_GLUNIFORM2I64ARB _ptr;
    _ptr = (PFN_GLUNIFORM2I64ARB)_getPrivateProcAddress("glUniform2i64ARB");
    if (!_ptr) {
        _ptr = &_fail_glUniform2i64ARB;
    }
    _glUniform2i64ARB = _ptr;
    _glUniform2i64ARB(location, x, y);
}

PFN_GLUNIFORM2I64ARB _glUniform2i64ARB = &_get_glUniform2i64ARB;

static void APIENTRY _fail_glUniform3i64ARB(GLint location, GLint64 x, GLint64 y, GLint64 z) {
    const char *_name = "glUniform3i64ARB";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glUniform3i64ARB(GLint location, GLint64 x, GLint64 y, GLint64 z) {
    PFN_GLUNIFORM3I64ARB _ptr;
    _ptr = (PFN_GLUNIFORM3I64ARB)_getPrivateProcAddress("glUniform3i64ARB");
    if (!_ptr) {
        _ptr = &_fail_glUniform3i64ARB;
    }
    _glUniform3i64ARB = _ptr;
    _glUniform3i64ARB(location, x, y, z);
}

PFN_GLUNIFORM3I64ARB _glUniform3i64ARB = &_get_glUniform3i64ARB;

static void APIENTRY _fail_glUniform4i64ARB(GLint location, GLint64 x, GLint64 y, GLint64 z, GLint64 w) {
    const char *_name = "glUniform4i64ARB";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glUniform4i64ARB(GLint location, GLint64 x, GLint64 y, GLint64 z, GLint64 w) {
    PFN_GLUNIFORM4I64ARB _ptr;
    _ptr = (PFN_GLUNIFORM4I64ARB)_getPrivateProcAddress("glUniform4i64ARB");
    if (!_ptr) {
        _ptr = &_fail_glUniform4i64ARB;
    }
    _glUniform4i64ARB = _ptr;
    _glUniform4i64ARB(location, x, y, z, w);
}

PFN_GLUNIFORM4I64ARB _glUniform4i64ARB = &_get_glUniform4i64ARB;

static void APIENTRY _fail_glUniform1i64vARB(GLint location, GLsizei count, const GLint64 * value) {
    const char *_name = "glUniform1i64vARB";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glUniform1i64vARB(GLint location, GLsizei count, const GLint64 * value) {
    PFN_GLUNIFORM1I64VARB _ptr;
    _ptr = (PFN_GLUNIFORM1I64VARB)_getPrivateProcAddress("glUniform1i64vARB");
    if (!_ptr) {
        _ptr = &_fail_glUniform1i64vARB;
    }
    _glUniform1i64vARB = _ptr;
    _glUniform1i64vARB(location, count, value);
}

PFN_GLUNIFORM1I64VARB _glUniform1i64vARB = &_get_glUniform1i64vARB;

static void APIENTRY _fail_glUniform2i64vARB(GLint location, GLsizei count, const GLint64 * value) {
    const char *_name = "glUniform2i64vARB";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glUniform2i64vARB(GLint location, GLsizei count, const GLint64 * value) {
    PFN_GLUNIFORM2I64VARB _ptr;
    _ptr = (PFN_GLUNIFORM2I64VARB)_getPrivateProcAddress("glUniform2i64vARB");
    if (!_ptr) {
        _ptr = &_fail_glUniform2i64vARB;
    }
    _glUniform2i64vARB = _ptr;
    _glUniform2i64vARB(location, count, value);
}

PFN_GLUNIFORM2I64VARB _glUniform2i64vARB = &_get_glUniform2i64vARB;

static void APIENTRY _fail_glUniform3i64vARB(GLint location, GLsizei count, const GLint64 * value) {
    const char *_name = "glUniform3i64vARB";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glUniform3i64vARB(GLint location, GLsizei count, const GLint64 * value) {
    PFN_GLUNIFORM3I64VARB _ptr;
    _ptr = (PFN_GLUNIFORM3I64VARB)_getPrivateProcAddress("glUniform3i64vARB");
    if (!_ptr) {
        _ptr = &_fail_glUniform3i64vARB;
    }
    _glUniform3i64vARB = _ptr;
    _glUniform3i64vARB(location, count, value);
}

PFN_GLUNIFORM3I64VARB _glUniform3i64vARB = &_get_glUniform3i64vARB;

static void APIENTRY _fail_glUniform4i64vARB(GLint location, GLsizei count, const GLint64 * value) {
    const char *_name = "glUniform4i64vARB";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glUniform4i64vARB(GLint location, GLsizei count, const GLint64 * value) {
    PFN_GLUNIFORM4I64VARB _ptr;
    _ptr = (PFN_GLUNIFORM4I64VARB)_getPrivateProcAddress("glUniform4i64vARB");
    if (!_ptr) {
        _ptr = &_fail_glUniform4i64vARB;
    }
    _glUniform4i64vARB = _ptr;
    _glUniform4i64vARB(location, count, value);
}

PFN_GLUNIFORM4I64VARB _glUniform4i64vARB = &_get_glUniform4i64vARB;

static void APIENTRY _fail_glUniform1ui64ARB(GLint location, GLuint64 x) {
    const char *_name = "glUniform1ui64ARB";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glUniform1ui64ARB(GLint location, GLuint64 x) {
    PFN_GLUNIFORM1UI64ARB _ptr;
    _ptr = (PFN_GLUNIFORM1UI64ARB)_getPrivateProcAddress("glUniform1ui64ARB");
    if (!_ptr) {
        _ptr = &_fail_glUniform1ui64ARB;
    }
    _glUniform1ui64ARB = _ptr;
    _glUniform1ui64ARB(location, x);
}

PFN_GLUNIFORM1UI64ARB _glUniform1ui64ARB = &_get_glUniform1ui64ARB;

static void APIENTRY _fail_glUniform2ui64ARB(GLint location, GLuint64 x, GLuint64 y) {
    const char *_name = "glUniform2ui64ARB";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glUniform2ui64ARB(GLint location, GLuint64 x, GLuint64 y) {
    PFN_GLUNIFORM2UI64ARB _ptr;
    _ptr = (PFN_GLUNIFORM2UI64ARB)_getPrivateProcAddress("glUniform2ui64ARB");
    if (!_ptr) {
        _ptr = &_fail_glUniform2ui64ARB;
    }
    _glUniform2ui64ARB = _ptr;
    _glUniform2ui64ARB(location, x, y);
}

PFN_GLUNIFORM2UI64ARB _glUniform2ui64ARB = &_get_glUniform2ui64ARB;

static void APIENTRY _fail_glUniform3ui64ARB(GLint location, GLuint64 x, GLuint64 y, GLuint64 z) {
    const char *_name = "glUniform3ui64ARB";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glUniform3ui64ARB(GLint location, GLuint64 x, GLuint64 y, GLuint64 z) {
    PFN_GLUNIFORM3UI64ARB _ptr;
    _ptr = (PFN_GLUNIFORM3UI64ARB)_getPrivateProcAddress("glUniform3ui64ARB");
    if (!_ptr) {
        _ptr = &_fail_glUniform3ui64ARB;
    }
    _glUniform3ui64ARB = _ptr;
    _glUniform3ui64ARB(location, x, y, z);
}

PFN_GLUNIFORM3UI64ARB _glUniform3ui64ARB = &_get_glUniform3ui64ARB;

static void APIENTRY _fail_glUniform4ui64ARB(GLint location, GLuint64 x, GLuint64 y, GLuint64 z, GLuint64 w) {
    const char *_name = "glUniform4ui64ARB";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glUniform4ui64ARB(GLint location, GLuint64 x, GLuint64 y, GLuint64 z, GLuint64 w) {
    PFN_GLUNIFORM4UI64ARB _ptr;
    _ptr = (PFN_GLUNIFORM4UI64ARB)_getPrivateProcAddress("glUniform4ui64ARB");
    if (!_ptr) {
        _ptr = &_fail_glUniform4ui64ARB;
    }
    _glUniform4ui64ARB = _ptr;
    _glUniform4ui64ARB(location, x, y, z, w);
}

PFN_GLUNIFORM4UI64ARB _glUniform4ui64ARB = &_get_glUniform4ui64ARB;

static void APIENTRY _fail_glUniform1ui64vARB(GLint location, GLsizei count, const GLuint64 * value) {
    const char *_name = "glUniform1ui64vARB";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glUniform1ui64vARB(GLint location, GLsizei count, const GLuint64 * value) {
    PFN_GLUNIFORM1UI64VARB _ptr;
    _ptr = (PFN_GLUNIFORM1UI64VARB)_getPrivateProcAddress("glUniform1ui64vARB");
    if (!_ptr) {
        _ptr = &_fail_glUniform1ui64vARB;
    }
    _glUniform1ui64vARB = _ptr;
    _glUniform1ui64vARB(location, count, value);
}

PFN_GLUNIFORM1UI64VARB _glUniform1ui64vARB = &_get_glUniform1ui64vARB;

static void APIENTRY _fail_glUniform2ui64vARB(GLint location, GLsizei count, const GLuint64 * value) {
    const char *_name = "glUniform2ui64vARB";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glUniform2ui64vARB(GLint location, GLsizei count, const GLuint64 * value) {
    PFN_GLUNIFORM2UI64VARB _ptr;
    _ptr = (PFN_GLUNIFORM2UI64VARB)_getPrivateProcAddress("glUniform2ui64vARB");
    if (!_ptr) {
        _ptr = &_fail_glUniform2ui64vARB;
    }
    _glUniform2ui64vARB = _ptr;
    _glUniform2ui64vARB(location, count, value);
}

PFN_GLUNIFORM2UI64VARB _glUniform2ui64vARB = &_get_glUniform2ui64vARB;

static void APIENTRY _fail_glUniform3ui64vARB(GLint location, GLsizei count, const GLuint64 * value) {
    const char *_name = "glUniform3ui64vARB";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glUniform3ui64vARB(GLint location, GLsizei count, const GLuint64 * value) {
    PFN_GLUNIFORM3UI64VARB _ptr;
    _ptr = (PFN_GLUNIFORM3UI64VARB)_getPrivateProcAddress("glUniform3ui64vARB");
    if (!_ptr) {
        _ptr = &_fail_glUniform3ui64vARB;
    }
    _glUniform3ui64vARB = _ptr;
    _glUniform3ui64vARB(location, count, value);
}

PFN_GLUNIFORM3UI64VARB _glUniform3ui64vARB = &_get_glUniform3ui64vARB;

static void APIENTRY _fail_glUniform4ui64vARB(GLint location, GLsizei count, const GLuint64 * value) {
    const char *_name = "glUniform4ui64vARB";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glUniform4ui64vARB(GLint location, GLsizei count, const GLuint64 * value) {
    PFN_GLUNIFORM4UI64VARB _ptr;
    _ptr = (PFN_GLUNIFORM4UI64VARB)_getPrivateProcAddress("glUniform4ui64vARB");
    if (!_ptr) {
        _ptr = &_fail_glUniform4ui64vARB;
    }
    _glUniform4ui64vARB = _ptr;
    _glUniform4ui64vARB(location, count, value);
}

PFN_GLUNIFORM4UI64VARB _glUniform4ui64vARB = &_get_glUniform4ui64vARB;

static void APIENTRY _fail_glGetUniformi64vARB(GLuint program, GLint location, GLint64 * params) {
    const char *_name = "glGetUniformi64vARB";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetUniformi64vARB(GLuint program, GLint location, GLint64 * params) {
    PFN_GLGETUNIFORMI64VARB _ptr;
    _ptr = (PFN_GLGETUNIFORMI64VARB)_getPrivateProcAddress("glGetUniformi64vARB");
    if (!_ptr) {
        _ptr = &_fail_glGetUniformi64vARB;
    }
    _glGetUniformi64vARB = _ptr;
    _glGetUniformi64vARB(program, location, params);
}

PFN_GLGETUNIFORMI64VARB _glGetUniformi64vARB = &_get_glGetUniformi64vARB;

static void APIENTRY _fail_glGetUniformui64vARB(GLuint program, GLint location, GLuint64 * params) {
    const char *_name = "glGetUniformui64vARB";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetUniformui64vARB(GLuint program, GLint location, GLuint64 * params) {
    PFN_GLGETUNIFORMUI64VARB _ptr;
    _ptr = (PFN_GLGETUNIFORMUI64VARB)_getPrivateProcAddress("glGetUniformui64vARB");
    if (!_ptr) {
        _ptr = &_fail_glGetUniformui64vARB;
    }
    _glGetUniformui64vARB = _ptr;
    _glGetUniformui64vARB(program, location, params);
}

PFN_GLGETUNIFORMUI64VARB _glGetUniformui64vARB = &_get_glGetUniformui64vARB;

static void APIENTRY _fail_glGetnUniformi64vARB(GLuint program, GLint location, GLsizei bufSize, GLint64 * params) {
    const char *_name = "glGetnUniformi64vARB";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetnUniformi64vARB(GLuint program, GLint location, GLsizei bufSize, GLint64 * params) {
    PFN_GLGETNUNIFORMI64VARB _ptr;
    _ptr = (PFN_GLGETNUNIFORMI64VARB)_getPrivateProcAddress("glGetnUniformi64vARB");
    if (!_ptr) {
        _ptr = &_fail_glGetnUniformi64vARB;
    }
    _glGetnUniformi64vARB = _ptr;
    _glGetnUniformi64vARB(program, location, bufSize, params);
}

PFN_GLGETNUNIFORMI64VARB _glGetnUniformi64vARB = &_get_glGetnUniformi64vARB;

static void APIENTRY _fail_glGetnUniformui64vARB(GLuint program, GLint location, GLsizei bufSize, GLuint64 * params) {
    const char *_name = "glGetnUniformui64vARB";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetnUniformui64vARB(GLuint program, GLint location, GLsizei bufSize, GLuint64 * params) {
    PFN_GLGETNUNIFORMUI64VARB _ptr;
    _ptr = (PFN_GLGETNUNIFORMUI64VARB)_getPrivateProcAddress("glGetnUniformui64vARB");
    if (!_ptr) {
        _ptr = &_fail_glGetnUniformui64vARB;
    }
    _glGetnUniformui64vARB = _ptr;
    _glGetnUniformui64vARB(program, location, bufSize, params);
}

PFN_GLGETNUNIFORMUI64VARB _glGetnUniformui64vARB = &_get_glGetnUniformui64vARB;

static void APIENTRY _fail_glProgramUniform1i64ARB(GLuint program, GLint location, GLint64 x) {
    const char *_name = "glProgramUniform1i64ARB";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glProgramUniform1i64ARB(GLuint program, GLint location, GLint64 x) {
    PFN_GLPROGRAMUNIFORM1I64ARB _ptr;
    _ptr = (PFN_GLPROGRAMUNIFORM1I64ARB)_getPrivateProcAddress("glProgramUniform1i64ARB");
    if (!_ptr) {
        _ptr = &_fail_glProgramUniform1i64ARB;
    }
    _glProgramUniform1i64ARB = _ptr;
    _glProgramUniform1i64ARB(program, location, x);
}

PFN_GLPROGRAMUNIFORM1I64ARB _glProgramUniform1i64ARB = &_get_glProgramUniform1i64ARB;

static void APIENTRY _fail_glProgramUniform2i64ARB(GLuint program, GLint location, GLint64 x, GLint64 y) {
    const char *_name = "glProgramUniform2i64ARB";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glProgramUniform2i64ARB(GLuint program, GLint location, GLint64 x, GLint64 y) {
    PFN_GLPROGRAMUNIFORM2I64ARB _ptr;
    _ptr = (PFN_GLPROGRAMUNIFORM2I64ARB)_getPrivateProcAddress("glProgramUniform2i64ARB");
    if (!_ptr) {
        _ptr = &_fail_glProgramUniform2i64ARB;
    }
    _glProgramUniform2i64ARB = _ptr;
    _glProgramUniform2i64ARB(program, location, x, y);
}

PFN_GLPROGRAMUNIFORM2I64ARB _glProgramUniform2i64ARB = &_get_glProgramUniform2i64ARB;

static void APIENTRY _fail_glProgramUniform3i64ARB(GLuint program, GLint location, GLint64 x, GLint64 y, GLint64 z) {
    const char *_name = "glProgramUniform3i64ARB";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glProgramUniform3i64ARB(GLuint program, GLint location, GLint64 x, GLint64 y, GLint64 z) {
    PFN_GLPROGRAMUNIFORM3I64ARB _ptr;
    _ptr = (PFN_GLPROGRAMUNIFORM3I64ARB)_getPrivateProcAddress("glProgramUniform3i64ARB");
    if (!_ptr) {
        _ptr = &_fail_glProgramUniform3i64ARB;
    }
    _glProgramUniform3i64ARB = _ptr;
    _glProgramUniform3i64ARB(program, location, x, y, z);
}

PFN_GLPROGRAMUNIFORM3I64ARB _glProgramUniform3i64ARB = &_get_glProgramUniform3i64ARB;

static void APIENTRY _fail_glProgramUniform4i64ARB(GLuint program, GLint location, GLint64 x, GLint64 y, GLint64 z, GLint64 w) {
    const char *_name = "glProgramUniform4i64ARB";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glProgramUniform4i64ARB(GLuint program, GLint location, GLint64 x, GLint64 y, GLint64 z, GLint64 w) {
    PFN_GLPROGRAMUNIFORM4I64ARB _ptr;
    _ptr = (PFN_GLPROGRAMUNIFORM4I64ARB)_getPrivateProcAddress("glProgramUniform4i64ARB");
    if (!_ptr) {
        _ptr = &_fail_glProgramUniform4i64ARB;
    }
    _glProgramUniform4i64ARB = _ptr;
    _glProgramUniform4i64ARB(program, location, x, y, z, w);
}

PFN_GLPROGRAMUNIFORM4I64ARB _glProgramUniform4i64ARB = &_get_glProgramUniform4i64ARB;

static void APIENTRY _fail_glProgramUniform1i64vARB(GLuint program, GLint location, GLsizei count, const GLint64 * value) {
    const char *_name = "glProgramUniform1i64vARB";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glProgramUniform1i64vARB(GLuint program, GLint location, GLsizei count, const GLint64 * value) {
    PFN_GLPROGRAMUNIFORM1I64VARB _ptr;
    _ptr = (PFN_GLPROGRAMUNIFORM1I64VARB)_getPrivateProcAddress("glProgramUniform1i64vARB");
    if (!_ptr) {
        _ptr = &_fail_glProgramUniform1i64vARB;
    }
    _glProgramUniform1i64vARB = _ptr;
    _glProgramUniform1i64vARB(program, location, count, value);
}

PFN_GLPROGRAMUNIFORM1I64VARB _glProgramUniform1i64vARB = &_get_glProgramUniform1i64vARB;

static void APIENTRY _fail_glProgramUniform2i64vARB(GLuint program, GLint location, GLsizei count, const GLint64 * value) {
    const char *_name = "glProgramUniform2i64vARB";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glProgramUniform2i64vARB(GLuint program, GLint location, GLsizei count, const GLint64 * value) {
    PFN_GLPROGRAMUNIFORM2I64VARB _ptr;
    _ptr = (PFN_GLPROGRAMUNIFORM2I64VARB)_getPrivateProcAddress("glProgramUniform2i64vARB");
    if (!_ptr) {
        _ptr = &_fail_glProgramUniform2i64vARB;
    }
    _glProgramUniform2i64vARB = _ptr;
    _glProgramUniform2i64vARB(program, location, count, value);
}

PFN_GLPROGRAMUNIFORM2I64VARB _glProgramUniform2i64vARB = &_get_glProgramUniform2i64vARB;

static void APIENTRY _fail_glProgramUniform3i64vARB(GLuint program, GLint location, GLsizei count, const GLint64 * value) {
    const char *_name = "glProgramUniform3i64vARB";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glProgramUniform3i64vARB(GLuint program, GLint location, GLsizei count, const GLint64 * value) {
    PFN_GLPROGRAMUNIFORM3I64VARB _ptr;
    _ptr = (PFN_GLPROGRAMUNIFORM3I64VARB)_getPrivateProcAddress("glProgramUniform3i64vARB");
    if (!_ptr) {
        _ptr = &_fail_glProgramUniform3i64vARB;
    }
    _glProgramUniform3i64vARB = _ptr;
    _glProgramUniform3i64vARB(program, location, count, value);
}

PFN_GLPROGRAMUNIFORM3I64VARB _glProgramUniform3i64vARB = &_get_glProgramUniform3i64vARB;

static void APIENTRY _fail_glProgramUniform4i64vARB(GLuint program, GLint location, GLsizei count, const GLint64 * value) {
    const char *_name = "glProgramUniform4i64vARB";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glProgramUniform4i64vARB(GLuint program, GLint location, GLsizei count, const GLint64 * value) {
    PFN_GLPROGRAMUNIFORM4I64VARB _ptr;
    _ptr = (PFN_GLPROGRAMUNIFORM4I64VARB)_getPrivateProcAddress("glProgramUniform4i64vARB");
    if (!_ptr) {
        _ptr = &_fail_glProgramUniform4i64vARB;
    }
    _glProgramUniform4i64vARB = _ptr;
    _glProgramUniform4i64vARB(program, location, count, value);
}

PFN_GLPROGRAMUNIFORM4I64VARB _glProgramUniform4i64vARB = &_get_glProgramUniform4i64vARB;

static void APIENTRY _fail_glProgramUniform1ui64ARB(GLuint program, GLint location, GLuint64 x) {
    const char *_name = "glProgramUniform1ui64ARB";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glProgramUniform1ui64ARB(GLuint program, GLint location, GLuint64 x) {
    PFN_GLPROGRAMUNIFORM1UI64ARB _ptr;
    _ptr = (PFN_GLPROGRAMUNIFORM1UI64ARB)_getPrivateProcAddress("glProgramUniform1ui64ARB");
    if (!_ptr) {
        _ptr = &_fail_glProgramUniform1ui64ARB;
    }
    _glProgramUniform1ui64ARB = _ptr;
    _glProgramUniform1ui64ARB(program, location, x);
}

PFN_GLPROGRAMUNIFORM1UI64ARB _glProgramUniform1ui64ARB = &_get_glProgramUniform1ui64ARB;

static void APIENTRY _fail_glProgramUniform2ui64ARB(GLuint program, GLint location, GLuint64 x, GLuint64 y) {
    const char *_name = "glProgramUniform2ui64ARB";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glProgramUniform2ui64ARB(GLuint program, GLint location, GLuint64 x, GLuint64 y) {
    PFN_GLPROGRAMUNIFORM2UI64ARB _ptr;
    _ptr = (PFN_GLPROGRAMUNIFORM2UI64ARB)_getPrivateProcAddress("glProgramUniform2ui64ARB");
    if (!_ptr) {
        _ptr = &_fail_glProgramUniform2ui64ARB;
    }
    _glProgramUniform2ui64ARB = _ptr;
    _glProgramUniform2ui64ARB(program, location, x, y);
}

PFN_GLPROGRAMUNIFORM2UI64ARB _glProgramUniform2ui64ARB = &_get_glProgramUniform2ui64ARB;

static void APIENTRY _fail_glProgramUniform3ui64ARB(GLuint program, GLint location, GLuint64 x, GLuint64 y, GLuint64 z) {
    const char *_name = "glProgramUniform3ui64ARB";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glProgramUniform3ui64ARB(GLuint program, GLint location, GLuint64 x, GLuint64 y, GLuint64 z) {
    PFN_GLPROGRAMUNIFORM3UI64ARB _ptr;
    _ptr = (PFN_GLPROGRAMUNIFORM3UI64ARB)_getPrivateProcAddress("glProgramUniform3ui64ARB");
    if (!_ptr) {
        _ptr = &_fail_glProgramUniform3ui64ARB;
    }
    _glProgramUniform3ui64ARB = _ptr;
    _glProgramUniform3ui64ARB(program, location, x, y, z);
}

PFN_GLPROGRAMUNIFORM3UI64ARB _glProgramUniform3ui64ARB = &_get_glProgramUniform3ui64ARB;

static void APIENTRY _fail_glProgramUniform4ui64ARB(GLuint program, GLint location, GLuint64 x, GLuint64 y, GLuint64 z, GLuint64 w) {
    const char *_name = "glProgramUniform4ui64ARB";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glProgramUniform4ui64ARB(GLuint program, GLint location, GLuint64 x, GLuint64 y, GLuint64 z, GLuint64 w) {
    PFN_GLPROGRAMUNIFORM4UI64ARB _ptr;
    _ptr = (PFN_GLPROGRAMUNIFORM4UI64ARB)_getPrivateProcAddress("glProgramUniform4ui64ARB");
    if (!_ptr) {
        _ptr = &_fail_glProgramUniform4ui64ARB;
    }
    _glProgramUniform4ui64ARB = _ptr;
    _glProgramUniform4ui64ARB(program, location, x, y, z, w);
}

PFN_GLPROGRAMUNIFORM4UI64ARB _glProgramUniform4ui64ARB = &_get_glProgramUniform4ui64ARB;

static void APIENTRY _fail_glProgramUniform1ui64vARB(GLuint program, GLint location, GLsizei count, const GLuint64 * value) {
    const char *_name = "glProgramUniform1ui64vARB";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glProgramUniform1ui64vARB(GLuint program, GLint location, GLsizei count, const GLuint64 * value) {
    PFN_GLPROGRAMUNIFORM1UI64VARB _ptr;
    _ptr = (PFN_GLPROGRAMUNIFORM1UI64VARB)_getPrivateProcAddress("glProgramUniform1ui64vARB");
    if (!_ptr) {
        _ptr = &_fail_glProgramUniform1ui64vARB;
    }
    _glProgramUniform1ui64vARB = _ptr;
    _glProgramUniform1ui64vARB(program, location, count, value);
}

PFN_GLPROGRAMUNIFORM1UI64VARB _glProgramUniform1ui64vARB = &_get_glProgramUniform1ui64vARB;

static void APIENTRY _fail_glProgramUniform2ui64vARB(GLuint program, GLint location, GLsizei count, const GLuint64 * value) {
    const char *_name = "glProgramUniform2ui64vARB";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glProgramUniform2ui64vARB(GLuint program, GLint location, GLsizei count, const GLuint64 * value) {
    PFN_GLPROGRAMUNIFORM2UI64VARB _ptr;
    _ptr = (PFN_GLPROGRAMUNIFORM2UI64VARB)_getPrivateProcAddress("glProgramUniform2ui64vARB");
    if (!_ptr) {
        _ptr = &_fail_glProgramUniform2ui64vARB;
    }
    _glProgramUniform2ui64vARB = _ptr;
    _glProgramUniform2ui64vARB(program, location, count, value);
}

PFN_GLPROGRAMUNIFORM2UI64VARB _glProgramUniform2ui64vARB = &_get_glProgramUniform2ui64vARB;

static void APIENTRY _fail_glProgramUniform3ui64vARB(GLuint program, GLint location, GLsizei count, const GLuint64 * value) {
    const char *_name = "glProgramUniform3ui64vARB";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glProgramUniform3ui64vARB(GLuint program, GLint location, GLsizei count, const GLuint64 * value) {
    PFN_GLPROGRAMUNIFORM3UI64VARB _ptr;
    _ptr = (PFN_GLPROGRAMUNIFORM3UI64VARB)_getPrivateProcAddress("glProgramUniform3ui64vARB");
    if (!_ptr) {
        _ptr = &_fail_glProgramUniform3ui64vARB;
    }
    _glProgramUniform3ui64vARB = _ptr;
    _glProgramUniform3ui64vARB(program, location, count, value);
}

PFN_GLPROGRAMUNIFORM3UI64VARB _glProgramUniform3ui64vARB = &_get_glProgramUniform3ui64vARB;

static void APIENTRY _fail_glProgramUniform4ui64vARB(GLuint program, GLint location, GLsizei count, const GLuint64 * value) {
    const char *_name = "glProgramUniform4ui64vARB";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glProgramUniform4ui64vARB(GLuint program, GLint location, GLsizei count, const GLuint64 * value) {
    PFN_GLPROGRAMUNIFORM4UI64VARB _ptr;
    _ptr = (PFN_GLPROGRAMUNIFORM4UI64VARB)_getPrivateProcAddress("glProgramUniform4ui64vARB");
    if (!_ptr) {
        _ptr = &_fail_glProgramUniform4ui64vARB;
    }
    _glProgramUniform4ui64vARB = _ptr;
    _glProgramUniform4ui64vARB(program, location, count, value);
}

PFN_GLPROGRAMUNIFORM4UI64VARB _glProgramUniform4ui64vARB = &_get_glProgramUniform4ui64vARB;

static void APIENTRY _fail_glMultiDrawArraysIndirectCountARB(GLenum mode, const GLvoid * indirect, GLintptr drawcount, GLsizei maxdrawcount, GLsizei stride) {
    const char *_name = "glMultiDrawArraysIndirectCountARB";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glMultiDrawArraysIndirectCountARB(GLenum mode, const GLvoid * indirect, GLintptr drawcount, GLsizei maxdrawcount, GLsizei stride) {
    PFN_GLMULTIDRAWARRAYSINDIRECTCOUNTARB _ptr;
    _ptr = (PFN_GLMULTIDRAWARRAYSINDIRECTCOUNTARB)_getPrivateProcAddress("glMultiDrawArraysIndirectCountARB");
    if (!_ptr) {
        _ptr = &_fail_glMultiDrawArraysIndirectCountARB;
    }
    _glMultiDrawArraysIndirectCountARB = _ptr;
    _glMultiDrawArraysIndirectCountARB(mode, indirect, drawcount, maxdrawcount, stride);
}

PFN_GLMULTIDRAWARRAYSINDIRECTCOUNTARB _glMultiDrawArraysIndirectCountARB = &_get_glMultiDrawArraysIndirectCountARB;

static void APIENTRY _fail_glMultiDrawElementsIndirectCountARB(GLenum mode, GLenum type, const GLvoid * indirect, GLintptr drawcount, GLsizei maxdrawcount, GLsizei stride) {
    const char *_name = "glMultiDrawElementsIndirectCountARB";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glMultiDrawElementsIndirectCountARB(GLenum mode, GLenum type, const GLvoid * indirect, GLintptr drawcount, GLsizei maxdrawcount, GLsizei stride) {
    PFN_GLMULTIDRAWELEMENTSINDIRECTCOUNTARB _ptr;
    _ptr = (PFN_GLMULTIDRAWELEMENTSINDIRECTCOUNTARB)_getPrivateProcAddress("glMultiDrawElementsIndirectCountARB");
    if (!_ptr) {
        _ptr = &_fail_glMultiDrawElementsIndirectCountARB;
    }
    _glMultiDrawElementsIndirectCountARB = _ptr;
    _glMultiDrawElementsIndirectCountARB(mode, type, indirect, drawcount, maxdrawcount, stride);
}

PFN_GLMULTIDRAWELEMENTSINDIRECTCOUNTARB _glMultiDrawElementsIndirectCountARB = &_get_glMultiDrawElementsIndirectCountARB;

static void APIENTRY _fail_glVertexAttribDivisorARB(GLuint index, GLuint divisor) {
    const char *_name = "glVertexAttribDivisorARB";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glVertexAttribDivisorARB(GLuint index, GLuint divisor) {
    PFN_GLVERTEXATTRIBDIVISORARB _ptr;
    _ptr = (PFN_GLVERTEXATTRIBDIVISORARB)_getPrivateProcAddress("glVertexAttribDivisorARB");
    if (!_ptr) {
        _ptr = &_fail_glVertexAttribDivisorARB;
    }
    _glVertexAttribDivisorARB = _ptr;
    _glVertexAttribDivisorARB(index, divisor);
}

PFN_GLVERTEXATTRIBDIVISORARB _glVertexAttribDivisorARB = &_get_glVertexAttribDivisorARB;

static void APIENTRY _fail_glGetInternalformativ(GLenum target, GLenum internalformat, GLenum pname, GLsizei bufSize, GLint * params) {
    const char *_name = "glGetInternalformativ";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetInternalformativ(GLenum target, GLenum internalformat, GLenum pname, GLsizei bufSize, GLint * params) {
    PFN_GLGETINTERNALFORMATIV _ptr;
    _ptr = (PFN_GLGETINTERNALFORMATIV)_getPrivateProcAddress("glGetInternalformativ");
    if (!_ptr) {
        _ptr = &_fail_glGetInternalformativ;
    }
    _glGetInternalformativ = _ptr;
    _glGetInternalformativ(target, internalformat, pname, bufSize, params);
}

PFN_GLGETINTERNALFORMATIV _glGetInternalformativ = &_get_glGetInternalformativ;

static void APIENTRY _fail_glGetInternalformati64v(GLenum target, GLenum internalformat, GLenum pname, GLsizei bufSize, GLint64 * params) {
    const char *_name = "glGetInternalformati64v";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glGetInternalformati64v(GLenum target, GLenum internalformat, GLenum pname, GLsizei bufSize, GLint64 * params) {
    PFN_GLGETINTERNALFORMATI64V _ptr;
    _ptr = (PFN_GLGETINTERNALFORMATI64V)_getPrivateProcAddress("glGetInternalformati64v");
    if (!_ptr) {
        _ptr = &_fail_glGetInternalformati64v;
    }
    _glGetInternalformati64v = _ptr;
    _glGetInternalformati64v(target, internalformat, pname, bufSize, params);
}

PFN_GLGETINTERNALFORMATI64V _glGetInternalformati64v = &_get_glGetInternalformati64v;

static void APIENTRY _fail_glInvalidateTexSubImage(GLuint texture, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth) {
    const char *_name = "glInvalidateTexSubImage";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glInvalidateTexSubImage(GLuint texture, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth) {
    PFN_GLINVALIDATETEXSUBIMAGE _ptr;
    _ptr = (PFN_GLINVALIDATETEXSUBIMAGE)_getPrivateProcAddress("glInvalidateTexSubImage");
    if (!_ptr) {
        _ptr = &_fail_glInvalidateTexSubImage;
    }
    _glInvalidateTexSubImage = _ptr;
    _glInvalidateTexSubImage(texture, level, xoffset, yoffset, zoffset, width, height, depth);
}

PFN_GLINVALIDATETEXSUBIMAGE _glInvalidateTexSubImage = &_get_glInvalidateTexSubImage;

static void APIENTRY _fail_glInvalidateTexImage(GLuint texture, GLint level) {
    const char *_name = "glInvalidateTexImage";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glInvalidateTexImage(GLuint texture, GLint level) {
    PFN_GLINVALIDATETEXIMAGE _ptr;
    _ptr = (PFN_GLINVALIDATETEXIMAGE)_getPrivateProcAddress("glInvalidateTexImage");
    if (!_ptr) {
        _ptr = &_fail_glInvalidateTexImage;
    }
    _glInvalidateTexImage = _ptr;
    _glInvalidateTexImage(texture, level);
}

PFN_GLINVALIDATETEXIMAGE _glInvalidateTexImage = &_get_glInvalidateTexImage;

static void APIENTRY _fail_glInvalidateBufferSubData(GLuint buffer, GLintptr offset, GLsizeiptr length) {
    const char *_name = "glInvalidateBufferSubData";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glInvalidateBufferSubData(GLuint buffer, GLintptr offset, GLsizeiptr length) {
    PFN_GLINVALIDATEBUFFERSUBDATA _ptr;
    _ptr = (PFN_GLINVALIDATEBUFFERSUBDATA)_getPrivateProcAddress("glInvalidateBufferSubData");
    if (!_ptr) {
        _ptr = &_fail_glInvalidateBufferSubData;
    }
    _glInvalidateBufferSubData = _ptr;
    _glInvalidateBufferSubData(buffer, offset, length);
}

PFN_GLINVALIDATEBUFFERSUBDATA _glInvalidateBufferSubData = &_get_glInvalidateBufferSubData;

static void APIENTRY _fail_glInvalidateBufferData(GLuint buffer) {
    const char *_name = "glInvalidateBufferData";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glInvalidateBufferData(GLuint buffer) {
    PFN_GLINVALIDATEBUFFERDATA _ptr;
    _ptr = (PFN_GLINVALIDATEBUFFERDATA)_getPrivateProcAddress("glInvalidateBufferData");
    if (!_ptr) {
        _ptr = &_fail_glInvalidateBufferData;
    }
    _glInvalidateBufferData = _ptr;
    _glInvalidateBufferData(buffer);
}

PFN_GLINVALIDATEBUFFERDATA _glInvalidateBufferData = &_get_glInvalidateBufferData;

static void APIENTRY _fail_glInvalidateFramebuffer(GLenum target, GLsizei numAttachments, const GLenum * attachments) {
    const char *_name = "glInvalidateFramebuffer";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glInvalidateFramebuffer(GLenum target, GLsizei numAttachments, const GLenum * attachments) {
    PFN_GLINVALIDATEFRAMEBUFFER _ptr;
    _ptr = (PFN_GLINVALIDATEFRAMEBUFFER)_getPrivateProcAddress("glInvalidateFramebuffer");
    if (!_ptr) {
        _ptr = &_fail_glInvalidateFramebuffer;
    }
    _glInvalidateFramebuffer = _ptr;
    _glInvalidateFramebuffer(target, numAttachments, attachments);
}

PFN_GLINVALIDATEFRAMEBUFFER _glInvalidateFramebuffer = &_get_glInvalidateFramebuffer;

static void APIENTRY _fail_glInvalidateSubFramebuffer(GLenum target, GLsizei numAttachments, const GLenum * attachments, GLint x, GLint y, GLsizei width, GLsizei height) {
    const char *_name = "glInvalidateSubFramebuffer";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glInvalidateSubFramebuffer(GLenum target, GLsizei numAttachments, const GLenum * attachments, GLint x, GLint y, GLsizei width, GLsizei height) {
    PFN_GLINVALIDATESUBFRAMEBUFFER _ptr;
    _ptr = (PFN_GLINVALIDATESUBFRAMEBUFFER)_getPrivateProcAddress("glInvalidateSubFramebuffer");
    if (!_ptr) {
        _ptr = &_fail_glInvalidateSubFramebuffer;
    }
    _glInvalidateSubFramebuffer = _ptr;
    _glInvalidateSubFramebuffer(target, numAttachments, attachments, x, y, width, height);
}

PFN_GLINVALIDATESUBFRAMEBUFFER _glInvalidateSubFramebuffer = &_get_glInvalidateSubFramebuffer;

static GLvoid * APIENTRY _fail_glMapBufferRange(GLenum target, GLintptr offset, GLsizeiptr length, GLbitfield access) {
    const char *_name = "glMapBufferRange";
    os::log("error: unavailable function %s\n", _name);
    os::abort();
}

static GLvoid * APIENTRY _get_glMapBufferRange(GLenum target, GLintptr offset, GLsizeiptr length, GLbitfield access) {
    PFN_GLMAPBUFFERRANGE _ptr;
    _ptr = (PFN_GLMAPBUFFERRANGE)_getPrivateProcAddress("glMapBufferRange");
    if (!_ptr) {
        _ptr = &_fail_glMapBufferRange;
    }
    _glMapBufferRange = _ptr;
    return _glMapBufferRange(target, offset, length, access);
}

PFN_GLMAPBUFFERRANGE _glMapBufferRange = &_get_glMapBufferRange;

static void APIENTRY _fail_glFlushMappedBufferRange(GLenum target, GLintptr offset, GLsizeiptr length) {
    const char *_name = "glFlushMappedBufferRange";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glFlushMappedBufferRange(GLenum target, GLintptr offset, GLsizeiptr length) {
    PFN_GLFLUSHMAPPEDBUFFERRANGE _ptr;
    _ptr = (PFN_GLFLUSHMAPPEDBUFFERRANGE)_getPrivateProcAddress("glFlushMappedBufferRange");
    if (!_ptr) {
        _ptr = &_fail_glFlushMappedBufferRange;
    }
    _glFlushMappedBufferRange = _ptr;
    _glFlushMappedBufferRange(target, offset, length);
}

PFN_GLFLUSHMAPPEDBUFFERRANGE _glFlushMappedBufferRange = &_get_glFlushMappedBufferRange;

static void APIENTRY _fail_glCurrentPaletteMatrixARB(GLint index) {
    const char *_name = "glCurrentPaletteMatrixARB";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glCurrentPaletteMatrixARB(GLint index) {
    PFN_GLCURRENTPALETTEMATRIXARB _ptr;
    _ptr = (PFN_GLCURRENTPALETTEMATRIXARB)_getPrivateProcAddress("glCurrentPaletteMatrixARB");
    if (!_ptr) {
        _ptr = &_fail_glCurrentPaletteMatrixARB;
    }
    _glCurrentPaletteMatrixARB = _ptr;
    _glCurrentPaletteMatrixARB(index);
}

PFN_GLCURRENTPALETTEMATRIXARB _glCurrentPaletteMatrixARB = &_get_glCurrentPaletteMatrixARB;

static void APIENTRY _fail_glMatrixIndexubvARB(GLint size, const GLubyte * indices) {
    const char *_name = "glMatrixIndexubvARB";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glMatrixIndexubvARB(GLint size, const GLubyte * indices) {
    PFN_GLMATRIXINDEXUBVARB _ptr;
    _ptr = (PFN_GLMATRIXINDEXUBVARB)_getPrivateProcAddress("glMatrixIndexubvARB");
    if (!_ptr) {
        _ptr = &_fail_glMatrixIndexubvARB;
    }
    _glMatrixIndexubvARB = _ptr;
    _glMatrixIndexubvARB(size, indices);
}

PFN_GLMATRIXINDEXUBVARB _glMatrixIndexubvARB = &_get_glMatrixIndexubvARB;

static void APIENTRY _fail_glMatrixIndexusvARB(GLint size, const GLushort * indices) {
    const char *_name = "glMatrixIndexusvARB";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glMatrixIndexusvARB(GLint size, const GLushort * indices) {
    PFN_GLMATRIXINDEXUSVARB _ptr;
    _ptr = (PFN_GLMATRIXINDEXUSVARB)_getPrivateProcAddress("glMatrixIndexusvARB");
    if (!_ptr) {
        _ptr = &_fail_glMatrixIndexusvARB;
    }
    _glMatrixIndexusvARB = _ptr;
    _glMatrixIndexusvARB(size, indices);
}

PFN_GLMATRIXINDEXUSVARB _glMatrixIndexusvARB = &_get_glMatrixIndexusvARB;

static void APIENTRY _fail_glMatrixIndexuivARB(GLint size, const GLuint * indices) {
    const char *_name = "glMatrixIndexuivARB";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glMatrixIndexuivARB(GLint size, const GLuint * indices) {
    PFN_GLMATRIXINDEXUIVARB _ptr;
    _ptr = (PFN_GLMATRIXINDEXUIVARB)_getPrivateProcAddress("glMatrixIndexuivARB");
    if (!_ptr) {
        _ptr = &_fail_glMatrixIndexuivARB;
    }
    _glMatrixIndexuivARB = _ptr;
    _glMatrixIndexuivARB(size, indices);
}

PFN_GLMATRIXINDEXUIVARB _glMatrixIndexuivARB = &_get_glMatrixIndexuivARB;

static void APIENTRY _fail_glMatrixIndexPointerARB(GLint size, GLenum type, GLsizei stride, const GLvoid * pointer) {
    const char *_name = "glMatrixIndexPointerARB";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glMatrixIndexPointerARB(GLint size, GLenum type, GLsizei stride, const GLvoid * pointer) {
    PFN_GLMATRIXINDEXPOINTERARB _ptr;
    _ptr = (PFN_GLMATRIXINDEXPOINTERARB)_getPrivateProcAddress("glMatrixIndexPointerARB");
    if (!_ptr) {
        _ptr = &_fail_glMatrixIndexPointerARB;
    }
    _glMatrixIndexPointerARB = _ptr;
    _glMatrixIndexPointerARB(size, type, stride, pointer);
}

PFN_GLMATRIXINDEXPOINTERARB _glMatrixIndexPointerARB = &_get_glMatrixIndexPointerARB;

static void APIENTRY _fail_glBindBuffersBase(GLenum target, GLuint first, GLsizei count, const GLuint * buffers) {
    const char *_name = "glBindBuffersBase";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glBindBuffersBase(GLenum target, GLuint first, GLsizei count, const GLuint * buffers) {
    PFN_GLBINDBUFFERSBASE _ptr;
    _ptr = (PFN_GLBINDBUFFERSBASE)_getPrivateProcAddress("glBindBuffersBase");
    if (!_ptr) {
        _ptr = &_fail_glBindBuffersBase;
    }
    _glBindBuffersBase = _ptr;
    _glBindBuffersBase(target, first, count, buffers);
}

PFN_GLBINDBUFFERSBASE _glBindBuffersBase = &_get_glBindBuffersBase;

static void APIENTRY _fail_glBindBuffersRange(GLenum target, GLuint first, GLsizei count, const GLuint * buffers, const GLintptr * offsets, const GLsizeiptr * sizes) {
    const char *_name = "glBindBuffersRange";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glBindBuffersRange(GLenum target, GLuint first, GLsizei count, const GLuint * buffers, const GLintptr * offsets, const GLsizeiptr * sizes) {
    PFN_GLBINDBUFFERSRANGE _ptr;
    _ptr = (PFN_GLBINDBUFFERSRANGE)_getPrivateProcAddress("glBindBuffersRange");
    if (!_ptr) {
        _ptr = &_fail_glBindBuffersRange;
    }
    _glBindBuffersRange = _ptr;
    _glBindBuffersRange(target, first, count, buffers, offsets, sizes);
}

PFN_GLBINDBUFFERSRANGE _glBindBuffersRange = &_get_glBindBuffersRange;

static void APIENTRY _fail_glBindTextures(GLuint first, GLsizei count, const GLuint * textures) {
    const char *_name = "glBindTextures";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glBindTextures(GLuint first, GLsizei count, const GLuint * textures) {
    PFN_GLBINDTEXTURES _ptr;
    _ptr = (PFN_GLBINDTEXTURES)_getPrivateProcAddress("glBindTextures");
    if (!_ptr) {
        _ptr = &_fail_glBindTextures;
    }
    _glBindTextures = _ptr;
    _glBindTextures(first, count, textures);
}

PFN_GLBINDTEXTURES _glBindTextures = &_get_glBindTextures;

static void APIENTRY _fail_glBindSamplers(GLuint first, GLsizei count, const GLuint * samplers) {
    const char *_name = "glBindSamplers";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glBindSamplers(GLuint first, GLsizei count, const GLuint * samplers) {
    PFN_GLBINDSAMPLERS _ptr;
    _ptr = (PFN_GLBINDSAMPLERS)_getPrivateProcAddress("glBindSamplers");
    if (!_ptr) {
        _ptr = &_fail_glBindSamplers;
    }
    _glBindSamplers = _ptr;
    _glBindSamplers(first, count, samplers);
}

PFN_GLBINDSAMPLERS _glBindSamplers = &_get_glBindSamplers;

static void APIENTRY _fail_glBindImageTextures(GLuint first, GLsizei count, const GLuint * textures) {
    const char *_name = "glBindImageTextures";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glBindImageTextures(GLuint first, GLsizei count, const GLuint * textures) {
    PFN_GLBINDIMAGETEXTURES _ptr;
    _ptr = (PFN_GLBINDIMAGETEXTURES)_getPrivateProcAddress("glBindImageTextures");
    if (!_ptr) {
        _ptr = &_fail_glBindImageTextures;
    }
    _glBindImageTextures = _ptr;
    _glBindImageTextures(first, count, textures);
}

PFN_GLBINDIMAGETEXTURES _glBindImageTextures = &_get_glBindImageTextures;

static void APIENTRY _fail_glBindVertexBuffers(GLuint first, GLsizei count, const GLuint * buffers, const GLintptr * offsets, const GLsizei * strides) {
    const char *_name = "glBindVertexBuffers";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glBindVertexBuffers(GLuint first, GLsizei count, const GLuint * buffers, const GLintptr * offsets, const GLsizei * strides) {
    PFN_GLBINDVERTEXBUFFERS _ptr;
    _ptr = (PFN_GLBINDVERTEXBUFFERS)_getPrivateProcAddress("glBindVertexBuffers");
    if (!_ptr) {
        _ptr = &_fail_glBindVertexBuffers;
    }
    _glBindVertexBuffers = _ptr;
    _glBindVertexBuffers(first, count, buffers, offsets, strides);
}

PFN_GLBINDVERTEXBUFFERS _glBindVertexBuffers = &_get_glBindVertexBuffers;

static void APIENTRY _fail_glMultiDrawArraysIndirect(GLenum mode, const GLvoid * indirect, GLsizei drawcount, GLsizei stride) {
    const char *_name = "glMultiDrawArraysIndirect";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glMultiDrawArraysIndirect(GLenum mode, const GLvoid * indirect, GLsizei drawcount, GLsizei stride) {
    PFN_GLMULTIDRAWARRAYSINDIRECT _ptr;
    _ptr = (PFN_GLMULTIDRAWARRAYSINDIRECT)_getPrivateProcAddress("glMultiDrawArraysIndirect");
    if (!_ptr) {
        _ptr = &_fail_glMultiDrawArraysIndirect;
    }
    _glMultiDrawArraysIndirect = _ptr;
    _glMultiDrawArraysIndirect(mode, indirect, drawcount, stride);
}

PFN_GLMULTIDRAWARRAYSINDIRECT _glMultiDrawArraysIndirect = &_get_glMultiDrawArraysIndirect;

static void APIENTRY _fail_glMultiDrawElementsIndirect(GLenum mode, GLenum type, const GLvoid * indirect, GLsizei drawcount, GLsizei stride) {
    const char *_name = "glMultiDrawElementsIndirect";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glMultiDrawElementsIndirect(GLenum mode, GLenum type, const GLvoid * indirect, GLsizei drawcount, GLsizei stride) {
    PFN_GLMULTIDRAWELEMENTSINDIRECT _ptr;
    _ptr = (PFN_GLMULTIDRAWELEMENTSINDIRECT)_getPrivateProcAddress("glMultiDrawElementsIndirect");
    if (!_ptr) {
        _ptr = &_fail_glMultiDrawElementsIndirect;
    }
    _glMultiDrawElementsIndirect = _ptr;
    _glMultiDrawElementsIndirect(mode, type, indirect, drawcount, stride);
}

PFN_GLMULTIDRAWELEMENTSINDIRECT _glMultiDrawElementsIndirect = &_get_glMultiDrawElementsIndirect;

static void APIENTRY _fail_glSampleCoverageARB(GLfloat value, GLboolean invert) {
    const char *_name = "glSampleCoverageARB";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glSampleCoverageARB(GLfloat value, GLboolean invert) {
    PFN_GLSAMPLECOVERAGEARB _ptr;
    _ptr = (PFN_GLSAMPLECOVERAGEARB)_getPrivateProcAddress("glSampleCoverageARB");
    if (!_ptr) {
        _ptr = &_fail_glSampleCoverageARB;
    }
    _glSampleCoverageARB = _ptr;
    _glSampleCoverageARB(value, invert);
}

PFN_GLSAMPLECOVERAGEARB _glSampleCoverageARB = &_get_glSampleCoverageARB;

static void APIENTRY _fail_glActiveTextureARB(GLenum texture) {
    const char *_name = "glActiveTextureARB";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glActiveTextureARB(GLenum texture) {
    PFN_GLACTIVETEXTUREARB _ptr;
    _ptr = (PFN_GLACTIVETEXTUREARB)_getPrivateProcAddress("glActiveTextureARB");
    if (!_ptr) {
        _ptr = &_fail_glActiveTextureARB;
    }
    _glActiveTextureARB = _ptr;
    _glActiveTextureARB(texture);
}

PFN_GLACTIVETEXTUREARB _glActiveTextureARB = &_get_glActiveTextureARB;

static void APIENTRY _fail_glClientActiveTextureARB(GLenum texture) {
    const char *_name = "glClientActiveTextureARB";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glClientActiveTextureARB(GLenum texture) {
    PFN_GLCLIENTACTIVETEXTUREARB _ptr;
    _ptr = (PFN_GLCLIENTACTIVETEXTUREARB)_getPrivateProcAddress("glClientActiveTextureARB");
    if (!_ptr) {
        _ptr = &_fail_glClientActiveTextureARB;
    }
    _glClientActiveTextureARB = _ptr;
    _glClientActiveTextureARB(texture);
}

PFN_GLCLIENTACTIVETEXTUREARB _glClientActiveTextureARB = &_get_glClientActiveTextureARB;

static void APIENTRY _fail_glMultiTexCoord1dARB(GLenum target, GLdouble s) {
    const char *_name = "glMultiTexCoord1dARB";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glMultiTexCoord1dARB(GLenum target, GLdouble s) {
    PFN_GLMULTITEXCOORD1DARB _ptr;
    _ptr = (PFN_GLMULTITEXCOORD1DARB)_getPrivateProcAddress("glMultiTexCoord1dARB");
    if (!_ptr) {
        _ptr = &_fail_glMultiTexCoord1dARB;
    }
    _glMultiTexCoord1dARB = _ptr;
    _glMultiTexCoord1dARB(target, s);
}

PFN_GLMULTITEXCOORD1DARB _glMultiTexCoord1dARB = &_get_glMultiTexCoord1dARB;

static void APIENTRY _fail_glMultiTexCoord1dvARB(GLenum target, const GLdouble * v) {
    const char *_name = "glMultiTexCoord1dvARB";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glMultiTexCoord1dvARB(GLenum target, const GLdouble * v) {
    PFN_GLMULTITEXCOORD1DVARB _ptr;
    _ptr = (PFN_GLMULTITEXCOORD1DVARB)_getPrivateProcAddress("glMultiTexCoord1dvARB");
    if (!_ptr) {
        _ptr = &_fail_glMultiTexCoord1dvARB;
    }
    _glMultiTexCoord1dvARB = _ptr;
    _glMultiTexCoord1dvARB(target, v);
}

PFN_GLMULTITEXCOORD1DVARB _glMultiTexCoord1dvARB = &_get_glMultiTexCoord1dvARB;

static void APIENTRY _fail_glMultiTexCoord1fARB(GLenum target, GLfloat s) {
    const char *_name = "glMultiTexCoord1fARB";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glMultiTexCoord1fARB(GLenum target, GLfloat s) {
    PFN_GLMULTITEXCOORD1FARB _ptr;
    _ptr = (PFN_GLMULTITEXCOORD1FARB)_getPrivateProcAddress("glMultiTexCoord1fARB");
    if (!_ptr) {
        _ptr = &_fail_glMultiTexCoord1fARB;
    }
    _glMultiTexCoord1fARB = _ptr;
    _glMultiTexCoord1fARB(target, s);
}

PFN_GLMULTITEXCOORD1FARB _glMultiTexCoord1fARB = &_get_glMultiTexCoord1fARB;

static void APIENTRY _fail_glMultiTexCoord1fvARB(GLenum target, const GLfloat * v) {
    const char *_name = "glMultiTexCoord1fvARB";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glMultiTexCoord1fvARB(GLenum target, const GLfloat * v) {
    PFN_GLMULTITEXCOORD1FVARB _ptr;
    _ptr = (PFN_GLMULTITEXCOORD1FVARB)_getPrivateProcAddress("glMultiTexCoord1fvARB");
    if (!_ptr) {
        _ptr = &_fail_glMultiTexCoord1fvARB;
    }
    _glMultiTexCoord1fvARB = _ptr;
    _glMultiTexCoord1fvARB(target, v);
}

PFN_GLMULTITEXCOORD1FVARB _glMultiTexCoord1fvARB = &_get_glMultiTexCoord1fvARB;

static void APIENTRY _fail_glMultiTexCoord1iARB(GLenum target, GLint s) {
    const char *_name = "glMultiTexCoord1iARB";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glMultiTexCoord1iARB(GLenum target, GLint s) {
    PFN_GLMULTITEXCOORD1IARB _ptr;
    _ptr = (PFN_GLMULTITEXCOORD1IARB)_getPrivateProcAddress("glMultiTexCoord1iARB");
    if (!_ptr) {
        _ptr = &_fail_glMultiTexCoord1iARB;
    }
    _glMultiTexCoord1iARB = _ptr;
    _glMultiTexCoord1iARB(target, s);
}

PFN_GLMULTITEXCOORD1IARB _glMultiTexCoord1iARB = &_get_glMultiTexCoord1iARB;

static void APIENTRY _fail_glMultiTexCoord1ivARB(GLenum target, const GLint * v) {
    const char *_name = "glMultiTexCoord1ivARB";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glMultiTexCoord1ivARB(GLenum target, const GLint * v) {
    PFN_GLMULTITEXCOORD1IVARB _ptr;
    _ptr = (PFN_GLMULTITEXCOORD1IVARB)_getPrivateProcAddress("glMultiTexCoord1ivARB");
    if (!_ptr) {
        _ptr = &_fail_glMultiTexCoord1ivARB;
    }
    _glMultiTexCoord1ivARB = _ptr;
    _glMultiTexCoord1ivARB(target, v);
}

PFN_GLMULTITEXCOORD1IVARB _glMultiTexCoord1ivARB = &_get_glMultiTexCoord1ivARB;

static void APIENTRY _fail_glMultiTexCoord1sARB(GLenum target, GLshort s) {
    const char *_name = "glMultiTexCoord1sARB";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glMultiTexCoord1sARB(GLenum target, GLshort s) {
    PFN_GLMULTITEXCOORD1SARB _ptr;
    _ptr = (PFN_GLMULTITEXCOORD1SARB)_getPrivateProcAddress("glMultiTexCoord1sARB");
    if (!_ptr) {
        _ptr = &_fail_glMultiTexCoord1sARB;
    }
    _glMultiTexCoord1sARB = _ptr;
    _glMultiTexCoord1sARB(target, s);
}

PFN_GLMULTITEXCOORD1SARB _glMultiTexCoord1sARB = &_get_glMultiTexCoord1sARB;

static void APIENTRY _fail_glMultiTexCoord1svARB(GLenum target, const GLshort * v) {
    const char *_name = "glMultiTexCoord1svARB";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glMultiTexCoord1svARB(GLenum target, const GLshort * v) {
    PFN_GLMULTITEXCOORD1SVARB _ptr;
    _ptr = (PFN_GLMULTITEXCOORD1SVARB)_getPrivateProcAddress("glMultiTexCoord1svARB");
    if (!_ptr) {
        _ptr = &_fail_glMultiTexCoord1svARB;
    }
    _glMultiTexCoord1svARB = _ptr;
    _glMultiTexCoord1svARB(target, v);
}

PFN_GLMULTITEXCOORD1SVARB _glMultiTexCoord1svARB = &_get_glMultiTexCoord1svARB;

static void APIENTRY _fail_glMultiTexCoord2dARB(GLenum target, GLdouble s, GLdouble t) {
    const char *_name = "glMultiTexCoord2dARB";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glMultiTexCoord2dARB(GLenum target, GLdouble s, GLdouble t) {
    PFN_GLMULTITEXCOORD2DARB _ptr;
    _ptr = (PFN_GLMULTITEXCOORD2DARB)_getPrivateProcAddress("glMultiTexCoord2dARB");
    if (!_ptr) {
        _ptr = &_fail_glMultiTexCoord2dARB;
    }
    _glMultiTexCoord2dARB = _ptr;
    _glMultiTexCoord2dARB(target, s, t);
}

PFN_GLMULTITEXCOORD2DARB _glMultiTexCoord2dARB = &_get_glMultiTexCoord2dARB;

static void APIENTRY _fail_glMultiTexCoord2dvARB(GLenum target, const GLdouble * v) {
    const char *_name = "glMultiTexCoord2dvARB";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glMultiTexCoord2dvARB(GLenum target, const GLdouble * v) {
    PFN_GLMULTITEXCOORD2DVARB _ptr;
    _ptr = (PFN_GLMULTITEXCOORD2DVARB)_getPrivateProcAddress("glMultiTexCoord2dvARB");
    if (!_ptr) {
        _ptr = &_fail_glMultiTexCoord2dvARB;
    }
    _glMultiTexCoord2dvARB = _ptr;
    _glMultiTexCoord2dvARB(target, v);
}

PFN_GLMULTITEXCOORD2DVARB _glMultiTexCoord2dvARB = &_get_glMultiTexCoord2dvARB;

static void APIENTRY _fail_glMultiTexCoord2fARB(GLenum target, GLfloat s, GLfloat t) {
    const char *_name = "glMultiTexCoord2fARB";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glMultiTexCoord2fARB(GLenum target, GLfloat s, GLfloat t) {
    PFN_GLMULTITEXCOORD2FARB _ptr;
    _ptr = (PFN_GLMULTITEXCOORD2FARB)_getPrivateProcAddress("glMultiTexCoord2fARB");
    if (!_ptr) {
        _ptr = &_fail_glMultiTexCoord2fARB;
    }
    _glMultiTexCoord2fARB = _ptr;
    _glMultiTexCoord2fARB(target, s, t);
}

PFN_GLMULTITEXCOORD2FARB _glMultiTexCoord2fARB = &_get_glMultiTexCoord2fARB;

static void APIENTRY _fail_glMultiTexCoord2fvARB(GLenum target, const GLfloat * v) {
    const char *_name = "glMultiTexCoord2fvARB";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glMultiTexCoord2fvARB(GLenum target, const GLfloat * v) {
    PFN_GLMULTITEXCOORD2FVARB _ptr;
    _ptr = (PFN_GLMULTITEXCOORD2FVARB)_getPrivateProcAddress("glMultiTexCoord2fvARB");
    if (!_ptr) {
        _ptr = &_fail_glMultiTexCoord2fvARB;
    }
    _glMultiTexCoord2fvARB = _ptr;
    _glMultiTexCoord2fvARB(target, v);
}

PFN_GLMULTITEXCOORD2FVARB _glMultiTexCoord2fvARB = &_get_glMultiTexCoord2fvARB;

static void APIENTRY _fail_glMultiTexCoord2iARB(GLenum target, GLint s, GLint t) {
    const char *_name = "glMultiTexCoord2iARB";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glMultiTexCoord2iARB(GLenum target, GLint s, GLint t) {
    PFN_GLMULTITEXCOORD2IARB _ptr;
    _ptr = (PFN_GLMULTITEXCOORD2IARB)_getPrivateProcAddress("glMultiTexCoord2iARB");
    if (!_ptr) {
        _ptr = &_fail_glMultiTexCoord2iARB;
    }
    _glMultiTexCoord2iARB = _ptr;
    _glMultiTexCoord2iARB(target, s, t);
}

PFN_GLMULTITEXCOORD2IARB _glMultiTexCoord2iARB = &_get_glMultiTexCoord2iARB;

static void APIENTRY _fail_glMultiTexCoord2ivARB(GLenum target, const GLint * v) {
    const char *_name = "glMultiTexCoord2ivARB";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glMultiTexCoord2ivARB(GLenum target, const GLint * v) {
    PFN_GLMULTITEXCOORD2IVARB _ptr;
    _ptr = (PFN_GLMULTITEXCOORD2IVARB)_getPrivateProcAddress("glMultiTexCoord2ivARB");
    if (!_ptr) {
        _ptr = &_fail_glMultiTexCoord2ivARB;
    }
    _glMultiTexCoord2ivARB = _ptr;
    _glMultiTexCoord2ivARB(target, v);
}

PFN_GLMULTITEXCOORD2IVARB _glMultiTexCoord2ivARB = &_get_glMultiTexCoord2ivARB;

static void APIENTRY _fail_glMultiTexCoord2sARB(GLenum target, GLshort s, GLshort t) {
    const char *_name = "glMultiTexCoord2sARB";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glMultiTexCoord2sARB(GLenum target, GLshort s, GLshort t) {
    PFN_GLMULTITEXCOORD2SARB _ptr;
    _ptr = (PFN_GLMULTITEXCOORD2SARB)_getPrivateProcAddress("glMultiTexCoord2sARB");
    if (!_ptr) {
        _ptr = &_fail_glMultiTexCoord2sARB;
    }
    _glMultiTexCoord2sARB = _ptr;
    _glMultiTexCoord2sARB(target, s, t);
}

PFN_GLMULTITEXCOORD2SARB _glMultiTexCoord2sARB = &_get_glMultiTexCoord2sARB;

static void APIENTRY _fail_glMultiTexCoord2svARB(GLenum target, const GLshort * v) {
    const char *_name = "glMultiTexCoord2svARB";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glMultiTexCoord2svARB(GLenum target, const GLshort * v) {
    PFN_GLMULTITEXCOORD2SVARB _ptr;
    _ptr = (PFN_GLMULTITEXCOORD2SVARB)_getPrivateProcAddress("glMultiTexCoord2svARB");
    if (!_ptr) {
        _ptr = &_fail_glMultiTexCoord2svARB;
    }
    _glMultiTexCoord2svARB = _ptr;
    _glMultiTexCoord2svARB(target, v);
}

PFN_GLMULTITEXCOORD2SVARB _glMultiTexCoord2svARB = &_get_glMultiTexCoord2svARB;

static void APIENTRY _fail_glMultiTexCoord3dARB(GLenum target, GLdouble s, GLdouble t, GLdouble r) {
    const char *_name = "glMultiTexCoord3dARB";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glMultiTexCoord3dARB(GLenum target, GLdouble s, GLdouble t, GLdouble r) {
    PFN_GLMULTITEXCOORD3DARB _ptr;
    _ptr = (PFN_GLMULTITEXCOORD3DARB)_getPrivateProcAddress("glMultiTexCoord3dARB");
    if (!_ptr) {
        _ptr = &_fail_glMultiTexCoord3dARB;
    }
    _glMultiTexCoord3dARB = _ptr;
    _glMultiTexCoord3dARB(target, s, t, r);
}

PFN_GLMULTITEXCOORD3DARB _glMultiTexCoord3dARB = &_get_glMultiTexCoord3dARB;

static void APIENTRY _fail_glMultiTexCoord3dvARB(GLenum target, const GLdouble * v) {
    const char *_name = "glMultiTexCoord3dvARB";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glMultiTexCoord3dvARB(GLenum target, const GLdouble * v) {
    PFN_GLMULTITEXCOORD3DVARB _ptr;
    _ptr = (PFN_GLMULTITEXCOORD3DVARB)_getPrivateProcAddress("glMultiTexCoord3dvARB");
    if (!_ptr) {
        _ptr = &_fail_glMultiTexCoord3dvARB;
    }
    _glMultiTexCoord3dvARB = _ptr;
    _glMultiTexCoord3dvARB(target, v);
}

PFN_GLMULTITEXCOORD3DVARB _glMultiTexCoord3dvARB = &_get_glMultiTexCoord3dvARB;

static void APIENTRY _fail_glMultiTexCoord3fARB(GLenum target, GLfloat s, GLfloat t, GLfloat r) {
    const char *_name = "glMultiTexCoord3fARB";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glMultiTexCoord3fARB(GLenum target, GLfloat s, GLfloat t, GLfloat r) {
    PFN_GLMULTITEXCOORD3FARB _ptr;
    _ptr = (PFN_GLMULTITEXCOORD3FARB)_getPrivateProcAddress("glMultiTexCoord3fARB");
    if (!_ptr) {
        _ptr = &_fail_glMultiTexCoord3fARB;
    }
    _glMultiTexCoord3fARB = _ptr;
    _glMultiTexCoord3fARB(target, s, t, r);
}

PFN_GLMULTITEXCOORD3FARB _glMultiTexCoord3fARB = &_get_glMultiTexCoord3fARB;

static void APIENTRY _fail_glMultiTexCoord3fvARB(GLenum target, const GLfloat * v) {
    const char *_name = "glMultiTexCoord3fvARB";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glMultiTexCoord3fvARB(GLenum target, const GLfloat * v) {
    PFN_GLMULTITEXCOORD3FVARB _ptr;
    _ptr = (PFN_GLMULTITEXCOORD3FVARB)_getPrivateProcAddress("glMultiTexCoord3fvARB");
    if (!_ptr) {
        _ptr = &_fail_glMultiTexCoord3fvARB;
    }
    _glMultiTexCoord3fvARB = _ptr;
    _glMultiTexCoord3fvARB(target, v);
}

PFN_GLMULTITEXCOORD3FVARB _glMultiTexCoord3fvARB = &_get_glMultiTexCoord3fvARB;

static void APIENTRY _fail_glMultiTexCoord3iARB(GLenum target, GLint s, GLint t, GLint r) {
    const char *_name = "glMultiTexCoord3iARB";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glMultiTexCoord3iARB(GLenum target, GLint s, GLint t, GLint r) {
    PFN_GLMULTITEXCOORD3IARB _ptr;
    _ptr = (PFN_GLMULTITEXCOORD3IARB)_getPrivateProcAddress("glMultiTexCoord3iARB");
    if (!_ptr) {
        _ptr = &_fail_glMultiTexCoord3iARB;
    }
    _glMultiTexCoord3iARB = _ptr;
    _glMultiTexCoord3iARB(target, s, t, r);
}

PFN_GLMULTITEXCOORD3IARB _glMultiTexCoord3iARB = &_get_glMultiTexCoord3iARB;

static void APIENTRY _fail_glMultiTexCoord3ivARB(GLenum target, const GLint * v) {
    const char *_name = "glMultiTexCoord3ivARB";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glMultiTexCoord3ivARB(GLenum target, const GLint * v) {
    PFN_GLMULTITEXCOORD3IVARB _ptr;
    _ptr = (PFN_GLMULTITEXCOORD3IVARB)_getPrivateProcAddress("glMultiTexCoord3ivARB");
    if (!_ptr) {
        _ptr = &_fail_glMultiTexCoord3ivARB;
    }
    _glMultiTexCoord3ivARB = _ptr;
    _glMultiTexCoord3ivARB(target, v);
}

PFN_GLMULTITEXCOORD3IVARB _glMultiTexCoord3ivARB = &_get_glMultiTexCoord3ivARB;

static void APIENTRY _fail_glMultiTexCoord3sARB(GLenum target, GLshort s, GLshort t, GLshort r) {
    const char *_name = "glMultiTexCoord3sARB";
    os::log("warning: ignoring call to unavailable function %s\n", _name);
    return;
}

static void APIENTRY _get_glMultiTexCoord3sARB(GLenum target, GLshort s, GLshort t, GLshort r) {
    PFN_GLMULTITEXCOORD3SARB _ptr;
    _ptr = (PFN_GLMULTITEXCOORD3SARB)_getPrivateProcAddress("glMultiTexCoord3sARB");
    if (!_ptr) {
        _ptr = &_fail_glMultiTexCoord3sARB;
    }
    _glMultiTexCoord3sARB = _ptr;
    _glMultiTexCoord3sARB(target, s, t, r);
}

PFN_GLMULTITEXCOORD3SARB _glMultiTexCoord3sARB = &_get_glMu