{-# LANGUAGE CPP #-}
{-# LANGUAGE NoRebindableSyntax #-}
{-# OPTIONS_GHC -fno-warn-missing-import-lists #-}
{-# OPTIONS_GHC -w #-}
module Paths_Agda (
    version,
    getBinDir, getLibDir, getDynLibDir, getDataDir, getLibexecDir,
    getDataFileName, getSysconfDir
  ) where


import qualified Control.Exception as Exception
import qualified Data.List as List
import Data.Version (Version(..))
import System.Environment (getEnv)
import Prelude


#if defined(VERSION_base)

#if MIN_VERSION_base(4,0,0)
catchIO :: IO a -> (Exception.IOException -> IO a) -> IO a
#else
catchIO :: IO a -> (Exception.Exception -> IO a) -> IO a
#endif

#else
catchIO :: IO a -> (Exception.IOException -> IO a) -> IO a
#endif
catchIO = Exception.catch

version :: Version
version = Version [2,6,4,3] []

getDataFileName :: FilePath -> IO FilePath
getDataFileName name = do
  dir <- getDataDir
  return (dir `joinFileName` name)

getBinDir, getLibDir, getDynLibDir, getDataDir, getLibexecDir, getSysconfDir :: IO FilePath



bindir, libdir, dynlibdir, datadir, libexecdir, sysconfdir :: FilePath
bindir     = "/usr/bin"
libdir     = "/usr/lib/ghc-9.4.8/site-local/Agda-2.6.4.3"
dynlibdir  = "/usr/lib"
datadir    = "/usr/share/agda"
libexecdir = "/usr/libexec/x86_64-linux-ghc-9.4.8/Agda-2.6.4.3"
sysconfdir = "/usr/etc"

getBinDir     = catchIO (getEnv "Agda_bindir")     (\_ -> return bindir)
getLibDir     = catchIO (getEnv "Agda_libdir")     (\_ -> return libdir)
getDynLibDir  = catchIO (getEnv "Agda_dynlibdir")  (\_ -> return dynlibdir)
getDataDir    = catchIO (getEnv "Agda_datadir")    (\_ -> return datadir)
getLibexecDir = catchIO (getEnv "Agda_libexecdir") (\_ -> return libexecdir)
getSysconfDir = catchIO (getEnv "Agda_sysconfdir") (\_ -> return sysconfdir)




joinFileName :: String -> String -> FilePath
joinFileName ""  fname = fname
joinFileName "." fname = fname
joinFileName dir ""    = dir
joinFileName dir fname
  | isPathSeparator (List.last dir) = dir ++ fname
  | otherwise                       = dir ++ pathSeparator : fname

pathSeparator :: Char
pathSeparator = '/'

isPathSeparator :: Char -> Bool
isPathSeparator c = c == '/'
