#ifndef ADRICONF_EGLDISPLAYFACTORY_H
#define ADRICONF_EGLDISPLAYFACTORY_H

#include "EGLDisplayFactoryInterface.h"
#include "../Translation/TranslatorInterface.h"

#include <functional>

#include <EGL/egl.h>

class EGLDisplayFactory : public EGLDisplayFactoryInterface {
private:
    std::function<EGLDisplay(EGLenum, void *, const EGLint *)> getPlatformDisplay;
    TranslatorInterface *translator;

public:
    explicit EGLDisplayFactory(TranslatorInterface *translator);

    virtual ~EGLDisplayFactory() = default;

    std::shared_ptr<EGLDisplayInterface> createDisplayFromGBM(const GBMDevice &device) override;
    std::shared_ptr<EGLDisplayInterface> createDefaultDisplay() override;
};


#endif //ADRICONF_EGLDISPLAYFACTORY_H
