.TH MPOST 1 "31 December 2018" "Web2C @VERSION@"
.\"=====================================================================
.de URL
\\$2 \(laURL: \\$1 \(ra\\$3
..
.if \n[.g] .mso www.tmac
.if n .ds MP MetaPost
.if t .ds MP MetaPost
.if n .ds MF Metafont
.if t .ds MF Metafont
.if t .ds TX \fRT\\h'-0.10m'\\v'0.17v'E\\v'-0.17v'\\h'-0.06m'X\fP
.if n .ds TX TeX
.ie t .ds OX \fIT\h'-0.17m'\v'+0.21m'E\v'-0.21m'\h'-0.04m'X\fP
.el .ds OX TeX
.\" BX definition must follow TX so BX can use TX
.if t .ds BX \fRB\s-2IB\s0\fP\*(TX
.if n .ds BX BibTeX
.\" LX definition must follow TX so LX can use TX
.if t .ds LX \fRL\\h'-0.36m'\\v'-0.15v'\s-2A\s0\\h'-0.15m'\\v'0.15v'\fP\*(TX
.if n .ds LX LaTeX
.\"=====================================================================
.SH NAME
mpost, pmpost, upmpost \- MetaPost, a system for creating graphics
r-mpost, r-pmpost, r-upmpost \- restricted MetaPost
.SH SYNOPSIS
.B mpost
.RI [ options ]
.RI [ commands ]
.PP
.B mpost 
.B --dvitomp
.IR dvifile [\fB.dvi\fP]
.RI [ mpxfile [\fB.mpx\fP]]

.\"=====================================================================
.SH DESCRIPTION
\*(MP interprets the \*(MP language and produces PostScript (EPS)
or Scalable Vector Graphics (SVG) pictures.  The \*(MP language is similar 
to Knuth's \*(MF with additional features for including
.BR tex (1)
or
.BR troff (1)
commands and accessing features of PostScript not found in \*(MF. 
.PP
\*(MP is normally used with a set of basic macros, and it 
will use its executable name as the name of the preload 
file to use.   For example, when called as
.B mpost
the
.I mpost.mp
file is used, which simply reads
.IR plain.mp .
When the
.B --ini
option is given, preloading does not happen.  
.PP
The
.I commands
given on the command line to the \*(MP program are passed to it as the
first input line.  (But it is often easier to type extended arguments
as the first input line, since UNIX shells tend to gobble up or
misinterpret \*(MP's favorite symbols, like semicolons, unless you
quote them.) The normal usage is to say
.I mpost figs
to process the file
.IR figs.mp .
The basename of
.I figs
becomes the ``jobname'',
and is used in forming output file names.  If no file is named, the
jobname becomes
.IR mpout .
The default extension,
.IR .mp ,
can be overridden by specifying an extension explicitly.
.PP
When the
.B --dvitomp
option is given, \*(MP acts as DVI-to-MPX converter only.
See dvitomp (1) for details.
.PP
The
.B pmpost 
program is a variant with Japanese support, and
.B upmpost
has Unicode-enabled Japanese support, analogous to ptex and uptex.
.PP
All three variants are also installed with an `r-' prefix, that is,
.BR r-mpost ,
.BR r-pmpost ,
.BR r-upmpost ,
which implicitly specify the
.B --restricted
option to make MetaPost safe to run on unknown input; the tex, makempx,
and editor commands are disabled.
.PP
This manual page is a mere skeleton.  For a list of all command line
options, run
.BR --help .
.PP
The main documentation for this version of \*(MP can be found in the
User Manual that should have been installed along with the program and
is also available from https://tug.org/metapost.
.PP
The \*(MP language is similar to \*(MF, but the manual
assumes no knowledge of \*(MF.  \*(MP does not have bitmap
output commands or \*(MF's online display mechanism.
.\"=====================================================================
.SH FILES
.TP
.I plain.mp
The standard preload file.
.TP
.I mfplain.mp
The \*(MF-compatible preload file. 
.TP
.I $TEXMFMAIN/metapost/base/*.mp
The standard \*(MP macros included in the original distribution.
.TP
.I $TEXMFMAIN/metapost/support/*
Various tables for handling included
.I tex
and
.IR troff .
.TP
.I $TEXMFMAIN/metapost/support/trfonts.map
Table of corresponding font names for
.I troff 
and PostScript.
.TP
.I psfonts.map
Table of corresponding font names for
.I tex
and PostScript.
.TP
.I $TEXMFMAIN/doc/metapost/*
The \*(MP manual and tutorial source, also including sample figures
.\"=====================================================================
.SH "SUGGESTED READING"
Donald E. Knuth,
.I "The \*(MF\^book"
(Volume C of
.IR "Computers & Typesetting" ).
.br
.I TUGboat
(the journal of the \*(TX Users Group).
.\"=====================================================================
.SH "SEE ALSO"
.BR dvitomp (1),
.BR epstopdf (1),
.BR mf (1),
.BR mptopdf (1),
.BR tex (1),
.br
.URL "https://tug.org/metapost/" "MetaPost home page" .
.\"=====================================================================
.SH AUTHORS
\*(MP was created by John D. Hobby, incorporating algorithms from 
the \*(MF program by Donald E. Knuth.
.PP
Ulrik Vieth adapted \*(MP to take advantage of the advanced path
searching features in more recent versions of Web2C and worked towards
fully integrating \*(MP into the canonical Unix \*(TX distribution.
.PP
The primary author of the current \*(MP was Taco Hoekwater, with
assistance from Hans Hagen and many others.  It is currently maintained
by Luigi Scarso.
.\"=====================================================================
.SH BUGS
The MetaPost home page is https://tug.org/metapost.
