## -*-Tcl-*- (install)
# ###################################################################
#  Alpha - new Tcl folder configuration
# 
#  FILE: "ftpMenu.tcl"
#                                    created: 20/7/96 {6:02:55 pm} 
#                                last update: 7/8/1999 {1:55:01 pm} 
#  
#  Description: 
# 
# ###################################################################
##

alpha::menu ftpMenu 0.1.2 global "141" {} {ftpMenu} {} uninstall {this-file} \
  help {file "FTP menu Help"}

hook::register savePostHook ftpPostHook

proc ftpMenu {} {}

proc ftpPostHook {name} {
    global fetched
    if {[info exists fetched($name)]} {
	set specs $fetched($name)
	# backwards compatibility
	if {[lindex $specs 4] == ""} {
	    lappend specs "ftp"
	    set fetched($name) $specs
	}
	message "Updating '[file tail $name]' on [car $specs]"
	if {[string length [lindex $specs 1]]} {
	    ftpStore $name [lindex $specs 0] "[cadr $specs]/[file tail $name]" [caddr $specs] [cadddr $specs]
	} else {
	    ftpStore $name [lindex $specs 0] "[file tail $name]" [caddr $specs] [cadddr $specs]
	}
    }
}

proc rebuildFtpMenu {} {
    global savedMounts recentMounts ftpMenu useCache
    
    Menu -n $ftpMenu -p ftpMenuProc {
	help
	"(-"
	"<S/ibrowse"
	"<S/i<IbrowseCurrent"
	"/nbrowseMounts"
	"(-"
	addMountPoint
	makePermanent
	removeMountPoint
	saveAsAt
	"(-"
	useCache
	flushCache
	"(-"
	"createFileset"
	"(-"
    }
    markMenuItem -m $ftpMenu "Use Cache" $useCache
    if {[info exists savedMounts]} {
	foreach m [lsort -ignore [array names savedMounts]] {
	    addMenuItem -m -l "b " $ftpMenu $m
	}
    }
    if {[info exists recentMounts]} {
	addMenuItem -m $ftpMenu "(-"
	foreach m [lsort -ignore [array names recentMounts]] {
	    addMenuItem -m -l "b " $ftpMenu $m
	}
    }
}

if {![info exists useCache]} {set useCache 1}

app::registerMultiple ftp [list Arch FTCh] [list 141 315] rebuildFtpMenu

proc mountPoints {} {
    global savedMounts recentMounts
    if {[info exists recentMounts]} {
	if {[info exists savedMounts]} {
	    set l [concat [array names recentMounts] [array names savedMounts]]
	} else {
	    set l [array names recentMounts]]
	}
    } else {
	set l [array names savedMounts]
    }
    return [lsort $l]
}



proc ftpMenuProc {menu item} {
    global modifiedVars modifiedArrVars savedMounts recentMounts PREFS fetched HOME ftpMenu useCache createFtpType
    switch -- $item {
	help				{
	    editMark [file join $HOME Help "Alpha Manual"] "Ftp Browser" -r
	}
	browse				{
	    eval ftpBrowse [lrange [getLogin {Browse remote machine:} 0] 0 3]
	}
	browseCurrent		{ 
	    if {[info exists fetched([win::Current])]} {
		eval ftpBrowse $fetched([win::Current]) 
	    } else {
		beep; message "'[win::CurrentTail]' not from remote host."
	    }
	}
	browseMounts		{
	    set l [mountPoints]
	    set res [listpick -p "Mount point:" $l]
	    if {[info exists recentMounts($res)]} {
		eval ftpBrowse $recentMounts($res)
	    } else {
		eval ftpBrowse $savedMounts($res)
	    }
	}
	
	addMountPoint		{ addMountPoint }
	makePermanent		{ makeMountPermanent }
	createFileset		{ newFileset ftp }
	removeMountPoint	{
	    set pt [listpick -p "Remove which mount point?" [lsort -ignore [array names savedMounts]]]
	    unset savedMounts($pt)
	    removeArrDef savedMounts $pt
	    rebuildFtpMenu
	}
	saveAsAt			{
	    global fetched PREFS
	    set name [prompt "Name:" [win::CurrentTail]]
	    set point [listpick -p "At which mount point?" [mountPoints]]
	    if {[info exists recentMounts($point)]} {
		set specs $recentMounts($point)
	    } else {
		set specs $savedMounts($point)
	    }
	    # backwards compatibility
	    if {[lindex $specs 4] == ""} {
		lappend specs "ftp"
	    }
	    set name [file join $PREFS ftptmp $name]
	    set fetched($name) $specs
	    message "Saving '$name' on [car $specs]"
	    
	    if {![file exists $name]} {
		set fid [open $name w]
		close $fid
	    }
	    saveAs -f "$name"
	    
	    set num 0
	    set pathname [lindex $specs 1]
	    for {set i [expr [string length $pathname] - 1]} {$i >= 0} {incr i -1} {
		scan $pathname "%c" char
		incr num $char
	    }
	    
	    set nm [file join $PREFS ftptmp listing.$num]
	    catch {rm $nm}
	    
	    setWinInfo platform $createFtpType
	    setWinInfo dirty 1
	    save
	}
	
	setDefaults			{ 
	    global ftpDefaults modifiedVars
	    set ftpDefaults [lrange [getLogin "Enter defaults that you wish saved:" 0] 0 3]
	    lappend modifiedVars ftpDefaults
	}
	flushCache		{ rm [file join $PREFS ftptmp *]; catch {unset recentMounts}; rebuildFtpMenu }
	useCache	{ 
	    set useCache [expr 1 - $useCache]
	    markMenuItem -m $ftpMenu "Use Cache" $useCache
	    lappend modifiedVars useCache
	}
	default {
	    if {[info exists recentMounts($item)]} {
		eval ftpBrowse $recentMounts($item)
	    } else {
		eval ftpBrowse $savedMounts($item)
	    }
	}
    }
}


proc ftpFilesetOpen {menu item} {
    global gfileSets PREFS fetched fileSetsExtra
    
    set ind [lsearch $gfileSets($menu) "$item"]
    if { $ind < 0 } { set ind [lsearch $gfileSets($menu) [file join * $item]] }

    if {$ind >= 0} {
	set f [lindex $gfileSets($menu) $ind]
	set lnm [file tail $f]
	regsub -all {:} $f {/} f
	set nm [file join $PREFS ftptmp $lnm]
	set specs $fileSetsExtra($menu)
	# backwards compatibility
	if {[lindex $specs 4] == ""} {
	    lappend specs "ftp"
	    set fileSetsExtra($menu) $specs
	}
	if {![file exists $nm]} {
	    ftpFetch $nm [car $specs] $f [caddr $specs] [cadddr $specs]
	}
	edit -w $nm
	set fetched($nm) $specs
    }
}


proc ftpCreateFileset {} {
    global gfileSets gfileSetsType PREFS fileSetsExtra
    
    set specs [getLogin]
    set name [car $specs]
    set host [cadr $specs]
    set path [caddr $specs]
    set user [cadddr $specs]
    set password [caddddr $specs]
    set pattern "^[prompt {Name pattern?} {.*.[ch]}]$"
    set path [string trimright $path {/}]
    
    set fileSetsExtra($name) [list $host $path $user $password "ftp"]
    
    if { ![file exists [file join $PREFS ftptmp]] } {
	file mkdir [file join $PREFS ftptmp]
    }
    set nm [file join $PREFS ftptmp listing.$path]
    ftpList $nm $host $path $user $password
    set files {}
    foreach f [processListing $nm] {
	if {![string match {*/} $f] && [regexp -- $pattern $f]} {
	    lappend files "$path/$f"
	}
    }
    regsub -all {/} $files {:} files
    
    global gfileSets gfileSetsType
    set gfileSets($name) [lsort -command sortByTail $files]
    set gfileSetsType($name) ftp
    if {[askyesno "Save project fileset?"] == "yes"} {
	addArrDef gfileSetsType $name ftp
	addArrDef gfileSets $name  $gfileSets($name)
	addArrDef fileSetsExtra $name $fileSetsExtra($name)
    }
    return $name
}


proc processListing {path} {
    set fd [open $path "r"]
    set lines [split [read $fd] "\n"]
    close $fd
    set files {}
    if {[llength $lines]} {
	if {[string length [lindex $lines 0]] <= 10} {
	    set lines [cdr [lreplace $lines end end]]
	} else {
	    set lines [lreplace $lines end end]
	}
	foreach f $lines {
	    set nm {}
	    regexp {[A-Z][a-z]+ [0-9, ]+ [0-9,:]+ (.*)$} $f dummy nm
	    if {[string length $nm]} {
		if {[string match "d*" $f]} {
		    if {![string match "." $nm] && ![string match ".." $nm]} {
			lappend files "$nm/"
		    }
		} else {
		    lappend files $nm
		}
	    }
	}
    } else {
	error "empty list"
    }
    return $files
}

proc getLogin {{prompt {All but 'password' are required:}} {nm 1}} {
    global ftpDefaults
    if {[info exists ftpDefaults]} {
	set defs $ftpDefaults
    } else {
	set defs {"" "" "" ""}
    }
    set left 10
    set right 100
    set top 10
    set bottom 30
    set eleft [expr $left + 100]
    set eright 370
    set incr 30
    
    set height 198
    
    if {$nm} {incr height $incr}
    set l "dialog -w 400 -h $height -t [list $prompt] $left $top 400 $bottom"
    
    if {$nm} {
	incr top $incr
	incr bottom $incr
	lappend l -t {Name:} $left $top $right $bottom
	lappend l -e {} $eleft $top $eright $bottom
    }
    
    incr top $incr
    incr bottom $incr
    lappend l -t {Host:} $left $top $right $bottom
    lappend l -e [car $defs] $eleft $top $eright $bottom
    
    incr top $incr
    incr bottom $incr
    lappend l -t {Path:} $left $top $right $bottom
    lappend l -e [cadr $defs] $eleft $top $eright $bottom
    
    incr top $incr
    incr bottom $incr
    lappend l -t {UserID:} $left $top $right $bottom
    lappend l -e [caddr $defs] $eleft $top $eright $bottom
    
    incr top $incr
    incr bottom $incr
    lappend l -t {Password:} $left $top $right $bottom
    lappend l -e [cadddr $defs] $eleft [expr $top + 6] $eright [expr $bottom - 12]
    
    incr top [expr $incr + 10]
    incr bottom [expr $incr + 10]
    lappend l -b "OK" $left $top $right [expr $top + 20]
    lappend l -b "Cancel" [expr $left + 200] $top [expr $right + 200] [expr $top + 20]
    
    set res [eval "$l"]
    if {[lindex $res end]} {error "Cancel"}
    return $res
}


proc addMountPoint {} {
    global savedMounts modifiedArrVars
    
    set res [getLogin]
    if {[lindex $res 5]} {
	set savedMounts([car $res]) [concat [lrange $res 1 4] "ftp"]
	lappend modifiedArrVars savedMounts
	rebuildFtpMenu
    }
}


proc makeMountPermanent {} {
    global recentMounts savedMounts modifiedArrVars
    if {![info exists recentMounts]} {
	alertnote "You have no temporary mounts."
	return
    }
    set res [listpick -p "Make which temporary mount point permanent?" [lsort [array names recentMounts]]]
    set name [prompt "Name?" $res]
    set savedMounts($name) $recentMounts($res)
    unset recentMounts($res)
    lappend modifiedArrVars savedMounts
    rebuildFtpMenu
}


proc ftpPromptBrowse {} {
    eval ftpBrowse [lrange [getLogin {Browse remote machine:} 0] 0 3]
}

proc ftpBrowse {host dir user password {type "ftp"} {fname {}}} {
    global PREFS fetched lastFtpDir recentMounts savedMounts useCache
    
    watchCursor
    if {![string length $password]} {
	set password [dialog::password "Password for ${host}:"]
    }
    
    if {![file exists [file join $PREFS ftptmp]]} {
	file mkdir [file join $PREFS ftptmp]
    }
    if {$dir == {-}} {
	if {![info exists lastFtpDir] || ![string length $lastFtpDir]} {set lastFtpDir ""}
	set dir [prompt "'$host' dir:" $lastFtpDir]
    }
    set dir [string trimright $dir {/}]
    set lastFtpDir $dir
    
    set num 0
    for {set i [expr [string length $dir] - 1]} {$i >= 0} {incr i -1} {
	scan [string index $dir $i] "%c" char
	incr num $char
    }
    
    set nm [file join $PREFS ftptmp listing.$num]
    
    if {!$useCache || ![file exists $nm]} {
	ftpList $nm $host $dir $user $password
    }
    if {[catch {processListing $nm} listing]} {
	alertnote "Error fetching directory '$dir'"
	error "Error fetching directory '$dir'"
    }
    set files [concat {..} $listing]
    if {$fname != ""} {
	set file [listpick -L $fname -p "$dir/" $files]
    } else {
	set file [listpick -p "$dir/" $files]
    }
    
    if {$file == {..}} {
	if {[regexp {(.+)/[^/]+} $dir dummy sub]} {
	    return [ftpBrowse $host $sub $user $password]
	} else {
	    return [ftpBrowse $host "" $user $password]
	}
    }
    
    if {[string match {*/} $file]} {
	if {[string length $dir]} {
	    return [ftpBrowse $host [string trimright "$dir/$file" {/}] $user $password]
	} else {
	    return [ftpBrowse $host [string trimright "$file" {/}] $user $password]
	}
    }
    
    set entry [list $host $dir $user $password $type]
    set new 1
    foreach name [array names savedMounts] {
	if {([car $savedMounts($name)] == [car $entry]) && ([cadr $savedMounts($name)] == [cadr $entry])} {
	    set new 0
	    break;
	}
    }
    if {$new} {
	set recentMounts($dir) $entry
	rebuildFtpMenu
    }
    
    set nm [file join $PREFS ftptmp $file]
    if {!$useCache || ![file exists $nm]} {
	if {[string length $dir]} {
	    ftpFetch $nm $host "$dir/$file" $user $password
	} else {
	    ftpFetch $nm $host "$file" $user $password
	}
    }
    edit -w $nm
    set fetched($nm) [list $host $dir $user $password "ftp"]
}


