# installation menu for editing xtem_TeXMenu's setting files
#
# Copyright (C) 2004  G. Lamprecht, W. Lotz, R. Weibezahn; IWD, Bremen University
#
#########################################################################################################################

source xic.tcl

XiInit

XiGetArgsAndOpenLog "Installation parameters for xtem_TeXMenu's setting-files edit-menu:"

if ![info exists xtem_path] {set xtem_path "$INSTPATH/xtem-$XTEMVERSION"}

XiGet_vv_XV

set stt ""; XiPlatform nolog

if	{[info commands set]==""}	{set errt "is not a Tcl/Tk-Shell"} \
elseif	{[info commands pack]==""}	{set errt "is a Tcl-shell but not a Tcl/Tk-Shell"} \
else					{set errt ""}
if {$errt!=""} {XiExit "Variable WISHCALL in file xteminstall\n$errt\n"}

set mousebutts 3; set bindkeysenab 0

set Wvsts  ".xteminstall_vsts";  # main menu
set Wenews ".xteminstall_enews"; # edit local news files
set Wevst  ".xteminstall_evst";  # edit vst file: all buttons
set Wevstb ".xteminstall_evstb"; # edit vst file (all the file in one text widget)
set Wevstl ".xteminstall_evstl"; # edit vst file (one entry, splitted into parameters) 
set Wevsta ".xteminstall_evsta"; # append a parameter to a vst file (if variable # of parameters)
set Wevstd ".xteminstall_evstd"; # delete a parameter from a vst file (if variable # of parameters)

set XiVstPBDLw ""

#----- common procs      ----------------------------------------------------------------------

proc XiEnabModVst {args} {
 set enabModVst 1
 foreach f $args {
   if {(![file exists $f])||(![file isdir $f])} {set enabModVst 0}
   if {([file exists $f])&&([file type $f]=="link")&&([file tail [file readlink $f]]=="$f.LRW")} {set enabModVst 0}
   TestPut 4 "<$args><$f><$enabModVst>"
 }
   return $enabModVst
}

#----- installation proc's -------------------------------------------------------------------

#----- setting file select menu proc's -------------------------------------------------------

proc XiFilesLangSuffix {suffix} {
 global XV Wvsts INSTPATH NEW email
 TestPut 2 ""

 set files ""
 foreach language [Languages] {
   if {![file exists $INSTPATH/$NEW/locals_$language]} {
     XiProtokoll "$INSTPATH/$NEW/locals_$language : directory not found;\nclick at \"install xtem\" first."
     XiProtokoll "If this error then repeats: $email\n"
     mybell 4
     return "$XV(anever)"
   }
   set list [glob -- $INSTPATH/$NEW/locals_$language/*$suffix]
   foreach name $list {
    set name [string range $name [expr [string last "/" $name]+1] [expr [string length $name]-[string length $suffix]-1]]
     set isin 0; foreach f $files {if {$name=="$f"} {set isin 1}}; if !$isin {set files "$files $name"}
   }
 }
 return "[lsort $files]"
}

proc XiCreateFileEditButtons {W Files Suffix Text} {
 TestPut 2 ""
 frame $W.dummy -height 7; pack $W.dummy
 label $W.label -text "$Text:"; pack $W.label -pady 3 -anchor nw
 set line 1
 while {$Files!=""} {
   frame $W.frame$line; pack $W.frame$line -anchor nw
   for {set n 1} {$n<=4} {incr n} {
     set fn [lindex $Files 0]; set Files [lrange $Files 1 end]
     button $W.frame$line.$fn -width 15 -text "$fn$Suffix" -anchor w -command "XiSettEditNV $fn $Suffix"
     pack $W.frame$line.$fn -side left
     if {$Files==""} {break}
   }
   incr line
 } 
}

proc XiSettEditNV {f s} {TestPut 2 ""; if {$s==".news"} {XiSettEditNews $f} else {XiSettEditVst $f}}

proc XiActivateFileEditButtons {W Files Suffix ActivateCase} {
 global XV INSTPATH NEW XiCurLanguage
 TestPut 2 "$ActivateCase"
 set line 1
 while {$Files!=""} {
   for {set n 1} {$n<=4} {incr n} {
     set fn [lindex $Files 0]; set Files [lrange $Files 1 end]
     if     {$ActivateCase==0} {$W.frame$line.$fn configure -state disabled} \
     elseif [file exists $INSTPATH/$NEW/locals_$XiCurLanguage/$fn$Suffix] {$W.frame$line.$fn configure -state normal} \
     else                      {$W.frame$line.$fn configure -state disabled}
     if {$Files==""} {break}
   }
   incr line
 } 
}

proc XiActivateLangSelButtons {W ActivateCase} {
 TestPut 2 "$ActivateCase"
 set line 1
 foreach l [Languages] {
   if {$ActivateCase==0} {$W.a.lang.$l configure -state disabled} else {$W.a.lang.$l configure -state normal}
 } 
}

proc XiLangButton {language} {
 global Wvsts XV INSTPATH NEW XiNewsfiles XiVstfiles
 TestPut 2 ""
 if {[file type "$INSTPATH/$NEW/locals_$language"]=="link"} \
      {set t1 "Directory: is link -->"; set t2 "[file readlink $INSTPATH/$NEW/locals_$language]"} \
 else {set t1 "Directory:";             set t2 "$INSTPATH/$NEW/locals_$language"}
 ConfigText $Wvsts.a.dirs.text "$t1"; ConfigText $Wvsts.a.dirs.disp "$t2"
 XiActivateFileEditButtons $Wvsts.b "$XiNewsfiles" .news 1
 XiActivateFileEditButtons $Wvsts.c "$XiVstfiles"  .vst  1
}

#----- setting file select menu        -------------------------------------------------------

proc XiSettings {} {

 global XV Wvsts INSTPATH DEFLANGUAGE NEW NEWV XiCurLanguage XiNewsfiles XiVstfiles
 TestPut 3 "********************** start main Window ($Wvsts)"

 XiProtokoll "$XV(AAsteriks)\nModification of the setting files ...\n"

 set XiNewsfiles [XiFilesLangSuffix .news];  set XiVstfiles [XiFilesLangSuffix .vst]
 if {($XiNewsfiles=="$XV(anever)")||($XiVstfiles=="$XV(anever)")} {return}


 wm iconname . "xteminstall"; wm title . "xteminstall (xtem version: $NEWV): modification of Settings [pwd]"
 wm minsize . 300 50;

 frame $Wvsts; pack $Wvsts

 foreach frame "a b c" {frame $Wvsts.$frame -borderwidth 1 -relief raised; pack $Wvsts.$frame -fill x -ipady 3}

 # frame a: end button, languagage selecton and directory display
 button $Wvsts.a.ende -text "end" -command {
   TestPut 4 "Ende:<$whichcheck><[info exists xtem_path]>"
   if {($whichcheck=="yes")&&[info exists xtem_path]} {xiVstCallsWhich}
   destroy .
 }
 label $Wvsts.a.dum1 -width 2; pack $Wvsts.a.ende $Wvsts.a.dum1 -side left
 set XiCurLanguage $DEFLANGUAGE
 frame $Wvsts.a.lang -height 300; pack $Wvsts.a.lang -side left
 label $Wvsts.a.lang.label -text "Language selection:"; pack $Wvsts.a.lang.label
 foreach l [Languages] {
   radiobutton $Wvsts.a.lang.$l -variable XiCurLanguage -value $l -width 14 -text $l -anchor w -command "XiLangButton $l"
   pack $Wvsts.a.lang.$l -anchor w
 }
 label $Wvsts.a.dum2 -width 2;    pack $Wvsts.a.dum2 -side left
 frame $Wvsts.a.dirs -height 300; pack $Wvsts.a.dirs -side left
 if {[file type "$INSTPATH/$NEW/locals_$XiCurLanguage"]=="link"} \
      {set t1 "Directory: is link -->"; set t2 "[file readlink $INSTPATH/$NEW/locals_$XiCurLanguage]"} \
 else {set t1 "Directory:";             set t2 "$INSTPATH/$NEW/locals_$XiCurLanguage"}
 label $Wvsts.a.dirs.text -text "$t1"; pack $Wvsts.a.dirs.text -anchor w
 label $Wvsts.a.dirs.disp -text "$t2"; pack $Wvsts.a.dirs.disp -anchor w

 # frame b: news file buttons
 XiCreateFileEditButtons $Wvsts.b $XiNewsfiles .news "News Files"
 XiActivateFileEditButtons $Wvsts.b $XiNewsfiles .news 1

 # frame c: setting file buttons
 XiCreateFileEditButtons $Wvsts.c $XiVstfiles .vst "Setting Files"
 XiActivateFileEditButtons $Wvsts.c $XiVstfiles .vst 1
}

#---------------------------------------------------------------------------------------------

#----- setting file edit menus proc's --------------------------------------------------------

proc XiSaveNewsfile {W FileSuffix} {
 global XV INSTPATH NEW XiCurLanguage
 TestPut 2 ""
 set file $INSTPATH/$NEW/locals_$XiCurLanguage/$FileSuffix
 set f [open $file w]
 set lc [$W.b.t get "end -1c" end]
 if {($lc=="\n")} {puts -nonewline $f [$W.b.t get 1.0 "end-1c"]} \
 else             {puts -nonewline $f [$W.b.t get 1.0 end]}
 flush $f;  close $f
 XiProtokoll "\tsave file \"$file\""
}

proc XiSaveFile {W File Suffix} {
 TestPut 2 ""
 if {$Suffix==".news"} {XiSaveNewsfile $W $File$Suffix} {XiSaveVstfile $File$Suffix 1}
}

proc XiDestroyESBut {W File Suffix logtext} {
 global Wvsts XiNewsfiles XiVstfiles
 TestPut 2 ""
 if {$File!=""} {if {$Suffix==".news"} {XiSaveNewsfile $W $File$Suffix} else {XiSaveVstfile $File$Suffix 1}}
 XiProtokoll "$logtext"
 destroy $W; raise $Wvsts
 XiActivateFileEditButtons $Wvsts.b $XiNewsfiles .news 1; XiActivateFileEditButtons $Wvsts.c $XiVstfiles .vst 1
 XiActivateLangSelButtons $Wvsts 1; $Wvsts.a.ende configure -state normal; update
}

proc XiCreateESButtons {W File Suffix} {
 global XV
 TestPut 2 "<$W><$File><$Suffix>"
 if [info exists XV(XSettVF$File$Suffix)] {TestPut 2 "$XV(XSettVF$File$Suffix)"}
 button $W.a.ends -text "end with file save" -command "XiDestroyESBut $W $File $Suffix \"end with file save\""
 pack $W.a.ends -side left
 set XV(aendq) ""
 button $W.a.save -text "save file" -command "XiSaveFile $W $File $Suffix"; pack $W.a.save -side left
 button $W.a.endq -text "exit without file save" -command "XiDestroyESBut $W \"\" $Suffix exit"
 pack $W.a.endq -side left
}

proc XiCreateLSBox {w text s wi he bw list com} {
# creates frame w.f and title for selection, creates selection box + scrollbar, width wi, height he;  fills with list
 global XiVstLastClick
 TestPut 2 ""

 frame $w.f; pack $w.f -anchor sw -padx 2 -pady 8 -fill x -expand yes
 if {$text!=""} {label $w.f.l -text $text; pack $w.f.l -side $s -anchor w}
 frame $w.f.f -relief raised -borderwidth $bw; pack $w.f.f -anchor sw -fill x -expand yes
 scrollbar $w.f.f.sb -command "$w.f.f.li yview"
 listbox $w.f.f.li -yscrollcommand "$w.f.f.sb set" -width $wi -height $he
 pack $w.f.f.sb -side right -fill y
 pack $w.f.f.li -side right -fill y -fill x -expand yes
 if {$list!=""} then {foreach e $list {$w.f.f.li insert end $e}}
 bind $w.f.f.li <Leave> Bend;  bind $w.f.f.li <Double-Button-1> Bend;  bind $w.f.f.li <Triple-Button-1> Bend
 bind $w.f.f.li <Button-1> "set XiVstLastClick \[Selektion %W %y\]; $com; Bend"
}

proc XiCopyOriToInactive {File} {
 global Wevst XiVstInactive
 TestPut 4 "<$File><[llength $XiVstInactive]>"
 set oldlength [llength $XiVstInactive]; XiVst2Lists $File.vst {} add; XiSettVHFill; $Wevst.c.f.f.li yview $oldlength
}

proc XiSettVHCritLine {} {# if item XiVstSelectedNr is criterion line in XiVstActive: return 1 (else 0)
 global XV XiSelectedFromActive XiVstSelectedNr XiSelectedVstFile
 TestPut 2 ""
 if {($XiSelectedFromActive==1)&&($XiVstSelectedNr<[lindex $XV(XSettVF$XiSelectedVstFile) 1])} {return 1} {return 0}
}

proc XiSettVHDel {deleteitemnumber} {# delete deleteitemnumber from XiVstActive/XiVstInactive acc.to XiSelectedFromActive
 global XV Wevst XiSelectedFromActive XiVstActive XiVstInactive
 TestPut 2 ""
 if {$deleteitemnumber==""} {return}
 if {$XiSelectedFromActive==1} {
   if {[string length [lindex $XiVstActive $deleteitemnumber]]==0} \
	{ConfigText $Wevst.e.t "you can't delete from an empty list!"; mybell 4; return}
   set XiVstActive   [lreplace "$XiVstActive"   $deleteitemnumber $deleteitemnumber]
 } else {
   if {[lindex $XiVstInactive $deleteitemnumber]==""} \
	{ConfigText $Wevst.e.t "you can't delete from an empty list!"; mybell 4; return}
   set XiVstInactive [lreplace "$XiVstInactive" $deleteitemnumber $deleteitemnumber]
 }
}

proc XiSettVHFill {} {# fill lists XiVstActive and XiVstInactive into their windows
 global Wevst XiVstActive XiVstInactive
 TestPut 2 ""
 $Wevst.b.f.f.li delete 0 end; foreach e $XiVstActive   {$Wevst.b.f.f.li insert end $e}
 $Wevst.c.f.f.li delete 0 end; foreach e $XiVstInactive {$Wevst.c.f.f.li insert end $e}
}

proc XiSettVHIns {liste nr item} {# insert item as element nr in liste (Active/Inactive)
 global XV Wevst XiVstActive XiVstInactive XiSelectedFromActive
 TestPut 2 ""
 if {$liste==""} {if {$XiSelectedFromActive==1} {set liste "Active"} else {set liste "Inactive"}}
 if     {$liste=="Active" }  {set XiVstActive   [linsert "$XiVstActive"   $nr "$item"]} \
 elseif {$liste=="Inactive"} {set XiVstInactive [linsert "$XiVstInactive" $nr "$item"]} \
 else                        {puts stdout "error in XiSettVHIns"; mybell 4}
}

proc XiSettVHSelClear {} {# clears seclection in both lists XiVstActive and XiVstInactive
 global Wevst XiSelectedFromActive XiVstSelectedNr XiVstLastClick
 TestPut 2 ""
 $Wevst.b.f.f.li selection clear 0 end; $Wevst.b.f.f.li selection clear 0 end
 set XiSelectedFromActive "";  set XiVstSelectedNr "";  set XiVstLastClick ""
}

proc XiSettVHParAddL {ltype liste} {# adds (appends) new parameter to each entry in liste
 global XV XiVstSep XiVstParAnz
 TestPut 2 ""
 set Liste ""
 foreach e $liste {
   set fl [split $e $XiVstSep];  set fll [llength $fl];  set e "[lindex $fl 0]"
   if {$XiVstParAnz<=$fll} {
     for {set n 1} {$n<$XiVstParAnz} {incr n} {set e "${e}${XiVstSep}[lindex $fl $n]"}
     set e "${e}${XiVstSep} "
     if {($ltype=="Active")&&[lindex $XV(XSettVFprinting.vst) 1]&&([string trim [lindex $fl 0]]=="")} {set e "${e}* "}
   }
   lappend Liste $e
 }
 return "$Liste"
}

proc XiSettVHParDelN {pardel liste} {# delete parameter pardel from each entry in liste
 global XV XiVstSep XiVstParAnz
 TestPut 2 ""
 set Liste ""
 foreach e $liste {
   set fl [split $e $XiVstSep];  set fll [llength $fl];  set e "[lindex $fl 0]"
   if {$pardel<$fll} {set fl [lreplace $fl [expr $pardel-1] $pardel [lindex $fl [expr $pardel-1]]]}
   for {set n 1} {$n<=$XiVstParAnz} {incr n} {if {$n<$fll} {set e "$e$XiVstSep[lindex $fl $n]"}}
   lappend Liste $e
 }
 return "$Liste"
}

proc XiSettVHParList {} {# sets and returns XiVstParAktEL: list of user definable parameters (e.g. in printing.vst)
 global XV XiVstSep XiVstParAnzMin XiVstParAktEL XiVstFL XiVstParAnz
 TestPut 2 ""
 set XiVstParAktEL "";  if {$XiVstParAnz<=$XiVstParAnzMin} {return ""}
 for {set i [expr $XiVstParAnzMin+1]} {$i<=$XiVstParAnz} {incr i} \
	 {lappend XiVstParAktEL "parameter $i :     [lindex [split $XiVstFL $XiVstSep] $i]"}
 return "$XiVstParAktEL"
}

proc XiSettVHSelItem {liste nr} {# marks item $nr in XiVstActive/Inactive ($liste), update XiVstLastClick
 global Wevst XiSelectedFromActive XiVstLastClick XiVstActive XiVstInactive XiVstSelectedNr
 TestPut 2 ""
 if {$liste==""} {if {$XiSelectedFromActive==1} {set liste "Active"} else {set liste "Inactive"}} 
 if {$liste=="Active"} {set w $Wevst.b.f.f.li; set lst $XiVstActive;   set XiSelectedFromActive 1}  \
 else                  {set w $Wevst.c.f.f.li; set lst $XiVstInactive; set XiSelectedFromActive 0}
 $w yview $nr
 $w selection set $nr
 set XiVstLastClick [lindex $lst $nr]; set XiVstSelectedNr $nr
}

proc XiSettVHSelLineActive   {} {
 global Wevstl XiSelectedFromActive
 TestPut 2 ""
 if [winfo exists $Wevstl] return; set XiSelectedFromActive 1; XiSettVHSelLine
}

proc XiSettVHSelLineInactive {} {
 global Wevstl XiSelectedFromActive
 TestPut 2 ""
 if [winfo exists $Wevstl] return; set XiSelectedFromActive 0; XiSettVHSelLine
}

proc XiSettVHSelLine {} {
 global XiVstLastClick XiSelectedFromActive XiVstActive XiVstInactive XiVstSelectedNr email
 TestPut 2 ""
 if {[string length "$XiVstLastClick"]==0} {return}
 if {$XiSelectedFromActive} {set liste $XiVstActive} else {set liste $XiVstInactive}
 set nr 0; foreach e $liste {if {([string first "$XiVstLastClick" [lindex $liste $nr]]>=0)} {break}; incr nr}
 set XiVstSelectedNr $nr
}

proc XiSettVHSelNext {incr CallIfLast args} {
 global XiSelectedFromActive XiVstSelectedNr XiVstActive XiVstInactive XiShift
 if {$XiSelectedFromActive}	 {set from Active;	set l [llength $XiVstActive]} \
 else				 {set from Inactive;	set l [llength $XiVstInactive]}
 set neueNr [expr $XiVstSelectedNr+$incr]
 TestPut 4 "<$CallIfLast><$args> <$from>  <$XiVstSelectedNr><$incr><$neueNr>  <$l>"
 if {($XiShift)&&($neueNr<$l)}  {XiSettVHSelItem $from $neueNr} else {eval $CallIfLast $args}
}


proc XiSettVBAppdNewE	{b} {# create (append) a new active entry and edit this entry
 global XV Wevst XiSelectedFromActive XiVstDefLine XiVstActive XiVstLastClick
 TestPut 2 ""
 set p [llength $XiVstActive];  XiSettVHIns Active $p "$XiVstDefLine"
 XiSettVHFill;  XiSettVHSelItem Active $p;  XiSettVHEditEntry $p
}

proc XiSettVBCopyAct	{b} {# copy item XiVstSelectedNr from list XiVstInactive to list XiVstActive
 global XV Wevst XiSelectedFromActive XiVstActive XiVstLastClick
 TestPut 2 ""
 if {$XiSelectedFromActive==""} {ConfigText $Wevst.e.t "$XV(anoentry)";   mybell 4; return}
 if {$XiSelectedFromActive==1}  {ConfigText $Wevst.e.t "$XV(anoinact)";   mybell 4; return}
 set p [llength $XiVstActive];  XiSettVHIns Active $p "$XiVstLastClick"
 XiSettVHFill;  XiSettVHSelNext 1 XiSettVHSelItem Active $p
 ConfigText $Wevst.e.t "[lindex $XV(XSettVBut$b) 3]"
}

proc XiSettVBCopyInact	{b} {# copy item XiVstSelectedNr from list XiVstActive to list XiVstInactive
 global XV Wevst XiSelectedFromActive XiVstInactive XiVstLastClick
 TestPut 2 ""
 if {$XiSelectedFromActive==""} {ConfigText $Wevst.e.t "$XV(anoentry)";  mybell 4; return}
 if {$XiSelectedFromActive==0}  {ConfigText $Wevst.e.t "$XV(anoact)";    mybell 4; return}
 if [XiSettVHCritLine]          {ConfigText $Wevst.e.t "$XV(anocopy)";   mybell 4; return}
 set p [llength $XiVstInactive];  XiSettVHIns Inactive $p "$XiVstLastClick"
 XiSettVHFill;  XiSettVHSelNext 1 XiSettVHSelItem Inactive $p
 ConfigText $Wevst.e.t "[lindex $XV(XSettVBut$b) 3]"
}

proc XiSettVBCpEdEntry	{b} {# copy the selected active entry XiVstLastClick/XiSelectedFromActive and edit the copy
 global XV Wevst XiSelectedFromActive XiVstSelectedNr XiVstLastClick XiVstActive
 TestPut 2 ""
 if {$XiSelectedFromActive==""} {ConfigText $Wevst.e.t "$XV(anoentry)";  mybell 4; return}
 if {$XiSelectedFromActive==0}  {ConfigText $Wevst.e.t "$XV(anoact)";    mybell 4; return}
 if [XiSettVHCritLine]          {ConfigText $Wevst.e.t "$XV(anocopy)";   mybell 4; return}
 set p [expr $XiVstSelectedNr+1];  XiSettVHIns "" $p "$XiVstLastClick";  XiSettVHFill;  XiSettVHSelItem Active $p
 XiSettVHEditEntry $p
}

proc XiSettVBDeltEntry	{b} {# delete item XiVstSelectedNr from list XiVstActive/Inactive acc.to XiSelectedFromActive
 global XV Wevst XiSelectedFromActive XiVstLastClick XiVstActive XiVstInactive XiVstSelectedNr
 TestPut 2 "<$XiSelectedFromActive><[XiSettVHCritLine]><$XiVstSelectedNr>"
 if {$XiSelectedFromActive==""} {ConfigText $Wevst.e.t "$XV(anoentry)";  mybell 4; return}
 if [XiSettVHCritLine]          {ConfigText $Wevst.e.t "$XV(anodelete)"; mybell 4; return}
 if {$XiVstSelectedNr==""} {return}
 XiSettVHDel $XiVstSelectedNr;  XiSettVHFill;  XiSettVHSelNext 0 XiSettVHSelClear
 ConfigText $Wevst.e.t "[lindex $XV(XSettVBut$b) 3]"
}

proc XiSettVBEditEntry	{b} {# edit the selected active entry XiVstLastClick (XiVstSelectedNr/...)
 global XV Wevst XiSelectedFromActive XiVstSelectedNr
 TestPut 2 ""
 if {$XiSelectedFromActive==""} {ConfigText $Wevst.e.t "$XV(anoentry)";  mybell 4; return}
 if {$XiSelectedFromActive==0}  {ConfigText $Wevst.e.t "$XV(anoact)";    mybell 4; return}
 set p $XiVstSelectedNr;  XiSettVHSelItem Active $p;  XiSettVHEditEntry $p
 ConfigText $Wevst.e.t "[lindex $XV(XSettVBut$b) 3]"
}

proc XiSettVBMakeActiv	{b} {# move item XiVstSelectedNr from list XiVstInactive to list XiVstActive
 global XV Wevst XiSelectedFromActive XiVstActive XiVstSelectedNr XiVstLastClick
 TestPut 2 ""
 if {$XiSelectedFromActive==""} {ConfigText $Wevst.e.t "$XV(anoentry)";  mybell 4; return}
 if {$XiSelectedFromActive==1}  {ConfigText $Wevst.e.t "$XV(anoinact)";  mybell 4; return}
 set p [llength $XiVstActive];  XiSettVHIns Active $p "$XiVstLastClick";  XiSettVHDel $XiVstSelectedNr
 XiSettVHFill;  XiSettVHSelNext 0 XiSettVHSelItem Active $p
 ConfigText  $Wevst.e.t "[lindex $XV(XSettVBut$b) 3]"
}

proc XiSettVBMakeInact	{b} {# move item XiVstSelectedNr from list XiVstActive to list XiVstInactive
 global XV Wevst XiSelectedFromActive XiVstInactive XiVstSelectedNr XiSelectedVstFile XiVstLastClick
 TestPut 2 ""
 if {$XiSelectedFromActive==""} {ConfigText $Wevst.e.t "$XV(anoentry)";  mybell 4; return}
 if {$XiSelectedFromActive==0}  {ConfigText $Wevst.e.t "$XV(anoact)";    mybell 4; return}
 if [XiSettVHCritLine]          {ConfigText $Wevst.e.t "$XV(anomove)";   mybell 4; return}
 set p [llength $XiVstInactive];  XiSettVHIns Inactive $p "$XiVstLastClick"; XiSettVHDel $XiVstSelectedNr
 XiSettVHFill;  XiSettVHSelNext 0 XiSettVHSelItem Inactive $p
 ConfigText $Wevst.e.t "[lindex $XV(XSettVBut$b) 3]"
}

proc XiSettVBMove1Down	{b} {# move item XiVstSelectedNr 1 down in list XiVstActive/Inactive acc.to XiSelectedFromActive
 global XV Wevst XiSelectedFromActive XiSelectedVstFile XiVstSelectedNr XiVstActive XiVstInactive XiVstLastClick
 TestPut 2 ""
 if {$XiSelectedFromActive==1}       {set ll [llength $XiVstActive]} else {set ll [llength $XiVstInactive]}
 if {$XiSelectedFromActive==""}      {ConfigText $Wevst.e.t "$XV(anoentry)";  mybell 4; return}
 if {$XiVstSelectedNr>=[expr $ll-1]} {ConfigText $Wevst.e.t "$XV(anomovedo)"; mybell 4; return}
 if {($XiSelectedFromActive==1)&&($XiVstSelectedNr<=[expr [lindex $XV(XSettVF$XiSelectedVstFile) 1]-1])} \
				     {ConfigText $Wevst.e.t "$XV(anomove)"; mybell 4; return}
 set p $XiVstSelectedNr; XiSettVHDel $p; incr p; XiSettVHIns "" $p "$XiVstLastClick"; XiSettVHFill; XiSettVHSelItem "" $p
 ConfigText $Wevst.e.t "[lindex $XV(XSettVBut$b) 3]"
}

proc XiSettVBMove1Up	{b} {# move item XiVstSelectedNr 1 up in list XiVstActive/Inactive acc.to XiSelectedFromActive
 global XV Wevst XiSelectedFromActive XiSelectedVstFile XiVstSelectedNr XiVstLastClick
 TestPut 2 ""
 if {$XiSelectedFromActive==""} {ConfigText $Wevst.e.t "$XV(anoentry)";  mybell 4; return}
 if {$XiVstSelectedNr<=0}       {ConfigText $Wevst.e.t "$XV(anomoveup)"; mybell 4; return}
 if {($XiSelectedFromActive==1)&&($XiVstSelectedNr<=[lindex $XV(XSettVF$XiSelectedVstFile) 1])} \
				{ConfigText $Wevst.e.t "$XV(anomoveup)"; mybell 4; return}
 set p $XiVstSelectedNr; XiSettVHDel $p; decr p; XiSettVHIns "" $p "$XiVstLastClick"; XiSettVHFill; XiSettVHSelItem "" $p
 ConfigText $Wevst.e.t "[lindex $XV(XSettVBut$b) 3]"
}

proc XiSettVBMoveDeflt	{b} {# moves selected item to the default position in list XiVstActive
 global XV Wevst XiSelectedFromActive XiVstSelectedNr XiSelectedVstFile XiVstLastClick
 TestPut 2 ""
 if {$XiSelectedFromActive==""} {ConfigText $Wevst.e.t "$XV(anoentry)";  mybell 4; return}
 if {$XiSelectedFromActive==0}  {ConfigText $Wevst.e.t "$XV(anoact)";    mybell 4; return}
 if {$XiVstSelectedNr<=[lindex $XV(XSettVF$XiSelectedVstFile) 1]} \
				{ConfigText $Wevst.e.t "$XV(anomoveup)"; mybell 4; return}
 XiSettVHDel $XiVstSelectedNr;  set XiVstSelectedNr [lindex $XV(XSettVF$XiSelectedVstFile) 1]
 XiSettVHIns "" $XiVstSelectedNr "$XiVstLastClick";  XiSettVHFill;  XiSettVHSelItem "" $XiVstSelectedNr
 ConfigText $Wevst.e.t "[lindex $XV(XSettVBut$b) 3]"
}

proc XiTBKT {w} \
  {if {"$w"!=""} {ConfigText $w "editing of the displayed file (positioning: mouse, home, end, pg-up, pg-down, cursor)"}}

proc XiTextBindKeys {w wt wl} {# key bindings for editing in text widgets wt (mouse grab)/w=toplevel
 TestPut 2 "<$w><$wt><$wl>"
   # tkTextButton1 and tkTextSelectTo from /usr/local/lib/tk4.0/text.tcl (tk/tclversion dependent?)  
   bindtags $wt {T1 Text $w all}
   bind T1 <Home>            "$wt mark set insert 0.0; $wt yview -pickplace insert;        XiTBKT \"$wl\"; break"
   bind T1 <End>             "$wt mark set insert end; $wt yview -pickplace insert;        XiTBKT \"$wl\"; break"
   bind T1 <Button-1>        "tkTextButton1 %W %x %y;                                      XiTBKT \"$wl\"; break"
   bind T1 <B1-Motion>       "set tkPriv(x) %x; set tkPriv(y) %y; tkTextSelectTo %W %x %y; XiTBKT \"$wl\"; break"
   bind T1 <ButtonRelease-2> {catch {%W insert insert [selection get -selection PRIMARY]};                 break}
   bind T1 <Delete>          "selection clear $wt"
   bind T1 <BackSpace>       "selection clear $wt"
}

proc XiEVBEASBut {save} {
 global Wevst Wevstb XiWevstButList XiSelectedVstFile INSTPATH NEW XiCurLanguage XiVstHasSep
 TestPut 3 ""
 if {$save=="save"} {
   set file $INSTPATH/$NEW/locals_$XiCurLanguage/${XiSelectedVstFile}.tmp
   set f [open $file w]
   set lc [$Wevstb.b.t get "end -1c" end]
   if {($lc=="\n")} {puts -nonewline $f [$Wevstb.b.t get 1.0 "end-1c"]} {puts -nonewline $f [$Wevstb.b.t get 1.0 end]}
   flush $f;  close $f
 }
 XiVst2Lists $XiSelectedVstFile tmp new; XiSettVHFill; # XiSelectedVstFile.tmp --> XiVstActive/Inactive & fill windows
 FileDelete $INSTPATH/$NEW/locals_$XiCurLanguage/${XiSelectedVstFile}.tmp
 XiSettVHDestroyRaiseUnlock $Wevstb
}

proc XiSettVHDestroyRaiseUnlock {destroy} {#destroys $destroy; then raises Wevst and unlocks/locks Buttons in it
 global Wevst Wevstb XiWevstButList
 TestPut 3 ""
 destroy $destroy;  raise $Wevst
 eval UnlockButtons $Wevst.a.ends $Wevst.a.save $Wevst.a.endq $Wevst.a.cLRW $XiWevstButList
 XiSettVHButLock
}

proc XiSettVHButLock {} {# locks some edit buttons in menu Wevst="Edit Setting File" (XiVstLockIfNoSep + ...)
 global Wevst XiVstHasSep XiVstLockIfNoSep XiVstOriginalParameters XiSelectedVstFile XiCurLanguage
 TestPut 3 "XiVstOriginalParameters=$XiVstOriginalParameters"
 if {$XiVstHasSep==0} {foreach b $XiVstLockIfNoSep {$b configure -state disabled}}
 if {$XiVstOriginalParameters==0} {
   $Wevst.a.cLRW configure -state disabled; bind $Wevst.a.cLRW <Button-1> ""
   set ft "locals_$XiCurLanguage.LRW/$XiSelectedVstFile -> locals_$XiCurLanguage/$XiSelectedVstFile"
   bind $Wevst.a.cLRW <Enter> \
     "ConfigText $Wevst.e.t \"criteria line of setting-files differ;you can only copy by hand $ft\""
 }
}

proc XiSettVHLockButtons {} {# locks top buttons in menu Wevst="Edit Setting File" (XiVstLockIfNoSep + ...)
 global Wevst XiWevstButList
 TestPut 3 ""
 eval LockButtons $Wevst.a.ends $Wevst.a.save $Wevst.a.endq $Wevst.a.cLRW $XiWevstButList
}

proc XiEditVstEntryBabrt {} {TestPut 2 ""; XiEditVstEntryHexit}

proc XiEditVstEntryBends {} {TestPut 2 ""; if ![XiEditVstEntryHSave] return; XiEditVstEntryHexit}

proc XiEditVstEntryBnext {} {
 global XiVstSelectedNr XiSelectedFromActive  XiVstActive XiVstInactive
 TestPut 2 "$XiVstSelectedNr"
 if {$XiSelectedFromActive==1} {set ll [llength $XiVstActive]} else {set ll [llength $XiVstInactive]}; incr ll -1
 if {$XiVstSelectedNr==$ll} return
 if {($XiVstSelectedNr<0)||($XiVstSelectedNr>$ll)} {return}
 if ![XiEditVstEntryHSave] return
 if {$XiVstSelectedNr<$ll} {incr XiVstSelectedNr 1}; XiEditVstEntryHLoad $XiVstSelectedNr; XiEditVstEntryHPNLU
 if {$XiSelectedFromActive==1} {XiSettVHSelItem Active $XiVstSelectedNr} else {XiSettVHSelItem Inactive $XiVstSelectedNr}
}

proc XiEditVstEntryBprev {} {
 global XiVstSelectedNr XiSelectedFromActive XiVstActive XiVstInactive
 TestPut 2 "$XiVstSelectedNr"
 if {$XiVstSelectedNr==0} return
 if {$XiSelectedFromActive==1} {set ll [llength $XiVstActive]} else {set ll [llength $XiVstInactive]}; incr ll -1
 if {($XiVstSelectedNr<0)||($XiVstSelectedNr>$ll)} {return}
 if ![XiEditVstEntryHSave] return
 if {$XiVstSelectedNr>0} {incr XiVstSelectedNr -1}; XiEditVstEntryHLoad $XiVstSelectedNr; XiEditVstEntryHPNLU
 if {$XiSelectedFromActive==1} {XiSettVHSelItem Active $XiVstSelectedNr} else {XiSettVHSelItem Inactive $XiVstSelectedNr}
}

proc XiEditVstEntryHexit {} {
 global Wevst Wevstl XiWevstButList XiVstSelectedNr XiSelectedFromActive
 TestPut 2 ""
 XiSettVHDestroyRaiseUnlock $Wevstl
 if {$XiSelectedFromActive==1} {XiSettVHSelItem Active $XiVstSelectedNr} else {XiSettVHSelItem Inactive $XiVstSelectedNr}
}

proc XiEditVstEntryHPar {n} {#
 global XV Wevstl XiVstPar XiSelectedVstFile XiVstLO
 TestPut 2 "$n"
 set wt [lindex $XV(XSettVF$XiSelectedVstFile) 4]; set wl [lindex $XV(XSettVF$XiSelectedVstFile) 5]
 set s [lindex $XV(XSettVF$XiSelectedVstFile) 6];  if {$s=="left"} {set a e} else {set a w}
 frame $Wevstl.b.$n;  pack $Wevstl.b.$n -anchor w -fill both -expand yes
 label $Wevstl.b.$n.l -width $wl -anchor $a; pack $Wevstl.b.$n.l -side $s -anchor w
 if {[lindex [lindex $XV(XSettVF$XiSelectedVstFile) [expr $n+$XiVstLO]] 2]==""} {
   entry $Wevstl.b.$n.e -textvariable XiVstPar($n) -width $wt -relief sunken
   pack $Wevstl.b.$n.e -side $s -anchor w -fill x -expand yes
 } else {
   scrollbar $Wevstl.b.$n.s -command "$Wevstl.b.$n.e yview"
   text $Wevstl.b.$n.e -yscrollcommand "$Wevstl.b.$n.s set" \
	-height [lindex [lindex $XV(XSettVF$XiSelectedVstFile) [expr $n+$XiVstLO]] 2]
   pack $Wevstl.b.$n.s -side right -fill y
   pack $Wevstl.b.$n.e -side right -fill both -expand yes
   XiTextBindKeys $Wevstl $Wevstl.b.$n.e ""
 }
}

proc XiEditVstEntryHLoad {nr} {# loads entry nr from list XiVstActive/Inactive acc.to XiSelectedFromActive
 global XV Wevstl XiVstActive XiVstInactive XiSelectedFromActive XiSelectedVstFile XiVstSep XiVstPar XiVstParAnz XiVstLO
 TestPut 2 "$nr"
 if   {$XiSelectedFromActive==1} {set e [lindex "$XiVstActive"   $nr]} \
 else				 {set e [lindex "$XiVstInactive" $nr]}
 for {set n 0} {$n<=$XiVstParAnz} {incr n} {
   ConfigText $Wevstl.b.$n.l "[lindex [lindex $XV(XSettVF$XiSelectedVstFile) [expr $n+$XiVstLO]] 0] : "
   if {$XiVstSep==""} {if {$n==0} {set XiVstPar(0) [lindex $e 0]} else {set XiVstPar($n) [lrange $e 1 end]}} \
   else {set XiVstPar($n) "[string trim [lindex [split $e $XiVstSep] $n]]"}
   if {[lindex $XV(XSettVF$XiSelectedVstFile) [expr $n+$XiVstLO]]=="_"} \
	{if [winfo exists $Wevstl.b.$n] {destroy $Wevstl.b.$n}}
   if {[lindex [lindex $XV(XSettVF$XiSelectedVstFile) [expr $n+$XiVstLO]] 2]!=""} {
     regsub -all "\},( )*" $XiVstPar($n) "\},\n" t
     $Wevstl.b.$n.e delete 0.0 end;  $Wevstl.b.$n.e insert end "$t";  $Wevstl.b.$n.e yview 0
   }
 }
 update
}

proc XiEditVstHSaveEmptyPar {parNr} {# empty parameter not allowd, give warning!
 global XV Wevst XiVstSelectedNr
 TestPut 2 ""
 set t "\t*** error: parameter $parNr in line [expr $XiVstSelectedNr+1] is empty!"
 XiProtokoll "\t$t";  ConfigText $Wevst.e.t "$t"
 mybell 4
}

proc XiEditVstEntryHSave {} {# saves current values in XiVstActive/XiVstInactive
 global XV Wevstl XiVstActive XiVstInactive XiSelectedFromActive XiSelectedVstFile XiVstSep XiVstHasSep XiVstLO
 global XiVstSelectedNr XiVstPar XiVstParAnz XiVstPBDL
 TestPut 2 ""
 set e ""
 for {set n 0} {$n<=$XiVstParAnz} {incr n} {
   if {$n>0} {set e "${e}$XiVstSep"}
   if {[lindex $XV(XSettVF$XiSelectedVstFile) [expr $n+$XiVstLO]]!="_"} {
     if {[lindex [lindex $XV(XSettVF$XiSelectedVstFile) [expr $n+$XiVstLO]] 2]==""} {set p "$XiVstPar($n)"} \
     else					{regsub -all "\n" [$Wevstl.b.$n.e get 1.0 end] " " p}
     if {$n==0} {
       for {set b [string length $p]} {$b<[lindex $XV(XSettVF$XiSelectedVstFile) 4]} {incr b} {
	 set p "$p "
	 set ml "[lindex $XV(XSettVF$XiSelectedVstFile) 8]"
	 if {($XiVstSep=="")&&($ml!="")&&([string length $p]>=$ml)} {break}
       }
       set e "${e}$p "
     } else {
       set e "${e} $p "
     }
   }
   if {($XiVstHasSep!="")&&([string first "$XiVstSep" $p]>=0)} \
	{ConfigText $Wevstl.c.t "Error: argument $n contains separator; please correct"; mybell 4; return 0}
   if {[string trim $p]==""} {
     set errempt 0
     if {([lindex [lindex $XV(XSettVF$XiSelectedVstFile) [expr $n+$XiVstLO]] 1]=="1")} {set errempt 1}
     if {[lindex $XV(XSettVF$XiSelectedVstFile) 1]=="1"} {# special analyse for file containing criteria line!
       if {$XiVstSelectedNr==0} {# criteria line
	 if {![winfo exists $Wevstl.b.$n.e]} {set errempt 0}; foreach i $XiVstPBDL {if {$i==$n} {set errempt 0}}
       } else {# other line
	 if {$n>[lindex $XV(XSettVF$XiSelectedVstFile) 2]} {set errempt 1}
       }
     }
     if {$errempt} {XiEditVstHSaveEmptyPar [lindex [lindex $XV(XSettVF$XiSelectedVstFile) [expr $n+$XiVstLO]] 0]}
   }
 }
 if {$XiSelectedFromActive==1} {set XiVstActive   [lreplace $XiVstActive  $XiVstSelectedNr $XiVstSelectedNr "$e"]} \
 else                          {set XiVstInactive [lreplace XiVstInactive $XiVstSelectedNr $XiVstSelectedNr "$e"]}
 XiSettVHFill
 return 1
}

proc XiEditVstEntryHPNLU {} {# lock/unlock the previous/next buttons
 global Wevstl XiVstActive XiVstInactive XiVstSelectedNr XiSelectedFromActive XiVstPBDL XiVstPBDLw
 TestPut 2 ""
 if {$XiSelectedFromActive==1} {set anz [llength "$XiVstActive"]} else {set anz [llength "$XiVstInactive"]}; incr anz -1
 $Wevstl.a.prev configure -state normal; $Wevstl.a.next configure -state normal
 if {$XiVstSelectedNr==0}    {$Wevstl.a.prev configure -state disabled}
 if {$XiVstSelectedNr>=$anz} {$Wevstl.a.next configure -state disabled}
 if {($XiVstSelectedNr==0)} {
   set XiVstPBDLw "";  foreach n $XiVstPBDL \
	{if [winfo exists $Wevstl.b.$n.e] {pack forget $Wevstl.b.$n.e; set XiVstPBDLw "$XiVstPBDLw $Wevstl.b.$n.e"}}
 }
 if {($XiVstSelectedNr==1)&&($XiVstPBDLw!="")} \
	{foreach w $XiVstPBDLw {pack $w -anchor w -fill both -expand yes}; set XiVstPBDLw ""}
 update
}

#----- setting file edit menus        --------------------------------------------------------

proc XiSettEditNews {File} {# edit File (.news-file) in a text edit widget
 global XV Wvsts Wenews XiNewsfiles XiVstfiles INSTPATH NEW XiCurLanguage
 TestPut 3 "**********************<$File>"

 XiActivateFileEditButtons $Wvsts.b $XiNewsfiles .news 0; XiActivateFileEditButtons $Wvsts.c $XiVstfiles .vst 0
 XiActivateLangSelButtons $Wvsts 0; $Wvsts.a.ende configure -state disabled; update
 
 XiProtokoll "$XV(AAsteriks)\nEdit News File \"$File.news\"\n"

 toplevel_init $Wenews "Edit News File" 400 100

 foreach frame "a b c" {frame $Wenews.$frame -borderwidth 1 -relief raised; pack $Wenews.$frame -fill both -expand yes}

 # frame a: end and save buttons
 XiCreateESButtons $Wenews $File .news

 # frame b: file edit widget
 scrollbar $Wenews.b.s -command "$Wenews.b.t yview"
 text $Wenews.b.t -yscrollcommand "$Wenews.b.s set" -height 20 -width 80
 pack $Wenews.b.s -side right -fill y
 pack $Wenews.b.t -side right -fill both -expand yes
 XiTextBindKeys $Wenews $Wenews.b.t $Wenews.c.t
 set f [open $INSTPATH/$NEW/locals_$XiCurLanguage/$File.news r]
 $Wenews.b.t delete 0.0 end;  $Wenews.b.t insert end "[read $f]";  $Wenews.b.t yview 0
 close $f

 # frame c: Text
 label $Wenews.c.t -text "click first at edit field"; pack $Wenews.c.t -anchor w
}

proc XiSettEditVst {File} {
 global XV Wevst Wvsts INSTPATH NEW XiNewsfiles XiVstfiles xtem_path language XiCurLanguage XiVstSelButtons XiVstParAnz
 global XiVstActive XiVstInactive XiSelectedFromActive XiSelectedVstFile XiVstSelectedNr XiWevstButList XiVstFL
 global XiVstHasSep XiVstSep XiVstParAnzMin XiMaxBoxWidth XiVstLO tclversion XiVstLockIfNoSep XiVstVersion
 TestPut 3 "**********************<$File>"
 
 XiActivateFileEditButtons $Wvsts.b $XiNewsfiles .news 0; XiActivateFileEditButtons $Wvsts.c $XiVstfiles .vst 0
 XiActivateLangSelButtons $Wvsts 0; $Wvsts.a.ende configure -state disabled; update

 XiProtokoll "$XV(AAsteriks)\nEdit Setting File \"...$XiCurLanguage/$File.vst\"\n"

 set XiVstVersion ""
 if [info exists XV(XSettVF$File.vst)] {TestPut 2 "P1: <$XV(XSettVF$File.vst)>"}
 set xtem_path "$INSTPATH/$NEW"; set language "$XiCurLanguage"
  XiVst2Lists $File.vst "" new; # File --> XiVstActive/Inactive
 if {([lindex $XV(XSettVF$File.vst) 3]==1)&&($XiVstParAnz>[lindex $XV(XSettVF$File.vst) 2])} {# update XV(XSettVFxxx.vst)
   set XiVstParAnzMin [lindex $XV(XSettVF$File.vst) 2]
   TestPut 1 "    <[expr [lindex $XV(XSettVF$File.vst) 2]+1]>...<$XiVstParAnz>"
   for {set n [expr [lindex $XV(XSettVF$File.vst) 2]+1]} {$n<=$XiVstParAnz} {incr n} {
    TestPut 1 "    <[llength $XV(XSettVF$File.vst)]><[expr $n+$XiVstLO]>"
    if {[llength $XV(XSettVF$File.vst)]<=[expr $n+$XiVstLO]} {
     lappend XV(XSettVF$File.vst) [string trim [lindex [split $XiVstFL $XiVstSep] $n]]
    } else {
     set p [expr $n+$XiVstLO]; set e [llength $XV(XSettVF$File.vst)]
     set XV(XSettVF$File.vst) [lreplace $XV(XSettVF$File.vst) $p $e [string trim [lindex [split $XiVstFL $XiVstSep] $n]]]
    }
   }
   set XV(XSettVF$File.vst) [lreplace $XV(XSettVF$File.vst) 7 7 $XiVstParAnz]
 }
 if [info exists XV(XSettVF$File.vst)] {TestPut 2 "P2: <$XV(XSettVF$File.vst)>"}

 if ![info exists XV(XSettVCom$XiCurLanguage)] {set XV(XSettVCom$XiCurLanguage) "$XV(XSettVComenglish)"}
 set XiSelectedFromActive "";  set XiSelectedVstFile "$File.vst";  set XiVstSelectedNr ""

 if $XiVstHasSep {set t "(Separator=\"$XiVstSep\""} else {set t "(Has no Separator"}
 if {$XiVstVersion!=""} {set t "$t / V.$XiVstVersion"}; set t "${t})"

 toplevel_init $Wevst "Edit Setting File: ...$XiCurLanguage/$File.vst $t" 600 400

 foreach w "a b c d e" {frame $Wevst.$w -borderwidth 1 -relief raised; pack $Wevst.$w -fill x}

 # frame a: end and save buttons
 XiCreateESButtons $Wevst $File .vst
 button $Wevst.a.cLRW -text "copy originals to inactive" -command "XiCopyOriToInactive $File"
 pack $Wevst.a.cLRW -side right
 bind $Wevst.a.cLRW <Enter> \
	{ConfigText $Wevst.e.t "copy (add) the authors original setting file entries to `inactive entries'"}
 bind $Wevst.a.cLRW <Leave> {ConfigText $Wevst.e.t ""}

 # frame b: setting file line selection menu: active entries
 XiCreateLSBox $Wevst.b "active entries:" top $XiMaxBoxWidth 10 2 $XiVstActive   XiSettVHSelLineActive

 # frame c: setting file line selection menu: inactive entries
 XiCreateLSBox $Wevst.c "inactive entries (=comment):" top $XiMaxBoxWidth  5 2 $XiVstInactive XiSettVHSelLineInactive

 # frame d: buttons
 set XiWevstButList ""; set XiVstLockIfNoSep ""
 set Buttons "$XV(XSettVButtons)"; if {[lindex $XV(XSettVF$XiSelectedVstFile) 3]==1} {set Buttons "$Buttons 13 14"}
 foreach bt $Buttons {
   if {[expr $bt%4]==1} {set line [expr $bt/4]; frame $Wevst.d.line$line; pack $Wevst.d.line$line -anchor nw}
   button $Wevst.d.line$line.$bt -width 16 -text "[lindex $XV(XSettVBut$bt) 0]" -anchor w
   pack $Wevst.d.line$line.$bt -side left
   bind $Wevst.d.line$line.$bt <Button-1>	"set XiShift 0; [lindex $XV(XSettVBut$bt) 1] $bt"
   bind $Wevst.d.line$line.$bt <Shift-Button-1>	"set XiShift 1; [lindex $XV(XSettVBut$bt) 1] $bt"
   bind $Wevst.d.line$line.$bt <Enter> "ConfigText $Wevst.e.t \"[lindex $XV(XSettVBut$bt) 2]\""
   bind $Wevst.d.line$line.$bt <Leave> {ConfigText $Wevst.e.t ""}
   set XiWevstButList "$XiWevstButList $Wevst.d.line$line.$bt"
   if {$bt==10} {set XiVstLockIfNoSep "$XiVstLockIfNoSep $Wevst.d.line$line.$bt"}
 }
 if {$XiVstHasSep==0} {foreach b $XiVstLockIfNoSep {bind $b <Button-1> ""}}
 XiSettVHButLock

 # frame e: Text
 label $Wevst.e.t -text ""; pack $Wevst.e.t -anchor w
 if {"$File"=="mkcommand"} {
   global MkcmdTclVColNr; if [info exists MkcmdTclVColNr] {unset MkcmdTclVColNr}; set mkcmdcol [MkcmdTclVCol no-exit]
   if {$mkcmdcol==0} {ConfigText $Wevst.e.t "$XV(MkCmdNCol1) $tclversion; $XV(MkCmdNCol2)"; mybell 4}
 }
}

proc XiSettVBEditBuff	{b} {# edit file XiSelectedVstFile (all entries) in a text edit widget
 global XV Wevstb XiSelectedVstFile INSTPATH NEW XiCurLanguage XiVstHasSep XiVstSep
 TestPut 3 "**********************<$b>"

 XiSettVHSelClear; XiSettVHLockButtons
 XiSaveVstfile ${XiSelectedVstFile}.tmp 0

 if $XiVstHasSep {set ts "(Separator=\"$XiVstSep\")"} else {set ts "(Has no Separator)"}
 toplevel_init $Wevstb "Edit Buffer: \"$XiSelectedVstFile\" $ts" 500 100

 foreach frame "a b c" {frame $Wevstb.$frame -borderwidth 1 -relief raised}
 pack $Wevstb.a -anchor w; pack $Wevstb.b -anchor w -fill both -expand yes; pack $Wevstb.c -anchor w -fill x

 # frame a: end and save buttons
 button $Wevstb.a.end -text "end"; pack $Wevstb.a.end -side left
 button $Wevstb.a.ext -text "abort"; pack $Wevstb.a.ext -side left
 bind $Wevstb.a.end <Button-1> "XiEVBEASBut   save; Bend"
 bind $Wevstb.a.ext <Button-1> "XiEVBEASBut nosave; Bend"
 bind $Wevstb.a.end <Enter> {ConfigText $Wevstb.c.t "end edit buffer window, using current contents of this window"}
 bind $Wevstb.a.ext <Enter> {ConfigText $Wevstb.c.t "exit edit buffer window, ignore all changes done in this window"}
 bind $Wevstb.a.end <Leave> {ConfigText $Wevstb.c.t ""}
 bind $Wevstb.a.ext <Leave> {ConfigText $Wevstb.c.t ""}
 
 # frame b: file edit widget
 scrollbar $Wevstb.b.s -command "$Wevstb.b.t yview"
 text $Wevstb.b.t -yscrollcommand "$Wevstb.b.s set" -height 20 -width 80
 pack $Wevstb.b.s -side right -fill y
 pack $Wevstb.b.t -side right -fill both -expand yes
 XiTextBindKeys $Wevstb $Wevstb.b.t $Wevstb.c.t
 set f [open $INSTPATH/$NEW/locals_$XiCurLanguage/${XiSelectedVstFile}.tmp r]
 $Wevstb.b.t delete 0.0 end;  $Wevstb.b.t insert end "[read $f]";  $Wevstb.b.t yview 0
 close $f

 # frame c: Text
 label $Wevstb.c.t -text "click first at edit field"; pack $Wevstb.c.t -anchor w
}

proc XiSettVHEditEntry {nr} {# edit item $nr from the active lists XiVstActive/Inactive according to XiSelectedFromActive
 global XV Wevst Wevstl XiSelectedFromActive XiWevstButList XiSelectedVstFile XiVstHasSep XiVstSep XiVstParAnz
 global XiVstPBDL XiVstPBDLw
 TestPut 3 "**********************<$nr>"

 if {$XiSelectedFromActive==""} {ConfigText $Wevst.e.t "$XV(anoentry)";  mybell 4; return}
 if {$XiSelectedFromActive==0}  {ConfigText $Wevst.e.t "$XV(anoact)";    mybell 4; return}

 XiSettVHLockButtons

 if $XiVstHasSep {set t "(Separator=\"$XiVstSep\")"} else {set t "(Has no Separator)"}

 toplevel_init $Wevstl "Edit an Entry in Setting File: \"$XiSelectedVstFile\" $t" 500 150

 foreach frame "a b c" {frame $Wevstl.$frame -borderwidth 1 -relief raised; pack $Wevstl.$frame -fill x -expand yes}

 # frame a: end, previous, next, abort, delete_parameter and add_parameter buttons
 set butlist "ends prev next abrt";# if {[lindex $XV(XSettVF$XiSelectedVstFile) 3]==1} {set butlist "$butlist pdel padd"}
 foreach b $butlist {
   button $Wevstl.a.$b -text $XV(Xeeb$b); if {($b=="pdel")||($b=="padd")} {set sd right} else {set sd left}
   pack $Wevstl.a.$b -side $sd
   bind $Wevstl.a.$b <Button-1> "XiEditVstEntryB$b; Bend"
   bind $Wevstl.a.$b <Enter> "ConfigText $Wevstl.c.t \"$XV(Xeet$b)\""
   bind $Wevstl.a.$b <Leave> "ConfigText $Wevstl.c.t \"\""
 }

 # frame b: item edit widget
 for {set n 0} {$n<=$XiVstParAnz} {incr n} {XiEditVstEntryHPar $n}
 set XiVstPBDLw ""; set XiVstPBDL ""; if {$XiSelectedVstFile=="printing.vst"} {set XiVstPBDL "0 4 5 6 7"}
 XiEditVstEntryHLoad $nr;  XiEditVstEntryHPNLU

 # frame c: Text
 label $Wevstl.c.t -text ""; pack $Wevstl.c.t -anchor w
}

proc XiSettVBParDel	{b} {# delete a paramter (to be specified in a window now generated) from each entry
 global XV Wevst Wevstd XiSelectedVstFile XiVstSep
 TestPut 3 "**********************<$b>"

 XiSettVHSelClear; ConfigText $Wevst.e.t "[lindex $XV(XSettVBut$b) 3]"; XiSettVHLockButtons

 toplevel_init $Wevstd "Deleting a Parameter in File: \"$XiSelectedVstFile\" (Separator=\"$XiVstSep\")" 500 100

 foreach frame "a b c" {frame $Wevstd.$frame -borderwidth 1 -relief raised; pack $Wevstd.$frame -fill x -expand yes}

 # frame a: end button
 button $Wevstd.a.e -text "end"; pack $Wevstd.a.e -side left
 bind $Wevstd.a.e <Button-1> "XiSettVHDestroyRaiseUnlock $Wevstd; Bend"
 bind $Wevstd.a.e <Enter> "ConfigText $Wevstd.c.t {ends this window}"
 bind $Wevstd.a.e <Leave> "ConfigText $Wevstd.c.t {}"

 # frame b: select&delete parameter
 XiCreateLSBox $Wevstd.b "Clicking at parameter in this list will delete it form all entries!:" top 40 10 2 \
	[XiSettVHParList] XiSettVHParDel

 # frame c: Text
 label $Wevstd.c.t -text ""; pack $Wevstd.c.t -anchor w
}

proc XiSettVBParAdd	{b} {# add a parameter (to be specified in window now generated) to each entry
 global XV Wevst Wevsta XiSelectedVstFile XiVstSep XiVstParNew
 TestPut 3 "**********************<$b>"

 XiSettVHSelClear;  ConfigText $Wevst.e.t "[lindex $XV(XSettVBut$b) 3]"; XiSettVHLockButtons

 toplevel_init $Wevsta "Adding a Parameter in File: \"$XiSelectedVstFile\" (Separator=\"$XiVstSep\")" 200 100

 foreach frame "a b c" {frame $Wevsta.$frame -borderwidth 1 -relief raised; pack $Wevsta.$frame -fill x -expand yes}

 # frame a: end button
 button $Wevsta.a.e -text "end"; pack $Wevsta.a.e -side left
 button $Wevsta.a.c -text "abort"; pack $Wevsta.a.c -side left
 bind $Wevsta.a.e <Button-1> "XiSettVHParAdd; Bend"
 bind $Wevsta.a.e <Enter> "ConfigText $Wevsta.c.t {ends this window with parameter creating}"
 bind $Wevsta.a.e <Leave> "ConfigText $Wevsta.c.t {}"
 bind $Wevsta.a.c <Button-1> "XiSettVHDestroyRaiseUnlock $Wevsta; Bend"
 bind $Wevsta.a.c <Enter> "ConfigText $Wevsta.c.t {aborts this window without parameter creating}"
 bind $Wevsta.a.c <Leave> "ConfigText $Wevsta.c.t {}"

 # frame b: add new parameter
 label $Wevsta.b.l -text "new parameter name:"; pack $Wevsta.b.l -anchor w
 entry $Wevsta.b.p -textvariable XiVstParNew -width 30 -relief sunken; pack $Wevsta.b.p -anchor w -fill x -expand yes
 bind $Wevsta.b.p <Return> "focus $Wevsta"
 set t "enter name of the new parameter, then `end' window"
 foreach win "l p" \
    {bind $Wevsta.b.$win <Enter> "ConfigText $Wevsta.c.t \"$t\"";bind $Wevsta.b.$win <Leave> "ConfigText $Wevsta.c.t {}"}
 set XiVstParNew ""

 # frame c: Text
 label $Wevsta.c.t -width 50 -anchor w; pack $Wevsta.c.t -anchor w
 focus $Wevsta.b.p
}

proc XiSettVHParDel {} {# deletes a user definable parameter (e.g. in printing.vst)
 global XV Wevstd XiSelectedVstFile XiVstSep XiVstParAnzMin XiVstParAktEL XiVstParAnz XiVstLastClick XiVstLO
 global XiVstFL XiVstActive XiVstInactive XiVstOriginalParameters
 TestPut 2 ""
 if {($XiVstLastClick=="")||([lindex $XV(XSettVF$XiSelectedVstFile) 7]<=$XiVstParAnzMin)} {return ""}
 incr XiVstParAnz -1;  set XV(XSettVF$XiSelectedVstFile) [lreplace $XV(XSettVF$XiSelectedVstFile) 7 7 $XiVstParAnz]
 set pardel [lindex $XiVstLastClick 1]
 set n [expr $pardel+$XiVstLO]; set XV(XSettVF$XiSelectedVstFile) \
     [lreplace $XV(XSettVF$XiSelectedVstFile) [expr $n-1] $n [lindex $XV(XSettVF$XiSelectedVstFile) [expr $n-1]]]
 set fl [split $XiVstFL $XiVstSep];  set XiVstFL "[lindex $fl 0]"
 set fl [lreplace $fl [expr $pardel-1] $pardel [lindex $fl [expr $pardel-1]]]
 for {set n 1} {$n<=$XiVstParAnz} {incr n} {set XiVstFL "${XiVstFL}${XiVstSep}[lindex $fl $n]"}
 $Wevstd.b.f.f.li delete 0 end; foreach e [XiSettVHParList] {$Wevstd.b.f.f.li insert end $e}
 set XiVstActive   [XiSettVHParDelN $pardel $XiVstActive]
 set XiVstInactive [XiSettVHParDelN $pardel $XiVstInactive]
 XiSettVHFill
 set XiVstOriginalParameters 0
}

proc XiSettVHParAdd {} {
 global XV Wevsta XiVstFL XiVstParNew XiVstActive XiVstInactive XiSelectedVstFile XiVstSep XiVstParAnz XiVstLO
 global XiVstOriginalParameters
 TestPut 2 "$XiVstParNew"
 set XiVstParNew [string trim $XiVstParNew]
 if {$XiVstParNew==""} \
	{ConfigText $Wevsta.c.t "missing parameter name --- enter string into the entry window!"; mybell 4; return}
 regsub -all " " $XiVstParNew "_" XiVstParNew
 TestPut 2 "$XiVstParNew"
 incr XiVstParAnz 1;  set XV(XSettVF$XiSelectedVstFile) [lreplace $XV(XSettVF$XiSelectedVstFile) 7 7 $XiVstParAnz]
 if {[string first " " $XiVstParNew]>=0} \
	{ConfigText $Wevsta.c.t "parameter name cannot contain blanks!"; mybell 4; return}
 set XV(XSettVF$XiSelectedVstFile) [linsert $XV(XSettVF$XiSelectedVstFile) [expr $XiVstParAnz+$XiVstLO] $XiVstParNew]
 set fl [split $XiVstFL $XiVstSep];  set XiVstFL "[lindex $fl 0]"
 for {set n 1} {$n<$XiVstParAnz} {incr n} {set XiVstFL "${XiVstFL}${XiVstSep}[lindex $fl $n]"}
 set XiVstFL "${XiVstFL}${XiVstSep} $XiVstParNew "
 set XiVstActive   [XiSettVHParAddL Active   $XiVstActive]
 set XiVstInactive [XiSettVHParAddL Inactive $XiVstInactive]
 set XiVstParNew ""
 XiSettVHFill
 set XiVstOriginalParameters 0
 XiSettVHDestroyRaiseUnlock $Wevsta
}

#----- main menu call     ----------------------------------------------------------------------

TestPut 3 "********************** Start main procedure!"

if {[XiEnabModVst locals_$DEFLANGUAGE]} {
  XiSettings
} else {
    set TEXT "directory [pwd]/locals_$DEFLANGUAGE\n"
    set TEXT "${TEXT}doesn't exist;  run \"xteminstall \[basic\]\" first and look for possible error messages!"
    XiExit "$TEXT"
}




#########################################################################################################################
#															 puts stdout "@@@@@@@@@ Ende der getesteten Installationsprozedur erreicht! @@@@@@";exit 0;##################################################################################################################################################################################################################################################################################																
