#ifdef __WIN32__
/* / and \ can be mixed on windows, which may lead to problems
	changes them all to the M$ dirsep */
void clean_up_dirseps(char* path)
{
	while (*path)
	{
		if (*path=='/') *path='\\';
		path++;
	}
}
#endif

/* get a char* pointing to the last appearance of a character inside
	a char* of the full path */
char* get_last_in_file_name(char* src, int element)
{
	char* start_of_element=src+strlen(src);

	while (1)
	{
		if (*start_of_element==element) break;
		if (start_of_element!=src) start_of_element--;
		else return NULL;
	}
	return start_of_element;
}

/* get a char* pointing to filename+extension inside
	a char* of the full path */
char* get_file_name_pointer(char* src)
{
	char* start_of_file=get_last_in_file_name(src,NATIVE_DIRSEP);
	
/* no path separator found - no directory in file name */
	if (!start_of_file) return src;
/* separator is last char - no file name */
	if (start_of_file==src) return NULL;
/* current char is separator - increase by 1 */
	return start_of_file+1;
}

/* get a char* pointing to the (last) extension inside
	a char* of the full path */
char* get_file_suffix_pointer(char* src)
{/* if not found return NULL, else pointer */
	return get_last_in_file_name(src,'.');
}
/* get a char* containing the file's name without the suffix inside
	a char* of the full path */
char* get_file_name(char* src)
{
	char* file_name=get_file_name_pointer(src);
	char* tmp_char;
	int file_name_size;
	char* new_file_name;

	if (!file_name) return NULL;
	tmp_char=file_name;
	while (*tmp_char)
	{
		if (*tmp_char=='.') break;
		tmp_char++;
	}
	file_name_size=tmp_char-file_name;
	new_string(new_file_name,file_name_size);
	if (new_file_name)
	{/* copy string and pad if alloc'd */
		memcpy(new_file_name,file_name,file_name_size);
		new_file_name[file_name_size]=0;
	}
	return new_file_name;
}

/* get a char* containing the dir's name inside
	a char* of the full path */
char* get_dir_name(char* src)
{
	char* file_name=get_file_name_pointer(src);
	int dir_name_size;
	char* dir_name;

	if (!file_name) return src;
	else if (file_name==src) return NULL;
	dir_name_size=file_name-src;
	new_string(dir_name,dir_name_size);
	if (dir_name)
	{/* copy string and pad if alloc'd */
		memcpy(dir_name,src,dir_name_size);
		dir_name[dir_name_size]=0;
	}
	return dir_name;
}
/* create full name of file
	dir_name and suffix may be NULLs */
char* create_full_file_name(char* dir_name, char* file_name, char* suffix)
{
	int name_length;
	int suffix_length;
	int dir_name_length;
	int needs_subdir_char;
	char* new_file_name;
	char* temp_new_name;
	
	if (!file_name) return NULL;
	name_length=strlen(file_name);
	if (!dir_name)
	{
		dir_name_length=0;
		needs_subdir_char=0;
	}
	else
	{
		dir_name_length=strlen(dir_name);
		if (dir_name[dir_name_length-1]!=NATIVE_DIRSEP)
			needs_subdir_char=1;
		else needs_subdir_char=0;
	}
	if (!suffix) suffix_length=0;
	else suffix_length=strlen(suffix);
	new_string(new_file_name,dir_name_length+needs_subdir_char+
		name_length+suffix_length);
	if (!new_file_name) return NULL;
	temp_new_name=new_file_name;
/* was directory set ? */
	if (dir_name)
	{/* yes - prefix with directory name */
		memcpy(temp_new_name,dir_name,dir_name_length);
		temp_new_name+=dir_name_length;
		if (needs_subdir_char)
		{
			*temp_new_name=NATIVE_DIRSEP;
			temp_new_name++;
		}
	}
	memcpy(temp_new_name,file_name,name_length);
	temp_new_name+=name_length;
/* no extension - add NULL */
	if (!suffix) *temp_new_name=0;
/* was extension passed - add it plus NULL */
	else memcpy(temp_new_name,suffix,suffix_length+1);
	return new_file_name;
}

/* create array containing the space delimited options
	inside xxx_cmd+file name for tex variant/util
	Returns NULL on error */
char** create_spawn_options(char* exe_name, char* options, char* file_name)
{
	char** tmp_opt;
/* exe_name, file_name and NULL pad */
	int array_size=3;
	int string_size;
	char* current_opt;
	char* tmp_str;

	if (options)
	{/* there's at least one option */
		array_size++;
		current_opt=options;
		while (*current_opt)
		{
			if (*current_opt==' ') array_size++;
			current_opt++;
		}
	/* set to last character */
		current_opt--;
	}
	new_array(char*,tmp_opt,array_size);
	if (tmp_opt)
	{/* last cell */
		tmp_opt[--array_size]=NULL;
	/* next to last cell */
		tmp_opt[--array_size]=file_name;
		tmp_opt[0]=exe_name;
		array_size--;
	/* if options were not passed we won't do this loop */
		while (array_size)
		{/* copy options into array */
			string_size=0;
			while (current_opt>=options)
			{/* as long as not space or start of string, it belongs to option */
				if (*current_opt==' ') break;
				string_size++;
				current_opt--;
			}
		/* go to first letter of option
			(1 too far if first option/space encountered) */
			current_opt++;
			new_string(tmp_str,string_size);
			if (!tmp_str)
			{/* I hope this does what I think :-) */
				while (tmp_opt[++array_size]!=file_name)
					free(tmp_opt[array_size]);
				free(tmp_opt);
				tmp_opt=NULL;
				break;
			}
			memcpy(tmp_str,current_opt,string_size);
			tmp_str[string_size]=0;
			tmp_opt[array_size]=tmp_str;
		/* we added 1 to get to first letter of option,
			so we need to go back 2 letters to reach last of previous
			option, if it exists. */
			current_opt-=2;
			array_size--;
		}
	}
	return tmp_opt;
}
