#ifndef RLIB_H
#define RLIB_H
#include <rlib/rlib.h>
#include <string.h>
#include <stdio.h>

#ifdef __MSDOS__
char RLIB_program_drive[MAXDRIVE];
char RLIB_program_directory[MAXDIR];
char RLIB_program_name[MAXFILE];
#endif
char RLIB_program_path[MAXPATH];

#if defined(__STDC__) || defined(__cplusplus)
void RLIB_start(char *program_full_path_file)
#else
void RLIB_start(program_full_path_file)
char *program_full_path_file;
#endif
{
#ifdef __MSDOS__
	char fname[MAXFILE];
	char fext[MAXEXT];

	fnsplit(program_full_path_file,RLIB_program_drive,RLIB_program_directory,fname,fext);
	strcpy(RLIB_program_name,fname);
	strcat(RLIB_program_name,fext);
   strcpy(RLIB_program_path,RLIB_program_drive);
	strcat(RLIB_program_path,RLIB_program_directory);

#else /* UNIX and AmigaDos */
  int i;
  int lastslash=0;
  RLIB_program_path[0] = 0;
  for (i = 0; i < strlen(program_full_path_file); i++)
	 lastslash = (program_full_path_file[i] == 47)
#ifdef amiga
		  || (program_full_path_file[i] == ':')
#endif
		  ? i : lastslash;
  for (i = 0; i <= lastslash; i++)
	 RLIB_program_path[i] = program_full_path_file[i];
#endif
};


char *float2str(float value, int decimals)
{
  static char valuestr[30];
  sprintf(valuestr,"%.*f",decimals,value);
  return(valuestr);                          
};
#endif
