
/* Uncomment the following line for hardcoded phrases
#define HARDCODE_PHRASES
*/

/* VMS users should #define VMS */
/* #define VMS */

/* MSDOS users should already have __MSDOS__ defined by the compiler
   otherwise it needs to be defined*/
/* #define __MSDOS__   */

/* This program uses my universal character set conversion and language
   cataloging libraries.  You may need to add the current directory to the
   include path.

   For most UNIX compilers, the  cc  command option is  -I. (<-with the period)

*/

#ifndef HARDCODE_PHRASES
#include <rlib/rlib.h>
#endif
#include <rlib/ucscu.h>
#include <rlib/language.h>

/* When VERBOSE is defined, The sections of the document are displayed
   as they are processed, and cleanup progress indicators are shown.
*/
#define VERBOSE


/* #include <rlib/escseq.h>             not implemented yet
int print_device = TRIBUTE_ES;
*/

/*
   This file contains 8-Bit characters and should be transmitted UUENCODED.

   TeX2hyp.c

   This program converts LaTeX documents to TEXT documents.
   Labels and cross references produce hypertext links compatible
   with Borlands TurboVision help compilers.
   Refer to the file TeX2hyp.DOC

   This program is freely distributable, but not in the Public Domain.
   Do not distribute MODIFIED versions of this program.
   I reserve all rights in the distribution of the program.

   Written by Roger Nelson

       Biological Systems Engr. Dept.
       Washington State University
       Pullman, WA 99164-6120

       rnelson@wsuaix.csc.wsu.edu

       Phone: (509)335-1578
       FAX  : (509)335-2722

   Version history:
   1.0  Jun 25 '93
   1.01 Jul  2 '93  Added Previous topic links.
   1.02 Jul  7 '93  Added more robust command line parsing.
                    Added interactive file and option prompter.
                    Added VMS compile options.
                    Added 7BIT ISO character set selection.
                    Added 8BIT multinational character set support.
                    Now compiles under old C.
                    Now look for fixup's in the LaTeX documents
                         using the new %fixup command.
                    Added label enumerations (section numbering of labels).
                    Fixed bibliography label cross reference
                         label positioning.
   1.03 Jul 12 '93  Cleaned up some 8bit stuff.
                         Added Amiga Topaz (Same as DEC MNCS.
   1.04 Jul 14 '93  Cleaned up some bibliography stuff.
                    Bibliography tabulation is now honoured.
                    Part numbers were incorrectly being added
                         to cross reference enumeration.
                    Some valid special characters were not being
                         allowed in label.
                    Now accepts accent characters of the form:
                         \"{u} as well as \"u.
                    Ligatures such as:
                         \t{ae} should also be processed ok.
                    \newcommand of the form:
                         \newcommand{\cmd}{replacement} should work,
                         but not of the form:
                         \newcommand{\cmd}[args]{replacement}.
                    `` and '' now converted to ".
                    ~ now converted to space.

   1.05 Spt 30 '93  Added \bibliography.
                    Added table of contents.
                    More comprehensive character set conversion using
                       universal character set conversion.
                    Added pagination.
                    Cleaned up line spacing.
                    Added line breaking.
   1.06 Oct 18 '93  Added index (\begin/\end{theindex} \indexspace.
                       \item \subitem \subsubitem \subsubsubitem)
                    Add foreign language translation.
   1.07 Oct 22 '93  Fixed some compilation problems.
                    Fixed line counting of verbatims
   1.08 Spt 17 '94  Text attributes (\em \rm etc..) were putting spaces
                    after left parens as in:({\em emphasised}) -> ( emphasised)
                    Corrected section numbering when chapters not used.
                    Renamed fixup file FIXUP.$$ for FIXUP.SS.
                    For hypertext output, bibliography entries are no longer
                    put on separate "pages".
                    Preliminary HTML support, don't try to use it.
   1.09 Oct 6 '94   Added Swedish Danish and French translations

Under developement:
   2.00

                    Read config.l2h configuration file.
                    .l2h configuration file may be specified on command line.
                    Add table commands.
                    Printer device control.
                    document styles: article report book
                    document options twocolumn
                    \pagenumbering

*/



/* One of the following hypertext readers may be defined: */
#define TR_STRAIGHTTEXT 0
#define TR_TURBOVISION  1
#define TR_HTML         2
#define TR_HTMLPLUS     3
#define TR_AGUIDE       4
#define TR_HYPRTEXT     5
#define TR_SMGL         6

#define HTML()   (textreader == TR_HTML) || (textreader == TR_HTMLPLUS)

/*


   HTML Tags used when doing TR_HTML

   HTML   /HTML

   HTMLPLUS Tags used when doing TR_HTMLPLUS

   HTMLPLUS  /HTMLPLUS

   Tags used for either HTML or HTMLPLUS
   HEAD /HEAD
   BODY /BODY
   H1-H6  /H1-/H6
   b em i code u   /b /em /i /code /u
   listing /listing
   p /p
*/

int textreader = TR_STRAIGHTTEXT;

#ifdef __MSDOS__
#define WRITEMODE "wt"
#define READMODE  "rt"
#else
#define WRITEMODE "w"
#define READMODE "r"
#endif

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <stdlib.h>   /* This may need to be replaced with malloc.h in UNIX */

#define normal_FONT 0
#define rm_FONT 1
#define sl_FONT 2
#define bf_FONT 3
#define em_FONT 4
#define it_FONT 5
#define tt_FONT 6
#define sf_FONT 7
#define sc_FONT 8
#define underline_FONT 10

#define INDENTATION 2

#define START_REF_MARKER 1
#define END_REF_MARKER 2
#define TOC_MARKER 3
#define BEGIN_DOC_MARKER 4

#define EXT_TEX ".tex"
#define EXT_BBL ".bbl"

#define HARD_NEWLINE 30
#define HARD_SPACE   31

#define NO_PREV_NEXT       0
#define GEN_PREV_NEXT      1

#define ENV_FLAG_HORIZ     1  /* If horizontal constraint */
#define ENV_FLAG_VERT      2  /* If vertical constraint */
#define ENV_FLAG_CENTER    4  /* If text is to be centered */
#define ENV_FLAG_RESOLVED  8  /* If cross references resolved */
#define ENV_FLAG_FIXEDUP  16  /* If fixups completed */

#define ENV_TYPE_FOOTNOTE  1  /* Footnote text */
#define ENV_TYPE_TABULAR   2  /* Tabular environment */
#define ENV_TYPE_EQUATION  3  /* Equation or subequation */




struct environment_layout
{                     /* When adding slots, make sure to add to new_environment() */
  int font;
  unsigned int type;  /* One of environment types */
  unsigned int flags; /* Flag bits */
  int indent;         /* # chars from left most print char pos  0 */
  int pref_width;     /* # chars to limit width to (usually for right margin)
                         0 if no constraint */
  int pref_length;    /* # lines to limit length to
                         0 if no constraint */
  int act_width;      /* The longest line length */
  int num_lines;      /* Number of lines if some sort of list.
                         0 if just a text string */
};


#define MAX_enumeration 40
struct label_layout
{
  char_8bit name[30]; /* The label ID */
  char_8bit enumeration[MAX_enumeration];  /* The section number */
  /* char_8bit desc[255];  The description of the section */
  struct label_layout *next;
};

struct fixup_layout
{
  char_8bit mathmode[80];
  char_8bit replacement[80];
  struct fixup_layout *next;
};

struct newcommand_layout
{
  char_8bit newcommand[80];
  char_8bit replacement[80];
  struct newcommand_layout *next;
};

FILE *fixup;
FILE *tocfile;
FILE *idxfile;

struct fixup_layout *fixups = 0;
struct label_layout *labels = 0;
struct newcommand_layout *newcommands = 0;

struct environment_layout *environ_stack[100];
int environ_SP=0;

int AT_END = 0;
int started = 0;

char_8bit input_filename[256];
char_8bit output_filename[256];
FILE *output_file=0;
int inc_indentlevel_after_line = 0;

int footnote_index = 0;

int HTlinenum = 0;
int indentlevel = 0;
int bibliography_indentlevel = 0;
int indentplus = 0;
int rightmargin = 76;

int partnum = 0;
int chapternum = 0;
int sectionnum = 0;
int subsectionnum = 0;
int subsubsectionnum = 0;
int in_appendix = 0;
int in_table = 0;
int in_equation = 0;

int in_bibliography = 0;

int equationnum = 0;
int tablenum = 0;

int build_label = 0;
char_8bit label[256];
int label_pos = 0;

int list_level=0;
int list_count[20];
int list_kind[20];
int in_center;
int in_brackets;

int makeindex = 0;   /* 1 = enable index generation */
int tableofcontents = 0; /* 1 = enable table of contents */

char language_name_code[30];

/* Page layout: */

int page_width  = 96;   /* The number of characters that will fit on a page at Elite */
int page_length = 60;   /* The number of lines that can be printed by printer
                           (usually before the perforation skip may take effect).*/

int left_margin = 0;    /* Number of spaces to indent the entire doc. */
int right_margin = 0;   /* Number of spaces to indent right side of page for entire doc. */
int top_margin = 0;     /* Number of lines to move down page on formfeed */
int bottom_margin = 0;  /* Number of space to leave at bottom of page */

int line_width = 80;     /* Number of characters to print on line
                           computed as page_width - (leftM -rightM)*/
int lines_per_page = 60; /* Number of lines to print on page
                           computed and page_length - (topM-botM) */
int page_num = 1;
int line_num = 1;

int break_lines = 0;        /* Do automatic line breaking */
int break_pages = 0;

char tocline[255];
int tocline_pos = 0;

int bullets[6] =
 { SYM_filled_square,
   SYM_cdot,
   SYM_cpoint,
   '+','-'};
/*
 "Oo.+-",
 "+-",
*/

#define ITEMIZE_LIST      1
#define ENUMERATE_LIST    2
#define DESCRIPTION_LIST  3
#define BIBLIOGRAPHY_LIST 4
#define INDEX_LIST        5

#if defined(__STDC__) || defined(__cplusplus)
struct environment_layout *new_environment
(
  int font,
  unsigned int type,
  unsigned int flags,
  int indent,
  int pref_width,
  int pref_length,
  int act_width,
  int num_lines
)
#else
struct environment_layout *new_environment
(font,type,flags,indent,pref_width,pref_length,act_width,num_lines)
  int font;
  unsigned int type;
  unsigned int flags;
  int indent;
  int pref_width;
  int pref_length;
  int act_width;
  int num_lines;
#endif
{
  struct environment_layout *env;
  if ((env = (struct environment_layout *)malloc(sizeof(struct environment_layout))) != 0)
  { env->font         = font;
    env->type         = type;
    env->flags        = flags;
    env->indent       = indent;
    env->pref_width   = pref_width;
    env->pref_length  = pref_length;
    env->act_width    = act_width;
    env->num_lines    = num_lines;
  };
  return(env);
};

#if  defined(__STDC__) || defined(__cplusplus)
void process_text(FILE *infile);
void process_text_str(char *textstr);
void process_input(FILE *infile, char *extension);
void process_minienvironment(FILE *infile,struct environment_layout *curr_environ);
#else
extern void process_text();
extern void process_text_str();
extern void process_input();
extern void process_minienvironment();
#endif

static char_8bit out_line[256];
static int outlinepos = 0;
static int startlastwordpos = 0;

#if  defined(__STDC__) || defined(__cplusplus)
void print_page_num(FILE *outfile)
#else
void print_page_num(outfile)
FILE *outfile;
#endif
{
   int c;
   char numstr[10];

   if (line_num < lines_per_page)
   while (line_num++ < lines_per_page)
     fprintf(outfile,"\n");

   sprintf(numstr,"%d",page_num);
   for (c = 0; c < left_margin; c++)
      fputc(' ',outfile);
   for (c = 0; (c < line_width) && (c < (line_width - strlen(numstr))/2); c++)
      fputc(' ',outfile);
   fprintf(outfile,"%s",numstr);
   fprintf(outfile,"\f\n");
   page_num += 1;
   line_num = 1;
};

#if  defined(__STDC__) || defined(__cplusplus)
void check_page_break(FILE *outfile)
#else
void check_page_break(outfile)
FILE *outfile;
#endif
{
  if (line_num > lines_per_page)
    print_page_num(outfile);
};

#if  defined(__STDC__) || defined(__cplusplus)
void dumpline(void)
#else
void dumpline()
#endif
{
  int i,j;

  for (i = 1; i<= indentlevel; i++)
     for (j = 0; j <= INDENTATION; j++)
         fputc(' ',output_file);
  for (i = 0; i < (startlastwordpos ? (startlastwordpos) : outlinepos) ;i++)
     fputc(out_line[i],output_file);
  fputc('\n',output_file);
  line_num += 1;
  check_page_break(output_file);

  if (inc_indentlevel_after_line)
  switch (list_kind[list_level])
  { case BIBLIOGRAPHY_LIST :
       indentlevel = bibliography_indentlevel;
       break;
    case INDEX_LIST :
       indentlevel = 0;
       break;
    default :
       indentlevel += 1;
       break;
  };
  inc_indentlevel_after_line = 0;

  if (startlastwordpos)
  {
     for (i = startlastwordpos; i <= outlinepos; i++)
     {
        out_line[i-startlastwordpos] = out_line[i];
        out_line[i-startlastwordpos+1] = 0;
     };
     outlinepos = i -startlastwordpos -1;
     startlastwordpos = 0;
  }
  else
  {
    outlinepos = 0;
    out_line[0] = 0;
  };
};

#if  defined(__STDC__) || defined(__cplusplus)
void process_newpage(void)
#else
void process_newpage()
#endif
{
  dumpline();
  print_page_num(output_file);
};

int add_char_buffer_mode = 0;
char_8bit add_char_buffer[1024];
int add_char_bufferpos = 0;

#if  defined(__STDC__) || defined(__cplusplus)
void add_char(char_8bit outchar)
#else
void add_char(outchar)
char_8bit outchar;
#endif
{
  static char_8bit lastoutchar;

  if ((build_label) && (label_pos < 255))
  {  label[label_pos++] = outchar;
     label[label_pos] = 0;
  };

  if (add_char_buffer_mode)
  {
     add_char_buffer[add_char_bufferpos++] = outchar;
     add_char_buffer[add_char_bufferpos] = 0;
  }
  else
  {
  switch (outchar)
  {
    case HARD_NEWLINE :
       startlastwordpos =0;
       dumpline();
       check_page_break(output_file);
       break;
    case HARD_SPACE :
       out_line[outlinepos++] = ' ';
       if (tocline_pos && (tocline_pos < 255))
               tocline[tocline_pos++] = outchar;
       break;
    case ' ' : case 9 :
       outchar = ' ';
       if (outlinepos && (lastoutchar != ' '))
       {
          out_line[outlinepos++] = outchar;
          if (tocline_pos && (tocline_pos < 255))
               tocline[tocline_pos++] = outchar;
       }
       startlastwordpos = outlinepos;
       break;
    default :
       if (((outlinepos + indentlevel * INDENTATION) > rightmargin) &&
           break_lines)
          dumpline();
       out_line[outlinepos++] = outchar;
       if (tocline_pos && (tocline_pos < 255))
           tocline[tocline_pos++] = outchar;

       break;
  };
  out_line[outlinepos] = 0;
  }
  lastoutchar = outchar;
};

#if  defined(__STDC__) || defined(__cplusplus)

void add_chars(char_8bit *chars)
#else
void add_chars(chars)
char_8bit *chars;
#endif
{
  int i;
  for (i = 0; i < strlen(chars); i++)
     add_char(chars[i]);
};

#if  defined(__STDC__) || defined(__cplusplus)
int nextchar(FILE *infile)
#else
int nextchar(infile)
FILE *infile;
#endif
{
  int ch;
  ch = fgetc(infile);
  ungetc(ch,infile);
  return(ch);
};

int newline_just_printed = 0;


#if  defined(__STDC__) || defined(__cplusplus)
void process_newline(void)
#else
void process_newline()
#endif
{
  if (HTML()) add_chars(" <BF>");
  add_char(HARD_NEWLINE);
  newline_just_printed = 1;
};

#define SPACE_CHAR    1
#define PUNCT_CHAR    2
#define ALPHANUM_CHAR 3

#if  defined(__STDC__) || defined(__cplusplus)
struct label_layout *lookup_label(char_8bit *label_name)
#else
struct label_layout *lookup_label(label_name)
char_8bit *label_name;
#endif
{
  struct label_layout *curr;
  for (curr = labels; curr; curr = curr->next)
    if (strcmp(curr->name,label_name) == 0)
       return(curr);
  return(0);
};

#if  defined(__STDC__) || defined(__cplusplus)
void add_label(char_8bit *label_name)
#else
void add_label(label_name)
char_8bit *label_name;
#endif
{
  struct label_layout *label;

  label = lookup_label(label_name);
  if (!label)
  {
    label = (struct label_layout *)malloc(sizeof(struct label_layout));
    if (label)
    {
       label->next = labels;
       labels = label;
    }
    else
    {
      printf("%s (add_label)",translate(L_Not_enough_memory));
      getchar();
    };
  };
  if (label)
  {
     char_8bit enumeration[MAX_enumeration];
     if (in_table)
        sprintf(enumeration,"%s.%s",chapternum,tablenum);
     else
       if (in_equation)
         sprintf(enumeration,"%s.%s",chapternum,equationnum);
       else
         if (in_bibliography)
           strncpy(enumeration,add_char_buffer,MAX_enumeration-1);
         else
         {   char tempnum[10];
             enumeration[0] = 0;
/* Don't put part numbers in cross reference
             if ((partnum) && (!in_appendix))
             {
                sprintf(tempnum,"%d.",partnum);
                strcat(enumeration,tempnum);
             };
*/
             if (chapternum)
             {
                if (in_appendix)
                  sprintf(tempnum,"%c.",chapternum-1+'A');
                else
                  sprintf(tempnum,"%d.",chapternum);
                strncat(enumeration,tempnum,MAX_enumeration);
             };
             if (sectionnum)
             {
                sprintf(tempnum,"%d.",sectionnum);
                strncat(enumeration,tempnum,MAX_enumeration);
             };
             if (subsectionnum)
             {
                sprintf(tempnum,"%d.",subsectionnum);
                strncat(enumeration,tempnum,MAX_enumeration);
             };
             if (subsubsectionnum)
             {
                sprintf(tempnum,"%d.",subsectionnum);
                strncat(enumeration,tempnum,MAX_enumeration);
             };
           };
        strcpy(label->name,label_name);
        if (enumeration[strlen(enumeration)-1] == '.')
           enumeration[strlen(enumeration)-1] = 0;
        strcpy(label->enumeration,enumeration);
  };
};

#if  defined(__STDC__) || defined(__cplusplus)

void add_fixup(char_8bit *SmathS,char_8bit *replacement)
#else
void add_fixup(SmathS,replacement)
char_8bit *SmathS;
char_8bit *replacement;
#endif
{
  struct fixup_layout *fixup;
  fixup = (struct fixup_layout *)malloc(sizeof(struct fixup_layout));
  if (fixup)
  {
    strcpy(fixup->mathmode,SmathS);
    strcpy(fixup->replacement,replacement);
    fixup->next = fixups;
    fixups = fixup;
  }
  else
  {
      printf("%s (add_fixup)",translate(L_Not_enough_memory));
      getchar();
  };
};

#if  defined(__STDC__) || defined(__cplusplus)

void add_newcommand(char_8bit *cmnd,char_8bit *replacement)
#else
void add_newcommand(cmnd,replacement)
char_8bit *cmnd;
char_8bit *replacement;
#endif
{
  struct newcommand_layout *newcmnd;
  newcmnd = (struct newcommand_layout *)malloc(sizeof(struct newcommand_layout));
  if (newcmnd)
  {
    strcpy(newcmnd->newcommand,cmnd);
    strcpy(newcmnd->replacement,replacement);
    newcmnd->next = newcommands;
    newcommands= newcmnd;
  }
  else
  {
    printf("%s (newcommand)",translate(L_Not_enough_memory));
    getchar();
  };
};

#if  defined(__STDC__) || defined(__cplusplus)

char_8bit *lookup_fixup(char_8bit *SmathS)
#else
char_8bit *lookup_fixup(SmathS)
char_8bit *SmathS;
#endif
{
   struct fixup_layout *curr;
   for (curr = fixups; curr ;curr = curr->next)
     if (strcmp(curr->mathmode,SmathS) == 0)
        return(curr->replacement);
   return(0);
};

#if  defined(__STDC__) || defined(__cplusplus)

char_8bit *lookup_newcommand(char_8bit *cmnd)
#else
char_8bit *lookup_newcommand(cmnd)
char_8bit *cmnd;
#endif
{
   struct newcommand_layout *curr;
   for (curr = newcommands; curr ;curr = curr->next)
     if (strcmp(curr->newcommand,cmnd) == 0)
        return(curr->replacement);
   return(0);
};

#if  defined(__STDC__) || defined(__cplusplus)

char_8bit *readword(FILE *infile)
#else
char_8bit *readword(infile)
FILE *infile;
#endif
{
   static char_8bit wordread[265];
   int wordpos=0;
   static int charclass;
   static int nextcharclass;
   int charin;
   int nchar;
   int at_eof = 0;

   wordread[0] = 0;
   do
   {
     charin = fgetc(infile);

     if ((charin == EOF) || feof(infile))
     {  charin = 0;
        at_eof = 1;
     };

     if (ispunct(charin))  charclass = PUNCT_CHAR;
     else if (isspace(charin))  charclass = SPACE_CHAR;
     else charclass = ALPHANUM_CHAR;
     wordread[wordpos++] = charin;
     wordread[wordpos] = 0;

     nchar = nextchar(infile);
     if (ispunct(nchar))  nextcharclass = PUNCT_CHAR;
     else if (isspace(nchar))  nextcharclass = SPACE_CHAR;
     else nextcharclass = ALPHANUM_CHAR;
   } while ((nextcharclass == charclass) && (!at_eof) && (nchar != EOF));
   return(wordread);
};

#if  defined(__STDC__) || defined(__cplusplus)

void process_appendix(FILE *infile)
#else
void process_appendix(infile)
FILE *infile;
#endif
{
  in_appendix = 1;
  chapternum = 0;
};



/*

  CPI table
                  10Pt    If not avail
  \tiny            17    12
  \scriptsize      17    12
  \footnotesize    17    12
  \small           12    17
  \normalsize      12    10 or 17
  \large           10    8  or 12
  \Large           8.5   10 or 12
  \LARGE           8.5   10 or 12
  \huge            6     8 or 10
  \Huge            5     6 or 8



*/

#define pitch_tiny_on(outfile)
#define pitch_tiny_off(outfile)
#define pitch_small_on(outfile)
#define pitch_small_off(outfile)
#define pitch_normalsize_on(outfile)
#define pitch_normalsize_off(outfile)
#define pitch_large_on(outfile)
#define pitch_large_off(outfile)
#define pitch_Large_on(outfile)
#define pitch_Large_off(outfile)
#define pitch_LARGE_on(outfile)
#define pitch_LARGE_off(outfile)
#define pitch_huge_on(outfile)
#define pitch_huge_off(outfile)
#define pitch_Huge_on(outfile)
#define pitch_Huge_off(outfile)

/* Printer control not yet implemented
#if  defined(__STDC__) || defined(__cplusplus)

void  pitch_tiny_on(FILE *outfile)
#else
void  pitch_tiny_on(outfile)
#endif
{
  if (ES_attribute(ES_17CPION,print_device))
     ES_print_attribute(outfile,ES_17CPION,print_device);
  else
  if (ES_attribute(ES_12CPION,print_device))
     ES_print_attribute(outfile,ES_12CPION,print_device);
};

#if  defined(__STDC__) || defined(__cplusplus)
void  pitch_tiny_off(FILE *outfile)
#else
void  pitch_tiny_off(outfile)
#endif
{
  char *attr;
  if (ES_attribute(ES_17CPIOFF,print_device))
     ES_print_attribute(outfile,ES_17CPIOFF,print_device);
  else
  if (ES_attribute(ES_12CPIOFF,print_device))
     ES_print_attribute(outfile,ES_12CPIOFF,print_device);
};

#define pitch_scriptsize_on(x) pitch_tiny_on(x)
#define pitch_scriptsize_off(x) pitch_tiny_off(x)

#define pitch_footnotesize_on(x) pitch_tiny_on(x)
#define pitch_footnotesize_off(x) pitch_tiny_off(x)

#if  defined(__STDC__) || defined(__cplusplus)
void  pitch_small_on(FILE *outfile)
#else
void  pitch_small_on(outfile)
#endif
{
  if (ES_attribute(ES_12CPION,print_device))
     ES_print_attribute(outfile,ES_12CPION,print_device);
  else
  if (ES_attribute(ES_17CPION,print_device))
     ES_print_attribute(outfile,ES_17CPION,print_device);
};

#if  defined(__STDC__) || defined(__cplusplus)

void  pitch_small_off(FILE *outfile)
#else
void  pitch_small_off(outfile)
#endif
{
  if (ES_attribute(ES_12CPIOFF,print_device))
     ES_print_attribute(outfile,ES_12CPIOFF,print_device);
  else
  if (ES_attribute(ES_17CPIOFF,print_device))
     ES_print_attribute(outfile,ES_17CPIOFF,print_device);
};

#if  defined(__STDC__) || defined(__cplusplus)

void  pitch_normalsize_on(FILE *outfile)
#else
void  pitch_normalsize_on(outfile)
#endif
{
  if (ES_attribute(ES_12CPION,print_device))
     ES_print_attribute(outfile,ES_12CPION,print_device);
  else
  if (ES_attribute(ES_10CPION,print_device))
     ES_print_attribute(outfile,ES_10CPION,print_device);
  else
  if (ES_attribute(ES_17CPION,print_device))
     ES_print_attribute(outfile,ES_17CPION,print_device);
};

#if  defined(__STDC__) || defined(__cplusplus)

void  pitch_normalsize_off(FILE *outfile)
#else
void  pitch_normalsize_off(outfile)
#endif
{
  if (ES_attribute(ES_12CPIOFF,print_device))
     ES_print_attribute(outfile,ES_12CPIOFF,print_device);
  else
  if (ES_attribute(ES_10CPIOFF,print_device))
     ES_print_attribute(outfile,ES_10CPIOFF,print_device);
  else
  if (ES_attribute(ES_17CPIOFF,print_device))
     ES_print_attribute(outfile,ES_17CPIOFF,print_device);
};

#if  defined(__STDC__) || defined(__cplusplus)

void  pitch_large_on(FILE *outfile)
#else
void  pitch_large_on(outfile)
#endif
{
  if (ES_attribute(ES_10CPION,print_device))
     ES_print_attribute(outfile,ES_10CPION,print_device);
  else
  if (ES_attribute(ES_8CPION,print_device))
     ES_print_attribute(outfile,ES_8CPION,print_device);
  else
  if (ES_attribute(ES_12CPION,print_device))
     ES_print_attribute(outfile,ES_12CPION,print_device);
};

#if  defined(__STDC__) || defined(__cplusplus)

void  pitch_large_off(FILE *outfile)
#else
void  pitch_large_off(outfile)
#endif
{
  if (ES_attribute(ES_10CPIOFF,print_device))
     ES_print_attribute(outfile,ES_10CPIOFF,print_device);
  else
  if (ES_attribute(ES_8CPIOFF,print_device))
     ES_print_attribute(outfile,ES_8CPIOFF,print_device);
  else
  if (ES_attribute(ES_12CPIOFF,print_device))
     ES_print_attribute(outfile,ES_12CPIOFF,print_device);
};

#if  defined(__STDC__) || defined(__cplusplus)

void  pitch_Large_on(FILE *outfile)
#else
void  pitch_Large_on(outfile)
#endif
{
  if (ES_attribute(ES_8CPION,print_device))
     ES_print_attribute(outfile,ES_8CPION,print_device);
  else
  if (ES_attribute(ES_10CPION,print_device))
     ES_print_attribute(outfile,ES_10CPION,print_device);
  else
  if (ES_attribute(ES_12CPION,print_device))
     ES_print_attribute(outfile,ES_12CPION,print_device);
};

#if  defined(__STDC__) || defined(__cplusplus)

void  pitch_Large_off(FILE *outfile)
#else
void  pitch_Large_off(outfile)
#endif
{
  if (ES_attribute(ES_8CPIOFF,print_device))
     ES_print_attribute(outfile,ES_8CPIOFF,print_device);
  else
  if (ES_attribute(ES_10CPIOFF,print_device))
     ES_print_attribute(outfile,ES_10CPIOFF,print_device);
  else
  if (ES_attribute(ES_12CPIOFF,print_device))
     ES_print_attribute(outfile,ES_12CPIOFF,print_device);
};

#if  defined(__STDC__) || defined(__cplusplus)

void  pitch_LARGE_on(FILE *outfile)
#else
void  pitch_LARGE_on(outfile)
#endif
{
  if (ES_attribute(ES_8CPION,print_device))
     ES_print_attribute(outfile,ES_8CPION,print_device);
  else
  if (ES_attribute(ES_10CPION,print_device))
     ES_print_attribute(outfile,ES_10CPION,print_device);
  else
  if (ES_attribute(ES_12CPION,print_device))
     ES_print_attribute(outfile,ES_12CPION,print_device);
};

#if  defined(__STDC__) || defined(__cplusplus)
void  pitch_LARGE_off(FILE *outfile)
#else
void  pitch_LARGE_off(outfile)
#endif
{
  if (ES_attribute(ES_8CPIOFF,print_device))
     ES_print_attribute(outfile,ES_8CPIOFF,print_device);
  else
  if (ES_attribute(ES_10CPIOFF,print_device))
     ES_print_attribute(outfile,ES_10CPIOFF,print_device);
  else
  if (ES_attribute(ES_12CPIOFF,print_device))
     ES_print_attribute(outfile,ES_12CPIOFF,print_device);
};


#if  defined(__STDC__) || defined(__cplusplus)
void  pitch_huge_on(FILE *outfile)
#else
void  pitch_huge_on(outfile)
#endif
{
  if (ES_attribute(ES_6CPION,print_device))
     ES_print_attribute(outfile,ES_6CPION,print_device);
  else
  if (ES_attribute(ES_8CPION,print_device))
     ES_print_attribute(outfile,ES_8CPION,print_device);
  else
  if (ES_attribute(ES_10CPION,print_device))
     ES_print_attribute(outfile,ES_10CPION,print_device);
};

#if  defined(__STDC__) || defined(__cplusplus)
void  pitch_huge_off(FILE *outfile)
#else
void  pitch_huge_off(outfile)
#endif
{
  if (ES_attribute(ES_6CPIOFF,print_device))
     ES_print_attribute(outfile,ES_6CPIOFF,print_device);
  else
  if (ES_attribute(ES_8CPIOFF,print_device))
     ES_print_attribute(outfile,ES_8CPIOFF,print_device);
  else
  if (ES_attribute(ES_10CPIOFF,print_device))
     ES_print_attribute(outfile,ES_10CPIOFF,print_device);
};


#if  defined(__STDC__) || defined(__cplusplus)
void  pitch_Huge_on(FILE *outfile)
#else
void  pitch_Huge_on(outfile)
#endif
{
  if (ES_attribute(ES_5CPION,print_device))
     ES_print_attribute(outfile,ES_5CPION,print_device);
  else
  if (ES_attribute(ES_6CPION,print_device))
     ES_print_attribute(outfile,ES_6CPION,print_device);
  else
  if (ES_attribute(ES_8CPION,print_device))
     ES_print_attribute(outfile,ES_8CPION,print_device);
};

#if  defined(__STDC__) || defined(__cplusplus)
void  pitch_Huge_off(FILE *outfile)
#else
void  pitch_Huge_off(outfile)
#endif
{
  if (ES_attribute(ES_5CPIOFF,print_device))
     ES_print_attribute(outfile,ES_5CPIOFF,print_device);
  else
  if (ES_attribute(ES_6CPIOFF,print_device))
     ES_print_attribute(outfile,ES_6CPIOFF,print_device);
  else
  if (ES_attribute(ES_8CPIOFF,print_device))
     ES_print_attribute(outfile,ES_8CPIOFF,print_device);
};

*/

#if  defined(__STDC__) || defined(__cplusplus)
void toc_page_line(int page_num)
#else
void toc_page_line(page_num)
int page_num;
#endif
{
   int c;
   char numstr[10];
   tocline[tocline_pos] = 0;
   sprintf(numstr,"%d",page_num);
   for (c = 0; c < left_margin; c++)
      fputc(' ',tocfile);
   fprintf(tocfile,"%s",tocline);
   for (c = 0;
        (c < line_width) && (c < (line_width - (strlen(tocline) + strlen(numstr))));
        c++)
     fputc('.',tocfile);
   fprintf(tocfile,"%s\n",numstr);
   tocline_pos = 0;
#ifdef VERBOSE
  printf("%s\n",tocline);
#endif
};


#if  defined(__STDC__) || defined(__cplusplus)
void paragraph_begin(void)
#else
void paragraph_begin()
#endif
{
  if (HTML())
    add_chars(" <P>");
  else
  {
    process_newline();
    process_newline();
  };
}

#if  defined(__STDC__) || defined(__cplusplus)
void paragraph_end(void)
#else
void paragraph_end()
#endif
{
  if (HTML())
    add_chars(" </P>");
  else
  {
    process_newline();
    process_newline();
  };
}

#if  defined(__STDC__) || defined(__cplusplus)
void process_part(FILE *infile)
#else
void process_part(infile)
FILE *infile;
#endif
{
  char_8bit outline[256];
  partnum += 1;

/*  ES_print_attribute(tocfile,ES_boldON,print_device); */
  paragraph_end();

  print_page_num(output_file);


  if (nextchar(infile) == '*')
  {
      sprintf(outline,"%s",translate(L_Part));
      sprintf(tocline,"\n");
  }
  else
  {
     sprintf(outline,"%s %d",translate(L_Part),partnum);
     sprintf(tocline,"\n%d ",partnum);
  };

  if (HTML()) add_chars(" <H1>");
  else pitch_Huge_on(output_file);
  add_chars(outline);
  if (HTML()) add_chars(" </H1>");
  else pitch_Huge_off(output_file);

  process_newline();
  process_newline();

 indentlevel = 0;
  sectionnum = 0;
  subsectionnum = 0;
  subsubsectionnum = 0;

  fscanf(infile,"{");
  tocline_pos = strlen(tocline);
  if (HTML()) add_chars(" <H1>");
  else pitch_Huge_on(output_file);
  process_minienvironment(infile,environ_stack[environ_SP]);
  if (HTML()) add_chars(" </H1>");
  else pitch_Huge_off(output_file);
  toc_page_line(page_num);
  paragraph_begin();

/*   ES_print_attribute(tocfile,ES_boldOFF,print_device); */
}
#if  defined(__STDC__) || defined(__cplusplus)
void process_chapter(FILE *infile)
#else
void process_chapter(infile)
FILE *infile;
#endif
{
  char_8bit outline[256];

  chapternum += 1;
  paragraph_end();

  print_page_num(output_file);

  if (in_appendix)
     if (nextchar(infile) == '*')
     {
        sprintf(outline,"%s",translate(L_Appendix));
        sprintf(tocline,"\n%s ",translate(L_Appendix));
     }
     else
     {
        sprintf(outline,"%s %c",translate(L_Appendix),chapternum+'A'-1);
        sprintf(tocline,"\n%s %c ",translate(L_Appendix),chapternum+'A'-1);
     }
  else
     if (nextchar(infile) == '*')
     {
         sprintf(outline,"%s",translate(L_Chapter));
         sprintf(tocline,"\n");
     }
     else
     {
        sprintf(outline,"%s %d",translate(L_Chapter),chapternum);
        sprintf(tocline,"\n%-3d ",chapternum);
     };

  if (HTML()) add_chars(" <H2>");
  else pitch_Huge_on(output_file);
  add_chars(outline);
  if (HTML()) add_chars(" </H2>");
  else pitch_Huge_off(output_file);

  process_newline();
  process_newline();

  indentlevel = 0;
  sectionnum = 0;
  subsectionnum = 0;
  subsubsectionnum = 0;
  equationnum = 0;
  tablenum = 0;
  fscanf(infile,"{");
  tocline_pos = strlen(tocline);
  if (HTML()) add_chars(" <H2>");
  else pitch_Huge_on(output_file);
  process_minienvironment(infile,environ_stack[environ_SP]);
  if (HTML()) add_chars(" </H2>");
  else pitch_Huge_off(output_file);
  toc_page_line(page_num);
  paragraph_begin();
  /* Moved to pb
  process_newline();
  process_newline();
  */
};

#if  defined(__STDC__) || defined(__cplusplus)
void process_section(FILE *infile)
#else
void process_section(infile)
FILE *infile;
#endif
{
  char_8bit outline[256];

  sectionnum += 1;
  paragraph_end();
  /* moved to paragraph end
  process_newline();
  process_newline();
  */
  if (HTML()) add_chars(" <H3>");
  else pitch_Large_on(output_file);

  if (nextchar(infile) != '*')
  {
    if (chapternum)
    {
     sprintf(outline,"%d.%d ",chapternum,sectionnum);
     sprintf(tocline,"   %d.%-3d ",chapternum,sectionnum);
    }
    else
    {
     sprintf(outline,"%d ",sectionnum);
     sprintf(tocline,"   %-3d ",sectionnum);
    }
    add_chars(outline);
  }
  indentlevel = 0;
  subsectionnum = 0;
  subsubsectionnum = 0;
  fscanf(infile,"{");
  tocline_pos = strlen(tocline);
  process_minienvironment(infile,environ_stack[environ_SP]);
  if (HTML()) add_chars(" </H3>");
  else pitch_Large_off(output_file);
  toc_page_line(page_num);
  paragraph_begin();
}
#if  defined(__STDC__) || defined(__cplusplus)
void process_subsection(FILE *infile)
#else
void process_subsection(infile)
FILE *infile;
#endif
{
  char_8bit outline[256];

  subsectionnum += 1;
  paragraph_end();

  if (HTML()) add_chars(" <H4>");
  else pitch_large_on(output_file);

  if (nextchar(infile) != '*')
  {
    if (chapternum)
    {
     sprintf(outline,"%d.%d.%d ",chapternum,sectionnum,subsectionnum);
     sprintf(tocline,"      %d.%d.%-3d ",chapternum,sectionnum,subsectionnum);
    }
    else
    {
     sprintf(outline,"%d.%d ",sectionnum,subsectionnum);
     sprintf(tocline,"      %d.%-3d ",sectionnum,subsectionnum);
    }
    add_chars(outline);
  };
  indentlevel = 0;
  subsubsectionnum = 0;
  fscanf(infile,"{");
  tocline_pos = strlen(tocline);
  process_minienvironment(infile,environ_stack[environ_SP]);
  toc_page_line(page_num);
  if (HTML()) add_chars(" </H4>");
  else pitch_large_off(output_file);
  paragraph_begin();
  /* Moved to pb
  process_newline();
  process_newline();
  */
}

#if  defined(__STDC__) || defined(__cplusplus)
void process_subsubsection(FILE *infile)
#else
void process_subsubsection(infile)
FILE *infile;
#endif
{
  char_8bit outline[256];

  subsubsectionnum += 1;

  paragraph_end();
  /* moved to paragraph end
  process_newline();
  process_newline();
  */

  if (HTML()) add_chars(" <H5>");
  else pitch_large_on(output_file);
  if (nextchar(infile) != '*')
  {
    sprintf(outline,"%d.%d.%d.%d ",chapternum,sectionnum,subsectionnum,subsubsectionnum);
    sprintf(tocline,"         %d.%d.%d.%-3d ",chapternum,sectionnum,subsectionnum,subsubsectionnum);
    add_chars(outline);
  };
  indentlevel = 0;
  fscanf(infile,"{");
  tocline_pos = strlen(tocline);
  process_minienvironment(infile,environ_stack[environ_SP]);
  toc_page_line(page_num);
  if (HTML()) add_chars(" </H5>");
  else pitch_large_off(output_file);
  paragraph_begin();
  /* Moved to paragraph_begin
  process_newline();
  process_newline();
  */
}
#if  defined(__STDC__) || defined(__cplusplus)
void process_paragraph(FILE *infile)
#else
void process_paragraph(infile)
FILE *infile;
#endif
{
  fscanf(infile,"{");
  paragraph_begin();
  if (HTML()) add_chars(" <H6>");
  process_minienvironment(infile,environ_stack[environ_SP]);
  if (HTML()) add_chars(" <H6>");
  paragraph_end();
};

#if  defined(__STDC__) || defined(__cplusplus)
void process_subparagraph(FILE *infile)
#else
void process_subparagraph(infile)
FILE *infile;
#endif
{
  fscanf(infile,"{");
  paragraph_begin();
  process_minienvironment(infile,environ_stack[environ_SP]);
  paragraph_end();
};
/*
 If the following commands are encountered,
 the remainder of the line is ignored.
*/
char_8bit *ignore_line_commands[]=
{
  "addtocounter",
  "addtolength",
  "documentstyle",
  "includeonly",
  "hfill",
  "hspace",
  "kill",
  "linebreak",
  "maketitle",
  "newenvironment",
  "newlength",
  "newtheorem",
  "nolinebreak",
  "nopagebreak",
  "pagebreak",
  "pagenumbering",
  "pagestyle",
  "parbox",
  "parindent",
  "parskip",
  "newsavebox",
  "samepage",
  "setcounter",
  "setlength",
  "settowidth",
  "sloppy",
  "usebox",
  "vspace",
  "=",
  ">",
  "-",
  NULL
};
/*
 If the following commands are encountered,
 the text between the following { and the matching } is ignored
*/
char_8bit *ignore_environment_commands[]=
{
  "title",
  "author",
  "bibliographystyle", /* We ignore this because we use the bbl file which
                          should have already incorporated the bibliographystyle */
  NULL
};

/* If the following commands are encountered,
  the text between the { and the matching } is printed, enclosed in ().
*/
char_8bit *ignore_command_commands[]=
{
  "mbox",
  "makebox",
  "fbox",
  "framebox",
  NULL
};
/*
 If the following begin blocks are encountered,
 The text to the matching \end{...} is ignored.
*/
char_8bit *ignore_blocks[]=
{
  "eqnarray",
  "equation",
  "array",
  "tabular",
  "figure",
  "table",
  "picture",
  NULL
};

/* If the following begin blocks are encountered,
 the command is ignored.  The remainder of the line is also ignored.
*/
char_8bit *ignore_block_commands[]=
{  "minipage",
   "sloppypar",
   NULL
};

#if  defined(__STDC__) || defined(__cplusplus)
void process_begin_quote(FILE *infile)
#else
void process_begin_quote(infile)
FILE *infile;
#endif
{
};
#if  defined(__STDC__) || defined(__cplusplus)
void process_end_quote(FILE *infile)
#else
void process_end_quote(infile)
FILE *infile;
#endif
{
};
#if  defined(__STDC__) || defined(__cplusplus)
void process_begin_document(FILE *infile)
#else
void process_begin_document(infile)
FILE *infile;
#endif
{
  add_char(TOC_MARKER);
  add_char(BEGIN_DOC_MARKER);
};
#if  defined(__STDC__) || defined(__cplusplus)
void process_end_document(FILE *infile)
#else
void process_end_document(infile)
FILE *infile;
#endif
{
  AT_END = 1;
};

#if  defined(__STDC__) || defined(__cplusplus)
int ignore(char_8bit *wordstr,char_8bit *wordlist[])
#else
int ignore(wordstr,wordlist)
char_8bit *wordstr;
char_8bit *wordlist[];
#endif
{
   int i;
   for (i = 0; wordlist[i] != NULL; i++)
      if (strcmp(wordstr,wordlist[i]) == 0) return(1);
   return(0);
};
#if  defined(__STDC__) || defined(__cplusplus)
void ignore_block(FILE *infile,char_8bit *block_kind)
#else
void ignore_block(infile,block_kind)
FILE *infile;
char_8bit *block_kind;
#endif
{
   char_8bit linein[256];
   char_8bit matchend[50];
   char_8bit matchbegin[50];
   int stackcount=1;
   int atend = 0;
   int old_in_table;
   int old_in_equation;

   old_in_table = in_table;
   old_in_equation = in_equation;

   sprintf(matchend,"\\end{%s}",block_kind);
   sprintf(matchbegin,"\\begin{%s}",block_kind);

   if (strcmp(block_kind,"table") == 0)
      in_table = 1;

   if (strcmp(block_kind,"equation") == 0)
      in_equation = 1;

   while (!atend)
   {
     fgets(linein,255,infile);
     if (linein[0] != '%')
     {
        if (strstr((char *)linein,(char *)matchbegin))
           stackcount += 1;

        if (strstr((char *)linein,(char *)matchend))
        {
           stackcount -= 1;
           if (stackcount == 0) atend = 1;
        };
        if (strstr((char *)linein,"\\label"))
        {
          char *linechar;
          char_8bit name[80];
          int namepos=0;
/*
          sscanf(linein,"\\label{%s}",name);
          add_label(name);
             if (in_equation) equationnum += 1;
             if (in_table) tablenum += 1;
*/
          linechar = strstr((char *)linein,"\\label") + 7;
          if (strstr((char *)linein,"%") > linechar)
          {
             while (*linechar != '}')
             {
                name[namepos++] = *linechar;
                linechar += 1;
             };
             name[namepos] = 0;
             add_label(name);
             if (in_equation) equationnum += 1;
             if (in_table) tablenum += 1;
          };
        };
     };
   };
   in_table = old_in_table;
   in_equation = old_in_equation;
};

#if  defined(__STDC__) || defined(__cplusplus)
void process_begin_quotation(FILE *infile)
#else
void process_begin_quotation(infile)
FILE *infile;
#endif
{
  indentlevel += 1;
  rightmargin -= INDENTATION;

  if (HTML()) fprintf(output_file," <blockquote>\n");

};

#if  defined(__STDC__) || defined(__cplusplus)
void process_end_quotation(FILE *infile)
#else
void process_end_quotation(infile)
FILE *infile;
#endif
{
  indentlevel -= 1;
  rightmargin += INDENTATION;
  if (HTML()) fprintf(output_file," </blockquote>\n");
};

#if  defined(__STDC__) || defined(__cplusplus)
void process_begin_center(FILE *infile)
#else
void process_begin_center(infile)
FILE *infile;
#endif
{
  in_center = 1;
};
#if  defined(__STDC__) || defined(__cplusplus)
void process_end_center(FILE *infile)
#else
void process_end_center(infile)
FILE *infile;
#endif
{ in_center = 0;
};

#if  defined(__STDC__) || defined(__cplusplus)
void process_begin_abstract(FILE *infile)
#else
void process_begin_abstract(infile)
FILE *infile;
#endif
{
  process_newpage();
  process_newline();

  /* There should be no paragraphs before this */

  if (HTML()) add_chars(" <H3>");
  else pitch_Large_on(output_file);
  add_chars(translate(L_Abstract));
  if (HTML()) add_chars(" <H3>");
  else pitch_Large_off(output_file);
  paragraph_begin();
};

#if  defined(__STDC__) || defined(__cplusplus)
void process_end_abstract(FILE *infile)
#else
void process_end_abstract(infile)
FILE *infile;
#endif
{
  paragraph_end();
};

#if  defined(__STDC__) || defined(__cplusplus)
void process_begin_verbatim(FILE *infile)
#else
void process_begin_verbatim(infile)
FILE *infile;
#endif
{
  char_8bit outline[256];
  int atend = 0;

  if (HTML())
     fprintf(output_file," <listing>\n");
  while (!atend)
  {
     fgets(outline,255,infile);
     atend = feof(infile);
     if (strstr((char *)outline,"\\end{verbatim}"))
        atend=1;
     else
     {
       outline[strlen(outline)-1] = 0;
       fprintf(output_file,"%s\n",outline);
       line_num += 1;
       check_page_break(output_file);
     };
  };
};

#if  defined(__STDC__) || defined(__cplusplus)
void process_end_verbatim(FILE *infile)
#else
void process_end_verbatim(infile)
FILE *infile;
#endif
{
  if (HTML())
     fprintf(output_file," </listing>\n");
 /*  should already be taken care of by process_begin_verbatim */
};

#if  defined(__STDC__) || defined(__cplusplus)
void process_begin_itemize(FILE *infile)
#else
void process_begin_itemize(infile)
FILE *infile;
#endif
{
  dumpline();
  list_level += 1;
  indentlevel += 2;
  list_kind[list_level] = ITEMIZE_LIST;
  if (HTML()) add_chars(" <ul> ");
};

#if  defined(__STDC__) || defined(__cplusplus)
void process_end_list(FILE *infile)
#else
void process_end_list(infile)
FILE *infile;
#endif
{
  dumpline();
  list_level -= 1;
  indentlevel -= 2;
};

#if  defined(__STDC__) || defined(__cplusplus)
void process_end_itemize(FILE *infile)
#else
void process_end_itemize(infile)
FILE *infile;
#endif
{
  process_end_list(infile);
  if (HTML()) add_chars(" </ul> ");
};
#if  defined(__STDC__) || defined(__cplusplus)
void process_begin_enumerate(FILE *infile)
#else
void process_begin_enumerate(infile)
FILE *infile;
#endif
{
  dumpline();
  list_level += 1;
  indentlevel += 2;
  list_count[list_level] = 0;
  list_kind[list_level] = ENUMERATE_LIST;
  if (HTML()) add_chars(" <ol> ");
};

#if  defined(__STDC__) || defined(__cplusplus)
void process_end_enumerate(FILE *infile)
#else
void process_end_enumerate(infile)
FILE *infile;
#endif
{
  process_end_list(infile);
  if (HTML()) add_chars(" </ol> ");
};


#if  defined(__STDC__) || defined(__cplusplus)
void process_begin_description(FILE *infile)
#else
void process_begin_description(infile)
FILE *infile;
#endif
{
  dumpline();
  list_level += 1;
  indentlevel += 2;
  list_kind[list_level] = DESCRIPTION_LIST;
  if (HTML()) add_chars(" <dl> ");
};
#if  defined(__STDC__) || defined(__cplusplus)
void process_end_description(FILE *infile)
#else
void process_end_description(infile)
FILE *infile;
#endif
{
  process_end_list(infile);
  if (HTML()) add_chars(" </dl> ");
};

#if  defined(__STDC__) || defined(__cplusplus)
void process_begin_thebibliography(FILE *infile)
#else
void process_begin_thebibliography(infile)
FILE *infile;
#endif
{
  char tabulation[256];
  fscanf(infile,"{%s}",tabulation);
  bibliography_indentlevel = strlen(tabulation)/INDENTATION;

  paragraph_end();

  if (HTML()) add_chars(" <H2>");
  else pitch_Huge_on(output_file);
  add_chars(translate(L_Bibliography));
  if (HTML()) add_chars(" </H2>");
  else pitch_Huge_off(output_file);

  if (HTML()) add_chars(" <dl> ");
  else process_newline();
  indentlevel = 0;
  list_kind[list_level] = BIBLIOGRAPHY_LIST;
  in_bibliography = 1;

};

#if  defined(__STDC__) || defined(__cplusplus)
void process_begin_theindex(FILE *infile)
#else
void process_begin_theindex(infile)
FILE *infile;
#endif
{
  process_newpage();
  process_newline();
  if (HTML()) add_chars(" <H2>");
  else pitch_Huge_on(output_file);

  add_chars(translate(L_Index));

  if (HTML()) add_chars(" </H2>");
  else pitch_Huge_off(output_file);

  if (HTML()) add_chars(" <dl> ");
  else process_newline();
  indentlevel = 0;
  list_kind[list_level] = INDEX_LIST;
};

#if  defined(__STDC__) || defined(__cplusplus)
void process_end_thebibliography(FILE *infile)
#else
void process_end_thebibliography(infile)
FILE *infile;
#endif
{
  process_end_list(infile);
  if (HTML()) add_chars(" </dl> ");

  in_bibliography = 0;
  indentlevel = 0;
};

#if  defined(__STDC__) || defined(__cplusplus)
void process_end_theindex(FILE *infile)
#else
void process_end_theindex(infile)
FILE *infile;
#endif
{
  process_end_list(infile);
  if (HTML()) add_chars(" </dl> ");

  indentlevel = 0;
};

#if  defined(__STDC__) || defined(__cplusplus)
void process_bibliography(FILE *infile)
#else
void process_bibliography(infile)
FILE *infile;
#endif
{
  process_input(infile,EXT_BBL);
};

static char_8bit last_topic[256] = "";
#if  defined(__STDC__) || defined(__cplusplus)
void process_link_label(FILE *infile,int prev_next)
#else
void process_link_label(infile,prev_next)
FILE *infile;
int prev_next;
#endif
{
  char_8bit wordread[256];

  if (fscanf(infile,"{%[^}]}",wordread))
  {
    add_label(wordread);
    dumpline();
    switch (textreader)
    { case TR_TURBOVISION :
      {if (prev_next)
          fprintf(output_file,"\n\n{>>>%s<<<:%s}",translate(L_Next_topic),wordread);
       fprintf(output_file,"\n\n.topic %s\n",wordread);
       if ((strcmp(last_topic,"") != 0) && prev_next)
          fprintf(output_file,"{>>>%s<<<:%s}\n\n",translate(L_Prev_topic),last_topic);
      }
      break;
      case TR_HTML : case TR_HTMLPLUS :
      {
        /*  HTML already has Prev and next builtin */
        fprintf(output_file," <A NAME=\"%s\"> </A>\n",wordread
            /* Here we could also put the label of the section name */);
      }
      break;
    };
    strcpy(last_topic,wordread);
  };
};
/* Not implemented yet
#if  defined(__STDC__) || defined(__cplusplus)
void process_documentstyle(FILE *infile)
#else
void process_documentstyle(infile)
FILE *infile;
#endif
{
}
*/
#if  defined(__STDC__) || defined(__cplusplus)
void process_number_label(FILE *infile)
#else
void process_number_label(infile)
FILE *infile;
#endif
{
  char_8bit wordread[256];
  int wordpos=0;
  int inchar;

  while ((inchar = fgetc(infile)) != '{');
  while ((inchar = fgetc(infile)) != '}')
      wordread[wordpos++] = inchar;
  wordread[wordpos] = 0;

  add_label(wordread);
};

#if  defined(__STDC__) || defined(__cplusplus)
void process_item(FILE *infile)
#else
void process_item(infile)
FILE *infile;
#endif
{
  int first_bracket_found = 0;
  int charin;

  dumpline();
  if ((list_kind[list_level] == BIBLIOGRAPHY_LIST) ||
      (list_kind[list_level] == INDEX_LIST))
  {
    indentlevel = 0;
    inc_indentlevel_after_line = 1;
  }
  else
  {
    indentlevel -= 1;
    inc_indentlevel_after_line = 1;
  };
  switch (list_kind[list_level])
  {
    case DESCRIPTION_LIST :
         if (HTML()) add_chars(" <dt>");
         while (!first_bracket_found && ((charin = fgetc(infile)) != EOF))
                first_bracket_found= charin == '[';
         in_brackets = 1;
         process_text(infile);
         break;
    case BIBLIOGRAPHY_LIST :
       {
         add_char_buffer_mode = 1;
         add_char_bufferpos = 0;

         indentlevel = 0;

         if (HTML()) add_chars(" <dt>");
         while (!first_bracket_found && ((charin = fgetc(infile)) != EOF))
                first_bracket_found= charin == '[';
         in_brackets = 1;
         process_text(infile);
         add_char_buffer_mode = 0;
         process_link_label(infile,NO_PREV_NEXT);
         add_chars("[");
         add_chars(add_char_buffer);
         add_chars("] ");
       };
         break;
    case INDEX_LIST :
         if (HTML()) add_chars(" <li>");
         break;
    case ENUMERATE_LIST :
        { char_8bit countstr[5];
         list_count[list_level] += 1;
         if (HTML()) add_chars(" <li>");
         else
         {sprintf(countstr,"%d. ",list_count[list_level]);
          add_chars(countstr);
         };
        };
        break;
    case ITEMIZE_LIST :
         if (HTML()) add_chars(" <li>");
         else
         { add_chars(UCSCU_char(bullets[list_level]));
           add_char(' ');
         };
         break;
  };
};

#if  defined(__STDC__) || defined(__cplusplus)
void process_subitem(int level)
#else
void process_subitem(level)
int level;
#endif
{
  int i,j;
  process_newline();
  for (j = 0; j < level; j++)
    for (i = 0; i < INDENTATION; i++)
      add_char(HARD_SPACE);
};

#if  defined(__STDC__) || defined(__cplusplus)
void process_begin(FILE *infile)
#else
void process_begin(infile)
FILE *infile;
#endif
{
  int charin;
  char_8bit *wordread;

  charin = fgetc(infile);
  wordread = readword(infile);
  charin = fgetc(infile);
  if (ignore(wordread,ignore_blocks))
      {ignore_block(infile,wordread); return;};

  if (strcmp(wordread,"quote") == 0)      {process_begin_quote(infile); return;};
  if (strcmp(wordread,"quotation") == 0)  {process_begin_quotation(infile); return;};
  if (strcmp(wordread,"center") == 0)     {process_begin_center(infile); return;};
  if (strcmp(wordread,"abstract") == 0)   {process_begin_abstract(infile); return;};
  if (strcmp(wordread,"verbatim") == 0)   {process_begin_verbatim(infile); return;};
  if (strcmp(wordread,"itemize") == 0)    {process_begin_itemize(infile);  return;};
  if (strcmp(wordread,"enumerate") == 0)  {process_begin_enumerate(infile); return;};
  if (strcmp(wordread,"description") == 0){process_begin_description(infile); return;};
  if (strcmp(wordread,"thebibliography") == 0){process_begin_thebibliography(infile); return;};
  if (strcmp(wordread,"document") == 0)   {process_begin_document(infile); return;};
  if (strcmp(wordread,"theindex") == 0)   {process_begin_theindex(infile); return;};
};

#if  defined(__STDC__) || defined(__cplusplus)
void process_end(FILE *infile)
#else
void process_end(infile)
FILE *infile;
#endif
{
  char_8bit *wordread;

  fgetc(infile);  /* throw away left paren */
  wordread = readword(infile);
  fgetc(infile);  /* throw away right paren */
  if (strcmp(wordread,"quote") == 0)      {process_end_quote(infile); return;};
  if (strcmp(wordread,"quotation") == 0)  {process_end_quotation(infile); return;};
  if (strcmp(wordread,"center") == 0)     {process_end_center(infile); return;};
  if (strcmp(wordread,"verbatim") == 0)   {process_end_verbatim(infile); return;;};
  if (strcmp(wordread,"abstract") == 0)   {process_end_abstract(infile); return;;};
  if (strcmp(wordread,"itemize") == 0)    {process_end_itemize(infile);  return;};
  if (strcmp(wordread,"enumerate") == 0)  {process_end_enumerate(infile); return;};
  if (strcmp(wordread,"description") == 0){process_end_description(infile); return;};
  if (strcmp(wordread,"thebibliography") == 0){process_end_thebibliography(infile); return;};
  if (strcmp(wordread,"document") == 0)   {process_end_document(infile); return;};
  if (strcmp(wordread,"theindex") == 0)   {process_end_theindex(infile); return;};
};

#if  defined(__STDC__) || defined(__cplusplus)
void ignore_line(FILE *infile)
#else
void ignore_line(infile)
FILE *infile;
#endif
{
  char_8bit junk[256];
  fgets(junk,255,infile);
};

#if  defined(__STDC__) || defined(__cplusplus)
char *read_environment(FILE *infile)
#else
char *read_environment(infile)
FILE *infile;
#endif
{
  int bracecount = 0;
  int first_brace_found =0;
  int charin;
  int at_eof = 0;

  static char envstr[256];
  int envpos = 0;

  while (!first_brace_found && ((charin = fgetc(infile)) != EOF))
      first_brace_found = charin == '{';
  if ((charin == EOF) || feof(infile))
  {
    at_eof = 1;
    return(0);
  };
  bracecount = 1;
  while (bracecount && !at_eof)
  {
    charin = fgetc(infile);
    if (feof(infile))
       at_eof = 1;
    switch (charin)
    { case '%' : fscanf(infile,"\n"); break;     /* skip over comments */
      case '\\' : charin = fgetc(infile); break; /* skip over \}  */
      case '{' : bracecount += 1; break;
      case '}' : bracecount -= 1; break;
      case EOF :
        at_eof = 1; return(envstr); /*break;*/
    };
    if ((charin != '%') && (envpos < 255))
    { envstr[envpos++] = charin;
      envstr[envpos] = 0;
    };
  };
  return(envstr);
};

#if  defined(__STDC__) || defined(__cplusplus)
void ignore_command(FILE *infile)
#else
void ignore_command(infile)
FILE *infile;
#endif
{
   fscanf(infile,"{");
   add_char('(');
   process_text(infile);
   add_char(')');
};
#if  defined(__STDC__) || defined(__cplusplus)
void add_accent_character(FILE *infile,char_8bit accent)
#else
void add_accent_character(infile,accent)
FILE *infile;
char_8bit accent;
#endif
{
  char accent_coding[10];
  int accent_pos = 1;
  int i;
  char_8bit char_to_accent;

  accent_coding[0] = accent;

  char_to_accent = fgetc(infile);
  accent_coding[accent_pos++] = char_to_accent;
  if (char_to_accent == '{')
  {
    while ((char_to_accent = fgetc(infile)) != '}')
    {
      accent_coding[accent_pos++] = char_to_accent;
    };
    accent_coding[accent_pos++] = '}';
  };
  accent_coding[accent_pos] = 0;

  for (i = 0; UCSCU_TeX_table[i].symbol != UCSCU_END_TABLE;i++)
     if (strcmp(UCSCU_TeX_table[i].TeX, accent_coding) == 0)
     if (HTML())
        add_chars(UCSCU_lookup_code_HTML(UCSCU_TeX_table[i].symbol));
     else
        add_chars(UCSCU_char(UCSCU_TeX_table[i].symbol));
};

#if  defined(__STDC__) || defined(__cplusplus)
void process_footnote(FILE *infile)
#else
void process_footnote(infile)
FILE *infile;
#endif
{
   footnote_index += 1;
};


#define REFERENCE 1
#define CITATION  2

#if  defined(__STDC__) || defined(__cplusplus)
void process_ref(FILE *infile,int linkkind)
#else
void process_ref(infile,linkkind)
FILE *infile;
int linkkind;
#endif
{
  char_8bit linkstr[256];
  char_8bit linklabel[256];
  int linklabelpos = 0;
  struct label_layout *label;
  int inchar;

  while ((inchar = fgetc(infile)) != '{');
  while ((inchar = fgetc(infile)) != '}')
  { linklabel[linklabelpos++] = inchar;
    linklabel[linklabelpos] = 0;
  };

  label = lookup_label(linklabel);

  if (label)
     add_chars(label->enumeration);
  else
  {
     add_char(START_REF_MARKER);
     add_chars(linklabel);
     add_char(END_REF_MARKER);
  };

  if (build_label)
  switch (textreader)
  { case TR_TURBOVISION :
    {
      sprintf(linkstr," {>>>%s<<<:%s}",
         linkkind == REFERENCE ? translate(L_Read_topic) :
            translate(L_Read_biblio),linklabel);
      add_chars(linkstr);
    };
    break;
    case TR_HTML : case TR_HTMLPLUS :
    {
      sprintf(linkstr," <a href=\"#%s\"> %s %s</a>",linklabel,
         label->enumeration,"" /* eventually label description here*/ );
      add_chars(linkstr);
    }
    break;
  };
  build_label = 0;
};

#if  defined(__STDC__) || defined(__cplusplus)
void process_makeindex(void)
#else
void process_makeindex()
#endif
{
  makeindex = 1;
};

#if  defined(__STDC__) || defined(__cplusplus)
void process_tableofcontents(void)
#else
void process_tableofcontents()
#endif
{
  tableofcontents = 1;
  if (HTML()) add_chars(" <H2>");
  else pitch_Huge_on(output_file);
  fprintf(tocfile,"%s\n\n",translate(L_Contents));
  if (HTML()) add_chars(" </H2>");
  else pitch_Huge_off(output_file);
};

#if  defined(__STDC__) || defined(__cplusplus)
void process_index(FILE *infile)
#else
void process_index(infile)
FILE *infile;
#endif
{
  char_8bit wordread[256];
  if (fscanf(infile,"{%[^}]}",wordread))
  {
    fprintf(idxfile,"%d %s\n",page_num,wordread);
  };
};

#if  defined(__STDC__) || defined(__cplusplus)
void process_newcommand(FILE *infile)
#else
void process_newcommand(infile)
FILE *infile;
#endif
{
  char_8bit newcmnd[256];
  int bracelevel = 0;
  int newcmndpos= 0;
  char_8bit replacement[256];
  int replacementpos =0;
  int inchar;

  while ((inchar = fgetc(infile)) != '{');
  while ((inchar = fgetc(infile)) != 92);   /* Backslash */
  while (((inchar = fgetc(infile)) != '}') || bracelevel)
  {
    if (inchar == '{') bracelevel += 1;
    if (inchar == '}') bracelevel -= 1;
    newcmnd[newcmndpos++] = inchar;
  };
  newcmnd[newcmndpos] = 0;
  bracelevel = 0;
  while ((inchar = fgetc(infile)) != '{');
  while (((inchar = fgetc(infile)) != '}') || bracelevel)
  {
    if (inchar == '{') bracelevel += 1;
    if (inchar == '}') bracelevel -= 1;
    replacement[replacementpos++] = inchar;
  };
  replacement[replacementpos] = 0;

  add_newcommand(newcmnd,replacement);
};

#if  defined(__STDC__) || defined(__cplusplus)
void process_font(FILE *infile,int font)
#else
void process_font(infile,font)
FILE *infile;
int font;
#endif
{
  int charin;
  if (HTML())
  switch (font)
  {
     case bf_FONT : add_chars(" <b> "); break;
     case em_FONT : add_chars(" <em> "); break;
     case it_FONT : add_chars(" <i> "); break;
     case sl_FONT : add_chars(" <i> "); break;
     case tt_FONT : add_chars(" <code> "); break;
     case underline_FONT : add_chars(" <u> ");break;
     /*case rm_FONT : add_chars(" <> "); break; */
     /*case sf_FONT : add_chars(" <> "); break;
     /*case sc_FONT : add_chars(" <> "); break; */
  };
 if (nextchar(infile) == '{')
  {
    struct environment_layout *temp_environ;
    temp_environ = new_environment(
       environ_stack[environ_SP]->font,
       environ_stack[environ_SP]->type,
       environ_stack[environ_SP]->flags,
       environ_stack[environ_SP]->indent,
       environ_stack[environ_SP]->pref_width,
       environ_stack[environ_SP]->pref_length,
       environ_stack[environ_SP]->act_width,
       environ_stack[environ_SP]->num_lines
       );
    environ_stack[++environ_SP] = temp_environ;
    temp_environ->font = font;
    charin = fgetc(infile); /* read the { */

    if (!((charin == EOF) || feof(infile)))
       process_minienvironment(infile,temp_environ);

    free(environ_stack[environ_SP--]);
  }
  else
  { charin = fgetc(infile); /* read the space after the font tag */
    environ_stack[environ_SP]->font = font;
  }
};

#if  defined(__STDC__) || defined(__cplusplus)
void process_tex(FILE *infile)
#else
void process_tex(infile)
FILE *infile;
#endif
{
  char_8bit *wordread;
  char_8bit *newcmnd_replacement;
  wordread = readword(infile);

  if (ignore(wordread,ignore_line_commands))
     {ignore_line(infile);        return;};
  if (ignore(wordread,ignore_environment_commands))
     {read_environment(infile); return;};
  if (ignore(wordread,ignore_command_commands))
     {ignore_command(infile);     return;};


/* ACCENTS */
  if (wordread[0]=='"') {add_accent_character(infile,'"'); return;};
  if (wordread[0]=='`') {add_accent_character(infile,'`'); return;};
  if (wordread[0]==39)  {add_accent_character(infile,39); return;};
  if (wordread[0]=='^') {add_accent_character(infile,'^'); return;};
  if (wordread[0]=='~') {add_accent_character(infile,'~'); return;};
  if (wordread[0]=='=') {add_accent_character(infile,'='); return;};
  if (wordread[0]=='.') {add_accent_character(infile,'.'); return;};
  if (strcmp(wordread,"u") == 0) {add_accent_character(infile,'u'); return;};
  if (strcmp(wordread,"v") == 0) {add_accent_character(infile,'v'); return;};
  if (strcmp(wordread,"H") == 0) {add_accent_character(infile,'H'); return;};
  if (strcmp(wordread,"t") == 0) {add_accent_character(infile,'t'); return;};
  if (strcmp(wordread,"c") == 0) {add_accent_character(infile,'c'); return;};
  if (strcmp(wordread,"d") == 0) {add_accent_character(infile,'d'); return;};
  if (strcmp(wordread,"b") == 0) {add_accent_character(infile,'b'); return;};

/* Symbols */
  if (strcmp(wordread,"dag") == 0)       {add_chars(UCSCU_char(SYM_daggar));       return;};
  if (strcmp(wordread,"ddag") == 0)      {add_chars(UCSCU_char(SYM_double_daggar));      return;};
  if (strcmp(wordread,"P") == 0)         {add_chars(UCSCU_char(SYM_paragraph)); return;};
  if (strcmp(wordread,"copyright") == 0) {add_chars(UCSCU_char(SYM_copyright)); return;};
  if (strcmp(wordread,"pounds") == 0)    {add_chars(UCSCU_char(SYM_pounds));    return;};
  if (strcmp(wordread,"S") == 0)         {add_chars(UCSCU_char(SYM_section));   return;};
  if (strcmp(wordread,"$") == 0)         {add_char('$'); return;};
  if (strcmp(wordread,"&") == 0)
  {
    if (HTML())
          add_chars("&amp;");
    else add_char('&');
    return;
  };
  if (strcmp(wordread,"<") == 0)
  {
    if (HTML())
          add_chars("&lt;");
    else add_char('<');
    return;
  };
  if (strcmp(wordread,">") == 0)
  {
    if (HTML())
          add_chars("&gt;");
    else add_char('>');
    return;
  };
  if (strcmp(wordread,"%") == 0)         {add_char('%'); return;};
  if (strcmp(wordread,"#") == 0)         {add_char('#'); return;};
  if (strcmp(wordread,"{") == 0)         {add_char('{'); return;};
  if (strcmp(wordread,"}") == 0)         {add_char('}'); return;};
  if (strcmp(wordread,"_") == 0)         {add_char('_'); return;};
  if (strcmp(wordread,"/") == 0)         {add_char('/'); return;};

  if (strcmp(wordread,"\\") == 0)        {process_newline();return;};
  if (strcmp(wordread,"indexspace") == 0){process_newline();return;};
  if (strcmp(wordread,"newpage") == 0)   {process_newpage();return;};

  if (strcmp(wordread,"SLiTeX") == 0)    {add_chars("SLiTeX"); return;};
  if (strcmp(wordread,"LaTeXe") == 0)    {add_chars("LaTeXe"); return;};
  if (strcmp(wordread,"LaTeX") == 0)     {add_chars("LaTeX"); return;};
  if (strcmp(wordread,"TeX") == 0)       {add_chars("TeX"); return;};

/* Spacing */
  if (strcmp(wordread,",") == 0)         {add_char(' '); return;};

  if (strcmp(wordread,"begin") == 0)
     {process_begin(infile); return;};
  if (strcmp(wordread,"end") == 0)
     {process_end(infile);   return;};
  /* Not implemented yet
  if (strcmp(wordread,"documentstyle") == 0)    {process_documentstyle(infile); return;};
  */
  if (strcmp(wordread,"label") == 0)            {process_number_label(infile);   return;};
  if (strcmp(wordread,"ref") == 0)              {process_ref(infile,REFERENCE);   return;};
  if (strcmp(wordread,"input") == 0)            {process_input(infile,EXT_TEX); return;};
  if (strcmp(wordread,"bibliography") == 0)     {process_bibliography(infile); return;};
  if (strcmp(wordread,"include") == 0)          {process_input(infile,EXT_TEX); return;};
  if (strcmp(wordread,"appendix") == 0)         {process_appendix(infile); return;};
  if (strcmp(wordread,"part") == 0)             {process_part(infile); return;};
  if (strcmp(wordread,"chapter") == 0)          {process_chapter(infile); return;};
  if (strcmp(wordread,"section") == 0)          {process_section(infile); return;};
  if (strcmp(wordread,"subsection") == 0)       {process_subsection(infile); return;};
  if (strcmp(wordread,"subsubsection") == 0)    {process_subsubsection(infile); return;};
  if (strcmp(wordread,"paragraph") == 0)        {process_paragraph(infile); return;};
  if (strcmp(wordread,"subparagraph") == 0)     {process_subparagraph(infile);return;};

  if (strcmp(wordread,"newcommand") == 0)       {process_newcommand(infile);return;};

  if (strcmp(wordread,"tableofcontents") == 0)  {process_tableofcontents(); return;};
  if (strcmp(wordread,"makeindex") == 0)        {process_makeindex(); return;};
  if (strcmp(wordread,"index") == 0)            {process_index(infile); return;};

  if (strcmp(wordread,"item") == 0)             {process_item(infile); return;};
  if (strcmp(wordread,"subitem") == 0)          {process_subitem(1); return;};
  if (strcmp(wordread,"subsubitem") == 0)       {process_subitem(2); return;};
  if (strcmp(wordread,"subsubsubitem") == 0)    {process_subitem(3); return;};

  if (strcmp(wordread,"cite") == 0)             {process_ref(infile,CITATION); return;};
  if (strcmp(wordread,"bibitem") == 0)          {process_item(infile); return;};

  if (strcmp(wordread,"footnote") == 0)         {process_footnote(infile); return; };

  if ((strcmp(wordread,"rm")) == 0) { process_font(infile,rm_FONT); return;};
  if ((strcmp(wordread,"sl")) == 0) { process_font(infile,sl_FONT); return;};
  if ((strcmp(wordread,"bf")) == 0) { process_font(infile,bf_FONT); return;};
  if ((strcmp(wordread,"em")) == 0) { process_font(infile,em_FONT); return;};
  if ((strcmp(wordread,"it")) == 0) { process_font(infile,it_FONT); return;};
  if ((strcmp(wordread,"tt")) == 0) { process_font(infile,tt_FONT); return;};
  if ((strcmp(wordread,"sf")) == 0) { process_font(infile,sf_FONT); return;};
  if ((strcmp(wordread,"sc")) == 0) { process_font(infile,sc_FONT); return;};
  if ((strcmp(wordread,"underline")) == 0) { process_font(infile,underline_FONT); return;};

  if ((newcmnd_replacement = lookup_newcommand(wordread)) != 0)
     process_text_str(newcmnd_replacement);
/*  ignore_line(infile);*/
};

#if  defined(__STDC__) || defined(__cplusplus)
void add_hypertext_command(FILE *infile)
#else
void add_hypertext_command(infile)
FILE *infile;
#endif
{
  char_8bit HTline[256];
  add_char('\\');
  fgets(HTline,255,infile);
  add_chars(HTline);
};

#if  defined(__STDC__) || defined(__cplusplus)
void process_minienvironment(FILE *infile,struct environment_layout *curr_environ)
#else
void process_minienvironment(infile,curr_environ)
FILE *infile;
struct environment_layout *curr_environ;
#endif
{
  environ_SP += 1;
  memcpy((void *)&environ_stack[environ_SP],
         (void *)curr_environ,
         sizeof(struct environment_layout));
  build_label = 1;
  label_pos = 0;
  process_text(infile);

  /* At the end of the minienvironment, disable any special font that may
     have been enabled. We don't need to turn of the normal font */
  if (HTML())
  switch (environ_stack[environ_SP]->font)
  {
     case bf_FONT : add_chars(" </b> "); break;
     case em_FONT : add_chars(" </em> "); break;
     case it_FONT : add_chars(" </i> "); break;
     case sl_FONT : add_chars(" </i> "); break;
     case tt_FONT : add_chars(" </code> "); break;
     case underline_FONT : add_chars(" </u> ");break;
     /*case rm_FONT : add_chars("<> "); break; */
     /*case sf_FONT : add_chars("<> "); break;
     /*case sc_FONT : add_chars("<> "); break; */
  };

  environ_SP -= 1;
};

#if  defined(__STDC__) || defined(__cplusplus)
void add_verbatim(FILE *infile)
#else
void add_verbatim(infile)
FILE *infile;
#endif
{
  char_8bit outline[256];
  int atend = 0;
  paragraph_end();
  if (HTML()) fprintf(output_file," <listing>\n");
  fgets(outline,255,infile);  /* read the remainder of the line */
  while (!atend)
  {
    fgets(outline,255,infile);
    if (outline[0] != '%')
       atend = 1;
    else
    {
       outline[strlen(outline)-1] = 0;
       fprintf(output_file,"%s\n",&outline[1]);
       line_num += 1;
       check_page_break(output_file);
    }
    if (feof(infile))
      atend = 1;
  };
  if (HTML()) fprintf(output_file," </listing>\n");

};

#if  defined(__STDC__) || defined(__cplusplus)
void add_fixups(FILE *infile)
#else
void add_fixups(infile)
FILE *infile;
#endif
{
  char_8bit fixup_line[160];
  char_8bit SmathS[80];
  char_8bit replacement[80];
  int atend = 0;

  process_newline();
  fgets(fixup_line,160,infile);  /* read the remainder of the line */
  while (!atend)
  {
    fgets(fixup_line,160,infile);

    if (fixup_line[0] != '%')
       atend = 1;
    else
    {
       sscanf(fixup_line,"%%%[^|]|%[^\n]",SmathS,replacement);
       add_fixup(SmathS,replacement);
    }
    if (feof(infile))
      atend = 1;
  };
};

#if  defined(__STDC__) || defined(__cplusplus)
void process_comment(FILE *infile)
#else
void process_comment(infile)
FILE *infile;
#endif
{
  char_8bit *wordread;
  wordread = readword(infile);
  if (strcmp(wordread,"\\") == 0)
     add_hypertext_command(infile);
  else
  if (strcmp(wordread,"verbatim") == 0)
     add_verbatim(infile);
  else
  if (strcmp(wordread,"fixup") == 0)
     add_fixups(infile);
  else
  if (strcmp(wordread,"label") == 0)
     process_link_label(infile,GEN_PREV_NEXT);
  else
  if (strcmp(wordread,"checkpoint") == 0)
  {  char cplabel[255];
     fscanf(infile,"%[^\n]\n",cplabel);
     fprintf(stderr,"%s\n",cplabel);
  }
  else
  { char throwaway;
    while (((throwaway = fgetc(infile)) != '\n') && (throwaway != EOF));
  };
};

#if  defined(__STDC__) || defined(__cplusplus)
void process_formula(FILE *infile)
#else
void process_formula(infile)
FILE *infile;
#endif
{
  int inchar;
  char_8bit math[80];
  char_8bit SmathS[80];
  char_8bit *replacement;
  int mathpos = 0;

  while (((inchar = fgetc(infile)) != '$') && !feof(infile))
    math[mathpos++] = inchar;
  math[mathpos] = 0;

  sprintf(SmathS,"$%s$",math);

  replacement = lookup_fixup(SmathS);

  if (replacement)
     add_chars(replacement);
  else
  {
     fprintf(fixup,"%%%s|%s\n",SmathS,math);
     add_fixup(SmathS,math);
     add_chars(math);
  };
};

#if  defined(__STDC__) || defined(__cplusplus)
void process_text(FILE *infile)
#else
void process_text(infile)
FILE *infile;
#endif
{
   int charin;
   int collect_white_space = 0;
   int next_newline_is_hard = 0;
   while (((charin = fgetc(infile)) != EOF) && (!feof(infile)))
   {
     if (isspace(charin))
     {
       if (!collect_white_space)
       { add_char(' ');
         collect_white_space = 1;
       };
       if (charin == '\n')
       {
           if (next_newline_is_hard && !newline_just_printed)
           {
              add_char(HARD_NEWLINE);
              newline_just_printed = 0;
           };
           next_newline_is_hard = 1;
       }
     }
     else
     {
       next_newline_is_hard = 0;
       newline_just_printed = 0;
       collect_white_space = 0;

        switch (charin)
        { case '%' :
             process_comment(infile); break;
          case '$' : process_formula(infile); break;
          case '\\' :
             process_tex(infile); break;
          case '{' :
             process_minienvironment(infile,environ_stack[environ_SP]); break;
          case '}' :
             return; /*break;   exit minienvironment */
          case ']' :
             if (in_brackets)
             {in_brackets = 0;
              /* Special case for description list items */
              if (HTML()) add_chars(" <dd>");
              return;
             }
             else add_char(charin); break;
          case '`' :
             if (nextchar(infile) == '`')
             {  charin = fgetc(infile) ;
                add_char(34);
             };
             break;
          case 39 :
            if (nextchar(infile) == 39)
            {  charin = fgetc(infile);
               add_char(34);
            };
            break;
          case '~' :
               add_char(' ');
               break;
          default :
              if (HTML())
                 switch (charin)
                 { case '&' : add_chars("&amp;"); break;
                   case '<' : add_chars("&lt;"); break;
                   case '>' : add_chars("&gt;"); break;
                   case '"' : add_chars("&quot;"); break;
                   default : add_char(charin); break;
                 }
                 else
                     add_char(charin);
             break;
        };
     };
   };
};

#if  defined(__STDC__) || defined(__cplusplus)
void process_text_str(char *textstr)
#else
void process_text_str(textstr)
char *textstr;
#endif
{
  FILE *textstrfile;
  int strpos = 0;

  if ((textstrfile = fopen("DELETEME.TSF",WRITEMODE)) != NULL)
  {
    for (strpos = 0 ; strpos < strlen(textstr); strpos++)
       fputc(textstr[strpos],textstrfile);
    fclose(textstrfile);
    if ((textstrfile = fopen("DELETEME.TSF",READMODE)) != NULL)
    {
      process_text(textstrfile);
      fclose(textstrfile);
    };
  };
};


#if  defined(__STDC__) || defined(__cplusplus)
void process_text_file(char_8bit *fname,char *extension)
#else
void process_text_file(fname,extension)
char_8bit *fname;
char *extension;
#endif
{
   FILE *infile = 0;
   char_8bit ffname[256];

#ifdef VERBOSE
  printf("Processing file %s%s\n",fname,extension);
#endif

   if (strcmp(fname,"-") == 0)
      infile = stdin;
   else
   {
      strcpy(ffname,fname);
      strncat(ffname,extension,255);
      infile =fopen(ffname,READMODE);
   }

   if (infile)
   { process_text(infile);
     if (infile != stdin)
        fclose(infile);
   };
};

#if  defined(__STDC__) || defined(__cplusplus)
void process_input(FILE *infile,char *extension)
#else
void process_input(infile,extension)
FILE *infile;
char *extension;
#endif
{
  char_8bit *wordread;

  fscanf(infile,"{");
  wordread = readword(infile);
  fscanf(infile,"}");

  process_text_file(wordread,extension);
};

#if  defined(__STDC__) || defined(__cplusplus)
void prompt_options(void)
#else
void prompt_options()
#endif
{
  do
  {
    language_list_available(stdout);
    printf("\n%s\n",translate(L_Enter_language_code));
    gets(language_name_code);
  } while
#ifdef HARDCODE_PHRASES
  (!language_set(language_name_code));
#else
  (!language_init(language_name_code,"L2H",RLIB_program_path,"phrases.lng"));
#endif
  printf("\n%s\n",translate(L_Enter_LaTeX_fname));
  gets(input_filename);
  printf("\n%s\n",translate(L_Enter_output_fname));
  gets(output_filename);

  UCSCU_prompt_output_options();

  textreader = -1;
  while ((textreader < 0) || (textreader > 2))
  {
    printf("\nGenerate cross reference syntax for what kind of text reader\n");
    printf("0. TEXT (no special hypertext commands.)\n");
    printf("1. TVISION Borland's TurboVision help compiler.\n");
/* Not yet implemented

    printf("2. HTML Hypertext Meta Language.\n");
    printf("3. HTML+ (currently the same as HTML.\n");

     -AGUIDE    Amigaguide (Not implement, but I have documentation on this)
     -HYPRTEXT  Roger Nelsons hypertext reader for MS-DOS (not implement yet)
     -SMGL      SMGL (not implemented, I have no documentation on this)
*/
    scanf("%d",&textreader);
  };
};

#if  defined(__STDC__) || defined(__cplusplus)
void show_usage(void)
#else
void show_usage()
#endif
{
  printf("\nNon-interactive usage:    latex2hy infilename outfilename options\n");
  printf("\ninfilename is the LaTeX file, outfilename is the text file to be generated.\n");
  printf("infilename and or outfilename may be a - hypen to indicate stdin or stdout.\n");
  UCSCU_show_usage();
  printf("\nOne of the following text readers may be selected:\n");
  printf("     TEXT TVISION HTML HTMLPLUS\n");
  printf("\nISO language code may be specified for foreign language translation.\n");
  printf("\nInteractive usage: latex2hy\n");
};
#if  defined(__STDC__) || defined(__cplusplus)
void parse_command_line(int argc,char *argv[])
#else
void parse_command_line(argc,argv)
int argc;
char *argv[];
#endif
{
  int arg;

  strcpy(input_filename,argv[1]);
  strcpy(output_filename,argv[2]);
  UCSCU_parse_command_line(argc,argv);
  for (arg = 3; arg < argc; arg++)
  {
    if (strcmp(argv[arg],"TEXT")    == 0)
      textreader = TR_STRAIGHTTEXT;
    if (strcmp(argv[arg],"TVISION") == 0)
      textreader = TR_TURBOVISION;
    if (strcmp(argv[arg],"HTML") == 0)
      textreader = TR_HTML;
  };
};

#if  defined(__STDC__) || defined(__cplusplus)
void generate_contents(FILE *outfile)
#else
void generate_contents(outfile)
FILE *outfile;
#endif
{
  FILE *tocfile;
  int  inchr;
  int hold_page_num;

#ifdef VERBOSE
printf("Generating table of contents\n");
#endif

  hold_page_num = page_num;  /* We need to be able to restore the page
                                numbering for the index paging */
  page_num = 1;   /* Reset page numbering for TOC */

  fputc('\f',outfile);  /* Plain formfeed because don't want number on title*/
  tocfile = fopen("DELETEME.TOC",READMODE);
  if (tocfile)
  {
    while ((inchr = fgetc(tocfile)) != EOF)
    {
      fputc(inchr,outfile);
      if (inchr == '\n')
      {
        line_num += 1;
        check_page_break(outfile);
      };
      if (inchr == '\f')
      {
        print_page_num(outfile);
        page_num += 1;
        line_num = 1;
      };
    };
    /* print_page_num(outfile); don't page break because abstract, part or chapter will do it*/
  }
  else
     fprintf(stderr,"%s: DELETEME.TOC (%s)\n",
        translate(L_Unable_to_open_file),translate(L_Contents));
  page_num = hold_page_num;
};

#if  defined(__STDC__) || defined(__cplusplus)
void generate_index(char *docfilename)
#else
void generate_index(docfilename)
char *docfilename;
#endif
{
  FILE *DMidxfile;      /* DeleteMeindxfile */
  FILE *docidxfile;
  FILE *indextexfile;
  FILE *newindextexfile;
  char docfilenameext[255];
  int pagerenumber[10000];
  int i;
  char DMindexstr[255];
  char docindexstr[255];
  int DMpage;
  int docpage;
  int inchar;
  int lastinchar = 0;

  strcpy(docfilenameext,docfilename);
  strcat(docfilenameext,".idx");

  if ((DMidxfile = fopen("DELETEME.IDX",READMODE)) == 0)
  {
     fprintf(stderr,"%s: DELETEME.IDX (%s)\n",
        translate(L_Unable_to_open_file),translate(L_Index));
     return;
  };

  if ((docidxfile = fopen(docfilenameext,READMODE)) == 0)
  {
     fprintf(stderr,"%s: %s (%s)\n",
        translate(L_Unable_to_open_file),docfilenameext,translate(L_Index));
     fclose(DMidxfile);
     return;
  };

  for (i = 0; i < 10000;i++)
     pagerenumber[i] = 0;

  while(!feof(DMidxfile) && !feof(docidxfile))
  {
    fscanf(DMidxfile,"%d %[^\n]\n",&DMpage,DMindexstr);
    fscanf(docidxfile,"\\indexentry");
    strcpy(docindexstr,read_environment(docidxfile));
    fscanf(docidxfile,"{%d}\n",&docpage);
    pagerenumber[docpage] = DMpage;
  };

  fclose(DMidxfile);
  fclose(docidxfile);

  if ((indextexfile = fopen("index.tex",READMODE)) == 0)
  {
     fprintf(stderr,"%s: index.tex (%s)\n",
        translate(L_Unable_to_open_file),translate(L_Index));
     return;
  };

  if ((newindextexfile = fopen("DELETEME.ITX",WRITEMODE)) == 0)
  {
     fprintf(stderr,"%s: DELETEME.ITX (%s)\n",
        translate(L_Unable_to_open_file),translate(L_Index));
     fclose(indextexfile);
     return;
  };

  /* Now convert all page numbers in DVI file to the text document page numbers
     A page number can be identified because it will either be preceeded
     by a space or a '-', and will always be followed with a '-' ',' or
     newline.
  */
  {
  int num = 0;
  int reading_number = 0;

  while (!feof(indextexfile))
  {
    inchar = fgetc(indextexfile);
    if (reading_number)
      switch (inchar)
      {
      case ',' : case '-' : case '\n' :
         /* Normal termination of a page number. */

         /* It is possible that some page renumberings were not identified
            in the index pagination scan, so we will have to guess the
            page number. */
         if (!pagerenumber[num])
            pagerenumber[num] = (num == 1) ? 1 : pagerenumber[num-1]+1;

         fprintf(newindextexfile,"%d%c",pagerenumber[num],inchar);
         reading_number = 0;
         num = 0;
         break;
      default :
         if ((inchar >= '0') && (inchar <= '9'))
            num = num * 10 + (inchar - '0');
         else /* Unexpected character encountered in number, the number is
                 probably part of the index key, so just dump it. */
         {
           if (isdigit(lastinchar))
              fprintf(newindextexfile,"%d%c",num,inchar);
           else
              fputc(inchar,newindextexfile);

           reading_number = 0;
           num = 0;
         };
         break;
      }
    else
    {
      fputc(inchar,newindextexfile);
      switch (inchar)
      { case ' ' : case '-' :
           reading_number = 1;
           num = 0;
           break;
      };
    };
    lastinchar = inchar;
  };
  };
  fclose(indextexfile);
  fclose(newindextexfile);
  process_text_file("DELETEME",".ITX");
};

#if  defined(__STDC__) || defined(__cplusplus)
void resolve_refs(char *documentname)
#else
void resolve_refs(documentname)
char *documentname;
#endif
{
  FILE *tempfile;
  FILE *outfile;

  if (strcmp(output_filename,"-") == 0)
     outfile = stdout;
  else
     outfile = fopen(output_filename,WRITEMODE);

  tempfile = fopen("DELETEME.TXT",READMODE);


  /* HTML needs to define  the document, head and body */
  switch (textreader)
  { case TR_HTML:
         fprintf(outfile,"\n<HTML>\n<HEAD>\n");
    break;
    case TR_HTMLPLUS:
         fprintf(outfile,"\n<HTMLPLUS>\n<HEAD>\n");
    break;
  };



  if (tempfile && outfile)
  {
    int inchar;
    while (!feof(tempfile))
    {
      inchar = fgetc(tempfile);
      switch (inchar)
      {
      case TOC_MARKER :
         if (tableofcontents) generate_contents(outfile);
         break;
      case BEGIN_DOC_MARKER :
         switch (textreader)
         { case TR_HTML: case TR_HTMLPLUS :
            fprintf(outfile,"\n</HEAD>\n<BODY>\n");
          break;
         };
      break;
      case START_REF_MARKER :
         {
         char_8bit labelstr[80];
         int labelpos = 0;
         struct label_layout *label = 0;

         while ((inchar = fgetc(tempfile)) != END_REF_MARKER)
            labelstr[labelpos++] = inchar;
         labelstr[labelpos] = 0;
         label = lookup_label(labelstr);
         if (label)
            fprintf(outfile,"%s",label->enumeration);
         else
            fprintf(outfile,"???");
         }
         break;
      default :
           fputc(inchar,outfile);

      }
    };

#ifdef VERBOSE
fprintf(stderr,"Generating index\n");
#endif
    if (makeindex) generate_index(documentname);


    switch (textreader)
    { case TR_HTML:
         process_newline();
         fprintf(outfile," </BODY></HTML>\n");
      break;
     case TR_HTMLPLUS :
         process_newline();
         fprintf(outfile," </BODY></HTMLPLUS>\n");
      break;
    };

    fclose(outfile);
    fclose(tempfile);
  };
};

#if  defined(__STDC__) || defined(__cplusplus)
void cleanup_fixups(void)
#else
void cleanup_fixups()
#endif
{
   struct fixup_layout *next;
   struct fixup_layout *delete_fixup;
   for (delete_fixup= fixups; delete_fixup; delete_fixup= next)
   {
      next = delete_fixup->next;
      free(delete_fixup);
   };
};

#if  defined(__STDC__) || defined(__cplusplus)
void cleanup_labels(void)
#else
void cleanup_labels()
#endif
{
   struct label_layout *next;
   struct label_layout *delete_label;
   for (delete_label= labels; delete_label; delete_label= next)
   {
      next = delete_label->next;
      free(delete_label);
   };
};

/*  Not implemented yet
Page layout options

  Enable line breaks?  Some hypertext readers perform their own
                       paragraph justification.
  Enable page breaks?  Newpage always forces form feed

  Use device control codes?  For printer control.

If page layout disabled:

  Line width:      80
  Lines per page:  60

If page layout enabled:

  Paper Width:     8.5  inches
  Paper Length:   11.0  inches

  Left Margin:       0  Ms
  Right Margin:      0  Ms
  Top Margin:        0  Ms
  Bottom Margin:     0  Ms

  Use proportional spacing?


  Part title  (\Huge)
  Part number (\Huge)
  Chapter title  (\Huge)
  Appendix       (\Huge)
  Bibliography   (\Huge)    x
  Index          (\Huge)
  Table of contents (\Huge) x
  Chapter number (\huge)
  Section        (\Large)
  Abstract       (\Large)
  Subsection     (\large)
  Subsubsection  (\large)
  Paragraph (\normal \bf)

  Footnote  (\footnote size)

  Print Styles:

  \rm  Normal (Prestige if available)
  \em  Italics
  \bf  Normal bold
  \it  Italics
  \sl  Italics
  \sf  Normal (prefer sanserif if available)
  \sc  Normal (convert to capitals)
  \tt  Normal (courier if available)

  \underline Underline text
*/

#ifdef VMS
#if  defined(__STDC__) || defined(__cplusplus)
main(int argc, char *argv[])
#else
main(argc,argv)
int argc;
char *argv[];
#endif
#else
#if  defined(__STDC__) || defined(__cplusplus)
int main(int argc, char *argv[])
#else
void main(argc,argv)
int argc;
char *argv[];
#endif
#endif
{
  char *tex_pos = 0;
  char_8bit start_filename[256];

#ifdef HARDCODE_PHRASES
  language_set("en");
#else
#ifdef amiga
  strcpy(RLIB_program_path,"latex2hyp:");
#else
  RLIB_start(argv[0]);
#endif

  if (!language_init("en","L2H",RLIB_program_path,"phrases.lng"))
  { fprintf(stderr,"Unable to open language translation file: phrases.lng\n"
             "This file should be placed in the same directory as %s\n",
             RLIB_program_path);
    exit(1);
  };
#endif

  fixup = fopen("FIXUP.SS",WRITEMODE);

  if (argc == 1)
     prompt_options();
  else
    if (argc < 3)
    { show_usage();
      exit(1);
    }
    else
      parse_command_line(argc,argv);

  switch (textreader)
  { case TR_TURBOVISION :
       break_lines = 0;
       break_pages = 0;
    break;
    case TR_HTML :
       break_lines = 0;
       break_pages = 0;
    break;
    default :
       break_lines = 1;
       break_pages = 1;
    break;
  };

  strcpy(start_filename,input_filename);
  tex_pos = strstr((char *)start_filename,EXT_TEX);
  if (!tex_pos)
     tex_pos = strstr((char *)start_filename,EXT_TEX);
  if (tex_pos)
     *tex_pos = 0;

  output_file = fopen("DELETEME.TXT",WRITEMODE);
  tocfile = fopen("DELETEME.TOC",WRITEMODE);
  idxfile = fopen("DELETEME.IDX",WRITEMODE);
  environ_stack[environ_SP]->font = normal_FONT;
  process_text_file(start_filename,EXT_TEX);

  fclose(output_file);
  fclose(tocfile);
  fclose(idxfile);

#ifdef VERBOSE
  fprintf(stderr,"Resolving cross references\n");
#endif

  resolve_refs(start_filename);
  fclose(fixup);
#ifndef HARDCODE_PHRASES
  language_end();
#endif
};
