/*
    Copyright (C) 2013 Nicola L.C. Talbot
    www.dickimaw-books.com

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
package com.dickimawbooks.texparserlib.latex.jmlr;

import java.io.IOException;
import java.util.Vector;

import com.dickimawbooks.texparserlib.*;
import com.dickimawbooks.texparserlib.latex.*;

public class SubFloatLabel extends ControlSequence
{
   public SubFloatLabel(String name)
   {
      super(name);
   }

   public Object clone()
   {
      return new SubFloatLabel(getName());
   }

   public void process(TeXParser parser) throws IOException
   {
      process(parser, parser);
   }

   public void process(TeXParser parser, TeXObjectList stack) throws IOException
   {
      LaTeXParserListener listener = (LaTeXParserListener)parser.getListener();
      TeXObject arg;

      if (parser == stack)
      {
         arg = parser.popNextArg();
      }
      else
      {
         arg = stack.popArg(parser);
      }

      TeXObjectList list = new TeXObjectList();

      list.add(listener.getOther('('));

      ControlSequence cs = listener.getControlSequence("emph");

      Group grp = listener.createGroup();
      grp.add(arg);

      list.add(cs);
      list.add(grp);

      list.add(listener.getOther(')'));

      if (parser == stack)
      {
         list.process(parser);
      }
      else
      {
         list.process(parser, stack);
      }
   }

}
