package Bigtop::Example::Billing::Model::line_item;
use strict; use warnings;

use base 'Gantry::Utils::DBIxClass', 'Exporter';

use Bigtop::Example::Billing::Model::GEN::line_item;

our $LINE_ITEM = 'Bigtop::Example::Billing::Model::line_item';

our @EXPORT_OK = ( '$LINE_ITEM' );

sub get_count {
    my $class       = shift;
    my $gantry_site = shift;

    my %retval;

    my @line_items = $class->gsearch( $gantry_site );

    foreach my $line_item ( @line_items ) {
        $retval{ $line_item->invoice->id }++;
    }

    return \%retval;
}

1;

=head1 NAME

Bigtop::Example::Billing::Model::line_item - model for line_item table (stub part)

=head1 DESCRIPTION

This model inherits from its generated helper, which inherits from
Gantry::Utils::DBIxClass.  It was generated by Bigtop, but is
NOT subject to regeneration.

=head1 METHODS (mixed in from Bigtop::Example::Billing::Model::GEN::line_item)

You may use all normal Gantry::Utils::DBIxClass methods and the
ones listed here:

=over 4

=item get_foreign_display_fields

=item get_foreign_tables

=item foreign_display

=item table_name

=back

=cut
