package Solaris::Sysconf;

use 5.006;
use strict;
use warnings;
use Carp;

require Exporter;
require DynaLoader;
use AutoLoader;

our @ISA = qw(Exporter DynaLoader);

# Items to export into callers namespace by default. Note: do not export
# names by default without a very good reason. Use EXPORT_OK instead.
# Do not simply export all your public functions/methods/constants.

# This allows declaration	use Solaris::Sysconf ':all';
# If you do not need this, moving things directly into @EXPORT or @EXPORT_OK
# will save memory.
our %EXPORT_TAGS = ( 'all' => [ qw(
	sysconf
	_CS_LFS64_CFLAGS
	_CS_LFS64_LDFLAGS
	_CS_LFS64_LIBS
	_CS_LFS64_LINTFLAGS
	_CS_LFS_CFLAGS
	_CS_LFS_LDFLAGS
	_CS_LFS_LIBS
	_CS_LFS_LINTFLAGS
	_CS_PATH
	_CS_XBS5_ILP32_OFF32_CFLAGS
	_CS_XBS5_ILP32_OFF32_LDFLAGS
	_CS_XBS5_ILP32_OFF32_LIBS
	_CS_XBS5_ILP32_OFF32_LINTFLAGS
	_CS_XBS5_ILP32_OFFBIG_CFLAGS
	_CS_XBS5_ILP32_OFFBIG_LDFLAGS
	_CS_XBS5_ILP32_OFFBIG_LIBS
	_CS_XBS5_ILP32_OFFBIG_LINTFLAGS
	_CS_XBS5_LP64_OFF64_CFLAGS
	_CS_XBS5_LP64_OFF64_LDFLAGS
	_CS_XBS5_LP64_OFF64_LIBS
	_CS_XBS5_LP64_OFF64_LINTFLAGS
	_CS_XBS5_LPBIG_OFFBIG_CFLAGS
	_CS_XBS5_LPBIG_OFFBIG_LDFLAGS
	_CS_XBS5_LPBIG_OFFBIG_LIBS
	_CS_XBS5_LPBIG_OFFBIG_LINTFLAGS
	_PC_ASYNC_IO
	_PC_CHOWN_RESTRICTED
	_PC_FILESIZEBITS
	_PC_LAST
	_PC_LINK_MAX
	_PC_MAX_CANON
	_PC_MAX_INPUT
	_PC_NAME_MAX
	_PC_NO_TRUNC
	_PC_PATH_MAX
	_PC_PIPE_BUF
	_PC_PRIO_IO
	_PC_SYNC_IO
	_PC_VDISABLE
	_POSIX2_CHAR_TERM
	_POSIX2_C_BIND
	_POSIX2_C_DEV
	_POSIX2_C_VERSION
	_POSIX2_LOCALEDEF
	_POSIX2_SW_DEV
	_POSIX2_UPE
	_POSIX2_VERSION
	_POSIX_VERSION
	_SC_2_CHAR_TERM
	_SC_2_C_BIND
	_SC_2_C_DEV
	_SC_2_C_VERSION
	_SC_2_FORT_DEV
	_SC_2_FORT_RUN
	_SC_2_LOCALEDEF
	_SC_2_SW_DEV
	_SC_2_UPE
	_SC_2_VERSION
	_SC_AIO_LISTIO_MAX
	_SC_AIO_MAX
	_SC_AIO_PRIO_DELTA_MAX
	_SC_ARG_MAX
	_SC_ASYNCHRONOUS_IO
	_SC_ATEXIT_MAX
	_SC_AVPHYS_PAGES
	_SC_BC_BASE_MAX
	_SC_BC_DIM_MAX
	_SC_BC_SCALE_MAX
	_SC_BC_STRING_MAX
	_SC_CHILD_MAX
	_SC_CLK_TCK
	_SC_COHER_BLKSZ
	_SC_COLL_WEIGHTS_MAX
	_SC_DCACHE_ASSOC
	_SC_DCACHE_BLKSZ
	_SC_DCACHE_LINESZ
	_SC_DCACHE_SZ
	_SC_DCACHE_TBLKSZ
	_SC_DELAYTIMER_MAX
	_SC_EXPR_NEST_MAX
	_SC_FSYNC
	_SC_GETGR_R_SIZE_MAX
	_SC_GETPW_R_SIZE_MAX
	_SC_ICACHE_ASSOC
	_SC_ICACHE_BLKSZ
	_SC_ICACHE_LINESZ
	_SC_ICACHE_SZ
	_SC_IOV_MAX
	_SC_JOB_CONTROL
	_SC_LINE_MAX
	_SC_LOGIN_NAME_MAX
	_SC_LOGNAME_MAX
	_SC_MAPPED_FILES
	_SC_MAXPID
	_SC_MEMLOCK
	_SC_MEMLOCK_RANGE
	_SC_MEMORY_PROTECTION
	_SC_MESSAGE_PASSING
	_SC_MQ_OPEN_MAX
	_SC_MQ_PRIO_MAX
	_SC_NGROUPS_MAX
	_SC_NPROCESSORS_CONF
	_SC_NPROCESSORS_ONLN
	_SC_OPEN_MAX
	_SC_PAGESIZE
	_SC_PAGE_SIZE
	_SC_PASS_MAX
	_SC_PHYS_PAGES
	_SC_PRIORITIZED_IO
	_SC_PRIORITY_SCHEDULING
	_SC_REALTIME_SIGNALS
	_SC_RE_DUP_MAX
	_SC_RTSIG_MAX
	_SC_SAVED_IDS
	_SC_SEMAPHORES
	_SC_SEM_NSEMS_MAX
	_SC_SEM_VALUE_MAX
	_SC_SHARED_MEMORY_OBJECTS
	_SC_SIGQUEUE_MAX
	_SC_SIGRT_MAX
	_SC_SIGRT_MIN
	_SC_SPLIT_CACHE
	_SC_STACK_PROT
	_SC_STREAM_MAX
	_SC_SYNCHRONIZED_IO
	_SC_THREADS
	_SC_THREAD_ATTR_STACKADDR
	_SC_THREAD_ATTR_STACKSIZE
	_SC_THREAD_DESTRUCTOR_ITERATIONS
	_SC_THREAD_KEYS_MAX
	_SC_THREAD_PRIORITY_SCHEDULING
	_SC_THREAD_PRIO_INHERIT
	_SC_THREAD_PRIO_PROTECT
	_SC_THREAD_PROCESS_SHARED
	_SC_THREAD_SAFE_FUNCTIONS
	_SC_THREAD_STACK_MIN
	_SC_THREAD_THREADS_MAX
	_SC_TIMERS
	_SC_TIMER_MAX
	_SC_TTY_NAME_MAX
	_SC_TZNAME_MAX
	_SC_T_IOV_MAX
	_SC_VERSION
	_SC_XBS5_ILP32_OFF32
	_SC_XBS5_ILP32_OFFBIG
	_SC_XBS5_LP64_OFF64
	_SC_XBS5_LPBIG_OFFBIG
	_SC_XOPEN_CRYPT
	_SC_XOPEN_ENH_I18N
	_SC_XOPEN_LEGACY
	_SC_XOPEN_REALTIME
	_SC_XOPEN_REALTIME_THREADS
	_SC_XOPEN_SHM
	_SC_XOPEN_UNIX
	_SC_XOPEN_VERSION
	_SC_XOPEN_XCU_VERSION
	_XOPEN_ENH_I18N
	_XOPEN_REALTIME
	_XOPEN_SHM
	_XOPEN_UNIX
	_XOPEN_XCU_VERSION
	_XOPEN_XPG3
	_XOPEN_XPG4
) ] );

our @EXPORT_OK = ( @{ $EXPORT_TAGS{'all'} } );

our @EXPORT = qw(
	sysconf
	_CS_LFS64_CFLAGS
	_CS_LFS64_LDFLAGS
	_CS_LFS64_LIBS
	_CS_LFS64_LINTFLAGS
	_CS_LFS_CFLAGS
	_CS_LFS_LDFLAGS
	_CS_LFS_LIBS
	_CS_LFS_LINTFLAGS
	_CS_PATH
	_CS_XBS5_ILP32_OFF32_CFLAGS
	_CS_XBS5_ILP32_OFF32_LDFLAGS
	_CS_XBS5_ILP32_OFF32_LIBS
	_CS_XBS5_ILP32_OFF32_LINTFLAGS
	_CS_XBS5_ILP32_OFFBIG_CFLAGS
	_CS_XBS5_ILP32_OFFBIG_LDFLAGS
	_CS_XBS5_ILP32_OFFBIG_LIBS
	_CS_XBS5_ILP32_OFFBIG_LINTFLAGS
	_CS_XBS5_LP64_OFF64_CFLAGS
	_CS_XBS5_LP64_OFF64_LDFLAGS
	_CS_XBS5_LP64_OFF64_LIBS
	_CS_XBS5_LP64_OFF64_LINTFLAGS
	_CS_XBS5_LPBIG_OFFBIG_CFLAGS
	_CS_XBS5_LPBIG_OFFBIG_LDFLAGS
	_CS_XBS5_LPBIG_OFFBIG_LIBS
	_CS_XBS5_LPBIG_OFFBIG_LINTFLAGS
	_PC_ASYNC_IO
	_PC_CHOWN_RESTRICTED
	_PC_FILESIZEBITS
	_PC_LAST
	_PC_LINK_MAX
	_PC_MAX_CANON
	_PC_MAX_INPUT
	_PC_NAME_MAX
	_PC_NO_TRUNC
	_PC_PATH_MAX
	_PC_PIPE_BUF
	_PC_PRIO_IO
	_PC_SYNC_IO
	_PC_VDISABLE
	_POSIX2_CHAR_TERM
	_POSIX2_C_BIND
	_POSIX2_C_DEV
	_POSIX2_C_VERSION
	_POSIX2_LOCALEDEF
	_POSIX2_SW_DEV
	_POSIX2_UPE
	_POSIX2_VERSION
	_POSIX_VERSION
	_SC_2_CHAR_TERM
	_SC_2_C_BIND
	_SC_2_C_DEV
	_SC_2_C_VERSION
	_SC_2_FORT_DEV
	_SC_2_FORT_RUN
	_SC_2_LOCALEDEF
	_SC_2_SW_DEV
	_SC_2_UPE
	_SC_2_VERSION
	_SC_AIO_LISTIO_MAX
	_SC_AIO_MAX
	_SC_AIO_PRIO_DELTA_MAX
	_SC_ARG_MAX
	_SC_ASYNCHRONOUS_IO
	_SC_ATEXIT_MAX
	_SC_AVPHYS_PAGES
	_SC_BC_BASE_MAX
	_SC_BC_DIM_MAX
	_SC_BC_SCALE_MAX
	_SC_BC_STRING_MAX
	_SC_CHILD_MAX
	_SC_CLK_TCK
	_SC_COHER_BLKSZ
	_SC_COLL_WEIGHTS_MAX
	_SC_DCACHE_ASSOC
	_SC_DCACHE_BLKSZ
	_SC_DCACHE_LINESZ
	_SC_DCACHE_SZ
	_SC_DCACHE_TBLKSZ
	_SC_DELAYTIMER_MAX
	_SC_EXPR_NEST_MAX
	_SC_FSYNC
	_SC_GETGR_R_SIZE_MAX
	_SC_GETPW_R_SIZE_MAX
	_SC_ICACHE_ASSOC
	_SC_ICACHE_BLKSZ
	_SC_ICACHE_LINESZ
	_SC_ICACHE_SZ
	_SC_IOV_MAX
	_SC_JOB_CONTROL
	_SC_LINE_MAX
	_SC_LOGIN_NAME_MAX
	_SC_LOGNAME_MAX
	_SC_MAPPED_FILES
	_SC_MAXPID
	_SC_MEMLOCK
	_SC_MEMLOCK_RANGE
	_SC_MEMORY_PROTECTION
	_SC_MESSAGE_PASSING
	_SC_MQ_OPEN_MAX
	_SC_MQ_PRIO_MAX
	_SC_NGROUPS_MAX
	_SC_NPROCESSORS_CONF
	_SC_NPROCESSORS_ONLN
	_SC_OPEN_MAX
	_SC_PAGESIZE
	_SC_PAGE_SIZE
	_SC_PASS_MAX
	_SC_PHYS_PAGES
	_SC_PRIORITIZED_IO
	_SC_PRIORITY_SCHEDULING
	_SC_REALTIME_SIGNALS
	_SC_RE_DUP_MAX
	_SC_RTSIG_MAX
	_SC_SAVED_IDS
	_SC_SEMAPHORES
	_SC_SEM_NSEMS_MAX
	_SC_SEM_VALUE_MAX
	_SC_SHARED_MEMORY_OBJECTS
	_SC_SIGQUEUE_MAX
	_SC_SIGRT_MAX
	_SC_SIGRT_MIN
	_SC_SPLIT_CACHE
	_SC_STACK_PROT
	_SC_STREAM_MAX
	_SC_SYNCHRONIZED_IO
	_SC_THREADS
	_SC_THREAD_ATTR_STACKADDR
	_SC_THREAD_ATTR_STACKSIZE
	_SC_THREAD_DESTRUCTOR_ITERATIONS
	_SC_THREAD_KEYS_MAX
	_SC_THREAD_PRIORITY_SCHEDULING
	_SC_THREAD_PRIO_INHERIT
	_SC_THREAD_PRIO_PROTECT
	_SC_THREAD_PROCESS_SHARED
	_SC_THREAD_SAFE_FUNCTIONS
	_SC_THREAD_STACK_MIN
	_SC_THREAD_THREADS_MAX
	_SC_TIMERS
	_SC_TIMER_MAX
	_SC_TTY_NAME_MAX
	_SC_TZNAME_MAX
	_SC_T_IOV_MAX
	_SC_VERSION
	_SC_XBS5_ILP32_OFF32
	_SC_XBS5_ILP32_OFFBIG
	_SC_XBS5_LP64_OFF64
	_SC_XBS5_LPBIG_OFFBIG
	_SC_XOPEN_CRYPT
	_SC_XOPEN_ENH_I18N
	_SC_XOPEN_LEGACY
	_SC_XOPEN_REALTIME
	_SC_XOPEN_REALTIME_THREADS
	_SC_XOPEN_SHM
	_SC_XOPEN_UNIX
	_SC_XOPEN_VERSION
	_SC_XOPEN_XCU_VERSION
	_XOPEN_ENH_I18N
	_XOPEN_REALTIME
	_XOPEN_SHM
	_XOPEN_UNIX
	_XOPEN_XCU_VERSION
	_XOPEN_XPG3
	_XOPEN_XPG4
);
our $VERSION = '0.01';

sub AUTOLOAD {
    # This AUTOLOAD is used to 'autoload' constants from the constant()
    # XS function.  If a constant is not found then control is passed
    # to the AUTOLOAD in AutoLoader.

    my $constname;
    our $AUTOLOAD;
    ($constname = $AUTOLOAD) =~ s/.*:://;
    croak "& not defined" if $constname eq 'constant';
    my $val = constant($constname, @_ ? $_[0] : 0);
    if ($! != 0) {
	if ($! =~ /Invalid/ || $!{EINVAL}) {
	    $AutoLoader::AUTOLOAD = $AUTOLOAD;
	    goto &AutoLoader::AUTOLOAD;
	}
	else {
	    croak "Your vendor has not defined Solaris::Sysconf macro $constname";
	}
    }
    {
	no strict 'refs';
	# Fixed between 5.005_53 and 5.005_61
	if ($] >= 5.00561) {
	    *$AUTOLOAD = sub { $val };
	}
	else {
	    *$AUTOLOAD = sub { $val };
	}
    }
    goto &$AUTOLOAD;
}

bootstrap Solaris::Sysconf $VERSION;

# Preloaded methods go here.

# Autoload methods go after =cut, and are processed by the autosplit program.

1;
__END__
# Below is stub documentation for your module. You better edit it!

=head1 NAME

Solaris::Sysconf - get configurable system variables

=head1 SYNOPSIS

  use Solaris::Sysconf;

  print "_SC_CLK_TCK   : ", sysconf(_SC_CLK_TCK), "\n";
  print "_SC_PAGE_SIZE : ", sysconf(_SC_PAGE_SIZE), "\n";

=head1 DESCRIPTION

  The Solaris::Sysconf module is a simple interface to sysconf(3C) library function, which
  provides a method for an  application to  determine  the  current  value  of a configurable 
  system limit or option (variable). The argument to the sysconf method represents the system
  variable to be queried. The symbolic constants that represent the names of the variables, 
  accessible through sysconf are defined in <limits.h> and <unistd.h>. All these constants
  are exported by default by the Solaris::Sysconf module.

=head2 EXPORT

See <limits.h> and <unistd.h>

=head2 Exportable constants

  _CS_LFS64_CFLAGS
  _CS_LFS64_LDFLAGS
  _CS_LFS64_LIBS
  _CS_LFS64_LINTFLAGS
  _CS_LFS_CFLAGS
  _CS_LFS_LDFLAGS
  _CS_LFS_LIBS
  _CS_LFS_LINTFLAGS
  _CS_PATH
  _CS_XBS5_ILP32_OFF32_CFLAGS
  _CS_XBS5_ILP32_OFF32_LDFLAGS
  _CS_XBS5_ILP32_OFF32_LIBS
  _CS_XBS5_ILP32_OFF32_LINTFLAGS
  _CS_XBS5_ILP32_OFFBIG_CFLAGS
  _CS_XBS5_ILP32_OFFBIG_LDFLAGS
  _CS_XBS5_ILP32_OFFBIG_LIBS
  _CS_XBS5_ILP32_OFFBIG_LINTFLAGS
  _CS_XBS5_LP64_OFF64_CFLAGS
  _CS_XBS5_LP64_OFF64_LDFLAGS
  _CS_XBS5_LP64_OFF64_LIBS
  _CS_XBS5_LP64_OFF64_LINTFLAGS
  _CS_XBS5_LPBIG_OFFBIG_CFLAGS
  _CS_XBS5_LPBIG_OFFBIG_LDFLAGS
  _CS_XBS5_LPBIG_OFFBIG_LIBS
  _CS_XBS5_LPBIG_OFFBIG_LINTFLAGS
  _PC_ASYNC_IO
  _PC_CHOWN_RESTRICTED
  _PC_FILESIZEBITS
  _PC_LAST
  _PC_LINK_MAX
  _PC_MAX_CANON
  _PC_MAX_INPUT
  _PC_NAME_MAX
  _PC_NO_TRUNC
  _PC_PATH_MAX
  _PC_PIPE_BUF
  _PC_PRIO_IO
  _PC_SYNC_IO
  _PC_VDISABLE
  _POSIX2_CHAR_TERM
  _POSIX2_C_BIND
  _POSIX2_C_DEV
  _POSIX2_C_VERSION
  _POSIX2_LOCALEDEF
  _POSIX2_SW_DEV
  _POSIX2_UPE
  _POSIX2_VERSION
  _POSIX_VERSION
  _SC_2_CHAR_TERM
  _SC_2_C_BIND
  _SC_2_C_DEV
  _SC_2_C_VERSION
  _SC_2_FORT_DEV
  _SC_2_FORT_RUN
  _SC_2_LOCALEDEF
  _SC_2_SW_DEV
  _SC_2_UPE
  _SC_2_VERSION
  _SC_AIO_LISTIO_MAX
  _SC_AIO_MAX
  _SC_AIO_PRIO_DELTA_MAX
  _SC_ARG_MAX
  _SC_ASYNCHRONOUS_IO
  _SC_ATEXIT_MAX
  _SC_AVPHYS_PAGES
  _SC_BC_BASE_MAX
  _SC_BC_DIM_MAX
  _SC_BC_SCALE_MAX
  _SC_BC_STRING_MAX
  _SC_CHILD_MAX
  _SC_CLK_TCK
  _SC_COHER_BLKSZ
  _SC_COLL_WEIGHTS_MAX
  _SC_DCACHE_ASSOC
  _SC_DCACHE_BLKSZ
  _SC_DCACHE_LINESZ
  _SC_DCACHE_SZ
  _SC_DCACHE_TBLKSZ
  _SC_DELAYTIMER_MAX
  _SC_EXPR_NEST_MAX
  _SC_FSYNC
  _SC_GETGR_R_SIZE_MAX
  _SC_GETPW_R_SIZE_MAX
  _SC_ICACHE_ASSOC
  _SC_ICACHE_BLKSZ
  _SC_ICACHE_LINESZ
  _SC_ICACHE_SZ
  _SC_IOV_MAX
  _SC_JOB_CONTROL
  _SC_LINE_MAX
  _SC_LOGIN_NAME_MAX
  _SC_LOGNAME_MAX
  _SC_MAPPED_FILES
  _SC_MAXPID
  _SC_MEMLOCK
  _SC_MEMLOCK_RANGE
  _SC_MEMORY_PROTECTION
  _SC_MESSAGE_PASSING
  _SC_MQ_OPEN_MAX
  _SC_MQ_PRIO_MAX
  _SC_NGROUPS_MAX
  _SC_NPROCESSORS_CONF
  _SC_NPROCESSORS_ONLN
  _SC_OPEN_MAX
  _SC_PAGESIZE
  _SC_PAGE_SIZE
  _SC_PASS_MAX
  _SC_PHYS_PAGES
  _SC_PRIORITIZED_IO
  _SC_PRIORITY_SCHEDULING
  _SC_REALTIME_SIGNALS
  _SC_RE_DUP_MAX
  _SC_RTSIG_MAX
  _SC_SAVED_IDS
  _SC_SEMAPHORES
  _SC_SEM_NSEMS_MAX
  _SC_SEM_VALUE_MAX
  _SC_SHARED_MEMORY_OBJECTS
  _SC_SIGQUEUE_MAX
  _SC_SIGRT_MAX
  _SC_SIGRT_MIN
  _SC_SPLIT_CACHE
  _SC_STACK_PROT
  _SC_STREAM_MAX
  _SC_SYNCHRONIZED_IO
  _SC_THREADS
  _SC_THREAD_ATTR_STACKADDR
  _SC_THREAD_ATTR_STACKSIZE
  _SC_THREAD_DESTRUCTOR_ITERATIONS
  _SC_THREAD_KEYS_MAX
  _SC_THREAD_PRIORITY_SCHEDULING
  _SC_THREAD_PRIO_INHERIT
  _SC_THREAD_PRIO_PROTECT
  _SC_THREAD_PROCESS_SHARED
  _SC_THREAD_SAFE_FUNCTIONS
  _SC_THREAD_STACK_MIN
  _SC_THREAD_THREADS_MAX
  _SC_TIMERS
  _SC_TIMER_MAX
  _SC_TTY_NAME_MAX
  _SC_TZNAME_MAX
  _SC_T_IOV_MAX
  _SC_VERSION
  _SC_XBS5_ILP32_OFF32
  _SC_XBS5_ILP32_OFFBIG
  _SC_XBS5_LP64_OFF64
  _SC_XBS5_LPBIG_OFFBIG
  _SC_XOPEN_CRYPT
  _SC_XOPEN_ENH_I18N
  _SC_XOPEN_LEGACY
  _SC_XOPEN_REALTIME
  _SC_XOPEN_REALTIME_THREADS
  _SC_XOPEN_SHM
  _SC_XOPEN_UNIX
  _SC_XOPEN_VERSION
  _SC_XOPEN_XCU_VERSION
  _XOPEN_ENH_I18N
  _XOPEN_REALTIME
  _XOPEN_SHM
  _XOPEN_UNIX
  _XOPEN_XCU_VERSION
  _XOPEN_XPG3
  _XOPEN_XPG4

=head1 AUTHOR

Alexander Golomshtok, E<lt>golomshtok_alexander@jpmorgan.comE<gt>

=head1 SEE ALSO

L<perl>, L<sysconf(3C)>

=cut
