# *** DO NOT EDIT *** generated file *** DO NOT EDIT ***
#
# generated by lib/Net/IDN/UTS46/GenTests.PL from data/IdnaTest.txt
# see repository at http://github.com/cfaerber/Net-IDN-Encode for source files
#
use strict;
use utf8;
use open ':std', ':utf8';
use warnings;

use Test::More tests => 6197 + 1;
use Test::NoWarnings;

use Unicode::UCD;
use Net::IDN::UTS46 (':all');

no warnings 'utf8';

our $UCD_VERSION = eval('v'.(Unicode::UCD::UnicodeVersion()));

my %p = ("TransitionalProcessing" => "1");

is(eval{uts46_to_ascii("fass.de", %p)},	"fass.de",	"to_ascii\(\'fass\.de\'\)\ \[data\/IdnaTest\.txt\:75\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("faß.de", %p)},	"fass.de",	"to_ascii\(\'faß\.de\'\)\ \[data\/IdnaTest\.txt\:76\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Faß.de", %p)},	"fass.de",	"to_ascii\(\'Faß\.de\'\)\ \[data\/IdnaTest\.txt\:78\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--fa-hia.de", %p)},	"xn--fa-hia.de",	"to_ascii\(\'xn\-\-fa\-hia\.de\'\)\ \[data\/IdnaTest\.txt\:80\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("à\x{05D0}", %p)},	undef,	"to_ascii\(\'à\\u05D0\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:84\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("a\x{0300}\x{05D0}", %p)},	undef,	"to_ascii\(\'a\\u0300\\u05D0\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:85\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A\x{0300}\x{05D0}", %p)},	undef,	"to_ascii\(\'A\\u0300\\u05D0\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:86\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("À\x{05D0}", %p)},	undef,	"to_ascii\(\'À\\u05D0\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:87\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--0ca24w", %p)},	undef,	"to_ascii\(\'xn\-\-0ca24w\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:88\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("0à.\x{05D0}", %p)},	undef,	"to_ascii\(\'0à\.\\u05D0\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:89\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("0a\x{0300}.\x{05D0}", %p)},	undef,	"to_ascii\(\'0a\\u0300\.\\u05D0\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:90\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("0A\x{0300}.\x{05D0}", %p)},	undef,	"to_ascii\(\'0A\\u0300\.\\u05D0\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:91\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("0À.\x{05D0}", %p)},	undef,	"to_ascii\(\'0À\.\\u05D0\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:92\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--0-sfa.xn--4db", %p)},	undef,	"to_ascii\(\'xn\-\-0\-sfa\.xn\-\-4db\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:93\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("à.\x{05D0}\x{0308}", %p)},	"xn--0ca.xn--ssa73l",	"to_ascii\(\'à\.\\u05D0\\u0308\'\)\ \[data\/IdnaTest\.txt\:94\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("a\x{0300}.\x{05D0}\x{0308}", %p)},	"xn--0ca.xn--ssa73l",	"to_ascii\(\'a\\u0300\.\\u05D0\\u0308\'\)\ \[data\/IdnaTest\.txt\:95\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A\x{0300}.\x{05D0}\x{0308}", %p)},	"xn--0ca.xn--ssa73l",	"to_ascii\(\'A\\u0300\.\\u05D0\\u0308\'\)\ \[data\/IdnaTest\.txt\:96\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("À.\x{05D0}\x{0308}", %p)},	"xn--0ca.xn--ssa73l",	"to_ascii\(\'À\.\\u05D0\\u0308\'\)\ \[data\/IdnaTest\.txt\:97\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--0ca.xn--ssa73l", %p)},	"xn--0ca.xn--ssa73l",	"to_ascii\(\'xn\-\-0ca\.xn\-\-ssa73l\'\)\ \[data\/IdnaTest\.txt\:98\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("à.\x{05D0}0\x{0660}\x{05D0}", %p)},	undef,	"to_ascii\(\'à\.\\u05D00\\u0660\\u05D0\'\)\ throws\ error\ B4\ \[data\/IdnaTest\.txt\:99\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("a\x{0300}.\x{05D0}0\x{0660}\x{05D0}", %p)},	undef,	"to_ascii\(\'a\\u0300\.\\u05D00\\u0660\\u05D0\'\)\ throws\ error\ B4\ \[data\/IdnaTest\.txt\:100\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A\x{0300}.\x{05D0}0\x{0660}\x{05D0}", %p)},	undef,	"to_ascii\(\'A\\u0300\.\\u05D00\\u0660\\u05D0\'\)\ throws\ error\ B4\ \[data\/IdnaTest\.txt\:101\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("À.\x{05D0}0\x{0660}\x{05D0}", %p)},	undef,	"to_ascii\(\'À\.\\u05D00\\u0660\\u05D0\'\)\ throws\ error\ B4\ \[data\/IdnaTest\.txt\:102\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--0ca.xn--0-zhcb98c", %p)},	undef,	"to_ascii\(\'xn\-\-0ca\.xn\-\-0\-zhcb98c\'\)\ throws\ error\ B4\ \[data\/IdnaTest\.txt\:103\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0308}.\x{05D0}", %p)},	undef,	"to_ascii\(\'\\u0308\.\\u05D0\'\)\ throws\ error\ B1\ B3\ B6\ V5\ \[data\/IdnaTest\.txt\:104\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--ssa.xn--4db", %p)},	undef,	"to_ascii\(\'xn\-\-ssa\.xn\-\-4db\'\)\ throws\ error\ B1\ B3\ B6\ V5\ \[data\/IdnaTest\.txt\:105\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("à.\x{05D0}0\x{0660}", %p)},	undef,	"to_ascii\(\'à\.\\u05D00\\u0660\'\)\ throws\ error\ B4\ \[data\/IdnaTest\.txt\:106\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("a\x{0300}.\x{05D0}0\x{0660}", %p)},	undef,	"to_ascii\(\'a\\u0300\.\\u05D00\\u0660\'\)\ throws\ error\ B4\ \[data\/IdnaTest\.txt\:107\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A\x{0300}.\x{05D0}0\x{0660}", %p)},	undef,	"to_ascii\(\'A\\u0300\.\\u05D00\\u0660\'\)\ throws\ error\ B4\ \[data\/IdnaTest\.txt\:108\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("À.\x{05D0}0\x{0660}", %p)},	undef,	"to_ascii\(\'À\.\\u05D00\\u0660\'\)\ throws\ error\ B4\ \[data\/IdnaTest\.txt\:109\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--0ca.xn--0-zhc74b", %p)},	undef,	"to_ascii\(\'xn\-\-0ca\.xn\-\-0\-zhc74b\'\)\ throws\ error\ B4\ \[data\/IdnaTest\.txt\:110\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("àˇ.\x{05D0}", %p)},	undef,	"to_ascii\(\'àˇ\.\\u05D0\'\)\ throws\ error\ B6\ \[data\/IdnaTest\.txt\:111\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("a\x{0300}ˇ.\x{05D0}", %p)},	undef,	"to_ascii\(\'a\\u0300ˇ\.\\u05D0\'\)\ throws\ error\ B6\ \[data\/IdnaTest\.txt\:112\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A\x{0300}ˇ.\x{05D0}", %p)},	undef,	"to_ascii\(\'A\\u0300ˇ\.\\u05D0\'\)\ throws\ error\ B6\ \[data\/IdnaTest\.txt\:113\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Àˇ.\x{05D0}", %p)},	undef,	"to_ascii\(\'Àˇ\.\\u05D0\'\)\ throws\ error\ B6\ \[data\/IdnaTest\.txt\:114\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--0ca88g.xn--4db", %p)},	undef,	"to_ascii\(\'xn\-\-0ca88g\.xn\-\-4db\'\)\ throws\ error\ B6\ \[data\/IdnaTest\.txt\:115\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("à\x{0308}.\x{05D0}", %p)},	"xn--0ca81i.xn--4db",	"to_ascii\(\'à\\u0308\.\\u05D0\'\)\ \[data\/IdnaTest\.txt\:116\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("a\x{0300}\x{0308}.\x{05D0}", %p)},	"xn--0ca81i.xn--4db",	"to_ascii\(\'a\\u0300\\u0308\.\\u05D0\'\)\ \[data\/IdnaTest\.txt\:117\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A\x{0300}\x{0308}.\x{05D0}", %p)},	"xn--0ca81i.xn--4db",	"to_ascii\(\'A\\u0300\\u0308\.\\u05D0\'\)\ \[data\/IdnaTest\.txt\:118\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("À\x{0308}.\x{05D0}", %p)},	"xn--0ca81i.xn--4db",	"to_ascii\(\'À\\u0308\.\\u05D0\'\)\ \[data\/IdnaTest\.txt\:119\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--0ca81i.xn--4db", %p)},	"xn--0ca81i.xn--4db",	"to_ascii\(\'xn\-\-0ca81i\.xn\-\-4db\'\)\ \[data\/IdnaTest\.txt\:120\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("a\x{200C}b", %p)},	"ab",	"to_ascii\(\'a\\u200Cb\'\)\ \[data\/IdnaTest\.txt\:124\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A\x{200C}B", %p)},	"ab",	"to_ascii\(\'A\\u200CB\'\)\ \[data\/IdnaTest\.txt\:126\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A\x{200C}b", %p)},	"ab",	"to_ascii\(\'A\\u200Cb\'\)\ \[data\/IdnaTest\.txt\:128\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ab", %p)},	"ab",	"to_ascii\(\'ab\'\)\ \[data\/IdnaTest\.txt\:130\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--ab-j1t", %p)},	undef,	"to_ascii\(\'xn\-\-ab\-j1t\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:131\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("a\x{094D}\x{200C}b", %p)},	"xn--ab-fsf",	"to_ascii\(\'a\\u094D\\u200Cb\'\)\ \[data\/IdnaTest\.txt\:132\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A\x{094D}\x{200C}B", %p)},	"xn--ab-fsf",	"to_ascii\(\'A\\u094D\\u200CB\'\)\ \[data\/IdnaTest\.txt\:134\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A\x{094D}\x{200C}b", %p)},	"xn--ab-fsf",	"to_ascii\(\'A\\u094D\\u200Cb\'\)\ \[data\/IdnaTest\.txt\:136\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--ab-fsf", %p)},	"xn--ab-fsf",	"to_ascii\(\'xn\-\-ab\-fsf\'\)\ \[data\/IdnaTest\.txt\:138\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("a\x{094D}b", %p)},	"xn--ab-fsf",	"to_ascii\(\'a\\u094Db\'\)\ \[data\/IdnaTest\.txt\:139\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A\x{094D}B", %p)},	"xn--ab-fsf",	"to_ascii\(\'A\\u094DB\'\)\ \[data\/IdnaTest\.txt\:140\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A\x{094D}b", %p)},	"xn--ab-fsf",	"to_ascii\(\'A\\u094Db\'\)\ \[data\/IdnaTest\.txt\:141\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--ab-fsf604u", %p)},	"xn--ab-fsf604u",	"to_ascii\(\'xn\-\-ab\-fsf604u\'\)\ \[data\/IdnaTest\.txt\:142\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0308}\x{200C}\x{0308}\x{0628}b", %p)},	undef,	"to_ascii\(\'\\u0308\\u200C\\u0308\\u0628b\'\)\ throws\ error\ B1\ V5\ \[data\/IdnaTest\.txt\:143\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0308}\x{200C}\x{0308}\x{0628}B", %p)},	undef,	"to_ascii\(\'\\u0308\\u200C\\u0308\\u0628B\'\)\ throws\ error\ B1\ V5\ \[data\/IdnaTest\.txt\:145\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--b-bcba413a", %p)},	undef,	"to_ascii\(\'xn\-\-b\-bcba413a\'\)\ throws\ error\ B1\ V5\ \[data\/IdnaTest\.txt\:147\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--b-bcba413a2w8b", %p)},	undef,	"to_ascii\(\'xn\-\-b\-bcba413a2w8b\'\)\ throws\ error\ B1\ C1\ V5\ \[data\/IdnaTest\.txt\:148\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("a\x{0628}\x{0308}\x{200C}\x{0308}", %p)},	undef,	"to_ascii\(\'a\\u0628\\u0308\\u200C\\u0308\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:149\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A\x{0628}\x{0308}\x{200C}\x{0308}", %p)},	undef,	"to_ascii\(\'A\\u0628\\u0308\\u200C\\u0308\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:151\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--a-ccba213a", %p)},	undef,	"to_ascii\(\'xn\-\-a\-ccba213a\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:153\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--a-ccba213a5w8b", %p)},	undef,	"to_ascii\(\'xn\-\-a\-ccba213a5w8b\'\)\ throws\ error\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:154\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("a\x{0628}\x{0308}\x{200C}\x{0308}\x{0628}b", %p)},	undef,	"to_ascii\(\'a\\u0628\\u0308\\u200C\\u0308\\u0628b\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:155\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A\x{0628}\x{0308}\x{200C}\x{0308}\x{0628}B", %p)},	undef,	"to_ascii\(\'A\\u0628\\u0308\\u200C\\u0308\\u0628B\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:157\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A\x{0628}\x{0308}\x{200C}\x{0308}\x{0628}b", %p)},	undef,	"to_ascii\(\'A\\u0628\\u0308\\u200C\\u0308\\u0628b\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:159\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--ab-uuba211bca", %p)},	undef,	"to_ascii\(\'xn\-\-ab\-uuba211bca\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:161\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--ab-uuba211bca8057b", %p)},	undef,	"to_ascii\(\'xn\-\-ab\-uuba211bca8057b\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:162\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("a\x{200D}b", %p)},	"ab",	"to_ascii\(\'a\\u200Db\'\)\ \[data\/IdnaTest\.txt\:163\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A\x{200D}B", %p)},	"ab",	"to_ascii\(\'A\\u200DB\'\)\ \[data\/IdnaTest\.txt\:165\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A\x{200D}b", %p)},	"ab",	"to_ascii\(\'A\\u200Db\'\)\ \[data\/IdnaTest\.txt\:167\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--ab-m1t", %p)},	undef,	"to_ascii\(\'xn\-\-ab\-m1t\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:169\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("a\x{094D}\x{200D}b", %p)},	"xn--ab-fsf",	"to_ascii\(\'a\\u094D\\u200Db\'\)\ \[data\/IdnaTest\.txt\:170\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A\x{094D}\x{200D}B", %p)},	"xn--ab-fsf",	"to_ascii\(\'A\\u094D\\u200DB\'\)\ \[data\/IdnaTest\.txt\:172\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A\x{094D}\x{200D}b", %p)},	"xn--ab-fsf",	"to_ascii\(\'A\\u094D\\u200Db\'\)\ \[data\/IdnaTest\.txt\:174\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--ab-fsf014u", %p)},	"xn--ab-fsf014u",	"to_ascii\(\'xn\-\-ab\-fsf014u\'\)\ \[data\/IdnaTest\.txt\:176\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0308}\x{200D}\x{0308}\x{0628}b", %p)},	undef,	"to_ascii\(\'\\u0308\\u200D\\u0308\\u0628b\'\)\ throws\ error\ B1\ V5\ \[data\/IdnaTest\.txt\:177\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0308}\x{200D}\x{0308}\x{0628}B", %p)},	undef,	"to_ascii\(\'\\u0308\\u200D\\u0308\\u0628B\'\)\ throws\ error\ B1\ V5\ \[data\/IdnaTest\.txt\:179\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--b-bcba413a7w8b", %p)},	undef,	"to_ascii\(\'xn\-\-b\-bcba413a7w8b\'\)\ throws\ error\ B1\ C2\ V5\ \[data\/IdnaTest\.txt\:181\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("a\x{0628}\x{0308}\x{200D}\x{0308}", %p)},	undef,	"to_ascii\(\'a\\u0628\\u0308\\u200D\\u0308\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:182\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A\x{0628}\x{0308}\x{200D}\x{0308}", %p)},	undef,	"to_ascii\(\'A\\u0628\\u0308\\u200D\\u0308\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:184\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--a-ccba213abx8b", %p)},	undef,	"to_ascii\(\'xn\-\-a\-ccba213abx8b\'\)\ throws\ error\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:186\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("a\x{0628}\x{0308}\x{200D}\x{0308}\x{0628}b", %p)},	undef,	"to_ascii\(\'a\\u0628\\u0308\\u200D\\u0308\\u0628b\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:187\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A\x{0628}\x{0308}\x{200D}\x{0308}\x{0628}B", %p)},	undef,	"to_ascii\(\'A\\u0628\\u0308\\u200D\\u0308\\u0628B\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:189\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A\x{0628}\x{0308}\x{200D}\x{0308}\x{0628}b", %p)},	undef,	"to_ascii\(\'A\\u0628\\u0308\\u200D\\u0308\\u0628b\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:191\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--ab-uuba211bca5157b", %p)},	undef,	"to_ascii\(\'xn\-\-ab\-uuba211bca5157b\'\)\ throws\ error\ B5\ C2\ \[data\/IdnaTest\.txt\:193\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("¡", %p)},	"xn--7a",	"to_ascii\(\'\¡\'\)\ \[data\/IdnaTest\.txt\:197\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--7a", %p)},	"xn--7a",	"to_ascii\(\'xn\-\-7a\'\)\ \[data\/IdnaTest\.txt\:198\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("᧚", %p)},	"xn--pkf",	"to_ascii\(\'᧚\'\)\ \[data\/IdnaTest\.txt\:199\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("xn--pkf", %p)},	"xn--pkf",	"to_ascii\(\'xn\-\-pkf\'\)\ \[data\/IdnaTest\.txt\:200\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("。", %p)},	undef,	"to_ascii\(\'\。\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:201\]") or ($@ and diag($@));
is(eval{uts46_to_ascii(".", %p)},	undef,	"to_ascii\(\'\.\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:202\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_ascii("ꭠ", %p)},	"xn--3y9a",	"to_ascii\(\'ꭠ\'\)\ \[data\/IdnaTest\.txt\:203\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_ascii("xn--3y9a", %p)},	"xn--3y9a",	"to_ascii\(\'xn\-\-3y9a\'\)\ \[data\/IdnaTest\.txt\:204\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("1234567890ä1234567890123456789012345678901234567890123456", %p)},	undef,	"to_ascii\(\'1234567890ä1234567890123456789012345678901234567890123456\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:205\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("1234567890a\x{0308}1234567890123456789012345678901234567890123456", %p)},	undef,	"to_ascii\(\'1234567890a\\u03081234567890123456789012345678901234567890123456\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:206\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("1234567890A\x{0308}1234567890123456789012345678901234567890123456", %p)},	undef,	"to_ascii\(\'1234567890A\\u03081234567890123456789012345678901234567890123456\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:207\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("1234567890Ä1234567890123456789012345678901234567890123456", %p)},	undef,	"to_ascii\(\'1234567890Ä1234567890123456789012345678901234567890123456\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:208\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--12345678901234567890123456789012345678901234567890123456-fxe", %p)},	undef,	"to_ascii\(\'xn\-\-12345678901234567890123456789012345678901234567890123456\-fxe\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:209\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("www.eXample.cOm", %p)},	"www.example.com",	"to_ascii\(\'www\.eXample\.cOm\'\)\ \[data\/IdnaTest\.txt\:210\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Bücher.de", %p)},	"xn--bcher-kva.de",	"to_ascii\(\'Bücher\.de\'\)\ \[data\/IdnaTest\.txt\:211\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Bu\x{0308}cher.de", %p)},	"xn--bcher-kva.de",	"to_ascii\(\'Bu\\u0308cher\.de\'\)\ \[data\/IdnaTest\.txt\:212\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("bu\x{0308}cher.de", %p)},	"xn--bcher-kva.de",	"to_ascii\(\'bu\\u0308cher\.de\'\)\ \[data\/IdnaTest\.txt\:213\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("bücher.de", %p)},	"xn--bcher-kva.de",	"to_ascii\(\'bücher\.de\'\)\ \[data\/IdnaTest\.txt\:214\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("BÜCHER.DE", %p)},	"xn--bcher-kva.de",	"to_ascii\(\'BÜCHER\.DE\'\)\ \[data\/IdnaTest\.txt\:215\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("BU\x{0308}CHER.DE", %p)},	"xn--bcher-kva.de",	"to_ascii\(\'BU\\u0308CHER\.DE\'\)\ \[data\/IdnaTest\.txt\:216\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--bcher-kva.de", %p)},	"xn--bcher-kva.de",	"to_ascii\(\'xn\-\-bcher\-kva\.de\'\)\ \[data\/IdnaTest\.txt\:217\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ÖBB", %p)},	"xn--bb-eka",	"to_ascii\(\'ÖBB\'\)\ \[data\/IdnaTest\.txt\:218\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("O\x{0308}BB", %p)},	"xn--bb-eka",	"to_ascii\(\'O\\u0308BB\'\)\ \[data\/IdnaTest\.txt\:219\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("o\x{0308}bb", %p)},	"xn--bb-eka",	"to_ascii\(\'o\\u0308bb\'\)\ \[data\/IdnaTest\.txt\:220\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("öbb", %p)},	"xn--bb-eka",	"to_ascii\(\'öbb\'\)\ \[data\/IdnaTest\.txt\:221\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Öbb", %p)},	"xn--bb-eka",	"to_ascii\(\'Öbb\'\)\ \[data\/IdnaTest\.txt\:222\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("O\x{0308}bb", %p)},	"xn--bb-eka",	"to_ascii\(\'O\\u0308bb\'\)\ \[data\/IdnaTest\.txt\:223\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--bb-eka", %p)},	"xn--bb-eka",	"to_ascii\(\'xn\-\-bb\-eka\'\)\ \[data\/IdnaTest\.txt\:224\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("βόλος.com", %p)},	"xn--nxasmq6b.com",	"to_ascii\(\'βόλος\.com\'\)\ \[data\/IdnaTest\.txt\:225\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("βο\x{0301}λος.com", %p)},	"xn--nxasmq6b.com",	"to_ascii\(\'βο\\u0301λος\.com\'\)\ \[data\/IdnaTest\.txt\:227\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ΒΟ\x{0301}ΛΟΣ.COM", %p)},	"xn--nxasmq6b.com",	"to_ascii\(\'ΒΟ\\u0301ΛΟΣ\.COM\'\)\ \[data\/IdnaTest\.txt\:229\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ΒΌΛΟΣ.COM", %p)},	"xn--nxasmq6b.com",	"to_ascii\(\'ΒΌΛΟΣ\.COM\'\)\ \[data\/IdnaTest\.txt\:230\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("βόλοσ.com", %p)},	"xn--nxasmq6b.com",	"to_ascii\(\'βόλοσ\.com\'\)\ \[data\/IdnaTest\.txt\:231\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("βο\x{0301}λοσ.com", %p)},	"xn--nxasmq6b.com",	"to_ascii\(\'βο\\u0301λοσ\.com\'\)\ \[data\/IdnaTest\.txt\:232\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Βο\x{0301}λοσ.com", %p)},	"xn--nxasmq6b.com",	"to_ascii\(\'Βο\\u0301λοσ\.com\'\)\ \[data\/IdnaTest\.txt\:233\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Βόλοσ.com", %p)},	"xn--nxasmq6b.com",	"to_ascii\(\'Βόλοσ\.com\'\)\ \[data\/IdnaTest\.txt\:234\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--nxasmq6b.com", %p)},	"xn--nxasmq6b.com",	"to_ascii\(\'xn\-\-nxasmq6b\.com\'\)\ \[data\/IdnaTest\.txt\:235\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Βο\x{0301}λος.com", %p)},	"xn--nxasmq6b.com",	"to_ascii\(\'Βο\\u0301λος\.com\'\)\ \[data\/IdnaTest\.txt\:236\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Βόλος.com", %p)},	"xn--nxasmq6b.com",	"to_ascii\(\'Βόλος\.com\'\)\ \[data\/IdnaTest\.txt\:238\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--nxasmm1c.com", %p)},	"xn--nxasmm1c.com",	"to_ascii\(\'xn\-\-nxasmm1c\.com\'\)\ \[data\/IdnaTest\.txt\:240\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--nxasmm1c", %p)},	"xn--nxasmm1c",	"to_ascii\(\'xn\-\-nxasmm1c\'\)\ \[data\/IdnaTest\.txt\:241\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("βόλος", %p)},	"xn--nxasmq6b",	"to_ascii\(\'βόλος\'\)\ \[data\/IdnaTest\.txt\:242\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("βο\x{0301}λος", %p)},	"xn--nxasmq6b",	"to_ascii\(\'βο\\u0301λος\'\)\ \[data\/IdnaTest\.txt\:244\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ΒΟ\x{0301}ΛΟΣ", %p)},	"xn--nxasmq6b",	"to_ascii\(\'ΒΟ\\u0301ΛΟΣ\'\)\ \[data\/IdnaTest\.txt\:246\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ΒΌΛΟΣ", %p)},	"xn--nxasmq6b",	"to_ascii\(\'ΒΌΛΟΣ\'\)\ \[data\/IdnaTest\.txt\:247\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("βόλοσ", %p)},	"xn--nxasmq6b",	"to_ascii\(\'βόλοσ\'\)\ \[data\/IdnaTest\.txt\:248\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("βο\x{0301}λοσ", %p)},	"xn--nxasmq6b",	"to_ascii\(\'βο\\u0301λοσ\'\)\ \[data\/IdnaTest\.txt\:249\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Βο\x{0301}λοσ", %p)},	"xn--nxasmq6b",	"to_ascii\(\'Βο\\u0301λοσ\'\)\ \[data\/IdnaTest\.txt\:250\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Βόλοσ", %p)},	"xn--nxasmq6b",	"to_ascii\(\'Βόλοσ\'\)\ \[data\/IdnaTest\.txt\:251\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--nxasmq6b", %p)},	"xn--nxasmq6b",	"to_ascii\(\'xn\-\-nxasmq6b\'\)\ \[data\/IdnaTest\.txt\:252\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Βόλος", %p)},	"xn--nxasmq6b",	"to_ascii\(\'Βόλος\'\)\ \[data\/IdnaTest\.txt\:253\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Βο\x{0301}λος", %p)},	"xn--nxasmq6b",	"to_ascii\(\'Βο\\u0301λος\'\)\ \[data\/IdnaTest\.txt\:255\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("www.ශ\x{0DCA}\x{200D}ර\x{0DD3}.com", %p)},	"www.xn--10cl1a0b.com",	"to_ascii\(\'www\.ශ\\u0DCA\\u200Dර\\u0DD3\.com\'\)\ \[data\/IdnaTest\.txt\:257\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("WWW.ශ\x{0DCA}\x{200D}ර\x{0DD3}.COM", %p)},	"www.xn--10cl1a0b.com",	"to_ascii\(\'WWW\.ශ\\u0DCA\\u200Dර\\u0DD3\.COM\'\)\ \[data\/IdnaTest\.txt\:259\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Www.ශ\x{0DCA}\x{200D}ර\x{0DD3}.com", %p)},	"www.xn--10cl1a0b.com",	"to_ascii\(\'Www\.ශ\\u0DCA\\u200Dර\\u0DD3\.com\'\)\ \[data\/IdnaTest\.txt\:261\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("www.xn--10cl1a0b.com", %p)},	"www.xn--10cl1a0b.com",	"to_ascii\(\'www\.xn\-\-10cl1a0b\.com\'\)\ \[data\/IdnaTest\.txt\:263\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("www.ශ\x{0DCA}ර\x{0DD3}.com", %p)},	"www.xn--10cl1a0b.com",	"to_ascii\(\'www\.ශ\\u0DCAර\\u0DD3\.com\'\)\ \[data\/IdnaTest\.txt\:264\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("WWW.ශ\x{0DCA}ර\x{0DD3}.COM", %p)},	"www.xn--10cl1a0b.com",	"to_ascii\(\'WWW\.ශ\\u0DCAර\\u0DD3\.COM\'\)\ \[data\/IdnaTest\.txt\:265\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Www.ශ\x{0DCA}ර\x{0DD3}.com", %p)},	"www.xn--10cl1a0b.com",	"to_ascii\(\'Www\.ශ\\u0DCAර\\u0DD3\.com\'\)\ \[data\/IdnaTest\.txt\:266\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("www.xn--10cl1a0b660p.com", %p)},	"www.xn--10cl1a0b660p.com",	"to_ascii\(\'www\.xn\-\-10cl1a0b660p\.com\'\)\ \[data\/IdnaTest\.txt\:267\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0646}\x{0627}\x{0645}\x{0647}\x{200C}\x{0627}\x{06CC}", %p)},	"xn--mgba3gch31f",	"to_ascii\(\'\\u0646\\u0627\\u0645\\u0647\\u200C\\u0627\\u06CC\'\)\ \[data\/IdnaTest\.txt\:268\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--mgba3gch31f", %p)},	"xn--mgba3gch31f",	"to_ascii\(\'xn\-\-mgba3gch31f\'\)\ \[data\/IdnaTest\.txt\:270\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0646}\x{0627}\x{0645}\x{0647}\x{0627}\x{06CC}", %p)},	"xn--mgba3gch31f",	"to_ascii\(\'\\u0646\\u0627\\u0645\\u0647\\u0627\\u06CC\'\)\ \[data\/IdnaTest\.txt\:271\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--mgba3gch31f060k", %p)},	"xn--mgba3gch31f060k",	"to_ascii\(\'xn\-\-mgba3gch31f060k\'\)\ \[data\/IdnaTest\.txt\:272\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--mgba3gch31f060k.com", %p)},	"xn--mgba3gch31f060k.com",	"to_ascii\(\'xn\-\-mgba3gch31f060k\.com\'\)\ \[data\/IdnaTest\.txt\:273\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0646}\x{0627}\x{0645}\x{0647}\x{200C}\x{0627}\x{06CC}.com", %p)},	"xn--mgba3gch31f.com",	"to_ascii\(\'\\u0646\\u0627\\u0645\\u0647\\u200C\\u0627\\u06CC\.com\'\)\ \[data\/IdnaTest\.txt\:274\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0646}\x{0627}\x{0645}\x{0647}\x{200C}\x{0627}\x{06CC}.COM", %p)},	"xn--mgba3gch31f.com",	"to_ascii\(\'\\u0646\\u0627\\u0645\\u0647\\u200C\\u0627\\u06CC\.COM\'\)\ \[data\/IdnaTest\.txt\:276\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0646}\x{0627}\x{0645}\x{0647}\x{200C}\x{0627}\x{06CC}.Com", %p)},	"xn--mgba3gch31f.com",	"to_ascii\(\'\\u0646\\u0627\\u0645\\u0647\\u200C\\u0627\\u06CC\.Com\'\)\ \[data\/IdnaTest\.txt\:278\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--mgba3gch31f.com", %p)},	"xn--mgba3gch31f.com",	"to_ascii\(\'xn\-\-mgba3gch31f\.com\'\)\ \[data\/IdnaTest\.txt\:280\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0646}\x{0627}\x{0645}\x{0647}\x{0627}\x{06CC}.com", %p)},	"xn--mgba3gch31f.com",	"to_ascii\(\'\\u0646\\u0627\\u0645\\u0647\\u0627\\u06CC\.com\'\)\ \[data\/IdnaTest\.txt\:281\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0646}\x{0627}\x{0645}\x{0647}\x{0627}\x{06CC}.COM", %p)},	"xn--mgba3gch31f.com",	"to_ascii\(\'\\u0646\\u0627\\u0645\\u0647\\u0627\\u06CC\.COM\'\)\ \[data\/IdnaTest\.txt\:282\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0646}\x{0627}\x{0645}\x{0647}\x{0627}\x{06CC}.Com", %p)},	"xn--mgba3gch31f.com",	"to_ascii\(\'\\u0646\\u0627\\u0645\\u0647\\u0627\\u06CC\.Com\'\)\ \[data\/IdnaTest\.txt\:283\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("a.b．c。d｡", %p)},	"a.b.c.d.",	"to_ascii\(\'a\.b．c\。d｡\'\)\ \[data\/IdnaTest\.txt\:284\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("a.b.c。d。", %p)},	"a.b.c.d.",	"to_ascii\(\'a\.b\.c\。d\。\'\)\ \[data\/IdnaTest\.txt\:285\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A.B.C。D。", %p)},	"a.b.c.d.",	"to_ascii\(\'A\.B\.C\。D\。\'\)\ \[data\/IdnaTest\.txt\:286\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A.b.c。D。", %p)},	"a.b.c.d.",	"to_ascii\(\'A\.b\.c\。D\。\'\)\ \[data\/IdnaTest\.txt\:287\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("a.b.c.d.", %p)},	"a.b.c.d.",	"to_ascii\(\'a\.b\.c\.d\.\'\)\ \[data\/IdnaTest\.txt\:288\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A.B．C。D｡", %p)},	"a.b.c.d.",	"to_ascii\(\'A\.B．C\。D｡\'\)\ \[data\/IdnaTest\.txt\:289\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A.b．c。D｡", %p)},	"a.b.c.d.",	"to_ascii\(\'A\.b．c\。D｡\'\)\ \[data\/IdnaTest\.txt\:290\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("U\x{0308}.xn--tda", %p)},	"xn--tda.xn--tda",	"to_ascii\(\'U\\u0308\.xn\-\-tda\'\)\ \[data\/IdnaTest\.txt\:291\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ü.xn--tda", %p)},	"xn--tda.xn--tda",	"to_ascii\(\'Ü\.xn\-\-tda\'\)\ \[data\/IdnaTest\.txt\:292\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ü.xn--tda", %p)},	"xn--tda.xn--tda",	"to_ascii\(\'ü\.xn\-\-tda\'\)\ \[data\/IdnaTest\.txt\:293\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("u\x{0308}.xn--tda", %p)},	"xn--tda.xn--tda",	"to_ascii\(\'u\\u0308\.xn\-\-tda\'\)\ \[data\/IdnaTest\.txt\:294\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("U\x{0308}.XN--TDA", %p)},	"xn--tda.xn--tda",	"to_ascii\(\'U\\u0308\.XN\-\-TDA\'\)\ \[data\/IdnaTest\.txt\:295\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ü.XN--TDA", %p)},	"xn--tda.xn--tda",	"to_ascii\(\'Ü\.XN\-\-TDA\'\)\ \[data\/IdnaTest\.txt\:296\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ü.xn--Tda", %p)},	"xn--tda.xn--tda",	"to_ascii\(\'Ü\.xn\-\-Tda\'\)\ \[data\/IdnaTest\.txt\:297\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("U\x{0308}.xn--Tda", %p)},	"xn--tda.xn--tda",	"to_ascii\(\'U\\u0308\.xn\-\-Tda\'\)\ \[data\/IdnaTest\.txt\:298\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--tda.xn--tda", %p)},	"xn--tda.xn--tda",	"to_ascii\(\'xn\-\-tda\.xn\-\-tda\'\)\ \[data\/IdnaTest\.txt\:299\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ü.ü", %p)},	"xn--tda.xn--tda",	"to_ascii\(\'ü\.ü\'\)\ \[data\/IdnaTest\.txt\:300\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("u\x{0308}.u\x{0308}", %p)},	"xn--tda.xn--tda",	"to_ascii\(\'u\\u0308\.u\\u0308\'\)\ \[data\/IdnaTest\.txt\:301\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("U\x{0308}.U\x{0308}", %p)},	"xn--tda.xn--tda",	"to_ascii\(\'U\\u0308\.U\\u0308\'\)\ \[data\/IdnaTest\.txt\:302\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ü.Ü", %p)},	"xn--tda.xn--tda",	"to_ascii\(\'Ü\.Ü\'\)\ \[data\/IdnaTest\.txt\:303\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ü.ü", %p)},	"xn--tda.xn--tda",	"to_ascii\(\'Ü\.ü\'\)\ \[data\/IdnaTest\.txt\:304\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("U\x{0308}.u\x{0308}", %p)},	"xn--tda.xn--tda",	"to_ascii\(\'U\\u0308\.u\\u0308\'\)\ \[data\/IdnaTest\.txt\:305\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--u-ccb", %p)},	undef,	"to_ascii\(\'xn\-\-u\-ccb\'\)\ throws\ error\ V1\ \[data\/IdnaTest\.txt\:306\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("a⒈com", %p)},	undef,	"to_ascii\(\'a⒈com\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:307\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("a1.com", %p)},	"a1.com",	"to_ascii\(\'a1\.com\'\)\ \[data\/IdnaTest\.txt\:308\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A⒈COM", %p)},	undef,	"to_ascii\(\'A⒈COM\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:309\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A⒈Com", %p)},	undef,	"to_ascii\(\'A⒈Com\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:310\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--acom-0w1b", %p)},	undef,	"to_ascii\(\'xn\-\-acom\-0w1b\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:311\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--a-ecp.ru", %p)},	undef,	"to_ascii\(\'xn\-\-a\-ecp\.ru\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:312\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--0.pt", %p)},	undef,	"to_ascii\(\'xn\-\-0\.pt\'\)\ throws\ error\ A3\ \[data\/IdnaTest\.txt\:313\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--a.pt", %p)},	undef,	"to_ascii\(\'xn\-\-a\.pt\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:314\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--a-Ä.pt", %p)},	undef,	"to_ascii\(\'xn\-\-a\-Ä\.pt\'\)\ throws\ error\ A3\ \[data\/IdnaTest\.txt\:315\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--a-A\x{0308}.pt", %p)},	undef,	"to_ascii\(\'xn\-\-a\-A\\u0308\.pt\'\)\ throws\ error\ A3\ \[data\/IdnaTest\.txt\:316\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--a-a\x{0308}.pt", %p)},	undef,	"to_ascii\(\'xn\-\-a\-a\\u0308\.pt\'\)\ throws\ error\ A3\ \[data\/IdnaTest\.txt\:317\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--a-ä.pt", %p)},	undef,	"to_ascii\(\'xn\-\-a\-ä\.pt\'\)\ throws\ error\ A3\ \[data\/IdnaTest\.txt\:318\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("XN--A-Ä.PT", %p)},	undef,	"to_ascii\(\'XN\-\-A\-Ä\.PT\'\)\ throws\ error\ A3\ \[data\/IdnaTest\.txt\:319\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("XN--A-A\x{0308}.PT", %p)},	undef,	"to_ascii\(\'XN\-\-A\-A\\u0308\.PT\'\)\ throws\ error\ A3\ \[data\/IdnaTest\.txt\:320\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Xn--A-A\x{0308}.pt", %p)},	undef,	"to_ascii\(\'Xn\-\-A\-A\\u0308\.pt\'\)\ throws\ error\ A3\ \[data\/IdnaTest\.txt\:321\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Xn--A-Ä.pt", %p)},	undef,	"to_ascii\(\'Xn\-\-A\-Ä\.pt\'\)\ throws\ error\ A3\ \[data\/IdnaTest\.txt\:322\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--xn--a--gua.pt", %p)},	undef,	"to_ascii\(\'xn\-\-xn\-\-a\-\-gua\.pt\'\)\ throws\ error\ V2\ \[data\/IdnaTest\.txt\:323\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("日本語。ＪＰ", %p)},	"xn--wgv71a119e.jp",	"to_ascii\(\'日本語\。ＪＰ\'\)\ \[data\/IdnaTest\.txt\:324\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("日本語。JP", %p)},	"xn--wgv71a119e.jp",	"to_ascii\(\'日本語\。JP\'\)\ \[data\/IdnaTest\.txt\:325\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("日本語。jp", %p)},	"xn--wgv71a119e.jp",	"to_ascii\(\'日本語\。jp\'\)\ \[data\/IdnaTest\.txt\:326\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("日本語。Jp", %p)},	"xn--wgv71a119e.jp",	"to_ascii\(\'日本語\。Jp\'\)\ \[data\/IdnaTest\.txt\:327\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--wgv71a119e.jp", %p)},	"xn--wgv71a119e.jp",	"to_ascii\(\'xn\-\-wgv71a119e\.jp\'\)\ \[data\/IdnaTest\.txt\:328\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("日本語.jp", %p)},	"xn--wgv71a119e.jp",	"to_ascii\(\'日本語\.jp\'\)\ \[data\/IdnaTest\.txt\:329\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("日本語.JP", %p)},	"xn--wgv71a119e.jp",	"to_ascii\(\'日本語\.JP\'\)\ \[data\/IdnaTest\.txt\:330\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("日本語.Jp", %p)},	"xn--wgv71a119e.jp",	"to_ascii\(\'日本語\.Jp\'\)\ \[data\/IdnaTest\.txt\:331\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("日本語。ｊｐ", %p)},	"xn--wgv71a119e.jp",	"to_ascii\(\'日本語\。ｊｐ\'\)\ \[data\/IdnaTest\.txt\:332\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("日本語。Ｊｐ", %p)},	"xn--wgv71a119e.jp",	"to_ascii\(\'日本語\。Ｊｐ\'\)\ \[data\/IdnaTest\.txt\:333\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("☕", %p)},	"xn--53h",	"to_ascii\(\'\☕\'\)\ \[data\/IdnaTest\.txt\:334\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--53h", %p)},	"xn--53h",	"to_ascii\(\'xn\-\-53h\'\)\ \[data\/IdnaTest\.txt\:335\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("1.aß\x{200C}\x{200D}b\x{200C}\x{200D}cßßßßdςσßßßßßßßßeßßßßßßßßßßxßßßßßßßßßßyßßßßßßßß\x{0302}ßz", %p)},	undef,	"to_ascii\(\'1\.aß\\u200C\\u200Db\\u200C\\u200Dcßßßßdςσßßßßßßßßeßßßßßßßßßßxßßßßßßßßßßyßßßßßßßß\\u0302ßz\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:336\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("1.ASS\x{200C}\x{200D}B\x{200C}\x{200D}CSSSSSSSSDΣΣSSSSSSSSSSSSSSSSESSSSSSSSSSSSSSSSSSSSXSSSSSSSSSSSSSSSSSSSSYSSSSSSSSSSSSSSSS\x{0302}SSZ", %p)},	undef,	"to_ascii\(\'1\.ASS\\u200C\\u200DB\\u200C\\u200DCSSSSSSSSDΣΣSSSSSSSSSSSSSSSSESSSSSSSSSSSSSSSSSSSSXSSSSSSSSSSSSSSSSSSSSYSSSSSSSSSSSSSSSS\\u0302SSZ\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:338\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("1.ASS\x{200C}\x{200D}B\x{200C}\x{200D}CSSSSSSSSDΣΣSSSSSSSSSSSSSSSSESSSSSSSSSSSSSSSSSSSSXSSSSSSSSSSSSSSSSSSSSYSSSSSSSSSSSSSSSŜSSZ", %p)},	undef,	"to_ascii\(\'1\.ASS\\u200C\\u200DB\\u200C\\u200DCSSSSSSSSDΣΣSSSSSSSSSSSSSSSSESSSSSSSSSSSSSSSSSSSSXSSSSSSSSSSSSSSSSSSSSYSSSSSSSSSSSSSSSŜSSZ\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:340\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("1.ass\x{200C}\x{200D}b\x{200C}\x{200D}cssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssysssssssssssssssŝssz", %p)},	undef,	"to_ascii\(\'1\.ass\\u200C\\u200Db\\u200C\\u200Dcssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssysssssssssssssssŝssz\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:342\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("1.ass\x{200C}\x{200D}b\x{200C}\x{200D}cssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssyssssssssssssssss\x{0302}ssz", %p)},	undef,	"to_ascii\(\'1\.ass\\u200C\\u200Db\\u200C\\u200Dcssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssyssssssssssssssss\\u0302ssz\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:344\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("1.Ass\x{200C}\x{200D}b\x{200C}\x{200D}cssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssyssssssssssssssss\x{0302}ssz", %p)},	undef,	"to_ascii\(\'1\.Ass\\u200C\\u200Db\\u200C\\u200Dcssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssyssssssssssssssss\\u0302ssz\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:346\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("1.Ass\x{200C}\x{200D}b\x{200C}\x{200D}cssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssysssssssssssssssŝssz", %p)},	undef,	"to_ascii\(\'1\.Ass\\u200C\\u200Db\\u200C\\u200Dcssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssysssssssssssssssŝssz\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:348\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("1.xn--assbcssssssssdssssssssssssssssessssssssssssssssssssxssssssssssssssssssssysssssssssssssssssz-pxq1419aa", %p)},	undef,	"to_ascii\(\'1\.xn\-\-assbcssssssssdssssssssssssssssessssssssssssssssssssxssssssssssssssssssssysssssssssssssssssz\-pxq1419aa\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:350\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("1.assbcssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssysssssssssssssssŝssz", %p)},	undef,	"to_ascii\(\'1\.assbcssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssysssssssssssssssŝssz\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:351\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("1.assbcssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssyssssssssssssssss\x{0302}ssz", %p)},	undef,	"to_ascii\(\'1\.assbcssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssyssssssssssssssss\\u0302ssz\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:352\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("1.ASSBCSSSSSSSSDΣΣSSSSSSSSSSSSSSSSESSSSSSSSSSSSSSSSSSSSXSSSSSSSSSSSSSSSSSSSSYSSSSSSSSSSSSSSSS\x{0302}SSZ", %p)},	undef,	"to_ascii\(\'1\.ASSBCSSSSSSSSDΣΣSSSSSSSSSSSSSSSSESSSSSSSSSSSSSSSSSSSSXSSSSSSSSSSSSSSSSSSSSYSSSSSSSSSSSSSSSS\\u0302SSZ\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:353\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("1.ASSBCSSSSSSSSDΣΣSSSSSSSSSSSSSSSSESSSSSSSSSSSSSSSSSSSSXSSSSSSSSSSSSSSSSSSSSYSSSSSSSSSSSSSSSŜSSZ", %p)},	undef,	"to_ascii\(\'1\.ASSBCSSSSSSSSDΣΣSSSSSSSSSSSSSSSSESSSSSSSSSSSSSSSSSSSSXSSSSSSSSSSSSSSSSSSSSYSSSSSSSSSSSSSSSŜSSZ\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:354\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("1.Assbcssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssysssssssssssssssŝssz", %p)},	undef,	"to_ascii\(\'1\.Assbcssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssysssssssssssssssŝssz\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:355\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("1.Assbcssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssyssssssssssssssss\x{0302}ssz", %p)},	undef,	"to_ascii\(\'1\.Assbcssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssyssssssssssssssss\\u0302ssz\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:356\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("1.xn--assbcssssssssdssssssssssssssssessssssssssssssssssssxssssssssssssssssssssysssssssssssssssssz-pxq1419aa69989dba9gc", %p)},	undef,	"to_ascii\(\'1\.xn\-\-assbcssssssssdssssssssssssssssessssssssssssssssssssxssssssssssssssssssssysssssssssssssssssz\-pxq1419aa69989dba9gc\'\)\ throws\ error\ C1\ C2\ A4_2\ \[data\/IdnaTest\.txt\:357\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("1.Aß\x{200C}\x{200D}b\x{200C}\x{200D}cßßßßdςσßßßßßßßßeßßßßßßßßßßxßßßßßßßßßßyßßßßßßßß\x{0302}ßz", %p)},	undef,	"to_ascii\(\'1\.Aß\\u200C\\u200Db\\u200C\\u200Dcßßßßdςσßßßßßßßßeßßßßßßßßßßxßßßßßßßßßßyßßßßßßßß\\u0302ßz\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:358\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("1.xn--abcdexyz-qyacaaabaaaaaaabaaaaaaaaabaaaaaaaaabaaaaaaaa010ze2isb1140zba8cc", %p)},	undef,	"to_ascii\(\'1\.xn\-\-abcdexyz\-qyacaaabaaaaaaabaaaaaaaaabaaaaaaaaabaaaaaaaa010ze2isb1140zba8cc\'\)\ throws\ error\ C1\ C2\ A4_2\ \[data\/IdnaTest\.txt\:360\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}x\x{200D}n\x{200C}-\x{200D}-bß", %p)},	"xn--bss",	"to_ascii\(\'\\u200Cx\\u200Dn\\u200C\-\\u200D\-bß\'\)\ \[data\/IdnaTest\.txt\:361\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}X\x{200D}N\x{200C}-\x{200D}-BSS", %p)},	"xn--bss",	"to_ascii\(\'\\u200CX\\u200DN\\u200C\-\\u200D\-BSS\'\)\ \[data\/IdnaTest\.txt\:363\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}x\x{200D}n\x{200C}-\x{200D}-bss", %p)},	"xn--bss",	"to_ascii\(\'\\u200Cx\\u200Dn\\u200C\-\\u200D\-bss\'\)\ \[data\/IdnaTest\.txt\:365\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}X\x{200D}n\x{200C}-\x{200D}-Bss", %p)},	"xn--bss",	"to_ascii\(\'\\u200CX\\u200Dn\\u200C\-\\u200D\-Bss\'\)\ \[data\/IdnaTest\.txt\:367\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--bss", %p)},	"xn--bss",	"to_ascii\(\'xn\-\-bss\'\)\ \[data\/IdnaTest\.txt\:369\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("夙", %p)},	"xn--bss",	"to_ascii\(\'夙\'\)\ \[data\/IdnaTest\.txt\:370\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--xn--bss-7z6ccid", %p)},	undef,	"to_ascii\(\'xn\-\-xn\-\-bss\-7z6ccid\'\)\ throws\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:371\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}X\x{200D}n\x{200C}-\x{200D}-Bß", %p)},	"xn--bss",	"to_ascii\(\'\\u200CX\\u200Dn\\u200C\-\\u200D\-Bß\'\)\ \[data\/IdnaTest\.txt\:372\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--xn--b-pqa5796ccahd", %p)},	undef,	"to_ascii\(\'xn\-\-xn\-\-b\-pqa5796ccahd\'\)\ throws\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:374\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_ascii("ˣ\x{034F}ℕ\x{200B}﹣\x{00AD}－\x{180C}ℬ\x{FE00}ſ\x{2064}𝔰󠇯ﬄ", %p)},	"xn--bssffl",	"to_ascii\(\'ˣ\\u034Fℕ\\u200B﹣\\u00AD－\\u180Cℬ\\uFE00ſ\\u2064𝔰\󠇯ﬄ\'\)\ \[data\/IdnaTest\.txt\:375\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_ascii("x\x{034F}N\x{200B}-\x{00AD}-\x{180C}B\x{FE00}s\x{2064}s󠇯ffl", %p)},	"xn--bssffl",	"to_ascii\(\'x\\u034FN\\u200B\-\\u00AD\-\\u180CB\\uFE00s\\u2064s\󠇯ffl\'\)\ \[data\/IdnaTest\.txt\:376\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_ascii("x\x{034F}n\x{200B}-\x{00AD}-\x{180C}b\x{FE00}s\x{2064}s󠇯ffl", %p)},	"xn--bssffl",	"to_ascii\(\'x\\u034Fn\\u200B\-\\u00AD\-\\u180Cb\\uFE00s\\u2064s\󠇯ffl\'\)\ \[data\/IdnaTest\.txt\:377\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_ascii("X\x{034F}N\x{200B}-\x{00AD}-\x{180C}B\x{FE00}S\x{2064}S󠇯FFL", %p)},	"xn--bssffl",	"to_ascii\(\'X\\u034FN\\u200B\-\\u00AD\-\\u180CB\\uFE00S\\u2064S\󠇯FFL\'\)\ \[data\/IdnaTest\.txt\:378\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_ascii("X\x{034F}n\x{200B}-\x{00AD}-\x{180C}B\x{FE00}s\x{2064}s󠇯ffl", %p)},	"xn--bssffl",	"to_ascii\(\'X\\u034Fn\\u200B\-\\u00AD\-\\u180CB\\uFE00s\\u2064s\󠇯ffl\'\)\ \[data\/IdnaTest\.txt\:379\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--bssffl", %p)},	"xn--bssffl",	"to_ascii\(\'xn\-\-bssffl\'\)\ \[data\/IdnaTest\.txt\:380\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("夡夞夜夙", %p)},	"xn--bssffl",	"to_ascii\(\'夡夞夜夙\'\)\ \[data\/IdnaTest\.txt\:381\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_ascii("ˣ\x{034F}ℕ\x{200B}﹣\x{00AD}－\x{180C}ℬ\x{FE00}S\x{2064}𝔰󠇯FFL", %p)},	"xn--bssffl",	"to_ascii\(\'ˣ\\u034Fℕ\\u200B﹣\\u00AD－\\u180Cℬ\\uFE00S\\u2064𝔰\󠇯FFL\'\)\ \[data\/IdnaTest\.txt\:382\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_ascii("x\x{034F}N\x{200B}-\x{00AD}-\x{180C}B\x{FE00}S\x{2064}s󠇯FFL", %p)},	"xn--bssffl",	"to_ascii\(\'x\\u034FN\\u200B\-\\u00AD\-\\u180CB\\uFE00S\\u2064s\󠇯FFL\'\)\ \[data\/IdnaTest\.txt\:383\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_ascii("ˣ\x{034F}ℕ\x{200B}﹣\x{00AD}－\x{180C}ℬ\x{FE00}s\x{2064}𝔰󠇯ffl", %p)},	"xn--bssffl",	"to_ascii\(\'ˣ\\u034Fℕ\\u200B﹣\\u00AD－\\u180Cℬ\\uFE00s\\u2064𝔰\󠇯ffl\'\)\ \[data\/IdnaTest\.txt\:384\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901", %p)},	"123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901",	"to_ascii\(\'123456789012345678901234567890123456789012345678901234567890123\.123456789012345678901234567890123456789012345678901234567890123\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\'\)\ \[data\/IdnaTest\.txt\:385\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901.", %p)},	"123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901.",	"to_ascii\(\'123456789012345678901234567890123456789012345678901234567890123\.123456789012345678901234567890123456789012345678901234567890123\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\.\'\)\ \[data\/IdnaTest\.txt\:386\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890123.12345678901234567890123456789012345678901234567890123456789012", %p)},	undef,	"to_ascii\(\'123456789012345678901234567890123456789012345678901234567890123\.123456789012345678901234567890123456789012345678901234567890123\.123456789012345678901234567890123456789012345678901234567890123\.12345678901234567890123456789012345678901234567890123456789012\'\)\ throws\ error\ A4_1\ \[data\/IdnaTest\.txt\:387\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901234.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890", %p)},	undef,	"to_ascii\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901234\.123456789012345678901234567890123456789012345678901234567890123\.123456789012345678901234567890123456789012345678901234567890\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:388\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901234.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890.", %p)},	undef,	"to_ascii\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901234\.123456789012345678901234567890123456789012345678901234567890123\.123456789012345678901234567890123456789012345678901234567890\.\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:389\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901234.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901", %p)},	undef,	"to_ascii\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901234\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\'\)\ throws\ error\ A4_1\ A4_2\ \[data\/IdnaTest\.txt\:390\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ä1234567890123456789012345678901234567890123456789012345", %p)},	"xn--1234567890123456789012345678901234567890123456789012345-9te",	"to_ascii\(\'ä1234567890123456789012345678901234567890123456789012345\'\)\ \[data\/IdnaTest\.txt\:391\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("a\x{0308}1234567890123456789012345678901234567890123456789012345", %p)},	"xn--1234567890123456789012345678901234567890123456789012345-9te",	"to_ascii\(\'a\\u03081234567890123456789012345678901234567890123456789012345\'\)\ \[data\/IdnaTest\.txt\:392\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A\x{0308}1234567890123456789012345678901234567890123456789012345", %p)},	"xn--1234567890123456789012345678901234567890123456789012345-9te",	"to_ascii\(\'A\\u03081234567890123456789012345678901234567890123456789012345\'\)\ \[data\/IdnaTest\.txt\:393\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ä1234567890123456789012345678901234567890123456789012345", %p)},	"xn--1234567890123456789012345678901234567890123456789012345-9te",	"to_ascii\(\'Ä1234567890123456789012345678901234567890123456789012345\'\)\ \[data\/IdnaTest\.txt\:394\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--1234567890123456789012345678901234567890123456789012345-9te", %p)},	"xn--1234567890123456789012345678901234567890123456789012345-9te",	"to_ascii\(\'xn\-\-1234567890123456789012345678901234567890123456789012345\-9te\'\)\ \[data\/IdnaTest\.txt\:395\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("123456789012345678901234567890123456789012345678901234567890123.1234567890ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901", %p)},	"123456789012345678901234567890123456789012345678901234567890123.xn--1234567890123456789012345678901234567890123456789012345-kue.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901",	"to_ascii\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890ä123456789012345678901234567890123456789012345\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\'\)\ \[data\/IdnaTest\.txt\:396\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("123456789012345678901234567890123456789012345678901234567890123.1234567890a\x{0308}123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901", %p)},	"123456789012345678901234567890123456789012345678901234567890123.xn--1234567890123456789012345678901234567890123456789012345-kue.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901",	"to_ascii\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890a\\u0308123456789012345678901234567890123456789012345\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\'\)\ \[data\/IdnaTest\.txt\:397\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("123456789012345678901234567890123456789012345678901234567890123.1234567890A\x{0308}123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901", %p)},	"123456789012345678901234567890123456789012345678901234567890123.xn--1234567890123456789012345678901234567890123456789012345-kue.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901",	"to_ascii\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890A\\u0308123456789012345678901234567890123456789012345\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\'\)\ \[data\/IdnaTest\.txt\:398\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("123456789012345678901234567890123456789012345678901234567890123.1234567890Ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901", %p)},	"123456789012345678901234567890123456789012345678901234567890123.xn--1234567890123456789012345678901234567890123456789012345-kue.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901",	"to_ascii\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890Ä123456789012345678901234567890123456789012345\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\'\)\ \[data\/IdnaTest\.txt\:399\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("123456789012345678901234567890123456789012345678901234567890123.xn--1234567890123456789012345678901234567890123456789012345-kue.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901", %p)},	"123456789012345678901234567890123456789012345678901234567890123.xn--1234567890123456789012345678901234567890123456789012345-kue.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901",	"to_ascii\(\'123456789012345678901234567890123456789012345678901234567890123\.xn\-\-1234567890123456789012345678901234567890123456789012345\-kue\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\'\)\ \[data\/IdnaTest\.txt\:400\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("123456789012345678901234567890123456789012345678901234567890123.1234567890ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901.", %p)},	"123456789012345678901234567890123456789012345678901234567890123.xn--1234567890123456789012345678901234567890123456789012345-kue.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901.",	"to_ascii\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890ä123456789012345678901234567890123456789012345\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\.\'\)\ \[data\/IdnaTest\.txt\:401\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("123456789012345678901234567890123456789012345678901234567890123.1234567890a\x{0308}123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901.", %p)},	"123456789012345678901234567890123456789012345678901234567890123.xn--1234567890123456789012345678901234567890123456789012345-kue.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901.",	"to_ascii\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890a\\u0308123456789012345678901234567890123456789012345\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\.\'\)\ \[data\/IdnaTest\.txt\:402\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("123456789012345678901234567890123456789012345678901234567890123.1234567890A\x{0308}123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901.", %p)},	"123456789012345678901234567890123456789012345678901234567890123.xn--1234567890123456789012345678901234567890123456789012345-kue.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901.",	"to_ascii\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890A\\u0308123456789012345678901234567890123456789012345\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\.\'\)\ \[data\/IdnaTest\.txt\:403\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("123456789012345678901234567890123456789012345678901234567890123.1234567890Ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901.", %p)},	"123456789012345678901234567890123456789012345678901234567890123.xn--1234567890123456789012345678901234567890123456789012345-kue.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901.",	"to_ascii\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890Ä123456789012345678901234567890123456789012345\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\.\'\)\ \[data\/IdnaTest\.txt\:404\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("123456789012345678901234567890123456789012345678901234567890123.xn--1234567890123456789012345678901234567890123456789012345-kue.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901.", %p)},	"123456789012345678901234567890123456789012345678901234567890123.xn--1234567890123456789012345678901234567890123456789012345-kue.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901.",	"to_ascii\(\'123456789012345678901234567890123456789012345678901234567890123\.xn\-\-1234567890123456789012345678901234567890123456789012345\-kue\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\.\'\)\ \[data\/IdnaTest\.txt\:405\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("123456789012345678901234567890123456789012345678901234567890123.1234567890ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.12345678901234567890123456789012345678901234567890123456789012", %p)},	undef,	"to_ascii\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890ä123456789012345678901234567890123456789012345\.123456789012345678901234567890123456789012345678901234567890123\.12345678901234567890123456789012345678901234567890123456789012\'\)\ throws\ error\ A4_1\ \[data\/IdnaTest\.txt\:406\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("123456789012345678901234567890123456789012345678901234567890123.1234567890a\x{0308}123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.12345678901234567890123456789012345678901234567890123456789012", %p)},	undef,	"to_ascii\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890a\\u0308123456789012345678901234567890123456789012345\.123456789012345678901234567890123456789012345678901234567890123\.12345678901234567890123456789012345678901234567890123456789012\'\)\ throws\ error\ A4_1\ \[data\/IdnaTest\.txt\:407\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("123456789012345678901234567890123456789012345678901234567890123.1234567890A\x{0308}123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.12345678901234567890123456789012345678901234567890123456789012", %p)},	undef,	"to_ascii\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890A\\u0308123456789012345678901234567890123456789012345\.123456789012345678901234567890123456789012345678901234567890123\.12345678901234567890123456789012345678901234567890123456789012\'\)\ throws\ error\ A4_1\ \[data\/IdnaTest\.txt\:408\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("123456789012345678901234567890123456789012345678901234567890123.1234567890Ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.12345678901234567890123456789012345678901234567890123456789012", %p)},	undef,	"to_ascii\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890Ä123456789012345678901234567890123456789012345\.123456789012345678901234567890123456789012345678901234567890123\.12345678901234567890123456789012345678901234567890123456789012\'\)\ throws\ error\ A4_1\ \[data\/IdnaTest\.txt\:409\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("123456789012345678901234567890123456789012345678901234567890123.xn--1234567890123456789012345678901234567890123456789012345-kue.123456789012345678901234567890123456789012345678901234567890123.12345678901234567890123456789012345678901234567890123456789012", %p)},	undef,	"to_ascii\(\'123456789012345678901234567890123456789012345678901234567890123\.xn\-\-1234567890123456789012345678901234567890123456789012345\-kue\.123456789012345678901234567890123456789012345678901234567890123\.12345678901234567890123456789012345678901234567890123456789012\'\)\ throws\ error\ A4_1\ \[data\/IdnaTest\.txt\:410\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("123456789012345678901234567890123456789012345678901234567890123.1234567890ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890", %p)},	undef,	"to_ascii\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890ä1234567890123456789012345678901234567890123456\.123456789012345678901234567890123456789012345678901234567890123\.123456789012345678901234567890123456789012345678901234567890\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:411\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("123456789012345678901234567890123456789012345678901234567890123.1234567890a\x{0308}1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890", %p)},	undef,	"to_ascii\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890a\\u03081234567890123456789012345678901234567890123456\.123456789012345678901234567890123456789012345678901234567890123\.123456789012345678901234567890123456789012345678901234567890\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:412\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("123456789012345678901234567890123456789012345678901234567890123.1234567890A\x{0308}1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890", %p)},	undef,	"to_ascii\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890A\\u03081234567890123456789012345678901234567890123456\.123456789012345678901234567890123456789012345678901234567890123\.123456789012345678901234567890123456789012345678901234567890\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:413\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("123456789012345678901234567890123456789012345678901234567890123.1234567890Ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890", %p)},	undef,	"to_ascii\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890Ä1234567890123456789012345678901234567890123456\.123456789012345678901234567890123456789012345678901234567890123\.123456789012345678901234567890123456789012345678901234567890\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:414\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("123456789012345678901234567890123456789012345678901234567890123.xn--12345678901234567890123456789012345678901234567890123456-fxe.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890", %p)},	undef,	"to_ascii\(\'123456789012345678901234567890123456789012345678901234567890123\.xn\-\-12345678901234567890123456789012345678901234567890123456\-fxe\.123456789012345678901234567890123456789012345678901234567890123\.123456789012345678901234567890123456789012345678901234567890\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:415\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("123456789012345678901234567890123456789012345678901234567890123.1234567890ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890.", %p)},	undef,	"to_ascii\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890ä1234567890123456789012345678901234567890123456\.123456789012345678901234567890123456789012345678901234567890123\.123456789012345678901234567890123456789012345678901234567890\.\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:416\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("123456789012345678901234567890123456789012345678901234567890123.1234567890a\x{0308}1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890.", %p)},	undef,	"to_ascii\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890a\\u03081234567890123456789012345678901234567890123456\.123456789012345678901234567890123456789012345678901234567890123\.123456789012345678901234567890123456789012345678901234567890\.\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:417\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("123456789012345678901234567890123456789012345678901234567890123.1234567890A\x{0308}1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890.", %p)},	undef,	"to_ascii\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890A\\u03081234567890123456789012345678901234567890123456\.123456789012345678901234567890123456789012345678901234567890123\.123456789012345678901234567890123456789012345678901234567890\.\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:418\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("123456789012345678901234567890123456789012345678901234567890123.1234567890Ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890.", %p)},	undef,	"to_ascii\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890Ä1234567890123456789012345678901234567890123456\.123456789012345678901234567890123456789012345678901234567890123\.123456789012345678901234567890123456789012345678901234567890\.\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:419\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("123456789012345678901234567890123456789012345678901234567890123.xn--12345678901234567890123456789012345678901234567890123456-fxe.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890.", %p)},	undef,	"to_ascii\(\'123456789012345678901234567890123456789012345678901234567890123\.xn\-\-12345678901234567890123456789012345678901234567890123456\-fxe\.123456789012345678901234567890123456789012345678901234567890123\.123456789012345678901234567890123456789012345678901234567890\.\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:420\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("123456789012345678901234567890123456789012345678901234567890123.1234567890ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901", %p)},	undef,	"to_ascii\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890ä1234567890123456789012345678901234567890123456\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\'\)\ throws\ error\ A4_1\ A4_2\ \[data\/IdnaTest\.txt\:421\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("123456789012345678901234567890123456789012345678901234567890123.1234567890a\x{0308}1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901", %p)},	undef,	"to_ascii\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890a\\u03081234567890123456789012345678901234567890123456\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\'\)\ throws\ error\ A4_1\ A4_2\ \[data\/IdnaTest\.txt\:422\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("123456789012345678901234567890123456789012345678901234567890123.1234567890A\x{0308}1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901", %p)},	undef,	"to_ascii\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890A\\u03081234567890123456789012345678901234567890123456\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\'\)\ throws\ error\ A4_1\ A4_2\ \[data\/IdnaTest\.txt\:423\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("123456789012345678901234567890123456789012345678901234567890123.1234567890Ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901", %p)},	undef,	"to_ascii\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890Ä1234567890123456789012345678901234567890123456\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\'\)\ throws\ error\ A4_1\ A4_2\ \[data\/IdnaTest\.txt\:424\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("123456789012345678901234567890123456789012345678901234567890123.xn--12345678901234567890123456789012345678901234567890123456-fxe.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901", %p)},	undef,	"to_ascii\(\'123456789012345678901234567890123456789012345678901234567890123\.xn\-\-12345678901234567890123456789012345678901234567890123456\-fxe\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\'\)\ throws\ error\ A4_1\ A4_2\ \[data\/IdnaTest\.txt\:425\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("a.b..-q--a-.e", %p)},	undef,	"to_ascii\(\'a\.b\.\.\-q\-\-a\-\.e\'\)\ throws\ error\ V2\ V3\ A4_2\ \[data\/IdnaTest\.txt\:426\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("a.b..-q--ä-.e", %p)},	undef,	"to_ascii\(\'a\.b\.\.\-q\-\-ä\-\.e\'\)\ throws\ error\ V2\ V3\ A4_2\ \[data\/IdnaTest\.txt\:427\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("a.b..-q--a\x{0308}-.e", %p)},	undef,	"to_ascii\(\'a\.b\.\.\-q\-\-a\\u0308\-\.e\'\)\ throws\ error\ V2\ V3\ A4_2\ \[data\/IdnaTest\.txt\:428\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A.B..-Q--A\x{0308}-.E", %p)},	undef,	"to_ascii\(\'A\.B\.\.\-Q\-\-A\\u0308\-\.E\'\)\ throws\ error\ V2\ V3\ A4_2\ \[data\/IdnaTest\.txt\:429\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A.B..-Q--Ä-.E", %p)},	undef,	"to_ascii\(\'A\.B\.\.\-Q\-\-Ä\-\.E\'\)\ throws\ error\ V2\ V3\ A4_2\ \[data\/IdnaTest\.txt\:430\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A.b..-Q--Ä-.E", %p)},	undef,	"to_ascii\(\'A\.b\.\.\-Q\-\-Ä\-\.E\'\)\ throws\ error\ V2\ V3\ A4_2\ \[data\/IdnaTest\.txt\:431\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A.b..-Q--A\x{0308}-.E", %p)},	undef,	"to_ascii\(\'A\.b\.\.\-Q\-\-A\\u0308\-\.E\'\)\ throws\ error\ V2\ V3\ A4_2\ \[data\/IdnaTest\.txt\:432\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("a.b..xn---q----jra.e", %p)},	undef,	"to_ascii\(\'a\.b\.\.xn\-\-\-q\-\-\-\-jra\.e\'\)\ throws\ error\ V2\ V3\ A4_2\ \[data\/IdnaTest\.txt\:433\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("a..c", %p)},	undef,	"to_ascii\(\'a\.\.c\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:434\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("a.-b.", %p)},	undef,	"to_ascii\(\'a\.\-b\.\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:435\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("a.b-.c", %p)},	undef,	"to_ascii\(\'a\.b\-\.c\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:436\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("a.-.c", %p)},	undef,	"to_ascii\(\'a\.\-\.c\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:437\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("a.bc--de.f", %p)},	undef,	"to_ascii\(\'a\.bc\-\-de\.f\'\)\ throws\ error\ V2\ \[data\/IdnaTest\.txt\:438\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ä.\x{00AD}.c", %p)},	undef,	"to_ascii\(\'ä\.\\u00AD\.c\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:439\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("a\x{0308}.\x{00AD}.c", %p)},	undef,	"to_ascii\(\'a\\u0308\.\\u00AD\.c\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:440\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A\x{0308}.\x{00AD}.C", %p)},	undef,	"to_ascii\(\'A\\u0308\.\\u00AD\.C\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:441\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ä.\x{00AD}.C", %p)},	undef,	"to_ascii\(\'Ä\.\\u00AD\.C\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:442\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--4ca..c", %p)},	undef,	"to_ascii\(\'xn\-\-4ca\.\.c\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:443\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ä.-b.", %p)},	undef,	"to_ascii\(\'ä\.\-b\.\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:444\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("a\x{0308}.-b.", %p)},	undef,	"to_ascii\(\'a\\u0308\.\-b\.\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:445\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A\x{0308}.-B.", %p)},	undef,	"to_ascii\(\'A\\u0308\.\-B\.\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:446\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ä.-B.", %p)},	undef,	"to_ascii\(\'Ä\.\-B\.\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:447\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--4ca.-b.", %p)},	undef,	"to_ascii\(\'xn\-\-4ca\.\-b\.\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:448\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ä.b-.c", %p)},	undef,	"to_ascii\(\'ä\.b\-\.c\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:449\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("a\x{0308}.b-.c", %p)},	undef,	"to_ascii\(\'a\\u0308\.b\-\.c\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:450\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A\x{0308}.B-.C", %p)},	undef,	"to_ascii\(\'A\\u0308\.B\-\.C\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:451\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ä.B-.C", %p)},	undef,	"to_ascii\(\'Ä\.B\-\.C\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:452\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ä.b-.C", %p)},	undef,	"to_ascii\(\'Ä\.b\-\.C\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:453\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A\x{0308}.b-.C", %p)},	undef,	"to_ascii\(\'A\\u0308\.b\-\.C\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:454\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--4ca.b-.c", %p)},	undef,	"to_ascii\(\'xn\-\-4ca\.b\-\.c\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:455\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ä.-.c", %p)},	undef,	"to_ascii\(\'ä\.\-\.c\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:456\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("a\x{0308}.-.c", %p)},	undef,	"to_ascii\(\'a\\u0308\.\-\.c\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:457\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A\x{0308}.-.C", %p)},	undef,	"to_ascii\(\'A\\u0308\.\-\.C\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:458\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ä.-.C", %p)},	undef,	"to_ascii\(\'Ä\.\-\.C\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:459\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--4ca.-.c", %p)},	undef,	"to_ascii\(\'xn\-\-4ca\.\-\.c\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:460\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ä.bc--de.f", %p)},	undef,	"to_ascii\(\'ä\.bc\-\-de\.f\'\)\ throws\ error\ V2\ \[data\/IdnaTest\.txt\:461\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("a\x{0308}.bc--de.f", %p)},	undef,	"to_ascii\(\'a\\u0308\.bc\-\-de\.f\'\)\ throws\ error\ V2\ \[data\/IdnaTest\.txt\:462\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A\x{0308}.BC--DE.F", %p)},	undef,	"to_ascii\(\'A\\u0308\.BC\-\-DE\.F\'\)\ throws\ error\ V2\ \[data\/IdnaTest\.txt\:463\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ä.BC--DE.F", %p)},	undef,	"to_ascii\(\'Ä\.BC\-\-DE\.F\'\)\ throws\ error\ V2\ \[data\/IdnaTest\.txt\:464\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ä.bc--De.f", %p)},	undef,	"to_ascii\(\'Ä\.bc\-\-De\.f\'\)\ throws\ error\ V2\ \[data\/IdnaTest\.txt\:465\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A\x{0308}.bc--De.f", %p)},	undef,	"to_ascii\(\'A\\u0308\.bc\-\-De\.f\'\)\ throws\ error\ V2\ \[data\/IdnaTest\.txt\:466\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--4ca.bc--de.f", %p)},	undef,	"to_ascii\(\'xn\-\-4ca\.bc\-\-de\.f\'\)\ throws\ error\ V2\ \[data\/IdnaTest\.txt\:467\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("a.b.\x{0308}c.d", %p)},	undef,	"to_ascii\(\'a\.b\.\\u0308c\.d\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:468\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A.B.\x{0308}C.D", %p)},	undef,	"to_ascii\(\'A\.B\.\\u0308C\.D\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:469\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A.b.\x{0308}c.d", %p)},	undef,	"to_ascii\(\'A\.b\.\\u0308c\.d\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:470\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("a.b.xn--c-bcb.d", %p)},	undef,	"to_ascii\(\'a\.b\.xn\-\-c\-bcb\.d\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:471\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A0", %p)},	"a0",	"to_ascii\(\'A0\'\)\ \[data\/IdnaTest\.txt\:472\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("0A", %p)},	"0a",	"to_ascii\(\'0A\'\)\ \[data\/IdnaTest\.txt\:473\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("0A.\x{05D0}", %p)},	undef,	"to_ascii\(\'0A\.\\u05D0\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:474\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("0a.\x{05D0}", %p)},	undef,	"to_ascii\(\'0a\.\\u05D0\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:475\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("0a.xn--4db", %p)},	undef,	"to_ascii\(\'0a\.xn\-\-4db\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:476\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("c.xn--0-eha.xn--4db", %p)},	undef,	"to_ascii\(\'c\.xn\-\-0\-eha\.xn\-\-4db\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:477\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("b-.\x{05D0}", %p)},	undef,	"to_ascii\(\'b\-\.\\u05D0\'\)\ throws\ error\ B6\ V3\ \[data\/IdnaTest\.txt\:478\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("B-.\x{05D0}", %p)},	undef,	"to_ascii\(\'B\-\.\\u05D0\'\)\ throws\ error\ B6\ V3\ \[data\/IdnaTest\.txt\:479\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("b-.xn--4db", %p)},	undef,	"to_ascii\(\'b\-\.xn\-\-4db\'\)\ throws\ error\ B6\ V3\ \[data\/IdnaTest\.txt\:480\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("d.xn----dha.xn--4db", %p)},	undef,	"to_ascii\(\'d\.xn\-\-\-\-dha\.xn\-\-4db\'\)\ throws\ error\ B6\ V3\ \[data\/IdnaTest\.txt\:481\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("a\x{05D0}", %p)},	undef,	"to_ascii\(\'a\\u05D0\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:482\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A\x{05D0}", %p)},	undef,	"to_ascii\(\'A\\u05D0\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:483\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--a-0hc", %p)},	undef,	"to_ascii\(\'xn\-\-a\-0hc\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:484\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("\x{05D0}\x{05C7}", %p)},	"xn--vdbr",	"to_ascii\(\'\\u05D0\\u05C7\'\)\ \[data\/IdnaTest\.txt\:485\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("xn--vdbr", %p)},	"xn--vdbr",	"to_ascii\(\'xn\-\-vdbr\'\)\ \[data\/IdnaTest\.txt\:486\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("\x{05D0}9\x{05C7}", %p)},	"xn--9-ihcz",	"to_ascii\(\'\\u05D09\\u05C7\'\)\ \[data\/IdnaTest\.txt\:487\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("xn--9-ihcz", %p)},	"xn--9-ihcz",	"to_ascii\(\'xn\-\-9\-ihcz\'\)\ \[data\/IdnaTest\.txt\:488\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("\x{05D0}a\x{05C7}", %p)},	undef,	"to_ascii\(\'\\u05D0a\\u05C7\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:489\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("\x{05D0}A\x{05C7}", %p)},	undef,	"to_ascii\(\'\\u05D0A\\u05C7\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:490\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--a-ihcz", %p)},	undef,	"to_ascii\(\'xn\-\-a\-ihcz\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:491\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{05D0}\x{05EA}", %p)},	"xn--4db6c",	"to_ascii\(\'\\u05D0\\u05EA\'\)\ \[data\/IdnaTest\.txt\:492\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--4db6c", %p)},	"xn--4db6c",	"to_ascii\(\'xn\-\-4db6c\'\)\ \[data\/IdnaTest\.txt\:493\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{05D0}\x{05F3}\x{05EA}", %p)},	"xn--4db6c0a",	"to_ascii\(\'\\u05D0\\u05F3\\u05EA\'\)\ \[data\/IdnaTest\.txt\:494\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--4db6c0a", %p)},	"xn--4db6c0a",	"to_ascii\(\'xn\-\-4db6c0a\'\)\ \[data\/IdnaTest\.txt\:495\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("a\x{05D0}Tz", %p)},	undef,	"to_ascii\(\'a\\u05D0Tz\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:496\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("a\x{05D0}tz", %p)},	undef,	"to_ascii\(\'a\\u05D0tz\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:497\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A\x{05D0}TZ", %p)},	undef,	"to_ascii\(\'A\\u05D0TZ\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:498\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A\x{05D0}tz", %p)},	undef,	"to_ascii\(\'A\\u05D0tz\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:499\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--atz-qpe", %p)},	undef,	"to_ascii\(\'xn\-\-atz\-qpe\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:500\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{05D0}T\x{05EA}", %p)},	undef,	"to_ascii\(\'\\u05D0T\\u05EA\'\)\ throws\ error\ B2\ \[data\/IdnaTest\.txt\:501\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{05D0}t\x{05EA}", %p)},	undef,	"to_ascii\(\'\\u05D0t\\u05EA\'\)\ throws\ error\ B2\ \[data\/IdnaTest\.txt\:502\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--t-zhc3f", %p)},	undef,	"to_ascii\(\'xn\-\-t\-zhc3f\'\)\ throws\ error\ B2\ \[data\/IdnaTest\.txt\:503\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{05D0}7\x{05EA}", %p)},	"xn--7-zhc3f",	"to_ascii\(\'\\u05D07\\u05EA\'\)\ \[data\/IdnaTest\.txt\:504\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--7-zhc3f", %p)},	"xn--7-zhc3f",	"to_ascii\(\'xn\-\-7\-zhc3f\'\)\ \[data\/IdnaTest\.txt\:505\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{05D0}\x{0667}\x{05EA}", %p)},	"xn--4db6c6t",	"to_ascii\(\'\\u05D0\\u0667\\u05EA\'\)\ \[data\/IdnaTest\.txt\:506\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--4db6c6t", %p)},	"xn--4db6c6t",	"to_ascii\(\'xn\-\-4db6c6t\'\)\ \[data\/IdnaTest\.txt\:507\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("a7\x{0667}z", %p)},	undef,	"to_ascii\(\'a7\\u0667z\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:508\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A7\x{0667}Z", %p)},	undef,	"to_ascii\(\'A7\\u0667Z\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:509\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A7\x{0667}z", %p)},	undef,	"to_ascii\(\'A7\\u0667z\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:510\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--a7z-06e", %p)},	undef,	"to_ascii\(\'xn\-\-a7z\-06e\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:511\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{05D0}7\x{0667}\x{05EA}", %p)},	undef,	"to_ascii\(\'\\u05D07\\u0667\\u05EA\'\)\ throws\ error\ B4\ \[data\/IdnaTest\.txt\:512\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--7-zhc3fty", %p)},	undef,	"to_ascii\(\'xn\-\-7\-zhc3fty\'\)\ throws\ error\ B4\ \[data\/IdnaTest\.txt\:513\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ஹ\x{0BCD}\x{200D}", %p)},	"xn--dmc4b",	"to_ascii\(\'ஹ\\u0BCD\\u200D\'\)\ \[data\/IdnaTest\.txt\:514\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--dmc4b", %p)},	"xn--dmc4b",	"to_ascii\(\'xn\-\-dmc4b\'\)\ \[data\/IdnaTest\.txt\:516\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ஹ\x{0BCD}", %p)},	"xn--dmc4b",	"to_ascii\(\'ஹ\\u0BCD\'\)\ \[data\/IdnaTest\.txt\:517\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--dmc4b194h", %p)},	"xn--dmc4b194h",	"to_ascii\(\'xn\-\-dmc4b194h\'\)\ \[data\/IdnaTest\.txt\:518\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ஹ\x{200D}", %p)},	"xn--dmc",	"to_ascii\(\'ஹ\\u200D\'\)\ \[data\/IdnaTest\.txt\:519\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--dmc", %p)},	"xn--dmc",	"to_ascii\(\'xn\-\-dmc\'\)\ \[data\/IdnaTest\.txt\:521\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ஹ", %p)},	"xn--dmc",	"to_ascii\(\'ஹ\'\)\ \[data\/IdnaTest\.txt\:522\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--dmc225h", %p)},	undef,	"to_ascii\(\'xn\-\-dmc225h\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:523\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}", %p)},	undef,	"to_ascii\(\'\\u200D\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:524\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("", %p)},	undef,	"to_ascii\(\'\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:526\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--1ug", %p)},	undef,	"to_ascii\(\'xn\-\-1ug\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:527\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ஹ\x{0BCD}\x{200C}", %p)},	"xn--dmc4b",	"to_ascii\(\'ஹ\\u0BCD\\u200C\'\)\ \[data\/IdnaTest\.txt\:528\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--dmc4by94h", %p)},	"xn--dmc4by94h",	"to_ascii\(\'xn\-\-dmc4by94h\'\)\ \[data\/IdnaTest\.txt\:530\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ஹ\x{200C}", %p)},	"xn--dmc",	"to_ascii\(\'ஹ\\u200C\'\)\ \[data\/IdnaTest\.txt\:531\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--dmc025h", %p)},	undef,	"to_ascii\(\'xn\-\-dmc025h\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:533\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}", %p)},	undef,	"to_ascii\(\'\\u200C\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:534\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--0ug", %p)},	undef,	"to_ascii\(\'xn\-\-0ug\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:536\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0644}\x{0670}\x{200C}\x{06ED}\x{06EF}", %p)},	"xn--ghb2gxqia",	"to_ascii\(\'\\u0644\\u0670\\u200C\\u06ED\\u06EF\'\)\ \[data\/IdnaTest\.txt\:537\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--ghb2gxqia", %p)},	"xn--ghb2gxqia",	"to_ascii\(\'xn\-\-ghb2gxqia\'\)\ \[data\/IdnaTest\.txt\:539\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0644}\x{0670}\x{06ED}\x{06EF}", %p)},	"xn--ghb2gxqia",	"to_ascii\(\'\\u0644\\u0670\\u06ED\\u06EF\'\)\ \[data\/IdnaTest\.txt\:540\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--ghb2gxqia7523a", %p)},	"xn--ghb2gxqia7523a",	"to_ascii\(\'xn\-\-ghb2gxqia7523a\'\)\ \[data\/IdnaTest\.txt\:541\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0644}\x{0670}\x{200C}\x{06EF}", %p)},	"xn--ghb2g3q",	"to_ascii\(\'\\u0644\\u0670\\u200C\\u06EF\'\)\ \[data\/IdnaTest\.txt\:542\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--ghb2g3q", %p)},	"xn--ghb2g3q",	"to_ascii\(\'xn\-\-ghb2g3q\'\)\ \[data\/IdnaTest\.txt\:544\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0644}\x{0670}\x{06EF}", %p)},	"xn--ghb2g3q",	"to_ascii\(\'\\u0644\\u0670\\u06EF\'\)\ \[data\/IdnaTest\.txt\:545\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--ghb2g3qq34f", %p)},	"xn--ghb2g3qq34f",	"to_ascii\(\'xn\-\-ghb2g3qq34f\'\)\ \[data\/IdnaTest\.txt\:546\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0644}\x{200C}\x{06ED}\x{06EF}", %p)},	"xn--ghb25aga",	"to_ascii\(\'\\u0644\\u200C\\u06ED\\u06EF\'\)\ \[data\/IdnaTest\.txt\:547\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--ghb25aga", %p)},	"xn--ghb25aga",	"to_ascii\(\'xn\-\-ghb25aga\'\)\ \[data\/IdnaTest\.txt\:549\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0644}\x{06ED}\x{06EF}", %p)},	"xn--ghb25aga",	"to_ascii\(\'\\u0644\\u06ED\\u06EF\'\)\ \[data\/IdnaTest\.txt\:550\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--ghb25aga828w", %p)},	"xn--ghb25aga828w",	"to_ascii\(\'xn\-\-ghb25aga828w\'\)\ \[data\/IdnaTest\.txt\:551\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0644}\x{200C}\x{06EF}", %p)},	"xn--ghb65a",	"to_ascii\(\'\\u0644\\u200C\\u06EF\'\)\ \[data\/IdnaTest\.txt\:552\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--ghb65a", %p)},	"xn--ghb65a",	"to_ascii\(\'xn\-\-ghb65a\'\)\ \[data\/IdnaTest\.txt\:554\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0644}\x{06EF}", %p)},	"xn--ghb65a",	"to_ascii\(\'\\u0644\\u06EF\'\)\ \[data\/IdnaTest\.txt\:555\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--ghb65a953d", %p)},	"xn--ghb65a953d",	"to_ascii\(\'xn\-\-ghb65a953d\'\)\ \[data\/IdnaTest\.txt\:556\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0644}\x{0670}\x{200C}\x{06ED}", %p)},	"xn--ghb2gxq",	"to_ascii\(\'\\u0644\\u0670\\u200C\\u06ED\'\)\ \[data\/IdnaTest\.txt\:557\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--ghb2gxq", %p)},	"xn--ghb2gxq",	"to_ascii\(\'xn\-\-ghb2gxq\'\)\ \[data\/IdnaTest\.txt\:559\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0644}\x{0670}\x{06ED}", %p)},	"xn--ghb2gxq",	"to_ascii\(\'\\u0644\\u0670\\u06ED\'\)\ \[data\/IdnaTest\.txt\:560\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--ghb2gxqy34f", %p)},	undef,	"to_ascii\(\'xn\-\-ghb2gxqy34f\'\)\ throws\ error\ B3\ C1\ \[data\/IdnaTest\.txt\:561\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{06EF}\x{200C}\x{06EF}", %p)},	"xn--cmba",	"to_ascii\(\'\\u06EF\\u200C\\u06EF\'\)\ \[data\/IdnaTest\.txt\:562\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--cmba", %p)},	"xn--cmba",	"to_ascii\(\'xn\-\-cmba\'\)\ \[data\/IdnaTest\.txt\:564\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{06EF}\x{06EF}", %p)},	"xn--cmba",	"to_ascii\(\'\\u06EF\\u06EF\'\)\ \[data\/IdnaTest\.txt\:565\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--cmba004q", %p)},	undef,	"to_ascii\(\'xn\-\-cmba004q\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:566\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0644}\x{200C}", %p)},	"xn--ghb",	"to_ascii\(\'\\u0644\\u200C\'\)\ \[data\/IdnaTest\.txt\:567\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--ghb", %p)},	"xn--ghb",	"to_ascii\(\'xn\-\-ghb\'\)\ \[data\/IdnaTest\.txt\:569\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0644}", %p)},	"xn--ghb",	"to_ascii\(\'\\u0644\'\)\ \[data\/IdnaTest\.txt\:570\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--ghb413k", %p)},	undef,	"to_ascii\(\'xn\-\-ghb413k\'\)\ throws\ error\ B3\ C1\ \[data\/IdnaTest\.txt\:571\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("a。。b", %p)},	undef,	"to_ascii\(\'a\。\。b\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:572\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A。。B", %p)},	undef,	"to_ascii\(\'A\。\。B\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:573\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("a..b", %p)},	undef,	"to_ascii\(\'a\.\.b\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:574\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}。。\x{06B9}\x{200C}", %p)},	undef,	"to_ascii\(\'\\u200D\。\。\\u06B9\\u200C\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:575\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("..xn--skb", %p)},	undef,	"to_ascii\(\'\.\.xn\-\-skb\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:577\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--1ug..xn--skb080k", %p)},	undef,	"to_ascii\(\'xn\-\-1ug\.\.xn\-\-skb080k\'\)\ throws\ error\ B1\ B3\ C1\ C2\ A4_2\ \[data\/IdnaTest\.txt\:578\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{05D0}0\x{0660}", %p)},	undef,	"to_ascii\(\'\\u05D00\\u0660\'\)\ throws\ error\ B4\ \[data\/IdnaTest\.txt\:579\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--0-zhc74b", %p)},	undef,	"to_ascii\(\'xn\-\-0\-zhc74b\'\)\ throws\ error\ B4\ \[data\/IdnaTest\.txt\:580\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\$", %p)},	undef,	"to_ascii\(\'\$\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:581\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("c.0ü.\x{05D0}", %p)},	undef,	"to_ascii\(\'c\.0ü\.\\u05D0\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:585\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("c.0u\x{0308}.\x{05D0}", %p)},	undef,	"to_ascii\(\'c\.0u\\u0308\.\\u05D0\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:586\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("C.0U\x{0308}.\x{05D0}", %p)},	undef,	"to_ascii\(\'C\.0U\\u0308\.\\u05D0\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:587\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("C.0Ü.\x{05D0}", %p)},	undef,	"to_ascii\(\'C\.0Ü\.\\u05D0\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:588\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⒕∝\x{065F}򓤦．-󠄯", %p)},	undef,	"to_ascii\(\'⒕\∝\\u065F\?．\-\󠄯\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:589\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("14.∝\x{065F}򓤦.-󠄯", %p)},	undef,	"to_ascii\(\'14\.\∝\\u065F\?\.\-\󠄯\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:590\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("14.xn--7hb713l3v90n.-", %p)},	undef,	"to_ascii\(\'14\.xn\-\-7hb713l3v90n\.\-\'\)\ throws\ error\ V3\ V6\ \[data\/IdnaTest\.txt\:591\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--7hb713lfwbi1311b.-", %p)},	undef,	"to_ascii\(\'xn\-\-7hb713lfwbi1311b\.\-\'\)\ throws\ error\ V3\ V6\ \[data\/IdnaTest\.txt\:592\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_ascii("ꡣ.\x{07CF}", %p)},	"xn--8c9a.xn--qsb",	"to_ascii\(\'ꡣ\.\\u07CF\'\)\ \[data\/IdnaTest\.txt\:593\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_ascii("xn--8c9a.xn--qsb", %p)},	"xn--8c9a.xn--qsb",	"to_ascii\(\'xn\-\-8c9a\.xn\-\-qsb\'\)\ \[data\/IdnaTest\.txt\:594\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("≯\x{0603}｡-", %p)},	undef,	"to_ascii\(\'\≯\\u0603｡\-\'\)\ throws\ error\ B1\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:595\]") or ($@ and diag($@));
is(eval{uts46_to_ascii(">\x{0338}\x{0603}｡-", %p)},	undef,	"to_ascii\(\'\>\\u0338\\u0603｡\-\'\)\ throws\ error\ B1\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:596\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≯\x{0603}。-", %p)},	undef,	"to_ascii\(\'\≯\\u0603\。\-\'\)\ throws\ error\ B1\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:597\]") or ($@ and diag($@));
is(eval{uts46_to_ascii(">\x{0338}\x{0603}。-", %p)},	undef,	"to_ascii\(\'\>\\u0338\\u0603\。\-\'\)\ throws\ error\ B1\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:598\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--lfb566l.-", %p)},	undef,	"to_ascii\(\'xn\-\-lfb566l\.\-\'\)\ throws\ error\ B1\ V3\ V6\ \[data\/IdnaTest\.txt\:599\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⾛𐹧⾕.\x{115F}󠗰ςႭ", %p)},	undef,	"to_ascii\(\'⾛𐹧⾕\.\\u115F\?ςႭ\'\)\ throws\ error\ B5\ P1\ V6\ \[data\/IdnaTest\.txt\:600\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("走𐹧谷.\x{115F}󠗰ςႭ", %p)},	undef,	"to_ascii\(\'走𐹧谷\.\\u115F\?ςႭ\'\)\ throws\ error\ B5\ P1\ V6\ \[data\/IdnaTest\.txt\:602\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("走𐹧谷.\x{115F}󠗰ςⴍ", %p)},	undef,	"to_ascii\(\'走𐹧谷\.\\u115F\?ςⴍ\'\)\ throws\ error\ B5\ P1\ V6\ \[data\/IdnaTest\.txt\:604\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("走𐹧谷.\x{115F}󠗰ΣႭ", %p)},	undef,	"to_ascii\(\'走𐹧谷\.\\u115F\?ΣႭ\'\)\ throws\ error\ B5\ P1\ V6\ \[data\/IdnaTest\.txt\:606\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("走𐹧谷.\x{115F}󠗰σⴍ", %p)},	undef,	"to_ascii\(\'走𐹧谷\.\\u115F\?σⴍ\'\)\ throws\ error\ B5\ P1\ V6\ \[data\/IdnaTest\.txt\:607\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("走𐹧谷.\x{115F}󠗰Σⴍ", %p)},	undef,	"to_ascii\(\'走𐹧谷\.\\u115F\?Σⴍ\'\)\ throws\ error\ B5\ P1\ V6\ \[data\/IdnaTest\.txt\:608\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--6g3a1x434z.xn--4xa180eotvh7453a", %p)},	undef,	"to_ascii\(\'xn\-\-6g3a1x434z\.xn\-\-4xa180eotvh7453a\'\)\ throws\ error\ B5\ V6\ \[data\/IdnaTest\.txt\:609\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--6g3a1x434z.xn--4xa627dhpae6345i", %p)},	undef,	"to_ascii\(\'xn\-\-6g3a1x434z\.xn\-\-4xa627dhpae6345i\'\)\ throws\ error\ B5\ V6\ \[data\/IdnaTest\.txt\:610\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--6g3a1x434z.xn--3xa380eotvh7453a", %p)},	undef,	"to_ascii\(\'xn\-\-6g3a1x434z\.xn\-\-3xa380eotvh7453a\'\)\ throws\ error\ B5\ V6\ \[data\/IdnaTest\.txt\:611\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--6g3a1x434z.xn--3xa827dhpae6345i", %p)},	undef,	"to_ascii\(\'xn\-\-6g3a1x434z\.xn\-\-3xa827dhpae6345i\'\)\ throws\ error\ B5\ V6\ \[data\/IdnaTest\.txt\:612\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⾛𐹧⾕.\x{115F}󠗰ςⴍ", %p)},	undef,	"to_ascii\(\'⾛𐹧⾕\.\\u115F\?ςⴍ\'\)\ throws\ error\ B5\ P1\ V6\ \[data\/IdnaTest\.txt\:613\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⾛𐹧⾕.\x{115F}󠗰ΣႭ", %p)},	undef,	"to_ascii\(\'⾛𐹧⾕\.\\u115F\?ΣႭ\'\)\ throws\ error\ B5\ P1\ V6\ \[data\/IdnaTest\.txt\:615\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⾛𐹧⾕.\x{115F}󠗰σⴍ", %p)},	undef,	"to_ascii\(\'⾛𐹧⾕\.\\u115F\?σⴍ\'\)\ throws\ error\ B5\ P1\ V6\ \[data\/IdnaTest\.txt\:616\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⾛𐹧⾕.\x{115F}󠗰Σⴍ", %p)},	undef,	"to_ascii\(\'⾛𐹧⾕\.\\u115F\?Σⴍ\'\)\ throws\ error\ B5\ P1\ V6\ \[data\/IdnaTest\.txt\:617\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}≠ᢙ≯.솣-ᡴႠ", %p)},	undef,	"to_ascii\(\'\\u200D\≠ᢙ\≯\.솣\-ᡴႠ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:618\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}=\x{0338}ᢙ>\x{0338}.솣-ᡴႠ", %p)},	undef,	"to_ascii\(\'\\u200D\=\\u0338ᢙ\>\\u0338\.솣\-ᡴႠ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:620\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}=\x{0338}ᢙ>\x{0338}.솣-ᡴⴀ", %p)},	undef,	"to_ascii\(\'\\u200D\=\\u0338ᢙ\>\\u0338\.솣\-ᡴⴀ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:622\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}≠ᢙ≯.솣-ᡴⴀ", %p)},	undef,	"to_ascii\(\'\\u200D\≠ᢙ\≯\.솣\-ᡴⴀ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:624\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--jbf911clb.xn----p9j493ivi4l", %p)},	undef,	"to_ascii\(\'xn\-\-jbf911clb\.xn\-\-\-\-p9j493ivi4l\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:626\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--jbf929a90b0b.xn----p9j493ivi4l", %p)},	undef,	"to_ascii\(\'xn\-\-jbf929a90b0b\.xn\-\-\-\-p9j493ivi4l\'\)\ throws\ error\ C2\ V6\ \[data\/IdnaTest\.txt\:627\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--jbf911clb.xn----6zg521d196p", %p)},	undef,	"to_ascii\(\'xn\-\-jbf911clb\.xn\-\-\-\-6zg521d196p\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:628\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--jbf929a90b0b.xn----6zg521d196p", %p)},	undef,	"to_ascii\(\'xn\-\-jbf929a90b0b\.xn\-\-\-\-6zg521d196p\'\)\ throws\ error\ C2\ V6\ \[data\/IdnaTest\.txt\:629\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񯞜．𐿇\x{0FA2}\x{077D}\x{0600}", %p)},	undef,	"to_ascii\(\'\?．𐿇\\u0FA2\\u077D\\u0600\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:630\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񯞜．𐿇\x{0FA1}\x{0FB7}\x{077D}\x{0600}", %p)},	undef,	"to_ascii\(\'\?．𐿇\\u0FA1\\u0FB7\\u077D\\u0600\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:631\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񯞜.𐿇\x{0FA1}\x{0FB7}\x{077D}\x{0600}", %p)},	undef,	"to_ascii\(\'\?\.𐿇\\u0FA1\\u0FB7\\u077D\\u0600\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:632\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--gw68a.xn--ifb57ev2psc6027m", %p)},	undef,	"to_ascii\(\'xn\-\-gw68a\.xn\-\-ifb57ev2psc6027m\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:633\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("𣳔\x{0303}.𑓂", %p)},	undef,	"to_ascii\(\'𣳔\\u0303\.𑓂\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:634\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--nsa95820a.xn--wz1d", %p)},	undef,	"to_ascii\(\'xn\-\-nsa95820a\.xn\-\-wz1d\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:635\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𞤀𞥅񘐱。󠄌Ⴣꡥ", %p)},	undef,	"to_ascii\(\'𞤀𞥅\?\。\󠄌Ⴣꡥ\'\)\ throws\ error\ B2\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:636\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𞤢𞥅񘐱。󠄌ⴣꡥ", %p)},	undef,	"to_ascii\(\'𞤢𞥅\?\。\󠄌ⴣꡥ\'\)\ throws\ error\ B2\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:637\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--9d6hgcy3556a.xn--rlju750b", %p)},	undef,	"to_ascii\(\'xn\-\-9d6hgcy3556a\.xn\-\-rlju750b\'\)\ throws\ error\ B2\ B3\ V6\ \[data\/IdnaTest\.txt\:638\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--9d6hgcy3556a.xn--7nd0578e", %p)},	undef,	"to_ascii\(\'xn\-\-9d6hgcy3556a\.xn\-\-7nd0578e\'\)\ throws\ error\ B2\ B3\ V6\ \[data\/IdnaTest\.txt\:639\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𞤀𞥅񘐱。󠄌ⴣꡥ", %p)},	undef,	"to_ascii\(\'𞤀𞥅\?\。\󠄌ⴣꡥ\'\)\ throws\ error\ B2\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:640\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{08E2}𑁿ς𖬱。󠅡렧", %p)},	undef,	"to_ascii\(\'\\u08E2𑁿ς𖬱\。\󠅡렧\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:641\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{08E2}𑁿ς𖬱。󠅡렧", %p)},	undef,	"to_ascii\(\'\\u08E2𑁿ς𖬱\。\󠅡렧\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:643\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{08E2}𑁿Σ𖬱。󠅡렧", %p)},	undef,	"to_ascii\(\'\\u08E2𑁿Σ𖬱\。\󠅡렧\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:645\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{08E2}𑁿Σ𖬱。󠅡렧", %p)},	undef,	"to_ascii\(\'\\u08E2𑁿Σ𖬱\。\󠅡렧\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:646\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{08E2}𑁿σ𖬱。󠅡렧", %p)},	undef,	"to_ascii\(\'\\u08E2𑁿σ𖬱\。\󠅡렧\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:647\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{08E2}𑁿σ𖬱。󠅡렧", %p)},	undef,	"to_ascii\(\'\\u08E2𑁿σ𖬱\。\󠅡렧\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:648\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--4xa53xp48ys2xc.xn--kn2b", %p)},	undef,	"to_ascii\(\'xn\-\-4xa53xp48ys2xc\.xn\-\-kn2b\'\)\ throws\ error\ B1\ V6\ \[data\/IdnaTest\.txt\:649\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--3xa73xp48ys2xc.xn--kn2b", %p)},	undef,	"to_ascii\(\'xn\-\-3xa73xp48ys2xc\.xn\-\-kn2b\'\)\ throws\ error\ B1\ V6\ \[data\/IdnaTest\.txt\:650\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-\x{200D}。𞤍\x{200C}\x{200D}⒈", %p)},	undef,	"to_ascii\(\'\-\\u200D\。𞤍\\u200C\\u200D⒈\'\)\ throws\ error\ B1\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:651\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("-\x{200D}。𞤍\x{200C}\x{200D}1.", %p)},	undef,	"to_ascii\(\'\-\\u200D\。𞤍\\u200C\\u200D1\.\'\)\ throws\ error\ B1\ V3\ \[data\/IdnaTest\.txt\:653\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("-\x{200D}。𞤯\x{200C}\x{200D}1.", %p)},	undef,	"to_ascii\(\'\-\\u200D\。𞤯\\u200C\\u200D1\.\'\)\ throws\ error\ B1\ V3\ \[data\/IdnaTest\.txt\:655\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("-.xn--1-0i8r.", %p)},	undef,	"to_ascii\(\'\-\.xn\-\-1\-0i8r\.\'\)\ throws\ error\ B1\ V3\ \[data\/IdnaTest\.txt\:657\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----ugn.xn--1-rgnd61297b.", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-ugn\.xn\-\-1\-rgnd61297b\.\'\)\ throws\ error\ B1\ C1\ C2\ V3\ \[data\/IdnaTest\.txt\:658\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-\x{200D}。𞤯\x{200C}\x{200D}⒈", %p)},	undef,	"to_ascii\(\'\-\\u200D\。𞤯\\u200C\\u200D⒈\'\)\ throws\ error\ B1\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:659\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-.xn--tsh3666n", %p)},	undef,	"to_ascii\(\'\-\.xn\-\-tsh3666n\'\)\ throws\ error\ B1\ V3\ V6\ \[data\/IdnaTest\.txt\:661\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----ugn.xn--0ugc555aiv51d", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-ugn\.xn\-\-0ugc555aiv51d\'\)\ throws\ error\ B1\ C1\ C2\ V3\ V6\ \[data\/IdnaTest\.txt\:662\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}򅎭.Ⴒ𑇀", %p)},	undef,	"to_ascii\(\'\\u200C\?\.Ⴒ𑇀\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:663\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}򅎭.ⴒ𑇀", %p)},	undef,	"to_ascii\(\'\\u200C\?\.ⴒ𑇀\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:665\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--bn95b.xn--9kj2034e", %p)},	undef,	"to_ascii\(\'xn\-\-bn95b\.xn\-\-9kj2034e\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:667\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--0ug15083f.xn--9kj2034e", %p)},	undef,	"to_ascii\(\'xn\-\-0ug15083f\.xn\-\-9kj2034e\'\)\ throws\ error\ C1\ V6\ \[data\/IdnaTest\.txt\:668\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--bn95b.xn--qnd6272k", %p)},	undef,	"to_ascii\(\'xn\-\-bn95b\.xn\-\-qnd6272k\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:669\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--0ug15083f.xn--qnd6272k", %p)},	undef,	"to_ascii\(\'xn\-\-0ug15083f\.xn\-\-qnd6272k\'\)\ throws\ error\ C1\ V6\ \[data\/IdnaTest\.txt\:670\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("繱𑖿\x{200D}.８︒", %p)},	undef,	"to_ascii\(\'繱𑖿\\u200D\.８︒\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:671\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("繱𑖿\x{200D}.8。", %p)},	"xn--gl0as212a.8.",	"to_ascii\(\'繱𑖿\\u200D\.8\。\'\)\ \[data\/IdnaTest\.txt\:673\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("xn--gl0as212a.8.", %p)},	"xn--gl0as212a.8.",	"to_ascii\(\'xn\-\-gl0as212a\.8\.\'\)\ \[data\/IdnaTest\.txt\:675\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("繱𑖿.8.", %p)},	"xn--gl0as212a.8.",	"to_ascii\(\'繱𑖿\.8\.\'\)\ \[data\/IdnaTest\.txt\:676\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("xn--1ug6928ac48e.8.", %p)},	"xn--1ug6928ac48e.8.",	"to_ascii\(\'xn\-\-1ug6928ac48e\.8\.\'\)\ \[data\/IdnaTest\.txt\:677\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("繱𑖿\x{200D}.8.", %p)},	"xn--gl0as212a.8.",	"to_ascii\(\'繱𑖿\\u200D\.8\.\'\)\ \[data\/IdnaTest\.txt\:678\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--gl0as212a.xn--8-o89h", %p)},	undef,	"to_ascii\(\'xn\-\-gl0as212a\.xn\-\-8\-o89h\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:680\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--1ug6928ac48e.xn--8-o89h", %p)},	undef,	"to_ascii\(\'xn\-\-1ug6928ac48e\.xn\-\-8\-o89h\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:681\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("󠆾．𞀈", %p)},	undef,	"to_ascii\(\'\󠆾．𞀈\'\)\ throws\ error\ V5\ A4_2\ \[data\/IdnaTest\.txt\:682\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("󠆾.𞀈", %p)},	undef,	"to_ascii\(\'\󠆾\.𞀈\'\)\ throws\ error\ V5\ A4_2\ \[data\/IdnaTest\.txt\:683\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii(".xn--ph4h", %p)},	undef,	"to_ascii\(\'\.xn\-\-ph4h\'\)\ throws\ error\ V5\ A4_2\ \[data\/IdnaTest\.txt\:684\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ß\x{06EB}。\x{200D}", %p)},	"xn--ss-59d.",	"to_ascii\(\'ß\\u06EB\。\\u200D\'\)\ \[data\/IdnaTest\.txt\:685\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("SS\x{06EB}。\x{200D}", %p)},	"xn--ss-59d.",	"to_ascii\(\'SS\\u06EB\。\\u200D\'\)\ \[data\/IdnaTest\.txt\:687\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ss\x{06EB}。\x{200D}", %p)},	"xn--ss-59d.",	"to_ascii\(\'ss\\u06EB\。\\u200D\'\)\ \[data\/IdnaTest\.txt\:689\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ss\x{06EB}。\x{200D}", %p)},	"xn--ss-59d.",	"to_ascii\(\'Ss\\u06EB\。\\u200D\'\)\ \[data\/IdnaTest\.txt\:691\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--ss-59d.", %p)},	"xn--ss-59d.",	"to_ascii\(\'xn\-\-ss\-59d\.\'\)\ \[data\/IdnaTest\.txt\:693\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ss\x{06EB}.", %p)},	"xn--ss-59d.",	"to_ascii\(\'ss\\u06EB\.\'\)\ \[data\/IdnaTest\.txt\:694\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("SS\x{06EB}.", %p)},	"xn--ss-59d.",	"to_ascii\(\'SS\\u06EB\.\'\)\ \[data\/IdnaTest\.txt\:695\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ss\x{06EB}.", %p)},	"xn--ss-59d.",	"to_ascii\(\'Ss\\u06EB\.\'\)\ \[data\/IdnaTest\.txt\:696\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--ss-59d.xn--1ug", %p)},	undef,	"to_ascii\(\'xn\-\-ss\-59d\.xn\-\-1ug\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:697\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--zca012a.xn--1ug", %p)},	undef,	"to_ascii\(\'xn\-\-zca012a\.xn\-\-1ug\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:698\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠐵\x{200C}⒈．󠎇", %p)},	undef,	"to_ascii\(\'\?\\u200C⒈．\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:699\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠐵\x{200C}1..󠎇", %p)},	undef,	"to_ascii\(\'\?\\u200C1\.\.\?\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:701\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--1-bs31m..xn--tv36e", %p)},	undef,	"to_ascii\(\'xn\-\-1\-bs31m\.\.xn\-\-tv36e\'\)\ throws\ error\ V6\ A4_2\ \[data\/IdnaTest\.txt\:703\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--1-rgn37671n..xn--tv36e", %p)},	undef,	"to_ascii\(\'xn\-\-1\-rgn37671n\.\.xn\-\-tv36e\'\)\ throws\ error\ C1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:704\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--tshz2001k.xn--tv36e", %p)},	undef,	"to_ascii\(\'xn\-\-tshz2001k\.xn\-\-tv36e\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:705\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--0ug88o47900b.xn--tv36e", %p)},	undef,	"to_ascii\(\'xn\-\-0ug88o47900b\.xn\-\-tv36e\'\)\ throws\ error\ C1\ V6\ \[data\/IdnaTest\.txt\:706\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󟈣\x{065F}\x{AAB2}ß。󌓧", %p)},	undef,	"to_ascii\(\'\?\\u065F\\uAAB2ß\。\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:707\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󟈣\x{065F}\x{AAB2}SS。󌓧", %p)},	undef,	"to_ascii\(\'\?\\u065F\\uAAB2SS\。\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:709\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󟈣\x{065F}\x{AAB2}ss。󌓧", %p)},	undef,	"to_ascii\(\'\?\\u065F\\uAAB2ss\。\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:710\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󟈣\x{065F}\x{AAB2}Ss。󌓧", %p)},	undef,	"to_ascii\(\'\?\\u065F\\uAAB2Ss\。\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:711\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--ss-3xd2839nncy1m.xn--bb79d", %p)},	undef,	"to_ascii\(\'xn\-\-ss\-3xd2839nncy1m\.xn\-\-bb79d\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:712\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--zca92z0t7n5w96j.xn--bb79d", %p)},	undef,	"to_ascii\(\'xn\-\-zca92z0t7n5w96j\.xn\-\-bb79d\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:713\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0774}\x{200C}𞤿。𽘐䉜\x{200D}񿤼", %p)},	undef,	"to_ascii\(\'\\u0774\\u200C𞤿\。\?䉜\\u200D\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:714\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0774}\x{200C}𞤝。𽘐䉜\x{200D}񿤼", %p)},	undef,	"to_ascii\(\'\\u0774\\u200C𞤝\。\?䉜\\u200D\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:716\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--4pb2977v.xn--z0nt555ukbnv", %p)},	undef,	"to_ascii\(\'xn\-\-4pb2977v\.xn\-\-z0nt555ukbnv\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:718\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--4pb607jjt73a.xn--1ug236ke314donv1a", %p)},	undef,	"to_ascii\(\'xn\-\-4pb607jjt73a\.xn\-\-1ug236ke314donv1a\'\)\ throws\ error\ C1\ C2\ V6\ \[data\/IdnaTest\.txt\:719\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򔭜ςᡱ⒈.≮𑄳\x{200D}𐮍", %p)},	undef,	"to_ascii\(\'\?ςᡱ⒈\.\≮𑄳\\u200D𐮍\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:720\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򔭜ςᡱ⒈.<\x{0338}𑄳\x{200D}𐮍", %p)},	undef,	"to_ascii\(\'\?ςᡱ⒈\.\<\\u0338𑄳\\u200D𐮍\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:722\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򔭜ςᡱ1..≮𑄳\x{200D}𐮍", %p)},	undef,	"to_ascii\(\'\?ςᡱ1\.\.\≮𑄳\\u200D𐮍\'\)\ throws\ error\ B1\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:724\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򔭜ςᡱ1..<\x{0338}𑄳\x{200D}𐮍", %p)},	undef,	"to_ascii\(\'\?ςᡱ1\.\.\<\\u0338𑄳\\u200D𐮍\'\)\ throws\ error\ B1\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:726\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򔭜Σᡱ1..<\x{0338}𑄳\x{200D}𐮍", %p)},	undef,	"to_ascii\(\'\?Σᡱ1\.\.\<\\u0338𑄳\\u200D𐮍\'\)\ throws\ error\ B1\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:728\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򔭜Σᡱ1..≮𑄳\x{200D}𐮍", %p)},	undef,	"to_ascii\(\'\?Σᡱ1\.\.\≮𑄳\\u200D𐮍\'\)\ throws\ error\ B1\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:730\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򔭜σᡱ1..≮𑄳\x{200D}𐮍", %p)},	undef,	"to_ascii\(\'\?σᡱ1\.\.\≮𑄳\\u200D𐮍\'\)\ throws\ error\ B1\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:732\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򔭜σᡱ1..<\x{0338}𑄳\x{200D}𐮍", %p)},	undef,	"to_ascii\(\'\?σᡱ1\.\.\<\\u0338𑄳\\u200D𐮍\'\)\ throws\ error\ B1\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:734\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--1-zmb699meq63t..xn--gdh5392g6sd", %p)},	undef,	"to_ascii\(\'xn\-\-1\-zmb699meq63t\.\.xn\-\-gdh5392g6sd\'\)\ throws\ error\ B1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:736\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--1-zmb699meq63t..xn--1ug85gn777ahze", %p)},	undef,	"to_ascii\(\'xn\-\-1\-zmb699meq63t\.\.xn\-\-1ug85gn777ahze\'\)\ throws\ error\ B1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:737\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--1-xmb999meq63t..xn--1ug85gn777ahze", %p)},	undef,	"to_ascii\(\'xn\-\-1\-xmb999meq63t\.\.xn\-\-1ug85gn777ahze\'\)\ throws\ error\ B1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:738\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򔭜Σᡱ⒈.<\x{0338}𑄳\x{200D}𐮍", %p)},	undef,	"to_ascii\(\'\?Σᡱ⒈\.\<\\u0338𑄳\\u200D𐮍\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:739\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򔭜Σᡱ⒈.≮𑄳\x{200D}𐮍", %p)},	undef,	"to_ascii\(\'\?Σᡱ⒈\.\≮𑄳\\u200D𐮍\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:741\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򔭜σᡱ⒈.≮𑄳\x{200D}𐮍", %p)},	undef,	"to_ascii\(\'\?σᡱ⒈\.\≮𑄳\\u200D𐮍\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:743\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򔭜σᡱ⒈.<\x{0338}𑄳\x{200D}𐮍", %p)},	undef,	"to_ascii\(\'\?σᡱ⒈\.\<\\u0338𑄳\\u200D𐮍\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:745\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--4xa207hkzinr77u.xn--gdh5392g6sd", %p)},	undef,	"to_ascii\(\'xn\-\-4xa207hkzinr77u\.xn\-\-gdh5392g6sd\'\)\ throws\ error\ B1\ V6\ \[data\/IdnaTest\.txt\:747\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--4xa207hkzinr77u.xn--1ug85gn777ahze", %p)},	undef,	"to_ascii\(\'xn\-\-4xa207hkzinr77u\.xn\-\-1ug85gn777ahze\'\)\ throws\ error\ B1\ V6\ \[data\/IdnaTest\.txt\:748\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--3xa407hkzinr77u.xn--1ug85gn777ahze", %p)},	undef,	"to_ascii\(\'xn\-\-3xa407hkzinr77u\.xn\-\-1ug85gn777ahze\'\)\ throws\ error\ B1\ V6\ \[data\/IdnaTest\.txt\:749\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{3164}\x{094D}Ⴀ\x{17D0}.\x{180B}", %p)},	undef,	"to_ascii\(\'\\u3164\\u094DႠ\\u17D0\.\\u180B\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:750\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1160}\x{094D}Ⴀ\x{17D0}.\x{180B}", %p)},	undef,	"to_ascii\(\'\\u1160\\u094DႠ\\u17D0\.\\u180B\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:751\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1160}\x{094D}ⴀ\x{17D0}.\x{180B}", %p)},	undef,	"to_ascii\(\'\\u1160\\u094Dⴀ\\u17D0\.\\u180B\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:752\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--n3b742bkqf4ty.", %p)},	undef,	"to_ascii\(\'xn\-\-n3b742bkqf4ty\.\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:753\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--n3b468aoqa89r.", %p)},	undef,	"to_ascii\(\'xn\-\-n3b468aoqa89r\.\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:754\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{3164}\x{094D}ⴀ\x{17D0}.\x{180B}", %p)},	undef,	"to_ascii\(\'\\u3164\\u094Dⴀ\\u17D0\.\\u180B\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:755\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--n3b445e53po6d.", %p)},	undef,	"to_ascii\(\'xn\-\-n3b445e53po6d\.\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:756\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--n3b468azngju2a.", %p)},	undef,	"to_ascii\(\'xn\-\-n3b468azngju2a\.\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:757\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("❣\x{200D}．\x{09CD}𑰽\x{0612}\x{A929}", %p)},	undef,	"to_ascii\(\'\❣\\u200D．\\u09CD𑰽\\u0612\\uA929\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:758\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("❣\x{200D}.\x{09CD}𑰽\x{0612}\x{A929}", %p)},	undef,	"to_ascii\(\'\❣\\u200D\.\\u09CD𑰽\\u0612\\uA929\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:760\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--pei.xn--0fb32q3w7q2g4d", %p)},	undef,	"to_ascii\(\'xn\-\-pei\.xn\-\-0fb32q3w7q2g4d\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:762\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--1ugy10a.xn--0fb32q3w7q2g4d", %p)},	undef,	"to_ascii\(\'xn\-\-1ugy10a\.xn\-\-0fb32q3w7q2g4d\'\)\ throws\ error\ C2\ V5\ \[data\/IdnaTest\.txt\:763\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≮𐳺𐹄.≯񪮸ꡅ", %p)},	undef,	"to_ascii\(\'\≮𐳺\?\.\≯\?ꡅ\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:764\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("<\x{0338}𐳺𐹄.>\x{0338}񪮸ꡅ", %p)},	undef,	"to_ascii\(\'\<\\u0338𐳺\?\.\>\\u0338\?ꡅ\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:765\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--gdh7943gk2a.xn--hdh1383c5e36c", %p)},	undef,	"to_ascii\(\'xn\-\-gdh7943gk2a\.xn\-\-hdh1383c5e36c\'\)\ throws\ error\ B1\ V6\ \[data\/IdnaTest\.txt\:766\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0CCC}𐧅𐳏󠲺｡\x{0CCD}ᠦ", %p)},	undef,	"to_ascii\(\'\\u0CCC𐧅𐳏\?｡\\u0CCDᠦ\'\)\ throws\ error\ B1\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:767\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0CCC}𐧅𐳏󠲺。\x{0CCD}ᠦ", %p)},	undef,	"to_ascii\(\'\\u0CCC𐧅𐳏\?\。\\u0CCDᠦ\'\)\ throws\ error\ B1\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:768\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0CCC}𐧅𐲏󠲺。\x{0CCD}ᠦ", %p)},	undef,	"to_ascii\(\'\\u0CCC𐧅𐲏\?\。\\u0CCDᠦ\'\)\ throws\ error\ B1\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:769\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--7tc6360ky5bn2732c.xn--8tc429c", %p)},	undef,	"to_ascii\(\'xn\-\-7tc6360ky5bn2732c\.xn\-\-8tc429c\'\)\ throws\ error\ B1\ V5\ V6\ \[data\/IdnaTest\.txt\:770\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0CCC}𐧅𐲏󠲺｡\x{0CCD}ᠦ", %p)},	undef,	"to_ascii\(\'\\u0CCC𐧅𐲏\?｡\\u0CCDᠦ\'\)\ throws\ error\ B1\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:771\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0349}。𧡫", %p)},	undef,	"to_ascii\(\'\\u0349\。𧡫\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:772\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--nua.xn--bc6k", %p)},	undef,	"to_ascii\(\'xn\-\-nua\.xn\-\-bc6k\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:773\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𑰿󠅦．\x{1160}", %p)},	undef,	"to_ascii\(\'𑰿\󠅦．\\u1160\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:774\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𑰿󠅦.\x{1160}", %p)},	undef,	"to_ascii\(\'𑰿\󠅦\.\\u1160\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:775\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--ok3d.xn--psd", %p)},	undef,	"to_ascii\(\'xn\-\-ok3d\.xn\-\-psd\'\)\ throws\ error\ V5\ V6\ \[data\/IdnaTest\.txt\:776\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-𞤆\x{200D}。󸼄𞳒", %p)},	undef,	"to_ascii\(\'\-𞤆\\u200D\。\?\?\'\)\ throws\ error\ B1\ B5\ B6\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:777\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-𞤨\x{200D}。󸼄𞳒", %p)},	undef,	"to_ascii\(\'\-𞤨\\u200D\。\?\?\'\)\ throws\ error\ B1\ B5\ B6\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:779\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----ni8r.xn--846h96596c", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-ni8r\.xn\-\-846h96596c\'\)\ throws\ error\ B1\ B5\ B6\ V3\ V6\ \[data\/IdnaTest\.txt\:781\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----ugnx367r.xn--846h96596c", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-ugnx367r\.xn\-\-846h96596c\'\)\ throws\ error\ B1\ B5\ B6\ C2\ V3\ V6\ \[data\/IdnaTest\.txt\:782\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ꡏ󠇶≯𳾽。\x{1DFD}⾇滸𐹰", %p)},	undef,	"to_ascii\(\'ꡏ\?\≯\?\。\\u1DFD⾇滸𐹰\'\)\ throws\ error\ B1\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:783\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ꡏ󠇶>\x{0338}𳾽。\x{1DFD}⾇滸𐹰", %p)},	undef,	"to_ascii\(\'ꡏ\?\>\\u0338\?\。\\u1DFD⾇滸𐹰\'\)\ throws\ error\ B1\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:784\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ꡏ󠇶≯𳾽。\x{1DFD}舛滸𐹰", %p)},	undef,	"to_ascii\(\'ꡏ\?\≯\?\。\\u1DFD舛滸𐹰\'\)\ throws\ error\ B1\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:785\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ꡏ󠇶>\x{0338}𳾽。\x{1DFD}舛滸𐹰", %p)},	undef,	"to_ascii\(\'ꡏ\?\>\\u0338\?\。\\u1DFD舛滸𐹰\'\)\ throws\ error\ B1\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:786\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--hdh7483cu6twwki8e.xn--yfg0765a58l0n6k", %p)},	undef,	"to_ascii\(\'xn\-\-hdh7483cu6twwki8e\.xn\-\-yfg0765a58l0n6k\'\)\ throws\ error\ B1\ V5\ V6\ \[data\/IdnaTest\.txt\:787\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("蔏｡𑰺", %p)},	undef,	"to_ascii\(\'蔏｡𑰺\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:788\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("蔏。𑰺", %p)},	undef,	"to_ascii\(\'蔏\。𑰺\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:789\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--uy1a.xn--jk3d", %p)},	undef,	"to_ascii\(\'xn\-\-uy1a\.xn\-\-jk3d\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:790\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("𝟿𐮋。󠄊", %p)},	undef,	"to_ascii\(\'𝟿𐮋\。\󠄊\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:791\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("9𐮋。󠄊", %p)},	undef,	"to_ascii\(\'9𐮋\。\󠄊\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:792\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--9-rv5i.", %p)},	undef,	"to_ascii\(\'xn\-\-9\-rv5i\.\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:793\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󟇇-䟖F。\x{07CB}⒈\x{0662}", %p)},	undef,	"to_ascii\(\'\?\-䟖F\。\\u07CB⒈\\u0662\'\)\ throws\ error\ B4\ P1\ V6\ \[data\/IdnaTest\.txt\:794\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󟇇-䟖F。\x{07CB}1.\x{0662}", %p)},	undef,	"to_ascii\(\'\?\-䟖F\。\\u07CB1\.\\u0662\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:795\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󟇇-䟖f。\x{07CB}1.\x{0662}", %p)},	undef,	"to_ascii\(\'\?\-䟖f\。\\u07CB1\.\\u0662\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:796\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn---f-mz8b08788k.xn--1-ybd.xn--bib", %p)},	undef,	"to_ascii\(\'xn\-\-\-f\-mz8b08788k\.xn\-\-1\-ybd\.xn\-\-bib\'\)\ throws\ error\ B1\ V6\ \[data\/IdnaTest\.txt\:797\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󟇇-䟖f。\x{07CB}⒈\x{0662}", %p)},	undef,	"to_ascii\(\'\?\-䟖f\。\\u07CB⒈\\u0662\'\)\ throws\ error\ B4\ P1\ V6\ \[data\/IdnaTest\.txt\:798\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn---f-mz8b08788k.xn--bib53ev44d", %p)},	undef,	"to_ascii\(\'xn\-\-\-f\-mz8b08788k\.xn\-\-bib53ev44d\'\)\ throws\ error\ B4\ V6\ \[data\/IdnaTest\.txt\:799\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("\x{200C}｡𐹺", %p)},	undef,	"to_ascii\(\'\\u200C｡𐹺\'\)\ throws\ error\ B1\ A4_2\ \[data\/IdnaTest\.txt\:800\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("\x{200C}。𐹺", %p)},	undef,	"to_ascii\(\'\\u200C\。𐹺\'\)\ throws\ error\ B1\ A4_2\ \[data\/IdnaTest\.txt\:802\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii(".xn--yo0d", %p)},	undef,	"to_ascii\(\'\.xn\-\-yo0d\'\)\ throws\ error\ B1\ A4_2\ \[data\/IdnaTest\.txt\:804\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--0ug.xn--yo0d", %p)},	undef,	"to_ascii\(\'xn\-\-0ug\.xn\-\-yo0d\'\)\ throws\ error\ B1\ C1\ \[data\/IdnaTest\.txt\:805\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐡆.≯\x{200C}-𞥀", %p)},	undef,	"to_ascii\(\'𐡆\.\≯\\u200C\-𞥀\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:806\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐡆.>\x{0338}\x{200C}-𞥀", %p)},	undef,	"to_ascii\(\'𐡆\.\>\\u0338\\u200C\-𞥀\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:808\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐡆.>\x{0338}\x{200C}-𞤞", %p)},	undef,	"to_ascii\(\'𐡆\.\>\\u0338\\u200C\-𞤞\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:810\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐡆.≯\x{200C}-𞤞", %p)},	undef,	"to_ascii\(\'𐡆\.\≯\\u200C\-𞤞\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:812\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--le9c.xn----ogo9956r", %p)},	undef,	"to_ascii\(\'xn\-\-le9c\.xn\-\-\-\-ogo9956r\'\)\ throws\ error\ B1\ V6\ \[data\/IdnaTest\.txt\:814\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--le9c.xn----rgn40iy359e", %p)},	undef,	"to_ascii\(\'xn\-\-le9c\.xn\-\-\-\-rgn40iy359e\'\)\ throws\ error\ B1\ C1\ V6\ \[data\/IdnaTest\.txt\:815\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠁀-。≠\x{FCD7}", %p)},	undef,	"to_ascii\(\'\?\-\。\≠\\uFCD7\'\)\ throws\ error\ B1\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:816\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠁀-。=\x{0338}\x{FCD7}", %p)},	undef,	"to_ascii\(\'\?\-\。\=\\u0338\\uFCD7\'\)\ throws\ error\ B1\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:817\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠁀-。≠\x{0647}\x{062C}", %p)},	undef,	"to_ascii\(\'\?\-\。\≠\\u0647\\u062C\'\)\ throws\ error\ B1\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:818\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠁀-。=\x{0338}\x{0647}\x{062C}", %p)},	undef,	"to_ascii\(\'\?\-\。\=\\u0338\\u0647\\u062C\'\)\ throws\ error\ B1\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:819\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----f411m.xn--rgb7c611j", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-f411m\.xn\-\-rgb7c611j\'\)\ throws\ error\ B1\ V3\ V6\ \[data\/IdnaTest\.txt\:820\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񻬹𑈵。\x{200D}𞨶", %p)},	undef,	"to_ascii\(\'\?𑈵\。\\u200D\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:821\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--8g1d12120a.xn--5l6h", %p)},	undef,	"to_ascii\(\'xn\-\-8g1d12120a\.xn\-\-5l6h\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:823\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--8g1d12120a.xn--1ug6651p", %p)},	undef,	"to_ascii\(\'xn\-\-8g1d12120a\.xn\-\-1ug6651p\'\)\ throws\ error\ B1\ C2\ V6\ \[data\/IdnaTest\.txt\:824\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𑋧\x{A9C0}2｡㧉򒖄", %p)},	undef,	"to_ascii\(\'𑋧\\uA9C02｡㧉\?\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:825\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𑋧\x{A9C0}2。㧉򒖄", %p)},	undef,	"to_ascii\(\'𑋧\\uA9C02\。㧉\?\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:826\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--2-5z4eu89y.xn--97l02706d", %p)},	undef,	"to_ascii\(\'xn\-\-2\-5z4eu89y\.xn\-\-97l02706d\'\)\ throws\ error\ V5\ V6\ \[data\/IdnaTest\.txt\:827\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}𽬄𐹴𞩥。≯6", %p)},	undef,	"to_ascii\(\'\\u200C\?𐹴\?\。\≯6\'\)\ throws\ error\ B1\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:828\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}𽬄𐹴𞩥。>\x{0338}6", %p)},	undef,	"to_ascii\(\'\\u200C\?𐹴\?\。\>\\u03386\'\)\ throws\ error\ B1\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:830\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--so0du768aim9m.xn--6-ogo", %p)},	undef,	"to_ascii\(\'xn\-\-so0du768aim9m\.xn\-\-6\-ogo\'\)\ throws\ error\ B1\ B5\ B6\ V6\ \[data\/IdnaTest\.txt\:832\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--0ug7105gf5wfxepq.xn--6-ogo", %p)},	undef,	"to_ascii\(\'xn\-\-0ug7105gf5wfxepq\.xn\-\-6\-ogo\'\)\ throws\ error\ B1\ C1\ V6\ \[data\/IdnaTest\.txt\:833\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𑁿．𐹦𻞵-\x{200D}", %p)},	undef,	"to_ascii\(\'𑁿．𐹦\?\-\\u200D\'\)\ throws\ error\ B1\ B3\ B6\ P1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:834\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𑁿.𐹦𻞵-\x{200D}", %p)},	undef,	"to_ascii\(\'𑁿\.𐹦\?\-\\u200D\'\)\ throws\ error\ B1\ B3\ B6\ P1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:836\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--q30d.xn----i26i1299n", %p)},	undef,	"to_ascii\(\'xn\-\-q30d\.xn\-\-\-\-i26i1299n\'\)\ throws\ error\ B1\ B3\ B6\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:838\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--q30d.xn----ugn1088hfsxv", %p)},	undef,	"to_ascii\(\'xn\-\-q30d\.xn\-\-\-\-ugn1088hfsxv\'\)\ throws\ error\ B1\ B3\ B6\ C2\ V5\ V6\ \[data\/IdnaTest\.txt\:839\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⤸ς𺱀｡\x{FFA0}", %p)},	undef,	"to_ascii\(\'\⤸ς\?｡\\uFFA0\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:840\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⤸ς𺱀。\x{1160}", %p)},	undef,	"to_ascii\(\'\⤸ς\?\。\\u1160\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:842\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⤸Σ𺱀。\x{1160}", %p)},	undef,	"to_ascii\(\'\⤸Σ\?\。\\u1160\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:844\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⤸σ𺱀。\x{1160}", %p)},	undef,	"to_ascii\(\'\⤸σ\?\。\\u1160\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:845\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--4xa192qmp03d.xn--psd", %p)},	undef,	"to_ascii\(\'xn\-\-4xa192qmp03d\.xn\-\-psd\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:846\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--3xa392qmp03d.xn--psd", %p)},	undef,	"to_ascii\(\'xn\-\-3xa392qmp03d\.xn\-\-psd\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:847\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⤸Σ𺱀｡\x{FFA0}", %p)},	undef,	"to_ascii\(\'\⤸Σ\?｡\\uFFA0\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:848\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⤸σ𺱀｡\x{FFA0}", %p)},	undef,	"to_ascii\(\'\⤸σ\?｡\\uFFA0\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:849\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--4xa192qmp03d.xn--cl7c", %p)},	undef,	"to_ascii\(\'xn\-\-4xa192qmp03d\.xn\-\-cl7c\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:850\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--3xa392qmp03d.xn--cl7c", %p)},	undef,	"to_ascii\(\'xn\-\-3xa392qmp03d\.xn\-\-cl7c\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:851\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0765}\x{1035}𐫔\x{06D5}.𐦬𑋪Ⴃ", %p)},	undef,	"to_ascii\(\'\\u0765\\u1035𐫔\\u06D5\.𐦬𑋪Ⴃ\'\)\ throws\ error\ B2\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:852\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("\x{0765}\x{1035}𐫔\x{06D5}.𐦬𑋪ⴃ", %p)},	undef,	"to_ascii\(\'\\u0765\\u1035𐫔\\u06D5\.𐦬𑋪ⴃ\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:853\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--llb10as9tqp5y.xn--ukj7371e21f", %p)},	undef,	"to_ascii\(\'xn\-\-llb10as9tqp5y\.xn\-\-ukj7371e21f\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:854\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--llb10as9tqp5y.xn--bnd9168j21f", %p)},	undef,	"to_ascii\(\'xn\-\-llb10as9tqp5y\.xn\-\-bnd9168j21f\'\)\ throws\ error\ B2\ B3\ V6\ \[data\/IdnaTest\.txt\:855\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0661}\x{1B44}-킼.\x{1BAA}\x{0616}\x{066C}≯", %p)},	undef,	"to_ascii\(\'\\u0661\\u1B44\-킼\.\\u1BAA\\u0616\\u066C\≯\'\)\ throws\ error\ B1\ B5\ B6\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:856\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0661}\x{1B44}-킼.\x{1BAA}\x{0616}\x{066C}>\x{0338}", %p)},	undef,	"to_ascii\(\'\\u0661\\u1B44\-킼\.\\u1BAA\\u0616\\u066C\>\\u0338\'\)\ throws\ error\ B1\ B5\ B6\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:857\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----9pc551nk39n.xn--4fb6o571degg", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-9pc551nk39n\.xn\-\-4fb6o571degg\'\)\ throws\ error\ B1\ B5\ B6\ V5\ V6\ \[data\/IdnaTest\.txt\:858\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-。\x{06C2}\x{0604}򅖡𑓂", %p)},	undef,	"to_ascii\(\'\-\。\\u06C2\\u0604\?𑓂\'\)\ throws\ error\ B1\ B2\ B3\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:859\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-。\x{06C1}\x{0654}\x{0604}򅖡𑓂", %p)},	undef,	"to_ascii\(\'\-\。\\u06C1\\u0654\\u0604\?𑓂\'\)\ throws\ error\ B1\ B2\ B3\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:860\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-.xn--mfb39a7208dzgs3d", %p)},	undef,	"to_ascii\(\'\-\.xn\-\-mfb39a7208dzgs3d\'\)\ throws\ error\ B1\ B2\ B3\ V3\ V6\ \[data\/IdnaTest\.txt\:861\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}󯑖󠁐．\x{05BD}𙮰ꡝ𐋡", %p)},	undef,	"to_ascii\(\'\\u200D\?\?．\\u05BD\?ꡝ𐋡\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:862\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}󯑖󠁐.\x{05BD}𙮰ꡝ𐋡", %p)},	undef,	"to_ascii\(\'\\u200D\?\?\.\\u05BD\?ꡝ𐋡\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:864\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--b726ey18m.xn--ldb8734fg0qcyzzg", %p)},	undef,	"to_ascii\(\'xn\-\-b726ey18m\.xn\-\-ldb8734fg0qcyzzg\'\)\ throws\ error\ V5\ V6\ \[data\/IdnaTest\.txt\:866\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--1ug66101lt8me.xn--ldb8734fg0qcyzzg", %p)},	undef,	"to_ascii\(\'xn\-\-1ug66101lt8me\.xn\-\-ldb8734fg0qcyzzg\'\)\ throws\ error\ C2\ V5\ V6\ \[data\/IdnaTest\.txt\:867\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("︒􃈵ς񀠇｡𐮈", %p)},	undef,	"to_ascii\(\'︒\?ς\?｡𐮈\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:868\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("。􃈵ς񀠇。𐮈", %p)},	undef,	"to_ascii\(\'\。\?ς\?\。𐮈\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:870\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("。􃈵Σ񀠇。𐮈", %p)},	undef,	"to_ascii\(\'\。\?Σ\?\。𐮈\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:872\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("。􃈵σ񀠇。𐮈", %p)},	undef,	"to_ascii\(\'\。\?σ\?\。𐮈\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:873\]") or ($@ and diag($@));
is(eval{uts46_to_ascii(".xn--4xa68573c7n64d.xn--f29c", %p)},	undef,	"to_ascii\(\'\.xn\-\-4xa68573c7n64d\.xn\-\-f29c\'\)\ throws\ error\ V6\ A4_2\ \[data\/IdnaTest\.txt\:874\]") or ($@ and diag($@));
is(eval{uts46_to_ascii(".xn--3xa88573c7n64d.xn--f29c", %p)},	undef,	"to_ascii\(\'\.xn\-\-3xa88573c7n64d\.xn\-\-f29c\'\)\ throws\ error\ V6\ A4_2\ \[data\/IdnaTest\.txt\:875\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("︒􃈵Σ񀠇｡𐮈", %p)},	undef,	"to_ascii\(\'︒\?Σ\?｡𐮈\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:876\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("︒􃈵σ񀠇｡𐮈", %p)},	undef,	"to_ascii\(\'︒\?σ\?｡𐮈\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:877\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--4xa1729jwz5t7gl5f.xn--f29c", %p)},	undef,	"to_ascii\(\'xn\-\-4xa1729jwz5t7gl5f\.xn\-\-f29c\'\)\ throws\ error\ B1\ V6\ \[data\/IdnaTest\.txt\:878\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--3xa3729jwz5t7gl5f.xn--f29c", %p)},	undef,	"to_ascii\(\'xn\-\-3xa3729jwz5t7gl5f\.xn\-\-f29c\'\)\ throws\ error\ B1\ V6\ \[data\/IdnaTest\.txt\:879\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{07D9}．\x{06EE}󆾃≯󠅲", %p)},	undef,	"to_ascii\(\'\\u07D9．\\u06EE\?\≯\󠅲\'\)\ throws\ error\ B2\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:880\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{07D9}．\x{06EE}󆾃>\x{0338}󠅲", %p)},	undef,	"to_ascii\(\'\\u07D9．\\u06EE\?\>\\u0338\󠅲\'\)\ throws\ error\ B2\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:881\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{07D9}.\x{06EE}󆾃≯󠅲", %p)},	undef,	"to_ascii\(\'\\u07D9\.\\u06EE\?\≯\󠅲\'\)\ throws\ error\ B2\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:882\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{07D9}.\x{06EE}󆾃>\x{0338}󠅲", %p)},	undef,	"to_ascii\(\'\\u07D9\.\\u06EE\?\>\\u0338\󠅲\'\)\ throws\ error\ B2\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:883\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--0sb.xn--bmb691l0524t", %p)},	undef,	"to_ascii\(\'xn\-\-0sb\.xn\-\-bmb691l0524t\'\)\ throws\ error\ B2\ B3\ V6\ \[data\/IdnaTest\.txt\:884\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1A73}󚙸.𐭍", %p)},	undef,	"to_ascii\(\'\\u1A73\?\.𐭍\'\)\ throws\ error\ B1\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:885\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--2of22352n.xn--q09c", %p)},	undef,	"to_ascii\(\'xn\-\-2of22352n\.xn\-\-q09c\'\)\ throws\ error\ B1\ V5\ V6\ \[data\/IdnaTest\.txt\:886\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⒉󠊓≠｡Ⴟ⬣Ⴈ", %p)},	undef,	"to_ascii\(\'⒉\?\≠｡Ⴟ\⬣Ⴈ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:887\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⒉󠊓=\x{0338}｡Ⴟ⬣Ⴈ", %p)},	undef,	"to_ascii\(\'⒉\?\=\\u0338｡Ⴟ\⬣Ⴈ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:888\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("2.󠊓≠。Ⴟ⬣Ⴈ", %p)},	undef,	"to_ascii\(\'2\.\?\≠\。Ⴟ\⬣Ⴈ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:889\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("2.󠊓=\x{0338}。Ⴟ⬣Ⴈ", %p)},	undef,	"to_ascii\(\'2\.\?\=\\u0338\。Ⴟ\⬣Ⴈ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:890\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("2.󠊓=\x{0338}。ⴟ⬣ⴈ", %p)},	undef,	"to_ascii\(\'2\.\?\=\\u0338\。ⴟ\⬣ⴈ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:891\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("2.󠊓≠。ⴟ⬣ⴈ", %p)},	undef,	"to_ascii\(\'2\.\?\≠\。ⴟ\⬣ⴈ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:892\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("2.xn--1chz4101l.xn--45iz7d6b", %p)},	undef,	"to_ascii\(\'2\.xn\-\-1chz4101l\.xn\-\-45iz7d6b\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:893\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("2.xn--1chz4101l.xn--gnd9b297j", %p)},	undef,	"to_ascii\(\'2\.xn\-\-1chz4101l\.xn\-\-gnd9b297j\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:894\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⒉󠊓=\x{0338}｡ⴟ⬣ⴈ", %p)},	undef,	"to_ascii\(\'⒉\?\=\\u0338｡ⴟ\⬣ⴈ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:895\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⒉󠊓≠｡ⴟ⬣ⴈ", %p)},	undef,	"to_ascii\(\'⒉\?\≠｡ⴟ\⬣ⴈ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:896\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--1ch07f91401d.xn--45iz7d6b", %p)},	undef,	"to_ascii\(\'xn\-\-1ch07f91401d\.xn\-\-45iz7d6b\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:897\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--1ch07f91401d.xn--gnd9b297j", %p)},	undef,	"to_ascii\(\'xn\-\-1ch07f91401d\.xn\-\-gnd9b297j\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:898\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-󠉱\x{0FB8}Ⴥ。-𐹽\x{0774}𞣑", %p)},	undef,	"to_ascii\(\'\-\?\\u0FB8Ⴥ\。\-𐹽\\u0774𞣑\'\)\ throws\ error\ B1\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:899\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-󠉱\x{0FB8}ⴥ。-𐹽\x{0774}𞣑", %p)},	undef,	"to_ascii\(\'\-\?\\u0FB8ⴥ\。\-𐹽\\u0774𞣑\'\)\ throws\ error\ B1\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:900\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----xmg317tgv352a.xn----05c4213ryr0g", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-xmg317tgv352a\.xn\-\-\-\-05c4213ryr0g\'\)\ throws\ error\ B1\ V3\ V6\ \[data\/IdnaTest\.txt\:901\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----xmg12fm2555h.xn----05c4213ryr0g", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-xmg12fm2555h\.xn\-\-\-\-05c4213ryr0g\'\)\ throws\ error\ B1\ V3\ V6\ \[data\/IdnaTest\.txt\:902\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0659}。𑄴︒\x{0627}\x{07DD}", %p)},	undef,	"to_ascii\(\'\\u0659\。𑄴︒\\u0627\\u07DD\'\)\ throws\ error\ B1\ B3\ B6\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:903\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_ascii("\x{0659}。𑄴。\x{0627}\x{07DD}", %p)},	undef,	"to_ascii\(\'\\u0659\。𑄴\。\\u0627\\u07DD\'\)\ throws\ error\ B1\ B3\ B6\ V5\ \[data\/IdnaTest\.txt\:904\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--1hb.xn--w80d.xn--mgb09f", %p)},	undef,	"to_ascii\(\'xn\-\-1hb\.xn\-\-w80d\.xn\-\-mgb09f\'\)\ throws\ error\ B1\ B3\ B6\ V5\ \[data\/IdnaTest\.txt\:905\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--1hb.xn--mgb09fp820c08pa", %p)},	undef,	"to_ascii\(\'xn\-\-1hb\.xn\-\-mgb09fp820c08pa\'\)\ throws\ error\ B1\ B3\ B6\ V5\ V6\ \[data\/IdnaTest\.txt\:906\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴙ\x{0638}.󠆓\x{200D}", %p)},	undef,	"to_ascii\(\'Ⴙ\\u0638\.\󠆓\\u200D\'\)\ throws\ error\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:907\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("ⴙ\x{0638}.󠆓\x{200D}", %p)},	undef,	"to_ascii\(\'ⴙ\\u0638\.\󠆓\\u200D\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:909\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--3gb910r.", %p)},	undef,	"to_ascii\(\'xn\-\-3gb910r\.\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:911\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--3gb910r.xn--1ug", %p)},	undef,	"to_ascii\(\'xn\-\-3gb910r\.xn\-\-1ug\'\)\ throws\ error\ B1\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:912\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--3gb194c.", %p)},	undef,	"to_ascii\(\'xn\-\-3gb194c\.\'\)\ throws\ error\ B5\ B6\ V6\ \[data\/IdnaTest\.txt\:913\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--3gb194c.xn--1ug", %p)},	undef,	"to_ascii\(\'xn\-\-3gb194c\.xn\-\-1ug\'\)\ throws\ error\ B1\ B5\ B6\ C2\ V6\ \[data\/IdnaTest\.txt\:914\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠆸｡₆０𐺧\x{0756}", %p)},	undef,	"to_ascii\(\'\󠆸｡₆０𐺧\\u0756\'\)\ throws\ error\ B1\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:915\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠆸。60𐺧\x{0756}", %p)},	undef,	"to_ascii\(\'\󠆸\。60𐺧\\u0756\'\)\ throws\ error\ B1\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:916\]") or ($@ and diag($@));
is(eval{uts46_to_ascii(".xn--60-cke9470y", %p)},	undef,	"to_ascii\(\'\.xn\-\-60\-cke9470y\'\)\ throws\ error\ B1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:917\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("6\x{084F}｡-𑈴", %p)},	undef,	"to_ascii\(\'6\\u084F｡\-𑈴\'\)\ throws\ error\ B1\ V3\ \[data\/IdnaTest\.txt\:918\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("6\x{084F}。-𑈴", %p)},	undef,	"to_ascii\(\'6\\u084F\。\-𑈴\'\)\ throws\ error\ B1\ V3\ \[data\/IdnaTest\.txt\:919\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--6-jjd.xn----6n8i", %p)},	undef,	"to_ascii\(\'xn\-\-6\-jjd\.xn\-\-\-\-6n8i\'\)\ throws\ error\ B1\ V3\ \[data\/IdnaTest\.txt\:920\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}񋌿𐹰｡\x{0ACD}ς𞰎\x{08D6}", %p)},	undef,	"to_ascii\(\'\\u200D\?𐹰｡\\u0ACDς\?\\u08D6\'\)\ throws\ error\ B1\ B5\ B6\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:921\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}񋌿𐹰。\x{0ACD}ς𞰎\x{08D6}", %p)},	undef,	"to_ascii\(\'\\u200D\?𐹰\。\\u0ACDς\?\\u08D6\'\)\ throws\ error\ B1\ B5\ B6\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:923\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}񋌿𐹰。\x{0ACD}Σ𞰎\x{08D6}", %p)},	undef,	"to_ascii\(\'\\u200D\?𐹰\。\\u0ACDΣ\?\\u08D6\'\)\ throws\ error\ B1\ B5\ B6\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:925\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}񋌿𐹰。\x{0ACD}σ𞰎\x{08D6}", %p)},	undef,	"to_ascii\(\'\\u200D\?𐹰\。\\u0ACDσ\?\\u08D6\'\)\ throws\ error\ B1\ B5\ B6\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:927\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--oo0d1330n.xn--4xa21xcwbfz15g", %p)},	undef,	"to_ascii\(\'xn\-\-oo0d1330n\.xn\-\-4xa21xcwbfz15g\'\)\ throws\ error\ B1\ B5\ B6\ V5\ V6\ \[data\/IdnaTest\.txt\:929\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--1ugx105gq26y.xn--4xa21xcwbfz15g", %p)},	undef,	"to_ascii\(\'xn\-\-1ugx105gq26y\.xn\-\-4xa21xcwbfz15g\'\)\ throws\ error\ B1\ C2\ V5\ V6\ \[data\/IdnaTest\.txt\:930\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--1ugx105gq26y.xn--3xa41xcwbfz15g", %p)},	undef,	"to_ascii\(\'xn\-\-1ugx105gq26y\.xn\-\-3xa41xcwbfz15g\'\)\ throws\ error\ B1\ C2\ V5\ V6\ \[data\/IdnaTest\.txt\:931\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}񋌿𐹰｡\x{0ACD}Σ𞰎\x{08D6}", %p)},	undef,	"to_ascii\(\'\\u200D\?𐹰｡\\u0ACDΣ\?\\u08D6\'\)\ throws\ error\ B1\ B5\ B6\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:932\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}񋌿𐹰｡\x{0ACD}σ𞰎\x{08D6}", %p)},	undef,	"to_ascii\(\'\\u200D\?𐹰｡\\u0ACDσ\?\\u08D6\'\)\ throws\ error\ B1\ B5\ B6\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:934\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⒈񟄜Ⴓ⒪．\x{0DCA}򘘶\x{088B}𐹢", %p)},	undef,	"to_ascii\(\'⒈\?Ⴓ⒪．\\u0DCA\?\\u088B𐹢\'\)\ throws\ error\ B1\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:936\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("1.񟄜Ⴓ(o).\x{0DCA}򘘶\x{088B}𐹢", %p)},	undef,	"to_ascii\(\'1\.\?Ⴓ\(o\)\.\\u0DCA\?\\u088B𐹢\'\)\ throws\ error\ B1\ B6\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:937\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("1.񟄜ⴓ(o).\x{0DCA}򘘶\x{088B}𐹢", %p)},	undef,	"to_ascii\(\'1\.\?ⴓ\(o\)\.\\u0DCA\?\\u088B𐹢\'\)\ throws\ error\ B1\ B6\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:938\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("1.񟄜Ⴓ(O).\x{0DCA}򘘶\x{088B}𐹢", %p)},	undef,	"to_ascii\(\'1\.\?Ⴓ\(O\)\.\\u0DCA\?\\u088B𐹢\'\)\ throws\ error\ B1\ B6\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:939\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("1.xn--(o)-7sn88849j.xn--3xb99xpx1yoes3e", %p)},	undef,	"to_ascii\(\'1\.xn\-\-\(o\)\-7sn88849j\.xn\-\-3xb99xpx1yoes3e\'\)\ throws\ error\ B1\ B6\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:940\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("1.xn--(o)-ej1bu5389e.xn--3xb99xpx1yoes3e", %p)},	undef,	"to_ascii\(\'1\.xn\-\-\(o\)\-ej1bu5389e\.xn\-\-3xb99xpx1yoes3e\'\)\ throws\ error\ B1\ B6\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:941\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⒈񟄜ⴓ⒪．\x{0DCA}򘘶\x{088B}𐹢", %p)},	undef,	"to_ascii\(\'⒈\?ⴓ⒪．\\u0DCA\?\\u088B𐹢\'\)\ throws\ error\ B1\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:942\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--tsh0ds63atl31n.xn--3xb99xpx1yoes3e", %p)},	undef,	"to_ascii\(\'xn\-\-tsh0ds63atl31n\.xn\-\-3xb99xpx1yoes3e\'\)\ throws\ error\ B1\ V5\ V6\ \[data\/IdnaTest\.txt\:943\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--rnd762h7cx3027d.xn--3xb99xpx1yoes3e", %p)},	undef,	"to_ascii\(\'xn\-\-rnd762h7cx3027d\.xn\-\-3xb99xpx1yoes3e\'\)\ throws\ error\ B1\ V5\ V6\ \[data\/IdnaTest\.txt\:944\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("𞤷.𐮐𞢁𐹠\x{0624}", %p)},	"xn--ve6h.xn--jgb1694kz0b2176a",	"to_ascii\(\'𞤷\.𐮐𞢁𐹠\\u0624\'\)\ \[data\/IdnaTest\.txt\:945\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("𞤷.𐮐𞢁𐹠\x{0648}\x{0654}", %p)},	"xn--ve6h.xn--jgb1694kz0b2176a",	"to_ascii\(\'𞤷\.𐮐𞢁𐹠\\u0648\\u0654\'\)\ \[data\/IdnaTest\.txt\:946\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("𞤕.𐮐𞢁𐹠\x{0648}\x{0654}", %p)},	"xn--ve6h.xn--jgb1694kz0b2176a",	"to_ascii\(\'𞤕\.𐮐𞢁𐹠\\u0648\\u0654\'\)\ \[data\/IdnaTest\.txt\:947\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("𞤕.𐮐𞢁𐹠\x{0624}", %p)},	"xn--ve6h.xn--jgb1694kz0b2176a",	"to_ascii\(\'𞤕\.𐮐𞢁𐹠\\u0624\'\)\ \[data\/IdnaTest\.txt\:948\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("xn--ve6h.xn--jgb1694kz0b2176a", %p)},	"xn--ve6h.xn--jgb1694kz0b2176a",	"to_ascii\(\'xn\-\-ve6h\.xn\-\-jgb1694kz0b2176a\'\)\ \[data\/IdnaTest\.txt\:949\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("𐲈-｡𑄳񢌻", %p)},	undef,	"to_ascii\(\'𐲈\-｡𑄳\?\'\)\ throws\ error\ B1\ B3\ P1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:950\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐲈-。𑄳񢌻", %p)},	undef,	"to_ascii\(\'𐲈\-\。𑄳\?\'\)\ throws\ error\ B1\ B3\ P1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:951\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐳈-。𑄳񢌻", %p)},	undef,	"to_ascii\(\'𐳈\-\。𑄳\?\'\)\ throws\ error\ B1\ B3\ P1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:952\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----ue6i.xn--v80d6662t", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-ue6i\.xn\-\-v80d6662t\'\)\ throws\ error\ B1\ B3\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:953\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐳈-｡𑄳񢌻", %p)},	undef,	"to_ascii\(\'𐳈\-｡𑄳\?\'\)\ throws\ error\ B1\ B3\ P1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:954\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-󠉖ꡧ．󠊂񇆃🄉", %p)},	undef,	"to_ascii\(\'\-\?ꡧ．\?\?🄉\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:955\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-󠉖ꡧ.󠊂񇆃8,", %p)},	undef,	"to_ascii\(\'\-\?ꡧ\.\?\?8\,\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:956\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----hg4ei0361g.xn--8,-k362evu488a", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-hg4ei0361g\.xn\-\-8\,\-k362evu488a\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:957\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----hg4ei0361g.xn--207ht163h7m94c", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-hg4ei0361g\.xn\-\-207ht163h7m94c\'\)\ throws\ error\ V3\ V6\ \[data\/IdnaTest\.txt\:958\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠾛󠈴臯𧔤.\x{0768}𝟝", %p)},	undef,	"to_ascii\(\'\?\?臯𧔤\.\\u0768𝟝\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:959\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠾛󠈴臯𧔤.\x{0768}5", %p)},	undef,	"to_ascii\(\'\?\?臯𧔤\.\\u07685\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:960\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--zb1at733hm579ddhla.xn--5-b5c", %p)},	undef,	"to_ascii\(\'xn\-\-zb1at733hm579ddhla\.xn\-\-5\-b5c\'\)\ throws\ error\ B1\ V6\ \[data\/IdnaTest\.txt\:961\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≮𐹣．𝨿", %p)},	undef,	"to_ascii\(\'\≮𐹣．𝨿\'\)\ throws\ error\ B1\ B3\ B6\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:962\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("<\x{0338}𐹣．𝨿", %p)},	undef,	"to_ascii\(\'\<\\u0338𐹣．𝨿\'\)\ throws\ error\ B1\ B3\ B6\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:963\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≮𐹣.𝨿", %p)},	undef,	"to_ascii\(\'\≮𐹣\.𝨿\'\)\ throws\ error\ B1\ B3\ B6\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:964\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("<\x{0338}𐹣.𝨿", %p)},	undef,	"to_ascii\(\'\<\\u0338𐹣\.𝨿\'\)\ throws\ error\ B1\ B3\ B6\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:965\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--gdh1504g.xn--e92h", %p)},	undef,	"to_ascii\(\'xn\-\-gdh1504g\.xn\-\-e92h\'\)\ throws\ error\ B1\ B3\ B6\ V5\ V6\ \[data\/IdnaTest\.txt\:966\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_ascii("𐹯ᯛ\x{0A4D}｡脥", %p)},	undef,	"to_ascii\(\'𐹯ᯛ\\u0A4D｡脥\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:967\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_ascii("𐹯ᯛ\x{0A4D}。脥", %p)},	undef,	"to_ascii\(\'𐹯ᯛ\\u0A4D\。脥\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:968\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--ybc101g3m1p.xn--740a", %p)},	undef,	"to_ascii\(\'xn\-\-ybc101g3m1p\.xn\-\-740a\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:969\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1B44}\x{115F}𞷿򃀍.-", %p)},	undef,	"to_ascii\(\'\\u1B44\\u115F\?\?\.\-\'\)\ throws\ error\ B1\ B5\ P1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:970\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--osd971cpx70btgt8b.-", %p)},	undef,	"to_ascii\(\'xn\-\-osd971cpx70btgt8b\.\-\'\)\ throws\ error\ B1\ B5\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:971\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}｡\x{0354}", %p)},	undef,	"to_ascii\(\'\\u200C｡\\u0354\'\)\ throws\ error\ V5\ A4_2\ \[data\/IdnaTest\.txt\:972\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}。\x{0354}", %p)},	undef,	"to_ascii\(\'\\u200C\。\\u0354\'\)\ throws\ error\ V5\ A4_2\ \[data\/IdnaTest\.txt\:974\]") or ($@ and diag($@));
is(eval{uts46_to_ascii(".xn--yua", %p)},	undef,	"to_ascii\(\'\.xn\-\-yua\'\)\ throws\ error\ V5\ A4_2\ \[data\/IdnaTest\.txt\:976\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--0ug.xn--yua", %p)},	undef,	"to_ascii\(\'xn\-\-0ug\.xn\-\-yua\'\)\ throws\ error\ C1\ V5\ \[data\/IdnaTest\.txt\:977\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𞤥󠅮．ᡄႮ", %p)},	undef,	"to_ascii\(\'𞤥\󠅮．ᡄႮ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:978\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𞤥󠅮.ᡄႮ", %p)},	undef,	"to_ascii\(\'𞤥\󠅮\.ᡄႮ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:979\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("𞤥󠅮.ᡄⴎ", %p)},	"xn--de6h.xn--37e857h",	"to_ascii\(\'𞤥\󠅮\.ᡄⴎ\'\)\ \[data\/IdnaTest\.txt\:980\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("𞤃󠅮.ᡄႮ", %p)},	undef,	"to_ascii\(\'𞤃\󠅮\.ᡄႮ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:981\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("𞤃󠅮.ᡄⴎ", %p)},	"xn--de6h.xn--37e857h",	"to_ascii\(\'𞤃\󠅮\.ᡄⴎ\'\)\ \[data\/IdnaTest\.txt\:982\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("xn--de6h.xn--37e857h", %p)},	"xn--de6h.xn--37e857h",	"to_ascii\(\'xn\-\-de6h\.xn\-\-37e857h\'\)\ \[data\/IdnaTest\.txt\:983\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("𞤥.ᡄⴎ", %p)},	"xn--de6h.xn--37e857h",	"to_ascii\(\'𞤥\.ᡄⴎ\'\)\ \[data\/IdnaTest\.txt\:984\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("𞤃.ᡄႮ", %p)},	undef,	"to_ascii\(\'𞤃\.ᡄႮ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:985\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("𞤃.ᡄⴎ", %p)},	"xn--de6h.xn--37e857h",	"to_ascii\(\'𞤃\.ᡄⴎ\'\)\ \[data\/IdnaTest\.txt\:986\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--de6h.xn--mnd799a", %p)},	undef,	"to_ascii\(\'xn\-\-de6h\.xn\-\-mnd799a\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:987\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("𞤥󠅮．ᡄⴎ", %p)},	"xn--de6h.xn--37e857h",	"to_ascii\(\'𞤥\󠅮．ᡄⴎ\'\)\ \[data\/IdnaTest\.txt\:988\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("𞤃󠅮．ᡄႮ", %p)},	undef,	"to_ascii\(\'𞤃\󠅮．ᡄႮ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:989\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("𞤃󠅮．ᡄⴎ", %p)},	"xn--de6h.xn--37e857h",	"to_ascii\(\'𞤃\󠅮．ᡄⴎ\'\)\ \[data\/IdnaTest\.txt\:990\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("𞤥.ᡄႮ", %p)},	undef,	"to_ascii\(\'𞤥\.ᡄႮ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:991\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("𞤧𝨨Ξ．𪺏㛨❸", %p)},	undef,	"to_ascii\(\'𞤧𝨨Ξ．𪺏㛨❸\'\)\ throws\ error\ B2\ B3\ B6\ \[data\/IdnaTest\.txt\:992\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("𞤧𝨨Ξ.𪺏㛨❸", %p)},	undef,	"to_ascii\(\'𞤧𝨨Ξ\.𪺏㛨❸\'\)\ throws\ error\ B2\ B3\ B6\ \[data\/IdnaTest\.txt\:993\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("𞤧𝨨ξ.𪺏㛨❸", %p)},	undef,	"to_ascii\(\'𞤧𝨨ξ\.𪺏㛨❸\'\)\ throws\ error\ B2\ B3\ B6\ \[data\/IdnaTest\.txt\:994\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("𞤅𝨨Ξ.𪺏㛨❸", %p)},	undef,	"to_ascii\(\'𞤅𝨨Ξ\.𪺏㛨❸\'\)\ throws\ error\ B2\ B3\ B6\ \[data\/IdnaTest\.txt\:995\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("𞤅𝨨ξ.𪺏㛨❸", %p)},	undef,	"to_ascii\(\'𞤅𝨨ξ\.𪺏㛨❸\'\)\ throws\ error\ B2\ B3\ B6\ \[data\/IdnaTest\.txt\:996\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--zxa5691vboja.xn--bfi293ci119b", %p)},	undef,	"to_ascii\(\'xn\-\-zxa5691vboja\.xn\-\-bfi293ci119b\'\)\ throws\ error\ B2\ B3\ B6\ \[data\/IdnaTest\.txt\:997\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("𞤧𝨨ξ．𪺏㛨❸", %p)},	undef,	"to_ascii\(\'𞤧𝨨ξ．𪺏㛨❸\'\)\ throws\ error\ B2\ B3\ B6\ \[data\/IdnaTest\.txt\:998\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("𞤅𝨨Ξ．𪺏㛨❸", %p)},	undef,	"to_ascii\(\'𞤅𝨨Ξ．𪺏㛨❸\'\)\ throws\ error\ B2\ B3\ B6\ \[data\/IdnaTest\.txt\:999\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("𞤅𝨨ξ．𪺏㛨❸", %p)},	undef,	"to_ascii\(\'𞤅𝨨ξ．𪺏㛨❸\'\)\ throws\ error\ B2\ B3\ B6\ \[data\/IdnaTest\.txt\:1000\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("᠆몆\x{200C}-｡Ⴛ𐦅︒", %p)},	undef,	"to_ascii\(\'᠆몆\\u200C\-｡Ⴛ𐦅︒\'\)\ throws\ error\ B1\ B5\ B6\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:1001\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("᠆몆\x{200C}-｡Ⴛ𐦅︒", %p)},	undef,	"to_ascii\(\'᠆몆\\u200C\-｡Ⴛ𐦅︒\'\)\ throws\ error\ B1\ B5\ B6\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:1003\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("᠆몆\x{200C}-。Ⴛ𐦅。", %p)},	undef,	"to_ascii\(\'᠆몆\\u200C\-\。Ⴛ𐦅\。\'\)\ throws\ error\ B1\ B5\ B6\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:1005\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("᠆몆\x{200C}-。Ⴛ𐦅。", %p)},	undef,	"to_ascii\(\'᠆몆\\u200C\-\。Ⴛ𐦅\。\'\)\ throws\ error\ B1\ B5\ B6\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:1007\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("᠆몆\x{200C}-。ⴛ𐦅。", %p)},	undef,	"to_ascii\(\'᠆몆\\u200C\-\。ⴛ𐦅\。\'\)\ throws\ error\ B1\ B5\ B6\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:1009\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("᠆몆\x{200C}-。ⴛ𐦅。", %p)},	undef,	"to_ascii\(\'᠆몆\\u200C\-\。ⴛ𐦅\。\'\)\ throws\ error\ B1\ B5\ B6\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:1011\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----e3j6620g.xn--jlju661e.", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-e3j6620g\.xn\-\-jlju661e\.\'\)\ throws\ error\ B1\ B5\ B6\ V3\ V6\ \[data\/IdnaTest\.txt\:1013\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----e3j425bsk1o.xn--jlju661e.", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-e3j425bsk1o\.xn\-\-jlju661e\.\'\)\ throws\ error\ B1\ B5\ B6\ C1\ V3\ V6\ \[data\/IdnaTest\.txt\:1014\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----e3j6620g.xn--znd4948j.", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-e3j6620g\.xn\-\-znd4948j\.\'\)\ throws\ error\ B1\ B5\ B6\ V3\ V6\ \[data\/IdnaTest\.txt\:1015\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----e3j425bsk1o.xn--znd4948j.", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-e3j425bsk1o\.xn\-\-znd4948j\.\'\)\ throws\ error\ B1\ B5\ B6\ C1\ V3\ V6\ \[data\/IdnaTest\.txt\:1016\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("᠆몆\x{200C}-｡ⴛ𐦅︒", %p)},	undef,	"to_ascii\(\'᠆몆\\u200C\-｡ⴛ𐦅︒\'\)\ throws\ error\ B1\ B5\ B6\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:1017\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("᠆몆\x{200C}-｡ⴛ𐦅︒", %p)},	undef,	"to_ascii\(\'᠆몆\\u200C\-｡ⴛ𐦅︒\'\)\ throws\ error\ B1\ B5\ B6\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:1019\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----e3j6620g.xn--jlj4997dhgh", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-e3j6620g\.xn\-\-jlj4997dhgh\'\)\ throws\ error\ B1\ B5\ B6\ V3\ V6\ \[data\/IdnaTest\.txt\:1021\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----e3j425bsk1o.xn--jlj4997dhgh", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-e3j425bsk1o\.xn\-\-jlj4997dhgh\'\)\ throws\ error\ B1\ B5\ B6\ C1\ V3\ V6\ \[data\/IdnaTest\.txt\:1022\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----e3j6620g.xn--znd2362jhgh", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-e3j6620g\.xn\-\-znd2362jhgh\'\)\ throws\ error\ B1\ B5\ B6\ V3\ V6\ \[data\/IdnaTest\.txt\:1023\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----e3j425bsk1o.xn--znd2362jhgh", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-e3j425bsk1o\.xn\-\-znd2362jhgh\'\)\ throws\ error\ B1\ B5\ B6\ C1\ V3\ V6\ \[data\/IdnaTest\.txt\:1024\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠾳.︒⥱\x{200C}𐹬", %p)},	undef,	"to_ascii\(\'\?\.︒\⥱\\u200C𐹬\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:1025\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠾳.。⥱\x{200C}𐹬", %p)},	undef,	"to_ascii\(\'\?\.\。\⥱\\u200C𐹬\'\)\ throws\ error\ B1\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:1027\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--uf66e..xn--qti2829e", %p)},	undef,	"to_ascii\(\'xn\-\-uf66e\.\.xn\-\-qti2829e\'\)\ throws\ error\ B1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:1029\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--uf66e..xn--0ugz28as66q", %p)},	undef,	"to_ascii\(\'xn\-\-uf66e\.\.xn\-\-0ugz28as66q\'\)\ throws\ error\ B1\ C1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:1030\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--uf66e.xn--qtiz073e3ik", %p)},	undef,	"to_ascii\(\'xn\-\-uf66e\.xn\-\-qtiz073e3ik\'\)\ throws\ error\ B1\ V6\ \[data\/IdnaTest\.txt\:1031\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--uf66e.xn--0ugz28axl3pqxna", %p)},	undef,	"to_ascii\(\'xn\-\-uf66e\.xn\-\-0ugz28axl3pqxna\'\)\ throws\ error\ B1\ C1\ V6\ \[data\/IdnaTest\.txt\:1032\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐯖.𐹠Ⴑ񚇜𐫊", %p)},	undef,	"to_ascii\(\'\?\.𐹠Ⴑ\?𐫊\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:1033\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐯖.𐹠ⴑ񚇜𐫊", %p)},	undef,	"to_ascii\(\'\?\.𐹠ⴑ\?𐫊\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:1034\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--n49c.xn--8kj8702ewicl862o", %p)},	undef,	"to_ascii\(\'xn\-\-n49c\.xn\-\-8kj8702ewicl862o\'\)\ throws\ error\ B1\ V6\ \[data\/IdnaTest\.txt\:1035\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--n49c.xn--pnd4619jwicl862o", %p)},	undef,	"to_ascii\(\'xn\-\-n49c\.xn\-\-pnd4619jwicl862o\'\)\ throws\ error\ B1\ V6\ \[data\/IdnaTest\.txt\:1036\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0FA4}񱤯．𝟭Ⴛ", %p)},	undef,	"to_ascii\(\'\\u0FA4\?．𝟭Ⴛ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1037\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0FA4}񱤯.1Ⴛ", %p)},	undef,	"to_ascii\(\'\\u0FA4\?\.1Ⴛ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1038\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0FA4}񱤯.1ⴛ", %p)},	undef,	"to_ascii\(\'\\u0FA4\?\.1ⴛ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1039\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--0fd40533g.xn--1-tws", %p)},	undef,	"to_ascii\(\'xn\-\-0fd40533g\.xn\-\-1\-tws\'\)\ throws\ error\ V5\ V6\ \[data\/IdnaTest\.txt\:1040\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--0fd40533g.xn--1-q1g", %p)},	undef,	"to_ascii\(\'xn\-\-0fd40533g\.xn\-\-1\-q1g\'\)\ throws\ error\ V5\ V6\ \[data\/IdnaTest\.txt\:1041\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0FA4}񱤯．𝟭ⴛ", %p)},	undef,	"to_ascii\(\'\\u0FA4\?．𝟭ⴛ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1042\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-\x{0826}齀。릿𐸋", %p)},	undef,	"to_ascii\(\'\-\\u0826齀\。릿\?\'\)\ throws\ error\ B1\ B5\ B6\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:1043\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-\x{0826}齀。릿𐸋", %p)},	undef,	"to_ascii\(\'\-\\u0826齀\。릿\?\'\)\ throws\ error\ B1\ B5\ B6\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:1044\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----6gd0617i.xn--7y2bm55m", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-6gd0617i\.xn\-\-7y2bm55m\'\)\ throws\ error\ B1\ B5\ B6\ V3\ V6\ \[data\/IdnaTest\.txt\:1045\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠔊\x{071C}鹝꾗。񾵐\x{200D}\x{200D}⏃", %p)},	undef,	"to_ascii\(\'\?\\u071C鹝꾗\。\?\\u200D\\u200D\⏃\'\)\ throws\ error\ B1\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:1046\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠔊\x{071C}鹝꾗。񾵐\x{200D}\x{200D}⏃", %p)},	undef,	"to_ascii\(\'\?\\u071C鹝꾗\。\?\\u200D\\u200D\⏃\'\)\ throws\ error\ B1\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:1048\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--mnb6558e91kyq533a.xn--6mh27269e", %p)},	undef,	"to_ascii\(\'xn\-\-mnb6558e91kyq533a\.xn\-\-6mh27269e\'\)\ throws\ error\ B1\ B6\ V6\ \[data\/IdnaTest\.txt\:1050\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--mnb6558e91kyq533a.xn--1uga46zs309y", %p)},	undef,	"to_ascii\(\'xn\-\-mnb6558e91kyq533a\.xn\-\-1uga46zs309y\'\)\ throws\ error\ B1\ B6\ C2\ V6\ \[data\/IdnaTest\.txt\:1051\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≮．-\x{0708}--", %p)},	undef,	"to_ascii\(\'\≮．\-\\u0708\-\-\'\)\ throws\ error\ B1\ P1\ V2\ V3\ V6\ \[data\/IdnaTest\.txt\:1052\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("<\x{0338}．-\x{0708}--", %p)},	undef,	"to_ascii\(\'\<\\u0338．\-\\u0708\-\-\'\)\ throws\ error\ B1\ P1\ V2\ V3\ V6\ \[data\/IdnaTest\.txt\:1053\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≮.-\x{0708}--", %p)},	undef,	"to_ascii\(\'\≮\.\-\\u0708\-\-\'\)\ throws\ error\ B1\ P1\ V2\ V3\ V6\ \[data\/IdnaTest\.txt\:1054\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("<\x{0338}.-\x{0708}--", %p)},	undef,	"to_ascii\(\'\<\\u0338\.\-\\u0708\-\-\'\)\ throws\ error\ B1\ P1\ V2\ V3\ V6\ \[data\/IdnaTest\.txt\:1055\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--gdh.xn------eqf", %p)},	undef,	"to_ascii\(\'xn\-\-gdh\.xn\-\-\-\-\-\-eqf\'\)\ throws\ error\ B1\ V2\ V3\ V6\ \[data\/IdnaTest\.txt\:1056\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐹸󠋳。\x{200D}ς𝟩", %p)},	undef,	"to_ascii\(\'𐹸\?\。\\u200Dς𝟩\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:1057\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐹸󠋳。\x{200D}ς7", %p)},	undef,	"to_ascii\(\'𐹸\?\。\\u200Dς7\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:1059\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐹸󠋳。\x{200D}Σ7", %p)},	undef,	"to_ascii\(\'𐹸\?\。\\u200DΣ7\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:1061\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐹸󠋳。\x{200D}σ7", %p)},	undef,	"to_ascii\(\'𐹸\?\。\\u200Dσ7\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:1063\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--wo0di5177c.xn--7-zmb", %p)},	undef,	"to_ascii\(\'xn\-\-wo0di5177c\.xn\-\-7\-zmb\'\)\ throws\ error\ B1\ V6\ \[data\/IdnaTest\.txt\:1065\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--wo0di5177c.xn--7-zmb938s", %p)},	undef,	"to_ascii\(\'xn\-\-wo0di5177c\.xn\-\-7\-zmb938s\'\)\ throws\ error\ B1\ C2\ V6\ \[data\/IdnaTest\.txt\:1066\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--wo0di5177c.xn--7-xmb248s", %p)},	undef,	"to_ascii\(\'xn\-\-wo0di5177c\.xn\-\-7\-xmb248s\'\)\ throws\ error\ B1\ C2\ V6\ \[data\/IdnaTest\.txt\:1067\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐹸󠋳。\x{200D}Σ𝟩", %p)},	undef,	"to_ascii\(\'𐹸\?\。\\u200DΣ𝟩\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:1068\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐹸󠋳。\x{200D}σ𝟩", %p)},	undef,	"to_ascii\(\'𐹸\?\。\\u200Dσ𝟩\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:1070\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ς򅜌８.𞭤", %p)},	undef,	"to_ascii\(\'ς\?８\.\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1072\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ς򅜌8.𞭤", %p)},	undef,	"to_ascii\(\'ς\?8\.\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1074\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Σ򅜌8.𞭤", %p)},	undef,	"to_ascii\(\'Σ\?8\.\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1076\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("σ򅜌8.𞭤", %p)},	undef,	"to_ascii\(\'σ\?8\.\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1077\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--8-zmb14974n.xn--su6h", %p)},	undef,	"to_ascii\(\'xn\-\-8\-zmb14974n\.xn\-\-su6h\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:1078\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--8-xmb44974n.xn--su6h", %p)},	undef,	"to_ascii\(\'xn\-\-8\-xmb44974n\.xn\-\-su6h\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:1079\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Σ򅜌８.𞭤", %p)},	undef,	"to_ascii\(\'Σ\?８\.\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1080\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("σ򅜌８.𞭤", %p)},	undef,	"to_ascii\(\'σ\?８\.\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1081\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}ᡑ🄀\x{0684}．-𐫄𑲤", %p)},	undef,	"to_ascii\(\'\\u200Cᡑ🄀\\u0684．\-𐫄𑲤\'\)\ throws\ error\ B1\ B5\ B6\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:1082\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("\x{200C}ᡑ0.\x{0684}.-𐫄𑲤", %p)},	undef,	"to_ascii\(\'\\u200Cᡑ0\.\\u0684\.\-𐫄𑲤\'\)\ throws\ error\ B1\ V3\ \[data\/IdnaTest\.txt\:1084\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--0-o7j.xn--9ib.xn----ek5i065b", %p)},	undef,	"to_ascii\(\'xn\-\-0\-o7j\.xn\-\-9ib\.xn\-\-\-\-ek5i065b\'\)\ throws\ error\ B1\ V3\ \[data\/IdnaTest\.txt\:1086\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--0-o7j263b.xn--9ib.xn----ek5i065b", %p)},	undef,	"to_ascii\(\'xn\-\-0\-o7j263b\.xn\-\-9ib\.xn\-\-\-\-ek5i065b\'\)\ throws\ error\ B1\ C1\ V3\ \[data\/IdnaTest\.txt\:1087\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--9ib722gbw95a.xn----ek5i065b", %p)},	undef,	"to_ascii\(\'xn\-\-9ib722gbw95a\.xn\-\-\-\-ek5i065b\'\)\ throws\ error\ B1\ B5\ B6\ V3\ V6\ \[data\/IdnaTest\.txt\:1088\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--9ib722gvtfi563c.xn----ek5i065b", %p)},	undef,	"to_ascii\(\'xn\-\-9ib722gvtfi563c\.xn\-\-\-\-ek5i065b\'\)\ throws\ error\ B1\ C1\ V3\ V6\ \[data\/IdnaTest\.txt\:1089\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𖠍。𐪿넯򞵲", %p)},	undef,	"to_ascii\(\'𖠍\。\?넯\?\'\)\ throws\ error\ B2\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:1090\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𖠍。𐪿넯򞵲", %p)},	undef,	"to_ascii\(\'𖠍\。\?넯\?\'\)\ throws\ error\ B2\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:1091\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--4e9e.xn--l60bj21opd57g", %p)},	undef,	"to_ascii\(\'xn\-\-4e9e\.xn\-\-l60bj21opd57g\'\)\ throws\ error\ B2\ B3\ V6\ \[data\/IdnaTest\.txt\:1092\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("᠇Ⴘ。\x{0603}Ⴈ𝆊", %p)},	undef,	"to_ascii\(\'᠇Ⴘ\。\\u0603Ⴈ𝆊\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:1093\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("᠇ⴘ。\x{0603}ⴈ𝆊", %p)},	undef,	"to_ascii\(\'᠇ⴘ\。\\u0603ⴈ𝆊\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:1094\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--d6e009h.xn--lfb290rfu3z", %p)},	undef,	"to_ascii\(\'xn\-\-d6e009h\.xn\-\-lfb290rfu3z\'\)\ throws\ error\ B1\ V6\ \[data\/IdnaTest\.txt\:1095\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--wnd558a.xn--lfb465c1v87a", %p)},	undef,	"to_ascii\(\'xn\-\-wnd558a\.xn\-\-lfb465c1v87a\'\)\ throws\ error\ B1\ V6\ \[data\/IdnaTest\.txt\:1096\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⒚󠋑𞤰。牣\x{0667}Ⴜᣥ", %p)},	undef,	"to_ascii\(\'⒚\?𞤰\。牣\\u0667Ⴜᣥ\'\)\ throws\ error\ B1\ B5\ P1\ V6\ \[data\/IdnaTest\.txt\:1097\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("19.󠋑𞤰。牣\x{0667}Ⴜᣥ", %p)},	undef,	"to_ascii\(\'19\.\?𞤰\。牣\\u0667Ⴜᣥ\'\)\ throws\ error\ B1\ B5\ P1\ V6\ \[data\/IdnaTest\.txt\:1098\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("19.󠋑𞤰。牣\x{0667}ⴜᣥ", %p)},	undef,	"to_ascii\(\'19\.\?𞤰\。牣\\u0667ⴜᣥ\'\)\ throws\ error\ B1\ B5\ P1\ V6\ \[data\/IdnaTest\.txt\:1099\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("19.󠋑𞤎。牣\x{0667}Ⴜᣥ", %p)},	undef,	"to_ascii\(\'19\.\?𞤎\。牣\\u0667Ⴜᣥ\'\)\ throws\ error\ B1\ B5\ P1\ V6\ \[data\/IdnaTest\.txt\:1100\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("19.xn--oe6h75760c.xn--gib404ccxgh00h", %p)},	undef,	"to_ascii\(\'19\.xn\-\-oe6h75760c\.xn\-\-gib404ccxgh00h\'\)\ throws\ error\ B1\ B5\ V6\ \[data\/IdnaTest\.txt\:1101\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("19.xn--oe6h75760c.xn--gib285gtxo2l9d", %p)},	undef,	"to_ascii\(\'19\.xn\-\-oe6h75760c\.xn\-\-gib285gtxo2l9d\'\)\ throws\ error\ B1\ B5\ V6\ \[data\/IdnaTest\.txt\:1102\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⒚󠋑𞤰。牣\x{0667}ⴜᣥ", %p)},	undef,	"to_ascii\(\'⒚\?𞤰\。牣\\u0667ⴜᣥ\'\)\ throws\ error\ B1\ B5\ P1\ V6\ \[data\/IdnaTest\.txt\:1103\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⒚󠋑𞤎。牣\x{0667}Ⴜᣥ", %p)},	undef,	"to_ascii\(\'⒚\?𞤎\。牣\\u0667Ⴜᣥ\'\)\ throws\ error\ B1\ B5\ P1\ V6\ \[data\/IdnaTest\.txt\:1104\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--cthy466n29j3e.xn--gib404ccxgh00h", %p)},	undef,	"to_ascii\(\'xn\-\-cthy466n29j3e\.xn\-\-gib404ccxgh00h\'\)\ throws\ error\ B1\ B5\ V6\ \[data\/IdnaTest\.txt\:1105\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--cthy466n29j3e.xn--gib285gtxo2l9d", %p)},	undef,	"to_ascii\(\'xn\-\-cthy466n29j3e\.xn\-\-gib285gtxo2l9d\'\)\ throws\ error\ B1\ B5\ V6\ \[data\/IdnaTest\.txt\:1106\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-𐋱𐰽⒈.Ⴓ", %p)},	undef,	"to_ascii\(\'\-𐋱𐰽⒈\.Ⴓ\'\)\ throws\ error\ B1\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:1107\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-𐋱𐰽1..Ⴓ", %p)},	undef,	"to_ascii\(\'\-𐋱𐰽1\.\.Ⴓ\'\)\ throws\ error\ B1\ P1\ V3\ V6\ A4_2\ \[data\/IdnaTest\.txt\:1108\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("-𐋱𐰽1..ⴓ", %p)},	undef,	"to_ascii\(\'\-𐋱𐰽1\.\.ⴓ\'\)\ throws\ error\ B1\ V3\ A4_2\ \[data\/IdnaTest\.txt\:1109\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn---1-895nq11a..xn--blj", %p)},	undef,	"to_ascii\(\'xn\-\-\-1\-895nq11a\.\.xn\-\-blj\'\)\ throws\ error\ B1\ V3\ A4_2\ \[data\/IdnaTest\.txt\:1110\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn---1-895nq11a..xn--rnd", %p)},	undef,	"to_ascii\(\'xn\-\-\-1\-895nq11a\.\.xn\-\-rnd\'\)\ throws\ error\ B1\ V3\ V6\ A4_2\ \[data\/IdnaTest\.txt\:1111\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-𐋱𐰽⒈.ⴓ", %p)},	undef,	"to_ascii\(\'\-𐋱𐰽⒈\.ⴓ\'\)\ throws\ error\ B1\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:1112\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----ecp0206g90h.xn--blj", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-ecp0206g90h\.xn\-\-blj\'\)\ throws\ error\ B1\ V3\ V6\ \[data\/IdnaTest\.txt\:1113\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----ecp0206g90h.xn--rnd", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-ecp0206g90h\.xn\-\-rnd\'\)\ throws\ error\ B1\ V3\ V6\ \[data\/IdnaTest\.txt\:1114\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}긃.榶-", %p)},	undef,	"to_ascii\(\'\\u200C긃\.榶\-\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:1115\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}긃.榶-", %p)},	undef,	"to_ascii\(\'\\u200C긃\.榶\-\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:1117\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--ej0b.xn----d87b", %p)},	undef,	"to_ascii\(\'xn\-\-ej0b\.xn\-\-\-\-d87b\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:1119\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--0ug3307c.xn----d87b", %p)},	undef,	"to_ascii\(\'xn\-\-0ug3307c\.xn\-\-\-\-d87b\'\)\ throws\ error\ C1\ V3\ \[data\/IdnaTest\.txt\:1120\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("뉓泓𜵽.\x{09CD}\x{200D}", %p)},	undef,	"to_ascii\(\'뉓泓\?\.\\u09CD\\u200D\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1121\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("뉓泓𜵽.\x{09CD}\x{200D}", %p)},	undef,	"to_ascii\(\'뉓泓\?\.\\u09CD\\u200D\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1123\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--lwwp69lqs7m.xn--b7b", %p)},	undef,	"to_ascii\(\'xn\-\-lwwp69lqs7m\.xn\-\-b7b\'\)\ throws\ error\ V5\ V6\ \[data\/IdnaTest\.txt\:1125\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--lwwp69lqs7m.xn--b7b605i", %p)},	undef,	"to_ascii\(\'xn\-\-lwwp69lqs7m\.xn\-\-b7b605i\'\)\ throws\ error\ V5\ V6\ \[data\/IdnaTest\.txt\:1126\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}𐹴ß｡\x{0EB4}\x{2B75}񪅌", %p)},	undef,	"to_ascii\(\'\\u200D𐹴ß｡\\u0EB4\\u2B75\?\'\)\ throws\ error\ B1\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1127\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}𐹴ß。\x{0EB4}\x{2B75}񪅌", %p)},	undef,	"to_ascii\(\'\\u200D𐹴ß\。\\u0EB4\\u2B75\?\'\)\ throws\ error\ B1\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1129\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}𐹴SS。\x{0EB4}\x{2B75}񪅌", %p)},	undef,	"to_ascii\(\'\\u200D𐹴SS\。\\u0EB4\\u2B75\?\'\)\ throws\ error\ B1\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1131\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}𐹴ss。\x{0EB4}\x{2B75}񪅌", %p)},	undef,	"to_ascii\(\'\\u200D𐹴ss\。\\u0EB4\\u2B75\?\'\)\ throws\ error\ B1\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1133\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}𐹴Ss。\x{0EB4}\x{2B75}񪅌", %p)},	undef,	"to_ascii\(\'\\u200D𐹴Ss\。\\u0EB4\\u2B75\?\'\)\ throws\ error\ B1\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1135\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--ss-ti3o.xn--57c638l8774i", %p)},	undef,	"to_ascii\(\'xn\-\-ss\-ti3o\.xn\-\-57c638l8774i\'\)\ throws\ error\ B1\ V5\ V6\ \[data\/IdnaTest\.txt\:1137\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--ss-l1t5169j.xn--57c638l8774i", %p)},	undef,	"to_ascii\(\'xn\-\-ss\-l1t5169j\.xn\-\-57c638l8774i\'\)\ throws\ error\ B1\ C2\ V5\ V6\ \[data\/IdnaTest\.txt\:1138\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--zca770nip7n.xn--57c638l8774i", %p)},	undef,	"to_ascii\(\'xn\-\-zca770nip7n\.xn\-\-57c638l8774i\'\)\ throws\ error\ B1\ C2\ V5\ V6\ \[data\/IdnaTest\.txt\:1139\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}𐹴SS｡\x{0EB4}\x{2B75}񪅌", %p)},	undef,	"to_ascii\(\'\\u200D𐹴SS｡\\u0EB4\\u2B75\?\'\)\ throws\ error\ B1\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1140\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}𐹴ss｡\x{0EB4}\x{2B75}񪅌", %p)},	undef,	"to_ascii\(\'\\u200D𐹴ss｡\\u0EB4\\u2B75\?\'\)\ throws\ error\ B1\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1142\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}𐹴Ss｡\x{0EB4}\x{2B75}񪅌", %p)},	undef,	"to_ascii\(\'\\u200D𐹴Ss｡\\u0EB4\\u2B75\?\'\)\ throws\ error\ B1\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1144\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1B44}．\x{1BAA}-≮≠", %p)},	undef,	"to_ascii\(\'\\u1B44．\\u1BAA\-\≮\≠\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1146\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1B44}．\x{1BAA}-<\x{0338}=\x{0338}", %p)},	undef,	"to_ascii\(\'\\u1B44．\\u1BAA\-\<\\u0338\=\\u0338\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1147\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1B44}.\x{1BAA}-≮≠", %p)},	undef,	"to_ascii\(\'\\u1B44\.\\u1BAA\-\≮\≠\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1148\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1B44}.\x{1BAA}-<\x{0338}=\x{0338}", %p)},	undef,	"to_ascii\(\'\\u1B44\.\\u1BAA\-\<\\u0338\=\\u0338\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1149\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--1uf.xn----nmlz65aub", %p)},	undef,	"to_ascii\(\'xn\-\-1uf\.xn\-\-\-\-nmlz65aub\'\)\ throws\ error\ V5\ V6\ \[data\/IdnaTest\.txt\:1150\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1BF3}Ⴑ\x{115F}．𑄴Ⅎ", %p)},	undef,	"to_ascii\(\'\\u1BF3Ⴑ\\u115F．𑄴Ⅎ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1151\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1BF3}Ⴑ\x{115F}.𑄴Ⅎ", %p)},	undef,	"to_ascii\(\'\\u1BF3Ⴑ\\u115F\.𑄴Ⅎ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1152\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1BF3}ⴑ\x{115F}.𑄴ⅎ", %p)},	undef,	"to_ascii\(\'\\u1BF3ⴑ\\u115F\.𑄴ⅎ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1153\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1BF3}Ⴑ\x{115F}.𑄴ⅎ", %p)},	undef,	"to_ascii\(\'\\u1BF3Ⴑ\\u115F\.𑄴ⅎ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1154\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--pnd26a55x.xn--73g3065g", %p)},	undef,	"to_ascii\(\'xn\-\-pnd26a55x\.xn\-\-73g3065g\'\)\ throws\ error\ V5\ V6\ \[data\/IdnaTest\.txt\:1155\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--osd925cvyn.xn--73g3065g", %p)},	undef,	"to_ascii\(\'xn\-\-osd925cvyn\.xn\-\-73g3065g\'\)\ throws\ error\ V5\ V6\ \[data\/IdnaTest\.txt\:1156\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--pnd26a55x.xn--f3g7465g", %p)},	undef,	"to_ascii\(\'xn\-\-pnd26a55x\.xn\-\-f3g7465g\'\)\ throws\ error\ V5\ V6\ \[data\/IdnaTest\.txt\:1157\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1BF3}ⴑ\x{115F}．𑄴ⅎ", %p)},	undef,	"to_ascii\(\'\\u1BF3ⴑ\\u115F．𑄴ⅎ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1158\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1BF3}Ⴑ\x{115F}．𑄴ⅎ", %p)},	undef,	"to_ascii\(\'\\u1BF3Ⴑ\\u115F．𑄴ⅎ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1159\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𜉆。Ⴃ𐴣𐹹똯", %p)},	undef,	"to_ascii\(\'\?\。Ⴃ𐴣𐹹똯\'\)\ throws\ error\ B5\ P1\ V6\ \[data\/IdnaTest\.txt\:1160\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𜉆。Ⴃ𐴣𐹹똯", %p)},	undef,	"to_ascii\(\'\?\。Ⴃ𐴣𐹹똯\'\)\ throws\ error\ B5\ P1\ V6\ \[data\/IdnaTest\.txt\:1161\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𜉆。ⴃ𐴣𐹹똯", %p)},	undef,	"to_ascii\(\'\?\。ⴃ𐴣𐹹똯\'\)\ throws\ error\ B5\ P1\ V6\ \[data\/IdnaTest\.txt\:1162\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𜉆。ⴃ𐴣𐹹똯", %p)},	undef,	"to_ascii\(\'\?\。ⴃ𐴣𐹹똯\'\)\ throws\ error\ B5\ P1\ V6\ \[data\/IdnaTest\.txt\:1163\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--187g.xn--ukjy205b8rscdeb", %p)},	undef,	"to_ascii\(\'xn\-\-187g\.xn\-\-ukjy205b8rscdeb\'\)\ throws\ error\ B5\ V6\ \[data\/IdnaTest\.txt\:1164\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--187g.xn--bnd4785f8r8bdeb", %p)},	undef,	"to_ascii\(\'xn\-\-187g\.xn\-\-bnd4785f8r8bdeb\'\)\ throws\ error\ B5\ V6\ \[data\/IdnaTest\.txt\:1165\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐫀｡⳻󠙾󠄷\x{3164}", %p)},	undef,	"to_ascii\(\'𐫀｡⳻\?\󠄷\\u3164\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:1166\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐫀。⳻󠙾󠄷\x{1160}", %p)},	undef,	"to_ascii\(\'𐫀\。⳻\?\󠄷\\u1160\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:1167\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--pw9c.xn--psd742lxt32w", %p)},	undef,	"to_ascii\(\'xn\-\-pw9c\.xn\-\-psd742lxt32w\'\)\ throws\ error\ B1\ V6\ \[data\/IdnaTest\.txt\:1168\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--pw9c.xn--mkj83l4v899a", %p)},	undef,	"to_ascii\(\'xn\-\-pw9c\.xn\-\-mkj83l4v899a\'\)\ throws\ error\ B1\ V6\ \[data\/IdnaTest\.txt\:1169\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("\x{079A}⾇．\x{071E}-𐋰", %p)},	undef,	"to_ascii\(\'\\u079A⾇．\\u071E\-𐋰\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:1170\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("\x{079A}舛.\x{071E}-𐋰", %p)},	undef,	"to_ascii\(\'\\u079A舛\.\\u071E\-𐋰\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:1171\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--7qb6383d.xn----20c3154q", %p)},	undef,	"to_ascii\(\'xn\-\-7qb6383d\.xn\-\-\-\-20c3154q\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:1172\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴉ猕󹛫≮．︒", %p)},	undef,	"to_ascii\(\'Ⴉ猕\?\≮．︒\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1173\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴉ猕󹛫<\x{0338}．︒", %p)},	undef,	"to_ascii\(\'Ⴉ猕\?\<\\u0338．︒\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1174\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴉ猕󹛫≮.。", %p)},	undef,	"to_ascii\(\'Ⴉ猕\?\≮\.\。\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:1175\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴉ猕󹛫<\x{0338}.。", %p)},	undef,	"to_ascii\(\'Ⴉ猕\?\<\\u0338\.\。\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:1176\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⴉ猕󹛫<\x{0338}.。", %p)},	undef,	"to_ascii\(\'ⴉ猕\?\<\\u0338\.\。\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:1177\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⴉ猕󹛫≮.。", %p)},	undef,	"to_ascii\(\'ⴉ猕\?\≮\.\。\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:1178\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--gdh892bbz0d5438s..", %p)},	undef,	"to_ascii\(\'xn\-\-gdh892bbz0d5438s\.\.\'\)\ throws\ error\ V6\ A4_2\ \[data\/IdnaTest\.txt\:1179\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--hnd212gz32d54x5r..", %p)},	undef,	"to_ascii\(\'xn\-\-hnd212gz32d54x5r\.\.\'\)\ throws\ error\ V6\ A4_2\ \[data\/IdnaTest\.txt\:1180\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⴉ猕󹛫<\x{0338}．︒", %p)},	undef,	"to_ascii\(\'ⴉ猕\?\<\\u0338．︒\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1181\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⴉ猕󹛫≮．︒", %p)},	undef,	"to_ascii\(\'ⴉ猕\?\≮．︒\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1182\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--gdh892bbz0d5438s.xn--y86c", %p)},	undef,	"to_ascii\(\'xn\-\-gdh892bbz0d5438s\.xn\-\-y86c\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:1183\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--hnd212gz32d54x5r.xn--y86c", %p)},	undef,	"to_ascii\(\'xn\-\-hnd212gz32d54x5r\.xn\-\-y86c\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:1184\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_ascii("🏮｡\x{062B}鳳\x{07E2}󠅉", %p)},	undef,	"to_ascii\(\'🏮｡\\u062B鳳\\u07E2\󠅉\'\)\ throws\ error\ B1\ B2\ \[data\/IdnaTest\.txt\:1185\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_ascii("🏮。\x{062B}鳳\x{07E2}󠅉", %p)},	undef,	"to_ascii\(\'🏮\。\\u062B鳳\\u07E2\󠅉\'\)\ throws\ error\ B1\ B2\ \[data\/IdnaTest\.txt\:1186\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--8m8h.xn--qgb29f6z90a", %p)},	undef,	"to_ascii\(\'xn\-\-8m8h\.xn\-\-qgb29f6z90a\'\)\ throws\ error\ B1\ B2\ \[data\/IdnaTest\.txt\:1187\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("\x{200D}𐹶。ß", %p)},	undef,	"to_ascii\(\'\\u200D𐹶\。ß\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:1188\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("\x{200D}𐹶。SS", %p)},	undef,	"to_ascii\(\'\\u200D𐹶\。SS\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:1190\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("\x{200D}𐹶。ss", %p)},	undef,	"to_ascii\(\'\\u200D𐹶\。ss\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:1192\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("\x{200D}𐹶。Ss", %p)},	undef,	"to_ascii\(\'\\u200D𐹶\。Ss\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:1194\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--uo0d.ss", %p)},	undef,	"to_ascii\(\'xn\-\-uo0d\.ss\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:1196\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--1ug9105g.ss", %p)},	undef,	"to_ascii\(\'xn\-\-1ug9105g\.ss\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:1197\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--1ug9105g.xn--zca", %p)},	undef,	"to_ascii\(\'xn\-\-1ug9105g\.xn\-\-zca\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:1198\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Å둄-．\x{200C}", %p)},	undef,	"to_ascii\(\'Å둄\-．\\u200C\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:1199\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A\x{030A}둄-．\x{200C}", %p)},	undef,	"to_ascii\(\'A\\u030A둄\-．\\u200C\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:1201\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Å둄-.\x{200C}", %p)},	undef,	"to_ascii\(\'Å둄\-\.\\u200C\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:1203\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A\x{030A}둄-.\x{200C}", %p)},	undef,	"to_ascii\(\'A\\u030A둄\-\.\\u200C\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:1205\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("a\x{030A}둄-.\x{200C}", %p)},	undef,	"to_ascii\(\'a\\u030A둄\-\.\\u200C\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:1207\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("å둄-.\x{200C}", %p)},	undef,	"to_ascii\(\'å둄\-\.\\u200C\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:1209\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----1fa1788k.", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-1fa1788k\.\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:1211\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----1fa1788k.xn--0ug", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-1fa1788k\.xn\-\-0ug\'\)\ throws\ error\ C1\ V3\ \[data\/IdnaTest\.txt\:1212\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("a\x{030A}둄-．\x{200C}", %p)},	undef,	"to_ascii\(\'a\\u030A둄\-．\\u200C\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:1213\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("å둄-．\x{200C}", %p)},	undef,	"to_ascii\(\'å둄\-．\\u200C\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:1215\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{3099}򬎑\x{1DD7}𞤀.򱲢-\x{0953}", %p)},	undef,	"to_ascii\(\'\\u3099\?\\u1DD7𞤀\.\?\-\\u0953\'\)\ throws\ error\ B1\ B6\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1217\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{3099}򬎑\x{1DD7}𞤢.򱲢-\x{0953}", %p)},	undef,	"to_ascii\(\'\\u3099\?\\u1DD7𞤢\.\?\-\\u0953\'\)\ throws\ error\ B1\ B6\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1218\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--veg121fwg63altj9d.xn----eyd92688s", %p)},	undef,	"to_ascii\(\'xn\-\-veg121fwg63altj9d\.xn\-\-\-\-eyd92688s\'\)\ throws\ error\ B1\ B6\ V5\ V6\ \[data\/IdnaTest\.txt\:1219\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ς.ß񴱄\x{06DD}\x{2D7F}", %p)},	undef,	"to_ascii\(\'ς\.ß\?\\u06DD\\u2D7F\'\)\ throws\ error\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:1220\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Σ.SS񴱄\x{06DD}\x{2D7F}", %p)},	undef,	"to_ascii\(\'Σ\.SS\?\\u06DD\\u2D7F\'\)\ throws\ error\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:1222\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("σ.ss񴱄\x{06DD}\x{2D7F}", %p)},	undef,	"to_ascii\(\'σ\.ss\?\\u06DD\\u2D7F\'\)\ throws\ error\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:1223\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Σ.ss񴱄\x{06DD}\x{2D7F}", %p)},	undef,	"to_ascii\(\'Σ\.ss\?\\u06DD\\u2D7F\'\)\ throws\ error\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:1224\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--4xa.xn--ss-y8d4760biv60n", %p)},	undef,	"to_ascii\(\'xn\-\-4xa\.xn\-\-ss\-y8d4760biv60n\'\)\ throws\ error\ B5\ B6\ V6\ \[data\/IdnaTest\.txt\:1225\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Σ.ß񴱄\x{06DD}\x{2D7F}", %p)},	undef,	"to_ascii\(\'Σ\.ß\?\\u06DD\\u2D7F\'\)\ throws\ error\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:1226\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("σ.ß񴱄\x{06DD}\x{2D7F}", %p)},	undef,	"to_ascii\(\'σ\.ß\?\\u06DD\\u2D7F\'\)\ throws\ error\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:1228\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--4xa.xn--zca281az71b8x73m", %p)},	undef,	"to_ascii\(\'xn\-\-4xa\.xn\-\-zca281az71b8x73m\'\)\ throws\ error\ B5\ B6\ V6\ \[data\/IdnaTest\.txt\:1230\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--3xa.xn--zca281az71b8x73m", %p)},	undef,	"to_ascii\(\'xn\-\-3xa\.xn\-\-zca281az71b8x73m\'\)\ throws\ error\ B5\ B6\ V6\ \[data\/IdnaTest\.txt\:1231\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("ꡀ𞀟｡\x{066B}\x{0599}", %p)},	undef,	"to_ascii\(\'ꡀ𞀟｡\\u066B\\u0599\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:1232\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("ꡀ𞀟。\x{066B}\x{0599}", %p)},	undef,	"to_ascii\(\'ꡀ𞀟\。\\u066B\\u0599\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:1233\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--8b9a1720d.xn--kcb33b", %p)},	undef,	"to_ascii\(\'xn\-\-8b9a1720d\.xn\-\-kcb33b\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:1234\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򈛉\x{200C}\x{08A9}｡⧅񘘡-𐭡", %p)},	undef,	"to_ascii\(\'\?\\u200C\\u08A9｡\⧅\?\-𐭡\'\)\ throws\ error\ B1\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:1235\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򈛉\x{200C}\x{08A9}。⧅񘘡-𐭡", %p)},	undef,	"to_ascii\(\'\?\\u200C\\u08A9\。\⧅\?\-𐭡\'\)\ throws\ error\ B1\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:1237\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--yyb56242i.xn----zir1232guu71b", %p)},	undef,	"to_ascii\(\'xn\-\-yyb56242i\.xn\-\-\-\-zir1232guu71b\'\)\ throws\ error\ B1\ B5\ B6\ V6\ \[data\/IdnaTest\.txt\:1239\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--yyb780jll63m.xn----zir1232guu71b", %p)},	undef,	"to_ascii\(\'xn\-\-yyb780jll63m\.xn\-\-\-\-zir1232guu71b\'\)\ throws\ error\ B1\ B5\ B6\ C1\ V6\ \[data\/IdnaTest\.txt\:1240\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("룱\x{200D}𰍨\x{200C}。𝨖︒", %p)},	undef,	"to_ascii\(\'룱\\u200D𰍨\\u200C\。𝨖︒\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1241\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("룱\x{200D}𰍨\x{200C}。𝨖︒", %p)},	undef,	"to_ascii\(\'룱\\u200D𰍨\\u200C\。𝨖︒\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1243\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("룱\x{200D}𰍨\x{200C}。𝨖。", %p)},	undef,	"to_ascii\(\'룱\\u200D𰍨\\u200C\。𝨖\。\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1245\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("룱\x{200D}𰍨\x{200C}。𝨖。", %p)},	undef,	"to_ascii\(\'룱\\u200D𰍨\\u200C\。𝨖\。\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1247\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--ct2b0738h.xn--772h.", %p)},	undef,	"to_ascii\(\'xn\-\-ct2b0738h\.xn\-\-772h\.\'\)\ throws\ error\ V5\ V6\ \[data\/IdnaTest\.txt\:1249\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--0ugb3358ili2v.xn--772h.", %p)},	undef,	"to_ascii\(\'xn\-\-0ugb3358ili2v\.xn\-\-772h\.\'\)\ throws\ error\ C1\ C2\ V5\ V6\ \[data\/IdnaTest\.txt\:1250\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--ct2b0738h.xn--y86cl899a", %p)},	undef,	"to_ascii\(\'xn\-\-ct2b0738h\.xn\-\-y86cl899a\'\)\ throws\ error\ V5\ V6\ \[data\/IdnaTest\.txt\:1251\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--0ugb3358ili2v.xn--y86cl899a", %p)},	undef,	"to_ascii\(\'xn\-\-0ugb3358ili2v\.xn\-\-y86cl899a\'\)\ throws\ error\ C1\ C2\ V5\ V6\ \[data\/IdnaTest\.txt\:1252\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("🄄．\x{1CDC}⒈ß", %p)},	undef,	"to_ascii\(\'🄄．\\u1CDC⒈ß\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1253\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("3,.\x{1CDC}1.ß", %p)},	undef,	"to_ascii\(\'3\,\.\\u1CDC1\.ß\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1255\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("3,.\x{1CDC}1.SS", %p)},	undef,	"to_ascii\(\'3\,\.\\u1CDC1\.SS\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1257\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("3,.\x{1CDC}1.ss", %p)},	undef,	"to_ascii\(\'3\,\.\\u1CDC1\.ss\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1258\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("3,.\x{1CDC}1.Ss", %p)},	undef,	"to_ascii\(\'3\,\.\\u1CDC1\.Ss\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1259\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("3,.xn--1-43l.ss", %p)},	undef,	"to_ascii\(\'3\,\.xn\-\-1\-43l\.ss\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1260\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("3,.xn--1-43l.xn--zca", %p)},	undef,	"to_ascii\(\'3\,\.xn\-\-1\-43l\.xn\-\-zca\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1261\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("🄄．\x{1CDC}⒈SS", %p)},	undef,	"to_ascii\(\'🄄．\\u1CDC⒈SS\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1262\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("🄄．\x{1CDC}⒈ss", %p)},	undef,	"to_ascii\(\'🄄．\\u1CDC⒈ss\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1263\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("🄄．\x{1CDC}⒈Ss", %p)},	undef,	"to_ascii\(\'🄄．\\u1CDC⒈Ss\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1264\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--x07h.xn--ss-k1r094b", %p)},	undef,	"to_ascii\(\'xn\-\-x07h\.xn\-\-ss\-k1r094b\'\)\ throws\ error\ V5\ V6\ \[data\/IdnaTest\.txt\:1265\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--x07h.xn--zca344lmif", %p)},	undef,	"to_ascii\(\'xn\-\-x07h\.xn\-\-zca344lmif\'\)\ throws\ error\ V5\ V6\ \[data\/IdnaTest\.txt\:1266\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񇌍\x{2D7F}｡𞼓򡄨𑐺", %p)},	undef,	"to_ascii\(\'\?\\u2D7F｡\?\?𑐺\'\)\ throws\ error\ B2\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:1267\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񇌍\x{2D7F}。𞼓򡄨𑐺", %p)},	undef,	"to_ascii\(\'\?\\u2D7F\。\?\?𑐺\'\)\ throws\ error\ B2\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:1268\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--eoj16016a.xn--0v1d3848a3lr0d", %p)},	undef,	"to_ascii\(\'xn\-\-eoj16016a\.xn\-\-0v1d3848a3lr0d\'\)\ throws\ error\ B2\ B3\ V6\ \[data\/IdnaTest\.txt\:1269\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1DFD}\x{103A}\x{094D}．≠\x{200D}㇛", %p)},	undef,	"to_ascii\(\'\\u1DFD\\u103A\\u094D．\≠\\u200D㇛\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1270\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{103A}\x{094D}\x{1DFD}．≠\x{200D}㇛", %p)},	undef,	"to_ascii\(\'\\u103A\\u094D\\u1DFD．\≠\\u200D㇛\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1272\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{103A}\x{094D}\x{1DFD}．=\x{0338}\x{200D}㇛", %p)},	undef,	"to_ascii\(\'\\u103A\\u094D\\u1DFD．\=\\u0338\\u200D㇛\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1274\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{103A}\x{094D}\x{1DFD}.≠\x{200D}㇛", %p)},	undef,	"to_ascii\(\'\\u103A\\u094D\\u1DFD\.\≠\\u200D㇛\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1276\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{103A}\x{094D}\x{1DFD}.=\x{0338}\x{200D}㇛", %p)},	undef,	"to_ascii\(\'\\u103A\\u094D\\u1DFD\.\=\\u0338\\u200D㇛\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1278\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--n3b956a9zm.xn--1ch912d", %p)},	undef,	"to_ascii\(\'xn\-\-n3b956a9zm\.xn\-\-1ch912d\'\)\ throws\ error\ V5\ V6\ \[data\/IdnaTest\.txt\:1280\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--n3b956a9zm.xn--1ug63gz5w", %p)},	undef,	"to_ascii\(\'xn\-\-n3b956a9zm\.xn\-\-1ug63gz5w\'\)\ throws\ error\ C2\ V5\ V6\ \[data\/IdnaTest\.txt\:1281\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴁ𐋨娤.\x{200D}\x{033C}\x{0662}𑖿", %p)},	undef,	"to_ascii\(\'Ⴁ𐋨娤\.\\u200D\\u033C\\u0662𑖿\'\)\ throws\ error\ B1\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1282\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("ⴁ𐋨娤.\x{200D}\x{033C}\x{0662}𑖿", %p)},	undef,	"to_ascii\(\'ⴁ𐋨娤\.\\u200D\\u033C\\u0662𑖿\'\)\ throws\ error\ B1\ V5\ \[data\/IdnaTest\.txt\:1284\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--skjw75lg29h.xn--9ta62nrv36a", %p)},	undef,	"to_ascii\(\'xn\-\-skjw75lg29h\.xn\-\-9ta62nrv36a\'\)\ throws\ error\ B1\ V5\ \[data\/IdnaTest\.txt\:1286\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--skjw75lg29h.xn--9ta62ngt6aou8t", %p)},	undef,	"to_ascii\(\'xn\-\-skjw75lg29h\.xn\-\-9ta62ngt6aou8t\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:1287\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--8md2578ag21g.xn--9ta62nrv36a", %p)},	undef,	"to_ascii\(\'xn\-\-8md2578ag21g\.xn\-\-9ta62nrv36a\'\)\ throws\ error\ B1\ V5\ V6\ \[data\/IdnaTest\.txt\:1288\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--8md2578ag21g.xn--9ta62ngt6aou8t", %p)},	undef,	"to_ascii\(\'xn\-\-8md2578ag21g\.xn\-\-9ta62ngt6aou8t\'\)\ throws\ error\ B1\ C2\ V6\ \[data\/IdnaTest\.txt\:1289\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("🄀Ⴄ\x{0669}\x{0820}。⒈\x{0FB6}ß", %p)},	undef,	"to_ascii\(\'🄀Ⴄ\\u0669\\u0820\。⒈\\u0FB6ß\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:1290\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("0.Ⴄ\x{0669}\x{0820}。1.\x{0FB6}ß", %p)},	undef,	"to_ascii\(\'0\.Ⴄ\\u0669\\u0820\。1\.\\u0FB6ß\'\)\ throws\ error\ B1\ B5\ B6\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1292\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("0.ⴄ\x{0669}\x{0820}。1.\x{0FB6}ß", %p)},	undef,	"to_ascii\(\'0\.ⴄ\\u0669\\u0820\。1\.\\u0FB6ß\'\)\ throws\ error\ B1\ B5\ B6\ V5\ \[data\/IdnaTest\.txt\:1294\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("0.Ⴄ\x{0669}\x{0820}。1.\x{0FB6}SS", %p)},	undef,	"to_ascii\(\'0\.Ⴄ\\u0669\\u0820\。1\.\\u0FB6SS\'\)\ throws\ error\ B1\ B5\ B6\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1296\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("0.ⴄ\x{0669}\x{0820}。1.\x{0FB6}ss", %p)},	undef,	"to_ascii\(\'0\.ⴄ\\u0669\\u0820\。1\.\\u0FB6ss\'\)\ throws\ error\ B1\ B5\ B6\ V5\ \[data\/IdnaTest\.txt\:1297\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("0.Ⴄ\x{0669}\x{0820}。1.\x{0FB6}Ss", %p)},	undef,	"to_ascii\(\'0\.Ⴄ\\u0669\\u0820\。1\.\\u0FB6Ss\'\)\ throws\ error\ B1\ B5\ B6\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1298\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("0.xn--iib29f26o.1.xn--ss-1sj", %p)},	undef,	"to_ascii\(\'0\.xn\-\-iib29f26o\.1\.xn\-\-ss\-1sj\'\)\ throws\ error\ B1\ B5\ B6\ V5\ V6\ \[data\/IdnaTest\.txt\:1299\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("0.xn--iib29fp25e.1.xn--ss-1sj", %p)},	undef,	"to_ascii\(\'0\.xn\-\-iib29fp25e\.1\.xn\-\-ss\-1sj\'\)\ throws\ error\ B1\ B5\ B6\ V5\ \[data\/IdnaTest\.txt\:1300\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("0.xn--iib29fp25e.1.xn--zca117e", %p)},	undef,	"to_ascii\(\'0\.xn\-\-iib29fp25e\.1\.xn\-\-zca117e\'\)\ throws\ error\ B1\ B5\ B6\ V5\ \[data\/IdnaTest\.txt\:1301\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("0.xn--iib29f26o.1.xn--zca117e", %p)},	undef,	"to_ascii\(\'0\.xn\-\-iib29f26o\.1\.xn\-\-zca117e\'\)\ throws\ error\ B1\ B5\ B6\ V5\ V6\ \[data\/IdnaTest\.txt\:1302\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("🄀ⴄ\x{0669}\x{0820}。⒈\x{0FB6}ß", %p)},	undef,	"to_ascii\(\'🄀ⴄ\\u0669\\u0820\。⒈\\u0FB6ß\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:1303\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("🄀Ⴄ\x{0669}\x{0820}。⒈\x{0FB6}SS", %p)},	undef,	"to_ascii\(\'🄀Ⴄ\\u0669\\u0820\。⒈\\u0FB6SS\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:1305\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("🄀ⴄ\x{0669}\x{0820}。⒈\x{0FB6}ss", %p)},	undef,	"to_ascii\(\'🄀ⴄ\\u0669\\u0820\。⒈\\u0FB6ss\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:1306\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("🄀Ⴄ\x{0669}\x{0820}。⒈\x{0FB6}Ss", %p)},	undef,	"to_ascii\(\'🄀Ⴄ\\u0669\\u0820\。⒈\\u0FB6Ss\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:1307\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--iib29f26o6n43c.xn--ss-1sj588o", %p)},	undef,	"to_ascii\(\'xn\-\-iib29f26o6n43c\.xn\-\-ss\-1sj588o\'\)\ throws\ error\ B1\ V6\ \[data\/IdnaTest\.txt\:1308\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--iib29fp25e0219a.xn--ss-1sj588o", %p)},	undef,	"to_ascii\(\'xn\-\-iib29fp25e0219a\.xn\-\-ss\-1sj588o\'\)\ throws\ error\ B1\ V6\ \[data\/IdnaTest\.txt\:1309\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--iib29fp25e0219a.xn--zca117e3vp", %p)},	undef,	"to_ascii\(\'xn\-\-iib29fp25e0219a\.xn\-\-zca117e3vp\'\)\ throws\ error\ B1\ V6\ \[data\/IdnaTest\.txt\:1310\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--iib29f26o6n43c.xn--zca117e3vp", %p)},	undef,	"to_ascii\(\'xn\-\-iib29f26o6n43c\.xn\-\-zca117e3vp\'\)\ throws\ error\ B1\ V6\ \[data\/IdnaTest\.txt\:1311\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≠.\x{200C}-\x{066B}", %p)},	undef,	"to_ascii\(\'\≠\.\\u200C\-\\u066B\'\)\ throws\ error\ B1\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:1312\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("=\x{0338}.\x{200C}-\x{066B}", %p)},	undef,	"to_ascii\(\'\=\\u0338\.\\u200C\-\\u066B\'\)\ throws\ error\ B1\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:1314\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--1ch.xn----vqc", %p)},	undef,	"to_ascii\(\'xn\-\-1ch\.xn\-\-\-\-vqc\'\)\ throws\ error\ B1\ V3\ V6\ \[data\/IdnaTest\.txt\:1316\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--1ch.xn----vqc597q", %p)},	undef,	"to_ascii\(\'xn\-\-1ch\.xn\-\-\-\-vqc597q\'\)\ throws\ error\ B1\ C1\ V6\ \[data\/IdnaTest\.txt\:1317\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0660}۱｡󠳶𞠁\x{0665}", %p)},	undef,	"to_ascii\(\'\\u0660۱｡\?𞠁\\u0665\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:1318\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0660}۱。󠳶𞠁\x{0665}", %p)},	undef,	"to_ascii\(\'\\u0660۱\。\?𞠁\\u0665\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:1319\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--8hb40a.xn--eib7967vner3e", %p)},	undef,	"to_ascii\(\'xn\-\-8hb40a\.xn\-\-eib7967vner3e\'\)\ throws\ error\ B1\ V6\ \[data\/IdnaTest\.txt\:1320\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}\x{0663}⒖。󱅉𽷛\x{1BF3}", %p)},	undef,	"to_ascii\(\'\\u200C\\u0663⒖\。\?\?\\u1BF3\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:1321\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}\x{0663}15.。󱅉𽷛\x{1BF3}", %p)},	undef,	"to_ascii\(\'\\u200C\\u066315\.\。\?\?\\u1BF3\'\)\ throws\ error\ B1\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:1323\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--15-gyd..xn--1zf13512buy41d", %p)},	undef,	"to_ascii\(\'xn\-\-15\-gyd\.\.xn\-\-1zf13512buy41d\'\)\ throws\ error\ B1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:1325\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--15-gyd983x..xn--1zf13512buy41d", %p)},	undef,	"to_ascii\(\'xn\-\-15\-gyd983x\.\.xn\-\-1zf13512buy41d\'\)\ throws\ error\ B1\ C1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:1326\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--cib675m.xn--1zf13512buy41d", %p)},	undef,	"to_ascii\(\'xn\-\-cib675m\.xn\-\-1zf13512buy41d\'\)\ throws\ error\ B1\ V6\ \[data\/IdnaTest\.txt\:1327\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--cib152kwgd.xn--1zf13512buy41d", %p)},	undef,	"to_ascii\(\'xn\-\-cib152kwgd\.xn\-\-1zf13512buy41d\'\)\ throws\ error\ B1\ C1\ V6\ \[data\/IdnaTest\.txt\:1328\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1BF3}.-逋񳦭󙙮", %p)},	undef,	"to_ascii\(\'\\u1BF3\.\-逋\?\?\'\)\ throws\ error\ P1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:1329\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--1zf.xn----483d46987byr50b", %p)},	undef,	"to_ascii\(\'xn\-\-1zf\.xn\-\-\-\-483d46987byr50b\'\)\ throws\ error\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:1330\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0756}。\x{3164}\x{200D}ς", %p)},	undef,	"to_ascii\(\'\\u0756\。\\u3164\\u200Dς\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1331\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0756}。\x{1160}\x{200D}ς", %p)},	undef,	"to_ascii\(\'\\u0756\。\\u1160\\u200Dς\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1333\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0756}。\x{1160}\x{200D}Σ", %p)},	undef,	"to_ascii\(\'\\u0756\。\\u1160\\u200DΣ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1335\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0756}。\x{1160}\x{200D}σ", %p)},	undef,	"to_ascii\(\'\\u0756\。\\u1160\\u200Dσ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1337\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--9ob.xn--4xa380e", %p)},	undef,	"to_ascii\(\'xn\-\-9ob\.xn\-\-4xa380e\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:1339\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--9ob.xn--4xa380ebol", %p)},	undef,	"to_ascii\(\'xn\-\-9ob\.xn\-\-4xa380ebol\'\)\ throws\ error\ C2\ V6\ \[data\/IdnaTest\.txt\:1340\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--9ob.xn--3xa580ebol", %p)},	undef,	"to_ascii\(\'xn\-\-9ob\.xn\-\-3xa580ebol\'\)\ throws\ error\ C2\ V6\ \[data\/IdnaTest\.txt\:1341\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0756}。\x{3164}\x{200D}Σ", %p)},	undef,	"to_ascii\(\'\\u0756\。\\u3164\\u200DΣ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1342\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0756}。\x{3164}\x{200D}σ", %p)},	undef,	"to_ascii\(\'\\u0756\。\\u3164\\u200Dσ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1344\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--9ob.xn--4xa574u", %p)},	undef,	"to_ascii\(\'xn\-\-9ob\.xn\-\-4xa574u\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:1346\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--9ob.xn--4xa795lq2l", %p)},	undef,	"to_ascii\(\'xn\-\-9ob\.xn\-\-4xa795lq2l\'\)\ throws\ error\ C2\ V6\ \[data\/IdnaTest\.txt\:1347\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--9ob.xn--3xa995lq2l", %p)},	undef,	"to_ascii\(\'xn\-\-9ob\.xn\-\-3xa995lq2l\'\)\ throws\ error\ C2\ V6\ \[data\/IdnaTest\.txt\:1348\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᡆႣ｡󞢧\x{0315}\x{200D}\x{200D}", %p)},	undef,	"to_ascii\(\'ᡆႣ｡\?\\u0315\\u200D\\u200D\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1349\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᡆႣ。󞢧\x{0315}\x{200D}\x{200D}", %p)},	undef,	"to_ascii\(\'ᡆႣ\。\?\\u0315\\u200D\\u200D\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1351\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᡆⴃ。󞢧\x{0315}\x{200D}\x{200D}", %p)},	undef,	"to_ascii\(\'ᡆⴃ\。\?\\u0315\\u200D\\u200D\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1353\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--57e237h.xn--5sa98523p", %p)},	undef,	"to_ascii\(\'xn\-\-57e237h\.xn\-\-5sa98523p\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:1355\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--57e237h.xn--5sa649la993427a", %p)},	undef,	"to_ascii\(\'xn\-\-57e237h\.xn\-\-5sa649la993427a\'\)\ throws\ error\ C2\ V6\ \[data\/IdnaTest\.txt\:1356\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--bnd320b.xn--5sa98523p", %p)},	undef,	"to_ascii\(\'xn\-\-bnd320b\.xn\-\-5sa98523p\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:1357\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--bnd320b.xn--5sa649la993427a", %p)},	undef,	"to_ascii\(\'xn\-\-bnd320b\.xn\-\-5sa649la993427a\'\)\ throws\ error\ C2\ V6\ \[data\/IdnaTest\.txt\:1358\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᡆⴃ｡󞢧\x{0315}\x{200D}\x{200D}", %p)},	undef,	"to_ascii\(\'ᡆⴃ｡\?\\u0315\\u200D\\u200D\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1359\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("㭄\x{200D}\x{084F}𑚵．ς𐮮\x{200C}\x{200D}", %p)},	undef,	"to_ascii\(\'㭄\\u200D\\u084F𑚵．ς𐮮\\u200C\\u200D\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:1361\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("㭄\x{200D}\x{084F}𑚵.ς𐮮\x{200C}\x{200D}", %p)},	undef,	"to_ascii\(\'㭄\\u200D\\u084F𑚵\.ς𐮮\\u200C\\u200D\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:1363\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("㭄\x{200D}\x{084F}𑚵.Σ𐮮\x{200C}\x{200D}", %p)},	undef,	"to_ascii\(\'㭄\\u200D\\u084F𑚵\.Σ𐮮\\u200C\\u200D\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:1365\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("㭄\x{200D}\x{084F}𑚵.σ𐮮\x{200C}\x{200D}", %p)},	undef,	"to_ascii\(\'㭄\\u200D\\u084F𑚵\.σ𐮮\\u200C\\u200D\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:1367\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--ewb302xhu1l.xn--4xa0426k", %p)},	undef,	"to_ascii\(\'xn\-\-ewb302xhu1l\.xn\-\-4xa0426k\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:1369\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--ewb962jfitku4r.xn--4xa695lda6932v", %p)},	undef,	"to_ascii\(\'xn\-\-ewb962jfitku4r\.xn\-\-4xa695lda6932v\'\)\ throws\ error\ B5\ B6\ C1\ C2\ \[data\/IdnaTest\.txt\:1370\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--ewb962jfitku4r.xn--3xa895lda6932v", %p)},	undef,	"to_ascii\(\'xn\-\-ewb962jfitku4r\.xn\-\-3xa895lda6932v\'\)\ throws\ error\ B5\ B6\ C1\ C2\ \[data\/IdnaTest\.txt\:1371\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("㭄\x{200D}\x{084F}𑚵．Σ𐮮\x{200C}\x{200D}", %p)},	undef,	"to_ascii\(\'㭄\\u200D\\u084F𑚵．Σ𐮮\\u200C\\u200D\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:1372\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("㭄\x{200D}\x{084F}𑚵．σ𐮮\x{200C}\x{200D}", %p)},	undef,	"to_ascii\(\'㭄\\u200D\\u084F𑚵．σ𐮮\\u200C\\u200D\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:1374\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("\x{17B5}。𞯸ꡀ🄋", %p)},	undef,	"to_ascii\(\'\\u17B5\。\?ꡀ🄋\'\)\ throws\ error\ B1\ B2\ B3\ B6\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1376\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--03e.xn--8b9ar252dngd", %p)},	undef,	"to_ascii\(\'xn\-\-03e\.xn\-\-8b9ar252dngd\'\)\ throws\ error\ B1\ B2\ B3\ B6\ V5\ V6\ \[data\/IdnaTest\.txt\:1377\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󐪺暑．⾑\x{0668}", %p)},	undef,	"to_ascii\(\'\?暑．⾑\\u0668\'\)\ throws\ error\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:1378\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󐪺暑.襾\x{0668}", %p)},	undef,	"to_ascii\(\'\?暑\.襾\\u0668\'\)\ throws\ error\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:1379\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--tlvq3513e.xn--hib9228d", %p)},	undef,	"to_ascii\(\'xn\-\-tlvq3513e\.xn\-\-hib9228d\'\)\ throws\ error\ B5\ B6\ V6\ \[data\/IdnaTest\.txt\:1380\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠄚≯ꡢ。\x{0891}\x{1DFF}", %p)},	undef,	"to_ascii\(\'\󠄚\≯ꡢ\。\\u0891\\u1DFF\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:1381\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠄚>\x{0338}ꡢ。\x{0891}\x{1DFF}", %p)},	undef,	"to_ascii\(\'\󠄚\>\\u0338ꡢ\。\\u0891\\u1DFF\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:1382\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--hdh7783c.xn--9xb680i", %p)},	undef,	"to_ascii\(\'xn\-\-hdh7783c\.xn\-\-9xb680i\'\)\ throws\ error\ B1\ V6\ \[data\/IdnaTest\.txt\:1383\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{FDC3}𮁱\x{0B4D}𐨿.󐧤Ⴗ", %p)},	undef,	"to_ascii\(\'\\uFDC3𮁱\\u0B4D𐨿\.\?Ⴗ\'\)\ throws\ error\ B2\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:1384\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0643}\x{0645}\x{0645}𮁱\x{0B4D}𐨿.󐧤Ⴗ", %p)},	undef,	"to_ascii\(\'\\u0643\\u0645\\u0645𮁱\\u0B4D𐨿\.\?Ⴗ\'\)\ throws\ error\ B2\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:1385\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0643}\x{0645}\x{0645}𮁱\x{0B4D}𐨿.󐧤ⴗ", %p)},	undef,	"to_ascii\(\'\\u0643\\u0645\\u0645𮁱\\u0B4D𐨿\.\?ⴗ\'\)\ throws\ error\ B2\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:1386\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--fhbea662czx68a2tju.xn--fljz2846h", %p)},	undef,	"to_ascii\(\'xn\-\-fhbea662czx68a2tju\.xn\-\-fljz2846h\'\)\ throws\ error\ B2\ B3\ V6\ \[data\/IdnaTest\.txt\:1387\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--fhbea662czx68a2tju.xn--vnd55511o", %p)},	undef,	"to_ascii\(\'xn\-\-fhbea662czx68a2tju\.xn\-\-vnd55511o\'\)\ throws\ error\ B2\ B3\ V6\ \[data\/IdnaTest\.txt\:1388\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{FDC3}𮁱\x{0B4D}𐨿.󐧤ⴗ", %p)},	undef,	"to_ascii\(\'\\uFDC3𮁱\\u0B4D𐨿\.\?ⴗ\'\)\ throws\ error\ B2\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:1389\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𞀨｡\x{1B44}򡛨𞎇", %p)},	undef,	"to_ascii\(\'𞀨｡\\u1B44\?\?\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1390\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𞀨。\x{1B44}򡛨𞎇", %p)},	undef,	"to_ascii\(\'𞀨\。\\u1B44\?\?\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1391\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--mi4h.xn--1uf6843smg20c", %p)},	undef,	"to_ascii\(\'xn\-\-mi4h\.xn\-\-1uf6843smg20c\'\)\ throws\ error\ V5\ V6\ \[data\/IdnaTest\.txt\:1392\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠣼\x{200C}．𐺰\x{200C}ᡟ", %p)},	undef,	"to_ascii\(\'\?\\u200C．𐺰\\u200Cᡟ\'\)\ throws\ error\ B1\ B2\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:1393\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠣼\x{200C}.𐺰\x{200C}ᡟ", %p)},	undef,	"to_ascii\(\'\?\\u200C\.𐺰\\u200Cᡟ\'\)\ throws\ error\ B1\ B2\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:1395\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--q046e.xn--v8e7227j", %p)},	undef,	"to_ascii\(\'xn\-\-q046e\.xn\-\-v8e7227j\'\)\ throws\ error\ B1\ B2\ B3\ V6\ \[data\/IdnaTest\.txt\:1397\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--0ug18531l.xn--v8e340bp21t", %p)},	undef,	"to_ascii\(\'xn\-\-0ug18531l\.xn\-\-v8e340bp21t\'\)\ throws\ error\ B1\ B2\ B3\ C1\ V6\ \[data\/IdnaTest\.txt\:1398\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᢛ󨅟ß.ጧ", %p)},	undef,	"to_ascii\(\'ᢛ\?ß\.ጧ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1399\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᢛ󨅟SS.ጧ", %p)},	undef,	"to_ascii\(\'ᢛ\?SS\.ጧ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1401\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᢛ󨅟ss.ጧ", %p)},	undef,	"to_ascii\(\'ᢛ\?ss\.ጧ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1402\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᢛ󨅟Ss.ጧ", %p)},	undef,	"to_ascii\(\'ᢛ\?Ss\.ጧ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1403\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--ss-7dp66033t.xn--p5d", %p)},	undef,	"to_ascii\(\'xn\-\-ss\-7dp66033t\.xn\-\-p5d\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:1404\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--zca562jc642x.xn--p5d", %p)},	undef,	"to_ascii\(\'xn\-\-zca562jc642x\.xn\-\-p5d\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:1405\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⮒\x{200C}.񒚗\x{200C}", %p)},	undef,	"to_ascii\(\'\⮒\\u200C\.\?\\u200C\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1406\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--b9i.xn--5p9y", %p)},	undef,	"to_ascii\(\'xn\-\-b9i\.xn\-\-5p9y\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:1408\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--0ugx66b.xn--0ugz2871c", %p)},	undef,	"to_ascii\(\'xn\-\-0ugx66b\.xn\-\-0ugz2871c\'\)\ throws\ error\ C1\ V6\ \[data\/IdnaTest\.txt\:1409\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𞤂񹞁𐹯。Ⴜ", %p)},	undef,	"to_ascii\(\'𞤂\?𐹯\。Ⴜ\'\)\ throws\ error\ B2\ P1\ V6\ \[data\/IdnaTest\.txt\:1410\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𞤤񹞁𐹯。ⴜ", %p)},	undef,	"to_ascii\(\'𞤤\?𐹯\。ⴜ\'\)\ throws\ error\ B2\ P1\ V6\ \[data\/IdnaTest\.txt\:1411\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--no0dr648a51o3b.xn--klj", %p)},	undef,	"to_ascii\(\'xn\-\-no0dr648a51o3b\.xn\-\-klj\'\)\ throws\ error\ B2\ V6\ \[data\/IdnaTest\.txt\:1412\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--no0dr648a51o3b.xn--0nd", %p)},	undef,	"to_ascii\(\'xn\-\-no0dr648a51o3b\.xn\-\-0nd\'\)\ throws\ error\ B2\ V6\ \[data\/IdnaTest\.txt\:1413\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𞤂񹞁𐹯。ⴜ", %p)},	undef,	"to_ascii\(\'𞤂\?𐹯\。ⴜ\'\)\ throws\ error\ B2\ P1\ V6\ \[data\/IdnaTest\.txt\:1414\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐹵⮣\x{200C}𑄰｡񷴿\x{FCB7}", %p)},	undef,	"to_ascii\(\'𐹵\⮣\\u200C𑄰｡\?\\uFCB7\'\)\ throws\ error\ B1\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:1415\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐹵⮣\x{200C}𑄰。񷴿\x{0636}\x{0645}", %p)},	undef,	"to_ascii\(\'𐹵\⮣\\u200C𑄰\。\?\\u0636\\u0645\'\)\ throws\ error\ B1\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:1417\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--s9i5458e7yb.xn--1gb4a66004i", %p)},	undef,	"to_ascii\(\'xn\-\-s9i5458e7yb\.xn\-\-1gb4a66004i\'\)\ throws\ error\ B1\ B5\ B6\ V6\ \[data\/IdnaTest\.txt\:1419\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--0ug586bcj8p7jc.xn--1gb4a66004i", %p)},	undef,	"to_ascii\(\'xn\-\-0ug586bcj8p7jc\.xn\-\-1gb4a66004i\'\)\ throws\ error\ B1\ B5\ B6\ C1\ V6\ \[data\/IdnaTest\.txt\:1420\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴒ。デß𞤵\x{0C4D}", %p)},	undef,	"to_ascii\(\'Ⴒ\。デß𞤵\\u0C4D\'\)\ throws\ error\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:1421\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴒ。テ\x{3099}ß𞤵\x{0C4D}", %p)},	undef,	"to_ascii\(\'Ⴒ\。テ\\u3099ß𞤵\\u0C4D\'\)\ throws\ error\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:1423\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("ⴒ。テ\x{3099}ß𞤵\x{0C4D}", %p)},	undef,	"to_ascii\(\'ⴒ\。テ\\u3099ß𞤵\\u0C4D\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:1425\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("ⴒ。デß𞤵\x{0C4D}", %p)},	undef,	"to_ascii\(\'ⴒ\。デß𞤵\\u0C4D\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:1427\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("Ⴒ。デSS𞤓\x{0C4D}", %p)},	undef,	"to_ascii\(\'Ⴒ\。デSS𞤓\\u0C4D\'\)\ throws\ error\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:1429\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴒ。テ\x{3099}SS𞤓\x{0C4D}", %p)},	undef,	"to_ascii\(\'Ⴒ\。テ\\u3099SS𞤓\\u0C4D\'\)\ throws\ error\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:1430\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("ⴒ。テ\x{3099}ss𞤵\x{0C4D}", %p)},	undef,	"to_ascii\(\'ⴒ\。テ\\u3099ss𞤵\\u0C4D\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:1431\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("ⴒ。デss𞤵\x{0C4D}", %p)},	undef,	"to_ascii\(\'ⴒ\。デss𞤵\\u0C4D\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:1432\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("Ⴒ。デSs𞤵\x{0C4D}", %p)},	undef,	"to_ascii\(\'Ⴒ\。デSs𞤵\\u0C4D\'\)\ throws\ error\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:1433\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴒ。テ\x{3099}Ss𞤵\x{0C4D}", %p)},	undef,	"to_ascii\(\'Ⴒ\。テ\\u3099Ss𞤵\\u0C4D\'\)\ throws\ error\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:1434\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--qnd.xn--ss-9nh3648ahh20b", %p)},	undef,	"to_ascii\(\'xn\-\-qnd\.xn\-\-ss\-9nh3648ahh20b\'\)\ throws\ error\ B5\ B6\ V6\ \[data\/IdnaTest\.txt\:1435\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--9kj.xn--ss-9nh3648ahh20b", %p)},	undef,	"to_ascii\(\'xn\-\-9kj\.xn\-\-ss\-9nh3648ahh20b\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:1436\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--9kj.xn--zca669cmr3a0f28a", %p)},	undef,	"to_ascii\(\'xn\-\-9kj\.xn\-\-zca669cmr3a0f28a\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:1437\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--qnd.xn--zca669cmr3a0f28a", %p)},	undef,	"to_ascii\(\'xn\-\-qnd\.xn\-\-zca669cmr3a0f28a\'\)\ throws\ error\ B5\ B6\ V6\ \[data\/IdnaTest\.txt\:1438\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴒ。デSS𞤵\x{0C4D}", %p)},	undef,	"to_ascii\(\'Ⴒ\。デSS𞤵\\u0C4D\'\)\ throws\ error\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:1439\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴒ。テ\x{3099}SS𞤵\x{0C4D}", %p)},	undef,	"to_ascii\(\'Ⴒ\。テ\\u3099SS𞤵\\u0C4D\'\)\ throws\ error\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:1440\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("𑁿\x{0D4D}．７-\x{07D2}", %p)},	undef,	"to_ascii\(\'𑁿\\u0D4D．７\-\\u07D2\'\)\ throws\ error\ B1\ B3\ B6\ V5\ \[data\/IdnaTest\.txt\:1441\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("𑁿\x{0D4D}.7-\x{07D2}", %p)},	undef,	"to_ascii\(\'𑁿\\u0D4D\.7\-\\u07D2\'\)\ throws\ error\ B1\ B3\ B6\ V5\ \[data\/IdnaTest\.txt\:1442\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--wxc1283k.xn--7--yue", %p)},	undef,	"to_ascii\(\'xn\-\-wxc1283k\.xn\-\-7\-\-yue\'\)\ throws\ error\ B1\ B3\ B6\ V5\ \[data\/IdnaTest\.txt\:1443\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≯𑜫󠭇.\x{1734}񒞤𑍬ᢧ", %p)},	undef,	"to_ascii\(\'\≯𑜫\?\.\\u1734\?𑍬ᢧ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1444\]") or ($@ and diag($@));
is(eval{uts46_to_ascii(">\x{0338}𑜫󠭇.\x{1734}񒞤𑍬ᢧ", %p)},	undef,	"to_ascii\(\'\>\\u0338𑜫\?\.\\u1734\?𑍬ᢧ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1445\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--hdhx157g68o0g.xn--c0e65eu616c34o7a", %p)},	undef,	"to_ascii\(\'xn\-\-hdhx157g68o0g\.xn\-\-c0e65eu616c34o7a\'\)\ throws\ error\ V5\ V6\ \[data\/IdnaTest\.txt\:1446\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1DDB}򎐙Ⴗ쏔。\x{0781}", %p)},	undef,	"to_ascii\(\'\\u1DDB\?Ⴗ쏔\。\\u0781\'\)\ throws\ error\ B1\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1447\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1DDB}򎐙Ⴗ쏔。\x{0781}", %p)},	undef,	"to_ascii\(\'\\u1DDB\?Ⴗ쏔\。\\u0781\'\)\ throws\ error\ B1\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1448\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1DDB}򎐙ⴗ쏔。\x{0781}", %p)},	undef,	"to_ascii\(\'\\u1DDB\?ⴗ쏔\。\\u0781\'\)\ throws\ error\ B1\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1449\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1DDB}򎐙ⴗ쏔。\x{0781}", %p)},	undef,	"to_ascii\(\'\\u1DDB\?ⴗ쏔\。\\u0781\'\)\ throws\ error\ B1\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1450\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--zegy26dw47iy6w2f.xn--iqb", %p)},	undef,	"to_ascii\(\'xn\-\-zegy26dw47iy6w2f\.xn\-\-iqb\'\)\ throws\ error\ B1\ V5\ V6\ \[data\/IdnaTest\.txt\:1451\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--vnd148d733ky6n9e.xn--iqb", %p)},	undef,	"to_ascii\(\'xn\-\-vnd148d733ky6n9e\.xn\-\-iqb\'\)\ throws\ error\ B1\ V5\ V6\ \[data\/IdnaTest\.txt\:1452\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ß｡𐋳Ⴌ\x{0FB8}", %p)},	undef,	"to_ascii\(\'ß｡𐋳Ⴌ\\u0FB8\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1453\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ß。𐋳Ⴌ\x{0FB8}", %p)},	undef,	"to_ascii\(\'ß\。𐋳Ⴌ\\u0FB8\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1455\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("ß。𐋳ⴌ\x{0FB8}", %p)},	"ss.xn--lgd921mvv0m",	"to_ascii\(\'ß\。𐋳ⴌ\\u0FB8\'\)\ \[data\/IdnaTest\.txt\:1457\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("SS。𐋳Ⴌ\x{0FB8}", %p)},	undef,	"to_ascii\(\'SS\。𐋳Ⴌ\\u0FB8\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1459\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("ss。𐋳ⴌ\x{0FB8}", %p)},	"ss.xn--lgd921mvv0m",	"to_ascii\(\'ss\。𐋳ⴌ\\u0FB8\'\)\ \[data\/IdnaTest\.txt\:1460\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("Ss。𐋳Ⴌ\x{0FB8}", %p)},	undef,	"to_ascii\(\'Ss\。𐋳Ⴌ\\u0FB8\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1461\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ss.xn--lgd10cu829c", %p)},	undef,	"to_ascii\(\'ss\.xn\-\-lgd10cu829c\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:1462\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("ss.xn--lgd921mvv0m", %p)},	"ss.xn--lgd921mvv0m",	"to_ascii\(\'ss\.xn\-\-lgd921mvv0m\'\)\ \[data\/IdnaTest\.txt\:1463\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("ss.𐋳ⴌ\x{0FB8}", %p)},	"ss.xn--lgd921mvv0m",	"to_ascii\(\'ss\.𐋳ⴌ\\u0FB8\'\)\ \[data\/IdnaTest\.txt\:1464\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("SS.𐋳Ⴌ\x{0FB8}", %p)},	undef,	"to_ascii\(\'SS\.𐋳Ⴌ\\u0FB8\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1465\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ss.𐋳Ⴌ\x{0FB8}", %p)},	undef,	"to_ascii\(\'Ss\.𐋳Ⴌ\\u0FB8\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1466\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("xn--zca.xn--lgd921mvv0m", %p)},	"xn--zca.xn--lgd921mvv0m",	"to_ascii\(\'xn\-\-zca\.xn\-\-lgd921mvv0m\'\)\ \[data\/IdnaTest\.txt\:1467\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("ß.𐋳ⴌ\x{0FB8}", %p)},	"ss.xn--lgd921mvv0m",	"to_ascii\(\'ß\.𐋳ⴌ\\u0FB8\'\)\ \[data\/IdnaTest\.txt\:1468\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--zca.xn--lgd10cu829c", %p)},	undef,	"to_ascii\(\'xn\-\-zca\.xn\-\-lgd10cu829c\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:1470\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("ß｡𐋳ⴌ\x{0FB8}", %p)},	"ss.xn--lgd921mvv0m",	"to_ascii\(\'ß｡𐋳ⴌ\\u0FB8\'\)\ \[data\/IdnaTest\.txt\:1471\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("SS｡𐋳Ⴌ\x{0FB8}", %p)},	undef,	"to_ascii\(\'SS｡𐋳Ⴌ\\u0FB8\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1473\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("ss｡𐋳ⴌ\x{0FB8}", %p)},	"ss.xn--lgd921mvv0m",	"to_ascii\(\'ss｡𐋳ⴌ\\u0FB8\'\)\ \[data\/IdnaTest\.txt\:1474\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("Ss｡𐋳Ⴌ\x{0FB8}", %p)},	undef,	"to_ascii\(\'Ss｡𐋳Ⴌ\\u0FB8\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1475\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-\x{069E}𐶡.\x{200C}⾝\x{09CD}", %p)},	undef,	"to_ascii\(\'\-\\u069E\?\.\\u200C⾝\\u09CD\'\)\ throws\ error\ B1\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:1476\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-\x{069E}𐶡.\x{200C}身\x{09CD}", %p)},	undef,	"to_ascii\(\'\-\\u069E\?\.\\u200C身\\u09CD\'\)\ throws\ error\ B1\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:1478\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----stc7013r.xn--b7b1419d", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-stc7013r\.xn\-\-b7b1419d\'\)\ throws\ error\ B1\ V3\ V6\ \[data\/IdnaTest\.txt\:1480\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----stc7013r.xn--b7b305imj2f", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-stc7013r\.xn\-\-b7b305imj2f\'\)\ throws\ error\ B1\ C1\ V3\ V6\ \[data\/IdnaTest\.txt\:1481\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("😮\x{0764}𑈵𞀖.💅\x{200D}", %p)},	undef,	"to_ascii\(\'😮\\u0764𑈵𞀖\.💅\\u200D\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:1482\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("😮\x{0764}𑈵𞀖.💅\x{200D}", %p)},	undef,	"to_ascii\(\'😮\\u0764𑈵𞀖\.💅\\u200D\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:1484\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--opb4277kuc7elqsa.xn--kr8h", %p)},	undef,	"to_ascii\(\'xn\-\-opb4277kuc7elqsa\.xn\-\-kr8h\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:1486\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--opb4277kuc7elqsa.xn--1ug5265p", %p)},	undef,	"to_ascii\(\'xn\-\-opb4277kuc7elqsa\.xn\-\-1ug5265p\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:1487\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{08F2}\x{200D}꙳\x{0712}.ᢏ\x{200C}󠍄", %p)},	undef,	"to_ascii\(\'\\u08F2\\u200D꙳\\u0712\.ᢏ\\u200C\?\'\)\ throws\ error\ B1\ B6\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1488\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--cnb37gdy00a.xn--89e02253p", %p)},	undef,	"to_ascii\(\'xn\-\-cnb37gdy00a\.xn\-\-89e02253p\'\)\ throws\ error\ B1\ B6\ V5\ V6\ \[data\/IdnaTest\.txt\:1490\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--cnb37g904be26j.xn--89e849ax9363a", %p)},	undef,	"to_ascii\(\'xn\-\-cnb37g904be26j\.xn\-\-89e849ax9363a\'\)\ throws\ error\ B1\ B6\ C1\ C2\ V5\ V6\ \[data\/IdnaTest\.txt\:1491\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴑ．\x{06BF}𞯓ᠲ", %p)},	undef,	"to_ascii\(\'Ⴑ．\\u06BF\?ᠲ\'\)\ throws\ error\ B2\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:1492\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴑ.\x{06BF}𞯓ᠲ", %p)},	undef,	"to_ascii\(\'Ⴑ\.\\u06BF\?ᠲ\'\)\ throws\ error\ B2\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:1493\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⴑ.\x{06BF}𞯓ᠲ", %p)},	undef,	"to_ascii\(\'ⴑ\.\\u06BF\?ᠲ\'\)\ throws\ error\ B2\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:1494\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--8kj.xn--ykb840gd555a", %p)},	undef,	"to_ascii\(\'xn\-\-8kj\.xn\-\-ykb840gd555a\'\)\ throws\ error\ B2\ B3\ V6\ \[data\/IdnaTest\.txt\:1495\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--pnd.xn--ykb840gd555a", %p)},	undef,	"to_ascii\(\'xn\-\-pnd\.xn\-\-ykb840gd555a\'\)\ throws\ error\ B2\ B3\ V6\ \[data\/IdnaTest\.txt\:1496\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⴑ．\x{06BF}𞯓ᠲ", %p)},	undef,	"to_ascii\(\'ⴑ．\\u06BF\?ᠲ\'\)\ throws\ error\ B2\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:1497\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1A5A}𛦝\x{0C4D}。𚝬𝟵", %p)},	undef,	"to_ascii\(\'\\u1A5A\?\\u0C4D\。\?𝟵\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1498\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1A5A}𛦝\x{0C4D}。𚝬9", %p)},	undef,	"to_ascii\(\'\\u1A5A\?\\u0C4D\。\?9\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1499\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--lqc703ebm93a.xn--9-000p", %p)},	undef,	"to_ascii\(\'xn\-\-lqc703ebm93a\.xn\-\-9\-000p\'\)\ throws\ error\ V5\ V6\ \[data\/IdnaTest\.txt\:1500\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}\x{06A0}𿺆𝟗｡Ⴣ꒘\x{FCD0}񐘖", %p)},	undef,	"to_ascii\(\'\\u200C\\u06A0\?𝟗｡Ⴣ꒘\\uFCD0\?\'\)\ throws\ error\ B2\ B5\ P1\ V6\ \[data\/IdnaTest\.txt\:1501\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}\x{06A0}𿺆9。Ⴣ꒘\x{0645}\x{062E}񐘖", %p)},	undef,	"to_ascii\(\'\\u200C\\u06A0\?9\。Ⴣ꒘\\u0645\\u062E\?\'\)\ throws\ error\ B2\ B5\ P1\ V6\ \[data\/IdnaTest\.txt\:1503\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}\x{06A0}𿺆9。ⴣ꒘\x{0645}\x{062E}񐘖", %p)},	undef,	"to_ascii\(\'\\u200C\\u06A0\?9\。ⴣ꒘\\u0645\\u062E\?\'\)\ throws\ error\ B2\ B5\ P1\ V6\ \[data\/IdnaTest\.txt\:1505\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--9-vtc42319e.xn--tgb9bz87p833hw316c", %p)},	undef,	"to_ascii\(\'xn\-\-9\-vtc42319e\.xn\-\-tgb9bz87p833hw316c\'\)\ throws\ error\ B2\ B5\ V6\ \[data\/IdnaTest\.txt\:1507\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--9-vtc736qts91g.xn--tgb9bz87p833hw316c", %p)},	undef,	"to_ascii\(\'xn\-\-9\-vtc736qts91g\.xn\-\-tgb9bz87p833hw316c\'\)\ throws\ error\ B1\ B5\ C1\ V6\ \[data\/IdnaTest\.txt\:1508\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--9-vtc42319e.xn--tgb9bz61cfn8mw3t2c", %p)},	undef,	"to_ascii\(\'xn\-\-9\-vtc42319e\.xn\-\-tgb9bz61cfn8mw3t2c\'\)\ throws\ error\ B2\ B5\ V6\ \[data\/IdnaTest\.txt\:1509\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--9-vtc736qts91g.xn--tgb9bz61cfn8mw3t2c", %p)},	undef,	"to_ascii\(\'xn\-\-9\-vtc736qts91g\.xn\-\-tgb9bz61cfn8mw3t2c\'\)\ throws\ error\ B1\ B5\ C1\ V6\ \[data\/IdnaTest\.txt\:1510\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}\x{06A0}𿺆𝟗｡ⴣ꒘\x{FCD0}񐘖", %p)},	undef,	"to_ascii\(\'\\u200C\\u06A0\?𝟗｡ⴣ꒘\\uFCD0\?\'\)\ throws\ error\ B2\ B5\ P1\ V6\ \[data\/IdnaTest\.txt\:1511\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᡖ｡\x{031F}񗛨\x{0B82}-", %p)},	undef,	"to_ascii\(\'ᡖ｡\\u031F\?\\u0B82\-\'\)\ throws\ error\ P1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:1513\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᡖ。\x{031F}񗛨\x{0B82}-", %p)},	undef,	"to_ascii\(\'ᡖ\。\\u031F\?\\u0B82\-\'\)\ throws\ error\ P1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:1514\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--m8e.xn----mdb555dkk71m", %p)},	undef,	"to_ascii\(\'xn\-\-m8e\.xn\-\-\-\-mdb555dkk71m\'\)\ throws\ error\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:1515\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("𞠠浘。絧𞀀", %p)},	undef,	"to_ascii\(\'𞠠浘\。絧𞀀\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:1516\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--e0wp491f.xn--ud0a3573e", %p)},	undef,	"to_ascii\(\'xn\-\-e0wp491f\.xn\-\-ud0a3573e\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:1517\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0596}Ⴋ．𝟳≯︒\x{FE0A}", %p)},	undef,	"to_ascii\(\'\\u0596Ⴋ．𝟳\≯︒\\uFE0A\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1518\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0596}Ⴋ．𝟳>\x{0338}︒\x{FE0A}", %p)},	undef,	"to_ascii\(\'\\u0596Ⴋ．𝟳\>\\u0338︒\\uFE0A\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1519\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0596}Ⴋ.7≯。\x{FE0A}", %p)},	undef,	"to_ascii\(\'\\u0596Ⴋ\.7\≯\。\\uFE0A\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1520\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0596}Ⴋ.7>\x{0338}。\x{FE0A}", %p)},	undef,	"to_ascii\(\'\\u0596Ⴋ\.7\>\\u0338\。\\uFE0A\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1521\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0596}ⴋ.7>\x{0338}。\x{FE0A}", %p)},	undef,	"to_ascii\(\'\\u0596ⴋ\.7\>\\u0338\。\\uFE0A\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1522\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0596}ⴋ.7≯。\x{FE0A}", %p)},	undef,	"to_ascii\(\'\\u0596ⴋ\.7\≯\。\\uFE0A\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1523\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--hcb613r.xn--7-pgo.", %p)},	undef,	"to_ascii\(\'xn\-\-hcb613r\.xn\-\-7\-pgo\.\'\)\ throws\ error\ V5\ V6\ \[data\/IdnaTest\.txt\:1524\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--hcb887c.xn--7-pgo.", %p)},	undef,	"to_ascii\(\'xn\-\-hcb887c\.xn\-\-7\-pgo\.\'\)\ throws\ error\ V5\ V6\ \[data\/IdnaTest\.txt\:1525\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0596}ⴋ．𝟳>\x{0338}︒\x{FE0A}", %p)},	undef,	"to_ascii\(\'\\u0596ⴋ．𝟳\>\\u0338︒\\uFE0A\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1526\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0596}ⴋ．𝟳≯︒\x{FE0A}", %p)},	undef,	"to_ascii\(\'\\u0596ⴋ．𝟳\≯︒\\uFE0A\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1527\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--hcb613r.xn--7-pgoy530h", %p)},	undef,	"to_ascii\(\'xn\-\-hcb613r\.xn\-\-7\-pgoy530h\'\)\ throws\ error\ V5\ V6\ \[data\/IdnaTest\.txt\:1528\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--hcb887c.xn--7-pgoy530h", %p)},	undef,	"to_ascii\(\'xn\-\-hcb887c\.xn\-\-7\-pgoy530h\'\)\ throws\ error\ V5\ V6\ \[data\/IdnaTest\.txt\:1529\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}F𑓂。󠺨︒\x{077E}𐹢", %p)},	undef,	"to_ascii\(\'\\u200DF𑓂\。\?︒\\u077E𐹢\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:1530\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}F𑓂。󠺨。\x{077E}𐹢", %p)},	undef,	"to_ascii\(\'\\u200DF𑓂\。\?\。\\u077E𐹢\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:1532\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}f𑓂。󠺨。\x{077E}𐹢", %p)},	undef,	"to_ascii\(\'\\u200Df𑓂\。\?\。\\u077E𐹢\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:1534\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--f-kq9i.xn--7656e.xn--fqb4175k", %p)},	undef,	"to_ascii\(\'xn\-\-f\-kq9i\.xn\-\-7656e\.xn\-\-fqb4175k\'\)\ throws\ error\ B1\ V6\ \[data\/IdnaTest\.txt\:1536\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--f-tgn9761i.xn--7656e.xn--fqb4175k", %p)},	undef,	"to_ascii\(\'xn\-\-f\-tgn9761i\.xn\-\-7656e\.xn\-\-fqb4175k\'\)\ throws\ error\ B1\ C2\ V6\ \[data\/IdnaTest\.txt\:1537\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}f𑓂。󠺨︒\x{077E}𐹢", %p)},	undef,	"to_ascii\(\'\\u200Df𑓂\。\?︒\\u077E𐹢\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:1538\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--f-kq9i.xn--fqb1637j8hky9452a", %p)},	undef,	"to_ascii\(\'xn\-\-f\-kq9i\.xn\-\-fqb1637j8hky9452a\'\)\ throws\ error\ B1\ V6\ \[data\/IdnaTest\.txt\:1540\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--f-tgn9761i.xn--fqb1637j8hky9452a", %p)},	undef,	"to_ascii\(\'xn\-\-f\-tgn9761i\.xn\-\-fqb1637j8hky9452a\'\)\ throws\ error\ B1\ C2\ V6\ \[data\/IdnaTest\.txt\:1541\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0845}🄇𐼗︒｡𐹻𑜫", %p)},	undef,	"to_ascii\(\'\\u0845🄇𐼗︒｡𐹻𑜫\'\)\ throws\ error\ B1\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:1542\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0845}6,𐼗。。𐹻𑜫", %p)},	undef,	"to_ascii\(\'\\u08456\,𐼗\。\。𐹻𑜫\'\)\ throws\ error\ B1\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:1543\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--6,-r4e4420y..xn--zo0di2m", %p)},	undef,	"to_ascii\(\'xn\-\-6\,\-r4e4420y\.\.xn\-\-zo0di2m\'\)\ throws\ error\ B1\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:1544\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--3vb4696jpxkjh7s.xn--zo0di2m", %p)},	undef,	"to_ascii\(\'xn\-\-3vb4696jpxkjh7s\.xn\-\-zo0di2m\'\)\ throws\ error\ B1\ B3\ V6\ \[data\/IdnaTest\.txt\:1545\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐹈.\x{1DC0}𑈱𐦭", %p)},	undef,	"to_ascii\(\'\?\.\\u1DC0𑈱𐦭\'\)\ throws\ error\ B1\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1546\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--jn0d.xn--7dg0871h3lf", %p)},	undef,	"to_ascii\(\'xn\-\-jn0d\.xn\-\-7dg0871h3lf\'\)\ throws\ error\ B1\ V5\ V6\ \[data\/IdnaTest\.txt\:1547\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴂ䠺。𞤃񅏎󙮦\x{0693}", %p)},	undef,	"to_ascii\(\'Ⴂ䠺\。𞤃\?\?\\u0693\'\)\ throws\ error\ B2\ P1\ V6\ \[data\/IdnaTest\.txt\:1548\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⴂ䠺。𞤥񅏎󙮦\x{0693}", %p)},	undef,	"to_ascii\(\'ⴂ䠺\。𞤥\?\?\\u0693\'\)\ throws\ error\ B2\ P1\ V6\ \[data\/IdnaTest\.txt\:1549\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--tkj638f.xn--pjb9818vg4xno967d", %p)},	undef,	"to_ascii\(\'xn\-\-tkj638f\.xn\-\-pjb9818vg4xno967d\'\)\ throws\ error\ B2\ V6\ \[data\/IdnaTest\.txt\:1550\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--9md875z.xn--pjb9818vg4xno967d", %p)},	undef,	"to_ascii\(\'xn\-\-9md875z\.xn\-\-pjb9818vg4xno967d\'\)\ throws\ error\ B2\ V6\ \[data\/IdnaTest\.txt\:1551\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⴂ䠺。𞤃񅏎󙮦\x{0693}", %p)},	undef,	"to_ascii\(\'ⴂ䠺\。𞤃\?\?\\u0693\'\)\ throws\ error\ B2\ P1\ V6\ \[data\/IdnaTest\.txt\:1552\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("🄇伐︒.𜙚\x{A8C4}", %p)},	undef,	"to_ascii\(\'🄇伐︒\.\?\\uA8C4\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1553\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("6,伐。.𜙚\x{A8C4}", %p)},	undef,	"to_ascii\(\'6\,伐\。\.\?\\uA8C4\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:1554\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--6,-7i3c..xn--0f9ao925c", %p)},	undef,	"to_ascii\(\'xn\-\-6\,\-7i3c\.\.xn\-\-0f9ao925c\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:1555\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--woqs083bel0g.xn--0f9ao925c", %p)},	undef,	"to_ascii\(\'xn\-\-woqs083bel0g\.xn\-\-0f9ao925c\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:1556\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}𐹠\x{ABED}\x{FFFB}。\x{200D}𐫓Ⴚ𑂹", %p)},	undef,	"to_ascii\(\'\\u200D𐹠\\uABED\\uFFFB\。\\u200D𐫓Ⴚ𑂹\'\)\ throws\ error\ B1\ B2\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:1557\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}𐹠\x{ABED}\x{FFFB}。\x{200D}𐫓ⴚ𑂹", %p)},	undef,	"to_ascii\(\'\\u200D𐹠\\uABED\\uFFFB\。\\u200D𐫓ⴚ𑂹\'\)\ throws\ error\ B1\ B2\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:1559\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--429az70n29i.xn--ilj7702eqyd", %p)},	undef,	"to_ascii\(\'xn\-\-429az70n29i\.xn\-\-ilj7702eqyd\'\)\ throws\ error\ B1\ B2\ B3\ V6\ \[data\/IdnaTest\.txt\:1561\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--1ugz126coy7bdbm.xn--1ug062chv7ov6e", %p)},	undef,	"to_ascii\(\'xn\-\-1ugz126coy7bdbm\.xn\-\-1ug062chv7ov6e\'\)\ throws\ error\ B1\ C2\ V6\ \[data\/IdnaTest\.txt\:1562\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--429az70n29i.xn--ynd3619jqyd", %p)},	undef,	"to_ascii\(\'xn\-\-429az70n29i\.xn\-\-ynd3619jqyd\'\)\ throws\ error\ B1\ B2\ B3\ V6\ \[data\/IdnaTest\.txt\:1563\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--1ugz126coy7bdbm.xn--ynd959evs1pv6e", %p)},	undef,	"to_ascii\(\'xn\-\-1ugz126coy7bdbm\.xn\-\-ynd959evs1pv6e\'\)\ throws\ error\ B1\ C2\ V6\ \[data\/IdnaTest\.txt\:1564\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠆠．񷐴󌟈", %p)},	undef,	"to_ascii\(\'\󠆠．\?\?\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:1565\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠆠.񷐴󌟈", %p)},	undef,	"to_ascii\(\'\󠆠\.\?\?\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:1566\]") or ($@ and diag($@));
is(eval{uts46_to_ascii(".xn--rx21bhv12i", %p)},	undef,	"to_ascii\(\'\.xn\-\-rx21bhv12i\'\)\ throws\ error\ V6\ A4_2\ \[data\/IdnaTest\.txt\:1567\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐫃\x{200C}Ⴆ.≠𞷙", %p)},	undef,	"to_ascii\(\'𐫃\\u200CႦ\.\≠\?\'\)\ throws\ error\ B1\ B2\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:1568\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐫃\x{200C}Ⴆ.=\x{0338}𞷙", %p)},	undef,	"to_ascii\(\'𐫃\\u200CႦ\.\=\\u0338\?\'\)\ throws\ error\ B1\ B2\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:1570\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐫃\x{200C}ⴆ.=\x{0338}𞷙", %p)},	undef,	"to_ascii\(\'𐫃\\u200Cⴆ\.\=\\u0338\?\'\)\ throws\ error\ B1\ B2\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:1572\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐫃\x{200C}ⴆ.≠𞷙", %p)},	undef,	"to_ascii\(\'𐫃\\u200Cⴆ\.\≠\?\'\)\ throws\ error\ B1\ B2\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:1574\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--xkjz802e.xn--1ch2802p", %p)},	undef,	"to_ascii\(\'xn\-\-xkjz802e\.xn\-\-1ch2802p\'\)\ throws\ error\ B1\ B2\ B3\ V6\ \[data\/IdnaTest\.txt\:1576\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--0ug132csv7o.xn--1ch2802p", %p)},	undef,	"to_ascii\(\'xn\-\-0ug132csv7o\.xn\-\-1ch2802p\'\)\ throws\ error\ B1\ B2\ B3\ C1\ V6\ \[data\/IdnaTest\.txt\:1577\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--end1719j.xn--1ch2802p", %p)},	undef,	"to_ascii\(\'xn\-\-end1719j\.xn\-\-1ch2802p\'\)\ throws\ error\ B1\ B2\ B3\ V6\ \[data\/IdnaTest\.txt\:1578\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--end799ekr1p.xn--1ch2802p", %p)},	undef,	"to_ascii\(\'xn\-\-end799ekr1p\.xn\-\-1ch2802p\'\)\ throws\ error\ B1\ B2\ B3\ C1\ V6\ \[data\/IdnaTest\.txt\:1579\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠁲𙩢𝟥ꘌ．\x{0841}", %p)},	undef,	"to_ascii\(\'\?\?𝟥ꘌ．\\u0841\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:1580\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠁲𙩢3ꘌ.\x{0841}", %p)},	undef,	"to_ascii\(\'\?\?3ꘌ\.\\u0841\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:1581\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--3-0g3es485d8i15h.xn--zvb", %p)},	undef,	"to_ascii\(\'xn\-\-3\-0g3es485d8i15h\.xn\-\-zvb\'\)\ throws\ error\ B1\ V6\ \[data\/IdnaTest\.txt\:1582\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-.\x{1886}󡲣-", %p)},	undef,	"to_ascii\(\'\-\.\\u1886\?\-\'\)\ throws\ error\ P1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:1583\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-.xn----pbkx6497q", %p)},	undef,	"to_ascii\(\'\-\.xn\-\-\-\-pbkx6497q\'\)\ throws\ error\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:1584\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󲚗\x{200C}｡\x{200C}𞰆ς", %p)},	undef,	"to_ascii\(\'\?\\u200C｡\\u200C\?ς\'\)\ throws\ error\ B2\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:1585\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󲚗\x{200C}。\x{200C}𞰆ς", %p)},	undef,	"to_ascii\(\'\?\\u200C\。\\u200C\?ς\'\)\ throws\ error\ B2\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:1587\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󲚗\x{200C}。\x{200C}𞰆Σ", %p)},	undef,	"to_ascii\(\'\?\\u200C\。\\u200C\?Σ\'\)\ throws\ error\ B2\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:1589\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󲚗\x{200C}。\x{200C}𞰆σ", %p)},	undef,	"to_ascii\(\'\?\\u200C\。\\u200C\?σ\'\)\ throws\ error\ B2\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:1591\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--qp42f.xn--4xa3011w", %p)},	undef,	"to_ascii\(\'xn\-\-qp42f\.xn\-\-4xa3011w\'\)\ throws\ error\ B2\ B3\ V6\ \[data\/IdnaTest\.txt\:1593\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--0ug76062m.xn--4xa595lhn92a", %p)},	undef,	"to_ascii\(\'xn\-\-0ug76062m\.xn\-\-4xa595lhn92a\'\)\ throws\ error\ B1\ B6\ C1\ V6\ \[data\/IdnaTest\.txt\:1594\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--0ug76062m.xn--3xa795lhn92a", %p)},	undef,	"to_ascii\(\'xn\-\-0ug76062m\.xn\-\-3xa795lhn92a\'\)\ throws\ error\ B1\ B6\ C1\ V6\ \[data\/IdnaTest\.txt\:1595\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󲚗\x{200C}｡\x{200C}𞰆Σ", %p)},	undef,	"to_ascii\(\'\?\\u200C｡\\u200C\?Σ\'\)\ throws\ error\ B2\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:1596\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󲚗\x{200C}｡\x{200C}𞰆σ", %p)},	undef,	"to_ascii\(\'\?\\u200C｡\\u200C\?σ\'\)\ throws\ error\ B2\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:1598\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("堕𑓂\x{1B02}。𐮇𞤽\x{200C}-", %p)},	undef,	"to_ascii\(\'堕𑓂\\u1B02\。𐮇𞤽\\u200C\-\'\)\ throws\ error\ B3\ V3\ \[data\/IdnaTest\.txt\:1600\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("堕𑓂\x{1B02}。𐮇𞤛\x{200C}-", %p)},	undef,	"to_ascii\(\'堕𑓂\\u1B02\。𐮇𞤛\\u200C\-\'\)\ throws\ error\ B3\ V3\ \[data\/IdnaTest\.txt\:1602\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--5sf345zdk8h.xn----iv5iw606c", %p)},	undef,	"to_ascii\(\'xn\-\-5sf345zdk8h\.xn\-\-\-\-iv5iw606c\'\)\ throws\ error\ B3\ V3\ \[data\/IdnaTest\.txt\:1604\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--5sf345zdk8h.xn----rgnt157hwl9g", %p)},	undef,	"to_ascii\(\'xn\-\-5sf345zdk8h\.xn\-\-\-\-rgnt157hwl9g\'\)\ throws\ error\ B3\ C1\ V3\ \[data\/IdnaTest\.txt\:1605\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("𐹶𑁆ᡕ𞤢｡ᡥς\x{062A}ς", %p)},	undef,	"to_ascii\(\'𐹶𑁆ᡕ𞤢｡ᡥς\\u062Aς\'\)\ throws\ error\ B1\ B5\ \[data\/IdnaTest\.txt\:1606\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("𐹶𑁆ᡕ𞤢。ᡥς\x{062A}ς", %p)},	undef,	"to_ascii\(\'𐹶𑁆ᡕ𞤢\。ᡥς\\u062Aς\'\)\ throws\ error\ B1\ B5\ \[data\/IdnaTest\.txt\:1608\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("𐹶𑁆ᡕ𞤀。ᡥΣ\x{062A}Σ", %p)},	undef,	"to_ascii\(\'𐹶𑁆ᡕ𞤀\。ᡥΣ\\u062AΣ\'\)\ throws\ error\ B1\ B5\ \[data\/IdnaTest\.txt\:1610\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("𐹶𑁆ᡕ𞤢。ᡥσ\x{062A}σ", %p)},	undef,	"to_ascii\(\'𐹶𑁆ᡕ𞤢\。ᡥσ\\u062Aσ\'\)\ throws\ error\ B1\ B5\ \[data\/IdnaTest\.txt\:1611\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("𐹶𑁆ᡕ𞤀。ᡥΣ\x{062A}σ", %p)},	undef,	"to_ascii\(\'𐹶𑁆ᡕ𞤀\。ᡥΣ\\u062Aσ\'\)\ throws\ error\ B1\ B5\ \[data\/IdnaTest\.txt\:1612\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--l8e1317j1ebz456b.xn--4xaa85plx4a", %p)},	undef,	"to_ascii\(\'xn\-\-l8e1317j1ebz456b\.xn\-\-4xaa85plx4a\'\)\ throws\ error\ B1\ B5\ \[data\/IdnaTest\.txt\:1613\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("𐹶𑁆ᡕ𞤀。ᡥΣ\x{062A}ς", %p)},	undef,	"to_ascii\(\'𐹶𑁆ᡕ𞤀\。ᡥΣ\\u062Aς\'\)\ throws\ error\ B1\ B5\ \[data\/IdnaTest\.txt\:1614\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("𐹶𑁆ᡕ𞤢。ᡥσ\x{062A}ς", %p)},	undef,	"to_ascii\(\'𐹶𑁆ᡕ𞤢\。ᡥσ\\u062Aς\'\)\ throws\ error\ B1\ B5\ \[data\/IdnaTest\.txt\:1616\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--l8e1317j1ebz456b.xn--3xab95plx4a", %p)},	undef,	"to_ascii\(\'xn\-\-l8e1317j1ebz456b\.xn\-\-3xab95plx4a\'\)\ throws\ error\ B1\ B5\ \[data\/IdnaTest\.txt\:1618\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--l8e1317j1ebz456b.xn--3xaa16plx4a", %p)},	undef,	"to_ascii\(\'xn\-\-l8e1317j1ebz456b\.xn\-\-3xaa16plx4a\'\)\ throws\ error\ B1\ B5\ \[data\/IdnaTest\.txt\:1619\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("𐹶𑁆ᡕ𞤀｡ᡥΣ\x{062A}Σ", %p)},	undef,	"to_ascii\(\'𐹶𑁆ᡕ𞤀｡ᡥΣ\\u062AΣ\'\)\ throws\ error\ B1\ B5\ \[data\/IdnaTest\.txt\:1620\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("𐹶𑁆ᡕ𞤢｡ᡥσ\x{062A}σ", %p)},	undef,	"to_ascii\(\'𐹶𑁆ᡕ𞤢｡ᡥσ\\u062Aσ\'\)\ throws\ error\ B1\ B5\ \[data\/IdnaTest\.txt\:1621\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("𐹶𑁆ᡕ𞤀｡ᡥΣ\x{062A}σ", %p)},	undef,	"to_ascii\(\'𐹶𑁆ᡕ𞤀｡ᡥΣ\\u062Aσ\'\)\ throws\ error\ B1\ B5\ \[data\/IdnaTest\.txt\:1622\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("𐹶𑁆ᡕ𞤀｡ᡥΣ\x{062A}ς", %p)},	undef,	"to_ascii\(\'𐹶𑁆ᡕ𞤀｡ᡥΣ\\u062Aς\'\)\ throws\ error\ B1\ B5\ \[data\/IdnaTest\.txt\:1623\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("𐹶𑁆ᡕ𞤢｡ᡥσ\x{062A}ς", %p)},	undef,	"to_ascii\(\'𐹶𑁆ᡕ𞤢｡ᡥσ\\u062Aς\'\)\ throws\ error\ B1\ B5\ \[data\/IdnaTest\.txt\:1625\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("𐹶𑁆ᡕ𞤢。ᡥΣ\x{062A}Σ", %p)},	undef,	"to_ascii\(\'𐹶𑁆ᡕ𞤢\。ᡥΣ\\u062AΣ\'\)\ throws\ error\ B1\ B5\ \[data\/IdnaTest\.txt\:1627\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("𐹶𑁆ᡕ𞤢。ᡥΣ\x{062A}σ", %p)},	undef,	"to_ascii\(\'𐹶𑁆ᡕ𞤢\。ᡥΣ\\u062Aσ\'\)\ throws\ error\ B1\ B5\ \[data\/IdnaTest\.txt\:1628\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("𐹶𑁆ᡕ𞤢。ᡥΣ\x{062A}ς", %p)},	undef,	"to_ascii\(\'𐹶𑁆ᡕ𞤢\。ᡥΣ\\u062Aς\'\)\ throws\ error\ B1\ B5\ \[data\/IdnaTest\.txt\:1629\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("𐹶𑁆ᡕ𞤢｡ᡥΣ\x{062A}Σ", %p)},	undef,	"to_ascii\(\'𐹶𑁆ᡕ𞤢｡ᡥΣ\\u062AΣ\'\)\ throws\ error\ B1\ B5\ \[data\/IdnaTest\.txt\:1631\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("𐹶𑁆ᡕ𞤢｡ᡥΣ\x{062A}σ", %p)},	undef,	"to_ascii\(\'𐹶𑁆ᡕ𞤢｡ᡥΣ\\u062Aσ\'\)\ throws\ error\ B1\ B5\ \[data\/IdnaTest\.txt\:1632\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("𐹶𑁆ᡕ𞤢｡ᡥΣ\x{062A}ς", %p)},	undef,	"to_ascii\(\'𐹶𑁆ᡕ𞤢｡ᡥΣ\\u062Aς\'\)\ throws\ error\ B1\ B5\ \[data\/IdnaTest\.txt\:1633\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("󏒰．-𝟻ß", %p)},	undef,	"to_ascii\(\'\?．\-𝟻ß\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:1635\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󏒰.-5ß", %p)},	undef,	"to_ascii\(\'\?\.\-5ß\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:1637\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󏒰.-5SS", %p)},	undef,	"to_ascii\(\'\?\.\-5SS\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:1639\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󏒰.-5ss", %p)},	undef,	"to_ascii\(\'\?\.\-5ss\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:1640\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󏒰.-5Ss", %p)},	undef,	"to_ascii\(\'\?\.\-5Ss\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:1641\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--t960e.-5ss", %p)},	undef,	"to_ascii\(\'xn\-\-t960e\.\-5ss\'\)\ throws\ error\ V3\ V6\ \[data\/IdnaTest\.txt\:1642\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--t960e.xn---5-hia", %p)},	undef,	"to_ascii\(\'xn\-\-t960e\.xn\-\-\-5\-hia\'\)\ throws\ error\ V3\ V6\ \[data\/IdnaTest\.txt\:1643\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󏒰．-𝟻SS", %p)},	undef,	"to_ascii\(\'\?．\-𝟻SS\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:1644\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󏒰．-𝟻ss", %p)},	undef,	"to_ascii\(\'\?．\-𝟻ss\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:1645\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󏒰．-𝟻Ss", %p)},	undef,	"to_ascii\(\'\?．\-𝟻Ss\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:1646\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}𐨿.🤒Ⴥ򑮶", %p)},	undef,	"to_ascii\(\'\\u200D𐨿\.🤒Ⴥ\?\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1647\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}𐨿.🤒ⴥ򑮶", %p)},	undef,	"to_ascii\(\'\\u200D𐨿\.🤒ⴥ\?\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1649\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--0s9c.xn--tljz038l0gz4b", %p)},	undef,	"to_ascii\(\'xn\-\-0s9c\.xn\-\-tljz038l0gz4b\'\)\ throws\ error\ V5\ V6\ \[data\/IdnaTest\.txt\:1651\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--1ug9533g.xn--tljz038l0gz4b", %p)},	undef,	"to_ascii\(\'xn\-\-1ug9533g\.xn\-\-tljz038l0gz4b\'\)\ throws\ error\ C2\ V6\ \[data\/IdnaTest\.txt\:1652\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--0s9c.xn--9nd3211w0gz4b", %p)},	undef,	"to_ascii\(\'xn\-\-0s9c\.xn\-\-9nd3211w0gz4b\'\)\ throws\ error\ V5\ V6\ \[data\/IdnaTest\.txt\:1653\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--1ug9533g.xn--9nd3211w0gz4b", %p)},	undef,	"to_ascii\(\'xn\-\-1ug9533g\.xn\-\-9nd3211w0gz4b\'\)\ throws\ error\ C2\ V6\ \[data\/IdnaTest\.txt\:1654\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𵋅。ß𬵩\x{200D}", %p)},	undef,	"to_ascii\(\'\?\。ß𬵩\\u200D\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1655\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𵋅。SS𬵩\x{200D}", %p)},	undef,	"to_ascii\(\'\?\。SS𬵩\\u200D\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1657\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𵋅。ss𬵩\x{200D}", %p)},	undef,	"to_ascii\(\'\?\。ss𬵩\\u200D\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1659\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𵋅。Ss𬵩\x{200D}", %p)},	undef,	"to_ascii\(\'\?\。Ss𬵩\\u200D\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1661\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--ey1p.xn--ss-eq36b", %p)},	undef,	"to_ascii\(\'xn\-\-ey1p\.xn\-\-ss\-eq36b\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:1663\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--ey1p.xn--ss-n1tx0508a", %p)},	undef,	"to_ascii\(\'xn\-\-ey1p\.xn\-\-ss\-n1tx0508a\'\)\ throws\ error\ C2\ V6\ \[data\/IdnaTest\.txt\:1664\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--ey1p.xn--zca870nz438b", %p)},	undef,	"to_ascii\(\'xn\-\-ey1p\.xn\-\-zca870nz438b\'\)\ throws\ error\ C2\ V6\ \[data\/IdnaTest\.txt\:1665\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v10.0 (perl v5.28.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v10.0; is(eval{uts46_to_ascii("\x{200C}𭉝。\x{07F1}\x{0301}𞹻", %p)},	undef,	"to_ascii\(\'\\u200C𭉝\。\\u07F1\\u0301𞹻\'\)\ throws\ error\ B1\ V5\ \[data\/IdnaTest\.txt\:1666\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v10.0 (perl v5.28.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v10.0; is(eval{uts46_to_ascii("\x{200C}𭉝。\x{07F1}\x{0301}\x{063A}", %p)},	undef,	"to_ascii\(\'\\u200C𭉝\。\\u07F1\\u0301\\u063A\'\)\ throws\ error\ B1\ V5\ \[data\/IdnaTest\.txt\:1668\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--634m.xn--lsa46nuub", %p)},	undef,	"to_ascii\(\'xn\-\-634m\.xn\-\-lsa46nuub\'\)\ throws\ error\ B1\ V5\ \[data\/IdnaTest\.txt\:1670\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--0ugy003y.xn--lsa46nuub", %p)},	undef,	"to_ascii\(\'xn\-\-0ugy003y\.xn\-\-lsa46nuub\'\)\ throws\ error\ B1\ C1\ V5\ \[data\/IdnaTest\.txt\:1671\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𞼌\x{200C}𑈶。𐹡", %p)},	undef,	"to_ascii\(\'\?\\u200C𑈶\。𐹡\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:1672\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--9g1d1288a.xn--8n0d", %p)},	undef,	"to_ascii\(\'xn\-\-9g1d1288a\.xn\-\-8n0d\'\)\ throws\ error\ B1\ V6\ \[data\/IdnaTest\.txt\:1674\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--0ug7946gzpxf.xn--8n0d", %p)},	undef,	"to_ascii\(\'xn\-\-0ug7946gzpxf\.xn\-\-8n0d\'\)\ throws\ error\ B1\ B3\ C1\ V6\ \[data\/IdnaTest\.txt\:1675\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠅯򇽭\x{200C}🜭｡𑖿\x{1ABB}ς≠", %p)},	undef,	"to_ascii\(\'\󠅯\?\\u200C🜭｡𑖿\\u1ABBς\≠\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1676\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠅯򇽭\x{200C}🜭｡𑖿\x{1ABB}ς=\x{0338}", %p)},	undef,	"to_ascii\(\'\󠅯\?\\u200C🜭｡𑖿\\u1ABBς\=\\u0338\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1678\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠅯򇽭\x{200C}🜭。𑖿\x{1ABB}ς≠", %p)},	undef,	"to_ascii\(\'\󠅯\?\\u200C🜭\。𑖿\\u1ABBς\≠\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1680\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠅯򇽭\x{200C}🜭。𑖿\x{1ABB}ς=\x{0338}", %p)},	undef,	"to_ascii\(\'\󠅯\?\\u200C🜭\。𑖿\\u1ABBς\=\\u0338\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1682\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠅯򇽭\x{200C}🜭。𑖿\x{1ABB}Σ=\x{0338}", %p)},	undef,	"to_ascii\(\'\󠅯\?\\u200C🜭\。𑖿\\u1ABBΣ\=\\u0338\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1684\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠅯򇽭\x{200C}🜭。𑖿\x{1ABB}Σ≠", %p)},	undef,	"to_ascii\(\'\󠅯\?\\u200C🜭\。𑖿\\u1ABBΣ\≠\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1686\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠅯򇽭\x{200C}🜭。𑖿\x{1ABB}σ≠", %p)},	undef,	"to_ascii\(\'\󠅯\?\\u200C🜭\。𑖿\\u1ABBσ\≠\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1688\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠅯򇽭\x{200C}🜭。𑖿\x{1ABB}σ=\x{0338}", %p)},	undef,	"to_ascii\(\'\󠅯\?\\u200C🜭\。𑖿\\u1ABBσ\=\\u0338\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1690\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--zb9h5968x.xn--4xa378i1mfjw7y", %p)},	undef,	"to_ascii\(\'xn\-\-zb9h5968x\.xn\-\-4xa378i1mfjw7y\'\)\ throws\ error\ V5\ V6\ \[data\/IdnaTest\.txt\:1692\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--0ug3766p5nm1b.xn--4xa378i1mfjw7y", %p)},	undef,	"to_ascii\(\'xn\-\-0ug3766p5nm1b\.xn\-\-4xa378i1mfjw7y\'\)\ throws\ error\ C1\ V5\ V6\ \[data\/IdnaTest\.txt\:1693\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--0ug3766p5nm1b.xn--3xa578i1mfjw7y", %p)},	undef,	"to_ascii\(\'xn\-\-0ug3766p5nm1b\.xn\-\-3xa578i1mfjw7y\'\)\ throws\ error\ C1\ V5\ V6\ \[data\/IdnaTest\.txt\:1694\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠅯򇽭\x{200C}🜭｡𑖿\x{1ABB}Σ=\x{0338}", %p)},	undef,	"to_ascii\(\'\󠅯\?\\u200C🜭｡𑖿\\u1ABBΣ\=\\u0338\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1695\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠅯򇽭\x{200C}🜭｡𑖿\x{1ABB}Σ≠", %p)},	undef,	"to_ascii\(\'\󠅯\?\\u200C🜭｡𑖿\\u1ABBΣ\≠\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1697\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠅯򇽭\x{200C}🜭｡𑖿\x{1ABB}σ≠", %p)},	undef,	"to_ascii\(\'\󠅯\?\\u200C🜭｡𑖿\\u1ABBσ\≠\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1699\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠅯򇽭\x{200C}🜭｡𑖿\x{1ABB}σ=\x{0338}", %p)},	undef,	"to_ascii\(\'\󠅯\?\\u200C🜭｡𑖿\\u1ABBσ\=\\u0338\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1701\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⒋｡⒈\x{200D}򳴢", %p)},	undef,	"to_ascii\(\'⒋｡⒈\\u200D\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1703\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("4.。1.\x{200D}򳴢", %p)},	undef,	"to_ascii\(\'4\.\。1\.\\u200D\?\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:1705\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("4..1.xn--sf51d", %p)},	undef,	"to_ascii\(\'4\.\.1\.xn\-\-sf51d\'\)\ throws\ error\ V6\ A4_2\ \[data\/IdnaTest\.txt\:1707\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("4..1.xn--1ug64613i", %p)},	undef,	"to_ascii\(\'4\.\.1\.xn\-\-1ug64613i\'\)\ throws\ error\ C2\ V6\ A4_2\ \[data\/IdnaTest\.txt\:1708\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--wsh.xn--tsh07994h", %p)},	undef,	"to_ascii\(\'xn\-\-wsh\.xn\-\-tsh07994h\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:1709\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--wsh.xn--1ug58o74922a", %p)},	undef,	"to_ascii\(\'xn\-\-wsh\.xn\-\-1ug58o74922a\'\)\ throws\ error\ C2\ V6\ \[data\/IdnaTest\.txt\:1710\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0644}ß｡𐇽\x{1A60}򾅢𞤾", %p)},	undef,	"to_ascii\(\'\\u0644ß｡𐇽\\u1A60\?𞤾\'\)\ throws\ error\ B1\ B2\ B3\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1711\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0644}ß｡\x{1A60}𐇽򾅢𞤾", %p)},	undef,	"to_ascii\(\'\\u0644ß｡\\u1A60𐇽\?𞤾\'\)\ throws\ error\ B1\ B2\ B3\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1713\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0644}ß。\x{1A60}𐇽򾅢𞤾", %p)},	undef,	"to_ascii\(\'\\u0644ß\。\\u1A60𐇽\?𞤾\'\)\ throws\ error\ B1\ B2\ B3\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1715\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0644}SS。\x{1A60}𐇽򾅢𞤜", %p)},	undef,	"to_ascii\(\'\\u0644SS\。\\u1A60𐇽\?𞤜\'\)\ throws\ error\ B1\ B2\ B3\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1717\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0644}ss。\x{1A60}𐇽򾅢𞤾", %p)},	undef,	"to_ascii\(\'\\u0644ss\。\\u1A60𐇽\?𞤾\'\)\ throws\ error\ B1\ B2\ B3\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1718\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0644}Ss。\x{1A60}𐇽򾅢𞤜", %p)},	undef,	"to_ascii\(\'\\u0644Ss\。\\u1A60𐇽\?𞤜\'\)\ throws\ error\ B1\ B2\ B3\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1719\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--ss-svd.xn--jof2298hn83fln78f", %p)},	undef,	"to_ascii\(\'xn\-\-ss\-svd\.xn\-\-jof2298hn83fln78f\'\)\ throws\ error\ B1\ B2\ B3\ V5\ V6\ \[data\/IdnaTest\.txt\:1720\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--zca57y.xn--jof2298hn83fln78f", %p)},	undef,	"to_ascii\(\'xn\-\-zca57y\.xn\-\-jof2298hn83fln78f\'\)\ throws\ error\ B1\ B2\ B3\ V5\ V6\ \[data\/IdnaTest\.txt\:1721\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0644}SS｡\x{1A60}𐇽򾅢𞤜", %p)},	undef,	"to_ascii\(\'\\u0644SS｡\\u1A60𐇽\?𞤜\'\)\ throws\ error\ B1\ B2\ B3\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1722\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0644}ss｡\x{1A60}𐇽򾅢𞤾", %p)},	undef,	"to_ascii\(\'\\u0644ss｡\\u1A60𐇽\?𞤾\'\)\ throws\ error\ B1\ B2\ B3\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1723\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0644}Ss｡\x{1A60}𐇽򾅢𞤜", %p)},	undef,	"to_ascii\(\'\\u0644Ss｡\\u1A60𐇽\?𞤜\'\)\ throws\ error\ B1\ B2\ B3\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1724\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0644}SS｡𐇽\x{1A60}򾅢𞤜", %p)},	undef,	"to_ascii\(\'\\u0644SS｡𐇽\\u1A60\?𞤜\'\)\ throws\ error\ B1\ B2\ B3\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1725\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0644}ss｡𐇽\x{1A60}򾅢𞤾", %p)},	undef,	"to_ascii\(\'\\u0644ss｡𐇽\\u1A60\?𞤾\'\)\ throws\ error\ B1\ B2\ B3\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1726\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0644}Ss｡𐇽\x{1A60}򾅢𞤜", %p)},	undef,	"to_ascii\(\'\\u0644Ss｡𐇽\\u1A60\?𞤜\'\)\ throws\ error\ B1\ B2\ B3\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1727\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0644}SS。\x{1A60}𐇽򾅢𞤾", %p)},	undef,	"to_ascii\(\'\\u0644SS\。\\u1A60𐇽\?𞤾\'\)\ throws\ error\ B1\ B2\ B3\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1728\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0644}Ss。\x{1A60}𐇽򾅢𞤾", %p)},	undef,	"to_ascii\(\'\\u0644Ss\。\\u1A60𐇽\?𞤾\'\)\ throws\ error\ B1\ B2\ B3\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1729\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0644}SS｡\x{1A60}𐇽򾅢𞤾", %p)},	undef,	"to_ascii\(\'\\u0644SS｡\\u1A60𐇽\?𞤾\'\)\ throws\ error\ B1\ B2\ B3\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1730\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0644}Ss｡\x{1A60}𐇽򾅢𞤾", %p)},	undef,	"to_ascii\(\'\\u0644Ss｡\\u1A60𐇽\?𞤾\'\)\ throws\ error\ B1\ B2\ B3\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1731\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0644}SS｡𐇽\x{1A60}򾅢𞤾", %p)},	undef,	"to_ascii\(\'\\u0644SS｡𐇽\\u1A60\?𞤾\'\)\ throws\ error\ B1\ B2\ B3\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1732\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0644}Ss｡𐇽\x{1A60}򾅢𞤾", %p)},	undef,	"to_ascii\(\'\\u0644Ss｡𐇽\\u1A60\?𞤾\'\)\ throws\ error\ B1\ B2\ B3\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1733\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐹽𑄳񼜲.\x{1DDF}\x{17B8}\x{A806}𑜫", %p)},	undef,	"to_ascii\(\'𐹽𑄳\?\.\\u1DDF\\u17B8\\uA806𑜫\'\)\ throws\ error\ B1\ B3\ B6\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1734\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--1o0di0c0652w.xn--33e362arr1l153d", %p)},	undef,	"to_ascii\(\'xn\-\-1o0di0c0652w\.xn\-\-33e362arr1l153d\'\)\ throws\ error\ B1\ B3\ B6\ V5\ V6\ \[data\/IdnaTest\.txt\:1735\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴓ𑜫\x{200D}򗭓．\x{06A7}𑰶", %p)},	undef,	"to_ascii\(\'Ⴓ𑜫\\u200D\?．\\u06A7𑰶\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1736\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴓ𑜫\x{200D}򗭓.\x{06A7}𑰶", %p)},	undef,	"to_ascii\(\'Ⴓ𑜫\\u200D\?\.\\u06A7𑰶\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1738\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⴓ𑜫\x{200D}򗭓.\x{06A7}𑰶", %p)},	undef,	"to_ascii\(\'ⴓ𑜫\\u200D\?\.\\u06A7𑰶\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1740\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--blj6306ey091d.xn--9jb4223l", %p)},	undef,	"to_ascii\(\'xn\-\-blj6306ey091d\.xn\-\-9jb4223l\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:1742\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--1ugy52cym7p7xu5e.xn--9jb4223l", %p)},	undef,	"to_ascii\(\'xn\-\-1ugy52cym7p7xu5e\.xn\-\-9jb4223l\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:1743\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--rnd8945ky009c.xn--9jb4223l", %p)},	undef,	"to_ascii\(\'xn\-\-rnd8945ky009c\.xn\-\-9jb4223l\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:1744\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--rnd479ep20q7x12e.xn--9jb4223l", %p)},	undef,	"to_ascii\(\'xn\-\-rnd479ep20q7x12e\.xn\-\-9jb4223l\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:1745\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⴓ𑜫\x{200D}򗭓．\x{06A7}𑰶", %p)},	undef,	"to_ascii\(\'ⴓ𑜫\\u200D\?．\\u06A7𑰶\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1746\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐨿.🄆—", %p)},	undef,	"to_ascii\(\'𐨿\.🄆\—\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1748\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐨿.5,—", %p)},	undef,	"to_ascii\(\'𐨿\.5\,\—\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1749\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--0s9c.xn--5,-81t", %p)},	undef,	"to_ascii\(\'xn\-\-0s9c\.xn\-\-5\,\-81t\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1750\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--0s9c.xn--8ug8324p", %p)},	undef,	"to_ascii\(\'xn\-\-0s9c\.xn\-\-8ug8324p\'\)\ throws\ error\ V5\ V6\ \[data\/IdnaTest\.txt\:1751\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򔊱񁦮۸。󠾭-", %p)},	undef,	"to_ascii\(\'\?\?۸\。\?\-\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:1752\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--lmb18944c0g2z.xn----2k81m", %p)},	undef,	"to_ascii\(\'xn\-\-lmb18944c0g2z\.xn\-\-\-\-2k81m\'\)\ throws\ error\ V3\ V6\ \[data\/IdnaTest\.txt\:1753\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𼗸\x{07CD}𐹮。\x{06DD}ᡎᠴ", %p)},	undef,	"to_ascii\(\'\?\\u07CD𐹮\。\\u06DDᡎᠴ\'\)\ throws\ error\ B1\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:1754\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--osb0855kcc2r.xn--tlb299fhc", %p)},	undef,	"to_ascii\(\'xn\-\-osb0855kcc2r\.xn\-\-tlb299fhc\'\)\ throws\ error\ B1\ B5\ B6\ V6\ \[data\/IdnaTest\.txt\:1755\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}ᠮႾ🄂.🚗\x{0841}𮹌\x{200C}", %p)},	undef,	"to_ascii\(\'\\u200DᠮႾ🄂\.🚗\\u0841\?\\u200C\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:1756\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}ᠮႾ1,.🚗\x{0841}𮹌\x{200C}", %p)},	undef,	"to_ascii\(\'\\u200DᠮႾ1\,\.🚗\\u0841\?\\u200C\'\)\ throws\ error\ B1\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:1758\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}ᠮⴞ1,.🚗\x{0841}𮹌\x{200C}", %p)},	undef,	"to_ascii\(\'\\u200Dᠮⴞ1\,\.🚗\\u0841\?\\u200C\'\)\ throws\ error\ B1\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:1760\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--1,-v3o625k.xn--zvb3124wpkpf", %p)},	undef,	"to_ascii\(\'xn\-\-1\,\-v3o625k\.xn\-\-zvb3124wpkpf\'\)\ throws\ error\ B1\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:1762\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--1,-v3o161c53q.xn--zvb692j9664aic1g", %p)},	undef,	"to_ascii\(\'xn\-\-1\,\-v3o161c53q\.xn\-\-zvb692j9664aic1g\'\)\ throws\ error\ B1\ C1\ C2\ P1\ V6\ \[data\/IdnaTest\.txt\:1763\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--1,-ogkx89c.xn--zvb3124wpkpf", %p)},	undef,	"to_ascii\(\'xn\-\-1\,\-ogkx89c\.xn\-\-zvb3124wpkpf\'\)\ throws\ error\ B1\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:1764\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--1,-ogkx89c39j.xn--zvb692j9664aic1g", %p)},	undef,	"to_ascii\(\'xn\-\-1\,\-ogkx89c39j\.xn\-\-zvb692j9664aic1g\'\)\ throws\ error\ B1\ C1\ C2\ P1\ V6\ \[data\/IdnaTest\.txt\:1765\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}ᠮⴞ🄂.🚗\x{0841}𮹌\x{200C}", %p)},	undef,	"to_ascii\(\'\\u200Dᠮⴞ🄂\.🚗\\u0841\?\\u200C\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:1766\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--h7e438h1p44a.xn--zvb3124wpkpf", %p)},	undef,	"to_ascii\(\'xn\-\-h7e438h1p44a\.xn\-\-zvb3124wpkpf\'\)\ throws\ error\ B1\ V6\ \[data\/IdnaTest\.txt\:1768\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--h7e341b0wlbv45b.xn--zvb692j9664aic1g", %p)},	undef,	"to_ascii\(\'xn\-\-h7e341b0wlbv45b\.xn\-\-zvb692j9664aic1g\'\)\ throws\ error\ B1\ C1\ C2\ V6\ \[data\/IdnaTest\.txt\:1769\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--2nd129ai554b.xn--zvb3124wpkpf", %p)},	undef,	"to_ascii\(\'xn\-\-2nd129ai554b\.xn\-\-zvb3124wpkpf\'\)\ throws\ error\ B1\ V6\ \[data\/IdnaTest\.txt\:1770\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--2nd129ay2gnw71c.xn--zvb692j9664aic1g", %p)},	undef,	"to_ascii\(\'xn\-\-2nd129ay2gnw71c\.xn\-\-zvb692j9664aic1g\'\)\ throws\ error\ B1\ C1\ C2\ V6\ \[data\/IdnaTest\.txt\:1771\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0601}\x{0697}．𑚶񼡷⾆", %p)},	undef,	"to_ascii\(\'\\u0601\\u0697．𑚶\?⾆\'\)\ throws\ error\ B1\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1772\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0601}\x{0697}.𑚶񼡷舌", %p)},	undef,	"to_ascii\(\'\\u0601\\u0697\.𑚶\?舌\'\)\ throws\ error\ B1\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1773\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--jfb41a.xn--tc1ap851axo39c", %p)},	undef,	"to_ascii\(\'xn\-\-jfb41a\.xn\-\-tc1ap851axo39c\'\)\ throws\ error\ B1\ V5\ V6\ \[data\/IdnaTest\.txt\:1774\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("🞅󠳡󜍙.񲖷", %p)},	undef,	"to_ascii\(\'🞅\?\?\.\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1775\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--ie9hi1349bqdlb.xn--oj69a", %p)},	undef,	"to_ascii\(\'xn\-\-ie9hi1349bqdlb\.xn\-\-oj69a\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:1776\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{20E7}񯡎-򫣝.4Ⴄ\x{200C}", %p)},	undef,	"to_ascii\(\'\\u20E7\?\-\?\.4Ⴄ\\u200C\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1777\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{20E7}񯡎-򫣝.4ⴄ\x{200C}", %p)},	undef,	"to_ascii\(\'\\u20E7\?\-\?\.4ⴄ\\u200C\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1779\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----9snu5320fi76w.xn--4-ivs", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-9snu5320fi76w\.xn\-\-4\-ivs\'\)\ throws\ error\ V5\ V6\ \[data\/IdnaTest\.txt\:1781\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----9snu5320fi76w.xn--4-sgn589c", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-9snu5320fi76w\.xn\-\-4\-sgn589c\'\)\ throws\ error\ C1\ V5\ V6\ \[data\/IdnaTest\.txt\:1782\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----9snu5320fi76w.xn--4-f0g", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-9snu5320fi76w\.xn\-\-4\-f0g\'\)\ throws\ error\ V5\ V6\ \[data\/IdnaTest\.txt\:1783\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----9snu5320fi76w.xn--4-f0g649i", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-9snu5320fi76w\.xn\-\-4\-f0g649i\'\)\ throws\ error\ C1\ V5\ V6\ \[data\/IdnaTest\.txt\:1784\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("ᚭ｡𝌠ß𖫱", %p)},	"xn--hwe.xn--ss-ci1ub261a",	"to_ascii\(\'ᚭ｡𝌠ß𖫱\'\)\ \[data\/IdnaTest\.txt\:1785\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("ᚭ。𝌠ß𖫱", %p)},	"xn--hwe.xn--ss-ci1ub261a",	"to_ascii\(\'ᚭ\。𝌠ß𖫱\'\)\ \[data\/IdnaTest\.txt\:1787\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("ᚭ。𝌠SS𖫱", %p)},	"xn--hwe.xn--ss-ci1ub261a",	"to_ascii\(\'ᚭ\。𝌠SS𖫱\'\)\ \[data\/IdnaTest\.txt\:1789\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("ᚭ。𝌠ss𖫱", %p)},	"xn--hwe.xn--ss-ci1ub261a",	"to_ascii\(\'ᚭ\。𝌠ss𖫱\'\)\ \[data\/IdnaTest\.txt\:1790\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("ᚭ。𝌠Ss𖫱", %p)},	"xn--hwe.xn--ss-ci1ub261a",	"to_ascii\(\'ᚭ\。𝌠Ss𖫱\'\)\ \[data\/IdnaTest\.txt\:1791\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("xn--hwe.xn--ss-ci1ub261a", %p)},	"xn--hwe.xn--ss-ci1ub261a",	"to_ascii\(\'xn\-\-hwe\.xn\-\-ss\-ci1ub261a\'\)\ \[data\/IdnaTest\.txt\:1792\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("ᚭ.𝌠ss𖫱", %p)},	"xn--hwe.xn--ss-ci1ub261a",	"to_ascii\(\'ᚭ\.𝌠ss𖫱\'\)\ \[data\/IdnaTest\.txt\:1793\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("ᚭ.𝌠SS𖫱", %p)},	"xn--hwe.xn--ss-ci1ub261a",	"to_ascii\(\'ᚭ\.𝌠SS𖫱\'\)\ \[data\/IdnaTest\.txt\:1794\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("ᚭ.𝌠Ss𖫱", %p)},	"xn--hwe.xn--ss-ci1ub261a",	"to_ascii\(\'ᚭ\.𝌠Ss𖫱\'\)\ \[data\/IdnaTest\.txt\:1795\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("xn--hwe.xn--zca4946pblnc", %p)},	"xn--hwe.xn--zca4946pblnc",	"to_ascii\(\'xn\-\-hwe\.xn\-\-zca4946pblnc\'\)\ \[data\/IdnaTest\.txt\:1796\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("ᚭ.𝌠ß𖫱", %p)},	"xn--hwe.xn--ss-ci1ub261a",	"to_ascii\(\'ᚭ\.𝌠ß𖫱\'\)\ \[data\/IdnaTest\.txt\:1797\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("ᚭ｡𝌠SS𖫱", %p)},	"xn--hwe.xn--ss-ci1ub261a",	"to_ascii\(\'ᚭ｡𝌠SS𖫱\'\)\ \[data\/IdnaTest\.txt\:1799\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("ᚭ｡𝌠ss𖫱", %p)},	"xn--hwe.xn--ss-ci1ub261a",	"to_ascii\(\'ᚭ｡𝌠ss𖫱\'\)\ \[data\/IdnaTest\.txt\:1800\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("ᚭ｡𝌠Ss𖫱", %p)},	"xn--hwe.xn--ss-ci1ub261a",	"to_ascii\(\'ᚭ｡𝌠Ss𖫱\'\)\ \[data\/IdnaTest\.txt\:1801\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("₁｡𞤫ꡪ", %p)},	undef,	"to_ascii\(\'₁｡𞤫ꡪ\'\)\ throws\ error\ B1\ B2\ B3\ \[data\/IdnaTest\.txt\:1802\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("1。𞤫ꡪ", %p)},	undef,	"to_ascii\(\'1\。𞤫ꡪ\'\)\ throws\ error\ B1\ B2\ B3\ \[data\/IdnaTest\.txt\:1803\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("1。𞤉ꡪ", %p)},	undef,	"to_ascii\(\'1\。𞤉ꡪ\'\)\ throws\ error\ B1\ B2\ B3\ \[data\/IdnaTest\.txt\:1804\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("1.xn--gd9al691d", %p)},	undef,	"to_ascii\(\'1\.xn\-\-gd9al691d\'\)\ throws\ error\ B1\ B2\ B3\ \[data\/IdnaTest\.txt\:1805\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("₁｡𞤉ꡪ", %p)},	undef,	"to_ascii\(\'₁｡𞤉ꡪ\'\)\ throws\ error\ B1\ B2\ B3\ \[data\/IdnaTest\.txt\:1806\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("𯻼\x{200C}.𞶞򻙤񥘇", %p)},	undef,	"to_ascii\(\'\?\\u200C\.\?\?\?\'\)\ throws\ error\ B2\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:1807\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--kg4n.xn--2b7hs861pl540a", %p)},	undef,	"to_ascii\(\'xn\-\-kg4n\.xn\-\-2b7hs861pl540a\'\)\ throws\ error\ B2\ B3\ V6\ \[data\/IdnaTest\.txt\:1809\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--0ug27500a.xn--2b7hs861pl540a", %p)},	undef,	"to_ascii\(\'xn\-\-0ug27500a\.xn\-\-2b7hs861pl540a\'\)\ throws\ error\ B2\ B3\ B6\ C1\ V6\ \[data\/IdnaTest\.txt\:1810\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𑑄≯｡𑜤", %p)},	undef,	"to_ascii\(\'𑑄\≯｡𑜤\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1811\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𑑄>\x{0338}｡𑜤", %p)},	undef,	"to_ascii\(\'𑑄\>\\u0338｡𑜤\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1812\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𑑄≯。𑜤", %p)},	undef,	"to_ascii\(\'𑑄\≯\。𑜤\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1813\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𑑄>\x{0338}。𑜤", %p)},	undef,	"to_ascii\(\'𑑄\>\\u0338\。𑜤\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1814\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--hdh5636g.xn--ci2d", %p)},	undef,	"to_ascii\(\'xn\-\-hdh5636g\.xn\-\-ci2d\'\)\ throws\ error\ V5\ V6\ \[data\/IdnaTest\.txt\:1815\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴋ≮𱲆。\x{200D}\x{07A7}𐋣", %p)},	undef,	"to_ascii\(\'Ⴋ\≮𱲆\。\\u200D\\u07A7𐋣\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1816\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴋ<\x{0338}𱲆。\x{200D}\x{07A7}𐋣", %p)},	undef,	"to_ascii\(\'Ⴋ\<\\u0338𱲆\。\\u200D\\u07A7𐋣\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1818\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⴋ<\x{0338}𱲆。\x{200D}\x{07A7}𐋣", %p)},	undef,	"to_ascii\(\'ⴋ\<\\u0338𱲆\。\\u200D\\u07A7𐋣\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1820\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⴋ≮𱲆。\x{200D}\x{07A7}𐋣", %p)},	undef,	"to_ascii\(\'ⴋ\≮𱲆\。\\u200D\\u07A7𐋣\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1822\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--gdhz03bxt42d.xn--lrb6479j", %p)},	undef,	"to_ascii\(\'xn\-\-gdhz03bxt42d\.xn\-\-lrb6479j\'\)\ throws\ error\ V5\ V6\ \[data\/IdnaTest\.txt\:1824\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--gdhz03bxt42d.xn--lrb506jqr4n", %p)},	undef,	"to_ascii\(\'xn\-\-gdhz03bxt42d\.xn\-\-lrb506jqr4n\'\)\ throws\ error\ C2\ V6\ \[data\/IdnaTest\.txt\:1825\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--jnd802gsm17c.xn--lrb6479j", %p)},	undef,	"to_ascii\(\'xn\-\-jnd802gsm17c\.xn\-\-lrb6479j\'\)\ throws\ error\ V5\ V6\ \[data\/IdnaTest\.txt\:1826\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--jnd802gsm17c.xn--lrb506jqr4n", %p)},	undef,	"to_ascii\(\'xn\-\-jnd802gsm17c\.xn\-\-lrb506jqr4n\'\)\ throws\ error\ C2\ V6\ \[data\/IdnaTest\.txt\:1827\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{17D2}.򆽒≯", %p)},	undef,	"to_ascii\(\'\\u17D2\.\?\≯\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1828\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{17D2}.򆽒>\x{0338}", %p)},	undef,	"to_ascii\(\'\\u17D2\.\?\>\\u0338\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1829\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--u4e.xn--hdhx0084f", %p)},	undef,	"to_ascii\(\'xn\-\-u4e\.xn\-\-hdhx0084f\'\)\ throws\ error\ V5\ V6\ \[data\/IdnaTest\.txt\:1830\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񏁇\x{1734}．𐨺É⬓𑄴", %p)},	undef,	"to_ascii\(\'\?\\u1734．𐨺É\⬓𑄴\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1831\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񏁇\x{1734}．𐨺E\x{0301}⬓𑄴", %p)},	undef,	"to_ascii\(\'\?\\u1734．𐨺E\\u0301\⬓𑄴\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1832\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񏁇\x{1734}.𐨺É⬓𑄴", %p)},	undef,	"to_ascii\(\'\?\\u1734\.𐨺É\⬓𑄴\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1833\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񏁇\x{1734}.𐨺E\x{0301}⬓𑄴", %p)},	undef,	"to_ascii\(\'\?\\u1734\.𐨺E\\u0301\⬓𑄴\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1834\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񏁇\x{1734}.𐨺e\x{0301}⬓𑄴", %p)},	undef,	"to_ascii\(\'\?\\u1734\.𐨺e\\u0301\⬓𑄴\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1835\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񏁇\x{1734}.𐨺é⬓𑄴", %p)},	undef,	"to_ascii\(\'\?\\u1734\.𐨺é\⬓𑄴\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1836\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--c0e34564d.xn--9ca207st53lg3f", %p)},	undef,	"to_ascii\(\'xn\-\-c0e34564d\.xn\-\-9ca207st53lg3f\'\)\ throws\ error\ V5\ V6\ \[data\/IdnaTest\.txt\:1837\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񏁇\x{1734}．𐨺e\x{0301}⬓𑄴", %p)},	undef,	"to_ascii\(\'\?\\u1734．𐨺e\\u0301\⬓𑄴\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1838\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񏁇\x{1734}．𐨺é⬓𑄴", %p)},	undef,	"to_ascii\(\'\?\\u1734．𐨺é\⬓𑄴\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1839\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᢇ\x{200D}\x{A8C4}｡︒𞤺", %p)},	undef,	"to_ascii\(\'ᢇ\\u200D\\uA8C4｡︒𞤺\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:1840\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("ᢇ\x{200D}\x{A8C4}。。𞤺", %p)},	undef,	"to_ascii\(\'ᢇ\\u200D\\uA8C4\。\。𞤺\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:1842\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("ᢇ\x{200D}\x{A8C4}。。𞤘", %p)},	undef,	"to_ascii\(\'ᢇ\\u200D\\uA8C4\。\。𞤘\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:1844\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--09e4694e..xn--ye6h", %p)},	undef,	"to_ascii\(\'xn\-\-09e4694e\.\.xn\-\-ye6h\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:1846\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--09e669a6x8j..xn--ye6h", %p)},	undef,	"to_ascii\(\'xn\-\-09e669a6x8j\.\.xn\-\-ye6h\'\)\ throws\ error\ B6\ C2\ A4_2\ \[data\/IdnaTest\.txt\:1847\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᢇ\x{200D}\x{A8C4}｡︒𞤘", %p)},	undef,	"to_ascii\(\'ᢇ\\u200D\\uA8C4｡︒𞤘\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:1848\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--09e4694e.xn--y86cv562b", %p)},	undef,	"to_ascii\(\'xn\-\-09e4694e\.xn\-\-y86cv562b\'\)\ throws\ error\ B1\ V6\ \[data\/IdnaTest\.txt\:1850\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--09e669a6x8j.xn--y86cv562b", %p)},	undef,	"to_ascii\(\'xn\-\-09e669a6x8j\.xn\-\-y86cv562b\'\)\ throws\ error\ B1\ B6\ C2\ V6\ \[data\/IdnaTest\.txt\:1851\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𞩬򖙱\x{1714}\x{200C}｡\x{0631}\x{07AA}≮", %p)},	undef,	"to_ascii\(\'\?\?\\u1714\\u200C｡\\u0631\\u07AA\≮\'\)\ throws\ error\ B2\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:1852\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𞩬򖙱\x{1714}\x{200C}｡\x{0631}\x{07AA}<\x{0338}", %p)},	undef,	"to_ascii\(\'\?\?\\u1714\\u200C｡\\u0631\\u07AA\<\\u0338\'\)\ throws\ error\ B2\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:1854\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𞩬򖙱\x{1714}\x{200C}。\x{0631}\x{07AA}≮", %p)},	undef,	"to_ascii\(\'\?\?\\u1714\\u200C\。\\u0631\\u07AA\≮\'\)\ throws\ error\ B2\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:1856\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𞩬򖙱\x{1714}\x{200C}。\x{0631}\x{07AA}<\x{0338}", %p)},	undef,	"to_ascii\(\'\?\?\\u1714\\u200C\。\\u0631\\u07AA\<\\u0338\'\)\ throws\ error\ B2\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:1858\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--fze3930v7hz6b.xn--wgb86el10d", %p)},	undef,	"to_ascii\(\'xn\-\-fze3930v7hz6b\.xn\-\-wgb86el10d\'\)\ throws\ error\ B2\ B3\ V6\ \[data\/IdnaTest\.txt\:1860\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--fze607b9651bjwl7c.xn--wgb86el10d", %p)},	undef,	"to_ascii\(\'xn\-\-fze607b9651bjwl7c\.xn\-\-wgb86el10d\'\)\ throws\ error\ B2\ B3\ V6\ \[data\/IdnaTest\.txt\:1861\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴣ．\x{0653}ᢤ", %p)},	undef,	"to_ascii\(\'Ⴣ．\\u0653ᢤ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1862\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴣ.\x{0653}ᢤ", %p)},	undef,	"to_ascii\(\'Ⴣ\.\\u0653ᢤ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1863\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("ⴣ.\x{0653}ᢤ", %p)},	undef,	"to_ascii\(\'ⴣ\.\\u0653ᢤ\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:1864\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--rlj.xn--vhb294g", %p)},	undef,	"to_ascii\(\'xn\-\-rlj\.xn\-\-vhb294g\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:1865\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--7nd.xn--vhb294g", %p)},	undef,	"to_ascii\(\'xn\-\-7nd\.xn\-\-vhb294g\'\)\ throws\ error\ V5\ V6\ \[data\/IdnaTest\.txt\:1866\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("ⴣ．\x{0653}ᢤ", %p)},	undef,	"to_ascii\(\'ⴣ．\\u0653ᢤ\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:1867\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("󠄈\x{0813}．싉򄆻Ⴤ򂡐", %p)},	undef,	"to_ascii\(\'\󠄈\\u0813．싉\?Ⴤ\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1868\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠄈\x{0813}．싉򄆻Ⴤ򂡐", %p)},	undef,	"to_ascii\(\'\󠄈\\u0813．싉\?Ⴤ\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1869\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠄈\x{0813}.싉򄆻Ⴤ򂡐", %p)},	undef,	"to_ascii\(\'\󠄈\\u0813\.싉\?Ⴤ\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1870\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠄈\x{0813}.싉򄆻Ⴤ򂡐", %p)},	undef,	"to_ascii\(\'\󠄈\\u0813\.싉\?Ⴤ\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1871\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠄈\x{0813}.싉򄆻ⴤ򂡐", %p)},	undef,	"to_ascii\(\'\󠄈\\u0813\.싉\?ⴤ\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1872\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠄈\x{0813}.싉򄆻ⴤ򂡐", %p)},	undef,	"to_ascii\(\'\󠄈\\u0813\.싉\?ⴤ\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1873\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--oub.xn--sljz109bpe25dviva", %p)},	undef,	"to_ascii\(\'xn\-\-oub\.xn\-\-sljz109bpe25dviva\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:1874\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--oub.xn--8nd9522gpe69cviva", %p)},	undef,	"to_ascii\(\'xn\-\-oub\.xn\-\-8nd9522gpe69cviva\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:1875\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠄈\x{0813}．싉򄆻ⴤ򂡐", %p)},	undef,	"to_ascii\(\'\󠄈\\u0813．싉\?ⴤ\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1876\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠄈\x{0813}．싉򄆻ⴤ򂡐", %p)},	undef,	"to_ascii\(\'\󠄈\\u0813．싉\?ⴤ\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1877\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{AA2C}𑲫≮．⤂", %p)},	undef,	"to_ascii\(\'\\uAA2C𑲫\≮．\⤂\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1878\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{AA2C}𑲫<\x{0338}．⤂", %p)},	undef,	"to_ascii\(\'\\uAA2C𑲫\<\\u0338．\⤂\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1879\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{AA2C}𑲫≮.⤂", %p)},	undef,	"to_ascii\(\'\\uAA2C𑲫\≮\.\⤂\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1880\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{AA2C}𑲫<\x{0338}.⤂", %p)},	undef,	"to_ascii\(\'\\uAA2C𑲫\<\\u0338\.\⤂\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1881\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--gdh1854cn19c.xn--kqi", %p)},	undef,	"to_ascii\(\'xn\-\-gdh1854cn19c\.xn\-\-kqi\'\)\ throws\ error\ V5\ V6\ \[data\/IdnaTest\.txt\:1882\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0604}𐩔≮Ⴢ．Ⴃ", %p)},	undef,	"to_ascii\(\'\\u0604𐩔\≮Ⴢ．Ⴃ\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:1883\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0604}𐩔<\x{0338}Ⴢ．Ⴃ", %p)},	undef,	"to_ascii\(\'\\u0604𐩔\<\\u0338Ⴢ．Ⴃ\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:1884\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0604}𐩔≮Ⴢ.Ⴃ", %p)},	undef,	"to_ascii\(\'\\u0604𐩔\≮Ⴢ\.Ⴃ\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:1885\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0604}𐩔<\x{0338}Ⴢ.Ⴃ", %p)},	undef,	"to_ascii\(\'\\u0604𐩔\<\\u0338Ⴢ\.Ⴃ\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:1886\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0604}𐩔<\x{0338}ⴢ.ⴃ", %p)},	undef,	"to_ascii\(\'\\u0604𐩔\<\\u0338ⴢ\.ⴃ\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:1887\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0604}𐩔≮ⴢ.ⴃ", %p)},	undef,	"to_ascii\(\'\\u0604𐩔\≮ⴢ\.ⴃ\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:1888\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0604}𐩔≮Ⴢ.ⴃ", %p)},	undef,	"to_ascii\(\'\\u0604𐩔\≮Ⴢ\.ⴃ\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:1889\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0604}𐩔<\x{0338}Ⴢ.ⴃ", %p)},	undef,	"to_ascii\(\'\\u0604𐩔\<\\u0338Ⴢ\.ⴃ\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:1890\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--mfb416c0jox02t.xn--ukj", %p)},	undef,	"to_ascii\(\'xn\-\-mfb416c0jox02t\.xn\-\-ukj\'\)\ throws\ error\ B1\ V6\ \[data\/IdnaTest\.txt\:1891\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--mfb266l4khr54u.xn--ukj", %p)},	undef,	"to_ascii\(\'xn\-\-mfb266l4khr54u\.xn\-\-ukj\'\)\ throws\ error\ B1\ V6\ \[data\/IdnaTest\.txt\:1892\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--mfb416c0jox02t.xn--bnd", %p)},	undef,	"to_ascii\(\'xn\-\-mfb416c0jox02t\.xn\-\-bnd\'\)\ throws\ error\ B1\ V6\ \[data\/IdnaTest\.txt\:1893\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0604}𐩔<\x{0338}ⴢ．ⴃ", %p)},	undef,	"to_ascii\(\'\\u0604𐩔\<\\u0338ⴢ．ⴃ\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:1894\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0604}𐩔≮ⴢ．ⴃ", %p)},	undef,	"to_ascii\(\'\\u0604𐩔\≮ⴢ．ⴃ\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:1895\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0604}𐩔≮Ⴢ．ⴃ", %p)},	undef,	"to_ascii\(\'\\u0604𐩔\≮Ⴢ．ⴃ\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:1896\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0604}𐩔<\x{0338}Ⴢ．ⴃ", %p)},	undef,	"to_ascii\(\'\\u0604𐩔\<\\u0338Ⴢ．ⴃ\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:1897\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_ascii("𑁅。-", %p)},	undef,	"to_ascii\(\'𑁅\。\-\'\)\ throws\ error\ V3\ V5\ \[data\/IdnaTest\.txt\:1898\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--210d.-", %p)},	undef,	"to_ascii\(\'xn\-\-210d\.\-\'\)\ throws\ error\ V3\ V5\ \[data\/IdnaTest\.txt\:1899\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0DCA}򕸽󠧱｡饈≠\x{0664}", %p)},	undef,	"to_ascii\(\'\\u0DCA\?\?｡饈\≠\\u0664\'\)\ throws\ error\ B1\ B5\ B6\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1900\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0DCA}򕸽󠧱｡饈=\x{0338}\x{0664}", %p)},	undef,	"to_ascii\(\'\\u0DCA\?\?｡饈\=\\u0338\\u0664\'\)\ throws\ error\ B1\ B5\ B6\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1901\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0DCA}򕸽󠧱。饈≠\x{0664}", %p)},	undef,	"to_ascii\(\'\\u0DCA\?\?\。饈\≠\\u0664\'\)\ throws\ error\ B1\ B5\ B6\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1902\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0DCA}򕸽󠧱。饈=\x{0338}\x{0664}", %p)},	undef,	"to_ascii\(\'\\u0DCA\?\?\。饈\=\\u0338\\u0664\'\)\ throws\ error\ B1\ B5\ B6\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1903\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--h1c25913jfwov.xn--dib144ler5f", %p)},	undef,	"to_ascii\(\'xn\-\-h1c25913jfwov\.xn\-\-dib144ler5f\'\)\ throws\ error\ B1\ B5\ B6\ V5\ V6\ \[data\/IdnaTest\.txt\:1904\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𞥃ᠠ⁷｡≯邅⬻4", %p)},	undef,	"to_ascii\(\'𞥃ᠠ⁷｡\≯邅\⬻4\'\)\ throws\ error\ B1\ B2\ P1\ V6\ \[data\/IdnaTest\.txt\:1905\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𞥃ᠠ⁷｡>\x{0338}邅⬻4", %p)},	undef,	"to_ascii\(\'𞥃ᠠ⁷｡\>\\u0338邅\⬻4\'\)\ throws\ error\ B1\ B2\ P1\ V6\ \[data\/IdnaTest\.txt\:1906\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𞥃ᠠ7。≯邅⬻4", %p)},	undef,	"to_ascii\(\'𞥃ᠠ7\。\≯邅\⬻4\'\)\ throws\ error\ B1\ B2\ P1\ V6\ \[data\/IdnaTest\.txt\:1907\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𞥃ᠠ7。>\x{0338}邅⬻4", %p)},	undef,	"to_ascii\(\'𞥃ᠠ7\。\>\\u0338邅\⬻4\'\)\ throws\ error\ B1\ B2\ P1\ V6\ \[data\/IdnaTest\.txt\:1908\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𞤡ᠠ7。>\x{0338}邅⬻4", %p)},	undef,	"to_ascii\(\'𞤡ᠠ7\。\>\\u0338邅\⬻4\'\)\ throws\ error\ B1\ B2\ P1\ V6\ \[data\/IdnaTest\.txt\:1909\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𞤡ᠠ7。≯邅⬻4", %p)},	undef,	"to_ascii\(\'𞤡ᠠ7\。\≯邅\⬻4\'\)\ throws\ error\ B1\ B2\ P1\ V6\ \[data\/IdnaTest\.txt\:1910\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--7-v4j2826w.xn--4-ogoy01bou3i", %p)},	undef,	"to_ascii\(\'xn\-\-7\-v4j2826w\.xn\-\-4\-ogoy01bou3i\'\)\ throws\ error\ B1\ B2\ V6\ \[data\/IdnaTest\.txt\:1911\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𞤡ᠠ⁷｡>\x{0338}邅⬻4", %p)},	undef,	"to_ascii\(\'𞤡ᠠ⁷｡\>\\u0338邅\⬻4\'\)\ throws\ error\ B1\ B2\ P1\ V6\ \[data\/IdnaTest\.txt\:1912\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𞤡ᠠ⁷｡≯邅⬻4", %p)},	undef,	"to_ascii\(\'𞤡ᠠ⁷｡\≯邅\⬻4\'\)\ throws\ error\ B1\ B2\ P1\ V6\ \[data\/IdnaTest\.txt\:1913\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򠿯ᡳ-𑐻.𐹴𐋫\x{0605}󑎳", %p)},	undef,	"to_ascii\(\'\?ᡳ\-𑐻\.𐹴𐋫\\u0605\?\'\)\ throws\ error\ B1\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:1914\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----m9j3429kxmy7e.xn--nfb7950kdihrp812a", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-m9j3429kxmy7e\.xn\-\-nfb7950kdihrp812a\'\)\ throws\ error\ B1\ B6\ V6\ \[data\/IdnaTest\.txt\:1915\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򠶆\x{0845}\x{0A51}.넨-󶧈", %p)},	undef,	"to_ascii\(\'\?\\u0845\\u0A51\.넨\-\?\'\)\ throws\ error\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:1916\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򠶆\x{0845}\x{0A51}.넨-󶧈", %p)},	undef,	"to_ascii\(\'\?\\u0845\\u0A51\.넨\-\?\'\)\ throws\ error\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:1917\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--3vb26hb6834b.xn----i37ez0957g", %p)},	undef,	"to_ascii\(\'xn\-\-3vb26hb6834b\.xn\-\-\-\-i37ez0957g\'\)\ throws\ error\ B5\ B6\ V6\ \[data\/IdnaTest\.txt\:1918\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ꡦᡑ\x{200D}⒈。𐋣-", %p)},	undef,	"to_ascii\(\'ꡦᡑ\\u200D⒈\。𐋣\-\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:1919\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("ꡦᡑ\x{200D}1.。𐋣-", %p)},	undef,	"to_ascii\(\'ꡦᡑ\\u200D1\.\。𐋣\-\'\)\ throws\ error\ V3\ A4_2\ \[data\/IdnaTest\.txt\:1921\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--1-o7j0610f..xn----381i", %p)},	undef,	"to_ascii\(\'xn\-\-1\-o7j0610f\.\.xn\-\-\-\-381i\'\)\ throws\ error\ V3\ A4_2\ \[data\/IdnaTest\.txt\:1923\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--1-o7j663bdl7m..xn----381i", %p)},	undef,	"to_ascii\(\'xn\-\-1\-o7j663bdl7m\.\.xn\-\-\-\-381i\'\)\ throws\ error\ C2\ V3\ A4_2\ \[data\/IdnaTest\.txt\:1924\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--h8e863drj7h.xn----381i", %p)},	undef,	"to_ascii\(\'xn\-\-h8e863drj7h\.xn\-\-\-\-381i\'\)\ throws\ error\ V3\ V6\ \[data\/IdnaTest\.txt\:1925\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--h8e470bl0d838o.xn----381i", %p)},	undef,	"to_ascii\(\'xn\-\-h8e470bl0d838o\.xn\-\-\-\-381i\'\)\ throws\ error\ C2\ V3\ V6\ \[data\/IdnaTest\.txt\:1926\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴌ。􍼠\x{FB69}", %p)},	undef,	"to_ascii\(\'Ⴌ\。\?\\uFB69\'\)\ throws\ error\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:1927\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴌ。􍼠\x{0679}", %p)},	undef,	"to_ascii\(\'Ⴌ\。\?\\u0679\'\)\ throws\ error\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:1928\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⴌ。􍼠\x{0679}", %p)},	undef,	"to_ascii\(\'ⴌ\。\?\\u0679\'\)\ throws\ error\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:1929\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--3kj.xn--yib19191t", %p)},	undef,	"to_ascii\(\'xn\-\-3kj\.xn\-\-yib19191t\'\)\ throws\ error\ B5\ B6\ V6\ \[data\/IdnaTest\.txt\:1930\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--knd.xn--yib19191t", %p)},	undef,	"to_ascii\(\'xn\-\-knd\.xn\-\-yib19191t\'\)\ throws\ error\ B5\ B6\ V6\ \[data\/IdnaTest\.txt\:1931\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⴌ。􍼠\x{FB69}", %p)},	undef,	"to_ascii\(\'ⴌ\。\?\\uFB69\'\)\ throws\ error\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:1932\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐮁𐭱.\x{0F84}\x{135E}-\x{1CFA}", %p)},	undef,	"to_ascii\(\'𐮁𐭱\.\\u0F84\\u135E\-\\u1CFA\'\)\ throws\ error\ B1\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1933\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--r19c5a.xn----xjg270ag3m", %p)},	undef,	"to_ascii\(\'xn\-\-r19c5a\.xn\-\-\-\-xjg270ag3m\'\)\ throws\ error\ B1\ V5\ V6\ \[data\/IdnaTest\.txt\:1934\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⒈䰹\x{200D}-。웈", %p)},	undef,	"to_ascii\(\'⒈䰹\\u200D\-\。웈\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:1935\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⒈䰹\x{200D}-。웈", %p)},	undef,	"to_ascii\(\'⒈䰹\\u200D\-\。웈\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:1937\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("1.䰹\x{200D}-。웈", %p)},	undef,	"to_ascii\(\'1\.䰹\\u200D\-\。웈\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:1939\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("1.䰹\x{200D}-。웈", %p)},	undef,	"to_ascii\(\'1\.䰹\\u200D\-\。웈\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:1941\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("1.xn----zw5a.xn--kp5b", %p)},	undef,	"to_ascii\(\'1\.xn\-\-\-\-zw5a\.xn\-\-kp5b\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:1943\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("1.xn----tgnz80r.xn--kp5b", %p)},	undef,	"to_ascii\(\'1\.xn\-\-\-\-tgnz80r\.xn\-\-kp5b\'\)\ throws\ error\ C2\ V3\ \[data\/IdnaTest\.txt\:1944\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----dcp160o.xn--kp5b", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-dcp160o\.xn\-\-kp5b\'\)\ throws\ error\ V3\ V6\ \[data\/IdnaTest\.txt\:1945\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----tgnx5rjr6c.xn--kp5b", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-tgnx5rjr6c\.xn\-\-kp5b\'\)\ throws\ error\ C2\ V3\ V6\ \[data\/IdnaTest\.txt\:1946\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("て。\x{200C}󠳽\x{07F3}", %p)},	undef,	"to_ascii\(\'て\。\\u200C\?\\u07F3\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1947\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--m9j.xn--rtb10784p", %p)},	undef,	"to_ascii\(\'xn\-\-m9j\.xn\-\-rtb10784p\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:1949\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--m9j.xn--rtb154j9l73w", %p)},	undef,	"to_ascii\(\'xn\-\-m9j\.xn\-\-rtb154j9l73w\'\)\ throws\ error\ C1\ V6\ \[data\/IdnaTest\.txt\:1950\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("ς｡\x{A9C0}\x{06E7}", %p)},	undef,	"to_ascii\(\'ς｡\\uA9C0\\u06E7\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:1951\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("ς。\x{A9C0}\x{06E7}", %p)},	undef,	"to_ascii\(\'ς\。\\uA9C0\\u06E7\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:1953\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("Σ。\x{A9C0}\x{06E7}", %p)},	undef,	"to_ascii\(\'Σ\。\\uA9C0\\u06E7\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:1955\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("σ。\x{A9C0}\x{06E7}", %p)},	undef,	"to_ascii\(\'σ\。\\uA9C0\\u06E7\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:1956\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--4xa.xn--3lb1944f", %p)},	undef,	"to_ascii\(\'xn\-\-4xa\.xn\-\-3lb1944f\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:1957\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--3xa.xn--3lb1944f", %p)},	undef,	"to_ascii\(\'xn\-\-3xa\.xn\-\-3lb1944f\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:1958\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("Σ｡\x{A9C0}\x{06E7}", %p)},	undef,	"to_ascii\(\'Σ｡\\uA9C0\\u06E7\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:1959\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("σ｡\x{A9C0}\x{06E7}", %p)},	undef,	"to_ascii\(\'σ｡\\uA9C0\\u06E7\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:1960\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("\x{0BCD}󥫅򌉑.ႢႵ", %p)},	undef,	"to_ascii\(\'\\u0BCD\?\?\.ႢႵ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1961\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0BCD}󥫅򌉑.ⴂⴕ", %p)},	undef,	"to_ascii\(\'\\u0BCD\?\?\.ⴂⴕ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1962\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0BCD}󥫅򌉑.Ⴂⴕ", %p)},	undef,	"to_ascii\(\'\\u0BCD\?\?\.Ⴂⴕ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1963\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--xmc83135idcxza.xn--9md086l", %p)},	undef,	"to_ascii\(\'xn\-\-xmc83135idcxza\.xn\-\-9md086l\'\)\ throws\ error\ V5\ V6\ \[data\/IdnaTest\.txt\:1964\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--xmc83135idcxza.xn--tkjwb", %p)},	undef,	"to_ascii\(\'xn\-\-xmc83135idcxza\.xn\-\-tkjwb\'\)\ throws\ error\ V5\ V6\ \[data\/IdnaTest\.txt\:1965\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--xmc83135idcxza.xn--9md2b", %p)},	undef,	"to_ascii\(\'xn\-\-xmc83135idcxza\.xn\-\-9md2b\'\)\ throws\ error\ V5\ V6\ \[data\/IdnaTest\.txt\:1966\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1C32}🄈⾛\x{05A6}．\x{200D}򯥤\x{07FD}", %p)},	undef,	"to_ascii\(\'\\u1C32🄈⾛\\u05A6．\\u200D\?\\u07FD\'\)\ throws\ error\ B1\ B5\ B6\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1967\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1C32}7,走\x{05A6}.\x{200D}򯥤\x{07FD}", %p)},	undef,	"to_ascii\(\'\\u1C327\,走\\u05A6\.\\u200D\?\\u07FD\'\)\ throws\ error\ B1\ B5\ B6\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1969\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--7,-bid991urn3k.xn--1tb13454l", %p)},	undef,	"to_ascii\(\'xn\-\-7\,\-bid991urn3k\.xn\-\-1tb13454l\'\)\ throws\ error\ B1\ B5\ B6\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1971\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--7,-bid991urn3k.xn--1tb334j1197q", %p)},	undef,	"to_ascii\(\'xn\-\-7\,\-bid991urn3k\.xn\-\-1tb334j1197q\'\)\ throws\ error\ B1\ C2\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1972\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--xcb756i493fwi5o.xn--1tb13454l", %p)},	undef,	"to_ascii\(\'xn\-\-xcb756i493fwi5o\.xn\-\-1tb13454l\'\)\ throws\ error\ B1\ B5\ B6\ V5\ V6\ \[data\/IdnaTest\.txt\:1973\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--xcb756i493fwi5o.xn--1tb334j1197q", %p)},	undef,	"to_ascii\(\'xn\-\-xcb756i493fwi5o\.xn\-\-1tb334j1197q\'\)\ throws\ error\ B1\ C2\ V5\ V6\ \[data\/IdnaTest\.txt\:1974\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᢗ｡Ӏ񝄻", %p)},	undef,	"to_ascii\(\'ᢗ｡Ӏ\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1975\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᢗ。Ӏ񝄻", %p)},	undef,	"to_ascii\(\'ᢗ\。Ӏ\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1976\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᢗ。ӏ񝄻", %p)},	undef,	"to_ascii\(\'ᢗ\。ӏ\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1977\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--hbf.xn--s5a83117e", %p)},	undef,	"to_ascii\(\'xn\-\-hbf\.xn\-\-s5a83117e\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:1978\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--hbf.xn--d5a86117e", %p)},	undef,	"to_ascii\(\'xn\-\-hbf\.xn\-\-d5a86117e\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:1979\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᢗ｡ӏ񝄻", %p)},	undef,	"to_ascii\(\'ᢗ｡ӏ\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1980\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0668}-。񠏇🝆ᄾ", %p)},	undef,	"to_ascii\(\'\\u0668\-\。\?🝆ᄾ\'\)\ throws\ error\ B1\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:1981\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----oqc.xn--qrd1699v327w", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-oqc\.xn\-\-qrd1699v327w\'\)\ throws\ error\ B1\ V3\ V6\ \[data\/IdnaTest\.txt\:1982\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("-𐋷𖾑。󠆬", %p)},	undef,	"to_ascii\(\'\-𐋷𖾑\。\󠆬\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:1983\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn----991iq40y.", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-991iq40y\.\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:1984\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}𐹳🐴멈.\x{ABED}񐡼", %p)},	undef,	"to_ascii\(\'\\u200C𐹳🐴멈\.\\uABED\?\'\)\ throws\ error\ B1\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1985\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}𐹳🐴멈.\x{ABED}񐡼", %p)},	undef,	"to_ascii\(\'\\u200C𐹳🐴멈\.\\uABED\?\'\)\ throws\ error\ B1\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1987\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--422b325mqb6i.xn--429a8682s", %p)},	undef,	"to_ascii\(\'xn\-\-422b325mqb6i\.xn\-\-429a8682s\'\)\ throws\ error\ B1\ V5\ V6\ \[data\/IdnaTest\.txt\:1989\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--0ug6681d406b7bwk.xn--429a8682s", %p)},	undef,	"to_ascii\(\'xn\-\-0ug6681d406b7bwk\.xn\-\-429a8682s\'\)\ throws\ error\ B1\ C1\ V5\ V6\ \[data\/IdnaTest\.txt\:1990\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≮.\x{0769}\x{0603}", %p)},	undef,	"to_ascii\(\'\≮\.\\u0769\\u0603\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:1991\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("<\x{0338}.\x{0769}\x{0603}", %p)},	undef,	"to_ascii\(\'\<\\u0338\.\\u0769\\u0603\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:1992\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--gdh.xn--lfb92e", %p)},	undef,	"to_ascii\(\'xn\-\-gdh\.xn\-\-lfb92e\'\)\ throws\ error\ B1\ V6\ \[data\/IdnaTest\.txt\:1993\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐶭⾆｡\x{200C}𑚶򟱃𞰘", %p)},	undef,	"to_ascii\(\'\?⾆｡\\u200C𑚶\?\?\'\)\ throws\ error\ B2\ B3\ B5\ B6\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1994\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐶭舌。\x{200C}𑚶򟱃𞰘", %p)},	undef,	"to_ascii\(\'\?舌\。\\u200C𑚶\?\?\'\)\ throws\ error\ B2\ B3\ B5\ B6\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1996\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--tc1ao37z.xn--6e2dw557azds2d", %p)},	undef,	"to_ascii\(\'xn\-\-tc1ao37z\.xn\-\-6e2dw557azds2d\'\)\ throws\ error\ B2\ B3\ B5\ B6\ V5\ V6\ \[data\/IdnaTest\.txt\:1998\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--tc1ao37z.xn--0ugx728gi1nfwqz2e", %p)},	undef,	"to_ascii\(\'xn\-\-tc1ao37z\.xn\-\-0ugx728gi1nfwqz2e\'\)\ throws\ error\ B1\ B2\ B3\ C1\ V6\ \[data\/IdnaTest\.txt\:1999\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}Ⴠ-.𝟷ς𞴺ς", %p)},	undef,	"to_ascii\(\'\\u200CჀ\-\.𝟷ς𞴺ς\'\)\ throws\ error\ B1\ B6\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:2000\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}Ⴠ-.1ς𞴺ς", %p)},	undef,	"to_ascii\(\'\\u200CჀ\-\.1ς𞴺ς\'\)\ throws\ error\ B1\ B6\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:2002\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}ⴠ-.1ς𞴺ς", %p)},	undef,	"to_ascii\(\'\\u200Cⴠ\-\.1ς𞴺ς\'\)\ throws\ error\ B1\ B6\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:2004\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}Ⴠ-.1Σ𞴺Σ", %p)},	undef,	"to_ascii\(\'\\u200CჀ\-\.1Σ𞴺Σ\'\)\ throws\ error\ B1\ B6\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:2006\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}ⴠ-.1σ𞴺σ", %p)},	undef,	"to_ascii\(\'\\u200Cⴠ\-\.1σ𞴺σ\'\)\ throws\ error\ B1\ B6\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:2008\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----2ws.xn--1-0mba52321c", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-2ws\.xn\-\-1\-0mba52321c\'\)\ throws\ error\ B1\ B6\ V3\ V6\ \[data\/IdnaTest\.txt\:2010\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----rgn530d.xn--1-0mba52321c", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-rgn530d\.xn\-\-1\-0mba52321c\'\)\ throws\ error\ B1\ C1\ V3\ V6\ \[data\/IdnaTest\.txt\:2011\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----z1g.xn--1-0mba52321c", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-z1g\.xn\-\-1\-0mba52321c\'\)\ throws\ error\ B1\ B6\ V3\ V6\ \[data\/IdnaTest\.txt\:2012\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----z1g168i.xn--1-0mba52321c", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-z1g168i\.xn\-\-1\-0mba52321c\'\)\ throws\ error\ B1\ C1\ V3\ V6\ \[data\/IdnaTest\.txt\:2013\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----rgn530d.xn--1-ymba92321c", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-rgn530d\.xn\-\-1\-ymba92321c\'\)\ throws\ error\ B1\ C1\ V3\ V6\ \[data\/IdnaTest\.txt\:2014\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----z1g168i.xn--1-ymba92321c", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-z1g168i\.xn\-\-1\-ymba92321c\'\)\ throws\ error\ B1\ C1\ V3\ V6\ \[data\/IdnaTest\.txt\:2015\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}ⴠ-.𝟷ς𞴺ς", %p)},	undef,	"to_ascii\(\'\\u200Cⴠ\-\.𝟷ς𞴺ς\'\)\ throws\ error\ B1\ B6\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:2016\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}Ⴠ-.𝟷Σ𞴺Σ", %p)},	undef,	"to_ascii\(\'\\u200CჀ\-\.𝟷Σ𞴺Σ\'\)\ throws\ error\ B1\ B6\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:2018\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}ⴠ-.𝟷σ𞴺σ", %p)},	undef,	"to_ascii\(\'\\u200Cⴠ\-\.𝟷σ𞴺σ\'\)\ throws\ error\ B1\ B6\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:2020\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𑲘󠄒𓑡｡𝟪Ⴜ", %p)},	undef,	"to_ascii\(\'𑲘\󠄒\?｡𝟪Ⴜ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2022\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𑲘󠄒𓑡。8Ⴜ", %p)},	undef,	"to_ascii\(\'𑲘\󠄒\?\。8Ⴜ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2023\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𑲘󠄒𓑡。8ⴜ", %p)},	undef,	"to_ascii\(\'𑲘\󠄒\?\。8ⴜ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2024\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--7m3d291b.xn--8-vws", %p)},	undef,	"to_ascii\(\'xn\-\-7m3d291b\.xn\-\-8\-vws\'\)\ throws\ error\ V5\ V6\ \[data\/IdnaTest\.txt\:2025\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--7m3d291b.xn--8-s1g", %p)},	undef,	"to_ascii\(\'xn\-\-7m3d291b\.xn\-\-8\-s1g\'\)\ throws\ error\ V5\ V6\ \[data\/IdnaTest\.txt\:2026\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𑲘󠄒𓑡｡𝟪ⴜ", %p)},	undef,	"to_ascii\(\'𑲘\󠄒\?｡𝟪ⴜ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2027\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_ascii("䪏\x{06AB}\x{07E0}\x{0941}｡뭕ᢝ\x{17B9}", %p)},	undef,	"to_ascii\(\'䪏\\u06AB\\u07E0\\u0941｡뭕ᢝ\\u17B9\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:2028\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_ascii("䪏\x{06AB}\x{07E0}\x{0941}｡뭕ᢝ\x{17B9}", %p)},	undef,	"to_ascii\(\'䪏\\u06AB\\u07E0\\u0941｡뭕ᢝ\\u17B9\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:2029\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_ascii("䪏\x{06AB}\x{07E0}\x{0941}。뭕ᢝ\x{17B9}", %p)},	undef,	"to_ascii\(\'䪏\\u06AB\\u07E0\\u0941\。뭕ᢝ\\u17B9\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:2030\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_ascii("䪏\x{06AB}\x{07E0}\x{0941}。뭕ᢝ\x{17B9}", %p)},	undef,	"to_ascii\(\'䪏\\u06AB\\u07E0\\u0941\。뭕ᢝ\\u17B9\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:2031\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--ekb23dj4at01n.xn--43e96bh910b", %p)},	undef,	"to_ascii\(\'xn\-\-ekb23dj4at01n\.xn\-\-43e96bh910b\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:2032\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1BAB}｡🂉󠁰", %p)},	undef,	"to_ascii\(\'\\u1BAB｡🂉\?\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2033\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1BAB}。🂉󠁰", %p)},	undef,	"to_ascii\(\'\\u1BAB\。🂉\?\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2034\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--zxf.xn--fx7ho0250c", %p)},	undef,	"to_ascii\(\'xn\-\-zxf\.xn\-\-fx7ho0250c\'\)\ throws\ error\ V5\ V6\ \[data\/IdnaTest\.txt\:2035\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󩎃\x{0AC4}。ς\x{200D}𐹮𑈵", %p)},	undef,	"to_ascii\(\'\?\\u0AC4\。ς\\u200D𐹮𑈵\'\)\ throws\ error\ B5\ P1\ V6\ \[data\/IdnaTest\.txt\:2036\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󩎃\x{0AC4}。Σ\x{200D}𐹮𑈵", %p)},	undef,	"to_ascii\(\'\?\\u0AC4\。Σ\\u200D𐹮𑈵\'\)\ throws\ error\ B5\ P1\ V6\ \[data\/IdnaTest\.txt\:2038\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󩎃\x{0AC4}。σ\x{200D}𐹮𑈵", %p)},	undef,	"to_ascii\(\'\?\\u0AC4\。σ\\u200D𐹮𑈵\'\)\ throws\ error\ B5\ P1\ V6\ \[data\/IdnaTest\.txt\:2040\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--dfc53161q.xn--4xa8467k5mc", %p)},	undef,	"to_ascii\(\'xn\-\-dfc53161q\.xn\-\-4xa8467k5mc\'\)\ throws\ error\ B5\ V6\ \[data\/IdnaTest\.txt\:2042\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--dfc53161q.xn--4xa895lzo7nsfd", %p)},	undef,	"to_ascii\(\'xn\-\-dfc53161q\.xn\-\-4xa895lzo7nsfd\'\)\ throws\ error\ B5\ C2\ V6\ \[data\/IdnaTest\.txt\:2043\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--dfc53161q.xn--3xa006lzo7nsfd", %p)},	undef,	"to_ascii\(\'xn\-\-dfc53161q\.xn\-\-3xa006lzo7nsfd\'\)\ throws\ error\ B5\ C2\ V6\ \[data\/IdnaTest\.txt\:2044\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_ascii("𐫀ᡂ𑜫．𑘿", %p)},	undef,	"to_ascii\(\'𐫀ᡂ𑜫．𑘿\'\)\ throws\ error\ B1\ B2\ B3\ B6\ V5\ \[data\/IdnaTest\.txt\:2045\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_ascii("𐫀ᡂ𑜫.𑘿", %p)},	undef,	"to_ascii\(\'𐫀ᡂ𑜫\.𑘿\'\)\ throws\ error\ B1\ B2\ B3\ B6\ V5\ \[data\/IdnaTest\.txt\:2046\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--17e9625js1h.xn--sb2d", %p)},	undef,	"to_ascii\(\'xn\-\-17e9625js1h\.xn\-\-sb2d\'\)\ throws\ error\ B1\ B2\ B3\ B6\ V5\ \[data\/IdnaTest\.txt\:2047\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󬚶󸋖򖩰-。\x{200C}", %p)},	undef,	"to_ascii\(\'\?\?\?\-\。\\u200C\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:2048\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----7i12hu122k9ire.", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-7i12hu122k9ire\.\'\)\ throws\ error\ V3\ V6\ \[data\/IdnaTest\.txt\:2050\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----7i12hu122k9ire.xn--0ug", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-7i12hu122k9ire\.xn\-\-0ug\'\)\ throws\ error\ C1\ V3\ V6\ \[data\/IdnaTest\.txt\:2051\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("𐹣．\x{07C2}", %p)},	undef,	"to_ascii\(\'𐹣．\\u07C2\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:2052\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("𐹣.\x{07C2}", %p)},	undef,	"to_ascii\(\'𐹣\.\\u07C2\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:2053\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--bo0d.xn--dsb", %p)},	undef,	"to_ascii\(\'xn\-\-bo0d\.xn\-\-dsb\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:2054\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-\x{07E1}｡Ↄ", %p)},	undef,	"to_ascii\(\'\-\\u07E1｡Ↄ\'\)\ throws\ error\ B1\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:2055\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-\x{07E1}。Ↄ", %p)},	undef,	"to_ascii\(\'\-\\u07E1\。Ↄ\'\)\ throws\ error\ B1\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:2056\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_ascii("-\x{07E1}。ↄ", %p)},	undef,	"to_ascii\(\'\-\\u07E1\。ↄ\'\)\ throws\ error\ B1\ V3\ \[data\/IdnaTest\.txt\:2057\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn----8cd.xn--r5g", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-8cd\.xn\-\-r5g\'\)\ throws\ error\ B1\ V3\ \[data\/IdnaTest\.txt\:2058\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----8cd.xn--q5g", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-8cd\.xn\-\-q5g\'\)\ throws\ error\ B1\ V3\ V6\ \[data\/IdnaTest\.txt\:2059\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_ascii("-\x{07E1}｡ↄ", %p)},	undef,	"to_ascii\(\'\-\\u07E1｡ↄ\'\)\ throws\ error\ B1\ V3\ \[data\/IdnaTest\.txt\:2060\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("\x{200D}-︒󠄄。ß哑\x{200C}𐵿", %p)},	undef,	"to_ascii\(\'\\u200D\-︒\󠄄\。ß哑\\u200C\?\'\)\ throws\ error\ B1\ B5\ B6\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:2061\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}-。󠄄。ß哑\x{200C}𐵿", %p)},	undef,	"to_ascii\(\'\\u200D\-\。\󠄄\。ß哑\\u200C\?\'\)\ throws\ error\ B1\ B5\ B6\ P1\ V3\ V6\ A4_2\ \[data\/IdnaTest\.txt\:2063\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}-。󠄄。SS哑\x{200C}𐵿", %p)},	undef,	"to_ascii\(\'\\u200D\-\。\󠄄\。SS哑\\u200C\?\'\)\ throws\ error\ B1\ B5\ B6\ P1\ V3\ V6\ A4_2\ \[data\/IdnaTest\.txt\:2065\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}-。󠄄。ss哑\x{200C}𐵿", %p)},	undef,	"to_ascii\(\'\\u200D\-\。\󠄄\。ss哑\\u200C\?\'\)\ throws\ error\ B1\ B5\ B6\ P1\ V3\ V6\ A4_2\ \[data\/IdnaTest\.txt\:2067\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}-。󠄄。Ss哑\x{200C}𐵿", %p)},	undef,	"to_ascii\(\'\\u200D\-\。\󠄄\。Ss哑\\u200C\?\'\)\ throws\ error\ B1\ B5\ B6\ P1\ V3\ V6\ A4_2\ \[data\/IdnaTest\.txt\:2069\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-..xn--ss-h46c5711e", %p)},	undef,	"to_ascii\(\'\-\.\.xn\-\-ss\-h46c5711e\'\)\ throws\ error\ B1\ B5\ B6\ V3\ V6\ A4_2\ \[data\/IdnaTest\.txt\:2071\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----tgn..xn--ss-k1ts75zb8ym", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-tgn\.\.xn\-\-ss\-k1ts75zb8ym\'\)\ throws\ error\ B1\ B5\ B6\ C1\ C2\ V3\ V6\ A4_2\ \[data\/IdnaTest\.txt\:2072\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----tgn..xn--zca670n5f0binyk", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-tgn\.\.xn\-\-zca670n5f0binyk\'\)\ throws\ error\ B1\ B5\ B6\ C1\ C2\ V3\ V6\ A4_2\ \[data\/IdnaTest\.txt\:2073\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}-︒󠄄。SS哑\x{200C}𐵿", %p)},	undef,	"to_ascii\(\'\\u200D\-︒\󠄄\。SS哑\\u200C\?\'\)\ throws\ error\ B1\ B5\ B6\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:2074\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}-︒󠄄。ss哑\x{200C}𐵿", %p)},	undef,	"to_ascii\(\'\\u200D\-︒\󠄄\。ss哑\\u200C\?\'\)\ throws\ error\ B1\ B5\ B6\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:2076\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}-︒󠄄。Ss哑\x{200C}𐵿", %p)},	undef,	"to_ascii\(\'\\u200D\-︒\󠄄\。Ss哑\\u200C\?\'\)\ throws\ error\ B1\ B5\ B6\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:2078\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----o89h.xn--ss-h46c5711e", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-o89h\.xn\-\-ss\-h46c5711e\'\)\ throws\ error\ B1\ B5\ B6\ V3\ V6\ \[data\/IdnaTest\.txt\:2080\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----tgnt341h.xn--ss-k1ts75zb8ym", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-tgnt341h\.xn\-\-ss\-k1ts75zb8ym\'\)\ throws\ error\ B1\ B5\ B6\ C1\ C2\ V6\ \[data\/IdnaTest\.txt\:2081\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----tgnt341h.xn--zca670n5f0binyk", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-tgnt341h\.xn\-\-zca670n5f0binyk\'\)\ throws\ error\ B1\ B5\ B6\ C1\ C2\ V6\ \[data\/IdnaTest\.txt\:2082\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("︒．\x{FE2F}𑑂", %p)},	undef,	"to_ascii\(\'︒．\\uFE2F𑑂\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2083\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("︒．𑑂\x{FE2F}", %p)},	undef,	"to_ascii\(\'︒．𑑂\\uFE2F\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2084\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("。.𑑂\x{FE2F}", %p)},	undef,	"to_ascii\(\'\。\.𑑂\\uFE2F\'\)\ throws\ error\ V5\ A4_2\ \[data\/IdnaTest\.txt\:2085\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("..xn--s96cu30b", %p)},	undef,	"to_ascii\(\'\.\.xn\-\-s96cu30b\'\)\ throws\ error\ V5\ A4_2\ \[data\/IdnaTest\.txt\:2086\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--y86c.xn--s96cu30b", %p)},	undef,	"to_ascii\(\'xn\-\-y86c\.xn\-\-s96cu30b\'\)\ throws\ error\ V5\ V6\ \[data\/IdnaTest\.txt\:2087\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_ascii("\x{A92C}。\x{200D}", %p)},	undef,	"to_ascii\(\'\\uA92C\。\\u200D\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:2088\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--zi9a.", %p)},	undef,	"to_ascii\(\'xn\-\-zi9a\.\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:2090\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--zi9a.xn--1ug", %p)},	undef,	"to_ascii\(\'xn\-\-zi9a\.xn\-\-1ug\'\)\ throws\ error\ C2\ V5\ \[data\/IdnaTest\.txt\:2091\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}󠸡｡\x{FCD7}", %p)},	undef,	"to_ascii\(\'\\u200D\?｡\\uFCD7\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:2092\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}󠸡。\x{0647}\x{062C}", %p)},	undef,	"to_ascii\(\'\\u200D\?\。\\u0647\\u062C\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:2094\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--d356e.xn--rgb7c", %p)},	undef,	"to_ascii\(\'xn\-\-d356e\.xn\-\-rgb7c\'\)\ throws\ error\ B1\ V6\ \[data\/IdnaTest\.txt\:2096\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--1ug80651l.xn--rgb7c", %p)},	undef,	"to_ascii\(\'xn\-\-1ug80651l\.xn\-\-rgb7c\'\)\ throws\ error\ B1\ C2\ V6\ \[data\/IdnaTest\.txt\:2097\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-Ⴄ𝟢\x{0663}．𑍴ς", %p)},	undef,	"to_ascii\(\'\-Ⴄ𝟢\\u0663．𑍴ς\'\)\ throws\ error\ B1\ P1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:2098\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-Ⴄ0\x{0663}.𑍴ς", %p)},	undef,	"to_ascii\(\'\-Ⴄ0\\u0663\.𑍴ς\'\)\ throws\ error\ B1\ P1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:2100\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("-ⴄ0\x{0663}.𑍴ς", %p)},	undef,	"to_ascii\(\'\-ⴄ0\\u0663\.𑍴ς\'\)\ throws\ error\ B1\ V3\ V5\ \[data\/IdnaTest\.txt\:2102\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("-Ⴄ0\x{0663}.𑍴Σ", %p)},	undef,	"to_ascii\(\'\-Ⴄ0\\u0663\.𑍴Σ\'\)\ throws\ error\ B1\ P1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:2104\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("-ⴄ0\x{0663}.𑍴σ", %p)},	undef,	"to_ascii\(\'\-ⴄ0\\u0663\.𑍴σ\'\)\ throws\ error\ B1\ V3\ V5\ \[data\/IdnaTest\.txt\:2105\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn---0-iyd8660b.xn--4xa9120l", %p)},	undef,	"to_ascii\(\'xn\-\-\-0\-iyd8660b\.xn\-\-4xa9120l\'\)\ throws\ error\ B1\ V3\ V5\ \[data\/IdnaTest\.txt\:2106\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn---0-iyd216h.xn--4xa9120l", %p)},	undef,	"to_ascii\(\'xn\-\-\-0\-iyd216h\.xn\-\-4xa9120l\'\)\ throws\ error\ B1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:2107\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn---0-iyd8660b.xn--3xa1220l", %p)},	undef,	"to_ascii\(\'xn\-\-\-0\-iyd8660b\.xn\-\-3xa1220l\'\)\ throws\ error\ B1\ V3\ V5\ \[data\/IdnaTest\.txt\:2108\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn---0-iyd216h.xn--3xa1220l", %p)},	undef,	"to_ascii\(\'xn\-\-\-0\-iyd216h\.xn\-\-3xa1220l\'\)\ throws\ error\ B1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:2109\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("-ⴄ𝟢\x{0663}．𑍴ς", %p)},	undef,	"to_ascii\(\'\-ⴄ𝟢\\u0663．𑍴ς\'\)\ throws\ error\ B1\ V3\ V5\ \[data\/IdnaTest\.txt\:2110\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("-Ⴄ𝟢\x{0663}．𑍴Σ", %p)},	undef,	"to_ascii\(\'\-Ⴄ𝟢\\u0663．𑍴Σ\'\)\ throws\ error\ B1\ P1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:2112\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("-ⴄ𝟢\x{0663}．𑍴σ", %p)},	undef,	"to_ascii\(\'\-ⴄ𝟢\\u0663．𑍴σ\'\)\ throws\ error\ B1\ V3\ V5\ \[data\/IdnaTest\.txt\:2113\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("󦈄。-", %p)},	undef,	"to_ascii\(\'\?\。\-\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:2114\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--xm38e.-", %p)},	undef,	"to_ascii\(\'xn\-\-xm38e\.\-\'\)\ throws\ error\ V3\ V6\ \[data\/IdnaTest\.txt\:2115\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⋠𐋮．򶈮\x{0F18}ß≯", %p)},	undef,	"to_ascii\(\'\⋠𐋮．\?\\u0F18ß\≯\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2116\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≼\x{0338}𐋮．򶈮\x{0F18}ß>\x{0338}", %p)},	undef,	"to_ascii\(\'\≼\\u0338𐋮．\?\\u0F18ß\>\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2118\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⋠𐋮.򶈮\x{0F18}ß≯", %p)},	undef,	"to_ascii\(\'\⋠𐋮\.\?\\u0F18ß\≯\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2120\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≼\x{0338}𐋮.򶈮\x{0F18}ß>\x{0338}", %p)},	undef,	"to_ascii\(\'\≼\\u0338𐋮\.\?\\u0F18ß\>\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2122\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≼\x{0338}𐋮.򶈮\x{0F18}SS>\x{0338}", %p)},	undef,	"to_ascii\(\'\≼\\u0338𐋮\.\?\\u0F18SS\>\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2124\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⋠𐋮.򶈮\x{0F18}SS≯", %p)},	undef,	"to_ascii\(\'\⋠𐋮\.\?\\u0F18SS\≯\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2125\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⋠𐋮.򶈮\x{0F18}ss≯", %p)},	undef,	"to_ascii\(\'\⋠𐋮\.\?\\u0F18ss\≯\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2126\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≼\x{0338}𐋮.򶈮\x{0F18}ss>\x{0338}", %p)},	undef,	"to_ascii\(\'\≼\\u0338𐋮\.\?\\u0F18ss\>\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2127\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≼\x{0338}𐋮.򶈮\x{0F18}Ss>\x{0338}", %p)},	undef,	"to_ascii\(\'\≼\\u0338𐋮\.\?\\u0F18Ss\>\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2128\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⋠𐋮.򶈮\x{0F18}Ss≯", %p)},	undef,	"to_ascii\(\'\⋠𐋮\.\?\\u0F18Ss\≯\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2129\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--pgh4639f.xn--ss-ifj426nle504a", %p)},	undef,	"to_ascii\(\'xn\-\-pgh4639f\.xn\-\-ss\-ifj426nle504a\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:2130\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--pgh4639f.xn--zca593eo6oc013y", %p)},	undef,	"to_ascii\(\'xn\-\-pgh4639f\.xn\-\-zca593eo6oc013y\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:2131\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≼\x{0338}𐋮．򶈮\x{0F18}SS>\x{0338}", %p)},	undef,	"to_ascii\(\'\≼\\u0338𐋮．\?\\u0F18SS\>\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2132\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⋠𐋮．򶈮\x{0F18}SS≯", %p)},	undef,	"to_ascii\(\'\⋠𐋮．\?\\u0F18SS\≯\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2133\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⋠𐋮．򶈮\x{0F18}ss≯", %p)},	undef,	"to_ascii\(\'\⋠𐋮．\?\\u0F18ss\≯\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2134\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≼\x{0338}𐋮．򶈮\x{0F18}ss>\x{0338}", %p)},	undef,	"to_ascii\(\'\≼\\u0338𐋮．\?\\u0F18ss\>\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2135\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≼\x{0338}𐋮．򶈮\x{0F18}Ss>\x{0338}", %p)},	undef,	"to_ascii\(\'\≼\\u0338𐋮．\?\\u0F18Ss\>\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2136\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⋠𐋮．򶈮\x{0F18}Ss≯", %p)},	undef,	"to_ascii\(\'\⋠𐋮．\?\\u0F18Ss\≯\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2137\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("1𐋸\x{0664}｡󠢮\x{FBA4}񷝊", %p)},	undef,	"to_ascii\(\'1𐋸\\u0664｡\?\\uFBA4\?\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:2138\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("1𐋸\x{0664}。󠢮\x{06C0}񷝊", %p)},	undef,	"to_ascii\(\'1𐋸\\u0664\。\?\\u06C0\?\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:2139\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("1𐋸\x{0664}。󠢮\x{06D5}\x{0654}񷝊", %p)},	undef,	"to_ascii\(\'1𐋸\\u0664\。\?\\u06D5\\u0654\?\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:2140\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--1-hqc3905q.xn--zkb83268gqee4a", %p)},	undef,	"to_ascii\(\'xn\-\-1\-hqc3905q\.xn\-\-zkb83268gqee4a\'\)\ throws\ error\ B1\ V6\ \[data\/IdnaTest\.txt\:2141\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("儭-｡𐹴Ⴢ񥳠\x{200C}", %p)},	undef,	"to_ascii\(\'儭\-｡𐹴Ⴢ\?\\u200C\'\)\ throws\ error\ B1\ B6\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:2142\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("儭-。𐹴Ⴢ񥳠\x{200C}", %p)},	undef,	"to_ascii\(\'儭\-\。𐹴Ⴢ\?\\u200C\'\)\ throws\ error\ B1\ B6\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:2144\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("儭-。𐹴ⴢ񥳠\x{200C}", %p)},	undef,	"to_ascii\(\'儭\-\。𐹴ⴢ\?\\u200C\'\)\ throws\ error\ B1\ B6\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:2146\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----gz7a.xn--qlj9223eywx0b", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-gz7a\.xn\-\-qlj9223eywx0b\'\)\ throws\ error\ B1\ B6\ V3\ V6\ \[data\/IdnaTest\.txt\:2148\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----gz7a.xn--0ug472cfq0pus98b", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-gz7a\.xn\-\-0ug472cfq0pus98b\'\)\ throws\ error\ B1\ B6\ C1\ V3\ V6\ \[data\/IdnaTest\.txt\:2149\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----gz7a.xn--6nd5001kyw98a", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-gz7a\.xn\-\-6nd5001kyw98a\'\)\ throws\ error\ B1\ B6\ V3\ V6\ \[data\/IdnaTest\.txt\:2150\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----gz7a.xn--6nd249ejl4pusr7b", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-gz7a\.xn\-\-6nd249ejl4pusr7b\'\)\ throws\ error\ B1\ B6\ C1\ V3\ V6\ \[data\/IdnaTest\.txt\:2151\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("儭-｡𐹴ⴢ񥳠\x{200C}", %p)},	undef,	"to_ascii\(\'儭\-｡𐹴ⴢ\?\\u200C\'\)\ throws\ error\ B1\ B6\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:2152\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𝟺𐋷\x{06B9}．𞤭򿍡", %p)},	undef,	"to_ascii\(\'𝟺𐋷\\u06B9．𞤭\?\'\)\ throws\ error\ B1\ B2\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:2154\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("4𐋷\x{06B9}.𞤭򿍡", %p)},	undef,	"to_ascii\(\'4𐋷\\u06B9\.𞤭\?\'\)\ throws\ error\ B1\ B2\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:2155\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("4𐋷\x{06B9}.𞤋򿍡", %p)},	undef,	"to_ascii\(\'4𐋷\\u06B9\.𞤋\?\'\)\ throws\ error\ B1\ B2\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:2156\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--4-cvc5384q.xn--le6hi7322b", %p)},	undef,	"to_ascii\(\'xn\-\-4\-cvc5384q\.xn\-\-le6hi7322b\'\)\ throws\ error\ B1\ B2\ B3\ V6\ \[data\/IdnaTest\.txt\:2157\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𝟺𐋷\x{06B9}．𞤋򿍡", %p)},	undef,	"to_ascii\(\'𝟺𐋷\\u06B9．𞤋\?\'\)\ throws\ error\ B1\ B2\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:2158\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≯-ꡋ𑲣.⒈𐹭", %p)},	undef,	"to_ascii\(\'\≯\-ꡋ𑲣\.⒈𐹭\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:2159\]") or ($@ and diag($@));
is(eval{uts46_to_ascii(">\x{0338}-ꡋ𑲣.⒈𐹭", %p)},	undef,	"to_ascii\(\'\>\\u0338\-ꡋ𑲣\.⒈𐹭\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:2160\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≯-ꡋ𑲣.1.𐹭", %p)},	undef,	"to_ascii\(\'\≯\-ꡋ𑲣\.1\.𐹭\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:2161\]") or ($@ and diag($@));
is(eval{uts46_to_ascii(">\x{0338}-ꡋ𑲣.1.𐹭", %p)},	undef,	"to_ascii\(\'\>\\u0338\-ꡋ𑲣\.1\.𐹭\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:2162\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----ogox061d5i8d.1.xn--lo0d", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-ogox061d5i8d\.1\.xn\-\-lo0d\'\)\ throws\ error\ B1\ V6\ \[data\/IdnaTest\.txt\:2163\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----ogox061d5i8d.xn--tsh0666f", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-ogox061d5i8d\.xn\-\-tsh0666f\'\)\ throws\ error\ B1\ V6\ \[data\/IdnaTest\.txt\:2164\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0330}．󰜱蚀", %p)},	undef,	"to_ascii\(\'\\u0330．\?蚀\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2165\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0330}.󰜱蚀", %p)},	undef,	"to_ascii\(\'\\u0330\.\?蚀\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2166\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--xta.xn--e91aw9417e", %p)},	undef,	"to_ascii\(\'xn\-\-xta\.xn\-\-e91aw9417e\'\)\ throws\ error\ V5\ V6\ \[data\/IdnaTest\.txt\:2167\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{FB39}Ⴘ.𞡼𑇀ß\x{20D7}", %p)},	undef,	"to_ascii\(\'\\uFB39Ⴘ\.𞡼𑇀ß\\u20D7\'\)\ throws\ error\ B2\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:2168\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{05D9}\x{05BC}Ⴘ.𞡼𑇀ß\x{20D7}", %p)},	undef,	"to_ascii\(\'\\u05D9\\u05BCႸ\.𞡼𑇀ß\\u20D7\'\)\ throws\ error\ B2\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:2170\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("\x{05D9}\x{05BC}ⴘ.𞡼𑇀ß\x{20D7}", %p)},	undef,	"to_ascii\(\'\\u05D9\\u05BCⴘ\.𞡼𑇀ß\\u20D7\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:2172\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("\x{05D9}\x{05BC}Ⴘ.𞡼𑇀SS\x{20D7}", %p)},	undef,	"to_ascii\(\'\\u05D9\\u05BCႸ\.𞡼𑇀SS\\u20D7\'\)\ throws\ error\ B2\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:2174\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("\x{05D9}\x{05BC}ⴘ.𞡼𑇀ss\x{20D7}", %p)},	undef,	"to_ascii\(\'\\u05D9\\u05BCⴘ\.𞡼𑇀ss\\u20D7\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:2175\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("\x{05D9}\x{05BC}Ⴘ.𞡼𑇀ss\x{20D7}", %p)},	undef,	"to_ascii\(\'\\u05D9\\u05BCႸ\.𞡼𑇀ss\\u20D7\'\)\ throws\ error\ B2\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:2176\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--kdb1d867b.xn--ss-yju5690ken9h", %p)},	undef,	"to_ascii\(\'xn\-\-kdb1d867b\.xn\-\-ss\-yju5690ken9h\'\)\ throws\ error\ B2\ B3\ V6\ \[data\/IdnaTest\.txt\:2177\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--kdb1d278n.xn--ss-yju5690ken9h", %p)},	undef,	"to_ascii\(\'xn\-\-kdb1d278n\.xn\-\-ss\-yju5690ken9h\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:2178\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--kdb1d278n.xn--zca284nhg9nrrxg", %p)},	undef,	"to_ascii\(\'xn\-\-kdb1d278n\.xn\-\-zca284nhg9nrrxg\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:2179\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--kdb1d867b.xn--zca284nhg9nrrxg", %p)},	undef,	"to_ascii\(\'xn\-\-kdb1d867b\.xn\-\-zca284nhg9nrrxg\'\)\ throws\ error\ B2\ B3\ V6\ \[data\/IdnaTest\.txt\:2180\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("\x{FB39}ⴘ.𞡼𑇀ß\x{20D7}", %p)},	undef,	"to_ascii\(\'\\uFB39ⴘ\.𞡼𑇀ß\\u20D7\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:2181\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("\x{FB39}Ⴘ.𞡼𑇀SS\x{20D7}", %p)},	undef,	"to_ascii\(\'\\uFB39Ⴘ\.𞡼𑇀SS\\u20D7\'\)\ throws\ error\ B2\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:2183\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("\x{FB39}ⴘ.𞡼𑇀ss\x{20D7}", %p)},	undef,	"to_ascii\(\'\\uFB39ⴘ\.𞡼𑇀ss\\u20D7\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:2184\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("\x{FB39}Ⴘ.𞡼𑇀ss\x{20D7}", %p)},	undef,	"to_ascii\(\'\\uFB39Ⴘ\.𞡼𑇀ss\\u20D7\'\)\ throws\ error\ B2\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:2185\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1BA3}𐹰򁱓｡凬", %p)},	undef,	"to_ascii\(\'\\u1BA3𐹰\?｡凬\'\)\ throws\ error\ B1\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2186\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1BA3}𐹰򁱓。凬", %p)},	undef,	"to_ascii\(\'\\u1BA3𐹰\?\。凬\'\)\ throws\ error\ B1\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2187\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--rxfz314ilg20c.xn--t9q", %p)},	undef,	"to_ascii\(\'xn\-\-rxfz314ilg20c\.xn\-\-t9q\'\)\ throws\ error\ B1\ V5\ V6\ \[data\/IdnaTest\.txt\:2188\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("🢟🄈\x{200D}ꡎ｡\x{0F84}", %p)},	undef,	"to_ascii\(\'🢟🄈\\u200Dꡎ｡\\u0F84\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2189\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("🢟7,\x{200D}ꡎ。\x{0F84}", %p)},	undef,	"to_ascii\(\'🢟7\,\\u200Dꡎ\。\\u0F84\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2191\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--7,-gh9hg322i.xn--3ed", %p)},	undef,	"to_ascii\(\'xn\-\-7\,\-gh9hg322i\.xn\-\-3ed\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2193\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--7,-n1t0654eqo3o.xn--3ed", %p)},	undef,	"to_ascii\(\'xn\-\-7\,\-n1t0654eqo3o\.xn\-\-3ed\'\)\ throws\ error\ C2\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2194\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--nc9aq743ds0e.xn--3ed", %p)},	undef,	"to_ascii\(\'xn\-\-nc9aq743ds0e\.xn\-\-3ed\'\)\ throws\ error\ V5\ V6\ \[data\/IdnaTest\.txt\:2195\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--1ug4874cfd0kbmg.xn--3ed", %p)},	undef,	"to_ascii\(\'xn\-\-1ug4874cfd0kbmg\.xn\-\-3ed\'\)\ throws\ error\ C2\ V5\ V6\ \[data\/IdnaTest\.txt\:2196\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_ascii("ꡔ。\x{1039}ᢇ", %p)},	undef,	"to_ascii\(\'ꡔ\。\\u1039ᢇ\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:2197\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--tc9a.xn--9jd663b", %p)},	undef,	"to_ascii\(\'xn\-\-tc9a\.xn\-\-9jd663b\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:2198\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{20EB}≮.𝨖", %p)},	undef,	"to_ascii\(\'\\u20EB\≮\.𝨖\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2199\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{20EB}<\x{0338}.𝨖", %p)},	undef,	"to_ascii\(\'\\u20EB\<\\u0338\.𝨖\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2200\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--e1g71d.xn--772h", %p)},	undef,	"to_ascii\(\'xn\-\-e1g71d\.xn\-\-772h\'\)\ throws\ error\ V5\ V6\ \[data\/IdnaTest\.txt\:2201\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴢ≯褦．ᠪ\x{07EA}Ⴞ\x{0767}", %p)},	undef,	"to_ascii\(\'Ⴢ\≯褦．ᠪ\\u07EAႾ\\u0767\'\)\ throws\ error\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:2202\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴢ>\x{0338}褦．ᠪ\x{07EA}Ⴞ\x{0767}", %p)},	undef,	"to_ascii\(\'Ⴢ\>\\u0338褦．ᠪ\\u07EAႾ\\u0767\'\)\ throws\ error\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:2203\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴢ≯褦.ᠪ\x{07EA}Ⴞ\x{0767}", %p)},	undef,	"to_ascii\(\'Ⴢ\≯褦\.ᠪ\\u07EAႾ\\u0767\'\)\ throws\ error\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:2204\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴢ>\x{0338}褦.ᠪ\x{07EA}Ⴞ\x{0767}", %p)},	undef,	"to_ascii\(\'Ⴢ\>\\u0338褦\.ᠪ\\u07EAႾ\\u0767\'\)\ throws\ error\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:2205\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⴢ>\x{0338}褦.ᠪ\x{07EA}ⴞ\x{0767}", %p)},	undef,	"to_ascii\(\'ⴢ\>\\u0338褦\.ᠪ\\u07EAⴞ\\u0767\'\)\ throws\ error\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:2206\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⴢ≯褦.ᠪ\x{07EA}ⴞ\x{0767}", %p)},	undef,	"to_ascii\(\'ⴢ\≯褦\.ᠪ\\u07EAⴞ\\u0767\'\)\ throws\ error\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:2207\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--hdh433bev8e.xn--rpb5x392bcyt", %p)},	undef,	"to_ascii\(\'xn\-\-hdh433bev8e\.xn\-\-rpb5x392bcyt\'\)\ throws\ error\ B5\ B6\ V6\ \[data\/IdnaTest\.txt\:2208\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--6nd461g478e.xn--rpb5x49td2h", %p)},	undef,	"to_ascii\(\'xn\-\-6nd461g478e\.xn\-\-rpb5x49td2h\'\)\ throws\ error\ B5\ B6\ V6\ \[data\/IdnaTest\.txt\:2209\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⴢ>\x{0338}褦．ᠪ\x{07EA}ⴞ\x{0767}", %p)},	undef,	"to_ascii\(\'ⴢ\>\\u0338褦．ᠪ\\u07EAⴞ\\u0767\'\)\ throws\ error\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:2210\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⴢ≯褦．ᠪ\x{07EA}ⴞ\x{0767}", %p)},	undef,	"to_ascii\(\'ⴢ\≯褦．ᠪ\\u07EAⴞ\\u0767\'\)\ throws\ error\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:2211\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򊉆󠆒\x{200C}\x{A953}。𞤙\x{067B}ꡘ", %p)},	undef,	"to_ascii\(\'\?\󠆒\\u200C\\uA953\。𞤙\\u067Bꡘ\'\)\ throws\ error\ B2\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:2212\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򊉆󠆒\x{200C}\x{A953}。𞤻\x{067B}ꡘ", %p)},	undef,	"to_ascii\(\'\?\󠆒\\u200C\\uA953\。𞤻\\u067Bꡘ\'\)\ throws\ error\ B2\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:2214\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--3j9al6189a.xn--0ib8893fegvj", %p)},	undef,	"to_ascii\(\'xn\-\-3j9al6189a\.xn\-\-0ib8893fegvj\'\)\ throws\ error\ B2\ B3\ V6\ \[data\/IdnaTest\.txt\:2216\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--0ug8815chtz0e.xn--0ib8893fegvj", %p)},	undef,	"to_ascii\(\'xn\-\-0ug8815chtz0e\.xn\-\-0ib8893fegvj\'\)\ throws\ error\ B2\ B3\ C1\ V6\ \[data\/IdnaTest\.txt\:2217\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}.≯", %p)},	undef,	"to_ascii\(\'\\u200C\.\≯\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:2218\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}.>\x{0338}", %p)},	undef,	"to_ascii\(\'\\u200C\.\>\\u0338\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:2220\]") or ($@ and diag($@));
is(eval{uts46_to_ascii(".xn--hdh", %p)},	undef,	"to_ascii\(\'\.xn\-\-hdh\'\)\ throws\ error\ V6\ A4_2\ \[data\/IdnaTest\.txt\:2222\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--0ug.xn--hdh", %p)},	undef,	"to_ascii\(\'xn\-\-0ug\.xn\-\-hdh\'\)\ throws\ error\ C1\ V6\ \[data\/IdnaTest\.txt\:2223\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𰅧񣩠-．\x{ABED}-悜", %p)},	undef,	"to_ascii\(\'𰅧\?\-．\\uABED\-悜\'\)\ throws\ error\ P1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:2224\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𰅧񣩠-.\x{ABED}-悜", %p)},	undef,	"to_ascii\(\'𰅧\?\-\.\\uABED\-悜\'\)\ throws\ error\ P1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:2225\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----7m53aj640l.xn----8f4br83t", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-7m53aj640l\.xn\-\-\-\-8f4br83t\'\)\ throws\ error\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:2226\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᡉ𶓧⬞ᢜ.-\x{200D}𞣑\x{202E}", %p)},	undef,	"to_ascii\(\'ᡉ\?\⬞ᢜ\.\-\\u200D𞣑\\u202E\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:2227\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--87e0ol04cdl39e.xn----qinu247r", %p)},	undef,	"to_ascii\(\'xn\-\-87e0ol04cdl39e\.xn\-\-\-\-qinu247r\'\)\ throws\ error\ V3\ V6\ \[data\/IdnaTest\.txt\:2229\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--87e0ol04cdl39e.xn----ugn5e3763s", %p)},	undef,	"to_ascii\(\'xn\-\-87e0ol04cdl39e\.xn\-\-\-\-ugn5e3763s\'\)\ throws\ error\ C2\ V3\ V6\ \[data\/IdnaTest\.txt\:2230\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⒐\x{200C}衃Ⴝ.\x{0682}Ⴔ", %p)},	undef,	"to_ascii\(\'⒐\\u200C衃Ⴝ\.\\u0682Ⴔ\'\)\ throws\ error\ B1\ B2\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:2231\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("9.\x{200C}衃Ⴝ.\x{0682}Ⴔ", %p)},	undef,	"to_ascii\(\'9\.\\u200C衃Ⴝ\.\\u0682Ⴔ\'\)\ throws\ error\ B1\ B2\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:2233\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("9.\x{200C}衃ⴝ.\x{0682}ⴔ", %p)},	undef,	"to_ascii\(\'9\.\\u200C衃ⴝ\.\\u0682ⴔ\'\)\ throws\ error\ B1\ B2\ B3\ \[data\/IdnaTest\.txt\:2235\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("9.\x{200C}衃Ⴝ.\x{0682}ⴔ", %p)},	undef,	"to_ascii\(\'9\.\\u200C衃Ⴝ\.\\u0682ⴔ\'\)\ throws\ error\ B1\ B2\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:2237\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("9.xn--1nd9032d.xn--7ib268q", %p)},	undef,	"to_ascii\(\'9\.xn\-\-1nd9032d\.xn\-\-7ib268q\'\)\ throws\ error\ B1\ B2\ B3\ V6\ \[data\/IdnaTest\.txt\:2239\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("9.xn--1nd159e1y2f.xn--7ib268q", %p)},	undef,	"to_ascii\(\'9\.xn\-\-1nd159e1y2f\.xn\-\-7ib268q\'\)\ throws\ error\ B1\ B2\ B3\ C1\ V6\ \[data\/IdnaTest\.txt\:2240\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("9.xn--llj1920a.xn--7ib268q", %p)},	undef,	"to_ascii\(\'9\.xn\-\-llj1920a\.xn\-\-7ib268q\'\)\ throws\ error\ B1\ B2\ B3\ \[data\/IdnaTest\.txt\:2241\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("9.xn--0ug862cbm5e.xn--7ib268q", %p)},	undef,	"to_ascii\(\'9\.xn\-\-0ug862cbm5e\.xn\-\-7ib268q\'\)\ throws\ error\ B1\ B2\ B3\ C1\ \[data\/IdnaTest\.txt\:2242\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("9.xn--1nd9032d.xn--7ib433c", %p)},	undef,	"to_ascii\(\'9\.xn\-\-1nd9032d\.xn\-\-7ib433c\'\)\ throws\ error\ B1\ B2\ B3\ V6\ \[data\/IdnaTest\.txt\:2243\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("9.xn--1nd159e1y2f.xn--7ib433c", %p)},	undef,	"to_ascii\(\'9\.xn\-\-1nd159e1y2f\.xn\-\-7ib433c\'\)\ throws\ error\ B1\ B2\ B3\ C1\ V6\ \[data\/IdnaTest\.txt\:2244\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⒐\x{200C}衃ⴝ.\x{0682}ⴔ", %p)},	undef,	"to_ascii\(\'⒐\\u200C衃ⴝ\.\\u0682ⴔ\'\)\ throws\ error\ B1\ B2\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:2245\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⒐\x{200C}衃Ⴝ.\x{0682}ⴔ", %p)},	undef,	"to_ascii\(\'⒐\\u200C衃Ⴝ\.\\u0682ⴔ\'\)\ throws\ error\ B1\ B2\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:2247\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--1nd362hy16e.xn--7ib268q", %p)},	undef,	"to_ascii\(\'xn\-\-1nd362hy16e\.xn\-\-7ib268q\'\)\ throws\ error\ B1\ B2\ B3\ V6\ \[data\/IdnaTest\.txt\:2249\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--1nd159ecmd785k.xn--7ib268q", %p)},	undef,	"to_ascii\(\'xn\-\-1nd159ecmd785k\.xn\-\-7ib268q\'\)\ throws\ error\ B1\ B2\ B3\ C1\ V6\ \[data\/IdnaTest\.txt\:2250\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--1shy52abz3f.xn--7ib268q", %p)},	undef,	"to_ascii\(\'xn\-\-1shy52abz3f\.xn\-\-7ib268q\'\)\ throws\ error\ B1\ B2\ B3\ V6\ \[data\/IdnaTest\.txt\:2251\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--0ugx0px1izu2h.xn--7ib268q", %p)},	undef,	"to_ascii\(\'xn\-\-0ugx0px1izu2h\.xn\-\-7ib268q\'\)\ throws\ error\ B1\ B2\ B3\ C1\ V6\ \[data\/IdnaTest\.txt\:2252\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--1nd362hy16e.xn--7ib433c", %p)},	undef,	"to_ascii\(\'xn\-\-1nd362hy16e\.xn\-\-7ib433c\'\)\ throws\ error\ B1\ B2\ B3\ V6\ \[data\/IdnaTest\.txt\:2253\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--1nd159ecmd785k.xn--7ib433c", %p)},	undef,	"to_ascii\(\'xn\-\-1nd159ecmd785k\.xn\-\-7ib433c\'\)\ throws\ error\ B1\ B2\ B3\ C1\ V6\ \[data\/IdnaTest\.txt\:2254\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_ascii("\x{07E1}\x{200C}。--⸬", %p)},	undef,	"to_ascii\(\'\\u07E1\\u200C\。\-\-\⸬\'\)\ throws\ error\ B1\ V3\ \[data\/IdnaTest\.txt\:2255\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--8sb.xn-----iw2a", %p)},	undef,	"to_ascii\(\'xn\-\-8sb\.xn\-\-\-\-\-iw2a\'\)\ throws\ error\ B1\ V3\ \[data\/IdnaTest\.txt\:2257\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--8sb884j.xn-----iw2a", %p)},	undef,	"to_ascii\(\'xn\-\-8sb884j\.xn\-\-\-\-\-iw2a\'\)\ throws\ error\ B1\ B3\ C1\ V3\ \[data\/IdnaTest\.txt\:2258\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("𞥓．\x{0718}", %p)},	"xn--of6h.xn--inb",	"to_ascii\(\'𞥓．\\u0718\'\)\ \[data\/IdnaTest\.txt\:2259\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("𞥓.\x{0718}", %p)},	"xn--of6h.xn--inb",	"to_ascii\(\'𞥓\.\\u0718\'\)\ \[data\/IdnaTest\.txt\:2260\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("xn--of6h.xn--inb", %p)},	"xn--of6h.xn--inb",	"to_ascii\(\'xn\-\-of6h\.xn\-\-inb\'\)\ \[data\/IdnaTest\.txt\:2261\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("󠄽-．-\x{0DCA}", %p)},	undef,	"to_ascii\(\'\󠄽\-．\-\\u0DCA\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:2262\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠄽-.-\x{0DCA}", %p)},	undef,	"to_ascii\(\'\󠄽\-\.\-\\u0DCA\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:2263\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-.xn----ptf", %p)},	undef,	"to_ascii\(\'\-\.xn\-\-\-\-ptf\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:2264\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("󠇝\x{075B}-.\x{1927}", %p)},	undef,	"to_ascii\(\'\󠇝\\u075B\-\.\\u1927\'\)\ throws\ error\ B1\ B3\ B6\ V3\ V5\ \[data\/IdnaTest\.txt\:2265\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn----k4c.xn--lff", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-k4c\.xn\-\-lff\'\)\ throws\ error\ B1\ B3\ B6\ V3\ V5\ \[data\/IdnaTest\.txt\:2266\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𞤴󠆹⦉𐹺.\x{A806}⒌󘤸", %p)},	undef,	"to_ascii\(\'𞤴\󠆹\⦉𐹺\.\\uA806⒌\?\'\)\ throws\ error\ B1\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2267\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𞤴󠆹⦉𐹺.\x{A806}5.󘤸", %p)},	undef,	"to_ascii\(\'𞤴\󠆹\⦉𐹺\.\\uA8065\.\?\'\)\ throws\ error\ B1\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2268\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𞤒󠆹⦉𐹺.\x{A806}5.󘤸", %p)},	undef,	"to_ascii\(\'𞤒\󠆹\⦉𐹺\.\\uA8065\.\?\'\)\ throws\ error\ B1\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2269\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--fuix729epewf.xn--5-w93e.xn--7b83e", %p)},	undef,	"to_ascii\(\'xn\-\-fuix729epewf\.xn\-\-5\-w93e\.xn\-\-7b83e\'\)\ throws\ error\ B1\ V5\ V6\ \[data\/IdnaTest\.txt\:2270\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𞤒󠆹⦉𐹺.\x{A806}⒌󘤸", %p)},	undef,	"to_ascii\(\'𞤒\󠆹\⦉𐹺\.\\uA806⒌\?\'\)\ throws\ error\ B1\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2271\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--fuix729epewf.xn--xsh5029b6e77i", %p)},	undef,	"to_ascii\(\'xn\-\-fuix729epewf\.xn\-\-xsh5029b6e77i\'\)\ throws\ error\ B1\ V5\ V6\ \[data\/IdnaTest\.txt\:2272\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("󠄸₀。𑖿\x{200C}𐦂\x{200D}", %p)},	undef,	"to_ascii\(\'\󠄸₀\。𑖿\\u200C𐦂\\u200D\'\)\ throws\ error\ B1\ V5\ \[data\/IdnaTest\.txt\:2273\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("󠄸0。𑖿\x{200C}𐦂\x{200D}", %p)},	undef,	"to_ascii\(\'\󠄸0\。𑖿\\u200C𐦂\\u200D\'\)\ throws\ error\ B1\ V5\ \[data\/IdnaTest\.txt\:2275\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("0.xn--mn9cz2s", %p)},	undef,	"to_ascii\(\'0\.xn\-\-mn9cz2s\'\)\ throws\ error\ B1\ V5\ \[data\/IdnaTest\.txt\:2277\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("0.xn--0ugc8040p9hk", %p)},	undef,	"to_ascii\(\'0\.xn\-\-0ugc8040p9hk\'\)\ throws\ error\ B1\ C2\ V5\ \[data\/IdnaTest\.txt\:2278\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴚ𐋸󠄄。𝟝ퟶ\x{103A}", %p)},	undef,	"to_ascii\(\'Ⴚ𐋸\󠄄\。𝟝ퟶ\\u103A\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2279\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴚ𐋸󠄄。5ퟶ\x{103A}", %p)},	undef,	"to_ascii\(\'Ⴚ𐋸\󠄄\。5ퟶ\\u103A\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2280\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("ⴚ𐋸󠄄。5ퟶ\x{103A}", %p)},	"xn--ilj2659d.xn--5-dug9054m",	"to_ascii\(\'ⴚ𐋸\󠄄\。5ퟶ\\u103A\'\)\ \[data\/IdnaTest\.txt\:2281\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("xn--ilj2659d.xn--5-dug9054m", %p)},	"xn--ilj2659d.xn--5-dug9054m",	"to_ascii\(\'xn\-\-ilj2659d\.xn\-\-5\-dug9054m\'\)\ \[data\/IdnaTest\.txt\:2282\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("ⴚ𐋸.5ퟶ\x{103A}", %p)},	"xn--ilj2659d.xn--5-dug9054m",	"to_ascii\(\'ⴚ𐋸\.5ퟶ\\u103A\'\)\ \[data\/IdnaTest\.txt\:2283\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("Ⴚ𐋸.5ퟶ\x{103A}", %p)},	undef,	"to_ascii\(\'Ⴚ𐋸\.5ퟶ\\u103A\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2284\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--ynd2415j.xn--5-dug9054m", %p)},	undef,	"to_ascii\(\'xn\-\-ynd2415j\.xn\-\-5\-dug9054m\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:2285\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("ⴚ𐋸󠄄。𝟝ퟶ\x{103A}", %p)},	"xn--ilj2659d.xn--5-dug9054m",	"to_ascii\(\'ⴚ𐋸\󠄄\。𝟝ퟶ\\u103A\'\)\ \[data\/IdnaTest\.txt\:2286\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("\x{200D}-ᠹ﹪.\x{1DE1}\x{1922}", %p)},	undef,	"to_ascii\(\'\\u200D\-ᠹ﹪\.\\u1DE1\\u1922\'\)\ throws\ error\ P1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:2287\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}-ᠹ%.\x{1DE1}\x{1922}", %p)},	undef,	"to_ascii\(\'\\u200D\-ᠹ\%\.\\u1DE1\\u1922\'\)\ throws\ error\ P1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:2289\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn---%-u4o.xn--gff52t", %p)},	undef,	"to_ascii\(\'xn\-\-\-\%\-u4o\.xn\-\-gff52t\'\)\ throws\ error\ P1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:2291\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn---%-u4oy48b.xn--gff52t", %p)},	undef,	"to_ascii\(\'xn\-\-\-\%\-u4oy48b\.xn\-\-gff52t\'\)\ throws\ error\ C2\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2292\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----c6jx047j.xn--gff52t", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-c6jx047j\.xn\-\-gff52t\'\)\ throws\ error\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:2293\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----c6j614b1z4v.xn--gff52t", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-c6j614b1z4v\.xn\-\-gff52t\'\)\ throws\ error\ C2\ V5\ V6\ \[data\/IdnaTest\.txt\:2294\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≠.ᠿ", %p)},	undef,	"to_ascii\(\'\≠\.ᠿ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2295\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("=\x{0338}.ᠿ", %p)},	undef,	"to_ascii\(\'\=\\u0338\.ᠿ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2296\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--1ch.xn--y7e", %p)},	undef,	"to_ascii\(\'xn\-\-1ch\.xn\-\-y7e\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:2297\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0723}\x{05A3}｡㌪", %p)},	"xn--ucb18e.xn--eck4c5a",	"to_ascii\(\'\\u0723\\u05A3｡㌪\'\)\ \[data\/IdnaTest\.txt\:2298\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0723}\x{05A3}。ハイツ", %p)},	"xn--ucb18e.xn--eck4c5a",	"to_ascii\(\'\\u0723\\u05A3\。ハイツ\'\)\ \[data\/IdnaTest\.txt\:2299\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--ucb18e.xn--eck4c5a", %p)},	"xn--ucb18e.xn--eck4c5a",	"to_ascii\(\'xn\-\-ucb18e\.xn\-\-eck4c5a\'\)\ \[data\/IdnaTest\.txt\:2300\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0723}\x{05A3}.ハイツ", %p)},	"xn--ucb18e.xn--eck4c5a",	"to_ascii\(\'\\u0723\\u05A3\.ハイツ\'\)\ \[data\/IdnaTest\.txt\:2301\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𞷥󠆀≮.\x{2D7F}-", %p)},	undef,	"to_ascii\(\'\?\󠆀\≮\.\\u2D7F\-\'\)\ throws\ error\ B1\ B3\ P1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:2302\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𞷥󠆀<\x{0338}.\x{2D7F}-", %p)},	undef,	"to_ascii\(\'\?\󠆀\<\\u0338\.\\u2D7F\-\'\)\ throws\ error\ B1\ B3\ P1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:2303\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--gdhx802p.xn----i2s", %p)},	undef,	"to_ascii\(\'xn\-\-gdhx802p\.xn\-\-\-\-i2s\'\)\ throws\ error\ B1\ B3\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:2304\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("₆榎򦖎\x{0D4D}｡𞤅\x{06ED}\x{FC5A}󠮨", %p)},	undef,	"to_ascii\(\'₆榎\?\\u0D4D｡𞤅\\u06ED\\uFC5A\?\'\)\ throws\ error\ B1\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:2305\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("6榎򦖎\x{0D4D}。𞤅\x{06ED}\x{064A}\x{064A}󠮨", %p)},	undef,	"to_ascii\(\'6榎\?\\u0D4D\。𞤅\\u06ED\\u064A\\u064A\?\'\)\ throws\ error\ B1\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:2306\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("6榎򦖎\x{0D4D}。𞤧\x{06ED}\x{064A}\x{064A}󠮨", %p)},	undef,	"to_ascii\(\'6榎\?\\u0D4D\。𞤧\\u06ED\\u064A\\u064A\?\'\)\ throws\ error\ B1\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:2307\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--6-kmf4691ejv41j.xn--mhba10ch545mn8v8h", %p)},	undef,	"to_ascii\(\'xn\-\-6\-kmf4691ejv41j\.xn\-\-mhba10ch545mn8v8h\'\)\ throws\ error\ B1\ B3\ V6\ \[data\/IdnaTest\.txt\:2308\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("₆榎򦖎\x{0D4D}｡𞤧\x{06ED}\x{FC5A}󠮨", %p)},	undef,	"to_ascii\(\'₆榎\?\\u0D4D｡𞤧\\u06ED\\uFC5A\?\'\)\ throws\ error\ B1\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:2309\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𣩫．򌑲", %p)},	undef,	"to_ascii\(\'𣩫．\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2310\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𣩫.򌑲", %p)},	undef,	"to_ascii\(\'𣩫\.\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2311\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--td3j.xn--4628b", %p)},	undef,	"to_ascii\(\'xn\-\-td3j\.xn\-\-4628b\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:2312\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}︒｡\x{06B9}\x{200C}", %p)},	undef,	"to_ascii\(\'\\u200D︒｡\\u06B9\\u200C\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:2313\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--y86c.xn--skb", %p)},	undef,	"to_ascii\(\'xn\-\-y86c\.xn\-\-skb\'\)\ throws\ error\ B1\ V6\ \[data\/IdnaTest\.txt\:2315\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--1ug2658f.xn--skb080k", %p)},	undef,	"to_ascii\(\'xn\-\-1ug2658f\.xn\-\-skb080k\'\)\ throws\ error\ B1\ B3\ C1\ C2\ V6\ \[data\/IdnaTest\.txt\:2316\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--skb", %p)},	"xn--skb",	"to_ascii\(\'xn\-\-skb\'\)\ \[data\/IdnaTest\.txt\:2317\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{06B9}", %p)},	"xn--skb",	"to_ascii\(\'\\u06B9\'\)\ \[data\/IdnaTest\.txt\:2318\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐹦\x{200C}𐹶。\x{206D}", %p)},	undef,	"to_ascii\(\'𐹦\\u200C𐹶\。\\u206D\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:2319\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--eo0d6a.xn--sxg", %p)},	undef,	"to_ascii\(\'xn\-\-eo0d6a\.xn\-\-sxg\'\)\ throws\ error\ B1\ V6\ \[data\/IdnaTest\.txt\:2321\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--0ug4994goba.xn--sxg", %p)},	undef,	"to_ascii\(\'xn\-\-0ug4994goba\.xn\-\-sxg\'\)\ throws\ error\ B1\ C1\ V6\ \[data\/IdnaTest\.txt\:2322\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_ascii("\x{0C4D}𝨾\x{05A9}𝟭。-𑜨", %p)},	undef,	"to_ascii\(\'\\u0C4D𝨾\\u05A9𝟭\。\-𑜨\'\)\ throws\ error\ V3\ V5\ \[data\/IdnaTest\.txt\:2323\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_ascii("\x{0C4D}𝨾\x{05A9}1。-𑜨", %p)},	undef,	"to_ascii\(\'\\u0C4D𝨾\\u05A91\。\-𑜨\'\)\ throws\ error\ V3\ V5\ \[data\/IdnaTest\.txt\:2324\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--1-rfc312cdp45c.xn----nq0j", %p)},	undef,	"to_ascii\(\'xn\-\-1\-rfc312cdp45c\.xn\-\-\-\-nq0j\'\)\ throws\ error\ V3\ V5\ \[data\/IdnaTest\.txt\:2325\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򣿈。뙏", %p)},	undef,	"to_ascii\(\'\?\。뙏\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2326\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򣿈。뙏", %p)},	undef,	"to_ascii\(\'\?\。뙏\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2327\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--ph26c.xn--281b", %p)},	undef,	"to_ascii\(\'xn\-\-ph26c\.xn\-\-281b\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:2328\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񕨚󠄌󑽀ᡀ.\x{08B6}", %p)},	undef,	"to_ascii\(\'\?\󠄌\?ᡀ\.\\u08B6\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2329\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--z7e98100evc01b.xn--czb", %p)},	undef,	"to_ascii\(\'xn\-\-z7e98100evc01b\.xn\-\-czb\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:2330\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}｡񅁛", %p)},	undef,	"to_ascii\(\'\\u200D｡\?\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:2331\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}。񅁛", %p)},	undef,	"to_ascii\(\'\\u200D\。\?\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:2333\]") or ($@ and diag($@));
is(eval{uts46_to_ascii(".xn--6x4u", %p)},	undef,	"to_ascii\(\'\.xn\-\-6x4u\'\)\ throws\ error\ V6\ A4_2\ \[data\/IdnaTest\.txt\:2335\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--1ug.xn--6x4u", %p)},	undef,	"to_ascii\(\'xn\-\-1ug\.xn\-\-6x4u\'\)\ throws\ error\ C2\ V6\ \[data\/IdnaTest\.txt\:2336\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_ascii("\x{084B}皥．-", %p)},	undef,	"to_ascii\(\'\\u084B皥．\-\'\)\ throws\ error\ B1\ B2\ B3\ V3\ \[data\/IdnaTest\.txt\:2337\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_ascii("\x{084B}皥.-", %p)},	undef,	"to_ascii\(\'\\u084B皥\.\-\'\)\ throws\ error\ B1\ B2\ B3\ V3\ \[data\/IdnaTest\.txt\:2338\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--9vb4167c.-", %p)},	undef,	"to_ascii\(\'xn\-\-9vb4167c\.\-\'\)\ throws\ error\ B1\ B2\ B3\ V3\ \[data\/IdnaTest\.txt\:2339\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐣸\x{0315}𐮇．⒈ꡦ", %p)},	undef,	"to_ascii\(\'\?\\u0315𐮇．⒈ꡦ\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:2340\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐣸\x{0315}𐮇.1.ꡦ", %p)},	undef,	"to_ascii\(\'\?\\u0315𐮇\.1\.ꡦ\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:2341\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--5sa9915kgvb.1.xn--cd9a", %p)},	undef,	"to_ascii\(\'xn\-\-5sa9915kgvb\.1\.xn\-\-cd9a\'\)\ throws\ error\ B1\ V6\ \[data\/IdnaTest\.txt\:2342\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--5sa9915kgvb.xn--tshw539b", %p)},	undef,	"to_ascii\(\'xn\-\-5sa9915kgvb\.xn\-\-tshw539b\'\)\ throws\ error\ B1\ V6\ \[data\/IdnaTest\.txt\:2343\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴛ\x{200C}\x{05A2}\x{200D}。\x{FFA0}ā𐹦", %p)},	undef,	"to_ascii\(\'Ⴛ\\u200C\\u05A2\\u200D\。\\uFFA0ā𐹦\'\)\ throws\ error\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:2344\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴛ\x{200C}\x{05A2}\x{200D}。\x{FFA0}a\x{0304}𐹦", %p)},	undef,	"to_ascii\(\'Ⴛ\\u200C\\u05A2\\u200D\。\\uFFA0a\\u0304𐹦\'\)\ throws\ error\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:2346\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴛ\x{200C}\x{05A2}\x{200D}。\x{1160}ā𐹦", %p)},	undef,	"to_ascii\(\'Ⴛ\\u200C\\u05A2\\u200D\。\\u1160ā𐹦\'\)\ throws\ error\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:2348\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴛ\x{200C}\x{05A2}\x{200D}。\x{1160}a\x{0304}𐹦", %p)},	undef,	"to_ascii\(\'Ⴛ\\u200C\\u05A2\\u200D\。\\u1160a\\u0304𐹦\'\)\ throws\ error\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:2350\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⴛ\x{200C}\x{05A2}\x{200D}。\x{1160}a\x{0304}𐹦", %p)},	undef,	"to_ascii\(\'ⴛ\\u200C\\u05A2\\u200D\。\\u1160a\\u0304𐹦\'\)\ throws\ error\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:2352\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⴛ\x{200C}\x{05A2}\x{200D}。\x{1160}ā𐹦", %p)},	undef,	"to_ascii\(\'ⴛ\\u200C\\u05A2\\u200D\。\\u1160ā𐹦\'\)\ throws\ error\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:2354\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴛ\x{200C}\x{05A2}\x{200D}。\x{1160}Ā𐹦", %p)},	undef,	"to_ascii\(\'Ⴛ\\u200C\\u05A2\\u200D\。\\u1160Ā𐹦\'\)\ throws\ error\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:2356\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴛ\x{200C}\x{05A2}\x{200D}。\x{1160}A\x{0304}𐹦", %p)},	undef,	"to_ascii\(\'Ⴛ\\u200C\\u05A2\\u200D\。\\u1160A\\u0304𐹦\'\)\ throws\ error\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:2358\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--tcb597c.xn--yda594fdn5q", %p)},	undef,	"to_ascii\(\'xn\-\-tcb597c\.xn\-\-yda594fdn5q\'\)\ throws\ error\ B5\ B6\ V6\ \[data\/IdnaTest\.txt\:2360\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--tcb597cdmmfa.xn--yda594fdn5q", %p)},	undef,	"to_ascii\(\'xn\-\-tcb597cdmmfa\.xn\-\-yda594fdn5q\'\)\ throws\ error\ B5\ B6\ C1\ C2\ V6\ \[data\/IdnaTest\.txt\:2361\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--tcb323r.xn--yda594fdn5q", %p)},	undef,	"to_ascii\(\'xn\-\-tcb323r\.xn\-\-yda594fdn5q\'\)\ throws\ error\ B5\ B6\ V6\ \[data\/IdnaTest\.txt\:2362\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--tcb736kea974k.xn--yda594fdn5q", %p)},	undef,	"to_ascii\(\'xn\-\-tcb736kea974k\.xn\-\-yda594fdn5q\'\)\ throws\ error\ B5\ B6\ C1\ C2\ V6\ \[data\/IdnaTest\.txt\:2363\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⴛ\x{200C}\x{05A2}\x{200D}。\x{FFA0}a\x{0304}𐹦", %p)},	undef,	"to_ascii\(\'ⴛ\\u200C\\u05A2\\u200D\。\\uFFA0a\\u0304𐹦\'\)\ throws\ error\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:2364\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⴛ\x{200C}\x{05A2}\x{200D}。\x{FFA0}ā𐹦", %p)},	undef,	"to_ascii\(\'ⴛ\\u200C\\u05A2\\u200D\。\\uFFA0ā𐹦\'\)\ throws\ error\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:2366\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴛ\x{200C}\x{05A2}\x{200D}。\x{FFA0}Ā𐹦", %p)},	undef,	"to_ascii\(\'Ⴛ\\u200C\\u05A2\\u200D\。\\uFFA0Ā𐹦\'\)\ throws\ error\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:2368\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴛ\x{200C}\x{05A2}\x{200D}。\x{FFA0}A\x{0304}𐹦", %p)},	undef,	"to_ascii\(\'Ⴛ\\u200C\\u05A2\\u200D\。\\uFFA0A\\u0304𐹦\'\)\ throws\ error\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:2370\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--tcb597c.xn--yda9741khjj", %p)},	undef,	"to_ascii\(\'xn\-\-tcb597c\.xn\-\-yda9741khjj\'\)\ throws\ error\ B5\ B6\ V6\ \[data\/IdnaTest\.txt\:2372\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--tcb597cdmmfa.xn--yda9741khjj", %p)},	undef,	"to_ascii\(\'xn\-\-tcb597cdmmfa\.xn\-\-yda9741khjj\'\)\ throws\ error\ B5\ B6\ C1\ C2\ V6\ \[data\/IdnaTest\.txt\:2373\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--tcb323r.xn--yda9741khjj", %p)},	undef,	"to_ascii\(\'xn\-\-tcb323r\.xn\-\-yda9741khjj\'\)\ throws\ error\ B5\ B6\ V6\ \[data\/IdnaTest\.txt\:2374\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--tcb736kea974k.xn--yda9741khjj", %p)},	undef,	"to_ascii\(\'xn\-\-tcb736kea974k\.xn\-\-yda9741khjj\'\)\ throws\ error\ B5\ B6\ C1\ C2\ V6\ \[data\/IdnaTest\.txt\:2375\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{FFF9}\x{200C}｡曳⾑𐋰≯", %p)},	undef,	"to_ascii\(\'\\uFFF9\\u200C｡曳⾑𐋰\≯\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2376\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{FFF9}\x{200C}｡曳⾑𐋰>\x{0338}", %p)},	undef,	"to_ascii\(\'\\uFFF9\\u200C｡曳⾑𐋰\>\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2378\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{FFF9}\x{200C}。曳襾𐋰≯", %p)},	undef,	"to_ascii\(\'\\uFFF9\\u200C\。曳襾𐋰\≯\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2380\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{FFF9}\x{200C}。曳襾𐋰>\x{0338}", %p)},	undef,	"to_ascii\(\'\\uFFF9\\u200C\。曳襾𐋰\>\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2382\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--vn7c.xn--hdh501y8wvfs5h", %p)},	undef,	"to_ascii\(\'xn\-\-vn7c\.xn\-\-hdh501y8wvfs5h\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:2384\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--0ug2139f.xn--hdh501y8wvfs5h", %p)},	undef,	"to_ascii\(\'xn\-\-0ug2139f\.xn\-\-hdh501y8wvfs5h\'\)\ throws\ error\ C1\ V6\ \[data\/IdnaTest\.txt\:2385\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≯⒈。ß", %p)},	undef,	"to_ascii\(\'\≯⒈\。ß\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2386\]") or ($@ and diag($@));
is(eval{uts46_to_ascii(">\x{0338}⒈。ß", %p)},	undef,	"to_ascii\(\'\>\\u0338⒈\。ß\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2388\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≯1.。ß", %p)},	undef,	"to_ascii\(\'\≯1\.\。ß\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:2390\]") or ($@ and diag($@));
is(eval{uts46_to_ascii(">\x{0338}1.。ß", %p)},	undef,	"to_ascii\(\'\>\\u03381\.\。ß\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:2392\]") or ($@ and diag($@));
is(eval{uts46_to_ascii(">\x{0338}1.。SS", %p)},	undef,	"to_ascii\(\'\>\\u03381\.\。SS\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:2394\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≯1.。SS", %p)},	undef,	"to_ascii\(\'\≯1\.\。SS\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:2395\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≯1.。ss", %p)},	undef,	"to_ascii\(\'\≯1\.\。ss\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:2396\]") or ($@ and diag($@));
is(eval{uts46_to_ascii(">\x{0338}1.。ss", %p)},	undef,	"to_ascii\(\'\>\\u03381\.\。ss\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:2397\]") or ($@ and diag($@));
is(eval{uts46_to_ascii(">\x{0338}1.。Ss", %p)},	undef,	"to_ascii\(\'\>\\u03381\.\。Ss\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:2398\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≯1.。Ss", %p)},	undef,	"to_ascii\(\'\≯1\.\。Ss\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:2399\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--1-ogo..ss", %p)},	undef,	"to_ascii\(\'xn\-\-1\-ogo\.\.ss\'\)\ throws\ error\ V6\ A4_2\ \[data\/IdnaTest\.txt\:2400\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--1-ogo..xn--zca", %p)},	undef,	"to_ascii\(\'xn\-\-1\-ogo\.\.xn\-\-zca\'\)\ throws\ error\ V6\ A4_2\ \[data\/IdnaTest\.txt\:2401\]") or ($@ and diag($@));
is(eval{uts46_to_ascii(">\x{0338}⒈。SS", %p)},	undef,	"to_ascii\(\'\>\\u0338⒈\。SS\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2402\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≯⒈。SS", %p)},	undef,	"to_ascii\(\'\≯⒈\。SS\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2403\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≯⒈。ss", %p)},	undef,	"to_ascii\(\'\≯⒈\。ss\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2404\]") or ($@ and diag($@));
is(eval{uts46_to_ascii(">\x{0338}⒈。ss", %p)},	undef,	"to_ascii\(\'\>\\u0338⒈\。ss\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2405\]") or ($@ and diag($@));
is(eval{uts46_to_ascii(">\x{0338}⒈。Ss", %p)},	undef,	"to_ascii\(\'\>\\u0338⒈\。Ss\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2406\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≯⒈。Ss", %p)},	undef,	"to_ascii\(\'\≯⒈\。Ss\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2407\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--hdh84f.ss", %p)},	undef,	"to_ascii\(\'xn\-\-hdh84f\.ss\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:2408\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--hdh84f.xn--zca", %p)},	undef,	"to_ascii\(\'xn\-\-hdh84f\.xn\-\-zca\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:2409\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0667}\x{200D}\x{FB96}｡\x{07DA}-₆Ⴙ", %p)},	undef,	"to_ascii\(\'\\u0667\\u200D\\uFB96｡\\u07DA\-₆Ⴙ\'\)\ throws\ error\ B1\ B2\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:2410\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0667}\x{200D}\x{06B3}。\x{07DA}-6Ⴙ", %p)},	undef,	"to_ascii\(\'\\u0667\\u200D\\u06B3\。\\u07DA\-6Ⴙ\'\)\ throws\ error\ B1\ B2\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:2412\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_ascii("\x{0667}\x{200D}\x{06B3}。\x{07DA}-6ⴙ", %p)},	undef,	"to_ascii\(\'\\u0667\\u200D\\u06B3\。\\u07DA\-6ⴙ\'\)\ throws\ error\ B1\ B2\ B3\ \[data\/IdnaTest\.txt\:2414\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--gib6m.xn---6-lve6529a", %p)},	undef,	"to_ascii\(\'xn\-\-gib6m\.xn\-\-\-6\-lve6529a\'\)\ throws\ error\ B1\ B2\ B3\ \[data\/IdnaTest\.txt\:2416\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--gib6m343e.xn---6-lve6529a", %p)},	undef,	"to_ascii\(\'xn\-\-gib6m343e\.xn\-\-\-6\-lve6529a\'\)\ throws\ error\ B1\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:2417\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--gib6m.xn---6-lve002g", %p)},	undef,	"to_ascii\(\'xn\-\-gib6m\.xn\-\-\-6\-lve002g\'\)\ throws\ error\ B1\ B2\ B3\ V6\ \[data\/IdnaTest\.txt\:2418\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--gib6m343e.xn---6-lve002g", %p)},	undef,	"to_ascii\(\'xn\-\-gib6m343e\.xn\-\-\-6\-lve002g\'\)\ throws\ error\ B1\ B2\ B3\ C2\ V6\ \[data\/IdnaTest\.txt\:2419\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_ascii("\x{0667}\x{200D}\x{FB96}｡\x{07DA}-₆ⴙ", %p)},	undef,	"to_ascii\(\'\\u0667\\u200D\\uFB96｡\\u07DA\-₆ⴙ\'\)\ throws\ error\ B1\ B2\ B3\ \[data\/IdnaTest\.txt\:2420\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("\x{200C}｡≠", %p)},	undef,	"to_ascii\(\'\\u200C｡\≠\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:2422\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}｡=\x{0338}", %p)},	undef,	"to_ascii\(\'\\u200C｡\=\\u0338\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:2424\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}。≠", %p)},	undef,	"to_ascii\(\'\\u200C\。\≠\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:2426\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}。=\x{0338}", %p)},	undef,	"to_ascii\(\'\\u200C\。\=\\u0338\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:2428\]") or ($@ and diag($@));
is(eval{uts46_to_ascii(".xn--1ch", %p)},	undef,	"to_ascii\(\'\.xn\-\-1ch\'\)\ throws\ error\ V6\ A4_2\ \[data\/IdnaTest\.txt\:2430\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--0ug.xn--1ch", %p)},	undef,	"to_ascii\(\'xn\-\-0ug\.xn\-\-1ch\'\)\ throws\ error\ C1\ V6\ \[data\/IdnaTest\.txt\:2431\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_ascii("𑖿𝨔.ᡟ𑖿\x{1B42}\x{200C}", %p)},	undef,	"to_ascii\(\'𑖿𝨔\.ᡟ𑖿\\u1B42\\u200C\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:2432\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--461dw464a.xn--v8e29loy65a", %p)},	undef,	"to_ascii\(\'xn\-\-461dw464a\.xn\-\-v8e29loy65a\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:2434\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--461dw464a.xn--v8e29ldzfo952a", %p)},	undef,	"to_ascii\(\'xn\-\-461dw464a\.xn\-\-v8e29ldzfo952a\'\)\ throws\ error\ C1\ V5\ \[data\/IdnaTest\.txt\:2435\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򔣳\x{200D}򑝱.𖬴Ↄ≠-", %p)},	undef,	"to_ascii\(\'\?\\u200D\?\.𖬴Ↄ\≠\-\'\)\ throws\ error\ P1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:2436\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򔣳\x{200D}򑝱.𖬴Ↄ=\x{0338}-", %p)},	undef,	"to_ascii\(\'\?\\u200D\?\.𖬴Ↄ\=\\u0338\-\'\)\ throws\ error\ P1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:2438\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򔣳\x{200D}򑝱.𖬴ↄ=\x{0338}-", %p)},	undef,	"to_ascii\(\'\?\\u200D\?\.𖬴ↄ\=\\u0338\-\'\)\ throws\ error\ P1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:2440\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򔣳\x{200D}򑝱.𖬴ↄ≠-", %p)},	undef,	"to_ascii\(\'\?\\u200D\?\.𖬴ↄ\≠\-\'\)\ throws\ error\ P1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:2442\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--6j00chy9a.xn----81n51bt713h", %p)},	undef,	"to_ascii\(\'xn\-\-6j00chy9a\.xn\-\-\-\-81n51bt713h\'\)\ throws\ error\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:2444\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--1ug15151gkb5a.xn----81n51bt713h", %p)},	undef,	"to_ascii\(\'xn\-\-1ug15151gkb5a\.xn\-\-\-\-81n51bt713h\'\)\ throws\ error\ C2\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:2445\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--6j00chy9a.xn----61n81bt713h", %p)},	undef,	"to_ascii\(\'xn\-\-6j00chy9a\.xn\-\-\-\-61n81bt713h\'\)\ throws\ error\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:2446\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--1ug15151gkb5a.xn----61n81bt713h", %p)},	undef,	"to_ascii\(\'xn\-\-1ug15151gkb5a\.xn\-\-\-\-61n81bt713h\'\)\ throws\ error\ C2\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:2447\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{07E2}ς\x{200D}𝟳。蔑򛖢", %p)},	undef,	"to_ascii\(\'\\u07E2ς\\u200D𝟳\。蔑\?\'\)\ throws\ error\ B2\ P1\ V6\ \[data\/IdnaTest\.txt\:2448\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{07E2}ς\x{200D}7。蔑򛖢", %p)},	undef,	"to_ascii\(\'\\u07E2ς\\u200D7\。蔑\?\'\)\ throws\ error\ B2\ P1\ V6\ \[data\/IdnaTest\.txt\:2450\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{07E2}Σ\x{200D}7。蔑򛖢", %p)},	undef,	"to_ascii\(\'\\u07E2Σ\\u200D7\。蔑\?\'\)\ throws\ error\ B2\ P1\ V6\ \[data\/IdnaTest\.txt\:2452\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{07E2}σ\x{200D}7。蔑򛖢", %p)},	undef,	"to_ascii\(\'\\u07E2σ\\u200D7\。蔑\?\'\)\ throws\ error\ B2\ P1\ V6\ \[data\/IdnaTest\.txt\:2454\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--7-zmb872a.xn--wy1ao4929b", %p)},	undef,	"to_ascii\(\'xn\-\-7\-zmb872a\.xn\-\-wy1ao4929b\'\)\ throws\ error\ B2\ V6\ \[data\/IdnaTest\.txt\:2456\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--7-zmb872aez5a.xn--wy1ao4929b", %p)},	undef,	"to_ascii\(\'xn\-\-7\-zmb872aez5a\.xn\-\-wy1ao4929b\'\)\ throws\ error\ B2\ C2\ V6\ \[data\/IdnaTest\.txt\:2457\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--7-xmb182aez5a.xn--wy1ao4929b", %p)},	undef,	"to_ascii\(\'xn\-\-7\-xmb182aez5a\.xn\-\-wy1ao4929b\'\)\ throws\ error\ B2\ C2\ V6\ \[data\/IdnaTest\.txt\:2458\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{07E2}Σ\x{200D}𝟳。蔑򛖢", %p)},	undef,	"to_ascii\(\'\\u07E2Σ\\u200D𝟳\。蔑\?\'\)\ throws\ error\ B2\ P1\ V6\ \[data\/IdnaTest\.txt\:2459\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{07E2}σ\x{200D}𝟳。蔑򛖢", %p)},	undef,	"to_ascii\(\'\\u07E2σ\\u200D𝟳\。蔑\?\'\)\ throws\ error\ B2\ P1\ V6\ \[data\/IdnaTest\.txt\:2461\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐹰.\x{0600}", %p)},	undef,	"to_ascii\(\'𐹰\.\\u0600\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:2463\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--oo0d.xn--ifb", %p)},	undef,	"to_ascii\(\'xn\-\-oo0d\.xn\-\-ifb\'\)\ throws\ error\ B1\ V6\ \[data\/IdnaTest\.txt\:2464\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-\x{08A8}.𱠖", %p)},	undef,	"to_ascii\(\'\-\\u08A8\.𱠖\'\)\ throws\ error\ B1\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:2465\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----mod.xn--5o9n", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-mod\.xn\-\-5o9n\'\)\ throws\ error\ B1\ V3\ V6\ \[data\/IdnaTest\.txt\:2466\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≯𞱸󠇀。誆⒈", %p)},	undef,	"to_ascii\(\'\≯𞱸\󠇀\。誆⒈\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:2467\]") or ($@ and diag($@));
is(eval{uts46_to_ascii(">\x{0338}𞱸󠇀。誆⒈", %p)},	undef,	"to_ascii\(\'\>\\u0338𞱸\󠇀\。誆⒈\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:2468\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≯𞱸󠇀。誆1.", %p)},	undef,	"to_ascii\(\'\≯𞱸\󠇀\。誆1\.\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:2469\]") or ($@ and diag($@));
is(eval{uts46_to_ascii(">\x{0338}𞱸󠇀。誆1.", %p)},	undef,	"to_ascii\(\'\>\\u0338𞱸\󠇀\。誆1\.\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:2470\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--hdh7151p.xn--1-dy1d.", %p)},	undef,	"to_ascii\(\'xn\-\-hdh7151p\.xn\-\-1\-dy1d\.\'\)\ throws\ error\ B1\ V6\ \[data\/IdnaTest\.txt\:2471\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--hdh7151p.xn--tsh1248a", %p)},	undef,	"to_ascii\(\'xn\-\-hdh7151p\.xn\-\-tsh1248a\'\)\ throws\ error\ B1\ V6\ \[data\/IdnaTest\.txt\:2472\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0616}𞥙䐊\x{0650}．︒\x{0645}↺\x{069C}", %p)},	undef,	"to_ascii\(\'\\u0616𞥙䐊\\u0650．︒\\u0645\↺\\u069C\'\)\ throws\ error\ B1\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2473\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("\x{0616}𞥙䐊\x{0650}.。\x{0645}↺\x{069C}", %p)},	undef,	"to_ascii\(\'\\u0616𞥙䐊\\u0650\.\。\\u0645\↺\\u069C\'\)\ throws\ error\ B1\ V5\ A4_2\ \[data\/IdnaTest\.txt\:2474\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--4fb0j490qjg4x..xn--hhb8o948e", %p)},	undef,	"to_ascii\(\'xn\-\-4fb0j490qjg4x\.\.xn\-\-hhb8o948e\'\)\ throws\ error\ B1\ V5\ A4_2\ \[data\/IdnaTest\.txt\:2475\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--4fb0j490qjg4x.xn--hhb8o948euo5r", %p)},	undef,	"to_ascii\(\'xn\-\-4fb0j490qjg4x\.xn\-\-hhb8o948euo5r\'\)\ throws\ error\ B1\ V5\ V6\ \[data\/IdnaTest\.txt\:2476\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("퀬-\x{DF7E}񶳒.\x{200C}\x{0AC5}󩸤۴", %p)},	undef,	"to_ascii\(\'퀬\-\\uDF7E\?\.\\u200C\\u0AC5\?۴\'\)\ throws\ error\ P1\ V5\ V6\ A3\ \[data\/IdnaTest\.txt\:2477\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("퀬-\x{DF7E}񶳒.\x{200C}\x{0AC5}󩸤۴", %p)},	undef,	"to_ascii\(\'퀬\-\\uDF7E\?\.\\u200C\\u0AC5\?۴\'\)\ throws\ error\ P1\ V5\ V6\ A3\ \[data\/IdnaTest\.txt\:2479\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("퀬-\x{DF7E}񶳒.xn--hmb76q74166b", %p)},	undef,	"to_ascii\(\'퀬\-\\uDF7E\?\.xn\-\-hmb76q74166b\'\)\ throws\ error\ P1\ V5\ V6\ A3\ \[data\/IdnaTest\.txt\:2481\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("퀬-\x{DF7E}񶳒.xn--hmb76q74166b", %p)},	undef,	"to_ascii\(\'퀬\-\\uDF7E\?\.xn\-\-hmb76q74166b\'\)\ throws\ error\ P1\ V5\ V6\ A3\ \[data\/IdnaTest\.txt\:2482\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("퀬-\x{DF7E}񶳒.XN--HMB76Q74166B", %p)},	undef,	"to_ascii\(\'퀬\-\\uDF7E\?\.XN\-\-HMB76Q74166B\'\)\ throws\ error\ P1\ V5\ V6\ A3\ \[data\/IdnaTest\.txt\:2483\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("퀬-\x{DF7E}񶳒.XN--HMB76Q74166B", %p)},	undef,	"to_ascii\(\'퀬\-\\uDF7E\?\.XN\-\-HMB76Q74166B\'\)\ throws\ error\ P1\ V5\ V6\ A3\ \[data\/IdnaTest\.txt\:2484\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("퀬-\x{DF7E}񶳒.Xn--Hmb76q74166b", %p)},	undef,	"to_ascii\(\'퀬\-\\uDF7E\?\.Xn\-\-Hmb76q74166b\'\)\ throws\ error\ P1\ V5\ V6\ A3\ \[data\/IdnaTest\.txt\:2485\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("퀬-\x{DF7E}񶳒.Xn--Hmb76q74166b", %p)},	undef,	"to_ascii\(\'퀬\-\\uDF7E\?\.Xn\-\-Hmb76q74166b\'\)\ throws\ error\ P1\ V5\ V6\ A3\ \[data\/IdnaTest\.txt\:2486\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("퀬-\x{DF7E}񶳒.xn--hmb76q48y18505a", %p)},	undef,	"to_ascii\(\'퀬\-\\uDF7E\?\.xn\-\-hmb76q48y18505a\'\)\ throws\ error\ C1\ P1\ V6\ A3\ \[data\/IdnaTest\.txt\:2487\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("퀬-\x{DF7E}񶳒.xn--hmb76q48y18505a", %p)},	undef,	"to_ascii\(\'퀬\-\\uDF7E\?\.xn\-\-hmb76q48y18505a\'\)\ throws\ error\ C1\ P1\ V6\ A3\ \[data\/IdnaTest\.txt\:2488\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("퀬-\x{DF7E}񶳒.XN--HMB76Q48Y18505A", %p)},	undef,	"to_ascii\(\'퀬\-\\uDF7E\?\.XN\-\-HMB76Q48Y18505A\'\)\ throws\ error\ C1\ P1\ V6\ A3\ \[data\/IdnaTest\.txt\:2489\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("퀬-\x{DF7E}񶳒.XN--HMB76Q48Y18505A", %p)},	undef,	"to_ascii\(\'퀬\-\\uDF7E\?\.XN\-\-HMB76Q48Y18505A\'\)\ throws\ error\ C1\ P1\ V6\ A3\ \[data\/IdnaTest\.txt\:2490\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("퀬-\x{DF7E}񶳒.Xn--Hmb76q48y18505a", %p)},	undef,	"to_ascii\(\'퀬\-\\uDF7E\?\.Xn\-\-Hmb76q48y18505a\'\)\ throws\ error\ C1\ P1\ V6\ A3\ \[data\/IdnaTest\.txt\:2491\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("퀬-\x{DF7E}񶳒.Xn--Hmb76q48y18505a", %p)},	undef,	"to_ascii\(\'퀬\-\\uDF7E\?\.Xn\-\-Hmb76q48y18505a\'\)\ throws\ error\ C1\ P1\ V6\ A3\ \[data\/IdnaTest\.txt\:2492\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴌ.𐹾︒𑁿𞾄", %p)},	undef,	"to_ascii\(\'Ⴌ\.𐹾︒𑁿\?\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:2493\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴌ.𐹾。𑁿𞾄", %p)},	undef,	"to_ascii\(\'Ⴌ\.𐹾\。𑁿\?\'\)\ throws\ error\ B1\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2494\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⴌ.𐹾。𑁿𞾄", %p)},	undef,	"to_ascii\(\'ⴌ\.𐹾\。𑁿\?\'\)\ throws\ error\ B1\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2495\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--3kj.xn--2o0d.xn--q30dg029a", %p)},	undef,	"to_ascii\(\'xn\-\-3kj\.xn\-\-2o0d\.xn\-\-q30dg029a\'\)\ throws\ error\ B1\ V5\ V6\ \[data\/IdnaTest\.txt\:2496\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--knd.xn--2o0d.xn--q30dg029a", %p)},	undef,	"to_ascii\(\'xn\-\-knd\.xn\-\-2o0d\.xn\-\-q30dg029a\'\)\ throws\ error\ B1\ V5\ V6\ \[data\/IdnaTest\.txt\:2497\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⴌ.𐹾︒𑁿𞾄", %p)},	undef,	"to_ascii\(\'ⴌ\.𐹾︒𑁿\?\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:2498\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--3kj.xn--y86c030a9ob6374b", %p)},	undef,	"to_ascii\(\'xn\-\-3kj\.xn\-\-y86c030a9ob6374b\'\)\ throws\ error\ B1\ V6\ \[data\/IdnaTest\.txt\:2499\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--knd.xn--y86c030a9ob6374b", %p)},	undef,	"to_ascii\(\'xn\-\-knd\.xn\-\-y86c030a9ob6374b\'\)\ throws\ error\ B1\ V6\ \[data\/IdnaTest\.txt\:2500\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񧞿╏。𞩕󠁾", %p)},	undef,	"to_ascii\(\'\?\╏\。\?\?\'\)\ throws\ error\ B3\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:2501\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--iyh90030d.xn--1m6hs0260c", %p)},	undef,	"to_ascii\(\'xn\-\-iyh90030d\.xn\-\-1m6hs0260c\'\)\ throws\ error\ B3\ B6\ V6\ \[data\/IdnaTest\.txt\:2502\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("\x{200D}┮󠇐．\x{0C00}\x{0C4D}\x{1734}\x{200D}", %p)},	undef,	"to_ascii\(\'\\u200D\┮\󠇐．\\u0C00\\u0C4D\\u1734\\u200D\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:2503\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("\x{200D}┮󠇐.\x{0C00}\x{0C4D}\x{1734}\x{200D}", %p)},	undef,	"to_ascii\(\'\\u200D\┮\󠇐\.\\u0C00\\u0C4D\\u1734\\u200D\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:2505\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--kxh.xn--eoc8m432a", %p)},	undef,	"to_ascii\(\'xn\-\-kxh\.xn\-\-eoc8m432a\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:2507\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--1ug04r.xn--eoc8m432a40i", %p)},	undef,	"to_ascii\(\'xn\-\-1ug04r\.xn\-\-eoc8m432a40i\'\)\ throws\ error\ C2\ V5\ \[data\/IdnaTest\.txt\:2508\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򹚪｡🄂", %p)},	undef,	"to_ascii\(\'\?｡🄂\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2509\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򹚪。1,", %p)},	undef,	"to_ascii\(\'\?\。1\,\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2510\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--n433d.1,", %p)},	undef,	"to_ascii\(\'xn\-\-n433d\.1\,\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2511\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--n433d.xn--v07h", %p)},	undef,	"to_ascii\(\'xn\-\-n433d\.xn\-\-v07h\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:2512\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("𑍨刍.🛦", %p)},	undef,	"to_ascii\(\'𑍨刍\.🛦\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:2513\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--rbry728b.xn--y88h", %p)},	undef,	"to_ascii\(\'xn\-\-rbry728b\.xn\-\-y88h\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:2514\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠌏3｡\x{1BF1}𝟒", %p)},	undef,	"to_ascii\(\'\?3｡\\u1BF1𝟒\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2515\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠌏3。\x{1BF1}4", %p)},	undef,	"to_ascii\(\'\?3\。\\u1BF14\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2516\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--3-ib31m.xn--4-pql", %p)},	undef,	"to_ascii\(\'xn\-\-3\-ib31m\.xn\-\-4\-pql\'\)\ throws\ error\ V5\ V6\ \[data\/IdnaTest\.txt\:2517\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0687}６Ⴔ辘.\x{FD22}\x{0687}\x{200C}", %p)},	undef,	"to_ascii\(\'\\u0687６Ⴔ辘\.\\uFD22\\u0687\\u200C\'\)\ throws\ error\ B2\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:2518\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0687}6Ⴔ辘.\x{0635}\x{064A}\x{0687}\x{200C}", %p)},	undef,	"to_ascii\(\'\\u06876Ⴔ辘\.\\u0635\\u064A\\u0687\\u200C\'\)\ throws\ error\ B2\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:2520\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("\x{0687}6ⴔ辘.\x{0635}\x{064A}\x{0687}\x{200C}", %p)},	undef,	"to_ascii\(\'\\u06876ⴔ辘\.\\u0635\\u064A\\u0687\\u200C\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:2522\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--6-gsc2270akm6f.xn--0gb6bxk", %p)},	undef,	"to_ascii\(\'xn\-\-6\-gsc2270akm6f\.xn\-\-0gb6bxk\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:2524\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--6-gsc2270akm6f.xn--0gb6bxkx18g", %p)},	undef,	"to_ascii\(\'xn\-\-6\-gsc2270akm6f\.xn\-\-0gb6bxkx18g\'\)\ throws\ error\ B2\ B3\ C1\ \[data\/IdnaTest\.txt\:2525\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--6-gsc039eqq6k.xn--0gb6bxk", %p)},	undef,	"to_ascii\(\'xn\-\-6\-gsc039eqq6k\.xn\-\-0gb6bxk\'\)\ throws\ error\ B2\ B3\ V6\ \[data\/IdnaTest\.txt\:2526\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--6-gsc039eqq6k.xn--0gb6bxkx18g", %p)},	undef,	"to_ascii\(\'xn\-\-6\-gsc039eqq6k\.xn\-\-0gb6bxkx18g\'\)\ throws\ error\ B2\ B3\ C1\ V6\ \[data\/IdnaTest\.txt\:2527\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("\x{0687}６ⴔ辘.\x{FD22}\x{0687}\x{200C}", %p)},	undef,	"to_ascii\(\'\\u0687６ⴔ辘\.\\uFD22\\u0687\\u200C\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:2528\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("󠄍.𐮭𞰬򻫞۹", %p)},	undef,	"to_ascii\(\'\󠄍\.𐮭\?\?۹\'\)\ throws\ error\ B2\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:2530\]") or ($@ and diag($@));
is(eval{uts46_to_ascii(".xn--mmb3954kd0uf1zx7f", %p)},	undef,	"to_ascii\(\'\.xn\-\-mmb3954kd0uf1zx7f\'\)\ throws\ error\ B2\ V6\ A4_2\ \[data\/IdnaTest\.txt\:2531\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{A87D}≯．򻲀򒳄", %p)},	undef,	"to_ascii\(\'\\uA87D\≯．\?\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2532\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{A87D}>\x{0338}．򻲀򒳄", %p)},	undef,	"to_ascii\(\'\\uA87D\>\\u0338．\?\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2533\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{A87D}≯.򻲀򒳄", %p)},	undef,	"to_ascii\(\'\\uA87D\≯\.\?\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2534\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{A87D}>\x{0338}.򻲀򒳄", %p)},	undef,	"to_ascii\(\'\\uA87D\>\\u0338\.\?\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2535\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--hdh8193c.xn--5z40cp629b", %p)},	undef,	"to_ascii\(\'xn\-\-hdh8193c\.xn\-\-5z40cp629b\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:2536\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ςო\x{067B}.ς\x{0714}", %p)},	undef,	"to_ascii\(\'ςო\\u067B\.ς\\u0714\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:2537\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Σო\x{067B}.Σ\x{0714}", %p)},	undef,	"to_ascii\(\'Σო\\u067B\.Σ\\u0714\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:2539\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("σო\x{067B}.σ\x{0714}", %p)},	undef,	"to_ascii\(\'σო\\u067B\.σ\\u0714\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:2540\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Σო\x{067B}.σ\x{0714}", %p)},	undef,	"to_ascii\(\'Σო\\u067B\.σ\\u0714\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:2541\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--4xa60l26n.xn--4xa21o", %p)},	undef,	"to_ascii\(\'xn\-\-4xa60l26n\.xn\-\-4xa21o\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:2542\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Σო\x{067B}.ς\x{0714}", %p)},	undef,	"to_ascii\(\'Σო\\u067B\.ς\\u0714\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:2543\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("σო\x{067B}.ς\x{0714}", %p)},	undef,	"to_ascii\(\'σო\\u067B\.ς\\u0714\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:2545\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--4xa60l26n.xn--3xa41o", %p)},	undef,	"to_ascii\(\'xn\-\-4xa60l26n\.xn\-\-3xa41o\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:2547\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--3xa80l26n.xn--3xa41o", %p)},	undef,	"to_ascii\(\'xn\-\-3xa80l26n\.xn\-\-3xa41o\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:2548\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򄖚\x{0748}𠄯\x{075F}｡󠛩", %p)},	undef,	"to_ascii\(\'\?\\u0748𠄯\\u075F｡\?\'\)\ throws\ error\ B1\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:2549\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򄖚\x{0748}𠄯\x{075F}。󠛩", %p)},	undef,	"to_ascii\(\'\?\\u0748𠄯\\u075F\。\?\'\)\ throws\ error\ B1\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:2550\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--vob0c4369twfv8b.xn--kl46e", %p)},	undef,	"to_ascii\(\'xn\-\-vob0c4369twfv8b\.xn\-\-kl46e\'\)\ throws\ error\ B1\ B5\ B6\ V6\ \[data\/IdnaTest\.txt\:2551\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠳛．\x{200D}䤫≠Ⴞ", %p)},	undef,	"to_ascii\(\'\?．\\u200D䤫\≠Ⴞ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2552\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠳛．\x{200D}䤫=\x{0338}Ⴞ", %p)},	undef,	"to_ascii\(\'\?．\\u200D䤫\=\\u0338Ⴞ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2554\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠳛.\x{200D}䤫≠Ⴞ", %p)},	undef,	"to_ascii\(\'\?\.\\u200D䤫\≠Ⴞ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2556\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠳛.\x{200D}䤫=\x{0338}Ⴞ", %p)},	undef,	"to_ascii\(\'\?\.\\u200D䤫\=\\u0338Ⴞ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2558\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠳛.\x{200D}䤫=\x{0338}ⴞ", %p)},	undef,	"to_ascii\(\'\?\.\\u200D䤫\=\\u0338ⴞ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2560\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠳛.\x{200D}䤫≠ⴞ", %p)},	undef,	"to_ascii\(\'\?\.\\u200D䤫\≠ⴞ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2562\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--1t56e.xn--1ch153bqvw", %p)},	undef,	"to_ascii\(\'xn\-\-1t56e\.xn\-\-1ch153bqvw\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:2564\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--1t56e.xn--1ug73gzzpwi3a", %p)},	undef,	"to_ascii\(\'xn\-\-1t56e\.xn\-\-1ug73gzzpwi3a\'\)\ throws\ error\ C2\ V6\ \[data\/IdnaTest\.txt\:2565\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--1t56e.xn--2nd141ghl2a", %p)},	undef,	"to_ascii\(\'xn\-\-1t56e\.xn\-\-2nd141ghl2a\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:2566\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--1t56e.xn--2nd159e9vb743e", %p)},	undef,	"to_ascii\(\'xn\-\-1t56e\.xn\-\-2nd159e9vb743e\'\)\ throws\ error\ C2\ V6\ \[data\/IdnaTest\.txt\:2567\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠳛．\x{200D}䤫=\x{0338}ⴞ", %p)},	undef,	"to_ascii\(\'\?．\\u200D䤫\=\\u0338ⴞ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2568\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠳛．\x{200D}䤫≠ⴞ", %p)},	undef,	"to_ascii\(\'\?．\\u200D䤫\≠ⴞ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2570\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐽘𑈵．𐹣🕥", %p)},	undef,	"to_ascii\(\'𐽘𑈵．𐹣🕥\'\)\ throws\ error\ B1\ B2\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:2572\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐽘𑈵.𐹣🕥", %p)},	undef,	"to_ascii\(\'𐽘𑈵\.𐹣🕥\'\)\ throws\ error\ B1\ B2\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:2573\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--bv0d02c.xn--bo0dq650b", %p)},	undef,	"to_ascii\(\'xn\-\-bv0d02c\.xn\-\-bo0dq650b\'\)\ throws\ error\ B1\ B2\ B3\ V6\ \[data\/IdnaTest\.txt\:2574\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⒊⒈𑁄。9", %p)},	undef,	"to_ascii\(\'⒊⒈𑁄\。9\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2575\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_ascii("3.1.𑁄。9", %p)},	undef,	"to_ascii\(\'3\.1\.𑁄\。9\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:2576\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("3.1.xn--110d.9", %p)},	undef,	"to_ascii\(\'3\.1\.xn\-\-110d\.9\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:2577\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--tshd3512p.9", %p)},	undef,	"to_ascii\(\'xn\-\-tshd3512p\.9\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:2578\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-\x{200C}\x{2DF1}≮．𐹱򭏴4₉", %p)},	undef,	"to_ascii\(\'\-\\u200C\\u2DF1\≮．𐹱\?4₉\'\)\ throws\ error\ B1\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:2579\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-\x{200C}\x{2DF1}<\x{0338}．𐹱򭏴4₉", %p)},	undef,	"to_ascii\(\'\-\\u200C\\u2DF1\<\\u0338．𐹱\?4₉\'\)\ throws\ error\ B1\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:2581\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-\x{200C}\x{2DF1}≮.𐹱򭏴49", %p)},	undef,	"to_ascii\(\'\-\\u200C\\u2DF1\≮\.𐹱\?49\'\)\ throws\ error\ B1\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:2583\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-\x{200C}\x{2DF1}<\x{0338}.𐹱򭏴49", %p)},	undef,	"to_ascii\(\'\-\\u200C\\u2DF1\<\\u0338\.𐹱\?49\'\)\ throws\ error\ B1\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:2585\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----ngo823c.xn--49-ki3om2611f", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-ngo823c\.xn\-\-49\-ki3om2611f\'\)\ throws\ error\ B1\ V3\ V6\ \[data\/IdnaTest\.txt\:2587\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----sgn20i14s.xn--49-ki3om2611f", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-sgn20i14s\.xn\-\-49\-ki3om2611f\'\)\ throws\ error\ B1\ C1\ V3\ V6\ \[data\/IdnaTest\.txt\:2588\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-≯딾｡\x{0847}", %p)},	undef,	"to_ascii\(\'\-\≯딾｡\\u0847\'\)\ throws\ error\ B1\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:2589\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("->\x{0338}딾｡\x{0847}", %p)},	undef,	"to_ascii\(\'\-\>\\u0338딾｡\\u0847\'\)\ throws\ error\ B1\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:2590\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-≯딾。\x{0847}", %p)},	undef,	"to_ascii\(\'\-\≯딾\。\\u0847\'\)\ throws\ error\ B1\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:2591\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("->\x{0338}딾。\x{0847}", %p)},	undef,	"to_ascii\(\'\-\>\\u0338딾\。\\u0847\'\)\ throws\ error\ B1\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:2592\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----pgow547d.xn--5vb", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-pgow547d\.xn\-\-5vb\'\)\ throws\ error\ B1\ V3\ V6\ \[data\/IdnaTest\.txt\:2593\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𑙢⒈𐹠-｡󠗐\x{200C}", %p)},	undef,	"to_ascii\(\'𑙢⒈𐹠\-｡\?\\u200C\'\)\ throws\ error\ B1\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:2594\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𑙢1.𐹠-。󠗐\x{200C}", %p)},	undef,	"to_ascii\(\'𑙢1\.𐹠\-\。\?\\u200C\'\)\ throws\ error\ B1\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:2596\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--1-bf0j.xn----516i.xn--jd46e", %p)},	undef,	"to_ascii\(\'xn\-\-1\-bf0j\.xn\-\-\-\-516i\.xn\-\-jd46e\'\)\ throws\ error\ B1\ V3\ V6\ \[data\/IdnaTest\.txt\:2598\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--1-bf0j.xn----516i.xn--0ug23321l", %p)},	undef,	"to_ascii\(\'xn\-\-1\-bf0j\.xn\-\-\-\-516i\.xn\-\-0ug23321l\'\)\ throws\ error\ B1\ C1\ V3\ V6\ \[data\/IdnaTest\.txt\:2599\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----dcpy090hiyg.xn--jd46e", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-dcpy090hiyg\.xn\-\-jd46e\'\)\ throws\ error\ B1\ V3\ V6\ \[data\/IdnaTest\.txt\:2600\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----dcpy090hiyg.xn--0ug23321l", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-dcpy090hiyg\.xn\-\-0ug23321l\'\)\ throws\ error\ B1\ C1\ V3\ V6\ \[data\/IdnaTest\.txt\:2601\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("\x{034A}．𐨎", %p)},	undef,	"to_ascii\(\'\\u034A．𐨎\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:2602\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("\x{034A}.𐨎", %p)},	undef,	"to_ascii\(\'\\u034A\.𐨎\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:2603\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--oua.xn--mr9c", %p)},	undef,	"to_ascii\(\'xn\-\-oua\.xn\-\-mr9c\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:2604\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("훉≮｡\x{0E34}", %p)},	undef,	"to_ascii\(\'훉\≮｡\\u0E34\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2605\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("훉<\x{0338}｡\x{0E34}", %p)},	undef,	"to_ascii\(\'훉\<\\u0338｡\\u0E34\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2606\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("훉≮。\x{0E34}", %p)},	undef,	"to_ascii\(\'훉\≮\。\\u0E34\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2607\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("훉<\x{0338}。\x{0E34}", %p)},	undef,	"to_ascii\(\'훉\<\\u0338\。\\u0E34\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2608\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--gdh2512e.xn--i4c", %p)},	undef,	"to_ascii\(\'xn\-\-gdh2512e\.xn\-\-i4c\'\)\ throws\ error\ V5\ V6\ \[data\/IdnaTest\.txt\:2609\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{2DF7}򞣉🃘．𴈇𝟸\x{0659}𞤯", %p)},	undef,	"to_ascii\(\'\\u2DF7\?🃘．\?𝟸\\u0659𞤯\'\)\ throws\ error\ B1\ B5\ B6\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2610\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{2DF7}򞣉🃘.𴈇2\x{0659}𞤯", %p)},	undef,	"to_ascii\(\'\\u2DF7\?🃘\.\?2\\u0659𞤯\'\)\ throws\ error\ B1\ B5\ B6\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2611\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{2DF7}򞣉🃘.𴈇2\x{0659}𞤍", %p)},	undef,	"to_ascii\(\'\\u2DF7\?🃘\.\?2\\u0659𞤍\'\)\ throws\ error\ B1\ B5\ B6\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2612\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--trj8045le6s9b.xn--2-upc23918acjsj", %p)},	undef,	"to_ascii\(\'xn\-\-trj8045le6s9b\.xn\-\-2\-upc23918acjsj\'\)\ throws\ error\ B1\ B5\ B6\ V5\ V6\ \[data\/IdnaTest\.txt\:2613\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{2DF7}򞣉🃘．𴈇𝟸\x{0659}𞤍", %p)},	undef,	"to_ascii\(\'\\u2DF7\?🃘．\?𝟸\\u0659𞤍\'\)\ throws\ error\ B1\ B5\ B6\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2614\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󗇩ßᢞ\x{200C}。\x{0660}𞷻\x{FCD4}-", %p)},	undef,	"to_ascii\(\'\?ßᢞ\\u200C\。\\u0660\?\\uFCD4\-\'\)\ throws\ error\ B1\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:2615\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󗇩ßᢞ\x{200C}。\x{0660}𞷻\x{0646}\x{062E}-", %p)},	undef,	"to_ascii\(\'\?ßᢞ\\u200C\。\\u0660\?\\u0646\\u062E\-\'\)\ throws\ error\ B1\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:2617\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󗇩SSᢞ\x{200C}。\x{0660}𞷻\x{0646}\x{062E}-", %p)},	undef,	"to_ascii\(\'\?SSᢞ\\u200C\。\\u0660\?\\u0646\\u062E\-\'\)\ throws\ error\ B1\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:2619\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󗇩ssᢞ\x{200C}。\x{0660}𞷻\x{0646}\x{062E}-", %p)},	undef,	"to_ascii\(\'\?ssᢞ\\u200C\。\\u0660\?\\u0646\\u062E\-\'\)\ throws\ error\ B1\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:2621\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󗇩Ssᢞ\x{200C}。\x{0660}𞷻\x{0646}\x{062E}-", %p)},	undef,	"to_ascii\(\'\?Ssᢞ\\u200C\。\\u0660\?\\u0646\\u062E\-\'\)\ throws\ error\ B1\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:2623\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--ss-jepz4596r.xn----dnc5e1er384z", %p)},	undef,	"to_ascii\(\'xn\-\-ss\-jepz4596r\.xn\-\-\-\-dnc5e1er384z\'\)\ throws\ error\ B1\ V3\ V6\ \[data\/IdnaTest\.txt\:2625\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--ss-jep006bqt765b.xn----dnc5e1er384z", %p)},	undef,	"to_ascii\(\'xn\-\-ss\-jep006bqt765b\.xn\-\-\-\-dnc5e1er384z\'\)\ throws\ error\ B1\ B6\ C1\ V3\ V6\ \[data\/IdnaTest\.txt\:2626\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--zca272jbif10059a.xn----dnc5e1er384z", %p)},	undef,	"to_ascii\(\'xn\-\-zca272jbif10059a\.xn\-\-\-\-dnc5e1er384z\'\)\ throws\ error\ B1\ B6\ C1\ V3\ V6\ \[data\/IdnaTest\.txt\:2627\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󗇩SSᢞ\x{200C}。\x{0660}𞷻\x{FCD4}-", %p)},	undef,	"to_ascii\(\'\?SSᢞ\\u200C\。\\u0660\?\\uFCD4\-\'\)\ throws\ error\ B1\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:2628\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󗇩ssᢞ\x{200C}。\x{0660}𞷻\x{FCD4}-", %p)},	undef,	"to_ascii\(\'\?ssᢞ\\u200C\。\\u0660\?\\uFCD4\-\'\)\ throws\ error\ B1\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:2630\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󗇩Ssᢞ\x{200C}。\x{0660}𞷻\x{FCD4}-", %p)},	undef,	"to_ascii\(\'\?Ssᢞ\\u200C\。\\u0660\?\\uFCD4\-\'\)\ throws\ error\ B1\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:2632\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ꡆ。Ↄ\x{0FB5}놮-", %p)},	undef,	"to_ascii\(\'ꡆ\。Ↄ\\u0FB5놮\-\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:2634\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ꡆ。Ↄ\x{0FB5}놮-", %p)},	undef,	"to_ascii\(\'ꡆ\。Ↄ\\u0FB5놮\-\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:2635\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_ascii("ꡆ。ↄ\x{0FB5}놮-", %p)},	undef,	"to_ascii\(\'ꡆ\。ↄ\\u0FB5놮\-\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:2636\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_ascii("ꡆ。ↄ\x{0FB5}놮-", %p)},	undef,	"to_ascii\(\'ꡆ\。ↄ\\u0FB5놮\-\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:2637\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--fc9a.xn----qmg097k469k", %p)},	undef,	"to_ascii\(\'xn\-\-fc9a\.xn\-\-\-\-qmg097k469k\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:2638\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--fc9a.xn----qmg787k869k", %p)},	undef,	"to_ascii\(\'xn\-\-fc9a\.xn\-\-\-\-qmg787k869k\'\)\ throws\ error\ V3\ V6\ \[data\/IdnaTest\.txt\:2639\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{FDAD}\x{200D}.񥰌\x{06A9}", %p)},	undef,	"to_ascii\(\'\\uFDAD\\u200D\.\?\\u06A9\'\)\ throws\ error\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:2640\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0644}\x{0645}\x{064A}\x{200D}.񥰌\x{06A9}", %p)},	undef,	"to_ascii\(\'\\u0644\\u0645\\u064A\\u200D\.\?\\u06A9\'\)\ throws\ error\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:2642\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--ghbcp.xn--ckb36214f", %p)},	undef,	"to_ascii\(\'xn\-\-ghbcp\.xn\-\-ckb36214f\'\)\ throws\ error\ B5\ B6\ V6\ \[data\/IdnaTest\.txt\:2644\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--ghbcp494x.xn--ckb36214f", %p)},	undef,	"to_ascii\(\'xn\-\-ghbcp494x\.xn\-\-ckb36214f\'\)\ throws\ error\ B3\ B5\ B6\ C2\ V6\ \[data\/IdnaTest\.txt\:2645\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴜ\x{1C2F}𐳒≯。\x{06E0}\x{1732}\x{0FBA}", %p)},	undef,	"to_ascii\(\'Ⴜ\\u1C2F𐳒\≯\。\\u06E0\\u1732\\u0FBA\'\)\ throws\ error\ B1\ B3\ B5\ B6\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2646\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴜ\x{1C2F}𐳒>\x{0338}。\x{06E0}\x{1732}\x{0FBA}", %p)},	undef,	"to_ascii\(\'Ⴜ\\u1C2F𐳒\>\\u0338\。\\u06E0\\u1732\\u0FBA\'\)\ throws\ error\ B1\ B3\ B5\ B6\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2647\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⴜ\x{1C2F}𐳒>\x{0338}。\x{06E0}\x{1732}\x{0FBA}", %p)},	undef,	"to_ascii\(\'ⴜ\\u1C2F𐳒\>\\u0338\。\\u06E0\\u1732\\u0FBA\'\)\ throws\ error\ B1\ B3\ B5\ B6\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2648\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⴜ\x{1C2F}𐳒≯。\x{06E0}\x{1732}\x{0FBA}", %p)},	undef,	"to_ascii\(\'ⴜ\\u1C2F𐳒\≯\。\\u06E0\\u1732\\u0FBA\'\)\ throws\ error\ B1\ B3\ B5\ B6\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2649\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴜ\x{1C2F}𐲒≯。\x{06E0}\x{1732}\x{0FBA}", %p)},	undef,	"to_ascii\(\'Ⴜ\\u1C2F𐲒\≯\。\\u06E0\\u1732\\u0FBA\'\)\ throws\ error\ B1\ B3\ B5\ B6\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2650\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴜ\x{1C2F}𐲒>\x{0338}。\x{06E0}\x{1732}\x{0FBA}", %p)},	undef,	"to_ascii\(\'Ⴜ\\u1C2F𐲒\>\\u0338\。\\u06E0\\u1732\\u0FBA\'\)\ throws\ error\ B1\ B3\ B5\ B6\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2651\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--0nd679cf3eq67y.xn--wlb646b4ng", %p)},	undef,	"to_ascii\(\'xn\-\-0nd679cf3eq67y\.xn\-\-wlb646b4ng\'\)\ throws\ error\ B1\ B3\ B5\ B6\ V5\ V6\ \[data\/IdnaTest\.txt\:2652\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--r1f68xh1jgv7u.xn--wlb646b4ng", %p)},	undef,	"to_ascii\(\'xn\-\-r1f68xh1jgv7u\.xn\-\-wlb646b4ng\'\)\ throws\ error\ B1\ B3\ B5\ B6\ V5\ V6\ \[data\/IdnaTest\.txt\:2653\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("𐋵。\x{FCEC}", %p)},	undef,	"to_ascii\(\'𐋵\。\\uFCEC\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:2654\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("𐋵。\x{0643}\x{0645}", %p)},	undef,	"to_ascii\(\'𐋵\。\\u0643\\u0645\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:2655\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--p97c.xn--fhbe", %p)},	undef,	"to_ascii\(\'xn\-\-p97c\.xn\-\-fhbe\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:2656\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("𐋵.\x{0643}\x{0645}", %p)},	undef,	"to_ascii\(\'𐋵\.\\u0643\\u0645\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:2657\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("≮𝅶．񱲁\x{AAEC}⹈󰥭", %p)},	undef,	"to_ascii\(\'\≮\?．\?\\uAAEC\⹈\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2658\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("<\x{0338}𝅶．񱲁\x{AAEC}⹈󰥭", %p)},	undef,	"to_ascii\(\'\<\\u0338\?．\?\\uAAEC\⹈\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2659\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≮𝅶.񱲁\x{AAEC}⹈󰥭", %p)},	undef,	"to_ascii\(\'\≮\?\.\?\\uAAEC\⹈\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2660\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("<\x{0338}𝅶.񱲁\x{AAEC}⹈󰥭", %p)},	undef,	"to_ascii\(\'\<\\u0338\?\.\?\\uAAEC\⹈\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2661\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--gdh0880o.xn--4tjx101bsg00ds9pyc", %p)},	undef,	"to_ascii\(\'xn\-\-gdh0880o\.xn\-\-4tjx101bsg00ds9pyc\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:2662\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{2DF0}\x{0358}ᢕ．\x{0361}𐹷󠴍", %p)},	undef,	"to_ascii\(\'\\u2DF0\\u0358ᢕ．\\u0361𐹷\?\'\)\ throws\ error\ B1\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2663\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{2DF0}\x{0358}ᢕ.\x{0361}𐹷󠴍", %p)},	undef,	"to_ascii\(\'\\u2DF0\\u0358ᢕ\.\\u0361𐹷\?\'\)\ throws\ error\ B1\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2664\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--2ua889htsp.xn--cva2687k2tv0g", %p)},	undef,	"to_ascii\(\'xn\-\-2ua889htsp\.xn\-\-cva2687k2tv0g\'\)\ throws\ error\ B1\ V5\ V6\ \[data\/IdnaTest\.txt\:2665\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("\x{FD79}ᡐ\x{200C}\x{06AD}．𑋪\x{05C7}", %p)},	undef,	"to_ascii\(\'\\uFD79ᡐ\\u200C\\u06AD．𑋪\\u05C7\'\)\ throws\ error\ B1\ B2\ B3\ B6\ V5\ \[data\/IdnaTest\.txt\:2666\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("\x{063A}\x{0645}\x{0645}ᡐ\x{200C}\x{06AD}.𑋪\x{05C7}", %p)},	undef,	"to_ascii\(\'\\u063A\\u0645\\u0645ᡐ\\u200C\\u06AD\.𑋪\\u05C7\'\)\ throws\ error\ B1\ B2\ B3\ B6\ V5\ \[data\/IdnaTest\.txt\:2668\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--5gbwa03bg24e.xn--vdb1198k", %p)},	undef,	"to_ascii\(\'xn\-\-5gbwa03bg24e\.xn\-\-vdb1198k\'\)\ throws\ error\ B1\ B2\ B3\ B6\ V5\ \[data\/IdnaTest\.txt\:2670\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--5gbwa03bg24eptk.xn--vdb1198k", %p)},	undef,	"to_ascii\(\'xn\-\-5gbwa03bg24eptk\.xn\-\-vdb1198k\'\)\ throws\ error\ B1\ B2\ B3\ B6\ V5\ \[data\/IdnaTest\.txt\:2671\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𑑂｡\x{200D}󥞀🞕򥁔", %p)},	undef,	"to_ascii\(\'𑑂｡\\u200D\?🞕\?\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2672\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𑑂。\x{200D}󥞀🞕򥁔", %p)},	undef,	"to_ascii\(\'𑑂\。\\u200D\?🞕\?\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2674\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--8v1d.xn--ye9h41035a2qqs", %p)},	undef,	"to_ascii\(\'xn\-\-8v1d\.xn\-\-ye9h41035a2qqs\'\)\ throws\ error\ V5\ V6\ \[data\/IdnaTest\.txt\:2676\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--8v1d.xn--1ug1386plvx1cd8vya", %p)},	undef,	"to_ascii\(\'xn\-\-8v1d\.xn\-\-1ug1386plvx1cd8vya\'\)\ throws\ error\ C2\ V5\ V6\ \[data\/IdnaTest\.txt\:2677\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-\x{05E9}。⒚", %p)},	undef,	"to_ascii\(\'\-\\u05E9\。⒚\'\)\ throws\ error\ B1\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:2678\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-\x{05E9}。19.", %p)},	undef,	"to_ascii\(\'\-\\u05E9\。19\.\'\)\ throws\ error\ B1\ V3\ \[data\/IdnaTest\.txt\:2679\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----gjc.19.", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-gjc\.19\.\'\)\ throws\ error\ B1\ V3\ \[data\/IdnaTest\.txt\:2680\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----gjc.xn--cth", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-gjc\.xn\-\-cth\'\)\ throws\ error\ B1\ V3\ V6\ \[data\/IdnaTest\.txt\:2681\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("􊾻\x{0845}\x{200C}｡ᢎ\x{200D}", %p)},	undef,	"to_ascii\(\'\?\\u0845\\u200C｡ᢎ\\u200D\'\)\ throws\ error\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:2682\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("􊾻\x{0845}\x{200C}。ᢎ\x{200D}", %p)},	undef,	"to_ascii\(\'\?\\u0845\\u200C\。ᢎ\\u200D\'\)\ throws\ error\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:2684\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--3vb50049s.xn--79e", %p)},	undef,	"to_ascii\(\'xn\-\-3vb50049s\.xn\-\-79e\'\)\ throws\ error\ B5\ B6\ V6\ \[data\/IdnaTest\.txt\:2686\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--3vb882jz4411a.xn--79e259a", %p)},	undef,	"to_ascii\(\'xn\-\-3vb882jz4411a\.xn\-\-79e259a\'\)\ throws\ error\ B5\ B6\ C1\ C2\ V6\ \[data\/IdnaTest\.txt\:2687\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("ß\x{09C1}\x{1DED}。\x{0620}8₅", %p)},	"xn--ss-e2f077r.xn--85-psd",	"to_ascii\(\'ß\\u09C1\\u1DED\。\\u06208₅\'\)\ \[data\/IdnaTest\.txt\:2688\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("ß\x{09C1}\x{1DED}。\x{0620}85", %p)},	"xn--ss-e2f077r.xn--85-psd",	"to_ascii\(\'ß\\u09C1\\u1DED\。\\u062085\'\)\ \[data\/IdnaTest\.txt\:2690\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("SS\x{09C1}\x{1DED}。\x{0620}85", %p)},	"xn--ss-e2f077r.xn--85-psd",	"to_ascii\(\'SS\\u09C1\\u1DED\。\\u062085\'\)\ \[data\/IdnaTest\.txt\:2692\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("ss\x{09C1}\x{1DED}。\x{0620}85", %p)},	"xn--ss-e2f077r.xn--85-psd",	"to_ascii\(\'ss\\u09C1\\u1DED\。\\u062085\'\)\ \[data\/IdnaTest\.txt\:2693\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("Ss\x{09C1}\x{1DED}。\x{0620}85", %p)},	"xn--ss-e2f077r.xn--85-psd",	"to_ascii\(\'Ss\\u09C1\\u1DED\。\\u062085\'\)\ \[data\/IdnaTest\.txt\:2694\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("xn--ss-e2f077r.xn--85-psd", %p)},	"xn--ss-e2f077r.xn--85-psd",	"to_ascii\(\'xn\-\-ss\-e2f077r\.xn\-\-85\-psd\'\)\ \[data\/IdnaTest\.txt\:2695\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("ss\x{09C1}\x{1DED}.\x{0620}85", %p)},	"xn--ss-e2f077r.xn--85-psd",	"to_ascii\(\'ss\\u09C1\\u1DED\.\\u062085\'\)\ \[data\/IdnaTest\.txt\:2696\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("SS\x{09C1}\x{1DED}.\x{0620}85", %p)},	"xn--ss-e2f077r.xn--85-psd",	"to_ascii\(\'SS\\u09C1\\u1DED\.\\u062085\'\)\ \[data\/IdnaTest\.txt\:2697\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("Ss\x{09C1}\x{1DED}.\x{0620}85", %p)},	"xn--ss-e2f077r.xn--85-psd",	"to_ascii\(\'Ss\\u09C1\\u1DED\.\\u062085\'\)\ \[data\/IdnaTest\.txt\:2698\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("xn--zca266bwrr.xn--85-psd", %p)},	"xn--zca266bwrr.xn--85-psd",	"to_ascii\(\'xn\-\-zca266bwrr\.xn\-\-85\-psd\'\)\ \[data\/IdnaTest\.txt\:2699\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("ß\x{09C1}\x{1DED}.\x{0620}85", %p)},	"xn--ss-e2f077r.xn--85-psd",	"to_ascii\(\'ß\\u09C1\\u1DED\.\\u062085\'\)\ \[data\/IdnaTest\.txt\:2700\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("SS\x{09C1}\x{1DED}。\x{0620}8₅", %p)},	"xn--ss-e2f077r.xn--85-psd",	"to_ascii\(\'SS\\u09C1\\u1DED\。\\u06208₅\'\)\ \[data\/IdnaTest\.txt\:2702\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("ss\x{09C1}\x{1DED}。\x{0620}8₅", %p)},	"xn--ss-e2f077r.xn--85-psd",	"to_ascii\(\'ss\\u09C1\\u1DED\。\\u06208₅\'\)\ \[data\/IdnaTest\.txt\:2703\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("Ss\x{09C1}\x{1DED}。\x{0620}8₅", %p)},	"xn--ss-e2f077r.xn--85-psd",	"to_ascii\(\'Ss\\u09C1\\u1DED\。\\u06208₅\'\)\ \[data\/IdnaTest\.txt\:2704\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("\x{0ACD}\x{0484}魅𝟣．₃𐹥ß", %p)},	undef,	"to_ascii\(\'\\u0ACD\\u0484魅𝟣．₃𐹥ß\'\)\ throws\ error\ B1\ V5\ \[data\/IdnaTest\.txt\:2705\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("\x{0ACD}\x{0484}魅1.3𐹥ß", %p)},	undef,	"to_ascii\(\'\\u0ACD\\u0484魅1\.3𐹥ß\'\)\ throws\ error\ B1\ V5\ \[data\/IdnaTest\.txt\:2707\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("\x{0ACD}\x{0484}魅1.3𐹥SS", %p)},	undef,	"to_ascii\(\'\\u0ACD\\u0484魅1\.3𐹥SS\'\)\ throws\ error\ B1\ V5\ \[data\/IdnaTest\.txt\:2709\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("\x{0ACD}\x{0484}魅1.3𐹥ss", %p)},	undef,	"to_ascii\(\'\\u0ACD\\u0484魅1\.3𐹥ss\'\)\ throws\ error\ B1\ V5\ \[data\/IdnaTest\.txt\:2710\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("\x{0ACD}\x{0484}魅1.3𐹥Ss", %p)},	undef,	"to_ascii\(\'\\u0ACD\\u0484魅1\.3𐹥Ss\'\)\ throws\ error\ B1\ V5\ \[data\/IdnaTest\.txt\:2711\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--1-0xb049b102o.xn--3ss-nv9t", %p)},	undef,	"to_ascii\(\'xn\-\-1\-0xb049b102o\.xn\-\-3ss\-nv9t\'\)\ throws\ error\ B1\ V5\ \[data\/IdnaTest\.txt\:2712\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--1-0xb049b102o.xn--3-qfa7018r", %p)},	undef,	"to_ascii\(\'xn\-\-1\-0xb049b102o\.xn\-\-3\-qfa7018r\'\)\ throws\ error\ B1\ V5\ \[data\/IdnaTest\.txt\:2713\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("\x{0ACD}\x{0484}魅𝟣．₃𐹥SS", %p)},	undef,	"to_ascii\(\'\\u0ACD\\u0484魅𝟣．₃𐹥SS\'\)\ throws\ error\ B1\ V5\ \[data\/IdnaTest\.txt\:2714\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("\x{0ACD}\x{0484}魅𝟣．₃𐹥ss", %p)},	undef,	"to_ascii\(\'\\u0ACD\\u0484魅𝟣．₃𐹥ss\'\)\ throws\ error\ B1\ V5\ \[data\/IdnaTest\.txt\:2715\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("\x{0ACD}\x{0484}魅𝟣．₃𐹥Ss", %p)},	undef,	"to_ascii\(\'\\u0ACD\\u0484魅𝟣．₃𐹥Ss\'\)\ throws\ error\ B1\ V5\ \[data\/IdnaTest\.txt\:2716\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("\x{072B}｡𑓂⒈𑜫󠿻", %p)},	undef,	"to_ascii\(\'\\u072B｡𑓂⒈𑜫\?\'\)\ throws\ error\ B1\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2717\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{072B}。𑓂1.𑜫󠿻", %p)},	undef,	"to_ascii\(\'\\u072B\。𑓂1\.𑜫\?\'\)\ throws\ error\ B1\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2718\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--1nb.xn--1-jq9i.xn--ji2dg9877c", %p)},	undef,	"to_ascii\(\'xn\-\-1nb\.xn\-\-1\-jq9i\.xn\-\-ji2dg9877c\'\)\ throws\ error\ B1\ V5\ V6\ \[data\/IdnaTest\.txt\:2719\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--1nb.xn--tsh7798f6rbrt828c", %p)},	undef,	"to_ascii\(\'xn\-\-1nb\.xn\-\-tsh7798f6rbrt828c\'\)\ throws\ error\ B1\ V5\ V6\ \[data\/IdnaTest\.txt\:2720\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{FE0D}છ。嵨", %p)},	"xn--6dc.xn--tot",	"to_ascii\(\'\\uFE0Dછ\。嵨\'\)\ \[data\/IdnaTest\.txt\:2721\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--6dc.xn--tot", %p)},	"xn--6dc.xn--tot",	"to_ascii\(\'xn\-\-6dc\.xn\-\-tot\'\)\ \[data\/IdnaTest\.txt\:2722\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("છ.嵨", %p)},	"xn--6dc.xn--tot",	"to_ascii\(\'છ\.嵨\'\)\ \[data\/IdnaTest\.txt\:2723\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴔ≠Ⴀ.𐹥𐹰", %p)},	undef,	"to_ascii\(\'Ⴔ\≠Ⴀ\.𐹥𐹰\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:2724\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴔ=\x{0338}Ⴀ.𐹥𐹰", %p)},	undef,	"to_ascii\(\'Ⴔ\=\\u0338Ⴀ\.𐹥𐹰\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:2725\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⴔ=\x{0338}ⴀ.𐹥𐹰", %p)},	undef,	"to_ascii\(\'ⴔ\=\\u0338ⴀ\.𐹥𐹰\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:2726\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⴔ≠ⴀ.𐹥𐹰", %p)},	undef,	"to_ascii\(\'ⴔ\≠ⴀ\.𐹥𐹰\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:2727\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--1ch603bxb.xn--do0dwa", %p)},	undef,	"to_ascii\(\'xn\-\-1ch603bxb\.xn\-\-do0dwa\'\)\ throws\ error\ B1\ V6\ \[data\/IdnaTest\.txt\:2728\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--7md3b171g.xn--do0dwa", %p)},	undef,	"to_ascii\(\'xn\-\-7md3b171g\.xn\-\-do0dwa\'\)\ throws\ error\ B1\ V6\ \[data\/IdnaTest\.txt\:2729\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-\x{200C}⒙𐫥｡𝨵", %p)},	undef,	"to_ascii\(\'\-\\u200C⒙𐫥｡𝨵\'\)\ throws\ error\ P1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:2730\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_ascii("-\x{200C}18.𐫥。𝨵", %p)},	undef,	"to_ascii\(\'\-\\u200C18\.𐫥\。𝨵\'\)\ throws\ error\ V3\ V5\ \[data\/IdnaTest\.txt\:2732\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("-18.xn--rx9c.xn--382h", %p)},	undef,	"to_ascii\(\'\-18\.xn\-\-rx9c\.xn\-\-382h\'\)\ throws\ error\ V3\ V5\ \[data\/IdnaTest\.txt\:2734\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn---18-9m0a.xn--rx9c.xn--382h", %p)},	undef,	"to_ascii\(\'xn\-\-\-18\-9m0a\.xn\-\-rx9c\.xn\-\-382h\'\)\ throws\ error\ C1\ V3\ V5\ \[data\/IdnaTest\.txt\:2735\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----ddps939g.xn--382h", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-ddps939g\.xn\-\-382h\'\)\ throws\ error\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:2736\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----sgn18r3191a.xn--382h", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-sgn18r3191a\.xn\-\-382h\'\)\ throws\ error\ C1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:2737\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("︒.ʌᠣ-𐹽", %p)},	undef,	"to_ascii\(\'︒\.ʌᠣ\-𐹽\'\)\ throws\ error\ B1\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:2738\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("。.ʌᠣ-𐹽", %p)},	undef,	"to_ascii\(\'\。\.ʌᠣ\-𐹽\'\)\ throws\ error\ B5\ B6\ A4_2\ \[data\/IdnaTest\.txt\:2739\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("。.Ʌᠣ-𐹽", %p)},	undef,	"to_ascii\(\'\。\.Ʌᠣ\-𐹽\'\)\ throws\ error\ B5\ B6\ A4_2\ \[data\/IdnaTest\.txt\:2740\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("..xn----73a596nuh9t", %p)},	undef,	"to_ascii\(\'\.\.xn\-\-\-\-73a596nuh9t\'\)\ throws\ error\ B5\ B6\ A4_2\ \[data\/IdnaTest\.txt\:2741\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("︒.Ʌᠣ-𐹽", %p)},	undef,	"to_ascii\(\'︒\.Ʌᠣ\-𐹽\'\)\ throws\ error\ B1\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:2742\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--y86c.xn----73a596nuh9t", %p)},	undef,	"to_ascii\(\'xn\-\-y86c\.xn\-\-\-\-73a596nuh9t\'\)\ throws\ error\ B1\ B5\ B6\ V6\ \[data\/IdnaTest\.txt\:2743\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{FE05}︒。𦀾\x{1CE0}", %p)},	undef,	"to_ascii\(\'\\uFE05︒\。𦀾\\u1CE0\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2744\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("\x{FE05}。。𦀾\x{1CE0}", %p)},	undef,	"to_ascii\(\'\\uFE05\。\。𦀾\\u1CE0\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:2745\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("..xn--t6f5138v", %p)},	undef,	"to_ascii\(\'\.\.xn\-\-t6f5138v\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:2746\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--y86c.xn--t6f5138v", %p)},	undef,	"to_ascii\(\'xn\-\-y86c\.xn\-\-t6f5138v\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:2747\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("xn--t6f5138v", %p)},	"xn--t6f5138v",	"to_ascii\(\'xn\-\-t6f5138v\'\)\ \[data\/IdnaTest\.txt\:2748\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("𦀾\x{1CE0}", %p)},	"xn--t6f5138v",	"to_ascii\(\'𦀾\\u1CE0\'\)\ \[data\/IdnaTest\.txt\:2749\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("𞮑ß􏞞。ᡁ", %p)},	undef,	"to_ascii\(\'\?ß\?\。ᡁ\'\)\ throws\ error\ B2\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:2750\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𞮑SS􏞞。ᡁ", %p)},	undef,	"to_ascii\(\'\?SS\?\。ᡁ\'\)\ throws\ error\ B2\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:2752\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𞮑ss􏞞。ᡁ", %p)},	undef,	"to_ascii\(\'\?ss\?\。ᡁ\'\)\ throws\ error\ B2\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:2753\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𞮑Ss􏞞。ᡁ", %p)},	undef,	"to_ascii\(\'\?Ss\?\。ᡁ\'\)\ throws\ error\ B2\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:2754\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--ss-o412ac6305g.xn--07e", %p)},	undef,	"to_ascii\(\'xn\-\-ss\-o412ac6305g\.xn\-\-07e\'\)\ throws\ error\ B2\ B3\ V6\ \[data\/IdnaTest\.txt\:2755\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--zca9432wb989f.xn--07e", %p)},	undef,	"to_ascii\(\'xn\-\-zca9432wb989f\.xn\-\-07e\'\)\ throws\ error\ B2\ B3\ V6\ \[data\/IdnaTest\.txt\:2756\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{A953}\x{200D}\x{062C}\x{066C}。𱆎󻡟\x{200C}󠅆", %p)},	undef,	"to_ascii\(\'\\uA953\\u200D\\u062C\\u066C\。𱆎\?\\u200C\󠅆\'\)\ throws\ error\ B5\ B6\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2757\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--rgb2k6711c.xn--ec8nj3948b", %p)},	undef,	"to_ascii\(\'xn\-\-rgb2k6711c\.xn\-\-ec8nj3948b\'\)\ throws\ error\ B5\ B6\ V5\ V6\ \[data\/IdnaTest\.txt\:2759\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--rgb2k500fhq9j.xn--0ug78870a5sp9d", %p)},	undef,	"to_ascii\(\'xn\-\-rgb2k500fhq9j\.xn\-\-0ug78870a5sp9d\'\)\ throws\ error\ B5\ B6\ C1\ V5\ V6\ \[data\/IdnaTest\.txt\:2760\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠕏．-ß\x{200C}≠", %p)},	undef,	"to_ascii\(\'\?．\-ß\\u200C\≠\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:2761\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠕏．-ß\x{200C}=\x{0338}", %p)},	undef,	"to_ascii\(\'\?．\-ß\\u200C\=\\u0338\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:2763\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠕏.-ß\x{200C}≠", %p)},	undef,	"to_ascii\(\'\?\.\-ß\\u200C\≠\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:2765\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠕏.-ß\x{200C}=\x{0338}", %p)},	undef,	"to_ascii\(\'\?\.\-ß\\u200C\=\\u0338\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:2767\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠕏.-SS\x{200C}=\x{0338}", %p)},	undef,	"to_ascii\(\'\?\.\-SS\\u200C\=\\u0338\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:2769\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠕏.-SS\x{200C}≠", %p)},	undef,	"to_ascii\(\'\?\.\-SS\\u200C\≠\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:2771\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠕏.-ss\x{200C}≠", %p)},	undef,	"to_ascii\(\'\?\.\-ss\\u200C\≠\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:2773\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠕏.-ss\x{200C}=\x{0338}", %p)},	undef,	"to_ascii\(\'\?\.\-ss\\u200C\=\\u0338\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:2775\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠕏.-Ss\x{200C}=\x{0338}", %p)},	undef,	"to_ascii\(\'\?\.\-Ss\\u200C\=\\u0338\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:2777\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠕏.-Ss\x{200C}≠", %p)},	undef,	"to_ascii\(\'\?\.\-Ss\\u200C\≠\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:2779\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--u836e.xn---ss-gl2a", %p)},	undef,	"to_ascii\(\'xn\-\-u836e\.xn\-\-\-ss\-gl2a\'\)\ throws\ error\ V3\ V6\ \[data\/IdnaTest\.txt\:2781\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--u836e.xn---ss-cn0at5l", %p)},	undef,	"to_ascii\(\'xn\-\-u836e\.xn\-\-\-ss\-cn0at5l\'\)\ throws\ error\ C1\ V3\ V6\ \[data\/IdnaTest\.txt\:2782\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--u836e.xn----qfa750ve7b", %p)},	undef,	"to_ascii\(\'xn\-\-u836e\.xn\-\-\-\-qfa750ve7b\'\)\ throws\ error\ C1\ V3\ V6\ \[data\/IdnaTest\.txt\:2783\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠕏．-SS\x{200C}=\x{0338}", %p)},	undef,	"to_ascii\(\'\?．\-SS\\u200C\=\\u0338\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:2784\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠕏．-SS\x{200C}≠", %p)},	undef,	"to_ascii\(\'\?．\-SS\\u200C\≠\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:2786\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠕏．-ss\x{200C}≠", %p)},	undef,	"to_ascii\(\'\?．\-ss\\u200C\≠\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:2788\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠕏．-ss\x{200C}=\x{0338}", %p)},	undef,	"to_ascii\(\'\?．\-ss\\u200C\=\\u0338\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:2790\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠕏．-Ss\x{200C}=\x{0338}", %p)},	undef,	"to_ascii\(\'\?．\-Ss\\u200C\=\\u0338\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:2792\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠕏．-Ss\x{200C}≠", %p)},	undef,	"to_ascii\(\'\?．\-Ss\\u200C\≠\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:2794\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᡙ\x{200C}｡≯𐋲≠", %p)},	undef,	"to_ascii\(\'ᡙ\\u200C｡\≯𐋲\≠\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2796\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᡙ\x{200C}｡>\x{0338}𐋲=\x{0338}", %p)},	undef,	"to_ascii\(\'ᡙ\\u200C｡\>\\u0338𐋲\=\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2798\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᡙ\x{200C}。≯𐋲≠", %p)},	undef,	"to_ascii\(\'ᡙ\\u200C\。\≯𐋲\≠\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2800\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᡙ\x{200C}。>\x{0338}𐋲=\x{0338}", %p)},	undef,	"to_ascii\(\'ᡙ\\u200C\。\>\\u0338𐋲\=\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2802\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--p8e.xn--1ch3a7084l", %p)},	undef,	"to_ascii\(\'xn\-\-p8e\.xn\-\-1ch3a7084l\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:2804\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--p8e650b.xn--1ch3a7084l", %p)},	undef,	"to_ascii\(\'xn\-\-p8e650b\.xn\-\-1ch3a7084l\'\)\ throws\ error\ C1\ V6\ \[data\/IdnaTest\.txt\:2805\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐹧𞲄󠁭񆼩。\x{034E}🄀", %p)},	undef,	"to_ascii\(\'𐹧𞲄\?\?\。\\u034E🄀\'\)\ throws\ error\ B1\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2806\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐹧𞲄󠁭񆼩。\x{034E}0.", %p)},	undef,	"to_ascii\(\'𐹧𞲄\?\?\。\\u034E0\.\'\)\ throws\ error\ B1\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2807\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--fo0dw409aq58qrn69d.xn--0-bgb.", %p)},	undef,	"to_ascii\(\'xn\-\-fo0dw409aq58qrn69d\.xn\-\-0\-bgb\.\'\)\ throws\ error\ B1\ V5\ V6\ \[data\/IdnaTest\.txt\:2808\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--fo0dw409aq58qrn69d.xn--sua6883w", %p)},	undef,	"to_ascii\(\'xn\-\-fo0dw409aq58qrn69d\.xn\-\-sua6883w\'\)\ throws\ error\ B1\ V5\ V6\ \[data\/IdnaTest\.txt\:2809\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴄ．\x{200D}\x{0721}󻣋ς", %p)},	undef,	"to_ascii\(\'Ⴄ．\\u200D\\u0721\?ς\'\)\ throws\ error\ B2\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:2810\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴄ.\x{200D}\x{0721}󻣋ς", %p)},	undef,	"to_ascii\(\'Ⴄ\.\\u200D\\u0721\?ς\'\)\ throws\ error\ B2\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:2812\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⴄ.\x{200D}\x{0721}󻣋ς", %p)},	undef,	"to_ascii\(\'ⴄ\.\\u200D\\u0721\?ς\'\)\ throws\ error\ B2\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:2814\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴄ.\x{200D}\x{0721}󻣋Σ", %p)},	undef,	"to_ascii\(\'Ⴄ\.\\u200D\\u0721\?Σ\'\)\ throws\ error\ B2\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:2816\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⴄ.\x{200D}\x{0721}󻣋σ", %p)},	undef,	"to_ascii\(\'ⴄ\.\\u200D\\u0721\?σ\'\)\ throws\ error\ B2\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:2818\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--vkj.xn--4xa73ob5892c", %p)},	undef,	"to_ascii\(\'xn\-\-vkj\.xn\-\-4xa73ob5892c\'\)\ throws\ error\ B2\ B3\ V6\ \[data\/IdnaTest\.txt\:2820\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--vkj.xn--4xa73o3t5ajq467a", %p)},	undef,	"to_ascii\(\'xn\-\-vkj\.xn\-\-4xa73o3t5ajq467a\'\)\ throws\ error\ B1\ C2\ V6\ \[data\/IdnaTest\.txt\:2821\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--cnd.xn--4xa73ob5892c", %p)},	undef,	"to_ascii\(\'xn\-\-cnd\.xn\-\-4xa73ob5892c\'\)\ throws\ error\ B2\ B3\ V6\ \[data\/IdnaTest\.txt\:2822\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--cnd.xn--4xa73o3t5ajq467a", %p)},	undef,	"to_ascii\(\'xn\-\-cnd\.xn\-\-4xa73o3t5ajq467a\'\)\ throws\ error\ B1\ C2\ V6\ \[data\/IdnaTest\.txt\:2823\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--vkj.xn--3xa93o3t5ajq467a", %p)},	undef,	"to_ascii\(\'xn\-\-vkj\.xn\-\-3xa93o3t5ajq467a\'\)\ throws\ error\ B1\ C2\ V6\ \[data\/IdnaTest\.txt\:2824\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--cnd.xn--3xa93o3t5ajq467a", %p)},	undef,	"to_ascii\(\'xn\-\-cnd\.xn\-\-3xa93o3t5ajq467a\'\)\ throws\ error\ B1\ C2\ V6\ \[data\/IdnaTest\.txt\:2825\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⴄ．\x{200D}\x{0721}󻣋ς", %p)},	undef,	"to_ascii\(\'ⴄ．\\u200D\\u0721\?ς\'\)\ throws\ error\ B2\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:2826\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴄ．\x{200D}\x{0721}󻣋Σ", %p)},	undef,	"to_ascii\(\'Ⴄ．\\u200D\\u0721\?Σ\'\)\ throws\ error\ B2\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:2828\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⴄ．\x{200D}\x{0721}󻣋σ", %p)},	undef,	"to_ascii\(\'ⴄ．\\u200D\\u0721\?σ\'\)\ throws\ error\ B2\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:2830\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򮵛\x{0613}.Ⴕ", %p)},	undef,	"to_ascii\(\'\?\\u0613\.Ⴕ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2832\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򮵛\x{0613}.ⴕ", %p)},	undef,	"to_ascii\(\'\?\\u0613\.ⴕ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2833\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--1fb94204l.xn--dlj", %p)},	undef,	"to_ascii\(\'xn\-\-1fb94204l\.xn\-\-dlj\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:2834\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--1fb94204l.xn--tnd", %p)},	undef,	"to_ascii\(\'xn\-\-1fb94204l\.xn\-\-tnd\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:2835\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≯\x{1DF3}𞤥。\x{200C}\x{A8C4}󠪉\x{200D}", %p)},	undef,	"to_ascii\(\'\≯\\u1DF3𞤥\。\\u200C\\uA8C4\?\\u200D\'\)\ throws\ error\ B1\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2836\]") or ($@ and diag($@));
is(eval{uts46_to_ascii(">\x{0338}\x{1DF3}𞤥。\x{200C}\x{A8C4}󠪉\x{200D}", %p)},	undef,	"to_ascii\(\'\>\\u0338\\u1DF3𞤥\。\\u200C\\uA8C4\?\\u200D\'\)\ throws\ error\ B1\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2838\]") or ($@ and diag($@));
is(eval{uts46_to_ascii(">\x{0338}\x{1DF3}𞤃。\x{200C}\x{A8C4}󠪉\x{200D}", %p)},	undef,	"to_ascii\(\'\>\\u0338\\u1DF3𞤃\。\\u200C\\uA8C4\?\\u200D\'\)\ throws\ error\ B1\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2840\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≯\x{1DF3}𞤃。\x{200C}\x{A8C4}󠪉\x{200D}", %p)},	undef,	"to_ascii\(\'\≯\\u1DF3𞤃\。\\u200C\\uA8C4\?\\u200D\'\)\ throws\ error\ B1\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2842\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--ofg13qyr21c.xn--0f9au6706d", %p)},	undef,	"to_ascii\(\'xn\-\-ofg13qyr21c\.xn\-\-0f9au6706d\'\)\ throws\ error\ B1\ V5\ V6\ \[data\/IdnaTest\.txt\:2844\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--ofg13qyr21c.xn--0ugc0116hix29k", %p)},	undef,	"to_ascii\(\'xn\-\-ofg13qyr21c\.xn\-\-0ugc0116hix29k\'\)\ throws\ error\ B1\ C1\ C2\ V6\ \[data\/IdnaTest\.txt\:2845\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}󠄷｡򒑁", %p)},	undef,	"to_ascii\(\'\\u200C\󠄷｡\?\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:2846\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}󠄷。򒑁", %p)},	undef,	"to_ascii\(\'\\u200C\󠄷\。\?\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:2848\]") or ($@ and diag($@));
is(eval{uts46_to_ascii(".xn--w720c", %p)},	undef,	"to_ascii\(\'\.xn\-\-w720c\'\)\ throws\ error\ V6\ A4_2\ \[data\/IdnaTest\.txt\:2850\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--0ug.xn--w720c", %p)},	undef,	"to_ascii\(\'xn\-\-0ug\.xn\-\-w720c\'\)\ throws\ error\ C1\ V6\ \[data\/IdnaTest\.txt\:2851\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⒈\x{0DD6}焅.󗡙\x{200D}ꡟ", %p)},	undef,	"to_ascii\(\'⒈\\u0DD6焅\.\?\\u200Dꡟ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2852\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("1.\x{0DD6}焅.󗡙\x{200D}ꡟ", %p)},	undef,	"to_ascii\(\'1\.\\u0DD6焅\.\?\\u200Dꡟ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2854\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("1.xn--t1c6981c.xn--4c9a21133d", %p)},	undef,	"to_ascii\(\'1\.xn\-\-t1c6981c\.xn\-\-4c9a21133d\'\)\ throws\ error\ V5\ V6\ \[data\/IdnaTest\.txt\:2856\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("1.xn--t1c6981c.xn--1ugz184c9lw7i", %p)},	undef,	"to_ascii\(\'1\.xn\-\-t1c6981c\.xn\-\-1ugz184c9lw7i\'\)\ throws\ error\ C2\ V5\ V6\ \[data\/IdnaTest\.txt\:2857\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--t1c337io97c.xn--4c9a21133d", %p)},	undef,	"to_ascii\(\'xn\-\-t1c337io97c\.xn\-\-4c9a21133d\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:2858\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--t1c337io97c.xn--1ugz184c9lw7i", %p)},	undef,	"to_ascii\(\'xn\-\-t1c337io97c\.xn\-\-1ugz184c9lw7i\'\)\ throws\ error\ C2\ V6\ \[data\/IdnaTest\.txt\:2859\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1DCD}ς≮.ς𝪦𞤕0", %p)},	undef,	"to_ascii\(\'\\u1DCDς\≮\.ς𝪦𞤕0\'\)\ throws\ error\ B1\ B5\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2860\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1DCD}ς<\x{0338}.ς𝪦𞤕0", %p)},	undef,	"to_ascii\(\'\\u1DCDς\<\\u0338\.ς𝪦𞤕0\'\)\ throws\ error\ B1\ B5\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2862\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1DCD}ς<\x{0338}.ς𝪦𞤷0", %p)},	undef,	"to_ascii\(\'\\u1DCDς\<\\u0338\.ς𝪦𞤷0\'\)\ throws\ error\ B1\ B5\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2864\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1DCD}ς≮.ς𝪦𞤷0", %p)},	undef,	"to_ascii\(\'\\u1DCDς\≮\.ς𝪦𞤷0\'\)\ throws\ error\ B1\ B5\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2866\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1DCD}Σ≮.Σ𝪦𞤕0", %p)},	undef,	"to_ascii\(\'\\u1DCDΣ\≮\.Σ𝪦𞤕0\'\)\ throws\ error\ B1\ B5\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2868\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1DCD}Σ<\x{0338}.Σ𝪦𞤕0", %p)},	undef,	"to_ascii\(\'\\u1DCDΣ\<\\u0338\.Σ𝪦𞤕0\'\)\ throws\ error\ B1\ B5\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2869\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1DCD}σ<\x{0338}.σ𝪦𞤷0", %p)},	undef,	"to_ascii\(\'\\u1DCDσ\<\\u0338\.σ𝪦𞤷0\'\)\ throws\ error\ B1\ B5\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2870\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1DCD}σ≮.σ𝪦𞤷0", %p)},	undef,	"to_ascii\(\'\\u1DCDσ\≮\.σ𝪦𞤷0\'\)\ throws\ error\ B1\ B5\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2871\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1DCD}Σ≮.Σ𝪦𞤷0", %p)},	undef,	"to_ascii\(\'\\u1DCDΣ\≮\.Σ𝪦𞤷0\'\)\ throws\ error\ B1\ B5\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2872\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1DCD}Σ<\x{0338}.Σ𝪦𞤷0", %p)},	undef,	"to_ascii\(\'\\u1DCDΣ\<\\u0338\.Σ𝪦𞤷0\'\)\ throws\ error\ B1\ B5\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2873\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--4xa544kvid.xn--0-zmb55727aggma", %p)},	undef,	"to_ascii\(\'xn\-\-4xa544kvid\.xn\-\-0\-zmb55727aggma\'\)\ throws\ error\ B1\ B5\ V5\ V6\ \[data\/IdnaTest\.txt\:2874\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--3xa744kvid.xn--0-xmb85727aggma", %p)},	undef,	"to_ascii\(\'xn\-\-3xa744kvid\.xn\-\-0\-xmb85727aggma\'\)\ throws\ error\ B1\ B5\ V5\ V6\ \[data\/IdnaTest\.txt\:2875\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1DCD}σ≮.σ𝪦𞤕0", %p)},	undef,	"to_ascii\(\'\\u1DCDσ\≮\.σ𝪦𞤕0\'\)\ throws\ error\ B1\ B5\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2876\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1DCD}σ<\x{0338}.σ𝪦𞤕0", %p)},	undef,	"to_ascii\(\'\\u1DCDσ\<\\u0338\.σ𝪦𞤕0\'\)\ throws\ error\ B1\ B5\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2877\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򢦾ß\x{05B9}𐫙.\x{05AD}\x{08A1}", %p)},	undef,	"to_ascii\(\'\?ß\\u05B9𐫙\.\\u05AD\\u08A1\'\)\ throws\ error\ B1\ B5\ B6\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2878\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򢦾SS\x{05B9}𐫙.\x{05AD}\x{08A1}", %p)},	undef,	"to_ascii\(\'\?SS\\u05B9𐫙\.\\u05AD\\u08A1\'\)\ throws\ error\ B1\ B5\ B6\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2880\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򢦾ss\x{05B9}𐫙.\x{05AD}\x{08A1}", %p)},	undef,	"to_ascii\(\'\?ss\\u05B9𐫙\.\\u05AD\\u08A1\'\)\ throws\ error\ B1\ B5\ B6\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2881\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򢦾Ss\x{05B9}𐫙.\x{05AD}\x{08A1}", %p)},	undef,	"to_ascii\(\'\?Ss\\u05B9𐫙\.\\u05AD\\u08A1\'\)\ throws\ error\ B1\ B5\ B6\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2882\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--ss-xjd6058xlz50g.xn--4cb62m", %p)},	undef,	"to_ascii\(\'xn\-\-ss\-xjd6058xlz50g\.xn\-\-4cb62m\'\)\ throws\ error\ B1\ B5\ B6\ V5\ V6\ \[data\/IdnaTest\.txt\:2883\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--zca89v339zj118e.xn--4cb62m", %p)},	undef,	"to_ascii\(\'xn\-\-zca89v339zj118e\.xn\-\-4cb62m\'\)\ throws\ error\ B1\ B5\ B6\ V5\ V6\ \[data\/IdnaTest\.txt\:2884\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-𞣄｡⒈", %p)},	undef,	"to_ascii\(\'\-𞣄｡⒈\'\)\ throws\ error\ B1\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:2885\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("-𞣄。1.", %p)},	undef,	"to_ascii\(\'\-𞣄\。1\.\'\)\ throws\ error\ B1\ V3\ \[data\/IdnaTest\.txt\:2886\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn----xc8r.1.", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-xc8r\.1\.\'\)\ throws\ error\ B1\ V3\ \[data\/IdnaTest\.txt\:2887\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----xc8r.xn--tsh", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-xc8r\.xn\-\-tsh\'\)\ throws\ error\ B1\ V3\ V6\ \[data\/IdnaTest\.txt\:2888\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񈠢𐫖𝟡。\x{063E}𑘿", %p)},	undef,	"to_ascii\(\'\?𐫖𝟡\。\\u063E𑘿\'\)\ throws\ error\ B5\ P1\ V6\ \[data\/IdnaTest\.txt\:2889\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񈠢𐫖9。\x{063E}𑘿", %p)},	undef,	"to_ascii\(\'\?𐫖9\。\\u063E𑘿\'\)\ throws\ error\ B5\ P1\ V6\ \[data\/IdnaTest\.txt\:2890\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--9-el5iv442t.xn--9gb0830l", %p)},	undef,	"to_ascii\(\'xn\-\-9\-el5iv442t\.xn\-\-9gb0830l\'\)\ throws\ error\ B5\ V6\ \[data\/IdnaTest\.txt\:2891\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("\x{0668}\x{FC8C}\x{0668}\x{1A5D}.\x{200D}", %p)},	undef,	"to_ascii\(\'\\u0668\\uFC8C\\u0668\\u1A5D\.\\u200D\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:2892\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("\x{0668}\x{0646}\x{0645}\x{0668}\x{1A5D}.\x{200D}", %p)},	undef,	"to_ascii\(\'\\u0668\\u0646\\u0645\\u0668\\u1A5D\.\\u200D\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:2894\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--hhbb5hc956w.", %p)},	undef,	"to_ascii\(\'xn\-\-hhbb5hc956w\.\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:2896\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--hhbb5hc956w.xn--1ug", %p)},	undef,	"to_ascii\(\'xn\-\-hhbb5hc956w\.xn\-\-1ug\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:2897\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𝟘．Ⴇ󀳑\x{FD50}񫃱", %p)},	undef,	"to_ascii\(\'𝟘．Ⴇ\?\\uFD50\?\'\)\ throws\ error\ B1\ B5\ P1\ V6\ \[data\/IdnaTest\.txt\:2898\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("0.Ⴇ󀳑\x{062A}\x{062C}\x{0645}񫃱", %p)},	undef,	"to_ascii\(\'0\.Ⴇ\?\\u062A\\u062C\\u0645\?\'\)\ throws\ error\ B1\ B5\ P1\ V6\ \[data\/IdnaTest\.txt\:2899\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("0.ⴇ󀳑\x{062A}\x{062C}\x{0645}񫃱", %p)},	undef,	"to_ascii\(\'0\.ⴇ\?\\u062A\\u062C\\u0645\?\'\)\ throws\ error\ B1\ B5\ P1\ V6\ \[data\/IdnaTest\.txt\:2900\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("0.xn--pgbe9ez79qd207lvff8b", %p)},	undef,	"to_ascii\(\'0\.xn\-\-pgbe9ez79qd207lvff8b\'\)\ throws\ error\ B1\ B5\ V6\ \[data\/IdnaTest\.txt\:2901\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("0.xn--pgbe9e344c2725svff8b", %p)},	undef,	"to_ascii\(\'0\.xn\-\-pgbe9e344c2725svff8b\'\)\ throws\ error\ B1\ B5\ V6\ \[data\/IdnaTest\.txt\:2902\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𝟘．ⴇ󀳑\x{FD50}񫃱", %p)},	undef,	"to_ascii\(\'𝟘．ⴇ\?\\uFD50\?\'\)\ throws\ error\ B1\ B5\ P1\ V6\ \[data\/IdnaTest\.txt\:2903\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_ascii("𑇀▍.⁞ᠰ", %p)},	undef,	"to_ascii\(\'𑇀\▍\.\⁞ᠰ\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:2904\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--9zh3057f.xn--j7e103b", %p)},	undef,	"to_ascii\(\'xn\-\-9zh3057f\.xn\-\-j7e103b\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:2905\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}-\x{067A}.򏯩", %p)},	undef,	"to_ascii\(\'\\u200D\-\\u067A\.\?\'\)\ throws\ error\ B1\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:2906\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----qrc.xn--ts49b", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-qrc\.xn\-\-ts49b\'\)\ throws\ error\ B1\ V3\ V6\ \[data\/IdnaTest\.txt\:2908\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----qrc357q.xn--ts49b", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-qrc357q\.xn\-\-ts49b\'\)\ throws\ error\ B1\ C2\ V6\ \[data\/IdnaTest\.txt\:2909\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᠢ𐮂𐫘寐｡\x{200C}≯✳", %p)},	undef,	"to_ascii\(\'ᠢ𐮂𐫘寐｡\\u200C\≯\✳\'\)\ throws\ error\ B1\ B5\ P1\ V6\ \[data\/IdnaTest\.txt\:2910\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᠢ𐮂𐫘寐｡\x{200C}>\x{0338}✳", %p)},	undef,	"to_ascii\(\'ᠢ𐮂𐫘寐｡\\u200C\>\\u0338\✳\'\)\ throws\ error\ B1\ B5\ P1\ V6\ \[data\/IdnaTest\.txt\:2912\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᠢ𐮂𐫘寐。\x{200C}≯✳", %p)},	undef,	"to_ascii\(\'ᠢ𐮂𐫘寐\。\\u200C\≯\✳\'\)\ throws\ error\ B1\ B5\ P1\ V6\ \[data\/IdnaTest\.txt\:2914\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᠢ𐮂𐫘寐。\x{200C}>\x{0338}✳", %p)},	undef,	"to_ascii\(\'ᠢ𐮂𐫘寐\。\\u200C\>\\u0338\✳\'\)\ throws\ error\ B1\ B5\ P1\ V6\ \[data\/IdnaTest\.txt\:2916\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--46e6675axzzhota.xn--hdh99p", %p)},	undef,	"to_ascii\(\'xn\-\-46e6675axzzhota\.xn\-\-hdh99p\'\)\ throws\ error\ B1\ B5\ V6\ \[data\/IdnaTest\.txt\:2918\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--46e6675axzzhota.xn--0ug06gu8f", %p)},	undef,	"to_ascii\(\'xn\-\-46e6675axzzhota\.xn\-\-0ug06gu8f\'\)\ throws\ error\ B1\ B5\ C1\ V6\ \[data\/IdnaTest\.txt\:2919\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}｡󸲜ႺႴ𞨇", %p)},	undef,	"to_ascii\(\'\\u200D｡\?ႺႴ\?\'\)\ throws\ error\ B5\ B6\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:2920\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}。󸲜ႺႴ𞨇", %p)},	undef,	"to_ascii\(\'\\u200D\。\?ႺႴ\?\'\)\ throws\ error\ B5\ B6\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:2922\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}。󸲜ⴚⴔ𞨇", %p)},	undef,	"to_ascii\(\'\\u200D\。\?ⴚⴔ\?\'\)\ throws\ error\ B5\ B6\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:2924\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}。󸲜Ⴚⴔ𞨇", %p)},	undef,	"to_ascii\(\'\\u200D\。\?Ⴚⴔ\?\'\)\ throws\ error\ B5\ B6\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:2926\]") or ($@ and diag($@));
is(eval{uts46_to_ascii(".xn--ynd036lq981an3r4h", %p)},	undef,	"to_ascii\(\'\.xn\-\-ynd036lq981an3r4h\'\)\ throws\ error\ B5\ B6\ V6\ A4_2\ \[data\/IdnaTest\.txt\:2928\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--1ug.xn--ynd036lq981an3r4h", %p)},	undef,	"to_ascii\(\'xn\-\-1ug\.xn\-\-ynd036lq981an3r4h\'\)\ throws\ error\ B1\ B5\ B6\ C2\ V6\ \[data\/IdnaTest\.txt\:2929\]") or ($@ and diag($@));
is(eval{uts46_to_ascii(".xn--cljl81825an3r4h", %p)},	undef,	"to_ascii\(\'\.xn\-\-cljl81825an3r4h\'\)\ throws\ error\ B5\ B6\ V6\ A4_2\ \[data\/IdnaTest\.txt\:2930\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--1ug.xn--cljl81825an3r4h", %p)},	undef,	"to_ascii\(\'xn\-\-1ug\.xn\-\-cljl81825an3r4h\'\)\ throws\ error\ B1\ B5\ B6\ C2\ V6\ \[data\/IdnaTest\.txt\:2931\]") or ($@ and diag($@));
is(eval{uts46_to_ascii(".xn--sndl01647an3h1h", %p)},	undef,	"to_ascii\(\'\.xn\-\-sndl01647an3h1h\'\)\ throws\ error\ B5\ B6\ V6\ A4_2\ \[data\/IdnaTest\.txt\:2932\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--1ug.xn--sndl01647an3h1h", %p)},	undef,	"to_ascii\(\'xn\-\-1ug\.xn\-\-sndl01647an3h1h\'\)\ throws\ error\ B1\ B5\ B6\ C2\ V6\ \[data\/IdnaTest\.txt\:2933\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}｡󸲜ⴚⴔ𞨇", %p)},	undef,	"to_ascii\(\'\\u200D｡\?ⴚⴔ\?\'\)\ throws\ error\ B5\ B6\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:2934\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}｡󸲜Ⴚⴔ𞨇", %p)},	undef,	"to_ascii\(\'\\u200D｡\?Ⴚⴔ\?\'\)\ throws\ error\ B5\ B6\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:2936\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-3.\x{200D}ヌᢕ", %p)},	undef,	"to_ascii\(\'\-3\.\\u200Dヌᢕ\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:2938\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-3.xn--fbf115j", %p)},	undef,	"to_ascii\(\'\-3\.xn\-\-fbf115j\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:2940\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-3.xn--fbf739aq5o", %p)},	undef,	"to_ascii\(\'\-3\.xn\-\-fbf739aq5o\'\)\ throws\ error\ C2\ V3\ \[data\/IdnaTest\.txt\:2941\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("🂃\x{0666}ß\x{200D}。󠠂򭰍𞩒-", %p)},	undef,	"to_ascii\(\'🂃\\u0666ß\\u200D\。\?\?\?\-\'\)\ throws\ error\ B1\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:2942\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("🂃\x{0666}SS\x{200D}。󠠂򭰍𞩒-", %p)},	undef,	"to_ascii\(\'🂃\\u0666SS\\u200D\。\?\?\?\-\'\)\ throws\ error\ B1\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:2944\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("🂃\x{0666}ss\x{200D}。󠠂򭰍𞩒-", %p)},	undef,	"to_ascii\(\'🂃\\u0666ss\\u200D\。\?\?\?\-\'\)\ throws\ error\ B1\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:2946\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("🂃\x{0666}Ss\x{200D}。󠠂򭰍𞩒-", %p)},	undef,	"to_ascii\(\'🂃\\u0666Ss\\u200D\。\?\?\?\-\'\)\ throws\ error\ B1\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:2948\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--ss-pyd98921c.xn----nz8rh7531csznt", %p)},	undef,	"to_ascii\(\'xn\-\-ss\-pyd98921c\.xn\-\-\-\-nz8rh7531csznt\'\)\ throws\ error\ B1\ V3\ V6\ \[data\/IdnaTest\.txt\:2950\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--ss-pyd483x5k99b.xn----nz8rh7531csznt", %p)},	undef,	"to_ascii\(\'xn\-\-ss\-pyd483x5k99b\.xn\-\-\-\-nz8rh7531csznt\'\)\ throws\ error\ B1\ C2\ V3\ V6\ \[data\/IdnaTest\.txt\:2951\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--zca34z68yzu83b.xn----nz8rh7531csznt", %p)},	undef,	"to_ascii\(\'xn\-\-zca34z68yzu83b\.xn\-\-\-\-nz8rh7531csznt\'\)\ throws\ error\ B1\ C2\ V3\ V6\ \[data\/IdnaTest\.txt\:2952\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ꇟ-𐾺\x{069F}。򰀺\x{200C}", %p)},	undef,	"to_ascii\(\'ꇟ\-𐾺\\u069F\。\?\\u200C\'\)\ throws\ error\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:2953\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----utc4430jd3zd.xn--bp20d", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-utc4430jd3zd\.xn\-\-bp20d\'\)\ throws\ error\ B5\ B6\ V6\ \[data\/IdnaTest\.txt\:2955\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----utc4430jd3zd.xn--0ugx6670i", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-utc4430jd3zd\.xn\-\-0ugx6670i\'\)\ throws\ error\ B5\ B6\ C1\ V6\ \[data\/IdnaTest\.txt\:2956\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0665}.\x{0484}𐨗𝩋𴤃", %p)},	undef,	"to_ascii\(\'\\u0665\.\\u0484𐨗𝩋\?\'\)\ throws\ error\ B1\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2957\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--eib.xn--n3a0405kus8eft5l", %p)},	undef,	"to_ascii\(\'xn\-\-eib\.xn\-\-n3a0405kus8eft5l\'\)\ throws\ error\ B1\ V5\ V6\ \[data\/IdnaTest\.txt\:2958\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-.񱼓\x{0649}𐨿", %p)},	undef,	"to_ascii\(\'\-\.\?\\u0649𐨿\'\)\ throws\ error\ B1\ B5\ B6\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:2959\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-.xn--lhb4124khbq4b", %p)},	undef,	"to_ascii\(\'\-\.xn\-\-lhb4124khbq4b\'\)\ throws\ error\ B1\ B5\ B6\ V3\ V6\ \[data\/IdnaTest\.txt\:2960\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󾬨ς.𞶙녫ß", %p)},	undef,	"to_ascii\(\'\?ς\.\?녫ß\'\)\ throws\ error\ B2\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:2961\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󾬨ς.𞶙녫ß", %p)},	undef,	"to_ascii\(\'\?ς\.\?녫ß\'\)\ throws\ error\ B2\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:2963\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󾬨Σ.𞶙녫SS", %p)},	undef,	"to_ascii\(\'\?Σ\.\?녫SS\'\)\ throws\ error\ B2\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:2965\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󾬨Σ.𞶙녫SS", %p)},	undef,	"to_ascii\(\'\?Σ\.\?녫SS\'\)\ throws\ error\ B2\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:2966\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󾬨σ.𞶙녫ss", %p)},	undef,	"to_ascii\(\'\?σ\.\?녫ss\'\)\ throws\ error\ B2\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:2967\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󾬨σ.𞶙녫ss", %p)},	undef,	"to_ascii\(\'\?σ\.\?녫ss\'\)\ throws\ error\ B2\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:2968\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󾬨Σ.𞶙녫Ss", %p)},	undef,	"to_ascii\(\'\?Σ\.\?녫Ss\'\)\ throws\ error\ B2\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:2969\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󾬨Σ.𞶙녫Ss", %p)},	undef,	"to_ascii\(\'\?Σ\.\?녫Ss\'\)\ throws\ error\ B2\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:2970\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--4xa76659r.xn--ss-d64i8755h", %p)},	undef,	"to_ascii\(\'xn\-\-4xa76659r\.xn\-\-ss\-d64i8755h\'\)\ throws\ error\ B2\ B3\ V6\ \[data\/IdnaTest\.txt\:2971\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--3xa96659r.xn--zca5051g4h4i", %p)},	undef,	"to_ascii\(\'xn\-\-3xa96659r\.xn\-\-zca5051g4h4i\'\)\ throws\ error\ B2\ B3\ V6\ \[data\/IdnaTest\.txt\:2972\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⅎ\x{17D2}\x{200D}｡≠\x{200D}\x{200C}", %p)},	undef,	"to_ascii\(\'Ⅎ\\u17D2\\u200D｡\≠\\u200D\\u200C\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2973\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⅎ\x{17D2}\x{200D}｡=\x{0338}\x{200D}\x{200C}", %p)},	undef,	"to_ascii\(\'Ⅎ\\u17D2\\u200D｡\=\\u0338\\u200D\\u200C\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2975\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⅎ\x{17D2}\x{200D}。≠\x{200D}\x{200C}", %p)},	undef,	"to_ascii\(\'Ⅎ\\u17D2\\u200D\。\≠\\u200D\\u200C\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2977\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⅎ\x{17D2}\x{200D}。=\x{0338}\x{200D}\x{200C}", %p)},	undef,	"to_ascii\(\'Ⅎ\\u17D2\\u200D\。\=\\u0338\\u200D\\u200C\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2979\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⅎ\x{17D2}\x{200D}。=\x{0338}\x{200D}\x{200C}", %p)},	undef,	"to_ascii\(\'ⅎ\\u17D2\\u200D\。\=\\u0338\\u200D\\u200C\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2981\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⅎ\x{17D2}\x{200D}。≠\x{200D}\x{200C}", %p)},	undef,	"to_ascii\(\'ⅎ\\u17D2\\u200D\。\≠\\u200D\\u200C\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2983\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--u4e969b.xn--1ch", %p)},	undef,	"to_ascii\(\'xn\-\-u4e969b\.xn\-\-1ch\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:2985\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--u4e823bq1a.xn--0ugb89o", %p)},	undef,	"to_ascii\(\'xn\-\-u4e823bq1a\.xn\-\-0ugb89o\'\)\ throws\ error\ C1\ C2\ V6\ \[data\/IdnaTest\.txt\:2986\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--u4e319b.xn--1ch", %p)},	undef,	"to_ascii\(\'xn\-\-u4e319b\.xn\-\-1ch\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:2987\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--u4e823bcza.xn--0ugb89o", %p)},	undef,	"to_ascii\(\'xn\-\-u4e823bcza\.xn\-\-0ugb89o\'\)\ throws\ error\ C1\ C2\ V6\ \[data\/IdnaTest\.txt\:2988\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⅎ\x{17D2}\x{200D}｡=\x{0338}\x{200D}\x{200C}", %p)},	undef,	"to_ascii\(\'ⅎ\\u17D2\\u200D｡\=\\u0338\\u200D\\u200C\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2989\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⅎ\x{17D2}\x{200D}｡≠\x{200D}\x{200C}", %p)},	undef,	"to_ascii\(\'ⅎ\\u17D2\\u200D｡\≠\\u200D\\u200C\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2991\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐋺\x{AAF6}\x{A953}󧦉．\x{200C}\x{1714}\x{068F}", %p)},	undef,	"to_ascii\(\'𐋺\\uAAF6\\uA953\?．\\u200C\\u1714\\u068F\'\)\ throws\ error\ B1\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2993\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐋺\x{AAF6}\x{A953}󧦉.\x{200C}\x{1714}\x{068F}", %p)},	undef,	"to_ascii\(\'𐋺\\uAAF6\\uA953\?\.\\u200C\\u1714\\u068F\'\)\ throws\ error\ B1\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2995\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--3j9a14ak27osbz2o.xn--ljb175f", %p)},	undef,	"to_ascii\(\'xn\-\-3j9a14ak27osbz2o\.xn\-\-ljb175f\'\)\ throws\ error\ B1\ V5\ V6\ \[data\/IdnaTest\.txt\:2997\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--3j9a14ak27osbz2o.xn--ljb175f1wg", %p)},	undef,	"to_ascii\(\'xn\-\-3j9a14ak27osbz2o\.xn\-\-ljb175f1wg\'\)\ throws\ error\ B1\ C1\ V6\ \[data\/IdnaTest\.txt\:2998\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񺔯\x{0FA8}．≯", %p)},	undef,	"to_ascii\(\'\?\\u0FA8．\≯\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2999\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񺔯\x{0FA8}．>\x{0338}", %p)},	undef,	"to_ascii\(\'\?\\u0FA8．\>\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3000\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񺔯\x{0FA8}.≯", %p)},	undef,	"to_ascii\(\'\?\\u0FA8\.\≯\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3001\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񺔯\x{0FA8}.>\x{0338}", %p)},	undef,	"to_ascii\(\'\?\\u0FA8\.\>\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3002\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--4fd57150h.xn--hdh", %p)},	undef,	"to_ascii\(\'xn\-\-4fd57150h\.xn\-\-hdh\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:3003\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}𞡄Ⴓ．𐇽", %p)},	undef,	"to_ascii\(\'\\u200D𞡄Ⴓ．𐇽\'\)\ throws\ error\ B1\ B2\ B3\ B6\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3004\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}𞡄Ⴓ.𐇽", %p)},	undef,	"to_ascii\(\'\\u200D𞡄Ⴓ\.𐇽\'\)\ throws\ error\ B1\ B2\ B3\ B6\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3006\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("\x{200D}𞡄ⴓ.𐇽", %p)},	undef,	"to_ascii\(\'\\u200D𞡄ⴓ\.𐇽\'\)\ throws\ error\ B1\ B2\ B3\ B6\ V5\ \[data\/IdnaTest\.txt\:3008\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--blj7492l.xn--m27c", %p)},	undef,	"to_ascii\(\'xn\-\-blj7492l\.xn\-\-m27c\'\)\ throws\ error\ B1\ B2\ B3\ B6\ V5\ \[data\/IdnaTest\.txt\:3010\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--1ugz52c4i16a.xn--m27c", %p)},	undef,	"to_ascii\(\'xn\-\-1ugz52c4i16a\.xn\-\-m27c\'\)\ throws\ error\ B1\ B3\ B6\ C2\ V5\ \[data\/IdnaTest\.txt\:3011\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--rnd5552v.xn--m27c", %p)},	undef,	"to_ascii\(\'xn\-\-rnd5552v\.xn\-\-m27c\'\)\ throws\ error\ B1\ B2\ B3\ B6\ V5\ V6\ \[data\/IdnaTest\.txt\:3012\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--rnd379ex885a.xn--m27c", %p)},	undef,	"to_ascii\(\'xn\-\-rnd379ex885a\.xn\-\-m27c\'\)\ throws\ error\ B1\ B3\ B6\ C2\ V5\ V6\ \[data\/IdnaTest\.txt\:3013\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("\x{200D}𞡄ⴓ．𐇽", %p)},	undef,	"to_ascii\(\'\\u200D𞡄ⴓ．𐇽\'\)\ throws\ error\ B1\ B2\ B3\ B6\ V5\ \[data\/IdnaTest\.txt\:3014\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("𐪒ß\x{A8EA}．ᡤ", %p)},	undef,	"to_ascii\(\'𐪒ß\\uA8EA．ᡤ\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:3016\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("𐪒ß\x{A8EA}.ᡤ", %p)},	undef,	"to_ascii\(\'𐪒ß\\uA8EA\.ᡤ\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:3018\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("𐪒SS\x{A8EA}.ᡤ", %p)},	undef,	"to_ascii\(\'𐪒SS\\uA8EA\.ᡤ\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:3020\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("𐪒ss\x{A8EA}.ᡤ", %p)},	undef,	"to_ascii\(\'𐪒ss\\uA8EA\.ᡤ\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:3021\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("𐪒Ss\x{A8EA}.ᡤ", %p)},	undef,	"to_ascii\(\'𐪒Ss\\uA8EA\.ᡤ\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:3022\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--ss-tu9hw933a.xn--08e", %p)},	undef,	"to_ascii\(\'xn\-\-ss\-tu9hw933a\.xn\-\-08e\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:3023\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--zca2517f2hvc.xn--08e", %p)},	undef,	"to_ascii\(\'xn\-\-zca2517f2hvc\.xn\-\-08e\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:3024\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("𐪒SS\x{A8EA}．ᡤ", %p)},	undef,	"to_ascii\(\'𐪒SS\\uA8EA．ᡤ\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:3025\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("𐪒ss\x{A8EA}．ᡤ", %p)},	undef,	"to_ascii\(\'𐪒ss\\uA8EA．ᡤ\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:3026\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("𐪒Ss\x{A8EA}．ᡤ", %p)},	undef,	"to_ascii\(\'𐪒Ss\\uA8EA．ᡤ\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:3027\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_ascii("𐨿󠆌鸮𑚶.ς", %p)},	undef,	"to_ascii\(\'𐨿\󠆌鸮𑚶\.ς\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:3028\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_ascii("𐨿󠆌鸮𑚶.Σ", %p)},	undef,	"to_ascii\(\'𐨿\󠆌鸮𑚶\.Σ\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:3030\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_ascii("𐨿󠆌鸮𑚶.σ", %p)},	undef,	"to_ascii\(\'𐨿\󠆌鸮𑚶\.σ\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:3031\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--l76a726rt2h.xn--4xa", %p)},	undef,	"to_ascii\(\'xn\-\-l76a726rt2h\.xn\-\-4xa\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:3032\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--l76a726rt2h.xn--3xa", %p)},	undef,	"to_ascii\(\'xn\-\-l76a726rt2h\.xn\-\-3xa\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:3033\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⒗𞤬。-𑚶", %p)},	undef,	"to_ascii\(\'⒗𞤬\。\-𑚶\'\)\ throws\ error\ B1\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3034\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("16.𞤬。-𑚶", %p)},	undef,	"to_ascii\(\'16\.𞤬\。\-𑚶\'\)\ throws\ error\ B1\ V3\ \[data\/IdnaTest\.txt\:3035\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("16.𞤊。-𑚶", %p)},	undef,	"to_ascii\(\'16\.𞤊\。\-𑚶\'\)\ throws\ error\ B1\ V3\ \[data\/IdnaTest\.txt\:3036\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("16.xn--ke6h.xn----4j0j", %p)},	undef,	"to_ascii\(\'16\.xn\-\-ke6h\.xn\-\-\-\-4j0j\'\)\ throws\ error\ B1\ V3\ \[data\/IdnaTest\.txt\:3037\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⒗𞤊。-𑚶", %p)},	undef,	"to_ascii\(\'⒗𞤊\。\-𑚶\'\)\ throws\ error\ B1\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3038\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--8shw466n.xn----4j0j", %p)},	undef,	"to_ascii\(\'xn\-\-8shw466n\.xn\-\-\-\-4j0j\'\)\ throws\ error\ B1\ V3\ V6\ \[data\/IdnaTest\.txt\:3039\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{08B3}𞤿⾫｡𐹣\x{068F}⒈", %p)},	undef,	"to_ascii\(\'\\u08B3𞤿⾫｡𐹣\\u068F⒈\'\)\ throws\ error\ B1\ B2\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:3040\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("\x{08B3}𞤿隹。𐹣\x{068F}1.", %p)},	undef,	"to_ascii\(\'\\u08B3𞤿隹\。𐹣\\u068F1\.\'\)\ throws\ error\ B1\ B2\ B3\ \[data\/IdnaTest\.txt\:3041\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("\x{08B3}𞤝隹。𐹣\x{068F}1.", %p)},	undef,	"to_ascii\(\'\\u08B3𞤝隹\。𐹣\\u068F1\.\'\)\ throws\ error\ B1\ B2\ B3\ \[data\/IdnaTest\.txt\:3042\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--8yb0383efiwk.xn--1-wsc3373r.", %p)},	undef,	"to_ascii\(\'xn\-\-8yb0383efiwk\.xn\-\-1\-wsc3373r\.\'\)\ throws\ error\ B1\ B2\ B3\ \[data\/IdnaTest\.txt\:3043\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{08B3}𞤝⾫｡𐹣\x{068F}⒈", %p)},	undef,	"to_ascii\(\'\\u08B3𞤝⾫｡𐹣\\u068F⒈\'\)\ throws\ error\ B1\ B2\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:3044\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--8yb0383efiwk.xn--ljb064mol4n", %p)},	undef,	"to_ascii\(\'xn\-\-8yb0383efiwk\.xn\-\-ljb064mol4n\'\)\ throws\ error\ B1\ B2\ B3\ V6\ \[data\/IdnaTest\.txt\:3045\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{2433}𚎛𝟧\x{0661}.ᡢ8\x{0F72}\x{0600}", %p)},	undef,	"to_ascii\(\'\\u2433\?𝟧\\u0661\.ᡢ8\\u0F72\\u0600\'\)\ throws\ error\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:3046\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{2433}𚎛5\x{0661}.ᡢ8\x{0F72}\x{0600}", %p)},	undef,	"to_ascii\(\'\\u2433\?5\\u0661\.ᡢ8\\u0F72\\u0600\'\)\ throws\ error\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:3047\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--5-bqc410un435a.xn--8-rkc763epjj", %p)},	undef,	"to_ascii\(\'xn\-\-5\-bqc410un435a\.xn\-\-8\-rkc763epjj\'\)\ throws\ error\ B5\ B6\ V6\ \[data\/IdnaTest\.txt\:3048\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐹠.🄀⒒-󨰈", %p)},	undef,	"to_ascii\(\'𐹠\.🄀⒒\-\?\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:3049\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐹠.0.11.-󨰈", %p)},	undef,	"to_ascii\(\'𐹠\.0\.11\.\-\?\'\)\ throws\ error\ B1\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3050\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--7n0d.0.11.xn----8j07m", %p)},	undef,	"to_ascii\(\'xn\-\-7n0d\.0\.11\.xn\-\-\-\-8j07m\'\)\ throws\ error\ B1\ V3\ V6\ \[data\/IdnaTest\.txt\:3051\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--7n0d.xn----xcp9757q1s13g", %p)},	undef,	"to_ascii\(\'xn\-\-7n0d\.xn\-\-\-\-xcp9757q1s13g\'\)\ throws\ error\ B1\ V6\ \[data\/IdnaTest\.txt\:3052\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ς-。\x{200C}𝟭-", %p)},	undef,	"to_ascii\(\'ς\-\。\\u200C𝟭\-\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:3053\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ς-。\x{200C}1-", %p)},	undef,	"to_ascii\(\'ς\-\。\\u200C1\-\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:3055\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Σ-。\x{200C}1-", %p)},	undef,	"to_ascii\(\'Σ\-\。\\u200C1\-\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:3057\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("σ-。\x{200C}1-", %p)},	undef,	"to_ascii\(\'σ\-\。\\u200C1\-\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:3059\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----zmb.1-", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-zmb\.1\-\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:3061\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----zmb.xn--1--i1t", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-zmb\.xn\-\-1\-\-i1t\'\)\ throws\ error\ C1\ V3\ \[data\/IdnaTest\.txt\:3062\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----xmb.xn--1--i1t", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-xmb\.xn\-\-1\-\-i1t\'\)\ throws\ error\ C1\ V3\ \[data\/IdnaTest\.txt\:3063\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Σ-。\x{200C}𝟭-", %p)},	undef,	"to_ascii\(\'Σ\-\。\\u200C𝟭\-\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:3064\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("σ-。\x{200C}𝟭-", %p)},	undef,	"to_ascii\(\'σ\-\。\\u200C𝟭\-\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:3066\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1734}-\x{0CE2}．󠄩Ⴄ", %p)},	undef,	"to_ascii\(\'\\u1734\-\\u0CE2．\󠄩Ⴄ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3068\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1734}-\x{0CE2}.󠄩Ⴄ", %p)},	undef,	"to_ascii\(\'\\u1734\-\\u0CE2\.\󠄩Ⴄ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3069\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_ascii("\x{1734}-\x{0CE2}.󠄩ⴄ", %p)},	undef,	"to_ascii\(\'\\u1734\-\\u0CE2\.\󠄩ⴄ\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:3070\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn----ggf830f.xn--vkj", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-ggf830f\.xn\-\-vkj\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:3071\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----ggf830f.xn--cnd", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-ggf830f\.xn\-\-cnd\'\)\ throws\ error\ V5\ V6\ \[data\/IdnaTest\.txt\:3072\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_ascii("\x{1734}-\x{0CE2}．󠄩ⴄ", %p)},	undef,	"to_ascii\(\'\\u1734\-\\u0CE2．\󠄩ⴄ\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:3073\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("򭈗♋\x{06BB}𐦥｡\x{0954}⒈", %p)},	undef,	"to_ascii\(\'\?\♋\\u06BB𐦥｡\\u0954⒈\'\)\ throws\ error\ B1\ B5\ B6\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3074\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򭈗♋\x{06BB}𐦥。\x{0954}1.", %p)},	undef,	"to_ascii\(\'\?\♋\\u06BB𐦥\。\\u09541\.\'\)\ throws\ error\ B1\ B5\ B6\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3075\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--ukb372n129m3rs7f.xn--1-fyd.", %p)},	undef,	"to_ascii\(\'xn\-\-ukb372n129m3rs7f\.xn\-\-1\-fyd\.\'\)\ throws\ error\ B1\ B5\ B6\ V5\ V6\ \[data\/IdnaTest\.txt\:3076\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--ukb372n129m3rs7f.xn--u3b240l", %p)},	undef,	"to_ascii\(\'xn\-\-ukb372n129m3rs7f\.xn\-\-u3b240l\'\)\ throws\ error\ B1\ B5\ B6\ V5\ V6\ \[data\/IdnaTest\.txt\:3077\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("\x{05A4}．\x{06C1}\x{1AB3}\x{200C}", %p)},	undef,	"to_ascii\(\'\\u05A4．\\u06C1\\u1AB3\\u200C\'\)\ throws\ error\ B1\ B3\ B6\ V5\ \[data\/IdnaTest\.txt\:3078\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("\x{05A4}.\x{06C1}\x{1AB3}\x{200C}", %p)},	undef,	"to_ascii\(\'\\u05A4\.\\u06C1\\u1AB3\\u200C\'\)\ throws\ error\ B1\ B3\ B6\ V5\ \[data\/IdnaTest\.txt\:3080\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--vcb.xn--0kb623h", %p)},	undef,	"to_ascii\(\'xn\-\-vcb\.xn\-\-0kb623h\'\)\ throws\ error\ B1\ B3\ B6\ V5\ \[data\/IdnaTest\.txt\:3082\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--vcb.xn--0kb623hm1d", %p)},	undef,	"to_ascii\(\'xn\-\-vcb\.xn\-\-0kb623hm1d\'\)\ throws\ error\ B1\ B3\ B6\ C1\ V5\ \[data\/IdnaTest\.txt\:3083\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񢭏\x{0846}≮\x{0ACD}．𞦊", %p)},	undef,	"to_ascii\(\'\?\\u0846\≮\\u0ACD．\?\'\)\ throws\ error\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:3084\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񢭏\x{0846}<\x{0338}\x{0ACD}．𞦊", %p)},	undef,	"to_ascii\(\'\?\\u0846\<\\u0338\\u0ACD．\?\'\)\ throws\ error\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:3085\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񢭏\x{0846}≮\x{0ACD}.𞦊", %p)},	undef,	"to_ascii\(\'\?\\u0846\≮\\u0ACD\.\?\'\)\ throws\ error\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:3086\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񢭏\x{0846}<\x{0338}\x{0ACD}.𞦊", %p)},	undef,	"to_ascii\(\'\?\\u0846\<\\u0338\\u0ACD\.\?\'\)\ throws\ error\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:3087\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--4vb80kq29ayo62l.xn--8g6h", %p)},	undef,	"to_ascii\(\'xn\-\-4vb80kq29ayo62l\.xn\-\-8g6h\'\)\ throws\ error\ B5\ B6\ V6\ \[data\/IdnaTest\.txt\:3088\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}。𞀘⒈ꡍ擉", %p)},	undef,	"to_ascii\(\'\\u200D\。𞀘⒈ꡍ擉\'\)\ throws\ error\ P1\ V5\ V6\ A4_2\ \[data\/IdnaTest\.txt\:3089\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("\x{200D}。𞀘1.ꡍ擉", %p)},	undef,	"to_ascii\(\'\\u200D\。𞀘1\.ꡍ擉\'\)\ throws\ error\ V5\ A4_2\ \[data\/IdnaTest\.txt\:3091\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii(".xn--1-1p4r.xn--s7uv61m", %p)},	undef,	"to_ascii\(\'\.xn\-\-1\-1p4r\.xn\-\-s7uv61m\'\)\ throws\ error\ V5\ A4_2\ \[data\/IdnaTest\.txt\:3093\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--1ug.xn--1-1p4r.xn--s7uv61m", %p)},	undef,	"to_ascii\(\'xn\-\-1ug\.xn\-\-1\-1p4r\.xn\-\-s7uv61m\'\)\ throws\ error\ C2\ V5\ \[data\/IdnaTest\.txt\:3094\]") or ($@ and diag($@));
is(eval{uts46_to_ascii(".xn--tsh026uql4bew9p", %p)},	undef,	"to_ascii\(\'\.xn\-\-tsh026uql4bew9p\'\)\ throws\ error\ V5\ V6\ A4_2\ \[data\/IdnaTest\.txt\:3095\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--1ug.xn--tsh026uql4bew9p", %p)},	undef,	"to_ascii\(\'xn\-\-1ug\.xn\-\-tsh026uql4bew9p\'\)\ throws\ error\ C2\ V5\ V6\ \[data\/IdnaTest\.txt\:3096\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("₈\x{07CB}．\x{FB64}≠", %p)},	undef,	"to_ascii\(\'₈\\u07CB．\\uFB64\≠\'\)\ throws\ error\ B1\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:3097\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("₈\x{07CB}．\x{FB64}=\x{0338}", %p)},	undef,	"to_ascii\(\'₈\\u07CB．\\uFB64\=\\u0338\'\)\ throws\ error\ B1\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:3098\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("8\x{07CB}.\x{067F}≠", %p)},	undef,	"to_ascii\(\'8\\u07CB\.\\u067F\≠\'\)\ throws\ error\ B1\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:3099\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("8\x{07CB}.\x{067F}=\x{0338}", %p)},	undef,	"to_ascii\(\'8\\u07CB\.\\u067F\=\\u0338\'\)\ throws\ error\ B1\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:3100\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--8-zbd.xn--4ib883l", %p)},	undef,	"to_ascii\(\'xn\-\-8\-zbd\.xn\-\-4ib883l\'\)\ throws\ error\ B1\ B3\ V6\ \[data\/IdnaTest\.txt\:3101\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᢡ\x{07DE}򹐣.⒒\x{0642}𑍦", %p)},	undef,	"to_ascii\(\'ᢡ\\u07DE\?\.⒒\\u0642𑍦\'\)\ throws\ error\ B1\ B5\ P1\ V6\ \[data\/IdnaTest\.txt\:3102\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᢡ\x{07DE}򹐣.11.\x{0642}𑍦", %p)},	undef,	"to_ascii\(\'ᢡ\\u07DE\?\.11\.\\u0642𑍦\'\)\ throws\ error\ B1\ B5\ P1\ V6\ \[data\/IdnaTest\.txt\:3103\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--5sb596fi873t.11.xn--ehb4198k", %p)},	undef,	"to_ascii\(\'xn\-\-5sb596fi873t\.11\.xn\-\-ehb4198k\'\)\ throws\ error\ B1\ B5\ V6\ \[data\/IdnaTest\.txt\:3104\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--5sb596fi873t.xn--ehb336mvy7n", %p)},	undef,	"to_ascii\(\'xn\-\-5sb596fi873t\.xn\-\-ehb336mvy7n\'\)\ throws\ error\ B1\ B5\ V6\ \[data\/IdnaTest\.txt\:3105\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0E48}-𐹺𝟜.\x{0363}\x{06E1}⒏", %p)},	undef,	"to_ascii\(\'\\u0E48\-𐹺𝟜\.\\u0363\\u06E1⒏\'\)\ throws\ error\ B1\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3106\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("\x{0E48}-𐹺4.\x{0363}\x{06E1}8.", %p)},	undef,	"to_ascii\(\'\\u0E48\-𐹺4\.\\u0363\\u06E18\.\'\)\ throws\ error\ B1\ V5\ \[data\/IdnaTest\.txt\:3107\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn---4-owiz479s.xn--8-ihb69x.", %p)},	undef,	"to_ascii\(\'xn\-\-\-4\-owiz479s\.xn\-\-8\-ihb69x\.\'\)\ throws\ error\ B1\ V5\ \[data\/IdnaTest\.txt\:3108\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn---4-owiz479s.xn--eva20pjv9a", %p)},	undef,	"to_ascii\(\'xn\-\-\-4\-owiz479s\.xn\-\-eva20pjv9a\'\)\ throws\ error\ B1\ V5\ V6\ \[data\/IdnaTest\.txt\:3109\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⫐｡Ⴠ-󃐢", %p)},	undef,	"to_ascii\(\'\⫐｡Ⴠ\-\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3110\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⫐。Ⴠ-󃐢", %p)},	undef,	"to_ascii\(\'\⫐\。Ⴠ\-\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3111\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⫐。ⴠ-󃐢", %p)},	undef,	"to_ascii\(\'\⫐\。ⴠ\-\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3112\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--r3i.xn----2wst7439i", %p)},	undef,	"to_ascii\(\'xn\-\-r3i\.xn\-\-\-\-2wst7439i\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:3113\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--r3i.xn----z1g58579u", %p)},	undef,	"to_ascii\(\'xn\-\-r3i\.xn\-\-\-\-z1g58579u\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:3114\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⫐｡ⴠ-󃐢", %p)},	undef,	"to_ascii\(\'\⫐｡ⴠ\-\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3115\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("𑑂◊．⦟∠", %p)},	undef,	"to_ascii\(\'𑑂\◊．\⦟\∠\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:3116\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("𑑂◊.⦟∠", %p)},	undef,	"to_ascii\(\'𑑂\◊\.\⦟\∠\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:3117\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--01h3338f.xn--79g270a", %p)},	undef,	"to_ascii\(\'xn\-\-01h3338f\.xn\-\-79g270a\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:3118\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𿌰-\x{0662}。󋸛ꡂ", %p)},	undef,	"to_ascii\(\'\?\-\\u0662\。\?ꡂ\'\)\ throws\ error\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:3119\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----dqc20828e.xn--bc9an2879c", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-dqc20828e\.xn\-\-bc9an2879c\'\)\ throws\ error\ B5\ B6\ V6\ \[data\/IdnaTest\.txt\:3120\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0678}。󠏬\x{0741}𞪭𐹪", %p)},	undef,	"to_ascii\(\'\\u0678\。\?\\u0741\?𐹪\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:3121\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{064A}\x{0674}。󠏬\x{0741}𞪭𐹪", %p)},	undef,	"to_ascii\(\'\\u064A\\u0674\。\?\\u0741\?𐹪\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:3122\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--mhb8f.xn--oob2585kfdsfsbo7h", %p)},	undef,	"to_ascii\(\'xn\-\-mhb8f\.xn\-\-oob2585kfdsfsbo7h\'\)\ throws\ error\ B1\ V6\ \[data\/IdnaTest\.txt\:3123\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("𐫆ꌄ｡\x{200D}ᣬ", %p)},	undef,	"to_ascii\(\'𐫆ꌄ｡\\u200Dᣬ\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:3124\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("𐫆ꌄ。\x{200D}ᣬ", %p)},	undef,	"to_ascii\(\'𐫆ꌄ\。\\u200Dᣬ\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:3126\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--y77ao18q.xn--wdf", %p)},	undef,	"to_ascii\(\'xn\-\-y77ao18q\.xn\-\-wdf\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:3128\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--y77ao18q.xn--wdf367a", %p)},	undef,	"to_ascii\(\'xn\-\-y77ao18q\.xn\-\-wdf367a\'\)\ throws\ error\ B1\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:3129\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("₀\x{0662}。󅪞≯-", %p)},	undef,	"to_ascii\(\'₀\\u0662\。\?\≯\-\'\)\ throws\ error\ B1\ B6\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3130\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("₀\x{0662}。󅪞>\x{0338}-", %p)},	undef,	"to_ascii\(\'₀\\u0662\。\?\>\\u0338\-\'\)\ throws\ error\ B1\ B6\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3131\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("0\x{0662}。󅪞≯-", %p)},	undef,	"to_ascii\(\'0\\u0662\。\?\≯\-\'\)\ throws\ error\ B1\ B6\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3132\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("0\x{0662}。󅪞>\x{0338}-", %p)},	undef,	"to_ascii\(\'0\\u0662\。\?\>\\u0338\-\'\)\ throws\ error\ B1\ B6\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3133\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--0-dqc.xn----ogov3342l", %p)},	undef,	"to_ascii\(\'xn\-\-0\-dqc\.xn\-\-\-\-ogov3342l\'\)\ throws\ error\ B1\ B6\ V3\ V6\ \[data\/IdnaTest\.txt\:3134\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{031C}𐹫-𞯃.𐋤\x{0845}", %p)},	undef,	"to_ascii\(\'\\u031C𐹫\-\?\.𐋤\\u0845\'\)\ throws\ error\ B1\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3135\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----gdb7046r692g.xn--3vb1349j", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-gdb7046r692g\.xn\-\-3vb1349j\'\)\ throws\ error\ B1\ V5\ V6\ \[data\/IdnaTest\.txt\:3136\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≠｡𝩑𐹩Ⴡ\x{0594}", %p)},	undef,	"to_ascii\(\'\≠｡𝩑𐹩Ⴡ\\u0594\'\)\ throws\ error\ B1\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3137\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("=\x{0338}｡𝩑𐹩Ⴡ\x{0594}", %p)},	undef,	"to_ascii\(\'\=\\u0338｡𝩑𐹩Ⴡ\\u0594\'\)\ throws\ error\ B1\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3138\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≠。𝩑𐹩Ⴡ\x{0594}", %p)},	undef,	"to_ascii\(\'\≠\。𝩑𐹩Ⴡ\\u0594\'\)\ throws\ error\ B1\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3139\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("=\x{0338}。𝩑𐹩Ⴡ\x{0594}", %p)},	undef,	"to_ascii\(\'\=\\u0338\。𝩑𐹩Ⴡ\\u0594\'\)\ throws\ error\ B1\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3140\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("=\x{0338}。𝩑𐹩ⴡ\x{0594}", %p)},	undef,	"to_ascii\(\'\=\\u0338\。𝩑𐹩ⴡ\\u0594\'\)\ throws\ error\ B1\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3141\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≠。𝩑𐹩ⴡ\x{0594}", %p)},	undef,	"to_ascii\(\'\≠\。𝩑𐹩ⴡ\\u0594\'\)\ throws\ error\ B1\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3142\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--1ch.xn--fcb363rk03mypug", %p)},	undef,	"to_ascii\(\'xn\-\-1ch\.xn\-\-fcb363rk03mypug\'\)\ throws\ error\ B1\ V5\ V6\ \[data\/IdnaTest\.txt\:3143\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--1ch.xn--fcb538c649rypog", %p)},	undef,	"to_ascii\(\'xn\-\-1ch\.xn\-\-fcb538c649rypog\'\)\ throws\ error\ B1\ V5\ V6\ \[data\/IdnaTest\.txt\:3144\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("=\x{0338}｡𝩑𐹩ⴡ\x{0594}", %p)},	undef,	"to_ascii\(\'\=\\u0338｡𝩑𐹩ⴡ\\u0594\'\)\ throws\ error\ B1\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3145\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≠｡𝩑𐹩ⴡ\x{0594}", %p)},	undef,	"to_ascii\(\'\≠｡𝩑𐹩ⴡ\\u0594\'\)\ throws\ error\ B1\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3146\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𖫳≠.Ⴀ𐮀", %p)},	undef,	"to_ascii\(\'𖫳\≠\.Ⴀ𐮀\'\)\ throws\ error\ B1\ B5\ B6\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3147\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𖫳=\x{0338}.Ⴀ𐮀", %p)},	undef,	"to_ascii\(\'𖫳\=\\u0338\.Ⴀ𐮀\'\)\ throws\ error\ B1\ B5\ B6\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3148\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𖫳=\x{0338}.ⴀ𐮀", %p)},	undef,	"to_ascii\(\'𖫳\=\\u0338\.ⴀ𐮀\'\)\ throws\ error\ B1\ B5\ B6\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3149\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𖫳≠.ⴀ𐮀", %p)},	undef,	"to_ascii\(\'𖫳\≠\.ⴀ𐮀\'\)\ throws\ error\ B1\ B5\ B6\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3150\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--1ch9250k.xn--rkj6232e", %p)},	undef,	"to_ascii\(\'xn\-\-1ch9250k\.xn\-\-rkj6232e\'\)\ throws\ error\ B1\ B5\ B6\ V5\ V6\ \[data\/IdnaTest\.txt\:3151\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--1ch9250k.xn--7md2659j", %p)},	undef,	"to_ascii\(\'xn\-\-1ch9250k\.xn\-\-7md2659j\'\)\ throws\ error\ B1\ B5\ B6\ V5\ V6\ \[data\/IdnaTest\.txt\:3152\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠅾\x{0736}\x{0726}．ᢚ閪\x{08E2}𝩟", %p)},	undef,	"to_ascii\(\'\󠅾\\u0736\\u0726．ᢚ閪\\u08E2𝩟\'\)\ throws\ error\ B1\ B5\ B6\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3153\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠅾\x{0736}\x{0726}.ᢚ閪\x{08E2}𝩟", %p)},	undef,	"to_ascii\(\'\󠅾\\u0736\\u0726\.ᢚ閪\\u08E2𝩟\'\)\ throws\ error\ B1\ B5\ B6\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3154\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--wnb5a.xn--l0b161fis8gbp5m", %p)},	undef,	"to_ascii\(\'xn\-\-wnb5a\.xn\-\-l0b161fis8gbp5m\'\)\ throws\ error\ B1\ B5\ B6\ V5\ V6\ \[data\/IdnaTest\.txt\:3155\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("\x{200D}󠇜\x{06CB}\x{A8E9}｡\x{20DD}\x{0FB0}-ᛟ", %p)},	undef,	"to_ascii\(\'\\u200D\󠇜\\u06CB\\uA8E9｡\\u20DD\\u0FB0\-ᛟ\'\)\ throws\ error\ B1\ V5\ \[data\/IdnaTest\.txt\:3156\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("\x{200D}󠇜\x{06CB}\x{A8E9}。\x{20DD}\x{0FB0}-ᛟ", %p)},	undef,	"to_ascii\(\'\\u200D\󠇜\\u06CB\\uA8E9\。\\u20DD\\u0FB0\-ᛟ\'\)\ throws\ error\ B1\ V5\ \[data\/IdnaTest\.txt\:3158\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--blb8114f.xn----gmg236cj6k", %p)},	undef,	"to_ascii\(\'xn\-\-blb8114f\.xn\-\-\-\-gmg236cj6k\'\)\ throws\ error\ B1\ V5\ \[data\/IdnaTest\.txt\:3160\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--blb540ke10h.xn----gmg236cj6k", %p)},	undef,	"to_ascii\(\'xn\-\-blb540ke10h\.xn\-\-\-\-gmg236cj6k\'\)\ throws\ error\ B1\ C2\ V5\ \[data\/IdnaTest\.txt\:3161\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("헁󘖙\x{0E3A}󚍚。\x{06BA}𝟜", %p)},	undef,	"to_ascii\(\'헁\?\\u0E3A\?\。\\u06BA𝟜\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3162\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("헁󘖙\x{0E3A}󚍚。\x{06BA}𝟜", %p)},	undef,	"to_ascii\(\'헁\?\\u0E3A\?\。\\u06BA𝟜\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3163\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("헁󘖙\x{0E3A}󚍚。\x{06BA}4", %p)},	undef,	"to_ascii\(\'헁\?\\u0E3A\?\。\\u06BA4\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3164\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("헁󘖙\x{0E3A}󚍚。\x{06BA}4", %p)},	undef,	"to_ascii\(\'헁\?\\u0E3A\?\。\\u06BA4\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3165\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--o4c1723h8g85gt4ya.xn--4-dvc", %p)},	undef,	"to_ascii\(\'xn\-\-o4c1723h8g85gt4ya\.xn\-\-4\-dvc\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:3166\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐹭｡󃱂\x{200C}Ⴞ", %p)},	undef,	"to_ascii\(\'𐹭｡\?\\u200CႾ\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:3167\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐹭。󃱂\x{200C}Ⴞ", %p)},	undef,	"to_ascii\(\'𐹭\。\?\\u200CႾ\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:3169\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐹭。󃱂\x{200C}ⴞ", %p)},	undef,	"to_ascii\(\'𐹭\。\?\\u200Cⴞ\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:3171\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--lo0d.xn--mljx1099g", %p)},	undef,	"to_ascii\(\'xn\-\-lo0d\.xn\-\-mljx1099g\'\)\ throws\ error\ B1\ V6\ \[data\/IdnaTest\.txt\:3173\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--lo0d.xn--0ugx72cwi33v", %p)},	undef,	"to_ascii\(\'xn\-\-lo0d\.xn\-\-0ugx72cwi33v\'\)\ throws\ error\ B1\ C1\ V6\ \[data\/IdnaTest\.txt\:3174\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--lo0d.xn--2nd75260n", %p)},	undef,	"to_ascii\(\'xn\-\-lo0d\.xn\-\-2nd75260n\'\)\ throws\ error\ B1\ V6\ \[data\/IdnaTest\.txt\:3175\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--lo0d.xn--2nd949eqw95u", %p)},	undef,	"to_ascii\(\'xn\-\-lo0d\.xn\-\-2nd949eqw95u\'\)\ throws\ error\ B1\ C1\ V6\ \[data\/IdnaTest\.txt\:3176\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐹭｡󃱂\x{200C}ⴞ", %p)},	undef,	"to_ascii\(\'𐹭｡\?\\u200Cⴞ\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:3177\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{A953}.\x{033D}𑂽馋", %p)},	undef,	"to_ascii\(\'\\uA953\.\\u033D\?馋\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3179\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--3j9a.xn--bua0708eqzrd", %p)},	undef,	"to_ascii\(\'xn\-\-3j9a\.xn\-\-bua0708eqzrd\'\)\ throws\ error\ V5\ V6\ \[data\/IdnaTest\.txt\:3180\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󈫝򪛸\x{200D}｡䜖", %p)},	undef,	"to_ascii\(\'\?\?\\u200D｡䜖\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3181\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󈫝򪛸\x{200D}。䜖", %p)},	undef,	"to_ascii\(\'\?\?\\u200D\。䜖\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3183\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--g138cxw05a.xn--k0o", %p)},	undef,	"to_ascii\(\'xn\-\-g138cxw05a\.xn\-\-k0o\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:3185\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--1ug30527h9mxi.xn--k0o", %p)},	undef,	"to_ascii\(\'xn\-\-1ug30527h9mxi\.xn\-\-k0o\'\)\ throws\ error\ C2\ V6\ \[data\/IdnaTest\.txt\:3186\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᡯ⚉姶🄉．۷\x{200D}🎪\x{200D}", %p)},	undef,	"to_ascii\(\'ᡯ\⚉姶🄉．۷\\u200D🎪\\u200D\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3187\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᡯ⚉姶8,.۷\x{200D}🎪\x{200D}", %p)},	undef,	"to_ascii\(\'ᡯ\⚉姶8\,\.۷\\u200D🎪\\u200D\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3189\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--8,-g9oy26fzu4d.xn--kmb6733w", %p)},	undef,	"to_ascii\(\'xn\-\-8\,\-g9oy26fzu4d\.xn\-\-kmb6733w\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3191\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--8,-g9oy26fzu4d.xn--kmb859ja94998b", %p)},	undef,	"to_ascii\(\'xn\-\-8\,\-g9oy26fzu4d\.xn\-\-kmb859ja94998b\'\)\ throws\ error\ C2\ P1\ V6\ \[data\/IdnaTest\.txt\:3192\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--c9e433epi4b3j20a.xn--kmb6733w", %p)},	undef,	"to_ascii\(\'xn\-\-c9e433epi4b3j20a\.xn\-\-kmb6733w\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:3193\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--c9e433epi4b3j20a.xn--kmb859ja94998b", %p)},	undef,	"to_ascii\(\'xn\-\-c9e433epi4b3j20a\.xn\-\-kmb859ja94998b\'\)\ throws\ error\ C2\ V6\ \[data\/IdnaTest\.txt\:3194\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𞽀.𐹸🚖\x{0E3A}", %p)},	undef,	"to_ascii\(\'\?\.𐹸🚖\\u0E3A\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:3195\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--0n7h.xn--o4c9032klszf", %p)},	undef,	"to_ascii\(\'xn\-\-0n7h\.xn\-\-o4c9032klszf\'\)\ throws\ error\ B1\ V6\ \[data\/IdnaTest\.txt\:3196\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴔᠵ｡𐹧\x{0747}۹", %p)},	undef,	"to_ascii\(\'Ⴔᠵ｡𐹧\\u0747۹\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:3197\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴔᠵ。𐹧\x{0747}۹", %p)},	undef,	"to_ascii\(\'Ⴔᠵ\。𐹧\\u0747۹\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:3198\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("ⴔᠵ。𐹧\x{0747}۹", %p)},	undef,	"to_ascii\(\'ⴔᠵ\。𐹧\\u0747۹\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:3199\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--o7e997h.xn--mmb9ml895e", %p)},	undef,	"to_ascii\(\'xn\-\-o7e997h\.xn\-\-mmb9ml895e\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:3200\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--snd659a.xn--mmb9ml895e", %p)},	undef,	"to_ascii\(\'xn\-\-snd659a\.xn\-\-mmb9ml895e\'\)\ throws\ error\ B1\ V6\ \[data\/IdnaTest\.txt\:3201\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("ⴔᠵ｡𐹧\x{0747}۹", %p)},	undef,	"to_ascii\(\'ⴔᠵ｡𐹧\\u0747۹\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:3202\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("\x{135F}ᡈ\x{200C}．︒-𖾐-", %p)},	undef,	"to_ascii\(\'\\u135Fᡈ\\u200C．︒\-𖾐\-\'\)\ throws\ error\ P1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:3203\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_ascii("\x{135F}ᡈ\x{200C}.。-𖾐-", %p)},	undef,	"to_ascii\(\'\\u135Fᡈ\\u200C\.\。\-𖾐\-\'\)\ throws\ error\ V3\ V5\ A4_2\ \[data\/IdnaTest\.txt\:3205\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--b7d82w..xn-----pe4u", %p)},	undef,	"to_ascii\(\'xn\-\-b7d82w\.\.xn\-\-\-\-\-pe4u\'\)\ throws\ error\ V3\ V5\ A4_2\ \[data\/IdnaTest\.txt\:3207\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--b7d82wo4h..xn-----pe4u", %p)},	undef,	"to_ascii\(\'xn\-\-b7d82wo4h\.\.xn\-\-\-\-\-pe4u\'\)\ throws\ error\ C1\ V3\ V5\ A4_2\ \[data\/IdnaTest\.txt\:3208\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--b7d82w.xn-----c82nz547a", %p)},	undef,	"to_ascii\(\'xn\-\-b7d82w\.xn\-\-\-\-\-c82nz547a\'\)\ throws\ error\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:3209\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--b7d82wo4h.xn-----c82nz547a", %p)},	undef,	"to_ascii\(\'xn\-\-b7d82wo4h\.xn\-\-\-\-\-c82nz547a\'\)\ throws\ error\ C1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:3210\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⒈\x{0601}⒖\x{200C}.\x{1DF0}\x{07DB}", %p)},	undef,	"to_ascii\(\'⒈\\u0601⒖\\u200C\.\\u1DF0\\u07DB\'\)\ throws\ error\ B1\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3211\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("1.\x{0601}15.\x{200C}.\x{1DF0}\x{07DB}", %p)},	undef,	"to_ascii\(\'1\.\\u060115\.\\u200C\.\\u1DF0\\u07DB\'\)\ throws\ error\ B1\ P1\ V5\ V6\ A4_2\ \[data\/IdnaTest\.txt\:3213\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("1.xn--15-1pd..xn--2sb914i", %p)},	undef,	"to_ascii\(\'1\.xn\-\-15\-1pd\.\.xn\-\-2sb914i\'\)\ throws\ error\ B1\ V5\ V6\ A4_2\ \[data\/IdnaTest\.txt\:3215\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("1.xn--15-1pd.xn--0ug.xn--2sb914i", %p)},	undef,	"to_ascii\(\'1\.xn\-\-15\-1pd\.xn\-\-0ug\.xn\-\-2sb914i\'\)\ throws\ error\ B1\ C1\ V5\ V6\ \[data\/IdnaTest\.txt\:3216\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--jfb347mib.xn--2sb914i", %p)},	undef,	"to_ascii\(\'xn\-\-jfb347mib\.xn\-\-2sb914i\'\)\ throws\ error\ B1\ V5\ V6\ \[data\/IdnaTest\.txt\:3217\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--jfb844kmfdwb.xn--2sb914i", %p)},	undef,	"to_ascii\(\'xn\-\-jfb844kmfdwb\.xn\-\-2sb914i\'\)\ throws\ error\ B1\ C1\ V5\ V6\ \[data\/IdnaTest\.txt\:3218\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𝩜。-\x{0B4D}Ⴋ", %p)},	undef,	"to_ascii\(\'𝩜\。\-\\u0B4DႫ\'\)\ throws\ error\ P1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:3219\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_ascii("𝩜。-\x{0B4D}ⴋ", %p)},	undef,	"to_ascii\(\'𝩜\。\-\\u0B4Dⴋ\'\)\ throws\ error\ V3\ V5\ \[data\/IdnaTest\.txt\:3220\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--792h.xn----bse820x", %p)},	undef,	"to_ascii\(\'xn\-\-792h\.xn\-\-\-\-bse820x\'\)\ throws\ error\ V3\ V5\ \[data\/IdnaTest\.txt\:3221\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--792h.xn----bse632b", %p)},	undef,	"to_ascii\(\'xn\-\-792h\.xn\-\-\-\-bse632b\'\)\ throws\ error\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:3222\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ßჀ.\x{0620}刯Ⴝ", %p)},	undef,	"to_ascii\(\'ßჀ\.\\u0620刯Ⴝ\'\)\ throws\ error\ B2\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:3223\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_ascii("ßⴠ.\x{0620}刯ⴝ", %p)},	undef,	"to_ascii\(\'ßⴠ\.\\u0620刯ⴝ\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:3225\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("SSჀ.\x{0620}刯Ⴝ", %p)},	undef,	"to_ascii\(\'SSჀ\.\\u0620刯Ⴝ\'\)\ throws\ error\ B2\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:3227\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_ascii("ssⴠ.\x{0620}刯ⴝ", %p)},	undef,	"to_ascii\(\'ssⴠ\.\\u0620刯ⴝ\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:3228\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("Ssⴠ.\x{0620}刯Ⴝ", %p)},	undef,	"to_ascii\(\'Ssⴠ\.\\u0620刯Ⴝ\'\)\ throws\ error\ B2\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:3229\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--ss-j81a.xn--fgb845cb66c", %p)},	undef,	"to_ascii\(\'xn\-\-ss\-j81a\.xn\-\-fgb845cb66c\'\)\ throws\ error\ B2\ B3\ V6\ \[data\/IdnaTest\.txt\:3230\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--ss-j81a.xn--fgb670rovy", %p)},	undef,	"to_ascii\(\'xn\-\-ss\-j81a\.xn\-\-fgb670rovy\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:3231\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--ss-wgk.xn--fgb845cb66c", %p)},	undef,	"to_ascii\(\'xn\-\-ss\-wgk\.xn\-\-fgb845cb66c\'\)\ throws\ error\ B2\ B3\ V6\ \[data\/IdnaTest\.txt\:3232\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--zca277t.xn--fgb670rovy", %p)},	undef,	"to_ascii\(\'xn\-\-zca277t\.xn\-\-fgb670rovy\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:3233\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--zca442f.xn--fgb845cb66c", %p)},	undef,	"to_ascii\(\'xn\-\-zca442f\.xn\-\-fgb845cb66c\'\)\ throws\ error\ B2\ B3\ V6\ \[data\/IdnaTest\.txt\:3234\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1BAA}ႣℲ｡ᠳ툻\x{0673}", %p)},	undef,	"to_ascii\(\'\\u1BAAႣℲ｡ᠳ툻\\u0673\'\)\ throws\ error\ B5\ B6\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3235\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1BAA}ႣℲ｡ᠳ툻\x{0673}", %p)},	undef,	"to_ascii\(\'\\u1BAAႣℲ｡ᠳ툻\\u0673\'\)\ throws\ error\ B5\ B6\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3236\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1BAA}ႣℲ。ᠳ툻\x{0673}", %p)},	undef,	"to_ascii\(\'\\u1BAAႣℲ\。ᠳ툻\\u0673\'\)\ throws\ error\ B5\ B6\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3237\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1BAA}ႣℲ。ᠳ툻\x{0673}", %p)},	undef,	"to_ascii\(\'\\u1BAAႣℲ\。ᠳ툻\\u0673\'\)\ throws\ error\ B5\ B6\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3238\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_ascii("\x{1BAA}ⴃⅎ。ᠳ툻\x{0673}", %p)},	undef,	"to_ascii\(\'\\u1BAAⴃⅎ\。ᠳ툻\\u0673\'\)\ throws\ error\ B5\ B6\ V5\ \[data\/IdnaTest\.txt\:3239\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_ascii("\x{1BAA}ⴃⅎ。ᠳ툻\x{0673}", %p)},	undef,	"to_ascii\(\'\\u1BAAⴃⅎ\。ᠳ툻\\u0673\'\)\ throws\ error\ B5\ B6\ V5\ \[data\/IdnaTest\.txt\:3240\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("\x{1BAA}Ⴃⅎ。ᠳ툻\x{0673}", %p)},	undef,	"to_ascii\(\'\\u1BAAႣⅎ\。ᠳ툻\\u0673\'\)\ throws\ error\ B5\ B6\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3241\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1BAA}Ⴃⅎ。ᠳ툻\x{0673}", %p)},	undef,	"to_ascii\(\'\\u1BAAႣⅎ\。ᠳ툻\\u0673\'\)\ throws\ error\ B5\ B6\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3242\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--bnd957c2pe.xn--sib102gc69k", %p)},	undef,	"to_ascii\(\'xn\-\-bnd957c2pe\.xn\-\-sib102gc69k\'\)\ throws\ error\ B5\ B6\ V5\ V6\ \[data\/IdnaTest\.txt\:3243\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--yxf24x4ol.xn--sib102gc69k", %p)},	undef,	"to_ascii\(\'xn\-\-yxf24x4ol\.xn\-\-sib102gc69k\'\)\ throws\ error\ B5\ B6\ V5\ \[data\/IdnaTest\.txt\:3244\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--bnd957cone.xn--sib102gc69k", %p)},	undef,	"to_ascii\(\'xn\-\-bnd957cone\.xn\-\-sib102gc69k\'\)\ throws\ error\ B5\ B6\ V5\ V6\ \[data\/IdnaTest\.txt\:3245\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_ascii("\x{1BAA}ⴃⅎ｡ᠳ툻\x{0673}", %p)},	undef,	"to_ascii\(\'\\u1BAAⴃⅎ｡ᠳ툻\\u0673\'\)\ throws\ error\ B5\ B6\ V5\ \[data\/IdnaTest\.txt\:3246\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_ascii("\x{1BAA}ⴃⅎ｡ᠳ툻\x{0673}", %p)},	undef,	"to_ascii\(\'\\u1BAAⴃⅎ｡ᠳ툻\\u0673\'\)\ throws\ error\ B5\ B6\ V5\ \[data\/IdnaTest\.txt\:3247\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("\x{1BAA}Ⴃⅎ｡ᠳ툻\x{0673}", %p)},	undef,	"to_ascii\(\'\\u1BAAႣⅎ｡ᠳ툻\\u0673\'\)\ throws\ error\ B5\ B6\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3248\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1BAA}Ⴃⅎ｡ᠳ툻\x{0673}", %p)},	undef,	"to_ascii\(\'\\u1BAAႣⅎ｡ᠳ툻\\u0673\'\)\ throws\ error\ B5\ B6\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3249\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_ascii("\x{06EC}.\x{08A2}𐹫\x{067C}", %p)},	undef,	"to_ascii\(\'\\u06EC\.\\u08A2𐹫\\u067C\'\)\ throws\ error\ B1\ B3\ B6\ V5\ \[data\/IdnaTest\.txt\:3250\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--8lb.xn--1ib31ily45b", %p)},	undef,	"to_ascii\(\'xn\-\-8lb\.xn\-\-1ib31ily45b\'\)\ throws\ error\ B1\ B3\ B6\ V5\ \[data\/IdnaTest\.txt\:3251\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("\x{06B6}\x{06DF}。₇\x{A806}", %p)},	undef,	"to_ascii\(\'\\u06B6\\u06DF\。₇\\uA806\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:3252\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("\x{06B6}\x{06DF}。7\x{A806}", %p)},	undef,	"to_ascii\(\'\\u06B6\\u06DF\。7\\uA806\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:3253\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--pkb6f.xn--7-x93e", %p)},	undef,	"to_ascii\(\'xn\-\-pkb6f\.xn\-\-7\-x93e\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:3254\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("\x{06B6}\x{06DF}.7\x{A806}", %p)},	undef,	"to_ascii\(\'\\u06B6\\u06DF\.7\\uA806\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:3255\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("Ⴣ𐹻.\x{200C}𝪣≮󠩉", %p)},	undef,	"to_ascii\(\'Ⴣ𐹻\.\\u200C𝪣\≮\?\'\)\ throws\ error\ B1\ B5\ B6\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3256\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴣ𐹻.\x{200C}𝪣<\x{0338}󠩉", %p)},	undef,	"to_ascii\(\'Ⴣ𐹻\.\\u200C𝪣\<\\u0338\?\'\)\ throws\ error\ B1\ B5\ B6\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3258\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⴣ𐹻.\x{200C}𝪣<\x{0338}󠩉", %p)},	undef,	"to_ascii\(\'ⴣ𐹻\.\\u200C𝪣\<\\u0338\?\'\)\ throws\ error\ B1\ B5\ B6\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3260\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⴣ𐹻.\x{200C}𝪣≮󠩉", %p)},	undef,	"to_ascii\(\'ⴣ𐹻\.\\u200C𝪣\≮\?\'\)\ throws\ error\ B1\ B5\ B6\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3262\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--rlj6323e.xn--gdh4944ob3x3e", %p)},	undef,	"to_ascii\(\'xn\-\-rlj6323e\.xn\-\-gdh4944ob3x3e\'\)\ throws\ error\ B1\ B5\ B6\ V5\ V6\ \[data\/IdnaTest\.txt\:3264\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--rlj6323e.xn--0ugy6gn120eb103g", %p)},	undef,	"to_ascii\(\'xn\-\-rlj6323e\.xn\-\-0ugy6gn120eb103g\'\)\ throws\ error\ B1\ B5\ B6\ C1\ V6\ \[data\/IdnaTest\.txt\:3265\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--7nd8101k.xn--gdh4944ob3x3e", %p)},	undef,	"to_ascii\(\'xn\-\-7nd8101k\.xn\-\-gdh4944ob3x3e\'\)\ throws\ error\ B1\ B5\ B6\ V5\ V6\ \[data\/IdnaTest\.txt\:3266\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--7nd8101k.xn--0ugy6gn120eb103g", %p)},	undef,	"to_ascii\(\'xn\-\-7nd8101k\.xn\-\-0ugy6gn120eb103g\'\)\ throws\ error\ B1\ B5\ B6\ C1\ V6\ \[data\/IdnaTest\.txt\:3267\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_ascii("𝟵隁⯮．\x{180D}\x{200C}", %p)},	"xn--9-mfs8024b.",	"to_ascii\(\'𝟵隁\⯮．\\u180D\\u200C\'\)\ \[data\/IdnaTest\.txt\:3268\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_ascii("9隁⯮.\x{180D}\x{200C}", %p)},	"xn--9-mfs8024b.",	"to_ascii\(\'9隁\⯮\.\\u180D\\u200C\'\)\ \[data\/IdnaTest\.txt\:3270\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_ascii("xn--9-mfs8024b.", %p)},	"xn--9-mfs8024b.",	"to_ascii\(\'xn\-\-9\-mfs8024b\.\'\)\ \[data\/IdnaTest\.txt\:3272\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_ascii("9隁⯮.", %p)},	"xn--9-mfs8024b.",	"to_ascii\(\'9隁\⯮\.\'\)\ \[data\/IdnaTest\.txt\:3273\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--9-mfs8024b.xn--0ug", %p)},	undef,	"to_ascii\(\'xn\-\-9\-mfs8024b\.xn\-\-0ug\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:3274\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⒏𐹧｡Ⴣ\x{0F84}彦", %p)},	undef,	"to_ascii\(\'⒏𐹧｡Ⴣ\\u0F84彦\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:3275\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("8.𐹧。Ⴣ\x{0F84}彦", %p)},	undef,	"to_ascii\(\'8\.𐹧\。Ⴣ\\u0F84彦\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:3276\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("8.𐹧。ⴣ\x{0F84}彦", %p)},	undef,	"to_ascii\(\'8\.𐹧\。ⴣ\\u0F84彦\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:3277\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("8.xn--fo0d.xn--3ed972m6o8a", %p)},	undef,	"to_ascii\(\'8\.xn\-\-fo0d\.xn\-\-3ed972m6o8a\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:3278\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("8.xn--fo0d.xn--3ed15dt93o", %p)},	undef,	"to_ascii\(\'8\.xn\-\-fo0d\.xn\-\-3ed15dt93o\'\)\ throws\ error\ B1\ V6\ \[data\/IdnaTest\.txt\:3279\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⒏𐹧｡ⴣ\x{0F84}彦", %p)},	undef,	"to_ascii\(\'⒏𐹧｡ⴣ\\u0F84彦\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:3280\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--0sh2466f.xn--3ed972m6o8a", %p)},	undef,	"to_ascii\(\'xn\-\-0sh2466f\.xn\-\-3ed972m6o8a\'\)\ throws\ error\ B1\ V6\ \[data\/IdnaTest\.txt\:3281\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--0sh2466f.xn--3ed15dt93o", %p)},	undef,	"to_ascii\(\'xn\-\-0sh2466f\.xn\-\-3ed15dt93o\'\)\ throws\ error\ B1\ V6\ \[data\/IdnaTest\.txt\:3282\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-问񬰔⒛。\x{0604}-񜗉橬", %p)},	undef,	"to_ascii\(\'\-问\?⒛\。\\u0604\-\?橬\'\)\ throws\ error\ B1\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3283\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-问񬰔20.。\x{0604}-񜗉橬", %p)},	undef,	"to_ascii\(\'\-问\?20\.\。\\u0604\-\?橬\'\)\ throws\ error\ B1\ P1\ V3\ V6\ A4_2\ \[data\/IdnaTest\.txt\:3284\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn---20-658jx1776d..xn----ykc7228efm46d", %p)},	undef,	"to_ascii\(\'xn\-\-\-20\-658jx1776d\.\.xn\-\-\-\-ykc7228efm46d\'\)\ throws\ error\ B1\ V3\ V6\ A4_2\ \[data\/IdnaTest\.txt\:3285\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----hdpu849bhis3e.xn----ykc7228efm46d", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-hdpu849bhis3e\.xn\-\-\-\-ykc7228efm46d\'\)\ throws\ error\ B1\ V3\ V6\ \[data\/IdnaTest\.txt\:3286\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1BAC}Ⴌ\x{200C}\x{0325}。𝟸", %p)},	undef,	"to_ascii\(\'\\u1BACႬ\\u200C\\u0325\。𝟸\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3287\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1BAC}Ⴌ\x{200C}\x{0325}。2", %p)},	undef,	"to_ascii\(\'\\u1BACႬ\\u200C\\u0325\。2\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3289\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_ascii("\x{1BAC}ⴌ\x{200C}\x{0325}。2", %p)},	undef,	"to_ascii\(\'\\u1BACⴌ\\u200C\\u0325\。2\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:3291\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--mta176jjjm.2", %p)},	undef,	"to_ascii\(\'xn\-\-mta176jjjm\.2\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:3293\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--mta176j97cl2q.2", %p)},	undef,	"to_ascii\(\'xn\-\-mta176j97cl2q\.2\'\)\ throws\ error\ C1\ V5\ \[data\/IdnaTest\.txt\:3294\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--mta930emri.2", %p)},	undef,	"to_ascii\(\'xn\-\-mta930emri\.2\'\)\ throws\ error\ V5\ V6\ \[data\/IdnaTest\.txt\:3295\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--mta930emribme.2", %p)},	undef,	"to_ascii\(\'xn\-\-mta930emribme\.2\'\)\ throws\ error\ C1\ V5\ V6\ \[data\/IdnaTest\.txt\:3296\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_ascii("\x{1BAC}ⴌ\x{200C}\x{0325}。𝟸", %p)},	undef,	"to_ascii\(\'\\u1BACⴌ\\u200C\\u0325\。𝟸\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:3297\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("\x{DC5F}。\x{A806}\x{0669}󠒩", %p)},	undef,	"to_ascii\(\'\\uDC5F\。\\uA806\\u0669\?\'\)\ throws\ error\ B1\ P1\ V5\ V6\ A3\ \[data\/IdnaTest\.txt\:3299\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{DC5F}.xn--iib9583fusy0i", %p)},	undef,	"to_ascii\(\'\\uDC5F\.xn\-\-iib9583fusy0i\'\)\ throws\ error\ B1\ P1\ V5\ V6\ A3\ \[data\/IdnaTest\.txt\:3300\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{DC5F}.XN--IIB9583FUSY0I", %p)},	undef,	"to_ascii\(\'\\uDC5F\.XN\-\-IIB9583FUSY0I\'\)\ throws\ error\ B1\ P1\ V5\ V6\ A3\ \[data\/IdnaTest\.txt\:3301\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{DC5F}.Xn--Iib9583fusy0i", %p)},	undef,	"to_ascii\(\'\\uDC5F\.Xn\-\-Iib9583fusy0i\'\)\ throws\ error\ B1\ P1\ V5\ V6\ A3\ \[data\/IdnaTest\.txt\:3302\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠄁\x{035F}⾶｡₇︒눇≮", %p)},	undef,	"to_ascii\(\'\󠄁\\u035F⾶｡₇︒눇\≮\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3303\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠄁\x{035F}⾶｡₇︒눇<\x{0338}", %p)},	undef,	"to_ascii\(\'\󠄁\\u035F⾶｡₇︒눇\<\\u0338\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3304\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠄁\x{035F}飛。7。눇≮", %p)},	undef,	"to_ascii\(\'\󠄁\\u035F飛\。7\。눇\≮\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3305\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠄁\x{035F}飛。7。눇<\x{0338}", %p)},	undef,	"to_ascii\(\'\󠄁\\u035F飛\。7\。눇\<\\u0338\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3306\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--9ua0567e.7.xn--gdh6767c", %p)},	undef,	"to_ascii\(\'xn\-\-9ua0567e\.7\.xn\-\-gdh6767c\'\)\ throws\ error\ V5\ V6\ \[data\/IdnaTest\.txt\:3307\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--9ua0567e.xn--7-ngou006d1ttc", %p)},	undef,	"to_ascii\(\'xn\-\-9ua0567e\.xn\-\-7\-ngou006d1ttc\'\)\ throws\ error\ V5\ V6\ \[data\/IdnaTest\.txt\:3308\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("\x{200C}\x{FE09}𐹴\x{200D}．\x{200C}⿃", %p)},	undef,	"to_ascii\(\'\\u200C\\uFE09𐹴\\u200D．\\u200C⿃\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:3309\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("\x{200C}\x{FE09}𐹴\x{200D}.\x{200C}鳥", %p)},	undef,	"to_ascii\(\'\\u200C\\uFE09𐹴\\u200D\.\\u200C鳥\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:3311\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--so0d.xn--6x6a", %p)},	undef,	"to_ascii\(\'xn\-\-so0d\.xn\-\-6x6a\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:3313\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--0ugc6024p.xn--0ug1920c", %p)},	undef,	"to_ascii\(\'xn\-\-0ugc6024p\.xn\-\-0ug1920c\'\)\ throws\ error\ B1\ C1\ C2\ \[data\/IdnaTest\.txt\:3314\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("🍮．\x{200D}󠗒𐦁𝨝", %p)},	undef,	"to_ascii\(\'🍮．\\u200D\?𐦁𝨝\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:3315\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("🍮.\x{200D}󠗒𐦁𝨝", %p)},	undef,	"to_ascii\(\'🍮\.\\u200D\?𐦁𝨝\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:3317\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--lj8h.xn--ln9ci476aqmr2g", %p)},	undef,	"to_ascii\(\'xn\-\-lj8h\.xn\-\-ln9ci476aqmr2g\'\)\ throws\ error\ B1\ V6\ \[data\/IdnaTest\.txt\:3319\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--lj8h.xn--1ug6603gr1pfwq37h", %p)},	undef,	"to_ascii\(\'xn\-\-lj8h\.xn\-\-1ug6603gr1pfwq37h\'\)\ throws\ error\ B1\ C2\ V6\ \[data\/IdnaTest\.txt\:3320\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("\x{067D}\x{0943}.𞤓\x{200D}", %p)},	"xn--2ib43l.xn--te6h",	"to_ascii\(\'\\u067D\\u0943\.𞤓\\u200D\'\)\ \[data\/IdnaTest\.txt\:3321\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("\x{067D}\x{0943}.𞤵\x{200D}", %p)},	"xn--2ib43l.xn--te6h",	"to_ascii\(\'\\u067D\\u0943\.𞤵\\u200D\'\)\ \[data\/IdnaTest\.txt\:3323\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("xn--2ib43l.xn--te6h", %p)},	"xn--2ib43l.xn--te6h",	"to_ascii\(\'xn\-\-2ib43l\.xn\-\-te6h\'\)\ \[data\/IdnaTest\.txt\:3325\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("\x{067D}\x{0943}.𞤵", %p)},	"xn--2ib43l.xn--te6h",	"to_ascii\(\'\\u067D\\u0943\.𞤵\'\)\ \[data\/IdnaTest\.txt\:3326\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("\x{067D}\x{0943}.𞤓", %p)},	"xn--2ib43l.xn--te6h",	"to_ascii\(\'\\u067D\\u0943\.𞤓\'\)\ \[data\/IdnaTest\.txt\:3327\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--2ib43l.xn--1ugy711p", %p)},	undef,	"to_ascii\(\'xn\-\-2ib43l\.xn\-\-1ugy711p\'\)\ throws\ error\ B3\ C2\ \[data\/IdnaTest\.txt\:3328\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0664}\x{0A4D}-．󥜽\x{1039}񦦐", %p)},	undef,	"to_ascii\(\'\\u0664\\u0A4D\-．\?\\u1039\?\'\)\ throws\ error\ B1\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3329\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0664}\x{0A4D}-.󥜽\x{1039}񦦐", %p)},	undef,	"to_ascii\(\'\\u0664\\u0A4D\-\.\?\\u1039\?\'\)\ throws\ error\ B1\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3330\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----gqc711a.xn--9jd88234f3qm0b", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-gqc711a\.xn\-\-9jd88234f3qm0b\'\)\ throws\ error\ B1\ V3\ V6\ \[data\/IdnaTest\.txt\:3331\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("4\x{103A}-𐹸｡\x{AA29}\x{200C}𐹴≮", %p)},	undef,	"to_ascii\(\'4\\u103A\-𐹸｡\\uAA29\\u200C𐹴\≮\'\)\ throws\ error\ B1\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3332\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("4\x{103A}-𐹸｡\x{AA29}\x{200C}𐹴<\x{0338}", %p)},	undef,	"to_ascii\(\'4\\u103A\-𐹸｡\\uAA29\\u200C𐹴\<\\u0338\'\)\ throws\ error\ B1\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3334\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("4\x{103A}-𐹸。\x{AA29}\x{200C}𐹴≮", %p)},	undef,	"to_ascii\(\'4\\u103A\-𐹸\。\\uAA29\\u200C𐹴\≮\'\)\ throws\ error\ B1\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3336\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("4\x{103A}-𐹸。\x{AA29}\x{200C}𐹴<\x{0338}", %p)},	undef,	"to_ascii\(\'4\\u103A\-𐹸\。\\uAA29\\u200C𐹴\<\\u0338\'\)\ throws\ error\ B1\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3338\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--4--e4j7831r.xn--gdh8754cz40c", %p)},	undef,	"to_ascii\(\'xn\-\-4\-\-e4j7831r\.xn\-\-gdh8754cz40c\'\)\ throws\ error\ B1\ V5\ V6\ \[data\/IdnaTest\.txt\:3340\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--4--e4j7831r.xn--0ugy6gjy5sl3ud", %p)},	undef,	"to_ascii\(\'xn\-\-4\-\-e4j7831r\.xn\-\-0ugy6gjy5sl3ud\'\)\ throws\ error\ B1\ C1\ V5\ V6\ \[data\/IdnaTest\.txt\:3341\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}。\x{FFA0}\x{0F84}\x{0F96}", %p)},	undef,	"to_ascii\(\'\\u200C\。\\uFFA0\\u0F84\\u0F96\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:3342\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}。\x{1160}\x{0F84}\x{0F96}", %p)},	undef,	"to_ascii\(\'\\u200C\。\\u1160\\u0F84\\u0F96\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:3344\]") or ($@ and diag($@));
is(eval{uts46_to_ascii(".xn--3ed0b20h", %p)},	undef,	"to_ascii\(\'\.xn\-\-3ed0b20h\'\)\ throws\ error\ V6\ A4_2\ \[data\/IdnaTest\.txt\:3346\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--0ug.xn--3ed0b20h", %p)},	undef,	"to_ascii\(\'xn\-\-0ug\.xn\-\-3ed0b20h\'\)\ throws\ error\ C1\ V6\ \[data\/IdnaTest\.txt\:3347\]") or ($@ and diag($@));
is(eval{uts46_to_ascii(".xn--3ed0by082k", %p)},	undef,	"to_ascii\(\'\.xn\-\-3ed0by082k\'\)\ throws\ error\ V6\ A4_2\ \[data\/IdnaTest\.txt\:3348\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--0ug.xn--3ed0by082k", %p)},	undef,	"to_ascii\(\'xn\-\-0ug\.xn\-\-3ed0by082k\'\)\ throws\ error\ C1\ V6\ \[data\/IdnaTest\.txt\:3349\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≯򍘅．\x{200D}𐅼򲇛", %p)},	undef,	"to_ascii\(\'\≯\?．\\u200D𐅼\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3350\]") or ($@ and diag($@));
is(eval{uts46_to_ascii(">\x{0338}򍘅．\x{200D}𐅼򲇛", %p)},	undef,	"to_ascii\(\'\>\\u0338\?．\\u200D𐅼\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3352\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≯򍘅.\x{200D}𐅼򲇛", %p)},	undef,	"to_ascii\(\'\≯\?\.\\u200D𐅼\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3354\]") or ($@ and diag($@));
is(eval{uts46_to_ascii(">\x{0338}򍘅.\x{200D}𐅼򲇛", %p)},	undef,	"to_ascii\(\'\>\\u0338\?\.\\u200D𐅼\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3356\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--hdh84488f.xn--xy7cw2886b", %p)},	undef,	"to_ascii\(\'xn\-\-hdh84488f\.xn\-\-xy7cw2886b\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:3358\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--hdh84488f.xn--1ug8099fbjp4e", %p)},	undef,	"to_ascii\(\'xn\-\-hdh84488f\.xn\-\-1ug8099fbjp4e\'\)\ throws\ error\ C2\ V6\ \[data\/IdnaTest\.txt\:3359\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("\x{0641}ß𐰯｡𝟕𐫫", %p)},	undef,	"to_ascii\(\'\\u0641ß𐰯｡𝟕𐫫\'\)\ throws\ error\ B1\ B2\ \[data\/IdnaTest\.txt\:3360\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("\x{0641}ß𐰯。7𐫫", %p)},	undef,	"to_ascii\(\'\\u0641ß𐰯\。7𐫫\'\)\ throws\ error\ B1\ B2\ \[data\/IdnaTest\.txt\:3362\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("\x{0641}SS𐰯。7𐫫", %p)},	undef,	"to_ascii\(\'\\u0641SS𐰯\。7𐫫\'\)\ throws\ error\ B1\ B2\ \[data\/IdnaTest\.txt\:3364\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("\x{0641}ss𐰯。7𐫫", %p)},	undef,	"to_ascii\(\'\\u0641ss𐰯\。7𐫫\'\)\ throws\ error\ B1\ B2\ \[data\/IdnaTest\.txt\:3365\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("\x{0641}Ss𐰯。7𐫫", %p)},	undef,	"to_ascii\(\'\\u0641Ss𐰯\。7𐫫\'\)\ throws\ error\ B1\ B2\ \[data\/IdnaTest\.txt\:3366\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--ss-jvd2339x.xn--7-mm5i", %p)},	undef,	"to_ascii\(\'xn\-\-ss\-jvd2339x\.xn\-\-7\-mm5i\'\)\ throws\ error\ B1\ B2\ \[data\/IdnaTest\.txt\:3367\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--zca96ys96y.xn--7-mm5i", %p)},	undef,	"to_ascii\(\'xn\-\-zca96ys96y\.xn\-\-7\-mm5i\'\)\ throws\ error\ B1\ B2\ \[data\/IdnaTest\.txt\:3368\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("\x{0641}SS𐰯｡𝟕𐫫", %p)},	undef,	"to_ascii\(\'\\u0641SS𐰯｡𝟕𐫫\'\)\ throws\ error\ B1\ B2\ \[data\/IdnaTest\.txt\:3369\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("\x{0641}ss𐰯｡𝟕𐫫", %p)},	undef,	"to_ascii\(\'\\u0641ss𐰯｡𝟕𐫫\'\)\ throws\ error\ B1\ B2\ \[data\/IdnaTest\.txt\:3370\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("\x{0641}Ss𐰯｡𝟕𐫫", %p)},	undef,	"to_ascii\(\'\\u0641Ss𐰯｡𝟕𐫫\'\)\ throws\ error\ B1\ B2\ \[data\/IdnaTest\.txt\:3371\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("ß\x{07AC}\x{07A7}\x{08B1}。𐭁􅮙𐹲", %p)},	undef,	"to_ascii\(\'ß\\u07AC\\u07A7\\u08B1\。𐭁\?𐹲\'\)\ throws\ error\ B2\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:3372\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("SS\x{07AC}\x{07A7}\x{08B1}。𐭁􅮙𐹲", %p)},	undef,	"to_ascii\(\'SS\\u07AC\\u07A7\\u08B1\。𐭁\?𐹲\'\)\ throws\ error\ B2\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:3374\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ss\x{07AC}\x{07A7}\x{08B1}。𐭁􅮙𐹲", %p)},	undef,	"to_ascii\(\'ss\\u07AC\\u07A7\\u08B1\。𐭁\?𐹲\'\)\ throws\ error\ B2\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:3375\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ss\x{07AC}\x{07A7}\x{08B1}。𐭁􅮙𐹲", %p)},	undef,	"to_ascii\(\'Ss\\u07AC\\u07A7\\u08B1\。𐭁\?𐹲\'\)\ throws\ error\ B2\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:3376\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--ss-9qet02k.xn--e09co8cr9861c", %p)},	undef,	"to_ascii\(\'xn\-\-ss\-9qet02k\.xn\-\-e09co8cr9861c\'\)\ throws\ error\ B2\ B5\ B6\ V6\ \[data\/IdnaTest\.txt\:3377\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--zca685aoa95h.xn--e09co8cr9861c", %p)},	undef,	"to_ascii\(\'xn\-\-zca685aoa95h\.xn\-\-e09co8cr9861c\'\)\ throws\ error\ B2\ B5\ B6\ V6\ \[data\/IdnaTest\.txt\:3378\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-｡󠉗⒌𞯛", %p)},	undef,	"to_ascii\(\'\-｡\?⒌\?\'\)\ throws\ error\ B1\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3379\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-。󠉗5.𞯛", %p)},	undef,	"to_ascii\(\'\-\。\?5\.\?\'\)\ throws\ error\ B1\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3380\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-.xn--5-zz21m.xn--6x6h", %p)},	undef,	"to_ascii\(\'\-\.xn\-\-5\-zz21m\.xn\-\-6x6h\'\)\ throws\ error\ B1\ V3\ V6\ \[data\/IdnaTest\.txt\:3381\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-.xn--xsh6367n1bi3e", %p)},	undef,	"to_ascii\(\'\-\.xn\-\-xsh6367n1bi3e\'\)\ throws\ error\ B1\ V3\ V6\ \[data\/IdnaTest\.txt\:3382\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𼎏ς．-≮\x{FCAB}", %p)},	undef,	"to_ascii\(\'\?ς．\-\≮\\uFCAB\'\)\ throws\ error\ B1\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3383\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𼎏ς．-<\x{0338}\x{FCAB}", %p)},	undef,	"to_ascii\(\'\?ς．\-\<\\u0338\\uFCAB\'\)\ throws\ error\ B1\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3385\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𼎏ς.-≮\x{062E}\x{062C}", %p)},	undef,	"to_ascii\(\'\?ς\.\-\≮\\u062E\\u062C\'\)\ throws\ error\ B1\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3387\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𼎏ς.-<\x{0338}\x{062E}\x{062C}", %p)},	undef,	"to_ascii\(\'\?ς\.\-\<\\u0338\\u062E\\u062C\'\)\ throws\ error\ B1\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3389\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𼎏Σ.-<\x{0338}\x{062E}\x{062C}", %p)},	undef,	"to_ascii\(\'\?Σ\.\-\<\\u0338\\u062E\\u062C\'\)\ throws\ error\ B1\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3391\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𼎏Σ.-≮\x{062E}\x{062C}", %p)},	undef,	"to_ascii\(\'\?Σ\.\-\≮\\u062E\\u062C\'\)\ throws\ error\ B1\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3392\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𼎏σ.-≮\x{062E}\x{062C}", %p)},	undef,	"to_ascii\(\'\?σ\.\-\≮\\u062E\\u062C\'\)\ throws\ error\ B1\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3393\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𼎏σ.-<\x{0338}\x{062E}\x{062C}", %p)},	undef,	"to_ascii\(\'\?σ\.\-\<\\u0338\\u062E\\u062C\'\)\ throws\ error\ B1\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3394\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--4xa92520c.xn----9mcf1400a", %p)},	undef,	"to_ascii\(\'xn\-\-4xa92520c\.xn\-\-\-\-9mcf1400a\'\)\ throws\ error\ B1\ V3\ V6\ \[data\/IdnaTest\.txt\:3395\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--3xa13520c.xn----9mcf1400a", %p)},	undef,	"to_ascii\(\'xn\-\-3xa13520c\.xn\-\-\-\-9mcf1400a\'\)\ throws\ error\ B1\ V3\ V6\ \[data\/IdnaTest\.txt\:3396\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𼎏Σ．-<\x{0338}\x{FCAB}", %p)},	undef,	"to_ascii\(\'\?Σ．\-\<\\u0338\\uFCAB\'\)\ throws\ error\ B1\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3397\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𼎏Σ．-≮\x{FCAB}", %p)},	undef,	"to_ascii\(\'\?Σ．\-\≮\\uFCAB\'\)\ throws\ error\ B1\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3398\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𼎏σ．-≮\x{FCAB}", %p)},	undef,	"to_ascii\(\'\?σ．\-\≮\\uFCAB\'\)\ throws\ error\ B1\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3399\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𼎏σ．-<\x{0338}\x{FCAB}", %p)},	undef,	"to_ascii\(\'\?σ．\-\<\\u0338\\uFCAB\'\)\ throws\ error\ B1\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3400\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ꡗ\x{08B8}\x{0719}．񔤔󠛙\x{0C4D}\x{FC3E}", %p)},	undef,	"to_ascii\(\'ꡗ\\u08B8\\u0719．\?\?\\u0C4D\\uFC3E\'\)\ throws\ error\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:3401\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ꡗ\x{08B8}\x{0719}.񔤔󠛙\x{0C4D}\x{0643}\x{064A}", %p)},	undef,	"to_ascii\(\'ꡗ\\u08B8\\u0719\.\?\?\\u0C4D\\u0643\\u064A\'\)\ throws\ error\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:3402\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--jnb34fs003a.xn--fhbo927bk128mpi24d", %p)},	undef,	"to_ascii\(\'xn\-\-jnb34fs003a\.xn\-\-fhbo927bk128mpi24d\'\)\ throws\ error\ B5\ B6\ V6\ \[data\/IdnaTest\.txt\:3403\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("𐠰\x{08B7}𞤌𐫭。𐋦\x{17CD}𝩃", %p)},	undef,	"to_ascii\(\'𐠰\\u08B7𞤌𐫭\。𐋦\\u17CD𝩃\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:3404\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("𐠰\x{08B7}𞤮𐫭。𐋦\x{17CD}𝩃", %p)},	undef,	"to_ascii\(\'𐠰\\u08B7𞤮𐫭\。𐋦\\u17CD𝩃\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:3405\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--dzb5191kezbrw47a.xn--p4e3841jz9tf", %p)},	undef,	"to_ascii\(\'xn\-\-dzb5191kezbrw47a\.xn\-\-p4e3841jz9tf\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:3406\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("𐠰\x{08B7}𞤮𐫭.𐋦\x{17CD}𝩃", %p)},	undef,	"to_ascii\(\'𐠰\\u08B7𞤮𐫭\.𐋦\\u17CD𝩃\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:3407\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("𐠰\x{08B7}𞤌𐫭.𐋦\x{17CD}𝩃", %p)},	undef,	"to_ascii\(\'𐠰\\u08B7𞤌𐫭\.𐋦\\u17CD𝩃\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:3408\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("₂㘷--。\x{06D3}\x{200C}𐫆𑖿", %p)},	undef,	"to_ascii\(\'₂㘷\-\-\。\\u06D3\\u200C𐫆𑖿\'\)\ throws\ error\ B1\ V2\ V3\ \[data\/IdnaTest\.txt\:3409\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("₂㘷--。\x{06D2}\x{0654}\x{200C}𐫆𑖿", %p)},	undef,	"to_ascii\(\'₂㘷\-\-\。\\u06D2\\u0654\\u200C𐫆𑖿\'\)\ throws\ error\ B1\ V2\ V3\ \[data\/IdnaTest\.txt\:3411\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("2㘷--。\x{06D3}\x{200C}𐫆𑖿", %p)},	undef,	"to_ascii\(\'2㘷\-\-\。\\u06D3\\u200C𐫆𑖿\'\)\ throws\ error\ B1\ V2\ V3\ \[data\/IdnaTest\.txt\:3413\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("2㘷--。\x{06D2}\x{0654}\x{200C}𐫆𑖿", %p)},	undef,	"to_ascii\(\'2㘷\-\-\。\\u06D2\\u0654\\u200C𐫆𑖿\'\)\ throws\ error\ B1\ V2\ V3\ \[data\/IdnaTest\.txt\:3415\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--2---u58b.xn--jlb8024k14g", %p)},	undef,	"to_ascii\(\'xn\-\-2\-\-\-u58b\.xn\-\-jlb8024k14g\'\)\ throws\ error\ B1\ V2\ V3\ \[data\/IdnaTest\.txt\:3417\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--2---u58b.xn--jlb820ku99nbgj", %p)},	undef,	"to_ascii\(\'xn\-\-2\-\-\-u58b\.xn\-\-jlb820ku99nbgj\'\)\ throws\ error\ B1\ C1\ V2\ V3\ \[data\/IdnaTest\.txt\:3418\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("-𘊻．ᡮ\x{062D}-", %p)},	undef,	"to_ascii\(\'\-𘊻．ᡮ\\u062D\-\'\)\ throws\ error\ B1\ B5\ B6\ V3\ \[data\/IdnaTest\.txt\:3419\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("-𘊻.ᡮ\x{062D}-", %p)},	undef,	"to_ascii\(\'\-𘊻\.ᡮ\\u062D\-\'\)\ throws\ error\ B1\ B5\ B6\ V3\ \[data\/IdnaTest\.txt\:3420\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn----bp5n.xn----bnc231l", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-bp5n\.xn\-\-\-\-bnc231l\'\)\ throws\ error\ B1\ B5\ B6\ V3\ \[data\/IdnaTest\.txt\:3421\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("\x{200C}-ß｡ᢣ𐹭\x{063F}", %p)},	undef,	"to_ascii\(\'\\u200C\-ß｡ᢣ𐹭\\u063F\'\)\ throws\ error\ B1\ B5\ B6\ V3\ \[data\/IdnaTest\.txt\:3422\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("\x{200C}-ß。ᢣ𐹭\x{063F}", %p)},	undef,	"to_ascii\(\'\\u200C\-ß\。ᢣ𐹭\\u063F\'\)\ throws\ error\ B1\ B5\ B6\ V3\ \[data\/IdnaTest\.txt\:3424\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("\x{200C}-SS。ᢣ𐹭\x{063F}", %p)},	undef,	"to_ascii\(\'\\u200C\-SS\。ᢣ𐹭\\u063F\'\)\ throws\ error\ B1\ B5\ B6\ V3\ \[data\/IdnaTest\.txt\:3426\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("\x{200C}-ss。ᢣ𐹭\x{063F}", %p)},	undef,	"to_ascii\(\'\\u200C\-ss\。ᢣ𐹭\\u063F\'\)\ throws\ error\ B1\ B5\ B6\ V3\ \[data\/IdnaTest\.txt\:3428\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("\x{200C}-Ss。ᢣ𐹭\x{063F}", %p)},	undef,	"to_ascii\(\'\\u200C\-Ss\。ᢣ𐹭\\u063F\'\)\ throws\ error\ B1\ B5\ B6\ V3\ \[data\/IdnaTest\.txt\:3430\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("-ss.xn--bhb925glx3p", %p)},	undef,	"to_ascii\(\'\-ss\.xn\-\-bhb925glx3p\'\)\ throws\ error\ B1\ B5\ B6\ V3\ \[data\/IdnaTest\.txt\:3432\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn---ss-8m0a.xn--bhb925glx3p", %p)},	undef,	"to_ascii\(\'xn\-\-\-ss\-8m0a\.xn\-\-bhb925glx3p\'\)\ throws\ error\ B1\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:3433\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----qfa550v.xn--bhb925glx3p", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-qfa550v\.xn\-\-bhb925glx3p\'\)\ throws\ error\ B1\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:3434\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("\x{200C}-SS｡ᢣ𐹭\x{063F}", %p)},	undef,	"to_ascii\(\'\\u200C\-SS｡ᢣ𐹭\\u063F\'\)\ throws\ error\ B1\ B5\ B6\ V3\ \[data\/IdnaTest\.txt\:3435\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("\x{200C}-ss｡ᢣ𐹭\x{063F}", %p)},	undef,	"to_ascii\(\'\\u200C\-ss｡ᢣ𐹭\\u063F\'\)\ throws\ error\ B1\ B5\ B6\ V3\ \[data\/IdnaTest\.txt\:3437\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("\x{200C}-Ss｡ᢣ𐹭\x{063F}", %p)},	undef,	"to_ascii\(\'\\u200C\-Ss｡ᢣ𐹭\\u063F\'\)\ throws\ error\ B1\ B5\ B6\ V3\ \[data\/IdnaTest\.txt\:3439\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("꧐Ӏ\x{1BAA}\x{08F6}．눵", %p)},	undef,	"to_ascii\(\'꧐Ӏ\\u1BAA\\u08F6．눵\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3441\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("꧐Ӏ\x{1BAA}\x{08F6}．눵", %p)},	undef,	"to_ascii\(\'꧐Ӏ\\u1BAA\\u08F6．눵\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3442\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("꧐Ӏ\x{1BAA}\x{08F6}.눵", %p)},	undef,	"to_ascii\(\'꧐Ӏ\\u1BAA\\u08F6\.눵\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3443\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("꧐Ӏ\x{1BAA}\x{08F6}.눵", %p)},	undef,	"to_ascii\(\'꧐Ӏ\\u1BAA\\u08F6\.눵\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3444\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_ascii("꧐ӏ\x{1BAA}\x{08F6}.눵", %p)},	"xn--s5a04sn4u297k.xn--2e1b",	"to_ascii\(\'꧐ӏ\\u1BAA\\u08F6\.눵\'\)\ \[data\/IdnaTest\.txt\:3445\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_ascii("꧐ӏ\x{1BAA}\x{08F6}.눵", %p)},	"xn--s5a04sn4u297k.xn--2e1b",	"to_ascii\(\'꧐ӏ\\u1BAA\\u08F6\.눵\'\)\ \[data\/IdnaTest\.txt\:3446\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_ascii("xn--s5a04sn4u297k.xn--2e1b", %p)},	"xn--s5a04sn4u297k.xn--2e1b",	"to_ascii\(\'xn\-\-s5a04sn4u297k\.xn\-\-2e1b\'\)\ \[data\/IdnaTest\.txt\:3447\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--d5a07sn4u297k.xn--2e1b", %p)},	undef,	"to_ascii\(\'xn\-\-d5a07sn4u297k\.xn\-\-2e1b\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:3448\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_ascii("꧐ӏ\x{1BAA}\x{08F6}．눵", %p)},	"xn--s5a04sn4u297k.xn--2e1b",	"to_ascii\(\'꧐ӏ\\u1BAA\\u08F6．눵\'\)\ \[data\/IdnaTest\.txt\:3449\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_ascii("꧐ӏ\x{1BAA}\x{08F6}．눵", %p)},	"xn--s5a04sn4u297k.xn--2e1b",	"to_ascii\(\'꧐ӏ\\u1BAA\\u08F6．눵\'\)\ \[data\/IdnaTest\.txt\:3450\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("\x{A8EA}｡𖄿𑆾󠇗", %p)},	undef,	"to_ascii\(\'\\uA8EA｡\?𑆾\󠇗\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3451\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{A8EA}。𖄿𑆾󠇗", %p)},	undef,	"to_ascii\(\'\\uA8EA\。\?𑆾\󠇗\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3452\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--3g9a.xn--ud1dz07k", %p)},	undef,	"to_ascii\(\'xn\-\-3g9a\.xn\-\-ud1dz07k\'\)\ throws\ error\ V5\ V6\ \[data\/IdnaTest\.txt\:3453\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󇓓𑚳。񐷿≯⾇", %p)},	undef,	"to_ascii\(\'\?𑚳\。\?\≯⾇\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3454\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󇓓𑚳。񐷿>\x{0338}⾇", %p)},	undef,	"to_ascii\(\'\?𑚳\。\?\>\\u0338⾇\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3455\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󇓓𑚳。񐷿≯舛", %p)},	undef,	"to_ascii\(\'\?𑚳\。\?\≯舛\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3456\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󇓓𑚳。񐷿>\x{0338}舛", %p)},	undef,	"to_ascii\(\'\?𑚳\。\?\>\\u0338舛\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3457\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--3e2d79770c.xn--hdh0088abyy1c", %p)},	undef,	"to_ascii\(\'xn\-\-3e2d79770c\.xn\-\-hdh0088abyy1c\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:3458\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("𐫇\x{0661}\x{200C}．\x{200D}\x{200C}", %p)},	"xn--9hb7344k.",	"to_ascii\(\'𐫇\\u0661\\u200C．\\u200D\\u200C\'\)\ \[data\/IdnaTest\.txt\:3459\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("𐫇\x{0661}\x{200C}.\x{200D}\x{200C}", %p)},	"xn--9hb7344k.",	"to_ascii\(\'𐫇\\u0661\\u200C\.\\u200D\\u200C\'\)\ \[data\/IdnaTest\.txt\:3461\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("xn--9hb7344k.", %p)},	"xn--9hb7344k.",	"to_ascii\(\'xn\-\-9hb7344k\.\'\)\ \[data\/IdnaTest\.txt\:3463\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("𐫇\x{0661}.", %p)},	"xn--9hb7344k.",	"to_ascii\(\'𐫇\\u0661\.\'\)\ \[data\/IdnaTest\.txt\:3464\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--9hb652kv99n.xn--0ugb", %p)},	undef,	"to_ascii\(\'xn\-\-9hb652kv99n\.xn\-\-0ugb\'\)\ throws\ error\ B1\ B3\ C1\ C2\ \[data\/IdnaTest\.txt\:3465\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񡅈砪≯ᢑ｡≯𝩚򓴔\x{200C}", %p)},	undef,	"to_ascii\(\'\?砪\≯ᢑ｡\≯𝩚\?\\u200C\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3466\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񡅈砪>\x{0338}ᢑ｡>\x{0338}𝩚򓴔\x{200C}", %p)},	undef,	"to_ascii\(\'\?砪\>\\u0338ᢑ｡\>\\u0338𝩚\?\\u200C\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3468\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񡅈砪≯ᢑ。≯𝩚򓴔\x{200C}", %p)},	undef,	"to_ascii\(\'\?砪\≯ᢑ\。\≯𝩚\?\\u200C\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3470\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񡅈砪>\x{0338}ᢑ。>\x{0338}𝩚򓴔\x{200C}", %p)},	undef,	"to_ascii\(\'\?砪\>\\u0338ᢑ\。\>\\u0338𝩚\?\\u200C\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3472\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--bbf561cf95e57y3e.xn--hdh0834o7mj6b", %p)},	undef,	"to_ascii\(\'xn\-\-bbf561cf95e57y3e\.xn\-\-hdh0834o7mj6b\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:3474\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--bbf561cf95e57y3e.xn--0ugz6gc910ejro8c", %p)},	undef,	"to_ascii\(\'xn\-\-bbf561cf95e57y3e\.xn\-\-0ugz6gc910ejro8c\'\)\ throws\ error\ C1\ V6\ \[data\/IdnaTest\.txt\:3475\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴥ.𑄳㊸", %p)},	undef,	"to_ascii\(\'Ⴥ\.𑄳㊸\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3476\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴥ.𑄳43", %p)},	undef,	"to_ascii\(\'Ⴥ\.𑄳43\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3477\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_ascii("ⴥ.𑄳43", %p)},	undef,	"to_ascii\(\'ⴥ\.𑄳43\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:3478\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--tlj.xn--43-274o", %p)},	undef,	"to_ascii\(\'xn\-\-tlj\.xn\-\-43\-274o\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:3479\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--9nd.xn--43-274o", %p)},	undef,	"to_ascii\(\'xn\-\-9nd\.xn\-\-43\-274o\'\)\ throws\ error\ V5\ V6\ \[data\/IdnaTest\.txt\:3480\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_ascii("ⴥ.𑄳㊸", %p)},	undef,	"to_ascii\(\'ⴥ\.𑄳㊸\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:3481\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("𝟎\x{0663}。Ⴒᡇ\x{08F2}𐹠", %p)},	undef,	"to_ascii\(\'𝟎\\u0663\。Ⴒᡇ\\u08F2𐹠\'\)\ throws\ error\ B1\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:3482\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("0\x{0663}。Ⴒᡇ\x{08F2}𐹠", %p)},	undef,	"to_ascii\(\'0\\u0663\。Ⴒᡇ\\u08F2𐹠\'\)\ throws\ error\ B1\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:3483\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_ascii("0\x{0663}。ⴒᡇ\x{08F2}𐹠", %p)},	undef,	"to_ascii\(\'0\\u0663\。ⴒᡇ\\u08F2𐹠\'\)\ throws\ error\ B1\ B5\ B6\ \[data\/IdnaTest\.txt\:3484\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--0-fqc.xn--10b369eivp359r", %p)},	undef,	"to_ascii\(\'xn\-\-0\-fqc\.xn\-\-10b369eivp359r\'\)\ throws\ error\ B1\ B5\ B6\ \[data\/IdnaTest\.txt\:3485\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--0-fqc.xn--10b180bnwgfy0z", %p)},	undef,	"to_ascii\(\'xn\-\-0\-fqc\.xn\-\-10b180bnwgfy0z\'\)\ throws\ error\ B1\ B5\ B6\ V6\ \[data\/IdnaTest\.txt\:3486\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_ascii("𝟎\x{0663}。ⴒᡇ\x{08F2}𐹠", %p)},	undef,	"to_ascii\(\'𝟎\\u0663\。ⴒᡇ\\u08F2𐹠\'\)\ throws\ error\ B1\ B5\ B6\ \[data\/IdnaTest\.txt\:3487\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("񗪨󠄉\x{FFA0}\x{0FB7}.񸞰\x{A953}", %p)},	undef,	"to_ascii\(\'\?\󠄉\\uFFA0\\u0FB7\.\?\\uA953\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3488\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񗪨󠄉\x{1160}\x{0FB7}.񸞰\x{A953}", %p)},	undef,	"to_ascii\(\'\?\󠄉\\u1160\\u0FB7\.\?\\uA953\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3489\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--kgd36f9z57y.xn--3j9au7544a", %p)},	undef,	"to_ascii\(\'xn\-\-kgd36f9z57y\.xn\-\-3j9au7544a\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:3490\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--kgd7493jee34a.xn--3j9au7544a", %p)},	undef,	"to_ascii\(\'xn\-\-kgd7493jee34a\.xn\-\-3j9au7544a\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:3491\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_ascii("\x{0618}.۳\x{200C}\x{A953}", %p)},	undef,	"to_ascii\(\'\\u0618\.۳\\u200C\\uA953\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:3492\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--6fb.xn--gmb0524f", %p)},	undef,	"to_ascii\(\'xn\-\-6fb\.xn\-\-gmb0524f\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:3494\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--6fb.xn--gmb469jjf1h", %p)},	undef,	"to_ascii\(\'xn\-\-6fb\.xn\-\-gmb469jjf1h\'\)\ throws\ error\ C1\ V5\ \[data\/IdnaTest\.txt\:3495\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᡌ．︒ᢑ", %p)},	undef,	"to_ascii\(\'ᡌ．︒ᢑ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3496\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᡌ.。ᢑ", %p)},	undef,	"to_ascii\(\'ᡌ\.\。ᢑ\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:3497\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--c8e..xn--bbf", %p)},	undef,	"to_ascii\(\'xn\-\-c8e\.\.xn\-\-bbf\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:3498\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--c8e.xn--bbf9168i", %p)},	undef,	"to_ascii\(\'xn\-\-c8e\.xn\-\-bbf9168i\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:3499\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𑋪\x{1073}｡𞽧", %p)},	undef,	"to_ascii\(\'𑋪\\u1073｡\?\'\)\ throws\ error\ B1\ B3\ B6\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3500\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𑋪\x{1073}。𞽧", %p)},	undef,	"to_ascii\(\'𑋪\\u1073\。\?\'\)\ throws\ error\ B1\ B3\ B6\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3501\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--xld7443k.xn--4o7h", %p)},	undef,	"to_ascii\(\'xn\-\-xld7443k\.xn\-\-4o7h\'\)\ throws\ error\ B1\ B3\ B6\ V5\ V6\ \[data\/IdnaTest\.txt\:3502\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𞷏。ᠢ򓘆", %p)},	undef,	"to_ascii\(\'\?\。ᠢ\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3503\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--hd7h.xn--46e66060j", %p)},	undef,	"to_ascii\(\'xn\-\-hd7h\.xn\-\-46e66060j\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:3504\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𑄳㴼．\x{200C}𐹡\x{20EB}񫺦", %p)},	undef,	"to_ascii\(\'𑄳㴼．\\u200C𐹡\\u20EB\?\'\)\ throws\ error\ B1\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3505\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𑄳㴼.\x{200C}𐹡\x{20EB}񫺦", %p)},	undef,	"to_ascii\(\'𑄳㴼\.\\u200C𐹡\\u20EB\?\'\)\ throws\ error\ B1\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3507\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--iym9428c.xn--e1g3464g08p3b", %p)},	undef,	"to_ascii\(\'xn\-\-iym9428c\.xn\-\-e1g3464g08p3b\'\)\ throws\ error\ B1\ V5\ V6\ \[data\/IdnaTest\.txt\:3509\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--iym9428c.xn--0ug46a7218cllv0c", %p)},	undef,	"to_ascii\(\'xn\-\-iym9428c\.xn\-\-0ug46a7218cllv0c\'\)\ throws\ error\ B1\ C1\ V5\ V6\ \[data\/IdnaTest\.txt\:3510\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񠻟𐹳𑈯｡\x{031D}", %p)},	undef,	"to_ascii\(\'\?𐹳𑈯｡\\u031D\'\)\ throws\ error\ B1\ B3\ B5\ B6\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3511\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񠻟𐹳𑈯。\x{031D}", %p)},	undef,	"to_ascii\(\'\?𐹳𑈯\。\\u031D\'\)\ throws\ error\ B1\ B3\ B5\ B6\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3512\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--ro0dw7dey96m.xn--eta", %p)},	undef,	"to_ascii\(\'xn\-\-ro0dw7dey96m\.xn\-\-eta\'\)\ throws\ error\ B1\ B3\ B5\ B6\ V5\ V6\ \[data\/IdnaTest\.txt\:3513\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᢊ뾜󠱴𑚶。\x{089D}𐹥", %p)},	undef,	"to_ascii\(\'ᢊ뾜\?𑚶\。\\u089D𐹥\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3514\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᢊ뾜󠱴𑚶。\x{089D}𐹥", %p)},	undef,	"to_ascii\(\'ᢊ뾜\?𑚶\。\\u089D𐹥\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3515\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--39e4566fjv8bwmt6n.xn--myb6415k", %p)},	undef,	"to_ascii\(\'xn\-\-39e4566fjv8bwmt6n\.xn\-\-myb6415k\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:3516\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐹥≠｡𐋲󠧠\x{200C}", %p)},	undef,	"to_ascii\(\'𐹥\≠｡𐋲\?\\u200C\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:3517\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐹥=\x{0338}｡𐋲󠧠\x{200C}", %p)},	undef,	"to_ascii\(\'𐹥\=\\u0338｡𐋲\?\\u200C\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:3519\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐹥≠。𐋲󠧠\x{200C}", %p)},	undef,	"to_ascii\(\'𐹥\≠\。𐋲\?\\u200C\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:3521\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐹥=\x{0338}。𐋲󠧠\x{200C}", %p)},	undef,	"to_ascii\(\'𐹥\=\\u0338\。𐋲\?\\u200C\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:3523\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--1ch6704g.xn--m97cw2999c", %p)},	undef,	"to_ascii\(\'xn\-\-1ch6704g\.xn\-\-m97cw2999c\'\)\ throws\ error\ B1\ V6\ \[data\/IdnaTest\.txt\:3525\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--1ch6704g.xn--0ug3840g51u4g", %p)},	undef,	"to_ascii\(\'xn\-\-1ch6704g\.xn\-\-0ug3840g51u4g\'\)\ throws\ error\ B1\ C1\ V6\ \[data\/IdnaTest\.txt\:3526\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{115F}񙯠\x{094D}．\x{200D}\x{A953}𐪤", %p)},	undef,	"to_ascii\(\'\\u115F\?\\u094D．\\u200D\\uA953\?\'\)\ throws\ error\ B5\ B6\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3527\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{115F}񙯠\x{094D}.\x{200D}\x{A953}𐪤", %p)},	undef,	"to_ascii\(\'\\u115F\?\\u094D\.\\u200D\\uA953\?\'\)\ throws\ error\ B5\ B6\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3529\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--n3b542bb085j.xn--3j9al95p", %p)},	undef,	"to_ascii\(\'xn\-\-n3b542bb085j\.xn\-\-3j9al95p\'\)\ throws\ error\ B5\ B6\ V5\ V6\ \[data\/IdnaTest\.txt\:3531\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--n3b542bb085j.xn--1ug6815co9wc", %p)},	undef,	"to_ascii\(\'xn\-\-n3b542bb085j\.xn\-\-1ug6815co9wc\'\)\ throws\ error\ B1\ C2\ V6\ \[data\/IdnaTest\.txt\:3532\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򌋔󠆎󠆗𑲕。≮", %p)},	undef,	"to_ascii\(\'\?\󠆎\󠆗𑲕\。\≮\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3533\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򌋔󠆎󠆗𑲕。<\x{0338}", %p)},	undef,	"to_ascii\(\'\?\󠆎\󠆗𑲕\。\<\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3534\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--4m3dv4354a.xn--gdh", %p)},	undef,	"to_ascii\(\'xn\-\-4m3dv4354a\.xn\-\-gdh\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:3535\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠆦.\x{08E3}暀≠", %p)},	undef,	"to_ascii\(\'\󠆦\.\\u08E3暀\≠\'\)\ throws\ error\ P1\ V5\ V6\ A4_2\ \[data\/IdnaTest\.txt\:3536\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠆦.\x{08E3}暀=\x{0338}", %p)},	undef,	"to_ascii\(\'\󠆦\.\\u08E3暀\=\\u0338\'\)\ throws\ error\ P1\ V5\ V6\ A4_2\ \[data\/IdnaTest\.txt\:3537\]") or ($@ and diag($@));
is(eval{uts46_to_ascii(".xn--m0b461k3g2c", %p)},	undef,	"to_ascii\(\'\.xn\-\-m0b461k3g2c\'\)\ throws\ error\ V5\ V6\ A4_2\ \[data\/IdnaTest\.txt\:3538\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐡤\x{ABED}｡\x{FD30}򜖅\x{1DF0}", %p)},	undef,	"to_ascii\(\'𐡤\\uABED｡\\uFD30\?\\u1DF0\'\)\ throws\ error\ B2\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:3539\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐡤\x{ABED}。\x{0634}\x{0645}򜖅\x{1DF0}", %p)},	undef,	"to_ascii\(\'𐡤\\uABED\。\\u0634\\u0645\?\\u1DF0\'\)\ throws\ error\ B2\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:3540\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--429ak76o.xn--zgb8a701kox37t", %p)},	undef,	"to_ascii\(\'xn\-\-429ak76o\.xn\-\-zgb8a701kox37t\'\)\ throws\ error\ B2\ B3\ V6\ \[data\/IdnaTest\.txt\:3541\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𝉃\x{200D}⒈｡Ⴌ𞱓", %p)},	undef,	"to_ascii\(\'𝉃\\u200D⒈｡Ⴌ\?\'\)\ throws\ error\ B1\ B5\ B6\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3542\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𝉃\x{200D}1.。Ⴌ𞱓", %p)},	undef,	"to_ascii\(\'𝉃\\u200D1\.\。Ⴌ\?\'\)\ throws\ error\ B1\ B5\ B6\ P1\ V5\ V6\ A4_2\ \[data\/IdnaTest\.txt\:3544\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𝉃\x{200D}1.。ⴌ𞱓", %p)},	undef,	"to_ascii\(\'𝉃\\u200D1\.\。ⴌ\?\'\)\ throws\ error\ B1\ B5\ B6\ P1\ V5\ V6\ A4_2\ \[data\/IdnaTest\.txt\:3546\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--1-px8q..xn--3kj4524l", %p)},	undef,	"to_ascii\(\'xn\-\-1\-px8q\.\.xn\-\-3kj4524l\'\)\ throws\ error\ B1\ B5\ B6\ V5\ V6\ A4_2\ \[data\/IdnaTest\.txt\:3548\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--1-tgn9827q..xn--3kj4524l", %p)},	undef,	"to_ascii\(\'xn\-\-1\-tgn9827q\.\.xn\-\-3kj4524l\'\)\ throws\ error\ B1\ B5\ B6\ C2\ V5\ V6\ A4_2\ \[data\/IdnaTest\.txt\:3549\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--1-px8q..xn--knd8464v", %p)},	undef,	"to_ascii\(\'xn\-\-1\-px8q\.\.xn\-\-knd8464v\'\)\ throws\ error\ B1\ B5\ B6\ V5\ V6\ A4_2\ \[data\/IdnaTest\.txt\:3550\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--1-tgn9827q..xn--knd8464v", %p)},	undef,	"to_ascii\(\'xn\-\-1\-tgn9827q\.\.xn\-\-knd8464v\'\)\ throws\ error\ B1\ B5\ B6\ C2\ V5\ V6\ A4_2\ \[data\/IdnaTest\.txt\:3551\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𝉃\x{200D}⒈｡ⴌ𞱓", %p)},	undef,	"to_ascii\(\'𝉃\\u200D⒈｡ⴌ\?\'\)\ throws\ error\ B1\ B5\ B6\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3552\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--tshz828m.xn--3kj4524l", %p)},	undef,	"to_ascii\(\'xn\-\-tshz828m\.xn\-\-3kj4524l\'\)\ throws\ error\ B1\ B5\ B6\ V5\ V6\ \[data\/IdnaTest\.txt\:3554\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--1ug68oq348b.xn--3kj4524l", %p)},	undef,	"to_ascii\(\'xn\-\-1ug68oq348b\.xn\-\-3kj4524l\'\)\ throws\ error\ B1\ B5\ B6\ C2\ V5\ V6\ \[data\/IdnaTest\.txt\:3555\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--tshz828m.xn--knd8464v", %p)},	undef,	"to_ascii\(\'xn\-\-tshz828m\.xn\-\-knd8464v\'\)\ throws\ error\ B1\ B5\ B6\ V5\ V6\ \[data\/IdnaTest\.txt\:3556\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--1ug68oq348b.xn--knd8464v", %p)},	undef,	"to_ascii\(\'xn\-\-1ug68oq348b\.xn\-\-knd8464v\'\)\ throws\ error\ B1\ B5\ B6\ C2\ V5\ V6\ \[data\/IdnaTest\.txt\:3557\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠣙\x{0A4D}𱫘𞤸.ς񵯞􈰔", %p)},	undef,	"to_ascii\(\'\?\\u0A4D𱫘𞤸\.ς\?\?\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:3558\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠣙\x{0A4D}𱫘𞤖.Σ񵯞􈰔", %p)},	undef,	"to_ascii\(\'\?\\u0A4D𱫘𞤖\.Σ\?\?\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:3560\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠣙\x{0A4D}𱫘𞤸.σ񵯞􈰔", %p)},	undef,	"to_ascii\(\'\?\\u0A4D𱫘𞤸\.σ\?\?\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:3561\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠣙\x{0A4D}𱫘𞤖.σ񵯞􈰔", %p)},	undef,	"to_ascii\(\'\?\\u0A4D𱫘𞤖\.σ\?\?\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:3562\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--ybc0236vjvxgt5q0g.xn--4xa82737giye6b", %p)},	undef,	"to_ascii\(\'xn\-\-ybc0236vjvxgt5q0g\.xn\-\-4xa82737giye6b\'\)\ throws\ error\ B1\ V6\ \[data\/IdnaTest\.txt\:3563\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠣙\x{0A4D}𱫘𞤖.ς񵯞􈰔", %p)},	undef,	"to_ascii\(\'\?\\u0A4D𱫘𞤖\.ς\?\?\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:3564\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--ybc0236vjvxgt5q0g.xn--3xa03737giye6b", %p)},	undef,	"to_ascii\(\'xn\-\-ybc0236vjvxgt5q0g\.xn\-\-3xa03737giye6b\'\)\ throws\ error\ B1\ V6\ \[data\/IdnaTest\.txt\:3566\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠣙\x{0A4D}𱫘𞤸.Σ񵯞􈰔", %p)},	undef,	"to_ascii\(\'\?\\u0A4D𱫘𞤸\.Σ\?\?\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:3567\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{07D3}。\x{200C}𐫀򞭱", %p)},	undef,	"to_ascii\(\'\\u07D3\。\\u200C𐫀\?\'\)\ throws\ error\ B2\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:3568\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--usb.xn--pw9ci1099a", %p)},	undef,	"to_ascii\(\'xn\-\-usb\.xn\-\-pw9ci1099a\'\)\ throws\ error\ B2\ B3\ V6\ \[data\/IdnaTest\.txt\:3570\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--usb.xn--0ug9553gm3v5d", %p)},	undef,	"to_ascii\(\'xn\-\-usb\.xn\-\-0ug9553gm3v5d\'\)\ throws\ error\ B1\ C1\ V6\ \[data\/IdnaTest\.txt\:3571\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("\x{1C2E}𞀝.\x{05A6}ꡟ𞤕󠆖", %p)},	undef,	"to_ascii\(\'\\u1C2E𞀝\.\\u05A6ꡟ𞤕\󠆖\'\)\ throws\ error\ B1\ B3\ B6\ V5\ \[data\/IdnaTest\.txt\:3572\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("\x{1C2E}𞀝.\x{05A6}ꡟ𞤷󠆖", %p)},	undef,	"to_ascii\(\'\\u1C2E𞀝\.\\u05A6ꡟ𞤷\󠆖\'\)\ throws\ error\ B1\ B3\ B6\ V5\ \[data\/IdnaTest\.txt\:3573\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--q1f4493q.xn--xcb8244fifvj", %p)},	undef,	"to_ascii\(\'xn\-\-q1f4493q\.xn\-\-xcb8244fifvj\'\)\ throws\ error\ B1\ B3\ B6\ V5\ \[data\/IdnaTest\.txt\:3574\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("䂹󾖅𐋦．\x{200D}", %p)},	undef,	"to_ascii\(\'䂹\?𐋦．\\u200D\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3575\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("䂹󾖅𐋦.\x{200D}", %p)},	undef,	"to_ascii\(\'䂹\?𐋦\.\\u200D\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3577\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--0on3543c5981i.", %p)},	undef,	"to_ascii\(\'xn\-\-0on3543c5981i\.\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:3579\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--0on3543c5981i.xn--1ug", %p)},	undef,	"to_ascii\(\'xn\-\-0on3543c5981i\.xn\-\-1ug\'\)\ throws\ error\ C2\ V6\ \[data\/IdnaTest\.txt\:3580\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{A9C0}\x{200C}𐹲\x{200C}｡\x{0767}🄉", %p)},	undef,	"to_ascii\(\'\\uA9C0\\u200C𐹲\\u200C｡\\u0767🄉\'\)\ throws\ error\ B5\ B6\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3581\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{A9C0}\x{200C}𐹲\x{200C}。\x{0767}8,", %p)},	undef,	"to_ascii\(\'\\uA9C0\\u200C𐹲\\u200C\。\\u07678\,\'\)\ throws\ error\ B3\ B5\ B6\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3583\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--7m9an32q.xn--8,-qle", %p)},	undef,	"to_ascii\(\'xn\-\-7m9an32q\.xn\-\-8\,\-qle\'\)\ throws\ error\ B3\ B5\ B6\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3585\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--0uga8686hdgvd.xn--8,-qle", %p)},	undef,	"to_ascii\(\'xn\-\-0uga8686hdgvd\.xn\-\-8\,\-qle\'\)\ throws\ error\ B3\ B5\ B6\ C1\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3586\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--7m9an32q.xn--rpb6081w", %p)},	undef,	"to_ascii\(\'xn\-\-7m9an32q\.xn\-\-rpb6081w\'\)\ throws\ error\ B5\ B6\ V5\ V6\ \[data\/IdnaTest\.txt\:3587\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--0uga8686hdgvd.xn--rpb6081w", %p)},	undef,	"to_ascii\(\'xn\-\-0uga8686hdgvd\.xn\-\-rpb6081w\'\)\ throws\ error\ B5\ B6\ C1\ V5\ V6\ \[data\/IdnaTest\.txt\:3588\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("︒｡Ⴃ≯", %p)},	undef,	"to_ascii\(\'︒｡Ⴃ\≯\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3589\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("︒｡Ⴃ>\x{0338}", %p)},	undef,	"to_ascii\(\'︒｡Ⴃ\>\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3590\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("。。Ⴃ≯", %p)},	undef,	"to_ascii\(\'\。\。Ⴃ\≯\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:3591\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("。。Ⴃ>\x{0338}", %p)},	undef,	"to_ascii\(\'\。\。Ⴃ\>\\u0338\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:3592\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("。。ⴃ>\x{0338}", %p)},	undef,	"to_ascii\(\'\。\。ⴃ\>\\u0338\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:3593\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("。。ⴃ≯", %p)},	undef,	"to_ascii\(\'\。\。ⴃ\≯\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:3594\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("..xn--hdh782b", %p)},	undef,	"to_ascii\(\'\.\.xn\-\-hdh782b\'\)\ throws\ error\ V6\ A4_2\ \[data\/IdnaTest\.txt\:3595\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("..xn--bnd622g", %p)},	undef,	"to_ascii\(\'\.\.xn\-\-bnd622g\'\)\ throws\ error\ V6\ A4_2\ \[data\/IdnaTest\.txt\:3596\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("︒｡ⴃ>\x{0338}", %p)},	undef,	"to_ascii\(\'︒｡ⴃ\>\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3597\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("︒｡ⴃ≯", %p)},	undef,	"to_ascii\(\'︒｡ⴃ\≯\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3598\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--y86c.xn--hdh782b", %p)},	undef,	"to_ascii\(\'xn\-\-y86c\.xn\-\-hdh782b\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:3599\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--y86c.xn--bnd622g", %p)},	undef,	"to_ascii\(\'xn\-\-y86c\.xn\-\-bnd622g\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:3600\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐹮｡󠢼\x{200D}", %p)},	undef,	"to_ascii\(\'𐹮｡\?\\u200D\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:3601\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐹮。󠢼\x{200D}", %p)},	undef,	"to_ascii\(\'𐹮\。\?\\u200D\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:3603\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--mo0d.xn--wy46e", %p)},	undef,	"to_ascii\(\'xn\-\-mo0d\.xn\-\-wy46e\'\)\ throws\ error\ B1\ V6\ \[data\/IdnaTest\.txt\:3605\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--mo0d.xn--1ug18431l", %p)},	undef,	"to_ascii\(\'xn\-\-mo0d\.xn\-\-1ug18431l\'\)\ throws\ error\ B1\ C2\ V6\ \[data\/IdnaTest\.txt\:3606\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴞ𐹨｡︒\x{077D}\x{200D}Ⴏ", %p)},	undef,	"to_ascii\(\'Ⴞ𐹨｡︒\\u077D\\u200DႯ\'\)\ throws\ error\ B1\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:3607\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴞ𐹨。。\x{077D}\x{200D}Ⴏ", %p)},	undef,	"to_ascii\(\'Ⴞ𐹨\。\。\\u077D\\u200DႯ\'\)\ throws\ error\ B2\ B3\ B5\ B6\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:3609\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("ⴞ𐹨。。\x{077D}\x{200D}ⴏ", %p)},	undef,	"to_ascii\(\'ⴞ𐹨\。\。\\u077D\\u200Dⴏ\'\)\ throws\ error\ B2\ B3\ B5\ B6\ A4_2\ \[data\/IdnaTest\.txt\:3611\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--mlju223e..xn--eqb053q", %p)},	undef,	"to_ascii\(\'xn\-\-mlju223e\.\.xn\-\-eqb053q\'\)\ throws\ error\ B2\ B3\ B5\ B6\ A4_2\ \[data\/IdnaTest\.txt\:3613\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--mlju223e..xn--eqb096jpgj", %p)},	undef,	"to_ascii\(\'xn\-\-mlju223e\.\.xn\-\-eqb096jpgj\'\)\ throws\ error\ B2\ B3\ B5\ B6\ C2\ A4_2\ \[data\/IdnaTest\.txt\:3614\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--2nd0990k..xn--eqb228b", %p)},	undef,	"to_ascii\(\'xn\-\-2nd0990k\.\.xn\-\-eqb228b\'\)\ throws\ error\ B2\ B3\ B5\ B6\ V6\ A4_2\ \[data\/IdnaTest\.txt\:3615\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--2nd0990k..xn--eqb228bgzm", %p)},	undef,	"to_ascii\(\'xn\-\-2nd0990k\.\.xn\-\-eqb228bgzm\'\)\ throws\ error\ B2\ B3\ B5\ B6\ C2\ V6\ A4_2\ \[data\/IdnaTest\.txt\:3616\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⴞ𐹨｡︒\x{077D}\x{200D}ⴏ", %p)},	undef,	"to_ascii\(\'ⴞ𐹨｡︒\\u077D\\u200Dⴏ\'\)\ throws\ error\ B1\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:3617\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--mlju223e.xn--eqb053qjk7l", %p)},	undef,	"to_ascii\(\'xn\-\-mlju223e\.xn\-\-eqb053qjk7l\'\)\ throws\ error\ B1\ B5\ B6\ V6\ \[data\/IdnaTest\.txt\:3619\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--mlju223e.xn--eqb096jpgj9y7r", %p)},	undef,	"to_ascii\(\'xn\-\-mlju223e\.xn\-\-eqb096jpgj9y7r\'\)\ throws\ error\ B1\ B5\ B6\ C2\ V6\ \[data\/IdnaTest\.txt\:3620\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--2nd0990k.xn--eqb228b583r", %p)},	undef,	"to_ascii\(\'xn\-\-2nd0990k\.xn\-\-eqb228b583r\'\)\ throws\ error\ B1\ B5\ B6\ V6\ \[data\/IdnaTest\.txt\:3621\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--2nd0990k.xn--eqb228bgzmvp0t", %p)},	undef,	"to_ascii\(\'xn\-\-2nd0990k\.xn\-\-eqb228bgzmvp0t\'\)\ throws\ error\ B1\ B5\ B6\ C2\ V6\ \[data\/IdnaTest\.txt\:3622\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}Ⴆ𝟹。-\x{20D2}-\x{07D1}", %p)},	undef,	"to_ascii\(\'\\u200CႦ𝟹\。\-\\u20D2\-\\u07D1\'\)\ throws\ error\ B1\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3623\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}Ⴆ3。-\x{20D2}-\x{07D1}", %p)},	undef,	"to_ascii\(\'\\u200CႦ3\。\-\\u20D2\-\\u07D1\'\)\ throws\ error\ B1\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3625\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_ascii("\x{200C}ⴆ3。-\x{20D2}-\x{07D1}", %p)},	undef,	"to_ascii\(\'\\u200Cⴆ3\。\-\\u20D2\-\\u07D1\'\)\ throws\ error\ B1\ V3\ \[data\/IdnaTest\.txt\:3627\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--3-lvs.xn-----vue617w", %p)},	undef,	"to_ascii\(\'xn\-\-3\-lvs\.xn\-\-\-\-\-vue617w\'\)\ throws\ error\ B1\ V3\ \[data\/IdnaTest\.txt\:3629\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--3-rgnv99c.xn-----vue617w", %p)},	undef,	"to_ascii\(\'xn\-\-3\-rgnv99c\.xn\-\-\-\-\-vue617w\'\)\ throws\ error\ B1\ C1\ V3\ \[data\/IdnaTest\.txt\:3630\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--3-i0g.xn-----vue617w", %p)},	undef,	"to_ascii\(\'xn\-\-3\-i0g\.xn\-\-\-\-\-vue617w\'\)\ throws\ error\ B1\ V3\ V6\ \[data\/IdnaTest\.txt\:3631\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--3-i0g939i.xn-----vue617w", %p)},	undef,	"to_ascii\(\'xn\-\-3\-i0g939i\.xn\-\-\-\-\-vue617w\'\)\ throws\ error\ B1\ C1\ V3\ V6\ \[data\/IdnaTest\.txt\:3632\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_ascii("\x{200C}ⴆ𝟹。-\x{20D2}-\x{07D1}", %p)},	undef,	"to_ascii\(\'\\u200Cⴆ𝟹\。\-\\u20D2\-\\u07D1\'\)\ throws\ error\ B1\ V3\ \[data\/IdnaTest\.txt\:3633\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("箃Ⴡ-󠁝｡≠-🤖", %p)},	undef,	"to_ascii\(\'箃Ⴡ\-\?｡\≠\-🤖\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3635\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("箃Ⴡ-󠁝｡=\x{0338}-🤖", %p)},	undef,	"to_ascii\(\'箃Ⴡ\-\?｡\=\\u0338\-🤖\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3636\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("箃Ⴡ-󠁝。≠-🤖", %p)},	undef,	"to_ascii\(\'箃Ⴡ\-\?\。\≠\-🤖\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3637\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("箃Ⴡ-󠁝。=\x{0338}-🤖", %p)},	undef,	"to_ascii\(\'箃Ⴡ\-\?\。\=\\u0338\-🤖\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3638\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("箃ⴡ-󠁝。=\x{0338}-🤖", %p)},	undef,	"to_ascii\(\'箃ⴡ\-\?\。\=\\u0338\-🤖\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3639\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("箃ⴡ-󠁝。≠-🤖", %p)},	undef,	"to_ascii\(\'箃ⴡ\-\?\。\≠\-🤖\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3640\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----4wsr321ay823p.xn----tfot873s", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-4wsr321ay823p\.xn\-\-\-\-tfot873s\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:3641\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----11g3013fy8x5m.xn----tfot873s", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-11g3013fy8x5m\.xn\-\-\-\-tfot873s\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:3642\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("箃ⴡ-󠁝｡=\x{0338}-🤖", %p)},	undef,	"to_ascii\(\'箃ⴡ\-\?｡\=\\u0338\-🤖\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3643\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("箃ⴡ-󠁝｡≠-🤖", %p)},	undef,	"to_ascii\(\'箃ⴡ\-\?｡\≠\-🤖\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3644\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_ascii("\x{07E5}.\x{06B5}", %p)},	"xn--dtb.xn--okb",	"to_ascii\(\'\\u07E5\.\\u06B5\'\)\ \[data\/IdnaTest\.txt\:3645\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_ascii("xn--dtb.xn--okb", %p)},	"xn--dtb.xn--okb",	"to_ascii\(\'xn\-\-dtb\.xn\-\-okb\'\)\ \[data\/IdnaTest\.txt\:3646\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("\x{200C}\x{200D}.𞤿", %p)},	undef,	"to_ascii\(\'\\u200C\\u200D\.𞤿\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:3647\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("\x{200C}\x{200D}.𞤝", %p)},	undef,	"to_ascii\(\'\\u200C\\u200D\.𞤝\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:3649\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii(".xn--3e6h", %p)},	undef,	"to_ascii\(\'\.xn\-\-3e6h\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:3651\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--0ugc.xn--3e6h", %p)},	undef,	"to_ascii\(\'xn\-\-0ugc\.xn\-\-3e6h\'\)\ throws\ error\ B1\ C1\ C2\ \[data\/IdnaTest\.txt\:3652\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("xn--3e6h", %p)},	"xn--3e6h",	"to_ascii\(\'xn\-\-3e6h\'\)\ \[data\/IdnaTest\.txt\:3653\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("𞤿", %p)},	"xn--3e6h",	"to_ascii\(\'𞤿\'\)\ \[data\/IdnaTest\.txt\:3654\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("𞤝", %p)},	"xn--3e6h",	"to_ascii\(\'𞤝\'\)\ \[data\/IdnaTest\.txt\:3655\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("🜑𐹧\x{0639}.ς𑍍蜹", %p)},	undef,	"to_ascii\(\'🜑𐹧\\u0639\.ς𑍍蜹\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:3656\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("🜑𐹧\x{0639}.Σ𑍍蜹", %p)},	undef,	"to_ascii\(\'🜑𐹧\\u0639\.Σ𑍍蜹\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:3658\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("🜑𐹧\x{0639}.σ𑍍蜹", %p)},	undef,	"to_ascii\(\'🜑𐹧\\u0639\.σ𑍍蜹\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:3659\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--4gb3736kk4zf.xn--4xa2248dy27d", %p)},	undef,	"to_ascii\(\'xn\-\-4gb3736kk4zf\.xn\-\-4xa2248dy27d\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:3660\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--4gb3736kk4zf.xn--3xa4248dy27d", %p)},	undef,	"to_ascii\(\'xn\-\-4gb3736kk4zf\.xn\-\-3xa4248dy27d\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:3661\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򫠐ス􆟤\x{0669}．󚃟", %p)},	undef,	"to_ascii\(\'\?ス\?\\u0669．\?\'\)\ throws\ error\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:3662\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򫠐ス􆟤\x{0669}.󚃟", %p)},	undef,	"to_ascii\(\'\?ス\?\\u0669\.\?\'\)\ throws\ error\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:3663\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--iib777sp230oo708a.xn--7824e", %p)},	undef,	"to_ascii\(\'xn\-\-iib777sp230oo708a\.xn\-\-7824e\'\)\ throws\ error\ B5\ B6\ V6\ \[data\/IdnaTest\.txt\:3664\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𝪣򕡝．\x{059A}\x{D850}\x{06C2}", %p)},	undef,	"to_ascii\(\'𝪣\?．\\u059A\\uD850\\u06C2\'\)\ throws\ error\ B1\ P1\ V5\ V6\ A3\ \[data\/IdnaTest\.txt\:3665\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𝪣򕡝．\x{059A}\x{D850}\x{06C1}\x{0654}", %p)},	undef,	"to_ascii\(\'𝪣\?．\\u059A\\uD850\\u06C1\\u0654\'\)\ throws\ error\ B1\ P1\ V5\ V6\ A3\ \[data\/IdnaTest\.txt\:3666\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𝪣򕡝.\x{059A}\x{D850}\x{06C2}", %p)},	undef,	"to_ascii\(\'𝪣\?\.\\u059A\\uD850\\u06C2\'\)\ throws\ error\ B1\ P1\ V5\ V6\ A3\ \[data\/IdnaTest\.txt\:3667\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𝪣򕡝.\x{059A}\x{D850}\x{06C1}\x{0654}", %p)},	undef,	"to_ascii\(\'𝪣\?\.\\u059A\\uD850\\u06C1\\u0654\'\)\ throws\ error\ B1\ P1\ V5\ V6\ A3\ \[data\/IdnaTest\.txt\:3668\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--8c3hu7971a.\x{059A}\x{D850}\x{06C2}", %p)},	undef,	"to_ascii\(\'xn\-\-8c3hu7971a\.\\u059A\\uD850\\u06C2\'\)\ throws\ error\ B1\ P1\ V5\ V6\ A3\ \[data\/IdnaTest\.txt\:3669\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--8c3hu7971a.\x{059A}\x{D850}\x{06C1}\x{0654}", %p)},	undef,	"to_ascii\(\'xn\-\-8c3hu7971a\.\\u059A\\uD850\\u06C1\\u0654\'\)\ throws\ error\ B1\ P1\ V5\ V6\ A3\ \[data\/IdnaTest\.txt\:3670\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("XN--8C3HU7971A.\x{059A}\x{D850}\x{06C1}\x{0654}", %p)},	undef,	"to_ascii\(\'XN\-\-8C3HU7971A\.\\u059A\\uD850\\u06C1\\u0654\'\)\ throws\ error\ B1\ P1\ V5\ V6\ A3\ \[data\/IdnaTest\.txt\:3671\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("XN--8C3HU7971A.\x{059A}\x{D850}\x{06C2}", %p)},	undef,	"to_ascii\(\'XN\-\-8C3HU7971A\.\\u059A\\uD850\\u06C2\'\)\ throws\ error\ B1\ P1\ V5\ V6\ A3\ \[data\/IdnaTest\.txt\:3672\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Xn--8C3hu7971a.\x{059A}\x{D850}\x{06C2}", %p)},	undef,	"to_ascii\(\'Xn\-\-8C3hu7971a\.\\u059A\\uD850\\u06C2\'\)\ throws\ error\ B1\ P1\ V5\ V6\ A3\ \[data\/IdnaTest\.txt\:3673\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Xn--8C3hu7971a.\x{059A}\x{D850}\x{06C1}\x{0654}", %p)},	undef,	"to_ascii\(\'Xn\-\-8C3hu7971a\.\\u059A\\uD850\\u06C1\\u0654\'\)\ throws\ error\ B1\ P1\ V5\ V6\ A3\ \[data\/IdnaTest\.txt\:3674\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0660}򪓵\x{200C}。\x{0757}", %p)},	undef,	"to_ascii\(\'\\u0660\?\\u200C\。\\u0757\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:3675\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--8hb82030l.xn--bpb", %p)},	undef,	"to_ascii\(\'xn\-\-8hb82030l\.xn\-\-bpb\'\)\ throws\ error\ B1\ V6\ \[data\/IdnaTest\.txt\:3677\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--8hb852ke991q.xn--bpb", %p)},	undef,	"to_ascii\(\'xn\-\-8hb852ke991q\.xn\-\-bpb\'\)\ throws\ error\ B1\ C1\ V6\ \[data\/IdnaTest\.txt\:3678\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_ascii("\x{103A}\x{200D}\x{200C}。-\x{200C}", %p)},	undef,	"to_ascii\(\'\\u103A\\u200D\\u200C\。\-\\u200C\'\)\ throws\ error\ V3\ V5\ \[data\/IdnaTest\.txt\:3679\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--bkd.-", %p)},	undef,	"to_ascii\(\'xn\-\-bkd\.\-\'\)\ throws\ error\ V3\ V5\ \[data\/IdnaTest\.txt\:3681\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--bkd412fca.xn----sgn", %p)},	undef,	"to_ascii\(\'xn\-\-bkd412fca\.xn\-\-\-\-sgn\'\)\ throws\ error\ C1\ V3\ V5\ \[data\/IdnaTest\.txt\:3682\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("︒｡\x{1B44}ᡉ", %p)},	undef,	"to_ascii\(\'︒｡\\u1B44ᡉ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3683\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_ascii("。。\x{1B44}ᡉ", %p)},	undef,	"to_ascii\(\'\。\。\\u1B44ᡉ\'\)\ throws\ error\ V5\ A4_2\ \[data\/IdnaTest\.txt\:3684\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("..xn--87e93m", %p)},	undef,	"to_ascii\(\'\.\.xn\-\-87e93m\'\)\ throws\ error\ V5\ A4_2\ \[data\/IdnaTest\.txt\:3685\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--y86c.xn--87e93m", %p)},	undef,	"to_ascii\(\'xn\-\-y86c\.xn\-\-87e93m\'\)\ throws\ error\ V5\ V6\ \[data\/IdnaTest\.txt\:3686\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("\x{0758}ß。ጫᢊ\x{0768}𝟐", %p)},	undef,	"to_ascii\(\'\\u0758ß\。ጫᢊ\\u0768𝟐\'\)\ throws\ error\ B2\ B3\ B5\ \[data\/IdnaTest\.txt\:3687\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("\x{0758}ß。ጫᢊ\x{0768}2", %p)},	undef,	"to_ascii\(\'\\u0758ß\。ጫᢊ\\u07682\'\)\ throws\ error\ B2\ B3\ B5\ \[data\/IdnaTest\.txt\:3689\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("\x{0758}SS。ጫᢊ\x{0768}2", %p)},	undef,	"to_ascii\(\'\\u0758SS\。ጫᢊ\\u07682\'\)\ throws\ error\ B2\ B3\ B5\ \[data\/IdnaTest\.txt\:3691\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("\x{0758}ss。ጫᢊ\x{0768}2", %p)},	undef,	"to_ascii\(\'\\u0758ss\。ጫᢊ\\u07682\'\)\ throws\ error\ B2\ B3\ B5\ \[data\/IdnaTest\.txt\:3692\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("\x{0758}Ss。ጫᢊ\x{0768}2", %p)},	undef,	"to_ascii\(\'\\u0758Ss\。ጫᢊ\\u07682\'\)\ throws\ error\ B2\ B3\ B5\ \[data\/IdnaTest\.txt\:3693\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--ss-gke.xn--2-b5c641gfmf", %p)},	undef,	"to_ascii\(\'xn\-\-ss\-gke\.xn\-\-2\-b5c641gfmf\'\)\ throws\ error\ B2\ B3\ B5\ \[data\/IdnaTest\.txt\:3694\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--zca724a.xn--2-b5c641gfmf", %p)},	undef,	"to_ascii\(\'xn\-\-zca724a\.xn\-\-2\-b5c641gfmf\'\)\ throws\ error\ B2\ B3\ B5\ \[data\/IdnaTest\.txt\:3695\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("\x{0758}SS。ጫᢊ\x{0768}𝟐", %p)},	undef,	"to_ascii\(\'\\u0758SS\。ጫᢊ\\u0768𝟐\'\)\ throws\ error\ B2\ B3\ B5\ \[data\/IdnaTest\.txt\:3696\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("\x{0758}ss。ጫᢊ\x{0768}𝟐", %p)},	undef,	"to_ascii\(\'\\u0758ss\。ጫᢊ\\u0768𝟐\'\)\ throws\ error\ B2\ B3\ B5\ \[data\/IdnaTest\.txt\:3697\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("\x{0758}Ss。ጫᢊ\x{0768}𝟐", %p)},	undef,	"to_ascii\(\'\\u0758Ss\。ጫᢊ\\u0768𝟐\'\)\ throws\ error\ B2\ B3\ B5\ \[data\/IdnaTest\.txt\:3698\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("\x{07C3}𞶇ᚲ.\x{0902}\x{0353}𝟚\x{09CD}", %p)},	undef,	"to_ascii\(\'\\u07C3\?ᚲ\.\\u0902\\u0353𝟚\\u09CD\'\)\ throws\ error\ B1\ B2\ B3\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3699\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{07C3}𞶇ᚲ.\x{0902}\x{0353}2\x{09CD}", %p)},	undef,	"to_ascii\(\'\\u07C3\?ᚲ\.\\u0902\\u03532\\u09CD\'\)\ throws\ error\ B1\ B2\ B3\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3700\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--esb067enh07a.xn--2-lgb874bjxa", %p)},	undef,	"to_ascii\(\'xn\-\-esb067enh07a\.xn\-\-2\-lgb874bjxa\'\)\ throws\ error\ B1\ B2\ B3\ V5\ V6\ \[data\/IdnaTest\.txt\:3701\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-\x{1BAB}︒\x{200D}.񒶈񥹓", %p)},	undef,	"to_ascii\(\'\-\\u1BAB︒\\u200D\.\?\?\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3702\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-\x{1BAB}。\x{200D}.񒶈񥹓", %p)},	undef,	"to_ascii\(\'\-\\u1BAB\。\\u200D\.\?\?\'\)\ throws\ error\ P1\ V3\ V6\ A4_2\ \[data\/IdnaTest\.txt\:3704\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----qml..xn--x50zy803a", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-qml\.\.xn\-\-x50zy803a\'\)\ throws\ error\ V3\ V6\ A4_2\ \[data\/IdnaTest\.txt\:3706\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----qml.xn--1ug.xn--x50zy803a", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-qml\.xn\-\-1ug\.xn\-\-x50zy803a\'\)\ throws\ error\ C2\ V3\ V6\ \[data\/IdnaTest\.txt\:3707\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----qml1407i.xn--x50zy803a", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-qml1407i\.xn\-\-x50zy803a\'\)\ throws\ error\ V3\ V6\ \[data\/IdnaTest\.txt\:3708\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----qmlv7tw180a.xn--x50zy803a", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-qmlv7tw180a\.xn\-\-x50zy803a\'\)\ throws\ error\ C2\ V3\ V6\ \[data\/IdnaTest\.txt\:3709\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠦮.≯𞀆", %p)},	undef,	"to_ascii\(\'\?\.\≯𞀆\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3710\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠦮.>\x{0338}𞀆", %p)},	undef,	"to_ascii\(\'\?\.\>\\u0338𞀆\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3711\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--t546e.xn--hdh5166o", %p)},	undef,	"to_ascii\(\'xn\-\-t546e\.xn\-\-hdh5166o\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:3712\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-𑄳󠊗𐹩。𞮱", %p)},	undef,	"to_ascii\(\'\-𑄳\?𐹩\。\?\'\)\ throws\ error\ B1\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3713\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----p26i72em2894c.xn--zw6h", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-p26i72em2894c\.xn\-\-zw6h\'\)\ throws\ error\ B1\ V3\ V6\ \[data\/IdnaTest\.txt\:3714\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{06B9}．ᡳ\x{115F}", %p)},	undef,	"to_ascii\(\'\\u06B9．ᡳ\\u115F\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3715\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{06B9}.ᡳ\x{115F}", %p)},	undef,	"to_ascii\(\'\\u06B9\.ᡳ\\u115F\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3716\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--skb.xn--osd737a", %p)},	undef,	"to_ascii\(\'xn\-\-skb\.xn\-\-osd737a\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:3717\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("㨛𘱎.︒𝟕\x{0D01}", %p)},	undef,	"to_ascii\(\'㨛𘱎\.︒𝟕\\u0D01\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3718\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("㨛𘱎.。7\x{0D01}", %p)},	undef,	"to_ascii\(\'㨛𘱎\.\。7\\u0D01\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:3719\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--mbm8237g..xn--7-7hf", %p)},	undef,	"to_ascii\(\'xn\-\-mbm8237g\.\.xn\-\-7\-7hf\'\)\ throws\ error\ V6\ A4_2\ \[data\/IdnaTest\.txt\:3720\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--mbm8237g.xn--7-7hf1526p", %p)},	undef,	"to_ascii\(\'xn\-\-mbm8237g\.xn\-\-7\-7hf1526p\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:3721\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{06DD}𻱧-｡𞷁\x{2064}𞤣≮", %p)},	undef,	"to_ascii\(\'\\u06DD\?\-｡\?\\u2064𞤣\≮\'\)\ throws\ error\ B1\ B3\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3722\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{06DD}𻱧-｡𞷁\x{2064}𞤣<\x{0338}", %p)},	undef,	"to_ascii\(\'\\u06DD\?\-｡\?\\u2064𞤣\<\\u0338\'\)\ throws\ error\ B1\ B3\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3723\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{06DD}𻱧-。𞷁\x{2064}𞤣≮", %p)},	undef,	"to_ascii\(\'\\u06DD\?\-\。\?\\u2064𞤣\≮\'\)\ throws\ error\ B1\ B3\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3724\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{06DD}𻱧-。𞷁\x{2064}𞤣<\x{0338}", %p)},	undef,	"to_ascii\(\'\\u06DD\?\-\。\?\\u2064𞤣\<\\u0338\'\)\ throws\ error\ B1\ B3\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3725\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{06DD}𻱧-。𞷁\x{2064}𞤁<\x{0338}", %p)},	undef,	"to_ascii\(\'\\u06DD\?\-\。\?\\u2064𞤁\<\\u0338\'\)\ throws\ error\ B1\ B3\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3726\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{06DD}𻱧-。𞷁\x{2064}𞤁≮", %p)},	undef,	"to_ascii\(\'\\u06DD\?\-\。\?\\u2064𞤁\≮\'\)\ throws\ error\ B1\ B3\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3727\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----dxc06304e.xn--gdh5020pk5c", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-dxc06304e\.xn\-\-gdh5020pk5c\'\)\ throws\ error\ B1\ B3\ V3\ V6\ \[data\/IdnaTest\.txt\:3728\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{06DD}𻱧-｡𞷁\x{2064}𞤁<\x{0338}", %p)},	undef,	"to_ascii\(\'\\u06DD\?\-｡\?\\u2064𞤁\<\\u0338\'\)\ throws\ error\ B1\ B3\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3729\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{06DD}𻱧-｡𞷁\x{2064}𞤁≮", %p)},	undef,	"to_ascii\(\'\\u06DD\?\-｡\?\\u2064𞤁\≮\'\)\ throws\ error\ B1\ B3\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3730\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ß\x{200C}\x{AAF6}ᢥ．⊶ჁႶ", %p)},	undef,	"to_ascii\(\'ß\\u200C\\uAAF6ᢥ．\⊶ჁႶ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3731\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ß\x{200C}\x{AAF6}ᢥ.⊶ჁႶ", %p)},	undef,	"to_ascii\(\'ß\\u200C\\uAAF6ᢥ\.\⊶ჁႶ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3733\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_ascii("ß\x{200C}\x{AAF6}ᢥ.⊶ⴡⴖ", %p)},	"xn--ss-4epx629f.xn--ifh802b6a",	"to_ascii\(\'ß\\u200C\\uAAF6ᢥ\.\⊶ⴡⴖ\'\)\ \[data\/IdnaTest\.txt\:3735\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("SS\x{200C}\x{AAF6}ᢥ.⊶ჁႶ", %p)},	undef,	"to_ascii\(\'SS\\u200C\\uAAF6ᢥ\.\⊶ჁႶ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3737\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_ascii("ss\x{200C}\x{AAF6}ᢥ.⊶ⴡⴖ", %p)},	"xn--ss-4epx629f.xn--ifh802b6a",	"to_ascii\(\'ss\\u200C\\uAAF6ᢥ\.\⊶ⴡⴖ\'\)\ \[data\/IdnaTest\.txt\:3739\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("Ss\x{200C}\x{AAF6}ᢥ.⊶Ⴡⴖ", %p)},	undef,	"to_ascii\(\'Ss\\u200C\\uAAF6ᢥ\.\⊶Ⴡⴖ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3741\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--ss-4epx629f.xn--5nd703gyrh", %p)},	undef,	"to_ascii\(\'xn\-\-ss\-4epx629f\.xn\-\-5nd703gyrh\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:3743\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--ss-4ep585bkm5p.xn--5nd703gyrh", %p)},	undef,	"to_ascii\(\'xn\-\-ss\-4ep585bkm5p\.xn\-\-5nd703gyrh\'\)\ throws\ error\ C1\ V6\ \[data\/IdnaTest\.txt\:3744\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_ascii("xn--ss-4epx629f.xn--ifh802b6a", %p)},	"xn--ss-4epx629f.xn--ifh802b6a",	"to_ascii\(\'xn\-\-ss\-4epx629f\.xn\-\-ifh802b6a\'\)\ \[data\/IdnaTest\.txt\:3745\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_ascii("ss\x{AAF6}ᢥ.⊶ⴡⴖ", %p)},	"xn--ss-4epx629f.xn--ifh802b6a",	"to_ascii\(\'ss\\uAAF6ᢥ\.\⊶ⴡⴖ\'\)\ \[data\/IdnaTest\.txt\:3746\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("SS\x{AAF6}ᢥ.⊶ჁႶ", %p)},	undef,	"to_ascii\(\'SS\\uAAF6ᢥ\.\⊶ჁႶ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3747\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ss\x{AAF6}ᢥ.⊶Ⴡⴖ", %p)},	undef,	"to_ascii\(\'Ss\\uAAF6ᢥ\.\⊶Ⴡⴖ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3748\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--ss-4epx629f.xn--undv409k", %p)},	undef,	"to_ascii\(\'xn\-\-ss\-4epx629f\.xn\-\-undv409k\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:3749\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--ss-4ep585bkm5p.xn--ifh802b6a", %p)},	undef,	"to_ascii\(\'xn\-\-ss\-4ep585bkm5p\.xn\-\-ifh802b6a\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:3750\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--ss-4ep585bkm5p.xn--undv409k", %p)},	undef,	"to_ascii\(\'xn\-\-ss\-4ep585bkm5p\.xn\-\-undv409k\'\)\ throws\ error\ C1\ V6\ \[data\/IdnaTest\.txt\:3751\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--zca682johfi89m.xn--ifh802b6a", %p)},	undef,	"to_ascii\(\'xn\-\-zca682johfi89m\.xn\-\-ifh802b6a\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:3752\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--zca682johfi89m.xn--undv409k", %p)},	undef,	"to_ascii\(\'xn\-\-zca682johfi89m\.xn\-\-undv409k\'\)\ throws\ error\ C1\ V6\ \[data\/IdnaTest\.txt\:3753\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_ascii("ß\x{200C}\x{AAF6}ᢥ．⊶ⴡⴖ", %p)},	"xn--ss-4epx629f.xn--ifh802b6a",	"to_ascii\(\'ß\\u200C\\uAAF6ᢥ．\⊶ⴡⴖ\'\)\ \[data\/IdnaTest\.txt\:3754\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("SS\x{200C}\x{AAF6}ᢥ．⊶ჁႶ", %p)},	undef,	"to_ascii\(\'SS\\u200C\\uAAF6ᢥ．\⊶ჁႶ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3756\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_ascii("ss\x{200C}\x{AAF6}ᢥ．⊶ⴡⴖ", %p)},	"xn--ss-4epx629f.xn--ifh802b6a",	"to_ascii\(\'ss\\u200C\\uAAF6ᢥ．\⊶ⴡⴖ\'\)\ \[data\/IdnaTest\.txt\:3758\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("Ss\x{200C}\x{AAF6}ᢥ．⊶Ⴡⴖ", %p)},	undef,	"to_ascii\(\'Ss\\u200C\\uAAF6ᢥ．\⊶Ⴡⴖ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3760\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}。ς󠁉", %p)},	undef,	"to_ascii\(\'\\u200D\。ς\?\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:3762\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}。Σ󠁉", %p)},	undef,	"to_ascii\(\'\\u200D\。Σ\?\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:3764\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}。σ󠁉", %p)},	undef,	"to_ascii\(\'\\u200D\。σ\?\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:3766\]") or ($@ and diag($@));
is(eval{uts46_to_ascii(".xn--4xa24344p", %p)},	undef,	"to_ascii\(\'\.xn\-\-4xa24344p\'\)\ throws\ error\ V6\ A4_2\ \[data\/IdnaTest\.txt\:3768\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--1ug.xn--4xa24344p", %p)},	undef,	"to_ascii\(\'xn\-\-1ug\.xn\-\-4xa24344p\'\)\ throws\ error\ C2\ V6\ \[data\/IdnaTest\.txt\:3769\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--1ug.xn--3xa44344p", %p)},	undef,	"to_ascii\(\'xn\-\-1ug\.xn\-\-3xa44344p\'\)\ throws\ error\ C2\ V6\ \[data\/IdnaTest\.txt\:3770\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𞵑ß.\x{0751}\x{200D}𞤛-", %p)},	undef,	"to_ascii\(\'\?ß\.\\u0751\\u200D𞤛\-\'\)\ throws\ error\ B2\ B3\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3771\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𞵑ß.\x{0751}\x{200D}𞤽-", %p)},	undef,	"to_ascii\(\'\?ß\.\\u0751\\u200D𞤽\-\'\)\ throws\ error\ B2\ B3\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3773\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𞵑SS.\x{0751}\x{200D}𞤛-", %p)},	undef,	"to_ascii\(\'\?SS\.\\u0751\\u200D𞤛\-\'\)\ throws\ error\ B2\ B3\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3775\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𞵑ss.\x{0751}\x{200D}𞤽-", %p)},	undef,	"to_ascii\(\'\?ss\.\\u0751\\u200D𞤽\-\'\)\ throws\ error\ B2\ B3\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3777\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𞵑Ss.\x{0751}\x{200D}𞤽-", %p)},	undef,	"to_ascii\(\'\?Ss\.\\u0751\\u200D𞤽\-\'\)\ throws\ error\ B2\ B3\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3779\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--ss-2722a.xn----z3c03218a", %p)},	undef,	"to_ascii\(\'xn\-\-ss\-2722a\.xn\-\-\-\-z3c03218a\'\)\ throws\ error\ B2\ B3\ V3\ V6\ \[data\/IdnaTest\.txt\:3781\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--ss-2722a.xn----z3c011q9513b", %p)},	undef,	"to_ascii\(\'xn\-\-ss\-2722a\.xn\-\-\-\-z3c011q9513b\'\)\ throws\ error\ B2\ B3\ C2\ V3\ V6\ \[data\/IdnaTest\.txt\:3782\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--zca5423w.xn----z3c011q9513b", %p)},	undef,	"to_ascii\(\'xn\-\-zca5423w\.xn\-\-\-\-z3c011q9513b\'\)\ throws\ error\ B2\ B3\ C2\ V3\ V6\ \[data\/IdnaTest\.txt\:3783\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𞵑ss.\x{0751}\x{200D}𞤛-", %p)},	undef,	"to_ascii\(\'\?ss\.\\u0751\\u200D𞤛\-\'\)\ throws\ error\ B2\ B3\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3784\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𞵑Ss.\x{0751}\x{200D}𞤛-", %p)},	undef,	"to_ascii\(\'\?Ss\.\\u0751\\u200D𞤛\-\'\)\ throws\ error\ B2\ B3\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3786\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𑘽\x{200D}𞤧．𐹧󡦪-", %p)},	undef,	"to_ascii\(\'𑘽\\u200D𞤧．𐹧\?\-\'\)\ throws\ error\ B1\ P1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:3788\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𑘽\x{200D}𞤧.𐹧󡦪-", %p)},	undef,	"to_ascii\(\'𑘽\\u200D𞤧\.𐹧\?\-\'\)\ throws\ error\ B1\ P1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:3790\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𑘽\x{200D}𞤅.𐹧󡦪-", %p)},	undef,	"to_ascii\(\'𑘽\\u200D𞤅\.𐹧\?\-\'\)\ throws\ error\ B1\ P1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:3792\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--qb2ds317a.xn----k26iq1483f", %p)},	undef,	"to_ascii\(\'xn\-\-qb2ds317a\.xn\-\-\-\-k26iq1483f\'\)\ throws\ error\ B1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:3794\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--1ugz808gdimf.xn----k26iq1483f", %p)},	undef,	"to_ascii\(\'xn\-\-1ugz808gdimf\.xn\-\-\-\-k26iq1483f\'\)\ throws\ error\ B1\ C2\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:3795\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𑘽\x{200D}𞤅．𐹧󡦪-", %p)},	undef,	"to_ascii\(\'𑘽\\u200D𞤅．𐹧\?\-\'\)\ throws\ error\ B1\ P1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:3796\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⒒򨘙򳳠𑓀.-󞡊", %p)},	undef,	"to_ascii\(\'⒒\?\?𑓀\.\-\?\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3798\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("11.򨘙򳳠𑓀.-󞡊", %p)},	undef,	"to_ascii\(\'11\.\?\?𑓀\.\-\?\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3799\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("11.xn--uz1d59632bxujd.xn----x310m", %p)},	undef,	"to_ascii\(\'11\.xn\-\-uz1d59632bxujd\.xn\-\-\-\-x310m\'\)\ throws\ error\ V3\ V6\ \[data\/IdnaTest\.txt\:3800\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--3shy698frsu9dt1me.xn----x310m", %p)},	undef,	"to_ascii\(\'xn\-\-3shy698frsu9dt1me\.xn\-\-\-\-x310m\'\)\ throws\ error\ V3\ V6\ \[data\/IdnaTest\.txt\:3801\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-｡\x{200D}", %p)},	undef,	"to_ascii\(\'\-｡\\u200D\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:3802\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-。\x{200D}", %p)},	undef,	"to_ascii\(\'\-\。\\u200D\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:3804\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-.", %p)},	undef,	"to_ascii\(\'\-\.\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:3806\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-.xn--1ug", %p)},	undef,	"to_ascii\(\'\-\.xn\-\-1ug\'\)\ throws\ error\ C2\ V3\ \[data\/IdnaTest\.txt\:3807\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≮ᡬ．ς¹-\x{DB09}", %p)},	undef,	"to_ascii\(\'\≮ᡬ．ς¹\-\\uDB09\'\)\ throws\ error\ P1\ V6\ A3\ \[data\/IdnaTest\.txt\:3808\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("<\x{0338}ᡬ．ς¹-\x{DB09}", %p)},	undef,	"to_ascii\(\'\<\\u0338ᡬ．ς¹\-\\uDB09\'\)\ throws\ error\ P1\ V6\ A3\ \[data\/IdnaTest\.txt\:3810\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≮ᡬ.ς1-\x{DB09}", %p)},	undef,	"to_ascii\(\'\≮ᡬ\.ς1\-\\uDB09\'\)\ throws\ error\ P1\ V6\ A3\ \[data\/IdnaTest\.txt\:3812\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("<\x{0338}ᡬ.ς1-\x{DB09}", %p)},	undef,	"to_ascii\(\'\<\\u0338ᡬ\.ς1\-\\uDB09\'\)\ throws\ error\ P1\ V6\ A3\ \[data\/IdnaTest\.txt\:3814\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("<\x{0338}ᡬ.Σ1-\x{DB09}", %p)},	undef,	"to_ascii\(\'\<\\u0338ᡬ\.Σ1\-\\uDB09\'\)\ throws\ error\ P1\ V6\ A3\ \[data\/IdnaTest\.txt\:3816\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≮ᡬ.Σ1-\x{DB09}", %p)},	undef,	"to_ascii\(\'\≮ᡬ\.Σ1\-\\uDB09\'\)\ throws\ error\ P1\ V6\ A3\ \[data\/IdnaTest\.txt\:3817\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≮ᡬ.σ1-\x{DB09}", %p)},	undef,	"to_ascii\(\'\≮ᡬ\.σ1\-\\uDB09\'\)\ throws\ error\ P1\ V6\ A3\ \[data\/IdnaTest\.txt\:3818\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("<\x{0338}ᡬ.σ1-\x{DB09}", %p)},	undef,	"to_ascii\(\'\<\\u0338ᡬ\.σ1\-\\uDB09\'\)\ throws\ error\ P1\ V6\ A3\ \[data\/IdnaTest\.txt\:3819\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--88e732c.σ1-\x{DB09}", %p)},	undef,	"to_ascii\(\'xn\-\-88e732c\.σ1\-\\uDB09\'\)\ throws\ error\ P1\ V6\ A3\ \[data\/IdnaTest\.txt\:3820\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("XN--88E732C.Σ1-\x{DB09}", %p)},	undef,	"to_ascii\(\'XN\-\-88E732C\.Σ1\-\\uDB09\'\)\ throws\ error\ P1\ V6\ A3\ \[data\/IdnaTest\.txt\:3821\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--88e732c.ς1-\x{DB09}", %p)},	undef,	"to_ascii\(\'xn\-\-88e732c\.ς1\-\\uDB09\'\)\ throws\ error\ P1\ V6\ A3\ \[data\/IdnaTest\.txt\:3822\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Xn--88E732c.ς1-\x{DB09}", %p)},	undef,	"to_ascii\(\'Xn\-\-88E732c\.ς1\-\\uDB09\'\)\ throws\ error\ P1\ V6\ A3\ \[data\/IdnaTest\.txt\:3824\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Xn--88E732c.σ1-\x{DB09}", %p)},	undef,	"to_ascii\(\'Xn\-\-88E732c\.σ1\-\\uDB09\'\)\ throws\ error\ P1\ V6\ A3\ \[data\/IdnaTest\.txt\:3826\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("<\x{0338}ᡬ．Σ¹-\x{DB09}", %p)},	undef,	"to_ascii\(\'\<\\u0338ᡬ．Σ¹\-\\uDB09\'\)\ throws\ error\ P1\ V6\ A3\ \[data\/IdnaTest\.txt\:3827\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≮ᡬ．Σ¹-\x{DB09}", %p)},	undef,	"to_ascii\(\'\≮ᡬ．Σ¹\-\\uDB09\'\)\ throws\ error\ P1\ V6\ A3\ \[data\/IdnaTest\.txt\:3828\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≮ᡬ．σ¹-\x{DB09}", %p)},	undef,	"to_ascii\(\'\≮ᡬ．σ¹\-\\uDB09\'\)\ throws\ error\ P1\ V6\ A3\ \[data\/IdnaTest\.txt\:3829\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("<\x{0338}ᡬ．σ¹-\x{DB09}", %p)},	undef,	"to_ascii\(\'\<\\u0338ᡬ．σ¹\-\\uDB09\'\)\ throws\ error\ P1\ V6\ A3\ \[data\/IdnaTest\.txt\:3830\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ቬ򔠼񁗶｡𐨬𝟠", %p)},	undef,	"to_ascii\(\'ቬ\?\?｡𐨬𝟠\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3831\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ቬ򔠼񁗶。𐨬8", %p)},	undef,	"to_ascii\(\'ቬ\?\?\。𐨬8\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3832\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--d0d41273c887z.xn--8-ob5i", %p)},	undef,	"to_ascii\(\'xn\-\-d0d41273c887z\.xn\-\-8\-ob5i\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:3833\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐱲。蔫\x{0766}", %p)},	undef,	"to_ascii\(\'\?\。蔫\\u0766\'\)\ throws\ error\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:3834\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--389c.xn--qpb7055d", %p)},	undef,	"to_ascii\(\'xn\-\-389c\.xn\-\-qpb7055d\'\)\ throws\ error\ B5\ B6\ V6\ \[data\/IdnaTest\.txt\:3835\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򒲧₃｡ꡚ𛇑󠄳\x{0647}", %p)},	undef,	"to_ascii\(\'\?₃｡ꡚ𛇑\󠄳\\u0647\'\)\ throws\ error\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:3836\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򒲧3。ꡚ𛇑󠄳\x{0647}", %p)},	undef,	"to_ascii\(\'\?3\。ꡚ𛇑\󠄳\\u0647\'\)\ throws\ error\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:3837\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--3-ep59g.xn--jhb5904fcp0h", %p)},	undef,	"to_ascii\(\'xn\-\-3\-ep59g\.xn\-\-jhb5904fcp0h\'\)\ throws\ error\ B5\ B6\ V6\ \[data\/IdnaTest\.txt\:3838\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("蓸\x{0642}≠.ß", %p)},	undef,	"to_ascii\(\'蓸\\u0642\≠\.ß\'\)\ throws\ error\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:3839\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("蓸\x{0642}=\x{0338}.ß", %p)},	undef,	"to_ascii\(\'蓸\\u0642\=\\u0338\.ß\'\)\ throws\ error\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:3841\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("蓸\x{0642}=\x{0338}.SS", %p)},	undef,	"to_ascii\(\'蓸\\u0642\=\\u0338\.SS\'\)\ throws\ error\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:3843\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("蓸\x{0642}≠.SS", %p)},	undef,	"to_ascii\(\'蓸\\u0642\≠\.SS\'\)\ throws\ error\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:3844\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("蓸\x{0642}≠.ss", %p)},	undef,	"to_ascii\(\'蓸\\u0642\≠\.ss\'\)\ throws\ error\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:3845\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("蓸\x{0642}=\x{0338}.ss", %p)},	undef,	"to_ascii\(\'蓸\\u0642\=\\u0338\.ss\'\)\ throws\ error\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:3846\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("蓸\x{0642}=\x{0338}.Ss", %p)},	undef,	"to_ascii\(\'蓸\\u0642\=\\u0338\.Ss\'\)\ throws\ error\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:3847\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("蓸\x{0642}≠.Ss", %p)},	undef,	"to_ascii\(\'蓸\\u0642\≠\.Ss\'\)\ throws\ error\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:3848\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--ehb015lnt1e.ss", %p)},	undef,	"to_ascii\(\'xn\-\-ehb015lnt1e\.ss\'\)\ throws\ error\ B5\ B6\ V6\ \[data\/IdnaTest\.txt\:3849\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--ehb015lnt1e.xn--zca", %p)},	undef,	"to_ascii\(\'xn\-\-ehb015lnt1e\.xn\-\-zca\'\)\ throws\ error\ B5\ B6\ V6\ \[data\/IdnaTest\.txt\:3850\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{084E}\x{067A}\x{0DD3}⒊.𐹹𞱩󠃪\x{200C}", %p)},	undef,	"to_ascii\(\'\\u084E\\u067A\\u0DD3⒊\.𐹹\?\?\\u200C\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:3851\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{084E}\x{067A}\x{0DD3}3..𐹹𞱩󠃪\x{200C}", %p)},	undef,	"to_ascii\(\'\\u084E\\u067A\\u0DD33\.\.𐹹\?\?\\u200C\'\)\ throws\ error\ B1\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:3853\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--3-prc71ls9j..xn--xo0dw109an237f", %p)},	undef,	"to_ascii\(\'xn\-\-3\-prc71ls9j\.\.xn\-\-xo0dw109an237f\'\)\ throws\ error\ B1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:3855\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--3-prc71ls9j..xn--0ug3205g7eyf3c96h", %p)},	undef,	"to_ascii\(\'xn\-\-3\-prc71ls9j\.\.xn\-\-0ug3205g7eyf3c96h\'\)\ throws\ error\ B1\ C1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:3856\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--zib94gfziuq1a.xn--xo0dw109an237f", %p)},	undef,	"to_ascii\(\'xn\-\-zib94gfziuq1a\.xn\-\-xo0dw109an237f\'\)\ throws\ error\ B1\ V6\ \[data\/IdnaTest\.txt\:3857\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--zib94gfziuq1a.xn--0ug3205g7eyf3c96h", %p)},	undef,	"to_ascii\(\'xn\-\-zib94gfziuq1a\.xn\-\-0ug3205g7eyf3c96h\'\)\ throws\ error\ B1\ C1\ V6\ \[data\/IdnaTest\.txt\:3858\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ς\x{200D}-.Ⴣ𦟙", %p)},	undef,	"to_ascii\(\'ς\\u200D\-\.Ⴣ𦟙\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3859\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("ς\x{200D}-.ⴣ𦟙", %p)},	undef,	"to_ascii\(\'ς\\u200D\-\.ⴣ𦟙\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:3861\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("Σ\x{200D}-.Ⴣ𦟙", %p)},	undef,	"to_ascii\(\'Σ\\u200D\-\.Ⴣ𦟙\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3863\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("σ\x{200D}-.ⴣ𦟙", %p)},	undef,	"to_ascii\(\'σ\\u200D\-\.ⴣ𦟙\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:3865\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn----zmb.xn--rlj2573p", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-zmb\.xn\-\-rlj2573p\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:3867\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----zmb048s.xn--rlj2573p", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-zmb048s\.xn\-\-rlj2573p\'\)\ throws\ error\ C2\ V3\ \[data\/IdnaTest\.txt\:3868\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----zmb.xn--7nd64871a", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-zmb\.xn\-\-7nd64871a\'\)\ throws\ error\ V3\ V6\ \[data\/IdnaTest\.txt\:3869\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----zmb048s.xn--7nd64871a", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-zmb048s\.xn\-\-7nd64871a\'\)\ throws\ error\ C2\ V3\ V6\ \[data\/IdnaTest\.txt\:3870\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----xmb348s.xn--rlj2573p", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-xmb348s\.xn\-\-rlj2573p\'\)\ throws\ error\ C2\ V3\ \[data\/IdnaTest\.txt\:3871\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----xmb348s.xn--7nd64871a", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-xmb348s\.xn\-\-7nd64871a\'\)\ throws\ error\ C2\ V3\ V6\ \[data\/IdnaTest\.txt\:3872\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≠。🞳𝟲", %p)},	undef,	"to_ascii\(\'\≠\。🞳𝟲\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3873\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("=\x{0338}。🞳𝟲", %p)},	undef,	"to_ascii\(\'\=\\u0338\。🞳𝟲\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3874\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≠。🞳6", %p)},	undef,	"to_ascii\(\'\≠\。🞳6\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3875\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("=\x{0338}。🞳6", %p)},	undef,	"to_ascii\(\'\=\\u0338\。🞳6\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3876\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--1ch.xn--6-dl4s", %p)},	undef,	"to_ascii\(\'xn\-\-1ch\.xn\-\-6\-dl4s\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:3877\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󅬽.蠔", %p)},	undef,	"to_ascii\(\'\?\.蠔\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3878\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--g747d.xn--xl2a", %p)},	undef,	"to_ascii\(\'xn\-\-g747d\.xn\-\-xl2a\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:3879\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_ascii("\x{08E6}\x{200D}．뼽", %p)},	undef,	"to_ascii\(\'\\u08E6\\u200D．뼽\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:3880\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_ascii("\x{08E6}\x{200D}．뼽", %p)},	undef,	"to_ascii\(\'\\u08E6\\u200D．뼽\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:3882\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_ascii("\x{08E6}\x{200D}.뼽", %p)},	undef,	"to_ascii\(\'\\u08E6\\u200D\.뼽\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:3884\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_ascii("\x{08E6}\x{200D}.뼽", %p)},	undef,	"to_ascii\(\'\\u08E6\\u200D\.뼽\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:3886\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--p0b.xn--e43b", %p)},	undef,	"to_ascii\(\'xn\-\-p0b\.xn\-\-e43b\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:3888\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--p0b869i.xn--e43b", %p)},	undef,	"to_ascii\(\'xn\-\-p0b869i\.xn\-\-e43b\'\)\ throws\ error\ C2\ V5\ \[data\/IdnaTest\.txt\:3889\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("₇\x{0BCD}􃂷\x{06D2}。👖\x{0675}-𞪑", %p)},	undef,	"to_ascii\(\'₇\\u0BCD\?\\u06D2\。👖\\u0675\-\?\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:3890\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("7\x{0BCD}􃂷\x{06D2}。👖\x{0627}\x{0674}-𞪑", %p)},	undef,	"to_ascii\(\'7\\u0BCD\?\\u06D2\。👖\\u0627\\u0674\-\?\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:3891\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--7-rwc839aj3073c.xn----ymc5uv818oghka", %p)},	undef,	"to_ascii\(\'xn\-\-7\-rwc839aj3073c\.xn\-\-\-\-ymc5uv818oghka\'\)\ throws\ error\ B1\ V6\ \[data\/IdnaTest\.txt\:3892\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_ascii("-｡\x{077B}", %p)},	undef,	"to_ascii\(\'\-｡\\u077B\'\)\ throws\ error\ B1\ V3\ \[data\/IdnaTest\.txt\:3893\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_ascii("-。\x{077B}", %p)},	undef,	"to_ascii\(\'\-\。\\u077B\'\)\ throws\ error\ B1\ V3\ \[data\/IdnaTest\.txt\:3894\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("-.xn--cqb", %p)},	undef,	"to_ascii\(\'\-\.xn\-\-cqb\'\)\ throws\ error\ B1\ V3\ \[data\/IdnaTest\.txt\:3895\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𑇌𵛓｡-⒈ꡏ\x{072B}", %p)},	undef,	"to_ascii\(\'𑇌\?｡\-⒈ꡏ\\u072B\'\)\ throws\ error\ B1\ P1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:3896\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𑇌𵛓。-1.ꡏ\x{072B}", %p)},	undef,	"to_ascii\(\'𑇌\?\。\-1\.ꡏ\\u072B\'\)\ throws\ error\ B1\ B5\ B6\ P1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:3897\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--8d1dg030h.-1.xn--1nb7163f", %p)},	undef,	"to_ascii\(\'xn\-\-8d1dg030h\.\-1\.xn\-\-1nb7163f\'\)\ throws\ error\ B1\ B5\ B6\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:3898\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--8d1dg030h.xn----u1c466tp10j", %p)},	undef,	"to_ascii\(\'xn\-\-8d1dg030h\.xn\-\-\-\-u1c466tp10j\'\)\ throws\ error\ B1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:3899\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("璛\x{1734}\x{06AF}.-", %p)},	undef,	"to_ascii\(\'璛\\u1734\\u06AF\.\-\'\)\ throws\ error\ B1\ B5\ B6\ V3\ \[data\/IdnaTest\.txt\:3900\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--ikb175frt4e.-", %p)},	undef,	"to_ascii\(\'xn\-\-ikb175frt4e\.\-\'\)\ throws\ error\ B1\ B5\ B6\ V3\ \[data\/IdnaTest\.txt\:3901\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("󠆰\x{08A1}\x{0A4D}샕．𐹲휁", %p)},	undef,	"to_ascii\(\'\󠆰\\u08A1\\u0A4D샕．𐹲휁\'\)\ throws\ error\ B1\ B2\ B3\ \[data\/IdnaTest\.txt\:3902\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("󠆰\x{08A1}\x{0A4D}샕．𐹲휁", %p)},	undef,	"to_ascii\(\'\󠆰\\u08A1\\u0A4D샕．𐹲휁\'\)\ throws\ error\ B1\ B2\ B3\ \[data\/IdnaTest\.txt\:3903\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("󠆰\x{08A1}\x{0A4D}샕.𐹲휁", %p)},	undef,	"to_ascii\(\'\󠆰\\u08A1\\u0A4D샕\.𐹲휁\'\)\ throws\ error\ B1\ B2\ B3\ \[data\/IdnaTest\.txt\:3904\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("󠆰\x{08A1}\x{0A4D}샕.𐹲휁", %p)},	undef,	"to_ascii\(\'\󠆰\\u08A1\\u0A4D샕\.𐹲휁\'\)\ throws\ error\ B1\ B2\ B3\ \[data\/IdnaTest\.txt\:3905\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--qyb07fj857a.xn--728bv72h", %p)},	undef,	"to_ascii\(\'xn\-\-qyb07fj857a\.xn\-\-728bv72h\'\)\ throws\ error\ B1\ B2\ B3\ \[data\/IdnaTest\.txt\:3906\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񍨽．񋸕", %p)},	undef,	"to_ascii\(\'\?．\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3907\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񍨽.񋸕", %p)},	undef,	"to_ascii\(\'\?\.\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3908\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--pr3x.xn--rv7w", %p)},	undef,	"to_ascii\(\'xn\-\-pr3x\.xn\-\-rv7w\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:3909\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{067D}𞥕｡𑑂𞤶Ⴍ-", %p)},	undef,	"to_ascii\(\'\\u067D𞥕｡𑑂𞤶Ⴍ\-\'\)\ throws\ error\ B1\ P1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:3910\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{067D}𞥕。𑑂𞤶Ⴍ-", %p)},	undef,	"to_ascii\(\'\\u067D𞥕\。𑑂𞤶Ⴍ\-\'\)\ throws\ error\ B1\ P1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:3911\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("\x{067D}𞥕。𑑂𞤶ⴍ-", %p)},	undef,	"to_ascii\(\'\\u067D𞥕\。𑑂𞤶ⴍ\-\'\)\ throws\ error\ B1\ V3\ V5\ \[data\/IdnaTest\.txt\:3912\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("\x{067D}𞥕。𑑂𞤔Ⴍ-", %p)},	undef,	"to_ascii\(\'\\u067D𞥕\。𑑂𞤔Ⴍ\-\'\)\ throws\ error\ B1\ P1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:3913\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("\x{067D}𞥕。𑑂𞤔ⴍ-", %p)},	undef,	"to_ascii\(\'\\u067D𞥕\。𑑂𞤔ⴍ\-\'\)\ throws\ error\ B1\ V3\ V5\ \[data\/IdnaTest\.txt\:3914\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--2ib0338v.xn----zvs0199fo91g", %p)},	undef,	"to_ascii\(\'xn\-\-2ib0338v\.xn\-\-\-\-zvs0199fo91g\'\)\ throws\ error\ B1\ V3\ V5\ \[data\/IdnaTest\.txt\:3915\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--2ib0338v.xn----w0g2740ro9vg", %p)},	undef,	"to_ascii\(\'xn\-\-2ib0338v\.xn\-\-\-\-w0g2740ro9vg\'\)\ throws\ error\ B1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:3916\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("\x{067D}𞥕｡𑑂𞤶ⴍ-", %p)},	undef,	"to_ascii\(\'\\u067D𞥕｡𑑂𞤶ⴍ\-\'\)\ throws\ error\ B1\ V3\ V5\ \[data\/IdnaTest\.txt\:3917\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("\x{067D}𞥕｡𑑂𞤔Ⴍ-", %p)},	undef,	"to_ascii\(\'\\u067D𞥕｡𑑂𞤔Ⴍ\-\'\)\ throws\ error\ B1\ P1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:3918\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("\x{067D}𞥕｡𑑂𞤔ⴍ-", %p)},	undef,	"to_ascii\(\'\\u067D𞥕｡𑑂𞤔ⴍ\-\'\)\ throws\ error\ B1\ V3\ V5\ \[data\/IdnaTest\.txt\:3919\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("𐯀𐸉𞧏。񢚧₄Ⴋ񂹫", %p)},	undef,	"to_ascii\(\'\?\?\?\。\?₄Ⴋ\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3920\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐯀𐸉𞧏。񢚧4Ⴋ񂹫", %p)},	undef,	"to_ascii\(\'\?\?\?\。\?4Ⴋ\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3921\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐯀𐸉𞧏。񢚧4ⴋ񂹫", %p)},	undef,	"to_ascii\(\'\?\?\?\。\?4ⴋ\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3922\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--039c42bq865a.xn--4-wvs27840bnrzm", %p)},	undef,	"to_ascii\(\'xn\-\-039c42bq865a\.xn\-\-4\-wvs27840bnrzm\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:3923\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--039c42bq865a.xn--4-t0g49302fnrzm", %p)},	undef,	"to_ascii\(\'xn\-\-039c42bq865a\.xn\-\-4\-t0g49302fnrzm\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:3924\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐯀𐸉𞧏。񢚧₄ⴋ񂹫", %p)},	undef,	"to_ascii\(\'\?\?\?\。\?₄ⴋ\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3925\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("4\x{06BD}︒󠑥.≠", %p)},	undef,	"to_ascii\(\'4\\u06BD︒\?\.\≠\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:3926\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("4\x{06BD}︒󠑥.=\x{0338}", %p)},	undef,	"to_ascii\(\'4\\u06BD︒\?\.\=\\u0338\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:3927\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("4\x{06BD}。󠑥.≠", %p)},	undef,	"to_ascii\(\'4\\u06BD\。\?\.\≠\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:3928\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("4\x{06BD}。󠑥.=\x{0338}", %p)},	undef,	"to_ascii\(\'4\\u06BD\。\?\.\=\\u0338\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:3929\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--4-kvc.xn--5136e.xn--1ch", %p)},	undef,	"to_ascii\(\'xn\-\-4\-kvc\.xn\-\-5136e\.xn\-\-1ch\'\)\ throws\ error\ B1\ V6\ \[data\/IdnaTest\.txt\:3930\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--4-kvc5601q2h50i.xn--1ch", %p)},	undef,	"to_ascii\(\'xn\-\-4\-kvc5601q2h50i\.xn\-\-1ch\'\)\ throws\ error\ B1\ V6\ \[data\/IdnaTest\.txt\:3931\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𝟓。\x{06D7}", %p)},	undef,	"to_ascii\(\'𝟓\。\\u06D7\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:3932\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("5。\x{06D7}", %p)},	undef,	"to_ascii\(\'5\。\\u06D7\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:3933\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("5.xn--nlb", %p)},	undef,	"to_ascii\(\'5\.xn\-\-nlb\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:3934\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}򺸩.⾕", %p)},	undef,	"to_ascii\(\'\\u200C\?\.⾕\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3935\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}򺸩.谷", %p)},	undef,	"to_ascii\(\'\\u200C\?\.谷\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3937\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--i183d.xn--6g3a", %p)},	undef,	"to_ascii\(\'xn\-\-i183d\.xn\-\-6g3a\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:3939\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--0ug26167i.xn--6g3a", %p)},	undef,	"to_ascii\(\'xn\-\-0ug26167i\.xn\-\-6g3a\'\)\ throws\ error\ C1\ V6\ \[data\/IdnaTest\.txt\:3940\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("︒󎰇\x{200D}.-\x{073C}\x{200C}", %p)},	undef,	"to_ascii\(\'︒\?\\u200D\.\-\\u073C\\u200C\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3941\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("。󎰇\x{200D}.-\x{073C}\x{200C}", %p)},	undef,	"to_ascii\(\'\。\?\\u200D\.\-\\u073C\\u200C\'\)\ throws\ error\ P1\ V3\ V6\ A4_2\ \[data\/IdnaTest\.txt\:3943\]") or ($@ and diag($@));
is(eval{uts46_to_ascii(".xn--hh50e.xn----t2c", %p)},	undef,	"to_ascii\(\'\.xn\-\-hh50e\.xn\-\-\-\-t2c\'\)\ throws\ error\ V3\ V6\ A4_2\ \[data\/IdnaTest\.txt\:3945\]") or ($@ and diag($@));
is(eval{uts46_to_ascii(".xn--1ug05310k.xn----t2c071q", %p)},	undef,	"to_ascii\(\'\.xn\-\-1ug05310k\.xn\-\-\-\-t2c071q\'\)\ throws\ error\ C1\ C2\ V3\ V6\ A4_2\ \[data\/IdnaTest\.txt\:3946\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--y86c71305c.xn----t2c", %p)},	undef,	"to_ascii\(\'xn\-\-y86c71305c\.xn\-\-\-\-t2c\'\)\ throws\ error\ V3\ V6\ \[data\/IdnaTest\.txt\:3947\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--1ug1658ftw26f.xn----t2c071q", %p)},	undef,	"to_ascii\(\'xn\-\-1ug1658ftw26f\.xn\-\-\-\-t2c071q\'\)\ throws\ error\ C1\ C2\ V3\ V6\ \[data\/IdnaTest\.txt\:3948\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≯𞤟。ᡨ", %p)},	undef,	"to_ascii\(\'\≯𞤟\。ᡨ\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:3949\]") or ($@ and diag($@));
is(eval{uts46_to_ascii(">\x{0338}𞤟。ᡨ", %p)},	undef,	"to_ascii\(\'\>\\u0338𞤟\。ᡨ\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:3950\]") or ($@ and diag($@));
is(eval{uts46_to_ascii(">\x{0338}𞥁。ᡨ", %p)},	undef,	"to_ascii\(\'\>\\u0338𞥁\。ᡨ\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:3951\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≯𞥁。ᡨ", %p)},	undef,	"to_ascii\(\'\≯𞥁\。ᡨ\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:3952\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--hdhz520p.xn--48e", %p)},	undef,	"to_ascii\(\'xn\-\-hdhz520p\.xn\-\-48e\'\)\ throws\ error\ B1\ V6\ \[data\/IdnaTest\.txt\:3953\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_ascii("\x{0F74}𫫰𝨄。\x{0713}𐹦", %p)},	undef,	"to_ascii\(\'\\u0F74𫫰𝨄\。\\u0713𐹦\'\)\ throws\ error\ B1\ V5\ \[data\/IdnaTest\.txt\:3954\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--ned8985uo92e.xn--dnb6395k", %p)},	undef,	"to_ascii\(\'xn\-\-ned8985uo92e\.xn\-\-dnb6395k\'\)\ throws\ error\ B1\ V5\ \[data\/IdnaTest\.txt\:3955\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_ascii("\x{033C}\x{07DB}⁷𝟹｡𝟬", %p)},	undef,	"to_ascii\(\'\\u033C\\u07DB⁷𝟹｡𝟬\'\)\ throws\ error\ B1\ V5\ \[data\/IdnaTest\.txt\:3956\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_ascii("\x{033C}\x{07DB}73。0", %p)},	undef,	"to_ascii\(\'\\u033C\\u07DB73\。0\'\)\ throws\ error\ B1\ V5\ \[data\/IdnaTest\.txt\:3957\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--73-9yb648b.0", %p)},	undef,	"to_ascii\(\'xn\-\-73\-9yb648b\.0\'\)\ throws\ error\ B1\ V5\ \[data\/IdnaTest\.txt\:3958\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}．𝟗", %p)},	undef,	"to_ascii\(\'\\u200D．𝟗\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:3959\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}.9", %p)},	undef,	"to_ascii\(\'\\u200D\.9\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:3961\]") or ($@ and diag($@));
is(eval{uts46_to_ascii(".9", %p)},	undef,	"to_ascii\(\'\.9\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:3963\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--1ug.9", %p)},	undef,	"to_ascii\(\'xn\-\-1ug\.9\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:3964\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("9", %p)},	"9",	"to_ascii\(\'9\'\)\ \[data\/IdnaTest\.txt\:3965\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("\x{0779}ᡭ𪕈。\x{06B6}\x{08D9}", %p)},	undef,	"to_ascii\(\'\\u0779ᡭ𪕈\。\\u06B6\\u08D9\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:3966\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--9pb497fs270c.xn--pkb80i", %p)},	undef,	"to_ascii\(\'xn\-\-9pb497fs270c\.xn\-\-pkb80i\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:3967\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0726}５\x{07E2}겙。\x{1CF4}𐷚", %p)},	undef,	"to_ascii\(\'\\u0726５\\u07E2겙\。\\u1CF4\?\'\)\ throws\ error\ B1\ B2\ B3\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3968\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0726}５\x{07E2}겙。\x{1CF4}𐷚", %p)},	undef,	"to_ascii\(\'\\u0726５\\u07E2겙\。\\u1CF4\?\'\)\ throws\ error\ B1\ B2\ B3\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3969\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0726}5\x{07E2}겙。\x{1CF4}𐷚", %p)},	undef,	"to_ascii\(\'\\u07265\\u07E2겙\。\\u1CF4\?\'\)\ throws\ error\ B1\ B2\ B3\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3970\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0726}5\x{07E2}겙。\x{1CF4}𐷚", %p)},	undef,	"to_ascii\(\'\\u07265\\u07E2겙\。\\u1CF4\?\'\)\ throws\ error\ B1\ B2\ B3\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3971\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--5-j1c97c2483c.xn--e7f2093h", %p)},	undef,	"to_ascii\(\'xn\-\-5\-j1c97c2483c\.xn\-\-e7f2093h\'\)\ throws\ error\ B1\ B2\ B3\ V5\ V6\ \[data\/IdnaTest\.txt\:3972\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴍ𿣍ꡨ\x{05AE}。Ⴞ\x{200C}\x{200C}", %p)},	undef,	"to_ascii\(\'Ⴍ\?ꡨ\\u05AE\。Ⴞ\\u200C\\u200C\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3973\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⴍ𿣍ꡨ\x{05AE}。ⴞ\x{200C}\x{200C}", %p)},	undef,	"to_ascii\(\'ⴍ\?ꡨ\\u05AE\。ⴞ\\u200C\\u200C\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3975\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--5cb172r175fug38a.xn--mlj", %p)},	undef,	"to_ascii\(\'xn\-\-5cb172r175fug38a\.xn\-\-mlj\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:3977\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--5cb172r175fug38a.xn--0uga051h", %p)},	undef,	"to_ascii\(\'xn\-\-5cb172r175fug38a\.xn\-\-0uga051h\'\)\ throws\ error\ C1\ V6\ \[data\/IdnaTest\.txt\:3978\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--5cb347co96jug15a.xn--2nd", %p)},	undef,	"to_ascii\(\'xn\-\-5cb347co96jug15a\.xn\-\-2nd\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:3979\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--5cb347co96jug15a.xn--2nd059ea", %p)},	undef,	"to_ascii\(\'xn\-\-5cb347co96jug15a\.xn\-\-2nd059ea\'\)\ throws\ error\ C1\ V6\ \[data\/IdnaTest\.txt\:3980\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐋰。󑓱", %p)},	undef,	"to_ascii\(\'𐋰\。\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3981\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--k97c.xn--q031e", %p)},	undef,	"to_ascii\(\'xn\-\-k97c\.xn\-\-q031e\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:3982\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󡎦\x{17B4}\x{0B4D}.𐹾", %p)},	undef,	"to_ascii\(\'\?\\u17B4\\u0B4D\.𐹾\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:3983\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--9ic364dho91z.xn--2o0d", %p)},	undef,	"to_ascii\(\'xn\-\-9ic364dho91z\.xn\-\-2o0d\'\)\ throws\ error\ B1\ V6\ \[data\/IdnaTest\.txt\:3984\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{08DF}Ⴋ𶿸귤．򠅼𝟢휪\x{0AE3}", %p)},	undef,	"to_ascii\(\'\\u08DFႫ\?귤．\?𝟢휪\\u0AE3\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3985\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{08DF}Ⴋ𶿸귤．򠅼𝟢휪\x{0AE3}", %p)},	undef,	"to_ascii\(\'\\u08DFႫ\?귤．\?𝟢휪\\u0AE3\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3986\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{08DF}Ⴋ𶿸귤.򠅼0휪\x{0AE3}", %p)},	undef,	"to_ascii\(\'\\u08DFႫ\?귤\.\?0휪\\u0AE3\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3987\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{08DF}Ⴋ𶿸귤.򠅼0휪\x{0AE3}", %p)},	undef,	"to_ascii\(\'\\u08DFႫ\?귤\.\?0휪\\u0AE3\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3988\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{08DF}ⴋ𶿸귤.򠅼0휪\x{0AE3}", %p)},	undef,	"to_ascii\(\'\\u08DFⴋ\?귤\.\?0휪\\u0AE3\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3989\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{08DF}ⴋ𶿸귤.򠅼0휪\x{0AE3}", %p)},	undef,	"to_ascii\(\'\\u08DFⴋ\?귤\.\?0휪\\u0AE3\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3990\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--i0b436pkl2g2h42a.xn--0-8le8997mulr5f", %p)},	undef,	"to_ascii\(\'xn\-\-i0b436pkl2g2h42a\.xn\-\-0\-8le8997mulr5f\'\)\ throws\ error\ V5\ V6\ \[data\/IdnaTest\.txt\:3991\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--i0b601b6r7l2hs0a.xn--0-8le8997mulr5f", %p)},	undef,	"to_ascii\(\'xn\-\-i0b601b6r7l2hs0a\.xn\-\-0\-8le8997mulr5f\'\)\ throws\ error\ V5\ V6\ \[data\/IdnaTest\.txt\:3992\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{08DF}ⴋ𶿸귤．򠅼𝟢휪\x{0AE3}", %p)},	undef,	"to_ascii\(\'\\u08DFⴋ\?귤．\?𝟢휪\\u0AE3\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3993\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{08DF}ⴋ𶿸귤．򠅼𝟢휪\x{0AE3}", %p)},	undef,	"to_ascii\(\'\\u08DFⴋ\?귤．\?𝟢휪\\u0AE3\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3994\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0784}．𞡝\x{0601}", %p)},	undef,	"to_ascii\(\'\\u0784．𞡝\\u0601\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3995\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0784}.𞡝\x{0601}", %p)},	undef,	"to_ascii\(\'\\u0784\.𞡝\\u0601\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3996\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--lqb.xn--jfb1808v", %p)},	undef,	"to_ascii\(\'xn\-\-lqb\.xn\-\-jfb1808v\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:3997\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("\x{0ACD}₃.8\x{A8C4}\x{200D}🃤", %p)},	undef,	"to_ascii\(\'\\u0ACD₃\.8\\uA8C4\\u200D🃤\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:3998\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("\x{0ACD}3.8\x{A8C4}\x{200D}🃤", %p)},	undef,	"to_ascii\(\'\\u0ACD3\.8\\uA8C4\\u200D🃤\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:4000\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--3-yke.xn--8-sl4et308f", %p)},	undef,	"to_ascii\(\'xn\-\-3\-yke\.xn\-\-8\-sl4et308f\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:4002\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--3-yke.xn--8-ugnv982dbkwm", %p)},	undef,	"to_ascii\(\'xn\-\-3\-yke\.xn\-\-8\-ugnv982dbkwm\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:4003\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("℻⩷𝆆。𞤠󠆁\x{180C}", %p)},	undef,	"to_ascii\(\'℻\⩷𝆆\。𞤠\󠆁\\u180C\'\)\ throws\ error\ B6\ \[data\/IdnaTest\.txt\:4004\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("FAX⩷𝆆。𞤠󠆁\x{180C}", %p)},	undef,	"to_ascii\(\'FAX\⩷𝆆\。𞤠\󠆁\\u180C\'\)\ throws\ error\ B6\ \[data\/IdnaTest\.txt\:4005\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("fax⩷𝆆。𞥂󠆁\x{180C}", %p)},	undef,	"to_ascii\(\'fax\⩷𝆆\。𞥂\󠆁\\u180C\'\)\ throws\ error\ B6\ \[data\/IdnaTest\.txt\:4006\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("Fax⩷𝆆。𞤠󠆁\x{180C}", %p)},	undef,	"to_ascii\(\'Fax\⩷𝆆\。𞤠\󠆁\\u180C\'\)\ throws\ error\ B6\ \[data\/IdnaTest\.txt\:4007\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--fax-4c9a1676t.xn--6e6h", %p)},	undef,	"to_ascii\(\'xn\-\-fax\-4c9a1676t\.xn\-\-6e6h\'\)\ throws\ error\ B6\ \[data\/IdnaTest\.txt\:4008\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("℻⩷𝆆。𞥂󠆁\x{180C}", %p)},	undef,	"to_ascii\(\'℻\⩷𝆆\。𞥂\󠆁\\u180C\'\)\ throws\ error\ B6\ \[data\/IdnaTest\.txt\:4009\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("FAX⩷𝆆。𞥂󠆁\x{180C}", %p)},	undef,	"to_ascii\(\'FAX\⩷𝆆\。𞥂\󠆁\\u180C\'\)\ throws\ error\ B6\ \[data\/IdnaTest\.txt\:4010\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("fax⩷𝆆。𞤠󠆁\x{180C}", %p)},	undef,	"to_ascii\(\'fax\⩷𝆆\。𞤠\󠆁\\u180C\'\)\ throws\ error\ B6\ \[data\/IdnaTest\.txt\:4011\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("fax⩷𝆆.𞥂", %p)},	undef,	"to_ascii\(\'fax\⩷𝆆\.𞥂\'\)\ throws\ error\ B6\ \[data\/IdnaTest\.txt\:4012\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("FAX⩷𝆆.𞤠", %p)},	undef,	"to_ascii\(\'FAX\⩷𝆆\.𞤠\'\)\ throws\ error\ B6\ \[data\/IdnaTest\.txt\:4013\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("Fax⩷𝆆.𞤠", %p)},	undef,	"to_ascii\(\'Fax\⩷𝆆\.𞤠\'\)\ throws\ error\ B6\ \[data\/IdnaTest\.txt\:4014\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("FAX⩷𝆆.𞥂", %p)},	undef,	"to_ascii\(\'FAX\⩷𝆆\.𞥂\'\)\ throws\ error\ B6\ \[data\/IdnaTest\.txt\:4015\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("Fax⩷𝆆.𞥂", %p)},	undef,	"to_ascii\(\'Fax\⩷𝆆\.𞥂\'\)\ throws\ error\ B6\ \[data\/IdnaTest\.txt\:4016\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("ꡕ≠\x{105E}󮿱｡𐵧󠄫\x{FFA0}", %p)},	undef,	"to_ascii\(\'ꡕ\≠\\u105E\?｡\?\󠄫\\uFFA0\'\)\ throws\ error\ B2\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:4017\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ꡕ=\x{0338}\x{105E}󮿱｡𐵧󠄫\x{FFA0}", %p)},	undef,	"to_ascii\(\'ꡕ\=\\u0338\\u105E\?｡\?\󠄫\\uFFA0\'\)\ throws\ error\ B2\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:4018\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ꡕ≠\x{105E}󮿱。𐵧󠄫\x{1160}", %p)},	undef,	"to_ascii\(\'ꡕ\≠\\u105E\?\。\?\󠄫\\u1160\'\)\ throws\ error\ B2\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:4019\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ꡕ=\x{0338}\x{105E}󮿱。𐵧󠄫\x{1160}", %p)},	undef,	"to_ascii\(\'ꡕ\=\\u0338\\u105E\?\。\?\󠄫\\u1160\'\)\ throws\ error\ B2\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:4020\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--cld333gn31h0158l.xn--psd1510k", %p)},	undef,	"to_ascii\(\'xn\-\-cld333gn31h0158l\.xn\-\-psd1510k\'\)\ throws\ error\ B2\ B3\ V6\ \[data\/IdnaTest\.txt\:4021\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--cld333gn31h0158l.xn--cl7c96v", %p)},	undef,	"to_ascii\(\'xn\-\-cld333gn31h0158l\.xn\-\-cl7c96v\'\)\ throws\ error\ B2\ B3\ V6\ \[data\/IdnaTest\.txt\:4022\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("鱊。\x{200C}", %p)},	"xn--rt6a.",	"to_ascii\(\'鱊\。\\u200C\'\)\ \[data\/IdnaTest\.txt\:4023\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--rt6a.", %p)},	"xn--rt6a.",	"to_ascii\(\'xn\-\-rt6a\.\'\)\ \[data\/IdnaTest\.txt\:4025\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("鱊.", %p)},	"xn--rt6a.",	"to_ascii\(\'鱊\.\'\)\ \[data\/IdnaTest\.txt\:4026\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--rt6a.xn--0ug", %p)},	undef,	"to_ascii\(\'xn\-\-rt6a\.xn\-\-0ug\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:4027\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("8𐹣．𑍨", %p)},	undef,	"to_ascii\(\'8𐹣．𑍨\'\)\ throws\ error\ B1\ B3\ B6\ V5\ \[data\/IdnaTest\.txt\:4028\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("8𐹣.𑍨", %p)},	undef,	"to_ascii\(\'8𐹣\.𑍨\'\)\ throws\ error\ B1\ B3\ B6\ V5\ \[data\/IdnaTest\.txt\:4029\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--8-d26i.xn--0p1d", %p)},	undef,	"to_ascii\(\'xn\-\-8\-d26i\.xn\-\-0p1d\'\)\ throws\ error\ B1\ B3\ B6\ V5\ \[data\/IdnaTest\.txt\:4030\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_ascii("⏹𐧀．𐫯", %p)},	undef,	"to_ascii\(\'\⏹𐧀．𐫯\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:4031\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_ascii("⏹𐧀.𐫯", %p)},	undef,	"to_ascii\(\'\⏹𐧀\.𐫯\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:4032\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--qoh9161g.xn--1x9c", %p)},	undef,	"to_ascii\(\'xn\-\-qoh9161g\.xn\-\-1x9c\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:4033\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("𞤺\x{07CC}4．\x{200D}", %p)},	"xn--4-0bd15808a.",	"to_ascii\(\'𞤺\\u07CC4．\\u200D\'\)\ \[data\/IdnaTest\.txt\:4034\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("𞤺\x{07CC}4.\x{200D}", %p)},	"xn--4-0bd15808a.",	"to_ascii\(\'𞤺\\u07CC4\.\\u200D\'\)\ \[data\/IdnaTest\.txt\:4036\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("𞤘\x{07CC}4.\x{200D}", %p)},	"xn--4-0bd15808a.",	"to_ascii\(\'𞤘\\u07CC4\.\\u200D\'\)\ \[data\/IdnaTest\.txt\:4038\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("xn--4-0bd15808a.", %p)},	"xn--4-0bd15808a.",	"to_ascii\(\'xn\-\-4\-0bd15808a\.\'\)\ \[data\/IdnaTest\.txt\:4040\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("𞤺\x{07CC}4.", %p)},	"xn--4-0bd15808a.",	"to_ascii\(\'𞤺\\u07CC4\.\'\)\ \[data\/IdnaTest\.txt\:4041\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("𞤘\x{07CC}4.", %p)},	"xn--4-0bd15808a.",	"to_ascii\(\'𞤘\\u07CC4\.\'\)\ \[data\/IdnaTest\.txt\:4042\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--4-0bd15808a.xn--1ug", %p)},	undef,	"to_ascii\(\'xn\-\-4\-0bd15808a\.xn\-\-1ug\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:4043\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("𞤘\x{07CC}4．\x{200D}", %p)},	"xn--4-0bd15808a.",	"to_ascii\(\'𞤘\\u07CC4．\\u200D\'\)\ \[data\/IdnaTest\.txt\:4044\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("⒗\x{0981}\x{20EF}-.\x{08E2}•", %p)},	undef,	"to_ascii\(\'⒗\\u0981\\u20EF\-\.\\u08E2\•\'\)\ throws\ error\ B1\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:4046\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("16.\x{0981}\x{20EF}-.\x{08E2}•", %p)},	undef,	"to_ascii\(\'16\.\\u0981\\u20EF\-\.\\u08E2\•\'\)\ throws\ error\ B1\ P1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:4047\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("16.xn----z0d801p.xn--l0b810j", %p)},	undef,	"to_ascii\(\'16\.xn\-\-\-\-z0d801p\.xn\-\-l0b810j\'\)\ throws\ error\ B1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:4048\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----z0d801p6kd.xn--l0b810j", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-z0d801p6kd\.xn\-\-l0b810j\'\)\ throws\ error\ B1\ V3\ V6\ \[data\/IdnaTest\.txt\:4049\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-｡䏛", %p)},	undef,	"to_ascii\(\'\-｡䏛\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:4050\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-。䏛", %p)},	undef,	"to_ascii\(\'\-\。䏛\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:4051\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-.xn--xco", %p)},	undef,	"to_ascii\(\'\-\.xn\-\-xco\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:4052\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}񒃠．\x{200D}", %p)},	undef,	"to_ascii\(\'\\u200C\?．\\u200D\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4053\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}񒃠.\x{200D}", %p)},	undef,	"to_ascii\(\'\\u200C\?\.\\u200D\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4055\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--dj8y.", %p)},	undef,	"to_ascii\(\'xn\-\-dj8y\.\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:4057\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--0ugz7551c.xn--1ug", %p)},	undef,	"to_ascii\(\'xn\-\-0ugz7551c\.xn\-\-1ug\'\)\ throws\ error\ C1\ C2\ V6\ \[data\/IdnaTest\.txt\:4058\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⒈⓰󥣇｡𐹠\x{200D}򗷦Ⴕ", %p)},	undef,	"to_ascii\(\'⒈⓰\?｡𐹠\\u200D\?Ⴕ\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:4059\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("1.⓰󥣇。𐹠\x{200D}򗷦Ⴕ", %p)},	undef,	"to_ascii\(\'1\.⓰\?\。𐹠\\u200D\?Ⴕ\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:4061\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("1.⓰󥣇。𐹠\x{200D}򗷦ⴕ", %p)},	undef,	"to_ascii\(\'1\.⓰\?\。𐹠\\u200D\?ⴕ\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:4063\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("1.xn--svh00804k.xn--dljv223ee5t2d", %p)},	undef,	"to_ascii\(\'1\.xn\-\-svh00804k\.xn\-\-dljv223ee5t2d\'\)\ throws\ error\ B1\ V6\ \[data\/IdnaTest\.txt\:4065\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("1.xn--svh00804k.xn--1ug352csp0psg45e", %p)},	undef,	"to_ascii\(\'1\.xn\-\-svh00804k\.xn\-\-1ug352csp0psg45e\'\)\ throws\ error\ B1\ C2\ V6\ \[data\/IdnaTest\.txt\:4066\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("1.xn--svh00804k.xn--tnd1990ke579c", %p)},	undef,	"to_ascii\(\'1\.xn\-\-svh00804k\.xn\-\-tnd1990ke579c\'\)\ throws\ error\ B1\ V6\ \[data\/IdnaTest\.txt\:4067\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("1.xn--svh00804k.xn--tnd969erj4psgl3e", %p)},	undef,	"to_ascii\(\'1\.xn\-\-svh00804k\.xn\-\-tnd969erj4psgl3e\'\)\ throws\ error\ B1\ C2\ V6\ \[data\/IdnaTest\.txt\:4068\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⒈⓰󥣇｡𐹠\x{200D}򗷦ⴕ", %p)},	undef,	"to_ascii\(\'⒈⓰\?｡𐹠\\u200D\?ⴕ\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:4069\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--tsh0nz9380h.xn--dljv223ee5t2d", %p)},	undef,	"to_ascii\(\'xn\-\-tsh0nz9380h\.xn\-\-dljv223ee5t2d\'\)\ throws\ error\ B1\ V6\ \[data\/IdnaTest\.txt\:4071\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--tsh0nz9380h.xn--1ug352csp0psg45e", %p)},	undef,	"to_ascii\(\'xn\-\-tsh0nz9380h\.xn\-\-1ug352csp0psg45e\'\)\ throws\ error\ B1\ C2\ V6\ \[data\/IdnaTest\.txt\:4072\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--tsh0nz9380h.xn--tnd1990ke579c", %p)},	undef,	"to_ascii\(\'xn\-\-tsh0nz9380h\.xn\-\-tnd1990ke579c\'\)\ throws\ error\ B1\ V6\ \[data\/IdnaTest\.txt\:4073\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--tsh0nz9380h.xn--tnd969erj4psgl3e", %p)},	undef,	"to_ascii\(\'xn\-\-tsh0nz9380h\.xn\-\-tnd969erj4psgl3e\'\)\ throws\ error\ B1\ C2\ V6\ \[data\/IdnaTest\.txt\:4074\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𞠊ᠮ-ß｡\x{1CD0}効\x{0601}𷣭", %p)},	undef,	"to_ascii\(\'𞠊ᠮ\-ß｡\\u1CD0効\\u0601\?\'\)\ throws\ error\ B1\ B2\ B3\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4075\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𞠊ᠮ-ß。\x{1CD0}効\x{0601}𷣭", %p)},	undef,	"to_ascii\(\'𞠊ᠮ\-ß\。\\u1CD0効\\u0601\?\'\)\ throws\ error\ B1\ B2\ B3\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4077\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𞠊ᠮ-SS。\x{1CD0}効\x{0601}𷣭", %p)},	undef,	"to_ascii\(\'𞠊ᠮ\-SS\。\\u1CD0効\\u0601\?\'\)\ throws\ error\ B1\ B2\ B3\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4079\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𞠊ᠮ-ss。\x{1CD0}効\x{0601}𷣭", %p)},	undef,	"to_ascii\(\'𞠊ᠮ\-ss\。\\u1CD0効\\u0601\?\'\)\ throws\ error\ B1\ B2\ B3\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4080\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𞠊ᠮ-Ss。\x{1CD0}効\x{0601}𷣭", %p)},	undef,	"to_ascii\(\'𞠊ᠮ\-Ss\。\\u1CD0効\\u0601\?\'\)\ throws\ error\ B1\ B2\ B3\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4081\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn---ss-21t18904a.xn--jfb197i791bi6x4c", %p)},	undef,	"to_ascii\(\'xn\-\-\-ss\-21t18904a\.xn\-\-jfb197i791bi6x4c\'\)\ throws\ error\ B1\ B2\ B3\ V5\ V6\ \[data\/IdnaTest\.txt\:4082\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----qfa310pg973b.xn--jfb197i791bi6x4c", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-qfa310pg973b\.xn\-\-jfb197i791bi6x4c\'\)\ throws\ error\ B1\ B2\ B3\ V5\ V6\ \[data\/IdnaTest\.txt\:4083\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𞠊ᠮ-SS｡\x{1CD0}効\x{0601}𷣭", %p)},	undef,	"to_ascii\(\'𞠊ᠮ\-SS｡\\u1CD0効\\u0601\?\'\)\ throws\ error\ B1\ B2\ B3\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4084\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𞠊ᠮ-ss｡\x{1CD0}効\x{0601}𷣭", %p)},	undef,	"to_ascii\(\'𞠊ᠮ\-ss｡\\u1CD0効\\u0601\?\'\)\ throws\ error\ B1\ B2\ B3\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4085\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𞠊ᠮ-Ss｡\x{1CD0}効\x{0601}𷣭", %p)},	undef,	"to_ascii\(\'𞠊ᠮ\-Ss｡\\u1CD0効\\u0601\?\'\)\ throws\ error\ B1\ B2\ B3\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4086\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𑇀.󠨱", %p)},	undef,	"to_ascii\(\'𑇀\.\?\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4087\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--wd1d.xn--k946e", %p)},	undef,	"to_ascii\(\'xn\-\-wd1d\.xn\-\-k946e\'\)\ throws\ error\ V5\ V6\ \[data\/IdnaTest\.txt\:4088\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("␒3\x{FB88}｡𝟘𐨿𐹆", %p)},	undef,	"to_ascii\(\'\␒3\\uFB88｡𝟘𐨿\?\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:4089\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("␒3\x{0688}。0𐨿𐹆", %p)},	undef,	"to_ascii\(\'\␒3\\u0688\。0𐨿\?\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:4090\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--3-jsc897t.xn--0-sc5iy3h", %p)},	undef,	"to_ascii\(\'xn\-\-3\-jsc897t\.xn\-\-0\-sc5iy3h\'\)\ throws\ error\ B1\ V6\ \[data\/IdnaTest\.txt\:4091\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_ascii("\x{076B}６\x{0A81}\x{08A6}。\x{1DE3}", %p)},	undef,	"to_ascii\(\'\\u076B６\\u0A81\\u08A6\。\\u1DE3\'\)\ throws\ error\ B1\ B3\ B6\ V5\ \[data\/IdnaTest\.txt\:4092\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_ascii("\x{076B}6\x{0A81}\x{08A6}。\x{1DE3}", %p)},	undef,	"to_ascii\(\'\\u076B6\\u0A81\\u08A6\。\\u1DE3\'\)\ throws\ error\ B1\ B3\ B6\ V5\ \[data\/IdnaTest\.txt\:4093\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--6-h5c06gj6c.xn--7eg", %p)},	undef,	"to_ascii\(\'xn\-\-6\-h5c06gj6c\.xn\-\-7eg\'\)\ throws\ error\ B1\ B3\ B6\ V5\ \[data\/IdnaTest\.txt\:4094\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0605}-𽤞Ⴂ。򅤶\x{200D}", %p)},	undef,	"to_ascii\(\'\\u0605\-\?Ⴂ\。\?\\u200D\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:4095\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0605}-𽤞ⴂ。򅤶\x{200D}", %p)},	undef,	"to_ascii\(\'\\u0605\-\?ⴂ\。\?\\u200D\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:4097\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----0kc8501a5399e.xn--ss06b", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-0kc8501a5399e\.xn\-\-ss06b\'\)\ throws\ error\ B1\ V6\ \[data\/IdnaTest\.txt\:4099\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----0kc8501a5399e.xn--1ugy3204f", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-0kc8501a5399e\.xn\-\-1ugy3204f\'\)\ throws\ error\ B1\ B6\ C2\ V6\ \[data\/IdnaTest\.txt\:4100\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----0kc662fc152h.xn--ss06b", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-0kc662fc152h\.xn\-\-ss06b\'\)\ throws\ error\ B1\ V6\ \[data\/IdnaTest\.txt\:4101\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----0kc662fc152h.xn--1ugy3204f", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-0kc662fc152h\.xn\-\-1ugy3204f\'\)\ throws\ error\ B1\ B6\ C2\ V6\ \[data\/IdnaTest\.txt\:4102\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⾆．ꡈ５≯ß", %p)},	undef,	"to_ascii\(\'⾆．ꡈ５\≯ß\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4103\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⾆．ꡈ５>\x{0338}ß", %p)},	undef,	"to_ascii\(\'⾆．ꡈ５\>\\u0338ß\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4105\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("舌.ꡈ5≯ß", %p)},	undef,	"to_ascii\(\'舌\.ꡈ5\≯ß\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4107\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("舌.ꡈ5>\x{0338}ß", %p)},	undef,	"to_ascii\(\'舌\.ꡈ5\>\\u0338ß\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4109\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("舌.ꡈ5>\x{0338}SS", %p)},	undef,	"to_ascii\(\'舌\.ꡈ5\>\\u0338SS\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4111\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("舌.ꡈ5≯SS", %p)},	undef,	"to_ascii\(\'舌\.ꡈ5\≯SS\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4112\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("舌.ꡈ5≯ss", %p)},	undef,	"to_ascii\(\'舌\.ꡈ5\≯ss\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4113\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("舌.ꡈ5>\x{0338}ss", %p)},	undef,	"to_ascii\(\'舌\.ꡈ5\>\\u0338ss\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4114\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("舌.ꡈ5>\x{0338}Ss", %p)},	undef,	"to_ascii\(\'舌\.ꡈ5\>\\u0338Ss\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4115\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("舌.ꡈ5≯Ss", %p)},	undef,	"to_ascii\(\'舌\.ꡈ5\≯Ss\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4116\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--tc1a.xn--5ss-3m2a5009e", %p)},	undef,	"to_ascii\(\'xn\-\-tc1a\.xn\-\-5ss\-3m2a5009e\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:4117\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--tc1a.xn--5-qfa988w745i", %p)},	undef,	"to_ascii\(\'xn\-\-tc1a\.xn\-\-5\-qfa988w745i\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:4118\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⾆．ꡈ５>\x{0338}SS", %p)},	undef,	"to_ascii\(\'⾆．ꡈ５\>\\u0338SS\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4119\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⾆．ꡈ５≯SS", %p)},	undef,	"to_ascii\(\'⾆．ꡈ５\≯SS\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4120\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⾆．ꡈ５≯ss", %p)},	undef,	"to_ascii\(\'⾆．ꡈ５\≯ss\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4121\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⾆．ꡈ５>\x{0338}ss", %p)},	undef,	"to_ascii\(\'⾆．ꡈ５\>\\u0338ss\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4122\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⾆．ꡈ５>\x{0338}Ss", %p)},	undef,	"to_ascii\(\'⾆．ꡈ５\>\\u0338Ss\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4123\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⾆．ꡈ５≯Ss", %p)},	undef,	"to_ascii\(\'⾆．ꡈ５\≯Ss\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4124\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0ACD}8\x{200D}．򾂈\x{075C}", %p)},	undef,	"to_ascii\(\'\\u0ACD8\\u200D．\?\\u075C\'\)\ throws\ error\ B1\ B5\ B6\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4125\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0ACD}8\x{200D}.򾂈\x{075C}", %p)},	undef,	"to_ascii\(\'\\u0ACD8\\u200D\.\?\\u075C\'\)\ throws\ error\ B1\ B5\ B6\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4127\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--8-yke.xn--gpb79046m", %p)},	undef,	"to_ascii\(\'xn\-\-8\-yke\.xn\-\-gpb79046m\'\)\ throws\ error\ B1\ B5\ B6\ V5\ V6\ \[data\/IdnaTest\.txt\:4129\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--8-yke534n.xn--gpb79046m", %p)},	undef,	"to_ascii\(\'xn\-\-8\-yke534n\.xn\-\-gpb79046m\'\)\ throws\ error\ B1\ B5\ B6\ C2\ V5\ V6\ \[data\/IdnaTest\.txt\:4130\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򸷆\x{0A70}≮򹓙．񞎧⁷󠯙\x{06B6}", %p)},	undef,	"to_ascii\(\'\?\\u0A70\≮\?．\?⁷\?\\u06B6\'\)\ throws\ error\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:4131\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򸷆\x{0A70}<\x{0338}򹓙．񞎧⁷󠯙\x{06B6}", %p)},	undef,	"to_ascii\(\'\?\\u0A70\<\\u0338\?．\?⁷\?\\u06B6\'\)\ throws\ error\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:4132\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򸷆\x{0A70}≮򹓙.񞎧7󠯙\x{06B6}", %p)},	undef,	"to_ascii\(\'\?\\u0A70\≮\?\.\?7\?\\u06B6\'\)\ throws\ error\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:4133\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򸷆\x{0A70}<\x{0338}򹓙.񞎧7󠯙\x{06B6}", %p)},	undef,	"to_ascii\(\'\?\\u0A70\<\\u0338\?\.\?7\?\\u06B6\'\)\ throws\ error\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:4134\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--ycc893jqh38rb6fa.xn--7-5uc53836ixt41c", %p)},	undef,	"to_ascii\(\'xn\-\-ycc893jqh38rb6fa\.xn\-\-7\-5uc53836ixt41c\'\)\ throws\ error\ B5\ B6\ V6\ \[data\/IdnaTest\.txt\:4135\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("𞤪.ς", %p)},	"xn--ie6h.xn--4xa",	"to_ascii\(\'𞤪\.ς\'\)\ \[data\/IdnaTest\.txt\:4136\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("𞤈.Σ", %p)},	"xn--ie6h.xn--4xa",	"to_ascii\(\'𞤈\.Σ\'\)\ \[data\/IdnaTest\.txt\:4138\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("𞤪.σ", %p)},	"xn--ie6h.xn--4xa",	"to_ascii\(\'𞤪\.σ\'\)\ \[data\/IdnaTest\.txt\:4139\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("𞤈.σ", %p)},	"xn--ie6h.xn--4xa",	"to_ascii\(\'𞤈\.σ\'\)\ \[data\/IdnaTest\.txt\:4140\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("xn--ie6h.xn--4xa", %p)},	"xn--ie6h.xn--4xa",	"to_ascii\(\'xn\-\-ie6h\.xn\-\-4xa\'\)\ \[data\/IdnaTest\.txt\:4141\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("𞤈.ς", %p)},	"xn--ie6h.xn--4xa",	"to_ascii\(\'𞤈\.ς\'\)\ \[data\/IdnaTest\.txt\:4142\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("xn--ie6h.xn--3xa", %p)},	"xn--ie6h.xn--3xa",	"to_ascii\(\'xn\-\-ie6h\.xn\-\-3xa\'\)\ \[data\/IdnaTest\.txt\:4144\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("𞤪.Σ", %p)},	"xn--ie6h.xn--4xa",	"to_ascii\(\'𞤪\.Σ\'\)\ \[data\/IdnaTest\.txt\:4145\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("\x{200C}Ⴚ｡ς", %p)},	undef,	"to_ascii\(\'\\u200CႺ｡ς\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4146\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}Ⴚ。ς", %p)},	undef,	"to_ascii\(\'\\u200CႺ\。ς\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4148\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("\x{200C}ⴚ。ς", %p)},	"xn--ilj.xn--4xa",	"to_ascii\(\'\\u200Cⴚ\。ς\'\)\ \[data\/IdnaTest\.txt\:4150\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("\x{200C}Ⴚ。Σ", %p)},	undef,	"to_ascii\(\'\\u200CႺ\。Σ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4152\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("\x{200C}ⴚ。σ", %p)},	"xn--ilj.xn--4xa",	"to_ascii\(\'\\u200Cⴚ\。σ\'\)\ \[data\/IdnaTest\.txt\:4154\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("xn--ilj.xn--4xa", %p)},	"xn--ilj.xn--4xa",	"to_ascii\(\'xn\-\-ilj\.xn\-\-4xa\'\)\ \[data\/IdnaTest\.txt\:4156\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("ⴚ.σ", %p)},	"xn--ilj.xn--4xa",	"to_ascii\(\'ⴚ\.σ\'\)\ \[data\/IdnaTest\.txt\:4157\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("Ⴚ.Σ", %p)},	undef,	"to_ascii\(\'Ⴚ\.Σ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4158\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("ⴚ.ς", %p)},	"xn--ilj.xn--4xa",	"to_ascii\(\'ⴚ\.ς\'\)\ \[data\/IdnaTest\.txt\:4159\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("Ⴚ.ς", %p)},	undef,	"to_ascii\(\'Ⴚ\.ς\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4161\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--ynd.xn--4xa", %p)},	undef,	"to_ascii\(\'xn\-\-ynd\.xn\-\-4xa\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:4163\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--ynd.xn--3xa", %p)},	undef,	"to_ascii\(\'xn\-\-ynd\.xn\-\-3xa\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:4164\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("xn--ilj.xn--3xa", %p)},	"xn--ilj.xn--3xa",	"to_ascii\(\'xn\-\-ilj\.xn\-\-3xa\'\)\ \[data\/IdnaTest\.txt\:4165\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("Ⴚ.σ", %p)},	undef,	"to_ascii\(\'Ⴚ\.σ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4166\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--0ug262c.xn--4xa", %p)},	undef,	"to_ascii\(\'xn\-\-0ug262c\.xn\-\-4xa\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:4167\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--ynd759e.xn--4xa", %p)},	undef,	"to_ascii\(\'xn\-\-ynd759e\.xn\-\-4xa\'\)\ throws\ error\ C1\ V6\ \[data\/IdnaTest\.txt\:4168\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--0ug262c.xn--3xa", %p)},	undef,	"to_ascii\(\'xn\-\-0ug262c\.xn\-\-3xa\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:4169\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--ynd759e.xn--3xa", %p)},	undef,	"to_ascii\(\'xn\-\-ynd759e\.xn\-\-3xa\'\)\ throws\ error\ C1\ V6\ \[data\/IdnaTest\.txt\:4170\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("\x{200C}ⴚ｡ς", %p)},	"xn--ilj.xn--4xa",	"to_ascii\(\'\\u200Cⴚ｡ς\'\)\ \[data\/IdnaTest\.txt\:4171\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("\x{200C}Ⴚ｡Σ", %p)},	undef,	"to_ascii\(\'\\u200CႺ｡Σ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4173\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("\x{200C}ⴚ｡σ", %p)},	"xn--ilj.xn--4xa",	"to_ascii\(\'\\u200Cⴚ｡σ\'\)\ \[data\/IdnaTest\.txt\:4175\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("𞤃．𐹦", %p)},	undef,	"to_ascii\(\'𞤃．𐹦\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:4177\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("𞤃.𐹦", %p)},	undef,	"to_ascii\(\'𞤃\.𐹦\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:4178\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("𞤥.𐹦", %p)},	undef,	"to_ascii\(\'𞤥\.𐹦\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:4179\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--de6h.xn--eo0d", %p)},	undef,	"to_ascii\(\'xn\-\-de6h\.xn\-\-eo0d\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:4180\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("𞤥．𐹦", %p)},	undef,	"to_ascii\(\'𞤥．𐹦\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:4181\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_ascii("\x{200D}⾕。\x{200C}\x{0310}\x{A953}ꡎ", %p)},	undef,	"to_ascii\(\'\\u200D⾕\。\\u200C\\u0310\\uA953ꡎ\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:4182\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_ascii("\x{200D}⾕。\x{200C}\x{A953}\x{0310}ꡎ", %p)},	undef,	"to_ascii\(\'\\u200D⾕\。\\u200C\\uA953\\u0310ꡎ\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:4184\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_ascii("\x{200D}谷。\x{200C}\x{A953}\x{0310}ꡎ", %p)},	undef,	"to_ascii\(\'\\u200D谷\。\\u200C\\uA953\\u0310ꡎ\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:4186\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--6g3a.xn--0sa8175flwa", %p)},	undef,	"to_ascii\(\'xn\-\-6g3a\.xn\-\-0sa8175flwa\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:4188\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--1ug0273b.xn--0sa359l6n7g13a", %p)},	undef,	"to_ascii\(\'xn\-\-1ug0273b\.xn\-\-0sa359l6n7g13a\'\)\ throws\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:4189\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("\x{06AA}-뉔．𞤐\x{200C}", %p)},	undef,	"to_ascii\(\'\\u06AA\-뉔．𞤐\\u200C\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:4190\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("\x{06AA}-뉔．𞤐\x{200C}", %p)},	undef,	"to_ascii\(\'\\u06AA\-뉔．𞤐\\u200C\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:4192\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("\x{06AA}-뉔.𞤐\x{200C}", %p)},	undef,	"to_ascii\(\'\\u06AA\-뉔\.𞤐\\u200C\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:4194\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("\x{06AA}-뉔.𞤐\x{200C}", %p)},	undef,	"to_ascii\(\'\\u06AA\-뉔\.𞤐\\u200C\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:4196\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("\x{06AA}-뉔.𞤲\x{200C}", %p)},	undef,	"to_ascii\(\'\\u06AA\-뉔\.𞤲\\u200C\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:4198\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("\x{06AA}-뉔.𞤲\x{200C}", %p)},	undef,	"to_ascii\(\'\\u06AA\-뉔\.𞤲\\u200C\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:4200\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn----guc3592k.xn--qe6h", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-guc3592k\.xn\-\-qe6h\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:4202\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----guc3592k.xn--0ug7611p", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-guc3592k\.xn\-\-0ug7611p\'\)\ throws\ error\ B2\ B3\ C1\ \[data\/IdnaTest\.txt\:4203\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("\x{06AA}-뉔．𞤲\x{200C}", %p)},	undef,	"to_ascii\(\'\\u06AA\-뉔．𞤲\\u200C\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:4204\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("\x{06AA}-뉔．𞤲\x{200C}", %p)},	undef,	"to_ascii\(\'\\u06AA\-뉔．𞤲\\u200C\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:4206\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("񔲵５ᦛς.\x{A8C4}\x{077B}\x{1CD2}\x{0738}", %p)},	undef,	"to_ascii\(\'\?５ᦛς\.\\uA8C4\\u077B\\u1CD2\\u0738\'\)\ throws\ error\ B1\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4208\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񔲵５ᦛς.\x{A8C4}\x{077B}\x{0738}\x{1CD2}", %p)},	undef,	"to_ascii\(\'\?５ᦛς\.\\uA8C4\\u077B\\u0738\\u1CD2\'\)\ throws\ error\ B1\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4210\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񔲵5ᦛς.\x{A8C4}\x{077B}\x{0738}\x{1CD2}", %p)},	undef,	"to_ascii\(\'\?5ᦛς\.\\uA8C4\\u077B\\u0738\\u1CD2\'\)\ throws\ error\ B1\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4212\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񔲵5ᦛΣ.\x{A8C4}\x{077B}\x{0738}\x{1CD2}", %p)},	undef,	"to_ascii\(\'\?5ᦛΣ\.\\uA8C4\\u077B\\u0738\\u1CD2\'\)\ throws\ error\ B1\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4214\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񔲵5ᦛσ.\x{A8C4}\x{077B}\x{0738}\x{1CD2}", %p)},	undef,	"to_ascii\(\'\?5ᦛσ\.\\uA8C4\\u077B\\u0738\\u1CD2\'\)\ throws\ error\ B1\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4215\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--5-0mb988ng603j.xn--fob7kk44dl41k", %p)},	undef,	"to_ascii\(\'xn\-\-5\-0mb988ng603j\.xn\-\-fob7kk44dl41k\'\)\ throws\ error\ B1\ V5\ V6\ \[data\/IdnaTest\.txt\:4216\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--5-ymb298ng603j.xn--fob7kk44dl41k", %p)},	undef,	"to_ascii\(\'xn\-\-5\-ymb298ng603j\.xn\-\-fob7kk44dl41k\'\)\ throws\ error\ B1\ V5\ V6\ \[data\/IdnaTest\.txt\:4217\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񔲵５ᦛΣ.\x{A8C4}\x{077B}\x{0738}\x{1CD2}", %p)},	undef,	"to_ascii\(\'\?５ᦛΣ\.\\uA8C4\\u077B\\u0738\\u1CD2\'\)\ throws\ error\ B1\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4218\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񔲵５ᦛσ.\x{A8C4}\x{077B}\x{0738}\x{1CD2}", %p)},	undef,	"to_ascii\(\'\?５ᦛσ\.\\uA8C4\\u077B\\u0738\\u1CD2\'\)\ throws\ error\ B1\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4219\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񔲵５ᦛΣ.\x{A8C4}\x{077B}\x{1CD2}\x{0738}", %p)},	undef,	"to_ascii\(\'\?５ᦛΣ\.\\uA8C4\\u077B\\u1CD2\\u0738\'\)\ throws\ error\ B1\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4220\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񔲵５ᦛσ.\x{A8C4}\x{077B}\x{1CD2}\x{0738}", %p)},	undef,	"to_ascii\(\'\?５ᦛσ\.\\uA8C4\\u077B\\u1CD2\\u0738\'\)\ throws\ error\ B1\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4221\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("淽。ᠾ", %p)},	"xn--34w.xn--x7e",	"to_ascii\(\'淽\。ᠾ\'\)\ \[data\/IdnaTest\.txt\:4222\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--34w.xn--x7e", %p)},	"xn--34w.xn--x7e",	"to_ascii\(\'xn\-\-34w\.xn\-\-x7e\'\)\ \[data\/IdnaTest\.txt\:4223\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("淽.ᠾ", %p)},	"xn--34w.xn--x7e",	"to_ascii\(\'淽\.ᠾ\'\)\ \[data\/IdnaTest\.txt\:4224\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("𐹴𑘷。-", %p)},	undef,	"to_ascii\(\'𐹴𑘷\。\-\'\)\ throws\ error\ B1\ V3\ \[data\/IdnaTest\.txt\:4225\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--so0do6k.-", %p)},	undef,	"to_ascii\(\'xn\-\-so0do6k\.\-\'\)\ throws\ error\ B1\ V3\ \[data\/IdnaTest\.txt\:4226\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򬨩Ⴓ❓｡𑄨", %p)},	undef,	"to_ascii\(\'\?Ⴓ\❓｡𑄨\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4227\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򬨩Ⴓ❓。𑄨", %p)},	undef,	"to_ascii\(\'\?Ⴓ\❓\。𑄨\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4228\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򬨩ⴓ❓。𑄨", %p)},	undef,	"to_ascii\(\'\?ⴓ\❓\。𑄨\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4229\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--8di78qvw32y.xn--k80d", %p)},	undef,	"to_ascii\(\'xn\-\-8di78qvw32y\.xn\-\-k80d\'\)\ throws\ error\ V5\ V6\ \[data\/IdnaTest\.txt\:4230\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--rnd896i0j14q.xn--k80d", %p)},	undef,	"to_ascii\(\'xn\-\-rnd896i0j14q\.xn\-\-k80d\'\)\ throws\ error\ V5\ V6\ \[data\/IdnaTest\.txt\:4231\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򬨩ⴓ❓｡𑄨", %p)},	undef,	"to_ascii\(\'\?ⴓ\❓｡𑄨\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4232\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}𐹡𞤌Ⴇ｡ßႣ", %p)},	undef,	"to_ascii\(\'\\u200C𐹡𞤌Ⴇ｡ßႣ\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:4233\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}𐹡𞤌Ⴇ。ßႣ", %p)},	undef,	"to_ascii\(\'\\u200C𐹡𞤌Ⴇ\。ßႣ\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:4235\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("\x{200C}𐹡𞤮ⴇ。ßⴃ", %p)},	undef,	"to_ascii\(\'\\u200C𐹡𞤮ⴇ\。ßⴃ\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:4237\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("\x{200C}𐹡𞤌Ⴇ。SSႣ", %p)},	undef,	"to_ascii\(\'\\u200C𐹡𞤌Ⴇ\。SSႣ\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:4239\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("\x{200C}𐹡𞤮ⴇ。ssⴃ", %p)},	undef,	"to_ascii\(\'\\u200C𐹡𞤮ⴇ\。ssⴃ\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:4241\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("\x{200C}𐹡𞤌ⴇ。Ssⴃ", %p)},	undef,	"to_ascii\(\'\\u200C𐹡𞤌ⴇ\。Ssⴃ\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:4243\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--ykj9323eegwf.xn--ss-151a", %p)},	undef,	"to_ascii\(\'xn\-\-ykj9323eegwf\.xn\-\-ss\-151a\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:4245\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--0ug332c3q0pr56g.xn--ss-151a", %p)},	undef,	"to_ascii\(\'xn\-\-0ug332c3q0pr56g\.xn\-\-ss\-151a\'\)\ throws\ error\ B1\ C1\ \[data\/IdnaTest\.txt\:4246\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--fnd1201kegrf.xn--ss-fek", %p)},	undef,	"to_ascii\(\'xn\-\-fnd1201kegrf\.xn\-\-ss\-fek\'\)\ throws\ error\ B1\ V6\ \[data\/IdnaTest\.txt\:4247\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--fnd599eyj4pr50g.xn--ss-fek", %p)},	undef,	"to_ascii\(\'xn\-\-fnd599eyj4pr50g\.xn\-\-ss\-fek\'\)\ throws\ error\ B1\ C1\ V6\ \[data\/IdnaTest\.txt\:4248\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--0ug332c3q0pr56g.xn--zca417t", %p)},	undef,	"to_ascii\(\'xn\-\-0ug332c3q0pr56g\.xn\-\-zca417t\'\)\ throws\ error\ B1\ C1\ \[data\/IdnaTest\.txt\:4249\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--fnd599eyj4pr50g.xn--zca681f", %p)},	undef,	"to_ascii\(\'xn\-\-fnd599eyj4pr50g\.xn\-\-zca681f\'\)\ throws\ error\ B1\ C1\ V6\ \[data\/IdnaTest\.txt\:4250\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("\x{200C}𐹡𞤮ⴇ｡ßⴃ", %p)},	undef,	"to_ascii\(\'\\u200C𐹡𞤮ⴇ｡ßⴃ\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:4251\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("\x{200C}𐹡𞤌Ⴇ｡SSႣ", %p)},	undef,	"to_ascii\(\'\\u200C𐹡𞤌Ⴇ｡SSႣ\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:4253\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("\x{200C}𐹡𞤮ⴇ｡ssⴃ", %p)},	undef,	"to_ascii\(\'\\u200C𐹡𞤮ⴇ｡ssⴃ\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:4255\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("\x{200C}𐹡𞤌ⴇ｡Ssⴃ", %p)},	undef,	"to_ascii\(\'\\u200C𐹡𞤌ⴇ｡Ssⴃ\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:4257\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("\x{200C}𐹡𞤌ⴇ。ßⴃ", %p)},	undef,	"to_ascii\(\'\\u200C𐹡𞤌ⴇ\。ßⴃ\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:4259\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("\x{200C}𐹡𞤌ⴇ。ssⴃ", %p)},	undef,	"to_ascii\(\'\\u200C𐹡𞤌ⴇ\。ssⴃ\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:4261\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("\x{200C}𐹡𞤌Ⴇ。Ssⴃ", %p)},	undef,	"to_ascii\(\'\\u200C𐹡𞤌Ⴇ\。Ssⴃ\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:4263\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--fnd1201kegrf.xn--ss-151a", %p)},	undef,	"to_ascii\(\'xn\-\-fnd1201kegrf\.xn\-\-ss\-151a\'\)\ throws\ error\ B1\ V6\ \[data\/IdnaTest\.txt\:4265\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--fnd599eyj4pr50g.xn--ss-151a", %p)},	undef,	"to_ascii\(\'xn\-\-fnd599eyj4pr50g\.xn\-\-ss\-151a\'\)\ throws\ error\ B1\ C1\ V6\ \[data\/IdnaTest\.txt\:4266\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("\x{200C}𐹡𞤌ⴇ｡ßⴃ", %p)},	undef,	"to_ascii\(\'\\u200C𐹡𞤌ⴇ｡ßⴃ\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:4267\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("\x{200C}𐹡𞤌ⴇ｡ssⴃ", %p)},	undef,	"to_ascii\(\'\\u200C𐹡𞤌ⴇ｡ssⴃ\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:4269\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("\x{200C}𐹡𞤌Ⴇ｡Ssⴃ", %p)},	undef,	"to_ascii\(\'\\u200C𐹡𞤌Ⴇ｡Ssⴃ\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:4271\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{17FF}｡𞬳", %p)},	undef,	"to_ascii\(\'\\u17FF｡\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4273\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{17FF}。𞬳", %p)},	undef,	"to_ascii\(\'\\u17FF\。\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4274\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--45e.xn--et6h", %p)},	undef,	"to_ascii\(\'xn\-\-45e\.xn\-\-et6h\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:4275\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_ascii("\x{0652}\x{200D}｡\x{0CCD}𑚳", %p)},	undef,	"to_ascii\(\'\\u0652\\u200D｡\\u0CCD𑚳\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:4276\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_ascii("\x{0652}\x{200D}。\x{0CCD}𑚳", %p)},	undef,	"to_ascii\(\'\\u0652\\u200D\。\\u0CCD𑚳\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:4278\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--uhb.xn--8tc4527k", %p)},	undef,	"to_ascii\(\'xn\-\-uhb\.xn\-\-8tc4527k\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:4280\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--uhb882k.xn--8tc4527k", %p)},	undef,	"to_ascii\(\'xn\-\-uhb882k\.xn\-\-8tc4527k\'\)\ throws\ error\ C2\ V5\ \[data\/IdnaTest\.txt\:4281\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-≠ᠻ．\x{076D}𞥃≮󟷺", %p)},	undef,	"to_ascii\(\'\-\≠ᠻ．\\u076D𞥃\≮\?\'\)\ throws\ error\ B1\ B2\ B3\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:4282\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-=\x{0338}ᠻ．\x{076D}𞥃<\x{0338}󟷺", %p)},	undef,	"to_ascii\(\'\-\=\\u0338ᠻ．\\u076D𞥃\<\\u0338\?\'\)\ throws\ error\ B1\ B2\ B3\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:4283\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-≠ᠻ.\x{076D}𞥃≮󟷺", %p)},	undef,	"to_ascii\(\'\-\≠ᠻ\.\\u076D𞥃\≮\?\'\)\ throws\ error\ B1\ B2\ B3\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:4284\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-=\x{0338}ᠻ.\x{076D}𞥃<\x{0338}󟷺", %p)},	undef,	"to_ascii\(\'\-\=\\u0338ᠻ\.\\u076D𞥃\<\\u0338\?\'\)\ throws\ error\ B1\ B2\ B3\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:4285\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-=\x{0338}ᠻ.\x{076D}𞤡<\x{0338}󟷺", %p)},	undef,	"to_ascii\(\'\-\=\\u0338ᠻ\.\\u076D𞤡\<\\u0338\?\'\)\ throws\ error\ B1\ B2\ B3\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:4286\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-≠ᠻ.\x{076D}𞤡≮󟷺", %p)},	undef,	"to_ascii\(\'\-\≠ᠻ\.\\u076D𞤡\≮\?\'\)\ throws\ error\ B1\ B2\ B3\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:4287\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----g6j886c.xn--xpb049kk353abj99f", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-g6j886c\.xn\-\-xpb049kk353abj99f\'\)\ throws\ error\ B1\ B2\ B3\ V3\ V6\ \[data\/IdnaTest\.txt\:4288\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-=\x{0338}ᠻ．\x{076D}𞤡<\x{0338}󟷺", %p)},	undef,	"to_ascii\(\'\-\=\\u0338ᠻ．\\u076D𞤡\<\\u0338\?\'\)\ throws\ error\ B1\ B2\ B3\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:4289\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-≠ᠻ．\x{076D}𞤡≮󟷺", %p)},	undef,	"to_ascii\(\'\-\≠ᠻ．\\u076D𞤡\≮\?\'\)\ throws\ error\ B1\ B2\ B3\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:4290\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠰆≯\x{07B5}𐻪．򊥕≮𑁆\x{084C}", %p)},	undef,	"to_ascii\(\'\?\≯\\u07B5\?．\?\≮𑁆\\u084C\'\)\ throws\ error\ B1\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:4291\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠰆>\x{0338}\x{07B5}𐻪．򊥕<\x{0338}𑁆\x{084C}", %p)},	undef,	"to_ascii\(\'\?\>\\u0338\\u07B5\?．\?\<\\u0338𑁆\\u084C\'\)\ throws\ error\ B1\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:4292\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠰆≯\x{07B5}𐻪.򊥕≮𑁆\x{084C}", %p)},	undef,	"to_ascii\(\'\?\≯\\u07B5\?\.\?\≮𑁆\\u084C\'\)\ throws\ error\ B1\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:4293\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠰆>\x{0338}\x{07B5}𐻪.򊥕<\x{0338}𑁆\x{084C}", %p)},	undef,	"to_ascii\(\'\?\>\\u0338\\u07B5\?\.\?\<\\u0338𑁆\\u084C\'\)\ throws\ error\ B1\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:4294\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--zrb797kdm1oes34i.xn--bwb394k8k2o25n6d", %p)},	undef,	"to_ascii\(\'xn\-\-zrb797kdm1oes34i\.xn\-\-bwb394k8k2o25n6d\'\)\ throws\ error\ B1\ B5\ B6\ V6\ \[data\/IdnaTest\.txt\:4295\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≠󦋂.\x{0600}\x{0BCD}-\x{06B9}", %p)},	undef,	"to_ascii\(\'\≠\?\.\\u0600\\u0BCD\-\\u06B9\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:4296\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("=\x{0338}󦋂.\x{0600}\x{0BCD}-\x{06B9}", %p)},	undef,	"to_ascii\(\'\=\\u0338\?\.\\u0600\\u0BCD\-\\u06B9\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:4297\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--1ch22084l.xn----qkc07co6n", %p)},	undef,	"to_ascii\(\'xn\-\-1ch22084l\.xn\-\-\-\-qkc07co6n\'\)\ throws\ error\ B1\ V6\ \[data\/IdnaTest\.txt\:4298\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{17DD}󠁣≠｡𐹼𐋤", %p)},	undef,	"to_ascii\(\'\\u17DD\?\≠｡𐹼𐋤\'\)\ throws\ error\ B1\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4299\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{17DD}󠁣=\x{0338}｡𐹼𐋤", %p)},	undef,	"to_ascii\(\'\\u17DD\?\=\\u0338｡𐹼𐋤\'\)\ throws\ error\ B1\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4300\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{17DD}󠁣≠。𐹼𐋤", %p)},	undef,	"to_ascii\(\'\\u17DD\?\≠\。𐹼𐋤\'\)\ throws\ error\ B1\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4301\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{17DD}󠁣=\x{0338}。𐹼𐋤", %p)},	undef,	"to_ascii\(\'\\u17DD\?\=\\u0338\。𐹼𐋤\'\)\ throws\ error\ B1\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4302\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--54e694cn389z.xn--787ct8r", %p)},	undef,	"to_ascii\(\'xn\-\-54e694cn389z\.xn\-\-787ct8r\'\)\ throws\ error\ B1\ V5\ V6\ \[data\/IdnaTest\.txt\:4303\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ß𰀻񆬗｡𝩨🕮ß", %p)},	undef,	"to_ascii\(\'ß𰀻\?｡𝩨🕮ß\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4304\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ß𰀻񆬗。𝩨🕮ß", %p)},	undef,	"to_ascii\(\'ß𰀻\?\。𝩨🕮ß\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4306\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("SS𰀻񆬗。𝩨🕮SS", %p)},	undef,	"to_ascii\(\'SS𰀻\?\。𝩨🕮SS\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4308\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ss𰀻񆬗。𝩨🕮ss", %p)},	undef,	"to_ascii\(\'ss𰀻\?\。𝩨🕮ss\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4309\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ss𰀻񆬗。𝩨🕮Ss", %p)},	undef,	"to_ascii\(\'Ss𰀻\?\。𝩨🕮Ss\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4310\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--ss-jl59biy67d.xn--ss-4d11aw87d", %p)},	undef,	"to_ascii\(\'xn\-\-ss\-jl59biy67d\.xn\-\-ss\-4d11aw87d\'\)\ throws\ error\ V5\ V6\ \[data\/IdnaTest\.txt\:4311\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--zca20040bgrkh.xn--zca3653v86qa", %p)},	undef,	"to_ascii\(\'xn\-\-zca20040bgrkh\.xn\-\-zca3653v86qa\'\)\ throws\ error\ V5\ V6\ \[data\/IdnaTest\.txt\:4312\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("SS𰀻񆬗｡𝩨🕮SS", %p)},	undef,	"to_ascii\(\'SS𰀻\?｡𝩨🕮SS\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4313\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ss𰀻񆬗｡𝩨🕮ss", %p)},	undef,	"to_ascii\(\'ss𰀻\?｡𝩨🕮ss\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4314\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ss𰀻񆬗｡𝩨🕮Ss", %p)},	undef,	"to_ascii\(\'Ss𰀻\?｡𝩨🕮Ss\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4315\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}。\x{200C}", %p)},	undef,	"to_ascii\(\'\\u200D\。\\u200C\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:4316\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--1ug.xn--0ug", %p)},	undef,	"to_ascii\(\'xn\-\-1ug\.xn\-\-0ug\'\)\ throws\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:4318\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0483}𐭞\x{200D}.\x{17B9}𞯌򟩚", %p)},	undef,	"to_ascii\(\'\\u0483𐭞\\u200D\.\\u17B9\?\?\'\)\ throws\ error\ B1\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4319\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--m3a6965k.xn--43e8670vmd79b", %p)},	undef,	"to_ascii\(\'xn\-\-m3a6965k\.xn\-\-43e8670vmd79b\'\)\ throws\ error\ B1\ V5\ V6\ \[data\/IdnaTest\.txt\:4321\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--m3a412lrr0o.xn--43e8670vmd79b", %p)},	undef,	"to_ascii\(\'xn\-\-m3a412lrr0o\.xn\-\-43e8670vmd79b\'\)\ throws\ error\ B1\ C2\ V5\ V6\ \[data\/IdnaTest\.txt\:4322\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}𐠨\x{200C}临。ꡢ򄷞ⶏ𐹣", %p)},	undef,	"to_ascii\(\'\\u200C𐠨\\u200C临\。ꡢ\?ⶏ𐹣\'\)\ throws\ error\ B2\ B3\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:4323\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--miq9646b.xn--uojv340bk71c99u9f", %p)},	undef,	"to_ascii\(\'xn\-\-miq9646b\.xn\-\-uojv340bk71c99u9f\'\)\ throws\ error\ B2\ B3\ B5\ B6\ V6\ \[data\/IdnaTest\.txt\:4325\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--0uga2656aop9k.xn--uojv340bk71c99u9f", %p)},	undef,	"to_ascii\(\'xn\-\-0uga2656aop9k\.xn\-\-uojv340bk71c99u9f\'\)\ throws\ error\ B1\ B5\ B6\ C1\ V6\ \[data\/IdnaTest\.txt\:4326\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠑘．󠄮", %p)},	undef,	"to_ascii\(\'\?．\󠄮\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4327\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠑘.󠄮", %p)},	undef,	"to_ascii\(\'\?\.\󠄮\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4328\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--s136e.", %p)},	undef,	"to_ascii\(\'xn\-\-s136e\.\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:4329\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("𐫄\x{0D4D}．\x{AAF6}", %p)},	undef,	"to_ascii\(\'𐫄\\u0D4D．\\uAAF6\'\)\ throws\ error\ B1\ B3\ B6\ V5\ \[data\/IdnaTest\.txt\:4330\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("𐫄\x{0D4D}.\x{AAF6}", %p)},	undef,	"to_ascii\(\'𐫄\\u0D4D\.\\uAAF6\'\)\ throws\ error\ B1\ B3\ B6\ V5\ \[data\/IdnaTest\.txt\:4331\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--wxc7880k.xn--2v9a", %p)},	undef,	"to_ascii\(\'xn\-\-wxc7880k\.xn\-\-2v9a\'\)\ throws\ error\ B1\ B3\ B6\ V5\ \[data\/IdnaTest\.txt\:4332\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{A9B7}󝵙멹。⒛󠨇", %p)},	undef,	"to_ascii\(\'\\uA9B7\?멹\。⒛\?\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4333\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{A9B7}󝵙멹。⒛󠨇", %p)},	undef,	"to_ascii\(\'\\uA9B7\?멹\。⒛\?\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4334\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{A9B7}󝵙멹。20.󠨇", %p)},	undef,	"to_ascii\(\'\\uA9B7\?멹\。20\.\?\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4335\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{A9B7}󝵙멹。20.󠨇", %p)},	undef,	"to_ascii\(\'\\uA9B7\?멹\。20\.\?\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4336\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--ym9av13acp85w.20.xn--d846e", %p)},	undef,	"to_ascii\(\'xn\-\-ym9av13acp85w\.20\.xn\-\-d846e\'\)\ throws\ error\ V5\ V6\ \[data\/IdnaTest\.txt\:4337\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--ym9av13acp85w.xn--dth22121k", %p)},	undef,	"to_ascii\(\'xn\-\-ym9av13acp85w\.xn\-\-dth22121k\'\)\ throws\ error\ V5\ V6\ \[data\/IdnaTest\.txt\:4338\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴅ󲬹릖󠶚.\x{0777}𐹳⒊", %p)},	undef,	"to_ascii\(\'Ⴅ\?릖\?\.\\u0777𐹳⒊\'\)\ throws\ error\ B4\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:4339\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴅ󲬹릖󠶚.\x{0777}𐹳⒊", %p)},	undef,	"to_ascii\(\'Ⴅ\?릖\?\.\\u0777𐹳⒊\'\)\ throws\ error\ B4\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:4340\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴅ󲬹릖󠶚.\x{0777}𐹳3.", %p)},	undef,	"to_ascii\(\'Ⴅ\?릖\?\.\\u0777𐹳3\.\'\)\ throws\ error\ B4\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:4341\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴅ󲬹릖󠶚.\x{0777}𐹳3.", %p)},	undef,	"to_ascii\(\'Ⴅ\?릖\?\.\\u0777𐹳3\.\'\)\ throws\ error\ B4\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:4342\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⴅ󲬹릖󠶚.\x{0777}𐹳3.", %p)},	undef,	"to_ascii\(\'ⴅ\?릖\?\.\\u0777𐹳3\.\'\)\ throws\ error\ B4\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:4343\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⴅ󲬹릖󠶚.\x{0777}𐹳3.", %p)},	undef,	"to_ascii\(\'ⴅ\?릖\?\.\\u0777𐹳3\.\'\)\ throws\ error\ B4\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:4344\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--wkj8016bne45io02g.xn--3-55c6803r.", %p)},	undef,	"to_ascii\(\'xn\-\-wkj8016bne45io02g\.xn\-\-3\-55c6803r\.\'\)\ throws\ error\ B4\ B6\ V6\ \[data\/IdnaTest\.txt\:4345\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--dnd2167fnet0io02g.xn--3-55c6803r.", %p)},	undef,	"to_ascii\(\'xn\-\-dnd2167fnet0io02g\.xn\-\-3\-55c6803r\.\'\)\ throws\ error\ B4\ B6\ V6\ \[data\/IdnaTest\.txt\:4346\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⴅ󲬹릖󠶚.\x{0777}𐹳⒊", %p)},	undef,	"to_ascii\(\'ⴅ\?릖\?\.\\u0777𐹳⒊\'\)\ throws\ error\ B4\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:4347\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⴅ󲬹릖󠶚.\x{0777}𐹳⒊", %p)},	undef,	"to_ascii\(\'ⴅ\?릖\?\.\\u0777𐹳⒊\'\)\ throws\ error\ B4\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:4348\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--wkj8016bne45io02g.xn--7pb000mwm4n", %p)},	undef,	"to_ascii\(\'xn\-\-wkj8016bne45io02g\.xn\-\-7pb000mwm4n\'\)\ throws\ error\ B4\ B6\ V6\ \[data\/IdnaTest\.txt\:4349\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--dnd2167fnet0io02g.xn--7pb000mwm4n", %p)},	undef,	"to_ascii\(\'xn\-\-dnd2167fnet0io02g\.xn\-\-7pb000mwm4n\'\)\ throws\ error\ B4\ B6\ V6\ \[data\/IdnaTest\.txt\:4350\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}｡︒", %p)},	undef,	"to_ascii\(\'\\u200C｡︒\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:4351\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}。。", %p)},	undef,	"to_ascii\(\'\\u200C\。\。\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:4353\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("..", %p)},	undef,	"to_ascii\(\'\.\.\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:4355\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--0ug..", %p)},	undef,	"to_ascii\(\'xn\-\-0ug\.\.\'\)\ throws\ error\ C1\ A4_2\ \[data\/IdnaTest\.txt\:4356\]") or ($@ and diag($@));
is(eval{uts46_to_ascii(".xn--y86c", %p)},	undef,	"to_ascii\(\'\.xn\-\-y86c\'\)\ throws\ error\ V6\ A4_2\ \[data\/IdnaTest\.txt\:4357\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--0ug.xn--y86c", %p)},	undef,	"to_ascii\(\'xn\-\-0ug\.xn\-\-y86c\'\)\ throws\ error\ C1\ V6\ \[data\/IdnaTest\.txt\:4358\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≯\x{076D}．₄", %p)},	undef,	"to_ascii\(\'\≯\\u076D．₄\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:4359\]") or ($@ and diag($@));
is(eval{uts46_to_ascii(">\x{0338}\x{076D}．₄", %p)},	undef,	"to_ascii\(\'\>\\u0338\\u076D．₄\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:4360\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≯\x{076D}.4", %p)},	undef,	"to_ascii\(\'\≯\\u076D\.4\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:4361\]") or ($@ and diag($@));
is(eval{uts46_to_ascii(">\x{0338}\x{076D}.4", %p)},	undef,	"to_ascii\(\'\>\\u0338\\u076D\.4\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:4362\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--xpb149k.4", %p)},	undef,	"to_ascii\(\'xn\-\-xpb149k\.4\'\)\ throws\ error\ B1\ V6\ \[data\/IdnaTest\.txt\:4363\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᡲ-𝟹.ß-\x{200C}-", %p)},	undef,	"to_ascii\(\'ᡲ\-𝟹\.ß\-\\u200C\-\'\)\ throws\ error\ V2\ V3\ \[data\/IdnaTest\.txt\:4364\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᡲ-3.ß-\x{200C}-", %p)},	undef,	"to_ascii\(\'ᡲ\-3\.ß\-\\u200C\-\'\)\ throws\ error\ V2\ V3\ \[data\/IdnaTest\.txt\:4366\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᡲ-3.SS-\x{200C}-", %p)},	undef,	"to_ascii\(\'ᡲ\-3\.SS\-\\u200C\-\'\)\ throws\ error\ V2\ V3\ \[data\/IdnaTest\.txt\:4368\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᡲ-3.ss-\x{200C}-", %p)},	undef,	"to_ascii\(\'ᡲ\-3\.ss\-\\u200C\-\'\)\ throws\ error\ V2\ V3\ \[data\/IdnaTest\.txt\:4370\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᡲ-3.Ss-\x{200C}-", %p)},	undef,	"to_ascii\(\'ᡲ\-3\.Ss\-\\u200C\-\'\)\ throws\ error\ V2\ V3\ \[data\/IdnaTest\.txt\:4372\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn---3-p9o.ss--", %p)},	undef,	"to_ascii\(\'xn\-\-\-3\-p9o\.ss\-\-\'\)\ throws\ error\ V2\ V3\ \[data\/IdnaTest\.txt\:4374\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn---3-p9o.xn--ss---276a", %p)},	undef,	"to_ascii\(\'xn\-\-\-3\-p9o\.xn\-\-ss\-\-\-276a\'\)\ throws\ error\ C1\ V3\ \[data\/IdnaTest\.txt\:4375\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn---3-p9o.xn-----fia9303a", %p)},	undef,	"to_ascii\(\'xn\-\-\-3\-p9o\.xn\-\-\-\-\-fia9303a\'\)\ throws\ error\ C1\ V3\ \[data\/IdnaTest\.txt\:4376\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᡲ-𝟹.SS-\x{200C}-", %p)},	undef,	"to_ascii\(\'ᡲ\-𝟹\.SS\-\\u200C\-\'\)\ throws\ error\ V2\ V3\ \[data\/IdnaTest\.txt\:4377\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᡲ-𝟹.ss-\x{200C}-", %p)},	undef,	"to_ascii\(\'ᡲ\-𝟹\.ss\-\\u200C\-\'\)\ throws\ error\ V2\ V3\ \[data\/IdnaTest\.txt\:4379\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᡲ-𝟹.Ss-\x{200C}-", %p)},	undef,	"to_ascii\(\'ᡲ\-𝟹\.Ss\-\\u200C\-\'\)\ throws\ error\ V2\ V3\ \[data\/IdnaTest\.txt\:4381\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{FD08}𝟦\x{0647}󎊯｡Ӏ", %p)},	undef,	"to_ascii\(\'\\uFD08𝟦\\u0647\?｡Ӏ\'\)\ throws\ error\ B2\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:4383\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0636}\x{064A}4\x{0647}󎊯。Ӏ", %p)},	undef,	"to_ascii\(\'\\u0636\\u064A4\\u0647\?\。Ӏ\'\)\ throws\ error\ B2\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:4384\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0636}\x{064A}4\x{0647}󎊯。ӏ", %p)},	undef,	"to_ascii\(\'\\u0636\\u064A4\\u0647\?\。ӏ\'\)\ throws\ error\ B2\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:4385\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--4-tnc6ck183523b.xn--s5a", %p)},	undef,	"to_ascii\(\'xn\-\-4\-tnc6ck183523b\.xn\-\-s5a\'\)\ throws\ error\ B2\ B3\ V6\ \[data\/IdnaTest\.txt\:4386\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--4-tnc6ck183523b.xn--d5a", %p)},	undef,	"to_ascii\(\'xn\-\-4\-tnc6ck183523b\.xn\-\-d5a\'\)\ throws\ error\ B2\ B3\ V6\ \[data\/IdnaTest\.txt\:4387\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{FD08}𝟦\x{0647}󎊯｡ӏ", %p)},	undef,	"to_ascii\(\'\\uFD08𝟦\\u0647\?｡ӏ\'\)\ throws\ error\ B2\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:4388\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-.\x{0602}\x{0622}𑆾🐹", %p)},	undef,	"to_ascii\(\'\-\.\\u0602\\u0622𑆾🐹\'\)\ throws\ error\ B1\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:4389\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-.\x{0602}\x{0627}\x{0653}𑆾🐹", %p)},	undef,	"to_ascii\(\'\-\.\\u0602\\u0627\\u0653𑆾🐹\'\)\ throws\ error\ B1\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:4390\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-.xn--kfb8dy983hgl7g", %p)},	undef,	"to_ascii\(\'\-\.xn\-\-kfb8dy983hgl7g\'\)\ throws\ error\ B1\ V3\ V6\ \[data\/IdnaTest\.txt\:4391\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󙶜ᢘ。\x{1A7F}⺢", %p)},	undef,	"to_ascii\(\'\?ᢘ\。\\u1A7F⺢\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4392\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--ibf35138o.xn--fpfz94g", %p)},	undef,	"to_ascii\(\'xn\-\-ibf35138o\.xn\-\-fpfz94g\'\)\ throws\ error\ V5\ V6\ \[data\/IdnaTest\.txt\:4393\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≠ႷᠤႫ｡\x{D907}\x{034C}\x{0633}觴", %p)},	undef,	"to_ascii\(\'\≠ႷᠤႫ｡\\uD907\\u034C\\u0633觴\'\)\ throws\ error\ B1\ B5\ P1\ V6\ A3\ \[data\/IdnaTest\.txt\:4394\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("=\x{0338}ႷᠤႫ｡\x{D907}\x{034C}\x{0633}觴", %p)},	undef,	"to_ascii\(\'\=\\u0338ႷᠤႫ｡\\uD907\\u034C\\u0633觴\'\)\ throws\ error\ B1\ B5\ P1\ V6\ A3\ \[data\/IdnaTest\.txt\:4395\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≠ႷᠤႫ。\x{D907}\x{034C}\x{0633}觴", %p)},	undef,	"to_ascii\(\'\≠ႷᠤႫ\。\\uD907\\u034C\\u0633觴\'\)\ throws\ error\ B1\ B5\ P1\ V6\ A3\ \[data\/IdnaTest\.txt\:4396\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("=\x{0338}ႷᠤႫ。\x{D907}\x{034C}\x{0633}觴", %p)},	undef,	"to_ascii\(\'\=\\u0338ႷᠤႫ\。\\uD907\\u034C\\u0633觴\'\)\ throws\ error\ B1\ B5\ P1\ V6\ A3\ \[data\/IdnaTest\.txt\:4397\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("=\x{0338}ⴗᠤⴋ。\x{D907}\x{034C}\x{0633}觴", %p)},	undef,	"to_ascii\(\'\=\\u0338ⴗᠤⴋ\。\\uD907\\u034C\\u0633觴\'\)\ throws\ error\ B1\ B5\ P1\ V6\ A3\ \[data\/IdnaTest\.txt\:4398\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≠ⴗᠤⴋ。\x{D907}\x{034C}\x{0633}觴", %p)},	undef,	"to_ascii\(\'\≠ⴗᠤⴋ\。\\uD907\\u034C\\u0633觴\'\)\ throws\ error\ B1\ B5\ P1\ V6\ A3\ \[data\/IdnaTest\.txt\:4399\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≠Ⴗᠤⴋ。\x{D907}\x{034C}\x{0633}觴", %p)},	undef,	"to_ascii\(\'\≠Ⴗᠤⴋ\。\\uD907\\u034C\\u0633觴\'\)\ throws\ error\ B1\ B5\ P1\ V6\ A3\ \[data\/IdnaTest\.txt\:4400\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("=\x{0338}Ⴗᠤⴋ。\x{D907}\x{034C}\x{0633}觴", %p)},	undef,	"to_ascii\(\'\=\\u0338Ⴗᠤⴋ\。\\uD907\\u034C\\u0633觴\'\)\ throws\ error\ B1\ B5\ P1\ V6\ A3\ \[data\/IdnaTest\.txt\:4401\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--vnd619as6ig6k.\x{D907}\x{034C}\x{0633}觴", %p)},	undef,	"to_ascii\(\'xn\-\-vnd619as6ig6k\.\\uD907\\u034C\\u0633觴\'\)\ throws\ error\ B1\ B5\ P1\ V6\ A3\ \[data\/IdnaTest\.txt\:4402\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("XN--VND619AS6IG6K.\x{D907}\x{034C}\x{0633}觴", %p)},	undef,	"to_ascii\(\'XN\-\-VND619AS6IG6K\.\\uD907\\u034C\\u0633觴\'\)\ throws\ error\ B1\ B5\ P1\ V6\ A3\ \[data\/IdnaTest\.txt\:4403\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Xn--Vnd619as6ig6k.\x{D907}\x{034C}\x{0633}觴", %p)},	undef,	"to_ascii\(\'Xn\-\-Vnd619as6ig6k\.\\uD907\\u034C\\u0633觴\'\)\ throws\ error\ B1\ B5\ P1\ V6\ A3\ \[data\/IdnaTest\.txt\:4404\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--66e353ce0ilb.\x{D907}\x{034C}\x{0633}觴", %p)},	undef,	"to_ascii\(\'xn\-\-66e353ce0ilb\.\\uD907\\u034C\\u0633觴\'\)\ throws\ error\ B1\ B5\ P1\ V6\ A3\ \[data\/IdnaTest\.txt\:4405\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("XN--66E353CE0ILB.\x{D907}\x{034C}\x{0633}觴", %p)},	undef,	"to_ascii\(\'XN\-\-66E353CE0ILB\.\\uD907\\u034C\\u0633觴\'\)\ throws\ error\ B1\ B5\ P1\ V6\ A3\ \[data\/IdnaTest\.txt\:4406\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Xn--66E353ce0ilb.\x{D907}\x{034C}\x{0633}觴", %p)},	undef,	"to_ascii\(\'Xn\-\-66E353ce0ilb\.\\uD907\\u034C\\u0633觴\'\)\ throws\ error\ B1\ B5\ P1\ V6\ A3\ \[data\/IdnaTest\.txt\:4407\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--jndx718cnnl.\x{D907}\x{034C}\x{0633}觴", %p)},	undef,	"to_ascii\(\'xn\-\-jndx718cnnl\.\\uD907\\u034C\\u0633觴\'\)\ throws\ error\ B1\ B5\ P1\ V6\ A3\ \[data\/IdnaTest\.txt\:4408\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("XN--JNDX718CNNL.\x{D907}\x{034C}\x{0633}觴", %p)},	undef,	"to_ascii\(\'XN\-\-JNDX718CNNL\.\\uD907\\u034C\\u0633觴\'\)\ throws\ error\ B1\ B5\ P1\ V6\ A3\ \[data\/IdnaTest\.txt\:4409\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Xn--Jndx718cnnl.\x{D907}\x{034C}\x{0633}觴", %p)},	undef,	"to_ascii\(\'Xn\-\-Jndx718cnnl\.\\uD907\\u034C\\u0633觴\'\)\ throws\ error\ B1\ B5\ P1\ V6\ A3\ \[data\/IdnaTest\.txt\:4410\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("=\x{0338}ⴗᠤⴋ｡\x{D907}\x{034C}\x{0633}觴", %p)},	undef,	"to_ascii\(\'\=\\u0338ⴗᠤⴋ｡\\uD907\\u034C\\u0633觴\'\)\ throws\ error\ B1\ B5\ P1\ V6\ A3\ \[data\/IdnaTest\.txt\:4411\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≠ⴗᠤⴋ｡\x{D907}\x{034C}\x{0633}觴", %p)},	undef,	"to_ascii\(\'\≠ⴗᠤⴋ｡\\uD907\\u034C\\u0633觴\'\)\ throws\ error\ B1\ B5\ P1\ V6\ A3\ \[data\/IdnaTest\.txt\:4412\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≠Ⴗᠤⴋ｡\x{D907}\x{034C}\x{0633}觴", %p)},	undef,	"to_ascii\(\'\≠Ⴗᠤⴋ｡\\uD907\\u034C\\u0633觴\'\)\ throws\ error\ B1\ B5\ P1\ V6\ A3\ \[data\/IdnaTest\.txt\:4413\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("=\x{0338}Ⴗᠤⴋ｡\x{D907}\x{034C}\x{0633}觴", %p)},	undef,	"to_ascii\(\'\=\\u0338Ⴗᠤⴋ｡\\uD907\\u034C\\u0633觴\'\)\ throws\ error\ B1\ B5\ P1\ V6\ A3\ \[data\/IdnaTest\.txt\:4414\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0667}.𐥨", %p)},	undef,	"to_ascii\(\'\\u0667\.\?\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:4415\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--gib.xn--vm9c", %p)},	undef,	"to_ascii\(\'xn\-\-gib\.xn\-\-vm9c\'\)\ throws\ error\ B1\ V6\ \[data\/IdnaTest\.txt\:4416\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{A9C0}𝟯｡\x{200D}񼑥𐹪\x{1BF3}", %p)},	undef,	"to_ascii\(\'\\uA9C0𝟯｡\\u200D\?𐹪\\u1BF3\'\)\ throws\ error\ B5\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4417\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{A9C0}3。\x{200D}񼑥𐹪\x{1BF3}", %p)},	undef,	"to_ascii\(\'\\uA9C03\。\\u200D\?𐹪\\u1BF3\'\)\ throws\ error\ B5\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4419\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--3-5z4e.xn--1zfz754hncv8b", %p)},	undef,	"to_ascii\(\'xn\-\-3\-5z4e\.xn\-\-1zfz754hncv8b\'\)\ throws\ error\ B5\ V5\ V6\ \[data\/IdnaTest\.txt\:4421\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--3-5z4e.xn--1zf96ony8ygd68c", %p)},	undef,	"to_ascii\(\'xn\-\-3\-5z4e\.xn\-\-1zf96ony8ygd68c\'\)\ throws\ error\ B1\ C2\ V5\ V6\ \[data\/IdnaTest\.txt\:4422\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򣕄4񠖽.≯\x{0664}𑀾󠸌", %p)},	undef,	"to_ascii\(\'\?4\?\.\≯\\u0664𑀾\?\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:4423\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򣕄4񠖽.>\x{0338}\x{0664}𑀾󠸌", %p)},	undef,	"to_ascii\(\'\?4\?\.\>\\u0338\\u0664𑀾\?\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:4424\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--4-fg85dl688i.xn--dib174li86ntdy0i", %p)},	undef,	"to_ascii\(\'xn\-\-4\-fg85dl688i\.xn\-\-dib174li86ntdy0i\'\)\ throws\ error\ B1\ V6\ \[data\/IdnaTest\.txt\:4425\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򗆧𝟯。⒈\x{1A76}𝟚򠘌", %p)},	undef,	"to_ascii\(\'\?𝟯\。⒈\\u1A76𝟚\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4426\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򗆧3。1.\x{1A76}2򠘌", %p)},	undef,	"to_ascii\(\'\?3\。1\.\\u1A762\?\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4427\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--3-rj42h.1.xn--2-13k96240l", %p)},	undef,	"to_ascii\(\'xn\-\-3\-rj42h\.1\.xn\-\-2\-13k96240l\'\)\ throws\ error\ V5\ V6\ \[data\/IdnaTest\.txt\:4428\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--3-rj42h.xn--2-13k746cq465x", %p)},	undef,	"to_ascii\(\'xn\-\-3\-rj42h\.xn\-\-2\-13k746cq465x\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:4429\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}₅⒈。≯𝟴\x{200D}", %p)},	undef,	"to_ascii\(\'\\u200D₅⒈\。\≯𝟴\\u200D\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4430\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}₅⒈。>\x{0338}𝟴\x{200D}", %p)},	undef,	"to_ascii\(\'\\u200D₅⒈\。\>\\u0338𝟴\\u200D\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4432\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}51.。≯8\x{200D}", %p)},	undef,	"to_ascii\(\'\\u200D51\.\。\≯8\\u200D\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:4434\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}51.。>\x{0338}8\x{200D}", %p)},	undef,	"to_ascii\(\'\\u200D51\.\。\>\\u03388\\u200D\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:4436\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("51..xn--8-ogo", %p)},	undef,	"to_ascii\(\'51\.\.xn\-\-8\-ogo\'\)\ throws\ error\ V6\ A4_2\ \[data\/IdnaTest\.txt\:4438\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--51-l1t..xn--8-ugn00i", %p)},	undef,	"to_ascii\(\'xn\-\-51\-l1t\.\.xn\-\-8\-ugn00i\'\)\ throws\ error\ C2\ V6\ A4_2\ \[data\/IdnaTest\.txt\:4439\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--5-ecp.xn--8-ogo", %p)},	undef,	"to_ascii\(\'xn\-\-5\-ecp\.xn\-\-8\-ogo\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:4440\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--5-tgnz5r.xn--8-ugn00i", %p)},	undef,	"to_ascii\(\'xn\-\-5\-tgnz5r\.xn\-\-8\-ugn00i\'\)\ throws\ error\ C2\ V6\ \[data\/IdnaTest\.txt\:4441\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ꡰ\x{0697}\x{1086}．򪘙\x{072F}≠\x{200C}", %p)},	undef,	"to_ascii\(\'ꡰ\\u0697\\u1086．\?\\u072F\≠\\u200C\'\)\ throws\ error\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:4442\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ꡰ\x{0697}\x{1086}．򪘙\x{072F}=\x{0338}\x{200C}", %p)},	undef,	"to_ascii\(\'ꡰ\\u0697\\u1086．\?\\u072F\=\\u0338\\u200C\'\)\ throws\ error\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:4444\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ꡰ\x{0697}\x{1086}.򪘙\x{072F}≠\x{200C}", %p)},	undef,	"to_ascii\(\'ꡰ\\u0697\\u1086\.\?\\u072F\≠\\u200C\'\)\ throws\ error\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:4446\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ꡰ\x{0697}\x{1086}.򪘙\x{072F}=\x{0338}\x{200C}", %p)},	undef,	"to_ascii\(\'ꡰ\\u0697\\u1086\.\?\\u072F\=\\u0338\\u200C\'\)\ throws\ error\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:4448\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--tjb002cn51k.xn--5nb630lbj91q", %p)},	undef,	"to_ascii\(\'xn\-\-tjb002cn51k\.xn\-\-5nb630lbj91q\'\)\ throws\ error\ B5\ B6\ V6\ \[data\/IdnaTest\.txt\:4450\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--tjb002cn51k.xn--5nb448jcubcz547b", %p)},	undef,	"to_ascii\(\'xn\-\-tjb002cn51k\.xn\-\-5nb448jcubcz547b\'\)\ throws\ error\ B5\ B6\ C1\ V6\ \[data\/IdnaTest\.txt\:4451\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𑄱｡򪌿𐹵", %p)},	undef,	"to_ascii\(\'𑄱｡\?𐹵\'\)\ throws\ error\ B1\ B3\ B5\ B6\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4452\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𑄱。򪌿𐹵", %p)},	undef,	"to_ascii\(\'𑄱\。\?𐹵\'\)\ throws\ error\ B1\ B3\ B5\ B6\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4453\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--t80d.xn--to0d14792b", %p)},	undef,	"to_ascii\(\'xn\-\-t80d\.xn\-\-to0d14792b\'\)\ throws\ error\ B1\ B3\ B5\ B6\ V5\ V6\ \[data\/IdnaTest\.txt\:4454\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𝟥\x{0600}。\x{073D}", %p)},	undef,	"to_ascii\(\'𝟥\\u0600\。\\u073D\'\)\ throws\ error\ B1\ B3\ B6\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4455\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("3\x{0600}。\x{073D}", %p)},	undef,	"to_ascii\(\'3\\u0600\。\\u073D\'\)\ throws\ error\ B1\ B3\ B6\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4456\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--3-rkc.xn--kob", %p)},	undef,	"to_ascii\(\'xn\-\-3\-rkc\.xn\-\-kob\'\)\ throws\ error\ B1\ B3\ B6\ V5\ V6\ \[data\/IdnaTest\.txt\:4457\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("\x{0637}𐹣\x{0666}.\x{076D}긷", %p)},	undef,	"to_ascii\(\'\\u0637𐹣\\u0666\.\\u076D긷\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:4458\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("\x{0637}𐹣\x{0666}.\x{076D}긷", %p)},	undef,	"to_ascii\(\'\\u0637𐹣\\u0666\.\\u076D긷\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:4459\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--2gb8gu829f.xn--xpb0156f", %p)},	undef,	"to_ascii\(\'xn\-\-2gb8gu829f\.xn\-\-xpb0156f\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:4460\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("︒Ↄ\x{2DE7}򾀃．Ⴗ𐣞", %p)},	undef,	"to_ascii\(\'︒Ↄ\\u2DE7\?．Ⴗ\?\'\)\ throws\ error\ B1\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:4461\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("。Ↄ\x{2DE7}򾀃.Ⴗ𐣞", %p)},	undef,	"to_ascii\(\'\。Ↄ\\u2DE7\?\.Ⴗ\?\'\)\ throws\ error\ B5\ B6\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:4462\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("。ↄ\x{2DE7}򾀃.ⴗ𐣞", %p)},	undef,	"to_ascii\(\'\。ↄ\\u2DE7\?\.ⴗ\?\'\)\ throws\ error\ B5\ B6\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:4463\]") or ($@ and diag($@));
is(eval{uts46_to_ascii(".xn--r5gy00cll06u.xn--flj4541e", %p)},	undef,	"to_ascii\(\'\.xn\-\-r5gy00cll06u\.xn\-\-flj4541e\'\)\ throws\ error\ B5\ B6\ V6\ A4_2\ \[data\/IdnaTest\.txt\:4464\]") or ($@ and diag($@));
is(eval{uts46_to_ascii(".xn--q5g000cll06u.xn--vnd8618j", %p)},	undef,	"to_ascii\(\'\.xn\-\-q5g000cll06u\.xn\-\-vnd8618j\'\)\ throws\ error\ B5\ B6\ V6\ A4_2\ \[data\/IdnaTest\.txt\:4465\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("︒ↄ\x{2DE7}򾀃．ⴗ𐣞", %p)},	undef,	"to_ascii\(\'︒ↄ\\u2DE7\?．ⴗ\?\'\)\ throws\ error\ B1\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:4466\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--r5gy00c056n0226g.xn--flj4541e", %p)},	undef,	"to_ascii\(\'xn\-\-r5gy00c056n0226g\.xn\-\-flj4541e\'\)\ throws\ error\ B1\ B5\ B6\ V6\ \[data\/IdnaTest\.txt\:4467\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--q5g000c056n0226g.xn--vnd8618j", %p)},	undef,	"to_ascii\(\'xn\-\-q5g000c056n0226g\.xn\-\-vnd8618j\'\)\ throws\ error\ B1\ B5\ B6\ V6\ \[data\/IdnaTest\.txt\:4468\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0600}.\x{05B1}", %p)},	undef,	"to_ascii\(\'\\u0600\.\\u05B1\'\)\ throws\ error\ B1\ B3\ B6\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4469\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--ifb.xn--8cb", %p)},	undef,	"to_ascii\(\'xn\-\-ifb\.xn\-\-8cb\'\)\ throws\ error\ B1\ B3\ B6\ V5\ V6\ \[data\/IdnaTest\.txt\:4470\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ς≯｡𐹽", %p)},	undef,	"to_ascii\(\'ς\≯｡𐹽\'\)\ throws\ error\ B1\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:4471\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ς>\x{0338}｡𐹽", %p)},	undef,	"to_ascii\(\'ς\>\\u0338｡𐹽\'\)\ throws\ error\ B1\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:4473\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ς≯。𐹽", %p)},	undef,	"to_ascii\(\'ς\≯\。𐹽\'\)\ throws\ error\ B1\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:4475\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ς>\x{0338}。𐹽", %p)},	undef,	"to_ascii\(\'ς\>\\u0338\。𐹽\'\)\ throws\ error\ B1\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:4477\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Σ>\x{0338}。𐹽", %p)},	undef,	"to_ascii\(\'Σ\>\\u0338\。𐹽\'\)\ throws\ error\ B1\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:4479\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Σ≯。𐹽", %p)},	undef,	"to_ascii\(\'Σ\≯\。𐹽\'\)\ throws\ error\ B1\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:4480\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("σ≯。𐹽", %p)},	undef,	"to_ascii\(\'σ\≯\。𐹽\'\)\ throws\ error\ B1\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:4481\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("σ>\x{0338}。𐹽", %p)},	undef,	"to_ascii\(\'σ\>\\u0338\。𐹽\'\)\ throws\ error\ B1\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:4482\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--4xa818m.xn--1o0d", %p)},	undef,	"to_ascii\(\'xn\-\-4xa818m\.xn\-\-1o0d\'\)\ throws\ error\ B1\ B6\ V6\ \[data\/IdnaTest\.txt\:4483\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--3xa028m.xn--1o0d", %p)},	undef,	"to_ascii\(\'xn\-\-3xa028m\.xn\-\-1o0d\'\)\ throws\ error\ B1\ B6\ V6\ \[data\/IdnaTest\.txt\:4484\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Σ>\x{0338}｡𐹽", %p)},	undef,	"to_ascii\(\'Σ\>\\u0338｡𐹽\'\)\ throws\ error\ B1\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:4485\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Σ≯｡𐹽", %p)},	undef,	"to_ascii\(\'Σ\≯｡𐹽\'\)\ throws\ error\ B1\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:4486\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("σ≯｡𐹽", %p)},	undef,	"to_ascii\(\'σ\≯｡𐹽\'\)\ throws\ error\ B1\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:4487\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("σ>\x{0338}｡𐹽", %p)},	undef,	"to_ascii\(\'σ\>\\u0338｡𐹽\'\)\ throws\ error\ B1\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:4488\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("\x{17D2}\x{200D}\x{075F}。𐹶", %p)},	undef,	"to_ascii\(\'\\u17D2\\u200D\\u075F\。𐹶\'\)\ throws\ error\ B1\ V5\ \[data\/IdnaTest\.txt\:4489\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--jpb535f.xn--uo0d", %p)},	undef,	"to_ascii\(\'xn\-\-jpb535f\.xn\-\-uo0d\'\)\ throws\ error\ B1\ V5\ \[data\/IdnaTest\.txt\:4491\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--jpb535fv9f.xn--uo0d", %p)},	undef,	"to_ascii\(\'xn\-\-jpb535fv9f\.xn\-\-uo0d\'\)\ throws\ error\ B1\ V5\ \[data\/IdnaTest\.txt\:4492\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𾷂\x{0A42}Ⴊ񂂟.≮", %p)},	undef,	"to_ascii\(\'\?\\u0A42Ⴊ\?\.\≮\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4493\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𾷂\x{0A42}Ⴊ񂂟.<\x{0338}", %p)},	undef,	"to_ascii\(\'\?\\u0A42Ⴊ\?\.\<\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4494\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𾷂\x{0A42}ⴊ񂂟.<\x{0338}", %p)},	undef,	"to_ascii\(\'\?\\u0A42ⴊ\?\.\<\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4495\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𾷂\x{0A42}ⴊ񂂟.≮", %p)},	undef,	"to_ascii\(\'\?\\u0A42ⴊ\?\.\≮\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4496\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--nbc229o4y27dgskb.xn--gdh", %p)},	undef,	"to_ascii\(\'xn\-\-nbc229o4y27dgskb\.xn\-\-gdh\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:4497\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--nbc493aro75ggskb.xn--gdh", %p)},	undef,	"to_ascii\(\'xn\-\-nbc493aro75ggskb\.xn\-\-gdh\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:4498\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_ascii("ꡠ．۲", %p)},	"xn--5c9a.xn--fmb",	"to_ascii\(\'ꡠ．۲\'\)\ \[data\/IdnaTest\.txt\:4499\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_ascii("ꡠ.۲", %p)},	"xn--5c9a.xn--fmb",	"to_ascii\(\'ꡠ\.۲\'\)\ \[data\/IdnaTest\.txt\:4500\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_ascii("xn--5c9a.xn--fmb", %p)},	"xn--5c9a.xn--fmb",	"to_ascii\(\'xn\-\-5c9a\.xn\-\-fmb\'\)\ \[data\/IdnaTest\.txt\:4501\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("𐹣񄷄｡ꡬ🄄", %p)},	undef,	"to_ascii\(\'𐹣\?｡ꡬ🄄\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:4502\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐹣񄷄。ꡬ3,", %p)},	undef,	"to_ascii\(\'𐹣\?\。ꡬ3\,\'\)\ throws\ error\ B1\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:4503\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--bo0d0203l.xn--3,-yj9h", %p)},	undef,	"to_ascii\(\'xn\-\-bo0d0203l\.xn\-\-3\,\-yj9h\'\)\ throws\ error\ B1\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:4504\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--bo0d0203l.xn--id9a4443d", %p)},	undef,	"to_ascii\(\'xn\-\-bo0d0203l\.xn\-\-id9a4443d\'\)\ throws\ error\ B1\ V6\ \[data\/IdnaTest\.txt\:4505\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-\x{0C4D}𞾀𑲓｡\x{200D}\x{0D4D}", %p)},	undef,	"to_ascii\(\'\-\\u0C4D\?𑲓｡\\u200D\\u0D4D\'\)\ throws\ error\ B1\ B3\ B6\ P1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:4506\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-\x{0C4D}𞾀𑲓。\x{200D}\x{0D4D}", %p)},	undef,	"to_ascii\(\'\-\\u0C4D\?𑲓\。\\u200D\\u0D4D\'\)\ throws\ error\ B1\ B3\ B6\ P1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:4508\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----x6e0220sclug.xn--wxc", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-x6e0220sclug\.xn\-\-wxc\'\)\ throws\ error\ B1\ B3\ B6\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:4510\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----x6e0220sclug.xn--wxc317g", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-x6e0220sclug\.xn\-\-wxc317g\'\)\ throws\ error\ B1\ C2\ V3\ V6\ \[data\/IdnaTest\.txt\:4511\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{A67D}\x{200C}霣🄆｡\x{200C}𑁂\x{1B01}", %p)},	undef,	"to_ascii\(\'\\uA67D\\u200C霣🄆｡\\u200C𑁂\\u1B01\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4512\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{A67D}\x{200C}霣🄆｡\x{200C}𑁂\x{1B01}", %p)},	undef,	"to_ascii\(\'\\uA67D\\u200C霣🄆｡\\u200C𑁂\\u1B01\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4514\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{A67D}\x{200C}霣5,。\x{200C}𑁂\x{1B01}", %p)},	undef,	"to_ascii\(\'\\uA67D\\u200C霣5\,\。\\u200C𑁂\\u1B01\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4516\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--5,-op8g373c.xn--4sf0725i", %p)},	undef,	"to_ascii\(\'xn\-\-5\,\-op8g373c\.xn\-\-4sf0725i\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4518\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--5,-i1tz135dnbqa.xn--4sf36u6u4w", %p)},	undef,	"to_ascii\(\'xn\-\-5\,\-i1tz135dnbqa\.xn\-\-4sf36u6u4w\'\)\ throws\ error\ C1\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4519\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--2q5a751a653w.xn--4sf0725i", %p)},	undef,	"to_ascii\(\'xn\-\-2q5a751a653w\.xn\-\-4sf0725i\'\)\ throws\ error\ V5\ V6\ \[data\/IdnaTest\.txt\:4520\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--0ug4208b2vjuk63a.xn--4sf36u6u4w", %p)},	undef,	"to_ascii\(\'xn\-\-0ug4208b2vjuk63a\.xn\-\-4sf36u6u4w\'\)\ throws\ error\ C1\ V5\ V6\ \[data\/IdnaTest\.txt\:4521\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("兎｡ᠼ󠴜𑚶𑰿", %p)},	undef,	"to_ascii\(\'兎｡ᠼ\?𑚶𑰿\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4522\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("兎。ᠼ󠴜𑚶𑰿", %p)},	undef,	"to_ascii\(\'兎\。ᠼ\?𑚶𑰿\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4523\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--b5q.xn--v7e6041kqqd4m251b", %p)},	undef,	"to_ascii\(\'xn\-\-b5q\.xn\-\-v7e6041kqqd4m251b\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:4524\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𝟙｡\x{200D}𝟸\x{200D}⁷", %p)},	"1.27",	"to_ascii\(\'𝟙｡\\u200D𝟸\\u200D⁷\'\)\ \[data\/IdnaTest\.txt\:4525\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("1。\x{200D}2\x{200D}7", %p)},	"1.27",	"to_ascii\(\'1\。\\u200D2\\u200D7\'\)\ \[data\/IdnaTest\.txt\:4527\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("1.27", %p)},	"1.27",	"to_ascii\(\'1\.27\'\)\ \[data\/IdnaTest\.txt\:4529\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("1.xn--27-l1tb", %p)},	undef,	"to_ascii\(\'1\.xn\-\-27\-l1tb\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:4530\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᡨ-｡󠻋𝟷", %p)},	undef,	"to_ascii\(\'ᡨ\-｡\?𝟷\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:4531\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᡨ-。󠻋1", %p)},	undef,	"to_ascii\(\'ᡨ\-\。\?1\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:4532\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----z8j.xn--1-5671m", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-z8j\.xn\-\-1\-5671m\'\)\ throws\ error\ V3\ V6\ \[data\/IdnaTest\.txt\:4533\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𑰻񵀐𐫚．\x{0668}⁹", %p)},	undef,	"to_ascii\(\'𑰻\?𐫚．\\u0668⁹\'\)\ throws\ error\ B1\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4534\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𑰻񵀐𐫚.\x{0668}9", %p)},	undef,	"to_ascii\(\'𑰻\?𐫚\.\\u06689\'\)\ throws\ error\ B1\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4535\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--gx9cr01aul57i.xn--9-oqc", %p)},	undef,	"to_ascii\(\'xn\-\-gx9cr01aul57i\.xn\-\-9\-oqc\'\)\ throws\ error\ B1\ V5\ V6\ \[data\/IdnaTest\.txt\:4536\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴜ򈷭\x{0F80}⾇。Ⴏ♀\x{200C}\x{200C}", %p)},	undef,	"to_ascii\(\'Ⴜ\?\\u0F80⾇\。Ⴏ\♀\\u200C\\u200C\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4537\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴜ򈷭\x{0F80}舛。Ⴏ♀\x{200C}\x{200C}", %p)},	undef,	"to_ascii\(\'Ⴜ\?\\u0F80舛\。Ⴏ\♀\\u200C\\u200C\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4539\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⴜ򈷭\x{0F80}舛。ⴏ♀\x{200C}\x{200C}", %p)},	undef,	"to_ascii\(\'ⴜ\?\\u0F80舛\。ⴏ\♀\\u200C\\u200C\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4541\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--zed372mdj2do3v4h.xn--e5h11w", %p)},	undef,	"to_ascii\(\'xn\-\-zed372mdj2do3v4h\.xn\-\-e5h11w\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:4543\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--zed372mdj2do3v4h.xn--0uga678bgyh", %p)},	undef,	"to_ascii\(\'xn\-\-zed372mdj2do3v4h\.xn\-\-0uga678bgyh\'\)\ throws\ error\ C1\ V6\ \[data\/IdnaTest\.txt\:4544\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--zed54dz10wo343g.xn--nnd651i", %p)},	undef,	"to_ascii\(\'xn\-\-zed54dz10wo343g\.xn\-\-nnd651i\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:4545\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--zed54dz10wo343g.xn--nnd089ea464d", %p)},	undef,	"to_ascii\(\'xn\-\-zed54dz10wo343g\.xn\-\-nnd089ea464d\'\)\ throws\ error\ C1\ V6\ \[data\/IdnaTest\.txt\:4546\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⴜ򈷭\x{0F80}⾇。ⴏ♀\x{200C}\x{200C}", %p)},	undef,	"to_ascii\(\'ⴜ\?\\u0F80⾇\。ⴏ\♀\\u200C\\u200C\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4547\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_ascii("𑁆𝟰.\x{200D}", %p)},	undef,	"to_ascii\(\'𑁆𝟰\.\\u200D\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:4549\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_ascii("𑁆4.\x{200D}", %p)},	undef,	"to_ascii\(\'𑁆4\.\\u200D\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:4551\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--4-xu7i.", %p)},	undef,	"to_ascii\(\'xn\-\-4\-xu7i\.\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:4553\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--4-xu7i.xn--1ug", %p)},	undef,	"to_ascii\(\'xn\-\-4\-xu7i\.xn\-\-1ug\'\)\ throws\ error\ C2\ V5\ \[data\/IdnaTest\.txt\:4554\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񮴘Ⴞ癀｡𑘿\x{200D}\x{200C}붼", %p)},	undef,	"to_ascii\(\'\?Ⴞ癀｡𑘿\\u200D\\u200C붼\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4555\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񮴘Ⴞ癀｡𑘿\x{200D}\x{200C}붼", %p)},	undef,	"to_ascii\(\'\?Ⴞ癀｡𑘿\\u200D\\u200C붼\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4557\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񮴘Ⴞ癀。𑘿\x{200D}\x{200C}붼", %p)},	undef,	"to_ascii\(\'\?Ⴞ癀\。𑘿\\u200D\\u200C붼\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4559\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񮴘Ⴞ癀。𑘿\x{200D}\x{200C}붼", %p)},	undef,	"to_ascii\(\'\?Ⴞ癀\。𑘿\\u200D\\u200C붼\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4561\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񮴘ⴞ癀。𑘿\x{200D}\x{200C}붼", %p)},	undef,	"to_ascii\(\'\?ⴞ癀\。𑘿\\u200D\\u200C붼\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4563\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񮴘ⴞ癀。𑘿\x{200D}\x{200C}붼", %p)},	undef,	"to_ascii\(\'\?ⴞ癀\。𑘿\\u200D\\u200C붼\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4565\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--mlju35u7qx2f.xn--et3bn23n", %p)},	undef,	"to_ascii\(\'xn\-\-mlju35u7qx2f\.xn\-\-et3bn23n\'\)\ throws\ error\ V5\ V6\ \[data\/IdnaTest\.txt\:4567\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--mlju35u7qx2f.xn--0ugb6122js83c", %p)},	undef,	"to_ascii\(\'xn\-\-mlju35u7qx2f\.xn\-\-0ugb6122js83c\'\)\ throws\ error\ C1\ V5\ V6\ \[data\/IdnaTest\.txt\:4568\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--2nd6803c7q37d.xn--et3bn23n", %p)},	undef,	"to_ascii\(\'xn\-\-2nd6803c7q37d\.xn\-\-et3bn23n\'\)\ throws\ error\ V5\ V6\ \[data\/IdnaTest\.txt\:4569\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--2nd6803c7q37d.xn--0ugb6122js83c", %p)},	undef,	"to_ascii\(\'xn\-\-2nd6803c7q37d\.xn\-\-0ugb6122js83c\'\)\ throws\ error\ C1\ V5\ V6\ \[data\/IdnaTest\.txt\:4570\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񮴘ⴞ癀｡𑘿\x{200D}\x{200C}붼", %p)},	undef,	"to_ascii\(\'\?ⴞ癀｡𑘿\\u200D\\u200C붼\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4571\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񮴘ⴞ癀｡𑘿\x{200D}\x{200C}붼", %p)},	undef,	"to_ascii\(\'\?ⴞ癀｡𑘿\\u200D\\u200C붼\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4573\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󚀅-\x{0BCD}。\x{06B9}", %p)},	undef,	"to_ascii\(\'\?\-\\u0BCD\。\\u06B9\'\)\ throws\ error\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:4575\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----mze84808x.xn--skb", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-mze84808x\.xn\-\-skb\'\)\ throws\ error\ B6\ V6\ \[data\/IdnaTest\.txt\:4576\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᡃ𝟧≯ᠣ．氁񨏱ꁫ", %p)},	undef,	"to_ascii\(\'ᡃ𝟧\≯ᠣ．氁\?ꁫ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4577\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᡃ𝟧>\x{0338}ᠣ．氁񨏱ꁫ", %p)},	undef,	"to_ascii\(\'ᡃ𝟧\>\\u0338ᠣ．氁\?ꁫ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4578\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᡃ5≯ᠣ.氁񨏱ꁫ", %p)},	undef,	"to_ascii\(\'ᡃ5\≯ᠣ\.氁\?ꁫ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4579\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᡃ5>\x{0338}ᠣ.氁񨏱ꁫ", %p)},	undef,	"to_ascii\(\'ᡃ5\>\\u0338ᠣ\.氁\?ꁫ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4580\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--5-24jyf768b.xn--lqw213ime95g", %p)},	undef,	"to_ascii\(\'xn\-\-5\-24jyf768b\.xn\-\-lqw213ime95g\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:4581\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_ascii("𐹬𝩇．\x{0F76}", %p)},	undef,	"to_ascii\(\'𐹬𝩇．\\u0F76\'\)\ throws\ error\ B1\ B3\ B6\ V5\ \[data\/IdnaTest\.txt\:4582\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_ascii("𐹬𝩇．\x{0FB2}\x{0F80}", %p)},	undef,	"to_ascii\(\'𐹬𝩇．\\u0FB2\\u0F80\'\)\ throws\ error\ B1\ B3\ B6\ V5\ \[data\/IdnaTest\.txt\:4583\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_ascii("𐹬𝩇.\x{0FB2}\x{0F80}", %p)},	undef,	"to_ascii\(\'𐹬𝩇\.\\u0FB2\\u0F80\'\)\ throws\ error\ B1\ B3\ B6\ V5\ \[data\/IdnaTest\.txt\:4584\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--ko0d8295a.xn--zed3h", %p)},	undef,	"to_ascii\(\'xn\-\-ko0d8295a\.xn\-\-zed3h\'\)\ throws\ error\ B1\ B3\ B6\ V5\ \[data\/IdnaTest\.txt\:4585\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-𑈶⒏．⒎𰛢󠎭", %p)},	undef,	"to_ascii\(\'\-𑈶⒏．⒎𰛢\?\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:4586\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-𑈶8..7.𰛢󠎭", %p)},	undef,	"to_ascii\(\'\-𑈶8\.\.7\.𰛢\?\'\)\ throws\ error\ P1\ V3\ V6\ A4_2\ \[data\/IdnaTest\.txt\:4587\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn---8-bv5o..7.xn--c35nf1622b", %p)},	undef,	"to_ascii\(\'xn\-\-\-8\-bv5o\.\.7\.xn\-\-c35nf1622b\'\)\ throws\ error\ V3\ V6\ A4_2\ \[data\/IdnaTest\.txt\:4588\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----scp6252h.xn--zshy411yzpx2d", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-scp6252h\.xn\-\-zshy411yzpx2d\'\)\ throws\ error\ V3\ V6\ \[data\/IdnaTest\.txt\:4589\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}Ⴁ畝\x{200D}．≮", %p)},	undef,	"to_ascii\(\'\\u200CႡ畝\\u200D．\≮\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4590\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}Ⴁ畝\x{200D}．<\x{0338}", %p)},	undef,	"to_ascii\(\'\\u200CႡ畝\\u200D．\<\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4592\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}Ⴁ畝\x{200D}.≮", %p)},	undef,	"to_ascii\(\'\\u200CႡ畝\\u200D\.\≮\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4594\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}Ⴁ畝\x{200D}.<\x{0338}", %p)},	undef,	"to_ascii\(\'\\u200CႡ畝\\u200D\.\<\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4596\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}ⴁ畝\x{200D}.<\x{0338}", %p)},	undef,	"to_ascii\(\'\\u200Cⴁ畝\\u200D\.\<\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4598\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}ⴁ畝\x{200D}.≮", %p)},	undef,	"to_ascii\(\'\\u200Cⴁ畝\\u200D\.\≮\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4600\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--skjy82u.xn--gdh", %p)},	undef,	"to_ascii\(\'xn\-\-skjy82u\.xn\-\-gdh\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:4602\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--0ugc160hb36e.xn--gdh", %p)},	undef,	"to_ascii\(\'xn\-\-0ugc160hb36e\.xn\-\-gdh\'\)\ throws\ error\ C1\ C2\ V6\ \[data\/IdnaTest\.txt\:4603\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--8md0962c.xn--gdh", %p)},	undef,	"to_ascii\(\'xn\-\-8md0962c\.xn\-\-gdh\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:4604\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--8md700fea3748f.xn--gdh", %p)},	undef,	"to_ascii\(\'xn\-\-8md700fea3748f\.xn\-\-gdh\'\)\ throws\ error\ C1\ C2\ V6\ \[data\/IdnaTest\.txt\:4605\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}ⴁ畝\x{200D}．<\x{0338}", %p)},	undef,	"to_ascii\(\'\\u200Cⴁ畝\\u200D．\<\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4606\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}ⴁ畝\x{200D}．≮", %p)},	undef,	"to_ascii\(\'\\u200Cⴁ畝\\u200D．\≮\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4608\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("歷｡𐹻≯󳛽\x{200D}", %p)},	undef,	"to_ascii\(\'歷｡𐹻\≯\?\\u200D\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:4610\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("歷｡𐹻>\x{0338}󳛽\x{200D}", %p)},	undef,	"to_ascii\(\'歷｡𐹻\>\\u0338\?\\u200D\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:4612\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("歷。𐹻≯󳛽\x{200D}", %p)},	undef,	"to_ascii\(\'歷\。𐹻\≯\?\\u200D\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:4614\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("歷。𐹻>\x{0338}󳛽\x{200D}", %p)},	undef,	"to_ascii\(\'歷\。𐹻\>\\u0338\?\\u200D\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:4616\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--nmw.xn--hdh7804gdms2h", %p)},	undef,	"to_ascii\(\'xn\-\-nmw\.xn\-\-hdh7804gdms2h\'\)\ throws\ error\ B1\ V6\ \[data\/IdnaTest\.txt\:4618\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--nmw.xn--1ugx6gs128a1134j", %p)},	undef,	"to_ascii\(\'xn\-\-nmw\.xn\-\-1ugx6gs128a1134j\'\)\ throws\ error\ B1\ C2\ V6\ \[data\/IdnaTest\.txt\:4619\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0ECB}\x{200D}．鎁󠰑", %p)},	undef,	"to_ascii\(\'\\u0ECB\\u200D．鎁\?\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4620\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0ECB}\x{200D}.鎁󠰑", %p)},	undef,	"to_ascii\(\'\\u0ECB\\u200D\.鎁\?\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4622\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--t8c.xn--iz4a43209d", %p)},	undef,	"to_ascii\(\'xn\-\-t8c\.xn\-\-iz4a43209d\'\)\ throws\ error\ V5\ V6\ \[data\/IdnaTest\.txt\:4624\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--t8c059f.xn--iz4a43209d", %p)},	undef,	"to_ascii\(\'xn\-\-t8c059f\.xn\-\-iz4a43209d\'\)\ throws\ error\ C2\ V5\ V6\ \[data\/IdnaTest\.txt\:4625\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}\x{200C}𞤀｡𱘅𐶃", %p)},	undef,	"to_ascii\(\'\\u200D\\u200C𞤀｡𱘅\?\'\)\ throws\ error\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:4626\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}\x{200C}𞤀。𱘅𐶃", %p)},	undef,	"to_ascii\(\'\\u200D\\u200C𞤀\。𱘅\?\'\)\ throws\ error\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:4628\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}\x{200C}𞤢。𱘅𐶃", %p)},	undef,	"to_ascii\(\'\\u200D\\u200C𞤢\。𱘅\?\'\)\ throws\ error\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:4630\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--9d6h.xn--wh0dj799f", %p)},	undef,	"to_ascii\(\'xn\-\-9d6h\.xn\-\-wh0dj799f\'\)\ throws\ error\ B5\ B6\ V6\ \[data\/IdnaTest\.txt\:4632\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--0ugb45126a.xn--wh0dj799f", %p)},	undef,	"to_ascii\(\'xn\-\-0ugb45126a\.xn\-\-wh0dj799f\'\)\ throws\ error\ B1\ B5\ B6\ C1\ C2\ V6\ \[data\/IdnaTest\.txt\:4633\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}\x{200C}𞤢｡𱘅𐶃", %p)},	undef,	"to_ascii\(\'\\u200D\\u200C𞤢｡𱘅\?\'\)\ throws\ error\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:4634\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0628}≠𝟫-.ς⒍𐹦≠", %p)},	undef,	"to_ascii\(\'\\u0628\≠𝟫\-\.ς⒍𐹦\≠\'\)\ throws\ error\ B3\ B5\ B6\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:4636\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0628}=\x{0338}𝟫-.ς⒍𐹦=\x{0338}", %p)},	undef,	"to_ascii\(\'\\u0628\=\\u0338𝟫\-\.ς⒍𐹦\=\\u0338\'\)\ throws\ error\ B3\ B5\ B6\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:4638\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0628}≠9-.ς6.𐹦≠", %p)},	undef,	"to_ascii\(\'\\u0628\≠9\-\.ς6\.𐹦\≠\'\)\ throws\ error\ B1\ B3\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:4640\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0628}=\x{0338}9-.ς6.𐹦=\x{0338}", %p)},	undef,	"to_ascii\(\'\\u0628\=\\u03389\-\.ς6\.𐹦\=\\u0338\'\)\ throws\ error\ B1\ B3\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:4642\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0628}=\x{0338}9-.Σ6.𐹦=\x{0338}", %p)},	undef,	"to_ascii\(\'\\u0628\=\\u03389\-\.Σ6\.𐹦\=\\u0338\'\)\ throws\ error\ B1\ B3\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:4644\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0628}≠9-.Σ6.𐹦≠", %p)},	undef,	"to_ascii\(\'\\u0628\≠9\-\.Σ6\.𐹦\≠\'\)\ throws\ error\ B1\ B3\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:4645\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0628}≠9-.σ6.𐹦≠", %p)},	undef,	"to_ascii\(\'\\u0628\≠9\-\.σ6\.𐹦\≠\'\)\ throws\ error\ B1\ B3\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:4646\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0628}=\x{0338}9-.σ6.𐹦=\x{0338}", %p)},	undef,	"to_ascii\(\'\\u0628\=\\u03389\-\.σ6\.𐹦\=\\u0338\'\)\ throws\ error\ B1\ B3\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:4647\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--9--etd0100a.xn--6-zmb.xn--1ch8704g", %p)},	undef,	"to_ascii\(\'xn\-\-9\-\-etd0100a\.xn\-\-6\-zmb\.xn\-\-1ch8704g\'\)\ throws\ error\ B1\ B3\ V3\ V6\ \[data\/IdnaTest\.txt\:4648\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--9--etd0100a.xn--6-xmb.xn--1ch8704g", %p)},	undef,	"to_ascii\(\'xn\-\-9\-\-etd0100a\.xn\-\-6\-xmb\.xn\-\-1ch8704g\'\)\ throws\ error\ B1\ B3\ V3\ V6\ \[data\/IdnaTest\.txt\:4649\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0628}=\x{0338}𝟫-.Σ⒍𐹦=\x{0338}", %p)},	undef,	"to_ascii\(\'\\u0628\=\\u0338𝟫\-\.Σ⒍𐹦\=\\u0338\'\)\ throws\ error\ B3\ B5\ B6\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:4650\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0628}≠𝟫-.Σ⒍𐹦≠", %p)},	undef,	"to_ascii\(\'\\u0628\≠𝟫\-\.Σ⒍𐹦\≠\'\)\ throws\ error\ B3\ B5\ B6\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:4651\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0628}≠𝟫-.σ⒍𐹦≠", %p)},	undef,	"to_ascii\(\'\\u0628\≠𝟫\-\.σ⒍𐹦\≠\'\)\ throws\ error\ B3\ B5\ B6\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:4652\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0628}=\x{0338}𝟫-.σ⒍𐹦=\x{0338}", %p)},	undef,	"to_ascii\(\'\\u0628\=\\u0338𝟫\-\.σ⒍𐹦\=\\u0338\'\)\ throws\ error\ B3\ B5\ B6\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:4653\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--9--etd0100a.xn--4xa887mzpbzz04b", %p)},	undef,	"to_ascii\(\'xn\-\-9\-\-etd0100a\.xn\-\-4xa887mzpbzz04b\'\)\ throws\ error\ B3\ B5\ B6\ V3\ V6\ \[data\/IdnaTest\.txt\:4654\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--9--etd0100a.xn--3xa097mzpbzz04b", %p)},	undef,	"to_ascii\(\'xn\-\-9\-\-etd0100a\.xn\-\-3xa097mzpbzz04b\'\)\ throws\ error\ B3\ B5\ B6\ V3\ V6\ \[data\/IdnaTest\.txt\:4655\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򉛴.-ᡢ\x{0592}𝨠", %p)},	undef,	"to_ascii\(\'\?\.\-ᡢ\\u0592𝨠\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:4656\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--ep37b.xn----hec165lho83b", %p)},	undef,	"to_ascii\(\'xn\-\-ep37b\.xn\-\-\-\-hec165lho83b\'\)\ throws\ error\ V3\ V6\ \[data\/IdnaTest\.txt\:4657\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{06CB}⒈ß󠄽。񷋍-", %p)},	undef,	"to_ascii\(\'\\u06CB⒈ß\󠄽\。\?\-\'\)\ throws\ error\ B2\ B3\ B6\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:4658\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{06CB}1.ß󠄽。񷋍-", %p)},	undef,	"to_ascii\(\'\\u06CB1\.ß\󠄽\。\?\-\'\)\ throws\ error\ B6\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:4660\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{06CB}1.SS󠄽。񷋍-", %p)},	undef,	"to_ascii\(\'\\u06CB1\.SS\󠄽\。\?\-\'\)\ throws\ error\ B6\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:4662\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{06CB}1.ss󠄽。񷋍-", %p)},	undef,	"to_ascii\(\'\\u06CB1\.ss\󠄽\。\?\-\'\)\ throws\ error\ B6\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:4663\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{06CB}1.Ss󠄽。񷋍-", %p)},	undef,	"to_ascii\(\'\\u06CB1\.Ss\󠄽\。\?\-\'\)\ throws\ error\ B6\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:4664\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--1-cwc.ss.xn----q001f", %p)},	undef,	"to_ascii\(\'xn\-\-1\-cwc\.ss\.xn\-\-\-\-q001f\'\)\ throws\ error\ B6\ V3\ V6\ \[data\/IdnaTest\.txt\:4665\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--1-cwc.xn--zca.xn----q001f", %p)},	undef,	"to_ascii\(\'xn\-\-1\-cwc\.xn\-\-zca\.xn\-\-\-\-q001f\'\)\ throws\ error\ B6\ V3\ V6\ \[data\/IdnaTest\.txt\:4666\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{06CB}⒈SS󠄽。񷋍-", %p)},	undef,	"to_ascii\(\'\\u06CB⒈SS\󠄽\。\?\-\'\)\ throws\ error\ B2\ B3\ B6\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:4667\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{06CB}⒈ss󠄽。񷋍-", %p)},	undef,	"to_ascii\(\'\\u06CB⒈ss\󠄽\。\?\-\'\)\ throws\ error\ B2\ B3\ B6\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:4668\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{06CB}⒈Ss󠄽。񷋍-", %p)},	undef,	"to_ascii\(\'\\u06CB⒈Ss\󠄽\。\?\-\'\)\ throws\ error\ B2\ B3\ B6\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:4669\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--ss-d7d6651a.xn----q001f", %p)},	undef,	"to_ascii\(\'xn\-\-ss\-d7d6651a\.xn\-\-\-\-q001f\'\)\ throws\ error\ B2\ B3\ B6\ V3\ V6\ \[data\/IdnaTest\.txt\:4670\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--zca541ato3a.xn----q001f", %p)},	undef,	"to_ascii\(\'xn\-\-zca541ato3a\.xn\-\-\-\-q001f\'\)\ throws\ error\ B2\ B3\ B6\ V3\ V6\ \[data\/IdnaTest\.txt\:4671\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𿀫．\x{1BAA}ςႦ\x{200D}", %p)},	undef,	"to_ascii\(\'\?．\\u1BAAςႦ\\u200D\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4672\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𿀫.\x{1BAA}ςႦ\x{200D}", %p)},	undef,	"to_ascii\(\'\?\.\\u1BAAςႦ\\u200D\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4674\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𿀫.\x{1BAA}ςⴆ\x{200D}", %p)},	undef,	"to_ascii\(\'\?\.\\u1BAAςⴆ\\u200D\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4676\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𿀫.\x{1BAA}ΣႦ\x{200D}", %p)},	undef,	"to_ascii\(\'\?\.\\u1BAAΣႦ\\u200D\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4678\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𿀫.\x{1BAA}σⴆ\x{200D}", %p)},	undef,	"to_ascii\(\'\?\.\\u1BAAσⴆ\\u200D\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4680\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𿀫.\x{1BAA}Σⴆ\x{200D}", %p)},	undef,	"to_ascii\(\'\?\.\\u1BAAΣⴆ\\u200D\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4682\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--nu4s.xn--4xa153j7im", %p)},	undef,	"to_ascii\(\'xn\-\-nu4s\.xn\-\-4xa153j7im\'\)\ throws\ error\ V5\ V6\ \[data\/IdnaTest\.txt\:4684\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--nu4s.xn--4xa153jk8cs1q", %p)},	undef,	"to_ascii\(\'xn\-\-nu4s\.xn\-\-4xa153jk8cs1q\'\)\ throws\ error\ C2\ V5\ V6\ \[data\/IdnaTest\.txt\:4685\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--nu4s.xn--4xa217dxri", %p)},	undef,	"to_ascii\(\'xn\-\-nu4s\.xn\-\-4xa217dxri\'\)\ throws\ error\ V5\ V6\ \[data\/IdnaTest\.txt\:4686\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--nu4s.xn--4xa217dxriome", %p)},	undef,	"to_ascii\(\'xn\-\-nu4s\.xn\-\-4xa217dxriome\'\)\ throws\ error\ C2\ V5\ V6\ \[data\/IdnaTest\.txt\:4687\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--nu4s.xn--3xa353jk8cs1q", %p)},	undef,	"to_ascii\(\'xn\-\-nu4s\.xn\-\-3xa353jk8cs1q\'\)\ throws\ error\ C2\ V5\ V6\ \[data\/IdnaTest\.txt\:4688\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--nu4s.xn--3xa417dxriome", %p)},	undef,	"to_ascii\(\'xn\-\-nu4s\.xn\-\-3xa417dxriome\'\)\ throws\ error\ C2\ V5\ V6\ \[data\/IdnaTest\.txt\:4689\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𿀫．\x{1BAA}ςⴆ\x{200D}", %p)},	undef,	"to_ascii\(\'\?．\\u1BAAςⴆ\\u200D\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4690\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𿀫．\x{1BAA}ΣႦ\x{200D}", %p)},	undef,	"to_ascii\(\'\?．\\u1BAAΣႦ\\u200D\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4692\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𿀫．\x{1BAA}σⴆ\x{200D}", %p)},	undef,	"to_ascii\(\'\?．\\u1BAAσⴆ\\u200D\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4694\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𿀫．\x{1BAA}Σⴆ\x{200D}", %p)},	undef,	"to_ascii\(\'\?．\\u1BAAΣⴆ\\u200D\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4696\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⾆\x{08E2}.𝈴", %p)},	undef,	"to_ascii\(\'⾆\\u08E2\.𝈴\'\)\ throws\ error\ B1\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:4698\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("舌\x{08E2}.𝈴", %p)},	undef,	"to_ascii\(\'舌\\u08E2\.𝈴\'\)\ throws\ error\ B1\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:4699\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--l0b9413d.xn--kl1h", %p)},	undef,	"to_ascii\(\'xn\-\-l0b9413d\.xn\-\-kl1h\'\)\ throws\ error\ B1\ B5\ B6\ V6\ \[data\/IdnaTest\.txt\:4700\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⫞𐹶𖫴。⭠⒈", %p)},	undef,	"to_ascii\(\'\⫞𐹶𖫴\。\⭠⒈\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:4701\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("⫞𐹶𖫴。⭠1.", %p)},	undef,	"to_ascii\(\'\⫞𐹶𖫴\。\⭠1\.\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:4702\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--53ix188et88b.xn--1-h6r.", %p)},	undef,	"to_ascii\(\'xn\-\-53ix188et88b\.xn\-\-1\-h6r\.\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:4703\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--53ix188et88b.xn--tsh52w", %p)},	undef,	"to_ascii\(\'xn\-\-53ix188et88b\.xn\-\-tsh52w\'\)\ throws\ error\ B1\ V6\ \[data\/IdnaTest\.txt\:4704\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⒈\x{200C}\x{AAEC}︒．\x{0ACD}", %p)},	undef,	"to_ascii\(\'⒈\\u200C\\uAAEC︒．\\u0ACD\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4705\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_ascii("1.\x{200C}\x{AAEC}。.\x{0ACD}", %p)},	undef,	"to_ascii\(\'1\.\\u200C\\uAAEC\。\.\\u0ACD\'\)\ throws\ error\ V5\ A4_2\ \[data\/IdnaTest\.txt\:4707\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("1.xn--sv9a..xn--mfc", %p)},	undef,	"to_ascii\(\'1\.xn\-\-sv9a\.\.xn\-\-mfc\'\)\ throws\ error\ V5\ A4_2\ \[data\/IdnaTest\.txt\:4709\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("1.xn--0ug7185c..xn--mfc", %p)},	undef,	"to_ascii\(\'1\.xn\-\-0ug7185c\.\.xn\-\-mfc\'\)\ throws\ error\ C1\ V5\ A4_2\ \[data\/IdnaTest\.txt\:4710\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--tsh0720cse8b.xn--mfc", %p)},	undef,	"to_ascii\(\'xn\-\-tsh0720cse8b\.xn\-\-mfc\'\)\ throws\ error\ V5\ V6\ \[data\/IdnaTest\.txt\:4711\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--0ug78o720myr1c.xn--mfc", %p)},	undef,	"to_ascii\(\'xn\-\-0ug78o720myr1c\.xn\-\-mfc\'\)\ throws\ error\ C1\ V5\ V6\ \[data\/IdnaTest\.txt\:4712\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0C46}。䰀\x{0668}𞭅󠅼", %p)},	undef,	"to_ascii\(\'\\u0C46\。䰀\\u0668\?\󠅼\'\)\ throws\ error\ B1\ B3\ B5\ B6\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4713\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--eqc.xn--hib5476aim6t", %p)},	undef,	"to_ascii\(\'xn\-\-eqc\.xn\-\-hib5476aim6t\'\)\ throws\ error\ B1\ B3\ B5\ B6\ V5\ V6\ \[data\/IdnaTest\.txt\:4714\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ß\x{200D}.\x{1BF2}񄾼", %p)},	undef,	"to_ascii\(\'ß\\u200D\.\\u1BF2\?\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4715\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("SS\x{200D}.\x{1BF2}񄾼", %p)},	undef,	"to_ascii\(\'SS\\u200D\.\\u1BF2\?\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4717\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ss\x{200D}.\x{1BF2}񄾼", %p)},	undef,	"to_ascii\(\'ss\\u200D\.\\u1BF2\?\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4719\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ss\x{200D}.\x{1BF2}񄾼", %p)},	undef,	"to_ascii\(\'Ss\\u200D\.\\u1BF2\?\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4721\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ss.xn--0zf22107b", %p)},	undef,	"to_ascii\(\'ss\.xn\-\-0zf22107b\'\)\ throws\ error\ V5\ V6\ \[data\/IdnaTest\.txt\:4723\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--ss-n1t.xn--0zf22107b", %p)},	undef,	"to_ascii\(\'xn\-\-ss\-n1t\.xn\-\-0zf22107b\'\)\ throws\ error\ C2\ V5\ V6\ \[data\/IdnaTest\.txt\:4724\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--zca870n.xn--0zf22107b", %p)},	undef,	"to_ascii\(\'xn\-\-zca870n\.xn\-\-0zf22107b\'\)\ throws\ error\ C2\ V5\ V6\ \[data\/IdnaTest\.txt\:4725\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𑓂\x{200C}≮.≮", %p)},	undef,	"to_ascii\(\'𑓂\\u200C\≮\.\≮\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4726\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𑓂\x{200C}<\x{0338}.<\x{0338}", %p)},	undef,	"to_ascii\(\'𑓂\\u200C\<\\u0338\.\<\\u0338\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4728\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--gdhz656g.xn--gdh", %p)},	undef,	"to_ascii\(\'xn\-\-gdhz656g\.xn\-\-gdh\'\)\ throws\ error\ V5\ V6\ \[data\/IdnaTest\.txt\:4730\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--0ugy6glz29a.xn--gdh", %p)},	undef,	"to_ascii\(\'xn\-\-0ugy6glz29a\.xn\-\-gdh\'\)\ throws\ error\ V5\ V6\ \[data\/IdnaTest\.txt\:4731\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("🕼．\x{FFA0}", %p)},	undef,	"to_ascii\(\'🕼．\\uFFA0\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4732\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("🕼.\x{1160}", %p)},	undef,	"to_ascii\(\'🕼\.\\u1160\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4733\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--my8h.xn--psd", %p)},	undef,	"to_ascii\(\'xn\-\-my8h\.xn\-\-psd\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:4734\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--my8h.xn--cl7c", %p)},	undef,	"to_ascii\(\'xn\-\-my8h\.xn\-\-cl7c\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:4735\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᡔ\x{FD82}。񷘎", %p)},	undef,	"to_ascii\(\'ᡔ\\uFD82\。\?\'\)\ throws\ error\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:4736\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᡔ\x{0644}\x{062D}\x{0649}。񷘎", %p)},	undef,	"to_ascii\(\'ᡔ\\u0644\\u062D\\u0649\。\?\'\)\ throws\ error\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:4737\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--sgb9bq785p.xn--bc31b", %p)},	undef,	"to_ascii\(\'xn\-\-sgb9bq785p\.xn\-\-bc31b\'\)\ throws\ error\ B5\ B6\ V6\ \[data\/IdnaTest\.txt\:4738\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("爕򳙑．𝟰気", %p)},	undef,	"to_ascii\(\'爕\?．𝟰気\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4739\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("爕򳙑.4気", %p)},	undef,	"to_ascii\(\'爕\?\.4気\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4740\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--1zxq3199c.xn--4-678b", %p)},	undef,	"to_ascii\(\'xn\-\-1zxq3199c\.xn\-\-4\-678b\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:4741\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⒋𑍍Ⴝ-．𞬪\x{0DCA}\x{05B5}", %p)},	undef,	"to_ascii\(\'⒋𑍍Ⴝ\-．\?\\u0DCA\\u05B5\'\)\ throws\ error\ B1\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:4742\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("4.𑍍Ⴝ-.𞬪\x{0DCA}\x{05B5}", %p)},	undef,	"to_ascii\(\'4\.𑍍Ⴝ\-\.\?\\u0DCA\\u05B5\'\)\ throws\ error\ B1\ B6\ P1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:4743\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("4.𑍍ⴝ-.𞬪\x{0DCA}\x{05B5}", %p)},	undef,	"to_ascii\(\'4\.𑍍ⴝ\-\.\?\\u0DCA\\u05B5\'\)\ throws\ error\ B1\ B6\ P1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:4744\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("4.xn----wwsx259f.xn--ddb152b7y23b", %p)},	undef,	"to_ascii\(\'4\.xn\-\-\-\-wwsx259f\.xn\-\-ddb152b7y23b\'\)\ throws\ error\ B1\ B6\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:4745\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("4.xn----t1g9869q.xn--ddb152b7y23b", %p)},	undef,	"to_ascii\(\'4\.xn\-\-\-\-t1g9869q\.xn\-\-ddb152b7y23b\'\)\ throws\ error\ B1\ B6\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:4746\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⒋𑍍ⴝ-．𞬪\x{0DCA}\x{05B5}", %p)},	undef,	"to_ascii\(\'⒋𑍍ⴝ\-．\?\\u0DCA\\u05B5\'\)\ throws\ error\ B1\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:4747\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----jcp487avl3w.xn--ddb152b7y23b", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-jcp487avl3w\.xn\-\-ddb152b7y23b\'\)\ throws\ error\ B1\ V3\ V6\ \[data\/IdnaTest\.txt\:4748\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----t1g323mnk9t.xn--ddb152b7y23b", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-t1g323mnk9t\.xn\-\-ddb152b7y23b\'\)\ throws\ error\ B1\ V3\ V6\ \[data\/IdnaTest\.txt\:4749\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󞝃。򑆃񉢗--", %p)},	undef,	"to_ascii\(\'\?\。\?\?\-\-\'\)\ throws\ error\ P1\ V2\ V3\ V6\ \[data\/IdnaTest\.txt\:4750\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--2y75e.xn-----1l15eer88n", %p)},	undef,	"to_ascii\(\'xn\-\-2y75e\.xn\-\-\-\-\-1l15eer88n\'\)\ throws\ error\ V2\ V3\ V6\ \[data\/IdnaTest\.txt\:4751\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("\x{200D}\x{07DF}｡\x{200C}\x{ABED}", %p)},	undef,	"to_ascii\(\'\\u200D\\u07DF｡\\u200C\\uABED\'\)\ throws\ error\ B1\ B3\ B6\ V5\ \[data\/IdnaTest\.txt\:4752\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("\x{200D}\x{07DF}。\x{200C}\x{ABED}", %p)},	undef,	"to_ascii\(\'\\u200D\\u07DF\。\\u200C\\uABED\'\)\ throws\ error\ B1\ B3\ B6\ V5\ \[data\/IdnaTest\.txt\:4754\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--6sb.xn--429a", %p)},	undef,	"to_ascii\(\'xn\-\-6sb\.xn\-\-429a\'\)\ throws\ error\ B1\ B3\ B6\ V5\ \[data\/IdnaTest\.txt\:4756\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--6sb394j.xn--0ug1126c", %p)},	undef,	"to_ascii\(\'xn\-\-6sb394j\.xn\-\-0ug1126c\'\)\ throws\ error\ B1\ C1\ C2\ \[data\/IdnaTest\.txt\:4757\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𞮽\x{07FF}\x{084E}｡ᢍ򝹁𐫘", %p)},	undef,	"to_ascii\(\'\?\\u07FF\\u084E｡ᢍ\?𐫘\'\)\ throws\ error\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:4758\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𞮽\x{07FF}\x{084E}。ᢍ򝹁𐫘", %p)},	undef,	"to_ascii\(\'\?\\u07FF\\u084E\。ᢍ\?𐫘\'\)\ throws\ error\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:4759\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--3tb2nz468k.xn--69e8615j5rn5d", %p)},	undef,	"to_ascii\(\'xn\-\-3tb2nz468k\.xn\-\-69e8615j5rn5d\'\)\ throws\ error\ B5\ B6\ V6\ \[data\/IdnaTest\.txt\:4760\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("\x{06ED}𞺌𑄚\x{1714}.ꡞ\x{08B7}", %p)},	undef,	"to_ascii\(\'\\u06ED𞺌𑄚\\u1714\.ꡞ\\u08B7\'\)\ throws\ error\ B1\ B5\ B6\ V5\ \[data\/IdnaTest\.txt\:4761\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("\x{06ED}\x{0645}𑄚\x{1714}.ꡞ\x{08B7}", %p)},	undef,	"to_ascii\(\'\\u06ED\\u0645𑄚\\u1714\.ꡞ\\u08B7\'\)\ throws\ error\ B1\ B5\ B6\ V5\ \[data\/IdnaTest\.txt\:4762\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--hhb94ag41b739u.xn--dzb5582f", %p)},	undef,	"to_ascii\(\'xn\-\-hhb94ag41b739u\.xn\-\-dzb5582f\'\)\ throws\ error\ B1\ B5\ B6\ V5\ \[data\/IdnaTest\.txt\:4763\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񻂵킃𑘶\x{07DC}｡ς\x{063C}ς", %p)},	undef,	"to_ascii\(\'\?킃𑘶\\u07DC｡ς\\u063Cς\'\)\ throws\ error\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:4764\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񻂵킃𑘶\x{07DC}｡ς\x{063C}ς", %p)},	undef,	"to_ascii\(\'\?킃𑘶\\u07DC｡ς\\u063Cς\'\)\ throws\ error\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:4766\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񻂵킃𑘶\x{07DC}。ς\x{063C}ς", %p)},	undef,	"to_ascii\(\'\?킃𑘶\\u07DC\。ς\\u063Cς\'\)\ throws\ error\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:4768\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񻂵킃𑘶\x{07DC}。ς\x{063C}ς", %p)},	undef,	"to_ascii\(\'\?킃𑘶\\u07DC\。ς\\u063Cς\'\)\ throws\ error\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:4770\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񻂵킃𑘶\x{07DC}。Σ\x{063C}Σ", %p)},	undef,	"to_ascii\(\'\?킃𑘶\\u07DC\。Σ\\u063CΣ\'\)\ throws\ error\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:4772\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񻂵킃𑘶\x{07DC}。Σ\x{063C}Σ", %p)},	undef,	"to_ascii\(\'\?킃𑘶\\u07DC\。Σ\\u063CΣ\'\)\ throws\ error\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:4773\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񻂵킃𑘶\x{07DC}。σ\x{063C}σ", %p)},	undef,	"to_ascii\(\'\?킃𑘶\\u07DC\。σ\\u063Cσ\'\)\ throws\ error\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:4774\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񻂵킃𑘶\x{07DC}。σ\x{063C}σ", %p)},	undef,	"to_ascii\(\'\?킃𑘶\\u07DC\。σ\\u063Cσ\'\)\ throws\ error\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:4775\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񻂵킃𑘶\x{07DC}。Σ\x{063C}σ", %p)},	undef,	"to_ascii\(\'\?킃𑘶\\u07DC\。Σ\\u063Cσ\'\)\ throws\ error\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:4776\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񻂵킃𑘶\x{07DC}。Σ\x{063C}σ", %p)},	undef,	"to_ascii\(\'\?킃𑘶\\u07DC\。Σ\\u063Cσ\'\)\ throws\ error\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:4777\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--3sb7483hoyvbbe76g.xn--4xaa21q", %p)},	undef,	"to_ascii\(\'xn\-\-3sb7483hoyvbbe76g\.xn\-\-4xaa21q\'\)\ throws\ error\ B5\ B6\ V6\ \[data\/IdnaTest\.txt\:4778\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񻂵킃𑘶\x{07DC}。Σ\x{063C}ς", %p)},	undef,	"to_ascii\(\'\?킃𑘶\\u07DC\。Σ\\u063Cς\'\)\ throws\ error\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:4779\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񻂵킃𑘶\x{07DC}。Σ\x{063C}ς", %p)},	undef,	"to_ascii\(\'\?킃𑘶\\u07DC\。Σ\\u063Cς\'\)\ throws\ error\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:4781\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񻂵킃𑘶\x{07DC}。σ\x{063C}ς", %p)},	undef,	"to_ascii\(\'\?킃𑘶\\u07DC\。σ\\u063Cς\'\)\ throws\ error\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:4783\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񻂵킃𑘶\x{07DC}。σ\x{063C}ς", %p)},	undef,	"to_ascii\(\'\?킃𑘶\\u07DC\。σ\\u063Cς\'\)\ throws\ error\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:4785\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--3sb7483hoyvbbe76g.xn--3xab31q", %p)},	undef,	"to_ascii\(\'xn\-\-3sb7483hoyvbbe76g\.xn\-\-3xab31q\'\)\ throws\ error\ B5\ B6\ V6\ \[data\/IdnaTest\.txt\:4787\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--3sb7483hoyvbbe76g.xn--3xaa51q", %p)},	undef,	"to_ascii\(\'xn\-\-3sb7483hoyvbbe76g\.xn\-\-3xaa51q\'\)\ throws\ error\ B5\ B6\ V6\ \[data\/IdnaTest\.txt\:4788\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񻂵킃𑘶\x{07DC}｡Σ\x{063C}Σ", %p)},	undef,	"to_ascii\(\'\?킃𑘶\\u07DC｡Σ\\u063CΣ\'\)\ throws\ error\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:4789\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񻂵킃𑘶\x{07DC}｡Σ\x{063C}Σ", %p)},	undef,	"to_ascii\(\'\?킃𑘶\\u07DC｡Σ\\u063CΣ\'\)\ throws\ error\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:4790\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񻂵킃𑘶\x{07DC}｡σ\x{063C}σ", %p)},	undef,	"to_ascii\(\'\?킃𑘶\\u07DC｡σ\\u063Cσ\'\)\ throws\ error\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:4791\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񻂵킃𑘶\x{07DC}｡σ\x{063C}σ", %p)},	undef,	"to_ascii\(\'\?킃𑘶\\u07DC｡σ\\u063Cσ\'\)\ throws\ error\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:4792\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񻂵킃𑘶\x{07DC}｡Σ\x{063C}σ", %p)},	undef,	"to_ascii\(\'\?킃𑘶\\u07DC｡Σ\\u063Cσ\'\)\ throws\ error\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:4793\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񻂵킃𑘶\x{07DC}｡Σ\x{063C}σ", %p)},	undef,	"to_ascii\(\'\?킃𑘶\\u07DC｡Σ\\u063Cσ\'\)\ throws\ error\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:4794\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񻂵킃𑘶\x{07DC}｡Σ\x{063C}ς", %p)},	undef,	"to_ascii\(\'\?킃𑘶\\u07DC｡Σ\\u063Cς\'\)\ throws\ error\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:4795\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񻂵킃𑘶\x{07DC}｡Σ\x{063C}ς", %p)},	undef,	"to_ascii\(\'\?킃𑘶\\u07DC｡Σ\\u063Cς\'\)\ throws\ error\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:4797\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񻂵킃𑘶\x{07DC}｡σ\x{063C}ς", %p)},	undef,	"to_ascii\(\'\?킃𑘶\\u07DC｡σ\\u063Cς\'\)\ throws\ error\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:4799\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񻂵킃𑘶\x{07DC}｡σ\x{063C}ς", %p)},	undef,	"to_ascii\(\'\?킃𑘶\\u07DC｡σ\\u063Cς\'\)\ throws\ error\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:4801\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("蔰。󠁹\x{08DD}-𑈵", %p)},	undef,	"to_ascii\(\'蔰\。\?\\u08DD\-𑈵\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4803\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--sz1a.xn----mrd9984r3dl0i", %p)},	undef,	"to_ascii\(\'xn\-\-sz1a\.xn\-\-\-\-mrd9984r3dl0i\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:4804\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ςჅ。\x{075A}", %p)},	undef,	"to_ascii\(\'ςჅ\。\\u075A\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4805\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("ςⴥ。\x{075A}", %p)},	"xn--4xa203s.xn--epb",	"to_ascii\(\'ςⴥ\。\\u075A\'\)\ \[data\/IdnaTest\.txt\:4807\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("ΣჅ。\x{075A}", %p)},	undef,	"to_ascii\(\'ΣჅ\。\\u075A\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4809\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("σⴥ。\x{075A}", %p)},	"xn--4xa203s.xn--epb",	"to_ascii\(\'σⴥ\。\\u075A\'\)\ \[data\/IdnaTest\.txt\:4810\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("Σⴥ。\x{075A}", %p)},	"xn--4xa203s.xn--epb",	"to_ascii\(\'Σⴥ\。\\u075A\'\)\ \[data\/IdnaTest\.txt\:4811\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("xn--4xa203s.xn--epb", %p)},	"xn--4xa203s.xn--epb",	"to_ascii\(\'xn\-\-4xa203s\.xn\-\-epb\'\)\ \[data\/IdnaTest\.txt\:4812\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("σⴥ.\x{075A}", %p)},	"xn--4xa203s.xn--epb",	"to_ascii\(\'σⴥ\.\\u075A\'\)\ \[data\/IdnaTest\.txt\:4813\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("ΣჅ.\x{075A}", %p)},	undef,	"to_ascii\(\'ΣჅ\.\\u075A\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4814\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("Σⴥ.\x{075A}", %p)},	"xn--4xa203s.xn--epb",	"to_ascii\(\'Σⴥ\.\\u075A\'\)\ \[data\/IdnaTest\.txt\:4815\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--4xa477d.xn--epb", %p)},	undef,	"to_ascii\(\'xn\-\-4xa477d\.xn\-\-epb\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:4816\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("xn--3xa403s.xn--epb", %p)},	"xn--3xa403s.xn--epb",	"to_ascii\(\'xn\-\-3xa403s\.xn\-\-epb\'\)\ \[data\/IdnaTest\.txt\:4817\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("ςⴥ.\x{075A}", %p)},	"xn--4xa203s.xn--epb",	"to_ascii\(\'ςⴥ\.\\u075A\'\)\ \[data\/IdnaTest\.txt\:4818\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--3xa677d.xn--epb", %p)},	undef,	"to_ascii\(\'xn\-\-3xa677d\.xn\-\-epb\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:4820\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0C4D}Ⴉ𞰓．\x{1B72}", %p)},	undef,	"to_ascii\(\'\\u0C4DႩ\?．\\u1B72\'\)\ throws\ error\ B1\ B3\ B6\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4821\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0C4D}Ⴉ𞰓.\x{1B72}", %p)},	undef,	"to_ascii\(\'\\u0C4DႩ\?\.\\u1B72\'\)\ throws\ error\ B1\ B3\ B6\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4822\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0C4D}ⴉ𞰓.\x{1B72}", %p)},	undef,	"to_ascii\(\'\\u0C4Dⴉ\?\.\\u1B72\'\)\ throws\ error\ B1\ B3\ B6\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4823\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--lqc478nlr02a.xn--dwf", %p)},	undef,	"to_ascii\(\'xn\-\-lqc478nlr02a\.xn\-\-dwf\'\)\ throws\ error\ B1\ B3\ B6\ V5\ V6\ \[data\/IdnaTest\.txt\:4824\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--lqc64t7t26c.xn--dwf", %p)},	undef,	"to_ascii\(\'xn\-\-lqc64t7t26c\.xn\-\-dwf\'\)\ throws\ error\ B1\ B3\ B6\ V5\ V6\ \[data\/IdnaTest\.txt\:4825\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0C4D}ⴉ𞰓．\x{1B72}", %p)},	undef,	"to_ascii\(\'\\u0C4Dⴉ\?．\\u1B72\'\)\ throws\ error\ B1\ B3\ B6\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4826\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⮷≮񎈴󠄟。𐠄", %p)},	undef,	"to_ascii\(\'\⮷\≮\?\󠄟\。𐠄\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:4827\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⮷<\x{0338}񎈴󠄟。𐠄", %p)},	undef,	"to_ascii\(\'\⮷\<\\u0338\?\󠄟\。𐠄\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:4828\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--gdh877a3513h.xn--pc9c", %p)},	undef,	"to_ascii\(\'xn\-\-gdh877a3513h\.xn\-\-pc9c\'\)\ throws\ error\ B1\ V6\ \[data\/IdnaTest\.txt\:4829\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{06BC}｡\x{200D}ẏ\x{200C}ᡤ", %p)},	"xn--vkb.xn--08e172a",	"to_ascii\(\'\\u06BC｡\\u200Dẏ\\u200Cᡤ\'\)\ \[data\/IdnaTest\.txt\:4830\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{06BC}｡\x{200D}y\x{0307}\x{200C}ᡤ", %p)},	"xn--vkb.xn--08e172a",	"to_ascii\(\'\\u06BC｡\\u200Dy\\u0307\\u200Cᡤ\'\)\ \[data\/IdnaTest\.txt\:4832\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{06BC}。\x{200D}ẏ\x{200C}ᡤ", %p)},	"xn--vkb.xn--08e172a",	"to_ascii\(\'\\u06BC\。\\u200Dẏ\\u200Cᡤ\'\)\ \[data\/IdnaTest\.txt\:4834\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{06BC}。\x{200D}y\x{0307}\x{200C}ᡤ", %p)},	"xn--vkb.xn--08e172a",	"to_ascii\(\'\\u06BC\。\\u200Dy\\u0307\\u200Cᡤ\'\)\ \[data\/IdnaTest\.txt\:4836\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{06BC}。\x{200D}Y\x{0307}\x{200C}ᡤ", %p)},	"xn--vkb.xn--08e172a",	"to_ascii\(\'\\u06BC\。\\u200DY\\u0307\\u200Cᡤ\'\)\ \[data\/IdnaTest\.txt\:4838\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{06BC}。\x{200D}Ẏ\x{200C}ᡤ", %p)},	"xn--vkb.xn--08e172a",	"to_ascii\(\'\\u06BC\。\\u200DẎ\\u200Cᡤ\'\)\ \[data\/IdnaTest\.txt\:4840\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--vkb.xn--08e172a", %p)},	"xn--vkb.xn--08e172a",	"to_ascii\(\'xn\-\-vkb\.xn\-\-08e172a\'\)\ \[data\/IdnaTest\.txt\:4842\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{06BC}.ẏᡤ", %p)},	"xn--vkb.xn--08e172a",	"to_ascii\(\'\\u06BC\.ẏᡤ\'\)\ \[data\/IdnaTest\.txt\:4843\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{06BC}.y\x{0307}ᡤ", %p)},	"xn--vkb.xn--08e172a",	"to_ascii\(\'\\u06BC\.y\\u0307ᡤ\'\)\ \[data\/IdnaTest\.txt\:4844\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{06BC}.Y\x{0307}ᡤ", %p)},	"xn--vkb.xn--08e172a",	"to_ascii\(\'\\u06BC\.Y\\u0307ᡤ\'\)\ \[data\/IdnaTest\.txt\:4845\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{06BC}.Ẏᡤ", %p)},	"xn--vkb.xn--08e172a",	"to_ascii\(\'\\u06BC\.Ẏᡤ\'\)\ \[data\/IdnaTest\.txt\:4846\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--vkb.xn--08e172ax6aca", %p)},	undef,	"to_ascii\(\'xn\-\-vkb\.xn\-\-08e172ax6aca\'\)\ throws\ error\ B1\ C1\ C2\ \[data\/IdnaTest\.txt\:4847\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{06BC}｡\x{200D}Y\x{0307}\x{200C}ᡤ", %p)},	"xn--vkb.xn--08e172a",	"to_ascii\(\'\\u06BC｡\\u200DY\\u0307\\u200Cᡤ\'\)\ \[data\/IdnaTest\.txt\:4848\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{06BC}｡\x{200D}Ẏ\x{200C}ᡤ", %p)},	"xn--vkb.xn--08e172a",	"to_ascii\(\'\\u06BC｡\\u200DẎ\\u200Cᡤ\'\)\ \[data\/IdnaTest\.txt\:4850\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐹹𑲛。񑂐\x{0DCA}", %p)},	undef,	"to_ascii\(\'𐹹𑲛\。\?\\u0DCA\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:4852\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--xo0dg5v.xn--h1c39876d", %p)},	undef,	"to_ascii\(\'xn\-\-xo0dg5v\.xn\-\-h1c39876d\'\)\ throws\ error\ B1\ V6\ \[data\/IdnaTest\.txt\:4853\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-≠𑈵｡嵕\x{FEF1}۴\x{A953}", %p)},	undef,	"to_ascii\(\'\-\≠𑈵｡嵕\\uFEF1۴\\uA953\'\)\ throws\ error\ B1\ B5\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:4854\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-=\x{0338}𑈵｡嵕\x{FEF1}۴\x{A953}", %p)},	undef,	"to_ascii\(\'\-\=\\u0338𑈵｡嵕\\uFEF1۴\\uA953\'\)\ throws\ error\ B1\ B5\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:4855\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-≠𑈵。嵕\x{064A}۴\x{A953}", %p)},	undef,	"to_ascii\(\'\-\≠𑈵\。嵕\\u064A۴\\uA953\'\)\ throws\ error\ B1\ B5\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:4856\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-=\x{0338}𑈵。嵕\x{064A}۴\x{A953}", %p)},	undef,	"to_ascii\(\'\-\=\\u0338𑈵\。嵕\\u064A۴\\uA953\'\)\ throws\ error\ B1\ B5\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:4857\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----ufo4749h.xn--mhb45a235sns3c", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-ufo4749h\.xn\-\-mhb45a235sns3c\'\)\ throws\ error\ B1\ B5\ V3\ V6\ \[data\/IdnaTest\.txt\:4858\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}񍸰𐹶\x{076E}．\x{06C1}\x{200D}≯\x{200D}", %p)},	undef,	"to_ascii\(\'\\u200C\?𐹶\\u076E．\\u06C1\\u200D\≯\\u200D\'\)\ throws\ error\ B3\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:4859\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}񍸰𐹶\x{076E}．\x{06C1}\x{200D}>\x{0338}\x{200D}", %p)},	undef,	"to_ascii\(\'\\u200C\?𐹶\\u076E．\\u06C1\\u200D\>\\u0338\\u200D\'\)\ throws\ error\ B3\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:4861\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}񍸰𐹶\x{076E}.\x{06C1}\x{200D}≯\x{200D}", %p)},	undef,	"to_ascii\(\'\\u200C\?𐹶\\u076E\.\\u06C1\\u200D\≯\\u200D\'\)\ throws\ error\ B3\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:4863\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}񍸰𐹶\x{076E}.\x{06C1}\x{200D}>\x{0338}\x{200D}", %p)},	undef,	"to_ascii\(\'\\u200C\?𐹶\\u076E\.\\u06C1\\u200D\>\\u0338\\u200D\'\)\ throws\ error\ B3\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:4865\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--ypb5875khz9y.xn--0kb682l", %p)},	undef,	"to_ascii\(\'xn\-\-ypb5875khz9y\.xn\-\-0kb682l\'\)\ throws\ error\ B3\ B5\ B6\ V6\ \[data\/IdnaTest\.txt\:4867\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--ypb717jrx2o7v94a.xn--0kb660ka35v", %p)},	undef,	"to_ascii\(\'xn\-\-ypb717jrx2o7v94a\.xn\-\-0kb660ka35v\'\)\ throws\ error\ B1\ B3\ C1\ C2\ V6\ \[data\/IdnaTest\.txt\:4868\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≮．\x{17B5}\x{0855}𐫔", %p)},	undef,	"to_ascii\(\'\≮．\\u17B5\\u0855𐫔\'\)\ throws\ error\ B1\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4869\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("<\x{0338}．\x{17B5}\x{0855}𐫔", %p)},	undef,	"to_ascii\(\'\<\\u0338．\\u17B5\\u0855𐫔\'\)\ throws\ error\ B1\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4870\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≮.\x{17B5}\x{0855}𐫔", %p)},	undef,	"to_ascii\(\'\≮\.\\u17B5\\u0855𐫔\'\)\ throws\ error\ B1\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4871\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("<\x{0338}.\x{17B5}\x{0855}𐫔", %p)},	undef,	"to_ascii\(\'\<\\u0338\.\\u17B5\\u0855𐫔\'\)\ throws\ error\ B1\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4872\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--gdh.xn--kwb589e217p", %p)},	undef,	"to_ascii\(\'xn\-\-gdh\.xn\-\-kwb589e217p\'\)\ throws\ error\ B1\ V5\ V6\ \[data\/IdnaTest\.txt\:4873\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐩗\x{200D}｡ႩႵ", %p)},	undef,	"to_ascii\(\'𐩗\\u200D｡ႩႵ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4874\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐩗\x{200D}。ႩႵ", %p)},	undef,	"to_ascii\(\'𐩗\\u200D\。ႩႵ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4876\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("𐩗\x{200D}。ⴉⴕ", %p)},	"xn--pt9c.xn--0kjya",	"to_ascii\(\'𐩗\\u200D\。ⴉⴕ\'\)\ \[data\/IdnaTest\.txt\:4878\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("𐩗\x{200D}。Ⴉⴕ", %p)},	undef,	"to_ascii\(\'𐩗\\u200D\。Ⴉⴕ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4880\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--pt9c.xn--hnd666l", %p)},	undef,	"to_ascii\(\'xn\-\-pt9c\.xn\-\-hnd666l\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:4882\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--1ug4933g.xn--hnd666l", %p)},	undef,	"to_ascii\(\'xn\-\-1ug4933g\.xn\-\-hnd666l\'\)\ throws\ error\ B3\ C2\ V6\ \[data\/IdnaTest\.txt\:4883\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("xn--pt9c.xn--0kjya", %p)},	"xn--pt9c.xn--0kjya",	"to_ascii\(\'xn\-\-pt9c\.xn\-\-0kjya\'\)\ \[data\/IdnaTest\.txt\:4884\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("𐩗.ⴉⴕ", %p)},	"xn--pt9c.xn--0kjya",	"to_ascii\(\'𐩗\.ⴉⴕ\'\)\ \[data\/IdnaTest\.txt\:4885\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("𐩗.ႩႵ", %p)},	undef,	"to_ascii\(\'𐩗\.ႩႵ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4886\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐩗.Ⴉⴕ", %p)},	undef,	"to_ascii\(\'𐩗\.Ⴉⴕ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4887\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--pt9c.xn--hndy", %p)},	undef,	"to_ascii\(\'xn\-\-pt9c\.xn\-\-hndy\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:4888\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--1ug4933g.xn--0kjya", %p)},	undef,	"to_ascii\(\'xn\-\-1ug4933g\.xn\-\-0kjya\'\)\ throws\ error\ B3\ C2\ \[data\/IdnaTest\.txt\:4889\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--1ug4933g.xn--hndy", %p)},	undef,	"to_ascii\(\'xn\-\-1ug4933g\.xn\-\-hndy\'\)\ throws\ error\ B3\ C2\ V6\ \[data\/IdnaTest\.txt\:4890\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("𐩗\x{200D}｡ⴉⴕ", %p)},	"xn--pt9c.xn--0kjya",	"to_ascii\(\'𐩗\\u200D｡ⴉⴕ\'\)\ \[data\/IdnaTest\.txt\:4891\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("𐩗\x{200D}｡Ⴉⴕ", %p)},	undef,	"to_ascii\(\'𐩗\\u200D｡Ⴉⴕ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4893\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}\x{200C}ㄤ．\x{032E}󕨑\x{09C2}", %p)},	undef,	"to_ascii\(\'\\u200C\\u200Cㄤ．\\u032E\?\\u09C2\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4895\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}\x{200C}ㄤ.\x{032E}󕨑\x{09C2}", %p)},	undef,	"to_ascii\(\'\\u200C\\u200Cㄤ\.\\u032E\?\\u09C2\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4897\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--1fk.xn--vta284a9o563a", %p)},	undef,	"to_ascii\(\'xn\-\-1fk\.xn\-\-vta284a9o563a\'\)\ throws\ error\ V5\ V6\ \[data\/IdnaTest\.txt\:4899\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--0uga242k.xn--vta284a9o563a", %p)},	undef,	"to_ascii\(\'xn\-\-0uga242k\.xn\-\-vta284a9o563a\'\)\ throws\ error\ C1\ V5\ V6\ \[data\/IdnaTest\.txt\:4900\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐋻｡-\x{200C}𐫄Ⴗ", %p)},	undef,	"to_ascii\(\'𐋻｡\-\\u200C𐫄Ⴗ\'\)\ throws\ error\ B1\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:4901\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐋻。-\x{200C}𐫄Ⴗ", %p)},	undef,	"to_ascii\(\'𐋻\。\-\\u200C𐫄Ⴗ\'\)\ throws\ error\ B1\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:4903\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("𐋻。-\x{200C}𐫄ⴗ", %p)},	undef,	"to_ascii\(\'𐋻\。\-\\u200C𐫄ⴗ\'\)\ throws\ error\ B1\ V3\ \[data\/IdnaTest\.txt\:4905\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--v97c.xn----lws0526f", %p)},	undef,	"to_ascii\(\'xn\-\-v97c\.xn\-\-\-\-lws0526f\'\)\ throws\ error\ B1\ V3\ \[data\/IdnaTest\.txt\:4907\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--v97c.xn----sgnv20du99s", %p)},	undef,	"to_ascii\(\'xn\-\-v97c\.xn\-\-\-\-sgnv20du99s\'\)\ throws\ error\ B1\ C1\ V3\ \[data\/IdnaTest\.txt\:4908\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--v97c.xn----i1g2513q", %p)},	undef,	"to_ascii\(\'xn\-\-v97c\.xn\-\-\-\-i1g2513q\'\)\ throws\ error\ B1\ V3\ V6\ \[data\/IdnaTest\.txt\:4909\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--v97c.xn----i1g888ih12u", %p)},	undef,	"to_ascii\(\'xn\-\-v97c\.xn\-\-\-\-i1g888ih12u\'\)\ throws\ error\ B1\ C1\ V3\ V6\ \[data\/IdnaTest\.txt\:4910\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("𐋻｡-\x{200C}𐫄ⴗ", %p)},	undef,	"to_ascii\(\'𐋻｡\-\\u200C𐫄ⴗ\'\)\ throws\ error\ B1\ V3\ \[data\/IdnaTest\.txt\:4911\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("🙑𐷺．≠\x{200C}", %p)},	undef,	"to_ascii\(\'🙑\?．\≠\\u200C\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:4913\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("🙑𐷺．=\x{0338}\x{200C}", %p)},	undef,	"to_ascii\(\'🙑\?．\=\\u0338\\u200C\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:4915\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("🙑𐷺.≠\x{200C}", %p)},	undef,	"to_ascii\(\'🙑\?\.\≠\\u200C\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:4917\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("🙑𐷺.=\x{0338}\x{200C}", %p)},	undef,	"to_ascii\(\'🙑\?\.\=\\u0338\\u200C\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:4919\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--bl0dh970b.xn--1ch", %p)},	undef,	"to_ascii\(\'xn\-\-bl0dh970b\.xn\-\-1ch\'\)\ throws\ error\ B1\ V6\ \[data\/IdnaTest\.txt\:4921\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--bl0dh970b.xn--0ug83g", %p)},	undef,	"to_ascii\(\'xn\-\-bl0dh970b\.xn\-\-0ug83g\'\)\ throws\ error\ B1\ C1\ V6\ \[data\/IdnaTest\.txt\:4922\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{064C}\x{1CD2}｡𞮞\x{2D7F}⧎", %p)},	undef,	"to_ascii\(\'\\u064C\\u1CD2｡\?\\u2D7F\⧎\'\)\ throws\ error\ B1\ B3\ B6\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4923\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{064C}\x{1CD2}。𞮞\x{2D7F}⧎", %p)},	undef,	"to_ascii\(\'\\u064C\\u1CD2\。\?\\u2D7F\⧎\'\)\ throws\ error\ B1\ B3\ B6\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4924\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--ohb646i.xn--ewi38jf765c", %p)},	undef,	"to_ascii\(\'xn\-\-ohb646i\.xn\-\-ewi38jf765c\'\)\ throws\ error\ B1\ B3\ B6\ V5\ V6\ \[data\/IdnaTest\.txt\:4925\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴔ𝨨₃󠁦．𝟳𑂹\x{0B82}", %p)},	undef,	"to_ascii\(\'Ⴔ𝨨₃\?．𝟳𑂹\\u0B82\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4926\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴔ𝨨3󠁦.7𑂹\x{0B82}", %p)},	undef,	"to_ascii\(\'Ⴔ𝨨3\?\.7𑂹\\u0B82\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4927\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⴔ𝨨3󠁦.7𑂹\x{0B82}", %p)},	undef,	"to_ascii\(\'ⴔ𝨨3\?\.7𑂹\\u0B82\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4928\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--3-ews6985n35s3g.xn--7-cve6271r", %p)},	undef,	"to_ascii\(\'xn\-\-3\-ews6985n35s3g\.xn\-\-7\-cve6271r\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:4929\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--3-b1g83426a35t0g.xn--7-cve6271r", %p)},	undef,	"to_ascii\(\'xn\-\-3\-b1g83426a35t0g\.xn\-\-7\-cve6271r\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:4930\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⴔ𝨨₃󠁦．𝟳𑂹\x{0B82}", %p)},	undef,	"to_ascii\(\'ⴔ𝨨₃\?．𝟳𑂹\\u0B82\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4931\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("䏈\x{200C}。\x{200C}⒈񱢕", %p)},	undef,	"to_ascii\(\'䏈\\u200C\。\\u200C⒈\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4932\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("䏈\x{200C}。\x{200C}1.񱢕", %p)},	undef,	"to_ascii\(\'䏈\\u200C\。\\u200C1\.\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4934\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--eco.1.xn--ms39a", %p)},	undef,	"to_ascii\(\'xn\-\-eco\.1\.xn\-\-ms39a\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:4936\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--0ug491l.xn--1-rgn.xn--ms39a", %p)},	undef,	"to_ascii\(\'xn\-\-0ug491l\.xn\-\-1\-rgn\.xn\-\-ms39a\'\)\ throws\ error\ C1\ V6\ \[data\/IdnaTest\.txt\:4937\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--eco.xn--tsh21126d", %p)},	undef,	"to_ascii\(\'xn\-\-eco\.xn\-\-tsh21126d\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:4938\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--0ug491l.xn--0ug88oot66q", %p)},	undef,	"to_ascii\(\'xn\-\-0ug491l\.xn\-\-0ug88oot66q\'\)\ throws\ error\ C1\ V6\ \[data\/IdnaTest\.txt\:4939\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("１\x{AAF6}ß𑲥｡\x{1DD8}", %p)},	undef,	"to_ascii\(\'１\\uAAF6ß𑲥｡\\u1DD8\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:4940\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("1\x{AAF6}ß𑲥。\x{1DD8}", %p)},	undef,	"to_ascii\(\'1\\uAAF6ß𑲥\。\\u1DD8\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:4942\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("1\x{AAF6}SS𑲥。\x{1DD8}", %p)},	undef,	"to_ascii\(\'1\\uAAF6SS𑲥\。\\u1DD8\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:4944\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("1\x{AAF6}ss𑲥。\x{1DD8}", %p)},	undef,	"to_ascii\(\'1\\uAAF6ss𑲥\。\\u1DD8\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:4945\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("1\x{AAF6}Ss𑲥。\x{1DD8}", %p)},	undef,	"to_ascii\(\'1\\uAAF6Ss𑲥\。\\u1DD8\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:4946\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--1ss-ir6ln166b.xn--weg", %p)},	undef,	"to_ascii\(\'xn\-\-1ss\-ir6ln166b\.xn\-\-weg\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:4947\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--1-qfa2471kdb0d.xn--weg", %p)},	undef,	"to_ascii\(\'xn\-\-1\-qfa2471kdb0d\.xn\-\-weg\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:4948\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("１\x{AAF6}SS𑲥｡\x{1DD8}", %p)},	undef,	"to_ascii\(\'１\\uAAF6SS𑲥｡\\u1DD8\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:4949\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("１\x{AAF6}ss𑲥｡\x{1DD8}", %p)},	undef,	"to_ascii\(\'１\\uAAF6ss𑲥｡\\u1DD8\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:4950\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("１\x{AAF6}Ss𑲥｡\x{1DD8}", %p)},	undef,	"to_ascii\(\'１\\uAAF6Ss𑲥｡\\u1DD8\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:4951\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("\x{200D}񫶩𞪯\x{0CCD}｡\x{077C}⒈", %p)},	undef,	"to_ascii\(\'\\u200D\?\?\\u0CCD｡\\u077C⒈\'\)\ throws\ error\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:4952\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}񫶩𞪯\x{0CCD}。\x{077C}1.", %p)},	undef,	"to_ascii\(\'\\u200D\?\?\\u0CCD\。\\u077C1\.\'\)\ throws\ error\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:4954\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--8tc9875v5is1a.xn--1-g6c.", %p)},	undef,	"to_ascii\(\'xn\-\-8tc9875v5is1a\.xn\-\-1\-g6c\.\'\)\ throws\ error\ B5\ B6\ V6\ \[data\/IdnaTest\.txt\:4956\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--8tc969gzn94a4lm8a.xn--1-g6c.", %p)},	undef,	"to_ascii\(\'xn\-\-8tc969gzn94a4lm8a\.xn\-\-1\-g6c\.\'\)\ throws\ error\ B1\ C2\ V6\ \[data\/IdnaTest\.txt\:4957\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--8tc9875v5is1a.xn--dqb689l", %p)},	undef,	"to_ascii\(\'xn\-\-8tc9875v5is1a\.xn\-\-dqb689l\'\)\ throws\ error\ B5\ B6\ V6\ \[data\/IdnaTest\.txt\:4958\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--8tc969gzn94a4lm8a.xn--dqb689l", %p)},	undef,	"to_ascii\(\'xn\-\-8tc969gzn94a4lm8a\.xn\-\-dqb689l\'\)\ throws\ error\ B1\ C2\ V6\ \[data\/IdnaTest\.txt\:4959\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1AB6}．𞤳򓢖򻉒\x{07D7}", %p)},	undef,	"to_ascii\(\'\\u1AB6．𞤳\?\?\\u07D7\'\)\ throws\ error\ B1\ B2\ B3\ B6\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4960\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1AB6}.𞤳򓢖򻉒\x{07D7}", %p)},	undef,	"to_ascii\(\'\\u1AB6\.𞤳\?\?\\u07D7\'\)\ throws\ error\ B1\ B2\ B3\ B6\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4961\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1AB6}.𞤑򓢖򻉒\x{07D7}", %p)},	undef,	"to_ascii\(\'\\u1AB6\.𞤑\?\?\\u07D7\'\)\ throws\ error\ B1\ B2\ B3\ B6\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4962\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--zqf.xn--ysb9657vuiz5bj0ep", %p)},	undef,	"to_ascii\(\'xn\-\-zqf\.xn\-\-ysb9657vuiz5bj0ep\'\)\ throws\ error\ B1\ B2\ B3\ B6\ V5\ V6\ \[data\/IdnaTest\.txt\:4963\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1AB6}．𞤑򓢖򻉒\x{07D7}", %p)},	undef,	"to_ascii\(\'\\u1AB6．𞤑\?\?\\u07D7\'\)\ throws\ error\ B1\ B2\ B3\ B6\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4964\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0842}𞩚⒈．󠬌８򏳏\x{0770}", %p)},	undef,	"to_ascii\(\'\\u0842\?⒈．\?８\?\\u0770\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:4965\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0842}𞩚1..󠬌8򏳏\x{0770}", %p)},	undef,	"to_ascii\(\'\\u0842\?1\.\.\?8\?\\u0770\'\)\ throws\ error\ B1\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:4966\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--1-rid26318a..xn--8-s5c22427ox454a", %p)},	undef,	"to_ascii\(\'xn\-\-1\-rid26318a\.\.xn\-\-8\-s5c22427ox454a\'\)\ throws\ error\ B1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:4967\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--0vb095ldg52a.xn--8-s5c22427ox454a", %p)},	undef,	"to_ascii\(\'xn\-\-0vb095ldg52a\.xn\-\-8\-s5c22427ox454a\'\)\ throws\ error\ B1\ V6\ \[data\/IdnaTest\.txt\:4968\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0361}𐫫\x{0369}ᡷ。-󠰛鞰", %p)},	undef,	"to_ascii\(\'\\u0361𐫫\\u0369ᡷ\。\-\?鞰\'\)\ throws\ error\ B1\ P1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:4969\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--cvaq482npv5t.xn----yg7dt1332g", %p)},	undef,	"to_ascii\(\'xn\-\-cvaq482npv5t\.xn\-\-\-\-yg7dt1332g\'\)\ throws\ error\ B1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:4970\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("-.\x{0ACD}剘ß𐫃", %p)},	undef,	"to_ascii\(\'\-\.\\u0ACD剘ß𐫃\'\)\ throws\ error\ B1\ V3\ V5\ \[data\/IdnaTest\.txt\:4971\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("-.\x{0ACD}剘SS𐫃", %p)},	undef,	"to_ascii\(\'\-\.\\u0ACD剘SS𐫃\'\)\ throws\ error\ B1\ V3\ V5\ \[data\/IdnaTest\.txt\:4973\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("-.\x{0ACD}剘ss𐫃", %p)},	undef,	"to_ascii\(\'\-\.\\u0ACD剘ss𐫃\'\)\ throws\ error\ B1\ V3\ V5\ \[data\/IdnaTest\.txt\:4974\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("-.\x{0ACD}剘Ss𐫃", %p)},	undef,	"to_ascii\(\'\-\.\\u0ACD剘Ss𐫃\'\)\ throws\ error\ B1\ V3\ V5\ \[data\/IdnaTest\.txt\:4975\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("-.xn--ss-bqg4734erywk", %p)},	undef,	"to_ascii\(\'\-\.xn\-\-ss\-bqg4734erywk\'\)\ throws\ error\ B1\ V3\ V5\ \[data\/IdnaTest\.txt\:4976\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-.xn--zca791c493duf8i", %p)},	undef,	"to_ascii\(\'\-\.xn\-\-zca791c493duf8i\'\)\ throws\ error\ B1\ V3\ V5\ \[data\/IdnaTest\.txt\:4977\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{08FB}𞵸｡-", %p)},	undef,	"to_ascii\(\'\\u08FB\?｡\-\'\)\ throws\ error\ B1\ P1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:4978\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{08FB}𞵸。-", %p)},	undef,	"to_ascii\(\'\\u08FB\?\。\-\'\)\ throws\ error\ B1\ P1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:4979\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--b1b2719v.-", %p)},	undef,	"to_ascii\(\'xn\-\-b1b2719v\.\-\'\)\ throws\ error\ B1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:4980\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⒈󠈻𐹲｡≠\x{0603}𐹽", %p)},	undef,	"to_ascii\(\'⒈\?𐹲｡\≠\\u0603𐹽\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:4981\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⒈󠈻𐹲｡=\x{0338}\x{0603}𐹽", %p)},	undef,	"to_ascii\(\'⒈\?𐹲｡\=\\u0338\\u0603𐹽\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:4982\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("1.󠈻𐹲。≠\x{0603}𐹽", %p)},	undef,	"to_ascii\(\'1\.\?𐹲\。\≠\\u0603𐹽\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:4983\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("1.󠈻𐹲。=\x{0338}\x{0603}𐹽", %p)},	undef,	"to_ascii\(\'1\.\?𐹲\。\=\\u0338\\u0603𐹽\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:4984\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("1.xn--qo0dl3077c.xn--lfb536lb35n", %p)},	undef,	"to_ascii\(\'1\.xn\-\-qo0dl3077c\.xn\-\-lfb536lb35n\'\)\ throws\ error\ B1\ V6\ \[data\/IdnaTest\.txt\:4985\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--tshw766f1153g.xn--lfb536lb35n", %p)},	undef,	"to_ascii\(\'xn\-\-tshw766f1153g\.xn\-\-lfb536lb35n\'\)\ throws\ error\ B1\ V6\ \[data\/IdnaTest\.txt\:4986\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐹢󠈚Ⴎ\x{200C}.㖾𐹡", %p)},	undef,	"to_ascii\(\'𐹢\?Ⴎ\\u200C\.㖾𐹡\'\)\ throws\ error\ B1\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:4987\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐹢󠈚ⴎ\x{200C}.㖾𐹡", %p)},	undef,	"to_ascii\(\'𐹢\?ⴎ\\u200C\.㖾𐹡\'\)\ throws\ error\ B1\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:4989\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--5kjx323em053g.xn--pelu572d", %p)},	undef,	"to_ascii\(\'xn\-\-5kjx323em053g\.xn\-\-pelu572d\'\)\ throws\ error\ B1\ B5\ B6\ V6\ \[data\/IdnaTest\.txt\:4991\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--0ug342clq0pqxv4i.xn--pelu572d", %p)},	undef,	"to_ascii\(\'xn\-\-0ug342clq0pqxv4i\.xn\-\-pelu572d\'\)\ throws\ error\ B1\ B5\ B6\ C1\ V6\ \[data\/IdnaTest\.txt\:4992\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--mnd9001km0o0g.xn--pelu572d", %p)},	undef,	"to_ascii\(\'xn\-\-mnd9001km0o0g\.xn\-\-pelu572d\'\)\ throws\ error\ B1\ B5\ B6\ V6\ \[data\/IdnaTest\.txt\:4993\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--mnd289ezj4pqxp0i.xn--pelu572d", %p)},	undef,	"to_ascii\(\'xn\-\-mnd289ezj4pqxp0i\.xn\-\-pelu572d\'\)\ throws\ error\ B1\ B5\ B6\ C1\ V6\ \[data\/IdnaTest\.txt\:4994\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򩼗．\x{07C7}ᡖႳႧ", %p)},	undef,	"to_ascii\(\'\?．\\u07C7ᡖႳႧ\'\)\ throws\ error\ B2\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:4995\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򩼗.\x{07C7}ᡖႳႧ", %p)},	undef,	"to_ascii\(\'\?\.\\u07C7ᡖႳႧ\'\)\ throws\ error\ B2\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:4996\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򩼗.\x{07C7}ᡖⴓⴇ", %p)},	undef,	"to_ascii\(\'\?\.\\u07C7ᡖⴓⴇ\'\)\ throws\ error\ B2\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:4997\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򩼗.\x{07C7}ᡖႳⴇ", %p)},	undef,	"to_ascii\(\'\?\.\\u07C7ᡖႳⴇ\'\)\ throws\ error\ B2\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:4998\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--te28c.xn--isb286btrgo7w", %p)},	undef,	"to_ascii\(\'xn\-\-te28c\.xn\-\-isb286btrgo7w\'\)\ throws\ error\ B2\ B3\ V6\ \[data\/IdnaTest\.txt\:4999\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--te28c.xn--isb295fbtpmb", %p)},	undef,	"to_ascii\(\'xn\-\-te28c\.xn\-\-isb295fbtpmb\'\)\ throws\ error\ B2\ B3\ V6\ \[data\/IdnaTest\.txt\:5000\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--te28c.xn--isb856b9a631d", %p)},	undef,	"to_ascii\(\'xn\-\-te28c\.xn\-\-isb856b9a631d\'\)\ throws\ error\ B2\ B3\ V6\ \[data\/IdnaTest\.txt\:5001\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򩼗．\x{07C7}ᡖⴓⴇ", %p)},	undef,	"to_ascii\(\'\?．\\u07C7ᡖⴓⴇ\'\)\ throws\ error\ B2\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:5002\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򩼗．\x{07C7}ᡖႳⴇ", %p)},	undef,	"to_ascii\(\'\?．\\u07C7ᡖႳⴇ\'\)\ throws\ error\ B2\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:5003\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}􅍉.\x{06B3}\x{0775}", %p)},	undef,	"to_ascii\(\'\\u200D\?\.\\u06B3\\u0775\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:5004\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--3j78f.xn--mkb20b", %p)},	undef,	"to_ascii\(\'xn\-\-3j78f\.xn\-\-mkb20b\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:5006\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--1ug39444n.xn--mkb20b", %p)},	undef,	"to_ascii\(\'xn\-\-1ug39444n\.xn\-\-mkb20b\'\)\ throws\ error\ B1\ C2\ V6\ \[data\/IdnaTest\.txt\:5007\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𲤱⒛⾳．ꡦ⒈", %p)},	undef,	"to_ascii\(\'\?⒛⾳．ꡦ⒈\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:5008\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𲤱20.音.ꡦ1.", %p)},	undef,	"to_ascii\(\'\?20\.音\.ꡦ1\.\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:5009\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--20-9802c.xn--0w5a.xn--1-eg4e.", %p)},	undef,	"to_ascii\(\'xn\-\-20\-9802c\.xn\-\-0w5a\.xn\-\-1\-eg4e\.\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:5010\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--dth6033bzbvx.xn--tsh9439b", %p)},	undef,	"to_ascii\(\'xn\-\-dth6033bzbvx\.xn\-\-tsh9439b\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:5011\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{07DC}８񳦓-｡򞲙𑁿𐩥\x{09CD}", %p)},	undef,	"to_ascii\(\'\\u07DC８\?\-｡\?𑁿𐩥\\u09CD\'\)\ throws\ error\ B2\ B3\ B5\ B6\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:5012\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{07DC}8񳦓-。򞲙𑁿𐩥\x{09CD}", %p)},	undef,	"to_ascii\(\'\\u07DC8\?\-\。\?𑁿𐩥\\u09CD\'\)\ throws\ error\ B2\ B3\ B5\ B6\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:5013\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--8--rve13079p.xn--b7b9842k42df776x", %p)},	undef,	"to_ascii\(\'xn\-\-8\-\-rve13079p\.xn\-\-b7b9842k42df776x\'\)\ throws\ error\ B2\ B3\ B5\ B6\ V3\ V6\ \[data\/IdnaTest\.txt\:5014\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴕ。۰≮ß\x{0745}", %p)},	undef,	"to_ascii\(\'Ⴕ\。۰\≮ß\\u0745\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:5015\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴕ。۰<\x{0338}ß\x{0745}", %p)},	undef,	"to_ascii\(\'Ⴕ\。۰\<\\u0338ß\\u0745\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:5017\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⴕ。۰<\x{0338}ß\x{0745}", %p)},	undef,	"to_ascii\(\'ⴕ\。۰\<\\u0338ß\\u0745\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:5019\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⴕ。۰≮ß\x{0745}", %p)},	undef,	"to_ascii\(\'ⴕ\。۰\≮ß\\u0745\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:5021\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴕ。۰≮SS\x{0745}", %p)},	undef,	"to_ascii\(\'Ⴕ\。۰\≮SS\\u0745\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:5023\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴕ。۰<\x{0338}SS\x{0745}", %p)},	undef,	"to_ascii\(\'Ⴕ\。۰\<\\u0338SS\\u0745\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:5024\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⴕ。۰<\x{0338}ss\x{0745}", %p)},	undef,	"to_ascii\(\'ⴕ\。۰\<\\u0338ss\\u0745\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:5025\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⴕ。۰≮ss\x{0745}", %p)},	undef,	"to_ascii\(\'ⴕ\。۰\≮ss\\u0745\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:5026\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴕ。۰≮Ss\x{0745}", %p)},	undef,	"to_ascii\(\'Ⴕ\。۰\≮Ss\\u0745\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:5027\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴕ。۰<\x{0338}Ss\x{0745}", %p)},	undef,	"to_ascii\(\'Ⴕ\。۰\<\\u0338Ss\\u0745\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:5028\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--tnd.xn--ss-jbe65aw27i", %p)},	undef,	"to_ascii\(\'xn\-\-tnd\.xn\-\-ss\-jbe65aw27i\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:5029\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--dlj.xn--ss-jbe65aw27i", %p)},	undef,	"to_ascii\(\'xn\-\-dlj\.xn\-\-ss\-jbe65aw27i\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:5030\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--dlj.xn--zca912alh227g", %p)},	undef,	"to_ascii\(\'xn\-\-dlj\.xn\-\-zca912alh227g\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:5031\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--tnd.xn--zca912alh227g", %p)},	undef,	"to_ascii\(\'xn\-\-tnd\.xn\-\-zca912alh227g\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:5032\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_ascii("\x{07E9}-.𝨗꒱\x{1B72}", %p)},	undef,	"to_ascii\(\'\\u07E9\-\.𝨗꒱\\u1B72\'\)\ throws\ error\ B1\ B3\ V3\ V5\ \[data\/IdnaTest\.txt\:5033\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn----odd.xn--dwf8994dc8wj", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-odd\.xn\-\-dwf8994dc8wj\'\)\ throws\ error\ B1\ B3\ V3\ V5\ \[data\/IdnaTest\.txt\:5034\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𞼸\x{200C}.≯䕵⫧", %p)},	undef,	"to_ascii\(\'\?\\u200C\.\≯䕵\⫧\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:5035\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𞼸\x{200C}.>\x{0338}䕵⫧", %p)},	undef,	"to_ascii\(\'\?\\u200C\.\>\\u0338䕵\⫧\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:5037\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--sn7h.xn--hdh754ax6w", %p)},	undef,	"to_ascii\(\'xn\-\-sn7h\.xn\-\-hdh754ax6w\'\)\ throws\ error\ B1\ V6\ \[data\/IdnaTest\.txt\:5039\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--0ugx453p.xn--hdh754ax6w", %p)},	undef,	"to_ascii\(\'xn\-\-0ugx453p\.xn\-\-hdh754ax6w\'\)\ throws\ error\ B1\ B3\ C1\ V6\ \[data\/IdnaTest\.txt\:5040\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐨅ß\x{FC57}.\x{06AC}۳︒", %p)},	undef,	"to_ascii\(\'𐨅ß\\uFC57\.\\u06AC۳︒\'\)\ throws\ error\ B1\ B3\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:5041\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("𐨅ß\x{064A}\x{062E}.\x{06AC}۳。", %p)},	undef,	"to_ascii\(\'𐨅ß\\u064A\\u062E\.\\u06AC۳\。\'\)\ throws\ error\ B1\ V5\ \[data\/IdnaTest\.txt\:5043\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("𐨅SS\x{064A}\x{062E}.\x{06AC}۳。", %p)},	undef,	"to_ascii\(\'𐨅SS\\u064A\\u062E\.\\u06AC۳\。\'\)\ throws\ error\ B1\ V5\ \[data\/IdnaTest\.txt\:5045\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("𐨅ss\x{064A}\x{062E}.\x{06AC}۳。", %p)},	undef,	"to_ascii\(\'𐨅ss\\u064A\\u062E\.\\u06AC۳\。\'\)\ throws\ error\ B1\ V5\ \[data\/IdnaTest\.txt\:5046\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("𐨅Ss\x{064A}\x{062E}.\x{06AC}۳。", %p)},	undef,	"to_ascii\(\'𐨅Ss\\u064A\\u062E\.\\u06AC۳\。\'\)\ throws\ error\ B1\ V5\ \[data\/IdnaTest\.txt\:5047\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--ss-ytd5i7765l.xn--fkb6l.", %p)},	undef,	"to_ascii\(\'xn\-\-ss\-ytd5i7765l\.xn\-\-fkb6l\.\'\)\ throws\ error\ B1\ V5\ \[data\/IdnaTest\.txt\:5048\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--zca23yncs877j.xn--fkb6l.", %p)},	undef,	"to_ascii\(\'xn\-\-zca23yncs877j\.xn\-\-fkb6l\.\'\)\ throws\ error\ B1\ V5\ \[data\/IdnaTest\.txt\:5049\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐨅SS\x{FC57}.\x{06AC}۳︒", %p)},	undef,	"to_ascii\(\'𐨅SS\\uFC57\.\\u06AC۳︒\'\)\ throws\ error\ B1\ B3\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:5050\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐨅ss\x{FC57}.\x{06AC}۳︒", %p)},	undef,	"to_ascii\(\'𐨅ss\\uFC57\.\\u06AC۳︒\'\)\ throws\ error\ B1\ B3\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:5051\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐨅Ss\x{FC57}.\x{06AC}۳︒", %p)},	undef,	"to_ascii\(\'𐨅Ss\\uFC57\.\\u06AC۳︒\'\)\ throws\ error\ B1\ B3\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:5052\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--ss-ytd5i7765l.xn--fkb6lp314e", %p)},	undef,	"to_ascii\(\'xn\-\-ss\-ytd5i7765l\.xn\-\-fkb6lp314e\'\)\ throws\ error\ B1\ B3\ V5\ V6\ \[data\/IdnaTest\.txt\:5053\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--zca23yncs877j.xn--fkb6lp314e", %p)},	undef,	"to_ascii\(\'xn\-\-zca23yncs877j\.xn\-\-fkb6lp314e\'\)\ throws\ error\ B1\ B3\ V5\ V6\ \[data\/IdnaTest\.txt\:5054\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-≮🡒\x{1CED}.񏿾Ⴁ\x{0714}", %p)},	undef,	"to_ascii\(\'\-\≮🡒\\u1CED\.\?Ⴁ\\u0714\'\)\ throws\ error\ B1\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:5055\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-<\x{0338}🡒\x{1CED}.񏿾Ⴁ\x{0714}", %p)},	undef,	"to_ascii\(\'\-\<\\u0338🡒\\u1CED\.\?Ⴁ\\u0714\'\)\ throws\ error\ B1\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:5056\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-<\x{0338}🡒\x{1CED}.񏿾ⴁ\x{0714}", %p)},	undef,	"to_ascii\(\'\-\<\\u0338🡒\\u1CED\.\?ⴁ\\u0714\'\)\ throws\ error\ B1\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:5057\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-≮🡒\x{1CED}.񏿾ⴁ\x{0714}", %p)},	undef,	"to_ascii\(\'\-\≮🡒\\u1CED\.\?ⴁ\\u0714\'\)\ throws\ error\ B1\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:5058\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----44l04zxt68c.xn--enb135qf106f", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-44l04zxt68c\.xn\-\-enb135qf106f\'\)\ throws\ error\ B1\ V3\ V6\ \[data\/IdnaTest\.txt\:5059\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----44l04zxt68c.xn--enb300c1597h", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-44l04zxt68c\.xn\-\-enb300c1597h\'\)\ throws\ error\ B1\ V3\ V6\ \[data\/IdnaTest\.txt\:5060\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("𞤨｡ꡏ\x{200D}\x{200C}", %p)},	"xn--ge6h.xn--oc9a",	"to_ascii\(\'𞤨｡ꡏ\\u200D\\u200C\'\)\ \[data\/IdnaTest\.txt\:5061\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("𞤨。ꡏ\x{200D}\x{200C}", %p)},	"xn--ge6h.xn--oc9a",	"to_ascii\(\'𞤨\。ꡏ\\u200D\\u200C\'\)\ \[data\/IdnaTest\.txt\:5063\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("𞤆。ꡏ\x{200D}\x{200C}", %p)},	"xn--ge6h.xn--oc9a",	"to_ascii\(\'𞤆\。ꡏ\\u200D\\u200C\'\)\ \[data\/IdnaTest\.txt\:5065\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("xn--ge6h.xn--oc9a", %p)},	"xn--ge6h.xn--oc9a",	"to_ascii\(\'xn\-\-ge6h\.xn\-\-oc9a\'\)\ \[data\/IdnaTest\.txt\:5067\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("𞤨.ꡏ", %p)},	"xn--ge6h.xn--oc9a",	"to_ascii\(\'𞤨\.ꡏ\'\)\ \[data\/IdnaTest\.txt\:5068\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("𞤆.ꡏ", %p)},	"xn--ge6h.xn--oc9a",	"to_ascii\(\'𞤆\.ꡏ\'\)\ \[data\/IdnaTest\.txt\:5069\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--ge6h.xn--0ugb9575h", %p)},	undef,	"to_ascii\(\'xn\-\-ge6h\.xn\-\-0ugb9575h\'\)\ throws\ error\ B6\ C1\ C2\ \[data\/IdnaTest\.txt\:5070\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("𞤆｡ꡏ\x{200D}\x{200C}", %p)},	"xn--ge6h.xn--oc9a",	"to_ascii\(\'𞤆｡ꡏ\\u200D\\u200C\'\)\ \[data\/IdnaTest\.txt\:5071\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("󠅹𑂶．ᢌ𑂹\x{0669}", %p)},	undef,	"to_ascii\(\'\󠅹𑂶．ᢌ𑂹\\u0669\'\)\ throws\ error\ B1\ B3\ B5\ B6\ V5\ \[data\/IdnaTest\.txt\:5073\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("󠅹𑂶.ᢌ𑂹\x{0669}", %p)},	undef,	"to_ascii\(\'\󠅹𑂶\.ᢌ𑂹\\u0669\'\)\ throws\ error\ B1\ B3\ B5\ B6\ V5\ \[data\/IdnaTest\.txt\:5074\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--b50d.xn--iib993gyp5p", %p)},	undef,	"to_ascii\(\'xn\-\-b50d\.xn\-\-iib993gyp5p\'\)\ throws\ error\ B1\ B3\ B5\ B6\ V5\ \[data\/IdnaTest\.txt\:5075\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⅎ󠅺񝵒。≯⾑", %p)},	undef,	"to_ascii\(\'Ⅎ\󠅺\?\。\≯⾑\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:5076\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⅎ󠅺񝵒。>\x{0338}⾑", %p)},	undef,	"to_ascii\(\'Ⅎ\󠅺\?\。\>\\u0338⾑\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:5077\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⅎ󠅺񝵒。≯襾", %p)},	undef,	"to_ascii\(\'Ⅎ\󠅺\?\。\≯襾\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:5078\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⅎ󠅺񝵒。>\x{0338}襾", %p)},	undef,	"to_ascii\(\'Ⅎ\󠅺\?\。\>\\u0338襾\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:5079\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⅎ󠅺񝵒。>\x{0338}襾", %p)},	undef,	"to_ascii\(\'ⅎ\󠅺\?\。\>\\u0338襾\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:5080\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⅎ󠅺񝵒。≯襾", %p)},	undef,	"to_ascii\(\'ⅎ\󠅺\?\。\≯襾\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:5081\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--73g39298c.xn--hdhz171b", %p)},	undef,	"to_ascii\(\'xn\-\-73g39298c\.xn\-\-hdhz171b\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:5082\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--f3g73398c.xn--hdhz171b", %p)},	undef,	"to_ascii\(\'xn\-\-f3g73398c\.xn\-\-hdhz171b\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:5083\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⅎ󠅺񝵒。>\x{0338}⾑", %p)},	undef,	"to_ascii\(\'ⅎ\󠅺\?\。\>\\u0338⾑\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:5084\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⅎ󠅺񝵒。≯⾑", %p)},	undef,	"to_ascii\(\'ⅎ\󠅺\?\。\≯⾑\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:5085\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ς\x{200D}\x{0DD4}\x{0660}｡-", %p)},	undef,	"to_ascii\(\'ς\\u200D\\u0DD4\\u0660｡\-\'\)\ throws\ error\ B1\ B5\ B6\ V3\ \[data\/IdnaTest\.txt\:5086\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ς\x{200D}\x{0DD4}\x{0660}。-", %p)},	undef,	"to_ascii\(\'ς\\u200D\\u0DD4\\u0660\。\-\'\)\ throws\ error\ B1\ B5\ B6\ V3\ \[data\/IdnaTest\.txt\:5088\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Σ\x{200D}\x{0DD4}\x{0660}。-", %p)},	undef,	"to_ascii\(\'Σ\\u200D\\u0DD4\\u0660\。\-\'\)\ throws\ error\ B1\ B5\ B6\ V3\ \[data\/IdnaTest\.txt\:5090\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("σ\x{200D}\x{0DD4}\x{0660}。-", %p)},	undef,	"to_ascii\(\'σ\\u200D\\u0DD4\\u0660\。\-\'\)\ throws\ error\ B1\ B5\ B6\ V3\ \[data\/IdnaTest\.txt\:5092\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--4xa25ks2j.-", %p)},	undef,	"to_ascii\(\'xn\-\-4xa25ks2j\.\-\'\)\ throws\ error\ B1\ B5\ B6\ V3\ \[data\/IdnaTest\.txt\:5094\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--4xa25ks2jenu.-", %p)},	undef,	"to_ascii\(\'xn\-\-4xa25ks2jenu\.\-\'\)\ throws\ error\ B1\ B5\ B6\ C2\ V3\ \[data\/IdnaTest\.txt\:5095\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--3xa45ks2jenu.-", %p)},	undef,	"to_ascii\(\'xn\-\-3xa45ks2jenu\.\-\'\)\ throws\ error\ B1\ B5\ B6\ C2\ V3\ \[data\/IdnaTest\.txt\:5096\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Σ\x{200D}\x{0DD4}\x{0660}｡-", %p)},	undef,	"to_ascii\(\'Σ\\u200D\\u0DD4\\u0660｡\-\'\)\ throws\ error\ B1\ B5\ B6\ V3\ \[data\/IdnaTest\.txt\:5097\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("σ\x{200D}\x{0DD4}\x{0660}｡-", %p)},	undef,	"to_ascii\(\'σ\\u200D\\u0DD4\\u0660｡\-\'\)\ throws\ error\ B1\ B5\ B6\ V3\ \[data\/IdnaTest\.txt\:5099\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}.ßႩ-", %p)},	undef,	"to_ascii\(\'\\u200C\.ßႩ\-\'\)\ throws\ error\ P1\ V3\ V6\ A4_2\ \[data\/IdnaTest\.txt\:5101\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("\x{200C}.ßⴉ-", %p)},	undef,	"to_ascii\(\'\\u200C\.ßⴉ\-\'\)\ throws\ error\ V3\ A4_2\ \[data\/IdnaTest\.txt\:5103\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("\x{200C}.SSႩ-", %p)},	undef,	"to_ascii\(\'\\u200C\.SSႩ\-\'\)\ throws\ error\ P1\ V3\ V6\ A4_2\ \[data\/IdnaTest\.txt\:5105\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("\x{200C}.ssⴉ-", %p)},	undef,	"to_ascii\(\'\\u200C\.ssⴉ\-\'\)\ throws\ error\ V3\ A4_2\ \[data\/IdnaTest\.txt\:5107\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("\x{200C}.Ssⴉ-", %p)},	undef,	"to_ascii\(\'\\u200C\.Ssⴉ\-\'\)\ throws\ error\ V3\ A4_2\ \[data\/IdnaTest\.txt\:5109\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii(".xn--ss--bi1b", %p)},	undef,	"to_ascii\(\'\.xn\-\-ss\-\-bi1b\'\)\ throws\ error\ V3\ A4_2\ \[data\/IdnaTest\.txt\:5111\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--0ug.xn--ss--bi1b", %p)},	undef,	"to_ascii\(\'xn\-\-0ug\.xn\-\-ss\-\-bi1b\'\)\ throws\ error\ C1\ V3\ \[data\/IdnaTest\.txt\:5112\]") or ($@ and diag($@));
is(eval{uts46_to_ascii(".xn--ss--4rn", %p)},	undef,	"to_ascii\(\'\.xn\-\-ss\-\-4rn\'\)\ throws\ error\ V3\ V6\ A4_2\ \[data\/IdnaTest\.txt\:5113\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--0ug.xn--ss--4rn", %p)},	undef,	"to_ascii\(\'xn\-\-0ug\.xn\-\-ss\-\-4rn\'\)\ throws\ error\ C1\ V3\ V6\ \[data\/IdnaTest\.txt\:5114\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--0ug.xn----pfa2305a", %p)},	undef,	"to_ascii\(\'xn\-\-0ug\.xn\-\-\-\-pfa2305a\'\)\ throws\ error\ C1\ V3\ \[data\/IdnaTest\.txt\:5115\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--0ug.xn----pfa042j", %p)},	undef,	"to_ascii\(\'xn\-\-0ug\.xn\-\-\-\-pfa042j\'\)\ throws\ error\ C1\ V3\ V6\ \[data\/IdnaTest\.txt\:5116\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󍭲𐫍㓱。⾑", %p)},	undef,	"to_ascii\(\'\?𐫍㓱\。⾑\'\)\ throws\ error\ B5\ P1\ V6\ \[data\/IdnaTest\.txt\:5117\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󍭲𐫍㓱。襾", %p)},	undef,	"to_ascii\(\'\?𐫍㓱\。襾\'\)\ throws\ error\ B5\ P1\ V6\ \[data\/IdnaTest\.txt\:5118\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--u7kt691dlj09f.xn--9v2a", %p)},	undef,	"to_ascii\(\'xn\-\-u7kt691dlj09f\.xn\-\-9v2a\'\)\ throws\ error\ B5\ V6\ \[data\/IdnaTest\.txt\:5119\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{06A0}𐮋𐹰≮。≯󠦗\x{200D}", %p)},	undef,	"to_ascii\(\'\\u06A0𐮋𐹰\≮\。\≯\?\\u200D\'\)\ throws\ error\ B1\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:5120\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{06A0}𐮋𐹰<\x{0338}。>\x{0338}󠦗\x{200D}", %p)},	undef,	"to_ascii\(\'\\u06A0𐮋𐹰\<\\u0338\。\>\\u0338\?\\u200D\'\)\ throws\ error\ B1\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:5122\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--2jb053lf13nyoc.xn--hdh08821l", %p)},	undef,	"to_ascii\(\'xn\-\-2jb053lf13nyoc\.xn\-\-hdh08821l\'\)\ throws\ error\ B1\ B3\ V6\ \[data\/IdnaTest\.txt\:5124\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--2jb053lf13nyoc.xn--1ugx6gc8096c", %p)},	undef,	"to_ascii\(\'xn\-\-2jb053lf13nyoc\.xn\-\-1ugx6gc8096c\'\)\ throws\ error\ B1\ B3\ C2\ V6\ \[data\/IdnaTest\.txt\:5125\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𝟞｡񃰶\x{0777}\x{08B0}⩋", %p)},	undef,	"to_ascii\(\'𝟞｡\?\\u0777\\u08B0\⩋\'\)\ throws\ error\ B1\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:5126\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("6。񃰶\x{0777}\x{08B0}⩋", %p)},	undef,	"to_ascii\(\'6\。\?\\u0777\\u08B0\⩋\'\)\ throws\ error\ B1\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:5127\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("6.xn--7pb04do15eq748f", %p)},	undef,	"to_ascii\(\'6\.xn\-\-7pb04do15eq748f\'\)\ throws\ error\ B1\ B5\ B6\ V6\ \[data\/IdnaTest\.txt\:5128\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("-\x{FCFD}。𑇀𑍴", %p)},	undef,	"to_ascii\(\'\-\\uFCFD\。𑇀𑍴\'\)\ throws\ error\ B1\ V3\ V5\ \[data\/IdnaTest\.txt\:5129\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("-\x{FCFD}。𑇀𑍴", %p)},	undef,	"to_ascii\(\'\-\\uFCFD\。𑇀𑍴\'\)\ throws\ error\ B1\ V3\ V5\ \[data\/IdnaTest\.txt\:5130\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("-\x{0634}\x{0649}。𑇀𑍴", %p)},	undef,	"to_ascii\(\'\-\\u0634\\u0649\。𑇀𑍴\'\)\ throws\ error\ B1\ V3\ V5\ \[data\/IdnaTest\.txt\:5131\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn----qnc7d.xn--wd1d62a", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-qnc7d\.xn\-\-wd1d62a\'\)\ throws\ error\ B1\ V3\ V5\ \[data\/IdnaTest\.txt\:5132\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}󠊶𝟏.\x{0D43}򪥐𐹬󊓶", %p)},	undef,	"to_ascii\(\'\\u200C\?𝟏\.\\u0D43\?𐹬\?\'\)\ throws\ error\ B1\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:5133\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}󠊶1.\x{0D43}򪥐𐹬󊓶", %p)},	undef,	"to_ascii\(\'\\u200C\?1\.\\u0D43\?𐹬\?\'\)\ throws\ error\ B1\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:5135\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--1-f521m.xn--mxc0872kcu37dnmem", %p)},	undef,	"to_ascii\(\'xn\-\-1\-f521m\.xn\-\-mxc0872kcu37dnmem\'\)\ throws\ error\ B1\ V5\ V6\ \[data\/IdnaTest\.txt\:5137\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--1-rgnu0071n.xn--mxc0872kcu37dnmem", %p)},	undef,	"to_ascii\(\'xn\-\-1\-rgnu0071n\.xn\-\-mxc0872kcu37dnmem\'\)\ throws\ error\ B1\ C1\ V5\ V6\ \[data\/IdnaTest\.txt\:5138\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("齙--𝟰.ß", %p)},	"xn----4-p16k.ss",	"to_ascii\(\'齙\-\-𝟰\.ß\'\)\ \[data\/IdnaTest\.txt\:5139\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("齙--4.ß", %p)},	"xn----4-p16k.ss",	"to_ascii\(\'齙\-\-4\.ß\'\)\ \[data\/IdnaTest\.txt\:5141\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("齙--4.SS", %p)},	"xn----4-p16k.ss",	"to_ascii\(\'齙\-\-4\.SS\'\)\ \[data\/IdnaTest\.txt\:5143\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("齙--4.ss", %p)},	"xn----4-p16k.ss",	"to_ascii\(\'齙\-\-4\.ss\'\)\ \[data\/IdnaTest\.txt\:5144\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("齙--4.Ss", %p)},	"xn----4-p16k.ss",	"to_ascii\(\'齙\-\-4\.Ss\'\)\ \[data\/IdnaTest\.txt\:5145\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----4-p16k.ss", %p)},	"xn----4-p16k.ss",	"to_ascii\(\'xn\-\-\-\-4\-p16k\.ss\'\)\ \[data\/IdnaTest\.txt\:5146\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----4-p16k.xn--zca", %p)},	"xn----4-p16k.xn--zca",	"to_ascii\(\'xn\-\-\-\-4\-p16k\.xn\-\-zca\'\)\ \[data\/IdnaTest\.txt\:5147\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("齙--𝟰.SS", %p)},	"xn----4-p16k.ss",	"to_ascii\(\'齙\-\-𝟰\.SS\'\)\ \[data\/IdnaTest\.txt\:5148\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("齙--𝟰.ss", %p)},	"xn----4-p16k.ss",	"to_ascii\(\'齙\-\-𝟰\.ss\'\)\ \[data\/IdnaTest\.txt\:5149\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("齙--𝟰.Ss", %p)},	"xn----4-p16k.ss",	"to_ascii\(\'齙\-\-𝟰\.Ss\'\)\ \[data\/IdnaTest\.txt\:5150\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("\x{1BF2}.𐹢𞀖\x{200C}", %p)},	undef,	"to_ascii\(\'\\u1BF2\.𐹢𞀖\\u200C\'\)\ throws\ error\ B1\ V5\ \[data\/IdnaTest\.txt\:5151\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--0zf.xn--9n0d2296a", %p)},	undef,	"to_ascii\(\'xn\-\-0zf\.xn\-\-9n0d2296a\'\)\ throws\ error\ B1\ V5\ \[data\/IdnaTest\.txt\:5153\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--0zf.xn--0ug9894grqqf", %p)},	undef,	"to_ascii\(\'xn\-\-0zf\.xn\-\-0ug9894grqqf\'\)\ throws\ error\ B1\ C1\ V5\ \[data\/IdnaTest\.txt\:5154\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󃲙󠋘｡\x{DEDE}-\x{200D}", %p)},	undef,	"to_ascii\(\'\?\?｡\\uDEDE\-\\u200D\'\)\ throws\ error\ P1\ V3\ V6\ A3\ \[data\/IdnaTest\.txt\:5155\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󃲙󠋘。\x{DEDE}-\x{200D}", %p)},	undef,	"to_ascii\(\'\?\?\。\\uDEDE\-\\u200D\'\)\ throws\ error\ P1\ V3\ V6\ A3\ \[data\/IdnaTest\.txt\:5157\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--ct86d8w51a.\x{DEDE}-", %p)},	undef,	"to_ascii\(\'xn\-\-ct86d8w51a\.\\uDEDE\-\'\)\ throws\ error\ P1\ V3\ V6\ A3\ \[data\/IdnaTest\.txt\:5159\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("XN--CT86D8W51A.\x{DEDE}-", %p)},	undef,	"to_ascii\(\'XN\-\-CT86D8W51A\.\\uDEDE\-\'\)\ throws\ error\ P1\ V3\ V6\ A3\ \[data\/IdnaTest\.txt\:5160\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Xn--Ct86d8w51a.\x{DEDE}-", %p)},	undef,	"to_ascii\(\'Xn\-\-Ct86d8w51a\.\\uDEDE\-\'\)\ throws\ error\ P1\ V3\ V6\ A3\ \[data\/IdnaTest\.txt\:5161\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--ct86d8w51a.\x{DEDE}-\x{200D}", %p)},	undef,	"to_ascii\(\'xn\-\-ct86d8w51a\.\\uDEDE\-\\u200D\'\)\ throws\ error\ P1\ V3\ V6\ A3\ \[data\/IdnaTest\.txt\:5162\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("XN--CT86D8W51A.\x{DEDE}-\x{200D}", %p)},	undef,	"to_ascii\(\'XN\-\-CT86D8W51A\.\\uDEDE\-\\u200D\'\)\ throws\ error\ P1\ V3\ V6\ A3\ \[data\/IdnaTest\.txt\:5164\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Xn--Ct86d8w51a.\x{DEDE}-\x{200D}", %p)},	undef,	"to_ascii\(\'Xn\-\-Ct86d8w51a\.\\uDEDE\-\\u200D\'\)\ throws\ error\ P1\ V3\ V6\ A3\ \[data\/IdnaTest\.txt\:5166\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1A60}．𞵷-𝪩悎", %p)},	undef,	"to_ascii\(\'\\u1A60．\?\-𝪩悎\'\)\ throws\ error\ B1\ B2\ B3\ B6\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:5168\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1A60}.𞵷-𝪩悎", %p)},	undef,	"to_ascii\(\'\\u1A60\.\?\-𝪩悎\'\)\ throws\ error\ B1\ B2\ B3\ B6\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:5169\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--jof.xn----gf4bq282iezpa", %p)},	undef,	"to_ascii\(\'xn\-\-jof\.xn\-\-\-\-gf4bq282iezpa\'\)\ throws\ error\ B1\ B2\ B3\ B6\ V5\ V6\ \[data\/IdnaTest\.txt\:5170\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𛜯󠊛．𞤳񏥾", %p)},	undef,	"to_ascii\(\'\?\?．𞤳\?\'\)\ throws\ error\ B2\ B3\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:5171\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𛜯󠊛.𞤳񏥾", %p)},	undef,	"to_ascii\(\'\?\?\.𞤳\?\'\)\ throws\ error\ B2\ B3\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:5172\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𛜯󠊛.𞤑񏥾", %p)},	undef,	"to_ascii\(\'\?\?\.𞤑\?\'\)\ throws\ error\ B2\ B3\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:5173\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--xx5gy2741c.xn--re6hw266j", %p)},	undef,	"to_ascii\(\'xn\-\-xx5gy2741c\.xn\-\-re6hw266j\'\)\ throws\ error\ B2\ B3\ B6\ V6\ \[data\/IdnaTest\.txt\:5174\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𛜯󠊛．𞤑񏥾", %p)},	undef,	"to_ascii\(\'\?\?．𞤑\?\'\)\ throws\ error\ B2\ B3\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:5175\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("\x{071C}𐫒\x{062E}.𐋲", %p)},	undef,	"to_ascii\(\'\\u071C𐫒\\u062E\.𐋲\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:5176\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--tgb98b8643d.xn--m97c", %p)},	undef,	"to_ascii\(\'xn\-\-tgb98b8643d\.xn\-\-m97c\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:5177\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐼑𞤓\x{0637}\x{08E2}.\x{DF56}", %p)},	undef,	"to_ascii\(\'𐼑𞤓\\u0637\\u08E2\.\\uDF56\'\)\ throws\ error\ P1\ V6\ A3\ \[data\/IdnaTest\.txt\:5178\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐼑𞤵\x{0637}\x{08E2}.\x{DF56}", %p)},	undef,	"to_ascii\(\'𐼑𞤵\\u0637\\u08E2\.\\uDF56\'\)\ throws\ error\ P1\ V6\ A3\ \[data\/IdnaTest\.txt\:5179\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--2gb08k9w69agm0g.\x{DF56}", %p)},	undef,	"to_ascii\(\'xn\-\-2gb08k9w69agm0g\.\\uDF56\'\)\ throws\ error\ P1\ V6\ A3\ \[data\/IdnaTest\.txt\:5180\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("XN--2GB08K9W69AGM0G.\x{DF56}", %p)},	undef,	"to_ascii\(\'XN\-\-2GB08K9W69AGM0G\.\\uDF56\'\)\ throws\ error\ P1\ V6\ A3\ \[data\/IdnaTest\.txt\:5181\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Xn--2Gb08k9w69agm0g.\x{DF56}", %p)},	undef,	"to_ascii\(\'Xn\-\-2Gb08k9w69agm0g\.\\uDF56\'\)\ throws\ error\ P1\ V6\ A3\ \[data\/IdnaTest\.txt\:5182\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ↄ。\x{0A4D}\x{1CD4}𞷣", %p)},	undef,	"to_ascii\(\'Ↄ\。\\u0A4D\\u1CD4\?\'\)\ throws\ error\ B1\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:5183\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ↄ。\x{1CD4}\x{0A4D}𞷣", %p)},	undef,	"to_ascii\(\'Ↄ\。\\u1CD4\\u0A4D\?\'\)\ throws\ error\ B1\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:5184\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ↄ。\x{1CD4}\x{0A4D}𞷣", %p)},	undef,	"to_ascii\(\'ↄ\。\\u1CD4\\u0A4D\?\'\)\ throws\ error\ B1\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:5185\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--r5g.xn--ybc995g0835a", %p)},	undef,	"to_ascii\(\'xn\-\-r5g\.xn\-\-ybc995g0835a\'\)\ throws\ error\ B1\ V5\ V6\ \[data\/IdnaTest\.txt\:5186\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--q5g.xn--ybc995g0835a", %p)},	undef,	"to_ascii\(\'xn\-\-q5g\.xn\-\-ybc995g0835a\'\)\ throws\ error\ B1\ V5\ V6\ \[data\/IdnaTest\.txt\:5187\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ↄ。\x{0A4D}\x{1CD4}𞷣", %p)},	undef,	"to_ascii\(\'ↄ\。\\u0A4D\\u1CD4\?\'\)\ throws\ error\ B1\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:5188\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠪢-。򛂏≮𑜫", %p)},	undef,	"to_ascii\(\'\?\-\。\?\≮𑜫\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:5189\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠪢-。򛂏<\x{0338}𑜫", %p)},	undef,	"to_ascii\(\'\?\-\。\?\<\\u0338𑜫\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:5190\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----bh61m.xn--gdhz157g0em1d", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-bh61m\.xn\-\-gdhz157g0em1d\'\)\ throws\ error\ V3\ V6\ \[data\/IdnaTest\.txt\:5191\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}󠉹\x{200D}。򌿧≮Ⴉ", %p)},	undef,	"to_ascii\(\'\\u200C\?\\u200D\。\?\≮Ⴉ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:5192\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}󠉹\x{200D}。򌿧<\x{0338}Ⴉ", %p)},	undef,	"to_ascii\(\'\\u200C\?\\u200D\。\?\<\\u0338Ⴉ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:5194\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}󠉹\x{200D}。򌿧<\x{0338}ⴉ", %p)},	undef,	"to_ascii\(\'\\u200C\?\\u200D\。\?\<\\u0338ⴉ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:5196\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}󠉹\x{200D}。򌿧≮ⴉ", %p)},	undef,	"to_ascii\(\'\\u200C\?\\u200D\。\?\≮ⴉ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:5198\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--3n36e.xn--gdh992byu01p", %p)},	undef,	"to_ascii\(\'xn\-\-3n36e\.xn\-\-gdh992byu01p\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:5200\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--0ugc90904y.xn--gdh992byu01p", %p)},	undef,	"to_ascii\(\'xn\-\-0ugc90904y\.xn\-\-gdh992byu01p\'\)\ throws\ error\ C1\ C2\ V6\ \[data\/IdnaTest\.txt\:5201\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--3n36e.xn--hnd112gpz83n", %p)},	undef,	"to_ascii\(\'xn\-\-3n36e\.xn\-\-hnd112gpz83n\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:5202\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--0ugc90904y.xn--hnd112gpz83n", %p)},	undef,	"to_ascii\(\'xn\-\-0ugc90904y\.xn\-\-hnd112gpz83n\'\)\ throws\ error\ C1\ C2\ V6\ \[data\/IdnaTest\.txt\:5203\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐹯-𑄴\x{08BC}。︒䖐⾆", %p)},	undef,	"to_ascii\(\'𐹯\-𑄴\\u08BC\。︒䖐⾆\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:5204\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("𐹯-𑄴\x{08BC}。。䖐舌", %p)},	undef,	"to_ascii\(\'𐹯\-𑄴\\u08BC\。\。䖐舌\'\)\ throws\ error\ B1\ A4_2\ \[data\/IdnaTest\.txt\:5205\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn----rpd7902rclc..xn--fpo216m", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-rpd7902rclc\.\.xn\-\-fpo216m\'\)\ throws\ error\ B1\ A4_2\ \[data\/IdnaTest\.txt\:5206\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----rpd7902rclc.xn--fpo216mn07e", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-rpd7902rclc\.xn\-\-fpo216mn07e\'\)\ throws\ error\ B1\ V6\ \[data\/IdnaTest\.txt\:5207\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𝪞Ⴐ｡쪡", %p)},	undef,	"to_ascii\(\'𝪞Ⴐ｡쪡\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:5208\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𝪞Ⴐ｡쪡", %p)},	undef,	"to_ascii\(\'𝪞Ⴐ｡쪡\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:5209\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𝪞Ⴐ。쪡", %p)},	undef,	"to_ascii\(\'𝪞Ⴐ\。쪡\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:5210\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𝪞Ⴐ。쪡", %p)},	undef,	"to_ascii\(\'𝪞Ⴐ\。쪡\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:5211\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_ascii("𝪞ⴐ。쪡", %p)},	undef,	"to_ascii\(\'𝪞ⴐ\。쪡\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:5212\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_ascii("𝪞ⴐ。쪡", %p)},	undef,	"to_ascii\(\'𝪞ⴐ\。쪡\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:5213\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--7kj1858k.xn--pi6b", %p)},	undef,	"to_ascii\(\'xn\-\-7kj1858k\.xn\-\-pi6b\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:5214\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--ond3755u.xn--pi6b", %p)},	undef,	"to_ascii\(\'xn\-\-ond3755u\.xn\-\-pi6b\'\)\ throws\ error\ V5\ V6\ \[data\/IdnaTest\.txt\:5215\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_ascii("𝪞ⴐ｡쪡", %p)},	undef,	"to_ascii\(\'𝪞ⴐ｡쪡\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:5216\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_ascii("𝪞ⴐ｡쪡", %p)},	undef,	"to_ascii\(\'𝪞ⴐ｡쪡\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:5217\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("\x{0E3A}쩁𐹬.􋉳", %p)},	undef,	"to_ascii\(\'\\u0E3A쩁𐹬\.\?\'\)\ throws\ error\ B1\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:5218\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0E3A}쩁𐹬.􋉳", %p)},	undef,	"to_ascii\(\'\\u0E3A쩁𐹬\.\?\'\)\ throws\ error\ B1\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:5219\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--o4c4837g2zvb.xn--5f70g", %p)},	undef,	"to_ascii\(\'xn\-\-o4c4837g2zvb\.xn\-\-5f70g\'\)\ throws\ error\ B1\ V5\ V6\ \[data\/IdnaTest\.txt\:5220\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᡅ０\x{200C}｡⎢󤨄", %p)},	undef,	"to_ascii\(\'ᡅ０\\u200C｡\⎢\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:5221\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᡅ0\x{200C}。⎢󤨄", %p)},	undef,	"to_ascii\(\'ᡅ0\\u200C\。\⎢\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:5223\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--0-z6j.xn--8lh28773l", %p)},	undef,	"to_ascii\(\'xn\-\-0\-z6j\.xn\-\-8lh28773l\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:5225\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--0-z6jy93b.xn--8lh28773l", %p)},	undef,	"to_ascii\(\'xn\-\-0\-z6jy93b\.xn\-\-8lh28773l\'\)\ throws\ error\ C1\ V6\ \[data\/IdnaTest\.txt\:5226\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𲮚９ꍩ\x{17D3}．\x{200D}ß", %p)},	undef,	"to_ascii\(\'\?９ꍩ\\u17D3．\\u200Dß\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:5227\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𲮚9ꍩ\x{17D3}.\x{200D}ß", %p)},	undef,	"to_ascii\(\'\?9ꍩ\\u17D3\.\\u200Dß\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:5229\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𲮚9ꍩ\x{17D3}.\x{200D}SS", %p)},	undef,	"to_ascii\(\'\?9ꍩ\\u17D3\.\\u200DSS\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:5231\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𲮚9ꍩ\x{17D3}.\x{200D}ss", %p)},	undef,	"to_ascii\(\'\?9ꍩ\\u17D3\.\\u200Dss\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:5233\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𲮚9ꍩ\x{17D3}.\x{200D}Ss", %p)},	undef,	"to_ascii\(\'\?9ꍩ\\u17D3\.\\u200DSs\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:5235\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--9-i0j5967eg3qz.ss", %p)},	undef,	"to_ascii\(\'xn\-\-9\-i0j5967eg3qz\.ss\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:5237\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--9-i0j5967eg3qz.xn--ss-l1t", %p)},	undef,	"to_ascii\(\'xn\-\-9\-i0j5967eg3qz\.xn\-\-ss\-l1t\'\)\ throws\ error\ C2\ V6\ \[data\/IdnaTest\.txt\:5238\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--9-i0j5967eg3qz.xn--zca770n", %p)},	undef,	"to_ascii\(\'xn\-\-9\-i0j5967eg3qz\.xn\-\-zca770n\'\)\ throws\ error\ C2\ V6\ \[data\/IdnaTest\.txt\:5239\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𲮚９ꍩ\x{17D3}．\x{200D}SS", %p)},	undef,	"to_ascii\(\'\?９ꍩ\\u17D3．\\u200DSS\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:5240\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𲮚９ꍩ\x{17D3}．\x{200D}ss", %p)},	undef,	"to_ascii\(\'\?９ꍩ\\u17D3．\\u200Dss\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:5242\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𲮚９ꍩ\x{17D3}．\x{200D}Ss", %p)},	undef,	"to_ascii\(\'\?９ꍩ\\u17D3．\\u200DSs\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:5244\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_ascii("ꗷ𑆀.\x{075D}𐩒", %p)},	"xn--ju8a625r.xn--hpb0073k",	"to_ascii\(\'ꗷ𑆀\.\\u075D𐩒\'\)\ \[data\/IdnaTest\.txt\:5246\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_ascii("xn--ju8a625r.xn--hpb0073k", %p)},	"xn--ju8a625r.xn--hpb0073k",	"to_ascii\(\'xn\-\-ju8a625r\.xn\-\-hpb0073k\'\)\ \[data\/IdnaTest\.txt\:5247\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("⒐≯-。︒򩑣-񞛠", %p)},	undef,	"to_ascii\(\'⒐\≯\-\。︒\?\-\?\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:5248\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⒐>\x{0338}-。︒򩑣-񞛠", %p)},	undef,	"to_ascii\(\'⒐\>\\u0338\-\。︒\?\-\?\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:5249\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("9.≯-。。򩑣-񞛠", %p)},	undef,	"to_ascii\(\'9\.\≯\-\。\。\?\-\?\'\)\ throws\ error\ P1\ V3\ V6\ A4_2\ \[data\/IdnaTest\.txt\:5250\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("9.>\x{0338}-。。򩑣-񞛠", %p)},	undef,	"to_ascii\(\'9\.\>\\u0338\-\。\。\?\-\?\'\)\ throws\ error\ P1\ V3\ V6\ A4_2\ \[data\/IdnaTest\.txt\:5251\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("9.xn----ogo..xn----xj54d1s69k", %p)},	undef,	"to_ascii\(\'9\.xn\-\-\-\-ogo\.\.xn\-\-\-\-xj54d1s69k\'\)\ throws\ error\ V3\ V6\ A4_2\ \[data\/IdnaTest\.txt\:5252\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----ogot9g.xn----n89hl0522az9u2a", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-ogot9g\.xn\-\-\-\-n89hl0522az9u2a\'\)\ throws\ error\ V3\ V6\ \[data\/IdnaTest\.txt\:5253\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򈪚\x{0CE3}Ⴡ󠢏．\x{061D}", %p)},	undef,	"to_ascii\(\'\?\\u0CE3Ⴡ\?．\\u061D\'\)\ throws\ error\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:5254\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򈪚\x{0CE3}Ⴡ󠢏.\x{061D}", %p)},	undef,	"to_ascii\(\'\?\\u0CE3Ⴡ\?\.\\u061D\'\)\ throws\ error\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:5255\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򈪚\x{0CE3}ⴡ󠢏.\x{061D}", %p)},	undef,	"to_ascii\(\'\?\\u0CE3ⴡ\?\.\\u061D\'\)\ throws\ error\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:5256\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--vuc226n8n28lmju7a.xn--cgb", %p)},	undef,	"to_ascii\(\'xn\-\-vuc226n8n28lmju7a\.xn\-\-cgb\'\)\ throws\ error\ B6\ V6\ \[data\/IdnaTest\.txt\:5257\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--vuc49qvu85xmju7a.xn--cgb", %p)},	undef,	"to_ascii\(\'xn\-\-vuc49qvu85xmju7a\.xn\-\-cgb\'\)\ throws\ error\ B6\ V6\ \[data\/IdnaTest\.txt\:5258\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򈪚\x{0CE3}ⴡ󠢏．\x{061D}", %p)},	undef,	"to_ascii\(\'\?\\u0CE3ⴡ\?．\\u061D\'\)\ throws\ error\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:5259\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("\x{1DEB}。𐋩\x{0638}-𐫮", %p)},	undef,	"to_ascii\(\'\\u1DEB\。𐋩\\u0638\-𐫮\'\)\ throws\ error\ B1\ B3\ B6\ V5\ \[data\/IdnaTest\.txt\:5260\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--gfg.xn----xnc0815qyyg", %p)},	undef,	"to_ascii\(\'xn\-\-gfg\.xn\-\-\-\-xnc0815qyyg\'\)\ throws\ error\ B1\ B3\ B6\ V5\ \[data\/IdnaTest\.txt\:5261\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("싇。⾇𐳋Ⴝ", %p)},	undef,	"to_ascii\(\'싇\。⾇𐳋Ⴝ\'\)\ throws\ error\ B5\ P1\ V6\ \[data\/IdnaTest\.txt\:5262\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("싇。⾇𐳋Ⴝ", %p)},	undef,	"to_ascii\(\'싇\。⾇𐳋Ⴝ\'\)\ throws\ error\ B5\ P1\ V6\ \[data\/IdnaTest\.txt\:5263\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("싇。舛𐳋Ⴝ", %p)},	undef,	"to_ascii\(\'싇\。舛𐳋Ⴝ\'\)\ throws\ error\ B5\ P1\ V6\ \[data\/IdnaTest\.txt\:5264\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("싇。舛𐳋Ⴝ", %p)},	undef,	"to_ascii\(\'싇\。舛𐳋Ⴝ\'\)\ throws\ error\ B5\ P1\ V6\ \[data\/IdnaTest\.txt\:5265\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_ascii("싇。舛𐳋ⴝ", %p)},	undef,	"to_ascii\(\'싇\。舛𐳋ⴝ\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:5266\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_ascii("싇。舛𐳋ⴝ", %p)},	undef,	"to_ascii\(\'싇\。舛𐳋ⴝ\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:5267\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("싇。舛𐲋Ⴝ", %p)},	undef,	"to_ascii\(\'싇\。舛𐲋Ⴝ\'\)\ throws\ error\ B5\ P1\ V6\ \[data\/IdnaTest\.txt\:5268\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("싇。舛𐲋Ⴝ", %p)},	undef,	"to_ascii\(\'싇\。舛𐲋Ⴝ\'\)\ throws\ error\ B5\ P1\ V6\ \[data\/IdnaTest\.txt\:5269\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_ascii("싇。舛𐲋ⴝ", %p)},	undef,	"to_ascii\(\'싇\。舛𐲋ⴝ\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:5270\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_ascii("싇。舛𐲋ⴝ", %p)},	undef,	"to_ascii\(\'싇\。舛𐲋ⴝ\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:5271\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--9u4b.xn--llj123yh74e", %p)},	undef,	"to_ascii\(\'xn\-\-9u4b\.xn\-\-llj123yh74e\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:5272\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--9u4b.xn--1nd7519ch79d", %p)},	undef,	"to_ascii\(\'xn\-\-9u4b\.xn\-\-1nd7519ch79d\'\)\ throws\ error\ B5\ V6\ \[data\/IdnaTest\.txt\:5273\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_ascii("싇。⾇𐳋ⴝ", %p)},	undef,	"to_ascii\(\'싇\。⾇𐳋ⴝ\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:5274\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_ascii("싇。⾇𐳋ⴝ", %p)},	undef,	"to_ascii\(\'싇\。⾇𐳋ⴝ\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:5275\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("싇。⾇𐲋Ⴝ", %p)},	undef,	"to_ascii\(\'싇\。⾇𐲋Ⴝ\'\)\ throws\ error\ B5\ P1\ V6\ \[data\/IdnaTest\.txt\:5276\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("싇。⾇𐲋Ⴝ", %p)},	undef,	"to_ascii\(\'싇\。⾇𐲋Ⴝ\'\)\ throws\ error\ B5\ P1\ V6\ \[data\/IdnaTest\.txt\:5277\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_ascii("싇。⾇𐲋ⴝ", %p)},	undef,	"to_ascii\(\'싇\。⾇𐲋ⴝ\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:5278\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_ascii("싇。⾇𐲋ⴝ", %p)},	undef,	"to_ascii\(\'싇\。⾇𐲋ⴝ\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:5279\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("𐹠ς。\x{200C}\x{06BF}Ⴠ", %p)},	undef,	"to_ascii\(\'𐹠ς\。\\u200C\\u06BFჀ\'\)\ throws\ error\ B1\ B2\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:5280\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("𐹠ς。\x{200C}\x{06BF}ⴠ", %p)},	undef,	"to_ascii\(\'𐹠ς\。\\u200C\\u06BFⴠ\'\)\ throws\ error\ B1\ B2\ B3\ \[data\/IdnaTest\.txt\:5282\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("𐹠Σ。\x{200C}\x{06BF}Ⴠ", %p)},	undef,	"to_ascii\(\'𐹠Σ\。\\u200C\\u06BFჀ\'\)\ throws\ error\ B1\ B2\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:5284\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("𐹠σ。\x{200C}\x{06BF}ⴠ", %p)},	undef,	"to_ascii\(\'𐹠σ\。\\u200C\\u06BFⴠ\'\)\ throws\ error\ B1\ B2\ B3\ \[data\/IdnaTest\.txt\:5286\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--4xa9167k.xn--ykb467q", %p)},	undef,	"to_ascii\(\'xn\-\-4xa9167k\.xn\-\-ykb467q\'\)\ throws\ error\ B1\ B2\ B3\ \[data\/IdnaTest\.txt\:5288\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--4xa9167k.xn--ykb760k9hj", %p)},	undef,	"to_ascii\(\'xn\-\-4xa9167k\.xn\-\-ykb760k9hj\'\)\ throws\ error\ B1\ C1\ \[data\/IdnaTest\.txt\:5289\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--4xa9167k.xn--ykb632c", %p)},	undef,	"to_ascii\(\'xn\-\-4xa9167k\.xn\-\-ykb632c\'\)\ throws\ error\ B1\ B2\ B3\ V6\ \[data\/IdnaTest\.txt\:5290\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--4xa9167k.xn--ykb632cvxm", %p)},	undef,	"to_ascii\(\'xn\-\-4xa9167k\.xn\-\-ykb632cvxm\'\)\ throws\ error\ B1\ C1\ V6\ \[data\/IdnaTest\.txt\:5291\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--3xa1267k.xn--ykb760k9hj", %p)},	undef,	"to_ascii\(\'xn\-\-3xa1267k\.xn\-\-ykb760k9hj\'\)\ throws\ error\ B1\ C1\ \[data\/IdnaTest\.txt\:5292\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--3xa1267k.xn--ykb632cvxm", %p)},	undef,	"to_ascii\(\'xn\-\-3xa1267k\.xn\-\-ykb632cvxm\'\)\ throws\ error\ B1\ C1\ V6\ \[data\/IdnaTest\.txt\:5293\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򇒐\x{200C}\x{0604}.\x{069A}-ß", %p)},	undef,	"to_ascii\(\'\?\\u200C\\u0604\.\\u069A\-ß\'\)\ throws\ error\ B2\ B3\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:5294\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򇒐\x{200C}\x{0604}.\x{069A}-SS", %p)},	undef,	"to_ascii\(\'\?\\u200C\\u0604\.\\u069A\-SS\'\)\ throws\ error\ B2\ B3\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:5296\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򇒐\x{200C}\x{0604}.\x{069A}-ss", %p)},	undef,	"to_ascii\(\'\?\\u200C\\u0604\.\\u069A\-ss\'\)\ throws\ error\ B2\ B3\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:5298\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򇒐\x{200C}\x{0604}.\x{069A}-Ss", %p)},	undef,	"to_ascii\(\'\?\\u200C\\u0604\.\\u069A\-Ss\'\)\ throws\ error\ B2\ B3\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:5300\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--mfb98261i.xn---ss-sdf", %p)},	undef,	"to_ascii\(\'xn\-\-mfb98261i\.xn\-\-\-ss\-sdf\'\)\ throws\ error\ B2\ B3\ B5\ B6\ V6\ \[data\/IdnaTest\.txt\:5302\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--mfb144kqo32m.xn---ss-sdf", %p)},	undef,	"to_ascii\(\'xn\-\-mfb144kqo32m\.xn\-\-\-ss\-sdf\'\)\ throws\ error\ B2\ B3\ B5\ B6\ C1\ V6\ \[data\/IdnaTest\.txt\:5303\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--mfb144kqo32m.xn----qfa315b", %p)},	undef,	"to_ascii\(\'xn\-\-mfb144kqo32m\.xn\-\-\-\-qfa315b\'\)\ throws\ error\ B2\ B3\ B5\ B6\ C1\ V6\ \[data\/IdnaTest\.txt\:5304\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}\x{200D}\x{17B5}\x{067A}.-\x{FBB0}󅄞𐸚", %p)},	undef,	"to_ascii\(\'\\u200C\\u200D\\u17B5\\u067A\.\-\\uFBB0\?\?\'\)\ throws\ error\ B1\ P1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:5305\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}\x{200D}\x{17B5}\x{067A}.-\x{06D3}󅄞𐸚", %p)},	undef,	"to_ascii\(\'\\u200C\\u200D\\u17B5\\u067A\.\-\\u06D3\?\?\'\)\ throws\ error\ B1\ P1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:5307\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}\x{200D}\x{17B5}\x{067A}.-\x{06D2}\x{0654}󅄞𐸚", %p)},	undef,	"to_ascii\(\'\\u200C\\u200D\\u17B5\\u067A\.\-\\u06D2\\u0654\?\?\'\)\ throws\ error\ B1\ P1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:5309\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--zib539f.xn----twc1133r17r6g", %p)},	undef,	"to_ascii\(\'xn\-\-zib539f\.xn\-\-\-\-twc1133r17r6g\'\)\ throws\ error\ B1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:5311\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--zib539f8igea.xn----twc1133r17r6g", %p)},	undef,	"to_ascii\(\'xn\-\-zib539f8igea\.xn\-\-\-\-twc1133r17r6g\'\)\ throws\ error\ B1\ C1\ C2\ V3\ V6\ \[data\/IdnaTest\.txt\:5312\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򡶱｡𐮬≠", %p)},	undef,	"to_ascii\(\'\?｡𐮬\≠\'\)\ throws\ error\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:5313\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򡶱｡𐮬=\x{0338}", %p)},	undef,	"to_ascii\(\'\?｡𐮬\=\\u0338\'\)\ throws\ error\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:5314\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򡶱。𐮬≠", %p)},	undef,	"to_ascii\(\'\?\。𐮬\≠\'\)\ throws\ error\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:5315\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򡶱。𐮬=\x{0338}", %p)},	undef,	"to_ascii\(\'\?\。𐮬\=\\u0338\'\)\ throws\ error\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:5316\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--dd55c.xn--1ch3003g", %p)},	undef,	"to_ascii\(\'xn\-\-dd55c\.xn\-\-1ch3003g\'\)\ throws\ error\ B3\ V6\ \[data\/IdnaTest\.txt\:5317\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0FB2}𞶅｡𐹮𐹷덝۵", %p)},	undef,	"to_ascii\(\'\\u0FB2\?｡𐹮𐹷덝۵\'\)\ throws\ error\ B1\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:5318\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0FB2}𞶅｡𐹮𐹷덝۵", %p)},	undef,	"to_ascii\(\'\\u0FB2\?｡𐹮𐹷덝۵\'\)\ throws\ error\ B1\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:5319\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0FB2}𞶅。𐹮𐹷덝۵", %p)},	undef,	"to_ascii\(\'\\u0FB2\?\。𐹮𐹷덝۵\'\)\ throws\ error\ B1\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:5320\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0FB2}𞶅。𐹮𐹷덝۵", %p)},	undef,	"to_ascii\(\'\\u0FB2\?\。𐹮𐹷덝۵\'\)\ throws\ error\ B1\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:5321\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--fgd0675v.xn--imb5839fidpcbba", %p)},	undef,	"to_ascii\(\'xn\-\-fgd0675v\.xn\-\-imb5839fidpcbba\'\)\ throws\ error\ B1\ V5\ V6\ \[data\/IdnaTest\.txt\:5322\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴏ󠅋-．\x{200D}Ⴉ", %p)},	undef,	"to_ascii\(\'Ⴏ\󠅋\-．\\u200DႩ\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:5323\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴏ󠅋-.\x{200D}Ⴉ", %p)},	undef,	"to_ascii\(\'Ⴏ\󠅋\-\.\\u200DႩ\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:5325\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("ⴏ󠅋-.\x{200D}ⴉ", %p)},	undef,	"to_ascii\(\'ⴏ\󠅋\-\.\\u200Dⴉ\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:5327\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn----3vs.xn--0kj", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-3vs\.xn\-\-0kj\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:5329\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----3vs.xn--1ug532c", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-3vs\.xn\-\-1ug532c\'\)\ throws\ error\ C2\ V3\ \[data\/IdnaTest\.txt\:5330\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----00g.xn--hnd", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-00g\.xn\-\-hnd\'\)\ throws\ error\ V3\ V6\ \[data\/IdnaTest\.txt\:5331\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----00g.xn--hnd399e", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-00g\.xn\-\-hnd399e\'\)\ throws\ error\ C2\ V3\ V6\ \[data\/IdnaTest\.txt\:5332\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("ⴏ󠅋-．\x{200D}ⴉ", %p)},	undef,	"to_ascii\(\'ⴏ\󠅋\-．\\u200Dⴉ\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:5333\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("⇧𐨏󠾈󯶅。\x{0600}󠈵󠆉", %p)},	undef,	"to_ascii\(\'\⇧𐨏\?\?\。\\u0600\?\󠆉\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:5335\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--l8g5552g64t4g46xf.xn--ifb08144p", %p)},	undef,	"to_ascii\(\'xn\-\-l8g5552g64t4g46xf\.xn\-\-ifb08144p\'\)\ throws\ error\ B1\ V6\ \[data\/IdnaTest\.txt\:5336\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≠𐮂.↑🄇⒈", %p)},	undef,	"to_ascii\(\'\≠𐮂\.\↑🄇⒈\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:5337\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("=\x{0338}𐮂.↑🄇⒈", %p)},	undef,	"to_ascii\(\'\=\\u0338𐮂\.\↑🄇⒈\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:5338\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≠𐮂.↑6,1.", %p)},	undef,	"to_ascii\(\'\≠𐮂\.\↑6\,1\.\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:5339\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("=\x{0338}𐮂.↑6,1.", %p)},	undef,	"to_ascii\(\'\=\\u0338𐮂\.\↑6\,1\.\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:5340\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--1chy492g.xn--6,1-pw1a.", %p)},	undef,	"to_ascii\(\'xn\-\-1chy492g\.xn\-\-6\,1\-pw1a\.\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:5341\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--1chy492g.xn--45gx9iuy44d", %p)},	undef,	"to_ascii\(\'xn\-\-1chy492g\.xn\-\-45gx9iuy44d\'\)\ throws\ error\ B1\ V6\ \[data\/IdnaTest\.txt\:5342\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𝩏󠲉ß.ᢤ򄦌\x{200C}𐹫", %p)},	undef,	"to_ascii\(\'𝩏\?ß\.ᢤ\?\\u200C𐹫\'\)\ throws\ error\ B1\ B5\ B6\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:5343\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𝩏󠲉SS.ᢤ򄦌\x{200C}𐹫", %p)},	undef,	"to_ascii\(\'𝩏\?SS\.ᢤ\?\\u200C𐹫\'\)\ throws\ error\ B1\ B5\ B6\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:5345\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𝩏󠲉ss.ᢤ򄦌\x{200C}𐹫", %p)},	undef,	"to_ascii\(\'𝩏\?ss\.ᢤ\?\\u200C𐹫\'\)\ throws\ error\ B1\ B5\ B6\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:5347\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𝩏󠲉Ss.ᢤ򄦌\x{200C}𐹫", %p)},	undef,	"to_ascii\(\'𝩏\?Ss\.ᢤ\?\\u200C𐹫\'\)\ throws\ error\ B1\ B5\ B6\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:5349\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--ss-zb11ap1427e.xn--ubf2596jbt61c", %p)},	undef,	"to_ascii\(\'xn\-\-ss\-zb11ap1427e\.xn\-\-ubf2596jbt61c\'\)\ throws\ error\ B1\ B5\ B6\ V5\ V6\ \[data\/IdnaTest\.txt\:5351\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--ss-zb11ap1427e.xn--ubf609atw1tynn3d", %p)},	undef,	"to_ascii\(\'xn\-\-ss\-zb11ap1427e\.xn\-\-ubf609atw1tynn3d\'\)\ throws\ error\ B1\ B5\ B6\ C1\ V5\ V6\ \[data\/IdnaTest\.txt\:5352\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--zca3153vupz3e.xn--ubf609atw1tynn3d", %p)},	undef,	"to_ascii\(\'xn\-\-zca3153vupz3e\.xn\-\-ubf609atw1tynn3d\'\)\ throws\ error\ B1\ B5\ B6\ C1\ V5\ V6\ \[data\/IdnaTest\.txt\:5353\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ß𐵳񗘁Ⴇ｡\x{A67A}", %p)},	undef,	"to_ascii\(\'ß\?\?Ⴇ｡\\uA67A\'\)\ throws\ error\ B1\ B3\ B5\ B6\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:5354\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ß𐵳񗘁Ⴇ。\x{A67A}", %p)},	undef,	"to_ascii\(\'ß\?\?Ⴇ\。\\uA67A\'\)\ throws\ error\ B1\ B3\ B5\ B6\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:5356\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ß𐵳񗘁ⴇ。\x{A67A}", %p)},	undef,	"to_ascii\(\'ß\?\?ⴇ\。\\uA67A\'\)\ throws\ error\ B1\ B3\ B5\ B6\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:5358\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("SS𐵳񗘁Ⴇ。\x{A67A}", %p)},	undef,	"to_ascii\(\'SS\?\?Ⴇ\。\\uA67A\'\)\ throws\ error\ B1\ B3\ B5\ B6\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:5360\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ss𐵳񗘁ⴇ。\x{A67A}", %p)},	undef,	"to_ascii\(\'ss\?\?ⴇ\。\\uA67A\'\)\ throws\ error\ B1\ B3\ B5\ B6\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:5361\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ss𐵳񗘁Ⴇ。\x{A67A}", %p)},	undef,	"to_ascii\(\'Ss\?\?Ⴇ\。\\uA67A\'\)\ throws\ error\ B1\ B3\ B5\ B6\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:5362\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--ss-rek7420r4hs7b.xn--9x8a", %p)},	undef,	"to_ascii\(\'xn\-\-ss\-rek7420r4hs7b\.xn\-\-9x8a\'\)\ throws\ error\ B1\ B3\ B5\ B6\ V5\ V6\ \[data\/IdnaTest\.txt\:5363\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--ss-e61ar955h4hs7b.xn--9x8a", %p)},	undef,	"to_ascii\(\'xn\-\-ss\-e61ar955h4hs7b\.xn\-\-9x8a\'\)\ throws\ error\ B1\ B3\ B5\ B6\ V5\ V6\ \[data\/IdnaTest\.txt\:5364\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--zca227tpy4lkns1b.xn--9x8a", %p)},	undef,	"to_ascii\(\'xn\-\-zca227tpy4lkns1b\.xn\-\-9x8a\'\)\ throws\ error\ B1\ B3\ B5\ B6\ V5\ V6\ \[data\/IdnaTest\.txt\:5365\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--zca491fci5qkn79a.xn--9x8a", %p)},	undef,	"to_ascii\(\'xn\-\-zca491fci5qkn79a\.xn\-\-9x8a\'\)\ throws\ error\ B1\ B3\ B5\ B6\ V5\ V6\ \[data\/IdnaTest\.txt\:5366\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ß𐵳񗘁ⴇ｡\x{A67A}", %p)},	undef,	"to_ascii\(\'ß\?\?ⴇ｡\\uA67A\'\)\ throws\ error\ B1\ B3\ B5\ B6\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:5367\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("SS𐵳񗘁Ⴇ｡\x{A67A}", %p)},	undef,	"to_ascii\(\'SS\?\?Ⴇ｡\\uA67A\'\)\ throws\ error\ B1\ B3\ B5\ B6\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:5369\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ss𐵳񗘁ⴇ｡\x{A67A}", %p)},	undef,	"to_ascii\(\'ss\?\?ⴇ｡\\uA67A\'\)\ throws\ error\ B1\ B3\ B5\ B6\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:5370\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ss𐵳񗘁Ⴇ｡\x{A67A}", %p)},	undef,	"to_ascii\(\'Ss\?\?Ⴇ｡\\uA67A\'\)\ throws\ error\ B1\ B3\ B5\ B6\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:5371\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("\x{1714}。󠆣-𑋪", %p)},	undef,	"to_ascii\(\'\\u1714\。\󠆣\-𑋪\'\)\ throws\ error\ V3\ V5\ \[data\/IdnaTest\.txt\:5372\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--fze.xn----ly8i", %p)},	undef,	"to_ascii\(\'xn\-\-fze\.xn\-\-\-\-ly8i\'\)\ throws\ error\ V3\ V5\ \[data\/IdnaTest\.txt\:5373\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{ABE8}-．򨏜\x{05BD}ß", %p)},	undef,	"to_ascii\(\'\\uABE8\-．\?\\u05BDß\'\)\ throws\ error\ P1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:5374\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{ABE8}-.򨏜\x{05BD}ß", %p)},	undef,	"to_ascii\(\'\\uABE8\-\.\?\\u05BDß\'\)\ throws\ error\ P1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:5376\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{ABE8}-.򨏜\x{05BD}SS", %p)},	undef,	"to_ascii\(\'\\uABE8\-\.\?\\u05BDSS\'\)\ throws\ error\ P1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:5378\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{ABE8}-.򨏜\x{05BD}ss", %p)},	undef,	"to_ascii\(\'\\uABE8\-\.\?\\u05BDss\'\)\ throws\ error\ P1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:5379\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{ABE8}-.򨏜\x{05BD}Ss", %p)},	undef,	"to_ascii\(\'\\uABE8\-\.\?\\u05BDSs\'\)\ throws\ error\ P1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:5380\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----pw5e.xn--ss-7jd10716y", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-pw5e\.xn\-\-ss\-7jd10716y\'\)\ throws\ error\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:5381\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----pw5e.xn--zca50wfv060a", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-pw5e\.xn\-\-zca50wfv060a\'\)\ throws\ error\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:5382\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{ABE8}-．򨏜\x{05BD}SS", %p)},	undef,	"to_ascii\(\'\\uABE8\-．\?\\u05BDSS\'\)\ throws\ error\ P1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:5383\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{ABE8}-．򨏜\x{05BD}ss", %p)},	undef,	"to_ascii\(\'\\uABE8\-．\?\\u05BDss\'\)\ throws\ error\ P1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:5384\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{ABE8}-．򨏜\x{05BD}Ss", %p)},	undef,	"to_ascii\(\'\\uABE8\-．\?\\u05BDSs\'\)\ throws\ error\ P1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:5385\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᡓ-≮。\x{066B}󠅱ᡄ", %p)},	undef,	"to_ascii\(\'ᡓ\-\≮\。\\u066B\󠅱ᡄ\'\)\ throws\ error\ B1\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:5386\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᡓ-<\x{0338}。\x{066B}󠅱ᡄ", %p)},	undef,	"to_ascii\(\'ᡓ\-\<\\u0338\。\\u066B\󠅱ᡄ\'\)\ throws\ error\ B1\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:5387\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----s7j866c.xn--kib252g", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-s7j866c\.xn\-\-kib252g\'\)\ throws\ error\ B1\ B6\ V6\ \[data\/IdnaTest\.txt\:5388\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_ascii("𝟥♮𑜫\x{08ED}．\x{17D2}𑜫8󠆏", %p)},	undef,	"to_ascii\(\'𝟥\♮𑜫\\u08ED．\\u17D2𑜫8\󠆏\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:5389\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_ascii("3♮𑜫\x{08ED}.\x{17D2}𑜫8󠆏", %p)},	undef,	"to_ascii\(\'3\♮𑜫\\u08ED\.\\u17D2𑜫8\󠆏\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:5390\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--3-ksd277tlo7s.xn--8-f0jx021l", %p)},	undef,	"to_ascii\(\'xn\-\-3\-ksd277tlo7s\.xn\-\-8\-f0jx021l\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:5391\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-｡򕌀\x{200D}❡", %p)},	undef,	"to_ascii\(\'\-｡\?\\u200D\❡\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:5392\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-。򕌀\x{200D}❡", %p)},	undef,	"to_ascii\(\'\-\。\?\\u200D\❡\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:5394\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-.xn--nei54421f", %p)},	undef,	"to_ascii\(\'\-\.xn\-\-nei54421f\'\)\ throws\ error\ V3\ V6\ \[data\/IdnaTest\.txt\:5396\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-.xn--1ug800aq795s", %p)},	undef,	"to_ascii\(\'\-\.xn\-\-1ug800aq795s\'\)\ throws\ error\ C2\ V3\ V6\ \[data\/IdnaTest\.txt\:5397\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𝟓☱𝟐򥰵｡𝪮񐡳", %p)},	undef,	"to_ascii\(\'𝟓\☱𝟐\?｡𝪮\?\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:5398\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("5☱2򥰵。𝪮񐡳", %p)},	undef,	"to_ascii\(\'5\☱2\?\。𝪮\?\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:5399\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--52-dwx47758j.xn--kd3hk431k", %p)},	undef,	"to_ascii\(\'xn\-\-52\-dwx47758j\.xn\-\-kd3hk431k\'\)\ throws\ error\ V5\ V6\ \[data\/IdnaTest\.txt\:5400\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-.-├򖦣", %p)},	undef,	"to_ascii\(\'\-\.\-\├\?\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:5401\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-.xn----ukp70432h", %p)},	undef,	"to_ascii\(\'\-\.xn\-\-\-\-ukp70432h\'\)\ throws\ error\ V3\ V6\ \[data\/IdnaTest\.txt\:5402\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{05A5}\x{076D}｡\x{200D}󠀘", %p)},	undef,	"to_ascii\(\'\\u05A5\\u076D｡\\u200D\?\'\)\ throws\ error\ B1\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:5403\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{05A5}\x{076D}。\x{200D}󠀘", %p)},	undef,	"to_ascii\(\'\\u05A5\\u076D\。\\u200D\?\'\)\ throws\ error\ B1\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:5405\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--wcb62g.xn--p526e", %p)},	undef,	"to_ascii\(\'xn\-\-wcb62g\.xn\-\-p526e\'\)\ throws\ error\ B1\ V5\ V6\ \[data\/IdnaTest\.txt\:5407\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--wcb62g.xn--1ugy8001l", %p)},	undef,	"to_ascii\(\'xn\-\-wcb62g\.xn\-\-1ugy8001l\'\)\ throws\ error\ B1\ C2\ V5\ V6\ \[data\/IdnaTest\.txt\:5408\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("쥥󔏉Ⴎ．\x{200C}⒈⒈𐫒", %p)},	undef,	"to_ascii\(\'쥥\?Ⴎ．\\u200C⒈⒈𐫒\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:5409\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("쥥󔏉Ⴎ．\x{200C}⒈⒈𐫒", %p)},	undef,	"to_ascii\(\'쥥\?Ⴎ．\\u200C⒈⒈𐫒\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:5411\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("쥥󔏉Ⴎ.\x{200C}1.1.𐫒", %p)},	undef,	"to_ascii\(\'쥥\?Ⴎ\.\\u200C1\.1\.𐫒\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:5413\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("쥥󔏉Ⴎ.\x{200C}1.1.𐫒", %p)},	undef,	"to_ascii\(\'쥥\?Ⴎ\.\\u200C1\.1\.𐫒\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:5415\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("쥥󔏉ⴎ.\x{200C}1.1.𐫒", %p)},	undef,	"to_ascii\(\'쥥\?ⴎ\.\\u200C1\.1\.𐫒\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:5417\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("쥥󔏉ⴎ.\x{200C}1.1.𐫒", %p)},	undef,	"to_ascii\(\'쥥\?ⴎ\.\\u200C1\.1\.𐫒\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:5419\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--5kj3511ccyw3h.1.1.xn--7w9c", %p)},	undef,	"to_ascii\(\'xn\-\-5kj3511ccyw3h\.1\.1\.xn\-\-7w9c\'\)\ throws\ error\ B1\ V6\ \[data\/IdnaTest\.txt\:5421\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--5kj3511ccyw3h.xn--1-rgn.1.xn--7w9c", %p)},	undef,	"to_ascii\(\'xn\-\-5kj3511ccyw3h\.xn\-\-1\-rgn\.1\.xn\-\-7w9c\'\)\ throws\ error\ B1\ C1\ V6\ \[data\/IdnaTest\.txt\:5422\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--mnd7865gcy28g.1.1.xn--7w9c", %p)},	undef,	"to_ascii\(\'xn\-\-mnd7865gcy28g\.1\.1\.xn\-\-7w9c\'\)\ throws\ error\ B1\ V6\ \[data\/IdnaTest\.txt\:5423\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--mnd7865gcy28g.xn--1-rgn.1.xn--7w9c", %p)},	undef,	"to_ascii\(\'xn\-\-mnd7865gcy28g\.xn\-\-1\-rgn\.1\.xn\-\-7w9c\'\)\ throws\ error\ B1\ C1\ V6\ \[data\/IdnaTest\.txt\:5424\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("쥥󔏉ⴎ．\x{200C}⒈⒈𐫒", %p)},	undef,	"to_ascii\(\'쥥\?ⴎ．\\u200C⒈⒈𐫒\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:5425\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("쥥󔏉ⴎ．\x{200C}⒈⒈𐫒", %p)},	undef,	"to_ascii\(\'쥥\?ⴎ．\\u200C⒈⒈𐫒\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:5427\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--5kj3511ccyw3h.xn--tsha6797o", %p)},	undef,	"to_ascii\(\'xn\-\-5kj3511ccyw3h\.xn\-\-tsha6797o\'\)\ throws\ error\ B1\ V6\ \[data\/IdnaTest\.txt\:5429\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--5kj3511ccyw3h.xn--0ug88oa0396u", %p)},	undef,	"to_ascii\(\'xn\-\-5kj3511ccyw3h\.xn\-\-0ug88oa0396u\'\)\ throws\ error\ B1\ C1\ V6\ \[data\/IdnaTest\.txt\:5430\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--mnd7865gcy28g.xn--tsha6797o", %p)},	undef,	"to_ascii\(\'xn\-\-mnd7865gcy28g\.xn\-\-tsha6797o\'\)\ throws\ error\ B1\ V6\ \[data\/IdnaTest\.txt\:5431\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--mnd7865gcy28g.xn--0ug88oa0396u", %p)},	undef,	"to_ascii\(\'xn\-\-mnd7865gcy28g\.xn\-\-0ug88oa0396u\'\)\ throws\ error\ B1\ C1\ V6\ \[data\/IdnaTest\.txt\:5432\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_ascii("\x{0827}𝟶\x{06A0}-。𑄳", %p)},	undef,	"to_ascii\(\'\\u0827𝟶\\u06A0\-\。𑄳\'\)\ throws\ error\ B1\ B3\ B6\ V3\ V5\ \[data\/IdnaTest\.txt\:5433\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_ascii("\x{0827}0\x{06A0}-。𑄳", %p)},	undef,	"to_ascii\(\'\\u08270\\u06A0\-\。𑄳\'\)\ throws\ error\ B1\ B3\ B6\ V3\ V5\ \[data\/IdnaTest\.txt\:5434\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--0--p3d67m.xn--v80d", %p)},	undef,	"to_ascii\(\'xn\-\-0\-\-p3d67m\.xn\-\-v80d\'\)\ throws\ error\ B1\ B3\ B6\ V3\ V5\ \[data\/IdnaTest\.txt\:5435\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ς．\x{FDC1}🞛⒈", %p)},	undef,	"to_ascii\(\'ς．\\uFDC1🞛⒈\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:5436\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("ς.\x{0641}\x{0645}\x{064A}🞛1.", %p)},	"xn--4xa.xn--1-gocmu97674d.",	"to_ascii\(\'ς\.\\u0641\\u0645\\u064A🞛1\.\'\)\ \[data\/IdnaTest\.txt\:5438\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("Σ.\x{0641}\x{0645}\x{064A}🞛1.", %p)},	"xn--4xa.xn--1-gocmu97674d.",	"to_ascii\(\'Σ\.\\u0641\\u0645\\u064A🞛1\.\'\)\ \[data\/IdnaTest\.txt\:5440\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("σ.\x{0641}\x{0645}\x{064A}🞛1.", %p)},	"xn--4xa.xn--1-gocmu97674d.",	"to_ascii\(\'σ\.\\u0641\\u0645\\u064A🞛1\.\'\)\ \[data\/IdnaTest\.txt\:5441\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("xn--4xa.xn--1-gocmu97674d.", %p)},	"xn--4xa.xn--1-gocmu97674d.",	"to_ascii\(\'xn\-\-4xa\.xn\-\-1\-gocmu97674d\.\'\)\ \[data\/IdnaTest\.txt\:5442\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("xn--3xa.xn--1-gocmu97674d.", %p)},	"xn--3xa.xn--1-gocmu97674d.",	"to_ascii\(\'xn\-\-3xa\.xn\-\-1\-gocmu97674d\.\'\)\ \[data\/IdnaTest\.txt\:5443\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("Σ．\x{FDC1}🞛⒈", %p)},	undef,	"to_ascii\(\'Σ．\\uFDC1🞛⒈\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:5444\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("σ．\x{FDC1}🞛⒈", %p)},	undef,	"to_ascii\(\'σ．\\uFDC1🞛⒈\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:5445\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--4xa.xn--dhbip2802atb20c", %p)},	undef,	"to_ascii\(\'xn\-\-4xa\.xn\-\-dhbip2802atb20c\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:5446\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--3xa.xn--dhbip2802atb20c", %p)},	undef,	"to_ascii\(\'xn\-\-3xa\.xn\-\-dhbip2802atb20c\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:5447\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("🗩-｡𐹻󐞆񥉮", %p)},	undef,	"to_ascii\(\'🗩\-｡𐹻\?\?\'\)\ throws\ error\ B1\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:5448\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("🗩-。𐹻󐞆񥉮", %p)},	undef,	"to_ascii\(\'🗩\-\。𐹻\?\?\'\)\ throws\ error\ B1\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:5449\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----6t3s.xn--zo0d4811u6ru6a", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-6t3s\.xn\-\-zo0d4811u6ru6a\'\)\ throws\ error\ B1\ V3\ V6\ \[data\/IdnaTest\.txt\:5450\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐡜-🔪｡𝟻\x{200C}𐿀", %p)},	undef,	"to_ascii\(\'𐡜\-🔪｡𝟻\\u200C𐿀\'\)\ throws\ error\ B1\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:5451\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐡜-🔪。5\x{200C}𐿀", %p)},	undef,	"to_ascii\(\'𐡜\-🔪\。5\\u200C𐿀\'\)\ throws\ error\ B1\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:5453\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----5j4iv089c.xn--5-bn7i", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-5j4iv089c\.xn\-\-5\-bn7i\'\)\ throws\ error\ B1\ B3\ V6\ \[data\/IdnaTest\.txt\:5455\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----5j4iv089c.xn--5-sgn7149h", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-5j4iv089c\.xn\-\-5\-sgn7149h\'\)\ throws\ error\ B1\ B3\ C1\ V6\ \[data\/IdnaTest\.txt\:5456\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("𐹣늿\x{200D}ß．\x{07CF}0\x{05BC}", %p)},	undef,	"to_ascii\(\'𐹣늿\\u200Dß．\\u07CF0\\u05BC\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:5457\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("𐹣늿\x{200D}ß．\x{07CF}0\x{05BC}", %p)},	undef,	"to_ascii\(\'𐹣늿\\u200Dß．\\u07CF0\\u05BC\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:5459\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("𐹣늿\x{200D}ß.\x{07CF}0\x{05BC}", %p)},	undef,	"to_ascii\(\'𐹣늿\\u200Dß\.\\u07CF0\\u05BC\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:5461\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("𐹣늿\x{200D}ß.\x{07CF}0\x{05BC}", %p)},	undef,	"to_ascii\(\'𐹣늿\\u200Dß\.\\u07CF0\\u05BC\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:5463\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("𐹣늿\x{200D}SS.\x{07CF}0\x{05BC}", %p)},	undef,	"to_ascii\(\'𐹣늿\\u200DSS\.\\u07CF0\\u05BC\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:5465\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("𐹣늿\x{200D}SS.\x{07CF}0\x{05BC}", %p)},	undef,	"to_ascii\(\'𐹣늿\\u200DSS\.\\u07CF0\\u05BC\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:5467\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("𐹣늿\x{200D}ss.\x{07CF}0\x{05BC}", %p)},	undef,	"to_ascii\(\'𐹣늿\\u200Dss\.\\u07CF0\\u05BC\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:5469\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("𐹣늿\x{200D}ss.\x{07CF}0\x{05BC}", %p)},	undef,	"to_ascii\(\'𐹣늿\\u200Dss\.\\u07CF0\\u05BC\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:5471\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("𐹣늿\x{200D}Ss.\x{07CF}0\x{05BC}", %p)},	undef,	"to_ascii\(\'𐹣늿\\u200DSs\.\\u07CF0\\u05BC\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:5473\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("𐹣늿\x{200D}Ss.\x{07CF}0\x{05BC}", %p)},	undef,	"to_ascii\(\'𐹣늿\\u200DSs\.\\u07CF0\\u05BC\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:5475\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--ss-i05i7041a.xn--0-vgc50n", %p)},	undef,	"to_ascii\(\'xn\-\-ss\-i05i7041a\.xn\-\-0\-vgc50n\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:5477\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--ss-l1tu910fo0xd.xn--0-vgc50n", %p)},	undef,	"to_ascii\(\'xn\-\-ss\-l1tu910fo0xd\.xn\-\-0\-vgc50n\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:5478\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--zca770n5s4hev6c.xn--0-vgc50n", %p)},	undef,	"to_ascii\(\'xn\-\-zca770n5s4hev6c\.xn\-\-0\-vgc50n\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:5479\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("𐹣늿\x{200D}SS．\x{07CF}0\x{05BC}", %p)},	undef,	"to_ascii\(\'𐹣늿\\u200DSS．\\u07CF0\\u05BC\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:5480\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("𐹣늿\x{200D}SS．\x{07CF}0\x{05BC}", %p)},	undef,	"to_ascii\(\'𐹣늿\\u200DSS．\\u07CF0\\u05BC\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:5482\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("𐹣늿\x{200D}ss．\x{07CF}0\x{05BC}", %p)},	undef,	"to_ascii\(\'𐹣늿\\u200Dss．\\u07CF0\\u05BC\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:5484\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("𐹣늿\x{200D}ss．\x{07CF}0\x{05BC}", %p)},	undef,	"to_ascii\(\'𐹣늿\\u200Dss．\\u07CF0\\u05BC\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:5486\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("𐹣늿\x{200D}Ss．\x{07CF}0\x{05BC}", %p)},	undef,	"to_ascii\(\'𐹣늿\\u200DSs．\\u07CF0\\u05BC\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:5488\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("𐹣늿\x{200D}Ss．\x{07CF}0\x{05BC}", %p)},	undef,	"to_ascii\(\'𐹣늿\\u200DSs．\\u07CF0\\u05BC\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:5490\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("9󠇥．󪴴ᢓ", %p)},	undef,	"to_ascii\(\'9\󠇥．\?ᢓ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:5492\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("9󠇥.󪴴ᢓ", %p)},	undef,	"to_ascii\(\'9\󠇥\.\?ᢓ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:5493\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("9.xn--dbf91222q", %p)},	undef,	"to_ascii\(\'9\.xn\-\-dbf91222q\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:5494\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}\x{FFA0}.𐫭🠗ß⽟", %p)},	undef,	"to_ascii\(\'\\u200C\\uFFA0\.𐫭🠗ß⽟\'\)\ throws\ error\ B2\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:5495\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}\x{1160}.𐫭🠗ß玉", %p)},	undef,	"to_ascii\(\'\\u200C\\u1160\.𐫭🠗ß玉\'\)\ throws\ error\ B2\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:5497\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}\x{1160}.𐫭🠗SS玉", %p)},	undef,	"to_ascii\(\'\\u200C\\u1160\.𐫭🠗SS玉\'\)\ throws\ error\ B2\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:5499\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}\x{1160}.𐫭🠗ss玉", %p)},	undef,	"to_ascii\(\'\\u200C\\u1160\.𐫭🠗ss玉\'\)\ throws\ error\ B2\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:5501\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}\x{1160}.𐫭🠗Ss玉", %p)},	undef,	"to_ascii\(\'\\u200C\\u1160\.𐫭🠗Ss玉\'\)\ throws\ error\ B2\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:5503\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--psd.xn--ss-je6eq954cp25j", %p)},	undef,	"to_ascii\(\'xn\-\-psd\.xn\-\-ss\-je6eq954cp25j\'\)\ throws\ error\ B2\ B3\ V6\ \[data\/IdnaTest\.txt\:5505\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--psd526e.xn--ss-je6eq954cp25j", %p)},	undef,	"to_ascii\(\'xn\-\-psd526e\.xn\-\-ss\-je6eq954cp25j\'\)\ throws\ error\ B1\ B2\ B3\ C1\ V6\ \[data\/IdnaTest\.txt\:5506\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--psd526e.xn--zca2289c550e0iwi", %p)},	undef,	"to_ascii\(\'xn\-\-psd526e\.xn\-\-zca2289c550e0iwi\'\)\ throws\ error\ B1\ B2\ B3\ C1\ V6\ \[data\/IdnaTest\.txt\:5507\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}\x{FFA0}.𐫭🠗SS⽟", %p)},	undef,	"to_ascii\(\'\\u200C\\uFFA0\.𐫭🠗SS⽟\'\)\ throws\ error\ B2\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:5508\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}\x{FFA0}.𐫭🠗ss⽟", %p)},	undef,	"to_ascii\(\'\\u200C\\uFFA0\.𐫭🠗ss⽟\'\)\ throws\ error\ B2\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:5510\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}\x{FFA0}.𐫭🠗Ss⽟", %p)},	undef,	"to_ascii\(\'\\u200C\\uFFA0\.𐫭🠗Ss⽟\'\)\ throws\ error\ B2\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:5512\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--cl7c.xn--ss-je6eq954cp25j", %p)},	undef,	"to_ascii\(\'xn\-\-cl7c\.xn\-\-ss\-je6eq954cp25j\'\)\ throws\ error\ B2\ B3\ V6\ \[data\/IdnaTest\.txt\:5514\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--0ug7719f.xn--ss-je6eq954cp25j", %p)},	undef,	"to_ascii\(\'xn\-\-0ug7719f\.xn\-\-ss\-je6eq954cp25j\'\)\ throws\ error\ B1\ B2\ B3\ C1\ V6\ \[data\/IdnaTest\.txt\:5515\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--0ug7719f.xn--zca2289c550e0iwi", %p)},	undef,	"to_ascii\(\'xn\-\-0ug7719f\.xn\-\-zca2289c550e0iwi\'\)\ throws\ error\ B1\ B2\ B3\ C1\ V6\ \[data\/IdnaTest\.txt\:5516\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("︒Ⴖ\x{0366}．\x{200C}", %p)},	undef,	"to_ascii\(\'︒Ⴖ\\u0366．\\u200C\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:5517\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("。Ⴖ\x{0366}.\x{200C}", %p)},	undef,	"to_ascii\(\'\。Ⴖ\\u0366\.\\u200C\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:5519\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("。ⴖ\x{0366}.\x{200C}", %p)},	undef,	"to_ascii\(\'\。ⴖ\\u0366\.\\u200C\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:5521\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii(".xn--hva754s.", %p)},	undef,	"to_ascii\(\'\.xn\-\-hva754s\.\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:5523\]") or ($@ and diag($@));
is(eval{uts46_to_ascii(".xn--hva754s.xn--0ug", %p)},	undef,	"to_ascii\(\'\.xn\-\-hva754s\.xn\-\-0ug\'\)\ throws\ error\ C1\ A4_2\ \[data\/IdnaTest\.txt\:5524\]") or ($@ and diag($@));
is(eval{uts46_to_ascii(".xn--hva929d.", %p)},	undef,	"to_ascii\(\'\.xn\-\-hva929d\.\'\)\ throws\ error\ V6\ A4_2\ \[data\/IdnaTest\.txt\:5525\]") or ($@ and diag($@));
is(eval{uts46_to_ascii(".xn--hva929d.xn--0ug", %p)},	undef,	"to_ascii\(\'\.xn\-\-hva929d\.xn\-\-0ug\'\)\ throws\ error\ C1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:5526\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("︒ⴖ\x{0366}．\x{200C}", %p)},	undef,	"to_ascii\(\'︒ⴖ\\u0366．\\u200C\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:5527\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--hva754sy94k.", %p)},	undef,	"to_ascii\(\'xn\-\-hva754sy94k\.\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:5529\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--hva754sy94k.xn--0ug", %p)},	undef,	"to_ascii\(\'xn\-\-hva754sy94k\.xn\-\-0ug\'\)\ throws\ error\ C1\ V6\ \[data\/IdnaTest\.txt\:5530\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--hva929dl29p.", %p)},	undef,	"to_ascii\(\'xn\-\-hva929dl29p\.\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:5531\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--hva929dl29p.xn--0ug", %p)},	undef,	"to_ascii\(\'xn\-\-hva929dl29p\.xn\-\-0ug\'\)\ throws\ error\ C1\ V6\ \[data\/IdnaTest\.txt\:5532\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("xn--hva754s.", %p)},	"xn--hva754s.",	"to_ascii\(\'xn\-\-hva754s\.\'\)\ \[data\/IdnaTest\.txt\:5533\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("ⴖ\x{0366}.", %p)},	"xn--hva754s.",	"to_ascii\(\'ⴖ\\u0366\.\'\)\ \[data\/IdnaTest\.txt\:5534\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("Ⴖ\x{0366}.", %p)},	undef,	"to_ascii\(\'Ⴖ\\u0366\.\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:5535\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--hva929d.", %p)},	undef,	"to_ascii\(\'xn\-\-hva929d\.\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:5536\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{08BB}．\x{200C}Ⴃ𞀒", %p)},	undef,	"to_ascii\(\'\\u08BB．\\u200CႣ𞀒\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:5537\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{08BB}.\x{200C}Ⴃ𞀒", %p)},	undef,	"to_ascii\(\'\\u08BB\.\\u200CႣ𞀒\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:5539\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("\x{08BB}.\x{200C}ⴃ𞀒", %p)},	"xn--hzb.xn--ukj4430l",	"to_ascii\(\'\\u08BB\.\\u200Cⴃ𞀒\'\)\ \[data\/IdnaTest\.txt\:5541\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("xn--hzb.xn--ukj4430l", %p)},	"xn--hzb.xn--ukj4430l",	"to_ascii\(\'xn\-\-hzb\.xn\-\-ukj4430l\'\)\ \[data\/IdnaTest\.txt\:5543\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("\x{08BB}.ⴃ𞀒", %p)},	"xn--hzb.xn--ukj4430l",	"to_ascii\(\'\\u08BB\.ⴃ𞀒\'\)\ \[data\/IdnaTest\.txt\:5544\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("\x{08BB}.Ⴃ𞀒", %p)},	undef,	"to_ascii\(\'\\u08BB\.Ⴃ𞀒\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:5545\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--hzb.xn--bnd2938u", %p)},	undef,	"to_ascii\(\'xn\-\-hzb\.xn\-\-bnd2938u\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:5546\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--hzb.xn--0ug822cp045a", %p)},	undef,	"to_ascii\(\'xn\-\-hzb\.xn\-\-0ug822cp045a\'\)\ throws\ error\ B1\ C1\ \[data\/IdnaTest\.txt\:5547\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--hzb.xn--bnd300f7225a", %p)},	undef,	"to_ascii\(\'xn\-\-hzb\.xn\-\-bnd300f7225a\'\)\ throws\ error\ B1\ C1\ V6\ \[data\/IdnaTest\.txt\:5548\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("\x{08BB}．\x{200C}ⴃ𞀒", %p)},	"xn--hzb.xn--ukj4430l",	"to_ascii\(\'\\u08BB．\\u200Cⴃ𞀒\'\)\ \[data\/IdnaTest\.txt\:5549\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("\x{200D}\x{200C}。２䫷󠧷", %p)},	undef,	"to_ascii\(\'\\u200D\\u200C\。２䫷\?\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:5551\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}\x{200C}。2䫷󠧷", %p)},	undef,	"to_ascii\(\'\\u200D\\u200C\。2䫷\?\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:5553\]") or ($@ and diag($@));
is(eval{uts46_to_ascii(".xn--2-me5ay1273i", %p)},	undef,	"to_ascii\(\'\.xn\-\-2\-me5ay1273i\'\)\ throws\ error\ V6\ A4_2\ \[data\/IdnaTest\.txt\:5555\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--0ugb.xn--2-me5ay1273i", %p)},	undef,	"to_ascii\(\'xn\-\-0ugb\.xn\-\-2\-me5ay1273i\'\)\ throws\ error\ C1\ C2\ V6\ \[data\/IdnaTest\.txt\:5556\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-𞀤󜠐。򈬖", %p)},	undef,	"to_ascii\(\'\-𞀤\?\。\?\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:5557\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----rq4re4997d.xn--l707b", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-rq4re4997d\.xn\-\-l707b\'\)\ throws\ error\ V3\ V6\ \[data\/IdnaTest\.txt\:5558\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󳛂︒\x{200C}㟀．\x{0624}⒈", %p)},	undef,	"to_ascii\(\'\?︒\\u200C㟀．\\u0624⒈\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:5559\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󳛂︒\x{200C}㟀．\x{0648}\x{0654}⒈", %p)},	undef,	"to_ascii\(\'\?︒\\u200C㟀．\\u0648\\u0654⒈\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:5561\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󳛂。\x{200C}㟀.\x{0624}1.", %p)},	undef,	"to_ascii\(\'\?\。\\u200C㟀\.\\u06241\.\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:5563\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󳛂。\x{200C}㟀.\x{0648}\x{0654}1.", %p)},	undef,	"to_ascii\(\'\?\。\\u200C㟀\.\\u0648\\u06541\.\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:5565\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--z272f.xn--etl.xn--1-smc.", %p)},	undef,	"to_ascii\(\'xn\-\-z272f\.xn\-\-etl\.xn\-\-1\-smc\.\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:5567\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--z272f.xn--0ug754g.xn--1-smc.", %p)},	undef,	"to_ascii\(\'xn\-\-z272f\.xn\-\-0ug754g\.xn\-\-1\-smc\.\'\)\ throws\ error\ B1\ C1\ V6\ \[data\/IdnaTest\.txt\:5568\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--etlt457ccrq7h.xn--jgb476m", %p)},	undef,	"to_ascii\(\'xn\-\-etlt457ccrq7h\.xn\-\-jgb476m\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:5569\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--0ug754gxl4ldlt0k.xn--jgb476m", %p)},	undef,	"to_ascii\(\'xn\-\-0ug754gxl4ldlt0k\.xn\-\-jgb476m\'\)\ throws\ error\ C1\ V6\ \[data\/IdnaTest\.txt\:5570\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("𑲜\x{07CA}𝅼。-\x{200D}", %p)},	undef,	"to_ascii\(\'𑲜\\u07CA𝅼\。\-\\u200D\'\)\ throws\ error\ B1\ V3\ V5\ \[data\/IdnaTest\.txt\:5571\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--lsb5482l7nre.-", %p)},	undef,	"to_ascii\(\'xn\-\-lsb5482l7nre\.\-\'\)\ throws\ error\ B1\ V3\ V5\ \[data\/IdnaTest\.txt\:5573\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--lsb5482l7nre.xn----ugn", %p)},	undef,	"to_ascii\(\'xn\-\-lsb5482l7nre\.xn\-\-\-\-ugn\'\)\ throws\ error\ B1\ C2\ V3\ V5\ \[data\/IdnaTest\.txt\:5574\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}．Ⴉ≠𐫶", %p)},	undef,	"to_ascii\(\'\\u200C．Ⴉ\≠𐫶\'\)\ throws\ error\ B5\ B6\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:5575\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}．Ⴉ=\x{0338}𐫶", %p)},	undef,	"to_ascii\(\'\\u200C．Ⴉ\=\\u0338𐫶\'\)\ throws\ error\ B5\ B6\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:5577\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}.Ⴉ≠𐫶", %p)},	undef,	"to_ascii\(\'\\u200C\.Ⴉ\≠𐫶\'\)\ throws\ error\ B5\ B6\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:5579\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}.Ⴉ=\x{0338}𐫶", %p)},	undef,	"to_ascii\(\'\\u200C\.Ⴉ\=\\u0338𐫶\'\)\ throws\ error\ B5\ B6\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:5581\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}.ⴉ=\x{0338}𐫶", %p)},	undef,	"to_ascii\(\'\\u200C\.ⴉ\=\\u0338𐫶\'\)\ throws\ error\ B5\ B6\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:5583\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}.ⴉ≠𐫶", %p)},	undef,	"to_ascii\(\'\\u200C\.ⴉ\≠𐫶\'\)\ throws\ error\ B5\ B6\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:5585\]") or ($@ and diag($@));
is(eval{uts46_to_ascii(".xn--1chx23bzj4p", %p)},	undef,	"to_ascii\(\'\.xn\-\-1chx23bzj4p\'\)\ throws\ error\ B5\ B6\ V6\ A4_2\ \[data\/IdnaTest\.txt\:5587\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--0ug.xn--1chx23bzj4p", %p)},	undef,	"to_ascii\(\'xn\-\-0ug\.xn\-\-1chx23bzj4p\'\)\ throws\ error\ B1\ B5\ B6\ C1\ V6\ \[data\/IdnaTest\.txt\:5588\]") or ($@ and diag($@));
is(eval{uts46_to_ascii(".xn--hnd481gv73o", %p)},	undef,	"to_ascii\(\'\.xn\-\-hnd481gv73o\'\)\ throws\ error\ B5\ B6\ V6\ A4_2\ \[data\/IdnaTest\.txt\:5589\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--0ug.xn--hnd481gv73o", %p)},	undef,	"to_ascii\(\'xn\-\-0ug\.xn\-\-hnd481gv73o\'\)\ throws\ error\ B1\ B5\ B6\ C1\ V6\ \[data\/IdnaTest\.txt\:5590\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}．ⴉ=\x{0338}𐫶", %p)},	undef,	"to_ascii\(\'\\u200C．ⴉ\=\\u0338𐫶\'\)\ throws\ error\ B5\ B6\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:5591\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}．ⴉ≠𐫶", %p)},	undef,	"to_ascii\(\'\\u200C．ⴉ\≠𐫶\'\)\ throws\ error\ B5\ B6\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:5593\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0750}。≯ς", %p)},	undef,	"to_ascii\(\'\\u0750\。\≯ς\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:5595\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0750}。>\x{0338}ς", %p)},	undef,	"to_ascii\(\'\\u0750\。\>\\u0338ς\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:5597\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0750}。>\x{0338}Σ", %p)},	undef,	"to_ascii\(\'\\u0750\。\>\\u0338Σ\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:5599\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0750}。≯Σ", %p)},	undef,	"to_ascii\(\'\\u0750\。\≯Σ\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:5600\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0750}。≯σ", %p)},	undef,	"to_ascii\(\'\\u0750\。\≯σ\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:5601\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0750}。>\x{0338}σ", %p)},	undef,	"to_ascii\(\'\\u0750\。\>\\u0338σ\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:5602\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--3ob.xn--4xa718m", %p)},	undef,	"to_ascii\(\'xn\-\-3ob\.xn\-\-4xa718m\'\)\ throws\ error\ B1\ V6\ \[data\/IdnaTest\.txt\:5603\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--3ob.xn--3xa918m", %p)},	undef,	"to_ascii\(\'xn\-\-3ob\.xn\-\-3xa918m\'\)\ throws\ error\ B1\ V6\ \[data\/IdnaTest\.txt\:5604\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{07FC}𐸆.𓖏︒񊨩Ⴐ", %p)},	undef,	"to_ascii\(\'\\u07FC\?\.\?︒\?Ⴐ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:5605\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{07FC}𐸆.𓖏。񊨩Ⴐ", %p)},	undef,	"to_ascii\(\'\\u07FC\?\.\?\。\?Ⴐ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:5606\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{07FC}𐸆.𓖏。񊨩ⴐ", %p)},	undef,	"to_ascii\(\'\\u07FC\?\.\?\。\?ⴐ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:5607\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--0tb8725k.xn--tu8d.xn--7kj73887a", %p)},	undef,	"to_ascii\(\'xn\-\-0tb8725k\.xn\-\-tu8d\.xn\-\-7kj73887a\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:5608\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--0tb8725k.xn--tu8d.xn--ond97931d", %p)},	undef,	"to_ascii\(\'xn\-\-0tb8725k\.xn\-\-tu8d\.xn\-\-ond97931d\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:5609\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{07FC}𐸆.𓖏︒񊨩ⴐ", %p)},	undef,	"to_ascii\(\'\\u07FC\?\.\?︒\?ⴐ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:5610\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--0tb8725k.xn--7kj9008dt18a7py9c", %p)},	undef,	"to_ascii\(\'xn\-\-0tb8725k\.xn\-\-7kj9008dt18a7py9c\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:5611\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--0tb8725k.xn--ond3562jt18a7py9c", %p)},	undef,	"to_ascii\(\'xn\-\-0tb8725k\.xn\-\-ond3562jt18a7py9c\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:5612\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴥ⚭󠖫⋃｡𑌼", %p)},	undef,	"to_ascii\(\'Ⴥ\⚭\?\⋃｡𑌼\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:5613\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴥ⚭󠖫⋃。𑌼", %p)},	undef,	"to_ascii\(\'Ⴥ\⚭\?\⋃\。𑌼\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:5614\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⴥ⚭󠖫⋃。𑌼", %p)},	undef,	"to_ascii\(\'ⴥ\⚭\?\⋃\。𑌼\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:5615\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--vfh16m67gx1162b.xn--ro1d", %p)},	undef,	"to_ascii\(\'xn\-\-vfh16m67gx1162b\.xn\-\-ro1d\'\)\ throws\ error\ V5\ V6\ \[data\/IdnaTest\.txt\:5616\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--9nd623g4zc5z060c.xn--ro1d", %p)},	undef,	"to_ascii\(\'xn\-\-9nd623g4zc5z060c\.xn\-\-ro1d\'\)\ throws\ error\ V5\ V6\ \[data\/IdnaTest\.txt\:5617\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⴥ⚭󠖫⋃｡𑌼", %p)},	undef,	"to_ascii\(\'ⴥ\⚭\?\⋃｡𑌼\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:5618\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("🄈。󠷳\x{0844}", %p)},	undef,	"to_ascii\(\'🄈\。\?\\u0844\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:5619\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("7,。󠷳\x{0844}", %p)},	undef,	"to_ascii\(\'7\,\。\?\\u0844\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:5620\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("7,.xn--2vb13094p", %p)},	undef,	"to_ascii\(\'7\,\.xn\-\-2vb13094p\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:5621\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--107h.xn--2vb13094p", %p)},	undef,	"to_ascii\(\'xn\-\-107h\.xn\-\-2vb13094p\'\)\ throws\ error\ B1\ V6\ \[data\/IdnaTest\.txt\:5622\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≮\x{0846}。섖쮖ß", %p)},	undef,	"to_ascii\(\'\≮\\u0846\。섖쮖ß\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:5623\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("<\x{0338}\x{0846}。섖쮖ß", %p)},	undef,	"to_ascii\(\'\<\\u0338\\u0846\。섖쮖ß\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:5625\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("<\x{0338}\x{0846}。섖쮖SS", %p)},	undef,	"to_ascii\(\'\<\\u0338\\u0846\。섖쮖SS\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:5627\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≮\x{0846}。섖쮖SS", %p)},	undef,	"to_ascii\(\'\≮\\u0846\。섖쮖SS\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:5628\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≮\x{0846}。섖쮖ss", %p)},	undef,	"to_ascii\(\'\≮\\u0846\。섖쮖ss\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:5629\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("<\x{0338}\x{0846}。섖쮖ss", %p)},	undef,	"to_ascii\(\'\<\\u0338\\u0846\。섖쮖ss\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:5630\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("<\x{0338}\x{0846}。섖쮖Ss", %p)},	undef,	"to_ascii\(\'\<\\u0338\\u0846\。섖쮖Ss\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:5631\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("≮\x{0846}。섖쮖Ss", %p)},	undef,	"to_ascii\(\'\≮\\u0846\。섖쮖Ss\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:5632\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--4vb505k.xn--ss-5z4j006a", %p)},	undef,	"to_ascii\(\'xn\-\-4vb505k\.xn\-\-ss\-5z4j006a\'\)\ throws\ error\ B1\ V6\ \[data\/IdnaTest\.txt\:5633\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--4vb505k.xn--zca7259goug", %p)},	undef,	"to_ascii\(\'xn\-\-4vb505k\.xn\-\-zca7259goug\'\)\ throws\ error\ B1\ V6\ \[data\/IdnaTest\.txt\:5634\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("󠆓⛏-。ꡒ", %p)},	undef,	"to_ascii\(\'\󠆓\⛏\-\。ꡒ\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:5635\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn----o9p.xn--rc9a", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-o9p\.xn\-\-rc9a\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:5636\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{07BB}𐹳\x{0626}𑁆。\x{08A7}\x{06B0}\x{200C}ᢒ", %p)},	undef,	"to_ascii\(\'\\u07BB𐹳\\u0626𑁆\。\\u08A7\\u06B0\\u200Cᢒ\'\)\ throws\ error\ B2\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:5637\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{07BB}𐹳\x{064A}𑁆\x{0654}。\x{08A7}\x{06B0}\x{200C}ᢒ", %p)},	undef,	"to_ascii\(\'\\u07BB𐹳\\u064A𑁆\\u0654\。\\u08A7\\u06B0\\u200Cᢒ\'\)\ throws\ error\ B2\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:5639\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--lgb32f2753cosb.xn--jkb91hlz1a", %p)},	undef,	"to_ascii\(\'xn\-\-lgb32f2753cosb\.xn\-\-jkb91hlz1a\'\)\ throws\ error\ B2\ B3\ V6\ \[data\/IdnaTest\.txt\:5641\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--lgb32f2753cosb.xn--jkb91hlz1azih", %p)},	undef,	"to_ascii\(\'xn\-\-lgb32f2753cosb\.xn\-\-jkb91hlz1azih\'\)\ throws\ error\ B2\ B3\ V6\ \[data\/IdnaTest\.txt\:5642\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0816}.𐨕𚚕", %p)},	undef,	"to_ascii\(\'\\u0816\.𐨕\?\'\)\ throws\ error\ B1\ B2\ B3\ B6\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:5643\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--rub.xn--tr9c248x", %p)},	undef,	"to_ascii\(\'xn\-\-rub\.xn\-\-tr9c248x\'\)\ throws\ error\ B1\ B2\ B3\ B6\ V5\ V6\ \[data\/IdnaTest\.txt\:5644\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("--。𽊆\x{0767}𐽋𞠬", %p)},	undef,	"to_ascii\(\'\-\-\。\?\\u0767𐽋𞠬\'\)\ throws\ error\ B1\ B5\ B6\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:5645\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("--.xn--rpb6226k77pfh58p", %p)},	undef,	"to_ascii\(\'\-\-\.xn\-\-rpb6226k77pfh58p\'\)\ throws\ error\ B1\ B5\ B6\ V3\ V6\ \[data\/IdnaTest\.txt\:5646\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򛭦𐋥𹸐.≯\x{08B0}\x{08A6}󔛣", %p)},	undef,	"to_ascii\(\'\?𐋥\?\.\≯\\u08B0\\u08A6\?\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:5647\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򛭦𐋥𹸐.>\x{0338}\x{08B0}\x{08A6}󔛣", %p)},	undef,	"to_ascii\(\'\?𐋥\?\.\>\\u0338\\u08B0\\u08A6\?\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:5648\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--887c2298i5mv6a.xn--vybt688qm8981a", %p)},	undef,	"to_ascii\(\'xn\-\-887c2298i5mv6a\.xn\-\-vybt688qm8981a\'\)\ throws\ error\ B1\ V6\ \[data\/IdnaTest\.txt\:5649\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("䔛󠇒򤸞𐹧．-䤷", %p)},	undef,	"to_ascii\(\'䔛\󠇒\?𐹧．\-䤷\'\)\ throws\ error\ B1\ B5\ B6\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:5650\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("䔛󠇒򤸞𐹧.-䤷", %p)},	undef,	"to_ascii\(\'䔛\󠇒\?𐹧\.\-䤷\'\)\ throws\ error\ B1\ B5\ B6\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:5651\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--2loy662coo60e.xn----0n4a", %p)},	undef,	"to_ascii\(\'xn\-\-2loy662coo60e\.xn\-\-\-\-0n4a\'\)\ throws\ error\ B1\ B5\ B6\ V3\ V6\ \[data\/IdnaTest\.txt\:5652\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("𐹩．\x{200D}-", %p)},	undef,	"to_ascii\(\'𐹩．\\u200D\-\'\)\ throws\ error\ B1\ V3\ \[data\/IdnaTest\.txt\:5653\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("𐹩.\x{200D}-", %p)},	undef,	"to_ascii\(\'𐹩\.\\u200D\-\'\)\ throws\ error\ B1\ V3\ \[data\/IdnaTest\.txt\:5655\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--ho0d.-", %p)},	undef,	"to_ascii\(\'xn\-\-ho0d\.\-\'\)\ throws\ error\ B1\ V3\ \[data\/IdnaTest\.txt\:5657\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--ho0d.xn----tgn", %p)},	undef,	"to_ascii\(\'xn\-\-ho0d\.xn\-\-\-\-tgn\'\)\ throws\ error\ B1\ C2\ V3\ \[data\/IdnaTest\.txt\:5658\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񂈦帷｡≯萺\x{1DC8}-", %p)},	undef,	"to_ascii\(\'\?帷｡\≯萺\\u1DC8\-\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:5659\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񂈦帷｡>\x{0338}萺\x{1DC8}-", %p)},	undef,	"to_ascii\(\'\?帷｡\>\\u0338萺\\u1DC8\-\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:5660\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񂈦帷。≯萺\x{1DC8}-", %p)},	undef,	"to_ascii\(\'\?帷\。\≯萺\\u1DC8\-\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:5661\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񂈦帷。>\x{0338}萺\x{1DC8}-", %p)},	undef,	"to_ascii\(\'\?帷\。\>\\u0338萺\\u1DC8\-\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:5662\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--qutw175s.xn----mimu6tf67j", %p)},	undef,	"to_ascii\(\'xn\-\-qutw175s\.xn\-\-\-\-mimu6tf67j\'\)\ throws\ error\ V3\ V6\ \[data\/IdnaTest\.txt\:5663\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}攌\x{ABED}。ᢖ-Ⴘ", %p)},	undef,	"to_ascii\(\'\\u200D攌\\uABED\。ᢖ\-Ⴘ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:5664\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("\x{200D}攌\x{ABED}。ᢖ-ⴘ", %p)},	"xn--p9ut19m.xn----mck373i",	"to_ascii\(\'\\u200D攌\\uABED\。ᢖ\-ⴘ\'\)\ \[data\/IdnaTest\.txt\:5666\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("xn--p9ut19m.xn----mck373i", %p)},	"xn--p9ut19m.xn----mck373i",	"to_ascii\(\'xn\-\-p9ut19m\.xn\-\-\-\-mck373i\'\)\ \[data\/IdnaTest\.txt\:5668\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("攌\x{ABED}.ᢖ-ⴘ", %p)},	"xn--p9ut19m.xn----mck373i",	"to_ascii\(\'攌\\uABED\.ᢖ\-ⴘ\'\)\ \[data\/IdnaTest\.txt\:5669\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("攌\x{ABED}.ᢖ-Ⴘ", %p)},	undef,	"to_ascii\(\'攌\\uABED\.ᢖ\-Ⴘ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:5670\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--p9ut19m.xn----k1g451d", %p)},	undef,	"to_ascii\(\'xn\-\-p9ut19m\.xn\-\-\-\-k1g451d\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:5671\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--1ug592ykp6b.xn----mck373i", %p)},	undef,	"to_ascii\(\'xn\-\-1ug592ykp6b\.xn\-\-\-\-mck373i\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:5672\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--1ug592ykp6b.xn----k1g451d", %p)},	undef,	"to_ascii\(\'xn\-\-1ug592ykp6b\.xn\-\-\-\-k1g451d\'\)\ throws\ error\ C2\ V6\ \[data\/IdnaTest\.txt\:5673\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}ꖨ．⒗３툒۳", %p)},	undef,	"to_ascii\(\'\\u200Cꖨ．⒗３툒۳\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:5674\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}ꖨ．⒗３툒۳", %p)},	undef,	"to_ascii\(\'\\u200Cꖨ．⒗３툒۳\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:5676\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_ascii("\x{200C}ꖨ.16.3툒۳", %p)},	"xn--9r8a.16.xn--3-nyc0117m",	"to_ascii\(\'\\u200Cꖨ\.16\.3툒۳\'\)\ \[data\/IdnaTest\.txt\:5678\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_ascii("\x{200C}ꖨ.16.3툒۳", %p)},	"xn--9r8a.16.xn--3-nyc0117m",	"to_ascii\(\'\\u200Cꖨ\.16\.3툒۳\'\)\ \[data\/IdnaTest\.txt\:5680\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_ascii("xn--9r8a.16.xn--3-nyc0117m", %p)},	"xn--9r8a.16.xn--3-nyc0117m",	"to_ascii\(\'xn\-\-9r8a\.16\.xn\-\-3\-nyc0117m\'\)\ \[data\/IdnaTest\.txt\:5682\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_ascii("ꖨ.16.3툒۳", %p)},	"xn--9r8a.16.xn--3-nyc0117m",	"to_ascii\(\'ꖨ\.16\.3툒۳\'\)\ \[data\/IdnaTest\.txt\:5683\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_ascii("ꖨ.16.3툒۳", %p)},	"xn--9r8a.16.xn--3-nyc0117m",	"to_ascii\(\'ꖨ\.16\.3툒۳\'\)\ \[data\/IdnaTest\.txt\:5684\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--0ug2473c.16.xn--3-nyc0117m", %p)},	undef,	"to_ascii\(\'xn\-\-0ug2473c\.16\.xn\-\-3\-nyc0117m\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:5685\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--9r8a.xn--3-nyc678tu07m", %p)},	undef,	"to_ascii\(\'xn\-\-9r8a\.xn\-\-3\-nyc678tu07m\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:5686\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--0ug2473c.xn--3-nyc678tu07m", %p)},	undef,	"to_ascii\(\'xn\-\-0ug2473c\.xn\-\-3\-nyc678tu07m\'\)\ throws\ error\ C1\ V6\ \[data\/IdnaTest\.txt\:5687\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⒈걾6.𐱁\x{06D0}", %p)},	undef,	"to_ascii\(\'⒈걾6\.𐱁\\u06D0\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:5688\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⒈걾6.𐱁\x{06D0}", %p)},	undef,	"to_ascii\(\'⒈걾6\.𐱁\\u06D0\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:5689\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("1.걾6.𐱁\x{06D0}", %p)},	undef,	"to_ascii\(\'1\.걾6\.𐱁\\u06D0\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:5690\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("1.걾6.𐱁\x{06D0}", %p)},	undef,	"to_ascii\(\'1\.걾6\.𐱁\\u06D0\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:5691\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("1.xn--6-945e.xn--glb1794k", %p)},	undef,	"to_ascii\(\'1\.xn\-\-6\-945e\.xn\-\-glb1794k\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:5692\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--6-dcps419c.xn--glb1794k", %p)},	undef,	"to_ascii\(\'xn\-\-6\-dcps419c\.xn\-\-glb1794k\'\)\ throws\ error\ B1\ V6\ \[data\/IdnaTest\.txt\:5693\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐲞𝟶≮≮.󠀧\x{0639}", %p)},	undef,	"to_ascii\(\'𐲞𝟶\≮\≮\.\?\\u0639\'\)\ throws\ error\ B1\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:5694\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐲞𝟶<\x{0338}<\x{0338}.󠀧\x{0639}", %p)},	undef,	"to_ascii\(\'𐲞𝟶\<\\u0338\<\\u0338\.\?\\u0639\'\)\ throws\ error\ B1\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:5695\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐲞0≮≮.󠀧\x{0639}", %p)},	undef,	"to_ascii\(\'𐲞0\≮\≮\.\?\\u0639\'\)\ throws\ error\ B1\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:5696\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐲞0<\x{0338}<\x{0338}.󠀧\x{0639}", %p)},	undef,	"to_ascii\(\'𐲞0\<\\u0338\<\\u0338\.\?\\u0639\'\)\ throws\ error\ B1\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:5697\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐳞0<\x{0338}<\x{0338}.󠀧\x{0639}", %p)},	undef,	"to_ascii\(\'𐳞0\<\\u0338\<\\u0338\.\?\\u0639\'\)\ throws\ error\ B1\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:5698\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐳞0≮≮.󠀧\x{0639}", %p)},	undef,	"to_ascii\(\'𐳞0\≮\≮\.\?\\u0639\'\)\ throws\ error\ B1\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:5699\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--0-ngoa5711v.xn--4gb31034p", %p)},	undef,	"to_ascii\(\'xn\-\-0\-ngoa5711v\.xn\-\-4gb31034p\'\)\ throws\ error\ B1\ B3\ V6\ \[data\/IdnaTest\.txt\:5700\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐳞𝟶<\x{0338}<\x{0338}.󠀧\x{0639}", %p)},	undef,	"to_ascii\(\'𐳞𝟶\<\\u0338\<\\u0338\.\?\\u0639\'\)\ throws\ error\ B1\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:5701\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐳞𝟶≮≮.󠀧\x{0639}", %p)},	undef,	"to_ascii\(\'𐳞𝟶\≮\≮\.\?\\u0639\'\)\ throws\ error\ B1\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:5702\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0AE3}.𐹺\x{115F}", %p)},	undef,	"to_ascii\(\'\\u0AE3\.𐹺\\u115F\'\)\ throws\ error\ B1\ B3\ B6\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:5703\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--8fc.xn--osd3070k", %p)},	undef,	"to_ascii\(\'xn\-\-8fc\.xn\-\-osd3070k\'\)\ throws\ error\ B1\ B3\ B6\ V5\ V6\ \[data\/IdnaTest\.txt\:5704\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_ascii("𝟏𝨙⸖.\x{200D}", %p)},	"xn--1-5bt6845n.",	"to_ascii\(\'𝟏𝨙\⸖\.\\u200D\'\)\ \[data\/IdnaTest\.txt\:5705\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_ascii("1𝨙⸖.\x{200D}", %p)},	"xn--1-5bt6845n.",	"to_ascii\(\'1𝨙\⸖\.\\u200D\'\)\ \[data\/IdnaTest\.txt\:5707\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_ascii("xn--1-5bt6845n.", %p)},	"xn--1-5bt6845n.",	"to_ascii\(\'xn\-\-1\-5bt6845n\.\'\)\ \[data\/IdnaTest\.txt\:5709\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_ascii("1𝨙⸖.", %p)},	"xn--1-5bt6845n.",	"to_ascii\(\'1𝨙\⸖\.\'\)\ \[data\/IdnaTest\.txt\:5710\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--1-5bt6845n.xn--1ug", %p)},	undef,	"to_ascii\(\'xn\-\-1\-5bt6845n\.xn\-\-1ug\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:5711\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𞤐≠\x{0726}\x{1A60}｡-\x{200C}\x{07D5}", %p)},	undef,	"to_ascii\(\'𞤐\≠\\u0726\\u1A60｡\-\\u200C\\u07D5\'\)\ throws\ error\ B1\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:5712\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𞤐=\x{0338}\x{0726}\x{1A60}｡-\x{200C}\x{07D5}", %p)},	undef,	"to_ascii\(\'𞤐\=\\u0338\\u0726\\u1A60｡\-\\u200C\\u07D5\'\)\ throws\ error\ B1\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:5714\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𞤐≠\x{0726}\x{1A60}。-\x{200C}\x{07D5}", %p)},	undef,	"to_ascii\(\'𞤐\≠\\u0726\\u1A60\。\-\\u200C\\u07D5\'\)\ throws\ error\ B1\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:5716\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𞤐=\x{0338}\x{0726}\x{1A60}。-\x{200C}\x{07D5}", %p)},	undef,	"to_ascii\(\'𞤐\=\\u0338\\u0726\\u1A60\。\-\\u200C\\u07D5\'\)\ throws\ error\ B1\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:5718\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𞤲=\x{0338}\x{0726}\x{1A60}。-\x{200C}\x{07D5}", %p)},	undef,	"to_ascii\(\'𞤲\=\\u0338\\u0726\\u1A60\。\-\\u200C\\u07D5\'\)\ throws\ error\ B1\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:5720\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𞤲≠\x{0726}\x{1A60}。-\x{200C}\x{07D5}", %p)},	undef,	"to_ascii\(\'𞤲\≠\\u0726\\u1A60\。\-\\u200C\\u07D5\'\)\ throws\ error\ B1\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:5722\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--wnb859grzfzw60c.xn----kcd", %p)},	undef,	"to_ascii\(\'xn\-\-wnb859grzfzw60c\.xn\-\-\-\-kcd\'\)\ throws\ error\ B1\ V3\ V6\ \[data\/IdnaTest\.txt\:5724\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--wnb859grzfzw60c.xn----kcd017p", %p)},	undef,	"to_ascii\(\'xn\-\-wnb859grzfzw60c\.xn\-\-\-\-kcd017p\'\)\ throws\ error\ B1\ C1\ V3\ V6\ \[data\/IdnaTest\.txt\:5725\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𞤲=\x{0338}\x{0726}\x{1A60}｡-\x{200C}\x{07D5}", %p)},	undef,	"to_ascii\(\'𞤲\=\\u0338\\u0726\\u1A60｡\-\\u200C\\u07D5\'\)\ throws\ error\ B1\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:5726\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𞤲≠\x{0726}\x{1A60}｡-\x{200C}\x{07D5}", %p)},	undef,	"to_ascii\(\'𞤲\≠\\u0726\\u1A60｡\-\\u200C\\u07D5\'\)\ throws\ error\ B1\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:5728\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("𐹰\x{0368}-ꡧ｡\x{0675}", %p)},	undef,	"to_ascii\(\'𐹰\\u0368\-ꡧ｡\\u0675\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:5730\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("𐹰\x{0368}-ꡧ。\x{0627}\x{0674}", %p)},	undef,	"to_ascii\(\'𐹰\\u0368\-ꡧ\。\\u0627\\u0674\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:5731\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn----shb2387jgkqd.xn--mgb8m", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-shb2387jgkqd\.xn\-\-mgb8m\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:5732\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("F󠅟｡򏗅♚", %p)},	undef,	"to_ascii\(\'F\󠅟｡\?\♚\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:5733\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("F󠅟。򏗅♚", %p)},	undef,	"to_ascii\(\'F\󠅟\。\?\♚\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:5734\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("f󠅟。򏗅♚", %p)},	undef,	"to_ascii\(\'f\󠅟\。\?\♚\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:5735\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("f.xn--45hz6953f", %p)},	undef,	"to_ascii\(\'f\.xn\-\-45hz6953f\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:5736\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("f󠅟｡򏗅♚", %p)},	undef,	"to_ascii\(\'f\󠅟｡\?\♚\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:5737\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0B4D}𑄴\x{1DE9}。𝟮Ⴘ𞀨񃥇", %p)},	undef,	"to_ascii\(\'\\u0B4D𑄴\\u1DE9\。𝟮Ⴘ𞀨\?\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:5738\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0B4D}𑄴\x{1DE9}。2Ⴘ𞀨񃥇", %p)},	undef,	"to_ascii\(\'\\u0B4D𑄴\\u1DE9\。2Ⴘ𞀨\?\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:5739\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0B4D}𑄴\x{1DE9}。2ⴘ𞀨񃥇", %p)},	undef,	"to_ascii\(\'\\u0B4D𑄴\\u1DE9\。2ⴘ𞀨\?\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:5740\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--9ic246gs21p.xn--2-nws2918ndrjr", %p)},	undef,	"to_ascii\(\'xn\-\-9ic246gs21p\.xn\-\-2\-nws2918ndrjr\'\)\ throws\ error\ V5\ V6\ \[data\/IdnaTest\.txt\:5741\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--9ic246gs21p.xn--2-k1g43076adrwq", %p)},	undef,	"to_ascii\(\'xn\-\-9ic246gs21p\.xn\-\-2\-k1g43076adrwq\'\)\ throws\ error\ V5\ V6\ \[data\/IdnaTest\.txt\:5742\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0B4D}𑄴\x{1DE9}。𝟮ⴘ𞀨񃥇", %p)},	undef,	"to_ascii\(\'\\u0B4D𑄴\\u1DE9\。𝟮ⴘ𞀨\?\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:5743\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򓠭\x{200C}\x{200C}⒈。勉𑁅", %p)},	undef,	"to_ascii\(\'\?\\u200C\\u200C⒈\。勉𑁅\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:5744\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򓠭\x{200C}\x{200C}1.。勉𑁅", %p)},	undef,	"to_ascii\(\'\?\\u200C\\u200C1\.\。勉𑁅\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:5746\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--1-yi00h..xn--4grs325b", %p)},	undef,	"to_ascii\(\'xn\-\-1\-yi00h\.\.xn\-\-4grs325b\'\)\ throws\ error\ V6\ A4_2\ \[data\/IdnaTest\.txt\:5748\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--1-rgna61159u..xn--4grs325b", %p)},	undef,	"to_ascii\(\'xn\-\-1\-rgna61159u\.\.xn\-\-4grs325b\'\)\ throws\ error\ C1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:5749\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--tsh11906f.xn--4grs325b", %p)},	undef,	"to_ascii\(\'xn\-\-tsh11906f\.xn\-\-4grs325b\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:5750\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--0uga855aez302a.xn--4grs325b", %p)},	undef,	"to_ascii\(\'xn\-\-0uga855aez302a\.xn\-\-4grs325b\'\)\ throws\ error\ C1\ V6\ \[data\/IdnaTest\.txt\:5751\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᡃ.玿񫈜󕞐", %p)},	undef,	"to_ascii\(\'ᡃ\.玿\?\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:5752\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--27e.xn--7cy81125a0yq4a", %p)},	undef,	"to_ascii\(\'xn\-\-27e\.xn\-\-7cy81125a0yq4a\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:5753\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}\x{200C}｡⒈≯𝟵", %p)},	undef,	"to_ascii\(\'\\u200C\\u200C｡⒈\≯𝟵\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:5754\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}\x{200C}｡⒈>\x{0338}𝟵", %p)},	undef,	"to_ascii\(\'\\u200C\\u200C｡⒈\>\\u0338𝟵\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:5756\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}\x{200C}。1.≯9", %p)},	undef,	"to_ascii\(\'\\u200C\\u200C\。1\.\≯9\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:5758\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}\x{200C}。1.>\x{0338}9", %p)},	undef,	"to_ascii\(\'\\u200C\\u200C\。1\.\>\\u03389\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:5760\]") or ($@ and diag($@));
is(eval{uts46_to_ascii(".1.xn--9-ogo", %p)},	undef,	"to_ascii\(\'\.1\.xn\-\-9\-ogo\'\)\ throws\ error\ V6\ A4_2\ \[data\/IdnaTest\.txt\:5762\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--0uga.1.xn--9-ogo", %p)},	undef,	"to_ascii\(\'xn\-\-0uga\.1\.xn\-\-9\-ogo\'\)\ throws\ error\ C1\ V6\ \[data\/IdnaTest\.txt\:5763\]") or ($@ and diag($@));
is(eval{uts46_to_ascii(".xn--9-ogo37g", %p)},	undef,	"to_ascii\(\'\.xn\-\-9\-ogo37g\'\)\ throws\ error\ V6\ A4_2\ \[data\/IdnaTest\.txt\:5764\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--0uga.xn--9-ogo37g", %p)},	undef,	"to_ascii\(\'xn\-\-0uga\.xn\-\-9\-ogo37g\'\)\ throws\ error\ C1\ V6\ \[data\/IdnaTest\.txt\:5765\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{115F}\x{1DE0}򐀁.𺻆≯𐮁", %p)},	undef,	"to_ascii\(\'\\u115F\\u1DE0\?\.\?\≯𐮁\'\)\ throws\ error\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:5766\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{115F}\x{1DE0}򐀁.𺻆>\x{0338}𐮁", %p)},	undef,	"to_ascii\(\'\\u115F\\u1DE0\?\.\?\>\\u0338𐮁\'\)\ throws\ error\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:5767\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--osd615d5659o.xn--hdh5192gkm6r", %p)},	undef,	"to_ascii\(\'xn\-\-osd615d5659o\.xn\-\-hdh5192gkm6r\'\)\ throws\ error\ B5\ B6\ V6\ \[data\/IdnaTest\.txt\:5768\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠄫𝩤\x{200D}\x{063E}.𝩩-\x{081E}󑼩", %p)},	undef,	"to_ascii\(\'\󠄫𝩤\\u200D\\u063E\.𝩩\-\\u081E\?\'\)\ throws\ error\ B1\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:5769\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--9gb5080v.xn----qgd52296avol4f", %p)},	undef,	"to_ascii\(\'xn\-\-9gb5080v\.xn\-\-\-\-qgd52296avol4f\'\)\ throws\ error\ B1\ V5\ V6\ \[data\/IdnaTest\.txt\:5771\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--9gb723kg862a.xn----qgd52296avol4f", %p)},	undef,	"to_ascii\(\'xn\-\-9gb723kg862a\.xn\-\-\-\-qgd52296avol4f\'\)\ throws\ error\ B1\ C2\ V5\ V6\ \[data\/IdnaTest\.txt\:5772\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("\x{20DA}．𑘿-", %p)},	undef,	"to_ascii\(\'\\u20DA．𑘿\-\'\)\ throws\ error\ V3\ V5\ \[data\/IdnaTest\.txt\:5773\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("\x{20DA}.𑘿-", %p)},	undef,	"to_ascii\(\'\\u20DA\.𑘿\-\'\)\ throws\ error\ V3\ V5\ \[data\/IdnaTest\.txt\:5774\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--w0g.xn----bd0j", %p)},	undef,	"to_ascii\(\'xn\-\-w0g\.xn\-\-\-\-bd0j\'\)\ throws\ error\ V3\ V5\ \[data\/IdnaTest\.txt\:5775\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("䮸ß.󠵟󠭎紙\x{08A8}", %p)},	undef,	"to_ascii\(\'䮸ß\.\?\?紙\\u08A8\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:5776\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("䮸SS.󠵟󠭎紙\x{08A8}", %p)},	undef,	"to_ascii\(\'䮸SS\.\?\?紙\\u08A8\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:5778\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("䮸ss.󠵟󠭎紙\x{08A8}", %p)},	undef,	"to_ascii\(\'䮸ss\.\?\?紙\\u08A8\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:5779\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("䮸Ss.󠵟󠭎紙\x{08A8}", %p)},	undef,	"to_ascii\(\'䮸Ss\.\?\?紙\\u08A8\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:5780\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--ss-sf1c.xn--xyb1370div70kpzba", %p)},	undef,	"to_ascii\(\'xn\-\-ss\-sf1c\.xn\-\-xyb1370div70kpzba\'\)\ throws\ error\ B1\ V6\ \[data\/IdnaTest\.txt\:5781\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--zca5349a.xn--xyb1370div70kpzba", %p)},	undef,	"to_ascii\(\'xn\-\-zca5349a\.xn\-\-xyb1370div70kpzba\'\)\ throws\ error\ B1\ V6\ \[data\/IdnaTest\.txt\:5782\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-Ⴞ.-𝩨⅔𐦕", %p)},	undef,	"to_ascii\(\'\-Ⴞ\.\-𝩨⅔𐦕\'\)\ throws\ error\ B1\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:5783\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-Ⴞ.-𝩨2⁄3𐦕", %p)},	undef,	"to_ascii\(\'\-Ⴞ\.\-𝩨2\⁄3𐦕\'\)\ throws\ error\ B1\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:5784\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_ascii("-ⴞ.-𝩨2⁄3𐦕", %p)},	undef,	"to_ascii\(\'\-ⴞ\.\-𝩨2\⁄3𐦕\'\)\ throws\ error\ B1\ V3\ \[data\/IdnaTest\.txt\:5785\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn----zws.xn---23-pt0a0433lk3jj", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-zws\.xn\-\-\-23\-pt0a0433lk3jj\'\)\ throws\ error\ B1\ V3\ \[data\/IdnaTest\.txt\:5786\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----w1g.xn---23-pt0a0433lk3jj", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-w1g\.xn\-\-\-23\-pt0a0433lk3jj\'\)\ throws\ error\ B1\ V3\ V6\ \[data\/IdnaTest\.txt\:5787\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v8.0 (perl v5.24.0) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v8.0; is(eval{uts46_to_ascii("-ⴞ.-𝩨⅔𐦕", %p)},	undef,	"to_ascii\(\'\-ⴞ\.\-𝩨⅔𐦕\'\)\ throws\ error\ B1\ V3\ \[data\/IdnaTest\.txt\:5788\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("󧈯𐹯\x{0AC2}｡򖢨𐮁񇼖ᡂ", %p)},	undef,	"to_ascii\(\'\?𐹯\\u0AC2｡\?𐮁\?ᡂ\'\)\ throws\ error\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:5789\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󧈯𐹯\x{0AC2}。򖢨𐮁񇼖ᡂ", %p)},	undef,	"to_ascii\(\'\?𐹯\\u0AC2\。\?𐮁\?ᡂ\'\)\ throws\ error\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:5790\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--bfc7604kv8m3g.xn--17e5565jl7zw4h16a", %p)},	undef,	"to_ascii\(\'xn\-\-bfc7604kv8m3g\.xn\-\-17e5565jl7zw4h16a\'\)\ throws\ error\ B5\ B6\ V6\ \[data\/IdnaTest\.txt\:5791\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1082}-\x{200D}\x{A8EA}．ꡊ\x{200D}񼸳", %p)},	undef,	"to_ascii\(\'\\u1082\-\\u200D\\uA8EA．ꡊ\\u200D\?\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:5792\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{1082}-\x{200D}\x{A8EA}.ꡊ\x{200D}񼸳", %p)},	undef,	"to_ascii\(\'\\u1082\-\\u200D\\uA8EA\.ꡊ\\u200D\?\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:5794\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----gyg3618i.xn--jc9ao4185a", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-gyg3618i\.xn\-\-jc9ao4185a\'\)\ throws\ error\ V5\ V6\ \[data\/IdnaTest\.txt\:5796\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----gyg250jio7k.xn--1ug8774cri56d", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-gyg250jio7k\.xn\-\-1ug8774cri56d\'\)\ throws\ error\ C2\ V5\ V6\ \[data\/IdnaTest\.txt\:5797\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("۱。≠\x{0668}", %p)},	undef,	"to_ascii\(\'۱\。\≠\\u0668\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:5798\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("۱。=\x{0338}\x{0668}", %p)},	undef,	"to_ascii\(\'۱\。\=\\u0338\\u0668\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:5799\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--emb.xn--hib334l", %p)},	undef,	"to_ascii\(\'xn\-\-emb\.xn\-\-hib334l\'\)\ throws\ error\ B1\ V6\ \[data\/IdnaTest\.txt\:5800\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("𑈵廊.𐠍", %p)},	undef,	"to_ascii\(\'𑈵廊\.𐠍\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:5801\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--xytw701b.xn--yc9c", %p)},	undef,	"to_ascii\(\'xn\-\-xytw701b\.xn\-\-yc9c\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:5802\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}\x{0356}-．-Ⴐ\x{0661}", %p)},	undef,	"to_ascii\(\'\\u200D\\u0356\-．\-Ⴐ\\u0661\'\)\ throws\ error\ B1\ P1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:5803\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}\x{0356}-.-Ⴐ\x{0661}", %p)},	undef,	"to_ascii\(\'\\u200D\\u0356\-\.\-Ⴐ\\u0661\'\)\ throws\ error\ B1\ P1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:5805\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("\x{200D}\x{0356}-.-ⴐ\x{0661}", %p)},	undef,	"to_ascii\(\'\\u200D\\u0356\-\.\-ⴐ\\u0661\'\)\ throws\ error\ B1\ V3\ V5\ \[data\/IdnaTest\.txt\:5807\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn----rgb.xn----bqc2280a", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-rgb\.xn\-\-\-\-bqc2280a\'\)\ throws\ error\ B1\ V3\ V5\ \[data\/IdnaTest\.txt\:5809\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----rgb661t.xn----bqc2280a", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-rgb661t\.xn\-\-\-\-bqc2280a\'\)\ throws\ error\ B1\ C2\ V3\ \[data\/IdnaTest\.txt\:5810\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----rgb.xn----bqc030f", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-rgb\.xn\-\-\-\-bqc030f\'\)\ throws\ error\ B1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:5811\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----rgb661t.xn----bqc030f", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-rgb661t\.xn\-\-\-\-bqc030f\'\)\ throws\ error\ B1\ C2\ V3\ V6\ \[data\/IdnaTest\.txt\:5812\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_ascii("\x{200D}\x{0356}-．-ⴐ\x{0661}", %p)},	undef,	"to_ascii\(\'\\u200D\\u0356\-．\-ⴐ\\u0661\'\)\ throws\ error\ B1\ V3\ V5\ \[data\/IdnaTest\.txt\:5813\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("\x{063A}\x{0661}挏󾯐.-", %p)},	undef,	"to_ascii\(\'\\u063A\\u0661挏\?\.\-\'\)\ throws\ error\ B1\ B2\ B3\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:5815\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--5gb2f4205aqi47p.-", %p)},	undef,	"to_ascii\(\'xn\-\-5gb2f4205aqi47p\.\-\'\)\ throws\ error\ B1\ B2\ B3\ V3\ V6\ \[data\/IdnaTest\.txt\:5816\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("\x{06EF}｡𐹧𞤽", %p)},	undef,	"to_ascii\(\'\\u06EF｡𐹧𞤽\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:5817\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("\x{06EF}。𐹧𞤽", %p)},	undef,	"to_ascii\(\'\\u06EF\。𐹧𞤽\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:5818\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("\x{06EF}。𐹧𞤛", %p)},	undef,	"to_ascii\(\'\\u06EF\。𐹧𞤛\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:5819\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--cmb.xn--fo0dy848a", %p)},	undef,	"to_ascii\(\'xn\-\-cmb\.xn\-\-fo0dy848a\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:5820\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("\x{06EF}｡𐹧𞤛", %p)},	undef,	"to_ascii\(\'\\u06EF｡𐹧𞤛\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:5821\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("Ⴞ𶛀𛗻．ᢗ릫", %p)},	undef,	"to_ascii\(\'Ⴞ\?\?．ᢗ릫\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:5822\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴞ𶛀𛗻．ᢗ릫", %p)},	undef,	"to_ascii\(\'Ⴞ\?\?．ᢗ릫\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:5823\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴞ𶛀𛗻.ᢗ릫", %p)},	undef,	"to_ascii\(\'Ⴞ\?\?\.ᢗ릫\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:5824\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ⴞ𶛀𛗻.ᢗ릫", %p)},	undef,	"to_ascii\(\'Ⴞ\?\?\.ᢗ릫\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:5825\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⴞ𶛀𛗻.ᢗ릫", %p)},	undef,	"to_ascii\(\'ⴞ\?\?\.ᢗ릫\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:5826\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⴞ𶛀𛗻.ᢗ릫", %p)},	undef,	"to_ascii\(\'ⴞ\?\?\.ᢗ릫\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:5827\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--mlj0486jgl2j.xn--hbf6853f", %p)},	undef,	"to_ascii\(\'xn\-\-mlj0486jgl2j\.xn\-\-hbf6853f\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:5828\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--2nd8876sgl2j.xn--hbf6853f", %p)},	undef,	"to_ascii\(\'xn\-\-2nd8876sgl2j\.xn\-\-hbf6853f\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:5829\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⴞ𶛀𛗻．ᢗ릫", %p)},	undef,	"to_ascii\(\'ⴞ\?\?．ᢗ릫\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:5830\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ⴞ𶛀𛗻．ᢗ릫", %p)},	undef,	"to_ascii\(\'ⴞ\?\?．ᢗ릫\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:5831\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠎃󗭞\x{06B7}𐹷｡≯\x{200C}\x{1DFE}", %p)},	undef,	"to_ascii\(\'\?\?\\u06B7𐹷｡\≯\\u200C\\u1DFE\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:5832\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠎃󗭞\x{06B7}𐹷｡>\x{0338}\x{200C}\x{1DFE}", %p)},	undef,	"to_ascii\(\'\?\?\\u06B7𐹷｡\>\\u0338\\u200C\\u1DFE\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:5834\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠎃󗭞\x{06B7}𐹷。≯\x{200C}\x{1DFE}", %p)},	undef,	"to_ascii\(\'\?\?\\u06B7𐹷\。\≯\\u200C\\u1DFE\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:5836\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󠎃󗭞\x{06B7}𐹷。>\x{0338}\x{200C}\x{1DFE}", %p)},	undef,	"to_ascii\(\'\?\?\\u06B7𐹷\。\>\\u0338\\u200C\\u1DFE\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:5838\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--qkb4516kbi06fg2id.xn--zfg31q", %p)},	undef,	"to_ascii\(\'xn\-\-qkb4516kbi06fg2id\.xn\-\-zfg31q\'\)\ throws\ error\ B1\ V6\ \[data\/IdnaTest\.txt\:5840\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--qkb4516kbi06fg2id.xn--zfg59fm0c", %p)},	undef,	"to_ascii\(\'xn\-\-qkb4516kbi06fg2id\.xn\-\-zfg59fm0c\'\)\ throws\ error\ B1\ C1\ V6\ \[data\/IdnaTest\.txt\:5841\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᛎ󠅍󠐕\x{200D}｡𐹾𐹪𐻝-", %p)},	undef,	"to_ascii\(\'ᛎ\󠅍\?\\u200D｡𐹾𐹪\?\-\'\)\ throws\ error\ B1\ B6\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:5842\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᛎ󠅍󠐕\x{200D}。𐹾𐹪𐻝-", %p)},	undef,	"to_ascii\(\'ᛎ\󠅍\?\\u200D\。𐹾𐹪\?\-\'\)\ throws\ error\ B1\ B6\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:5844\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--fxe63563p.xn----q26i2bvu", %p)},	undef,	"to_ascii\(\'xn\-\-fxe63563p\.xn\-\-\-\-q26i2bvu\'\)\ throws\ error\ B1\ B6\ V3\ V6\ \[data\/IdnaTest\.txt\:5846\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--fxe848bq3411a.xn----q26i2bvu", %p)},	undef,	"to_ascii\(\'xn\-\-fxe848bq3411a\.xn\-\-\-\-q26i2bvu\'\)\ throws\ error\ B1\ B6\ C2\ V3\ V6\ \[data\/IdnaTest\.txt\:5847\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("𐹶.𐫂", %p)},	undef,	"to_ascii\(\'𐹶\.𐫂\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:5848\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--uo0d.xn--rw9c", %p)},	undef,	"to_ascii\(\'xn\-\-uo0d\.xn\-\-rw9c\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:5849\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ß\x{200D}\x{103A}｡⒈", %p)},	undef,	"to_ascii\(\'ß\\u200D\\u103A｡⒈\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:5850\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_ascii("ß\x{200D}\x{103A}。1.", %p)},	"xn--ss-f4j.1.",	"to_ascii\(\'ß\\u200D\\u103A\。1\.\'\)\ \[data\/IdnaTest\.txt\:5852\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_ascii("SS\x{200D}\x{103A}。1.", %p)},	"xn--ss-f4j.1.",	"to_ascii\(\'SS\\u200D\\u103A\。1\.\'\)\ \[data\/IdnaTest\.txt\:5854\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_ascii("ss\x{200D}\x{103A}。1.", %p)},	"xn--ss-f4j.1.",	"to_ascii\(\'ss\\u200D\\u103A\。1\.\'\)\ \[data\/IdnaTest\.txt\:5856\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_ascii("Ss\x{200D}\x{103A}。1.", %p)},	"xn--ss-f4j.1.",	"to_ascii\(\'Ss\\u200D\\u103A\。1\.\'\)\ \[data\/IdnaTest\.txt\:5858\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_ascii("xn--ss-f4j.1.", %p)},	"xn--ss-f4j.1.",	"to_ascii\(\'xn\-\-ss\-f4j\.1\.\'\)\ \[data\/IdnaTest\.txt\:5860\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_ascii("ss\x{103A}.1.", %p)},	"xn--ss-f4j.1.",	"to_ascii\(\'ss\\u103A\.1\.\'\)\ \[data\/IdnaTest\.txt\:5861\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_ascii("SS\x{103A}.1.", %p)},	"xn--ss-f4j.1.",	"to_ascii\(\'SS\\u103A\.1\.\'\)\ \[data\/IdnaTest\.txt\:5862\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_ascii("Ss\x{103A}.1.", %p)},	"xn--ss-f4j.1.",	"to_ascii\(\'Ss\\u103A\.1\.\'\)\ \[data\/IdnaTest\.txt\:5863\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--ss-f4j585j.1.", %p)},	undef,	"to_ascii\(\'xn\-\-ss\-f4j585j\.1\.\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:5864\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--zca679eh2l.1.", %p)},	undef,	"to_ascii\(\'xn\-\-zca679eh2l\.1\.\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:5865\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("SS\x{200D}\x{103A}｡⒈", %p)},	undef,	"to_ascii\(\'SS\\u200D\\u103A｡⒈\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:5866\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ss\x{200D}\x{103A}｡⒈", %p)},	undef,	"to_ascii\(\'ss\\u200D\\u103A｡⒈\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:5868\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ss\x{200D}\x{103A}｡⒈", %p)},	undef,	"to_ascii\(\'Ss\\u200D\\u103A｡⒈\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:5870\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--ss-f4j.xn--tsh", %p)},	undef,	"to_ascii\(\'xn\-\-ss\-f4j\.xn\-\-tsh\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:5872\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--ss-f4j585j.xn--tsh", %p)},	undef,	"to_ascii\(\'xn\-\-ss\-f4j585j\.xn\-\-tsh\'\)\ throws\ error\ C2\ V6\ \[data\/IdnaTest\.txt\:5873\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--zca679eh2l.xn--tsh", %p)},	undef,	"to_ascii\(\'xn\-\-zca679eh2l\.xn\-\-tsh\'\)\ throws\ error\ C2\ V6\ \[data\/IdnaTest\.txt\:5874\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0B4D}\x{200C}𙶵𞻘。\x{200D}", %p)},	undef,	"to_ascii\(\'\\u0B4D\\u200C\?\?\。\\u200D\'\)\ throws\ error\ B1\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:5875\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--9ic6417rn4xb.", %p)},	undef,	"to_ascii\(\'xn\-\-9ic6417rn4xb\.\'\)\ throws\ error\ B1\ V5\ V6\ \[data\/IdnaTest\.txt\:5877\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--9ic637hz82z32jc.xn--1ug", %p)},	undef,	"to_ascii\(\'xn\-\-9ic637hz82z32jc\.xn\-\-1ug\'\)\ throws\ error\ B1\ C2\ V5\ V6\ \[data\/IdnaTest\.txt\:5878\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("𐮅｡\x{06BC}🁕", %p)},	undef,	"to_ascii\(\'𐮅｡\\u06BC🁕\'\)\ throws\ error\ B3\ \[data\/IdnaTest\.txt\:5879\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("𐮅。\x{06BC}🁕", %p)},	undef,	"to_ascii\(\'𐮅\。\\u06BC🁕\'\)\ throws\ error\ B3\ \[data\/IdnaTest\.txt\:5880\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--c29c.xn--vkb8871w", %p)},	undef,	"to_ascii\(\'xn\-\-c29c\.xn\-\-vkb8871w\'\)\ throws\ error\ B3\ \[data\/IdnaTest\.txt\:5881\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0620}\x{17D2}。𐫔󠀧\x{200C}𑈵", %p)},	undef,	"to_ascii\(\'\\u0620\\u17D2\。𐫔\?\\u200C𑈵\'\)\ throws\ error\ B2\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:5882\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--fgb471g.xn--9w9c29jw3931a", %p)},	undef,	"to_ascii\(\'xn\-\-fgb471g\.xn\-\-9w9c29jw3931a\'\)\ throws\ error\ B2\ B3\ V6\ \[data\/IdnaTest\.txt\:5884\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--fgb471g.xn--0ug9853g7verp838a", %p)},	undef,	"to_ascii\(\'xn\-\-fgb471g\.xn\-\-0ug9853g7verp838a\'\)\ throws\ error\ B2\ B3\ C1\ V6\ \[data\/IdnaTest\.txt\:5885\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񋉕.𞣕𞤊", %p)},	undef,	"to_ascii\(\'\?\.𞣕𞤊\'\)\ throws\ error\ B1\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:5886\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("񋉕.𞣕𞤬", %p)},	undef,	"to_ascii\(\'\?\.𞣕𞤬\'\)\ throws\ error\ B1\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:5887\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--tf5w.xn--2b6hof", %p)},	undef,	"to_ascii\(\'xn\-\-tf5w\.xn\-\-2b6hof\'\)\ throws\ error\ B1\ V5\ V6\ \[data\/IdnaTest\.txt\:5888\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("\x{06CC}𐨿．ß\x{0F84}𑍬", %p)},	"xn--clb2593k.xn--ss-toj6092t",	"to_ascii\(\'\\u06CC𐨿．ß\\u0F84𑍬\'\)\ \[data\/IdnaTest\.txt\:5889\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("\x{06CC}𐨿.ß\x{0F84}𑍬", %p)},	"xn--clb2593k.xn--ss-toj6092t",	"to_ascii\(\'\\u06CC𐨿\.ß\\u0F84𑍬\'\)\ \[data\/IdnaTest\.txt\:5891\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("\x{06CC}𐨿.SS\x{0F84}𑍬", %p)},	"xn--clb2593k.xn--ss-toj6092t",	"to_ascii\(\'\\u06CC𐨿\.SS\\u0F84𑍬\'\)\ \[data\/IdnaTest\.txt\:5893\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("\x{06CC}𐨿.ss\x{0F84}𑍬", %p)},	"xn--clb2593k.xn--ss-toj6092t",	"to_ascii\(\'\\u06CC𐨿\.ss\\u0F84𑍬\'\)\ \[data\/IdnaTest\.txt\:5894\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("\x{06CC}𐨿.Ss\x{0F84}𑍬", %p)},	"xn--clb2593k.xn--ss-toj6092t",	"to_ascii\(\'\\u06CC𐨿\.Ss\\u0F84𑍬\'\)\ \[data\/IdnaTest\.txt\:5895\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("xn--clb2593k.xn--ss-toj6092t", %p)},	"xn--clb2593k.xn--ss-toj6092t",	"to_ascii\(\'xn\-\-clb2593k\.xn\-\-ss\-toj6092t\'\)\ \[data\/IdnaTest\.txt\:5896\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("xn--clb2593k.xn--zca216edt0r", %p)},	"xn--clb2593k.xn--zca216edt0r",	"to_ascii\(\'xn\-\-clb2593k\.xn\-\-zca216edt0r\'\)\ \[data\/IdnaTest\.txt\:5897\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("\x{06CC}𐨿．SS\x{0F84}𑍬", %p)},	"xn--clb2593k.xn--ss-toj6092t",	"to_ascii\(\'\\u06CC𐨿．SS\\u0F84𑍬\'\)\ \[data\/IdnaTest\.txt\:5898\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("\x{06CC}𐨿．ss\x{0F84}𑍬", %p)},	"xn--clb2593k.xn--ss-toj6092t",	"to_ascii\(\'\\u06CC𐨿．ss\\u0F84𑍬\'\)\ \[data\/IdnaTest\.txt\:5899\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("\x{06CC}𐨿．Ss\x{0F84}𑍬", %p)},	"xn--clb2593k.xn--ss-toj6092t",	"to_ascii\(\'\\u06CC𐨿．Ss\\u0F84𑍬\'\)\ \[data\/IdnaTest\.txt\:5900\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("𝟠≮\x{200C}｡󠅱\x{17B4}", %p)},	undef,	"to_ascii\(\'𝟠\≮\\u200C｡\󠅱\\u17B4\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:5901\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𝟠<\x{0338}\x{200C}｡󠅱\x{17B4}", %p)},	undef,	"to_ascii\(\'𝟠\<\\u0338\\u200C｡\󠅱\\u17B4\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:5903\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("8≮\x{200C}。󠅱\x{17B4}", %p)},	undef,	"to_ascii\(\'8\≮\\u200C\。\󠅱\\u17B4\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:5905\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("8<\x{0338}\x{200C}。󠅱\x{17B4}", %p)},	undef,	"to_ascii\(\'8\<\\u0338\\u200C\。\󠅱\\u17B4\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:5907\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--8-ngo.xn--z3e", %p)},	undef,	"to_ascii\(\'xn\-\-8\-ngo\.xn\-\-z3e\'\)\ throws\ error\ V5\ V6\ \[data\/IdnaTest\.txt\:5909\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--8-sgn10i.xn--z3e", %p)},	undef,	"to_ascii\(\'xn\-\-8\-sgn10i\.xn\-\-z3e\'\)\ throws\ error\ C1\ V5\ V6\ \[data\/IdnaTest\.txt\:5910\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᢕ≯︒񄂯．Ⴀ", %p)},	undef,	"to_ascii\(\'ᢕ\≯︒\?．Ⴀ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:5911\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᢕ>\x{0338}︒񄂯．Ⴀ", %p)},	undef,	"to_ascii\(\'ᢕ\>\\u0338︒\?．Ⴀ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:5912\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᢕ≯。񄂯.Ⴀ", %p)},	undef,	"to_ascii\(\'ᢕ\≯\。\?\.Ⴀ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:5913\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᢕ>\x{0338}。񄂯.Ⴀ", %p)},	undef,	"to_ascii\(\'ᢕ\>\\u0338\。\?\.Ⴀ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:5914\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᢕ>\x{0338}。񄂯.ⴀ", %p)},	undef,	"to_ascii\(\'ᢕ\>\\u0338\。\?\.ⴀ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:5915\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᢕ≯。񄂯.ⴀ", %p)},	undef,	"to_ascii\(\'ᢕ\≯\。\?\.ⴀ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:5916\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--fbf851c.xn--ko1u.xn--rkj", %p)},	undef,	"to_ascii\(\'xn\-\-fbf851c\.xn\-\-ko1u\.xn\-\-rkj\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:5917\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--fbf851c.xn--ko1u.xn--7md", %p)},	undef,	"to_ascii\(\'xn\-\-fbf851c\.xn\-\-ko1u\.xn\-\-7md\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:5918\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᢕ>\x{0338}︒񄂯．ⴀ", %p)},	undef,	"to_ascii\(\'ᢕ\>\\u0338︒\?．ⴀ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:5919\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᢕ≯︒񄂯．ⴀ", %p)},	undef,	"to_ascii\(\'ᢕ\≯︒\?．ⴀ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:5920\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--fbf851cq98poxw1a.xn--rkj", %p)},	undef,	"to_ascii\(\'xn\-\-fbf851cq98poxw1a\.xn\-\-rkj\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:5921\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--fbf851cq98poxw1a.xn--7md", %p)},	undef,	"to_ascii\(\'xn\-\-fbf851cq98poxw1a\.xn\-\-7md\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:5922\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("\x{0F9F}．-\x{082A}", %p)},	undef,	"to_ascii\(\'\\u0F9F．\-\\u082A\'\)\ throws\ error\ V3\ V5\ \[data\/IdnaTest\.txt\:5923\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("\x{0F9F}.-\x{082A}", %p)},	undef,	"to_ascii\(\'\\u0F9F\.\-\\u082A\'\)\ throws\ error\ V3\ V5\ \[data\/IdnaTest\.txt\:5924\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--vfd.xn----fhd", %p)},	undef,	"to_ascii\(\'xn\-\-vfd\.xn\-\-\-\-fhd\'\)\ throws\ error\ V3\ V5\ \[data\/IdnaTest\.txt\:5925\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᵬ󠆠．핒⒒⒈􈄦", %p)},	undef,	"to_ascii\(\'ᵬ\󠆠．핒⒒⒈\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:5926\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᵬ󠆠．핒⒒⒈􈄦", %p)},	undef,	"to_ascii\(\'ᵬ\󠆠．핒⒒⒈\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:5927\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᵬ󠆠.핒11.1.􈄦", %p)},	undef,	"to_ascii\(\'ᵬ\󠆠\.핒11\.1\.\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:5928\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ᵬ󠆠.핒11.1.􈄦", %p)},	undef,	"to_ascii\(\'ᵬ\󠆠\.핒11\.1\.\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:5929\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--tbg.xn--11-5o7k.1.xn--k469f", %p)},	undef,	"to_ascii\(\'xn\-\-tbg\.xn\-\-11\-5o7k\.1\.xn\-\-k469f\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:5930\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--tbg.xn--tsht7586kyts9l", %p)},	undef,	"to_ascii\(\'xn\-\-tbg\.xn\-\-tsht7586kyts9l\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:5931\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("ς𑓂𐋢．\x{0668}", %p)},	undef,	"to_ascii\(\'ς𑓂𐋢．\\u0668\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:5932\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("ς𑓂𐋢.\x{0668}", %p)},	undef,	"to_ascii\(\'ς𑓂𐋢\.\\u0668\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:5934\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("Σ𑓂𐋢.\x{0668}", %p)},	undef,	"to_ascii\(\'Σ𑓂𐋢\.\\u0668\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:5936\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("σ𑓂𐋢.\x{0668}", %p)},	undef,	"to_ascii\(\'σ𑓂𐋢\.\\u0668\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:5937\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--4xa6371khhl.xn--hib", %p)},	undef,	"to_ascii\(\'xn\-\-4xa6371khhl\.xn\-\-hib\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:5938\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--3xa8371khhl.xn--hib", %p)},	undef,	"to_ascii\(\'xn\-\-3xa8371khhl\.xn\-\-hib\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:5939\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("Σ𑓂𐋢．\x{0668}", %p)},	undef,	"to_ascii\(\'Σ𑓂𐋢．\\u0668\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:5940\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_ascii("σ𑓂𐋢．\x{0668}", %p)},	undef,	"to_ascii\(\'σ𑓂𐋢．\\u0668\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:5941\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("\x{A953}\x{200C}𐋻\x{200D}.\x{2DF8}𞿄𐹲", %p)},	undef,	"to_ascii\(\'\\uA953\\u200C𐋻\\u200D\.\\u2DF8\?𐹲\'\)\ throws\ error\ B1\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:5942\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--3j9a531o.xn--urju692efj0f", %p)},	undef,	"to_ascii\(\'xn\-\-3j9a531o\.xn\-\-urju692efj0f\'\)\ throws\ error\ B1\ V5\ V6\ \[data\/IdnaTest\.txt\:5944\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--0ugc8356he76c.xn--urju692efj0f", %p)},	undef,	"to_ascii\(\'xn\-\-0ugc8356he76c\.xn\-\-urju692efj0f\'\)\ throws\ error\ B1\ B6\ C2\ V5\ V6\ \[data\/IdnaTest\.txt\:5945\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⊼。񪧖\x{0695}", %p)},	undef,	"to_ascii\(\'\⊼\。\?\\u0695\'\)\ throws\ error\ B1\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:5946\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--ofh.xn--rjb13118f", %p)},	undef,	"to_ascii\(\'xn\-\-ofh\.xn\-\-rjb13118f\'\)\ throws\ error\ B1\ B5\ B6\ V6\ \[data\/IdnaTest\.txt\:5947\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𐯬񖋔。󜳥", %p)},	undef,	"to_ascii\(\'\?\?\。\?\'\)\ throws\ error\ B2\ B3\ P1\ V6\ \[data\/IdnaTest\.txt\:5948\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--949co370q.xn--7g25e", %p)},	undef,	"to_ascii\(\'xn\-\-949co370q\.xn\-\-7g25e\'\)\ throws\ error\ B2\ B3\ V6\ \[data\/IdnaTest\.txt\:5949\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0601}𑍧\x{07DD}。ς򬍘🀞\x{17B5}", %p)},	undef,	"to_ascii\(\'\\u0601𑍧\\u07DD\。ς\?🀞\\u17B5\'\)\ throws\ error\ B1\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:5950\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0601}𑍧\x{07DD}。Σ򬍘🀞\x{17B5}", %p)},	undef,	"to_ascii\(\'\\u0601𑍧\\u07DD\。Σ\?🀞\\u17B5\'\)\ throws\ error\ B1\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:5952\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0601}𑍧\x{07DD}。σ򬍘🀞\x{17B5}", %p)},	undef,	"to_ascii\(\'\\u0601𑍧\\u07DD\。σ\?🀞\\u17B5\'\)\ throws\ error\ B1\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:5953\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--jfb66gt010c.xn--4xa623h9p95ars26d", %p)},	undef,	"to_ascii\(\'xn\-\-jfb66gt010c\.xn\-\-4xa623h9p95ars26d\'\)\ throws\ error\ B1\ B6\ V6\ \[data\/IdnaTest\.txt\:5954\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--jfb66gt010c.xn--3xa823h9p95ars26d", %p)},	undef,	"to_ascii\(\'xn\-\-jfb66gt010c\.xn\-\-3xa823h9p95ars26d\'\)\ throws\ error\ B1\ B6\ V6\ \[data\/IdnaTest\.txt\:5955\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-𐳲\x{0646}󠺐。\x{ABED}𝟥", %p)},	undef,	"to_ascii\(\'\-𐳲\\u0646\?\。\\uABED𝟥\'\)\ throws\ error\ B1\ P1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:5956\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-𐳲\x{0646}󠺐。\x{ABED}3", %p)},	undef,	"to_ascii\(\'\-𐳲\\u0646\?\。\\uABED3\'\)\ throws\ error\ B1\ P1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:5957\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-𐲲\x{0646}󠺐。\x{ABED}3", %p)},	undef,	"to_ascii\(\'\-𐲲\\u0646\?\。\\uABED3\'\)\ throws\ error\ B1\ P1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:5958\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn----roc5482rek10i.xn--3-zw5e", %p)},	undef,	"to_ascii\(\'xn\-\-\-\-roc5482rek10i\.xn\-\-3\-zw5e\'\)\ throws\ error\ B1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:5959\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-𐲲\x{0646}󠺐。\x{ABED}𝟥", %p)},	undef,	"to_ascii\(\'\-𐲲\\u0646\?\。\\uABED𝟥\'\)\ throws\ error\ B1\ P1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:5960\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}󠴦｡񲨕≮𐦜", %p)},	undef,	"to_ascii\(\'\\u200C\?｡\?\≮𐦜\'\)\ throws\ error\ B1\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:5961\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}󠴦｡񲨕<\x{0338}𐦜", %p)},	undef,	"to_ascii\(\'\\u200C\?｡\?\<\\u0338𐦜\'\)\ throws\ error\ B1\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:5963\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}󠴦。񲨕≮𐦜", %p)},	undef,	"to_ascii\(\'\\u200C\?\。\?\≮𐦜\'\)\ throws\ error\ B1\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:5965\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}󠴦。񲨕<\x{0338}𐦜", %p)},	undef,	"to_ascii\(\'\\u200C\?\。\?\<\\u0338𐦜\'\)\ throws\ error\ B1\ B5\ B6\ P1\ V6\ \[data\/IdnaTest\.txt\:5967\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--6v56e.xn--gdhz712gzlr6b", %p)},	undef,	"to_ascii\(\'xn\-\-6v56e\.xn\-\-gdhz712gzlr6b\'\)\ throws\ error\ B1\ B5\ B6\ V6\ \[data\/IdnaTest\.txt\:5969\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--0ug22251l.xn--gdhz712gzlr6b", %p)},	undef,	"to_ascii\(\'xn\-\-0ug22251l\.xn\-\-gdhz712gzlr6b\'\)\ throws\ error\ B1\ B5\ B6\ C1\ V6\ \[data\/IdnaTest\.txt\:5970\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("⒈✌򟬟．𝟡񠱣", %p)},	undef,	"to_ascii\(\'⒈\✌\?．𝟡\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:5971\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("1.✌򟬟.9񠱣", %p)},	undef,	"to_ascii\(\'1\.\✌\?\.9\?\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:5972\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("1.xn--7bi44996f.xn--9-o706d", %p)},	undef,	"to_ascii\(\'1\.xn\-\-7bi44996f\.xn\-\-9\-o706d\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:5973\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--tsh24g49550b.xn--9-o706d", %p)},	undef,	"to_ascii\(\'xn\-\-tsh24g49550b\.xn\-\-9\-o706d\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:5974\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("𑆾𞤬𐮆.\x{0666}\x{1DD4}", %p)},	undef,	"to_ascii\(\'𑆾𞤬𐮆\.\\u0666\\u1DD4\'\)\ throws\ error\ B1\ V5\ \[data\/IdnaTest\.txt\:5975\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("𑆾𞤊𐮆.\x{0666}\x{1DD4}", %p)},	undef,	"to_ascii\(\'𑆾𞤊𐮆\.\\u0666\\u1DD4\'\)\ throws\ error\ B1\ V5\ \[data\/IdnaTest\.txt\:5976\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--d29c79hf98r.xn--fib011j", %p)},	undef,	"to_ascii\(\'xn\-\-d29c79hf98r\.xn\-\-fib011j\'\)\ throws\ error\ B1\ V5\ \[data\/IdnaTest\.txt\:5977\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("ς．\x{A9C0}\x{A8C4}", %p)},	undef,	"to_ascii\(\'ς．\\uA9C0\\uA8C4\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:5978\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("ς.\x{A9C0}\x{A8C4}", %p)},	undef,	"to_ascii\(\'ς\.\\uA9C0\\uA8C4\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:5980\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("Σ.\x{A9C0}\x{A8C4}", %p)},	undef,	"to_ascii\(\'Σ\.\\uA9C0\\uA8C4\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:5982\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("σ.\x{A9C0}\x{A8C4}", %p)},	undef,	"to_ascii\(\'σ\.\\uA9C0\\uA8C4\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:5983\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--4xa.xn--0f9ars", %p)},	undef,	"to_ascii\(\'xn\-\-4xa\.xn\-\-0f9ars\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:5984\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--3xa.xn--0f9ars", %p)},	undef,	"to_ascii\(\'xn\-\-3xa\.xn\-\-0f9ars\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:5985\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("Σ．\x{A9C0}\x{A8C4}", %p)},	undef,	"to_ascii\(\'Σ．\\uA9C0\\uA8C4\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:5986\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_ascii("σ．\x{A9C0}\x{A8C4}", %p)},	undef,	"to_ascii\(\'σ．\\uA9C0\\uA8C4\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:5987\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("𑰶\x{200C}≯𐳐．\x{085B}", %p)},	undef,	"to_ascii\(\'𑰶\\u200C\≯𐳐．\\u085B\'\)\ throws\ error\ B1\ B3\ B6\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:5988\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𑰶\x{200C}>\x{0338}𐳐．\x{085B}", %p)},	undef,	"to_ascii\(\'𑰶\\u200C\>\\u0338𐳐．\\u085B\'\)\ throws\ error\ B1\ B3\ B6\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:5990\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𑰶\x{200C}≯𐳐.\x{085B}", %p)},	undef,	"to_ascii\(\'𑰶\\u200C\≯𐳐\.\\u085B\'\)\ throws\ error\ B1\ B3\ B6\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:5992\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𑰶\x{200C}>\x{0338}𐳐.\x{085B}", %p)},	undef,	"to_ascii\(\'𑰶\\u200C\>\\u0338𐳐\.\\u085B\'\)\ throws\ error\ B1\ B3\ B6\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:5994\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𑰶\x{200C}>\x{0338}𐲐.\x{085B}", %p)},	undef,	"to_ascii\(\'𑰶\\u200C\>\\u0338𐲐\.\\u085B\'\)\ throws\ error\ B1\ B3\ B6\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:5996\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𑰶\x{200C}≯𐲐.\x{085B}", %p)},	undef,	"to_ascii\(\'𑰶\\u200C\≯𐲐\.\\u085B\'\)\ throws\ error\ B1\ B3\ B6\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:5998\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--hdhz343g3wj.xn--qwb", %p)},	undef,	"to_ascii\(\'xn\-\-hdhz343g3wj\.xn\-\-qwb\'\)\ throws\ error\ B1\ B3\ B6\ V5\ V6\ \[data\/IdnaTest\.txt\:6000\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--0ug06g7697ap4ma.xn--qwb", %p)},	undef,	"to_ascii\(\'xn\-\-0ug06g7697ap4ma\.xn\-\-qwb\'\)\ throws\ error\ B1\ B3\ B6\ C1\ V5\ V6\ \[data\/IdnaTest\.txt\:6001\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𑰶\x{200C}>\x{0338}𐲐．\x{085B}", %p)},	undef,	"to_ascii\(\'𑰶\\u200C\>\\u0338𐲐．\\u085B\'\)\ throws\ error\ B1\ B3\ B6\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:6002\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𑰶\x{200C}≯𐲐．\x{085B}", %p)},	undef,	"to_ascii\(\'𑰶\\u200C\≯𐲐．\\u085B\'\)\ throws\ error\ B1\ B3\ B6\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:6004\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("羚｡≯", %p)},	undef,	"to_ascii\(\'羚｡\≯\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:6006\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("羚｡>\x{0338}", %p)},	undef,	"to_ascii\(\'羚｡\>\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:6007\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("羚。≯", %p)},	undef,	"to_ascii\(\'羚\。\≯\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:6008\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("羚。>\x{0338}", %p)},	undef,	"to_ascii\(\'羚\。\>\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:6009\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--xt0a.xn--hdh", %p)},	undef,	"to_ascii\(\'xn\-\-xt0a\.xn\-\-hdh\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:6010\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𑓂\x{1759}．\x{08A8}", %p)},	undef,	"to_ascii\(\'𑓂\\u1759．\\u08A8\'\)\ throws\ error\ B1\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:6011\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𑓂\x{1759}.\x{08A8}", %p)},	undef,	"to_ascii\(\'𑓂\\u1759\.\\u08A8\'\)\ throws\ error\ B1\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:6012\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--e1e9580k.xn--xyb", %p)},	undef,	"to_ascii\(\'xn\-\-e1e9580k\.xn\-\-xyb\'\)\ throws\ error\ B1\ V5\ V6\ \[data\/IdnaTest\.txt\:6013\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󨣿󠇀\x{200D}｡\x{0663}ҠჀ𝟑", %p)},	undef,	"to_ascii\(\'\?\󠇀\\u200D｡\\u0663ҠჀ𝟑\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:6014\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󨣿󠇀\x{200D}。\x{0663}ҠჀ3", %p)},	undef,	"to_ascii\(\'\?\󠇀\\u200D\。\\u0663ҠჀ3\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:6016\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󨣿󠇀\x{200D}。\x{0663}ҡⴠ3", %p)},	undef,	"to_ascii\(\'\?\󠇀\\u200D\。\\u0663ҡⴠ3\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:6018\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󨣿󠇀\x{200D}。\x{0663}Ҡⴠ3", %p)},	undef,	"to_ascii\(\'\?\󠇀\\u200D\。\\u0663Ҡⴠ3\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:6020\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--1r19e.xn--3-ozb36ko13f", %p)},	undef,	"to_ascii\(\'xn\-\-1r19e\.xn\-\-3\-ozb36ko13f\'\)\ throws\ error\ B1\ V6\ \[data\/IdnaTest\.txt\:6022\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--1ug89936l.xn--3-ozb36ko13f", %p)},	undef,	"to_ascii\(\'xn\-\-1ug89936l\.xn\-\-3\-ozb36ko13f\'\)\ throws\ error\ B1\ B6\ C2\ V6\ \[data\/IdnaTest\.txt\:6023\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--1r19e.xn--3-ozb36kixu", %p)},	undef,	"to_ascii\(\'xn\-\-1r19e\.xn\-\-3\-ozb36kixu\'\)\ throws\ error\ B1\ V6\ \[data\/IdnaTest\.txt\:6024\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--1ug89936l.xn--3-ozb36kixu", %p)},	undef,	"to_ascii\(\'xn\-\-1ug89936l\.xn\-\-3\-ozb36kixu\'\)\ throws\ error\ B1\ B6\ C2\ V6\ \[data\/IdnaTest\.txt\:6025\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󨣿󠇀\x{200D}｡\x{0663}ҡⴠ𝟑", %p)},	undef,	"to_ascii\(\'\?\󠇀\\u200D｡\\u0663ҡⴠ𝟑\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:6026\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("󨣿󠇀\x{200D}｡\x{0663}Ҡⴠ𝟑", %p)},	undef,	"to_ascii\(\'\?\󠇀\\u200D｡\\u0663Ҡⴠ𝟑\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:6028\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v9.0 (perl v5.25.3) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v9.0; is(eval{uts46_to_ascii("ᡷ。𐹢\x{08E0}", %p)},	undef,	"to_ascii\(\'ᡷ\。𐹢\\u08E0\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:6030\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--k9e.xn--j0b5005k", %p)},	undef,	"to_ascii\(\'xn\-\-k9e\.xn\-\-j0b5005k\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:6031\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򕮇\x{1BF3}｡\x{0666}񗜼\x{17D2}ß", %p)},	undef,	"to_ascii\(\'\?\\u1BF3｡\\u0666\?\\u17D2ß\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:6032\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򕮇\x{1BF3}。\x{0666}񗜼\x{17D2}ß", %p)},	undef,	"to_ascii\(\'\?\\u1BF3\。\\u0666\?\\u17D2ß\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:6034\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򕮇\x{1BF3}。\x{0666}񗜼\x{17D2}SS", %p)},	undef,	"to_ascii\(\'\?\\u1BF3\。\\u0666\?\\u17D2SS\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:6036\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򕮇\x{1BF3}。\x{0666}񗜼\x{17D2}ss", %p)},	undef,	"to_ascii\(\'\?\\u1BF3\。\\u0666\?\\u17D2ss\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:6037\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򕮇\x{1BF3}。\x{0666}񗜼\x{17D2}Ss", %p)},	undef,	"to_ascii\(\'\?\\u1BF3\。\\u0666\?\\u17D2Ss\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:6038\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--1zf58212h.xn--ss-pyd459o3258m", %p)},	undef,	"to_ascii\(\'xn\-\-1zf58212h\.xn\-\-ss\-pyd459o3258m\'\)\ throws\ error\ B1\ V6\ \[data\/IdnaTest\.txt\:6039\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--1zf58212h.xn--zca34zk4qx711k", %p)},	undef,	"to_ascii\(\'xn\-\-1zf58212h\.xn\-\-zca34zk4qx711k\'\)\ throws\ error\ B1\ V6\ \[data\/IdnaTest\.txt\:6040\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򕮇\x{1BF3}｡\x{0666}񗜼\x{17D2}SS", %p)},	undef,	"to_ascii\(\'\?\\u1BF3｡\\u0666\?\\u17D2SS\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:6041\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򕮇\x{1BF3}｡\x{0666}񗜼\x{17D2}ss", %p)},	undef,	"to_ascii\(\'\?\\u1BF3｡\\u0666\?\\u17D2ss\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:6042\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("򕮇\x{1BF3}｡\x{0666}񗜼\x{17D2}Ss", %p)},	undef,	"to_ascii\(\'\?\\u1BF3｡\\u0666\?\\u17D2Ss\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:6043\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0664}򤽎𑲛.󠔢︒≠", %p)},	undef,	"to_ascii\(\'\\u0664\?𑲛\.\?︒\≠\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:6044\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0664}򤽎𑲛.󠔢︒=\x{0338}", %p)},	undef,	"to_ascii\(\'\\u0664\?𑲛\.\?︒\=\\u0338\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:6045\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0664}򤽎𑲛.󠔢。≠", %p)},	undef,	"to_ascii\(\'\\u0664\?𑲛\.\?\。\≠\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:6046\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0664}򤽎𑲛.󠔢。=\x{0338}", %p)},	undef,	"to_ascii\(\'\\u0664\?𑲛\.\?\。\=\\u0338\'\)\ throws\ error\ B1\ P1\ V6\ \[data\/IdnaTest\.txt\:6047\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--dib0653l2i02d.xn--k736e.xn--1ch", %p)},	undef,	"to_ascii\(\'xn\-\-dib0653l2i02d\.xn\-\-k736e\.xn\-\-1ch\'\)\ throws\ error\ B1\ V6\ \[data\/IdnaTest\.txt\:6048\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--dib0653l2i02d.xn--1ch7467f14u4g", %p)},	undef,	"to_ascii\(\'xn\-\-dib0653l2i02d\.xn\-\-1ch7467f14u4g\'\)\ throws\ error\ B1\ V6\ \[data\/IdnaTest\.txt\:6049\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("➆񷧕ỗ⒈．򑬒񡘮\x{085B}𝟫", %p)},	undef,	"to_ascii\(\'➆\?ỗ⒈．\?\?\\u085B𝟫\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:6050\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("➆񷧕o\x{0302}\x{0303}⒈．򑬒񡘮\x{085B}𝟫", %p)},	undef,	"to_ascii\(\'➆\?o\\u0302\\u0303⒈．\?\?\\u085B𝟫\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:6051\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("➆񷧕ỗ1..򑬒񡘮\x{085B}9", %p)},	undef,	"to_ascii\(\'➆\?ỗ1\.\.\?\?\\u085B9\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:6052\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("➆񷧕o\x{0302}\x{0303}1..򑬒񡘮\x{085B}9", %p)},	undef,	"to_ascii\(\'➆\?o\\u0302\\u03031\.\.\?\?\\u085B9\'\)\ throws\ error\ P1\ V6\ A4_2\ \[dat