#!/usr/bin/perl

use strict;
use warnings;
#use utf8;
use lib 't/lib';

use Encode;
use English qw(-no_match_vars);
use Test::Deep;
use Test::Exception;
use Test::MockModule;
use Test::More;
use Test::NoWarnings;

use FusionInventory::Agent::Inventory;
use FusionInventory::Test::Utils;

BEGIN {
    # use mock modules for non-available ones
    push @INC, 't/lib/fake/windows' if $OSNAME ne 'MSWin32';
}


use FusionInventory::Agent::Task::Inventory::Win32::Softwares;

my %softwares_tests = (
        xp => [
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB977914)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '15/02/2010',
                NO_REMOVE        => undef,
                GUID             => 'KB977914',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=977914',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Kay Bruns',
                NAME             => 'Super User Run (SuRun)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => undef,
                NO_REMOVE        => undef,
                GUID             => 'SuRun',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => undef,
                URL_INFO_ABOUT   => 'http://kay-bruns.de/surun',
                VERSION_MAJOR    => undef,
                VERSION          => '1.2.0.8',
                UNINSTALL_STRING => 'C:\\WINDOWS\\SuRun.exe /UNINSTALL',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB2641653)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '16/03/2012',
                NO_REMOVE        => undef,
                GUID             => 'KB2641653',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=2641653',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft',
                NAME             => 'Update for Microsoft Office 2010 (KB2553310) 32-Bit Edition',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => undef,
                NO_REMOVE        => 0,
                GUID             => '{90140000-006E-0409-0000-0000000FF1CE}_Office14.PROPLUS_{73E67A3A-8D61-44EF-90C2-1697C3DBE668}',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => 'http://support.microsoft.com/kb/2553310',
                URL_INFO_ABOUT   => 'http://support.microsoft.com/kb/2553310',
                VERSION_MAJOR    => undef,
                VERSION          => undef,
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft',
                NAME             => 'Microsoft Office 2010 Service Pack 1 (SP1)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => undef,
                NO_REMOVE        => 0,
                GUID             => '{90140000-0044-0409-0000-0000000FF1CE}_Office14.PROPLUS_{6BD185A0-E67F-4F77-8BCD-E34EA6AE76DF}',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => 'http://support.microsoft.com/kb/2460049',
                URL_INFO_ABOUT   => 'http://support.microsoft.com/kb/2460049',
                VERSION_MAJOR    => undef,
                VERSION          => undef,
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Microsoft Office InfoPath MUI (English) 2010',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '04/10/2011',
                NO_REMOVE        => undef,
                GUID             => '{90140000-0044-0409-0000-0000000FF1CE}',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => undef,
                URL_INFO_ABOUT   => undef,
                VERSION_MAJOR    => undef,
                VERSION          => '14.0.6029.1000',
                UNINSTALL_STRING => undef,
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Update for Windows XP (KB2141007)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '20/09/2010',
                NO_REMOVE        => undef,
                GUID             => 'KB2141007',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=2141007',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Microsoft .NET Framework 4 Client Profile (KB2518870)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => undef,
                NO_REMOVE        => undef,
                GUID             => '{3C3901C5-3455-3E0A-A214-0B093A5070A6}.KB2518870',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com/kb/2518870',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => 'C:\\windows\\Microsoft.NET\\Framework\\v4.0.30319\\SetupCache\\Client\\setup.exe /uninstallpatch {2CE2EB39-45C8-32D4-8A99-5529C38F1B99} /parameterfolder Client',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB2508272)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '18/04/2011',
                NO_REMOVE        => undef,
                GUID             => 'KB2508272',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=2508272',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Microsoft Office Access MUI (English) 2010',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '04/10/2011',
                NO_REMOVE        => undef,
                GUID             => '{90140000-0015-0409-0000-0000000FF1CE}',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => undef,
                URL_INFO_ABOUT   => undef,
                VERSION_MAJOR    => undef,
                VERSION          => '14.0.6029.1000',
                UNINSTALL_STRING => undef,
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB2506223)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '18/04/2011',
                NO_REMOVE        => undef,
                GUID             => 'KB2506223',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=2506223',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'O&O Software GmbH',
                NAME             => 'O&O DiskStat Workstation',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '23/02/2011',
                NO_REMOVE        => undef,
                GUID             => '{754F24D0-D2FF-4801-B7ED-588D4E88415B}',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => undef,
                URL_INFO_ABOUT   => 'http://www.oo-software.com',
                VERSION_MAJOR    => undef,
                VERSION          => '2.0.386',
                UNINSTALL_STRING => undef,
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Update for Windows XP (KB973687)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '14/12/2009',
                NO_REMOVE        => undef,
                GUID             => 'KB973687',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=973687',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB2115168)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '16/08/2010',
                NO_REMOVE        => undef,
                GUID             => 'KB2115168',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=2115168',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB950582)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '01/11/2008',
                NO_REMOVE        => undef,
                GUID             => 'KB950582',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=950582',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Update for Windows XP (KB951072-v2)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '09/07/2008',
                NO_REMOVE        => undef,
                GUID             => 'KB951072-v2',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=951072',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '2',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows Media Player (KB954155)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '09/11/2009',
                NO_REMOVE        => undef,
                GUID             => 'KB954155_WM9',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => 'http://support.microsoft.com/?kbid=954155',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => undef,
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB2618451)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '20/12/2011',
                NO_REMOVE        => undef,
                GUID             => 'KB2618451',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=2618451',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Microsoft .NET Framework 4 Extended (KB2656351)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => undef,
                NO_REMOVE        => undef,
                GUID             => '{0A0CADCF-78DA-33C4-A350-CD51849B9702}.KB2656351',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com/kb/2656351',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => 'c:\\windows\\Microsoft.NET\\Framework\\v4.0.30319\\SetupCache\\Extended\\setup.exe /uninstallpatch {4952F442-5C1A-38EB-8C23-B18EFE77E20C} /parameterfolder Extended',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows Internet Explorer 8 (KB982381)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '14/06/2010',
                NO_REMOVE        => undef,
                GUID             => 'KB982381-IE8',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=982381',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB971557)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '03/09/2009',
                NO_REMOVE        => undef,
                GUID             => 'KB971557',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=971557',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB923561)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '18/05/2009',
                NO_REMOVE        => undef,
                GUID             => 'KB923561',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=923561',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Update for Windows XP (KB2345886)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '18/10/2010',
                NO_REMOVE        => undef,
                GUID             => 'KB2345886',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=2345886',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB978706)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '15/02/2010',
                NO_REMOVE        => undef,
                GUID             => 'KB978706',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=978706',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Hotfix for Windows XP (KB954550-v5)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '02/04/2009',
                NO_REMOVE        => 1,
                GUID             => 'KB954550-v5',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Hotfix',
                HELPLINK         => 'http://support.microsoft.com?kbid=954550',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '5',
                UNINSTALL_STRING => undef,
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB2478971)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '14/02/2011',
                NO_REMOVE        => undef,
                GUID             => 'KB2478971',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=2478971',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB960803)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '18/05/2009',
                NO_REMOVE        => undef,
                GUID             => 'KB960803',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=960803',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Symantec Corporation',
                NAME             => 'Symantec Endpoint Protection',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '25/01/2012',
                NO_REMOVE        => undef,
                GUID             => '{FA689023-0B72-4771-98A6-A1C927E58207}',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => undef,
                URL_INFO_ABOUT   => undef,
                VERSION_MAJOR    => undef,
                VERSION          => '12.1.1000.157',
                UNINSTALL_STRING => undef,
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => undef,
                NAME             => 'Microsoft .NET Framework 1.1 Security Update (KB2656370)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => undef,
                NO_REMOVE        => undef,
                GUID             => 'M2656370',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => undef,
                URL_INFO_ABOUT   => undef,
                VERSION_MAJOR    => undef,
                VERSION          => undef,
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB2624667)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '20/12/2011',
                NO_REMOVE        => undef,
                GUID             => 'KB2624667',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=2624667',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB2296011)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '18/10/2010',
                NO_REMOVE        => undef,
                GUID             => 'KB2296011',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=2296011',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows Media Player (KB978695)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '14/06/2010',
                NO_REMOVE        => undef,
                GUID             => 'KB978695_WM9',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => 'http://support.microsoft.com/?kbid=978695',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => undef,
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB2544893)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '21/06/2011',
                NO_REMOVE        => undef,
                GUID             => 'KB2544893',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=2544893',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => undef,
                NAME             => 'Iceows V4.20a',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => undef,
                NO_REMOVE        => undef,
                GUID             => 'ICEOWS',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => undef,
                URL_INFO_ABOUT   => undef,
                VERSION_MAJOR    => undef,
                VERSION          => undef,
                UNINSTALL_STRING => 'C:\\Program Files\\ICEOWS\\Setup.exe /uninstall',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Microsoft .NET Framework 3.5 SP1',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '03/01/2012',
                NO_REMOVE        => undef,
                GUID             => '{CE2CDD62-0124-36CA-84D3-9F4DCF5C5BD9}',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => undef,
                URL_INFO_ABOUT   => undef,
                VERSION_MAJOR    => undef,
                VERSION          => '3.5.30729',
                UNINSTALL_STRING => undef,
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Microsoft .NET Framework 4 Client Profile (KB2446708)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => undef,
                NO_REMOVE        => undef,
                GUID             => '{3C3901C5-3455-3E0A-A214-0B093A5070A6}.KB2446708',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com/kb/2446708',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => 'C:\\windows\\Microsoft.NET\\Framework\\v4.0.30319\\SetupCache\\Client\\setup.exe /uninstallpatch {3E0806DB-3085-378A-840A-F0D3AE3609D1} /parameterfolder Client',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Hotfix for Windows XP (KB2570791)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '04/10/2011',
                NO_REMOVE        => undef,
                GUID             => 'KB2570791',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Hotfix',
                HELPLINK         => 'http://support.microsoft.com?kbid=2570791',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB951376-v2)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '09/07/2008',
                NO_REMOVE        => 1,
                GUID             => 'KB951376-v2',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=951376',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '2',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Microsoft Office Shared Setup Metadata MUI (English) 2010',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '04/10/2011',
                NO_REMOVE        => undef,
                GUID             => '{90140000-0115-0409-0000-0000000FF1CE}',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => undef,
                URL_INFO_ABOUT   => undef,
                VERSION_MAJOR    => undef,
                VERSION          => '14.0.6029.1000',
                UNINSTALL_STRING => undef,
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft',
                NAME             => 'Microsoft Office 2010 Service Pack 1 (SP1)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => undef,
                NO_REMOVE        => 0,
                GUID             => '{90140000-001A-0409-0000-0000000FF1CE}_Office14.PROPLUS_{6BD185A0-E67F-4F77-8BCD-E34EA6AE76DF}',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => 'http://support.microsoft.com/kb/2460049',
                URL_INFO_ABOUT   => 'http://support.microsoft.com/kb/2460049',
                VERSION_MAJOR    => undef,
                VERSION          => undef,
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows Internet Explorer 8 (KB2183461)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '16/08/2010',
                NO_REMOVE        => undef,
                GUID             => 'KB2183461-IE8',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=2183461',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB2555917)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '19/07/2011',
                NO_REMOVE        => undef,
                GUID             => 'KB2555917',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=2555917',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'LogMeIn Inc.',
                NAME             => 'Network Console',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '15/10/2010',
                NO_REMOVE        => 1,
                GUID             => '{5B21BB9A-E23E-472b-AD2A-FB9B06A4727C}',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => undef,
                URL_INFO_ABOUT   => 'http://www.logmein.com',
                VERSION_MAJOR    => undef,
                VERSION          => '9.00.175',
                UNINSTALL_STRING => undef,
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB958215)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '15/01/2009',
                NO_REMOVE        => undef,
                GUID             => 'KB958215',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=958215',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Microsoft Office Outlook MUI (English) 2010',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '17/04/2012',
                NO_REMOVE        => undef,
                GUID             => '{90140000-001A-0409-0000-0000000FF1CE}',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => undef,
                URL_INFO_ABOUT   => undef,
                VERSION_MAJOR    => undef,
                VERSION          => '14.0.6029.1000',
                UNINSTALL_STRING => undef,
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft',
                NAME             => 'Update for Microsoft Office 2010 (KB2553385) 32-Bit Edition',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => undef,
                NO_REMOVE        => 0,
                GUID             => '{90140000-0011-0000-0000-0000000FF1CE}_Office14.PROPLUS_{28FAC187-7C0E-413A-B90A-76F19D0FBF30}',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => 'http://support.microsoft.com/kb/2553385',
                URL_INFO_ABOUT   => 'http://support.microsoft.com/kb/2553385',
                VERSION_MAJOR    => undef,
                VERSION          => undef,
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB2567680)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '16/08/2011',
                NO_REMOVE        => undef,
                GUID             => 'KB2567680',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=2567680',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Microsoft Office Professional Plus 2010',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '17/04/2012',
                NO_REMOVE        => undef,
                GUID             => '{90140000-0011-0000-0000-0000000FF1CE}',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => undef,
                URL_INFO_ABOUT   => undef,
                VERSION_MAJOR    => undef,
                VERSION          => '14.0.6029.1000',
                UNINSTALL_STRING => undef,
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Step By Step Interactive Training (KB923723)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '23/08/2007',
                NO_REMOVE        => undef,
                GUID             => 'KB923723',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => 'http://support.microsoft.com/kb/923723',
                URL_INFO_ABOUT   => undef,
                VERSION_MAJOR    => undef,
                VERSION          => '20050502.101010',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows Internet Explorer 8 (KB2360131)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '18/10/2010',
                NO_REMOVE        => undef,
                GUID             => 'KB2360131-IE8',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=2360131',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Adobe Systems Incorporated',
                NAME             => 'Adobe Reader X (10.1.2)',
                VERSION_MINOR    => undef,
                COMMENTS         => '   ',
                INSTALLDATE      => '09/02/2012',
                NO_REMOVE        => undef,
                GUID             => '{AC76BA86-7AD7-1033-7B44-AA1000000001}',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => undef,
                URL_INFO_ABOUT   => 'http://www.adobe.com',
                VERSION_MAJOR    => undef,
                VERSION          => '10.1.2',
                UNINSTALL_STRING => undef,
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows Internet Explorer 8 (KB971961)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '10/11/2009',
                NO_REMOVE        => undef,
                GUID             => 'KB971961-IE8',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=971961',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB960225)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '02/04/2009',
                NO_REMOVE        => undef,
                GUID             => 'KB960225',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=960225',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB2229593)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '19/07/2010',
                NO_REMOVE        => undef,
                GUID             => 'KB2229593',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=2229593',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows Internet Explorer 8 (KB974455)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '09/11/2009',
                NO_REMOVE        => undef,
                GUID             => 'KB974455-IE8',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=974455',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB2507618)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '18/04/2011',
                NO_REMOVE        => undef,
                GUID             => 'KB2507618',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=2507618',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Microsoft .NET Framework 4 Client Profile (KB2539636)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => undef,
                NO_REMOVE        => undef,
                GUID             => '{3C3901C5-3455-3E0A-A214-0B093A5070A6}.KB2539636',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com/kb/2539636',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => 'C:\\windows\\Microsoft.NET\\Framework\\v4.0.30319\\SetupCache\\Client\\setup.exe /uninstallpatch {7E97AB83-C1FE-38DE-B848-877E0A4BD81E} /parameterfolder Client',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows Internet Explorer 8 (KB981332)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '19/04/2010',
                NO_REMOVE        => undef,
                GUID             => 'KB981332-IE8',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=981332',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB980232)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '19/04/2010',
                NO_REMOVE        => undef,
                GUID             => 'KB980232',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=980232',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB2393802)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '14/02/2011',
                NO_REMOVE        => undef,
                GUID             => 'KB2393802',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=2393802',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB2485663)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '18/04/2011',
                NO_REMOVE        => undef,
                GUID             => 'KB2485663',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=2485663',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB2286198)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '09/08/2010',
                NO_REMOVE        => undef,
                GUID             => 'KB2286198',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=2286198',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB974318)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '14/12/2009',
                NO_REMOVE        => undef,
                GUID             => 'KB974318',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=974318',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB974571)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '09/11/2009',
                NO_REMOVE        => undef,
                GUID             => 'KB974571',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=974571',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB978037)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '15/02/2010',
                NO_REMOVE        => undef,
                GUID             => 'KB978037',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=978037',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => undef,
                NAME             => 'OSSEC HIDS 2.5.1',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => undef,
                NO_REMOVE        => undef,
                GUID             => 'OSSEC',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => 'http://www.ossec.net/main/support/',
                URL_INFO_ABOUT   => 'http://www.ossec.net',
                VERSION_MAJOR    => undef,
                VERSION          => '2.5.1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB951748)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '09/07/2008',
                NO_REMOVE        => 1,
                GUID             => 'KB951748',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=951748',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows Media Player (KB911564)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '05/04/2006',
                NO_REMOVE        => undef,
                GUID             => 'KB911564',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => 'http://support.microsoft.com/?kbid=911564',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => undef,
                UNINSTALL_STRING => undef,
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => undef,
                NAME             => 'GPL Ghostscript 8.54',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => undef,
                NO_REMOVE        => undef,
                GUID             => 'GPL Ghostscript 8.54',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => undef,
                URL_INFO_ABOUT   => undef,
                VERSION_MAJOR    => undef,
                VERSION          => undef,
                UNINSTALL_STRING => 'C:\\gs\\uninstgs.exe \\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Sun Microsystems, Inc.',
                NAME             => 'Java Auto Updater',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '20/02/2012',
                NO_REMOVE        => 1,
                GUID             => '{4A03706F-666A-4037-7777-5F2748764D10}',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => undef,
                URL_INFO_ABOUT   => undef,
                VERSION_MAJOR    => undef,
                VERSION          => '2.0.7.1',
                UNINSTALL_STRING => undef,
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB2660465)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '21/02/2012',
                NO_REMOVE        => undef,
                GUID             => 'KB2660465',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=2660465',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows Media Player 6.4 (KB925398)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '13/12/2006',
                NO_REMOVE        => undef,
                GUID             => 'KB925398_WMP64',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com/?kbid=925398',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => undef,
                UNINSTALL_STRING => undef,
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB956844)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '09/11/2009',
                NO_REMOVE        => undef,
                GUID             => 'KB956844',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=956844',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB2483614)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '28/03/2011',
                NO_REMOVE        => undef,
                GUID             => 'KB2483614',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=2483614',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Update for Microsoft .NET Framework 3.5 SP1 (KB963707)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => undef,
                NO_REMOVE        => undef,
                GUID             => '{CE2CDD62-0124-36CA-84D3-9F4DCF5C5BD9}.KB963707',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Update',
                HELPLINK         => 'http://support.microsoft.com/kb/963707',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => 'C:\\WINDOWS\\system32\\msiexec.exe /package {CE2CDD62-0124-36CA-84D3-9F4DCF5C5BD9} /uninstall {B2AE9C82-DC7B-3641-BFC8-87275C4F3607} /qb+ REBOOTPROMPT=\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB954600)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '15/01/2009',
                NO_REMOVE        => undef,
                GUID             => 'KB954600',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=954600',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB978251)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '15/02/2010',
                NO_REMOVE        => undef,
                GUID             => 'KB978251',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=978251',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => undef,
                NAME             => 'Microsoft .NET Framework 1.1',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => undef,
                NO_REMOVE        => undef,
                GUID             => 'Microsoft .NET Framework 1.1  (1033)',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => undef,
                URL_INFO_ABOUT   => undef,
                VERSION_MAJOR    => undef,
                VERSION          => undef,
                UNINSTALL_STRING => 'msiexec.exe /X {CB2F7EDD-9D1F-43C1-90FC-4F52EAE172A1}',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft',
                NAME             => 'Update for Microsoft Excel 2010 (KB2553439) 32-Bit Edition',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => undef,
                NO_REMOVE        => 0,
                GUID             => '{90140000-0011-0000-0000-0000000FF1CE}_Office14.PROPLUS_{3D1F379C-AA64-4823-90A4-A8DDD4B48C21}',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => 'http://support.microsoft.com/kb/2553439',
                URL_INFO_ABOUT   => 'http://support.microsoft.com/kb/2553439',
                VERSION_MAJOR    => undef,
                VERSION          => undef,
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'WebFldrs XP',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '05/04/2006',
                NO_REMOVE        => 1,
                GUID             => '{350C97B0-3D7C-4EE8-BAA9-00BCB3D54227}',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => undef,
                URL_INFO_ABOUT   => undef,
                VERSION_MAJOR    => undef,
                VERSION          => '9.50.7523',
                UNINSTALL_STRING => undef,
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft',
                NAME             => 'Update for Microsoft Outlook Social Connector 2010 (KB2553406) 32-Bit Edition',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => undef,
                NO_REMOVE        => 0,
                GUID             => '{90140000-001A-0409-0000-0000000FF1CE}_Office14.PROPLUS_{1EEFF749-6F29-4F0B-AB08-4C6EA52AA110}',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => 'http://support.microsoft.com/kb/2553406',
                URL_INFO_ABOUT   => 'http://support.microsoft.com/kb/2553406',
                VERSION_MAJOR    => undef,
                VERSION          => undef,
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft',
                NAME             => 'Update for Microsoft Office 2010 (KB2553267) 32-Bit Edition',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => undef,
                NO_REMOVE        => 0,
                GUID             => '{90140000-0011-0000-0000-0000000FF1CE}_Office14.PROPLUS_{18B3CF2A-73F7-4716-B1AE-86D68726D408}',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => 'http://support.microsoft.com/kb/2553267',
                URL_INFO_ABOUT   => 'http://support.microsoft.com/kb/2553267',
                VERSION_MAJOR    => undef,
                VERSION          => undef,
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Update for Windows Internet Explorer 8 (KB2447568)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '28/03/2011',
                NO_REMOVE        => undef,
                GUID             => 'KB2447568-IE8',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=2447568',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB2639417)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '20/12/2011',
                NO_REMOVE        => undef,
                GUID             => 'KB2639417',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=2639417',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => undef,
                NAME             => 'PCHealth',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => undef,
                NO_REMOVE        => undef,
                GUID             => 'PCHealth',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => undef,
                URL_INFO_ABOUT   => undef,
                VERSION_MAJOR    => undef,
                VERSION          => undef,
                UNINSTALL_STRING => 'rundll32.exe setupapi.dll,InstallHinfSection DefaultUninstall 132 C:\\WINDOWS\\INF\\PCHealth.inf',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'ScriptLogic Corporation',
                NAME             => 'Privilege Authority Client',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '09/02/2012',
                NO_REMOVE        => undef,
                GUID             => '{41BDFA12-0E3D-4AA4-ACBC-CF64E1AE18FF}',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => undef,
                URL_INFO_ABOUT   => 'http://www.scriptlogic.com',
                VERSION_MAJOR    => undef,
                VERSION          => '2.7.1.80',
                UNINSTALL_STRING => undef,
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Proxy Networks, Inc.',
                NAME             => 'PROXY Pro Master',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '11/12/2009',
                NO_REMOVE        => undef,
                GUID             => '{1AE60321-BFC1-43F3-95D6-B03C420AF04D}',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => undef,
                URL_INFO_ABOUT   => 'http://www.proxynetworks.com',
                VERSION_MAJOR    => undef,
                VERSION          => '7.0.1515',
                UNINSTALL_STRING => undef,
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB956802)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '15/01/2009',
                NO_REMOVE        => undef,
                GUID             => 'KB956802',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=956802',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB975560)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '15/02/2010',
                NO_REMOVE        => undef,
                GUID             => 'KB975560',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=975560',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows Internet Explorer 8 (KB2675157)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '17/04/2012',
                NO_REMOVE        => undef,
                GUID             => 'KB2675157-IE8',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=2675157',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Update for Windows XP (KB968389)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '03/09/2009',
                NO_REMOVE        => undef,
                GUID             => 'KB968389',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=968389',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft',
                NAME             => 'Update for Microsoft Office 2010 (KB2596964) 32-Bit Edition',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => undef,
                NO_REMOVE        => 0,
                GUID             => '{90140000-0011-0000-0000-0000000FF1CE}_Office14.PROPLUS_{ED31DE9A-3E13-4E2C-9106-E0D8AFFB9FA6}',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => 'http://support.microsoft.com/kb/2596964',
                URL_INFO_ABOUT   => 'http://support.microsoft.com/kb/2596964',
                VERSION_MAJOR    => undef,
                VERSION          => undef,
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Update for Windows XP (KB955839)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '15/01/2009',
                NO_REMOVE        => undef,
                GUID             => 'KB955839',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=955839',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft',
                NAME             => 'Security Update for Microsoft Office 2010 (KB2589320) 32-Bit Edition',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => undef,
                NO_REMOVE        => 0,
                GUID             => '{90140000-0011-0000-0000-0000000FF1CE}_Office14.PROPLUS_{DCE6D0BF-93E4-46C5-9A7C-F1EFF9707C02}',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => 'http://support.microsoft.com/kb/2589320',
                URL_INFO_ABOUT   => 'http://support.microsoft.com/kb/2589320',
                VERSION_MAJOR    => undef,
                VERSION          => undef,
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Update for Windows XP (KB2264107)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '09/08/2011',
                NO_REMOVE        => undef,
                GUID             => 'KB2264107',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=2264107',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB953838)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '09/07/2008',
                NO_REMOVE        => 1,
                GUID             => 'KB953838',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=953838',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Microsoft .NET Framework 2.0 Service Pack 2',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '17/04/2012',
                NO_REMOVE        => undef,
                GUID             => '{C09FB3CD-3D0C-3F2D-899A-6A1D67F2073F}',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => undef,
                URL_INFO_ABOUT   => undef,
                VERSION_MAJOR    => undef,
                VERSION          => '2.2.30729',
                UNINSTALL_STRING => undef,
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB978601)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '19/04/2010',
                NO_REMOVE        => undef,
                GUID             => 'KB978601',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=978601',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft',
                NAME             => 'Microsoft Office 2010 Service Pack 1 (SP1)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => undef,
                NO_REMOVE        => 0,
                GUID             => '{90140000-001B-0409-0000-0000000FF1CE}_Office14.PROPLUS_{6BD185A0-E67F-4F77-8BCD-E34EA6AE76DF}',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => 'http://support.microsoft.com/kb/2460049',
                URL_INFO_ABOUT   => 'http://support.microsoft.com/kb/2460049',
                VERSION_MAJOR    => undef,
                VERSION          => undef,
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB2536276-v2)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '16/08/2011',
                NO_REMOVE        => undef,
                GUID             => 'KB2536276-v2',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=2536276',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '2',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB956841)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '31/10/2008',
                NO_REMOVE        => undef,
                GUID             => 'KB956841',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=956841',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB2479628)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '14/02/2011',
                NO_REMOVE        => undef,
                GUID             => 'KB2479628',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=2479628',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Windows Presentation Foundation',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '10/04/2008',
                NO_REMOVE        => undef,
                GUID             => '{BAF78226-3200-4DB4-BE33-4D922A799840}',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => undef,
                URL_INFO_ABOUT   => undef,
                VERSION_MAJOR    => undef,
                VERSION          => '3.0.6920.0',
                UNINSTALL_STRING => undef,
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows Media Player (KB968816)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '09/11/2009',
                NO_REMOVE        => undef,
                GUID             => 'KB968816_WM9',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => 'http://support.microsoft.com/?kbid=968816',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => undef,
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB978338)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '19/04/2010',
                NO_REMOVE        => undef,
                GUID             => 'KB978338',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=978338',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Microsoft .NET Framework 4 Client Profile',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '17/04/2012',
                NO_REMOVE        => undef,
                GUID             => '{3C3901C5-3455-3E0A-A214-0B093A5070A6}',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => undef,
                URL_INFO_ABOUT   => 'http://go.microsoft.com/fwlink/?LinkId=164164',
                VERSION_MAJOR    => undef,
                VERSION          => '4.0.30319',
                UNINSTALL_STRING => undef,
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => undef,
                NAME             => 'QT Lite 4.1.0',
                VERSION_MINOR    => 1,
                COMMENTS         => undef,
                INSTALLDATE      => '23/11/2011',
                NO_REMOVE        => undef,
                GUID             => 'quicktime_lite_is1',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => undef,
                URL_INFO_ABOUT   => undef,
                VERSION_MAJOR    => 4,
                VERSION          => '4.1.0',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB973354)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '03/09/2009',
                NO_REMOVE        => undef,
                GUID             => 'KB973354',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=973354',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Update for Windows XP (KB2616676-v2)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '27/09/2011',
                NO_REMOVE        => undef,
                GUID             => 'KB2616676-v2',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=2616676',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '2',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB2535512)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '21/06/2011',
                NO_REMOVE        => undef,
                GUID             => 'KB2535512',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=2535512',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Update for Microsoft .NET Framework 4 Client Profile (KB2473228)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => undef,
                NO_REMOVE        => undef,
                GUID             => '{3C3901C5-3455-3E0A-A214-0B093A5070A6}.KB2473228',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Update',
                HELPLINK         => 'http://support.microsoft.com/kb/2473228',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => 'C:\\windows\\Microsoft.NET\\Framework\\v4.0.30319\\SetupCache\\Client\\setup.exe /uninstallpatch {FD988F49-E1C8-3C84-9683-0448B6BB8E20} /parameterfolder Client',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows Media Player 10 (KB911565)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '05/04/2006',
                NO_REMOVE        => undef,
                GUID             => 'KB911565',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => 'http://support.microsoft.com/?kbid=911565',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => undef,
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft',
                NAME             => 'Microsoft Office 2010 Service Pack 1 (SP1)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => undef,
                NO_REMOVE        => 0,
                GUID             => '{90140000-00BA-0409-0000-0000000FF1CE}_Office14.PROPLUS_{6BD185A0-E67F-4F77-8BCD-E34EA6AE76DF}',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => 'http://support.microsoft.com/kb/2460049',
                URL_INFO_ABOUT   => 'http://support.microsoft.com/kb/2460049',
                VERSION_MAJOR    => undef,
                VERSION          => undef,
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'O&O Software GmbH',
                NAME             => 'O&O Defrag Workstation',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '30/04/2011',
                NO_REMOVE        => undef,
                GUID             => '{C6DC78B1-C060-4621-8140-226380141AA1}',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => undef,
                URL_INFO_ABOUT   => 'http://www.oo-software.com',
                VERSION_MAJOR    => undef,
                VERSION          => '11.5.4065',
                UNINSTALL_STRING => undef,
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB2419632)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '17/01/2011',
                NO_REMOVE        => undef,
                GUID             => 'KB2419632',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=2419632',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB957095)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '31/10/2008',
                NO_REMOVE        => undef,
                GUID             => 'KB957095',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=957095',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Hotfix for Windows XP (KB961118)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '18/05/2009',
                NO_REMOVE        => undef,
                GUID             => 'KB961118',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Hotfix',
                HELPLINK         => 'http://support.microsoft.com?kbid=961118',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows Media Player 10 (KB936782)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '23/09/2007',
                NO_REMOVE        => undef,
                GUID             => 'KB936782_WMP10',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => 'http://support.microsoft.com/?kbid=936782',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => undef,
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Hotfix for Windows XP (KB2158563)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '22/11/2010',
                NO_REMOVE        => undef,
                GUID             => 'KB2158563',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Hotfix',
                HELPLINK         => 'http://support.microsoft.com?kbid=2158563',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'MSXML 4.0 SP2 (KB954430)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '14/12/2009',
                NO_REMOVE        => undef,
                GUID             => '{86493ADD-824D-4B8E-BD72-8C5DCDC52A71}',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => undef,
                URL_INFO_ABOUT   => undef,
                VERSION_MAJOR    => undef,
                VERSION          => '4.20.9870.0',
                UNINSTALL_STRING => undef,
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB950760)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '10/04/2008',
                NO_REMOVE        => undef,
                GUID             => 'KB950760',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=950760',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft',
                NAME             => 'Update for Microsoft Office 2010 (KB2553181) 32-Bit Edition',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => undef,
                NO_REMOVE        => 0,
                GUID             => '{90140000-0011-0000-0000-0000000FF1CE}_Office14.PROPLUS_{48E1B6C2-7299-4F3F-AA63-42F0ACE55AA4}',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => 'http://support.microsoft.com/kb/2553181',
                URL_INFO_ABOUT   => 'http://support.microsoft.com/kb/2553181',
                VERSION_MAJOR    => undef,
                VERSION          => undef,
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB979683)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '19/04/2010',
                NO_REMOVE        => undef,
                GUID             => 'KB979683',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=979683',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Microsoft .NET Framework 3.5 SP1 (KB2657424)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => undef,
                NO_REMOVE        => undef,
                GUID             => '{CE2CDD62-0124-36CA-84D3-9F4DCF5C5BD9}.KB2657424',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com/kb/2657424',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => 'C:\\windows\\system32\\msiexec.exe /package {CE2CDD62-0124-36CA-84D3-9F4DCF5C5BD9} /uninstall {F6F5AC31-9833-3E77-AC8E-8E910CAB39AE} /qb+ REBOOTPROMPT=\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB2079403)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '16/08/2010',
                NO_REMOVE        => undef,
                GUID             => 'KB2079403',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=2079403',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft',
                NAME             => 'Security Update for Microsoft Visio Viewer 2010 (KB2597170) 32-Bit Edition',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => undef,
                NO_REMOVE        => 0,
                GUID             => '{90140000-0011-0000-0000-0000000FF1CE}_Office14.PROPLUS_{011FE2F6-5427-4EC9-AE80-6B28E69781C1}',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => 'http://support.microsoft.com/kb/2597170',
                URL_INFO_ABOUT   => 'http://support.microsoft.com/kb/2597170',
                VERSION_MAJOR    => undef,
                VERSION          => undef,
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Microsoft .NET Framework 4 Client Profile (KB2572078)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => undef,
                NO_REMOVE        => undef,
                GUID             => '{3C3901C5-3455-3E0A-A214-0B093A5070A6}.KB2572078',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com/kb/2572078',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => 'C:\\windows\\Microsoft.NET\\Framework\\v4.0.30319\\SetupCache\\Client\\setup.exe /uninstallpatch {DB31DEDD-BF95-31E7-A9B7-5480561CEFF3} /parameterfolder Client',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows Internet Explorer 8 (KB2544521)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '21/06/2011',
                NO_REMOVE        => undef,
                GUID             => 'KB2544521-IE8',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=2544521',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Microsoft Office PowerPoint MUI (English) 2010',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '04/10/2011',
                NO_REMOVE        => undef,
                GUID             => '{90140000-0018-0409-0000-0000000FF1CE}',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => undef,
                URL_INFO_ABOUT   => undef,
                VERSION_MAJOR    => undef,
                VERSION          => '14.0.6029.1000',
                UNINSTALL_STRING => undef,
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB975562)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '14/06/2010',
                NO_REMOVE        => undef,
                GUID             => 'KB975562',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=975562',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Hummingbird Ltd.',
                NAME             => 'Hummingbird Exceed 2006',
                VERSION_MINOR    => undef,
                COMMENTS         => 'Exceed 2006 Setup for Windows Installer',
                INSTALLDATE      => '23/08/2007',
                NO_REMOVE        => undef,
                GUID             => '{35DFFE62-9F48-4236-9249-9EAB5C7123C9}',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => undef,
                URL_INFO_ABOUT   => 'http://www.hummingbird.com',
                VERSION_MAJOR    => undef,
                VERSION          => '11.0.28.0',
                UNINSTALL_STRING => undef,
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for CAPICOM (KB931906)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '03/09/2009',
                NO_REMOVE        => undef,
                GUID             => '{0EFDF2F9-836D-4EB7-A32D-038BD3F1FB2A}',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => undef,
                URL_INFO_ABOUT   => undef,
                VERSION_MAJOR    => undef,
                VERSION          => '2.1.0.2',
                UNINSTALL_STRING => undef,
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB2584146)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '17/01/2012',
                NO_REMOVE        => undef,
                GUID             => 'KB2584146',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=2584146',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB981997)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '16/08/2010',
                NO_REMOVE        => undef,
                GUID             => 'KB981997',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=981997',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB975713)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '15/02/2010',
                NO_REMOVE        => undef,
                GUID             => 'KB975713',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=975713',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => undef,
                NAME             => 'Windows Media Player 10',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => undef,
                NO_REMOVE        => undef,
                GUID             => 'Windows Media Player',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => undef,
                URL_INFO_ABOUT   => undef,
                VERSION_MAJOR    => undef,
                VERSION          => undef,
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft',
                NAME             => 'PDFCREATOR1.2.1XP',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '12/07/2011',
                NO_REMOVE        => undef,
                GUID             => '{5D6991B6-0406-4518-9A6E-3DBBF760BB1B}',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => undef,
                URL_INFO_ABOUT   => undef,
                VERSION_MAJOR    => undef,
                VERSION          => '1.2.1.0',
                UNINSTALL_STRING => undef,
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB981322)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '20/09/2010',
                NO_REMOVE        => undef,
                GUID             => 'KB981322',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=981322',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Windows Genuine Advantage Notifications (KB905474)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '16/06/2006',
                NO_REMOVE        => 1,
                GUID             => 'WgaNotify',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => 'http://support.microsoft.com?kbid=905474',
                URL_INFO_ABOUT   => 'http://www.microsoft.com/genuine',
                VERSION_MAJOR    => undef,
                VERSION          => '1.5.0554.0',
                UNINSTALL_STRING => undef,
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB956390)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '31/10/2008',
                NO_REMOVE        => undef,
                GUID             => 'KB956390',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=956390',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB953839)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '09/07/2008',
                NO_REMOVE        => undef,
                GUID             => 'KB953839',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=953839',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB973525)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '09/11/2009',
                NO_REMOVE        => undef,
                GUID             => 'KB973525',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=973525',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB2524375)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '28/03/2011',
                NO_REMOVE        => undef,
                GUID             => 'KB2524375',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=2524375',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB974455)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '09/11/2009',
                NO_REMOVE        => undef,
                GUID             => 'KB974455',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=974455',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Oracle',
                NAME             => 'Java(TM) 6 Update 31',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '20/02/2012',
                NO_REMOVE        => undef,
                GUID             => '{26A24AE4-039D-4CA4-87B4-2F83216031FF}',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => undef,
                URL_INFO_ABOUT   => 'http://java.com',
                VERSION_MAJOR    => undef,
                VERSION          => '6.0.310',
                UNINSTALL_STRING => undef,
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => undef,
                NAME             => 'FF&TB 1.5 + Plugins1',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => undef,
                NO_REMOVE        => undef,
                GUID             => 'FF&TB 1.5 + Plugins1',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => undef,
                URL_INFO_ABOUT   => undef,
                VERSION_MAJOR    => undef,
                VERSION          => undef,
                UNINSTALL_STRING => 'C:\\DOCUME~1\\ALLUSE~1\\APPLIC~1\\Symantec\\Ghost\\AUTOIN~1\\INSTAL~1\\~0000.exe cfg=\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => undef,
                NAME             => 'NLSDownlevelMapping',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => undef,
                NO_REMOVE        => undef,
                GUID             => 'NLSDownlevelMapping',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => undef,
                URL_INFO_ABOUT   => undef,
                VERSION_MAJOR    => undef,
                VERSION          => undef,
                UNINSTALL_STRING => undef,
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Hotfix for Windows XP (KB976098-v2)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '01/02/2010',
                NO_REMOVE        => undef,
                GUID             => 'KB976098-v2',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Hotfix',
                HELPLINK         => 'http://support.microsoft.com?kbid=976098',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '2',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => undef,
                NAME             => 'PDFTK Builder 2.3',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => undef,
                NO_REMOVE        => undef,
                GUID             => 'PDFTK Builder_is1',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => undef,
                URL_INFO_ABOUT   => undef,
                VERSION_MAJOR    => undef,
                VERSION          => undef,
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft',
                NAME             => 'Update for Microsoft OneNote 2010 (KB2553290) 32-Bit Edition',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => undef,
                NO_REMOVE        => 0,
                GUID             => '{90140000-0011-0000-0000-0000000FF1CE}_Office14.PROPLUS_{BEBC2484-290C-46AD-9834-6DAD1FA80273}',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => 'http://support.microsoft.com/kb/2553290',
                URL_INFO_ABOUT   => 'http://support.microsoft.com/kb/2553290',
                VERSION_MAJOR    => undef,
                VERSION          => undef,
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows Internet Explorer 8 (KB2559049)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '16/08/2011',
                NO_REMOVE        => undef,
                GUID             => 'KB2559049-IE8',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=2559049',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB951698)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '09/07/2008',
                NO_REMOVE        => 1,
                GUID             => 'KB951698',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=951698',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'MSXML 6.0 Parser (KB933579)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '10/04/2008',
                NO_REMOVE        => undef,
                GUID             => '{0A869A65-8C94-4F7C-A5C7-972D3C8CED9E}',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => undef,
                URL_INFO_ABOUT   => undef,
                VERSION_MAJOR    => undef,
                VERSION          => '6.10.1200.0',
                UNINSTALL_STRING => undef,
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Symantec Corporation',
                NAME             => 'Symantec Backup Exec Remote Agent for Windows Systems',
                VERSION_MINOR    => undef,
                COMMENTS         => 'Symantec Backup Exec Remote Agent for Windows Systems 32-bit',
                INSTALLDATE      => '10/12/2009',
                NO_REMOVE        => undef,
                GUID             => '{F72C6003-60EF-448D-AC89-0B69C97678DC}',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => undef,
                URL_INFO_ABOUT   => 'http://www.symantec.com',
                VERSION_MAJOR    => undef,
                VERSION          => '11.0.6235',
                UNINSTALL_STRING => undef,
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft',
                NAME             => 'Security Update for Microsoft PowerPoint 2010 (KB2553185) 32-Bit Edition',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => undef,
                NO_REMOVE        => 0,
                GUID             => '{90140000-0011-0000-0000-0000000FF1CE}_Office14.PROPLUS_{61461470-8168-4F4B-97B7-617AF354F028}',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => 'http://support.microsoft.com/kb/2553185',
                URL_INFO_ABOUT   => 'http://support.microsoft.com/kb/2553185',
                VERSION_MAJOR    => undef,
                VERSION          => undef,
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'O&O Software GmbH',
                NAME             => 'O&O DriveLED Workstation',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '23/02/2011',
                NO_REMOVE        => undef,
                GUID             => '{98166E4E-CB20-4039-AD27-DF0BFA772352}',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => undef,
                URL_INFO_ABOUT   => 'http://www.oo-software.com',
                VERSION_MAJOR    => undef,
                VERSION          => '4.1.119',
                UNINSTALL_STRING => undef,
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => undef,
                NAME             => 'GPL Ghostscript Fonts',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => undef,
                NO_REMOVE        => undef,
                GUID             => 'GPL Ghostscript Fonts',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => undef,
                URL_INFO_ABOUT   => undef,
                VERSION_MAJOR    => undef,
                VERSION          => undef,
                UNINSTALL_STRING => 'C:\\gs\\uninstgs.exe \\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB979309)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '19/04/2010',
                NO_REMOVE        => undef,
                GUID             => 'KB979309',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=979309',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Microsoft Software Update for Web Folders  (English) 14',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '04/10/2011',
                NO_REMOVE        => 1,
                GUID             => '{90140000-0010-0409-0000-0000000FF1CE}',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => undef,
                URL_INFO_ABOUT   => undef,
                VERSION_MAJOR    => undef,
                VERSION          => '14.0.6029.1000',
                UNINSTALL_STRING => undef,
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => undef,
                NAME             => 'K-Lite Codec Pack 7.1.0 (Standard)',
                VERSION_MINOR    => 1,
                COMMENTS         => undef,
                INSTALLDATE      => '23/11/2011',
                NO_REMOVE        => undef,
                GUID             => 'KLiteCodecPack_is1',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => undef,
                URL_INFO_ABOUT   => undef,
                VERSION_MAJOR    => 7,
                VERSION          => '7.1.0',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Microsoft Office OneNote MUI (English) 2010',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '15/11/2011',
                NO_REMOVE        => undef,
                GUID             => '{90140000-00A1-0409-0000-0000000FF1CE}',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => undef,
                URL_INFO_ABOUT   => undef,
                VERSION_MAJOR    => undef,
                VERSION          => '14.0.6029.1000',
                UNINSTALL_STRING => undef,
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft',
                NAME             => 'Update for Microsoft Outlook 2010 (KB2553248) 32-Bit Edition',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => undef,
                NO_REMOVE        => 0,
                GUID             => '{90140000-001A-0409-0000-0000000FF1CE}_Office14.PROPLUS_{5EBDE1DE-3B28-4134-AB00-85CFF2B4F94D}',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => 'http://support.microsoft.com/kb/2553248',
                URL_INFO_ABOUT   => 'http://support.microsoft.com/kb/2553248',
                VERSION_MAJOR    => undef,
                VERSION          => undef,
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB971961)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '09/11/2009',
                NO_REMOVE        => undef,
                GUID             => 'KB971961',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=971961',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Windows Media Player 10 Hotfix - KB888656',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '05/04/2006',
                NO_REMOVE        => undef,
                GUID             => 'KB888656',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => 'http://support.microsoft.com?kbid=888656',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => undef,
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB982214)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '16/08/2010',
                NO_REMOVE        => undef,
                GUID             => 'KB982214',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=982214',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Windows Management Framework Core',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '01/02/2010',
                NO_REMOVE        => undef,
                GUID             => 'KB968930',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Software Update',
                HELPLINK         => 'http://go.microsoft.com/fwlink/?LinkID=163790',
                URL_INFO_ABOUT   => 'http://go.microsoft.com/fwlink/?LinkID=163792',
                VERSION_MAJOR    => undef,
                VERSION          => undef,
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB2121546)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '20/09/2010',
                NO_REMOVE        => undef,
                GUID             => 'KB2121546',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=2121546',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Microsoft .NET Framework 4 Client Profile (KB2633870)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => undef,
                NO_REMOVE        => undef,
                GUID             => '{3C3901C5-3455-3E0A-A214-0B093A5070A6}.KB2633870',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com/kb/2633870',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => 'C:\\windows\\Microsoft.NET\\Framework\\v4.0.30319\\SetupCache\\Client\\setup.exe /uninstallpatch {8DDEFC7E-0C61-3D11-AFC6-5414F2DAFD01} /parameterfolder Client',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Hotfix for Windows XP (KB979306)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '05/04/2010',
                NO_REMOVE        => undef,
                GUID             => 'KB979306',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Hotfix',
                HELPLINK         => 'http://support.microsoft.com?kbid=979306',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Update for Windows XP (KB971737)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '14/12/2009',
                NO_REMOVE        => undef,
                GUID             => 'KB971737',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=971737',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft',
                NAME             => 'Update for Microsoft Office 2010 (KB2566458)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => undef,
                NO_REMOVE        => 0,
                GUID             => '{90140000-0011-0000-0000-0000000FF1CE}_Office14.PROPLUS_{EFB525A0-E1C0-4E32-9968-FE401BC87363}',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => 'http://support.microsoft.com/kb/2566458',
                URL_INFO_ABOUT   => 'http://support.microsoft.com/kb/2566458',
                VERSION_MAJOR    => undef,
                VERSION          => undef,
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft',
                NAME             => 'Microsoft Office 2010 Service Pack 1 (SP1)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => undef,
                NO_REMOVE        => 0,
                GUID             => '{90140000-0117-0409-0000-0000000FF1CE}_Office14.PROPLUS_{6BD185A0-E67F-4F77-8BCD-E34EA6AE76DF}',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => 'http://support.microsoft.com/kb/2460049',
                URL_INFO_ABOUT   => 'http://support.microsoft.com/kb/2460049',
                VERSION_MAJOR    => undef,
                VERSION          => undef,
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB971468)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '15/02/2010',
                NO_REMOVE        => undef,
                GUID             => 'KB971468',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=971468',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB950974)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '09/07/2008',
                NO_REMOVE        => 1,
                GUID             => 'KB950974',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=950974',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB2440591)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '20/12/2010',
                NO_REMOVE        => undef,
                GUID             => 'KB2440591',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=2440591',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'LogMeIn Inc.',
                NAME             => 'Network Console',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => undef,
                NO_REMOVE        => undef,
                GUID             => 'Network Console',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => 'http://www.logmein.com',
                URL_INFO_ABOUT   => 'http://www.logmein.com',
                VERSION_MAJOR    => undef,
                VERSION          => '9.00.175',
                UNINSTALL_STRING => 'C:\\Program Files\\Network Console\\NetworkConsole.exe uninstall /I{5B21BB9A-E23E-472b-AD2A-FB9B06A4727C}',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'FusionInventory Team',
                NAME             => 'FusionInventory Agent',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => undef,
                NO_REMOVE        => undef,
                GUID             => 'FusionInventory Agent',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => undef,
                URL_INFO_ABOUT   => 'http://www.FusionInventory.org',
                VERSION_MAJOR    => undef,
                VERSION          => '2.2.0-2',
                UNINSTALL_STRING => 'C:\\Program Files\\FusionInventory-Agent\\uninstFI.exe',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB982132)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '18/10/2010',
                NO_REMOVE        => undef,
                GUID             => 'KB982132',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=982132',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => undef,
                NAME             => 'Branding',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => undef,
                NO_REMOVE        => undef,
                GUID             => 'Branding',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => undef,
                URL_INFO_ABOUT   => undef,
                VERSION_MAJOR    => undef,
                VERSION          => undef,
                UNINSTALL_STRING => undef,
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft',
                NAME             => 'Security Update for Microsoft Office 2010 (KB2553096)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => undef,
                NO_REMOVE        => 0,
                GUID             => '{90140000-0011-0000-0000-0000000FF1CE}_Office14.PROPLUS_{10802A6D-EDBF-4383-BCBD-9D5B32F56D35}',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => 'http://support.microsoft.com/kb/2553096',
                URL_INFO_ABOUT   => 'http://support.microsoft.com/kb/2553096',
                VERSION_MAJOR    => undef,
                VERSION          => undef,
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB973904)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '14/12/2009',
                NO_REMOVE        => undef,
                GUID             => 'KB973904',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=973904',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Microsoft Office Proofing (English) 2010',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '04/10/2011',
                NO_REMOVE        => undef,
                GUID             => '{90140000-002C-0409-0000-0000000FF1CE}',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => undef,
                URL_INFO_ABOUT   => undef,
                VERSION_MAJOR    => undef,
                VERSION          => '14.0.6029.1000',
                UNINSTALL_STRING => undef,
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Update for Windows Internet Explorer 8 (KB976749)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '10/11/2009',
                NO_REMOVE        => undef,
                GUID             => 'KB976749-IE8',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=976749',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB975025)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '09/11/2009',
                NO_REMOVE        => undef,
                GUID             => 'KB975025',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=975025',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Microsoft Visual C++ 2005 Redistributable',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '29/11/2011',
                NO_REMOVE        => undef,
                GUID             => '{710f4c1c-cc18-4c49-8cbf-51240c89a1a2}',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => undef,
                URL_INFO_ABOUT   => undef,
                VERSION_MAJOR    => undef,
                VERSION          => '8.0.61001',
                UNINSTALL_STRING => undef,
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB2592799)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '18/10/2011',
                NO_REMOVE        => undef,
                GUID             => 'KB2592799',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=2592799',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft',
                NAME             => 'Microsoft .NET Framework 1.1',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '17/04/2012',
                NO_REMOVE        => undef,
                GUID             => '{CB2F7EDD-9D1F-43C1-90FC-4F52EAE172A1}',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => undef,
                URL_INFO_ABOUT   => undef,
                VERSION_MAJOR    => undef,
                VERSION          => '1.1.4322',
                UNINSTALL_STRING => undef,
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Microsoft Office Proof (English) 2010',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '20/12/2011',
                NO_REMOVE        => undef,
                GUID             => '{90140000-001F-0409-0000-0000000FF1CE}',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => undef,
                URL_INFO_ABOUT   => undef,
                VERSION_MAJOR    => undef,
                VERSION          => '14.0.6029.1000',
                UNINSTALL_STRING => undef,
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows Internet Explorer 8 (KB2647516)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '21/02/2012',
                NO_REMOVE        => undef,
                GUID             => 'KB2647516-IE8',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=2647516',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft',
                NAME             => 'Microsoft Office 2010 Service Pack 1 (SP1)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => undef,
                NO_REMOVE        => 0,
                GUID             => '{90140000-002C-0409-0000-0000000FF1CE}_Office14.PROPLUS_{7CA93DF4-8902-449E-A42E-4C5923CFBDE3}',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => 'http://support.microsoft.com/kb/2460049',
                URL_INFO_ABOUT   => 'http://support.microsoft.com/kb/2460049',
                VERSION_MAJOR    => undef,
                VERSION          => undef,
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB971657)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '03/09/2009',
                NO_REMOVE        => undef,
                GUID             => 'KB971657',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=971657',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Hotfix for Microsoft .NET Framework 3.5 SP1 (KB958484)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => undef,
                NO_REMOVE        => undef,
                GUID             => '{CE2CDD62-0124-36CA-84D3-9F4DCF5C5BD9}.KB958484',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Hotfix',
                HELPLINK         => 'http://support.microsoft.com/kb/958484',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => 'C:\\windows\\system32\\msiexec.exe /package {CE2CDD62-0124-36CA-84D3-9F4DCF5C5BD9} /uninstall {A7EEA2F2-BFCD-4A54-A575-7B81A786E658} /qb+ REBOOTPROMPT=\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB980218)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '14/06/2010',
                NO_REMOVE        => undef,
                GUID             => 'KB980218',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=980218',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft',
                NAME             => 'Microsoft Office 2010 Service Pack 1 (SP1)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => undef,
                NO_REMOVE        => 0,
                GUID             => '{90140000-001F-040C-0000-0000000FF1CE}_Office14.PROPLUS_{46298F6A-1E7E-4D4A-B5F5-106A4F0E48C6}',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => 'http://support.microsoft.com/kb/2460049',
                URL_INFO_ABOUT   => 'http://support.microsoft.com/kb/2460049',
                VERSION_MAJOR    => undef,
                VERSION          => undef,
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB961501)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '09/07/2009',
                NO_REMOVE        => undef,
                GUID             => 'KB961501',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=961501',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Microsoft .NET Framework 4 Extended',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => undef,
                NO_REMOVE        => undef,
                GUID             => 'Microsoft .NET Framework 4 Extended',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => undef,
                URL_INFO_ABOUT   => 'http://go.microsoft.com/fwlink/?LinkId=164164',
                VERSION_MAJOR    => undef,
                VERSION          => '4.0.30319',
                UNINSTALL_STRING => 'C:\\windows\\Microsoft.NET\\Framework\\v4.0.30319\\SetupCache\\Extended\\Setup.exe /repair /x86 /parameterfolder Extended',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB2508429)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '18/04/2011',
                NO_REMOVE        => undef,
                GUID             => 'KB2508429',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=2508429',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB956391)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '31/10/2008',
                NO_REMOVE        => undef,
                GUID             => 'KB956391',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=956391',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Update for Windows XP (KB973815)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '03/09/2009',
                NO_REMOVE        => undef,
                GUID             => 'KB973815',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=973815',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB981852)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '16/08/2010',
                NO_REMOVE        => undef,
                GUID             => 'KB981852',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=981852',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB2570222)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '16/08/2011',
                NO_REMOVE        => undef,
                GUID             => 'KB2570222',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=2570222',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Update for Windows XP (KB2467659)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '20/12/2010',
                NO_REMOVE        => undef,
                GUID             => 'KB2467659',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=2467659',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows Media Player (KB952069)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '15/01/2009',
                NO_REMOVE        => undef,
                GUID             => 'KB952069_WM9',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => 'http://support.microsoft.com/?kbid=952069',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => undef,
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB2585542)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '17/01/2012',
                NO_REMOVE        => undef,
                GUID             => 'KB2585542',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=2585542',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft',
                NAME             => 'Microsoft Office 2010 Service Pack 1 (SP1)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => undef,
                NO_REMOVE        => 0,
                GUID             => '{90140000-006E-0409-0000-0000000FF1CE}_Office14.PROPLUS_{4560037C-E356-444A-A015-D21F487D809E}',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => 'http://support.microsoft.com/kb/2460049',
                URL_INFO_ABOUT   => 'http://support.microsoft.com/kb/2460049',
                VERSION_MAJOR    => undef,
                VERSION          => undef,
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft',
                NAME             => 'Microsoft Office 2010 Service Pack 1 (SP1)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => undef,
                NO_REMOVE        => 0,
                GUID             => '{90140000-0019-0409-0000-0000000FF1CE}_Office14.PROPLUS_{6BD185A0-E67F-4F77-8BCD-E34EA6AE76DF}',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => 'http://support.microsoft.com/kb/2460049',
                URL_INFO_ABOUT   => 'http://support.microsoft.com/kb/2460049',
                VERSION_MAJOR    => undef,
                VERSION          => undef,
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB2536276)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '21/06/2011',
                NO_REMOVE        => undef,
                GUID             => 'KB2536276',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=2536276',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB954459)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '15/01/2009',
                NO_REMOVE        => undef,
                GUID             => 'KB954459',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=954459',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Update for Windows Media Player 10 (KB912452)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '05/04/2006',
                NO_REMOVE        => undef,
                GUID             => 'KB912452',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => 'http://support.microsoft.com/?kbid=912452',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => undef,
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows Internet Explorer 8 (KB978207)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '25/01/2010',
                NO_REMOVE        => undef,
                GUID             => 'KB978207-IE8',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=978207',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => undef,
                NAME             => 'Microsoft .NET Framework 1.1 Security Update (KB979906)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => undef,
                NO_REMOVE        => undef,
                GUID             => 'M979906',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => undef,
                URL_INFO_ABOUT   => undef,
                VERSION_MAJOR    => undef,
                VERSION          => undef,
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Microsoft Office Shared MUI (English) 2010',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '15/11/2011',
                NO_REMOVE        => undef,
                GUID             => '{90140000-006E-0409-0000-0000000FF1CE}',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => undef,
                URL_INFO_ABOUT   => undef,
                VERSION_MAJOR    => undef,
                VERSION          => '14.0.6029.1000',
                UNINSTALL_STRING => undef,
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB958687)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '15/01/2009',
                NO_REMOVE        => undef,
                GUID             => 'KB958687',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=958687',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => undef,
                NAME             => 'Microsoft .NET Framework 1.1 Security Update (KB2656353)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => undef,
                NO_REMOVE        => undef,
                GUID             => 'M2656353',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => undef,
                URL_INFO_ABOUT   => undef,
                VERSION_MAJOR    => undef,
                VERSION          => undef,
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB954211)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '31/10/2008',
                NO_REMOVE        => undef,
                GUID             => 'KB954211',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=954211',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB961373)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '18/05/2009',
                NO_REMOVE        => undef,
                GUID             => 'KB961373',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=961373',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB2360937)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '18/10/2010',
                NO_REMOVE        => undef,
                GUID             => 'KB2360937',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=2360937',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB2506212)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '18/04/2011',
                NO_REMOVE        => undef,
                GUID             => 'KB2506212',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=2506212',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft',
                NAME             => 'Microsoft Office 2010 Service Pack 1 (SP1)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => undef,
                NO_REMOVE        => 0,
                GUID             => '{90140000-0018-0409-0000-0000000FF1CE}_Office14.PROPLUS_{6BD185A0-E67F-4F77-8BCD-E34EA6AE76DF}',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => 'http://support.microsoft.com/kb/2460049',
                URL_INFO_ABOUT   => 'http://support.microsoft.com/kb/2460049',
                VERSION_MAJOR    => undef,
                VERSION          => undef,
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows Media Player 10 (KB917734)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '16/06/2006',
                NO_REMOVE        => undef,
                GUID             => 'KB917734_WMP10',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => 'http://support.microsoft.com/?kbid=917734',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => undef,
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB959426)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '18/05/2009',
                NO_REMOVE        => undef,
                GUID             => 'KB959426',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=959426',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'O&O Software GmbH',
                NAME             => 'O&O DiskImage Workstation',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '17/01/2012',
                NO_REMOVE        => 1,
                GUID             => '{8B2E50B7-E372-4045-A5FC-3E6A30A6C871}',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => undef,
                URL_INFO_ABOUT   => 'http://www.oo-software.com',
                VERSION_MAJOR    => undef,
                VERSION          => '6.0.440',
                UNINSTALL_STRING => undef,
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft',
                NAME             => 'Microsoft Office 2010 Service Pack 1 (SP1)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => undef,
                NO_REMOVE        => 0,
                GUID             => '{90140000-001F-0409-0000-0000000FF1CE}_Office14.PROPLUS_{99ACCA38-6DD3-48A8-96AE-A283C9759279}',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => 'http://support.microsoft.com/kb/2460049',
                URL_INFO_ABOUT   => 'http://support.microsoft.com/kb/2460049',
                VERSION_MAJOR    => undef,
                VERSION          => undef,
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft',
                NAME             => 'Update for Microsoft Office 2010 (KB2597091) 32-Bit Edition',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => undef,
                NO_REMOVE        => 0,
                GUID             => '{90140000-0011-0000-0000-0000000FF1CE}_Office14.PROPLUS_{4D98EEEA-A31B-42FA-991A-F989594F4DA5}',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => 'http://support.microsoft.com/kb/2597091',
                URL_INFO_ABOUT   => 'http://support.microsoft.com/kb/2597091',
                VERSION_MAJOR    => undef,
                VERSION          => undef,
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB951066)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '09/07/2008',
                NO_REMOVE        => 1,
                GUID             => 'KB951066',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=951066',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows Internet Explorer 8 (KB2618444)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '20/12/2011',
                NO_REMOVE        => undef,
                GUID             => 'KB2618444-IE8',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=2618444',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB2160329)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '16/08/2010',
                NO_REMOVE        => undef,
                GUID             => 'KB2160329',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=2160329',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB2603381)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '17/01/2012',
                NO_REMOVE        => undef,
                GUID             => 'KB2603381',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=2603381',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft',
                NAME             => 'Security Update for Microsoft Office 2010 (KB2553091)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => undef,
                NO_REMOVE        => 0,
                GUID             => '{90140000-0011-0000-0000-0000000FF1CE}_Office14.PROPLUS_{07CA44F3-F5B3-4D12-8C91-EDC5FE91D45C}',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => 'http://support.microsoft.com/kb/2553091',
                URL_INFO_ABOUT   => 'http://support.microsoft.com/kb/2553091',
                VERSION_MAJOR    => undef,
                VERSION          => undef,
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB950762)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '09/07/2008',
                NO_REMOVE        => 1,
                GUID             => 'KB950762',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=950762',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB2621440)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '16/03/2012',
                NO_REMOVE        => undef,
                GUID             => 'KB2621440',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=2621440',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Update for Microsoft .NET Framework 4 Extended (KB2468871)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => undef,
                NO_REMOVE        => undef,
                GUID             => '{0A0CADCF-78DA-33C4-A350-CD51849B9702}.KB2468871',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Update',
                HELPLINK         => 'http://support.microsoft.com/kb/2468871',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => 'c:\\windows\\Microsoft.NET\\Framework\\v4.0.30319\\SetupCache\\Extended\\setup.exe /uninstallpatch {5E9CF3A4-ADB3-3080-A8BF-976A28340758} /parameterfolder Extended',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Microsoft .NET Framework 3.5 SP1',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => undef,
                NO_REMOVE        => undef,
                GUID             => 'Microsoft .NET Framework 3.5 SP1',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => 'http://go.microsoft.com/fwlink/?LinkId=120337',
                URL_INFO_ABOUT   => undef,
                VERSION_MAJOR    => undef,
                VERSION          => undef,
                UNINSTALL_STRING => 'C:\\WINDOWS\\Microsoft.NET\\Framework\\v3.5\\Microsoft .NET Framework 3.5 SP1\\setup.exe',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'O&O Software GmbH',
                NAME             => 'O&O Event Viewer',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '23/02/2011',
                NO_REMOVE        => undef,
                GUID             => '{ED088F40-C86D-4548-9EAB-54CF3FEA3579}',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => undef,
                URL_INFO_ABOUT   => 'http://www.oo-software.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1.0.270',
                UNINSTALL_STRING => undef,
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Update for Windows Internet Explorer 8 (KB2362765)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '22/11/2010',
                NO_REMOVE        => undef,
                GUID             => 'KB2362765-IE8',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=2362765',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Microsoft Office Publisher MUI (English) 2010',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '04/10/2011',
                NO_REMOVE        => undef,
                GUID             => '{90140000-0019-0409-0000-0000000FF1CE}',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => undef,
                URL_INFO_ABOUT   => undef,
                VERSION_MAJOR    => undef,
                VERSION          => '14.0.6029.1000',
                UNINSTALL_STRING => undef,
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB2620712)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '20/12/2011',
                NO_REMOVE        => undef,
                GUID             => 'KB2620712',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=2620712',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB923689)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '13/12/2006',
                NO_REMOVE        => undef,
                GUID             => 'KB923689',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=923689',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => undef,
                UNINSTALL_STRING => undef,
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB982665)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '16/08/2010',
                NO_REMOVE        => undef,
                GUID             => 'KB982665',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=982665',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB2478960)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '14/02/2011',
                NO_REMOVE        => undef,
                GUID             => 'KB2478960',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=2478960',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Hotfix for Windows XP (KB969084)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '01/02/2010',
                NO_REMOVE        => undef,
                GUID             => 'KB969084',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Hotfix',
                HELPLINK         => 'http://support.microsoft.com?kbid=969084',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '3',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'VS Revo Group',
                NAME             => 'Revo Uninstaller 1.93',
                VERSION_MINOR    => undef,
                COMMENTS         => 'Thank you for choosing Revo Uninstaller!',
                INSTALLDATE      => undef,
                NO_REMOVE        => undef,
                GUID             => 'Revo Uninstaller',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => 'http://www.revouninstaller.com',
                URL_INFO_ABOUT   => 'http://www.revouninstaller.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1.93',
                UNINSTALL_STRING => 'C:\\Program Files\\VS Revo Group\\Revo Uninstaller\\uninst.exe',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB974112)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '09/11/2009',
                NO_REMOVE        => undef,
                GUID             => 'KB974112',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=974112',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Microsoft Office Proof (Spanish) 2010',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '20/12/2011',
                NO_REMOVE        => undef,
                GUID             => '{90140000-001F-0C0A-0000-0000000FF1CE}',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => undef,
                URL_INFO_ABOUT   => undef,
                VERSION_MAJOR    => undef,
                VERSION          => '14.0.6029.1000',
                UNINSTALL_STRING => undef,
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft',
                NAME             => 'Microsoft Office 2010 Service Pack 1 (SP1)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => undef,
                NO_REMOVE        => 0,
                GUID             => '{90140000-001F-0C0A-0000-0000000FF1CE}_Office14.PROPLUS_{DEA87BE2-FFCC-4F33-9946-FCBE55A1E998}',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => 'http://support.microsoft.com/kb/2460049',
                URL_INFO_ABOUT   => 'http://support.microsoft.com/kb/2460049',
                VERSION_MAJOR    => undef,
                VERSION          => undef,
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB956744)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '03/09/2009',
                NO_REMOVE        => undef,
                GUID             => 'KB956744',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=956744',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB960859)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '03/09/2009',
                NO_REMOVE        => undef,
                GUID             => 'KB960859',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=960859',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Microsoft .NET Framework 4 Client Profile (KB2656368)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => undef,
                NO_REMOVE        => undef,
                GUID             => '{3C3901C5-3455-3E0A-A214-0B093A5070A6}.KB2656368',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com/kb/2656368',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => 'C:\\windows\\Microsoft.NET\\Framework\\v4.0.30319\\SetupCache\\Client\\setup.exe /uninstallpatch {9EC88EA8-4ABE-393C-87BD-90EABB1C4C9B} /parameterfolder Client',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB2347290)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '20/09/2010',
                NO_REMOVE        => undef,
                GUID             => 'KB2347290',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=2347290',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB963027)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '18/05/2009',
                NO_REMOVE        => undef,
                GUID             => 'KB963027',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=963027',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB938464)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '31/10/2008',
                NO_REMOVE        => undef,
                GUID             => 'KB938464',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=938464',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB955069)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '15/01/2009',
                NO_REMOVE        => undef,
                GUID             => 'KB955069',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=955069',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB981957)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '18/10/2010',
                NO_REMOVE        => undef,
                GUID             => 'KB981957',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=981957',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'User Profile Hive Cleanup Service',
                VERSION_MINOR    => undef,
                COMMENTS         => 'Installer for User Profile Hive Cleanup Service',
                INSTALLDATE      => '23/08/2007',
                NO_REMOVE        => undef,
                GUID             => '{FF77941A-2BFA-4A18-BE2E-69B9498E4D55}',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => undef,
                URL_INFO_ABOUT   => 'http://www.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1.6.30',
                UNINSTALL_STRING => undef,
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB978262)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '15/02/2010',
                NO_REMOVE        => undef,
                GUID             => 'KB978262',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=978262',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB2633171)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '20/12/2011',
                NO_REMOVE        => undef,
                GUID             => 'KB2633171',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=2633171',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB2646524)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '17/01/2012',
                NO_REMOVE        => undef,
                GUID             => 'KB2646524',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=2646524',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft',
                NAME             => 'Microsoft Windows Journal Viewer',
                VERSION_MINOR    => undef,
                COMMENTS         => 'A viewer for Windows Journal documents.',
                INSTALLDATE      => '05/04/2006',
                NO_REMOVE        => undef,
                GUID             => '{43DCF766-6838-4F9A-8C91-D92DA586DFA8}',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => undef,
                URL_INFO_ABOUT   => undef,
                VERSION_MAJOR    => undef,
                VERSION          => '1.5.2316.0',
                UNINSTALL_STRING => undef,
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Microsoft .NET Framework 4 Extended (KB2487367)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => undef,
                NO_REMOVE        => undef,
                GUID             => '{0A0CADCF-78DA-33C4-A350-CD51849B9702}.KB2487367',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com/kb/2487367',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => 'c:\\windows\\Microsoft.NET\\Framework\\v4.0.30319\\SetupCache\\Extended\\setup.exe /uninstallpatch {42A3562E-8B4E-39A4-B82D-CC12F82889E3} /parameterfolder Extended',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'XML Paper Specification Shared Components Pack 1.0',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '10/04/2008',
                NO_REMOVE        => 1,
                GUID             => 'XpsEPSC',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => 'http://support.microsoft.com?kbid=test',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => undef,
                UNINSTALL_STRING => undef,
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB952004)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '18/05/2009',
                NO_REMOVE        => undef,
                GUID             => 'KB952004',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=952004',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB970430)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '14/12/2009',
                NO_REMOVE        => undef,
                GUID             => 'KB970430',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=970430',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB971486)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '09/11/2009',
                NO_REMOVE        => undef,
                GUID             => 'KB971486',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=971486',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows Internet Explorer 8 (KB2510531)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '18/04/2011',
                NO_REMOVE        => undef,
                GUID             => 'KB2510531-IE8',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=2510531',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB2570947)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '20/09/2011',
                NO_REMOVE        => undef,
                GUID             => 'KB2570947',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=2570947',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Adobe Systems Inc.',
                NAME             => 'Adobe AIR',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '08/07/2008',
                NO_REMOVE        => undef,
                GUID             => '{00203668-8170-44A0-BE44-B632FA4D780F}',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => undef,
                URL_INFO_ABOUT   => undef,
                VERSION_MAJOR    => undef,
                VERSION          => '1.0.8.4990',
                UNINSTALL_STRING => undef,
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'MSXML 4.0 SP2 (KB973688)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '14/12/2009',
                NO_REMOVE        => undef,
                GUID             => '{F662A8E6-F4DC-41A2-901E-8C11F044BDEC}',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => undef,
                URL_INFO_ABOUT   => undef,
                VERSION_MAJOR    => undef,
                VERSION          => '4.20.9876.0',
                UNINSTALL_STRING => undef,
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB958690)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '02/04/2009',
                NO_REMOVE        => undef,
                GUID             => 'KB958690',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=958690',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB973346)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '03/09/2009',
                NO_REMOVE        => undef,
                GUID             => 'KB973346',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=973346',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB979482)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '14/06/2010',
                NO_REMOVE        => undef,
                GUID             => 'KB979482',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=979482',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Update for Windows Internet Explorer 8 (KB975364)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '10/11/2009',
                NO_REMOVE        => undef,
                GUID             => 'KB975364-IE8',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=975364',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Symantec Corporation',
                NAME             => 'Symantec Backup Exec Remote Agent for Windows Systems',
                VERSION_MINOR    => undef,
                COMMENTS         => 'Symantec Backup Exec Remote Agent for Windows Systems 32-bit',
                INSTALLDATE      => '10/12/2009',
                NO_REMOVE        => undef,
                GUID             => 'Remote Agent for Windows Servers',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => undef,
                URL_INFO_ABOUT   => 'http://www.symantec.com',
                VERSION_MAJOR    => undef,
                VERSION          => '11.0.6235',
                UNINSTALL_STRING => undef,
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB2485376)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '14/02/2011',
                NO_REMOVE        => undef,
                GUID             => 'KB2485376',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=2485376',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows Internet Explorer 8 (KB976325)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '14/12/2009',
                NO_REMOVE        => undef,
                GUID             => 'KB976325-IE8',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=976325',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB946648)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '09/07/2008',
                NO_REMOVE        => 1,
                GUID             => 'KB946648',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=946648',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft',
                NAME             => 'Microsoft Office 2010 Service Pack 1 (SP1)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => undef,
                NO_REMOVE        => 0,
                GUID             => '{90140000-0015-0409-0000-0000000FF1CE}_Office14.PROPLUS_{6BD185A0-E67F-4F77-8BCD-E34EA6AE76DF}',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => 'http://support.microsoft.com/kb/2460049',
                URL_INFO_ABOUT   => 'http://support.microsoft.com/kb/2460049',
                VERSION_MAJOR    => undef,
                VERSION          => undef,
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB2483185)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '14/02/2011',
                NO_REMOVE        => undef,
                GUID             => 'KB2483185',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=2483185',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB958644)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '31/10/2008',
                NO_REMOVE        => undef,
                GUID             => 'KB958644',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=958644',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => undef,
                NAME             => 'Windows Media Format Runtime',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => undef,
                NO_REMOVE        => undef,
                GUID             => 'Windows Media Format Runtime',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => undef,
                URL_INFO_ABOUT   => undef,
                VERSION_MAJOR    => undef,
                VERSION          => undef,
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Windows Genuine Advantage Validation Tool (KB892130)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '12/04/2006',
                NO_REMOVE        => 1,
                GUID             => 'WGA',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => 'http://support.microsoft.com?kbid=892130',
                URL_INFO_ABOUT   => 'http://www.microsoft.com/genuine',
                VERSION_MAJOR    => undef,
                VERSION          => '1.7.0069.2',
                UNINSTALL_STRING => undef,
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Update for Microsoft Windows (KB971513)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '09/11/2009',
                NO_REMOVE        => undef,
                GUID             => 'KB971513',
                FROM             => 'registry',
                RELEASE_TYPE     => '%HOTFIX%',
                HELPLINK         => 'http://support.microsoft.com/kb/971513',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => undef,
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB977816)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '19/04/2010',
                NO_REMOVE        => undef,
                GUID             => 'KB977816',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=977816',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Update for Windows Internet Explorer 8 (KB976662)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '01/03/2010',
                NO_REMOVE        => undef,
                GUID             => 'KB976662-IE8',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=976662',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Adobe Systems, Inc.',
                NAME             => 'Adobe Shockwave Player 11',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => undef,
                NO_REMOVE        => undef,
                GUID             => 'Adobe Shockwave Player',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => 'http://www.adobe.com/support/shockwave',
                URL_INFO_ABOUT   => 'http://www.adobe.com',
                VERSION_MAJOR    => undef,
                VERSION          => '11',
                UNINSTALL_STRING => 'C:\\WINDOWS\\system32\\adobe\\SHOCKW~1\\UNWISE.EXE C:\\WINDOWS\\system32\\Adobe\\SHOCKW~1\\Install.log',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Update for Windows XP (KB955759)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '14/12/2009',
                NO_REMOVE        => undef,
                GUID             => 'KB955759',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=955759',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows Internet Explorer 8 (KB2586448)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '18/10/2011',
                NO_REMOVE        => undef,
                GUID             => 'KB2586448-IE8',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=2586448',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Update for Windows Internet Explorer 8 (KB980302)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '05/04/2010',
                NO_REMOVE        => undef,
                GUID             => 'KB980302-IE8',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=980302',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB2279986)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '18/10/2010',
                NO_REMOVE        => undef,
                GUID             => 'KB2279986',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=2279986',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB972260)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '03/09/2009',
                NO_REMOVE        => undef,
                GUID             => 'KB972260',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=972260',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB2661637)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '21/02/2012',
                NO_REMOVE        => undef,
                GUID             => 'KB2661637',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=2661637',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Proxy Networks, Inc.',
                NAME             => 'PROXY Pro Host',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '09/07/2009',
                NO_REMOVE        => undef,
                GUID             => '{A17F60BF-18E7-49ED-8AA2-8AC82B7F3993}',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => undef,
                URL_INFO_ABOUT   => 'http://www.proxynetworks.com',
                VERSION_MAJOR    => undef,
                VERSION          => '6.10.1374',
                UNINSTALL_STRING => undef,
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Simon Tatham',
                NAME             => 'PuTTY version 0.58',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => undef,
                NO_REMOVE        => undef,
                GUID             => 'PuTTY_is1',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => undef,
                URL_INFO_ABOUT   => 'http://www.chiark.greenend.org.uk/~sgtatham/putty/',
                VERSION_MAJOR    => undef,
                VERSION          => '0.58',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => undef,
                NAME             => 'GSview 4.8',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => undef,
                NO_REMOVE        => undef,
                GUID             => 'GSview 4.8',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => undef,
                URL_INFO_ABOUT   => undef,
                VERSION_MAJOR    => undef,
                VERSION          => undef,
                UNINSTALL_STRING => 'C:\\Program Files\\Ghostgum\\gsview\\uninstgs.exe \\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB969897)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '09/07/2009',
                NO_REMOVE        => undef,
                GUID             => 'KB969897',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=969897',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB2598479)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '17/01/2012',
                NO_REMOVE        => undef,
                GUID             => 'KB2598479',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=2598479',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Hummingbird Ltd.',
                NAME             => 'Hummingbird Connectivity Secure Shell 2006',
                VERSION_MINOR    => undef,
                COMMENTS         => 'Connectivity Secure Shell 2006 Setup for Windows Installer',
                INSTALLDATE      => '23/08/2007',
                NO_REMOVE        => undef,
                GUID             => '{82FA2169-16BD-404E-A743-FDDAC1DA81C1}',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => undef,
                URL_INFO_ABOUT   => 'http://www.hummingbird.com',
                VERSION_MAJOR    => undef,
                VERSION          => '11.0.6.0',
                UNINSTALL_STRING => undef,
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB969898)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '09/07/2009',
                NO_REMOVE        => undef,
                GUID             => 'KB969898',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=969898',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Adobe Systems Incorporated',
                NAME             => 'Adobe Flash Player 11 Plugin',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '20/02/2012',
                NO_REMOVE        => undef,
                GUID             => '{35E1B1BF-D8E5-4B7F-9FD6-87D2E5694015}',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => undef,
                URL_INFO_ABOUT   => 'http://www.adobe.com',
                VERSION_MAJOR    => undef,
                VERSION          => '11.1.102.62',
                UNINSTALL_STRING => undef,
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB2476490)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '21/06/2011',
                NO_REMOVE        => undef,
                GUID             => 'KB2476490',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=2476490',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'OCS Inventory NG Team',
                NAME             => 'OCS Inventory Agent 4.0.4.8',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => undef,
                NO_REMOVE        => undef,
                GUID             => 'OCS Inventory Agent',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => undef,
                URL_INFO_ABOUT   => 'http://ocsinventory.sourceforge.net',
                VERSION_MAJOR    => undef,
                VERSION          => '4.0.4.8',
                UNINSTALL_STRING => 'C:\\Program Files\\OCS Inventory Agent\\uninst.exe',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Microsoft Office Excel MUI (English) 2010',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '04/10/2011',
                NO_REMOVE        => undef,
                GUID             => '{90140000-0016-0409-0000-0000000FF1CE}',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => undef,
                URL_INFO_ABOUT   => undef,
                VERSION_MAJOR    => undef,
                VERSION          => '14.0.6029.1000',
                UNINSTALL_STRING => undef,
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Hotfix for Windows XP (KB2443685)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '28/03/2011',
                NO_REMOVE        => undef,
                GUID             => 'KB2443685',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Hotfix',
                HELPLINK         => 'http://support.microsoft.com?kbid=2443685',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows Internet Explorer 8 (KB2482017)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '14/02/2011',
                NO_REMOVE        => undef,
                GUID             => 'KB2482017-IE8',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=2482017',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB971633)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '03/09/2009',
                NO_REMOVE        => undef,
                GUID             => 'KB971633',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=971633',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB923789)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => undef,
                NO_REMOVE        => undef,
                GUID             => 'KB923789',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => 'http://support.microsoft.com?kbid=923789',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => undef,
                UNINSTALL_STRING => 'C:\\WINDOWS\\system32\\MacroMed\\Flash\\genuinst.exe C:\\WINDOWS\\system32\\MacroMed\\Flash\\KB923789.inf',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => undef,
                NAME             => 'ie7',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => undef,
                NO_REMOVE        => undef,
                GUID             => 'ie7',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => undef,
                URL_INFO_ABOUT   => undef,
                VERSION_MAJOR    => undef,
                VERSION          => undef,
                UNINSTALL_STRING => undef,
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft',
                NAME             => 'Update for Microsoft Outlook Social Connector 2010 (KB2553406) 32-Bit Edition',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => undef,
                NO_REMOVE        => 0,
                GUID             => '{90140000-0011-0000-0000-0000000FF1CE}_Office14.PROPLUS_{BC6DFBFD-16DD-47E1-A7EF-2C062930FA4F}',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => 'http://support.microsoft.com/kb/2553406',
                URL_INFO_ABOUT   => 'http://support.microsoft.com/kb/2553406',
                VERSION_MAJOR    => undef,
                VERSION          => undef,
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Microsoft Windows (KB2564958)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '18/10/2011',
                NO_REMOVE        => undef,
                GUID             => 'KB2564958',
                FROM             => 'registry',
                RELEASE_TYPE     => '%HOTFIX%',
                HELPLINK         => 'http://support.microsoft.com/kb/2564958',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => undef,
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft',
                NAME             => 'Security Update for Microsoft SharePoint Workspace 2010 (KB2566445)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => undef,
                NO_REMOVE        => 0,
                GUID             => '{90140000-0011-0000-0000-0000000FF1CE}_Office14.PROPLUS_{337A3FB9-281D-4EC8-9CC1-7F6DDAC2359F}',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => 'http://support.microsoft.com/kb/2566445',
                URL_INFO_ABOUT   => 'http://support.microsoft.com/kb/2566445',
                VERSION_MAJOR    => undef,
                VERSION          => undef,
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft',
                NAME             => 'Update for Microsoft OneNote 2010 (KB2553290) 32-Bit Edition',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => undef,
                NO_REMOVE        => 0,
                GUID             => '{90140000-00A1-0409-0000-0000000FF1CE}_Office14.PROPLUS_{9865DC3A-2898-48D9-B96A-46397571C934}',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => 'http://support.microsoft.com/kb/2553290',
                URL_INFO_ABOUT   => 'http://support.microsoft.com/kb/2553290',
                VERSION_MAJOR    => undef,
                VERSION          => undef,
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB980436)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '16/08/2010',
                NO_REMOVE        => undef,
                GUID             => 'KB980436',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=980436',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows Media Player (KB2378111)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '18/10/2010',
                NO_REMOVE        => undef,
                GUID             => 'KB2378111_WM9',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => 'http://support.microsoft.com/?kbid=2378111',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => undef,
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Hotfix for Windows XP (KB970653-v3)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '03/09/2009',
                NO_REMOVE        => undef,
                GUID             => 'KB970653-v3',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Hotfix',
                HELPLINK         => 'http://support.microsoft.com?kbid=970653',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '3',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft',
                NAME             => 'Security Update for Microsoft Office 2010 (KB2598039) 32-Bit Edition',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => undef,
                NO_REMOVE        => 1,
                GUID             => '{90140000-0011-0000-0000-0000000FF1CE}_Office14.PROPLUS_{01F2485C-FAEE-47E7-986E-B4F2FFC22D57}',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => 'http://support.microsoft.com/kb/2598039',
                URL_INFO_ABOUT   => 'http://support.microsoft.com/kb/2598039',
                VERSION_MAJOR    => undef,
                VERSION          => undef,
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB2503658)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '18/04/2011',
                NO_REMOVE        => undef,
                GUID             => 'KB2503658',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=2503658',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows Media Player (KB975558)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '20/09/2010',
                NO_REMOVE        => undef,
                GUID             => 'KB975558_WM8',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => 'http://support.microsoft.com/?kbid=975558',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => undef,
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB977165)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '15/02/2010',
                NO_REMOVE        => undef,
                GUID             => 'KB977165',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=977165',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Colin Harrison',
                NAME             => 'Xming 7.5.0.15',
                VERSION_MINOR    => 5,
                COMMENTS         => undef,
                INSTALLDATE      => '23/02/2010',
                NO_REMOVE        => undef,
                GUID             => 'Xming_is1',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => 'http://www.StraightRunning.com/XmingNotes',
                URL_INFO_ABOUT   => 'http://www.StraightRunning.com/XmingNotes',
                VERSION_MAJOR    => 7,
                VERSION          => '7.5.0.15',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft',
                NAME             => 'Update for Microsoft Office 2010 (KB2553270) 32-Bit Edition',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => undef,
                NO_REMOVE        => 0,
                GUID             => '{90140000-001F-0C0A-0000-0000000FF1CE}_Office14.PROPLUS_{995A7832-B512-46D5-87C9-2D71FB541435}',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => 'http://support.microsoft.com/kb/2553270',
                URL_INFO_ABOUT   => 'http://support.microsoft.com/kb/2553270',
                VERSION_MAJOR    => undef,
                VERSION          => undef,
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Microsoft Office Word MUI (English) 2010',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '04/10/2011',
                NO_REMOVE        => undef,
                GUID             => '{90140000-001B-0409-0000-0000000FF1CE}',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => undef,
                URL_INFO_ABOUT   => undef,
                VERSION_MAJOR    => undef,
                VERSION          => '14.0.6029.1000',
                UNINSTALL_STRING => undef,
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Hotfix for Windows Media Format SDK (KB902344)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '05/04/2006',
                NO_REMOVE        => undef,
                GUID             => 'KB902344',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => 'http://support.microsoft.com?kbid=902344',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => undef,
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Windows Internet Explorer 8',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '09/11/2009',
                NO_REMOVE        => undef,
                GUID             => 'ie8',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => 'http://www.microsoft.com/ie',
                URL_INFO_ABOUT   => 'http://www.microsoft.com/ie',
                VERSION_MAJOR    => undef,
                VERSION          => '20090308.140743',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB973869)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '03/09/2009',
                NO_REMOVE        => undef,
                GUID             => 'KB973869',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=973869',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft',
                NAME             => 'Update for Microsoft Office 2010 (KB2553310) 32-Bit Edition',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => undef,
                NO_REMOVE        => 0,
                GUID             => '{90140000-0011-0000-0000-0000000FF1CE}_Office14.PROPLUS_{C8694FF0-8203-483B-A07A-2BC40433167D}',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => 'http://support.microsoft.com/kb/2553310',
                URL_INFO_ABOUT   => 'http://support.microsoft.com/kb/2553310',
                VERSION_MAJOR    => undef,
                VERSION          => undef,
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Microsoft .NET Framework 3.0 Service Pack 2',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '05/07/2010',
                NO_REMOVE        => undef,
                GUID             => '{A3051CD0-2F64-3813-A88D-B8DCCDE8F8C7}',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => undef,
                URL_INFO_ABOUT   => undef,
                VERSION_MAJOR    => undef,
                VERSION          => '3.2.30729',
                UNINSTALL_STRING => undef,
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB956803)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '31/10/2008',
                NO_REMOVE        => undef,
                GUID             => 'KB956803',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=956803',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Update for Windows XP (KB2641690)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '15/11/2011',
                NO_REMOVE        => undef,
                GUID             => 'KB2641690',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=2641690',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Hotfix for Microsoft .NET Framework 3.5 SP1 (KB953595)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => undef,
                NO_REMOVE        => 1,
                GUID             => '{CE2CDD62-0124-36CA-84D3-9F4DCF5C5BD9}.KB953595',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Hotfix',
                HELPLINK         => 'http://support.microsoft.com/kb/953595',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => 'C:\\WINDOWS\\system32\\msiexec.exe /package {CE2CDD62-0124-36CA-84D3-9F4DCF5C5BD9} /uninstall  /qb+ REBOOTPROMPT=\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'HighMAT Extension to Microsoft Windows XP CD Writing Wizard',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '05/04/2006',
                NO_REMOVE        => undef,
                GUID             => '{FCE65C4E-B0E8-4FBD-AD16-EDCBE6CD591F}',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => undef,
                URL_INFO_ABOUT   => undef,
                VERSION_MAJOR    => undef,
                VERSION          => '1.1.1905.1',
                UNINSTALL_STRING => undef,
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB2544893-v2)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '15/11/2011',
                NO_REMOVE        => undef,
                GUID             => 'KB2544893-v2',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=2544893',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '2',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft',
                NAME             => 'Update for Microsoft Outlook 2010 (KB2553248) 32-Bit Edition',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => undef,
                NO_REMOVE        => 0,
                GUID             => '{90140000-0011-0000-0000-0000000FF1CE}_Office14.PROPLUS_{38990592-F6A1-4A26-96C7-0600E36AE794}',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => 'http://support.microsoft.com/kb/2553248',
                URL_INFO_ABOUT   => 'http://support.microsoft.com/kb/2553248',
                VERSION_MAJOR    => undef,
                VERSION          => undef,
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows Internet Explorer 8 (KB2530548)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '21/06/2011',
                NO_REMOVE        => undef,
                GUID             => 'KB2530548-IE8',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=2530548',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB2507938)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '19/07/2011',
                NO_REMOVE        => undef,
                GUID             => 'KB2507938',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=2507938',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Microsoft Office Groove MUI (English) 2010',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '04/10/2011',
                NO_REMOVE        => undef,
                GUID             => '{90140000-00BA-0409-0000-0000000FF1CE}',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => undef,
                URL_INFO_ABOUT   => undef,
                VERSION_MAJOR    => undef,
                VERSION          => '14.0.6029.1000',
                UNINSTALL_STRING => undef,
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Microsoft .NET Framework 4 Client Profile (KB2478663)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => undef,
                NO_REMOVE        => undef,
                GUID             => '{3C3901C5-3455-3E0A-A214-0B093A5070A6}.KB2478663',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com/kb/2478663',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => 'C:\\windows\\Microsoft.NET\\Framework\\v4.0.30319\\SetupCache\\Client\\setup.exe /uninstallpatch {728D9A6A-2206-31E8-9F65-C3EABEFCF53E} /parameterfolder Client',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB952954)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '09/07/2008',
                NO_REMOVE        => 1,
                GUID             => 'KB952954',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=952954',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB2259922)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '20/09/2010',
                NO_REMOVE        => undef,
                GUID             => 'KB2259922',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=2259922',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft',
                NAME             => 'Microsoft Office 2010 Service Pack 1 (SP1)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => undef,
                NO_REMOVE        => 0,
                GUID             => '{90140000-0016-0409-0000-0000000FF1CE}_Office14.PROPLUS_{6BD185A0-E67F-4F77-8BCD-E34EA6AE76DF}',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => 'http://support.microsoft.com/kb/2460049',
                URL_INFO_ABOUT   => 'http://support.microsoft.com/kb/2460049',
                VERSION_MAJOR    => undef,
                VERSION          => undef,
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Adobe Systems Incorporated',
                NAME             => 'Spelling Dictionaries Support For Adobe Reader 9',
                VERSION_MINOR    => undef,
                COMMENTS         => 'This is a placeholder for ARP comments for Spelling Dictionaries for Adobe Reader 9.0',
                INSTALLDATE      => '03/09/2009',
                NO_REMOVE        => undef,
                GUID             => '{AC76BA86-7AD7-5464-3428-900000000004}',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => undef,
                URL_INFO_ABOUT   => 'http://www.adobe.com',
                VERSION_MAJOR    => undef,
                VERSION          => '9.0.0',
                UNINSTALL_STRING => undef,
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB941569)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '01/01/2008',
                NO_REMOVE        => undef,
                GUID             => 'KB941569',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=941569',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => undef,
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Oracle',
                NAME             => 'Oracle Calendar',
                VERSION_MINOR    => undef,
                COMMENTS         => ' ',
                INSTALLDATE      => '24/10/2006',
                NO_REMOVE        => undef,
                GUID             => '{4DA016C7-9AC2-4BA7-AD31-3EBA29BC21B1}',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => undef,
                URL_INFO_ABOUT   => 'http://www.oracle.com',
                VERSION_MAJOR    => undef,
                VERSION          => '10.1.2.3.0',
                UNINSTALL_STRING => undef,
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Opera Software ASA',
                NAME             => 'Opera 11.52',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => undef,
                NO_REMOVE        => undef,
                GUID             => 'Opera 11.52.1100',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => 'http://www.opera.com/support',
                URL_INFO_ABOUT   => 'http://www.opera.com',
                VERSION_MAJOR    => undef,
                VERSION          => '11.52.1100',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB2436673)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '20/12/2010',
                NO_REMOVE        => undef,
                GUID             => 'KB2436673',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=2436673',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft',
                NAME             => 'Microsoft Office 2010 Service Pack 1 (SP1)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => undef,
                NO_REMOVE        => 0,
                GUID             => '{90140000-0115-0409-0000-0000000FF1CE}_Office14.PROPLUS_{4560037C-E356-444A-A015-D21F487D809E}',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => 'http://support.microsoft.com/kb/2460049',
                URL_INFO_ABOUT   => 'http://support.microsoft.com/kb/2460049',
                VERSION_MAJOR    => undef,
                VERSION          => undef,
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB2443105)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '20/12/2010',
                NO_REMOVE        => undef,
                GUID             => 'KB2443105',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=2443105',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB2509553)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '18/04/2011',
                NO_REMOVE        => undef,
                GUID             => 'KB2509553',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=2509553',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft',
                NAME             => 'Update for Microsoft Office 2010 (KB2553092)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => undef,
                NO_REMOVE        => 0,
                GUID             => '{90140000-0011-0000-0000-0000000FF1CE}_Office14.PROPLUS_{7AC49FC8-F8D2-4DD8-9086-09E52385A21F}',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => 'http://support.microsoft.com/kb/2553092',
                URL_INFO_ABOUT   => 'http://support.microsoft.com/kb/2553092',
                VERSION_MAJOR    => undef,
                VERSION          => undef,
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB960714)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '15/01/2009',
                NO_REMOVE        => undef,
                GUID             => 'KB960714',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=960714',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Microsoft .NET Framework 4 Extended (KB2416472)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => undef,
                NO_REMOVE        => undef,
                GUID             => '{0A0CADCF-78DA-33C4-A350-CD51849B9702}.KB2416472',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com/kb/2416472',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => 'c:\\windows\\Microsoft.NET\\Framework\\v4.0.30319\\SetupCache\\Extended\\setup.exe /uninstallpatch {7A2C18A1-D2A2-3177-82F1-5FE9CC08ECB0} /parameterfolder Extended',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => undef,
                NAME             => 'Real Alternative 2.0.2 Lite',
                VERSION_MINOR    => 0,
                COMMENTS         => undef,
                INSTALLDATE      => '23/11/2011',
                NO_REMOVE        => undef,
                GUID             => 'RealAlt_is1',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => undef,
                URL_INFO_ABOUT   => undef,
                VERSION_MAJOR    => 2,
                VERSION          => '2.0.2',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Frank Heindörfer, Philip Chinery',
                NAME             => 'PDFCreator',
                VERSION_MINOR    => undef,
                COMMENTS         => 'PDFCreator - Opensource',
                INSTALLDATE      => '05/07/2011',
                NO_REMOVE        => undef,
                GUID             => '{0001B4FD-9EA3-4D90-A79E-FD14BA3AB01D}',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => 'http://www.sf.net/projects/pdfcreator',
                URL_INFO_ABOUT   => 'http://www.sf.net/projects/pdfcreator',
                VERSION_MAJOR    => undef,
                VERSION          => '1.2.1',
                UNINSTALL_STRING => 'C:\\Program Files\\PDFCreator\\unins000.exe',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows Internet Explorer 8 (KB2497640)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '18/04/2011',
                NO_REMOVE        => undef,
                GUID             => 'KB2497640-IE8',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=2497640',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft',
                NAME             => 'Update for Microsoft Office 2010 (KB2553270) 32-Bit Edition',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => undef,
                NO_REMOVE        => 0,
                GUID             => '{90140000-001F-040C-0000-0000000FF1CE}_Office14.PROPLUS_{15058154-469F-4794-ACD5-94F8420F9B80}',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => 'http://support.microsoft.com/kb/2553270',
                URL_INFO_ABOUT   => 'http://support.microsoft.com/kb/2553270',
                VERSION_MAJOR    => undef,
                VERSION          => undef,
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB978542)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '17/05/2010',
                NO_REMOVE        => undef,
                GUID             => 'KB978542',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=978542',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB2387149)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '18/10/2010',
                NO_REMOVE        => undef,
                GUID             => 'KB2387149',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=2387149',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Microsoft .NET Framework 4 Client Profile (KB2656351)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => undef,
                NO_REMOVE        => undef,
                GUID             => '{3C3901C5-3455-3E0A-A214-0B093A5070A6}.KB2656351',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com/kb/2656351',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => 'C:\\windows\\Microsoft.NET\\Framework\\v4.0.30319\\SetupCache\\Client\\setup.exe /uninstallpatch {4952F442-5C1A-38EB-8C23-B18EFE77E20C} /parameterfolder Client',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for CAPICOM (KB931906)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => undef,
                NO_REMOVE        => undef,
                GUID             => 'KB931906',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=931906',
                URL_INFO_ABOUT   => undef,
                VERSION_MAJOR    => undef,
                VERSION          => '2.1.0.2',
                UNINSTALL_STRING => 'MsiExec.exe /X{0EFDF2F9-836D-4EB7-A32D-038BD3F1FB2A}',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB969947)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '14/12/2009',
                NO_REMOVE        => undef,
                GUID             => 'KB969947',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=969947',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB979559)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '14/06/2010',
                NO_REMOVE        => undef,
                GUID             => 'KB979559',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=979559',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Update for Windows XP (KB951978)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '09/07/2008',
                NO_REMOVE        => undef,
                GUID             => 'KB951978',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=951978',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB2566454)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '16/08/2011',
                NO_REMOVE        => undef,
                GUID             => 'KB2566454',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=2566454',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB2653956)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '17/04/2012',
                NO_REMOVE        => undef,
                GUID             => 'KB2653956',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=2653956',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Piriform',
                NAME             => 'CCleaner (remove only)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => undef,
                NO_REMOVE        => undef,
                GUID             => 'CCleaner',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => undef,
                URL_INFO_ABOUT   => undef,
                VERSION_MAJOR    => undef,
                VERSION          => undef,
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft',
                NAME             => '{90140000-0011-0000-0000-0000000FF1CE}_Office14.PROPLUS_{DC6A88F2-14D6-468F-9E68-CBF7779FEE00}',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => undef,
                NO_REMOVE        => 1,
                GUID             => '{90140000-0011-0000-0000-0000000FF1CE}_Office14.PROPLUS_{DC6A88F2-14D6-468F-9E68-CBF7779FEE00}',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => undef,
                URL_INFO_ABOUT   => undef,
                VERSION_MAJOR    => undef,
                VERSION          => undef,
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB975561)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '15/03/2010',
                NO_REMOVE        => undef,
                GUID             => 'KB975561',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=975561',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Mozilla',
                NAME             => 'Mozilla Firefox 10.0.2 (x86 en-US)',
                VERSION_MINOR    => undef,
                COMMENTS         => 'Mozilla Firefox 10.0.2 (x86 en-US)',
                INSTALLDATE      => undef,
                NO_REMOVE        => undef,
                GUID             => 'Mozilla Firefox 10.0.2 (x86 en-US)',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => undef,
                URL_INFO_ABOUT   => 'http://www.mozilla.com/en-US/',
                VERSION_MAJOR    => undef,
                VERSION          => '10.0.2',
                UNINSTALL_STRING => 'C:\\Program Files\\Mozilla Firefox\\uninstall\\helper.exe',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Update for Windows XP (KB2607712)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '13/09/2011',
                NO_REMOVE        => undef,
                GUID             => 'KB2607712',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=2607712',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Hotfix for Microsoft .NET Framework 3.0 (KB932471)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => undef,
                NO_REMOVE        => undef,
                GUID             => 'KB932471.T301_380ToU433_380',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Hotfix',
                HELPLINK         => undef,
                URL_INFO_ABOUT   => undef,
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => 'C:\\WINDOWS\\system32\\msiexec.exe /promptrestart /uninstall {ECD292A0-0347-4244-8C24-5DBCE990FB40} /package {BAF78226-3200-4DB4-BE33-4D922A799840}',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Step By Step Interactive Training (KB898458)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '05/04/2006',
                NO_REMOVE        => undef,
                GUID             => 'KB898458',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => 'http://support.microsoft.com/kb/898458',
                URL_INFO_ABOUT   => undef,
                VERSION_MAJOR    => undef,
                VERSION          => '20050502.101010',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Colin Harrison',
                NAME             => 'Xming-fonts 7.5.0.25',
                VERSION_MINOR    => 5,
                COMMENTS         => undef,
                INSTALLDATE      => '02/09/2010',
                NO_REMOVE        => undef,
                GUID             => 'Xming-fonts_is1',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => 'http://www.StraightRunning.com/XmingNotes',
                URL_INFO_ABOUT   => 'http://www.StraightRunning.com/XmingNotes',
                VERSION_MAJOR    => 7,
                VERSION          => '7.5.0.25',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB975467)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '09/11/2009',
                NO_REMOVE        => undef,
                GUID             => 'KB975467',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=975467',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Microsoft Office Proof (French) 2010',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '20/12/2011',
                NO_REMOVE        => undef,
                GUID             => '{90140000-001F-040C-0000-0000000FF1CE}',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => undef,
                URL_INFO_ABOUT   => undef,
                VERSION_MAJOR    => undef,
                VERSION          => '14.0.6029.1000',
                UNINSTALL_STRING => undef,
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Cornell University',
                NAME             => 'Spider4',
                VERSION_MINOR    => undef,
                COMMENTS         => 'This installer database contains the logic and data required to install Spider4.',
                INSTALLDATE      => '27/04/2010',
                NO_REMOVE        => undef,
                GUID             => '{FB9448E7-477B-4F92-81A0-90754E2A259B}',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => undef,
                URL_INFO_ABOUT   => 'http://www.cit.cornell.edu/security/tools',
                VERSION_MAJOR    => undef,
                VERSION          => '4.0.2',
                UNINSTALL_STRING => undef,
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft',
                NAME             => 'Update for Microsoft Office 2010 (KB2553065)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => undef,
                NO_REMOVE        => 0,
                GUID             => '{90140000-0011-0000-0000-0000000FF1CE}_Office14.PROPLUS_{A8686D24-1E89-43A1-973E-05A258D2B3F8}',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => 'http://support.microsoft.com/kb/2553065',
                URL_INFO_ABOUT   => 'http://support.microsoft.com/kb/2553065',
                VERSION_MAJOR    => undef,
                VERSION          => undef,
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Microsoft Office Professional Plus 2010',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => undef,
                NO_REMOVE        => 0,
                GUID             => 'Office14.PROPLUS',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => undef,
                URL_INFO_ABOUT   => undef,
                VERSION_MAJOR    => undef,
                VERSION          => '14.0.6029.1000',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => undef,
                NAME             => 'Shockwave',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => undef,
                NO_REMOVE        => undef,
                GUID             => 'Shockwave',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => undef,
                URL_INFO_ABOUT   => undef,
                VERSION_MAJOR    => undef,
                VERSION          => undef,
                UNINSTALL_STRING => undef,
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Update for Windows XP (KB2541763)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '05/07/2011',
                NO_REMOVE        => undef,
                GUID             => 'KB2541763',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=2541763',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB2412687)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '18/04/2011',
                NO_REMOVE        => undef,
                GUID             => 'KB2412687',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=2412687',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB974392)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '14/12/2009',
                NO_REMOVE        => undef,
                GUID             => 'KB974392',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=974392',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Windows XP Service Pack 3',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '09/07/2008',
                NO_REMOVE        => 1,
                GUID             => 'Windows XP Service Pack',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => 'http://support.microsoft.com?kbid=936929',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '20080414.031525',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB956572)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '18/05/2009',
                NO_REMOVE        => undef,
                GUID             => 'KB956572',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=956572',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB2619339)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '20/12/2011',
                NO_REMOVE        => undef,
                GUID             => 'KB2619339',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=2619339',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB2479943)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '14/03/2011',
                NO_REMOVE        => undef,
                GUID             => 'KB2479943',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=2479943',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB968537)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '09/07/2009',
                NO_REMOVE        => undef,
                GUID             => 'KB968537',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=968537',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Update for Windows XP (KB2492386)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '09/08/2011',
                NO_REMOVE        => undef,
                GUID             => 'KB2492386',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=2492386',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Windows Genuine Advantage Validation Tool (KB892130)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '03/09/2009',
                NO_REMOVE        => 1,
                GUID             => 'KB892130',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => 'http://support.microsoft.com?kbid=892130',
                URL_INFO_ABOUT   => 'http://www.microsoft.com/genuine',
                VERSION_MAJOR    => undef,
                VERSION          => undef,
                UNINSTALL_STRING => undef,
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB982802)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '20/09/2010',
                NO_REMOVE        => undef,
                GUID             => 'KB982802',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=982802',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows Media Player (KB973540)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '03/09/2009',
                NO_REMOVE        => undef,
                GUID             => 'KB973540_WM9',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => 'http://support.microsoft.com/?kbid=973540',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => undef,
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Windows Media Hotfix - KB895181',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '05/04/2006',
                NO_REMOVE        => undef,
                GUID             => 'KB895181',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => 'http://support.microsoft.com?kbid=895181',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => undef,
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft',
                NAME             => 'Update for Microsoft Office 2010 (KB2553270) 32-Bit Edition',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => undef,
                NO_REMOVE        => 0,
                GUID             => '{90140000-001F-0409-0000-0000000FF1CE}_Office14.PROPLUS_{17E7B9AB-2DD2-457D-8D8E-CD14ACA973FE}',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => 'http://support.microsoft.com/kb/2553270',
                URL_INFO_ABOUT   => 'http://support.microsoft.com/kb/2553270',
                VERSION_MAJOR    => undef,
                VERSION          => undef,
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB2296199)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '20/12/2010',
                NO_REMOVE        => undef,
                GUID             => 'KB2296199',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=2296199',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB2503665)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '21/06/2011',
                NO_REMOVE        => undef,
                GUID             => 'KB2503665',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=2503665',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB972270)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '18/01/2010',
                NO_REMOVE        => undef,
                GUID             => 'KB972270',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=972270',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft',
                NAME             => 'Microsoft Office 2010 Service Pack 1 (SP1)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => undef,
                NO_REMOVE        => 0,
                GUID             => '{90140000-00A1-0409-0000-0000000FF1CE}_Office14.PROPLUS_{6BD185A0-E67F-4F77-8BCD-E34EA6AE76DF}',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => 'http://support.microsoft.com/kb/2460049',
                URL_INFO_ABOUT   => 'http://support.microsoft.com/kb/2460049',
                VERSION_MAJOR    => undef,
                VERSION          => undef,
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB960715)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '02/04/2009',
                NO_REMOVE        => undef,
                GUID             => 'KB960715',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=960715',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Hotfix for Windows XP (KB952287)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '09/07/2008',
                NO_REMOVE        => 1,
                GUID             => 'KB952287',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Hotfix',
                HELPLINK         => 'http://support.microsoft.com?kbid=952287',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Update for Windows Internet Explorer 8 (KB980182)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '05/04/2010',
                NO_REMOVE        => undef,
                GUID             => 'KB980182-IE8',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=980182',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => undef,
                NAME             => 'IDNMitigationAPIs',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => undef,
                NO_REMOVE        => undef,
                GUID             => 'IDNMitigationAPIs',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => undef,
                URL_INFO_ABOUT   => undef,
                VERSION_MAJOR    => undef,
                VERSION          => undef,
                UNINSTALL_STRING => undef,
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB2476687)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '14/02/2011',
                NO_REMOVE        => undef,
                GUID             => 'KB2476687',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=2476687',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Microsoft .NET Framework 4 Extended',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '03/01/2012',
                NO_REMOVE        => undef,
                GUID             => '{0A0CADCF-78DA-33C4-A350-CD51849B9702}',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => undef,
                URL_INFO_ABOUT   => 'http://go.microsoft.com/fwlink/?LinkId=164164',
                VERSION_MAJOR    => undef,
                VERSION          => '4.0.30319',
                UNINSTALL_STRING => undef,
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB961371-v2)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '03/09/2009',
                NO_REMOVE        => undef,
                GUID             => 'KB961371-v2',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=961371',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '2',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB957097)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '15/01/2009',
                NO_REMOVE        => undef,
                GUID             => 'KB957097',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=957097',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Identity Finder, LLC',
                NAME             => 'Identity Finder',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '11/11/2010',
                NO_REMOVE        => undef,
                GUID             => '{19DD1E9D-51E7-4A63-83F0-BAB7D6FBFC55}',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => undef,
                URL_INFO_ABOUT   => undef,
                VERSION_MAJOR    => undef,
                VERSION          => '4.6.1.0',
                UNINSTALL_STRING => undef,
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Update for Windows XP (KB971029)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '28/03/2011',
                NO_REMOVE        => undef,
                GUID             => 'KB971029',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=971029',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Update for Microsoft .NET Framework 4 Client Profile (KB2468871)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => undef,
                NO_REMOVE        => undef,
                GUID             => '{3C3901C5-3455-3E0A-A214-0B093A5070A6}.KB2468871',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Update',
                HELPLINK         => 'http://support.microsoft.com/kb/2468871',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => 'C:\\windows\\Microsoft.NET\\Framework\\v4.0.30319\\SetupCache\\Client\\setup.exe /uninstallpatch {5E9CF3A4-ADB3-3080-A8BF-976A28340758} /parameterfolder Client',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB973507)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '03/09/2009',
                NO_REMOVE        => undef,
                GUID             => 'KB973507',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=973507',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Microsoft Office Access Setup Metadata MUI (English) 2010',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '04/10/2011',
                NO_REMOVE        => undef,
                GUID             => '{90140000-0117-0409-0000-0000000FF1CE}',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => undef,
                URL_INFO_ABOUT   => undef,
                VERSION_MAJOR    => undef,
                VERSION          => '14.0.6029.1000',
                UNINSTALL_STRING => undef,
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB2423089)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '20/12/2010',
                NO_REMOVE        => undef,
                GUID             => 'KB2423089',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=2423089',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Windows Imaging Component',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '10/04/2008',
                NO_REMOVE        => 1,
                GUID             => 'WIC',
                FROM             => 'registry',
                RELEASE_TYPE     => 'HotFix',
                HELPLINK         => undef,
                URL_INFO_ABOUT   => undef,
                VERSION_MAJOR    => undef,
                VERSION          => '3.0.0.0',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB969059)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '09/11/2009',
                NO_REMOVE        => undef,
                GUID             => 'KB969059',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=969059',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows Internet Explorer 8 (KB2416400)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '20/12/2010',
                NO_REMOVE        => undef,
                GUID             => 'KB2416400-IE8',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=2416400',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft',
                NAME             => 'Definition update for Microsoft Office 2010 (KB982726) 32-Bit Edition',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => undef,
                NO_REMOVE        => 0,
                GUID             => '{90140000-0011-0000-0000-0000000FF1CE}_Office14.PROPLUS_{28857979-5507-4C10-A922-FF709A19D38C}',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => 'http://support.microsoft.com/kb/982726',
                URL_INFO_ABOUT   => 'http://support.microsoft.com/kb/982726',
                VERSION_MAJOR    => undef,
                VERSION          => undef,
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB2511455)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '18/04/2011',
                NO_REMOVE        => undef,
                GUID             => 'KB2511455',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=2511455',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB958869)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '09/11/2009',
                NO_REMOVE        => undef,
                GUID             => 'KB958869',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=958869',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB2631813)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '17/01/2012',
                NO_REMOVE        => undef,
                GUID             => 'KB2631813',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=2631813',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB980195)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '14/06/2010',
                NO_REMOVE        => undef,
                GUID             => 'KB980195',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=980195',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB950759)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '09/07/2008',
                NO_REMOVE        => 1,
                GUID             => 'KB950759',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=950759',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB979687)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '18/10/2010',
                NO_REMOVE        => undef,
                GUID             => 'KB979687',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=979687',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Martin Prikryl',
                NAME             => 'WinSCP 4.0.7',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '15/01/2009',
                NO_REMOVE        => undef,
                GUID             => 'winscp3_is1',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => 'http://winscp.net/forum/',
                URL_INFO_ABOUT   => 'http://winscp.net/',
                VERSION_MAJOR    => undef,
                VERSION          => '4.0.7',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB2567053)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '18/10/2011',
                NO_REMOVE        => undef,
                GUID             => 'KB2567053',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=2567053',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Update for Windows XP (KB943729)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '09/11/2009',
                NO_REMOVE        => undef,
                GUID             => 'KB943729',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => 'http://support.microsoft.com?kbid=943729',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => undef,
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Microsoft .NET Framework 4 Client Profile',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => undef,
                NO_REMOVE        => undef,
                GUID             => 'Microsoft .NET Framework 4 Client Profile',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => undef,
                URL_INFO_ABOUT   => 'http://go.microsoft.com/fwlink/?LinkId=164164',
                VERSION_MAJOR    => undef,
                VERSION          => '4.0.30319',
                UNINSTALL_STRING => 'C:\\windows\\Microsoft.NET\\Framework\\v4.0.30319\\SetupCache\\Client\\Setup.exe /repair /x86 /parameterfolder Client',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft',
                NAME             => 'Microsoft Office 2010 Service Pack 1 (SP1)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => undef,
                NO_REMOVE        => 0,
                GUID             => '{90140000-0011-0000-0000-0000000FF1CE}_Office14.PROPLUS_{047B0968-E622-4FAA-9B4B-121FA109EDDE}',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => 'http://support.microsoft.com/kb/2460049',
                URL_INFO_ABOUT   => 'http://support.microsoft.com/kb/2460049',
                VERSION_MAJOR    => undef,
                VERSION          => undef,
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Microsoft Corporation',
                NAME             => 'Security Update for Windows XP (KB970238)',
                VERSION_MINOR    => undef,
                COMMENTS         => undef,
                INSTALLDATE      => '09/07/2009',
                NO_REMOVE        => undef,
                GUID             => 'KB970238',
                FROM             => 'registry',
                RELEASE_TYPE     => 'Security Update',
                HELPLINK         => 'http://support.microsoft.com?kbid=970238',
                URL_INFO_ABOUT   => 'http://support.microsoft.com',
                VERSION_MAJOR    => undef,
                VERSION          => '1',
                UNINSTALL_STRING => '\\',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            },
            {
                PUBLISHER        => 'Mozilla',
                NAME             => 'Mozilla Thunderbird (2.0.0.23)',
                VERSION_MINOR    => undef,
                COMMENTS         => 'Mozilla Thunderbird',
                INSTALLDATE      => undef,
                NO_REMOVE        => undef,
                GUID             => 'Mozilla Thunderbird (2.0.0.23)',
                FROM             => 'registry',
                RELEASE_TYPE     => undef,
                HELPLINK         => undef,
                URL_INFO_ABOUT   => 'http://www.mozilla.org/',
                VERSION_MAJOR    => undef,
                VERSION          => '2.0.0.23 (en-US)',
                UNINSTALL_STRING => 'C:\\Program Files\\Mozilla Thunderbird\\uninstall\\helper.exe',
                ARCH             => 'i586',
                USERID           => undef,
                USERNAME         => undef
            }
        ],
);

my %hotfixes_tests = (
    xp => [
        {
            FROM         => 'WMI',
            NAME         => 'KB980195',
            COMMENTS     => 'Security Update for Windows XP (KB980195)',
            ARCH         => 'i586',
            RELEASE_TYPE => 'Security Update'
        },
        {
            FROM         => 'WMI',
            NAME         => 'KB980232',
            COMMENTS     => 'Security Update for Windows XP (KB980232)',
            ARCH         => 'i586',
            RELEASE_TYPE => 'Security Update'
        },
        {
            FROM         => 'WMI',
            NAME         => 'KB980436',
            COMMENTS     => 'Security Update for Windows XP (KB980436)',
            ARCH         => 'i586',
            RELEASE_TYPE => 'Security Update'
        },
        {
            FROM         => 'WMI',
            NAME         => 'KB981322',
            COMMENTS     => 'Security Update for Windows XP (KB981322)',
            ARCH         => 'i586',
            RELEASE_TYPE => 'Security Update'
        },
        {
            FROM         => 'WMI',
            NAME         => 'KB981349',
            COMMENTS     => 'Security Update for Windows XP (KB981349)',
            ARCH         => 'i586',
            RELEASE_TYPE => 'Security Update'
        },
        {
            FROM         => 'WMI',
            NAME         => 'KB981852',
            COMMENTS     => 'Security Update for Windows XP (KB981852)',
            ARCH         => 'i586',
            RELEASE_TYPE => 'Security Update'
        },
        {
            FROM         => 'WMI',
            NAME         => 'KB981997',
            COMMENTS     => 'Security Update for Windows XP (KB981997)',
            ARCH         => 'i586',
            RELEASE_TYPE => 'Security Update'
        },
        {
            FROM         => 'WMI',
            NAME         => 'KB982132',
            COMMENTS     => 'Security Update for Windows XP (KB982132)',
            ARCH         => 'i586',
            RELEASE_TYPE => 'Security Update'
        },
        {
            FROM         => 'WMI',
            NAME         => 'KB982214',
            COMMENTS     => 'Security Update for Windows XP (KB982214)',
            ARCH         => 'i586',
            RELEASE_TYPE => 'Security Update'
        },
        {
            FROM         => 'WMI',
            NAME         => 'KB982665',
            COMMENTS     => 'Security Update for Windows XP (KB982665)',
            ARCH         => 'i586',
            RELEASE_TYPE => 'Security Update'
        }
    ]
);

plan tests =>
    scalar (2 * keys %softwares_tests) +
    scalar (keys %hotfixes_tests)      +
    1;

my $inventory = FusionInventory::Agent::Inventory->new();

my $module = Test::MockModule->new(
    'FusionInventory::Agent::Task::Inventory::Win32::Softwares'
);
$module->mock(
    'encodeFromRegistry',
    sub {
        return undef unless $_[0];
        return encode("UTF-8", decode('cp1252', $_[0]));
    }
);

foreach my $test (keys %softwares_tests) {
    my $softwaresKey = FusionInventory::Test::Utils::loadRegistryDump(
        "resources/win32/registry/$test-uninstall.reg"
    );

    my $softwares = FusionInventory::Agent::Task::Inventory::Win32::Softwares::_getSoftwaresList(softwares => $softwaresKey);

    cmp_deeply(
        [ sort { compare() } @$softwares ],
        [ sort { compare() } @{$softwares_tests{$test}} ],
        "$test: parsing"
    );
    lives_ok {
        $inventory->addEntry(section => 'SOFTWARES', entry => $_)
            foreach @$softwares;
    } "$test: registering";
}

foreach my $test (keys %hotfixes_tests) {
    $module->mock(
        'getWMIObjects',
        mockGetWMIObjects($test)
    );

    my $hotfixes = FusionInventory::Agent::Task::Inventory::Win32::Softwares::_getHotfixesList(is64bit => 0);
    cmp_deeply(
        $hotfixes,
        $hotfixes_tests{$test},
        "$test hotfixes list"
    );
}

sub compare {
    return
        $a->{NAME}      cmp $b->{NAME}     ||
        $a->{GUID}      cmp $b->{GUID}     ||
        $a->{PUBLISHER} cmp $b->{PUBLISHER};
}
