# Generated by default/object.tt
package Paws::WAFV2::FirewallManagerStatement;
  use Moose;
  has ManagedRuleGroupStatement => (is => 'ro', isa => 'Paws::WAFV2::ManagedRuleGroupStatement');
  has RuleGroupReferenceStatement => (is => 'ro', isa => 'Paws::WAFV2::RuleGroupReferenceStatement');

1;

### main pod documentation begin ###

=head1 NAME

Paws::WAFV2::FirewallManagerStatement

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::WAFV2::FirewallManagerStatement object:

  $service_obj->Method(Att1 => { ManagedRuleGroupStatement => $value, ..., RuleGroupReferenceStatement => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::WAFV2::FirewallManagerStatement object:

  $result = $service_obj->Method(...);
  $result->Att1->ManagedRuleGroupStatement

=head1 DESCRIPTION

The processing guidance for an Firewall Manager rule. This is like a
regular rule Statement, but it can only contain a rule group reference.

=head1 ATTRIBUTES


=head2 ManagedRuleGroupStatement => L<Paws::WAFV2::ManagedRuleGroupStatement>

A rule statement used to run the rules that are defined in a managed
rule group. To use this, provide the vendor name and the name of the
rule group in this statement. You can retrieve the required names by
calling ListAvailableManagedRuleGroups.

You cannot nest a C<ManagedRuleGroupStatement>, for example for use
inside a C<NotStatement> or C<OrStatement>. It can only be referenced
as a top-level statement within a rule.


=head2 RuleGroupReferenceStatement => L<Paws::WAFV2::RuleGroupReferenceStatement>

A rule statement used to run the rules that are defined in a RuleGroup.
To use this, create a rule group with your rules, then provide the ARN
of the rule group in this statement.

You cannot nest a C<RuleGroupReferenceStatement>, for example for use
inside a C<NotStatement> or C<OrStatement>. It can only be referenced
as a top-level statement within a rule.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::WAFV2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

