package Shipment::FedEx::WSDL::RateTypes::EMailNotificationDetail;
$Shipment::FedEx::WSDL::RateTypes::EMailNotificationDetail::VERSION = '2.00';
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns {'http://fedex.com/ws/rate/v9'}

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{    # BLOCK to scope variables

    my %PersonalMessage_of : ATTR(:get<PersonalMessage>);
    my %Recipients_of : ATTR(:get<Recipients>);

    __PACKAGE__->_factory(
        [   qw(        PersonalMessage
              Recipients

              )
        ],
        {   'PersonalMessage' => \%PersonalMessage_of,
            'Recipients'      => \%Recipients_of,
        },
        {   'PersonalMessage' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
            'Recipients' =>
              'Shipment::FedEx::WSDL::RateTypes::EMailNotificationRecipient',
        },
        {

            'PersonalMessage' => 'PersonalMessage',
            'Recipients'      => 'Recipients',
        }
    );

}    # end BLOCK


1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Shipment::FedEx::WSDL::RateTypes::EMailNotificationDetail

=head1 VERSION

version 2.00

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
EMailNotificationDetail from the namespace http://fedex.com/ws/rate/v9.

Information describing email notifications that will be sent in relation to events that occur during package movement

=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * PersonalMessage (min/maxOccurs: 0/1)

=item * Recipients (min/maxOccurs: 0/6)

=back

=head1 NAME

Shipment::FedEx::WSDL::RateTypes::EMailNotificationDetail

=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # Shipment::FedEx::WSDL::RateTypes::EMailNotificationDetail
   PersonalMessage =>  $some_value, # string
   Recipients =>  { # Shipment::FedEx::WSDL::RateTypes::EMailNotificationRecipient
     EMailNotificationRecipientType => $some_value, # EMailNotificationRecipientType
     EMailAddress =>  $some_value, # string
     NotifyOnShipment =>  $some_value, # boolean
     NotifyOnException =>  $some_value, # boolean
     NotifyOnDelivery =>  $some_value, # boolean
     Format => $some_value, # EMailNotificationFormatType
     Localization =>  { # Shipment::FedEx::WSDL::RateTypes::Localization
       LanguageCode =>  $some_value, # string
       LocaleCode =>  $some_value, # string
     },
   },
 },

=head1 AUTHOR

Generated by SOAP::WSDL

=head1 AUTHOR

Andrew Baerg <baergaj@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2013 by Andrew Baerg.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
