# Generated by default/object.tt
package Paws::CloudFront::EndPoint;
  use Moose;
  has KinesisStreamConfig => (is => 'ro', isa => 'Paws::CloudFront::KinesisStreamConfig');
  has StreamType => (is => 'ro', isa => 'Str', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::CloudFront::EndPoint

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::CloudFront::EndPoint object:

  $service_obj->Method(Att1 => { KinesisStreamConfig => $value, ..., StreamType => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::CloudFront::EndPoint object:

  $result = $service_obj->Method(...);
  $result->Att1->KinesisStreamConfig

=head1 DESCRIPTION

Contains information about the Amazon Kinesis data stream where you are
sending real-time log data in a real-time log configuration.

=head1 ATTRIBUTES


=head2 KinesisStreamConfig => L<Paws::CloudFront::KinesisStreamConfig>

Contains information about the Amazon Kinesis data stream where you are
sending real-time log data.


=head2 B<REQUIRED> StreamType => Str

The type of data stream where you are sending real-time log data. The
only valid value is C<Kinesis>.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::CloudFront>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

