# Generated by default/object.tt
package Paws::Lambda::SelfManagedEventSource;
  use Moose;
  has Endpoints => (is => 'ro', isa => 'Paws::Lambda::Endpoints');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Lambda::SelfManagedEventSource

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Lambda::SelfManagedEventSource object:

  $service_obj->Method(Att1 => { Endpoints => $value, ..., Endpoints => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Lambda::SelfManagedEventSource object:

  $result = $service_obj->Method(...);
  $result->Att1->Endpoints

=head1 DESCRIPTION

The Self-Managed Apache Kafka cluster for your event source.

=head1 ATTRIBUTES


=head2 Endpoints => L<Paws::Lambda::Endpoints>

The list of bootstrap servers for your Kafka brokers in the following
format: C<"KAFKA_BOOTSTRAP_SERVERS":
["abc.xyz.com:xxxx","abc2.xyz.com:xxxx"]>.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Lambda>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

