/*                                                                
**  Copyright (C) 1995,2007,2008,2010  Smithsonian Astrophysical Observatory 
*/                                                                

/*                                                                          */
/*  This program is free software; you can redistribute it and/or modify    */
/*  it under the terms of the GNU General Public License as published by    */
/*  the Free Software Foundation; either version 3 of the License, or       */
/*  (at your option) any later version.                                     */
/*                                                                          */
/*  This program is distributed in the hope that it will be useful,         */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/*  GNU General Public License for more details.                            */
/*                                                                          */
/*  You should have received a copy of the GNU General Public License along */
/*  with this program; if not, write to the Free Software Foundation, Inc., */
/*  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.             */
/*                                                                          */


/*H****************************************************************************

* FILE NAME: %M%

* DEVELOPMENT:  UI

* DESCRIPTION:

	This routine contains utility routines for the Parameter
	interface file.


* NOTES:  



* REVISION HISTORY:

        Ref. No.        Date
        --------        ----
	%I%		%G%

*H******************************************************/

#include <sys/param.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>

#include "ParameterUtils.h"

#define PARAM_EXT      ".par"
#define PARAM_KEYWORDU " PFILE="
#define PARAM_KEYWORDL " pfile="
#define PARAM_KEYWORDA "@@"

int
cxcparam_find_file (const char *env, const char *name, const int mode,
		    char *ret_path);


/* Search given PATH directories and check access of given filename.    */
/* Mode is read (R_OK), write (W_OK), execute (X_OK), or exists (F_OK). */
int
cxcparam_find_file (const char *env, const char *name, const int mode,
		    char *ret_path)
{
  char *path, *ptr, *save_path = NULL;
  char buffer[MAXPATHLEN] = "";
  int retval = 0;

  if (!name)
    return retval;

  /* copy the PATH environment variable */
  if (env)
    {
      save_path = path = (char *) calloc (1, strlen (env) + 1);
      strcpy (path, env);
    }
  else
    path = ".";

  /* parse through the path names, separated by colons and */
  /* check each path for the executable file */
  ptr = path;
  while (ptr)
    {
      if ((ptr = strchr (path, ':')) || (ptr = strchr (path, ' ')))
	*ptr = '\0';
      sprintf (buffer, "%s/%s", path, name);

      if (access (buffer, mode) == 0)
	{
	  retval = 1;
	  break;
	}
      path = ptr + 1;
    }
  if (save_path)
    free (save_path);
  if (retval && ret_path)
    strcpy (ret_path, buffer);
  return retval;
}


/* ------------------------------------------------------------------ */
/* Searches the current directory and then the environment            */
/* ASCDS_USER_PARAM and ASCDS_SYS_PARAM directories and verifies that */
/* the input file name exists in one of those directories.            */
/* ------------------------------------------------------------------ */
int
ParameterExists (char *tool_name, char *ret_path)
{
  int ii;
  char *env;
  char *ext;
  char full_toolname[MAXPATHLEN];
  char explicit_path[MAXPATHLEN];
  char current_dir[MAXPATHLEN];
  int retval = 0;

  if (!tool_name || *tool_name == '\0')
    return retval;

  getcwd (&current_dir[0], sizeof (current_dir));

  ext = strstr (tool_name, PARAM_EXT);
  strcpy (full_toolname, tool_name);
  if (!ext)
    strcat (full_toolname, PARAM_EXT);

  ii = strlen (full_toolname);
  while ((ii >= 0) && (full_toolname[ii] != '/'))
    ii--;

  if (ii == -1)
    {
      /* path not explicitly provided- use local path */
      env = &current_dir[0];
    }
  else
    {
      /* split into path and toolname */
      strcpy (explicit_path, full_toolname);
      explicit_path[ii] = '\0';
      strcpy (full_toolname, &explicit_path[ii + 1]);
      env = &explicit_path[0];
    }

  /* First check if an explicit path is provided, then     */
  /* check the current directory.  If you don't find       */
  /* the *.par file, check the PDIRS, PFILES, UPARMS,      */
  /* ASCDS_USER_PARAM and ASCDS_SYS_PARAM env vars         */
  for (ii = 0; ii < 7 || retval; ii++)
    {
      switch (ii)
	{
	case 0:
	  /* do nothing- value already set */
	  break;
	case 1:
	  env = &current_dir[0];
	  break;
	case 2:
	  env = (char *) getenv ("PDIRS");
	  break;
	case 3:
	  env = (char *) getenv ("PFILES");
	  break;
	case 4:
	  env = (char *) getenv ("UPARM");
	  break;
	case 5:
	  env = (char *) getenv ("ASCDS_USER_PARAM");
	  break;
	case 6:
	  env = (char *) getenv ("ASCDS_SYS_PARAM");
	  break;
	default:
	  env = &current_dir[0];
	  break;
	}

      if (env)
	{
	  if ((retval =
	       cxcparam_find_file (env, full_toolname, F_OK, ret_path)))
	    break;
	}
    }

  return retval;
}



/* ------------------------------------------------------------------ */
/* Check the input string for the parameter keyword 'pfile=' or '@@'  */
/* If found, return pfile/@@ parameter name                           */
/* ------------------------------------------------------------------ */
int
ParameterParsePfile (char *str, char *ret_file)
{
  int ret_stat = 0;
  char *ptr;

  ptr = strstr (str, PARAM_KEYWORDU);
  if (ptr)
    {
      ptr = strchr (ptr, '=');
      ptr += 1;
    }
  else
    {
      ptr = strstr (str, PARAM_KEYWORDL);
      if (ptr)
	{
	  ptr = strchr (ptr, '=');
	  ptr += 1;
	}
      else
	{
	  ptr = strstr (str, PARAM_KEYWORDA);
	  if (ptr)
	    ptr += 2;
	}
    }

  /* we found the = sign, so lets return a pointer to the first non- */
  /* white space after the equals */
  if (ptr)
    {
      if (sscanf (ptr, "%s", ret_file) == 1)
	ret_stat = 1;
    }
  return ret_stat;
}
