
package Paws::SecurityHub::DescribeHub;
  use Moose;
  has HubArn => (is => 'ro', isa => 'Str', traits => ['ParamInQuery'], query_name => 'HubArn');

  use MooseX::ClassAttribute;

  class_has _api_call => (isa => 'Str', is => 'ro', default => 'DescribeHub');
  class_has _api_uri  => (isa => 'Str', is => 'ro', default => '/accounts');
  class_has _api_method  => (isa => 'Str', is => 'ro', default => 'GET');
  class_has _returns => (isa => 'Str', is => 'ro', default => 'Paws::SecurityHub::DescribeHubResponse');
1;

### main pod documentation begin ###

=head1 NAME

Paws::SecurityHub::DescribeHub - Arguments for method DescribeHub on L<Paws::SecurityHub>

=head1 DESCRIPTION

This class represents the parameters used for calling the method DescribeHub on the
L<AWS SecurityHub|Paws::SecurityHub> service. Use the attributes of this class
as arguments to method DescribeHub.

You shouldn't make instances of this class. Each attribute should be used as a named argument in the call to DescribeHub.

=head1 SYNOPSIS

    my $securityhub = Paws->service('SecurityHub');
    my $DescribeHubResponse = $securityhub->DescribeHub(
      HubArn => 'MyNonEmptyString',    # OPTIONAL
    );

    # Results:
    my $AutoEnableControls = $DescribeHubResponse->AutoEnableControls;
    my $HubArn             = $DescribeHubResponse->HubArn;
    my $SubscribedAt       = $DescribeHubResponse->SubscribedAt;

    # Returns a L<Paws::SecurityHub::DescribeHubResponse> object.

Values for attributes that are native types (Int, String, Float, etc) can passed as-is (scalar values). Values for complex Types (objects) can be passed as a HashRef. The keys and values of the hashref will be used to instance the underlying object.
For the AWS API documentation, see L<https://docs.aws.amazon.com/goto/WebAPI/securityhub/DescribeHub>

=head1 ATTRIBUTES


=head2 HubArn => Str

The ARN of the Hub resource to retrieve.




=head1 SEE ALSO

This class forms part of L<Paws>, documenting arguments for method DescribeHub in L<Paws::SecurityHub>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

