package Sah::Schema::example::has_merge;

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2021-07-30'; # DATE
our $DIST = 'Sah-Schemas-Examples'; # DIST
our $VERSION = '0.009'; # VERSION

our $schema = [posint => {
    summary => 'Even integer',
    description => <<'_',

This schema is based on "posint", which is ["int", {min=>1}], and adds another
clause div_by=>2. However, this schema also deletes the min=>1 clause using
merge key: merge.delete.min=>undef. Thus, the resolved result becomes ["int",
{div_by=>2}] which is basically "even integer". Without the merge key, this
schema would become "positive even integer."

_
    'merge.delete.min' => undef,
    div_by => 2,
}];

1;
# ABSTRACT: Even integer

__END__

=pod

=encoding UTF-8

=head1 NAME

Sah::Schema::example::has_merge - Even integer

=head1 VERSION

This document describes version 0.009 of Sah::Schema::example::has_merge (from Perl distribution Sah-Schemas-Examples), released on 2021-07-30.

=head1 SYNOPSIS

To check data against this schema (requires L<Data::Sah>):

 use Data::Sah qw(gen_validator);
 my $validator = gen_validator("example::has_merge*");
 say $validator->($data) ? "valid" : "INVALID!";

 # Data::Sah can also create validator that returns nice error message string
 # and/or coerced value. Data::Sah can even create validator that targets other
 # language, like JavaScript. All from the same schema. See its documentation
 # for more details.

To validate function parameters against this schema (requires L<Params::Sah>):

 use Params::Sah qw(gen_validator);

 sub myfunc {
     my @args = @_;
     state $validator = gen_validator("example::has_merge*");
     $validator->(\@args);
     ...
 }

To specify schema in L<Rinci> function metadata and use the metadata with
L<Perinci::CmdLine> to create a CLI:

 # in lib/MyApp.pm
 package
   MyApp;
 our %SPEC;
 $SPEC{myfunc} = {
     v => 1.1,
     summary => 'Routine to do blah ...',
     args => {
         arg1 => {
             summary => 'The blah blah argument',
             schema => ['example::has_merge*'],
         },
         ...
     },
 };
 sub myfunc {
     my %args = @_;
     ...
 }
 1;

 # in myapp.pl
 package
   main;
 use Perinci::CmdLine::Any;
 Perinci::CmdLine::Any->new(url=>'/MyApp/myfunc')->run;

 # in command-line
 % ./myapp.pl --help
 myapp - Routine to do blah ...
 ...

 % ./myapp.pl --version

 % ./myapp.pl --arg1 ...

=head1 DESCRIPTION

This schema is based on "posint", which is ["int", {min=>1}], and adds another
clause div_by=>2. However, this schema also deletes the min=>1 clause using
merge key: merge.delete.min=>undef. Thus, the resolved result becomes ["int",
{div_by=>2}] which is basically "even integer". Without the merge key, this
schema would become "positive even integer."

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Sah-Schemas-Examples>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Sah-Schemas-Examples>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Sah-Schemas-Examples>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2021, 2020, 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
