#!/usr/bin/perl

package eBay::API::XML::DataType::Enum::URLTypeCodeType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. URLTypeCodeType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::Enum::URLTypeCodeType

=head1 DESCRIPTION

A compressed, representative title for the eBay URL.



=head1 SYNOPSIS

=cut



=head1 Enums:

=cut


=head2 ViewItemURL

URL Prefix for viewing a particular listing. Just add an item id.



=cut


use constant ViewItemURL => scalar('ViewItemURL');


=head2 ViewUserURL

URL Prefix for viewing the feedback for a particular userid. Just add a userid.



=cut


use constant ViewUserURL => scalar('ViewUserURL');


=head2 MyeBayURL

Full URL for an eBay login page.



=cut


use constant MyeBayURL => scalar('MyeBayURL');


=head2 MyeBayBiddingURL

Full URL for viewing the items on which the user is bidding.



=cut


use constant MyeBayBiddingURL => scalar('MyeBayBiddingURL');


=head2 MyeBayNotWonURL

Full URL for viewing the items on which the user bid but did not win.



=cut


use constant MyeBayNotWonURL => scalar('MyeBayNotWonURL');


=head2 MyeBayWonURL

Full URL for viewing the items on which the user bid and also won.



=cut


use constant MyeBayWonURL => scalar('MyeBayWonURL');


=head2 MyeBayWatchingURL

Full URL for viewing the items the user is currently watching.



=cut


use constant MyeBayWatchingURL => scalar('MyeBayWatchingURL');


=head2 eBayStoreURL

Full URL for eBay Stores.



=cut


use constant eBayStoreURL => scalar('eBayStoreURL');


=head2 SmallLogoURL

Full URL for the small version of the "An eBay Marketplace" logo.



=cut


use constant SmallLogoURL => scalar('SmallLogoURL');


=head2 MediumLogoURL

Full URL for the medium version of the "An eBay Marketplace" logo.



=cut


use constant MediumLogoURL => scalar('MediumLogoURL');


=head2 LargeLogoURL

Full URL for the large version of the "An eBay Marketplace" logo.



=cut


use constant LargeLogoURL => scalar('LargeLogoURL');


=head2 CustomCode

Reserved for future use.



=cut


use constant CustomCode => scalar('CustomCode');







1;   
