# Generated by default/object.tt
package Paws::Chime::ChannelSummary;
  use Moose;
  has ChannelArn => (is => 'ro', isa => 'Str');
  has LastMessageTimestamp => (is => 'ro', isa => 'Str');
  has Metadata => (is => 'ro', isa => 'Str');
  has Mode => (is => 'ro', isa => 'Str');
  has Name => (is => 'ro', isa => 'Str');
  has Privacy => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Chime::ChannelSummary

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Chime::ChannelSummary object:

  $service_obj->Method(Att1 => { ChannelArn => $value, ..., Privacy => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Chime::ChannelSummary object:

  $result = $service_obj->Method(...);
  $result->Att1->ChannelArn

=head1 DESCRIPTION

Summary of the details of a C<Channel>.

=head1 ATTRIBUTES


=head2 ChannelArn => Str

The ARN of the channel.


=head2 LastMessageTimestamp => Str

The time at which the last message in a channel was sent.


=head2 Metadata => Str

The metadata of the channel.


=head2 Mode => Str

The mode of the channel.


=head2 Name => Str

The name of the channel.


=head2 Privacy => Str

The privacy setting of the channel.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Chime>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

