/*    Normalizer.xs
 *
 *    $Id: Normalizer.xs,v 1.3 2001/06/05 07:29:59 mrperl Exp $
 *
 *    Copyright (c) 2000 Brian Stell and James
 *
 *    This package is free software and is provided ``as is'' without
 *    express or implied warranty. It may be used, redistributed and/or
 *    modified under the terms of the Perl Artistic License
 *    (see http://www.perl.com/perl/misc/Artistic.html)
 *
 */

extern "C" {
#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"
}

#include  "picu/picu_debug.h"
#include  "picu/picu_utf8.h"
#include  "picu/Normalizer.h"
#include  "unicode/normlzr.h"

static int debugLevel = 0;

/*
 * Note: constant_iv returns a integer (not double)
 */
static IV
constant_iv(char *name, int arg)
{
    errno = 0;
    switch (*name) {
    case 'C':
        if (strEQ(name, "COMPOSE"))
           return Normalizer::COMPOSE;
        else if (strEQ(name, "COMPOSE_COMPAT"))
           return Normalizer::COMPOSE_COMPAT;
        else if (strEQ(name, "COMPOSE_BIT"))
           return Normalizer::COMPOSE_BIT;
        else if (strEQ(name, "COMPAT_BIT"))
           return Normalizer::COMPAT_BIT;
        break;
    case 'D':
        if (strEQ(name, "DECOMP"))
           return Normalizer::DECOMP;
        else if (strEQ(name, "DECOMP_COMPAT"))
           return Normalizer::DECOMP_COMPAT;
        else if (strEQ(name, "DECOMP_BIT"))
           return Normalizer::DECOMP_BIT;
        else if (strEQ(name, "DONE"))
           return Normalizer::DONE;
    case 'I':
        if (strEQ(name, "IGNORE_HANGUL"))
           return Normalizer::IGNORE_HANGUL;
    case 'N':
        if (strEQ(name, "NO_OP"))
           return Normalizer::NO_OP;
    }
    errno = EINVAL;
    return 0;

/* if a value should be defined but is not */
not_there:
    errno = ENOENT;
    return 0;
}

typedef enum Normalizer::EMode Normalizer__EMode;

MODULE = ICU::Normalizer    PACKAGE = ICU::Normalizer  

# This requires xsubpp version 1.925 or greater
REQUIRE: 1.925

IV
constant_iv(name,arg)
        char *name
        int   arg

char *
normalize(s, mode, options, status)
        char *			s;
	Normalizer__EMode	mode;
	int32_t			options;
	UErrorCode		status = U_ZERO_ERROR;
    PREINIT:
	UnicodeString		source(s, "UTF-8");
	UnicodeString		result;
        U8 *			u8str;
        uint32_t 		u8len;
	SV *			sv_status = NULL;
    CODE:
        Normalizer::normalize(source, mode, options, result, status);
        if (sv_status) {
            sv_setiv(sv_status, (IV)status);
        }
        u8str = UnicodeStringToU8String(result, &u8len);
        ST(0) = sv_newmortal();
        sv_usepvn(ST(0), (char*)u8str, u8len);
    OUTPUT:

char *
compose(s, compat, options, status)
        char *			s;
	UBool			compat;
	int32_t			options;
	UErrorCode		status = U_ZERO_ERROR;
    PREINIT:
	UnicodeString		source(s, "UTF-8");
	UnicodeString		result;
        U8 *			u8str;
        uint32_t 		u8len;
	SV *			sv_status = NULL;
    CODE:
        Normalizer::compose(source, compat, options, result, status);
        if (sv_status) {
            sv_setiv(sv_status, (IV)status);
        }
        u8str = UnicodeStringToU8String(result, &u8len);
        ST(0) = sv_newmortal();
        sv_usepvn(ST(0), (char*)u8str, u8len);
    OUTPUT:

char *
decompose(s, compat, options, status)
        char *			s;
	UBool			compat;
	int32_t			options;
	UErrorCode		status = U_ZERO_ERROR;
    PREINIT:
	UnicodeString		source(s, "UTF-8");
	UnicodeString		result;
        U8 *			u8str;
        uint32_t 		u8len;
	SV *			sv_status = NULL;
    CODE:
        Normalizer::decompose(source, compat, options, result, status);
        if (sv_status) {
            sv_setiv(sv_status, (IV)status);
        }
        u8str = UnicodeStringToU8String(result, &u8len);
        ST(0) = sv_newmortal();
        sv_usepvn(ST(0), (char*)u8str, u8len);
    OUTPUT:

