use Test::Most;
use Test::PAUSE::ConsistentPermissions::Check;

BEGIN {
    plan skip_all => 'Set LIVE_TEST environmental variable to test this.' unless $ENV{LIVE_TEST};
}
# NOTE: this test is very likely to fail as it's checking the state of cpan itself.

# FIXME: make sure this is optional.
use PAUSE::Packages;
my $pp = PAUSE::Packages->new;
my $perms_test = Test::PAUSE::ConsistentPermissions::Check->new;

sub check_package
{
    my $dist = shift;
    my $module = shift;
    my $release_info = $pp->release($dist);
    my @modules = map { $_->name } @{$release_info->modules};
    my $problems = $perms_test->report_problems(\@modules, $module);
}

# FIXME: make use of local file.
# then we don't need the guff (perhaps)
eq_or_diff check_package('OpusVL-AppKit', 'OpusVL::AppKit'), {
    module => 'OpusVL::AppKit',
    owner => 'NEWELLC',
    comaint => [qw/ALTREUS BRADH JONALLEN NMBOOKER/],
    problems => [
    ],
};
eq_or_diff check_package('Test-DBIx-Class', 'Test::DBIx::Class'), {
    module => 'Test::DBIx::Class',
    owner => 'JJNAPIORK',
    comaint => [qw/NEWELLC PHAYLON/],
    problems => [
    ],
};
eq_or_diff check_package('DBIx-Class-Migration', 'DBIx::Class::Migration'), {
    module => 'DBIx::Class::Migration',
    owner => 'JJNAPIORK',
    comaint => [qw/PNU SKAUFMAN/],
    problems => [
        {
            module => 'DBIx::Class::Migration::SandboxDirSandboxBuilder',
            issues => {
                missing => ['PNU', 'SKAUFMAN'],
            },
        },
        {
            module => 'Test::DBIx::Class::FixtureCommand::Population',
            issues => {
                extra => ['NEWELLC']
            },
        },
    ],
};
my $report = check_package('Moose', 'Moose');
eq_or_diff $report, {"comaint" => ["DOY","DROLSKY","ETHER","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"],"module" => "Moose","owner" => "STEVAN","problems" => [{"issues" => {"missing" => ["GRODITI"]},"module" => "Class::MOP::Method::Inlined"},{"issues" => {"missing" => ["GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Class::MOP::Method::Meta"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Class::MOP::Overload"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Cookbook"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Cookbook::Basics::BankAccount_MethodModifiersAndSubclassing"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Cookbook::Basics::BinaryTree_AttributeFeatures"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Cookbook::Basics::BinaryTree_BuilderAndLazyBuild"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Cookbook::Basics::Company_Subtypes"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Cookbook::Basics::DateTime_ExtendingNonMooseParent"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Cookbook::Basics::Document_AugmentAndInner"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Cookbook::Basics::Genome_OverloadingSubtypesAndCoercion"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Cookbook::Basics::HTTP_SubtypesAndCoercion"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Cookbook::Basics::Immutable"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Cookbook::Basics::Person_BUILDARGSAndBUILD"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Cookbook::Basics::Point_AttributesAndSubclassing"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Cookbook::Extending::Debugging_BaseClassRole"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Cookbook::Extending::ExtensionOverview"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Cookbook::Extending::Mooseish_MooseSugar"},{"issues" => {"missing" => ["DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Cookbook::Legacy::Debugging_BaseClassReplacement"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Cookbook::Legacy::Labeled_AttributeMetaclass"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Cookbook::Legacy::Table_ClassMetaclass"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Cookbook::Meta::GlobRef_InstanceMetaclass"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Cookbook::Meta::Labeled_AttributeTrait"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Cookbook::Meta::PrivateOrPublic_MethodMetaclass"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Cookbook::Meta::Table_MetaclassTrait"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Cookbook::Meta::WhyMeta"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Cookbook::Roles::ApplicationToInstance"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Cookbook::Roles::Comparable_CodeReuse"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Cookbook::Roles::Restartable_AdvancedComposition"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Cookbook::Snack::Keywords"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Cookbook::Snack::Types"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Cookbook::Style"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::AccessorMustReadWrite"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::AddParameterizableTypeTakesParameterizableType"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::AddRoleTakesAMooseMetaRoleInstance"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::AddRoleToARoleTakesAMooseMetaRole"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::ApplyTakesABlessedInstance"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::AttachToClassNeedsAClassMOPClassInstanceOrASubclass"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::AttributeConflictInRoles"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::AttributeConflictInSummation"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::AttributeExtensionIsNotSupportedInRoles"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::AttributeIsRequired"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::AttributeMustBeAnClassMOPMixinAttributeCoreOrSubclass"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::AttributeNamesDoNotMatch"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::AttributeValueIsNotAnObject"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::AttributeValueIsNotDefined"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::AutoDeRefNeedsArrayRefOrHashRef"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::BadOptionFormat"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::BothBuilderAndDefaultAreNotAllowed"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::BuilderDoesNotExist"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::BuilderMethodNotSupportedForAttribute"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::BuilderMethodNotSupportedForInlineAttribute"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::BuilderMustBeAMethodName"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::CallingMethodOnAnImmutableInstance"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::CallingReadOnlyMethodOnAnImmutableInstance"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::CanExtendOnlyClasses"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::CannotAddAdditionalTypeCoercionsToUnion"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::CannotAddAsAnAttributeToARole"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::CannotApplyBaseClassRolesToRole"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::CannotAssignValueToReadOnlyAccessor"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::CannotAugmentIfLocalMethodPresent"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::CannotAugmentNoSuperMethod"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::CannotAutoDereferenceTypeConstraint"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::CannotAutoDerefWithoutIsa"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::CannotCalculateNativeType"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::CannotCallAnAbstractBaseMethod"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::CannotCallAnAbstractMethod"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::CannotCoerceAttributeWhichHasNoCoercion"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::CannotCoerceAWeakRef"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::CannotCreateHigherOrderTypeWithoutATypeParameter"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::CannotCreateMethodAliasLocalMethodIsPresent"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::CannotCreateMethodAliasLocalMethodIsPresentInClass"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::CannotDelegateLocalMethodIsPresent"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::CannotDelegateWithoutIsa"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::CannotFindDelegateMetaclass"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::CannotFindType"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::CannotFindTypeGivenToMatchOnType"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::CannotFixMetaclassCompatibility"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::CannotGenerateInlineConstraint"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::CannotInitializeMooseMetaRoleComposite"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::CannotInlineTypeConstraintCheck"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::CannotLocatePackageInINC"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::CannotMakeMetaclassCompatible"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::CannotOverrideALocalMethod"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::CannotOverrideBodyOfMetaMethods"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::CannotOverrideLocalMethodIsPresent"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::CannotOverrideNoSuperMethod"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::CannotRegisterUnnamedTypeConstraint"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::CannotUseLazyBuildAndDefaultSimultaneously"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::CanOnlyConsumeRole"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::CanOnlyWrapBlessedCode"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::CanReblessOnlyIntoASubclass"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::CanReblessOnlyIntoASuperclass"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::CircularReferenceInAlso"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::ClassDoesNotHaveInitMeta"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::ClassDoesTheExcludedRole"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::ClassNamesDoNotMatch"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::CloneObjectExpectsAnInstanceOfMetaclass"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::CodeBlockMustBeACodeRef"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::CoercingWithoutCoercions"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::CoercionAlreadyExists"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::CoercionNeedsTypeConstraint"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::ConflictDetectedInCheckRoleExclusions"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::ConflictDetectedInCheckRoleExclusionsInToClass"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::ConstructClassInstanceTakesPackageName"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::CouldNotCreateMethod"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::CouldNotCreateWriter"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::CouldNotEvalConstructor"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::CouldNotEvalDestructor"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::CouldNotFindTypeConstraintToCoerceFrom"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::CouldNotGenerateInlineAttributeMethod"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::CouldNotLocateTypeConstraintForUnion"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::CouldNotParseType"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::CreateMOPClassTakesArrayRefOfAttributes"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::CreateMOPClassTakesArrayRefOfSuperclasses"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::CreateMOPClassTakesHashRefOfMethods"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::CreateTakesArrayRefOfRoles"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::CreateTakesHashRefOfAttributes"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::CreateTakesHashRefOfMethods"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::DefaultToMatchOnTypeMustBeCodeRef"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::DelegationToAClassWhichIsNotLoaded"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::DelegationToARoleWhichIsNotLoaded"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::DelegationToATypeWhichIsNotAClass"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::DoesRequiresRoleName"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::EnumCalledWithAnArrayRefAndAdditionalArgs"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::EnumValuesMustBeString"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::ExtendsMissingArgs"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::HandlesMustBeAHashRef"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::IllegalInheritedOptions"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::IllegalMethodTypeToAddMethodModifier"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::IncompatibleMetaclassOfSuperclass"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::InitializeTakesUnBlessedPackageName"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::InitMetaRequiresClass"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::InstanceBlessedIntoWrongClass"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::InstanceMustBeABlessedReference"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::InvalidArgPassedToMooseUtilMetaRole"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::InvalidArgumentsToTraitAliases"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::InvalidArgumentToMethod"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::InvalidBaseTypeGivenToCreateParameterizedTypeConstraint"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::InvalidHandleValue"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::InvalidHasProvidedInARole"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::InvalidNameForType"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::InvalidOverloadOperator"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::InvalidRoleApplication"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::InvalidTypeConstraint"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::InvalidTypeGivenToCreateParameterizedTypeConstraint"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::InvalidValueForIs"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::IsaDoesNotDoTheRole"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::IsaLacksDoesMethod"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::LazyAttributeNeedsADefault"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::Legacy"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::MatchActionMustBeACodeRef"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::MessageParameterMustBeCodeRef"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::MetaclassIsAClassNotASubclassOfGivenMetaclass"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::MetaclassIsARoleNotASubclassOfGivenMetaclass"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::MetaclassIsNotASubclassOfGivenMetaclass"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::MetaclassMustBeASubclassOfMooseMetaClass"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::MetaclassMustBeASubclassOfMooseMetaRole"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::MetaclassMustBeDerivedFromClassMOPClass"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::MetaclassNotLoaded"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::MetaclassTypeIncompatible"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::MethodExpectedAMetaclassObject"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::MethodExpectsFewerArgs"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::MethodExpectsMoreArgs"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::MethodModifierNeedsMethodName"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::MethodNameConflictInRoles"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::MethodNameNotFoundInInheritanceHierarchy"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::MethodNameNotGiven"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::MOPAttributeNewNeedsAttributeName"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::MustDefineAMethodName"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::MustDefineAnAttributeName"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::MustDefineAnOverloadOperator"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::MustHaveAtLeastOneValueToEnumerate"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::MustPassAHashOfOptions"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::MustPassAMooseMetaRoleInstanceOrSubclass"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::MustPassAPackageNameOrAnExistingClassMOPPackageInstance"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::MustPassEvenNumberOfArguments"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::MustPassEvenNumberOfAttributeOptions"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::MustProvideANameForTheAttribute"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::MustSpecifyAtleastOneMethod"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::MustSpecifyAtleastOneRole"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::MustSpecifyAtleastOneRoleToApplicant"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::MustSupplyAClassMOPAttributeInstance"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::MustSupplyADelegateToMethod"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::MustSupplyAMetaclass"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::MustSupplyAMooseMetaAttributeInstance"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::MustSupplyAnAccessorTypeToConstructWith"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::MustSupplyAnAttributeToConstructWith"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::MustSupplyArrayRefAsCurriedArguments"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::MustSupplyPackageNameAndName"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::NeedsTypeConstraintUnionForTypeCoercionUnion"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::NeitherAttributeNorAttributeNameIsGiven"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::NeitherClassNorClassNameIsGiven"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::NeitherRoleNorRoleNameIsGiven"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::NeitherTypeNorTypeNameIsGiven"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::NoAttributeFoundInSuperClass"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::NoBodyToInitializeInAnAbstractBaseClass"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::NoCasesMatched"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::NoConstraintCheckForTypeConstraint"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::NoDestructorClassSpecified"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::NoImmutableTraitSpecifiedForClass"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::NoParentGivenToSubtype"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::OnlyInstancesCanBeCloned"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::OperatorIsRequired"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::OverloadConflictInSummation"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::OverloadRequiresAMetaClass"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::OverloadRequiresAMetaMethod"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::OverloadRequiresAMetaOverload"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::OverloadRequiresAMethodNameOrCoderef"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::OverloadRequiresAnOperator"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::OverloadRequiresNamesForCoderef"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::OverrideConflictInComposition"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::OverrideConflictInSummation"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::PackageDoesNotUseMooseExporter"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::PackageNameAndNameParamsNotGivenToWrap"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::PackagesAndModulesAreNotCachable"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::ParameterIsNotSubtypeOfParent"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::ReferencesAreNotAllowedAsDefault"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::RequiredAttributeLacksInitialization"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::RequiredAttributeNeedsADefault"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::RequiredMethodsImportedByClass"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::RequiredMethodsNotImplementedByClass"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::Role::Attribute"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::Role::AttributeName"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::Role::Class"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::Role::EitherAttributeOrAttributeName"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::Role::Instance"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::Role::InstanceClass"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::Role::InvalidAttributeOptions"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::Role::Method"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::Role::ParamsHash"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::Role::Role"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::Role::RoleForCreate"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::Role::RoleForCreateMOPClass"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::Role::TypeConstraint"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::RoleDoesTheExcludedRole"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::RoleExclusionConflict"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::RoleNameRequired"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::RoleNameRequiredForMooseMetaRole"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::RolesDoNotSupportAugment"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::RolesDoNotSupportExtends"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::RolesDoNotSupportInner"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::RolesDoNotSupportRegexReferencesForMethodModifiers"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::RolesInCreateTakesAnArrayRef"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::RolesListMustBeInstancesOfMooseMetaRole"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::SingleParamsToNewMustBeHashRef"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::TriggerMustBeACodeRef"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::TypeConstraintCannotBeUsedForAParameterizableType"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::TypeConstraintIsAlreadyCreated"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::TypeParameterMustBeMooseMetaType"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::UnableToCanonicalizeHandles"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::UnableToCanonicalizeNonRolePackage"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::UnableToRecognizeDelegateMetaclass"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::UndefinedHashKeysPassedToMethod"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::UnionCalledWithAnArrayRefAndAdditionalArgs"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::UnionTakesAtleastTwoTypeNames"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::ValidationFailedForInlineTypeConstraint"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::ValidationFailedForTypeConstraint"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::WrapTakesACodeRefToBless"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Exception::WrongTypeConstraintGiven"},{"issues" => {"missing" => ["GRODITI"]},"module" => "Moose::Exporter"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Intro"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Manual"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Manual::Attributes"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Manual::BestPractices"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Manual::Classes"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Manual::Concepts"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Manual::Construction"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Manual::Contributing"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Manual::Delegation"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Manual::Delta"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Manual::Exceptions"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Manual::Exceptions::Manifest"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Manual::FAQ"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Manual::MethodModifiers"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Manual::MooseX"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Manual::MOP"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Manual::Resources"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Manual::Roles"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Manual::Support"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Manual::Types"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Manual::Unsweetened"},{"issues" => {"missing" => ["GRODITI"]},"module" => "Moose::Meta::Attribute::Custom::Moose"},{"issues" => {"missing" => ["GRODITI"]},"module" => "Moose::Meta::Attribute::Native"},{"issues" => {"missing" => ["GRODITI"]},"module" => "Moose::Meta::Attribute::Native::Trait::Array"},{"issues" => {"missing" => ["GRODITI"]},"module" => "Moose::Meta::Attribute::Native::Trait::Bool"},{"issues" => {"missing" => ["GRODITI"]},"module" => "Moose::Meta::Attribute::Native::Trait::Code"},{"issues" => {"missing" => ["GRODITI"]},"module" => "Moose::Meta::Attribute::Native::Trait::Counter"},{"issues" => {"missing" => ["GRODITI"]},"module" => "Moose::Meta::Attribute::Native::Trait::Hash"},{"issues" => {"missing" => ["GRODITI"]},"module" => "Moose::Meta::Attribute::Native::Trait::Number"},{"issues" => {"missing" => ["GRODITI"]},"module" => "Moose::Meta::Attribute::Native::Trait::String"},{"issues" => {"missing" => ["GRODITI"]},"module" => "Moose::Meta::Method::Augmented"},{"issues" => {"missing" => ["GRODITI"]},"module" => "Moose::Meta::Method::Delegation"},{"issues" => {"missing" => ["GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Meta::Method::Meta"},{"issues" => {"missing" => ["GRODITI"]},"module" => "Moose::Meta::Method::Overridden"},{"issues" => {"missing" => ["GRODITI"]},"module" => "Moose::Meta::Role::Application"},{"issues" => {"missing" => ["GRODITI"]},"module" => "Moose::Meta::Role::Application::RoleSummation"},{"issues" => {"missing" => ["GRODITI"]},"module" => "Moose::Meta::Role::Application::ToClass"},{"issues" => {"missing" => ["GRODITI"]},"module" => "Moose::Meta::Role::Application::ToInstance"},{"issues" => {"missing" => ["GRODITI"]},"module" => "Moose::Meta::Role::Application::ToRole"},{"issues" => {"missing" => ["GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Meta::Role::Attribute"},{"issues" => {"missing" => ["GRODITI"]},"module" => "Moose::Meta::Role::Composite"},{"issues" => {"missing" => ["GRODITI"]},"module" => "Moose::Meta::Role::Method::Conflicting"},{"issues" => {"missing" => ["GRODITI"]},"module" => "Moose::Meta::TypeConstraint::Class"},{"issues" => {"missing" => ["GRODITI"]},"module" => "Moose::Meta::TypeConstraint::DuckType"},{"issues" => {"missing" => ["GRODITI"]},"module" => "Moose::Meta::TypeConstraint::Enum"},{"issues" => {"missing" => ["GRODITI"]},"module" => "Moose::Meta::TypeConstraint::Parameterizable"},{"issues" => {"missing" => ["GRODITI"]},"module" => "Moose::Meta::TypeConstraint::Role"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Spec::Role"},{"issues" => {"missing" => ["DOY","DROLSKY","FLORA","GRODITI","HDP","MSTROUT","NUFFIN","PERIGRIN","SARTAK"]},"module" => "Moose::Unsweetened"},{"issues" => {"missing" => ["GRODITI"]},"module" => "Moose::Util::MetaRole"},{"issues" => {"missing" => ["GRODITI"]},"module" => "oose"},{"issues" => {"missing" => ["HDP","MSTROUT","PERIGRIN"]},"module" => "Test::Moose"}]};

done_testing;

