#!/usr/bin/perl

# Compares GD::SVG output in SVG to that generated by GD in PNG
use strict;

my ($image_class,$poly_class,$font_class,$image_type);
sub BEGIN {
  chomp (my $package = shift);
  $package or die "\nUsage: lots_of_glyphs IMAGE_CLASS
\t- where IMAGE_CLASS is one of GD or GD::SVG
\t- GD generate png output; GD::SVG generates SVG.\n";
  
  if ($package eq 'GD::SVG') {
    $image_type = 'svg';
  } else {
    $image_type = 'png';
  }
  eval "use $package";
  $image_class = $package . '::Image';
  $poly_class  = $package . '::Polygon';
  $font_class  = $package . '::Font';
}

my $image = $image_class->new('800','800');

# Allocate some colors
my $white  = $image->colorAllocate(255,255,255);
my $red    = $image->colorAllocate(255,0,0);
my $black  = $image->colorAllocate(0,0,0);
my $blue   = $image->colorAllocate(0,0,255);
my $gray   = $image->colorAllocate(127,127,127);
my $aqua   = $image->colorAllocate(127,255,212);
my $yellow = $image->colorAllocate(255,255,0);
my $orange = $image->colorAllocate(255,165,0);
my $green  = $image->colorAllocate(0,255,0);

# Setting pixels
my @colors = ($black,$red,$blue,$green,$yellow,$gray,$aqua,$orange);


# Make the background transparent (and white)
#$image->transparent($white);


$image->string(gdMediumBoldFont,10,10,'Setting pixels...',$black);
my $color_index = 0;
for (my $x=250;$x<=750;$x+=10) {
  my $color = $colors[$color_index];
  $image->setPixel($x,20,$color);
  $color_index++;
  $color_index = 0 if ($color_index >= @colors);
}

# Drawing lines
$image->string(gdMediumBoldFont,10,35,'Drawing lines...',$black);
$image->setThickness(0.5);
$image->line(250,35,750,35,$aqua);
$image->line(250,40,750,40,$yellow);
$image->line(250,45,750,45,$red);
$image->setThickness(1);
$image->line(250,50,750,50,$black);
$image->line(250,55,750,55,$red);
$image->line(250,65,750,65,$green);
$image->setThickness(2);
$image->line(250,60,750,60,$blue);
$image->line(250,65,750,65,$green);
$image->line(250,70,750,70,$yellow);
$image->setThickness(4);
$image->line(250,75,750,75,$gray);
$image->line(250,80,750,80,$aqua);
$image->line(250,85,750,85,$orange);
$image->setThickness(1);

# Styled and dashed lines

# Rectangles
$image->string(gdMediumBoldFont,10,100,'Rectangles...',$black);
$image->rectangle(250,100,750,120,$black);

# Filled rectangles
$image->string(gdMediumBoldFont,10,140,'Filled rectangles...',$black);
$image->filledRectangle(250,140,750,160,$red);

# Filled rectangles with borders
$image->string(gdMediumBoldFont,10,180,'Filled rectangles (bordered)...',$black);
$image->filledRectangle(250,180,750,200,$aqua);
$image->rectangle(250,180,750,200,$black);

# Polygons
my @star = ([40,0],[50,30],
	    [80,40],[50,50],
	    [40,80],[30,50],
	    [0,40],[30,30],[40,0]);

my @starting_positions = ([250,220],[350,220],[450,220],[550,220],[650,220]);
$image->string(gdMediumBoldFont,10,220,'Polygons...',$black);
$color_index = 0;
foreach (@starting_positions) {
  my $polygon = $poly_class->new();
  my ($startx,$starty) = @$_;
  my $color = $colors[$color_index];
  foreach (@star) {
    my ($x,$y) = @$_;
    $polygon->addPt($startx + $x,$starty + $y);
  }
  $image->polygon($polygon,$color);
  $color_index++;
}

# Filled polygons
# This is the same as above, but using the offset()
# method of the polygon object Kind of a kludgy example (we have to
# start the iterative loop 100 pixels left of where we really want to
# start in order to demonstarte the offset method.
$image->string(gdMediumBoldFont,10,320,'Filled polygons...',$black);
$color_index = 0;
my $y = 320;
for (my $x=150;$x<=550;$x+=100) {
  my $polygon = $poly_class->new();
  my $color = $colors[$color_index];
  foreach (@star) {
    my ($starx,$stary) = @$_;
    $polygon->addPt($starx + $x,$stary + $y);
  }
  $polygon->offset(100,0);
  $image->filledPolygon($polygon,$color);
  $color_index++;
}

# Filled bordered polygons
$image->string(gdMediumBoldFont,10,420,'Filled polygons (bordered)...',$black);
$color_index = 0;
@starting_positions = ([250,420],[350,420],[450,420],[550,420],[650,420]);
foreach (@starting_positions) {
  my $polygon    = $poly_class->new();
  my ($startx,$starty) = @$_;
  my $color = $colors[$color_index];
  foreach (@star) {
    my ($x,$y) = @$_;
    $polygon->addPt($startx + $x,$starty + $y);
  }
  $image->filledPolygon($polygon,$color);
  $image->polygon($polygon,$black);
  $color_index++;
}

# Ellipses
$image->string(gdMediumBoldFont,10,520,'Ellipses...',$black);
$color_index = 0;
@starting_positions = ([290,520],[390,520],[490,520],[590,520],[690,520]);
foreach (@starting_positions) {
  my ($x,$y) = @$_;
  my $color = $colors[$color_index];
  $image->ellipse($x,$y,80,25,$color);
  $color_index++;
}

# Filled ellipeses
$image->string(gdMediumBoldFont,10,550,'Filled ellipses...',$black);
$color_index = 0;
@starting_positions = ([290,550],[390,550],[490,550],[590,550],[690,550]);
foreach (@starting_positions) {
  my ($x,$y) = @$_;
  my $color = $colors[$color_index];
  $image->filledEllipse($x,$y,80,25,$color);
  $color_index++;
}

$image->string(gdMediumBoldFont,10,580,'Filled ellipses (bordered, increasing thickness)...',$black);
$color_index = 0;
@starting_positions = ([290,580],[390,580],[490,580],[590,580],[690,580]);
foreach (@starting_positions) {
  $image->setThickness($color_index+1);
  my ($x,$y) = @$_;
  my $color = $colors[$color_index];
  $image->filledEllipse($x,$y,80,25,$color);
  $image->ellipse($x,$y,80,25,$black);
  $color_index++;
}
$image->setThickness(1);

# Arcs
#$image->string(gdMediumBoldFont,10,610,'Arcs...',$black);
#$color_index = 0;
#@starting_positions = ([290,610],[390,610],[490,610],[590,610],[690,610]);
#foreach (@starting_positions) {
#  my ($x,$y) = @$_;
#  my $color = $colors[$color_index];
#  $image->arc($x,$y,80,25,0,180,$color);
#  $color_index++;
#}

# Fonts...
$image->string(gdMediumBoldFont,10,650,'Fonts',$black);
$image->string(gdTinyFont,250,650,'gdTinyFont',$black);
$image->string($font_class->Tiny,400,650,"$font_class->Tiny",$black);
$image->string(gdSmallFont,250,670,'gdSmallFont',$black);
$image->string($font_class->Small,400,670,"$font_class->Small",$black);
$image->string(gdMediumBoldFont,250,690,'gdMediumBoldFont',$black);
$image->string($font_class->MediumBold,400,690,"$font_class->MediumBold",$black);
$image->string(gdLargeFont,250,710,'gdLargeFont',$black);
$image->string($font_class->Large,400,710,"$font_class->Large",$black);
$image->string(gdGiantFont,250,730,'gdGiantFont',$black);
$image->string($font_class->Giant,400,730,"$font_class->Giant",$black);

print $image->$image_type();
