/*
 * Decompiled with CFR 0.152.
 */
package com.vizdom.dbd.jdbc;

import com.vizdom.ber.BerIdentifier;
import com.vizdom.ber.BerModule;
import com.vizdom.ber.BerObject;
import com.vizdom.ber.BerObjectFactory;
import com.vizdom.ber.BerOctetString;
import com.vizdom.ber.BerSequence;
import com.vizdom.util.Debug;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;

class BerHash
extends BerSequence {
    static final BerIdentifier gIDENTIFIER = new BerIdentifier(64, 32, 27);
    static final BerObjectFactory gFACTORY = new BerObjectFactory(){

        @Override
        public boolean acceptsIdentifier(BerIdentifier anIdentifier) {
            return anIdentifier.equals(gIDENTIFIER);
        }

        @Override
        public BerObject createBerObject() {
            return new BerHash();
        }
    };
    private Hashtable<String, String> mHashtable;

    private BerHash() {
    }

    @Override
    protected void mReadContents(InputStream anIn, BerModule aModule, BerIdentifier anIdentifier, int aLength) throws IOException {
        super.mReadContents(anIn, aModule, anIdentifier, aLength);
        Debug.assertTrue(this.mSequence.length % 2 == 0);
    }

    Hashtable<String, String> toHashtable() {
        if (this.mHashtable == null) {
            this.mHashtable = new Hashtable();
            for (int i = 0; i < this.mSequence.length; i += 2) {
                this.mHashtable.put(this.mSequence[i].toString(), this.mSequence[i + 1].toString());
            }
        }
        return this.mHashtable;
    }

    Hashtable<String, String> toHashtable(String aCharacterEncoding) throws UnsupportedEncodingException {
        Hashtable<String, String> h = new Hashtable<String, String>();
        for (int i = 0; i < this.mSequence.length; i += 2) {
            h.put(((BerOctetString)this.mSequence[i]).toString(aCharacterEncoding), ((BerOctetString)this.mSequence[i + 1]).toString(aCharacterEncoding));
        }
        return h;
    }

    @Override
    public BerIdentifier getIdentifier() {
        return gIDENTIFIER;
    }

    @Override
    public String toString() {
        return "Hash";
    }
}

