/*
 * Copyright 1995-2016 The OpenSSL Project Authors. All Rights Reserved.
 *
 * Licensed under the OpenSSL license (the "License").  You may not use
 * this file except in compliance with the License.  You can obtain a copy
 * in the file LICENSE in the source distribution or at
 * https://www.openssl.org/source/license.html
 */

/*
 * NOTE: this file was auto generated by the mkerr.pl script: any changes
 * made to it will be overwritten when the script next updates this file,
 * only reason strings will be preserved.
 */

#include <stdio.h>
#include <openssl/err.h>
#include "e_afalg_err.h"

/* BEGIN ERROR CODES */
#ifndef OPENSSL_NO_ERR

# define ERR_FUNC(func) ERR_PACK(0,func,0)
# define ERR_REASON(reason) ERR_PACK(0,0,reason)

static ERR_STRING_DATA AFALG_str_functs[] = {
    {ERR_FUNC(AFALG_F_AFALG_CHK_PLATFORM), "afalg_chk_platform"},
    {ERR_FUNC(AFALG_F_AFALG_CREATE_BIND_SK), "afalg_create_bind_sk"},
    {ERR_FUNC(AFALG_F_AFALG_CREATE_BIND_SOCKET), "afalg_create_bind_sk"},
    {ERR_FUNC(AFALG_F_AFALG_CREATE_SK), "afalg_create_sk"},
    {ERR_FUNC(AFALG_F_AFALG_INIT_AIO), "afalg_init_aio"},
    {ERR_FUNC(AFALG_F_AFALG_SETUP_ASYNC_EVENT_NOTIFICATION),
     "afalg_setup_async_event_notification"},
    {ERR_FUNC(AFALG_F_AFALG_SET_KEY), "afalg_set_key"},
    {ERR_FUNC(AFALG_F_AFALG_SOCKET), "afalg_socket"},
    {ERR_FUNC(AFALG_F_AFALG_START_CIPHER_SK), "afalg_start_cipher_sk"},
    {ERR_FUNC(AFALG_F_BIND_AFALG), "bind_afalg"},
    {0, NULL}
};

static ERR_STRING_DATA AFALG_str_reasons[] = {
    {ERR_REASON(AFALG_R_EVENTFD_FAILED), "eventfd failed"},
    {ERR_REASON(AFALG_R_FAILED_TO_GET_PLATFORM_INFO),
     "failed to get platform info"},
    {ERR_REASON(AFALG_R_INIT_FAILED), "init failed"},
    {ERR_REASON(AFALG_R_IO_SETUP_FAILED), "io setup failed"},
    {ERR_REASON(AFALG_R_KERNEL_DOES_NOT_SUPPORT_AFALG),
     "kernel does not support afalg"},
    {ERR_REASON(AFALG_R_KERNEL_DOES_NOT_SUPPORT_ASYNC_AFALG),
     "kernel does not support async afalg"},
    {ERR_REASON(AFALG_R_MEM_ALLOC_FAILED), "mem alloc failed"},
    {ERR_REASON(AFALG_R_SOCKET_ACCEPT_FAILED), "socket accept failed"},
    {ERR_REASON(AFALG_R_SOCKET_BIND_FAILED), "socket bind failed"},
    {ERR_REASON(AFALG_R_SOCKET_CREATE_FAILED), "socket create failed"},
    {ERR_REASON(AFALG_R_SOCKET_OPERATION_FAILED), "socket operation failed"},
    {ERR_REASON(AFALG_R_SOCKET_SET_KEY_FAILED), "socket set key failed"},
    {0, NULL}
};

#endif

#ifdef AFALG_LIB_NAME
static ERR_STRING_DATA AFALG_lib_name[] = {
    {0, AFALG_LIB_NAME},
    {0, NULL}
};
#endif

static int AFALG_lib_error_code = 0;
static int AFALG_error_init = 1;

void ERR_load_AFALG_strings(void)
{
    if (AFALG_lib_error_code == 0)
        AFALG_lib_error_code = ERR_get_next_error_library();

    if (AFALG_error_init) {
        AFALG_error_init = 0;
#ifndef OPENSSL_NO_ERR
        ERR_load_strings(AFALG_lib_error_code, AFALG_str_functs);
        ERR_load_strings(AFALG_lib_error_code, AFALG_str_reasons);
#endif

#ifdef AFALG_LIB_NAME
        AFALG_lib_name->error = ERR_PACK(AFALG_lib_error_code, 0, 0);
        ERR_load_strings(0, AFALG_lib_name);
#endif
    }
}

void ERR_unload_AFALG_strings(void)
{
    if (AFALG_error_init == 0) {
#ifndef OPENSSL_NO_ERR
        ERR_unload_strings(AFALG_lib_error_code, AFALG_str_functs);
        ERR_unload_strings(AFALG_lib_error_code, AFALG_str_reasons);
#endif

#ifdef AFALG_LIB_NAME
        ERR_unload_strings(0, AFALG_lib_name);
#endif
        AFALG_error_init = 1;
    }
}

void ERR_AFALG_error(int function, int reason, char *file, int line)
{
    if (AFALG_lib_error_code == 0)
        AFALG_lib_error_code = ERR_get_next_error_library();
    ERR_PUT_error(AFALG_lib_error_code, function, reason, file, line);
}
