#!/usr/bin/perl

use strict;
use warnings;

use Test::More tests => 2;

use Algorithm::ClusterPoints;

# my @x = (0.616027832031250, 0.152069091796875, 0.190399169921875, 0.61352539062500, 0.560211181640625);
# my @y = (0.151336669921875, 0.058563232421875, 0.240966796875000, 0.65527343750000, 0.620880126953125);
# my @z = (0.325408935546875, 0.380126953125000, 0.726531982421875, 0.72015380859375, 0.141204833984375);



my @x = ( 0.370452880859375, 0.540771484375000, 0.068023681640625, 0.947723388671875, 0.379699707031250,
          0.118957519531250, 0.919097900390625, 0.404083251953125, 0.890777587890625, 0.077453613281250,
          0.313354492187500, 0.799285888671875, 0.388702392578125, 0.605743408203125, 0.923034667968750,
          0.216796875000000, 0.778015136718750, 0.497253417968750, 0.012207031250000, 0.504455566406250 );

my @y = ( 0.516418457031250, 0.550109863281250, 0.003204345703125, 0.898040771484375, 0.884124755859375,
          0.686798095703125, 0.109252929687500, 0.824249267578125, 0.795867919921875, 0.565551757812500,
          0.836212158203125, 0.641906738281250, 0.973724365234375, 0.332397460937500, 0.379638671875000,
          0.865753173828125, 0.545440673828125, 0.391784667968750, 0.261322021484375, 0.975372314453125 );

my @z = ( 0.701416015625000, 0.308532714843750, 0.103179931640625, 0.342620849609375, 0.839630126953125,
          0.736083984375000, 0.625488281250000, 0.582672119140625, 0.353637695312500, 0.069366455078125,
          0.440246582031250, 0.555389404296875, 0.045349121093750, 0.227325439453125, 0.823425292968750,
          0.921325683593750, 0.507598876953125, 0.142578125000000, 0.767700195312500, 0.672821044921875 );

my @sol = ( [ 0 ], [ 1 ], [ 2 ], [ 3, 8 ], [ 4, 15 ], [ 5 ], [ 6 ], [ 7, 10 ],
            [ 9 ], [ 11, 16 ], [ 12 ], [ 13, 17 ], [ 14 ], [ 18 ], [ 19 ] );

my $n = @x;

my $clp = Algorithm::ClusterPoints->new(dimension => 3, ordered => 1, radius => 0.2);
$clp->add_point($x[$_], $y[$_], $z[$_]) for 0..$n-1;

my @bfc = $clp->brute_force_clusters_ix;
my @c = $clp->clusters_ix;

# use Data::Dumper;
# print STDERR Data::Dumper->Dump([\@bfc, \@c], [qw($bfc $c)]);
# print STDERR "distance(4, 15) = ".$clp->distance(4, 15)."\n";

is_deeply(\@c, \@sol, "simple 3d");
is_deeply(\@bfc, \@sol, "simple 3d brute force");

