package Minilla::ModuleMaker::ModuleBuildTiny;
use strict;
use warnings;
use utf8;
use Data::Section::Simple qw(get_data_section);
use Text::MicroTemplate qw(render_mt);
use Data::Dumper;

use Moo;

no Moo;

use Minilla::Util qw(spew_raw);

sub generate {
    my ($self, $project) = @_;

    local $Data::Dumper::Terse = 1;
    local $Data::Dumper::Useqq = 1;
    local $Data::Dumper::Purity = 1;
    local $Data::Dumper::Indent = 0;
    my $content = get_data_section('Build.PL');
    my $mt = Text::MicroTemplate->new(template => $content, escape_func => sub { $_[0] });
    my $src = $mt->build->($project);
    spew_raw('Build.PL', $src);
}

sub prereqs {
    my ($self, $project) = @_;
    my $prereqs = +{
        configure => {
            requires => {
                'Module::Build::Tiny' => '0.035',
            }
        }
    };

    for my $key (qw(tap_harness_args use_xsutil c_source allow_pureperl)) {
        if( $project->$key ){
            die "$key does not supported by " . __PACKAGE__;
        }
    }
    return $prereqs;
}

1;
__DATA__

@@ Build.PL
? my $project = shift;
# =========================================================================
# THIS FILE IS AUTOMATICALLY GENERATED BY MINILLA.
# DO NOT EDIT DIRECTLY.
# =========================================================================

use 5.008_001;
use strict;

use Module::Build::Tiny 0.035;

Build_PL();

