/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.parser;

import javax.xml.transform.SourceLocator;
import net.sf.saxon.Configuration;
import net.sf.saxon.TypeCheckerEnvironment;
import net.sf.saxon.expr.AtomicSequenceConverter;
import net.sf.saxon.expr.Atomizer;
import net.sf.saxon.expr.CardinalityChecker;
import net.sf.saxon.expr.CardinalityCheckingIterator;
import net.sf.saxon.expr.CollationMap;
import net.sf.saxon.expr.EarlyEvaluationContext;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.FirstItemExpression;
import net.sf.saxon.expr.ItemChecker;
import net.sf.saxon.expr.ItemMappingFunction;
import net.sf.saxon.expr.ItemMappingIterator;
import net.sf.saxon.expr.ItemTypeCheckingFunction;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RoleLocator;
import net.sf.saxon.functions.NumberFn;
import net.sf.saxon.functions.StringFn;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.pattern.EmptySequenceTest;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyFunctionType;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.Converter;
import net.sf.saxon.type.ExternalObjectType;
import net.sf.saxon.type.FunctionItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.PlainType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AnyURIValue;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.FloatValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.Value;

public final class TypeChecker {
    private TypeChecker() {
    }

    public static Expression staticTypeCheck(Expression supplied, SequenceType req, boolean backwardsCompatible, RoleLocator role, final TypeCheckerEnvironment visitor) throws XPathException {
        XPathException err;
        int relation;
        Expression cexp;
        boolean itemTypeOK;
        boolean cardOK;
        if (supplied.implementsStaticTypeCheck()) {
            return supplied.staticTypeCheck(req, backwardsCompatible, role, visitor);
        }
        Expression exp = supplied;
        NamePool namePool = visitor.getConfiguration().getNamePool();
        TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
        ItemType reqItemType = req.getPrimaryType();
        int reqCard = req.getCardinality();
        boolean allowsMany = Cardinality.allowsMany(reqCard);
        ItemType suppliedItemType = null;
        int suppliedCard = -1;
        boolean bl = cardOK = reqCard == 57344;
        if (!cardOK) {
            suppliedCard = exp.getCardinality();
            cardOK = Cardinality.subsumes(reqCard, suppliedCard);
        }
        if (!(itemTypeOK = reqItemType instanceof AnyItemType)) {
            suppliedItemType = exp.getItemType(th);
            if (suppliedItemType instanceof EmptySequenceTest) {
                itemTypeOK = true;
            } else {
                if (reqItemType == null || suppliedItemType == null) {
                    throw new NullPointerException();
                }
                int relation2 = th.relationship(reqItemType, suppliedItemType);
                boolean bl2 = itemTypeOK = relation2 == 0 || relation2 == 1;
            }
        }
        if (backwardsCompatible && !allowsMany) {
            if (Cardinality.allowsMany(suppliedCard)) {
                Expression cexp2 = FirstItemExpression.makeFirstItemExpression(exp);
                cexp2.adoptChildExpression(exp);
                exp = cexp2;
                suppliedCard = 24576;
                cardOK = Cardinality.subsumes(reqCard, suppliedCard);
            }
            if (!itemTypeOK) {
                if (reqItemType.equals(BuiltInAtomicType.STRING)) {
                    StringFn fn = (StringFn)SystemFunction.makeSystemFunction("string", new Expression[]{exp});
                    try {
                        exp = visitor.typeCheck(visitor.simplify(fn), new ExpressionVisitor.ContextItemType(AnyItemType.getInstance(), true));
                    }
                    catch (XPathException err2) {
                        err2.maybeSetLocation(exp);
                        throw err2.makeStatic();
                    }
                    suppliedItemType = BuiltInAtomicType.STRING;
                    suppliedCard = 16384;
                    cardOK = Cardinality.subsumes(reqCard, suppliedCard);
                    itemTypeOK = true;
                }
                if (reqItemType.equals(BuiltInAtomicType.NUMERIC) || reqItemType.equals(BuiltInAtomicType.DOUBLE)) {
                    NumberFn fn = (NumberFn)SystemFunction.makeSystemFunction("number", new Expression[]{exp});
                    try {
                        exp = visitor.typeCheck(visitor.simplify(fn), new ExpressionVisitor.ContextItemType(AnyItemType.getInstance(), true));
                    }
                    catch (XPathException err3) {
                        err3.maybeSetLocation(exp);
                        throw err3.makeStatic();
                    }
                    suppliedItemType = BuiltInAtomicType.DOUBLE;
                    suppliedCard = 16384;
                    cardOK = Cardinality.subsumes(reqCard, suppliedCard);
                    itemTypeOK = true;
                }
            }
        }
        if (!itemTypeOK) {
            if (reqItemType.isPlainType()) {
                if (!suppliedItemType.isPlainType() && suppliedCard != 8192) {
                    if (!suppliedItemType.isAtomizable()) {
                        XPathException err4 = new XPathException("An atomic value is required for the " + role.getMessage() + ", but the supplied value cannot be atomized", supplied);
                        err4.setErrorCode(role.getErrorCode());
                        err4.setIsTypeError(true);
                        err4.setLocator(exp);
                        throw err4;
                    }
                    exp = new Atomizer(exp);
                    Expression cexp3 = visitor.simplify(exp);
                    ExpressionTool.copyLocationInfo(exp, cexp3);
                    exp = cexp3;
                    suppliedItemType = exp.getItemType(th);
                    suppliedCard = exp.getCardinality();
                    cardOK = Cardinality.subsumes(reqCard, suppliedCard);
                }
                if (suppliedItemType.equals(BuiltInAtomicType.UNTYPED_ATOMIC) && !reqItemType.equals(BuiltInAtomicType.UNTYPED_ATOMIC) && !reqItemType.equals(BuiltInAtomicType.ANY_ATOMIC)) {
                    if (reqItemType instanceof AtomicType && ((AtomicType)reqItemType).isNamespaceSensitive()) {
                        XPathException err5 = new XPathException("An untyped atomic value cannot be converted to a QName or NOTATION for the " + role.getMessage(), supplied);
                        err5.setErrorCode("XPTY0117");
                        err5.setIsTypeError(true);
                        err5.setLocator(exp);
                        throw err5;
                    }
                    AtomicSequenceConverter cexp4 = AtomicSequenceConverter.makeUntypedSequenceConverter(visitor.getConfiguration(), exp, (PlainType)reqItemType);
                    ExpressionTool.copyLocationInfo(exp, cexp4);
                    try {
                        exp = exp instanceof Literal ? Literal.makeLiteral(new SequenceExtent<Item>(((Expression)cexp4).iterate(visitor.makeDynamicContext())).simplify()) : cexp4;
                    }
                    catch (XPathException err6) {
                        err6.maybeSetLocation(exp);
                        err6.setErrorCode(role.getErrorCode());
                        throw err6.makeStatic();
                    }
                    itemTypeOK = true;
                    suppliedItemType = reqItemType;
                }
                if (suppliedItemType.equals(BuiltInAtomicType.ANY_ATOMIC) && !reqItemType.equals(BuiltInAtomicType.UNTYPED_ATOMIC) && !reqItemType.equals(BuiltInAtomicType.ANY_ATOMIC) && (exp.getSpecialProperties() & 0x2000000) == 0) {
                    AtomicSequenceConverter conversion = ((SimpleType)((Object)reqItemType)).isNamespaceSensitive() ? AtomicSequenceConverter.makeUntypedSequenceRejector(visitor.getConfiguration(), exp, (PlainType)reqItemType) : AtomicSequenceConverter.makeUntypedSequenceConverter(visitor.getConfiguration(), exp, (PlainType)reqItemType);
                    ExpressionTool.copyLocationInfo(exp, conversion);
                    try {
                        exp = exp instanceof Literal ? Literal.makeLiteral(new SequenceExtent<Item>(((Expression)conversion).iterate(visitor.makeDynamicContext())).simplify()) : conversion;
                        suppliedItemType = exp.getItemType(th);
                    }
                    catch (XPathException err7) {
                        err7.maybeSetLocation(exp);
                        throw err7.makeStatic();
                    }
                }
                if (reqItemType instanceof AtomicType) {
                    int rt = ((AtomicType)reqItemType).getFingerprint();
                    if (rt == 517 && th.relationship(suppliedItemType, BuiltInAtomicType.NUMERIC) != 4) {
                        cexp = TypeChecker.makePromoterToDouble(exp, visitor);
                        ExpressionTool.copyLocationInfo(exp, cexp);
                        exp = cexp;
                        try {
                            exp = visitor.typeCheck(visitor.simplify(exp), new ExpressionVisitor.ContextItemType(AnyItemType.getInstance(), true));
                        }
                        catch (XPathException err8) {
                            err8.maybeSetLocation(exp);
                            throw err8.makeStatic();
                        }
                        suppliedItemType = BuiltInAtomicType.DOUBLE;
                        suppliedCard = -1;
                    } else if (rt == 516 && th.relationship(suppliedItemType, BuiltInAtomicType.NUMERIC) != 4 && !th.isSubType(suppliedItemType, BuiltInAtomicType.DOUBLE)) {
                        cexp = TypeChecker.makePromoterToFloat(exp, visitor);
                        ExpressionTool.copyLocationInfo(exp, cexp);
                        exp = cexp;
                        try {
                            exp = visitor.typeCheck(visitor.simplify(exp), new ExpressionVisitor.ContextItemType(AnyItemType.getInstance(), true));
                        }
                        catch (XPathException err9) {
                            err9.maybeSetLocation(exp);
                            throw err9.makeStatic();
                        }
                        suppliedItemType = BuiltInAtomicType.FLOAT;
                        suppliedCard = -1;
                    }
                    if (rt == 513 && th.isSubType(suppliedItemType, BuiltInAtomicType.ANY_URI)) {
                        suppliedItemType = BuiltInAtomicType.STRING;
                        itemTypeOK = true;
                    }
                }
            } else if (reqItemType instanceof FunctionItemType && !((FunctionItemType)reqItemType).isMapType()) {
                if (!(suppliedItemType instanceof FunctionItemType)) {
                    exp = new ItemChecker(exp, AnyFunctionType.getInstance(), role);
                    suppliedItemType = AnyFunctionType.getInstance();
                }
                TypeCheckerEnvironment tce = new TypeCheckerEnvironment(){
                    final Configuration config;
                    final CollationMap collationMap;
                    {
                        this.config = visitor.getConfiguration();
                        this.collationMap = visitor.getCollationMap();
                    }

                    public Configuration getConfiguration() {
                        return this.config;
                    }

                    public void issueWarning(String message, SourceLocator locator) {
                    }

                    public CollationMap getCollationMap() {
                        return this.collationMap;
                    }

                    public XPathContext makeDynamicContext() {
                        return new EarlyEvaluationContext(this.config, this.collationMap);
                    }

                    public Expression simplify(Expression exp) throws XPathException {
                        return exp;
                    }

                    public Expression typeCheck(Expression exp, ExpressionVisitor.ContextItemType contextItemType) throws XPathException {
                        return exp;
                    }
                };
                exp = ((FunctionItemType)reqItemType).makeFunctionSequenceCoercer(exp, role, tce);
                itemTypeOK = true;
            }
        }
        if (itemTypeOK && cardOK) {
            return exp;
        }
        if (suppliedCard == -1) {
            suppliedCard = exp.getCardinality();
            if (!cardOK) {
                cardOK = Cardinality.subsumes(reqCard, suppliedCard);
            }
        }
        if (cardOK && suppliedCard == 8192) {
            return exp;
        }
        if (suppliedCard == 8192 && (reqCard & 0x2000) == 0) {
            XPathException err10 = new XPathException("An empty sequence is not allowed as the " + role.getMessage(), supplied);
            err10.setErrorCode(role.getErrorCode());
            err10.setIsTypeError(true);
            err10.setLocator(exp);
            throw err10;
        }
        int n = relation = itemTypeOK ? 2 : th.relationship(suppliedItemType, reqItemType);
        if (relation == 4) {
            if (Cardinality.allowsZero(suppliedCard) && Cardinality.allowsZero(reqCard)) {
                if (suppliedCard != 8192) {
                    String msg = "Required item type of " + role.getMessage() + " is " + reqItemType.toString(namePool) + "; supplied value has item type " + suppliedItemType.toString(namePool) + ". The expression can succeed only if the supplied value is an empty sequence.";
                    visitor.issueWarning(msg, supplied);
                }
            } else {
                err = new XPathException("Required item type of " + role.getMessage() + " is " + reqItemType.toString(namePool) + "; supplied value has item type " + suppliedItemType.toString(namePool), supplied);
                err.setErrorCode(role.getErrorCode());
                err.setIsTypeError(true);
                err.setLocator(supplied);
                throw err;
            }
        }
        if (relation != 0 && relation != 2) {
            if (exp instanceof Literal) {
                err = new XPathException("Required item type of " + role.getMessage() + " is " + reqItemType.toString(namePool) + "; supplied value has item type " + suppliedItemType.toString(namePool), supplied);
                err.setErrorCode(role.getErrorCode());
                err.setIsTypeError(true);
                err.setLocator(supplied);
                throw err;
            }
            cexp = new ItemChecker(exp, reqItemType, role);
            ExpressionTool.copyLocationInfo(exp, cexp);
            exp = cexp;
        }
        if (!cardOK) {
            if (exp instanceof Literal) {
                err = new XPathException("Required cardinality of " + role.getMessage() + " is " + Cardinality.toString(reqCard) + "; supplied value has cardinality " + Cardinality.toString(suppliedCard), supplied);
                err.setIsTypeError(true);
                err.setErrorCode(role.getErrorCode());
                err.setLocator(supplied);
                throw err;
            }
            cexp = CardinalityChecker.makeCardinalityChecker(exp, reqCard, role);
            ExpressionTool.copyLocationInfo(exp, cexp);
            exp = cexp;
        }
        return exp;
    }

    public static Expression strictTypeCheck(Expression supplied, SequenceType req, RoleLocator role, StaticContext env) throws XPathException {
        Expression cexp;
        int relation;
        boolean itemTypeOK;
        boolean cardOK;
        Expression exp = supplied;
        TypeHierarchy th = env.getConfiguration().getTypeHierarchy();
        ItemType reqItemType = req.getPrimaryType();
        int reqCard = req.getCardinality();
        ItemType suppliedItemType = null;
        int suppliedCard = -1;
        boolean bl = cardOK = reqCard == 57344;
        if (!cardOK) {
            suppliedCard = exp.getCardinality();
            cardOK = Cardinality.subsumes(reqCard, suppliedCard);
        }
        if (!(itemTypeOK = req.getPrimaryType() instanceof AnyItemType)) {
            suppliedItemType = exp.getItemType(th);
            relation = th.relationship(reqItemType, suppliedItemType);
            boolean bl2 = itemTypeOK = relation == 0 || relation == 1;
        }
        if (itemTypeOK && cardOK) {
            return exp;
        }
        if (suppliedCard == -1) {
            suppliedCard = suppliedItemType instanceof EmptySequenceTest ? 8192 : exp.getCardinality();
            if (!cardOK) {
                cardOK = Cardinality.subsumes(reqCard, suppliedCard);
            }
        }
        if (cardOK && suppliedCard == 8192) {
            return exp;
        }
        if (suppliedItemType == null) {
            suppliedItemType = exp.getItemType(th);
        }
        if (suppliedCard == 8192 && (reqCard & 0x2000) == 0) {
            XPathException err = new XPathException("An empty sequence is not allowed as the " + role.getMessage(), supplied);
            err.setErrorCode(role.getErrorCode());
            err.setIsTypeError(true);
            err.setLocator(exp);
            throw err;
        }
        relation = th.relationship(suppliedItemType, reqItemType);
        if (relation == 4) {
            if (Cardinality.allowsZero(suppliedCard) && Cardinality.allowsZero(reqCard)) {
                if (suppliedCard != 8192) {
                    String msg = "Required item type of " + role.getMessage() + " is " + reqItemType.toString(env.getNamePool()) + "; supplied value has item type " + suppliedItemType.toString(env.getNamePool()) + ". The expression can succeed only if the supplied value is an empty sequence.";
                    env.issueWarning(msg, supplied);
                }
            } else {
                XPathException err = new XPathException("Required item type of " + role.getMessage() + " is " + reqItemType.toString(env.getNamePool()) + "; supplied value has item type " + suppliedItemType.toString(env.getNamePool()), supplied);
                err.setErrorCode(role.getErrorCode());
                err.setIsTypeError(true);
                err.setLocator(exp);
                throw err;
            }
        }
        if (relation != 0 && relation != 2) {
            cexp = new ItemChecker(exp, reqItemType, role);
            cexp.adoptChildExpression(exp);
            exp = cexp;
        }
        if (!cardOK) {
            if (exp instanceof Literal) {
                XPathException err = new XPathException("Required cardinality of " + role.getMessage() + " is " + Cardinality.toString(reqCard) + "; supplied value has cardinality " + Cardinality.toString(suppliedCard), supplied);
                err.setIsTypeError(true);
                err.setErrorCode(role.getErrorCode());
                throw err;
            }
            cexp = CardinalityChecker.makeCardinalityChecker(exp, reqCard, role);
            cexp.adoptChildExpression(exp);
            exp = cexp;
        }
        return exp;
    }

    public static XPathException testConformance(ValueRepresentation val, SequenceType requiredType, XPathContext context) throws XPathException {
        Object item;
        ItemType reqItemType = requiredType.getPrimaryType();
        Configuration config = context.getConfiguration();
        TypeHierarchy th = config.getTypeHierarchy();
        SequenceIterator iter = Value.asIterator(val);
        int count = 0;
        while ((item = iter.next()) != null) {
            ++count;
            if (reqItemType.matchesItem((Item)item, false, config)) continue;
            XPathException err = new XPathException("Required type is " + reqItemType + "; supplied value has type " + Value.asValue(val).getItemType(th));
            err.setIsTypeError(true);
            err.setErrorCode("XPTY0004");
            return err;
        }
        int reqCardinality = requiredType.getCardinality();
        if (count == 0 && !Cardinality.allowsZero(reqCardinality)) {
            XPathException err = new XPathException("Required type does not allow empty sequence, but supplied value is empty");
            err.setIsTypeError(true);
            err.setErrorCode("XPTY0004");
            return err;
        }
        if (count > 1 && !Cardinality.allowsMany(reqCardinality)) {
            XPathException err = new XPathException("Required type requires a singleton sequence; supplied value contains " + count + " items");
            err.setIsTypeError(true);
            err.setErrorCode("XPTY0004");
            return err;
        }
        if (count > 0 && reqCardinality == 8192) {
            XPathException err = new XPathException("Required type requires an empty sequence, but supplied value is non-empty");
            err.setIsTypeError(true);
            err.setErrorCode("XPTY0004");
            return err;
        }
        return null;
    }

    public static XPathException ebvError(Expression exp, TypeHierarchy th) {
        if (Cardinality.allowsZero(exp.getCardinality())) {
            return null;
        }
        ItemType t = exp.getItemType(th);
        if (th.relationship(t, Type.NODE_TYPE) == 4 && th.relationship(t, BuiltInAtomicType.BOOLEAN) == 4 && th.relationship(t, BuiltInAtomicType.STRING) == 4 && th.relationship(t, BuiltInAtomicType.ANY_URI) == 4 && th.relationship(t, BuiltInAtomicType.UNTYPED_ATOMIC) == 4 && th.relationship(t, BuiltInAtomicType.NUMERIC) == 4 && !(t instanceof ExternalObjectType)) {
            XPathException err = new XPathException("Effective boolean value is defined only for sequences containing booleans, strings, numbers, URIs, or nodes");
            err.setErrorCode("FORG0006");
            err.setIsTypeError(true);
            return err;
        }
        return null;
    }

    private static Expression makePromoterToDouble(Expression exp, TypeCheckerEnvironment visitor) {
        AtomicSequenceConverter asc = new AtomicSequenceConverter(exp, BuiltInAtomicType.DOUBLE, true);
        Converter.PromoterToDouble converter = new Converter.PromoterToDouble();
        converter.setConversionRules(visitor.getConfiguration().getConversionRules());
        asc.setConverter(converter);
        ExpressionTool.copyLocationInfo(exp, asc);
        return asc;
    }

    private static Expression makePromoterToFloat(Expression exp, TypeCheckerEnvironment visitor) {
        AtomicSequenceConverter asc = new AtomicSequenceConverter(exp, BuiltInAtomicType.FLOAT, true);
        Converter.PromoterToFloat converter = new Converter.PromoterToFloat();
        converter.setConversionRules(visitor.getConfiguration().getConversionRules());
        asc.setConverter(converter);
        ExpressionTool.copyLocationInfo(exp, asc);
        return asc;
    }

    public static Value applyFunctionConversionRules(ValueRepresentation value, SequenceType requiredType, RoleLocator role, SourceLocator locator, XPathContext context) throws XPathException {
        TypeHierarchy th = context.getConfiguration().getTypeHierarchy();
        ItemType suppliedItemType = value instanceof NodeInfo ? new NameTest((NodeInfo)value) : ((Value)value).getItemType(th);
        SequenceIterator si = TypeChecker.applyFunctionConversionRules(Value.asIterator(value), suppliedItemType, requiredType, role, locator, context);
        return Value.asValue(SequenceExtent.makeSequenceExtent(si));
    }

    public static SequenceIterator applyFunctionConversionRules(SequenceIterator input, ItemType suppliedItemType, SequenceType requiredType, RoleLocator role, SourceLocator locator, final XPathContext context) throws XPathException {
        int relation;
        TypeHierarchy th = context.getConfiguration().getTypeHierarchy();
        final ItemType requiredItemType = requiredType.getPrimaryType();
        SequenceIterator iterator = input;
        if (requiredItemType.isPlainType()) {
            if (!suppliedItemType.isPlainType()) {
                iterator = Atomizer.getAtomizingIterator(iterator, false);
                suppliedItemType = suppliedItemType.getAtomizedItemType();
            }
            if (th.relationship(suppliedItemType, BuiltInAtomicType.UNTYPED_ATOMIC) != 4) {
                ItemMappingFunction converter;
                boolean nsSensitive = ((SimpleType)((Object)requiredItemType)).isNamespaceSensitive();
                if (nsSensitive) {
                    converter = new ItemMappingFunction(){

                        public Item mapItem(Item item) throws XPathException {
                            if (item instanceof UntypedAtomicValue) {
                                ValidationFailure vf = new ValidationFailure("Implicit conversion of untypedAtomic value to " + requiredItemType.toString() + " is not allowed");
                                vf.setErrorCode("XPTY0117");
                                throw vf.makeException();
                            }
                            return item;
                        }
                    };
                } else if (((SimpleType)((Object)requiredItemType)).isUnionType()) {
                    final ConversionRules rules = context.getConfiguration().getConversionRules();
                    converter = new ItemMappingFunction(){

                        public Item mapItem(Item item) throws XPathException {
                            if (item instanceof UntypedAtomicValue) {
                                try {
                                    SequenceIterator<AtomicValue> tv = ((SimpleType)((Object)requiredItemType)).getTypedValue(item.getStringValueCS(), null, rules);
                                    return tv.next();
                                }
                                catch (ValidationException ve) {
                                    ve.setErrorCode("XPTY0004");
                                    throw ve;
                                }
                            }
                            return item;
                        }
                    };
                } else {
                    converter = new ItemMappingFunction(){

                        public Item mapItem(Item item) throws XPathException {
                            if (item instanceof UntypedAtomicValue) {
                                AtomicValue val = Converter.convert((UntypedAtomicValue)item, (AtomicType)requiredItemType, context.getConfiguration().getConversionRules());
                                if (val instanceof ValidationFailure) {
                                    ValidationFailure vex = (ValidationFailure)((Object)val);
                                    throw vex.makeException();
                                }
                                return val;
                            }
                            return item;
                        }
                    };
                }
                iterator = new ItemMappingIterator(iterator, converter, true);
            }
            if (requiredItemType.equals(BuiltInAtomicType.DOUBLE)) {
                ItemMappingFunction<AtomicValue, DoubleValue> promoter = new ItemMappingFunction<AtomicValue, DoubleValue>(){

                    @Override
                    public DoubleValue mapItem(AtomicValue item) throws XPathException {
                        if (item instanceof NumericValue) {
                            return (DoubleValue)Converter.convert(item, BuiltInAtomicType.DOUBLE, context.getConfiguration().getConversionRules()).asAtomic();
                        }
                        throw new XPathException("Cannot promote non-numeric value to xs:double", "XPTY0004", context);
                    }
                };
                iterator = new ItemMappingIterator<AtomicValue, DoubleValue>(iterator, promoter, true);
            } else if (requiredItemType.equals(BuiltInAtomicType.FLOAT)) {
                ItemMappingFunction<AtomicValue, FloatValue> promoter = new ItemMappingFunction<AtomicValue, FloatValue>(){

                    @Override
                    public FloatValue mapItem(AtomicValue item) throws XPathException {
                        if (item instanceof DoubleValue) {
                            throw new XPathException("Cannot promote xs:double value to xs:float", "XPTY0004", context);
                        }
                        if (item instanceof NumericValue) {
                            return (FloatValue)Converter.convert(item, BuiltInAtomicType.FLOAT, context.getConfiguration().getConversionRules()).asAtomic();
                        }
                        throw new XPathException("Cannot promote non-numeric value to xs:float", "XPTY0004", context);
                    }
                };
                iterator = new ItemMappingIterator<AtomicValue, FloatValue>(iterator, promoter, true);
            }
            if (requiredItemType.equals(BuiltInAtomicType.STRING) && th.relationship(suppliedItemType, BuiltInAtomicType.ANY_URI) != 4) {
                ItemMappingFunction promoter = new ItemMappingFunction(){

                    public Item mapItem(Item item) throws XPathException {
                        if (item instanceof AnyURIValue) {
                            return new StringValue(item.getStringValueCS());
                        }
                        return item;
                    }
                };
                iterator = new ItemMappingIterator(iterator, promoter, true);
            }
        }
        if ((relation = th.relationship(suppliedItemType, requiredItemType)) != 0 && relation != 1) {
            ItemTypeCheckingFunction itemChecker = new ItemTypeCheckingFunction(requiredItemType, role, locator, context);
            iterator = new ItemMappingIterator(iterator, itemChecker, true);
        }
        if (requiredType.getCardinality() != 57344) {
            iterator = new CardinalityCheckingIterator(iterator, requiredType.getCardinality(), role, locator);
        }
        return iterator;
    }
}

