/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.s9api;

import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.lib.StandardURIChecker;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Name10Checker;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.StringToDouble;
import net.sf.saxon.value.AtomicValue;

public abstract class ItemType {
    private static ConversionRules defaultConversionRules = new ConversionRules();
    public static ItemType ANY_ITEM;
    public static final ItemType ANY_NODE;
    public static final ItemType ANY_ATOMIC_VALUE;
    public static final ItemType NUMERIC;
    public static final ItemType STRING;
    public static final ItemType BOOLEAN;
    public static final ItemType DURATION;
    public static final ItemType DATE_TIME;
    public static final ItemType DATE;
    public static final ItemType TIME;
    public static final ItemType G_YEAR_MONTH;
    public static final ItemType G_MONTH;
    public static final ItemType G_MONTH_DAY;
    public static final ItemType G_YEAR;
    public static final ItemType G_DAY;
    public static final ItemType HEX_BINARY;
    public static final ItemType BASE64_BINARY;
    public static final ItemType ANY_URI;
    public static final ItemType QNAME;
    public static final ItemType NOTATION;
    public static final ItemType UNTYPED_ATOMIC;
    public static final ItemType DECIMAL;
    public static final ItemType FLOAT;
    public static final ItemType DOUBLE;
    public static final ItemType INTEGER;
    public static final ItemType NON_POSITIVE_INTEGER;
    public static final ItemType NEGATIVE_INTEGER;
    public static final ItemType LONG;
    public static final ItemType INT;
    public static final ItemType SHORT;
    public static final ItemType BYTE;
    public static final ItemType NON_NEGATIVE_INTEGER;
    public static final ItemType POSITIVE_INTEGER;
    public static final ItemType UNSIGNED_LONG;
    public static final ItemType UNSIGNED_INT;
    public static final ItemType UNSIGNED_SHORT;
    public static final ItemType UNSIGNED_BYTE;
    public static final ItemType YEAR_MONTH_DURATION;
    public static final ItemType DAY_TIME_DURATION;
    public static final ItemType NORMALIZED_STRING;
    public static final ItemType TOKEN;
    public static final ItemType LANGUAGE;
    public static final ItemType NAME;
    public static final ItemType NMTOKEN;
    public static final ItemType NCNAME;
    public static final ItemType ID;
    public static final ItemType IDREF;
    public static final ItemType ENTITY;
    public static final ItemType DATE_TIME_STAMP;

    public abstract ConversionRules getConversionRules();

    public abstract boolean matches(XdmItem var1);

    public abstract boolean subsumes(ItemType var1);

    public abstract net.sf.saxon.type.ItemType getUnderlyingItemType();

    static {
        defaultConversionRules.setNameChecker(Name10Checker.getInstance());
        defaultConversionRules.setStringToDoubleConverter(StringToDouble.getInstance());
        defaultConversionRules.setNotationSet(null);
        defaultConversionRules.setURIChecker(StandardURIChecker.getInstance());
        ANY_ITEM = new ItemType(){

            public ConversionRules getConversionRules() {
                return defaultConversionRules;
            }

            public boolean matches(XdmItem item) {
                return true;
            }

            public boolean subsumes(ItemType other) {
                return true;
            }

            public net.sf.saxon.type.ItemType getUnderlyingItemType() {
                return AnyItemType.getInstance();
            }
        };
        ANY_NODE = new ItemType(){

            public ConversionRules getConversionRules() {
                return defaultConversionRules;
            }

            public boolean matches(XdmItem item) {
                return item.getUnderlyingValue() instanceof NodeInfo;
            }

            public boolean subsumes(ItemType other) {
                return other.getUnderlyingItemType() instanceof NodeTest;
            }

            public net.sf.saxon.type.ItemType getUnderlyingItemType() {
                return AnyNodeTest.getInstance();
            }
        };
        ANY_ATOMIC_VALUE = new ItemType(){

            public ConversionRules getConversionRules() {
                return defaultConversionRules;
            }

            public boolean matches(XdmItem item) {
                return item.getUnderlyingValue() instanceof AtomicValue;
            }

            public boolean subsumes(ItemType other) {
                return other.getUnderlyingItemType() instanceof AtomicType;
            }

            public net.sf.saxon.type.ItemType getUnderlyingItemType() {
                return BuiltInAtomicType.ANY_ATOMIC;
            }
        };
        NUMERIC = new BuiltInAtomicItemType(BuiltInAtomicType.NUMERIC, defaultConversionRules);
        STRING = new BuiltInAtomicItemType(BuiltInAtomicType.STRING, defaultConversionRules);
        BOOLEAN = new BuiltInAtomicItemType(BuiltInAtomicType.BOOLEAN, defaultConversionRules);
        DURATION = new BuiltInAtomicItemType(BuiltInAtomicType.DURATION, defaultConversionRules);
        DATE_TIME = new BuiltInAtomicItemType(BuiltInAtomicType.DATE_TIME, defaultConversionRules);
        DATE = new BuiltInAtomicItemType(BuiltInAtomicType.DATE, defaultConversionRules);
        TIME = new BuiltInAtomicItemType(BuiltInAtomicType.TIME, defaultConversionRules);
        G_YEAR_MONTH = new BuiltInAtomicItemType(BuiltInAtomicType.G_YEAR_MONTH, defaultConversionRules);
        G_MONTH = new BuiltInAtomicItemType(BuiltInAtomicType.G_MONTH, defaultConversionRules);
        G_MONTH_DAY = new BuiltInAtomicItemType(BuiltInAtomicType.G_MONTH_DAY, defaultConversionRules);
        G_YEAR = new BuiltInAtomicItemType(BuiltInAtomicType.G_YEAR, defaultConversionRules);
        G_DAY = new BuiltInAtomicItemType(BuiltInAtomicType.G_DAY, defaultConversionRules);
        HEX_BINARY = new BuiltInAtomicItemType(BuiltInAtomicType.HEX_BINARY, defaultConversionRules);
        BASE64_BINARY = new BuiltInAtomicItemType(BuiltInAtomicType.BASE64_BINARY, defaultConversionRules);
        ANY_URI = new BuiltInAtomicItemType(BuiltInAtomicType.ANY_URI, defaultConversionRules);
        QNAME = new BuiltInAtomicItemType(BuiltInAtomicType.QNAME, defaultConversionRules);
        NOTATION = new BuiltInAtomicItemType(BuiltInAtomicType.NOTATION, defaultConversionRules);
        UNTYPED_ATOMIC = new BuiltInAtomicItemType(BuiltInAtomicType.UNTYPED_ATOMIC, defaultConversionRules);
        DECIMAL = new BuiltInAtomicItemType(BuiltInAtomicType.DECIMAL, defaultConversionRules);
        FLOAT = new BuiltInAtomicItemType(BuiltInAtomicType.FLOAT, defaultConversionRules);
        DOUBLE = new BuiltInAtomicItemType(BuiltInAtomicType.DOUBLE, defaultConversionRules);
        INTEGER = new BuiltInAtomicItemType(BuiltInAtomicType.INTEGER, defaultConversionRules);
        NON_POSITIVE_INTEGER = new BuiltInAtomicItemType(BuiltInAtomicType.NON_POSITIVE_INTEGER, defaultConversionRules);
        NEGATIVE_INTEGER = new BuiltInAtomicItemType(BuiltInAtomicType.NEGATIVE_INTEGER, defaultConversionRules);
        LONG = new BuiltInAtomicItemType(BuiltInAtomicType.LONG, defaultConversionRules);
        INT = new BuiltInAtomicItemType(BuiltInAtomicType.INT, defaultConversionRules);
        SHORT = new BuiltInAtomicItemType(BuiltInAtomicType.SHORT, defaultConversionRules);
        BYTE = new BuiltInAtomicItemType(BuiltInAtomicType.BYTE, defaultConversionRules);
        NON_NEGATIVE_INTEGER = new BuiltInAtomicItemType(BuiltInAtomicType.NON_NEGATIVE_INTEGER, defaultConversionRules);
        POSITIVE_INTEGER = new BuiltInAtomicItemType(BuiltInAtomicType.POSITIVE_INTEGER, defaultConversionRules);
        UNSIGNED_LONG = new BuiltInAtomicItemType(BuiltInAtomicType.UNSIGNED_LONG, defaultConversionRules);
        UNSIGNED_INT = new BuiltInAtomicItemType(BuiltInAtomicType.UNSIGNED_INT, defaultConversionRules);
        UNSIGNED_SHORT = new BuiltInAtomicItemType(BuiltInAtomicType.UNSIGNED_SHORT, defaultConversionRules);
        UNSIGNED_BYTE = new BuiltInAtomicItemType(BuiltInAtomicType.UNSIGNED_BYTE, defaultConversionRules);
        YEAR_MONTH_DURATION = new BuiltInAtomicItemType(BuiltInAtomicType.YEAR_MONTH_DURATION, defaultConversionRules);
        DAY_TIME_DURATION = new BuiltInAtomicItemType(BuiltInAtomicType.DAY_TIME_DURATION, defaultConversionRules);
        NORMALIZED_STRING = new BuiltInAtomicItemType(BuiltInAtomicType.NORMALIZED_STRING, defaultConversionRules);
        TOKEN = new BuiltInAtomicItemType(BuiltInAtomicType.TOKEN, defaultConversionRules);
        LANGUAGE = new BuiltInAtomicItemType(BuiltInAtomicType.LANGUAGE, defaultConversionRules);
        NAME = new BuiltInAtomicItemType(BuiltInAtomicType.NAME, defaultConversionRules);
        NMTOKEN = new BuiltInAtomicItemType(BuiltInAtomicType.NMTOKEN, defaultConversionRules);
        NCNAME = new BuiltInAtomicItemType(BuiltInAtomicType.NCNAME, defaultConversionRules);
        ID = new BuiltInAtomicItemType(BuiltInAtomicType.ID, defaultConversionRules);
        IDREF = new BuiltInAtomicItemType(BuiltInAtomicType.IDREF, defaultConversionRules);
        ENTITY = new BuiltInAtomicItemType(BuiltInAtomicType.ENTITY, defaultConversionRules);
        DATE_TIME_STAMP = new BuiltInAtomicItemType(BuiltInAtomicType.DATE_TIME_STAMP, defaultConversionRules);
    }

    static class BuiltInAtomicItemType
    extends ItemType {
        private BuiltInAtomicType underlyingType;
        private ConversionRules conversionRules;

        public BuiltInAtomicItemType(BuiltInAtomicType underlyingType, ConversionRules conversionRules) {
            this.underlyingType = underlyingType;
            this.conversionRules = conversionRules;
        }

        public static BuiltInAtomicItemType makeVariant(BuiltInAtomicItemType type, ConversionRules conversionRules) {
            return new BuiltInAtomicItemType(type.underlyingType, conversionRules);
        }

        public ConversionRules getConversionRules() {
            return this.conversionRules;
        }

        public boolean matches(XdmItem item) {
            Item value = (Item)item.getUnderlyingValue();
            if (!(value instanceof AtomicValue)) {
                return false;
            }
            AtomicType type = ((AtomicValue)value).getTypeLabel();
            return this.subsumesUnderlyingType(type);
        }

        public boolean subsumes(ItemType other) {
            net.sf.saxon.type.ItemType otherType = other.getUnderlyingItemType();
            if (!otherType.isPlainType()) {
                return false;
            }
            AtomicType type = (AtomicType)otherType;
            return this.subsumesUnderlyingType(type);
        }

        private boolean subsumesUnderlyingType(AtomicType type) {
            BuiltInAtomicType builtIn;
            BuiltInAtomicType builtInAtomicType = builtIn = type instanceof BuiltInAtomicType ? (BuiltInAtomicType)type : (BuiltInAtomicType)type.getBuiltInBaseType();
            while (!builtIn.isSameType(this.underlyingType)) {
                SchemaType base = builtIn.getBaseType();
                if (!(base instanceof BuiltInAtomicType)) {
                    return false;
                }
                builtIn = (BuiltInAtomicType)base;
            }
            return true;
        }

        public net.sf.saxon.type.ItemType getUnderlyingItemType() {
            return this.underlyingType;
        }
    }
}

