# Generated by default/object.tt
package Paws::TimestreamWrite::Database;
  use Moose;
  has Arn => (is => 'ro', isa => 'Str');
  has CreationTime => (is => 'ro', isa => 'Str');
  has DatabaseName => (is => 'ro', isa => 'Str');
  has KmsKeyId => (is => 'ro', isa => 'Str');
  has LastUpdatedTime => (is => 'ro', isa => 'Str');
  has TableCount => (is => 'ro', isa => 'Int');

1;

### main pod documentation begin ###

=head1 NAME

Paws::TimestreamWrite::Database

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::TimestreamWrite::Database object:

  $service_obj->Method(Att1 => { Arn => $value, ..., TableCount => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::TimestreamWrite::Database object:

  $result = $service_obj->Method(...);
  $result->Att1->Arn

=head1 DESCRIPTION

A top level container for a table. Databases and tables are the
fundamental management concepts in Amazon Timestream. All tables in a
database are encrypted with the same KMS key.

=head1 ATTRIBUTES


=head2 Arn => Str

The Amazon Resource Name that uniquely identifies this database.


=head2 CreationTime => Str

The time when the database was created, calculated from the Unix epoch
time.


=head2 DatabaseName => Str

The name of the Timestream database.


=head2 KmsKeyId => Str

The identifier of the KMS key used to encrypt the data stored in the
database.


=head2 LastUpdatedTime => Str

The last time that this database was updated.


=head2 TableCount => Int

The total number of tables found within a Timestream database.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::TimestreamWrite>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

