# Generated by default/object.tt
package Paws::IoTDeviceAdvisor::SuiteDefinitionConfiguration;
  use Moose;
  has DevicePermissionRoleArn => (is => 'ro', isa => 'Str', request_name => 'devicePermissionRoleArn', traits => ['NameInRequest']);
  has Devices => (is => 'ro', isa => 'ArrayRef[Paws::IoTDeviceAdvisor::DeviceUnderTest]', request_name => 'devices', traits => ['NameInRequest']);
  has IntendedForQualification => (is => 'ro', isa => 'Bool', request_name => 'intendedForQualification', traits => ['NameInRequest']);
  has RootGroup => (is => 'ro', isa => 'Str', request_name => 'rootGroup', traits => ['NameInRequest']);
  has SuiteDefinitionName => (is => 'ro', isa => 'Str', request_name => 'suiteDefinitionName', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::IoTDeviceAdvisor::SuiteDefinitionConfiguration

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::IoTDeviceAdvisor::SuiteDefinitionConfiguration object:

  $service_obj->Method(Att1 => { DevicePermissionRoleArn => $value, ..., SuiteDefinitionName => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::IoTDeviceAdvisor::SuiteDefinitionConfiguration object:

  $result = $service_obj->Method(...);
  $result->Att1->DevicePermissionRoleArn

=head1 DESCRIPTION

Gets Suite Definition Configuration.

=head1 ATTRIBUTES


=head2 DevicePermissionRoleArn => Str

Gets device permission arn.


=head2 Devices => ArrayRef[L<Paws::IoTDeviceAdvisor::DeviceUnderTest>]

Gets the devices configured.


=head2 IntendedForQualification => Bool

Gets the tests intended for qualification in a suite.


=head2 RootGroup => Str

Gets test suite root group.


=head2 SuiteDefinitionName => Str

Gets Suite Definition Configuration name.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::IoTDeviceAdvisor>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

