# Generated by default/object.tt
package Paws::ElastiCache::GlobalReplicationGroupMember;
  use Moose;
  has AutomaticFailover => (is => 'ro', isa => 'Str');
  has ReplicationGroupId => (is => 'ro', isa => 'Str');
  has ReplicationGroupRegion => (is => 'ro', isa => 'Str');
  has Role => (is => 'ro', isa => 'Str');
  has Status => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::ElastiCache::GlobalReplicationGroupMember

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::ElastiCache::GlobalReplicationGroupMember object:

  $service_obj->Method(Att1 => { AutomaticFailover => $value, ..., Status => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::ElastiCache::GlobalReplicationGroupMember object:

  $result = $service_obj->Method(...);
  $result->Att1->AutomaticFailover

=head1 DESCRIPTION

A member of a Global datastore. It contains the Replication Group Id,
the AWS region and the role of the replication group.

=head1 ATTRIBUTES


=head2 AutomaticFailover => Str

Indicates whether automatic failover is enabled for the replication
group.


=head2 ReplicationGroupId => Str

The replication group id of the Global datastore member.


=head2 ReplicationGroupRegion => Str

The AWS region of the Global datastore member.


=head2 Role => Str

Indicates the role of the replication group, primary or secondary.


=head2 Status => Str

The status of the membership of the replication group.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::ElastiCache>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

