# Generated by default/object.tt
package Paws::EKS::AddonIssue;
  use Moose;
  has Code => (is => 'ro', isa => 'Str', request_name => 'code', traits => ['NameInRequest']);
  has Message => (is => 'ro', isa => 'Str', request_name => 'message', traits => ['NameInRequest']);
  has ResourceIds => (is => 'ro', isa => 'ArrayRef[Str|Undef]', request_name => 'resourceIds', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::EKS::AddonIssue

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::EKS::AddonIssue object:

  $service_obj->Method(Att1 => { Code => $value, ..., ResourceIds => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::EKS::AddonIssue object:

  $result = $service_obj->Method(...);
  $result->Att1->Code

=head1 DESCRIPTION

An issue related to an add-on.

=head1 ATTRIBUTES


=head2 Code => Str

A code that describes the type of issue.


=head2 Message => Str

A message that provides details about the issue and what might cause
it.


=head2 ResourceIds => ArrayRef[Str|Undef]

The resource IDs of the issue.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::EKS>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

