# Generated by default/object.tt
package Paws::AccessAnalyzer::GeneratedPolicyProperties;
  use Moose;
  has CloudTrailProperties => (is => 'ro', isa => 'Paws::AccessAnalyzer::CloudTrailProperties', request_name => 'cloudTrailProperties', traits => ['NameInRequest']);
  has IsComplete => (is => 'ro', isa => 'Bool', request_name => 'isComplete', traits => ['NameInRequest']);
  has PrincipalArn => (is => 'ro', isa => 'Str', request_name => 'principalArn', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::AccessAnalyzer::GeneratedPolicyProperties

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::AccessAnalyzer::GeneratedPolicyProperties object:

  $service_obj->Method(Att1 => { CloudTrailProperties => $value, ..., PrincipalArn => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::AccessAnalyzer::GeneratedPolicyProperties object:

  $result = $service_obj->Method(...);
  $result->Att1->CloudTrailProperties

=head1 DESCRIPTION

Contains the generated policy details.

=head1 ATTRIBUTES


=head2 CloudTrailProperties => L<Paws::AccessAnalyzer::CloudTrailProperties>

Lists details about the C<Trail> used to generated policy.


=head2 IsComplete => Bool

This value is set to C<true> if the generated policy contains all
possible actions for a service that Access Analyzer identified from the
CloudTrail trail that you specified, and C<false> otherwise.


=head2 B<REQUIRED> PrincipalArn => Str

The ARN of the IAM entity (user or role) for which you are generating a
policy.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::AccessAnalyzer>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

