use strict;
use Test::More;
use lib qw(./lib ./blib/lib);
use Sisimai::Data;
use Sisimai::Mail;
use Sisimai::Message;
use Module::Load;

my $R = {
    'Sendmail' => {
        '01001' => qr/suspend/,
        '01002' => qr/blocked/,
        '01003' => qr/expired/,
        '01004' => qr/userunknown/,
        '01005' => qr/expired/,
        '01006' => qr/expired/,
        '01007' => qr/expired/,
        '01008' => qr/filtered/,
        '01009' => qr/expired/,
        '01010' => qr/blocked/,
        '01011' => qr/blocked/,
        '01012' => qr/systemerror/,
        '01013' => qr/userunknown/,
        '01014' => qr/expired/,
        '01015' => qr/hostunknown/,
        '01016' => qr/expired/,
        '01017' => qr/expired/,
        '01018' => qr/hostunknown/,
        '01019' => qr/blocked/,
        '01020' => qr/expired/,
        '01021' => qr/expired/,
        '01022' => qr/expired/,
        '01023' => qr/expired/,
        '01024' => qr/filtered/,
        '01025' => qr/mesgtoobig/,
        '01026' => qr/blocked/,
        '01027' => qr/rejected/,
        '01028' => qr/norelaying/,
        '01029' => qr/spamdetected/,
        '01030' => qr/suspend/,
        '01031' => qr/suspend/,
        '01032' => qr/mailererror/,
        '01033' => qr/mailererror/,
        '01034' => qr/mailererror/,
        '01035' => qr/userunknown/,
        '01036' => qr/filtered/,
        '01037' => qr/filtered/,
        '01038' => qr/userunknown/,
        '01039' => qr/(?:filtered|userunknown)/,
        '01040' => qr/userunknown/,
        '01041' => qr/blocked/,
        '01042' => qr/userunknown/,
        '01043' => qr/userunknown/,
        '01044' => qr/userunknown/,
        '01045' => qr/userunknown/,
        '01046' => qr/userunknown/,
        '01047' => qr/blocked/,
        '01048' => qr/userunknown/,
        '01049' => qr/userunknown/,
        '01050' => qr/userunknown/,
        '01051' => qr/userunknown/,
        '01052' => qr/userunknown/,
        '01053' => qr/userunknown/,
        '01054' => qr/userunknown/,
        '01055' => qr/userunknown/,
        '01056' => qr/userunknown/,
        '01057' => qr/userunknown/,
        '01058' => qr/norelaying/,
        '01059' => qr/userunknown/,
        '01060' => qr/userunknown/,
        '01061' => qr/blocked/,
        '01062' => qr/userunknown/,
        '01063' => qr/userunknown/,
        '01064' => qr/userunknown/,
        '01065' => qr/userunknown/,
        '01066' => qr/userunknown/,
        '01067' => qr/userunknown/,
        '01068' => qr/userunknown/,
        '01069' => qr/userunknown/,
        '01070' => qr/userunknown/,
        '01071' => qr/userunknown/,
        '01072' => qr/userunknown/,
        '01073' => qr/userunknown/,
        '01074' => qr/userunknown/,
        '01075' => qr/userunknown/,
        '01076' => qr/userunknown/,
        '01077' => qr/userunknown/,
        '01078' => qr/userunknown/,
        '01079' => qr/userunknown/,
        '01080' => qr/userunknown/,
        '01081' => qr/userunknown/,
        '01082' => qr/userunknown/,
        '01083' => qr/userunknown/,
        '01084' => qr/filtered/,
        '01085' => qr/filtered/,
        '01086' => qr/hostunknown/,
        '01087' => qr/hostunknown/,
        '01088' => qr/hostunknown/,
        '01089' => qr/norelaying/,
        '01090' => qr/filtered/,
        '01091' => qr/filtered/,
        '01092' => qr/filtered/,
        '01093' => qr/suspend/,
        '01094' => qr/mailboxfull/,
        '01095' => qr/mailboxfull/,
        '01096' => qr/mailboxfull/,
        '01097' => qr/mailboxfull/,
        '01098' => qr/exceedlimit/,
        '01099' => qr/exceedlimit/,
        '01100' => qr/exceedlimit/,
        '01101' => qr/systemerror/,
        '01102' => qr/filtered/,
        '01103' => qr/filtered/,
        '01104' => qr/mesgtoobig/,
        '01105' => qr/mesgtoobig/,
        '01106' => qr/mesgtoobig/,
        '01107' => qr/systemerror/,
        '01108' => qr/systemerror/,
        '01109' => qr/filtered/,
        '01110' => qr/filtered/,
        '01111' => qr/networkerror/,
        '01112' => qr/mailererror/,
        '01113' => qr/contenterror/,
        '01114' => qr/securityerror/,
        '01115' => qr/securityerror/,
        '01116' => qr/securityerror/,
        '01117' => qr/spamdetected/,
        '01118' => qr/userunknown/,
        '01119' => qr/filtered/,
        '01120' => qr/filtered/,
        '01121' => qr/filtered/,
        '01122' => qr/userunknown/,
        '01124' => qr/expired/,
        '01125' => qr/mesgtoobig/,
        '01127' => qr/userunknown/,
        '01128' => qr/(?:rejected|filtered|userunknown|hostunknown|blocked)/,
        '01129' => qr/hasmoved/,
        '01130' => qr/userunknown/,
        '01131' => qr/filtered/,
        '01132' => qr/filtered/,
        '01133' => qr/filtered/,
        '01134' => qr/mesgtoobig/,
        '01135' => qr/userunknown/,
        '01136' => qr/hostunknown/,
        '01137' => qr/(?:userunknown|mailboxfull)/,
        '01138' => qr/filtered/,
        '01139' => qr/filtered/,
        '01140' => qr/filtered/,
        '01141' => qr/userunknown/,
        '01142' => qr/securityerror/,
        '01143' => qr/userunknown/,
        '01144' => qr/userunknown/,
        '01145' => qr/userunknown/,
        '01146' => qr/userunknown/,
        '01147' => qr/mesgtoobig/,
        '01148' => qr/userunknown/,
        '01149' => qr/userunknown/,
        '01150' => qr/userunknown/,
        '01151' => qr/mailboxfull/,
        '01152' => qr/systemerror/,
        '01153' => qr/mailererror/,
        '01154' => qr/userunknown/,
        '01155' => qr/mesgtoobig/,
        '01156' => qr/userunknown/,
        '01157' => qr/(?:hostunknown|filtered)/,
        '01158' => qr/expired/,
        '01159' => qr/mailboxfull/,
        '01160' => qr/filtered/,
        '01161' => qr/userunknown/,
        '01162' => qr/(?:userunknown|filtered)/,
        '01163' => qr/userunknown/,
        '01164' => qr/rejected/,
        '01165' => qr/exceedlimit/,
        '01166' => qr/contenterror/,
        '01167' => qr/norelaying/,
        '01168' => qr/blocked/,
        '01169' => qr/securityerror/,
        '01170' => qr/blocked/,
        '01171' => qr/expired/,
        '01172' => qr/systemerror/,
        '01173' => qr/userunknown/,
        '01174' => qr/hostunknown/,
        '01175' => qr/blocked/,
        '01176' => qr/hasmoved/,
        '01177' => qr/mailererror/,
        '01178' => qr/hostunknown/,
        '01179' => qr/userunknown/,
        '01180' => qr/userunknown/,
        '01181' => qr/mesgtoobig/,
        '01182' => qr/userunknown/,
        '01183' => qr/suspend/,
        '01184' => qr/filtered/,
        '01185' => qr/expired/,
        '01186' => qr/securityerror/,
        '01187' => qr/securityerror/,
        '01188' => qr/userunknown/,
        '01189' => qr/expired/,
        '01190' => qr/blocked/,
        '01191' => qr/suspend/,
        '01192' => qr/userunknown/,
        '01193' => qr/userunknown/,
        '01194' => qr/suspend/,
    },
    'Postfix' => {
        '01001' => qr/filtered/,
        '01002' => qr/userunknown/,
        '01003' => qr/userunknown/,
        '01004' => qr/userunknown/,
        '01005' => qr/filtered/,
        '01006' => qr/userunknown/,
        '01007' => qr/filtered/,
        '01008' => qr/filtered/,
        '01009' => qr/userunknown/,
        '01010' => qr/hostunknown/,
        '01011' => qr/systemerror/,
        '01012' => qr/userunknown/,
        '01013' => qr/userunknown/,
        '01014' => qr/userunknown/,
        '01015' => qr/userunknown/,
        '01016' => qr/toomanyconn/,
        '01017' => qr/expired/,
        '01018' => qr/systemerror/,
        '01019' => qr/userunknown/,
        '01020' => qr/userunknown/,
        '01021' => qr/expired/,
        '01022' => qr/userunknown/,
        '01023' => qr/blocked/,
        '01024' => qr/userunknown/,
        '01025' => qr/userunknown/,
        '01026' => qr/expired/,
        '01027' => qr/systemerror/,
        '01028' => qr/suspend/,
        '01029' => qr/userunknown/,
        '01030' => qr/userunknown/,
        '01031' => qr/userunknown/,
        '01032' => qr/userunknown/,
        '01033' => qr/userunknown/,
        '01034' => qr/filtered/,
        '01035' => qr/mailboxfull/,
        '01036' => qr/hostunknown/,
        '01037' => qr/filtered/,
        '01038' => qr/blocked/,
        '01039' => qr/userunknown/,
        '01040' => qr/userunknown/,
        '01041' => qr/userunknown/,
        '01042' => qr/networkerror/,
        '01043' => qr/hasmoved/,
        '01044' => qr/mesgtoobig/,
        '01045' => qr/mesgtoobig/,
        '01046' => qr/mesgtoobig/,
        '01047' => qr/mesgtoobig/,
        '01048' => qr/userunknown/,
        '01049' => qr/hostunknown/,
        '01050' => qr/userunknown/,
        '01051' => qr/blocked/,
        '01052' => qr/spamdetected/,
        '01053' => qr/systemerror/,
        '01054' => qr/userunknown/,
        '01055' => qr/filtered/,
        '01056' => qr/mailererror/,
        '01057' => qr/userunknown/,
        '01058' => qr/filtered/,
        '01059' => qr/userunknown/,
        '01060' => qr/userunknown/,
        '01061' => qr/hostunknown/,
        '01062' => qr/filtered/,
        '01063' => qr/mailererror/,
        '01064' => qr/hostunknown/,
        '01065' => qr/networkerror/,
        '01066' => qr/norelaying/,
        '01067' => qr/userunknown/,
        '01068' => qr/norelaying/,
        '01069' => qr/userunknown/,
        '01070' => qr/networkerror/,
        '01071' => qr/mailboxfull/,
        '01072' => qr/onhold/,
        '01073' => qr/mailboxfull/,
        '01074' => qr/mailboxfull/,
        '01075' => qr/mailboxfull/,
        '01076' => qr/filtered/,
        '01077' => qr/norelaying/,
        '01078' => qr/norelaying/,
        '01079' => qr/spamdetected/,
        '01080' => qr/spamdetected/,
        '01081' => qr/spamdetected/,
        '01082' => qr/spamdetected/,
        '01083' => qr/spamdetected/,
        '01084' => qr/spamdetected/,
        '01085' => qr/spamdetected/,
        '01086' => qr/spamdetected/,
        '01087' => qr/spamdetected/,
        '01088' => qr/spamdetected/,
        '01089' => qr/spamdetected/,
        '01090' => qr/spamdetected/,
        '01091' => qr/spamdetected/,
        '01092' => qr/spamdetected/,
        '01093' => qr/spamdetected/,
        '01094' => qr/spamdetected/,
        '01095' => qr/spamdetected/,
        '01096' => qr/spamdetected/,
        '01097' => qr/spamdetected/,
        '01098' => qr/spamdetected/,
        '01099' => qr/spamdetected/,
        '01100' => qr/spamdetected/,
        '01101' => qr/securityerror/,
        '01102' => qr/spamdetected/,
        '01103' => qr/spamdetected/,
        '01104' => qr/spamdetected/,
        '01105' => qr/spamdetected/,
        '01106' => qr/spamdetected/,
        '01107' => qr/spamdetected/,
        '01108' => qr/spamdetected/,
        '01109' => qr/spamdetected/,
        '01110' => qr/spamdetected/,
        '01111' => qr/spamdetected/,
        '01112' => qr/spamdetected/,
        '01113' => qr/spamdetected/,
        '01114' => qr/spamdetected/,
        '01115' => qr/blocked/,
        '01116' => qr/spamdetected/,
        '01117' => qr/spamdetected/,
        '01118' => qr/spamdetected/,
        '01119' => qr/spamdetected/,
        '01120' => qr/spamdetected/,
        '01121' => qr/spamdetected/,
        '01122' => qr/hostunknown/,
        '01123' => qr/userunknown/,
        '01124' => qr/userunknown/,
        '01125' => qr/exceedlimit/,
        '01126' => qr/systemerror/,
        '01127' => qr/userunknown/,
        '01128' => qr/userunknown/,
        '01129' => qr/filtered/,
        '01130' => qr/mailboxfull/,
        '01131' => qr/exceedlimit/,
        '01132' => qr/userunknown/,
        '01133' => qr/userunknown/,
        '01134' => qr/userunknown/,
        '01135' => qr/suspend/,
        '01136' => qr/userunknown/,
        '01137' => qr/userunknown/,
        '01138' => qr/userunknown/,
        '01139' => qr/userunknown/,
        '01140' => qr/userunknown/,
        '01141' => qr/filtered/,
        '01142' => qr/blocked/,
        '01143' => qr/userunknown/,
        '01144' => qr/suspend/,
        '01145' => qr/filtered/,
        '01146' => qr/userunknown/,
        '01147' => qr/userunknown/,
        '01148' => qr/userunknown/,
        '01149' => qr/mailboxfull/,
    },
    'qmail' => {
        '01001' => qr/filtered/,
        '01002' => qr/undefined/,
        '01003' => qr/hostunknown/,
        '01004' => qr/userunknown/,
        '01005' => qr/hostunknown/,
        '01006' => qr/userunknown/,
        '01007' => qr/hostunknown/,
        '01008' => qr/userunknown/,
        '01009' => qr/userunknown/,
        '01010' => qr/hostunknown/,
        '01011' => qr/hostunknown/,
        '01012' => qr/userunknown/,
        '01013' => qr/userunknown/,
        '01014' => qr/rejected/,
        '01015' => qr/rejected/,
        '01016' => qr/hostunknown/,
        '01017' => qr/userunknown/,
        '01018' => qr/userunknown/,
        '01019' => qr/mailboxfull/,
        '01020' => qr/filtered/,
        '01021' => qr/userunknown/,
        '01022' => qr/userunknown/,
        '01023' => qr/userunknown/,
        '01024' => qr/userunknown/,
        '01025' => qr/(?:userunknown|filtered)/,
        '01026' => qr/mesgtoobig/,
        '01027' => qr/mailboxfull/,
        '01028' => qr/userunknown/,
        '01029' => qr/filtered/,
        '01030' => qr/userunknown/,
        '01031' => qr/userunknown/,
        '01032' => qr/networkerror/,
        '01033' => qr/mailboxfull/,
        '01034' => qr/mailboxfull/,
        '01035' => qr/mailboxfull/,
        '01036' => qr/userunknown/,
        '01037' => qr/hostunknown/,
        '01038' => qr/filtered/,
        '01039' => qr/mailboxfull/,
        '01040' => qr/mailboxfull/,
        '01041' => qr/userunknown/,
        '01042' => qr/(?:userunknown|filtered)/,
        '01043' => qr/rejected/,
        '01044' => qr/blocked/,
        '01045' => qr/systemerror/,
        '01046' => qr/mailboxfull/,
        '01047' => qr/userunknown/,
        '01048' => qr/mailboxfull/,
        '01049' => qr/mailboxfull/,
        '01050' => qr/userunknown/,
        '01051' => qr/undefined/,
        '01052' => qr/suspend/,
        '01053' => qr/filtered/,
        '01054' => qr/userunknown/,
        '01055' => qr/mailboxfull/,
        '01056' => qr/userunknown/,
        '01057' => qr/userunknown/,
        '01058' => qr/userunknown/,
        '01059' => qr/filtered/,
        '01060' => qr/suspend/,
        '01061' => qr/filtered/,
        '01062' => qr/filtered/,
        '01063' => qr/userunknown/,
        '01064' => qr/userunknown/,
    },
    'Exim' => {
        '01001' => qr/securityerror/,
        '01002' => qr/expired/,
        '01003' => qr/filtered/,
        '01004' => qr/blocked/,
        '01005' => qr/userunknown/,
        '01006' => qr/filtered/,
        '01007' => qr/securityerror/,
        '01008' => qr/userunknown/,
        '01009' => qr/hostunknown/,
        '01010' => qr/blocked/,
        '01011' => qr/userunknown/,
        '01012' => qr/userunknown/,
        '01013' => qr/userunknown/,
        '01014' => qr/expired/,
        '01015' => qr/expired/,
        '01016' => qr/userunknown/,
        '01017' => qr/expired/,
        '01018' => qr/userunknown/,
        '01019' => qr/userunknown/,
        '01020' => qr/userunknown/,
        '01021' => qr/filtered/,
        '01022' => qr/userunknown/,
        '01023' => qr/userunknown/,
        '01024' => qr/userunknown/,
        '01025' => qr/userunknown/,
        '01026' => qr/userunknown/,
        '01027' => qr/expired/,
        '01028' => qr/mailboxfull/,
        '01029' => qr/userunknown/,
        '01030' => qr/mailboxfull/,
        '01031' => qr/expired/,
        '01032' => qr/userunknown/,
        '01033' => qr/userunknown/,
        '01034' => qr/userunknown/,
        '01035' => qr/rejected/,
        '01036' => qr/userunknown/,
        '01037' => qr/expired/,
        '01038' => qr/blocked/,
        '01039' => qr/mailboxfull/,
        '01040' => qr/expired/,
        '01041' => qr/expired/,
        '01042' => qr/networkerror/,
        '01043' => qr/userunknown/,
        '01044' => qr/networkerror/,
        '01045' => qr/hostunknown/,
        '01046' => qr/userunknown/,
        '01047' => qr/userunknown/,
        '01048' => qr/userunknown/,
        '01049' => qr/suspend/,
        '01050' => qr/userunknown/,
        '01051' => qr/userunknown/,
        '01052' => qr/userunknown/,
        '01053' => qr/userunknown/,
        '01054' => qr/suspend/,
        '01055' => qr/userunknown/,
        '01056' => qr/userunknown/,
        '01057' => qr/suspend/,
        '01058' => qr/userunknown/,
        '01059' => qr/onhold/,
        '01060' => qr/expired/,
        '01061' => qr/userunknown/,
        '01062' => qr/userunknown/,
        '01063' => qr/userunknown/,
        '01064' => qr/userunknown/,
        '01065' => qr/userunknown/,
        '01066' => qr/userunknown/,
        '01067' => qr/userunknown/,
        '01068' => qr/userunknown/,
        '01069' => qr/userunknown/,
        '01070' => qr/userunknown/,
        '01071' => qr/userunknown/,
        '01072' => qr/userunknown/,
        '01073' => qr/suspend/,
        '01074' => qr/userunknown/,
        '01075' => qr/userunknown/,
        '01076' => qr/userunknown/,
        '01077' => qr/suspend/,
        '01078' => qr/undefined/,
        '01079' => qr/hostunknown/,
        '01080' => qr/hostunknown/,
        '01081' => qr/hostunknown/,
        '01082' => qr/onhold/,
        '01083' => qr/onhold/,
        '01084' => qr/systemerror/,
        '01085' => qr/(?:undefined|onhold|blocked)/,
        '01086' => qr/onhold/,
        '01087' => qr/onhold/,
        '01088' => qr/(?:systemerror|onhold)/,
        '01089' => qr/mailererror/,
        '01090' => qr/onhold/,
        '01091' => qr/onhold/,
        '01092' => qr/undefined/,
        '01093' => qr/(?:undefined|onhold|systemerror)/,
        '01094' => qr/onhold/,
        '01095' => qr/onhold/,
        '01096' => qr/onhold/,
        '01097' => qr/(?:hostunknown|networkerror)/,
        '01098' => qr/expired/,
        '01099' => qr/expired/,
        '01100' => qr/mailererror/,
        '01101' => qr/mailererror/,
        '01102' => qr/mailererror/,
        '01103' => qr/undefined/,
        '01104' => qr/mailererror/,
        '01105' => qr/mailererror/,
        '01106' => qr/onhold/,
    },
    'Courier' => {
        '01001' => qr/filtered/,
        '01002' => qr/filtered/,
        '01003' => qr/blocked/,
        '01004' => qr/userunknown/,
        '01005' => qr/userunknown/,
        '01006' => qr/userunknown/,
        '01007' => qr/userunknown/,
        '01008' => qr/userunknown/,
        '01009' => qr/filtered/,
        '01010' => qr/blocked/,
        '01011' => qr/hostunknown/,
    },
    'OpenSMTPD' => {
        '01001' => qr/userunknown/,
        '01002' => qr/filtered/,
        '01003' => qr/mailboxfull/,
        '01004' => qr/filtered/,
        '01005' => qr/filtered/,
        '01006' => qr/expired/,
        '01007' => qr/userunknown/,
        '01008' => qr/(?:mailboxfull|userunknown)/,
        '01009' => qr/hostunknown/,
        '01010' => qr/networkerror/,
        '01011' => qr/userunknown/,
        '01012' => qr/(?:mailboxfull|userunknown)/,
        '01013' => qr/hostunknown/,
        '01014' => qr/expired/,
        '01015' => qr/networkerror/,
    },
    'Exchange' => {
        '01001' => qr/userunknown/,
        '01002' => qr/userunknown/,
        '01003' => qr/userunknown/,
        '01004' => qr/userunknown/,
        '01005' => qr/userunknown/,
        '01006' => qr/userunknown/,
        '01007' => qr/userunknown/,
        '01008' => qr/userunknown/,
        '01009' => qr/userunknown/,
        '01010' => qr/userunknown/,
        '01011' => qr/userunknown/,
        '01012' => qr/userunknown/,
        '01013' => qr/userunknown/,
        '01014' => qr/userunknown/,
        '01015' => qr/userunknown/,
        '01016' => qr/userunknown/,
        '01017' => qr/filtered/,
        '01018' => qr/userunknown/,
        '01019' => qr/userunknown/,
        '01020' => qr/userunknown/,
        '01021' => qr/userunknown/,
        '01022' => qr/userunknown/,
        '01023' => qr/filtered/,
        '01024' => qr/userunknown/,
        '01025' => qr/userunknown/,
        '01026' => qr/userunknown/,
        '01027' => qr/userunknown/,
        '01028' => qr/userunknown/,
        '01029' => qr/userunknown/,
        '01030' => qr/userunknown/,
        '01031' => qr/userunknown/,
        '01032' => qr/userunknown/,
    },
    'Domino' => {
        '01001' => qr/onhold/,
        '01002' => qr/userunknown/,
        '01003' => qr/userunknown/,
        '01004' => qr/onhold/,
        '01005' => qr/onhold/,
        '01006' => qr/userunknown/,
        '01007' => qr/userunknown/,
        '01008' => qr/userunknown/,
        '01009' => qr/userunknown/,
        '01010' => qr/userunknown/,
        '01011' => qr/userunknown/,
    },
    'Notes' => {
        '01001' => qr/userunknown/,
        '01002' => qr/onhold/,
        '01003' => qr/onhold/,
        '01004' => qr/userunknown/,
        '01005' => qr/onhold/,
        '01006' => qr/userunknown/,
        '01007' => qr/userunknown/,
    },
    'McAfee' => {
        '01001' => qr/userunknown/,
        '01002' => qr/userunknown/,
        '01003' => qr/userunknown/,
        '01004' => qr/userunknown/,
        '01005' => qr/userunknown/,
        '01006' => qr/userunknown/,
        '01007' => qr/userunknown/,
    },
    'MXLogic' => {
        '01001' => qr/userunknown/,
        '01002' => qr/userunknown/,
        '01003' => qr/userunknown/,
        '01004' => qr/userunknown/,
        '01005' => qr/userunknown/,
        '01006' => qr/userunknown/,
        '01007' => qr/userunknown/,
        '01008' => qr/userunknown/,
        '01009' => qr/userunknown/,
        '01010' => qr/filtered/,
    },
    'MailFoundry' => {
        '01001' => qr/filtered/,
        '01002' => qr/mailboxfull/,
        '01003' => qr/userunknown/,
        '01004' => qr/filtered/,
        '01005' => qr/mailboxfull/,
    },
    'IMailServer' => {
        '01001' => qr/hostunknown/,
        '01002' => qr/mailboxfull/,
        '01003' => qr/userunknown/,
        '01004' => qr/userunknown/,
        '01005' => qr/mailboxfull/,
        '01006' => qr/userunknown/,
        '01007' => qr/userunknown/,
        '01008' => qr/hostunknown/,
        '01009' => qr/expired/,
        '01010' => qr/expired/,
        '01011' => qr/userunknown/,
        '01012' => qr/mailboxfull/,
        '01013' => qr/userunknown/,
        '01014' => qr/hostunknown/,
        '01015' => qr/userunknown/,
        '01016' => qr/expired/,
        '01017' => qr/expired/,
        '01018' => qr/mailboxfull/,
        '01019' => qr/mailboxfull/,
        '01020' => qr/undefined/,
        '01021' => qr/mailboxfull/,
        '01022' => qr/userunknown/,
        '01023' => qr/mailboxfull/,
        '01024' => qr/undefined/,
        '01025' => qr/userunknown/,
        '01026' => qr/userunknown/,
        '01027' => qr/userunknown/,
        '01028' => qr/userunknown/,
        '01029' => qr/userunknown/,
        '01030' => qr/hostunknown/,
        '01031' => qr/hostunknown/,
        '01032' => qr/undefined/,
        '01033' => qr/userunknown/,
        '01034' => qr/userunknown/,
        '01035' => qr/spamdetected/,
        '01036' => qr/spamdetected/,
    },
    'mFILTER' => {
        '01001' => qr/filtered/,
        '01002' => qr/userunknown/,
        '01003' => qr/filtered/,
        '01004' => qr/filtered/,
        '01005' => qr/userunknown/,
        '01006' => qr/filtered/,
    },
    'Activehunter' => {
        '01001' => qr/filtered/,
        '01002' => qr/userunknown/,
        '01003' => qr/filtered/,
        '01004' => qr/filtered/,
        '01005' => qr/userunknown/,
        '01006' => qr/userunknown/,
        '01007' => qr/filtered/,
    },
    'InterScanMSS' => {
        '01001' => qr/userunknown/,
        '01002' => qr/undefined/,
        '01003' => qr/userunknown/,
        '01004' => qr/userunknown/,
        '01005' => qr/userunknown/,
    },
    'SurfControl' => {
        '01001' => qr/filtered/,
        '01002' => qr/filtered/,
        '01003' => qr/filtered/,
        '01004' => qr/systemerror/,
        '01005' => qr/systemerror/,
    },
    'V5sendmail' => {
        '01001' => qr/userunknown/,
        '01002' => qr/(?:userunknown|hostunknown)/,
        '01003' => qr/hostunknown/,
        '01004' => qr/hostunknown/,
        '01005' => qr/(?:userunknown|hostunknown)/,
        '01006' => qr/hostunknown/,
        '01007' => qr/(?:userunknown|hostunknown)/,
        '01008' => qr/hostunknown/,
        '01009' => qr/(?:hostunknown|userunknown)/,
        '01010' => qr/hostunknown/,
        '01011' => qr/hostunknown/,
        '01012' => qr/userunknown/,
        '01013' => qr/userunknown/,
        '01014' => qr/hostunknown/,
        '01015' => qr/hostunknown/,
        '01016' => qr/hostunknown/,
        '01017' => qr/userunknown/,
        '01018' => qr/(?:userunknown|hostunknown)/,
        '01019' => qr/filtered/,
        '01020' => qr/userunknown/,
        '01021' => qr/hostunknown/,
        '01022' => qr/(?:userunknown|hostunknown)/,
        '01023' => qr/hostunknown/,
        '01024' => qr/hostunknown/,
        '01025' => qr/hostunknown/,
        '01026' => qr/(?:hostunknown|userunknown)/,
        '01027' => qr/hostunknown/,
        '01028' => qr/(?:hostunknown|userunknown)/,
        '01029' => qr/(?:userunknown|hostunknown)/,
        '01030' => qr/hostunknown/,
        '01031' => qr/hostunknown/,
        '01032' => qr/userunknown/,
        '01033' => qr/(?:userunknown|hostunknown)/,
        '01034' => qr/hostunknown/,
        '01035' => qr/hostunknown/,
        '01036' => qr/userunknown/,
        '01037' => qr/hostunknown/,
        '01038' => qr/userunknown/,
        '01039' => qr/hostunknown/,
        '01040' => qr/hostunknown/,
        '01041' => qr/(?:userunknown|hostunknown)/,
        '01042' => qr/hostunknown/,
        '01043' => qr/(?:hostunknown|userunknown)/,
        '01044' => qr/hostunknown/,
        '01045' => qr/(?:hostunknown|userunknown)/,
        '01046' => qr/hostunknown/,
        '01047' => qr/hostunknown/,
        '01048' => qr/hostunknown/,
        '01049' => qr/userunknown/,
        '01050' => qr/hostunknown/,
        '01051' => qr/(?:hostunknown|userunknown)/,
        '01052' => qr/(?:blocked|hostunknown|userunknown)/,
        '01053' => qr/userunknown/,
        '01054' => qr/(?:hostunknown|userunknown)/,
        '01055' => qr/(?:hostunknown|userunknown)/,
        '01056' => qr/(?:userunknown|hostunknown)/,
        '01057' => qr/hostunknown/,
        '01058' => qr/userunknown/,
        '01059' => qr/hostunknown/,
        '01060' => qr/(?:hostunknown|userunknown)/,
        '01061' => qr/userunknown/,
        '01062' => qr/(?:hostunknown|userunknown)/,
        '01063' => qr/hostunknown/,
        '01064' => qr/(?:hostunknown|userunknown)/,
        '01065' => qr/hostunknown/,
        '01066' => qr/(?:userunknown|norelaying)/,
        '01067' => qr/hostunknown/,
        '01068' => qr/hostunknown/,
        '01069' => qr/filtered/,
        '01070' => qr/hostunknown/,
        '01071' => qr/hostunknown/,
        '01072' => qr/(?:hostunknown|userunknown)/,
        '01073' => qr/(?:hostunknown|userunknown)/,
        '01074' => qr/(?:systemerror|userunknown)/,
        '01075' => qr/hostunknown/,
        '01076' => qr/(?:hostunknown|userunknown)/,
        '01077' => qr/hostunknown/,
        '01078' => qr/hostunknown/,
        '01079' => qr/hostunknown/,
        '01080' => qr/hostunknown/,
        '01081' => qr/(?:hostunknown|userunknown)/,
        '01082' => qr/userunknown/,
        '01083' => qr/hostunknown/,
        '01084' => qr/hostunknown/,
        '01085' => qr/hostunknown/,
        '01086' => qr/hostunknown/,
        '01087' => qr/(?:userunknown|hostunknown)/,
        '01088' => qr/hostunknown/,
        '01089' => qr/hostunknown/,
        '01090' => qr/(?:hostunknown|userunknown)/,
        '01091' => qr/hostunknown/,
        '01092' => qr/hostunknown/,
        '01093' => qr/hostunknown/,
        '01094' => qr/(?:userunknown|hostunknown)/,
        '01095' => qr/(?:userunknown|hostunknown)/,
        '01096' => qr/(?:userunknown|hostunknown)/,
        '01097' => qr/(?:userunknown|hostunknown)/,
        '01098' => qr/userunknown/,
        '01099' => qr/(?:hostunknown|userunknown|blocked)/,
        '01100' => qr/userunknown/,
        '01101' => qr/hostunknown/,
        '01102' => qr/hostunknown/,
        '01103' => qr/hostunknown/,
        '01104' => qr/userunknown/,
        '01105' => qr/hostunknown/,
        '01106' => qr/userunknown/,
        '01107' => qr/userunknown/,
        '01108' => qr/hostunknown/,
        '01109' => qr/hostunknown/,
        '01110' => qr/hostunknown/,
        '01111' => qr/userunknown/,
        '01112' => qr/userunknown/,
        '01113' => qr/blocked/,
        '01114' => qr/hostunknown/,
        '01115' => qr/networkerror/,
        '01116' => qr/hostunknown/,
        '01117' => qr/blocked/,
        '01118' => qr/(?:hostunknown|userunknown)/,
        '01119' => qr/expired/,
        '01120' => qr/(?:userunknown|hostunknown)/,
        '01121' => qr/hostunknown/,
        '01122' => qr/blocked/,
        '01123' => qr/hostunknown/,
        '01124' => qr/expired/,
        '01125' => qr/expired/,
        '01126' => qr/(?:userunknown|hostunknown)/,
        '01127' => qr/expired/,
        '01128' => qr/norelaying/,
        '01129' => qr/hostunknown/,
        '01130' => qr/expired/,
        '01131' => qr/(?:userunknown|hostunknown)/,
        '01132' => qr/filtered/,
        '01133' => qr/hostunknown/,
        '01134' => qr/expired/,
        '01135' => qr/hostunknown/,
        '01136' => qr/hostunknown/,
        '01137' => qr/(?:userunknown|hostunknown)/,
        '01138' => qr/userunknown/,
        '01139' => qr/(?:userunknown|hostunknown)/,
        '01140' => qr/(?:hostunknown|userunknown)/,
        '01141' => qr/hostunknown/,
        '01142' => qr/(?:systemerror|userunknown)/,
        '01143' => qr/hostunknown/,
        '01144' => qr/(?:hostunknown|userunknown)/,
    },
    'MessagingServer' => {
        '01001' => qr/hostunknown/,
        '01002' => qr/mailboxfull/,
        '01003' => qr/filtered/,
        '01004' => qr/mailboxfull/,
        '01005' => qr/hostunknown/,
        '01006' => qr/filtered/,
        '01007' => qr/mailboxfull/,
        '01008' => qr/filtered/,
        '01009' => qr/mailboxfull/,
        '01010' => qr/mailboxfull/,
        '01011' => qr/expired/,
        '01012' => qr/filtered/,
    },
    'MailMarshalSMTP' => {
        '01001' => qr/filtered/,
    },
    'ApacheJames' => {
        '01001' => qr/filtered/,
        '01002' => qr/filtered/,
        '01003' => qr/filtered/,
        '01004' => qr/undefined/,
        '01005' => qr/undefined/,
    },
    'X1' => {
        '01001' => qr/filtered/,
        '01002' => qr/filtered/,
        '01003' => qr/filtered/,
        '01004' => qr/filtered/,
        '01005' => qr/filtered/,
    },
    'X2' => {
        '01001' => qr/expired/,
        '01002' => qr/filtered/,
        '01003' => qr/filtered/,
        '01004' => qr/(?:suspend|filtered)/,
        '01005' => qr/expired/,
        '01006' => qr/hostunknown/,
        '01007' => qr/expired/,
        '01008' => qr/expired/,
        '01009' => qr/mailboxfull/,
        '01010' => qr/suspend/,
        '01011' => qr/mailboxfull/,
        '01012' => qr/suspend/,
        '01013' => qr/suspend/,
        '01014' => qr/suspend/,
        '01015' => qr/suspend/,
        '01016' => qr/suspend/,
        '01017' => qr/(?:suspend|filtered)/,
        '01018' => qr/suspend/,
        '01019' => qr/mailboxfull/,
    },
    'X3' => {
        '01001' => qr/userunknown/,
        '01002' => qr/undefined/,
        '01003' => qr/expired/,
        '01004' => qr/userunknown/,
    },
    'X4' => {
        '01001' => qr/mailboxfull/,
        '01002' => qr/mailboxfull/,
        '01003' => qr/hostunknown/,
        '01004' => qr/mailboxfull/,
        '01005' => qr/userunknown/,
        '01006' => qr/userunknown/,
        '01007' => qr/userunknown/,
        '01008' => qr/userunknown/,
        '01009' => qr/userunknown/,
        '01010' => qr/hostunknown/,
        '01011' => qr/userunknown/,
        '01012' => qr/mailboxfull/,
        '01013' => qr/mailboxfull/,
        '01014' => qr/mailboxfull/,
        '01015' => qr/mailboxfull/,
        '01016' => qr/mailboxfull/,
        '01017' => qr/networkerror/,
        '01018' => qr/userunknown/,
        '01019' => qr/userunknown/,
        '01020' => qr/mailboxfull/,
    },
    'X5' => {
        '01001' => qr/userunknown/,
    },
};

for my $x ( keys %$R ) {
    # Check each MTA module
    my $M = 'Sisimai::MTA::'.$x;
    my $d = './var/data/'.lc($x);

    Module::Load::load( $M );
    use_ok $M;

    if( -d $d ) {

        my $h = undef;
        my $n = 0;
        ok $d, sprintf( "%s %s", $x, $d );

        opendir( $h, $d );
        while( my $e = readdir $h ) {
            # Open email in var/data directory
            next if $e eq '.';
            next if $e eq '..';

            my $emailfn = sprintf( "%s/%s", $d, $e ); next unless -f $emailfn;
            my $mailbox = Sisimai::Mail->new( $emailfn );

            $n = $e; $n =~ s/\A(\d+)[-].*[.]eml/$1/;

            while( my $r = $mailbox->read ) {
                # Parse each email in eg/ directory
                my $p = Sisimai::Message->new( 'data' => $r );
                my $v = Sisimai::Data->make( 'data' => $p );
                my $y = undef;

                for my $ee ( @$v ) {
                    isa_ok $ee, 'Sisimai::Data';

                    ok length  $ee->token, sprintf( "[%s] %s/%s->token = %s", $n, $e, $x, $ee->token );
                    ok defined $ee->lhost, sprintf( "[%s] %s/%s->lhost = %s", $n, $e, $x, $ee->lhost );
                    ok defined $ee->rhost, sprintf( "[%s] %s/%s->rhost = %s", $n, $e, $x, $ee->rhost );
                    ok defined $ee->alias, sprintf( "[%s] %s/%s->alias = %s", $n, $e, $x, $ee->alias );
                    ok defined $ee->listid,sprintf( "[%s] %s/%s->listid = %s",$n, $e, $x, $ee->listid );
                    ok defined $ee->action,sprintf( "[%s] %s/%s->action = %s",$n, $e, $x, $ee->action );

                    ok defined $ee->messageid,     sprintf( "[%s] %s/%s->messageid = %s", $n, $e, $x, $ee->messageid );
                    ok defined $ee->smtpcommand,   sprintf( "[%s] %s/%s->smtpcommand = %s", $n, $e, $x, $ee->smtpcommand );
                    ok defined $ee->diagnosticcode,sprintf( "[%s] %s/%s->diagnosticcode = %s", $n, $e, $x, $ee->diagnosticcode );
                    ok defined $ee->diagnostictype,sprintf( "[%s] %s/%s->diagnostictype = %s", $n, $e, $x, $ee->diagnostictype );
                    ok defined $ee->replycode,     sprintf( "[%s] %s/%s->replycode = %s", $n, $e, $x, $ee->replycode );
                    ok defined $ee->feedbacktype,  sprintf( "[%s] %s/%s->feedbacktype = %s", $n, $e, $x, $ee->feedbacktype );
                    ok defined $ee->subject,       sprintf( "[%s] %s/%s->subject", $n, $e, $x );
                    ok length  $ee->deliverystatus,sprintf( "[%s] %s/%s->deliverystatus = %s", $n, $e, $x, $ee->deliverystatus );
                    ok length  $ee->softbounce,    sprintf( "[%s] %s/%s->softbounce = %s", $n, $e, $x, $ee->softbounce );

                    if( $x eq 'mFILTER' ) {
                        # mFILTER => m-FILTER
                        is $ee->smtpagent, 'm-FILTER', sprintf( "[%s] %s/%s->smtpagent = %s", $n, $e, $x, $ee->smtpagent );

                    } elsif( $x eq 'X4' ) {
                        # X4 is qmail clone
                        like $ee->smtpagent, qr/\A(?:qmail|X4)\z/, sprintf( "[%s] %s/%s->smtpagent = %s", $n, $e, $x, $ee->smtpagent );

                    } else {
                        # Other MTA modules
                        is $ee->smtpagent, $x, sprintf( "[%s] %s/%s->smtpagent = %s", $n, $e, $x, $ee->smtpagent );
                    }

                    if( length $ee->action ) {
                        # Check the value of action
                        like $ee->action, qr/(?:fail.+|delayed|expired)\z/, 
                            sprintf( "[%s] %s/%s->action = %s", $n, $e, $x, $ee->action );
                    }

                    if( length $ee->deliverystatus ) {
                        # Check the value of D.S.N. format
                        like $ee->deliverystatus, qr/\A[45][.]\d/, 
                            sprintf( "[%s] %s/%s->deliverystatus = %s", $n, $e, $x, $ee->deliverystatus );

                        if( substr( $ee->deliverystatus, 0, 1 ) == 4 ) {
                            # 4.x.x
                            is $ee->softbounce, 1, sprintf( "[%s] %s/%s->softbounce = %s", $n, $e, $x, $ee->softbounce );

                        } elsif( substr( $ee->deliverystatus, 0, 1 ) == 5 ) {
                            # 5.x.x
                            is $ee->softbounce, 0, sprintf( "[%s] %s/%s->softbounce = %s", $n, $e, $x, $ee->softbounce );
                        }
                    } else {
                        # No deliverystatus
                        is $ee->softbounce, -1, sprintf( "[%s] %s/%s->softbounce = %s", $n, $e, $x, $ee->softbounce );
                    }

                    like $ee->reason,         $R->{ $x }->{ $n },   sprintf( "[%s] %s/%s->reason = %s", $n, $e, $x, $ee->reason );
                    like $ee->replycode,      qr/\A(?:[45]\d\d|)\z/,sprintf( "[%s] %s/%s->replycode = %s", $n, $e, $x, $ee->replycode );
                    like $ee->timezoneoffset, qr/\A[+-]\d+\z/,      sprintf( "[%s] %s/%s->timezoneoffset = %s", $n, $e, $x, $ee->timezoneoffset );

                    unlike $ee->deliverystatus,qr/[ ]/, sprintf( "[%s] %s/%s->deliverystatus = %s", $n, $e, $x, $ee->deliverystatus );
                    unlike $ee->smtpcommand,   qr/[ ]/, sprintf( "[%s] %s/%s->smtpcommand = %s", $n, $e, $x, $ee->smtpcommand );

                    unlike $ee->lhost,     qr/[ ]/, sprintf( "[%s] %s/%s->lhost = %s", $n, $e, $x, $ee->lhost );
                    unlike $ee->rhost,     qr/[ ]/, sprintf( "[%s] %s/%s->rhost = %s", $n, $e, $x, $ee->rhost );
                    unlike $ee->alias,     qr/[ ]/, sprintf( "[%s] %s/%s->alias = %s", $n, $e, $x, $ee->alias );
                    unlike $ee->listid,    qr/[ ]/, sprintf( "[%s] %s/%s->listid = %s", $n, $e, $x, $ee->listid );
                    unlike $ee->action,    qr/[ ]/, sprintf( "[%s] %s/%s->action = %s", $n, $e, $x, $ee->action );
                    unlike $ee->messageid, qr/[ ]/, sprintf( "[%s] %s/%s->messageid = %s", $n, $e, $x, $ee->messageid );

                    isa_ok $ee->timestamp, 'Sisimai::Time'; $y = $ee->timestamp;
                    like $y->year, qr/\A\d{4}\z/,sprintf( "[%s] %s/%s->timestamp->year = %s", $n, $e, $x, $y->year );
                    like $y->month,qr/\A\w+\z/,  sprintf( "[%s] %s/%s->timestamp->month = %s", $n, $e, $x, $y->month );
                    like $y->mday, qr/\A\d+\z/,  sprintf( "[%s] %s/%s->timestamp->mday = %s", $n, $e, $x, $y->mday );
                    like $y->day,  qr/\A\w+\z/,  sprintf( "[%s] %s/%s->timestamp->day = %s", $n, $e, $x, $y->day );

                    isa_ok $ee->addresser, 'Sisimai::Address'; $y = $ee->addresser;
                    ok length  $y->host,            sprintf( "[%s] %s/%s->addresser->host = %s", $n, $e, $x, $y->host );
                    ok length  $y->user,            sprintf( "[%s] %s/%s->addresser->user = %s", $n, $e, $x, $y->user );
                    ok length  $y->address,         sprintf( "[%s] %s/%s->addresser->address = %s", $n, $e, $x, $y->address );
                    ok defined $y->verp,            sprintf( "[%s] %s/%s->addresser->verp = %s", $n, $e, $x, $y->verp );
                    ok defined $y->alias,           sprintf( "[%s] %s/%s->addresser->alias = %s", $n, $e, $x, $y->alias );

                    is $y->host, $ee->senderdomain, sprintf( "[%s] %s/%s->senderdomain = %s", $n, $e, $x, $y->host );
                    unlike $y->host,   qr/[ ]/,     sprintf( "[%s] %s/%s->addresser->host = %s", $n, $e, $x, $y->host );
                    unlike $y->user,   qr/[ ]/,     sprintf( "[%s] %s/%s->addresser->user = %s", $n, $e, $x, $y->user );
                    unlike $y->verp,   qr/[ ]/,     sprintf( "[%s] %s/%s->addresser->verp = %s", $n, $e, $x, $y->verp );
                    unlike $y->alias,  qr/[ ]/,     sprintf( "[%s] %s/%s->addresser->alias = %s", $n, $e, $x, $y->alias );
                    unlike $y->address,qr/[ ]/,     sprintf( "[%s] %s/%s->addresser->address = %s", $n, $e, $x, $y->address );

                    isa_ok $ee->recipient, 'Sisimai::Address'; $y = $ee->recipient;
                    ok length  $y->host,            sprintf( "[%s] %s/%s->recipient->host = %s", $n, $e, $x, $y->host );
                    ok length  $y->user,            sprintf( "[%s] %s/%s->recipient->user = %s", $n, $e, $x, $y->user );
                    ok length  $y->address,         sprintf( "[%s] %s/%s->recipient->address = %s", $n, $e, $x, $y->address );
                    ok defined $y->verp,            sprintf( "[%s] %s/%s->recipient->verp = %s", $n, $e, $x, $y->verp );
                    ok defined $y->alias,           sprintf( "[%s] %s/%s->recipient->alias = %s", $n, $e, $x, $y->alias );

                    is $y->host, $ee->destination,  sprintf( "[%s] %s/%s->destination = %s", $n, $e, $x, $y->host );
                    unlike $y->host,   qr/[ ]/,     sprintf( "[%s] %s/%s->recipient->host = %s", $n, $e, $x, $y->host );
                    unlike $y->user,   qr/[ ]/,     sprintf( "[%s] %s/%s->recipient->user = %s", $n, $e, $x, $y->user );
                    unlike $y->verp,   qr/[ ]/,     sprintf( "[%s] %s/%s->recipient->verp = %s", $n, $e, $x, $y->verp );
                    unlike $y->alias,  qr/[ ]/,     sprintf( "[%s] %s/%s->recipient->alias = %s", $n, $e, $x, $y->alias );
                    unlike $y->address,qr/[ ]/,     sprintf( "[%s] %s/%s->recipient->address = %s", $n, $e, $x, $y->address );
                }
            }
        }
        close $h;
    }
}
done_testing;

