// This file was generated by gir (https://github.com/gtk-rs/gir)
// from
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use crate::{ffi, Cookie, CookieJarAcceptPolicy, SessionFeature};
use glib::{
    prelude::*,
    signal::{connect_raw, SignalHandlerId},
    translate::*,
};
use std::boxed::Box as Box_;

glib::wrapper! {
    #[doc(alias = "SoupCookieJar")]
    pub struct CookieJar(Object<ffi::SoupCookieJar, ffi::SoupCookieJarClass>) @implements SessionFeature;

    match fn {
        type_ => || ffi::soup_cookie_jar_get_type(),
    }
}

impl CookieJar {
    pub const NONE: Option<&'static CookieJar> = None;

    #[doc(alias = "soup_cookie_jar_new")]
    pub fn new() -> CookieJar {
        assert_initialized_main_thread!();
        unsafe { from_glib_full(ffi::soup_cookie_jar_new()) }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`CookieJar`] objects.
    ///
    /// This method returns an instance of [`CookieJarBuilder`](crate::builders::CookieJarBuilder) which can be used to create [`CookieJar`] objects.
    pub fn builder() -> CookieJarBuilder {
        CookieJarBuilder::new()
    }
}

impl Default for CookieJar {
    fn default() -> Self {
        Self::new()
    }
}

// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`CookieJar`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct CookieJarBuilder {
    builder: glib::object::ObjectBuilder<'static, CookieJar>,
}

impl CookieJarBuilder {
    fn new() -> Self {
        Self {
            builder: glib::object::Object::builder(),
        }
    }

    pub fn accept_policy(self, accept_policy: CookieJarAcceptPolicy) -> Self {
        Self {
            builder: self.builder.property("accept-policy", accept_policy),
        }
    }

    pub fn read_only(self, read_only: bool) -> Self {
        Self {
            builder: self.builder.property("read-only", read_only),
        }
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`CookieJar`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> CookieJar {
        self.builder.build()
    }
}

mod sealed {
    pub trait Sealed {}
    impl<T: super::IsA<super::CookieJar>> Sealed for T {}
}

pub trait CookieJarExt: IsA<CookieJar> + sealed::Sealed + 'static {
    #[doc(alias = "soup_cookie_jar_all_cookies")]
    fn all_cookies(&self) -> Vec<Cookie> {
        unsafe {
            FromGlibPtrContainer::from_glib_full(ffi::soup_cookie_jar_all_cookies(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "soup_cookie_jar_get_accept_policy")]
    #[doc(alias = "get_accept_policy")]
    #[doc(alias = "accept-policy")]
    fn accept_policy(&self) -> CookieJarAcceptPolicy {
        unsafe {
            from_glib(ffi::soup_cookie_jar_get_accept_policy(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "soup_cookie_jar_get_cookie_list")]
    #[doc(alias = "get_cookie_list")]
    fn cookie_list(&self, uri: &glib::Uri, for_http: bool) -> Vec<Cookie> {
        unsafe {
            FromGlibPtrContainer::from_glib_full(ffi::soup_cookie_jar_get_cookie_list(
                self.as_ref().to_glib_none().0,
                uri.to_glib_none().0,
                for_http.into_glib(),
            ))
        }
    }

    #[doc(alias = "soup_cookie_jar_get_cookie_list_with_same_site_info")]
    #[doc(alias = "get_cookie_list_with_same_site_info")]
    fn cookie_list_with_same_site_info(
        &self,
        uri: &glib::Uri,
        top_level: Option<&glib::Uri>,
        site_for_cookies: Option<&glib::Uri>,
        for_http: bool,
        is_safe_method: bool,
        is_top_level_navigation: bool,
    ) -> Vec<Cookie> {
        unsafe {
            FromGlibPtrContainer::from_glib_full(
                ffi::soup_cookie_jar_get_cookie_list_with_same_site_info(
                    self.as_ref().to_glib_none().0,
                    uri.to_glib_none().0,
                    top_level.to_glib_none().0,
                    site_for_cookies.to_glib_none().0,
                    for_http.into_glib(),
                    is_safe_method.into_glib(),
                    is_top_level_navigation.into_glib(),
                ),
            )
        }
    }

    #[doc(alias = "soup_cookie_jar_get_cookies")]
    #[doc(alias = "get_cookies")]
    fn cookies(&self, uri: &glib::Uri, for_http: bool) -> Option<glib::GString> {
        unsafe {
            from_glib_full(ffi::soup_cookie_jar_get_cookies(
                self.as_ref().to_glib_none().0,
                uri.to_glib_none().0,
                for_http.into_glib(),
            ))
        }
    }

    #[doc(alias = "soup_cookie_jar_is_persistent")]
    fn is_persistent(&self) -> bool {
        unsafe {
            from_glib(ffi::soup_cookie_jar_is_persistent(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "soup_cookie_jar_set_accept_policy")]
    #[doc(alias = "accept-policy")]
    fn set_accept_policy(&self, policy: CookieJarAcceptPolicy) {
        unsafe {
            ffi::soup_cookie_jar_set_accept_policy(
                self.as_ref().to_glib_none().0,
                policy.into_glib(),
            );
        }
    }

    #[doc(alias = "soup_cookie_jar_set_cookie")]
    fn set_cookie(&self, uri: &glib::Uri, cookie: &str) {
        unsafe {
            ffi::soup_cookie_jar_set_cookie(
                self.as_ref().to_glib_none().0,
                uri.to_glib_none().0,
                cookie.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "soup_cookie_jar_set_cookie_with_first_party")]
    fn set_cookie_with_first_party(&self, uri: &glib::Uri, first_party: &glib::Uri, cookie: &str) {
        unsafe {
            ffi::soup_cookie_jar_set_cookie_with_first_party(
                self.as_ref().to_glib_none().0,
                uri.to_glib_none().0,
                first_party.to_glib_none().0,
                cookie.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "read-only")]
    fn is_read_only(&self) -> bool {
        ObjectExt::property(self.as_ref(), "read-only")
    }

    #[doc(alias = "changed")]
    fn connect_changed<F: Fn(&Self, &Cookie, &Cookie) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn changed_trampoline<
            P: IsA<CookieJar>,
            F: Fn(&P, &Cookie, &Cookie) + 'static,
        >(
            this: *mut ffi::SoupCookieJar,
            old_cookie: *mut ffi::SoupCookie,
            new_cookie: *mut ffi::SoupCookie,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                CookieJar::from_glib_borrow(this).unsafe_cast_ref(),
                &from_glib_borrow(old_cookie),
                &from_glib_borrow(new_cookie),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"changed\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    changed_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "accept-policy")]
    fn connect_accept_policy_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_accept_policy_trampoline<
            P: IsA<CookieJar>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::SoupCookieJar,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(CookieJar::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::accept-policy\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_accept_policy_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl<O: IsA<CookieJar>> CookieJarExt for O {}
