# Riemann Security and Disclosure Information
This page describes Riemann security and disclosure information.

## Supported Versions

The currently supported version of Riemann for security-patching purposes is always the latest version.

## Security Announcements

Will be made on the [Riemann mailing list](https://groups.google.com/g/riemann-users?pli=1).

## Report a Vulnerability

We're extremely grateful for security researchers and users that report vulnerabilities to Riemann. All reports are thoroughly investigated by the maintainers.

To make a report, you should email the private security@riemann.io list with the details.

## When Should I Report a Vulnerability?

* You think you discovered a potential security vulnerability in Riemann.
* You are unsure how a vulnerability affects Riemann.
* You think you discovered a vulnerability in another project that Riemann depends on

For projects with their own vulnerability reporting and disclosure process, please report it directly there.

## When Should I NOT Report a Vulnerability?

* You need help tuning Riemann components for security
* You need help applying security related updates
* Your issue is not security related

## Security Vulnerability Response

Each report is acknowledged and analyzed within 5 working days.

Any vulnerability information shared stays within Riemann project and will not be disseminated to other projects unless it is necessary to get the issue fixed.

As the security issue moves from triage, to identified fix, to release planning we will keep the reporter updated.

## Public Disclosure Timing

A public disclosure date is negotiated by the Riemann maintainers nd the bug submitter. We prefer to fully disclose the bug as soon as possible once a user mitigation is available. It is reasonable to delay disclosure when the bug or the fix is not yet fully understood, the solution is not well-tested, or for vendor coordination. The timeframe for disclosure is from immediate (especially if it's already publicly known) to a few weeks. For a vulnerability with a straightforward mitigation, we expect report date to disclosure date to be on the order of 7 days. The Riemann maintainers hold the final say when setting a disclosure date.
