/*
RailControl - Model Railway Control Software

Copyright (c) 2017-2025 by Teddy / Dominik Mahrer - www.railcontrol.org

RailControl is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 3, or (at your option) any
later version.

RailControl is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with RailControl; see the file LICENCE. If not see
<http://www.gnu.org/licenses/>.
*/

#include "Server/Web/HtmlTagButton.h"
#include "Server/Web/HtmlTagInput.h"

namespace Server { namespace Web
{
	HtmlTagButton::HtmlTagButton(const std::string& value, const std::string& command, const std::string& toolTipText)
	:	HtmlTag(),
		commandID("skip_" + command)
	{
		HtmlTag buttonTag("button");
		buttonTag.AddClass("button");
		buttonTag.AddAttribute("name", commandID);
		buttonTag.AddAttribute("type", "button");
		buttonTag.AddId(commandID);
		buttonTag.AddContent(value);
		if (toolTipText.length() > 0)
		{
			HtmlTag toolTip("span");
			toolTip.AddClass("tooltip");
			toolTip.AddContent(toolTipText);
			buttonTag.AddChildTag(toolTip);
		}
		AddChildTag(buttonTag);
	}
}} // namespace Server::Web
