#  python-holidays
#  ---------------
#  A fast, efficient Python library for generating country, province and state
#  specific sets of holidays on the fly. It aims to make determining whether a
#  specific date is a holiday as fast and flexible as possible.
#
#  Author:  ryanss <ryanssdev@icloud.com> (c) 2014-2017
#           dr-prodigy <maurizio.montel@gmail.com> (c) 2017-2020
#  Website: https://github.com/dr-prodigy/python-holidays
#  License: MIT (see LICENSE file)

from .argentina import Argentina, AR
from .aruba import Aruba, AW
from .australia import Australia, AU
from .austria import Austria, AT
from .belarus import Belarus, BY
from .belgium import Belgium, BE
from .brazil import Brazil, BR
from .bulgaria import Bulgaria, BG
from .canada import Canada, CA
from .chile import Chile, CL
from .colombia import Colombia, CO
from .croatia import Croatia, HR
from .czechia import Czechia, Czech, CZ
from .denmark import Denmark, DK
from .dominican_republic import DominicanRepublic, DO
from .egypt import Egypt, EG
from .estonia import Estonia, EE
from .european_central_bank import EuropeanCentralBank, ECB, TAR
from .finland import Finland, FI
from .france import France, FRA
from .germany import Germany, DE
from .greece import Greece, GR
from .honduras import Honduras, HND
from .hongkong import HongKong, HK
from .hungary import Hungary, HU
from .iceland import Iceland, IS
from .india import India, IND
from .ireland import Ireland, IE
from .italy import Italy, IT
from .israel import Israel, ISR, IL
from .japan import Japan, JP
from .kenya import Kenya, KE
from .lithuania import Lithuania, LT
from .luxembourg import Luxembourg, LU
from .mexico import Mexico, MX
from .netherlands import Netherlands, NL
from .new_zealand import NewZealand, NZ
from .nicaragua import Nicaragua, NI
from .nigeria import Nigeria, NG
from .norway import Norway, NO
from .paraguay import Paraguay, PY
from .peru import Peru, PE
from .poland import Poland, Polish, PL
from .portugal import Portugal, PT, PortugalExt, PTE
from .russia import Russia, RU
from .serbia import Serbia, RS
from .singapore import Singapore, SG
from .slovakia import Slovakia, Slovak, SK
from .slovenia import Slovenia, SI
from .south_africa import SouthAfrica, ZA
from .spain import Spain, ES
from .sweden import Sweden, SE
from .switzerland import Switzerland, CH
from .ukraine import Ukraine, UA
from .united_kingdom import UnitedKingdom, UK, GB, England, Wales, Scotland,\
    IsleOfMan, NorthernIreland
from .united_states import UnitedStates, US
