# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.azurestackhcivm import AzureStackHCIVmClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestAzureStackHCIVmGuestAgentsOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(AzureStackHCIVmClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_guest_agents_get(self, resource_group):
        response = self.client.guest_agents.get(
            resource_uri="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_guest_agents_begin_create(self, resource_group):
        response = self.client.guest_agents.begin_create(
            resource_uri="str",
            resource={
                "id": "str",
                "name": "str",
                "properties": {
                    "credentials": {"password": "str", "username": "str"},
                    "provisioningAction": "str",
                    "provisioningState": "str",
                    "status": "str",
                },
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "type": "str",
            },
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_guest_agents_begin_delete(self, resource_group):
        response = self.client.guest_agents.begin_delete(
            resource_uri="str",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_guest_agents_list_by_virtual_machine_instance(self, resource_group):
        response = self.client.guest_agents.list_by_virtual_machine_instance(
            resource_uri="str",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...
