# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from six import with_metaclass
from azure.core import CaseInsensitiveEnumMeta


class ComplianceStateType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The compliance state of the configuration.
    """

    PENDING = "Pending"
    COMPLIANT = "Compliant"
    NONCOMPLIANT = "Noncompliant"
    INSTALLED = "Installed"
    FAILED = "Failed"

class Enum0(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):

    MICROSOFT_CONTAINER_SERVICE = "Microsoft.ContainerService"
    MICROSOFT_KUBERNETES = "Microsoft.Kubernetes"

class Enum1(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):

    MANAGED_CLUSTERS = "managedClusters"
    CONNECTED_CLUSTERS = "connectedClusters"

class InstallStateType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Status of installation of this instance of the extension.
    """

    PENDING = "Pending"
    INSTALLED = "Installed"
    FAILED = "Failed"

class LevelType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Level of the status.
    """

    ERROR = "Error"
    WARNING = "Warning"
    INFORMATION = "Information"

class MessageLevelType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Level of the message.
    """

    ERROR = "Error"
    WARNING = "Warning"
    INFORMATION = "Information"

class OperatorScopeType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Scope at which the operator will be installed.
    """

    CLUSTER = "cluster"
    NAMESPACE = "namespace"

class OperatorType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Type of the operator
    """

    FLUX = "Flux"

class ProvisioningStateType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The provisioning state of the resource provider.
    """

    ACCEPTED = "Accepted"
    DELETING = "Deleting"
    RUNNING = "Running"
    SUCCEEDED = "Succeeded"
    FAILED = "Failed"

class ResourceIdentityType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The type of identity used for the configuration. Type 'SystemAssigned' will use an implicitly
    created identity. Type 'None' will not use Managed Identity for the configuration.
    """

    SYSTEM_ASSIGNED = "SystemAssigned"
    NONE = "None"
