# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class AccessRightsDescription(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Rights that this key has."""

    SERVICE_CONFIG = "ServiceConfig"
    ENROLLMENT_READ = "EnrollmentRead"
    ENROLLMENT_WRITE = "EnrollmentWrite"
    DEVICE_CONNECT = "DeviceConnect"
    REGISTRATION_STATUS_READ = "RegistrationStatusRead"
    REGISTRATION_STATUS_WRITE = "RegistrationStatusWrite"


class AllocationPolicy(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Allocation policy to be used by this provisioning service."""

    HASHED = "Hashed"
    GEO_LATENCY = "GeoLatency"
    STATIC = "Static"


class CertificatePurpose(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """CertificatePurpose."""

    CLIENT_AUTHENTICATION = "clientAuthentication"
    SERVER_AUTHENTICATION = "serverAuthentication"


class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of identity that created the resource."""

    USER = "User"
    APPLICATION = "Application"
    MANAGED_IDENTITY = "ManagedIdentity"
    KEY = "Key"


class IotDpsSku(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Sku name."""

    S1 = "S1"


class IpFilterActionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The desired action for requests captured by this rule."""

    ACCEPT = "Accept"
    REJECT = "Reject"


class IpFilterTargetType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Target for requests captured by this rule."""

    ALL = "all"
    SERVICE_API = "serviceApi"
    DEVICE_API = "deviceApi"


class NameUnavailabilityReason(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """specifies the reason a name is unavailable."""

    INVALID = "Invalid"
    ALREADY_EXISTS = "AlreadyExists"


class PrivateLinkServiceConnectionStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The status of a private endpoint connection."""

    PENDING = "Pending"
    APPROVED = "Approved"
    REJECTED = "Rejected"
    DISCONNECTED = "Disconnected"


class PublicNetworkAccess(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Whether requests from Public Network are allowed."""

    ENABLED = "Enabled"
    DISABLED = "Disabled"


class State(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Current state of the provisioning service."""

    ACTIVATING = "Activating"
    ACTIVE = "Active"
    DELETING = "Deleting"
    DELETED = "Deleted"
    ACTIVATION_FAILED = "ActivationFailed"
    DELETION_FAILED = "DeletionFailed"
    TRANSITIONING = "Transitioning"
    SUSPENDING = "Suspending"
    SUSPENDED = "Suspended"
    RESUMING = "Resuming"
    FAILING_OVER = "FailingOver"
    FAILOVER_FAILED = "FailoverFailed"
