# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.poly_data_algorithm import PolyDataAlgorithm


class PolyDataPointSampler(PolyDataAlgorithm):
    r"""
    PolyDataPointSampler - generate points from PolyData
    
    Superclass: PolyDataAlgorithm
    
    PolyDataPointSampler generates points from input PolyData. The
    filter has two modes of operation: random point generation, or
    regular point generation. In random generation mode, points are
    generated in each polygonal entity using a random approach. In
    regular generation mode, the points are placed approximately a
    specified distance apart. Optionally, the points attributes can be
    interpolated from the generating vertices, edges, and polygons.
    
    In regular point generation mode, this filter functions as follows.
    First, it regurgitates all input points, then it samples all lines,
    plus edges associated with the input polygons and triangle strips to
    produce edge points. Finally, the interiors of polygons and triangle
    strips are subsampled to produce points. All of these operations can
    be enabled or disabled separately. Note that this algorithm only
    approximately generates points the specified distance apart.
    Generally the point density is finer than requested.
    
    In random point generation mode, this filter functions as follows.
    First, it randomly regurgitates all input points (if enabled), then
    it randomly samples all lines, plus edges associated with the input
    polygons and triangle strips to produce edge points (if enabled).
    Finally, the interiors of polygons and triangle strips are randomly
    subsampled to produce points. All of these operations can be enabled
    or disabled separately. Note that this algorithm only approximately
    generates points the specified distance apart. Generally the point
    density is finer than requested. Also note that the result is not
    truly random due to the constraints of the mesh construction.
    
    @warning
    Although this algorithm processes general polygons. it does so by
    performing a fan triangulation. This may produce poor results,
    especially for concave polygons. For better results, use a triangle
    filter to pre-tesselate polygons.
    
    @warning
    In random point generation mode, producing random edges and vertex
    points from polygons and triangle strips is less random than is
    typically desirable. You may wish to disable vertex and edge point
    generation for a result that is closer to random.
    
    @warning
    Point generation can be useful in a variety of applications. For
    example, generating seed points for glyphing or streamline
    generation. Another useful application is generating points for
    implicit modeling. In many cases implicit models can be more
    efficiently generated from points than from polygons or other
    primitives.
    
    @warning
    When sampling polygons of five sides or more, the polygon is
    triangulated. This can result in variations in point density near
    tesselation boudaries.
    
    @sa
    TriangleFilter ImplicitModeller
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkPolyDataPointSampler, obj, update, **traits)
    
    generate_edge_points = tvtk_base.true_bool_trait(desc=\
        r"""
        
        """
    )

    def _generate_edge_points_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetGenerateEdgePoints,
                        self.generate_edge_points_)

    generate_interior_points = tvtk_base.true_bool_trait(desc=\
        r"""
        
        """
    )

    def _generate_interior_points_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetGenerateInteriorPoints,
                        self.generate_interior_points_)

    generate_vertex_points = tvtk_base.true_bool_trait(desc=\
        r"""
        
        """
    )

    def _generate_vertex_points_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetGenerateVertexPoints,
                        self.generate_vertex_points_)

    generate_vertices = tvtk_base.true_bool_trait(desc=\
        r"""
        
        """
    )

    def _generate_vertices_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetGenerateVertices,
                        self.generate_vertices_)

    interpolate_point_data = tvtk_base.false_bool_trait(desc=\
        r"""
        
        """
    )

    def _interpolate_point_data_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetInterpolatePointData,
                        self.interpolate_point_data_)

    point_generation_mode = tvtk_base.RevPrefixMap({'regular': 0, 'random': 1}, default_value='regular', desc=\
        r"""
        Specify/retrieve the type of point generation: either regular
        point generation or random point generation. By default, regular
        point generation is used.
        """
    )

    def _point_generation_mode_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPointGenerationMode,
                        self.point_generation_mode_)

    distance = traits.Trait(0.01, traits.Range(0.0, 9.999999680285692e+37, enter_set=True, auto_set=False), desc=\
        r"""
        Set/Get the approximate distance between points. This is an
        absolute distance measure. The default is 0.01.
        """
    )

    def _distance_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetDistance,
                        self.distance)

    def _get_input(self):
        try:
            return wrap_vtk(self._vtk_obj.GetInput(0))
        except TypeError:
            return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input,
                            desc="The first input of this object, i.e. the result of `get_input(0)`.")
    
    def get_input(self, *args):
        """
        get_input(self) -> DataObject
        C++: DataObject *get_input()
        get_input(self, port:int) -> DataObject
        C++: DataObject *get_input(int port)"""
        ret = self._wrap_call(self._vtk_obj.GetInput, *args)
        return wrap_vtk(ret)

    _updateable_traits_ = \
    (('generate_edge_points', 'GetGenerateEdgePoints'),
    ('generate_interior_points', 'GetGenerateInteriorPoints'),
    ('generate_vertex_points', 'GetGenerateVertexPoints'),
    ('generate_vertices', 'GetGenerateVertices'),
    ('interpolate_point_data', 'GetInterpolatePointData'),
    ('abort_execute', 'GetAbortExecute'), ('release_data_flag',
    'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('point_generation_mode', 'GetPointGenerationMode'), ('distance',
    'GetDistance'), ('progress', 'GetProgress'), ('progress_text',
    'GetProgressText'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'generate_edge_points',
    'generate_interior_points', 'generate_vertex_points',
    'generate_vertices', 'global_warning_display',
    'interpolate_point_data', 'release_data_flag',
    'point_generation_mode', 'distance', 'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(PolyDataPointSampler, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit PolyDataPointSampler properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['generate_edge_points', 'generate_interior_points',
            'generate_vertex_points', 'generate_vertices',
            'interpolate_point_data'], ['point_generation_mode'], ['distance']),
            title='Edit PolyDataPointSampler properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit PolyDataPointSampler properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

